/*! For license information please see index.js.LICENSE.txt */
(()=>{var __webpack_modules__={4963:(e,t,r)=>{"use strict";r.d(t,{Z:()=>o});var n=r(8081),a=r.n(n),i=r(3645),s=r.n(i)()(a());s.push([e.id,"/* Animations */\n\n@keyframes appear {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n\n@keyframes disappear {\n  from {\n    opacity: 1;\n  }\n  to {\n    opacity: 0;\n  }\n}\n\n@keyframes fade {\n  0% {\n    opacity: 1;\n  }\n  20% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n\n@keyframes slide-up {\n  from {\n    transform: translateY(300px);\n  }\n  to {\n    transform: translateY(0);\n  }\n}\n\n/* General */\n\n@keyframes spin {\n  0% {\n    transform: rotate(0deg);\n  }\n  100% {\n    transform: rotate(360deg);\n  }\n}\n\n.spinner {\n  opacity: 0;\n  animation: spin 0.8s linear infinite, appear 0.4s 0.2s ease-in forwards;\n}\n\n/* Background */\n\n.background {\n  .layer {\n    opacity: 0;\n    transition: opacity 0.2s linear;\n\n    &.active {\n      opacity: 1;\n    }\n  }\n\n  .wallpaper {\n    animation: appear 0.3s cubic-bezier(0.33, 1, 0.68, 1) forwards;\n  }\n}\n\n/* Gallery */\n\n.active .page .buttons {\n  visibility: visible;\n}\n\n.page {\n  opacity: 0;\n}\n\n.active .page {\n  animation: appear 0.3s ease-in-out 0.1s forwards;\n}\n\n.active:first-of-type {\n  animation-duration: 0.4s;\n  animation-delay: 0s;\n}\n\n.dismissed .page {\n  animation: disappear var(--fade-out-duration) ease-in-out forwards;\n}\n\n.active .page .buttons {\n  animation: appear 0.3s linear 0.2s forwards;\n  opacity: 0;\n}\n\n.dismissed .page .buttons {\n  animation: disappear 0.3s linear forwards;\n  opacity: 1;\n  pointer-events: none;\n}\n\n/* Summary */\n\n#summary {\n  animation: appear 0.5s ease-in-out 0.3s forwards;\n  opacity: 0;\n\n  .start {\n    animation: appear 0.4s linear 1.4s forwards;\n    opacity: 0;\n  }\n\n  .preview {\n    i {\n      transform: translateY(300px);\n    }\n\n    .desktop {\n      animation: slide-up 0.5s ease-out 0.5s forwards;\n    }\n\n    .android {\n      animation: slide-up 0.5s ease-out 0.7s forwards;\n    }\n\n    .ios {\n      animation: slide-up 0.5s ease-out 0.9s forwards;\n    }\n  }\n}\n",""]);const o=s},9580:(e,t,r)=>{"use strict";r.d(t,{Z:()=>B});var n=r(8081),a=r.n(n),i=r(3645),s=r.n(i),o=r(1667),l=r.n(o),u=new URL(r(3056),r.b),c=new URL(r(1755),r.b),h=new URL(r(6856),r.b),p=new URL(r(1272),r.b),f=new URL(r(3311),r.b),d=new URL(r(6297),r.b),m=new URL(r(8420),r.b),g=new URL(r(1942),r.b),y=new URL(r(1055),r.b),v=new URL(r(3630),r.b),b=new URL(r(903),r.b),k=new URL(r(6912),r.b),x=new URL(r(1016),r.b),S=new URL(r(2063),r.b),w=new URL(r(1695),r.b),E=s()(a()),_=l()(u),P=l()(c),C=l()(h),A=l()(p),T=l()(f),M=l()(d),D=l()(m),I=l()(g),F=l()(y),O=l()(v),R=l()(b),L=l()(k),N=l()(x),V=l()(S),z=l()(w);E.push([e.id,"/* Fonts */\n\n@font-face {\n  font-display: swap;\n  font-family: 'Be Vietnam Pro';\n  font-style: normal;\n  font-weight: 400;\n  src: url("+_+") format('truetype');\n}\n\n@font-face {\n  font-display: swap;\n  font-family: 'Be Vietnam Pro';\n  font-style: normal;\n  font-weight: 700;\n  src: url("+P+") format('truetype');\n}\n\n@font-face {\n  font-display: swap;\n  font-family: 'Space Mono';\n  font-style: normal;\n  font-weight: 400;\n  src: url("+C+") format('truetype');\n}\n\n@font-face {\n  font-display: swap;\n  font-family: 'Space Mono';\n  font-style: normal;\n  font-weight: 700;\n  src: url("+A+") format('truetype');\n}\n\n@font-face {\n  font-display: swap;\n  font-family: Averta;\n  font-style: normal;\n  font-weight: 500;\n  src: url("+T+") format('opentype');\n}\n\n/* General */\n\n* {\n  overscroll-behavior: contain;\n}\n\n.key-nav {\n  position: fixed;\n  opacity: 0;\n  z-index: 0;\n\n  .start {\n    top: 0;\n    left: 0;\n  }\n\n  .end {\n    bottom: 0;\n    right: 0;\n  }\n}\n\n.hidden > * {\n  visibility: hidden;\n  pointer-events: none;\n}\n\nbody {\n  --spacing: 32px;\n  --padding: 64px;\n  --default-content-width: 800px;\n  --max-content-width: 800px;\n  --min-content-width: 800px;\n  --content-width: clamp(\n    var(--min-content-width),\n    var(--default-content-width),\n    var(--max-content-width)\n  );\n  --outro-width: 680px;\n  --accent-color: #5021ff;\n  --light-font-color: #ffffff;\n  --dark-font-color: #000000;\n  --secondary-dark-font-color: #000000a4;\n  --highlight-color: #ffffff22;\n  --shadow-color: #00000033;\n\n  background-color: transparent;\n  box-sizing: border-box;\n  font-family: 'Be Vietnam Pro', 'Space Mono', roboto, sans-serif;\n  height: 100%;\n  margin: 0;\n  padding: 0;\n  width: 100%;\n}\n\n.onboarding {\n  --panel-background-color: #ffffff88;\n  --tile-background-color: #ffffff;\n  --tile-font-color: var(--dark-font-color);\n  --icon-background-color: #000000;\n  --active-background-color: var(--accent-color);\n  --inactive-background-color: #d9d9d9;\n  --preview-background-color: var(--tile-background-color);\n  --preview-hightlight-color: #bcbcda;\n  --primary-text-color: #000000;\n  --secondary-text-color: #252836;\n\n  align-items: center;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  margin: auto;\n  min-height: 100vh;\n  width: var(--default-content-width);\n}\n\n@media (prefers-color-scheme: dark) {\n  .onboarding {\n    --panel-background-color: #3c405580;\n    --tile-background-color: #000000;\n    --tile-font-color: var(--light-font-color);\n    --icon-background-color: #ffffff;\n    --inactive-background-color: #262626;\n    --preview-background-color: #4d4d66;\n    --preview-hightlight-color: #26263c;\n    --primary-text-color: #ffffff;\n    --secondary-text-color: #fff8;\n  }\n}\n\nh1,\nh2 {\n  color: var(--primary-text-color);\n  margin: 0;\n}\n\nh1 {\n  font-size: 48px;\n  font-weight: 700;\n  line-height: 52px;\n}\n\nh2 {\n  font-size: 24px;\n  font-weight: 400;\n  line-height: 24px;\n}\n\n.spinner {\n  align-items: center;\n  display: flex;\n  justify-content: center;\n\n  svg {\n    width: 48px;\n    height: 48px;\n  }\n}\n\n.tile {\n  background-color: var(--tile-background-color);\n  border-radius: 24px;\n  border: 4px solid transparent;\n  box-sizing: border-box;\n  height: 200px;\n  width: 200px;\n\n  &.selected {\n    border-color: var(--accent-color);\n  }\n}\n\n.overlay-icon {\n  z-index: 1;\n  align-items: center;\n  border-radius: 50%;\n  box-shadow: 0px 2px 2px 0px var(--shadow-color);\n  display: flex;\n  height: 24px;\n  justify-content: center;\n  margin-left: auto;\n  position: absolute;\n  width: 24px;\n\n  & > * {\n    border-radius: inherit;\n    display: inline-block;\n    background-position: center;\n    background-repeat: no-repeat;\n  }\n\n  .check {\n    background-color: var(--accent-color);\n    background-image: url("+M+");\n    background-position: center;\n    background-repeat: no-repeat;\n    background-size: 16px;\n    height: 24px;\n    width: 24px;\n  }\n}\n\n.overlay,\n.background,\n.wallpaper {\n  position: fixed;\n  top: 0;\n  left: 0;\n  bottom: 0;\n  right: 0;\n}\n\n.onboarding.done {\n  cursor: pointer;\n}\n\n/* Background */\n\n.background {\n  pointer-events: none;\n\n  .layer {\n    background-position: center;\n    background-size: cover;\n    height: 100%;\n    position: absolute;\n    width: 100%;\n  }\n\n  .base {\n    background-color: #fff;\n  }\n\n  .light {\n    background-image: url("+D+");\n  }\n\n  .dark {\n    background-image: url("+I+");\n  }\n\n  .wallpaper {\n    background-position: center;\n    background-size: cover;\n  }\n}\n\n/* Overlay */\n\n.overlay {\n  background-image: url("+I+");\n  background-position: center;\n  background-repeat: no-repeat;\n  background-size: cover;\n  cursor: pointer;\n\n  .container {\n    align-items: center;\n    box-sizing: border-box;\n    display: flex;\n    height: 100%;\n    justify-content: center;\n    position: relative;\n    width: max(400px, 100%);\n  }\n\n  .get-started {\n    background-color: #f0f2f6;\n    border: 0;\n    border-radius: 18px;\n    cursor: pointer;\n    height: 80px;\n    opacity: 0;\n    padding: 0 14px 0 14px;\n    transition: background-color 0.2s linear;\n    text-transform: uppercase;\n\n    display: inline-flex;\n    box-sizing: content-box;\n    height: 56px;\n    padding: 14px 14px;\n    width: fit-content;\n\n    &.active {\n      background-color: #fff2;\n      pointer-events: none;\n      transition: background-color 0.6s linear;\n    }\n\n    &:hover {\n      background-color: #afb6bb;\n    }\n\n    &::before {\n      animation: appear 0.3s linear 1.6s forwards;\n      background: var(--accent-color);\n      border-radius: 7px;\n      content: '';\n      display: block;\n      flex-grow: 0;\n      flex-shrink: 0;\n      height: 56px;\n      left: 14px;\n      opacity: 0;\n      top: 14px;\n      transition: background-color 0.6s linear;\n      width: 14px;\n    }\n\n    &.active::before {\n      background-color: #fff;\n    }\n\n    .label {\n      display: inline-block;\n      flex-grow: 1;\n      font-size: 24px;\n      font-weight: 400;\n      font-weight: normal;\n      height: 56px;\n      line-height: 56px;\n      padding-left: 68px;\n      padding-right: 32px;\n      position: relative;\n      white-space: nowrap;\n      width: auto;\n\n      .logo {\n        animation: appear 0.3s linear 1.8s forwards;\n        background: url("+F+");\n        content: '';\n        height: 36px;\n        left: 16px;\n        opacity: 0;\n        position: absolute;\n        top: 10px;\n        width: 37px;\n      }\n\n      .text {\n        animation: appear 0.3s linear 2.2s forwards;\n        opacity: 0;\n      }\n    }\n  }\n}\n\n/* Contents */\n\n.contents {\n  align-items: center;\n  display: flex;\n  height: fit-content;\n  justify-content: center;\n  opacity: 0;\n  pointer-events: none;\n\n  &.ready {\n    opacity: 1;\n    pointer-events: all;\n  }\n\n  .opera-logo {\n    background-position: center;\n    background-repeat: no-repeat;\n    background-size: cover;\n    background: url("+O+");\n    height: 26px;\n    position: fixed;\n    right: 40px;\n    top: 32px;\n    width: 26px;\n  }\n}\n\n/* Popup */\n\n.popup {\n  --shadow-color: color-mix(\n    in srgb,\n    var(--primary-text-color) 24%,\n    transparent\n  );\n  background-color: var(--tile-background-color);\n  border-radius: 12px;\n  filter: drop-shadow(0 0 4px var(--shadow-color));\n  left: 50%;\n  opacity: 1;\n  padding: 16px;\n  position: absolute;\n  top: 50%;\n  transform: translate(-50%, -50%);\n  width: 200px;\n  z-index: 3;\n\n  .header {\n    align-items: center;\n    color: var(--primary-text-color);\n    display: inline-flex;\n    flex-direction: row;\n    font-size: 12px;\n    font-weight: 700;\n    justify-content: space-between;\n    text-transform: uppercase;\n    width: 100%;\n\n    .close {\n      align-items: center;\n      cursor: pointer;\n      display: flex;\n      height: 13px;\n      justify-content: center;\n      padding: 2px;\n      width: 12px;\n    }\n  }\n\n  .message {\n    border-top: 1px solid var(--shadow-color);\n    color: var(--primary-text-color);\n    margin-top: 12px;\n    padding-top: 12px;\n  }\n}\n\n.fade {\n  bottom: 0;\n  left: 0;\n  position: fixed;\n  right: 0;\n  top: 0;\n  z-index: 3;\n}\n\n/* Gallery */\n\n.gallery {\n  display: grid;\n  grid-template-columns: repeat(6, 100vw);\n  height: fit-content;\n  margin: auto;\n  padding-bottom: 48px;\n  position: relative;\n  width: var(--max-content-width);\n\n  .header {\n    display: flex;\n    flex-direction: column;\n    gap: 24px;\n  }\n\n  .screens {\n    display: contents;\n\n    .screen {\n      &.active {\n        pointer-events: all;\n      }\n\n      align-items: center;\n      box-sizing: border-box;\n      display: flex;\n      height: fit-content;\n      justify-content: center;\n      min-width: var(--min-content-width);\n      pointer-events: none;\n      position: relative;\n      width: var(--content-width);\n    }\n  }\n\n  .page {\n    box-sizing: border-box;\n    display: flex;\n    flex-direction: column;\n    height: 100%;\n    justify-content: center;\n    margin: auto;\n    min-width: var(--min-content-width);\n    opacity: 0;\n    pointer-events: none;\n    position: relative;\n    width: fit-content;\n  }\n\n  .active .page {\n    pointer-events: all;\n  }\n\n  .content {\n    display: flex;\n    flex-direction: column;\n    height: fit-content;\n    position: relative;\n    width: var(--content-width);\n\n    .title,\n    .subtitle {\n      display: block;\n      position: relative;\n      width: 100%;\n    }\n\n    .wide.title {\n      font-size: 44px;\n      font-size: 48px;\n    }\n\n    .widest.title {\n      font-size: 40px;\n      line-height: 44px;\n    }\n  }\n\n  .feature {\n    background-color: var(--panel-background-color);\n    border-radius: 24px;\n    box-sizing: border-box;\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n    margin: var(--spacing) auto;\n    width: var(--content-width);\n    padding: var(--padding);\n    position: relative;\n    width: 100%;\n  }\n\n  .navigation {\n    animation: appear 0.3s linear 0.2s forwards;\n    bottom: 0;\n    height: 24px;\n    margin-bottom: var(--spacing);\n    opacity: 0;\n    position: absolute;\n    width: var(--max-content-width);\n\n    .controls,\n    .pagination {\n      align-items: center;\n      display: flex;\n      height: 100%;\n      position: absolute;\n      width: 100%;\n    }\n\n    .controls {\n      --default-link-color: var(--dark-font-color);\n      --hovered-link-color: var(--accent-color);\n\n      @media (prefers-color-scheme: dark) {\n        --default-link-color: #ffffff80;\n        --hovered-link-color: var(--light-font-color);\n      }\n\n      color: var(--default-link-color);\n      font-size: 20px;\n      font-weight: 700;\n      justify-content: space-between;\n\n      .left,\n      .right {\n        display: flex;\n        z-index: 1;\n      }\n\n      .right {\n        position: relative;\n        left: 4px;\n      }\n\n      .link {\n        cursor: pointer;\n        padding: 2px 8px;\n        user-select: none;\n\n        &:hover,\n        &:focus {\n          color: var(--hovered-link-color);\n        }\n      }\n\n      .right > .link {\n        &:not(:last-child) {\n          border-right: 2px solid #a4a4a4;\n        }\n      }\n    }\n\n    .pagination {\n      justify-content: center;\n      pointer-events: none;\n\n      .dots {\n        --inactive-dot-color: #00000040;\n        --active-dot-color: var(--accent-color);\n\n        @media (prefers-color-scheme: dark) {\n          --inactive-dot-color: #ffffff40;\n          --active-dot-color: var(--light-font-color);\n        }\n\n        align-items: center;\n        display: flex;\n        gap: 8px;\n        justify-content: center;\n        pointer-events: all;\n        width: 100%;\n      }\n\n      .dot {\n        background-color: var(--inactive-dot-color);\n        border-radius: 50%;\n        cursor: pointer;\n        height: 12px;\n        transition: all 0.2s ease-out;\n        width: 12px;\n\n        &.active {\n          background-color: var(--active-dot-color);\n          height: 16px;\n          width: 16px;\n        }\n      }\n    }\n  }\n\n  .screen:nth-child(2) {\n    left: -100vw;\n  }\n\n  .screen:nth-child(3) {\n    left: -200vw;\n  }\n\n  .screen:nth-child(4) {\n    left: -300vw;\n  }\n\n  .screen:nth-child(5) {\n    left: -400vw;\n  }\n\n  .screen:nth-child(6) {\n    left: -500vw;\n  }\n\n  .screen:nth-child(7) {\n    left: -600vw;\n  }\n}\n\n/* UserSurvey */\n\n#user_survey {\n  display: flex;\n  flex-direction: column;\n  gap: 24px;\n\n  .option-container {\n    cursor: pointer;\n    position: relative;\n    width: fit-content;\n  }\n\n  .option-header {\n    border-radius: 4px;\n    color: white;\n    font-size: 12px;\n    font-weight: 700;\n    left: 16px;\n    line-height: 16px;\n    padding: 2px 4px 2px 4px;\n    position: relative;\n    text-transform: uppercase;\n    top: 8px;\n    width: fit-content;\n  }\n\n  .option-header[data-user-type='newbie'] {\n    background-color: rgba(239, 141, 75, 1);\n  }\n\n  .option-header[data-user-type='active'] {\n    background-color: rgba(123, 198, 215, 1);\n  }\n\n  .option-header[data-user-type='returning'] {\n    background-color: rgba(170, 120, 223, 1);\n  }\n\n  .option-desc {\n    background-color: white;\n    border-radius: 16px;\n    border: 2px solid var(--panel-background-color);\n    color: black;\n    font-size: 20px;\n    font-weight: 400;\n    line-height: 26px;\n    padding: 16px;\n    width: fit-content;\n  }\n\n  .option-desc:hover {\n    box-shadow: 0px 0px 37.8px 0px rgba(170, 120, 223, 0.2);\n  }\n}\n\n/* Theme */\n\n#theme {\n  .tile {\n    background-color: transparent;\n\n    &::before,\n    &::after {\n      background-position: center;\n      background-repeat: no-repeat;\n      background-size: 192px 192px;\n      border-radius: 20px;\n      height: 192px;\n      position: absolute;\n      width: 192px;\n    }\n  }\n\n  .theme {\n    align-items: center;\n    cursor: pointer;\n    display: flex;\n    justify-content: center;\n    position: relative;\n  }\n\n  .theme::before,\n  .system.theme::after {\n    content: '';\n    opacity: 0.75;\n    transition: opacity 0.2s linear;\n    z-index: 1;\n  }\n\n  .selected.theme::before,\n  .selected.theme::after,\n  .theme:hover::before,\n  .theme:hover::after {\n    opacity: 1;\n  }\n\n  .light.theme::before {\n    background-image: url("+R+");\n  }\n\n  .dark.theme::before {\n    background-image: url("+L+");\n  }\n\n  .system.theme::before {\n    background-image: url("+R+");\n    clip-path: polygon(0 0, 100% 0, 0 100%);\n  }\n\n  .system.theme::after {\n    background-image: url("+L+");\n    clip-path: polygon(100% 0, 100% 100%, 0 100%);\n    z-index: 2;\n  }\n\n  .theme .name {\n    background: white;\n    border-radius: 8px;\n    color: black;\n    font-size: 20px;\n    font-weight: 700;\n    padding: 8px 16px;\n    z-index: 3;\n  }\n}\n\n/* Wallpapers */\n\n#wallpaper {\n  .thumbnail {\n    cursor: pointer;\n    position: relative;\n    user-select: none;\n\n    &.tile {\n      background-color: transparent;\n    }\n\n    .image {\n      background-position: center;\n      background-size: cover;\n      background-repeat: no-repeat;\n      border-radius: 20px;\n      width: 100%;\n      height: 100%;\n      transition: opacity 0.2s linear;\n    }\n\n    &:hover .image {\n      opacity: 1;\n    }\n\n    &.dimmed .image {\n      opacity: 0.6;\n    }\n\n    .image,\n    .spinner {\n      bottom: 0;\n      left: 0;\n      position: absolute;\n      right: 0;\n      top: 0;\n    }\n\n    &.selected .image {\n      opacity: 1;\n    }\n  }\n}\n\n/* Ad blocker */\n\n#adblocker {\n  .label {\n    color: var(--icon-background-color);\n    font-family: Averta;\n    font-size: 15px;\n    font-weight: 400;\n    padding: 0 24px;\n    position: relative;\n    text-align: center;\n    top: -10px;\n    user-select: none;\n  }\n\n  .preview {\n    height: 200px;\n    width: 332px;\n  }\n\n  .adblock {\n    --switch-background-color: black;\n    align-items: center;\n    display: flex;\n    flex-direction: column;\n    gap: 16px;\n    justify-content: center;\n  }\n\n  input[type='checkbox'] {\n    appearance: none;\n    background-color: var(--inactive-background-color);\n    border-radius: 6px;\n    cursor: pointer;\n    height: 32px;\n    position: relative;\n    width: 60px;\n  }\n\n  input[type='checkbox']::after {\n    background-color: white;\n    border-radius: 3px;\n    content: '';\n    display: block;\n    height: 20px;\n    left: 6px;\n    position: absolute;\n    top: 6px;\n    transition: all 0.2s cubic-bezier(0.175, 0.885, 0.32, 1.275);\n    width: 20px;\n  }\n\n  input[type='checkbox']:checked {\n    background-color: var(--active-background-color);\n  }\n\n  input[type='checkbox']:checked::after {\n    left: 34px;\n  }\n}\n\n/* Messengers */\n\n#messengers {\n  .feature {\n    gap: 16px;\n  }\n\n  .tile {\n    cursor: pointer;\n    display: flex;\n    justify-content: center;\n    width: 100px;\n\n    .messenger {\n      filter: url(#light-grey-filter);\n      height: 100%;\n      margin-top: 60px;\n      position: relative;\n      align-items: center;\n      display: flex;\n      flex-direction: column;\n      height: 62px;\n      width: 60px;\n\n      .icon {\n        align-items: center;\n        display: flex;\n        height: 60px;\n        justify-content: center;\n        width: 60px;\n      }\n\n      .name {\n        align-items: center;\n        color: var(--tile-font-color);\n        display: flex;\n        font-family: Averta;\n        font-size: 14px;\n        font-weight: 700;\n        line-height: 24px;\n        margin: 0px;\n        opacity: 0.5;\n        padding-top: 8px;\n      }\n\n      .overlay-icon {\n        right: 0;\n        top: -8px;\n      }\n\n      .icon i {\n        background-position: center;\n        background-repeat: no-repeat;\n        background-size: 48px;\n        display: block;\n        height: 48px;\n        width: 48px;\n      }\n    }\n\n    &:hover .messenger,\n    &.active .messenger {\n      filter: none;\n\n      .name {\n        opacity: 1;\n      }\n    }\n  }\n}\n\n/* Import */\n\n#import {\n  .browsers {\n    align-items: center;\n    display: flex;\n    gap: 16px;\n  }\n\n  .tile {\n    align-items: center;\n    cursor: pointer;\n    display: flex;\n    flex-direction: column;\n    padding-top: 48px;\n    position: relative;\n    user-select: none;\n    width: 120px;\n\n    .browser {\n      align-items: center;\n      display: flex;\n      flex-direction: column;\n      position: relative;\n      width: fit-content;\n\n      &.available {\n        cursor: pointer;\n      }\n\n      .name {\n        color: var(--tile-font-color);\n        filter: none;\n        font-size: 14px;\n        font-style: normal;\n        font-weight: 600;\n        line-height: 18px;\n        opacity: 0.6;\n        padding-top: 4px;\n        text-align: center;\n        width: 100px;\n        white-space: nowrap;\n      }\n\n      .icon {\n        position: relative;\n        height: 64px;\n        width: 64px;\n\n        i {\n          display: inline-block;\n          background-position: center;\n          background-size: contain;\n          filter: url(#light-grey-filter);\n          height: 100%;\n          width: 100%;\n        }\n\n        .spinner {\n          left: 0;\n          position: absolute;\n          right: 0;\n          top: 8px;\n        }\n\n        .overlay-icon {\n          right: 2px;\n          top: -4px;\n          z-index: 2;\n\n          & svg {\n            height: 24px;\n            width: 24px;\n          }\n        }\n      }\n    }\n\n    &.imported {\n      opacity: 1;\n      pointer-events: none;\n\n      .browser .icon i {\n        filter: none;\n      }\n    }\n\n    &:hover .browser .icon i {\n      filter: none;\n    }\n\n    &.disabled {\n      background-color: transparent;\n      opacity: 0.16;\n      pointer-events: none;\n    }\n  }\n}\n\n/* Summary */\n\n#summary {\n  height: 100vh;\n  left: 0;\n  min-height: 100vh;\n  position: fixed;\n  right: 0;\n  top: 0;\n\n  .content {\n    display: flex;\n    flex-direction: column;\n    height: 100vh;\n    justify-content: space-between;\n    margin: 0 auto;\n    width: var(--outro-width);\n  }\n\n  .header {\n    display: flex;\n    flex-direction: column;\n    gap: var(--spacing);\n    padding: calc(2 * var(--spacing)) 0;\n    pointer-events: none;\n    width: var(--max-content-width);\n\n    .title {\n      line-height: 56px;\n    }\n\n    @media screen and (height > 600px) {\n      margin-top: calc(30vh - 180px);\n      gap: calc(5vh - 30px + var(--spacing));\n    }\n  }\n\n  .start {\n    background-color: var(--accent-color);\n    border: 0;\n    border-radius: 16px;\n    color: var(--light-font-color);\n    font-size: 12px;\n    font-size: 18px;\n    font-weight: 700;\n    letter-spacing: 1px;\n    padding: 16px 32px;\n    width: fit-content;\n  }\n\n  .page {\n    padding: 0;\n  }\n\n  .preview {\n    height: 270px;\n    position: relative;\n    width: 720px;\n\n    i {\n      background-size: cover;\n      display: inline-block;\n      position: absolute;\n    }\n\n    .desktop {\n      background-image: url("+N+");\n      height: 470.5px;\n      left: 0;\n      position: absolute;\n      top: 0;\n      width: 720px;\n    }\n\n    .android {\n      background-image: url("+V+");\n      height: 339px;\n      right: -92px;\n      top: 74px;\n      width: 159.5px;\n    }\n\n    .ios {\n      background-image: url("+z+");\n      height: 326px;\n      right: 44px;\n      top: 90px;\n      width: 153.5px;\n    }\n  }\n}\n",""]);const B=E},3645:e=>{"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var r="",n=void 0!==t[5];return t[4]&&(r+="@supports (".concat(t[4],") {")),t[2]&&(r+="@media ".concat(t[2]," {")),n&&(r+="@layer".concat(t[5].length>0?" ".concat(t[5]):""," {")),r+=e(t),n&&(r+="}"),t[2]&&(r+="}"),t[4]&&(r+="}"),r})).join("")},t.i=function(e,r,n,a,i){"string"==typeof e&&(e=[[null,e,void 0]]);var s={};if(n)for(var o=0;o<this.length;o++){var l=this[o][0];null!=l&&(s[l]=!0)}for(var u=0;u<e.length;u++){var c=[].concat(e[u]);n&&s[c[0]]||(void 0!==i&&(void 0===c[5]||(c[1]="@layer".concat(c[5].length>0?" ".concat(c[5]):""," {").concat(c[1],"}")),c[5]=i),r&&(c[2]?(c[1]="@media ".concat(c[2]," {").concat(c[1],"}"),c[2]=r):c[2]=r),a&&(c[4]?(c[1]="@supports (".concat(c[4],") {").concat(c[1],"}"),c[4]=a):c[4]="".concat(a)),t.push(c))}},t}},1667:e=>{"use strict";e.exports=function(e,t){return t||(t={}),e?(e=String(e.__esModule?e.default:e),/^['"].*['"]$/.test(e)&&(e=e.slice(1,-1)),t.hash&&(e+=t.hash),/["'() \t\n]|(%20)/.test(e)||t.needQuotes?'"'.concat(e.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):e):e}},8081:e=>{"use strict";e.exports=function(e){return e[1]}},1248:function(module,exports,__webpack_require__){var factory;"undefined"!=typeof navigator&&(factory=function(){"use strict";var svgNS="http://www.w3.org/2000/svg",locationHref="",_useWebWorker=!1,initialDefaultFrame=-999999,setWebWorker=function(e){_useWebWorker=!!e},getWebWorker=function(){return _useWebWorker},setLocationHref=function(e){locationHref=e},getLocationHref=function(){return locationHref};function createTag(e){return document.createElement(e)}function extendPrototype(e,t){var r,n,a=e.length;for(r=0;r<a;r+=1)for(var i in n=e[r].prototype)Object.prototype.hasOwnProperty.call(n,i)&&(t.prototype[i]=n[i])}function getDescriptor(e,t){return Object.getOwnPropertyDescriptor(e,t)}function createProxyFunction(e){function t(){}return t.prototype=e,t}var audioControllerFactory=function(){function e(e){this.audios=[],this.audioFactory=e,this._volume=1,this._isMuted=!1}return e.prototype={addAudio:function(e){this.audios.push(e)},pause:function(){var e,t=this.audios.length;for(e=0;e<t;e+=1)this.audios[e].pause()},resume:function(){var e,t=this.audios.length;for(e=0;e<t;e+=1)this.audios[e].resume()},setRate:function(e){var t,r=this.audios.length;for(t=0;t<r;t+=1)this.audios[t].setRate(e)},createAudio:function(e){return this.audioFactory?this.audioFactory(e):window.Howl?new window.Howl({src:[e]}):{isPlaying:!1,play:function(){this.isPlaying=!0},seek:function(){this.isPlaying=!1},playing:function(){},rate:function(){},setVolume:function(){}}},setAudioFactory:function(e){this.audioFactory=e},setVolume:function(e){this._volume=e,this._updateVolume()},mute:function(){this._isMuted=!0,this._updateVolume()},unmute:function(){this._isMuted=!1,this._updateVolume()},getVolume:function(){return this._volume},_updateVolume:function(){var e,t=this.audios.length;for(e=0;e<t;e+=1)this.audios[e].volume(this._volume*(this._isMuted?0:1))}},function(){return new e}}(),createTypedArray=function(){function e(e,t){var r,n=0,a=[];switch(e){case"int16":case"uint8c":r=1;break;default:r=1.1}for(n=0;n<t;n+=1)a.push(r);return a}return"function"==typeof Uint8ClampedArray&&"function"==typeof Float32Array?function(t,r){return"float32"===t?new Float32Array(r):"int16"===t?new Int16Array(r):"uint8c"===t?new Uint8ClampedArray(r):e(t,r)}:e}();function createSizedArray(e){return Array.apply(null,{length:e})}function _typeof$6(e){return _typeof$6="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$6(e)}var subframeEnabled=!0,expressionsPlugin=null,expressionsInterfaces=null,idPrefix$1="",isSafari=/^((?!chrome|android).)*safari/i.test(navigator.userAgent),_shouldRoundValues=!1,bmPow=Math.pow,bmSqrt=Math.sqrt,bmFloor=Math.floor,bmMax=Math.max,bmMin=Math.min,BMMath={};function ProjectInterface$1(){return{}}!function(){var e,t=["abs","acos","acosh","asin","asinh","atan","atanh","atan2","ceil","cbrt","expm1","clz32","cos","cosh","exp","floor","fround","hypot","imul","log","log1p","log2","log10","max","min","pow","random","round","sign","sin","sinh","sqrt","tan","tanh","trunc","E","LN10","LN2","LOG10E","LOG2E","PI","SQRT1_2","SQRT2"],r=t.length;for(e=0;e<r;e+=1)BMMath[t[e]]=Math[t[e]]}(),BMMath.random=Math.random,BMMath.abs=function(e){if("object"===_typeof$6(e)&&e.length){var t,r=createSizedArray(e.length),n=e.length;for(t=0;t<n;t+=1)r[t]=Math.abs(e[t]);return r}return Math.abs(e)};var defaultCurveSegments=150,degToRads=Math.PI/180,roundCorner=.5519;function roundValues(e){_shouldRoundValues=!!e}function bmRnd(e){return _shouldRoundValues?Math.round(e):e}function styleDiv(e){e.style.position="absolute",e.style.top=0,e.style.left=0,e.style.display="block",e.style.transformOrigin="0 0",e.style.webkitTransformOrigin="0 0",e.style.backfaceVisibility="visible",e.style.webkitBackfaceVisibility="visible",e.style.transformStyle="preserve-3d",e.style.webkitTransformStyle="preserve-3d",e.style.mozTransformStyle="preserve-3d"}function BMEnterFrameEvent(e,t,r,n){this.type=e,this.currentTime=t,this.totalTime=r,this.direction=n<0?-1:1}function BMCompleteEvent(e,t){this.type=e,this.direction=t<0?-1:1}function BMCompleteLoopEvent(e,t,r,n){this.type=e,this.currentLoop=r,this.totalLoops=t,this.direction=n<0?-1:1}function BMSegmentStartEvent(e,t,r){this.type=e,this.firstFrame=t,this.totalFrames=r}function BMDestroyEvent(e,t){this.type=e,this.target=t}function BMRenderFrameErrorEvent(e,t){this.type="renderFrameError",this.nativeError=e,this.currentTime=t}function BMConfigErrorEvent(e){this.type="configError",this.nativeError=e}function BMAnimationConfigErrorEvent(e,t){this.type=e,this.nativeError=t}var createElementID=(_count=0,function(){return idPrefix$1+"__lottie_element_"+(_count+=1)}),_count;function HSVtoRGB(e,t,r){var n,a,i,s,o,l,u,c;switch(l=r*(1-t),u=r*(1-(o=6*e-(s=Math.floor(6*e)))*t),c=r*(1-(1-o)*t),s%6){case 0:n=r,a=c,i=l;break;case 1:n=u,a=r,i=l;break;case 2:n=l,a=r,i=c;break;case 3:n=l,a=u,i=r;break;case 4:n=c,a=l,i=r;break;case 5:n=r,a=l,i=u}return[n,a,i]}function RGBtoHSV(e,t,r){var n,a=Math.max(e,t,r),i=Math.min(e,t,r),s=a-i,o=0===a?0:s/a,l=a/255;switch(a){case i:n=0;break;case e:n=t-r+s*(t<r?6:0),n/=6*s;break;case t:n=r-e+2*s,n/=6*s;break;case r:n=e-t+4*s,n/=6*s}return[n,o,l]}function addSaturationToRGB(e,t){var r=RGBtoHSV(255*e[0],255*e[1],255*e[2]);return r[1]+=t,r[1]>1?r[1]=1:r[1]<=0&&(r[1]=0),HSVtoRGB(r[0],r[1],r[2])}function addBrightnessToRGB(e,t){var r=RGBtoHSV(255*e[0],255*e[1],255*e[2]);return r[2]+=t,r[2]>1?r[2]=1:r[2]<0&&(r[2]=0),HSVtoRGB(r[0],r[1],r[2])}function addHueToRGB(e,t){var r=RGBtoHSV(255*e[0],255*e[1],255*e[2]);return r[0]+=t/360,r[0]>1?r[0]-=1:r[0]<0&&(r[0]+=1),HSVtoRGB(r[0],r[1],r[2])}var rgbToHex=function(){var e,t,r=[];for(e=0;e<256;e+=1)t=e.toString(16),r[e]=1===t.length?"0"+t:t;return function(e,t,n){return e<0&&(e=0),t<0&&(t=0),n<0&&(n=0),"#"+r[e]+r[t]+r[n]}}(),setSubframeEnabled=function(e){subframeEnabled=!!e},getSubframeEnabled=function(){return subframeEnabled},setExpressionsPlugin=function(e){expressionsPlugin=e},getExpressionsPlugin=function(){return expressionsPlugin},setExpressionInterfaces=function(e){expressionsInterfaces=e},getExpressionInterfaces=function(){return expressionsInterfaces},setDefaultCurveSegments=function(e){defaultCurveSegments=e},getDefaultCurveSegments=function(){return defaultCurveSegments},setIdPrefix=function(e){idPrefix$1=e},getIdPrefix=function(){return idPrefix$1};function createNS(e){return document.createElementNS(svgNS,e)}function _typeof$5(e){return _typeof$5="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$5(e)}var dataManager=function(){var e,t,r=1,n=[],a={onmessage:function(){},postMessage:function(t){e({data:t})}},i={postMessage:function(e){a.onmessage({data:e})}};function s(){t||(t=function(t){if(window.Worker&&window.Blob&&getWebWorker()){var r=new Blob(["var _workerSelf = self; self.onmessage = ",t.toString()],{type:"text/javascript"}),n=URL.createObjectURL(r);return new Worker(n)}return e=t,a}((function(e){if(i.dataManager||(i.dataManager=function(){function e(a,i){var s,o,l,u,c,p,f=a.length;for(o=0;o<f;o+=1)if("ks"in(s=a[o])&&!s.completed){if(s.completed=!0,s.hasMask){var d=s.masksProperties;for(u=d.length,l=0;l<u;l+=1)if(d[l].pt.k.i)n(d[l].pt.k);else for(p=d[l].pt.k.length,c=0;c<p;c+=1)d[l].pt.k[c].s&&n(d[l].pt.k[c].s[0]),d[l].pt.k[c].e&&n(d[l].pt.k[c].e[0])}0===s.ty?(s.layers=t(s.refId,i),e(s.layers,i)):4===s.ty?r(s.shapes):5===s.ty&&h(s)}}function t(e,t){var r=function(e,t){for(var r=0,n=t.length;r<n;){if(t[r].id===e)return t[r];r+=1}return null}(e,t);return r?r.layers.__used?JSON.parse(JSON.stringify(r.layers)):(r.layers.__used=!0,r.layers):null}function r(e){var t,a,i;for(t=e.length-1;t>=0;t-=1)if("sh"===e[t].ty)if(e[t].ks.k.i)n(e[t].ks.k);else for(i=e[t].ks.k.length,a=0;a<i;a+=1)e[t].ks.k[a].s&&n(e[t].ks.k[a].s[0]),e[t].ks.k[a].e&&n(e[t].ks.k[a].e[0]);else"gr"===e[t].ty&&r(e[t].it)}function n(e){var t,r=e.i.length;for(t=0;t<r;t+=1)e.i[t][0]+=e.v[t][0],e.i[t][1]+=e.v[t][1],e.o[t][0]+=e.v[t][0],e.o[t][1]+=e.v[t][1]}function a(e,t){var r=t?t.split("."):[100,100,100];return e[0]>r[0]||!(r[0]>e[0])&&(e[1]>r[1]||!(r[1]>e[1])&&(e[2]>r[2]||!(r[2]>e[2])&&null))}var i,s=function(){var e=[4,4,14];function t(e){var t,r,n,a=e.length;for(t=0;t<a;t+=1)5===e[t].ty&&(n=void 0,n=(r=e[t]).t.d,r.t.d={k:[{s:n,t:0}]})}return function(r){if(a(e,r.v)&&(t(r.layers),r.assets)){var n,i=r.assets.length;for(n=0;n<i;n+=1)r.assets[n].layers&&t(r.assets[n].layers)}}}(),o=(i=[4,7,99],function(e){if(e.chars&&!a(i,e.v)){var t,n=e.chars.length;for(t=0;t<n;t+=1){var s=e.chars[t];s.data&&s.data.shapes&&(r(s.data.shapes),s.data.ip=0,s.data.op=99999,s.data.st=0,s.data.sr=1,s.data.ks={p:{k:[0,0],a:0},s:{k:[100,100],a:0},a:{k:[0,0],a:0},r:{k:0,a:0},o:{k:100,a:0}},e.chars[t].t||(s.data.shapes.push({ty:"no"}),s.data.shapes[0].it.push({p:{k:[0,0],a:0},s:{k:[100,100],a:0},a:{k:[0,0],a:0},r:{k:0,a:0},o:{k:100,a:0},sk:{k:0,a:0},sa:{k:0,a:0},ty:"tr"})))}}}),l=function(){var e=[5,7,15];function t(e){var t,r,n=e.length;for(t=0;t<n;t+=1)5===e[t].ty&&(r=void 0,"number"==typeof(r=e[t].t.p).a&&(r.a={a:0,k:r.a}),"number"==typeof r.p&&(r.p={a:0,k:r.p}),"number"==typeof r.r&&(r.r={a:0,k:r.r}))}return function(r){if(a(e,r.v)&&(t(r.layers),r.assets)){var n,i=r.assets.length;for(n=0;n<i;n+=1)r.assets[n].layers&&t(r.assets[n].layers)}}}(),u=function(){var e=[4,1,9];function t(e){var r,n,a,i=e.length;for(r=0;r<i;r+=1)if("gr"===e[r].ty)t(e[r].it);else if("fl"===e[r].ty||"st"===e[r].ty)if(e[r].c.k&&e[r].c.k[0].i)for(a=e[r].c.k.length,n=0;n<a;n+=1)e[r].c.k[n].s&&(e[r].c.k[n].s[0]/=255,e[r].c.k[n].s[1]/=255,e[r].c.k[n].s[2]/=255,e[r].c.k[n].s[3]/=255),e[r].c.k[n].e&&(e[r].c.k[n].e[0]/=255,e[r].c.k[n].e[1]/=255,e[r].c.k[n].e[2]/=255,e[r].c.k[n].e[3]/=255);else e[r].c.k[0]/=255,e[r].c.k[1]/=255,e[r].c.k[2]/=255,e[r].c.k[3]/=255}function r(e){var r,n=e.length;for(r=0;r<n;r+=1)4===e[r].ty&&t(e[r].shapes)}return function(t){if(a(e,t.v)&&(r(t.layers),t.assets)){var n,i=t.assets.length;for(n=0;n<i;n+=1)t.assets[n].layers&&r(t.assets[n].layers)}}}(),c=function(){var e=[4,4,18];function t(e){var r,n,a;for(r=e.length-1;r>=0;r-=1)if("sh"===e[r].ty)if(e[r].ks.k.i)e[r].ks.k.c=e[r].closed;else for(a=e[r].ks.k.length,n=0;n<a;n+=1)e[r].ks.k[n].s&&(e[r].ks.k[n].s[0].c=e[r].closed),e[r].ks.k[n].e&&(e[r].ks.k[n].e[0].c=e[r].closed);else"gr"===e[r].ty&&t(e[r].it)}function r(e){var r,n,a,i,s,o,l=e.length;for(n=0;n<l;n+=1){if((r=e[n]).hasMask){var u=r.masksProperties;for(i=u.length,a=0;a<i;a+=1)if(u[a].pt.k.i)u[a].pt.k.c=u[a].cl;else for(o=u[a].pt.k.length,s=0;s<o;s+=1)u[a].pt.k[s].s&&(u[a].pt.k[s].s[0].c=u[a].cl),u[a].pt.k[s].e&&(u[a].pt.k[s].e[0].c=u[a].cl)}4===r.ty&&t(r.shapes)}}return function(t){if(a(e,t.v)&&(r(t.layers),t.assets)){var n,i=t.assets.length;for(n=0;n<i;n+=1)t.assets[n].layers&&r(t.assets[n].layers)}}}();function h(e){0===e.t.a.length&&e.t.p}var p={completeData:function(r){r.__complete||(u(r),s(r),o(r),l(r),c(r),e(r.layers,r.assets),function(r,n){if(r){var a=0,i=r.length;for(a=0;a<i;a+=1)1===r[a].t&&(r[a].data.layers=t(r[a].data.refId,n),e(r[a].data.layers,n))}}(r.chars,r.assets),r.__complete=!0)}};return p.checkColors=u,p.checkChars=o,p.checkPathProperties=l,p.checkShapes=c,p.completeLayers=e,p}()),i.assetLoader||(i.assetLoader=function(){function e(e){var t=e.getResponseHeader("content-type");return t&&"json"===e.responseType&&-1!==t.indexOf("json")||e.response&&"object"===_typeof$5(e.response)?e.response:e.response&&"string"==typeof e.response?JSON.parse(e.response):e.responseText?JSON.parse(e.responseText):null}return{load:function(t,r,n,a){var i,s=new XMLHttpRequest;try{s.responseType="json"}catch(e){}s.onreadystatechange=function(){if(4===s.readyState)if(200===s.status)i=e(s),n(i);else try{i=e(s),n(i)}catch(e){a&&a(e)}};try{s.open(["G","E","T"].join(""),t,!0)}catch(e){s.open(["G","E","T"].join(""),r+"/"+t,!0)}s.send()}}}()),"loadAnimation"===e.data.type)i.assetLoader.load(e.data.path,e.data.fullPath,(function(t){i.dataManager.completeData(t),i.postMessage({id:e.data.id,payload:t,status:"success"})}),(function(){i.postMessage({id:e.data.id,status:"error"})}));else if("complete"===e.data.type){var t=e.data.animation;i.dataManager.completeData(t),i.postMessage({id:e.data.id,payload:t,status:"success"})}else"loadData"===e.data.type&&i.assetLoader.load(e.data.path,e.data.fullPath,(function(t){i.postMessage({id:e.data.id,payload:t,status:"success"})}),(function(){i.postMessage({id:e.data.id,status:"error"})}))})),t.onmessage=function(e){var t=e.data,r=t.id,a=n[r];n[r]=null,"success"===t.status?a.onComplete(t.payload):a.onError&&a.onError()})}function o(e,t){var a="processId_"+(r+=1);return n[a]={onComplete:e,onError:t},a}return{loadAnimation:function(e,r,n){s();var a=o(r,n);t.postMessage({type:"loadAnimation",path:e,fullPath:window.location.origin+window.location.pathname,id:a})},loadData:function(e,r,n){s();var a=o(r,n);t.postMessage({type:"loadData",path:e,fullPath:window.location.origin+window.location.pathname,id:a})},completeAnimation:function(e,r,n){s();var a=o(r,n);t.postMessage({type:"complete",animation:e,id:a})}}}(),ImagePreloader=function(){var e=function(){var e=createTag("canvas");e.width=1,e.height=1;var t=e.getContext("2d");return t.fillStyle="rgba(0,0,0,0)",t.fillRect(0,0,1,1),e}();function t(){this.loadedAssets+=1,this.loadedAssets===this.totalImages&&this.loadedFootagesCount===this.totalFootages&&this.imagesLoadedCb&&this.imagesLoadedCb(null)}function r(){this.loadedFootagesCount+=1,this.loadedAssets===this.totalImages&&this.loadedFootagesCount===this.totalFootages&&this.imagesLoadedCb&&this.imagesLoadedCb(null)}function n(e,t,r){var n="";if(e.e)n=e.p;else if(t){var a=e.p;-1!==a.indexOf("images/")&&(a=a.split("/")[1]),n=t+a}else n=r,n+=e.u?e.u:"",n+=e.p;return n}function a(e){var t=0,r=setInterval(function(){(e.getBBox().width||t>500)&&(this._imageLoaded(),clearInterval(r)),t+=1}.bind(this),50)}function i(e){var t={assetData:e},r=n(e,this.assetsPath,this.path);return dataManager.loadData(r,function(e){t.img=e,this._footageLoaded()}.bind(this),function(){t.img={},this._footageLoaded()}.bind(this)),t}function s(){this._imageLoaded=t.bind(this),this._footageLoaded=r.bind(this),this.testImageLoaded=a.bind(this),this.createFootageData=i.bind(this),this.assetsPath="",this.path="",this.totalImages=0,this.totalFootages=0,this.loadedAssets=0,this.loadedFootagesCount=0,this.imagesLoadedCb=null,this.images=[]}return s.prototype={loadAssets:function(e,t){var r;this.imagesLoadedCb=t;var n=e.length;for(r=0;r<n;r+=1)e[r].layers||(e[r].t&&"seq"!==e[r].t?3===e[r].t&&(this.totalFootages+=1,this.images.push(this.createFootageData(e[r]))):(this.totalImages+=1,this.images.push(this._createImageData(e[r]))))},setAssetsPath:function(e){this.assetsPath=e||""},setPath:function(e){this.path=e||""},loadedImages:function(){return this.totalImages===this.loadedAssets},loadedFootages:function(){return this.totalFootages===this.loadedFootagesCount},destroy:function(){this.imagesLoadedCb=null,this.images.length=0},getAsset:function(e){for(var t=0,r=this.images.length;t<r;){if(this.images[t].assetData===e)return this.images[t].img;t+=1}return null},createImgData:function(t){var r=n(t,this.assetsPath,this.path),a=createTag("img");a.crossOrigin="anonymous",a.addEventListener("load",this._imageLoaded,!1),a.addEventListener("error",function(){i.img=e,this._imageLoaded()}.bind(this),!1),a.src=r;var i={img:a,assetData:t};return i},createImageData:function(t){var r=n(t,this.assetsPath,this.path),a=createNS("image");isSafari?this.testImageLoaded(a):a.addEventListener("load",this._imageLoaded,!1),a.addEventListener("error",function(){i.img=e,this._imageLoaded()}.bind(this),!1),a.setAttributeNS("http://www.w3.org/1999/xlink","href",r),this._elementHelper.append?this._elementHelper.append(a):this._elementHelper.appendChild(a);var i={img:a,assetData:t};return i},imageLoaded:t,footageLoaded:r,setCacheType:function(e,t){"svg"===e?(this._elementHelper=t,this._createImageData=this.createImageData.bind(this)):this._createImageData=this.createImgData.bind(this)}},s}();function BaseEvent(){}BaseEvent.prototype={triggerEvent:function(e,t){if(this._cbs[e])for(var r=this._cbs[e],n=0;n<r.length;n+=1)r[n](t)},addEventListener:function(e,t){return this._cbs[e]||(this._cbs[e]=[]),this._cbs[e].push(t),function(){this.removeEventListener(e,t)}.bind(this)},removeEventListener:function(e,t){if(t){if(this._cbs[e]){for(var r=0,n=this._cbs[e].length;r<n;)this._cbs[e][r]===t&&(this._cbs[e].splice(r,1),r-=1,n-=1),r+=1;this._cbs[e].length||(this._cbs[e]=null)}}else this._cbs[e]=null}};var markerParser=function(){function e(e){for(var t,r=e.split("\r\n"),n={},a=0,i=0;i<r.length;i+=1)2===(t=r[i].split(":")).length&&(n[t[0]]=t[1].trim(),a+=1);if(0===a)throw new Error;return n}return function(t){for(var r=[],n=0;n<t.length;n+=1){var a=t[n],i={time:a.tm,duration:a.dr};try{i.payload=JSON.parse(t[n].cm)}catch(r){try{i.payload=e(t[n].cm)}catch(e){i.payload={name:t[n].cm}}}r.push(i)}return r}}(),ProjectInterface=function(){function e(e){this.compositions.push(e)}return function(){function t(e){for(var t=0,r=this.compositions.length;t<r;){if(this.compositions[t].data&&this.compositions[t].data.nm===e)return this.compositions[t].prepareFrame&&this.compositions[t].data.xt&&this.compositions[t].prepareFrame(this.currentFrame),this.compositions[t].compInterface;t+=1}return null}return t.compositions=[],t.currentFrame=0,t.registerComposition=e,t}}(),renderers={},registerRenderer=function(e,t){renderers[e]=t};function getRenderer(e){return renderers[e]}function getRegisteredRenderer(){if(renderers.canvas)return"canvas";for(var e in renderers)if(renderers[e])return e;return""}function _typeof$4(e){return _typeof$4="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$4(e)}var AnimationItem=function(){this._cbs=[],this.name="",this.path="",this.isLoaded=!1,this.currentFrame=0,this.currentRawFrame=0,this.firstFrame=0,this.totalFrames=0,this.frameRate=0,this.frameMult=0,this.playSpeed=1,this.playDirection=1,this.playCount=0,this.animationData={},this.assets=[],this.isPaused=!0,this.autoplay=!1,this.loop=!0,this.renderer=null,this.animationID=createElementID(),this.assetsPath="",this.timeCompleted=0,this.segmentPos=0,this.isSubframeEnabled=getSubframeEnabled(),this.segments=[],this._idle=!0,this._completedLoop=!1,this.projectInterface=ProjectInterface(),this.imagePreloader=new ImagePreloader,this.audioController=audioControllerFactory(),this.markers=[],this.configAnimation=this.configAnimation.bind(this),this.onSetupError=this.onSetupError.bind(this),this.onSegmentComplete=this.onSegmentComplete.bind(this),this.drawnFrameEvent=new BMEnterFrameEvent("drawnFrame",0,0,0),this.expressionsPlugin=getExpressionsPlugin()};extendPrototype([BaseEvent],AnimationItem),AnimationItem.prototype.setParams=function(e){(e.wrapper||e.container)&&(this.wrapper=e.wrapper||e.container);var t="svg";e.animType?t=e.animType:e.renderer&&(t=e.renderer);var r=getRenderer(t);this.renderer=new r(this,e.rendererSettings),this.imagePreloader.setCacheType(t,this.renderer.globalData.defs),this.renderer.setProjectInterface(this.projectInterface),this.animType=t,""===e.loop||null===e.loop||void 0===e.loop||!0===e.loop?this.loop=!0:!1===e.loop?this.loop=!1:this.loop=parseInt(e.loop,10),this.autoplay=!("autoplay"in e)||e.autoplay,this.name=e.name?e.name:"",this.autoloadSegments=!Object.prototype.hasOwnProperty.call(e,"autoloadSegments")||e.autoloadSegments,this.assetsPath=e.assetsPath,this.initialSegment=e.initialSegment,e.audioFactory&&this.audioController.setAudioFactory(e.audioFactory),e.animationData?this.setupAnimation(e.animationData):e.path&&(-1!==e.path.lastIndexOf("\\")?this.path=e.path.substr(0,e.path.lastIndexOf("\\")+1):this.path=e.path.substr(0,e.path.lastIndexOf("/")+1),this.fileName=e.path.substr(e.path.lastIndexOf("/")+1),this.fileName=this.fileName.substr(0,this.fileName.lastIndexOf(".json")),dataManager.loadAnimation(e.path,this.configAnimation,this.onSetupError))},AnimationItem.prototype.onSetupError=function(){this.trigger("data_failed")},AnimationItem.prototype.setupAnimation=function(e){dataManager.completeAnimation(e,this.configAnimation)},AnimationItem.prototype.setData=function(e,t){t&&"object"!==_typeof$4(t)&&(t=JSON.parse(t));var r={wrapper:e,animationData:t},n=e.attributes;r.path=n.getNamedItem("data-animation-path")?n.getNamedItem("data-animation-path").value:n.getNamedItem("data-bm-path")?n.getNamedItem("data-bm-path").value:n.getNamedItem("bm-path")?n.getNamedItem("bm-path").value:"",r.animType=n.getNamedItem("data-anim-type")?n.getNamedItem("data-anim-type").value:n.getNamedItem("data-bm-type")?n.getNamedItem("data-bm-type").value:n.getNamedItem("bm-type")?n.getNamedItem("bm-type").value:n.getNamedItem("data-bm-renderer")?n.getNamedItem("data-bm-renderer").value:n.getNamedItem("bm-renderer")?n.getNamedItem("bm-renderer").value:getRegisteredRenderer()||"canvas";var a=n.getNamedItem("data-anim-loop")?n.getNamedItem("data-anim-loop").value:n.getNamedItem("data-bm-loop")?n.getNamedItem("data-bm-loop").value:n.getNamedItem("bm-loop")?n.getNamedItem("bm-loop").value:"";"false"===a?r.loop=!1:"true"===a?r.loop=!0:""!==a&&(r.loop=parseInt(a,10));var i=n.getNamedItem("data-anim-autoplay")?n.getNamedItem("data-anim-autoplay").value:n.getNamedItem("data-bm-autoplay")?n.getNamedItem("data-bm-autoplay").value:!n.getNamedItem("bm-autoplay")||n.getNamedItem("bm-autoplay").value;r.autoplay="false"!==i,r.name=n.getNamedItem("data-name")?n.getNamedItem("data-name").value:n.getNamedItem("data-bm-name")?n.getNamedItem("data-bm-name").value:n.getNamedItem("bm-name")?n.getNamedItem("bm-name").value:"","false"===(n.getNamedItem("data-anim-prerender")?n.getNamedItem("data-anim-prerender").value:n.getNamedItem("data-bm-prerender")?n.getNamedItem("data-bm-prerender").value:n.getNamedItem("bm-prerender")?n.getNamedItem("bm-prerender").value:"")&&(r.prerender=!1),r.path?this.setParams(r):this.trigger("destroy")},AnimationItem.prototype.includeLayers=function(e){e.op>this.animationData.op&&(this.animationData.op=e.op,this.totalFrames=Math.floor(e.op-this.animationData.ip));var t,r,n=this.animationData.layers,a=n.length,i=e.layers,s=i.length;for(r=0;r<s;r+=1)for(t=0;t<a;){if(n[t].id===i[r].id){n[t]=i[r];break}t+=1}if((e.chars||e.fonts)&&(this.renderer.globalData.fontManager.addChars(e.chars),this.renderer.globalData.fontManager.addFonts(e.fonts,this.renderer.globalData.defs)),e.assets)for(a=e.assets.length,t=0;t<a;t+=1)this.animationData.assets.push(e.assets[t]);this.animationData.__complete=!1,dataManager.completeAnimation(this.animationData,this.onSegmentComplete)},AnimationItem.prototype.onSegmentComplete=function(e){this.animationData=e;var t=getExpressionsPlugin();t&&t.initExpressions(this),this.loadNextSegment()},AnimationItem.prototype.loadNextSegment=function(){var e=this.animationData.segments;if(!e||0===e.length||!this.autoloadSegments)return this.trigger("data_ready"),void(this.timeCompleted=this.totalFrames);var t=e.shift();this.timeCompleted=t.time*this.frameRate;var r=this.path+this.fileName+"_"+this.segmentPos+".json";this.segmentPos+=1,dataManager.loadData(r,this.includeLayers.bind(this),function(){this.trigger("data_failed")}.bind(this))},AnimationItem.prototype.loadSegments=function(){this.animationData.segments||(this.timeCompleted=this.totalFrames),this.loadNextSegment()},AnimationItem.prototype.imagesLoaded=function(){this.trigger("loaded_images"),this.checkLoaded()},AnimationItem.prototype.preloadImages=function(){this.imagePreloader.setAssetsPath(this.assetsPath),this.imagePreloader.setPath(this.path),this.imagePreloader.loadAssets(this.animationData.assets,this.imagesLoaded.bind(this))},AnimationItem.prototype.configAnimation=function(e){if(this.renderer)try{this.animationData=e,this.initialSegment?(this.totalFrames=Math.floor(this.initialSegment[1]-this.initialSegment[0]),this.firstFrame=Math.round(this.initialSegment[0])):(this.totalFrames=Math.floor(this.animationData.op-this.animationData.ip),this.firstFrame=Math.round(this.animationData.ip)),this.renderer.configAnimation(e),e.assets||(e.assets=[]),this.assets=this.animationData.assets,this.frameRate=this.animationData.fr,this.frameMult=this.animationData.fr/1e3,this.renderer.searchExtraCompositions(e.assets),this.markers=markerParser(e.markers||[]),this.trigger("config_ready"),this.preloadImages(),this.loadSegments(),this.updaFrameModifier(),this.waitForFontsLoaded(),this.isPaused&&this.audioController.pause()}catch(e){this.triggerConfigError(e)}},AnimationItem.prototype.waitForFontsLoaded=function(){this.renderer&&(this.renderer.globalData.fontManager.isLoaded?this.checkLoaded():setTimeout(this.waitForFontsLoaded.bind(this),20))},AnimationItem.prototype.checkLoaded=function(){if(!this.isLoaded&&this.renderer.globalData.fontManager.isLoaded&&(this.imagePreloader.loadedImages()||"canvas"!==this.renderer.rendererType)&&this.imagePreloader.loadedFootages()){this.isLoaded=!0;var e=getExpressionsPlugin();e&&e.initExpressions(this),this.renderer.initItems(),setTimeout(function(){this.trigger("DOMLoaded")}.bind(this),0),this.gotoFrame(),this.autoplay&&this.play()}},AnimationItem.prototype.resize=function(e,t){var r="number"==typeof e?e:void 0,n="number"==typeof t?t:void 0;this.renderer.updateContainerSize(r,n)},AnimationItem.prototype.setSubframe=function(e){this.isSubframeEnabled=!!e},AnimationItem.prototype.gotoFrame=function(){this.currentFrame=this.isSubframeEnabled?this.currentRawFrame:~~this.currentRawFrame,this.timeCompleted!==this.totalFrames&&this.currentFrame>this.timeCompleted&&(this.currentFrame=this.timeCompleted),this.trigger("enterFrame"),this.renderFrame(),this.trigger("drawnFrame")},AnimationItem.prototype.renderFrame=function(){if(!1!==this.isLoaded&&this.renderer)try{this.expressionsPlugin&&this.expressionsPlugin.resetFrame(),this.renderer.renderFrame(this.currentFrame+this.firstFrame)}catch(e){this.triggerRenderFrameError(e)}},AnimationItem.prototype.play=function(e){e&&this.name!==e||!0===this.isPaused&&(this.isPaused=!1,this.trigger("_play"),this.audioController.resume(),this._idle&&(this._idle=!1,this.trigger("_active")))},AnimationItem.prototype.pause=function(e){e&&this.name!==e||!1===this.isPaused&&(this.isPaused=!0,this.trigger("_pause"),this._idle=!0,this.trigger("_idle"),this.audioController.pause())},AnimationItem.prototype.togglePause=function(e){e&&this.name!==e||(!0===this.isPaused?this.play():this.pause())},AnimationItem.prototype.stop=function(e){e&&this.name!==e||(this.pause(),this.playCount=0,this._completedLoop=!1,this.setCurrentRawFrameValue(0))},AnimationItem.prototype.getMarkerData=function(e){for(var t,r=0;r<this.markers.length;r+=1)if((t=this.markers[r]).payload&&t.payload.name===e)return t;return null},AnimationItem.prototype.goToAndStop=function(e,t,r){if(!r||this.name===r){var n=Number(e);if(isNaN(n)){var a=this.getMarkerData(e);a&&this.goToAndStop(a.time,!0)}else t?this.setCurrentRawFrameValue(e):this.setCurrentRawFrameValue(e*this.frameModifier);this.pause()}},AnimationItem.prototype.goToAndPlay=function(e,t,r){if(!r||this.name===r){var n=Number(e);if(isNaN(n)){var a=this.getMarkerData(e);a&&(a.duration?this.playSegments([a.time,a.time+a.duration],!0):this.goToAndStop(a.time,!0))}else this.goToAndStop(n,t,r);this.play()}},AnimationItem.prototype.advanceTime=function(e){if(!0!==this.isPaused&&!1!==this.isLoaded){var t=this.currentRawFrame+e*this.frameModifier,r=!1;t>=this.totalFrames-1&&this.frameModifier>0?this.loop&&this.playCount!==this.loop?t>=this.totalFrames?(this.playCount+=1,this.checkSegments(t%this.totalFrames)||(this.setCurrentRawFrameValue(t%this.totalFrames),this._completedLoop=!0,this.trigger("loopComplete"))):this.setCurrentRawFrameValue(t):this.checkSegments(t>this.totalFrames?t%this.totalFrames:0)||(r=!0,t=this.totalFrames-1):t<0?this.checkSegments(t%this.totalFrames)||(!this.loop||this.playCount--<=0&&!0!==this.loop?(r=!0,t=0):(this.setCurrentRawFrameValue(this.totalFrames+t%this.totalFrames),this._completedLoop?this.trigger("loopComplete"):this._completedLoop=!0)):this.setCurrentRawFrameValue(t),r&&(this.setCurrentRawFrameValue(t),this.pause(),this.trigger("complete"))}},AnimationItem.prototype.adjustSegment=function(e,t){this.playCount=0,e[1]<e[0]?(this.frameModifier>0&&(this.playSpeed<0?this.setSpeed(-this.playSpeed):this.setDirection(-1)),this.totalFrames=e[0]-e[1],this.timeCompleted=this.totalFrames,this.firstFrame=e[1],this.setCurrentRawFrameValue(this.totalFrames-.001-t)):e[1]>e[0]&&(this.frameModifier<0&&(this.playSpeed<0?this.setSpeed(-this.playSpeed):this.setDirection(1)),this.totalFrames=e[1]-e[0],this.timeCompleted=this.totalFrames,this.firstFrame=e[0],this.setCurrentRawFrameValue(.001+t)),this.trigger("segmentStart")},AnimationItem.prototype.setSegment=function(e,t){var r=-1;this.isPaused&&(this.currentRawFrame+this.firstFrame<e?r=e:this.currentRawFrame+this.firstFrame>t&&(r=t-e)),this.firstFrame=e,this.totalFrames=t-e,this.timeCompleted=this.totalFrames,-1!==r&&this.goToAndStop(r,!0)},AnimationItem.prototype.playSegments=function(e,t){if(t&&(this.segments.length=0),"object"===_typeof$4(e[0])){var r,n=e.length;for(r=0;r<n;r+=1)this.segments.push(e[r])}else this.segments.push(e);this.segments.length&&t&&this.adjustSegment(this.segments.shift(),0),this.isPaused&&this.play()},AnimationItem.prototype.resetSegments=function(e){this.segments.length=0,this.segments.push([this.animationData.ip,this.animationData.op]),e&&this.checkSegments(0)},AnimationItem.prototype.checkSegments=function(e){return!!this.segments.length&&(this.adjustSegment(this.segments.shift(),e),!0)},AnimationItem.prototype.destroy=function(e){e&&this.name!==e||!this.renderer||(this.renderer.destroy(),this.imagePreloader.destroy(),this.trigger("destroy"),this._cbs=null,this.onEnterFrame=null,this.onLoopComplete=null,this.onComplete=null,this.onSegmentStart=null,this.onDestroy=null,this.renderer=null,this.expressionsPlugin=null,this.imagePreloader=null,this.projectInterface=null)},AnimationItem.prototype.setCurrentRawFrameValue=function(e){this.currentRawFrame=e,this.gotoFrame()},AnimationItem.prototype.setSpeed=function(e){this.playSpeed=e,this.updaFrameModifier()},AnimationItem.prototype.setDirection=function(e){this.playDirection=e<0?-1:1,this.updaFrameModifier()},AnimationItem.prototype.setLoop=function(e){this.loop=e},AnimationItem.prototype.setVolume=function(e,t){t&&this.name!==t||this.audioController.setVolume(e)},AnimationItem.prototype.getVolume=function(){return this.audioController.getVolume()},AnimationItem.prototype.mute=function(e){e&&this.name!==e||this.audioController.mute()},AnimationItem.prototype.unmute=function(e){e&&this.name!==e||this.audioController.unmute()},AnimationItem.prototype.updaFrameModifier=function(){this.frameModifier=this.frameMult*this.playSpeed*this.playDirection,this.audioController.setRate(this.playSpeed*this.playDirection)},AnimationItem.prototype.getPath=function(){return this.path},AnimationItem.prototype.getAssetsPath=function(e){var t="";if(e.e)t=e.p;else if(this.assetsPath){var r=e.p;-1!==r.indexOf("images/")&&(r=r.split("/")[1]),t=this.assetsPath+r}else t=this.path,t+=e.u?e.u:"",t+=e.p;return t},AnimationItem.prototype.getAssetData=function(e){for(var t=0,r=this.assets.length;t<r;){if(e===this.assets[t].id)return this.assets[t];t+=1}return null},AnimationItem.prototype.hide=function(){this.renderer.hide()},AnimationItem.prototype.show=function(){this.renderer.show()},AnimationItem.prototype.getDuration=function(e){return e?this.totalFrames:this.totalFrames/this.frameRate},AnimationItem.prototype.updateDocumentData=function(e,t,r){try{this.renderer.getElementByPath(e).updateDocumentData(t,r)}catch(e){}},AnimationItem.prototype.trigger=function(e){if(this._cbs&&this._cbs[e])switch(e){case"enterFrame":this.triggerEvent(e,new BMEnterFrameEvent(e,this.currentFrame,this.totalFrames,this.frameModifier));break;case"drawnFrame":this.drawnFrameEvent.currentTime=this.currentFrame,this.drawnFrameEvent.totalTime=this.totalFrames,this.drawnFrameEvent.direction=this.frameModifier,this.triggerEvent(e,this.drawnFrameEvent);break;case"loopComplete":this.triggerEvent(e,new BMCompleteLoopEvent(e,this.loop,this.playCount,this.frameMult));break;case"complete":this.triggerEvent(e,new BMCompleteEvent(e,this.frameMult));break;case"segmentStart":this.triggerEvent(e,new BMSegmentStartEvent(e,this.firstFrame,this.totalFrames));break;case"destroy":this.triggerEvent(e,new BMDestroyEvent(e,this));break;default:this.triggerEvent(e)}"enterFrame"===e&&this.onEnterFrame&&this.onEnterFrame.call(this,new BMEnterFrameEvent(e,this.currentFrame,this.totalFrames,this.frameMult)),"loopComplete"===e&&this.onLoopComplete&&this.onLoopComplete.call(this,new BMCompleteLoopEvent(e,this.loop,this.playCount,this.frameMult)),"complete"===e&&this.onComplete&&this.onComplete.call(this,new BMCompleteEvent(e,this.frameMult)),"segmentStart"===e&&this.onSegmentStart&&this.onSegmentStart.call(this,new BMSegmentStartEvent(e,this.firstFrame,this.totalFrames)),"destroy"===e&&this.onDestroy&&this.onDestroy.call(this,new BMDestroyEvent(e,this))},AnimationItem.prototype.triggerRenderFrameError=function(e){var t=new BMRenderFrameErrorEvent(e,this.currentFrame);this.triggerEvent("error",t),this.onError&&this.onError.call(this,t)},AnimationItem.prototype.triggerConfigError=function(e){var t=new BMConfigErrorEvent(e,this.currentFrame);this.triggerEvent("error",t),this.onError&&this.onError.call(this,t)};var animationManager=function(){var e={},t=[],r=0,n=0,a=0,i=!0,s=!1;function o(e){for(var r=0,a=e.target;r<n;)t[r].animation===a&&(t.splice(r,1),r-=1,n-=1,a.isPaused||c()),r+=1}function l(e,r){if(!e)return null;for(var a=0;a<n;){if(t[a].elem===e&&null!==t[a].elem)return t[a].animation;a+=1}var i=new AnimationItem;return h(i,e),i.setData(e,r),i}function u(){a+=1,d()}function c(){a-=1}function h(e,r){e.addEventListener("destroy",o),e.addEventListener("_active",u),e.addEventListener("_idle",c),t.push({elem:r,animation:e}),n+=1}function p(e){var o,l=e-r;for(o=0;o<n;o+=1)t[o].animation.advanceTime(l);r=e,a&&!s?window.requestAnimationFrame(p):i=!0}function f(e){r=e,window.requestAnimationFrame(p)}function d(){!s&&a&&i&&(window.requestAnimationFrame(f),i=!1)}return e.registerAnimation=l,e.loadAnimation=function(e){var t=new AnimationItem;return h(t,null),t.setParams(e),t},e.setSpeed=function(e,r){var a;for(a=0;a<n;a+=1)t[a].animation.setSpeed(e,r)},e.setDirection=function(e,r){var a;for(a=0;a<n;a+=1)t[a].animation.setDirection(e,r)},e.play=function(e){var r;for(r=0;r<n;r+=1)t[r].animation.play(e)},e.pause=function(e){var r;for(r=0;r<n;r+=1)t[r].animation.pause(e)},e.stop=function(e){var r;for(r=0;r<n;r+=1)t[r].animation.stop(e)},e.togglePause=function(e){var r;for(r=0;r<n;r+=1)t[r].animation.togglePause(e)},e.searchAnimations=function(e,t,r){var n,a=[].concat([].slice.call(document.getElementsByClassName("lottie")),[].slice.call(document.getElementsByClassName("bodymovin"))),i=a.length;for(n=0;n<i;n+=1)r&&a[n].setAttribute("data-bm-type",r),l(a[n],e);if(t&&0===i){r||(r="svg");var s=document.getElementsByTagName("body")[0];s.innerText="";var o=createTag("div");o.style.width="100%",o.style.height="100%",o.setAttribute("data-bm-type",r),s.appendChild(o),l(o,e)}},e.resize=function(){var e;for(e=0;e<n;e+=1)t[e].animation.resize()},e.goToAndStop=function(e,r,a){var i;for(i=0;i<n;i+=1)t[i].animation.goToAndStop(e,r,a)},e.destroy=function(e){var r;for(r=n-1;r>=0;r-=1)t[r].animation.destroy(e)},e.freeze=function(){s=!0},e.unfreeze=function(){s=!1,d()},e.setVolume=function(e,r){var a;for(a=0;a<n;a+=1)t[a].animation.setVolume(e,r)},e.mute=function(e){var r;for(r=0;r<n;r+=1)t[r].animation.mute(e)},e.unmute=function(e){var r;for(r=0;r<n;r+=1)t[r].animation.unmute(e)},e.getRegisteredAnimations=function(){var e,r=t.length,n=[];for(e=0;e<r;e+=1)n.push(t[e].animation);return n},e}(),BezierFactory=function(){var e={getBezierEasing:function(e,r,n,a,i){var s=i||("bez_"+e+"_"+r+"_"+n+"_"+a).replace(/\./g,"p");if(t[s])return t[s];var o=new f([e,r,n,a]);return t[s]=o,o}},t={},r=4,n=1e-7,a=10,i=11,s=1/(i-1),o="function"==typeof Float32Array;function l(e,t){return 1-3*t+3*e}function u(e,t){return 3*t-6*e}function c(e){return 3*e}function h(e,t,r){return((l(t,r)*e+u(t,r))*e+c(t))*e}function p(e,t,r){return 3*l(t,r)*e*e+2*u(t,r)*e+c(t)}function f(e){this._p=e,this._mSampleValues=o?new Float32Array(i):new Array(i),this._precomputed=!1,this.get=this.get.bind(this)}return f.prototype={get:function(e){var t=this._p[0],r=this._p[1],n=this._p[2],a=this._p[3];return this._precomputed||this._precompute(),t===r&&n===a?e:0===e?0:1===e?1:h(this._getTForX(e),r,a)},_precompute:function(){var e=this._p[0],t=this._p[1],r=this._p[2],n=this._p[3];this._precomputed=!0,e===t&&r===n||this._calcSampleValues()},_calcSampleValues:function(){for(var e=this._p[0],t=this._p[2],r=0;r<i;++r)this._mSampleValues[r]=h(r*s,e,t)},_getTForX:function(e){for(var t=this._p[0],o=this._p[2],l=this._mSampleValues,u=0,c=1,f=i-1;c!==f&&l[c]<=e;++c)u+=s;var d=u+(e-l[--c])/(l[c+1]-l[c])*s,m=p(d,t,o);return m>=.001?function(e,t,n,a){for(var i=0;i<r;++i){var s=p(t,n,a);if(0===s)return t;t-=(h(t,n,a)-e)/s}return t}(e,d,t,o):0===m?d:function(e,t,r,i,s){var o,l,u=0;do{(o=h(l=t+(r-t)/2,i,s)-e)>0?r=l:t=l}while(Math.abs(o)>n&&++u<a);return l}(e,u,u+s,t,o)}},e}(),pooling={double:function(e){return e.concat(createSizedArray(e.length))}},poolFactory=function(e,t,r){var n=0,a=e,i=createSizedArray(a);return{newElement:function(){return n?i[n-=1]:t()},release:function(e){n===a&&(i=pooling.double(i),a*=2),r&&r(e),i[n]=e,n+=1}}},bezierLengthPool=poolFactory(8,(function(){return{addedLength:0,percents:createTypedArray("float32",getDefaultCurveSegments()),lengths:createTypedArray("float32",getDefaultCurveSegments())}})),segmentsLengthPool=poolFactory(8,(function(){return{lengths:[],totalLength:0}}),(function(e){var t,r=e.lengths.length;for(t=0;t<r;t+=1)bezierLengthPool.release(e.lengths[t]);e.lengths.length=0}));function bezFunction(){var e=Math;function t(e,t,r,n,a,i){var s=e*n+t*a+r*i-a*n-i*e-r*t;return s>-.001&&s<.001}var r=function(e,t,r,n){var a,i,s,o,l,u,c=getDefaultCurveSegments(),h=0,p=[],f=[],d=bezierLengthPool.newElement();for(s=r.length,a=0;a<c;a+=1){for(l=a/(c-1),u=0,i=0;i<s;i+=1)o=bmPow(1-l,3)*e[i]+3*bmPow(1-l,2)*l*r[i]+3*(1-l)*bmPow(l,2)*n[i]+bmPow(l,3)*t[i],p[i]=o,null!==f[i]&&(u+=bmPow(p[i]-f[i],2)),f[i]=p[i];u&&(h+=u=bmSqrt(u)),d.percents[a]=l,d.lengths[a]=h}return d.addedLength=h,d};function n(e){this.segmentLength=0,this.points=new Array(e)}function a(e,t){this.partialLength=e,this.point=t}var i,s=(i={},function(e,r,s,o){var l=(e[0]+"_"+e[1]+"_"+r[0]+"_"+r[1]+"_"+s[0]+"_"+s[1]+"_"+o[0]+"_"+o[1]).replace(/\./g,"p");if(!i[l]){var u,c,h,p,f,d,m,g=getDefaultCurveSegments(),y=0,v=null;2===e.length&&(e[0]!==r[0]||e[1]!==r[1])&&t(e[0],e[1],r[0],r[1],e[0]+s[0],e[1]+s[1])&&t(e[0],e[1],r[0],r[1],r[0]+o[0],r[1]+o[1])&&(g=2);var b=new n(g);for(h=s.length,u=0;u<g;u+=1){for(m=createSizedArray(h),f=u/(g-1),d=0,c=0;c<h;c+=1)p=bmPow(1-f,3)*e[c]+3*bmPow(1-f,2)*f*(e[c]+s[c])+3*(1-f)*bmPow(f,2)*(r[c]+o[c])+bmPow(f,3)*r[c],m[c]=p,null!==v&&(d+=bmPow(m[c]-v[c],2));y+=d=bmSqrt(d),b.points[u]=new a(d,m),v=m}b.segmentLength=y,i[l]=b}return i[l]});function o(e,t){var r=t.percents,n=t.lengths,a=r.length,i=bmFloor((a-1)*e),s=e*t.addedLength,o=0;if(i===a-1||0===i||s===n[i])return r[i];for(var l=n[i]>s?-1:1,u=!0;u;)if(n[i]<=s&&n[i+1]>s?(o=(s-n[i])/(n[i+1]-n[i]),u=!1):i+=l,i<0||i>=a-1){if(i===a-1)return r[i];u=!1}return r[i]+(r[i+1]-r[i])*o}var l=createTypedArray("float32",8);return{getSegmentsLength:function(e){var t,n=segmentsLengthPool.newElement(),a=e.c,i=e.v,s=e.o,o=e.i,l=e._length,u=n.lengths,c=0;for(t=0;t<l-1;t+=1)u[t]=r(i[t],i[t+1],s[t],o[t+1]),c+=u[t].addedLength;return a&&l&&(u[t]=r(i[t],i[0],s[t],o[0]),c+=u[t].addedLength),n.totalLength=c,n},getNewSegment:function(t,r,n,a,i,s,u){i<0?i=0:i>1&&(i=1);var c,h=o(i,u),p=o(s=s>1?1:s,u),f=t.length,d=1-h,m=1-p,g=d*d*d,y=h*d*d*3,v=h*h*d*3,b=h*h*h,k=d*d*m,x=h*d*m+d*h*m+d*d*p,S=h*h*m+d*h*p+h*d*p,w=h*h*p,E=d*m*m,_=h*m*m+d*p*m+d*m*p,P=h*p*m+d*p*p+h*m*p,C=h*p*p,A=m*m*m,T=p*m*m+m*p*m+m*m*p,M=p*p*m+m*p*p+p*m*p,D=p*p*p;for(c=0;c<f;c+=1)l[4*c]=e.round(1e3*(g*t[c]+y*n[c]+v*a[c]+b*r[c]))/1e3,l[4*c+1]=e.round(1e3*(k*t[c]+x*n[c]+S*a[c]+w*r[c]))/1e3,l[4*c+2]=e.round(1e3*(E*t[c]+_*n[c]+P*a[c]+C*r[c]))/1e3,l[4*c+3]=e.round(1e3*(A*t[c]+T*n[c]+M*a[c]+D*r[c]))/1e3;return l},getPointInSegment:function(t,r,n,a,i,s){var l=o(i,s),u=1-l;return[e.round(1e3*(u*u*u*t[0]+(l*u*u+u*l*u+u*u*l)*n[0]+(l*l*u+u*l*l+l*u*l)*a[0]+l*l*l*r[0]))/1e3,e.round(1e3*(u*u*u*t[1]+(l*u*u+u*l*u+u*u*l)*n[1]+(l*l*u+u*l*l+l*u*l)*a[1]+l*l*l*r[1]))/1e3]},buildBezierData:s,pointOnLine2D:t,pointOnLine3D:function(r,n,a,i,s,o,l,u,c){if(0===a&&0===o&&0===c)return t(r,n,i,s,l,u);var h,p=e.sqrt(e.pow(i-r,2)+e.pow(s-n,2)+e.pow(o-a,2)),f=e.sqrt(e.pow(l-r,2)+e.pow(u-n,2)+e.pow(c-a,2)),d=e.sqrt(e.pow(l-i,2)+e.pow(u-s,2)+e.pow(c-o,2));return(h=p>f?p>d?p-f-d:d-f-p:d>f?d-f-p:f-p-d)>-1e-4&&h<1e-4}}}var bez=bezFunction(),initFrame=initialDefaultFrame,mathAbs=Math.abs;function interpolateValue(e,t){var r,n=this.offsetTime;"multidimensional"===this.propType&&(r=createTypedArray("float32",this.pv.length));for(var a,i,s,o,l,u,c,h,p,f=t.lastIndex,d=f,m=this.keyframes.length-1,g=!0;g;){if(a=this.keyframes[d],i=this.keyframes[d+1],d===m-1&&e>=i.t-n){a.h&&(a=i),f=0;break}if(i.t-n>e){f=d;break}d<m-1?d+=1:(f=0,g=!1)}s=this.keyframesMetadata[d]||{};var y,v=i.t-n,b=a.t-n;if(a.to){s.bezierData||(s.bezierData=bez.buildBezierData(a.s,i.s||a.e,a.to,a.ti));var k=s.bezierData;if(e>=v||e<b){var x=e>=v?k.points.length-1:0;for(l=k.points[x].point.length,o=0;o<l;o+=1)r[o]=k.points[x].point[o]}else{s.__fnct?p=s.__fnct:(p=BezierFactory.getBezierEasing(a.o.x,a.o.y,a.i.x,a.i.y,a.n).get,s.__fnct=p),u=p((e-b)/(v-b));var S,w=k.segmentLength*u,E=t.lastFrame<e&&t._lastKeyframeIndex===d?t._lastAddedLength:0;for(h=t.lastFrame<e&&t._lastKeyframeIndex===d?t._lastPoint:0,g=!0,c=k.points.length;g;){if(E+=k.points[h].partialLength,0===w||0===u||h===k.points.length-1){for(l=k.points[h].point.length,o=0;o<l;o+=1)r[o]=k.points[h].point[o];break}if(w>=E&&w<E+k.points[h+1].partialLength){for(S=(w-E)/k.points[h+1].partialLength,l=k.points[h].point.length,o=0;o<l;o+=1)r[o]=k.points[h].point[o]+(k.points[h+1].point[o]-k.points[h].point[o])*S;break}h<c-1?h+=1:g=!1}t._lastPoint=h,t._lastAddedLength=E-k.points[h].partialLength,t._lastKeyframeIndex=d}}else{var _,P,C,A,T;if(m=a.s.length,y=i.s||a.e,this.sh&&1!==a.h)e>=v?(r[0]=y[0],r[1]=y[1],r[2]=y[2]):e<=b?(r[0]=a.s[0],r[1]=a.s[1],r[2]=a.s[2]):quaternionToEuler(r,slerp(createQuaternion(a.s),createQuaternion(y),(e-b)/(v-b)));else for(d=0;d<m;d+=1)1!==a.h&&(e>=v?u=1:e<b?u=0:(a.o.x.constructor===Array?(s.__fnct||(s.__fnct=[]),s.__fnct[d]?p=s.__fnct[d]:(_=void 0===a.o.x[d]?a.o.x[0]:a.o.x[d],P=void 0===a.o.y[d]?a.o.y[0]:a.o.y[d],C=void 0===a.i.x[d]?a.i.x[0]:a.i.x[d],A=void 0===a.i.y[d]?a.i.y[0]:a.i.y[d],p=BezierFactory.getBezierEasing(_,P,C,A).get,s.__fnct[d]=p)):s.__fnct?p=s.__fnct:(_=a.o.x,P=a.o.y,C=a.i.x,A=a.i.y,p=BezierFactory.getBezierEasing(_,P,C,A).get,a.keyframeMetadata=p),u=p((e-b)/(v-b)))),y=i.s||a.e,T=1===a.h?a.s[d]:a.s[d]+(y[d]-a.s[d])*u,"multidimensional"===this.propType?r[d]=T:r=T}return t.lastIndex=f,r}function slerp(e,t,r){var n,a,i,s,o,l=[],u=e[0],c=e[1],h=e[2],p=e[3],f=t[0],d=t[1],m=t[2],g=t[3];return(a=u*f+c*d+h*m+p*g)<0&&(a=-a,f=-f,d=-d,m=-m,g=-g),1-a>1e-6?(n=Math.acos(a),i=Math.sin(n),s=Math.sin((1-r)*n)/i,o=Math.sin(r*n)/i):(s=1-r,o=r),l[0]=s*u+o*f,l[1]=s*c+o*d,l[2]=s*h+o*m,l[3]=s*p+o*g,l}function quaternionToEuler(e,t){var r=t[0],n=t[1],a=t[2],i=t[3],s=Math.atan2(2*n*i-2*r*a,1-2*n*n-2*a*a),o=Math.asin(2*r*n+2*a*i),l=Math.atan2(2*r*i-2*n*a,1-2*r*r-2*a*a);e[0]=s/degToRads,e[1]=o/degToRads,e[2]=l/degToRads}function createQuaternion(e){var t=e[0]*degToRads,r=e[1]*degToRads,n=e[2]*degToRads,a=Math.cos(t/2),i=Math.cos(r/2),s=Math.cos(n/2),o=Math.sin(t/2),l=Math.sin(r/2),u=Math.sin(n/2);return[o*l*s+a*i*u,o*i*s+a*l*u,a*l*s-o*i*u,a*i*s-o*l*u]}function getValueAtCurrentTime(){var e=this.comp.renderedFrame-this.offsetTime,t=this.keyframes[0].t-this.offsetTime,r=this.keyframes[this.keyframes.length-1].t-this.offsetTime;if(!(e===this._caching.lastFrame||this._caching.lastFrame!==initFrame&&(this._caching.lastFrame>=r&&e>=r||this._caching.lastFrame<t&&e<t))){this._caching.lastFrame>=e&&(this._caching._lastKeyframeIndex=-1,this._caching.lastIndex=0);var n=this.interpolateValue(e,this._caching);this.pv=n}return this._caching.lastFrame=e,this.pv}function setVValue(e){var t;if("unidimensional"===this.propType)t=e*this.mult,mathAbs(this.v-t)>1e-5&&(this.v=t,this._mdf=!0);else for(var r=0,n=this.v.length;r<n;)t=e[r]*this.mult,mathAbs(this.v[r]-t)>1e-5&&(this.v[r]=t,this._mdf=!0),r+=1}function processEffectsSequence(){if(this.elem.globalData.frameId!==this.frameId&&this.effectsSequence.length)if(this.lock)this.setVValue(this.pv);else{var e;this.lock=!0,this._mdf=this._isFirstFrame;var t=this.effectsSequence.length,r=this.kf?this.pv:this.data.k;for(e=0;e<t;e+=1)r=this.effectsSequence[e](r);this.setVValue(r),this._isFirstFrame=!1,this.lock=!1,this.frameId=this.elem.globalData.frameId}}function addEffect(e){this.effectsSequence.push(e),this.container.addDynamicProperty(this)}function ValueProperty(e,t,r,n){this.propType="unidimensional",this.mult=r||1,this.data=t,this.v=r?t.k*r:t.k,this.pv=t.k,this._mdf=!1,this.elem=e,this.container=n,this.comp=e.comp,this.k=!1,this.kf=!1,this.vel=0,this.effectsSequence=[],this._isFirstFrame=!0,this.getValue=processEffectsSequence,this.setVValue=setVValue,this.addEffect=addEffect}function MultiDimensionalProperty(e,t,r,n){var a;this.propType="multidimensional",this.mult=r||1,this.data=t,this._mdf=!1,this.elem=e,this.container=n,this.comp=e.comp,this.k=!1,this.kf=!1,this.frameId=-1;var i=t.k.length;for(this.v=createTypedArray("float32",i),this.pv=createTypedArray("float32",i),this.vel=createTypedArray("float32",i),a=0;a<i;a+=1)this.v[a]=t.k[a]*this.mult,this.pv[a]=t.k[a];this._isFirstFrame=!0,this.effectsSequence=[],this.getValue=processEffectsSequence,this.setVValue=setVValue,this.addEffect=addEffect}function KeyframedValueProperty(e,t,r,n){this.propType="unidimensional",this.keyframes=t.k,this.keyframesMetadata=[],this.offsetTime=e.data.st,this.frameId=-1,this._caching={lastFrame:initFrame,lastIndex:0,value:0,_lastKeyframeIndex:-1},this.k=!0,this.kf=!0,this.data=t,this.mult=r||1,this.elem=e,this.container=n,this.comp=e.comp,this.v=initFrame,this.pv=initFrame,this._isFirstFrame=!0,this.getValue=processEffectsSequence,this.setVValue=setVValue,this.interpolateValue=interpolateValue,this.effectsSequence=[getValueAtCurrentTime.bind(this)],this.addEffect=addEffect}function KeyframedMultidimensionalProperty(e,t,r,n){var a;this.propType="multidimensional";var i,s,o,l,u=t.k.length;for(a=0;a<u-1;a+=1)t.k[a].to&&t.k[a].s&&t.k[a+1]&&t.k[a+1].s&&(i=t.k[a].s,s=t.k[a+1].s,o=t.k[a].to,l=t.k[a].ti,(2===i.length&&(i[0]!==s[0]||i[1]!==s[1])&&bez.pointOnLine2D(i[0],i[1],s[0],s[1],i[0]+o[0],i[1]+o[1])&&bez.pointOnLine2D(i[0],i[1],s[0],s[1],s[0]+l[0],s[1]+l[1])||3===i.length&&(i[0]!==s[0]||i[1]!==s[1]||i[2]!==s[2])&&bez.pointOnLine3D(i[0],i[1],i[2],s[0],s[1],s[2],i[0]+o[0],i[1]+o[1],i[2]+o[2])&&bez.pointOnLine3D(i[0],i[1],i[2],s[0],s[1],s[2],s[0]+l[0],s[1]+l[1],s[2]+l[2]))&&(t.k[a].to=null,t.k[a].ti=null),i[0]===s[0]&&i[1]===s[1]&&0===o[0]&&0===o[1]&&0===l[0]&&0===l[1]&&(2===i.length||i[2]===s[2]&&0===o[2]&&0===l[2])&&(t.k[a].to=null,t.k[a].ti=null));this.effectsSequence=[getValueAtCurrentTime.bind(this)],this.data=t,this.keyframes=t.k,this.keyframesMetadata=[],this.offsetTime=e.data.st,this.k=!0,this.kf=!0,this._isFirstFrame=!0,this.mult=r||1,this.elem=e,this.container=n,this.comp=e.comp,this.getValue=processEffectsSequence,this.setVValue=setVValue,this.interpolateValue=interpolateValue,this.frameId=-1;var c=t.k[0].s.length;for(this.v=createTypedArray("float32",c),this.pv=createTypedArray("float32",c),a=0;a<c;a+=1)this.v[a]=initFrame,this.pv[a]=initFrame;this._caching={lastFrame:initFrame,lastIndex:0,value:createTypedArray("float32",c)},this.addEffect=addEffect}var PropertyFactory={getProp:function(e,t,r,n,a){var i;if(t.sid&&(t=e.globalData.slotManager.getProp(t)),t.k.length)if("number"==typeof t.k[0])i=new MultiDimensionalProperty(e,t,n,a);else switch(r){case 0:i=new KeyframedValueProperty(e,t,n,a);break;case 1:i=new KeyframedMultidimensionalProperty(e,t,n,a)}else i=new ValueProperty(e,t,n,a);return i.effectsSequence.length&&a.addDynamicProperty(i),i}};function DynamicPropertyContainer(){}DynamicPropertyContainer.prototype={addDynamicProperty:function(e){-1===this.dynamicProperties.indexOf(e)&&(this.dynamicProperties.push(e),this.container.addDynamicProperty(this),this._isAnimated=!0)},iterateDynamicProperties:function(){var e;this._mdf=!1;var t=this.dynamicProperties.length;for(e=0;e<t;e+=1)this.dynamicProperties[e].getValue(),this.dynamicProperties[e]._mdf&&(this._mdf=!0)},initDynamicPropertyContainer:function(e){this.container=e,this.dynamicProperties=[],this._mdf=!1,this._isAnimated=!1}};var pointPool=poolFactory(8,(function(){return createTypedArray("float32",2)}));function ShapePath(){this.c=!1,this._length=0,this._maxLength=8,this.v=createSizedArray(this._maxLength),this.o=createSizedArray(this._maxLength),this.i=createSizedArray(this._maxLength)}ShapePath.prototype.setPathData=function(e,t){this.c=e,this.setLength(t);for(var r=0;r<t;)this.v[r]=pointPool.newElement(),this.o[r]=pointPool.newElement(),this.i[r]=pointPool.newElement(),r+=1},ShapePath.prototype.setLength=function(e){for(;this._maxLength<e;)this.doubleArrayLength();this._length=e},ShapePath.prototype.doubleArrayLength=function(){this.v=this.v.concat(createSizedArray(this._maxLength)),this.i=this.i.concat(createSizedArray(this._maxLength)),this.o=this.o.concat(createSizedArray(this._maxLength)),this._maxLength*=2},ShapePath.prototype.setXYAt=function(e,t,r,n,a){var i;switch(this._length=Math.max(this._length,n+1),this._length>=this._maxLength&&this.doubleArrayLength(),r){case"v":i=this.v;break;case"i":i=this.i;break;case"o":i=this.o;break;default:i=[]}(!i[n]||i[n]&&!a)&&(i[n]=pointPool.newElement()),i[n][0]=e,i[n][1]=t},ShapePath.prototype.setTripleAt=function(e,t,r,n,a,i,s,o){this.setXYAt(e,t,"v",s,o),this.setXYAt(r,n,"o",s,o),this.setXYAt(a,i,"i",s,o)},ShapePath.prototype.reverse=function(){var e=new ShapePath;e.setPathData(this.c,this._length);var t=this.v,r=this.o,n=this.i,a=0;this.c&&(e.setTripleAt(t[0][0],t[0][1],n[0][0],n[0][1],r[0][0],r[0][1],0,!1),a=1);var i,s=this._length-1,o=this._length;for(i=a;i<o;i+=1)e.setTripleAt(t[s][0],t[s][1],n[s][0],n[s][1],r[s][0],r[s][1],i,!1),s-=1;return e},ShapePath.prototype.length=function(){return this._length};var shapePool=(factory=poolFactory(4,(function(){return new ShapePath}),(function(e){var t,r=e._length;for(t=0;t<r;t+=1)pointPool.release(e.v[t]),pointPool.release(e.i[t]),pointPool.release(e.o[t]),e.v[t]=null,e.i[t]=null,e.o[t]=null;e._length=0,e.c=!1})),factory.clone=function(e){var t,r=factory.newElement(),n=void 0===e._length?e.v.length:e._length;for(r.setLength(n),r.c=e.c,t=0;t<n;t+=1)r.setTripleAt(e.v[t][0],e.v[t][1],e.o[t][0],e.o[t][1],e.i[t][0],e.i[t][1],t);return r},factory),factory;function ShapeCollection(){this._length=0,this._maxLength=4,this.shapes=createSizedArray(this._maxLength)}ShapeCollection.prototype.addShape=function(e){this._length===this._maxLength&&(this.shapes=this.shapes.concat(createSizedArray(this._maxLength)),this._maxLength*=2),this.shapes[this._length]=e,this._length+=1},ShapeCollection.prototype.releaseShapes=function(){var e;for(e=0;e<this._length;e+=1)shapePool.release(this.shapes[e]);this._length=0};var shapeCollectionPool=(ob={newShapeCollection:function(){return _length?pool[_length-=1]:new ShapeCollection},release:function(e){var t,r=e._length;for(t=0;t<r;t+=1)shapePool.release(e.shapes[t]);e._length=0,_length===_maxLength&&(pool=pooling.double(pool),_maxLength*=2),pool[_length]=e,_length+=1}},_length=0,_maxLength=4,pool=createSizedArray(_maxLength),ob),ob,_length,_maxLength,pool,ShapePropertyFactory=function(){var e=-999999;function t(e,t,r){var n,a,i,s,o,l,u,c,h,p=r.lastIndex,f=this.keyframes;if(e<f[0].t-this.offsetTime)n=f[0].s[0],i=!0,p=0;else if(e>=f[f.length-1].t-this.offsetTime)n=f[f.length-1].s?f[f.length-1].s[0]:f[f.length-2].e[0],i=!0;else{for(var d,m,g,y=p,v=f.length-1,b=!0;b&&(d=f[y],!((m=f[y+1]).t-this.offsetTime>e));)y<v-1?y+=1:b=!1;if(g=this.keyframesMetadata[y]||{},p=y,!(i=1===d.h)){if(e>=m.t-this.offsetTime)c=1;else if(e<d.t-this.offsetTime)c=0;else{var k;g.__fnct?k=g.__fnct:(k=BezierFactory.getBezierEasing(d.o.x,d.o.y,d.i.x,d.i.y).get,g.__fnct=k),c=k((e-(d.t-this.offsetTime))/(m.t-this.offsetTime-(d.t-this.offsetTime)))}a=m.s?m.s[0]:d.e[0]}n=d.s[0]}for(l=t._length,u=n.i[0].length,r.lastIndex=p,s=0;s<l;s+=1)for(o=0;o<u;o+=1)h=i?n.i[s][o]:n.i[s][o]+(a.i[s][o]-n.i[s][o])*c,t.i[s][o]=h,h=i?n.o[s][o]:n.o[s][o]+(a.o[s][o]-n.o[s][o])*c,t.o[s][o]=h,h=i?n.v[s][o]:n.v[s][o]+(a.v[s][o]-n.v[s][o])*c,t.v[s][o]=h}function r(){var t=this.comp.renderedFrame-this.offsetTime,r=this.keyframes[0].t-this.offsetTime,n=this.keyframes[this.keyframes.length-1].t-this.offsetTime,a=this._caching.lastFrame;return a!==e&&(a<r&&t<r||a>n&&t>n)||(this._caching.lastIndex=a<t?this._caching.lastIndex:0,this.interpolateShape(t,this.pv,this._caching)),this._caching.lastFrame=t,this.pv}function n(){this.paths=this.localShapeCollection}function a(e){(function(e,t){if(e._length!==t._length||e.c!==t.c)return!1;var r,n=e._length;for(r=0;r<n;r+=1)if(e.v[r][0]!==t.v[r][0]||e.v[r][1]!==t.v[r][1]||e.o[r][0]!==t.o[r][0]||e.o[r][1]!==t.o[r][1]||e.i[r][0]!==t.i[r][0]||e.i[r][1]!==t.i[r][1])return!1;return!0})(this.v,e)||(this.v=shapePool.clone(e),this.localShapeCollection.releaseShapes(),this.localShapeCollection.addShape(this.v),this._mdf=!0,this.paths=this.localShapeCollection)}function i(){if(this.elem.globalData.frameId!==this.frameId)if(this.effectsSequence.length)if(this.lock)this.setVValue(this.pv);else{var e,t;this.lock=!0,this._mdf=!1,e=this.kf?this.pv:this.data.ks?this.data.ks.k:this.data.pt.k;var r=this.effectsSequence.length;for(t=0;t<r;t+=1)e=this.effectsSequence[t](e);this.setVValue(e),this.lock=!1,this.frameId=this.elem.globalData.frameId}else this._mdf=!1}function s(e,t,r){this.propType="shape",this.comp=e.comp,this.container=e,this.elem=e,this.data=t,this.k=!1,this.kf=!1,this._mdf=!1;var a=3===r?t.pt.k:t.ks.k;this.v=shapePool.clone(a),this.pv=shapePool.clone(this.v),this.localShapeCollection=shapeCollectionPool.newShapeCollection(),this.paths=this.localShapeCollection,this.paths.addShape(this.v),this.reset=n,this.effectsSequence=[]}function o(e){this.effectsSequence.push(e),this.container.addDynamicProperty(this)}function l(t,a,i){this.propType="shape",this.comp=t.comp,this.elem=t,this.container=t,this.offsetTime=t.data.st,this.keyframes=3===i?a.pt.k:a.ks.k,this.keyframesMetadata=[],this.k=!0,this.kf=!0;var s=this.keyframes[0].s[0].i.length;this.v=shapePool.newElement(),this.v.setPathData(this.keyframes[0].s[0].c,s),this.pv=shapePool.clone(this.v),this.localShapeCollection=shapeCollectionPool.newShapeCollection(),this.paths=this.localShapeCollection,this.paths.addShape(this.v),this.lastFrame=e,this.reset=n,this._caching={lastFrame:e,lastIndex:0},this.effectsSequence=[r.bind(this)]}s.prototype.interpolateShape=t,s.prototype.getValue=i,s.prototype.setVValue=a,s.prototype.addEffect=o,l.prototype.getValue=i,l.prototype.interpolateShape=t,l.prototype.setVValue=a,l.prototype.addEffect=o;var u=function(){var e=roundCorner;function t(e,t){this.v=shapePool.newElement(),this.v.setPathData(!0,4),this.localShapeCollection=shapeCollectionPool.newShapeCollection(),this.paths=this.localShapeCollection,this.localShapeCollection.addShape(this.v),this.d=t.d,this.elem=e,this.comp=e.comp,this.frameId=-1,this.initDynamicPropertyContainer(e),this.p=PropertyFactory.getProp(e,t.p,1,0,this),this.s=PropertyFactory.getProp(e,t.s,1,0,this),this.dynamicProperties.length?this.k=!0:(this.k=!1,this.convertEllToPath())}return t.prototype={reset:n,getValue:function(){this.elem.globalData.frameId!==this.frameId&&(this.frameId=this.elem.globalData.frameId,this.iterateDynamicProperties(),this._mdf&&this.convertEllToPath())},convertEllToPath:function(){var t=this.p.v[0],r=this.p.v[1],n=this.s.v[0]/2,a=this.s.v[1]/2,i=3!==this.d,s=this.v;s.v[0][0]=t,s.v[0][1]=r-a,s.v[1][0]=i?t+n:t-n,s.v[1][1]=r,s.v[2][0]=t,s.v[2][1]=r+a,s.v[3][0]=i?t-n:t+n,s.v[3][1]=r,s.i[0][0]=i?t-n*e:t+n*e,s.i[0][1]=r-a,s.i[1][0]=i?t+n:t-n,s.i[1][1]=r-a*e,s.i[2][0]=i?t+n*e:t-n*e,s.i[2][1]=r+a,s.i[3][0]=i?t-n:t+n,s.i[3][1]=r+a*e,s.o[0][0]=i?t+n*e:t-n*e,s.o[0][1]=r-a,s.o[1][0]=i?t+n:t-n,s.o[1][1]=r+a*e,s.o[2][0]=i?t-n*e:t+n*e,s.o[2][1]=r+a,s.o[3][0]=i?t-n:t+n,s.o[3][1]=r-a*e}},extendPrototype([DynamicPropertyContainer],t),t}(),c=function(){function e(e,t){this.v=shapePool.newElement(),this.v.setPathData(!0,0),this.elem=e,this.comp=e.comp,this.data=t,this.frameId=-1,this.d=t.d,this.initDynamicPropertyContainer(e),1===t.sy?(this.ir=PropertyFactory.getProp(e,t.ir,0,0,this),this.is=PropertyFactory.getProp(e,t.is,0,.01,this),this.convertToPath=this.convertStarToPath):this.convertToPath=this.convertPolygonToPath,this.pt=PropertyFactory.getProp(e,t.pt,0,0,this),this.p=PropertyFactory.getProp(e,t.p,1,0,this),this.r=PropertyFactory.getProp(e,t.r,0,degToRads,this),this.or=PropertyFactory.getProp(e,t.or,0,0,this),this.os=PropertyFactory.getProp(e,t.os,0,.01,this),this.localShapeCollection=shapeCollectionPool.newShapeCollection(),this.localShapeCollection.addShape(this.v),this.paths=this.localShapeCollection,this.dynamicProperties.length?this.k=!0:(this.k=!1,this.convertToPath())}return e.prototype={reset:n,getValue:function(){this.elem.globalData.frameId!==this.frameId&&(this.frameId=this.elem.globalData.frameId,this.iterateDynamicProperties(),this._mdf&&this.convertToPath())},convertStarToPath:function(){var e,t,r,n,a=2*Math.floor(this.pt.v),i=2*Math.PI/a,s=!0,o=this.or.v,l=this.ir.v,u=this.os.v,c=this.is.v,h=2*Math.PI*o/(2*a),p=2*Math.PI*l/(2*a),f=-Math.PI/2;f+=this.r.v;var d=3===this.data.d?-1:1;for(this.v._length=0,e=0;e<a;e+=1){r=s?u:c,n=s?h:p;var m=(t=s?o:l)*Math.cos(f),g=t*Math.sin(f),y=0===m&&0===g?0:g/Math.sqrt(m*m+g*g),v=0===m&&0===g?0:-m/Math.sqrt(m*m+g*g);m+=+this.p.v[0],g+=+this.p.v[1],this.v.setTripleAt(m,g,m-y*n*r*d,g-v*n*r*d,m+y*n*r*d,g+v*n*r*d,e,!0),s=!s,f+=i*d}},convertPolygonToPath:function(){var e,t=Math.floor(this.pt.v),r=2*Math.PI/t,n=this.or.v,a=this.os.v,i=2*Math.PI*n/(4*t),s=.5*-Math.PI,o=3===this.data.d?-1:1;for(s+=this.r.v,this.v._length=0,e=0;e<t;e+=1){var l=n*Math.cos(s),u=n*Math.sin(s),c=0===l&&0===u?0:u/Math.sqrt(l*l+u*u),h=0===l&&0===u?0:-l/Math.sqrt(l*l+u*u);l+=+this.p.v[0],u+=+this.p.v[1],this.v.setTripleAt(l,u,l-c*i*a*o,u-h*i*a*o,l+c*i*a*o,u+h*i*a*o,e,!0),s+=r*o}this.paths.length=0,this.paths[0]=this.v}},extendPrototype([DynamicPropertyContainer],e),e}(),h=function(){function e(e,t){this.v=shapePool.newElement(),this.v.c=!0,this.localShapeCollection=shapeCollectionPool.newShapeCollection(),this.localShapeCollection.addShape(this.v),this.paths=this.localShapeCollection,this.elem=e,this.comp=e.comp,this.frameId=-1,this.d=t.d,this.initDynamicPropertyContainer(e),this.p=PropertyFactory.getProp(e,t.p,1,0,this),this.s=PropertyFactory.getProp(e,t.s,1,0,this),this.r=PropertyFactory.getProp(e,t.r,0,0,this),this.dynamicProperties.length?this.k=!0:(this.k=!1,this.convertRectToPath())}return e.prototype={convertRectToPath:function(){var e=this.p.v[0],t=this.p.v[1],r=this.s.v[0]/2,n=this.s.v[1]/2,a=bmMin(r,n,this.r.v),i=a*(1-roundCorner);this.v._length=0,2===this.d||1===this.d?(this.v.setTripleAt(e+r,t-n+a,e+r,t-n+a,e+r,t-n+i,0,!0),this.v.setTripleAt(e+r,t+n-a,e+r,t+n-i,e+r,t+n-a,1,!0),0!==a?(this.v.setTripleAt(e+r-a,t+n,e+r-a,t+n,e+r-i,t+n,2,!0),this.v.setTripleAt(e-r+a,t+n,e-r+i,t+n,e-r+a,t+n,3,!0),this.v.setTripleAt(e-r,t+n-a,e-r,t+n-a,e-r,t+n-i,4,!0),this.v.setTripleAt(e-r,t-n+a,e-r,t-n+i,e-r,t-n+a,5,!0),this.v.setTripleAt(e-r+a,t-n,e-r+a,t-n,e-r+i,t-n,6,!0),this.v.setTripleAt(e+r-a,t-n,e+r-i,t-n,e+r-a,t-n,7,!0)):(this.v.setTripleAt(e-r,t+n,e-r+i,t+n,e-r,t+n,2),this.v.setTripleAt(e-r,t-n,e-r,t-n+i,e-r,t-n,3))):(this.v.setTripleAt(e+r,t-n+a,e+r,t-n+i,e+r,t-n+a,0,!0),0!==a?(this.v.setTripleAt(e+r-a,t-n,e+r-a,t-n,e+r-i,t-n,1,!0),this.v.setTripleAt(e-r+a,t-n,e-r+i,t-n,e-r+a,t-n,2,!0),this.v.setTripleAt(e-r,t-n+a,e-r,t-n+a,e-r,t-n+i,3,!0),this.v.setTripleAt(e-r,t+n-a,e-r,t+n-i,e-r,t+n-a,4,!0),this.v.setTripleAt(e-r+a,t+n,e-r+a,t+n,e-r+i,t+n,5,!0),this.v.setTripleAt(e+r-a,t+n,e+r-i,t+n,e+r-a,t+n,6,!0),this.v.setTripleAt(e+r,t+n-a,e+r,t+n-a,e+r,t+n-i,7,!0)):(this.v.setTripleAt(e-r,t-n,e-r+i,t-n,e-r,t-n,1,!0),this.v.setTripleAt(e-r,t+n,e-r,t+n-i,e-r,t+n,2,!0),this.v.setTripleAt(e+r,t+n,e+r-i,t+n,e+r,t+n,3,!0)))},getValue:function(){this.elem.globalData.frameId!==this.frameId&&(this.frameId=this.elem.globalData.frameId,this.iterateDynamicProperties(),this._mdf&&this.convertRectToPath())},reset:n},extendPrototype([DynamicPropertyContainer],e),e}(),p={getShapeProp:function(e,t,r){var n;return 3===r||4===r?n=(3===r?t.pt:t.ks).k.length?new l(e,t,r):new s(e,t,r):5===r?n=new h(e,t):6===r?n=new u(e,t):7===r&&(n=new c(e,t)),n.k&&e.addDynamicProperty(n),n},getConstructorFunction:function(){return s},getKeyframedConstructorFunction:function(){return l}};return p}(),Matrix=function(){var e=Math.cos,t=Math.sin,r=Math.tan,n=Math.round;function a(){return this.props[0]=1,this.props[1]=0,this.props[2]=0,this.props[3]=0,this.props[4]=0,this.props[5]=1,this.props[6]=0,this.props[7]=0,this.props[8]=0,this.props[9]=0,this.props[10]=1,this.props[11]=0,this.props[12]=0,this.props[13]=0,this.props[14]=0,this.props[15]=1,this}function i(r){if(0===r)return this;var n=e(r),a=t(r);return this._t(n,-a,0,0,a,n,0,0,0,0,1,0,0,0,0,1)}function s(r){if(0===r)return this;var n=e(r),a=t(r);return this._t(1,0,0,0,0,n,-a,0,0,a,n,0,0,0,0,1)}function o(r){if(0===r)return this;var n=e(r),a=t(r);return this._t(n,0,a,0,0,1,0,0,-a,0,n,0,0,0,0,1)}function l(r){if(0===r)return this;var n=e(r),a=t(r);return this._t(n,-a,0,0,a,n,0,0,0,0,1,0,0,0,0,1)}function u(e,t){return this._t(1,t,e,1,0,0)}function c(e,t){return this.shear(r(e),r(t))}function h(n,a){var i=e(a),s=t(a);return this._t(i,s,0,0,-s,i,0,0,0,0,1,0,0,0,0,1)._t(1,0,0,0,r(n),1,0,0,0,0,1,0,0,0,0,1)._t(i,-s,0,0,s,i,0,0,0,0,1,0,0,0,0,1)}function p(e,t,r){return r||0===r||(r=1),1===e&&1===t&&1===r?this:this._t(e,0,0,0,0,t,0,0,0,0,r,0,0,0,0,1)}function f(e,t,r,n,a,i,s,o,l,u,c,h,p,f,d,m){return this.props[0]=e,this.props[1]=t,this.props[2]=r,this.props[3]=n,this.props[4]=a,this.props[5]=i,this.props[6]=s,this.props[7]=o,this.props[8]=l,this.props[9]=u,this.props[10]=c,this.props[11]=h,this.props[12]=p,this.props[13]=f,this.props[14]=d,this.props[15]=m,this}function d(e,t,r){return r=r||0,0!==e||0!==t||0!==r?this._t(1,0,0,0,0,1,0,0,0,0,1,0,e,t,r,1):this}function m(e,t,r,n,a,i,s,o,l,u,c,h,p,f,d,m){var g=this.props;if(1===e&&0===t&&0===r&&0===n&&0===a&&1===i&&0===s&&0===o&&0===l&&0===u&&1===c&&0===h)return g[12]=g[12]*e+g[15]*p,g[13]=g[13]*i+g[15]*f,g[14]=g[14]*c+g[15]*d,g[15]*=m,this._identityCalculated=!1,this;var y=g[0],v=g[1],b=g[2],k=g[3],x=g[4],S=g[5],w=g[6],E=g[7],_=g[8],P=g[9],C=g[10],A=g[11],T=g[12],M=g[13],D=g[14],I=g[15];return g[0]=y*e+v*a+b*l+k*p,g[1]=y*t+v*i+b*u+k*f,g[2]=y*r+v*s+b*c+k*d,g[3]=y*n+v*o+b*h+k*m,g[4]=x*e+S*a+w*l+E*p,g[5]=x*t+S*i+w*u+E*f,g[6]=x*r+S*s+w*c+E*d,g[7]=x*n+S*o+w*h+E*m,g[8]=_*e+P*a+C*l+A*p,g[9]=_*t+P*i+C*u+A*f,g[10]=_*r+P*s+C*c+A*d,g[11]=_*n+P*o+C*h+A*m,g[12]=T*e+M*a+D*l+I*p,g[13]=T*t+M*i+D*u+I*f,g[14]=T*r+M*s+D*c+I*d,g[15]=T*n+M*o+D*h+I*m,this._identityCalculated=!1,this}function g(e){var t=e.props;return this.transform(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])}function y(){return this._identityCalculated||(this._identity=!(1!==this.props[0]||0!==this.props[1]||0!==this.props[2]||0!==this.props[3]||0!==this.props[4]||1!==this.props[5]||0!==this.props[6]||0!==this.props[7]||0!==this.props[8]||0!==this.props[9]||1!==this.props[10]||0!==this.props[11]||0!==this.props[12]||0!==this.props[13]||0!==this.props[14]||1!==this.props[15]),this._identityCalculated=!0),this._identity}function v(e){for(var t=0;t<16;){if(e.props[t]!==this.props[t])return!1;t+=1}return!0}function b(e){var t;for(t=0;t<16;t+=1)e.props[t]=this.props[t];return e}function k(e){var t;for(t=0;t<16;t+=1)this.props[t]=e[t]}function x(e,t,r){return{x:e*this.props[0]+t*this.props[4]+r*this.props[8]+this.props[12],y:e*this.props[1]+t*this.props[5]+r*this.props[9]+this.props[13],z:e*this.props[2]+t*this.props[6]+r*this.props[10]+this.props[14]}}function S(e,t,r){return e*this.props[0]+t*this.props[4]+r*this.props[8]+this.props[12]}function w(e,t,r){return e*this.props[1]+t*this.props[5]+r*this.props[9]+this.props[13]}function E(e,t,r){return e*this.props[2]+t*this.props[6]+r*this.props[10]+this.props[14]}function _(){var e=this.props[0]*this.props[5]-this.props[1]*this.props[4],t=this.props[5]/e,r=-this.props[1]/e,n=-this.props[4]/e,a=this.props[0]/e,i=(this.props[4]*this.props[13]-this.props[5]*this.props[12])/e,s=-(this.props[0]*this.props[13]-this.props[1]*this.props[12])/e,o=new Matrix;return o.props[0]=t,o.props[1]=r,o.props[4]=n,o.props[5]=a,o.props[12]=i,o.props[13]=s,o}function P(e){return this.getInverseMatrix().applyToPointArray(e[0],e[1],e[2]||0)}function C(e){var t,r=e.length,n=[];for(t=0;t<r;t+=1)n[t]=P(e[t]);return n}function A(e,t,r){var n=createTypedArray("float32",6);if(this.isIdentity())n[0]=e[0],n[1]=e[1],n[2]=t[0],n[3]=t[1],n[4]=r[0],n[5]=r[1];else{var a=this.props[0],i=this.props[1],s=this.props[4],o=this.props[5],l=this.props[12],u=this.props[13];n[0]=e[0]*a+e[1]*s+l,n[1]=e[0]*i+e[1]*o+u,n[2]=t[0]*a+t[1]*s+l,n[3]=t[0]*i+t[1]*o+u,n[4]=r[0]*a+r[1]*s+l,n[5]=r[0]*i+r[1]*o+u}return n}function T(e,t,r){return this.isIdentity()?[e,t,r]:[e*this.props[0]+t*this.props[4]+r*this.props[8]+this.props[12],e*this.props[1]+t*this.props[5]+r*this.props[9]+this.props[13],e*this.props[2]+t*this.props[6]+r*this.props[10]+this.props[14]]}function M(e,t){if(this.isIdentity())return e+","+t;var r=this.props;return Math.round(100*(e*r[0]+t*r[4]+r[12]))/100+","+Math.round(100*(e*r[1]+t*r[5]+r[13]))/100}function D(){for(var e=0,t=this.props,r="matrix3d(";e<16;)r+=n(1e4*t[e])/1e4,r+=15===e?")":",",e+=1;return r}function I(e){return e<1e-6&&e>0||e>-1e-6&&e<0?n(1e4*e)/1e4:e}function F(){var e=this.props;return"matrix("+I(e[0])+","+I(e[1])+","+I(e[4])+","+I(e[5])+","+I(e[12])+","+I(e[13])+")"}return function(){this.reset=a,this.rotate=i,this.rotateX=s,this.rotateY=o,this.rotateZ=l,this.skew=c,this.skewFromAxis=h,this.shear=u,this.scale=p,this.setTransform=f,this.translate=d,this.transform=m,this.multiply=g,this.applyToPoint=x,this.applyToX=S,this.applyToY=w,this.applyToZ=E,this.applyToPointArray=T,this.applyToTriplePoints=A,this.applyToPointStringified=M,this.toCSS=D,this.to2dCSS=F,this.clone=b,this.cloneFromProps=k,this.equals=v,this.inversePoints=C,this.inversePoint=P,this.getInverseMatrix=_,this._t=this.transform,this.isIdentity=y,this._identity=!0,this._identityCalculated=!1,this.props=createTypedArray("float32",16),this.reset()}}();function _typeof$3(e){return _typeof$3="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$3(e)}var lottie={},standalone="__[STANDALONE]__",animationData="__[ANIMATIONDATA]__",renderer="";function setLocation(e){setLocationHref(e)}function searchAnimations(){!0===standalone?animationManager.searchAnimations(animationData,standalone,renderer):animationManager.searchAnimations()}function setSubframeRendering(e){setSubframeEnabled(e)}function setPrefix(e){setIdPrefix(e)}function loadAnimation(e){return!0===standalone&&(e.animationData=JSON.parse(animationData)),animationManager.loadAnimation(e)}function setQuality(e){if("string"==typeof e)switch(e){case"high":setDefaultCurveSegments(200);break;default:case"medium":setDefaultCurveSegments(50);break;case"low":setDefaultCurveSegments(10)}else!isNaN(e)&&e>1&&setDefaultCurveSegments(e);getDefaultCurveSegments()>=50?roundValues(!1):roundValues(!0)}function inBrowser(){return"undefined"!=typeof navigator}function installPlugin(e,t){"expressions"===e&&setExpressionsPlugin(t)}function getFactory(e){switch(e){case"propertyFactory":return PropertyFactory;case"shapePropertyFactory":return ShapePropertyFactory;case"matrix":return Matrix;default:return null}}function checkReady(){"complete"===document.readyState&&(clearInterval(readyStateCheckInterval),searchAnimations())}function getQueryVariable(e){for(var t=queryString.split("&"),r=0;r<t.length;r+=1){var n=t[r].split("=");if(decodeURIComponent(n[0])==e)return decodeURIComponent(n[1])}return null}lottie.play=animationManager.play,lottie.pause=animationManager.pause,lottie.setLocationHref=setLocation,lottie.togglePause=animationManager.togglePause,lottie.setSpeed=animationManager.setSpeed,lottie.setDirection=animationManager.setDirection,lottie.stop=animationManager.stop,lottie.searchAnimations=searchAnimations,lottie.registerAnimation=animationManager.registerAnimation,lottie.loadAnimation=loadAnimation,lottie.setSubframeRendering=setSubframeRendering,lottie.resize=animationManager.resize,lottie.goToAndStop=animationManager.goToAndStop,lottie.destroy=animationManager.destroy,lottie.setQuality=setQuality,lottie.inBrowser=inBrowser,lottie.installPlugin=installPlugin,lottie.freeze=animationManager.freeze,lottie.unfreeze=animationManager.unfreeze,lottie.setVolume=animationManager.setVolume,lottie.mute=animationManager.mute,lottie.unmute=animationManager.unmute,lottie.getRegisteredAnimations=animationManager.getRegisteredAnimations,lottie.useWebWorker=setWebWorker,lottie.setIDPrefix=setPrefix,lottie.__getFactory=getFactory,lottie.version="5.12.2";var queryString="";if(standalone){var scripts=document.getElementsByTagName("script"),index=scripts.length-1,myScript=scripts[index]||{src:""};queryString=myScript.src?myScript.src.replace(/^[^\?]+\??/,""):"",renderer=getQueryVariable("renderer")}var readyStateCheckInterval=setInterval(checkReady,100);try{"object"!==_typeof$3(exports)&&__webpack_require__.amdO}catch(e){}var ShapeModifiers=function(){var e={},t={};return e.registerModifier=function(e,r){t[e]||(t[e]=r)},e.getModifier=function(e,r,n){return new t[e](r,n)},e}();function ShapeModifier(){}function TrimModifier(){}function PuckerAndBloatModifier(){}ShapeModifier.prototype.initModifierProperties=function(){},ShapeModifier.prototype.addShapeToModifier=function(){},ShapeModifier.prototype.addShape=function(e){if(!this.closed){e.sh.container.addDynamicProperty(e.sh);var t={shape:e.sh,data:e,localShapeCollection:shapeCollectionPool.newShapeCollection()};this.shapes.push(t),this.addShapeToModifier(t),this._isAnimated&&e.setAsAnimated()}},ShapeModifier.prototype.init=function(e,t){this.shapes=[],this.elem=e,this.initDynamicPropertyContainer(e),this.initModifierProperties(e,t),this.frameId=initialDefaultFrame,this.closed=!1,this.k=!1,this.dynamicProperties.length?this.k=!0:this.getValue(!0)},ShapeModifier.prototype.processKeys=function(){this.elem.globalData.frameId!==this.frameId&&(this.frameId=this.elem.globalData.frameId,this.iterateDynamicProperties())},extendPrototype([DynamicPropertyContainer],ShapeModifier),extendPrototype([ShapeModifier],TrimModifier),TrimModifier.prototype.initModifierProperties=function(e,t){this.s=PropertyFactory.getProp(e,t.s,0,.01,this),this.e=PropertyFactory.getProp(e,t.e,0,.01,this),this.o=PropertyFactory.getProp(e,t.o,0,0,this),this.sValue=0,this.eValue=0,this.getValue=this.processKeys,this.m=t.m,this._isAnimated=!!this.s.effectsSequence.length||!!this.e.effectsSequence.length||!!this.o.effectsSequence.length},TrimModifier.prototype.addShapeToModifier=function(e){e.pathsData=[]},TrimModifier.prototype.calculateShapeEdges=function(e,t,r,n,a){var i=[];t<=1?i.push({s:e,e:t}):e>=1?i.push({s:e-1,e:t-1}):(i.push({s:e,e:1}),i.push({s:0,e:t-1}));var s,o,l=[],u=i.length;for(s=0;s<u;s+=1){var c,h;(o=i[s]).e*a<n||o.s*a>n+r||(c=o.s*a<=n?0:(o.s*a-n)/r,h=o.e*a>=n+r?1:(o.e*a-n)/r,l.push([c,h]))}return l.length||l.push([0,0]),l},TrimModifier.prototype.releasePathsData=function(e){var t,r=e.length;for(t=0;t<r;t+=1)segmentsLengthPool.release(e[t]);return e.length=0,e},TrimModifier.prototype.processShapes=function(e){var t,r,n,a;if(this._mdf||e){var i=this.o.v%360/360;if(i<0&&(i+=1),(t=this.s.v>1?1+i:this.s.v<0?0+i:this.s.v+i)>(r=this.e.v>1?1+i:this.e.v<0?0+i:this.e.v+i)){var s=t;t=r,r=s}t=1e-4*Math.round(1e4*t),r=1e-4*Math.round(1e4*r),this.sValue=t,this.eValue=r}else t=this.sValue,r=this.eValue;var o,l,u,c,h,p=this.shapes.length,f=0;if(r===t)for(a=0;a<p;a+=1)this.shapes[a].localShapeCollection.releaseShapes(),this.shapes[a].shape._mdf=!0,this.shapes[a].shape.paths=this.shapes[a].localShapeCollection,this._mdf&&(this.shapes[a].pathsData.length=0);else if(1===r&&0===t||0===r&&1===t){if(this._mdf)for(a=0;a<p;a+=1)this.shapes[a].pathsData.length=0,this.shapes[a].shape._mdf=!0}else{var d,m,g=[];for(a=0;a<p;a+=1)if((d=this.shapes[a]).shape._mdf||this._mdf||e||2===this.m){if(l=(n=d.shape.paths)._length,h=0,!d.shape._mdf&&d.pathsData.length)h=d.totalShapeLength;else{for(u=this.releasePathsData(d.pathsData),o=0;o<l;o+=1)c=bez.getSegmentsLength(n.shapes[o]),u.push(c),h+=c.totalLength;d.totalShapeLength=h,d.pathsData=u}f+=h,d.shape._mdf=!0}else d.shape.paths=d.localShapeCollection;var y,v=t,b=r,k=0;for(a=p-1;a>=0;a-=1)if((d=this.shapes[a]).shape._mdf){for((m=d.localShapeCollection).releaseShapes(),2===this.m&&p>1?(y=this.calculateShapeEdges(t,r,d.totalShapeLength,k,f),k+=d.totalShapeLength):y=[[v,b]],l=y.length,o=0;o<l;o+=1){v=y[o][0],b=y[o][1],g.length=0,b<=1?g.push({s:d.totalShapeLength*v,e:d.totalShapeLength*b}):v>=1?g.push({s:d.totalShapeLength*(v-1),e:d.totalShapeLength*(b-1)}):(g.push({s:d.totalShapeLength*v,e:d.totalShapeLength}),g.push({s:0,e:d.totalShapeLength*(b-1)}));var x=this.addShapes(d,g[0]);if(g[0].s!==g[0].e){if(g.length>1)if(d.shape.paths.shapes[d.shape.paths._length-1].c){var S=x.pop();this.addPaths(x,m),x=this.addShapes(d,g[1],S)}else this.addPaths(x,m),x=this.addShapes(d,g[1]);this.addPaths(x,m)}}d.shape.paths=m}}},TrimModifier.prototype.addPaths=function(e,t){var r,n=e.length;for(r=0;r<n;r+=1)t.addShape(e[r])},TrimModifier.prototype.addSegment=function(e,t,r,n,a,i,s){a.setXYAt(t[0],t[1],"o",i),a.setXYAt(r[0],r[1],"i",i+1),s&&a.setXYAt(e[0],e[1],"v",i),a.setXYAt(n[0],n[1],"v",i+1)},TrimModifier.prototype.addSegmentFromArray=function(e,t,r,n){t.setXYAt(e[1],e[5],"o",r),t.setXYAt(e[2],e[6],"i",r+1),n&&t.setXYAt(e[0],e[4],"v",r),t.setXYAt(e[3],e[7],"v",r+1)},TrimModifier.prototype.addShapes=function(e,t,r){var n,a,i,s,o,l,u,c,h=e.pathsData,p=e.shape.paths.shapes,f=e.shape.paths._length,d=0,m=[],g=!0;for(r?(o=r._length,c=r._length):(r=shapePool.newElement(),o=0,c=0),m.push(r),n=0;n<f;n+=1){for(l=h[n].lengths,r.c=p[n].c,i=p[n].c?l.length:l.length+1,a=1;a<i;a+=1)if(d+(s=l[a-1]).addedLength<t.s)d+=s.addedLength,r.c=!1;else{if(d>t.e){r.c=!1;break}t.s<=d&&t.e>=d+s.addedLength?(this.addSegment(p[n].v[a-1],p[n].o[a-1],p[n].i[a],p[n].v[a],r,o,g),g=!1):(u=bez.getNewSegment(p[n].v[a-1],p[n].v[a],p[n].o[a-1],p[n].i[a],(t.s-d)/s.addedLength,(t.e-d)/s.addedLength,l[a-1]),this.addSegmentFromArray(u,r,o,g),g=!1,r.c=!1),d+=s.addedLength,o+=1}if(p[n].c&&l.length){if(s=l[a-1],d<=t.e){var y=l[a-1].addedLength;t.s<=d&&t.e>=d+y?(this.addSegment(p[n].v[a-1],p[n].o[a-1],p[n].i[0],p[n].v[0],r,o,g),g=!1):(u=bez.getNewSegment(p[n].v[a-1],p[n].v[0],p[n].o[a-1],p[n].i[0],(t.s-d)/y,(t.e-d)/y,l[a-1]),this.addSegmentFromArray(u,r,o,g),g=!1,r.c=!1)}else r.c=!1;d+=s.addedLength,o+=1}if(r._length&&(r.setXYAt(r.v[c][0],r.v[c][1],"i",c),r.setXYAt(r.v[r._length-1][0],r.v[r._length-1][1],"o",r._length-1)),d>t.e)break;n<f-1&&(r=shapePool.newElement(),g=!0,m.push(r),o=0)}return m},extendPrototype([ShapeModifier],PuckerAndBloatModifier),PuckerAndBloatModifier.prototype.initModifierProperties=function(e,t){this.getValue=this.processKeys,this.amount=PropertyFactory.getProp(e,t.a,0,null,this),this._isAnimated=!!this.amount.effectsSequence.length},PuckerAndBloatModifier.prototype.processPath=function(e,t){var r=t/100,n=[0,0],a=e._length,i=0;for(i=0;i<a;i+=1)n[0]+=e.v[i][0],n[1]+=e.v[i][1];n[0]/=a,n[1]/=a;var s,o,l,u,c,h,p=shapePool.newElement();for(p.c=e.c,i=0;i<a;i+=1)s=e.v[i][0]+(n[0]-e.v[i][0])*r,o=e.v[i][1]+(n[1]-e.v[i][1])*r,l=e.o[i][0]+(n[0]-e.o[i][0])*-r,u=e.o[i][1]+(n[1]-e.o[i][1])*-r,c=e.i[i][0]+(n[0]-e.i[i][0])*-r,h=e.i[i][1]+(n[1]-e.i[i][1])*-r,p.setTripleAt(s,o,l,u,c,h,i);return p},PuckerAndBloatModifier.prototype.processShapes=function(e){var t,r,n,a,i,s,o=this.shapes.length,l=this.amount.v;if(0!==l)for(r=0;r<o;r+=1){if(s=(i=this.shapes[r]).localShapeCollection,i.shape._mdf||this._mdf||e)for(s.releaseShapes(),i.shape._mdf=!0,t=i.shape.paths.shapes,a=i.shape.paths._length,n=0;n<a;n+=1)s.addShape(this.processPath(t[n],l));i.shape.paths=i.localShapeCollection}this.dynamicProperties.length||(this._mdf=!1)};var TransformPropertyFactory=function(){var e=[0,0];function t(e,t,r){if(this.elem=e,this.frameId=-1,this.propType="transform",this.data=t,this.v=new Matrix,this.pre=new Matrix,this.appliedTransformations=0,this.initDynamicPropertyContainer(r||e),t.p&&t.p.s?(this.px=PropertyFactory.getProp(e,t.p.x,0,0,this),this.py=PropertyFactory.getProp(e,t.p.y,0,0,this),t.p.z&&(this.pz=PropertyFactory.getProp(e,t.p.z,0,0,this))):this.p=PropertyFactory.getProp(e,t.p||{k:[0,0,0]},1,0,this),t.rx){if(this.rx=PropertyFactory.getProp(e,t.rx,0,degToRads,this),this.ry=PropertyFactory.getProp(e,t.ry,0,degToRads,this),this.rz=PropertyFactory.getProp(e,t.rz,0,degToRads,this),t.or.k[0].ti){var n,a=t.or.k.length;for(n=0;n<a;n+=1)t.or.k[n].to=null,t.or.k[n].ti=null}this.or=PropertyFactory.getProp(e,t.or,1,degToRads,this),this.or.sh=!0}else this.r=PropertyFactory.getProp(e,t.r||{k:0},0,degToRads,this);t.sk&&(this.sk=PropertyFactory.getProp(e,t.sk,0,degToRads,this),this.sa=PropertyFactory.getProp(e,t.sa,0,degToRads,this)),this.a=PropertyFactory.getProp(e,t.a||{k:[0,0,0]},1,0,this),this.s=PropertyFactory.getProp(e,t.s||{k:[100,100,100]},1,.01,this),t.o?this.o=PropertyFactory.getProp(e,t.o,0,.01,e):this.o={_mdf:!1,v:1},this._isDirty=!0,this.dynamicProperties.length||this.getValue(!0)}return t.prototype={applyToMatrix:function(e){var t=this._mdf;this.iterateDynamicProperties(),this._mdf=this._mdf||t,this.a&&e.translate(-this.a.v[0],-this.a.v[1],this.a.v[2]),this.s&&e.scale(this.s.v[0],this.s.v[1],this.s.v[2]),this.sk&&e.skewFromAxis(-this.sk.v,this.sa.v),this.r?e.rotate(-this.r.v):e.rotateZ(-this.rz.v).rotateY(this.ry.v).rotateX(this.rx.v).rotateZ(-this.or.v[2]).rotateY(this.or.v[1]).rotateX(this.or.v[0]),this.data.p.s?this.data.p.z?e.translate(this.px.v,this.py.v,-this.pz.v):e.translate(this.px.v,this.py.v,0):e.translate(this.p.v[0],this.p.v[1],-this.p.v[2])},getValue:function(t){if(this.elem.globalData.frameId!==this.frameId){if(this._isDirty&&(this.precalculateMatrix(),this._isDirty=!1),this.iterateDynamicProperties(),this._mdf||t){var r;if(this.v.cloneFromProps(this.pre.props),this.appliedTransformations<1&&this.v.translate(-this.a.v[0],-this.a.v[1],this.a.v[2]),this.appliedTransformations<2&&this.v.scale(this.s.v[0],this.s.v[1],this.s.v[2]),this.sk&&this.appliedTransformations<3&&this.v.skewFromAxis(-this.sk.v,this.sa.v),this.r&&this.appliedTransformations<4?this.v.rotate(-this.r.v):!this.r&&this.appliedTransformations<4&&this.v.rotateZ(-this.rz.v).rotateY(this.ry.v).rotateX(this.rx.v).rotateZ(-this.or.v[2]).rotateY(this.or.v[1]).rotateX(this.or.v[0]),this.autoOriented){var n,a;if(r=this.elem.globalData.frameRate,this.p&&this.p.keyframes&&this.p.getValueAtTime)this.p._caching.lastFrame+this.p.offsetTime<=this.p.keyframes[0].t?(n=this.p.getValueAtTime((this.p.keyframes[0].t+.01)/r,0),a=this.p.getValueAtTime(this.p.keyframes[0].t/r,0)):this.p._caching.lastFrame+this.p.offsetTime>=this.p.keyframes[this.p.keyframes.length-1].t?(n=this.p.getValueAtTime(this.p.keyframes[this.p.keyframes.length-1].t/r,0),a=this.p.getValueAtTime((this.p.keyframes[this.p.keyframes.length-1].t-.05)/r,0)):(n=this.p.pv,a=this.p.getValueAtTime((this.p._caching.lastFrame+this.p.offsetTime-.01)/r,this.p.offsetTime));else if(this.px&&this.px.keyframes&&this.py.keyframes&&this.px.getValueAtTime&&this.py.getValueAtTime){n=[],a=[];var i=this.px,s=this.py;i._caching.lastFrame+i.offsetTime<=i.keyframes[0].t?(n[0]=i.getValueAtTime((i.keyframes[0].t+.01)/r,0),n[1]=s.getValueAtTime((s.keyframes[0].t+.01)/r,0),a[0]=i.getValueAtTime(i.keyframes[0].t/r,0),a[1]=s.getValueAtTime(s.keyframes[0].t/r,0)):i._caching.lastFrame+i.offsetTime>=i.keyframes[i.keyframes.length-1].t?(n[0]=i.getValueAtTime(i.keyframes[i.keyframes.length-1].t/r,0),n[1]=s.getValueAtTime(s.keyframes[s.keyframes.length-1].t/r,0),a[0]=i.getValueAtTime((i.keyframes[i.keyframes.length-1].t-.01)/r,0),a[1]=s.getValueAtTime((s.keyframes[s.keyframes.length-1].t-.01)/r,0)):(n=[i.pv,s.pv],a[0]=i.getValueAtTime((i._caching.lastFrame+i.offsetTime-.01)/r,i.offsetTime),a[1]=s.getValueAtTime((s._caching.lastFrame+s.offsetTime-.01)/r,s.offsetTime))}else n=a=e;this.v.rotate(-Math.atan2(n[1]-a[1],n[0]-a[0]))}this.data.p&&this.data.p.s?this.data.p.z?this.v.translate(this.px.v,this.py.v,-this.pz.v):this.v.translate(this.px.v,this.py.v,0):this.v.translate(this.p.v[0],this.p.v[1],-this.p.v[2])}this.frameId=this.elem.globalData.frameId}},precalculateMatrix:function(){if(this.appliedTransformations=0,this.pre.reset(),!this.a.effectsSequence.length&&(this.pre.translate(-this.a.v[0],-this.a.v[1],this.a.v[2]),this.appliedTransformations=1,!this.s.effectsSequence.length)){if(this.pre.scale(this.s.v[0],this.s.v[1],this.s.v[2]),this.appliedTransformations=2,this.sk){if(this.sk.effectsSequence.length||this.sa.effectsSequence.length)return;this.pre.skewFromAxis(-this.sk.v,this.sa.v),this.appliedTransformations=3}this.r?this.r.effectsSequence.length||(this.pre.rotate(-this.r.v),this.appliedTransformations=4):this.rz.effectsSequence.length||this.ry.effectsSequence.length||this.rx.effectsSequence.length||this.or.effectsSequence.length||(this.pre.rotateZ(-this.rz.v).rotateY(this.ry.v).rotateX(this.rx.v).rotateZ(-this.or.v[2]).rotateY(this.or.v[1]).rotateX(this.or.v[0]),this.appliedTransformations=4)}},autoOrient:function(){}},extendPrototype([DynamicPropertyContainer],t),t.prototype.addDynamicProperty=function(e){this._addDynamicProperty(e),this.elem.addDynamicProperty(e),this._isDirty=!0},t.prototype._addDynamicProperty=DynamicPropertyContainer.prototype.addDynamicProperty,{getTransformProperty:function(e,r,n){return new t(e,r,n)}}}();function RepeaterModifier(){}function RoundCornersModifier(){}function floatEqual(e,t){return 1e5*Math.abs(e-t)<=Math.min(Math.abs(e),Math.abs(t))}function floatZero(e){return Math.abs(e)<=1e-5}function lerp(e,t,r){return e*(1-r)+t*r}function lerpPoint(e,t,r){return[lerp(e[0],t[0],r),lerp(e[1],t[1],r)]}function quadRoots(e,t,r){if(0===e)return[];var n=t*t-4*e*r;if(n<0)return[];var a=-t/(2*e);if(0===n)return[a];var i=Math.sqrt(n)/(2*e);return[a-i,a+i]}function polynomialCoefficients(e,t,r,n){return[3*t-e-3*r+n,3*e-6*t+3*r,-3*e+3*t,e]}function singlePoint(e){return new PolynomialBezier(e,e,e,e,!1)}function PolynomialBezier(e,t,r,n,a){a&&pointEqual(e,t)&&(t=lerpPoint(e,n,1/3)),a&&pointEqual(r,n)&&(r=lerpPoint(e,n,2/3));var i=polynomialCoefficients(e[0],t[0],r[0],n[0]),s=polynomialCoefficients(e[1],t[1],r[1],n[1]);this.a=[i[0],s[0]],this.b=[i[1],s[1]],this.c=[i[2],s[2]],this.d=[i[3],s[3]],this.points=[e,t,r,n]}function extrema(e,t){var r=e.points[0][t],n=e.points[e.points.length-1][t];if(r>n){var a=n;n=r,r=a}for(var i=quadRoots(3*e.a[t],2*e.b[t],e.c[t]),s=0;s<i.length;s+=1)if(i[s]>0&&i[s]<1){var o=e.point(i[s])[t];o<r?r=o:o>n&&(n=o)}return{min:r,max:n}}function intersectData(e,t,r){var n=e.boundingBox();return{cx:n.cx,cy:n.cy,width:n.width,height:n.height,bez:e,t:(t+r)/2,t1:t,t2:r}}function splitData(e){var t=e.bez.split(.5);return[intersectData(t[0],e.t1,e.t),intersectData(t[1],e.t,e.t2)]}function boxIntersect(e,t){return 2*Math.abs(e.cx-t.cx)<e.width+t.width&&2*Math.abs(e.cy-t.cy)<e.height+t.height}function intersectsImpl(e,t,r,n,a,i){if(boxIntersect(e,t))if(r>=i||e.width<=n&&e.height<=n&&t.width<=n&&t.height<=n)a.push([e.t,t.t]);else{var s=splitData(e),o=splitData(t);intersectsImpl(s[0],o[0],r+1,n,a,i),intersectsImpl(s[0],o[1],r+1,n,a,i),intersectsImpl(s[1],o[0],r+1,n,a,i),intersectsImpl(s[1],o[1],r+1,n,a,i)}}function crossProduct(e,t){return[e[1]*t[2]-e[2]*t[1],e[2]*t[0]-e[0]*t[2],e[0]*t[1]-e[1]*t[0]]}function lineIntersection(e,t,r,n){var a=[e[0],e[1],1],i=[t[0],t[1],1],s=[r[0],r[1],1],o=[n[0],n[1],1],l=crossProduct(crossProduct(a,i),crossProduct(s,o));return floatZero(l[2])?null:[l[0]/l[2],l[1]/l[2]]}function polarOffset(e,t,r){return[e[0]+Math.cos(t)*r,e[1]-Math.sin(t)*r]}function pointDistance(e,t){return Math.hypot(e[0]-t[0],e[1]-t[1])}function pointEqual(e,t){return floatEqual(e[0],t[0])&&floatEqual(e[1],t[1])}function ZigZagModifier(){}function setPoint(e,t,r,n,a,i,s){var o=r-Math.PI/2,l=r+Math.PI/2,u=t[0]+Math.cos(r)*n*a,c=t[1]-Math.sin(r)*n*a;e.setTripleAt(u,c,u+Math.cos(o)*i,c-Math.sin(o)*i,u+Math.cos(l)*s,c-Math.sin(l)*s,e.length())}function getPerpendicularVector(e,t){var r=[t[0]-e[0],t[1]-e[1]],n=.5*-Math.PI;return[Math.cos(n)*r[0]-Math.sin(n)*r[1],Math.sin(n)*r[0]+Math.cos(n)*r[1]]}function getProjectingAngle(e,t){var r=0===t?e.length()-1:t-1,n=(t+1)%e.length(),a=getPerpendicularVector(e.v[r],e.v[n]);return Math.atan2(0,1)-Math.atan2(a[1],a[0])}function zigZagCorner(e,t,r,n,a,i,s){var o=getProjectingAngle(t,r),l=t.v[r%t._length],u=t.v[0===r?t._length-1:r-1],c=t.v[(r+1)%t._length],h=2===i?Math.sqrt(Math.pow(l[0]-u[0],2)+Math.pow(l[1]-u[1],2)):0,p=2===i?Math.sqrt(Math.pow(l[0]-c[0],2)+Math.pow(l[1]-c[1],2)):0;setPoint(e,t.v[r%t._length],o,s,n,p/(2*(a+1)),h/(2*(a+1)),i)}function zigZagSegment(e,t,r,n,a,i){for(var s=0;s<n;s+=1){var o=(s+1)/(n+1),l=2===a?Math.sqrt(Math.pow(t.points[3][0]-t.points[0][0],2)+Math.pow(t.points[3][1]-t.points[0][1],2)):0,u=t.normalAngle(o);setPoint(e,t.point(o),u,i,r,l/(2*(n+1)),l/(2*(n+1)),a),i=-i}return i}function linearOffset(e,t,r){var n=Math.atan2(t[0]-e[0],t[1]-e[1]);return[polarOffset(e,n,r),polarOffset(t,n,r)]}function offsetSegment(e,t){var r,n,a,i,s,o,l;r=(l=linearOffset(e.points[0],e.points[1],t))[0],n=l[1],a=(l=linearOffset(e.points[1],e.points[2],t))[0],i=l[1],s=(l=linearOffset(e.points[2],e.points[3],t))[0],o=l[1];var u=lineIntersection(r,n,a,i);null===u&&(u=n);var c=lineIntersection(s,o,a,i);return null===c&&(c=s),new PolynomialBezier(r,u,c,o)}function joinLines(e,t,r,n,a){var i=t.points[3],s=r.points[0];if(3===n)return i;if(pointEqual(i,s))return i;if(2===n){var o=-t.tangentAngle(1),l=-r.tangentAngle(0)+Math.PI,u=lineIntersection(i,polarOffset(i,o+Math.PI/2,100),s,polarOffset(s,o+Math.PI/2,100)),c=u?pointDistance(u,i):pointDistance(i,s)/2,h=polarOffset(i,o,2*c*roundCorner);return e.setXYAt(h[0],h[1],"o",e.length()-1),h=polarOffset(s,l,2*c*roundCorner),e.setTripleAt(s[0],s[1],s[0],s[1],h[0],h[1],e.length()),s}var p=lineIntersection(pointEqual(i,t.points[2])?t.points[0]:t.points[2],i,s,pointEqual(s,r.points[1])?r.points[3]:r.points[1]);return p&&pointDistance(p,i)<a?(e.setTripleAt(p[0],p[1],p[0],p[1],p[0],p[1],e.length()),p):i}function getIntersection(e,t){var r=e.intersections(t);return r.length&&floatEqual(r[0][0],1)&&r.shift(),r.length?r[0]:null}function pruneSegmentIntersection(e,t){var r=e.slice(),n=t.slice(),a=getIntersection(e[e.length-1],t[0]);return a&&(r[e.length-1]=e[e.length-1].split(a[0])[0],n[0]=t[0].split(a[1])[1]),e.length>1&&t.length>1&&(a=getIntersection(e[0],t[t.length-1]))?[[e[0].split(a[0])[0]],[t[t.length-1].split(a[1])[1]]]:[r,n]}function pruneIntersections(e){for(var t,r=1;r<e.length;r+=1)t=pruneSegmentIntersection(e[r-1],e[r]),e[r-1]=t[0],e[r]=t[1];return e.length>1&&(t=pruneSegmentIntersection(e[e.length-1],e[0]),e[e.length-1]=t[0],e[0]=t[1]),e}function offsetSegmentSplit(e,t){var r,n,a,i,s=e.inflectionPoints();if(0===s.length)return[offsetSegment(e,t)];if(1===s.length||floatEqual(s[1],1))return r=(a=e.split(s[0]))[0],n=a[1],[offsetSegment(r,t),offsetSegment(n,t)];r=(a=e.split(s[0]))[0];var o=(s[1]-s[0])/(1-s[0]);return i=(a=a[1].split(o))[0],n=a[1],[offsetSegment(r,t),offsetSegment(i,t),offsetSegment(n,t)]}function OffsetPathModifier(){}function getFontProperties(e){for(var t=e.fStyle?e.fStyle.split(" "):[],r="normal",n="normal",a=t.length,i=0;i<a;i+=1)switch(t[i].toLowerCase()){case"italic":n="italic";break;case"bold":r="700";break;case"black":r="900";break;case"medium":r="500";break;case"regular":case"normal":r="400";break;case"light":case"thin":r="200"}return{style:n,weight:e.fWeight||r}}extendPrototype([ShapeModifier],RepeaterModifier),RepeaterModifier.prototype.initModifierProperties=function(e,t){this.getValue=this.processKeys,this.c=PropertyFactory.getProp(e,t.c,0,null,this),this.o=PropertyFactory.getProp(e,t.o,0,null,this),this.tr=TransformPropertyFactory.getTransformProperty(e,t.tr,this),this.so=PropertyFactory.getProp(e,t.tr.so,0,.01,this),this.eo=PropertyFactory.getProp(e,t.tr.eo,0,.01,this),this.data=t,this.dynamicProperties.length||this.getValue(!0),this._isAnimated=!!this.dynamicProperties.length,this.pMatrix=new Matrix,this.rMatrix=new Matrix,this.sMatrix=new Matrix,this.tMatrix=new Matrix,this.matrix=new Matrix},RepeaterModifier.prototype.applyTransforms=function(e,t,r,n,a,i){var s=i?-1:1,o=n.s.v[0]+(1-n.s.v[0])*(1-a),l=n.s.v[1]+(1-n.s.v[1])*(1-a);e.translate(n.p.v[0]*s*a,n.p.v[1]*s*a,n.p.v[2]),t.translate(-n.a.v[0],-n.a.v[1],n.a.v[2]),t.rotate(-n.r.v*s*a),t.translate(n.a.v[0],n.a.v[1],n.a.v[2]),r.translate(-n.a.v[0],-n.a.v[1],n.a.v[2]),r.scale(i?1/o:o,i?1/l:l),r.translate(n.a.v[0],n.a.v[1],n.a.v[2])},RepeaterModifier.prototype.init=function(e,t,r,n){for(this.elem=e,this.arr=t,this.pos=r,this.elemsData=n,this._currentCopies=0,this._elements=[],this._groups=[],this.frameId=-1,this.initDynamicPropertyContainer(e),this.initModifierProperties(e,t[r]);r>0;)r-=1,this._elements.unshift(t[r]);this.dynamicProperties.length?this.k=!0:this.getValue(!0)},RepeaterModifier.prototype.resetElements=function(e){var t,r=e.length;for(t=0;t<r;t+=1)e[t]._processed=!1,"gr"===e[t].ty&&this.resetElements(e[t].it)},RepeaterModifier.prototype.cloneElements=function(e){var t=JSON.parse(JSON.stringify(e));return this.resetElements(t),t},RepeaterModifier.prototype.changeGroupRender=function(e,t){var r,n=e.length;for(r=0;r<n;r+=1)e[r]._render=t,"gr"===e[r].ty&&this.changeGroupRender(e[r].it,t)},RepeaterModifier.prototype.processShapes=function(e){var t,r,n,a,i,s=!1;if(this._mdf||e){var o,l=Math.ceil(this.c.v);if(this._groups.length<l){for(;this._groups.length<l;){var u={it:this.cloneElements(this._elements),ty:"gr"};u.it.push({a:{a:0,ix:1,k:[0,0]},nm:"Transform",o:{a:0,ix:7,k:100},p:{a:0,ix:2,k:[0,0]},r:{a:1,ix:6,k:[{s:0,e:0,t:0},{s:0,e:0,t:1}]},s:{a:0,ix:3,k:[100,100]},sa:{a:0,ix:5,k:0},sk:{a:0,ix:4,k:0},ty:"tr"}),this.arr.splice(0,0,u),this._groups.splice(0,0,u),this._currentCopies+=1}this.elem.reloadShapes(),s=!0}for(i=0,n=0;n<=this._groups.length-1;n+=1){if(o=i<l,this._groups[n]._render=o,this.changeGroupRender(this._groups[n].it,o),!o){var c=this.elemsData[n].it,h=c[c.length-1];0!==h.transform.op.v?(h.transform.op._mdf=!0,h.transform.op.v=0):h.transform.op._mdf=!1}i+=1}this._currentCopies=l;var p=this.o.v,f=p%1,d=p>0?Math.floor(p):Math.ceil(p),m=this.pMatrix.props,g=this.rMatrix.props,y=this.sMatrix.props;this.pMatrix.reset(),this.rMatrix.reset(),this.sMatrix.reset(),this.tMatrix.reset(),this.matrix.reset();var v,b,k=0;if(p>0){for(;k<d;)this.applyTransforms(this.pMatrix,this.rMatrix,this.sMatrix,this.tr,1,!1),k+=1;f&&(this.applyTransforms(this.pMatrix,this.rMatrix,this.sMatrix,this.tr,f,!1),k+=f)}else if(p<0){for(;k>d;)this.applyTransforms(this.pMatrix,this.rMatrix,this.sMatrix,this.tr,1,!0),k-=1;f&&(this.applyTransforms(this.pMatrix,this.rMatrix,this.sMatrix,this.tr,-f,!0),k-=f)}for(n=1===this.data.m?0:this._currentCopies-1,a=1===this.data.m?1:-1,i=this._currentCopies;i;){if(b=(r=(t=this.elemsData[n].it)[t.length-1].transform.mProps.v.props).length,t[t.length-1].transform.mProps._mdf=!0,t[t.length-1].transform.op._mdf=!0,t[t.length-1].transform.op.v=1===this._currentCopies?this.so.v:this.so.v+(this.eo.v-this.so.v)*(n/(this._currentCopies-1)),0!==k){for((0!==n&&1===a||n!==this._currentCopies-1&&-1===a)&&this.applyTransforms(this.pMatrix,this.rMatrix,this.sMatrix,this.tr,1,!1),this.matrix.transform(g[0],g[1],g[2],g[3],g[4],g[5],g[6],g[7],g[8],g[9],g[10],g[11],g[12],g[13],g[14],g[15]),this.matrix.transform(y[0],y[1],y[2],y[3],y[4],y[5],y[6],y[7],y[8],y[9],y[10],y[11],y[12],y[13],y[14],y[15]),this.matrix.transform(m[0],m[1],m[2],m[3],m[4],m[5],m[6],m[7],m[8],m[9],m[10],m[11],m[12],m[13],m[14],m[15]),v=0;v<b;v+=1)r[v]=this.matrix.props[v];this.matrix.reset()}else for(this.matrix.reset(),v=0;v<b;v+=1)r[v]=this.matrix.props[v];k+=1,i-=1,n+=a}}else for(i=this._currentCopies,n=0,a=1;i;)r=(t=this.elemsData[n].it)[t.length-1].transform.mProps.v.props,t[t.length-1].transform.mProps._mdf=!1,t[t.length-1].transform.op._mdf=!1,i-=1,n+=a;return s},RepeaterModifier.prototype.addShape=function(){},extendPrototype([ShapeModifier],RoundCornersModifier),RoundCornersModifier.prototype.initModifierProperties=function(e,t){this.getValue=this.processKeys,this.rd=PropertyFactory.getProp(e,t.r,0,null,this),this._isAnimated=!!this.rd.effectsSequence.length},RoundCornersModifier.prototype.processPath=function(e,t){var r,n=shapePool.newElement();n.c=e.c;var a,i,s,o,l,u,c,h,p,f,d,m,g=e._length,y=0;for(r=0;r<g;r+=1)a=e.v[r],s=e.o[r],i=e.i[r],a[0]===s[0]&&a[1]===s[1]&&a[0]===i[0]&&a[1]===i[1]?0!==r&&r!==g-1||e.c?(o=0===r?e.v[g-1]:e.v[r-1],u=(l=Math.sqrt(Math.pow(a[0]-o[0],2)+Math.pow(a[1]-o[1],2)))?Math.min(l/2,t)/l:0,c=d=a[0]+(o[0]-a[0])*u,h=m=a[1]-(a[1]-o[1])*u,p=c-(c-a[0])*roundCorner,f=h-(h-a[1])*roundCorner,n.setTripleAt(c,h,p,f,d,m,y),y+=1,o=r===g-1?e.v[0]:e.v[r+1],u=(l=Math.sqrt(Math.pow(a[0]-o[0],2)+Math.pow(a[1]-o[1],2)))?Math.min(l/2,t)/l:0,c=p=a[0]+(o[0]-a[0])*u,h=f=a[1]+(o[1]-a[1])*u,d=c-(c-a[0])*roundCorner,m=h-(h-a[1])*roundCorner,n.setTripleAt(c,h,p,f,d,m,y),y+=1):(n.setTripleAt(a[0],a[1],s[0],s[1],i[0],i[1],y),y+=1):(n.setTripleAt(e.v[r][0],e.v[r][1],e.o[r][0],e.o[r][1],e.i[r][0],e.i[r][1],y),y+=1);return n},RoundCornersModifier.prototype.processShapes=function(e){var t,r,n,a,i,s,o=this.shapes.length,l=this.rd.v;if(0!==l)for(r=0;r<o;r+=1){if(s=(i=this.shapes[r]).localShapeCollection,i.shape._mdf||this._mdf||e)for(s.releaseShapes(),i.shape._mdf=!0,t=i.shape.paths.shapes,a=i.shape.paths._length,n=0;n<a;n+=1)s.addShape(this.processPath(t[n],l));i.shape.paths=i.localShapeCollection}this.dynamicProperties.length||(this._mdf=!1)},PolynomialBezier.prototype.point=function(e){return[((this.a[0]*e+this.b[0])*e+this.c[0])*e+this.d[0],((this.a[1]*e+this.b[1])*e+this.c[1])*e+this.d[1]]},PolynomialBezier.prototype.derivative=function(e){return[(3*e*this.a[0]+2*this.b[0])*e+this.c[0],(3*e*this.a[1]+2*this.b[1])*e+this.c[1]]},PolynomialBezier.prototype.tangentAngle=function(e){var t=this.derivative(e);return Math.atan2(t[1],t[0])},PolynomialBezier.prototype.normalAngle=function(e){var t=this.derivative(e);return Math.atan2(t[0],t[1])},PolynomialBezier.prototype.inflectionPoints=function(){var e=this.a[1]*this.b[0]-this.a[0]*this.b[1];if(floatZero(e))return[];var t=-.5*(this.a[1]*this.c[0]-this.a[0]*this.c[1])/e,r=t*t-1/3*(this.b[1]*this.c[0]-this.b[0]*this.c[1])/e;if(r<0)return[];var n=Math.sqrt(r);return floatZero(n)?n>0&&n<1?[t]:[]:[t-n,t+n].filter((function(e){return e>0&&e<1}))},PolynomialBezier.prototype.split=function(e){if(e<=0)return[singlePoint(this.points[0]),this];if(e>=1)return[this,singlePoint(this.points[this.points.length-1])];var t=lerpPoint(this.points[0],this.points[1],e),r=lerpPoint(this.points[1],this.points[2],e),n=lerpPoint(this.points[2],this.points[3],e),a=lerpPoint(t,r,e),i=lerpPoint(r,n,e),s=lerpPoint(a,i,e);return[new PolynomialBezier(this.points[0],t,a,s,!0),new PolynomialBezier(s,i,n,this.points[3],!0)]},PolynomialBezier.prototype.bounds=function(){return{x:extrema(this,0),y:extrema(this,1)}},PolynomialBezier.prototype.boundingBox=function(){var e=this.bounds();return{left:e.x.min,right:e.x.max,top:e.y.min,bottom:e.y.max,width:e.x.max-e.x.min,height:e.y.max-e.y.min,cx:(e.x.max+e.x.min)/2,cy:(e.y.max+e.y.min)/2}},PolynomialBezier.prototype.intersections=function(e,t,r){void 0===t&&(t=2),void 0===r&&(r=7);var n=[];return intersectsImpl(intersectData(this,0,1),intersectData(e,0,1),0,t,n,r),n},PolynomialBezier.shapeSegment=function(e,t){var r=(t+1)%e.length();return new PolynomialBezier(e.v[t],e.o[t],e.i[r],e.v[r],!0)},PolynomialBezier.shapeSegmentInverted=function(e,t){var r=(t+1)%e.length();return new PolynomialBezier(e.v[r],e.i[r],e.o[t],e.v[t],!0)},extendPrototype([ShapeModifier],ZigZagModifier),ZigZagModifier.prototype.initModifierProperties=function(e,t){this.getValue=this.processKeys,this.amplitude=PropertyFactory.getProp(e,t.s,0,null,this),this.frequency=PropertyFactory.getProp(e,t.r,0,null,this),this.pointsType=PropertyFactory.getProp(e,t.pt,0,null,this),this._isAnimated=0!==this.amplitude.effectsSequence.length||0!==this.frequency.effectsSequence.length||0!==this.pointsType.effectsSequence.length},ZigZagModifier.prototype.processPath=function(e,t,r,n){var a=e._length,i=shapePool.newElement();if(i.c=e.c,e.c||(a-=1),0===a)return i;var s=-1,o=PolynomialBezier.shapeSegment(e,0);zigZagCorner(i,e,0,t,r,n,s);for(var l=0;l<a;l+=1)s=zigZagSegment(i,o,t,r,n,-s),o=l!==a-1||e.c?PolynomialBezier.shapeSegment(e,(l+1)%a):null,zigZagCorner(i,e,l+1,t,r,n,s);return i},ZigZagModifier.prototype.processShapes=function(e){var t,r,n,a,i,s,o=this.shapes.length,l=this.amplitude.v,u=Math.max(0,Math.round(this.frequency.v)),c=this.pointsType.v;if(0!==l)for(r=0;r<o;r+=1){if(s=(i=this.shapes[r]).localShapeCollection,i.shape._mdf||this._mdf||e)for(s.releaseShapes(),i.shape._mdf=!0,t=i.shape.paths.shapes,a=i.shape.paths._length,n=0;n<a;n+=1)s.addShape(this.processPath(t[n],l,u,c));i.shape.paths=i.localShapeCollection}this.dynamicProperties.length||(this._mdf=!1)},extendPrototype([ShapeModifier],OffsetPathModifier),OffsetPathModifier.prototype.initModifierProperties=function(e,t){this.getValue=this.processKeys,this.amount=PropertyFactory.getProp(e,t.a,0,null,this),this.miterLimit=PropertyFactory.getProp(e,t.ml,0,null,this),this.lineJoin=t.lj,this._isAnimated=0!==this.amount.effectsSequence.length},OffsetPathModifier.prototype.processPath=function(e,t,r,n){var a=shapePool.newElement();a.c=e.c;var i,s,o,l=e.length();e.c||(l-=1);var u=[];for(i=0;i<l;i+=1)o=PolynomialBezier.shapeSegment(e,i),u.push(offsetSegmentSplit(o,t));if(!e.c)for(i=l-1;i>=0;i-=1)o=PolynomialBezier.shapeSegmentInverted(e,i),u.push(offsetSegmentSplit(o,t));u=pruneIntersections(u);var c=null,h=null;for(i=0;i<u.length;i+=1){var p=u[i];for(h&&(c=joinLines(a,h,p[0],r,n)),h=p[p.length-1],s=0;s<p.length;s+=1)o=p[s],c&&pointEqual(o.points[0],c)?a.setXYAt(o.points[1][0],o.points[1][1],"o",a.length()-1):a.setTripleAt(o.points[0][0],o.points[0][1],o.points[1][0],o.points[1][1],o.points[0][0],o.points[0][1],a.length()),a.setTripleAt(o.points[3][0],o.points[3][1],o.points[3][0],o.points[3][1],o.points[2][0],o.points[2][1],a.length()),c=o.points[3]}return u.length&&joinLines(a,h,u[0][0],r,n),a},OffsetPathModifier.prototype.processShapes=function(e){var t,r,n,a,i,s,o=this.shapes.length,l=this.amount.v,u=this.miterLimit.v,c=this.lineJoin;if(0!==l)for(r=0;r<o;r+=1){if(s=(i=this.shapes[r]).localShapeCollection,i.shape._mdf||this._mdf||e)for(s.releaseShapes(),i.shape._mdf=!0,t=i.shape.paths.shapes,a=i.shape.paths._length,n=0;n<a;n+=1)s.addShape(this.processPath(t[n],l,c,u));i.shape.paths=i.localShapeCollection}this.dynamicProperties.length||(this._mdf=!1)};var FontManager=function(){var e=5e3,t={w:0,size:0,shapes:[],data:{shapes:[]}},r=[];r=r.concat([2304,2305,2306,2307,2362,2363,2364,2364,2366,2367,2368,2369,2370,2371,2372,2373,2374,2375,2376,2377,2378,2379,2380,2381,2382,2383,2387,2388,2389,2390,2391,2402,2403]);var n=127988,a=917631,i=917601,s=917626,o=65039,l=8205,u=127462,c=127487,h=["d83cdffb","d83cdffc","d83cdffd","d83cdffe","d83cdfff"];function p(e,t){var r=createTag("span");r.setAttribute("aria-hidden",!0),r.style.fontFamily=t;var n=createTag("span");n.innerText="giItT1WQy@!-/#",r.style.position="absolute",r.style.left="-10000px",r.style.top="-10000px",r.style.fontSize="300px",r.style.fontVariant="normal",r.style.fontStyle="normal",r.style.fontWeight="normal",r.style.letterSpacing="0",r.appendChild(n),document.body.appendChild(r);var a=n.offsetWidth;return n.style.fontFamily=function(e){var t,r=e.split(","),n=r.length,a=[];for(t=0;t<n;t+=1)"sans-serif"!==r[t]&&"monospace"!==r[t]&&a.push(r[t]);return a.join(",")}(e)+", "+t,{node:n,w:a,parent:r}}function f(e,t){var r,n=document.body&&t?"svg":"canvas",a=getFontProperties(e);if("svg"===n){var i=createNS("text");i.style.fontSize="100px",i.setAttribute("font-family",e.fFamily),i.setAttribute("font-style",a.style),i.setAttribute("font-weight",a.weight),i.textContent="1",e.fClass?(i.style.fontFamily="inherit",i.setAttribute("class",e.fClass)):i.style.fontFamily=e.fFamily,t.appendChild(i),r=i}else{var s=new OffscreenCanvas(500,500).getContext("2d");s.font=a.style+" "+a.weight+" 100px "+e.fFamily,r=s}return{measureText:function(e){return"svg"===n?(r.textContent=e,r.getComputedTextLength()):r.measureText(e).width}}}function d(e){var t=0,r=e.charCodeAt(0);if(r>=55296&&r<=56319){var n=e.charCodeAt(1);n>=56320&&n<=57343&&(t=1024*(r-55296)+n-56320+65536)}return t}function m(e){var t=d(e);return t>=u&&t<=c}var g=function(){this.fonts=[],this.chars=null,this.typekitLoaded=0,this.isLoaded=!1,this._warned=!1,this.initTime=Date.now(),this.setIsLoadedBinded=this.setIsLoaded.bind(this),this.checkLoadedFontsBinded=this.checkLoadedFonts.bind(this)};g.isModifier=function(e,t){var r=e.toString(16)+t.toString(16);return-1!==h.indexOf(r)},g.isZeroWidthJoiner=function(e){return e===l},g.isFlagEmoji=function(e){return m(e.substr(0,2))&&m(e.substr(2,2))},g.isRegionalCode=m,g.isCombinedCharacter=function(e){return-1!==r.indexOf(e)},g.isRegionalFlag=function(e,t){var r=d(e.substr(t,2));if(r!==n)return!1;var o=0;for(t+=2;o<5;){if((r=d(e.substr(t,2)))<i||r>s)return!1;o+=1,t+=2}return d(e.substr(t,2))===a},g.isVariationSelector=function(e){return e===o},g.BLACK_FLAG_CODE_POINT=n;var y={addChars:function(e){if(e){var t;this.chars||(this.chars=[]);var r,n,a=e.length,i=this.chars.length;for(t=0;t<a;t+=1){for(r=0,n=!1;r<i;)this.chars[r].style===e[t].style&&this.chars[r].fFamily===e[t].fFamily&&this.chars[r].ch===e[t].ch&&(n=!0),r+=1;n||(this.chars.push(e[t]),i+=1)}}},addFonts:function(e,t){if(e){if(this.chars)return this.isLoaded=!0,void(this.fonts=e.list);if(!document.body)return this.isLoaded=!0,e.list.forEach((function(e){e.helper=f(e),e.cache={}})),void(this.fonts=e.list);var r,n=e.list,a=n.length,i=a;for(r=0;r<a;r+=1){var s,o,l=!0;if(n[r].loaded=!1,n[r].monoCase=p(n[r].fFamily,"monospace"),n[r].sansCase=p(n[r].fFamily,"sans-serif"),n[r].fPath){if("p"===n[r].fOrigin||3===n[r].origin){if((s=document.querySelectorAll('style[f-forigin="p"][f-family="'+n[r].fFamily+'"], style[f-origin="3"][f-family="'+n[r].fFamily+'"]')).length>0&&(l=!1),l){var u=createTag("style");u.setAttribute("f-forigin",n[r].fOrigin),u.setAttribute("f-origin",n[r].origin),u.setAttribute("f-family",n[r].fFamily),u.type="text/css",u.innerText="@font-face {font-family: "+n[r].fFamily+"; font-style: normal; src: url('"+n[r].fPath+"');}",t.appendChild(u)}}else if("g"===n[r].fOrigin||1===n[r].origin){for(s=document.querySelectorAll('link[f-forigin="g"], link[f-origin="1"]'),o=0;o<s.length;o+=1)-1!==s[o].href.indexOf(n[r].fPath)&&(l=!1);if(l){var c=createTag("link");c.setAttribute("f-forigin",n[r].fOrigin),c.setAttribute("f-origin",n[r].origin),c.type="text/css",c.rel="stylesheet",c.href=n[r].fPath,document.body.appendChild(c)}}else if("t"===n[r].fOrigin||2===n[r].origin){for(s=document.querySelectorAll('script[f-forigin="t"], script[f-origin="2"]'),o=0;o<s.length;o+=1)n[r].fPath===s[o].src&&(l=!1);if(l){var h=createTag("link");h.setAttribute("f-forigin",n[r].fOrigin),h.setAttribute("f-origin",n[r].origin),h.setAttribute("rel","stylesheet"),h.setAttribute("href",n[r].fPath),t.appendChild(h)}}}else n[r].loaded=!0,i-=1;n[r].helper=f(n[r],t),n[r].cache={},this.fonts.push(n[r])}0===i?this.isLoaded=!0:setTimeout(this.checkLoadedFonts.bind(this),100)}else this.isLoaded=!0},getCharData:function(e,r,n){for(var a=0,i=this.chars.length;a<i;){if(this.chars[a].ch===e&&this.chars[a].style===r&&this.chars[a].fFamily===n)return this.chars[a];a+=1}return("string"==typeof e&&13!==e.charCodeAt(0)||!e)&&console&&console.warn&&!this._warned&&(this._warned=!0,console.warn("Missing character from exported characters list: ",e,r,n)),t},getFontByName:function(e){for(var t=0,r=this.fonts.length;t<r;){if(this.fonts[t].fName===e)return this.fonts[t];t+=1}return this.fonts[0]},measureText:function(e,t,r){var n=this.getFontByName(t),a=e;if(!n.cache[a]){var i=n.helper;if(" "===e){var s=i.measureText("|"+e+"|"),o=i.measureText("||");n.cache[a]=(s-o)/100}else n.cache[a]=i.measureText(e)/100}return n.cache[a]*r},checkLoadedFonts:function(){var t,r,n,a=this.fonts.length,i=a;for(t=0;t<a;t+=1)this.fonts[t].loaded?i-=1:"n"===this.fonts[t].fOrigin||0===this.fonts[t].origin?this.fonts[t].loaded=!0:(r=this.fonts[t].monoCase.node,n=this.fonts[t].monoCase.w,r.offsetWidth!==n?(i-=1,this.fonts[t].loaded=!0):(r=this.fonts[t].sansCase.node,n=this.fonts[t].sansCase.w,r.offsetWidth!==n&&(i-=1,this.fonts[t].loaded=!0)),this.fonts[t].loaded&&(this.fonts[t].sansCase.parent.parentNode.removeChild(this.fonts[t].sansCase.parent),this.fonts[t].monoCase.parent.parentNode.removeChild(this.fonts[t].monoCase.parent)));0!==i&&Date.now()-this.initTime<e?setTimeout(this.checkLoadedFontsBinded,20):setTimeout(this.setIsLoadedBinded,10)},setIsLoaded:function(){this.isLoaded=!0}};return g.prototype=y,g}();function SlotManager(e){this.animationData=e}function slotFactory(e){return new SlotManager(e)}function RenderableElement(){}SlotManager.prototype.getProp=function(e){return this.animationData.slots&&this.animationData.slots[e.sid]?Object.assign(e,this.animationData.slots[e.sid].p):e},RenderableElement.prototype={initRenderable:function(){this.isInRange=!1,this.hidden=!1,this.isTransparent=!1,this.renderableComponents=[]},addRenderableComponent:function(e){-1===this.renderableComponents.indexOf(e)&&this.renderableComponents.push(e)},removeRenderableComponent:function(e){-1!==this.renderableComponents.indexOf(e)&&this.renderableComponents.splice(this.renderableComponents.indexOf(e),1)},prepareRenderableFrame:function(e){this.checkLayerLimits(e)},checkTransparency:function(){this.finalTransform.mProp.o.v<=0?!this.isTransparent&&this.globalData.renderConfig.hideOnTransparent&&(this.isTransparent=!0,this.hide()):this.isTransparent&&(this.isTransparent=!1,this.show())},checkLayerLimits:function(e){this.data.ip-this.data.st<=e&&this.data.op-this.data.st>e?!0!==this.isInRange&&(this.globalData._mdf=!0,this._mdf=!0,this.isInRange=!0,this.show()):!1!==this.isInRange&&(this.globalData._mdf=!0,this.isInRange=!1,this.hide())},renderRenderable:function(){var e,t=this.renderableComponents.length;for(e=0;e<t;e+=1)this.renderableComponents[e].renderFrame(this._isFirstFrame)},sourceRectAtTime:function(){return{top:0,left:0,width:100,height:100}},getLayerSize:function(){return 5===this.data.ty?{w:this.data.textData.width,h:this.data.textData.height}:{w:this.data.width,h:this.data.height}}};var getBlendMode=(blendModeEnums={0:"source-over",1:"multiply",2:"screen",3:"overlay",4:"darken",5:"lighten",6:"color-dodge",7:"color-burn",8:"hard-light",9:"soft-light",10:"difference",11:"exclusion",12:"hue",13:"saturation",14:"color",15:"luminosity"},function(e){return blendModeEnums[e]||""}),blendModeEnums;function SliderEffect(e,t,r){this.p=PropertyFactory.getProp(t,e.v,0,0,r)}function AngleEffect(e,t,r){this.p=PropertyFactory.getProp(t,e.v,0,0,r)}function ColorEffect(e,t,r){this.p=PropertyFactory.getProp(t,e.v,1,0,r)}function PointEffect(e,t,r){this.p=PropertyFactory.getProp(t,e.v,1,0,r)}function LayerIndexEffect(e,t,r){this.p=PropertyFactory.getProp(t,e.v,0,0,r)}function MaskIndexEffect(e,t,r){this.p=PropertyFactory.getProp(t,e.v,0,0,r)}function CheckboxEffect(e,t,r){this.p=PropertyFactory.getProp(t,e.v,0,0,r)}function NoValueEffect(){this.p={}}function EffectsManager(e,t){var r,n=e.ef||[];this.effectElements=[];var a,i=n.length;for(r=0;r<i;r+=1)a=new GroupEffect(n[r],t),this.effectElements.push(a)}function GroupEffect(e,t){this.init(e,t)}function BaseElement(){}function FrameElement(){}function FootageElement(e,t,r){this.initFrame(),this.initRenderable(),this.assetData=t.getAssetData(e.refId),this.footageData=t.imageLoader.getAsset(this.assetData),this.initBaseData(e,t,r)}function AudioElement(e,t,r){this.initFrame(),this.initRenderable(),this.assetData=t.getAssetData(e.refId),this.initBaseData(e,t,r),this._isPlaying=!1,this._canPlay=!1;var n=this.globalData.getAssetsPath(this.assetData);this.audio=this.globalData.audioController.createAudio(n),this._currentTime=0,this.globalData.audioController.addAudio(this),this._volumeMultiplier=1,this._volume=1,this._previousVolume=null,this.tm=e.tm?PropertyFactory.getProp(this,e.tm,0,t.frameRate,this):{_placeholder:!0},this.lv=PropertyFactory.getProp(this,e.au&&e.au.lv?e.au.lv:{k:[100]},1,.01,this)}function BaseRenderer(){}extendPrototype([DynamicPropertyContainer],GroupEffect),GroupEffect.prototype.getValue=GroupEffect.prototype.iterateDynamicProperties,GroupEffect.prototype.init=function(e,t){var r;this.data=e,this.effectElements=[],this.initDynamicPropertyContainer(t);var n,a=this.data.ef.length,i=this.data.ef;for(r=0;r<a;r+=1){switch(n=null,i[r].ty){case 0:n=new SliderEffect(i[r],t,this);break;case 1:n=new AngleEffect(i[r],t,this);break;case 2:n=new ColorEffect(i[r],t,this);break;case 3:n=new PointEffect(i[r],t,this);break;case 4:case 7:n=new CheckboxEffect(i[r],t,this);break;case 10:n=new LayerIndexEffect(i[r],t,this);break;case 11:n=new MaskIndexEffect(i[r],t,this);break;case 5:n=new EffectsManager(i[r],t,this);break;default:n=new NoValueEffect(i[r],t,this)}n&&this.effectElements.push(n)}},BaseElement.prototype={checkMasks:function(){if(!this.data.hasMask)return!1;for(var e=0,t=this.data.masksProperties.length;e<t;){if("n"!==this.data.masksProperties[e].mode&&!1!==this.data.masksProperties[e].cl)return!0;e+=1}return!1},initExpressions:function(){var e=getExpressionInterfaces();if(e){var t=e("layer"),r=e("effects"),n=e("shape"),a=e("text"),i=e("comp");this.layerInterface=t(this),this.data.hasMask&&this.maskManager&&this.layerInterface.registerMaskInterface(this.maskManager);var s=r.createEffectsInterface(this,this.layerInterface);this.layerInterface.registerEffectsInterface(s),0===this.data.ty||this.data.xt?this.compInterface=i(this):4===this.data.ty?(this.layerInterface.shapeInterface=n(this.shapesData,this.itemsData,this.layerInterface),this.layerInterface.content=this.layerInterface.shapeInterface):5===this.data.ty&&(this.layerInterface.textInterface=a(this),this.layerInterface.text=this.layerInterface.textInterface)}},setBlendMode:function(){var e=getBlendMode(this.data.bm);(this.baseElement||this.layerElement).style["mix-blend-mode"]=e},initBaseData:function(e,t,r){this.globalData=t,this.comp=r,this.data=e,this.layerId=createElementID(),this.data.sr||(this.data.sr=1),this.effectsManager=new EffectsManager(this.data,this,this.dynamicProperties)},getType:function(){return this.type},sourceRectAtTime:function(){}},FrameElement.prototype={initFrame:function(){this._isFirstFrame=!1,this.dynamicProperties=[],this._mdf=!1},prepareProperties:function(e,t){var r,n=this.dynamicProperties.length;for(r=0;r<n;r+=1)(t||this._isParent&&"transform"===this.dynamicProperties[r].propType)&&(this.dynamicProperties[r].getValue(),this.dynamicProperties[r]._mdf&&(this.globalData._mdf=!0,this._mdf=!0))},addDynamicProperty:function(e){-1===this.dynamicProperties.indexOf(e)&&this.dynamicProperties.push(e)}},FootageElement.prototype.prepareFrame=function(){},extendPrototype([RenderableElement,BaseElement,FrameElement],FootageElement),FootageElement.prototype.getBaseElement=function(){return null},FootageElement.prototype.renderFrame=function(){},FootageElement.prototype.destroy=function(){},FootageElement.prototype.initExpressions=function(){var e=getExpressionInterfaces();if(e){var t=e("footage");this.layerInterface=t(this)}},FootageElement.prototype.getFootageData=function(){return this.footageData},AudioElement.prototype.prepareFrame=function(e){if(this.prepareRenderableFrame(e,!0),this.prepareProperties(e,!0),this.tm._placeholder)this._currentTime=e/this.data.sr;else{var t=this.tm.v;this._currentTime=t}this._volume=this.lv.v[0];var r=this._volume*this._volumeMultiplier;this._previousVolume!==r&&(this._previousVolume=r,this.audio.volume(r))},extendPrototype([RenderableElement,BaseElement,FrameElement],AudioElement),AudioElement.prototype.renderFrame=function(){this.isInRange&&this._canPlay&&(this._isPlaying?(!this.audio.playing()||Math.abs(this._currentTime/this.globalData.frameRate-this.audio.seek())>.1)&&this.audio.seek(this._currentTime/this.globalData.frameRate):(this.audio.play(),this.audio.seek(this._currentTime/this.globalData.frameRate),this._isPlaying=!0))},AudioElement.prototype.show=function(){},AudioElement.prototype.hide=function(){this.audio.pause(),this._isPlaying=!1},AudioElement.prototype.pause=function(){this.audio.pause(),this._isPlaying=!1,this._canPlay=!1},AudioElement.prototype.resume=function(){this._canPlay=!0},AudioElement.prototype.setRate=function(e){this.audio.rate(e)},AudioElement.prototype.volume=function(e){this._volumeMultiplier=e,this._previousVolume=e*this._volume,this.audio.volume(this._previousVolume)},AudioElement.prototype.getBaseElement=function(){return null},AudioElement.prototype.destroy=function(){},AudioElement.prototype.sourceRectAtTime=function(){},AudioElement.prototype.initExpressions=function(){},BaseRenderer.prototype.checkLayers=function(e){var t,r,n=this.layers.length;for(this.completeLayers=!0,t=n-1;t>=0;t-=1)this.elements[t]||(r=this.layers[t]).ip-r.st<=e-this.layers[t].st&&r.op-r.st>e-this.layers[t].st&&this.buildItem(t),this.completeLayers=!!this.elements[t]&&this.completeLayers;this.checkPendingElements()},BaseRenderer.prototype.createItem=function(e){switch(e.ty){case 2:return this.createImage(e);case 0:return this.createComp(e);case 1:return this.createSolid(e);case 3:default:return this.createNull(e);case 4:return this.createShape(e);case 5:return this.createText(e);case 6:return this.createAudio(e);case 13:return this.createCamera(e);case 15:return this.createFootage(e)}},BaseRenderer.prototype.createCamera=function(){throw new Error("You're using a 3d camera. Try the html renderer.")},BaseRenderer.prototype.createAudio=function(e){return new AudioElement(e,this.globalData,this)},BaseRenderer.prototype.createFootage=function(e){return new FootageElement(e,this.globalData,this)},BaseRenderer.prototype.buildAllItems=function(){var e,t=this.layers.length;for(e=0;e<t;e+=1)this.buildItem(e);this.checkPendingElements()},BaseRenderer.prototype.includeLayers=function(e){var t;this.completeLayers=!1;var r,n=e.length,a=this.layers.length;for(t=0;t<n;t+=1)for(r=0;r<a;){if(this.layers[r].id===e[t].id){this.layers[r]=e[t];break}r+=1}},BaseRenderer.prototype.setProjectInterface=function(e){this.globalData.projectInterface=e},BaseRenderer.prototype.initItems=function(){this.globalData.progressiveLoad||this.buildAllItems()},BaseRenderer.prototype.buildElementParenting=function(e,t,r){for(var n=this.elements,a=this.layers,i=0,s=a.length;i<s;)a[i].ind==t&&(n[i]&&!0!==n[i]?(r.push(n[i]),n[i].setAsParent(),void 0!==a[i].parent?this.buildElementParenting(e,a[i].parent,r):e.setHierarchy(r)):(this.buildItem(i),this.addPendingElement(e))),i+=1},BaseRenderer.prototype.addPendingElement=function(e){this.pendingElements.push(e)},BaseRenderer.prototype.searchExtraCompositions=function(e){var t,r=e.length;for(t=0;t<r;t+=1)if(e[t].xt){var n=this.createComp(e[t]);n.initExpressions(),this.globalData.projectInterface.registerComposition(n)}},BaseRenderer.prototype.getElementById=function(e){var t,r=this.elements.length;for(t=0;t<r;t+=1)if(this.elements[t].data.ind===e)return this.elements[t];return null},BaseRenderer.prototype.getElementByPath=function(e){var t,r=e.shift();if("number"==typeof r)t=this.elements[r];else{var n,a=this.elements.length;for(n=0;n<a;n+=1)if(this.elements[n].data.nm===r){t=this.elements[n];break}}return 0===e.length?t:t.getElementByPath(e)},BaseRenderer.prototype.setupGlobalData=function(e,t){this.globalData.fontManager=new FontManager,this.globalData.slotManager=slotFactory(e),this.globalData.fontManager.addChars(e.chars),this.globalData.fontManager.addFonts(e.fonts,t),this.globalData.getAssetData=this.animationItem.getAssetData.bind(this.animationItem),this.globalData.getAssetsPath=this.animationItem.getAssetsPath.bind(this.animationItem),this.globalData.imageLoader=this.animationItem.imagePreloader,this.globalData.audioController=this.animationItem.audioController,this.globalData.frameId=0,this.globalData.frameRate=e.fr,this.globalData.nm=e.nm,this.globalData.compSize={w:e.w,h:e.h}};var effectTypes={TRANSFORM_EFFECT:"transformEFfect"};function TransformElement(){}function MaskElement(e,t,r){this.data=e,this.element=t,this.globalData=r,this.storedData=[],this.masksProperties=this.data.masksProperties||[],this.maskElement=null;var n,a,i=this.globalData.defs,s=this.masksProperties?this.masksProperties.length:0;this.viewData=createSizedArray(s),this.solidPath="";var o,l,u,c,h,p,f=this.masksProperties,d=0,m=[],g=createElementID(),y="clipPath",v="clip-path";for(n=0;n<s;n+=1)if(("a"!==f[n].mode&&"n"!==f[n].mode||f[n].inv||100!==f[n].o.k||f[n].o.x)&&(y="mask",v="mask"),"s"!==f[n].mode&&"i"!==f[n].mode||0!==d?u=null:((u=createNS("rect")).setAttribute("fill","#ffffff"),u.setAttribute("width",this.element.comp.data.w||0),u.setAttribute("height",this.element.comp.data.h||0),m.push(u)),a=createNS("path"),"n"===f[n].mode)this.viewData[n]={op:PropertyFactory.getProp(this.element,f[n].o,0,.01,this.element),prop:ShapePropertyFactory.getShapeProp(this.element,f[n],3),elem:a,lastPath:""},i.appendChild(a);else{var b;if(d+=1,a.setAttribute("fill","s"===f[n].mode?"#000000":"#ffffff"),a.setAttribute("clip-rule","nonzero"),0!==f[n].x.k?(y="mask",v="mask",p=PropertyFactory.getProp(this.element,f[n].x,0,null,this.element),b=createElementID(),(c=createNS("filter")).setAttribute("id",b),(h=createNS("feMorphology")).setAttribute("operator","erode"),h.setAttribute("in","SourceGraphic"),h.setAttribute("radius","0"),c.appendChild(h),i.appendChild(c),a.setAttribute("stroke","s"===f[n].mode?"#000000":"#ffffff")):(h=null,p=null),this.storedData[n]={elem:a,x:p,expan:h,lastPath:"",lastOperator:"",filterId:b,lastRadius:0},"i"===f[n].mode){l=m.length;var k=createNS("g");for(o=0;o<l;o+=1)k.appendChild(m[o]);var x=createNS("mask");x.setAttribute("mask-type","alpha"),x.setAttribute("id",g+"_"+d),x.appendChild(a),i.appendChild(x),k.setAttribute("mask","url("+getLocationHref()+"#"+g+"_"+d+")"),m.length=0,m.push(k)}else m.push(a);f[n].inv&&!this.solidPath&&(this.solidPath=this.createLayerSolidPath()),this.viewData[n]={elem:a,lastPath:"",op:PropertyFactory.getProp(this.element,f[n].o,0,.01,this.element),prop:ShapePropertyFactory.getShapeProp(this.element,f[n],3),invRect:u},this.viewData[n].prop.k||this.drawPath(f[n],this.viewData[n].prop.v,this.viewData[n])}for(this.maskElement=createNS(y),s=m.length,n=0;n<s;n+=1)this.maskElement.appendChild(m[n]);d>0&&(this.maskElement.setAttribute("id",g),this.element.maskedElement.setAttribute(v,"url("+getLocationHref()+"#"+g+")"),i.appendChild(this.maskElement)),this.viewData.length&&this.element.addRenderableComponent(this)}TransformElement.prototype={initTransform:function(){var e=new Matrix;this.finalTransform={mProp:this.data.ks?TransformPropertyFactory.getTransformProperty(this,this.data.ks,this):{o:0},_matMdf:!1,_localMatMdf:!1,_opMdf:!1,mat:e,localMat:e,localOpacity:1},this.data.ao&&(this.finalTransform.mProp.autoOriented=!0),this.data.ty},renderTransform:function(){if(this.finalTransform._opMdf=this.finalTransform.mProp.o._mdf||this._isFirstFrame,this.finalTransform._matMdf=this.finalTransform.mProp._mdf||this._isFirstFrame,this.hierarchy){var e,t=this.finalTransform.mat,r=0,n=this.hierarchy.length;if(!this.finalTransform._matMdf)for(;r<n;){if(this.hierarchy[r].finalTransform.mProp._mdf){this.finalTransform._matMdf=!0;break}r+=1}if(this.finalTransform._matMdf)for(e=this.finalTransform.mProp.v.props,t.cloneFromProps(e),r=0;r<n;r+=1)t.multiply(this.hierarchy[r].finalTransform.mProp.v)}this.finalTransform._matMdf&&(this.finalTransform._localMatMdf=this.finalTransform._matMdf),this.finalTransform._opMdf&&(this.finalTransform.localOpacity=this.finalTransform.mProp.o.v)},renderLocalTransform:function(){if(this.localTransforms){var e=0,t=this.localTransforms.length;if(this.finalTransform._localMatMdf=this.finalTransform._matMdf,!this.finalTransform._localMatMdf||!this.finalTransform._opMdf)for(;e<t;)this.localTransforms[e]._mdf&&(this.finalTransform._localMatMdf=!0),this.localTransforms[e]._opMdf&&!this.finalTransform._opMdf&&(this.finalTransform.localOpacity=this.finalTransform.mProp.o.v,this.finalTransform._opMdf=!0),e+=1;if(this.finalTransform._localMatMdf){var r=this.finalTransform.localMat;for(this.localTransforms[0].matrix.clone(r),e=1;e<t;e+=1){var n=this.localTransforms[e].matrix;r.multiply(n)}r.multiply(this.finalTransform.mat)}if(this.finalTransform._opMdf){var a=this.finalTransform.localOpacity;for(e=0;e<t;e+=1)a*=.01*this.localTransforms[e].opacity;this.finalTransform.localOpacity=a}}},searchEffectTransforms:function(){if(this.renderableEffectsManager){var e=this.renderableEffectsManager.getEffects(effectTypes.TRANSFORM_EFFECT);if(e.length){this.localTransforms=[],this.finalTransform.localMat=new Matrix;var t=0,r=e.length;for(t=0;t<r;t+=1)this.localTransforms.push(e[t])}}},globalToLocal:function(e){var t=[];t.push(this.finalTransform);for(var r,n=!0,a=this.comp;n;)a.finalTransform?(a.data.hasMask&&t.splice(0,0,a.finalTransform),a=a.comp):n=!1;var i,s=t.length;for(r=0;r<s;r+=1)i=t[r].mat.applyToPointArray(0,0,0),e=[e[0]-i[0],e[1]-i[1],0];return e},mHelper:new Matrix},MaskElement.prototype.getMaskProperty=function(e){return this.viewData[e].prop},MaskElement.prototype.renderFrame=function(e){var t,r=this.element.finalTransform.mat,n=this.masksProperties.length;for(t=0;t<n;t+=1)if((this.viewData[t].prop._mdf||e)&&this.drawPath(this.masksProperties[t],this.viewData[t].prop.v,this.viewData[t]),(this.viewData[t].op._mdf||e)&&this.viewData[t].elem.setAttribute("fill-opacity",this.viewData[t].op.v),"n"!==this.masksProperties[t].mode&&(this.viewData[t].invRect&&(this.element.finalTransform.mProp._mdf||e)&&this.viewData[t].invRect.setAttribute("transform",r.getInverseMatrix().to2dCSS()),this.storedData[t].x&&(this.storedData[t].x._mdf||e))){var a=this.storedData[t].expan;this.storedData[t].x.v<0?("erode"!==this.storedData[t].lastOperator&&(this.storedData[t].lastOperator="erode",this.storedData[t].elem.setAttribute("filter","url("+getLocationHref()+"#"+this.storedData[t].filterId+")")),a.setAttribute("radius",-this.storedData[t].x.v)):("dilate"!==this.storedData[t].lastOperator&&(this.storedData[t].lastOperator="dilate",this.storedData[t].elem.setAttribute("filter",null)),this.storedData[t].elem.setAttribute("stroke-width",2*this.storedData[t].x.v))}},MaskElement.prototype.getMaskelement=function(){return this.maskElement},MaskElement.prototype.createLayerSolidPath=function(){var e="M0,0 ";return e+=" h"+this.globalData.compSize.w,e+=" v"+this.globalData.compSize.h,e+=" h-"+this.globalData.compSize.w,e+=" v-"+this.globalData.compSize.h+" "},MaskElement.prototype.drawPath=function(e,t,r){var n,a,i=" M"+t.v[0][0]+","+t.v[0][1];for(a=t._length,n=1;n<a;n+=1)i+=" C"+t.o[n-1][0]+","+t.o[n-1][1]+" "+t.i[n][0]+","+t.i[n][1]+" "+t.v[n][0]+","+t.v[n][1];if(t.c&&a>1&&(i+=" C"+t.o[n-1][0]+","+t.o[n-1][1]+" "+t.i[0][0]+","+t.i[0][1]+" "+t.v[0][0]+","+t.v[0][1]),r.lastPath!==i){var s="";r.elem&&(t.c&&(s=e.inv?this.solidPath+i:i),r.elem.setAttribute("d",s)),r.lastPath=i}},MaskElement.prototype.destroy=function(){this.element=null,this.globalData=null,this.maskElement=null,this.data=null,this.masksProperties=null};var filtersFactory=function(){var e={createFilter:function(e,t){var r=createNS("filter");return r.setAttribute("id",e),!0!==t&&(r.setAttribute("filterUnits","objectBoundingBox"),r.setAttribute("x","0%"),r.setAttribute("y","0%"),r.setAttribute("width","100%"),r.setAttribute("height","100%")),r},createAlphaToLuminanceFilter:function(){var e=createNS("feColorMatrix");return e.setAttribute("type","matrix"),e.setAttribute("color-interpolation-filters","sRGB"),e.setAttribute("values","0 0 0 1 0  0 0 0 1 0  0 0 0 1 0  0 0 0 1 1"),e}};return e}(),featureSupport=function(){var e={maskType:!0,svgLumaHidden:!0,offscreenCanvas:"undefined"!=typeof OffscreenCanvas};return(/MSIE 10/i.test(navigator.userAgent)||/MSIE 9/i.test(navigator.userAgent)||/rv:11.0/i.test(navigator.userAgent)||/Edge\/\d./i.test(navigator.userAgent))&&(e.maskType=!1),/firefox/i.test(navigator.userAgent)&&(e.svgLumaHidden=!1),e}(),registeredEffects$1={},idPrefix="filter_result_";function SVGEffects(e){var t,r,n="SourceGraphic",a=e.data.ef?e.data.ef.length:0,i=createElementID(),s=filtersFactory.createFilter(i,!0),o=0;for(this.filters=[],t=0;t<a;t+=1){r=null;var l=e.data.ef[t].ty;registeredEffects$1[l]&&(r=new(0,registeredEffects$1[l].effect)(s,e.effectsManager.effectElements[t],e,idPrefix+o,n),n=idPrefix+o,registeredEffects$1[l].countsAsEffect&&(o+=1)),r&&this.filters.push(r)}o&&(e.globalData.defs.appendChild(s),e.layerElement.setAttribute("filter","url("+getLocationHref()+"#"+i+")")),this.filters.length&&e.addRenderableComponent(this)}function registerEffect$1(e,t,r){registeredEffects$1[e]={effect:t,countsAsEffect:r}}function SVGBaseElement(){}function HierarchyElement(){}function RenderableDOMElement(){}function IImageElement(e,t,r){this.assetData=t.getAssetData(e.refId),this.assetData&&this.assetData.sid&&(this.assetData=t.slotManager.getProp(this.assetData)),this.initElement(e,t,r),this.sourceRect={top:0,left:0,width:this.assetData.w,height:this.assetData.h}}function ProcessedElement(e,t){this.elem=e,this.pos=t}function IShapeElement(){}SVGEffects.prototype.renderFrame=function(e){var t,r=this.filters.length;for(t=0;t<r;t+=1)this.filters[t].renderFrame(e)},SVGEffects.prototype.getEffects=function(e){var t,r=this.filters.length,n=[];for(t=0;t<r;t+=1)this.filters[t].type===e&&n.push(this.filters[t]);return n},SVGBaseElement.prototype={initRendererElement:function(){this.layerElement=createNS("g")},createContainerElements:function(){this.matteElement=createNS("g"),this.transformedElement=this.layerElement,this.maskedElement=this.layerElement,this._sizeChanged=!1;var e=null;if(this.data.td){this.matteMasks={};var t=createNS("g");t.setAttribute("id",this.layerId),t.appendChild(this.layerElement),e=t,this.globalData.defs.appendChild(t)}else this.data.tt?(this.matteElement.appendChild(this.layerElement),e=this.matteElement,this.baseElement=this.matteElement):this.baseElement=this.layerElement;if(this.data.ln&&this.layerElement.setAttribute("id",this.data.ln),this.data.cl&&this.layerElement.setAttribute("class",this.data.cl),0===this.data.ty&&!this.data.hd){var r=createNS("clipPath"),n=createNS("path");n.setAttribute("d","M0,0 L"+this.data.w+",0 L"+this.data.w+","+this.data.h+" L0,"+this.data.h+"z");var a=createElementID();if(r.setAttribute("id",a),r.appendChild(n),this.globalData.defs.appendChild(r),this.checkMasks()){var i=createNS("g");i.setAttribute("clip-path","url("+getLocationHref()+"#"+a+")"),i.appendChild(this.layerElement),this.transformedElement=i,e?e.appendChild(this.transformedElement):this.baseElement=this.transformedElement}else this.layerElement.setAttribute("clip-path","url("+getLocationHref()+"#"+a+")")}0!==this.data.bm&&this.setBlendMode()},renderElement:function(){this.finalTransform._localMatMdf&&this.transformedElement.setAttribute("transform",this.finalTransform.localMat.to2dCSS()),this.finalTransform._opMdf&&this.transformedElement.setAttribute("opacity",this.finalTransform.localOpacity)},destroyBaseElement:function(){this.layerElement=null,this.matteElement=null,this.maskManager.destroy()},getBaseElement:function(){return this.data.hd?null:this.baseElement},createRenderableComponents:function(){this.maskManager=new MaskElement(this.data,this,this.globalData),this.renderableEffectsManager=new SVGEffects(this),this.searchEffectTransforms()},getMatte:function(e){if(this.matteMasks||(this.matteMasks={}),!this.matteMasks[e]){var t,r,n,a,i=this.layerId+"_"+e;if(1===e||3===e){var s=createNS("mask");s.setAttribute("id",i),s.setAttribute("mask-type",3===e?"luminance":"alpha"),(n=createNS("use")).setAttributeNS("http://www.w3.org/1999/xlink","href","#"+this.layerId),s.appendChild(n),this.globalData.defs.appendChild(s),featureSupport.maskType||1!==e||(s.setAttribute("mask-type","luminance"),t=createElementID(),r=filtersFactory.createFilter(t),this.globalData.defs.appendChild(r),r.appendChild(filtersFactory.createAlphaToLuminanceFilter()),(a=createNS("g")).appendChild(n),s.appendChild(a),a.setAttribute("filter","url("+getLocationHref()+"#"+t+")"))}else if(2===e){var o=createNS("mask");o.setAttribute("id",i),o.setAttribute("mask-type","alpha");var l=createNS("g");o.appendChild(l),t=createElementID(),r=filtersFactory.createFilter(t);var u=createNS("feComponentTransfer");u.setAttribute("in","SourceGraphic"),r.appendChild(u);var c=createNS("feFuncA");c.setAttribute("type","table"),c.setAttribute("tableValues","1.0 0.0"),u.appendChild(c),this.globalData.defs.appendChild(r);var h=createNS("rect");h.setAttribute("width",this.comp.data.w),h.setAttribute("height",this.comp.data.h),h.setAttribute("x","0"),h.setAttribute("y","0"),h.setAttribute("fill","#ffffff"),h.setAttribute("opacity","0"),l.setAttribute("filter","url("+getLocationHref()+"#"+t+")"),l.appendChild(h),(n=createNS("use")).setAttributeNS("http://www.w3.org/1999/xlink","href","#"+this.layerId),l.appendChild(n),featureSupport.maskType||(o.setAttribute("mask-type","luminance"),r.appendChild(filtersFactory.createAlphaToLuminanceFilter()),a=createNS("g"),l.appendChild(h),a.appendChild(this.layerElement),l.appendChild(a)),this.globalData.defs.appendChild(o)}this.matteMasks[e]=i}return this.matteMasks[e]},setMatte:function(e){this.matteElement&&this.matteElement.setAttribute("mask","url("+getLocationHref()+"#"+e+")")}},HierarchyElement.prototype={initHierarchy:function(){this.hierarchy=[],this._isParent=!1,this.checkParenting()},setHierarchy:function(e){this.hierarchy=e},setAsParent:function(){this._isParent=!0},checkParenting:function(){void 0!==this.data.parent&&this.comp.buildElementParenting(this,this.data.parent,[])}},extendPrototype([RenderableElement,createProxyFunction({initElement:function(e,t,r){this.initFrame(),this.initBaseData(e,t,r),this.initTransform(e,t,r),this.initHierarchy(),this.initRenderable(),this.initRendererElement(),this.createContainerElements(),this.createRenderableComponents(),this.createContent(),this.hide()},hide:function(){this.hidden||this.isInRange&&!this.isTransparent||((this.baseElement||this.layerElement).style.display="none",this.hidden=!0)},show:function(){this.isInRange&&!this.isTransparent&&(this.data.hd||((this.baseElement||this.layerElement).style.display="block"),this.hidden=!1,this._isFirstFrame=!0)},renderFrame:function(){this.data.hd||this.hidden||(this.renderTransform(),this.renderRenderable(),this.renderLocalTransform(),this.renderElement(),this.renderInnerContent(),this._isFirstFrame&&(this._isFirstFrame=!1))},renderInnerContent:function(){},prepareFrame:function(e){this._mdf=!1,this.prepareRenderableFrame(e),this.prepareProperties(e,this.isInRange),this.checkTransparency()},destroy:function(){this.innerElem=null,this.destroyBaseElement()}})],RenderableDOMElement),extendPrototype([BaseElement,TransformElement,SVGBaseElement,HierarchyElement,FrameElement,RenderableDOMElement],IImageElement),IImageElement.prototype.createContent=function(){var e=this.globalData.getAssetsPath(this.assetData);this.innerElem=createNS("image"),this.innerElem.setAttribute("width",this.assetData.w+"px"),this.innerElem.setAttribute("height",this.assetData.h+"px"),this.innerElem.setAttribute("preserveAspectRatio",this.assetData.pr||this.globalData.renderConfig.imagePreserveAspectRatio),this.innerElem.setAttributeNS("http://www.w3.org/1999/xlink","href",e),this.layerElement.appendChild(this.innerElem)},IImageElement.prototype.sourceRectAtTime=function(){return this.sourceRect},IShapeElement.prototype={addShapeToModifiers:function(e){var t,r=this.shapeModifiers.length;for(t=0;t<r;t+=1)this.shapeModifiers[t].addShape(e)},isShapeInAnimatedModifiers:function(e){for(var t=this.shapeModifiers.length;0<t;)if(this.shapeModifiers[0].isAnimatedWithShape(e))return!0;return!1},renderModifiers:function(){if(this.shapeModifiers.length){var e,t=this.shapes.length;for(e=0;e<t;e+=1)this.shapes[e].sh.reset();for(e=(t=this.shapeModifiers.length)-1;e>=0&&!this.shapeModifiers[e].processShapes(this._isFirstFrame);e-=1);}},searchProcessedElement:function(e){for(var t=this.processedElements,r=0,n=t.length;r<n;){if(t[r].elem===e)return t[r].pos;r+=1}return 0},addProcessedElement:function(e,t){for(var r=this.processedElements,n=r.length;n;)if(r[n-=1].elem===e)return void(r[n].pos=t);r.push(new ProcessedElement(e,t))},prepareFrame:function(e){this.prepareRenderableFrame(e),this.prepareProperties(e,this.isInRange)}};var lineCapEnum={1:"butt",2:"round",3:"square"},lineJoinEnum={1:"miter",2:"round",3:"bevel"};function SVGShapeData(e,t,r){this.caches=[],this.styles=[],this.transformers=e,this.lStr="",this.sh=r,this.lvl=t,this._isAnimated=!!r.k;for(var n=0,a=e.length;n<a;){if(e[n].mProps.dynamicProperties.length){this._isAnimated=!0;break}n+=1}}function SVGStyleData(e,t){this.data=e,this.type=e.ty,this.d="",this.lvl=t,this._mdf=!1,this.closed=!0===e.hd,this.pElem=createNS("path"),this.msElem=null}function DashProperty(e,t,r,n){var a;this.elem=e,this.frameId=-1,this.dataProps=createSizedArray(t.length),this.renderer=r,this.k=!1,this.dashStr="",this.dashArray=createTypedArray("float32",t.length?t.length-1:0),this.dashoffset=createTypedArray("float32",1),this.initDynamicPropertyContainer(n);var i,s=t.length||0;for(a=0;a<s;a+=1)i=PropertyFactory.getProp(e,t[a].v,0,0,this),this.k=i.k||this.k,this.dataProps[a]={n:t[a].n,p:i};this.k||this.getValue(!0),this._isAnimated=this.k}function SVGStrokeStyleData(e,t,r){this.initDynamicPropertyContainer(e),this.getValue=this.iterateDynamicProperties,this.o=PropertyFactory.getProp(e,t.o,0,.01,this),this.w=PropertyFactory.getProp(e,t.w,0,null,this),this.d=new DashProperty(e,t.d||{},"svg",this),this.c=PropertyFactory.getProp(e,t.c,1,255,this),this.style=r,this._isAnimated=!!this._isAnimated}function SVGFillStyleData(e,t,r){this.initDynamicPropertyContainer(e),this.getValue=this.iterateDynamicProperties,this.o=PropertyFactory.getProp(e,t.o,0,.01,this),this.c=PropertyFactory.getProp(e,t.c,1,255,this),this.style=r}function SVGNoStyleData(e,t,r){this.initDynamicPropertyContainer(e),this.getValue=this.iterateDynamicProperties,this.style=r}function GradientProperty(e,t,r){this.data=t,this.c=createTypedArray("uint8c",4*t.p);var n=t.k.k[0].s?t.k.k[0].s.length-4*t.p:t.k.k.length-4*t.p;this.o=createTypedArray("float32",n),this._cmdf=!1,this._omdf=!1,this._collapsable=this.checkCollapsable(),this._hasOpacity=n,this.initDynamicPropertyContainer(r),this.prop=PropertyFactory.getProp(e,t.k,1,null,this),this.k=this.prop.k,this.getValue(!0)}function SVGGradientFillStyleData(e,t,r){this.initDynamicPropertyContainer(e),this.getValue=this.iterateDynamicProperties,this.initGradientData(e,t,r)}function SVGGradientStrokeStyleData(e,t,r){this.initDynamicPropertyContainer(e),this.getValue=this.iterateDynamicProperties,this.w=PropertyFactory.getProp(e,t.w,0,null,this),this.d=new DashProperty(e,t.d||{},"svg",this),this.initGradientData(e,t,r),this._isAnimated=!!this._isAnimated}function ShapeGroupData(){this.it=[],this.prevViewData=[],this.gr=createNS("g")}function SVGTransformData(e,t,r){this.transform={mProps:e,op:t,container:r},this.elements=[],this._isAnimated=this.transform.mProps.dynamicProperties.length||this.transform.op.effectsSequence.length}SVGShapeData.prototype.setAsAnimated=function(){this._isAnimated=!0},SVGStyleData.prototype.reset=function(){this.d="",this._mdf=!1},DashProperty.prototype.getValue=function(e){if((this.elem.globalData.frameId!==this.frameId||e)&&(this.frameId=this.elem.globalData.frameId,this.iterateDynamicProperties(),this._mdf=this._mdf||e,this._mdf)){var t=0,r=this.dataProps.length;for("svg"===this.renderer&&(this.dashStr=""),t=0;t<r;t+=1)"o"!==this.dataProps[t].n?"svg"===this.renderer?this.dashStr+=" "+this.dataProps[t].p.v:this.dashArray[t]=this.dataProps[t].p.v:this.dashoffset[0]=this.dataProps[t].p.v}},extendPrototype([DynamicPropertyContainer],DashProperty),extendPrototype([DynamicPropertyContainer],SVGStrokeStyleData),extendPrototype([DynamicPropertyContainer],SVGFillStyleData),extendPrototype([DynamicPropertyContainer],SVGNoStyleData),GradientProperty.prototype.comparePoints=function(e,t){for(var r=0,n=this.o.length/2;r<n;){if(Math.abs(e[4*r]-e[4*t+2*r])>.01)return!1;r+=1}return!0},GradientProperty.prototype.checkCollapsable=function(){if(this.o.length/2!=this.c.length/4)return!1;if(this.data.k.k[0].s)for(var e=0,t=this.data.k.k.length;e<t;){if(!this.comparePoints(this.data.k.k[e].s,this.data.p))return!1;e+=1}else if(!this.comparePoints(this.data.k.k,this.data.p))return!1;return!0},GradientProperty.prototype.getValue=function(e){if(this.prop.getValue(),this._mdf=!1,this._cmdf=!1,this._omdf=!1,this.prop._mdf||e){var t,r,n,a=4*this.data.p;for(t=0;t<a;t+=1)r=t%4==0?100:255,n=Math.round(this.prop.v[t]*r),this.c[t]!==n&&(this.c[t]=n,this._cmdf=!e);if(this.o.length)for(a=this.prop.v.length,t=4*this.data.p;t<a;t+=1)r=t%2==0?100:1,n=t%2==0?Math.round(100*this.prop.v[t]):this.prop.v[t],this.o[t-4*this.data.p]!==n&&(this.o[t-4*this.data.p]=n,this._omdf=!e);this._mdf=!e}},extendPrototype([DynamicPropertyContainer],GradientProperty),SVGGradientFillStyleData.prototype.initGradientData=function(e,t,r){this.o=PropertyFactory.getProp(e,t.o,0,.01,this),this.s=PropertyFactory.getProp(e,t.s,1,null,this),this.e=PropertyFactory.getProp(e,t.e,1,null,this),this.h=PropertyFactory.getProp(e,t.h||{k:0},0,.01,this),this.a=PropertyFactory.getProp(e,t.a||{k:0},0,degToRads,this),this.g=new GradientProperty(e,t.g,this),this.style=r,this.stops=[],this.setGradientData(r.pElem,t),this.setGradientOpacity(t,r),this._isAnimated=!!this._isAnimated},SVGGradientFillStyleData.prototype.setGradientData=function(e,t){var r=createElementID(),n=createNS(1===t.t?"linearGradient":"radialGradient");n.setAttribute("id",r),n.setAttribute("spreadMethod","pad"),n.setAttribute("gradientUnits","userSpaceOnUse");var a,i,s,o=[];for(s=4*t.g.p,i=0;i<s;i+=4)a=createNS("stop"),n.appendChild(a),o.push(a);e.setAttribute("gf"===t.ty?"fill":"stroke","url("+getLocationHref()+"#"+r+")"),this.gf=n,this.cst=o},SVGGradientFillStyleData.prototype.setGradientOpacity=function(e,t){if(this.g._hasOpacity&&!this.g._collapsable){var r,n,a,i=createNS("mask"),s=createNS("path");i.appendChild(s);var o=createElementID(),l=createElementID();i.setAttribute("id",l);var u=createNS(1===e.t?"linearGradient":"radialGradient");u.setAttribute("id",o),u.setAttribute("spreadMethod","pad"),u.setAttribute("gradientUnits","userSpaceOnUse"),a=e.g.k.k[0].s?e.g.k.k[0].s.length:e.g.k.k.length;var c=this.stops;for(n=4*e.g.p;n<a;n+=2)(r=createNS("stop")).setAttribute("stop-color","rgb(255,255,255)"),u.appendChild(r),c.push(r);s.setAttribute("gf"===e.ty?"fill":"stroke","url("+getLocationHref()+"#"+o+")"),"gs"===e.ty&&(s.setAttribute("stroke-linecap",lineCapEnum[e.lc||2]),s.setAttribute("stroke-linejoin",lineJoinEnum[e.lj||2]),1===e.lj&&s.setAttribute("stroke-miterlimit",e.ml)),this.of=u,this.ms=i,this.ost=c,this.maskId=l,t.msElem=s}},extendPrototype([DynamicPropertyContainer],SVGGradientFillStyleData),extendPrototype([SVGGradientFillStyleData,DynamicPropertyContainer],SVGGradientStrokeStyleData);var buildShapeString=function(e,t,r,n){if(0===t)return"";var a,i=e.o,s=e.i,o=e.v,l=" M"+n.applyToPointStringified(o[0][0],o[0][1]);for(a=1;a<t;a+=1)l+=" C"+n.applyToPointStringified(i[a-1][0],i[a-1][1])+" "+n.applyToPointStringified(s[a][0],s[a][1])+" "+n.applyToPointStringified(o[a][0],o[a][1]);return r&&t&&(l+=" C"+n.applyToPointStringified(i[a-1][0],i[a-1][1])+" "+n.applyToPointStringified(s[0][0],s[0][1])+" "+n.applyToPointStringified(o[0][0],o[0][1]),l+="z"),l},SVGElementsRenderer=function(){var e=new Matrix,t=new Matrix;function r(e,t,r){(r||t.transform.op._mdf)&&t.transform.container.setAttribute("opacity",t.transform.op.v),(r||t.transform.mProps._mdf)&&t.transform.container.setAttribute("transform",t.transform.mProps.v.to2dCSS())}function n(){}function a(r,n,a){var i,s,o,l,u,c,h,p,f,d,m=n.styles.length,g=n.lvl;for(c=0;c<m;c+=1){if(l=n.sh._mdf||a,n.styles[c].lvl<g){for(p=t.reset(),f=g-n.styles[c].lvl,d=n.transformers.length-1;!l&&f>0;)l=n.transformers[d].mProps._mdf||l,f-=1,d-=1;if(l)for(f=g-n.styles[c].lvl,d=n.transformers.length-1;f>0;)p.multiply(n.transformers[d].mProps.v),f-=1,d-=1}else p=e;if(s=(h=n.sh.paths)._length,l){for(o="",i=0;i<s;i+=1)(u=h.shapes[i])&&u._length&&(o+=buildShapeString(u,u._length,u.c,p));n.caches[c]=o}else o=n.caches[c];n.styles[c].d+=!0===r.hd?"":o,n.styles[c]._mdf=l||n.styles[c]._mdf}}function i(e,t,r){var n=t.style;(t.c._mdf||r)&&n.pElem.setAttribute("fill","rgb("+bmFloor(t.c.v[0])+","+bmFloor(t.c.v[1])+","+bmFloor(t.c.v[2])+")"),(t.o._mdf||r)&&n.pElem.setAttribute("fill-opacity",t.o.v)}function s(e,t,r){o(e,t,r),l(0,t,r)}function o(e,t,r){var n,a,i,s,o,l=t.gf,u=t.g._hasOpacity,c=t.s.v,h=t.e.v;if(t.o._mdf||r){var p="gf"===e.ty?"fill-opacity":"stroke-opacity";t.style.pElem.setAttribute(p,t.o.v)}if(t.s._mdf||r){var f=1===e.t?"x1":"cx",d="x1"===f?"y1":"cy";l.setAttribute(f,c[0]),l.setAttribute(d,c[1]),u&&!t.g._collapsable&&(t.of.setAttribute(f,c[0]),t.of.setAttribute(d,c[1]))}if(t.g._cmdf||r){n=t.cst;var m=t.g.c;for(i=n.length,a=0;a<i;a+=1)(s=n[a]).setAttribute("offset",m[4*a]+"%"),s.setAttribute("stop-color","rgb("+m[4*a+1]+","+m[4*a+2]+","+m[4*a+3]+")")}if(u&&(t.g._omdf||r)){var g=t.g.o;for(i=(n=t.g._collapsable?t.cst:t.ost).length,a=0;a<i;a+=1)s=n[a],t.g._collapsable||s.setAttribute("offset",g[2*a]+"%"),s.setAttribute("stop-opacity",g[2*a+1])}if(1===e.t)(t.e._mdf||r)&&(l.setAttribute("x2",h[0]),l.setAttribute("y2",h[1]),u&&!t.g._collapsable&&(t.of.setAttribute("x2",h[0]),t.of.setAttribute("y2",h[1])));else if((t.s._mdf||t.e._mdf||r)&&(o=Math.sqrt(Math.pow(c[0]-h[0],2)+Math.pow(c[1]-h[1],2)),l.setAttribute("r",o),u&&!t.g._collapsable&&t.of.setAttribute("r",o)),t.e._mdf||t.h._mdf||t.a._mdf||r){o||(o=Math.sqrt(Math.pow(c[0]-h[0],2)+Math.pow(c[1]-h[1],2)));var y=Math.atan2(h[1]-c[1],h[0]-c[0]),v=t.h.v;v>=1?v=.99:v<=-1&&(v=-.99);var b=o*v,k=Math.cos(y+t.a.v)*b+c[0],x=Math.sin(y+t.a.v)*b+c[1];l.setAttribute("fx",k),l.setAttribute("fy",x),u&&!t.g._collapsable&&(t.of.setAttribute("fx",k),t.of.setAttribute("fy",x))}}function l(e,t,r){var n=t.style,a=t.d;a&&(a._mdf||r)&&a.dashStr&&(n.pElem.setAttribute("stroke-dasharray",a.dashStr),n.pElem.setAttribute("stroke-dashoffset",a.dashoffset[0])),t.c&&(t.c._mdf||r)&&n.pElem.setAttribute("stroke","rgb("+bmFloor(t.c.v[0])+","+bmFloor(t.c.v[1])+","+bmFloor(t.c.v[2])+")"),(t.o._mdf||r)&&n.pElem.setAttribute("stroke-opacity",t.o.v),(t.w._mdf||r)&&(n.pElem.setAttribute("stroke-width",t.w.v),n.msElem&&n.msElem.setAttribute("stroke-width",t.w.v))}return{createRenderFunction:function(e){switch(e.ty){case"fl":return i;case"gf":return o;case"gs":return s;case"st":return l;case"sh":case"el":case"rc":case"sr":return a;case"tr":return r;case"no":return n;default:return null}}}}();function SVGShapeElement(e,t,r){this.shapes=[],this.shapesData=e.shapes,this.stylesList=[],this.shapeModifiers=[],this.itemsData=[],this.processedElements=[],this.animatedContents=[],this.initElement(e,t,r),this.prevViewData=[]}function LetterProps(e,t,r,n,a,i){this.o=e,this.sw=t,this.sc=r,this.fc=n,this.m=a,this.p=i,this._mdf={o:!0,sw:!!t,sc:!!r,fc:!!n,m:!0,p:!0}}function TextProperty(e,t){this._frameId=initialDefaultFrame,this.pv="",this.v="",this.kf=!1,this._isFirstFrame=!0,this._mdf=!1,t.d&&t.d.sid&&(t.d=e.globalData.slotManager.getProp(t.d)),this.data=t,this.elem=e,this.comp=this.elem.comp,this.keysIndex=0,this.canResize=!1,this.minimumFontSize=1,this.effectsSequence=[],this.currentData={ascent:0,boxWidth:this.defaultBoxWidth,f:"",fStyle:"",fWeight:"",fc:"",j:"",justifyOffset:"",l:[],lh:0,lineWidths:[],ls:"",of:"",s:"",sc:"",sw:0,t:0,tr:0,sz:0,ps:null,fillColorAnim:!1,strokeColorAnim:!1,strokeWidthAnim:!1,yOffset:0,finalSize:0,finalText:[],finalLineHeight:0,__complete:!1},this.copyData(this.currentData,this.data.d.k[0].s),this.searchProperty()||this.completeTextData(this.currentData)}extendPrototype([BaseElement,TransformElement,SVGBaseElement,IShapeElement,HierarchyElement,FrameElement,RenderableDOMElement],SVGShapeElement),SVGShapeElement.prototype.initSecondaryElement=function(){},SVGShapeElement.prototype.identityMatrix=new Matrix,SVGShapeElement.prototype.buildExpressionInterface=function(){},SVGShapeElement.prototype.createContent=function(){this.searchShapes(this.shapesData,this.itemsData,this.prevViewData,this.layerElement,0,[],!0),this.filterUniqueShapes()},SVGShapeElement.prototype.filterUniqueShapes=function(){var e,t,r,n,a=this.shapes.length,i=this.stylesList.length,s=[],o=!1;for(r=0;r<i;r+=1){for(n=this.stylesList[r],o=!1,s.length=0,e=0;e<a;e+=1)-1!==(t=this.shapes[e]).styles.indexOf(n)&&(s.push(t),o=t._isAnimated||o);s.length>1&&o&&this.setShapesAsAnimated(s)}},SVGShapeElement.prototype.setShapesAsAnimated=function(e){var t,r=e.length;for(t=0;t<r;t+=1)e[t].setAsAnimated()},SVGShapeElement.prototype.createStyleElement=function(e,t){var r,n=new SVGStyleData(e,t),a=n.pElem;return"st"===e.ty?r=new SVGStrokeStyleData(this,e,n):"fl"===e.ty?r=new SVGFillStyleData(this,e,n):"gf"===e.ty||"gs"===e.ty?(r=new("gf"===e.ty?SVGGradientFillStyleData:SVGGradientStrokeStyleData)(this,e,n),this.globalData.defs.appendChild(r.gf),r.maskId&&(this.globalData.defs.appendChild(r.ms),this.globalData.defs.appendChild(r.of),a.setAttribute("mask","url("+getLocationHref()+"#"+r.maskId+")"))):"no"===e.ty&&(r=new SVGNoStyleData(this,e,n)),"st"!==e.ty&&"gs"!==e.ty||(a.setAttribute("stroke-linecap",lineCapEnum[e.lc||2]),a.setAttribute("stroke-linejoin",lineJoinEnum[e.lj||2]),a.setAttribute("fill-opacity","0"),1===e.lj&&a.setAttribute("stroke-miterlimit",e.ml)),2===e.r&&a.setAttribute("fill-rule","evenodd"),e.ln&&a.setAttribute("id",e.ln),e.cl&&a.setAttribute("class",e.cl),e.bm&&(a.style["mix-blend-mode"]=getBlendMode(e.bm)),this.stylesList.push(n),this.addToAnimatedContents(e,r),r},SVGShapeElement.prototype.createGroupElement=function(e){var t=new ShapeGroupData;return e.ln&&t.gr.setAttribute("id",e.ln),e.cl&&t.gr.setAttribute("class",e.cl),e.bm&&(t.gr.style["mix-blend-mode"]=getBlendMode(e.bm)),t},SVGShapeElement.prototype.createTransformElement=function(e,t){var r=TransformPropertyFactory.getTransformProperty(this,e,this),n=new SVGTransformData(r,r.o,t);return this.addToAnimatedContents(e,n),n},SVGShapeElement.prototype.createShapeElement=function(e,t,r){var n=4;"rc"===e.ty?n=5:"el"===e.ty?n=6:"sr"===e.ty&&(n=7);var a=new SVGShapeData(t,r,ShapePropertyFactory.getShapeProp(this,e,n,this));return this.shapes.push(a),this.addShapeToModifiers(a),this.addToAnimatedContents(e,a),a},SVGShapeElement.prototype.addToAnimatedContents=function(e,t){for(var r=0,n=this.animatedContents.length;r<n;){if(this.animatedContents[r].element===t)return;r+=1}this.animatedContents.push({fn:SVGElementsRenderer.createRenderFunction(e),element:t,data:e})},SVGShapeElement.prototype.setElementStyles=function(e){var t,r=e.styles,n=this.stylesList.length;for(t=0;t<n;t+=1)this.stylesList[t].closed||r.push(this.stylesList[t])},SVGShapeElement.prototype.reloadShapes=function(){var e;this._isFirstFrame=!0;var t=this.itemsData.length;for(e=0;e<t;e+=1)this.prevViewData[e]=this.itemsData[e];for(this.searchShapes(this.shapesData,this.itemsData,this.prevViewData,this.layerElement,0,[],!0),this.filterUniqueShapes(),t=this.dynamicProperties.length,e=0;e<t;e+=1)this.dynamicProperties[e].getValue();this.renderModifiers()},SVGShapeElement.prototype.searchShapes=function(e,t,r,n,a,i,s){var o,l,u,c,h,p,f=[].concat(i),d=e.length-1,m=[],g=[];for(o=d;o>=0;o-=1){if((p=this.searchProcessedElement(e[o]))?t[o]=r[p-1]:e[o]._render=s,"fl"===e[o].ty||"st"===e[o].ty||"gf"===e[o].ty||"gs"===e[o].ty||"no"===e[o].ty)p?t[o].style.closed=!1:t[o]=this.createStyleElement(e[o],a),e[o]._render&&t[o].style.pElem.parentNode!==n&&n.appendChild(t[o].style.pElem),m.push(t[o].style);else if("gr"===e[o].ty){if(p)for(u=t[o].it.length,l=0;l<u;l+=1)t[o].prevViewData[l]=t[o].it[l];else t[o]=this.createGroupElement(e[o]);this.searchShapes(e[o].it,t[o].it,t[o].prevViewData,t[o].gr,a+1,f,s),e[o]._render&&t[o].gr.parentNode!==n&&n.appendChild(t[o].gr)}else"tr"===e[o].ty?(p||(t[o]=this.createTransformElement(e[o],n)),c=t[o].transform,f.push(c)):"sh"===e[o].ty||"rc"===e[o].ty||"el"===e[o].ty||"sr"===e[o].ty?(p||(t[o]=this.createShapeElement(e[o],f,a)),this.setElementStyles(t[o])):"tm"===e[o].ty||"rd"===e[o].ty||"ms"===e[o].ty||"pb"===e[o].ty||"zz"===e[o].ty||"op"===e[o].ty?(p?(h=t[o]).closed=!1:((h=ShapeModifiers.getModifier(e[o].ty)).init(this,e[o]),t[o]=h,this.shapeModifiers.push(h)),g.push(h)):"rp"===e[o].ty&&(p?(h=t[o]).closed=!0:(h=ShapeModifiers.getModifier(e[o].ty),t[o]=h,h.init(this,e,o,t),this.shapeModifiers.push(h),s=!1),g.push(h));this.addProcessedElement(e[o],o+1)}for(d=m.length,o=0;o<d;o+=1)m[o].closed=!0;for(d=g.length,o=0;o<d;o+=1)g[o].closed=!0},SVGShapeElement.prototype.renderInnerContent=function(){var e;this.renderModifiers();var t=this.stylesList.length;for(e=0;e<t;e+=1)this.stylesList[e].reset();for(this.renderShape(),e=0;e<t;e+=1)(this.stylesList[e]._mdf||this._isFirstFrame)&&(this.stylesList[e].msElem&&(this.stylesList[e].msElem.setAttribute("d",this.stylesList[e].d),this.stylesList[e].d="M0 0"+this.stylesList[e].d),this.stylesList[e].pElem.setAttribute("d",this.stylesList[e].d||"M0 0"))},SVGShapeElement.prototype.renderShape=function(){var e,t,r=this.animatedContents.length;for(e=0;e<r;e+=1)t=this.animatedContents[e],(this._isFirstFrame||t.element._isAnimated)&&!0!==t.data&&t.fn(t.data,t.element,this._isFirstFrame)},SVGShapeElement.prototype.destroy=function(){this.destroyBaseElement(),this.shapesData=null,this.itemsData=null},LetterProps.prototype.update=function(e,t,r,n,a,i){this._mdf.o=!1,this._mdf.sw=!1,this._mdf.sc=!1,this._mdf.fc=!1,this._mdf.m=!1,this._mdf.p=!1;var s=!1;return this.o!==e&&(this.o=e,this._mdf.o=!0,s=!0),this.sw!==t&&(this.sw=t,this._mdf.sw=!0,s=!0),this.sc!==r&&(this.sc=r,this._mdf.sc=!0,s=!0),this.fc!==n&&(this.fc=n,this._mdf.fc=!0,s=!0),this.m!==a&&(this.m=a,this._mdf.m=!0,s=!0),!i.length||this.p[0]===i[0]&&this.p[1]===i[1]&&this.p[4]===i[4]&&this.p[5]===i[5]&&this.p[12]===i[12]&&this.p[13]===i[13]||(this.p=i,this._mdf.p=!0,s=!0),s},TextProperty.prototype.defaultBoxWidth=[0,0],TextProperty.prototype.copyData=function(e,t){for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]);return e},TextProperty.prototype.setCurrentData=function(e){e.__complete||this.completeTextData(e),this.currentData=e,this.currentData.boxWidth=this.currentData.boxWidth||this.defaultBoxWidth,this._mdf=!0},TextProperty.prototype.searchProperty=function(){return this.searchKeyframes()},TextProperty.prototype.searchKeyframes=function(){return this.kf=this.data.d.k.length>1,this.kf&&this.addEffect(this.getKeyframeValue.bind(this)),this.kf},TextProperty.prototype.addEffect=function(e){this.effectsSequence.push(e),this.elem.addDynamicProperty(this)},TextProperty.prototype.getValue=function(e){if(this.elem.globalData.frameId!==this.frameId&&this.effectsSequence.length||e){this.currentData.t=this.data.d.k[this.keysIndex].s.t;var t=this.currentData,r=this.keysIndex;if(this.lock)this.setCurrentData(this.currentData);else{var n;this.lock=!0,this._mdf=!1;var a=this.effectsSequence.length,i=e||this.data.d.k[this.keysIndex].s;for(n=0;n<a;n+=1)i=r!==this.keysIndex?this.effectsSequence[n](i,i.t):this.effectsSequence[n](this.currentData,i.t);t!==i&&this.setCurrentData(i),this.v=this.currentData,this.pv=this.v,this.lock=!1,this.frameId=this.elem.globalData.frameId}}},TextProperty.prototype.getKeyframeValue=function(){for(var e=this.data.d.k,t=this.elem.comp.renderedFrame,r=0,n=e.length;r<=n-1&&!(r===n-1||e[r+1].t>t);)r+=1;return this.keysIndex!==r&&(this.keysIndex=r),this.data.d.k[this.keysIndex].s},TextProperty.prototype.buildFinalText=function(e){for(var t,r,n=[],a=0,i=e.length,s=!1,o=!1,l="";a<i;)s=o,o=!1,t=e.charCodeAt(a),l=e.charAt(a),FontManager.isCombinedCharacter(t)?s=!0:t>=55296&&t<=56319?FontManager.isRegionalFlag(e,a)?l=e.substr(a,14):(r=e.charCodeAt(a+1))>=56320&&r<=57343&&(FontManager.isModifier(t,r)?(l=e.substr(a,2),s=!0):l=FontManager.isFlagEmoji(e.substr(a,4))?e.substr(a,4):e.substr(a,2)):t>56319?(r=e.charCodeAt(a+1),FontManager.isVariationSelector(t)&&(s=!0)):FontManager.isZeroWidthJoiner(t)&&(s=!0,o=!0),s?(n[n.length-1]+=l,s=!1):n.push(l),a+=l.length;return n},TextProperty.prototype.completeTextData=function(e){e.__complete=!0;var t,r,n,a,i,s,o,l=this.elem.globalData.fontManager,u=this.data,c=[],h=0,p=u.m.g,f=0,d=0,m=0,g=[],y=0,v=0,b=l.getFontByName(e.f),k=0,x=getFontProperties(b);e.fWeight=x.weight,e.fStyle=x.style,e.finalSize=e.s,e.finalText=this.buildFinalText(e.t),r=e.finalText.length,e.finalLineHeight=e.lh;var S,w=e.tr/1e3*e.finalSize;if(e.sz)for(var E,_,P=!0,C=e.sz[0],A=e.sz[1];P;){E=0,y=0,r=(_=this.buildFinalText(e.t)).length,w=e.tr/1e3*e.finalSize;var T=-1;for(t=0;t<r;t+=1)S=_[t].charCodeAt(0),n=!1," "===_[t]?T=t:13!==S&&3!==S||(y=0,n=!0,E+=e.finalLineHeight||1.2*e.finalSize),l.chars?(o=l.getCharData(_[t],b.fStyle,b.fFamily),k=n?0:o.w*e.finalSize/100):k=l.measureText(_[t],e.f,e.finalSize),y+k>C&&" "!==_[t]?(-1===T?r+=1:t=T,E+=e.finalLineHeight||1.2*e.finalSize,_.splice(t,T===t?1:0,"\r"),T=-1,y=0):(y+=k,y+=w);E+=b.ascent*e.finalSize/100,this.canResize&&e.finalSize>this.minimumFontSize&&A<E?(e.finalSize-=1,e.finalLineHeight=e.finalSize*e.lh/e.s):(e.finalText=_,r=e.finalText.length,P=!1)}y=-w,k=0;var M,D=0;for(t=0;t<r;t+=1)if(n=!1,13===(S=(M=e.finalText[t]).charCodeAt(0))||3===S?(D=0,g.push(y),v=y>v?y:v,y=-2*w,a="",n=!0,m+=1):a=M,l.chars?(o=l.getCharData(M,b.fStyle,l.getFontByName(e.f).fFamily),k=n?0:o.w*e.finalSize/100):k=l.measureText(a,e.f,e.finalSize)," "===M?D+=k+w:(y+=k+w+D,D=0),c.push({l:k,an:k,add:f,n,anIndexes:[],val:a,line:m,animatorJustifyOffset:0}),2==p){if(f+=k,""===a||" "===a||t===r-1){for(""!==a&&" "!==a||(f-=k);d<=t;)c[d].an=f,c[d].ind=h,c[d].extra=k,d+=1;h+=1,f=0}}else if(3==p){if(f+=k,""===a||t===r-1){for(""===a&&(f-=k);d<=t;)c[d].an=f,c[d].ind=h,c[d].extra=k,d+=1;f=0,h+=1}}else c[h].ind=h,c[h].extra=0,h+=1;if(e.l=c,v=y>v?y:v,g.push(y),e.sz)e.boxWidth=e.sz[0],e.justifyOffset=0;else switch(e.boxWidth=v,e.j){case 1:e.justifyOffset=-e.boxWidth;break;case 2:e.justifyOffset=-e.boxWidth/2;break;default:e.justifyOffset=0}e.lineWidths=g;var I,F,O,R,L=u.a;s=L.length;var N=[];for(i=0;i<s;i+=1){for((I=L[i]).a.sc&&(e.strokeColorAnim=!0),I.a.sw&&(e.strokeWidthAnim=!0),(I.a.fc||I.a.fh||I.a.fs||I.a.fb)&&(e.fillColorAnim=!0),R=0,O=I.s.b,t=0;t<r;t+=1)(F=c[t]).anIndexes[i]=R,(1==O&&""!==F.val||2==O&&""!==F.val&&" "!==F.val||3==O&&(F.n||" "==F.val||t==r-1)||4==O&&(F.n||t==r-1))&&(1===I.s.rn&&N.push(R),R+=1);u.a[i].s.totalChars=R;var V,z=-1;if(1===I.s.rn)for(t=0;t<r;t+=1)z!=(F=c[t]).anIndexes[i]&&(z=F.anIndexes[i],V=N.splice(Math.floor(Math.random()*N.length),1)[0]),F.anIndexes[i]=V}e.yOffset=e.finalLineHeight||1.2*e.finalSize,e.ls=e.ls||0,e.ascent=b.ascent*e.finalSize/100},TextProperty.prototype.updateDocumentData=function(e,t){t=void 0===t?this.keysIndex:t;var r=this.copyData({},this.data.d.k[t].s);r=this.copyData(r,e),this.data.d.k[t].s=r,this.recalculate(t),this.setCurrentData(r),this.elem.addDynamicProperty(this)},TextProperty.prototype.recalculate=function(e){var t=this.data.d.k[e].s;t.__complete=!1,this.keysIndex=0,this._isFirstFrame=!0,this.getValue(t)},TextProperty.prototype.canResizeFont=function(e){this.canResize=e,this.recalculate(this.keysIndex),this.elem.addDynamicProperty(this)},TextProperty.prototype.setMinimumFontSize=function(e){this.minimumFontSize=Math.floor(e)||1,this.recalculate(this.keysIndex),this.elem.addDynamicProperty(this)};var TextSelectorProp=function(){var e=Math.max,t=Math.min,r=Math.floor;function n(e,t){this._currentTextLength=-1,this.k=!1,this.data=t,this.elem=e,this.comp=e.comp,this.finalS=0,this.finalE=0,this.initDynamicPropertyContainer(e),this.s=PropertyFactory.getProp(e,t.s||{k:0},0,0,this),this.e="e"in t?PropertyFactory.getProp(e,t.e,0,0,this):{v:100},this.o=PropertyFactory.getProp(e,t.o||{k:0},0,0,this),this.xe=PropertyFactory.getProp(e,t.xe||{k:0},0,0,this),this.ne=PropertyFactory.getProp(e,t.ne||{k:0},0,0,this),this.sm=PropertyFactory.getProp(e,t.sm||{k:100},0,0,this),this.a=PropertyFactory.getProp(e,t.a,0,.01,this),this.dynamicProperties.length||this.getValue()}return n.prototype={getMult:function(n){this._currentTextLength!==this.elem.textProperty.currentData.l.length&&this.getValue();var a=0,i=0,s=1,o=1;this.ne.v>0?a=this.ne.v/100:i=-this.ne.v/100,this.xe.v>0?s=1-this.xe.v/100:o=1+this.xe.v/100;var l=BezierFactory.getBezierEasing(a,i,s,o).get,u=0,c=this.finalS,h=this.finalE,p=this.data.sh;if(2===p)u=l(u=h===c?n>=h?1:0:e(0,t(.5/(h-c)+(n-c)/(h-c),1)));else if(3===p)u=l(u=h===c?n>=h?0:1:1-e(0,t(.5/(h-c)+(n-c)/(h-c),1)));else if(4===p)h===c?u=0:(u=e(0,t(.5/(h-c)+(n-c)/(h-c),1)))<.5?u*=2:u=1-2*(u-.5),u=l(u);else if(5===p){if(h===c)u=0;else{var f=h-c,d=-f/2+(n=t(e(0,n+.5-c),h-c)),m=f/2;u=Math.sqrt(1-d*d/(m*m))}u=l(u)}else 6===p?(h===c?u=0:(n=t(e(0,n+.5-c),h-c),u=(1+Math.cos(Math.PI+2*Math.PI*n/(h-c)))/2),u=l(u)):(n>=r(c)&&(u=e(0,t(n-c<0?t(h,1)-(c-n):h-n,1))),u=l(u));if(100!==this.sm.v){var g=.01*this.sm.v;0===g&&(g=1e-8);var y=.5-.5*g;u<y?u=0:(u=(u-y)/g)>1&&(u=1)}return u*this.a.v},getValue:function(e){this.iterateDynamicProperties(),this._mdf=e||this._mdf,this._currentTextLength=this.elem.textProperty.currentData.l.length||0,e&&2===this.data.r&&(this.e.v=this._currentTextLength);var t=2===this.data.r?1:100/this.data.totalChars,r=this.o.v/t,n=this.s.v/t+r,a=this.e.v/t+r;if(n>a){var i=n;n=a,a=i}this.finalS=n,this.finalE=a}},extendPrototype([DynamicPropertyContainer],n),{getTextSelectorProp:function(e,t,r){return new n(e,t,r)}}}();function TextAnimatorDataProperty(e,t,r){var n={propType:!1},a=PropertyFactory.getProp,i=t.a;this.a={r:i.r?a(e,i.r,0,degToRads,r):n,rx:i.rx?a(e,i.rx,0,degToRads,r):n,ry:i.ry?a(e,i.ry,0,degToRads,r):n,sk:i.sk?a(e,i.sk,0,degToRads,r):n,sa:i.sa?a(e,i.sa,0,degToRads,r):n,s:i.s?a(e,i.s,1,.01,r):n,a:i.a?a(e,i.a,1,0,r):n,o:i.o?a(e,i.o,0,.01,r):n,p:i.p?a(e,i.p,1,0,r):n,sw:i.sw?a(e,i.sw,0,0,r):n,sc:i.sc?a(e,i.sc,1,0,r):n,fc:i.fc?a(e,i.fc,1,0,r):n,fh:i.fh?a(e,i.fh,0,0,r):n,fs:i.fs?a(e,i.fs,0,.01,r):n,fb:i.fb?a(e,i.fb,0,.01,r):n,t:i.t?a(e,i.t,0,0,r):n},this.s=TextSelectorProp.getTextSelectorProp(e,t.s,r),this.s.t=t.s.t}function TextAnimatorProperty(e,t,r){this._isFirstFrame=!0,this._hasMaskedPath=!1,this._frameId=-1,this._textData=e,this._renderType=t,this._elem=r,this._animatorsData=createSizedArray(this._textData.a.length),this._pathData={},this._moreOptions={alignment:{}},this.renderedLetters=[],this.lettersChangedFlag=!1,this.initDynamicPropertyContainer(r)}function ITextElement(){}TextAnimatorProperty.prototype.searchProperties=function(){var e,t,r=this._textData.a.length,n=PropertyFactory.getProp;for(e=0;e<r;e+=1)t=this._textData.a[e],this._animatorsData[e]=new TextAnimatorDataProperty(this._elem,t,this);this._textData.p&&"m"in this._textData.p?(this._pathData={a:n(this._elem,this._textData.p.a,0,0,this),f:n(this._elem,this._textData.p.f,0,0,this),l:n(this._elem,this._textData.p.l,0,0,this),r:n(this._elem,this._textData.p.r,0,0,this),p:n(this._elem,this._textData.p.p,0,0,this),m:this._elem.maskManager.getMaskProperty(this._textData.p.m)},this._hasMaskedPath=!0):this._hasMaskedPath=!1,this._moreOptions.alignment=n(this._elem,this._textData.m.a,1,0,this)},TextAnimatorProperty.prototype.getMeasures=function(e,t){if(this.lettersChangedFlag=t,this._mdf||this._isFirstFrame||t||this._hasMaskedPath&&this._pathData.m._mdf){this._isFirstFrame=!1;var r,n,a,i,s,o,l,u,c,h,p,f,d,m,g,y,v,b,k,x=this._moreOptions.alignment.v,S=this._animatorsData,w=this._textData,E=this.mHelper,_=this._renderType,P=this.renderedLetters.length,C=e.l;if(this._hasMaskedPath){if(k=this._pathData.m,!this._pathData.n||this._pathData._mdf){var A,T=k.v;for(this._pathData.r.v&&(T=T.reverse()),s={tLength:0,segments:[]},i=T._length-1,y=0,a=0;a<i;a+=1)A=bez.buildBezierData(T.v[a],T.v[a+1],[T.o[a][0]-T.v[a][0],T.o[a][1]-T.v[a][1]],[T.i[a+1][0]-T.v[a+1][0],T.i[a+1][1]-T.v[a+1][1]]),s.tLength+=A.segmentLength,s.segments.push(A),y+=A.segmentLength;a=i,k.v.c&&(A=bez.buildBezierData(T.v[a],T.v[0],[T.o[a][0]-T.v[a][0],T.o[a][1]-T.v[a][1]],[T.i[0][0]-T.v[0][0],T.i[0][1]-T.v[0][1]]),s.tLength+=A.segmentLength,s.segments.push(A),y+=A.segmentLength),this._pathData.pi=s}if(s=this._pathData.pi,o=this._pathData.f.v,p=0,h=1,u=0,c=!0,m=s.segments,o<0&&k.v.c)for(s.tLength<Math.abs(o)&&(o=-Math.abs(o)%s.tLength),h=(d=m[p=m.length-1].points).length-1;o<0;)o+=d[h].partialLength,(h-=1)<0&&(h=(d=m[p-=1].points).length-1);f=(d=m[p].points)[h-1],g=(l=d[h]).partialLength}i=C.length,r=0,n=0;var M,D,I,F,O,R=1.2*e.finalSize*.714,L=!0;I=S.length;var N,V,z,B,j,G,H,q,U,W,$,K,J=-1,Y=o,Q=p,X=h,Z=-1,ee="",te=this.defaultPropsArray;if(2===e.j||1===e.j){var re=0,ne=0,ae=2===e.j?-.5:-1,ie=0,se=!0;for(a=0;a<i;a+=1)if(C[a].n){for(re&&(re+=ne);ie<a;)C[ie].animatorJustifyOffset=re,ie+=1;re=0,se=!0}else{for(D=0;D<I;D+=1)(M=S[D].a).t.propType&&(se&&2===e.j&&(ne+=M.t.v*ae),(O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars)).length?re+=M.t.v*O[0]*ae:re+=M.t.v*O*ae);se=!1}for(re&&(re+=ne);ie<a;)C[ie].animatorJustifyOffset=re,ie+=1}for(a=0;a<i;a+=1){if(E.reset(),B=1,C[a].n)r=0,n+=e.yOffset,n+=L?1:0,o=Y,L=!1,this._hasMaskedPath&&(h=X,f=(d=m[p=Q].points)[h-1],g=(l=d[h]).partialLength,u=0),ee="",$="",U="",K="",te=this.defaultPropsArray;else{if(this._hasMaskedPath){if(Z!==C[a].line){switch(e.j){case 1:o+=y-e.lineWidths[C[a].line];break;case 2:o+=(y-e.lineWidths[C[a].line])/2}Z=C[a].line}J!==C[a].ind&&(C[J]&&(o+=C[J].extra),o+=C[a].an/2,J=C[a].ind),o+=x[0]*C[a].an*.005;var oe=0;for(D=0;D<I;D+=1)(M=S[D].a).p.propType&&((O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars)).length?oe+=M.p.v[0]*O[0]:oe+=M.p.v[0]*O),M.a.propType&&((O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars)).length?oe+=M.a.v[0]*O[0]:oe+=M.a.v[0]*O);for(c=!0,this._pathData.a.v&&(o=.5*C[0].an+(y-this._pathData.f.v-.5*C[0].an-.5*C[C.length-1].an)*J/(i-1),o+=this._pathData.f.v);c;)u+g>=o+oe||!d?(v=(o+oe-u)/l.partialLength,V=f.point[0]+(l.point[0]-f.point[0])*v,z=f.point[1]+(l.point[1]-f.point[1])*v,E.translate(-x[0]*C[a].an*.005,-x[1]*R*.01),c=!1):d&&(u+=l.partialLength,(h+=1)>=d.length&&(h=0,m[p+=1]?d=m[p].points:k.v.c?(h=0,d=m[p=0].points):(u-=l.partialLength,d=null)),d&&(f=l,g=(l=d[h]).partialLength));N=C[a].an/2-C[a].add,E.translate(-N,0,0)}else N=C[a].an/2-C[a].add,E.translate(-N,0,0),E.translate(-x[0]*C[a].an*.005,-x[1]*R*.01,0);for(D=0;D<I;D+=1)(M=S[D].a).t.propType&&(O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars),0===r&&0===e.j||(this._hasMaskedPath?O.length?o+=M.t.v*O[0]:o+=M.t.v*O:O.length?r+=M.t.v*O[0]:r+=M.t.v*O));for(e.strokeWidthAnim&&(G=e.sw||0),e.strokeColorAnim&&(j=e.sc?[e.sc[0],e.sc[1],e.sc[2]]:[0,0,0]),e.fillColorAnim&&e.fc&&(H=[e.fc[0],e.fc[1],e.fc[2]]),D=0;D<I;D+=1)(M=S[D].a).a.propType&&((O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars)).length?E.translate(-M.a.v[0]*O[0],-M.a.v[1]*O[1],M.a.v[2]*O[2]):E.translate(-M.a.v[0]*O,-M.a.v[1]*O,M.a.v[2]*O));for(D=0;D<I;D+=1)(M=S[D].a).s.propType&&((O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars)).length?E.scale(1+(M.s.v[0]-1)*O[0],1+(M.s.v[1]-1)*O[1],1):E.scale(1+(M.s.v[0]-1)*O,1+(M.s.v[1]-1)*O,1));for(D=0;D<I;D+=1){if(M=S[D].a,O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars),M.sk.propType&&(O.length?E.skewFromAxis(-M.sk.v*O[0],M.sa.v*O[1]):E.skewFromAxis(-M.sk.v*O,M.sa.v*O)),M.r.propType&&(O.length?E.rotateZ(-M.r.v*O[2]):E.rotateZ(-M.r.v*O)),M.ry.propType&&(O.length?E.rotateY(M.ry.v*O[1]):E.rotateY(M.ry.v*O)),M.rx.propType&&(O.length?E.rotateX(M.rx.v*O[0]):E.rotateX(M.rx.v*O)),M.o.propType&&(O.length?B+=(M.o.v*O[0]-B)*O[0]:B+=(M.o.v*O-B)*O),e.strokeWidthAnim&&M.sw.propType&&(O.length?G+=M.sw.v*O[0]:G+=M.sw.v*O),e.strokeColorAnim&&M.sc.propType)for(q=0;q<3;q+=1)O.length?j[q]+=(M.sc.v[q]-j[q])*O[0]:j[q]+=(M.sc.v[q]-j[q])*O;if(e.fillColorAnim&&e.fc){if(M.fc.propType)for(q=0;q<3;q+=1)O.length?H[q]+=(M.fc.v[q]-H[q])*O[0]:H[q]+=(M.fc.v[q]-H[q])*O;M.fh.propType&&(H=O.length?addHueToRGB(H,M.fh.v*O[0]):addHueToRGB(H,M.fh.v*O)),M.fs.propType&&(H=O.length?addSaturationToRGB(H,M.fs.v*O[0]):addSaturationToRGB(H,M.fs.v*O)),M.fb.propType&&(H=O.length?addBrightnessToRGB(H,M.fb.v*O[0]):addBrightnessToRGB(H,M.fb.v*O))}}for(D=0;D<I;D+=1)(M=S[D].a).p.propType&&(O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars),this._hasMaskedPath?O.length?E.translate(0,M.p.v[1]*O[0],-M.p.v[2]*O[1]):E.translate(0,M.p.v[1]*O,-M.p.v[2]*O):O.length?E.translate(M.p.v[0]*O[0],M.p.v[1]*O[1],-M.p.v[2]*O[2]):E.translate(M.p.v[0]*O,M.p.v[1]*O,-M.p.v[2]*O));if(e.strokeWidthAnim&&(U=G<0?0:G),e.strokeColorAnim&&(W="rgb("+Math.round(255*j[0])+","+Math.round(255*j[1])+","+Math.round(255*j[2])+")"),e.fillColorAnim&&e.fc&&($="rgb("+Math.round(255*H[0])+","+Math.round(255*H[1])+","+Math.round(255*H[2])+")"),this._hasMaskedPath){if(E.translate(0,-e.ls),E.translate(0,x[1]*R*.01+n,0),this._pathData.p.v){b=(l.point[1]-f.point[1])/(l.point[0]-f.point[0]);var le=180*Math.atan(b)/Math.PI;l.point[0]<f.point[0]&&(le+=180),E.rotate(-le*Math.PI/180)}E.translate(V,z,0),o-=x[0]*C[a].an*.005,C[a+1]&&J!==C[a+1].ind&&(o+=C[a].an/2,o+=.001*e.tr*e.finalSize)}else{switch(E.translate(r,n,0),e.ps&&E.translate(e.ps[0],e.ps[1]+e.ascent,0),e.j){case 1:E.translate(C[a].animatorJustifyOffset+e.justifyOffset+(e.boxWidth-e.lineWidths[C[a].line]),0,0);break;case 2:E.translate(C[a].animatorJustifyOffset+e.justifyOffset+(e.boxWidth-e.lineWidths[C[a].line])/2,0,0)}E.translate(0,-e.ls),E.translate(N,0,0),E.translate(x[0]*C[a].an*.005,x[1]*R*.01,0),r+=C[a].l+.001*e.tr*e.finalSize}"html"===_?ee=E.toCSS():"svg"===_?ee=E.to2dCSS():te=[E.props[0],E.props[1],E.props[2],E.props[3],E.props[4],E.props[5],E.props[6],E.props[7],E.props[8],E.props[9],E.props[10],E.props[11],E.props[12],E.props[13],E.props[14],E.props[15]],K=B}P<=a?(F=new LetterProps(K,U,W,$,ee,te),this.renderedLetters.push(F),P+=1,this.lettersChangedFlag=!0):(F=this.renderedLetters[a],this.lettersChangedFlag=F.update(K,U,W,$,ee,te)||this.lettersChangedFlag)}}},TextAnimatorProperty.prototype.getValue=function(){this._elem.globalData.frameId!==this._frameId&&(this._frameId=this._elem.globalData.frameId,this.iterateDynamicProperties())},TextAnimatorProperty.prototype.mHelper=new Matrix,TextAnimatorProperty.prototype.defaultPropsArray=[],extendPrototype([DynamicPropertyContainer],TextAnimatorProperty),ITextElement.prototype.initElement=function(e,t,r){this.lettersChangedFlag=!0,this.initFrame(),this.initBaseData(e,t,r),this.textProperty=new TextProperty(this,e.t,this.dynamicProperties),this.textAnimator=new TextAnimatorProperty(e.t,this.renderType,this),this.initTransform(e,t,r),this.initHierarchy(),this.initRenderable(),this.initRendererElement(),this.createContainerElements(),this.createRenderableComponents(),this.createContent(),this.hide(),this.textAnimator.searchProperties(this.dynamicProperties)},ITextElement.prototype.prepareFrame=function(e){this._mdf=!1,this.prepareRenderableFrame(e),this.prepareProperties(e,this.isInRange)},ITextElement.prototype.createPathShape=function(e,t){var r,n,a=t.length,i="";for(r=0;r<a;r+=1)"sh"===t[r].ty&&(n=t[r].ks.k,i+=buildShapeString(n,n.i.length,!0,e));return i},ITextElement.prototype.updateDocumentData=function(e,t){this.textProperty.updateDocumentData(e,t)},ITextElement.prototype.canResizeFont=function(e){this.textProperty.canResizeFont(e)},ITextElement.prototype.setMinimumFontSize=function(e){this.textProperty.setMinimumFontSize(e)},ITextElement.prototype.applyTextPropertiesToMatrix=function(e,t,r,n,a){switch(e.ps&&t.translate(e.ps[0],e.ps[1]+e.ascent,0),t.translate(0,-e.ls,0),e.j){case 1:t.translate(e.justifyOffset+(e.boxWidth-e.lineWidths[r]),0,0);break;case 2:t.translate(e.justifyOffset+(e.boxWidth-e.lineWidths[r])/2,0,0)}t.translate(n,a,0)},ITextElement.prototype.buildColor=function(e){return"rgb("+Math.round(255*e[0])+","+Math.round(255*e[1])+","+Math.round(255*e[2])+")"},ITextElement.prototype.emptyProp=new LetterProps,ITextElement.prototype.destroy=function(){},ITextElement.prototype.validateText=function(){(this.textProperty._mdf||this.textProperty._isFirstFrame)&&(this.buildNewText(),this.textProperty._isFirstFrame=!1,this.textProperty._mdf=!1)};var emptyShapeData={shapes:[]};function SVGTextLottieElement(e,t,r){this.textSpans=[],this.renderType="svg",this.initElement(e,t,r)}function ISolidElement(e,t,r){this.initElement(e,t,r)}function NullElement(e,t,r){this.initFrame(),this.initBaseData(e,t,r),this.initFrame(),this.initTransform(e,t,r),this.initHierarchy()}function SVGRendererBase(){}function ICompElement(){}function SVGCompElement(e,t,r){this.layers=e.layers,this.supports3d=!0,this.completeLayers=!1,this.pendingElements=[],this.elements=this.layers?createSizedArray(this.layers.length):[],this.initElement(e,t,r),this.tm=e.tm?PropertyFactory.getProp(this,e.tm,0,t.frameRate,this):{_placeholder:!0}}function SVGRenderer(e,t){this.animationItem=e,this.layers=null,this.renderedFrame=-1,this.svgElement=createNS("svg");var r="";if(t&&t.title){var n=createNS("title"),a=createElementID();n.setAttribute("id",a),n.textContent=t.title,this.svgElement.appendChild(n),r+=a}if(t&&t.description){var i=createNS("desc"),s=createElementID();i.setAttribute("id",s),i.textContent=t.description,this.svgElement.appendChild(i),r+=" "+s}r&&this.svgElement.setAttribute("aria-labelledby",r);var o=createNS("defs");this.svgElement.appendChild(o);var l=createNS("g");this.svgElement.appendChild(l),this.layerElement=l,this.renderConfig={preserveAspectRatio:t&&t.preserveAspectRatio||"xMidYMid meet",imagePreserveAspectRatio:t&&t.imagePreserveAspectRatio||"xMidYMid slice",contentVisibility:t&&t.contentVisibility||"visible",progressiveLoad:t&&t.progressiveLoad||!1,hideOnTransparent:!(t&&!1===t.hideOnTransparent),viewBoxOnly:t&&t.viewBoxOnly||!1,viewBoxSize:t&&t.viewBoxSize||!1,className:t&&t.className||"",id:t&&t.id||"",focusable:t&&t.focusable,filterSize:{width:t&&t.filterSize&&t.filterSize.width||"100%",height:t&&t.filterSize&&t.filterSize.height||"100%",x:t&&t.filterSize&&t.filterSize.x||"0%",y:t&&t.filterSize&&t.filterSize.y||"0%"},width:t&&t.width,height:t&&t.height,runExpressions:!t||void 0===t.runExpressions||t.runExpressions},this.globalData={_mdf:!1,frameNum:-1,defs:o,renderConfig:this.renderConfig},this.elements=[],this.pendingElements=[],this.destroyed=!1,this.rendererType="svg"}function ShapeTransformManager(){this.sequences={},this.sequenceList=[],this.transform_key_count=0}extendPrototype([BaseElement,TransformElement,SVGBaseElement,HierarchyElement,FrameElement,RenderableDOMElement,ITextElement],SVGTextLottieElement),SVGTextLottieElement.prototype.createContent=function(){this.data.singleShape&&!this.globalData.fontManager.chars&&(this.textContainer=createNS("text"))},SVGTextLottieElement.prototype.buildTextContents=function(e){for(var t=0,r=e.length,n=[],a="";t<r;)e[t]===String.fromCharCode(13)||e[t]===String.fromCharCode(3)?(n.push(a),a=""):a+=e[t],t+=1;return n.push(a),n},SVGTextLottieElement.prototype.buildShapeData=function(e,t){if(e.shapes&&e.shapes.length){var r=e.shapes[0];if(r.it){var n=r.it[r.it.length-1];n.s&&(n.s.k[0]=t,n.s.k[1]=t)}}return e},SVGTextLottieElement.prototype.buildNewText=function(){var e,t;this.addDynamicProperty(this);var r=this.textProperty.currentData;this.renderedLetters=createSizedArray(r?r.l.length:0),r.fc?this.layerElement.setAttribute("fill",this.buildColor(r.fc)):this.layerElement.setAttribute("fill","rgba(0,0,0,0)"),r.sc&&(this.layerElement.setAttribute("stroke",this.buildColor(r.sc)),this.layerElement.setAttribute("stroke-width",r.sw)),this.layerElement.setAttribute("font-size",r.finalSize);var n=this.globalData.fontManager.getFontByName(r.f);if(n.fClass)this.layerElement.setAttribute("class",n.fClass);else{this.layerElement.setAttribute("font-family",n.fFamily);var a=r.fWeight,i=r.fStyle;this.layerElement.setAttribute("font-style",i),this.layerElement.setAttribute("font-weight",a)}this.layerElement.setAttribute("aria-label",r.t);var s,o=r.l||[],l=!!this.globalData.fontManager.chars;t=o.length;var u=this.mHelper,c=this.data.singleShape,h=0,p=0,f=!0,d=.001*r.tr*r.finalSize;if(!c||l||r.sz){var m,g=this.textSpans.length;for(e=0;e<t;e+=1){if(this.textSpans[e]||(this.textSpans[e]={span:null,childSpan:null,glyph:null}),!l||!c||0===e){if(s=g>e?this.textSpans[e].span:createNS(l?"g":"text"),g<=e){if(s.setAttribute("stroke-linecap","butt"),s.setAttribute("stroke-linejoin","round"),s.setAttribute("stroke-miterlimit","4"),this.textSpans[e].span=s,l){var y=createNS("g");s.appendChild(y),this.textSpans[e].childSpan=y}this.textSpans[e].span=s,this.layerElement.appendChild(s)}s.style.display="inherit"}if(u.reset(),c&&(o[e].n&&(h=-d,p+=r.yOffset,p+=f?1:0,f=!1),this.applyTextPropertiesToMatrix(r,u,o[e].line,h,p),h+=o[e].l||0,h+=d),l){var v;if(1===(m=this.globalData.fontManager.getCharData(r.finalText[e],n.fStyle,this.globalData.fontManager.getFontByName(r.f).fFamily)).t)v=new SVGCompElement(m.data,this.globalData,this);else{var b=emptyShapeData;m.data&&m.data.shapes&&(b=this.buildShapeData(m.data,r.finalSize)),v=new SVGShapeElement(b,this.globalData,this)}if(this.textSpans[e].glyph){var k=this.textSpans[e].glyph;this.textSpans[e].childSpan.removeChild(k.layerElement),k.destroy()}this.textSpans[e].glyph=v,v._debug=!0,v.prepareFrame(0),v.renderFrame(),this.textSpans[e].childSpan.appendChild(v.layerElement),1===m.t&&this.textSpans[e].childSpan.setAttribute("transform","scale("+r.finalSize/100+","+r.finalSize/100+")")}else c&&s.setAttribute("transform","translate("+u.props[12]+","+u.props[13]+")"),s.textContent=o[e].val,s.setAttributeNS("http://www.w3.org/XML/1998/namespace","xml:space","preserve")}c&&s&&s.setAttribute("d","")}else{var x=this.textContainer,S="start";switch(r.j){case 1:S="end";break;case 2:S="middle";break;default:S="start"}x.setAttribute("text-anchor",S),x.setAttribute("letter-spacing",d);var w=this.buildTextContents(r.finalText);for(t=w.length,p=r.ps?r.ps[1]+r.ascent:0,e=0;e<t;e+=1)(s=this.textSpans[e].span||createNS("tspan")).textContent=w[e],s.setAttribute("x",0),s.setAttribute("y",p),s.style.display="inherit",x.appendChild(s),this.textSpans[e]||(this.textSpans[e]={span:null,glyph:null}),this.textSpans[e].span=s,p+=r.finalLineHeight;this.layerElement.appendChild(x)}for(;e<this.textSpans.length;)this.textSpans[e].span.style.display="none",e+=1;this._sizeChanged=!0},SVGTextLottieElement.prototype.sourceRectAtTime=function(){if(this.prepareFrame(this.comp.renderedFrame-this.data.st),this.renderInnerContent(),this._sizeChanged){this._sizeChanged=!1;var e=this.layerElement.getBBox();this.bbox={top:e.y,left:e.x,width:e.width,height:e.height}}return this.bbox},SVGTextLottieElement.prototype.getValue=function(){var e,t,r=this.textSpans.length;for(this.renderedFrame=this.comp.renderedFrame,e=0;e<r;e+=1)(t=this.textSpans[e].glyph)&&(t.prepareFrame(this.comp.renderedFrame-this.data.st),t._mdf&&(this._mdf=!0))},SVGTextLottieElement.prototype.renderInnerContent=function(){if(this.validateText(),(!this.data.singleShape||this._mdf)&&(this.textAnimator.getMeasures(this.textProperty.currentData,this.lettersChangedFlag),this.lettersChangedFlag||this.textAnimator.lettersChangedFlag)){var e,t;this._sizeChanged=!0;var r,n,a,i=this.textAnimator.renderedLetters,s=this.textProperty.currentData.l;for(t=s.length,e=0;e<t;e+=1)s[e].n||(r=i[e],n=this.textSpans[e].span,(a=this.textSpans[e].glyph)&&a.renderFrame(),r._mdf.m&&n.setAttribute("transform",r.m),r._mdf.o&&n.setAttribute("opacity",r.o),r._mdf.sw&&n.setAttribute("stroke-width",r.sw),r._mdf.sc&&n.setAttribute("stroke",r.sc),r._mdf.fc&&n.setAttribute("fill",r.fc))}},extendPrototype([IImageElement],ISolidElement),ISolidElement.prototype.createContent=function(){var e=createNS("rect");e.setAttribute("width",this.data.sw),e.setAttribute("height",this.data.sh),e.setAttribute("fill",this.data.sc),this.layerElement.appendChild(e)},NullElement.prototype.prepareFrame=function(e){this.prepareProperties(e,!0)},NullElement.prototype.renderFrame=function(){},NullElement.prototype.getBaseElement=function(){return null},NullElement.prototype.destroy=function(){},NullElement.prototype.sourceRectAtTime=function(){},NullElement.prototype.hide=function(){},extendPrototype([BaseElement,TransformElement,HierarchyElement,FrameElement],NullElement),extendPrototype([BaseRenderer],SVGRendererBase),SVGRendererBase.prototype.createNull=function(e){return new NullElement(e,this.globalData,this)},SVGRendererBase.prototype.createShape=function(e){return new SVGShapeElement(e,this.globalData,this)},SVGRendererBase.prototype.createText=function(e){return new SVGTextLottieElement(e,this.globalData,this)},SVGRendererBase.prototype.createImage=function(e){return new IImageElement(e,this.globalData,this)},SVGRendererBase.prototype.createSolid=function(e){return new ISolidElement(e,this.globalData,this)},SVGRendererBase.prototype.configAnimation=function(e){this.svgElement.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.svgElement.setAttribute("xmlns:xlink","http://www.w3.org/1999/xlink"),this.renderConfig.viewBoxSize?this.svgElement.setAttribute("viewBox",this.renderConfig.viewBoxSize):this.svgElement.setAttribute("viewBox","0 0 "+e.w+" "+e.h),this.renderConfig.viewBoxOnly||(this.svgElement.setAttribute("width",e.w),this.svgElement.setAttribute("height",e.h),this.svgElement.style.width="100%",this.svgElement.style.height="100%",this.svgElement.style.transform="translate3d(0,0,0)",this.svgElement.style.contentVisibility=this.renderConfig.contentVisibility),this.renderConfig.width&&this.svgElement.setAttribute("width",this.renderConfig.width),this.renderConfig.height&&this.svgElement.setAttribute("height",this.renderConfig.height),this.renderConfig.className&&this.svgElement.setAttribute("class",this.renderConfig.className),this.renderConfig.id&&this.svgElement.setAttribute("id",this.renderConfig.id),void 0!==this.renderConfig.focusable&&this.svgElement.setAttribute("focusable",this.renderConfig.focusable),this.svgElement.setAttribute("preserveAspectRatio",this.renderConfig.preserveAspectRatio),this.animationItem.wrapper.appendChild(this.svgElement);var t=this.globalData.defs;this.setupGlobalData(e,t),this.globalData.progressiveLoad=this.renderConfig.progressiveLoad,this.data=e;var r=createNS("clipPath"),n=createNS("rect");n.setAttribute("width",e.w),n.setAttribute("height",e.h),n.setAttribute("x",0),n.setAttribute("y",0);var a=createElementID();r.setAttribute("id",a),r.appendChild(n),this.layerElement.setAttribute("clip-path","url("+getLocationHref()+"#"+a+")"),t.appendChild(r),this.layers=e.layers,this.elements=createSizedArray(e.layers.length)},SVGRendererBase.prototype.destroy=function(){var e;this.animationItem.wrapper&&(this.animationItem.wrapper.innerText=""),this.layerElement=null,this.globalData.defs=null;var t=this.layers?this.layers.length:0;for(e=0;e<t;e+=1)this.elements[e]&&this.elements[e].destroy&&this.elements[e].destroy();this.elements.length=0,this.destroyed=!0,this.animationItem=null},SVGRendererBase.prototype.updateContainerSize=function(){},SVGRendererBase.prototype.findIndexByInd=function(e){var t=0,r=this.layers.length;for(t=0;t<r;t+=1)if(this.layers[t].ind===e)return t;return-1},SVGRendererBase.prototype.buildItem=function(e){var t=this.elements;if(!t[e]&&99!==this.layers[e].ty){t[e]=!0;var r=this.createItem(this.layers[e]);if(t[e]=r,getExpressionsPlugin()&&(0===this.layers[e].ty&&this.globalData.projectInterface.registerComposition(r),r.initExpressions()),this.appendElementInPos(r,e),this.layers[e].tt){var n="tp"in this.layers[e]?this.findIndexByInd(this.layers[e].tp):e-1;if(-1===n)return;if(this.elements[n]&&!0!==this.elements[n]){var a=t[n].getMatte(this.layers[e].tt);r.setMatte(a)}else this.buildItem(n),this.addPendingElement(r)}}},SVGRendererBase.prototype.checkPendingElements=function(){for(;this.pendingElements.length;){var e=this.pendingElements.pop();if(e.checkParenting(),e.data.tt)for(var t=0,r=this.elements.length;t<r;){if(this.elements[t]===e){var n="tp"in e.data?this.findIndexByInd(e.data.tp):t-1,a=this.elements[n].getMatte(this.layers[t].tt);e.setMatte(a);break}t+=1}}},SVGRendererBase.prototype.renderFrame=function(e){if(this.renderedFrame!==e&&!this.destroyed){var t;null===e?e=this.renderedFrame:this.renderedFrame=e,this.globalData.frameNum=e,this.globalData.frameId+=1,this.globalData.projectInterface.currentFrame=e,this.globalData._mdf=!1;var r=this.layers.length;for(this.completeLayers||this.checkLayers(e),t=r-1;t>=0;t-=1)(this.completeLayers||this.elements[t])&&this.elements[t].prepareFrame(e-this.layers[t].st);if(this.globalData._mdf)for(t=0;t<r;t+=1)(this.completeLayers||this.elements[t])&&this.elements[t].renderFrame()}},SVGRendererBase.prototype.appendElementInPos=function(e,t){var r=e.getBaseElement();if(r){for(var n,a=0;a<t;)this.elements[a]&&!0!==this.elements[a]&&this.elements[a].getBaseElement()&&(n=this.elements[a].getBaseElement()),a+=1;n?this.layerElement.insertBefore(r,n):this.layerElement.appendChild(r)}},SVGRendererBase.prototype.hide=function(){this.layerElement.style.display="none"},SVGRendererBase.prototype.show=function(){this.layerElement.style.display="block"},extendPrototype([BaseElement,TransformElement,HierarchyElement,FrameElement,RenderableDOMElement],ICompElement),ICompElement.prototype.initElement=function(e,t,r){this.initFrame(),this.initBaseData(e,t,r),this.initTransform(e,t,r),this.initRenderable(),this.initHierarchy(),this.initRendererElement(),this.createContainerElements(),this.createRenderableComponents(),!this.data.xt&&t.progressiveLoad||this.buildAllItems(),this.hide()},ICompElement.prototype.prepareFrame=function(e){if(this._mdf=!1,this.prepareRenderableFrame(e),this.prepareProperties(e,this.isInRange),this.isInRange||this.data.xt){if(this.tm._placeholder)this.renderedFrame=e/this.data.sr;else{var t=this.tm.v;t===this.data.op&&(t=this.data.op-1),this.renderedFrame=t}var r,n=this.elements.length;for(this.completeLayers||this.checkLayers(this.renderedFrame),r=n-1;r>=0;r-=1)(this.completeLayers||this.elements[r])&&(this.elements[r].prepareFrame(this.renderedFrame-this.layers[r].st),this.elements[r]._mdf&&(this._mdf=!0))}},ICompElement.prototype.renderInnerContent=function(){var e,t=this.layers.length;for(e=0;e<t;e+=1)(this.completeLayers||this.elements[e])&&this.elements[e].renderFrame()},ICompElement.prototype.setElements=function(e){this.elements=e},ICompElement.prototype.getElements=function(){return this.elements},ICompElement.prototype.destroyElements=function(){var e,t=this.layers.length;for(e=0;e<t;e+=1)this.elements[e]&&this.elements[e].destroy()},ICompElement.prototype.destroy=function(){this.destroyElements(),this.destroyBaseElement()},extendPrototype([SVGRendererBase,ICompElement,SVGBaseElement],SVGCompElement),SVGCompElement.prototype.createComp=function(e){return new SVGCompElement(e,this.globalData,this)},extendPrototype([SVGRendererBase],SVGRenderer),SVGRenderer.prototype.createComp=function(e){return new SVGCompElement(e,this.globalData,this)},ShapeTransformManager.prototype={addTransformSequence:function(e){var t,r=e.length,n="_";for(t=0;t<r;t+=1)n+=e[t].transform.key+"_";var a=this.sequences[n];return a||(a={transforms:[].concat(e),finalTransform:new Matrix,_mdf:!1},this.sequences[n]=a,this.sequenceList.push(a)),a},processSequence:function(e,t){for(var r=0,n=e.transforms.length,a=t;r<n&&!t;){if(e.transforms[r].transform.mProps._mdf){a=!0;break}r+=1}if(a)for(e.finalTransform.reset(),r=n-1;r>=0;r-=1)e.finalTransform.multiply(e.transforms[r].transform.mProps.v);e._mdf=a},processSequences:function(e){var t,r=this.sequenceList.length;for(t=0;t<r;t+=1)this.processSequence(this.sequenceList[t],e)},getNewKey:function(){return this.transform_key_count+=1,"_"+this.transform_key_count}};var lumaLoader=function(){var e="__lottie_element_luma_buffer",t=null,r=null,n=null;function a(){var a,i,s;t||(a=createNS("svg"),i=createNS("filter"),s=createNS("feColorMatrix"),i.setAttribute("id",e),s.setAttribute("type","matrix"),s.setAttribute("color-interpolation-filters","sRGB"),s.setAttribute("values","0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0"),i.appendChild(s),a.appendChild(i),a.setAttribute("id",e+"_svg"),featureSupport.svgLumaHidden&&(a.style.display="none"),n=a,document.body.appendChild(n),t=createTag("canvas"),(r=t.getContext("2d")).filter="url(#"+e+")",r.fillStyle="rgba(0,0,0,0)",r.fillRect(0,0,1,1))}return{load:a,get:function(n){return t||a(),t.width=n.width,t.height=n.height,r.filter="url(#"+e+")",t}}};function createCanvas(e,t){if(featureSupport.offscreenCanvas)return new OffscreenCanvas(e,t);var r=createTag("canvas");return r.width=e,r.height=t,r}var assetLoader={loadLumaCanvas:lumaLoader.load,getLumaCanvas:lumaLoader.get,createCanvas},registeredEffects={};function CVEffects(e){var t,r,n=e.data.ef?e.data.ef.length:0;for(this.filters=[],t=0;t<n;t+=1){r=null;var a=e.data.ef[t].ty;registeredEffects[a]&&(r=new(0,registeredEffects[a].effect)(e.effectsManager.effectElements[t],e)),r&&this.filters.push(r)}this.filters.length&&e.addRenderableComponent(this)}function registerEffect(e,t){registeredEffects[e]={effect:t}}function CVMaskElement(e,t){var r;this.data=e,this.element=t,this.masksProperties=this.data.masksProperties||[],this.viewData=createSizedArray(this.masksProperties.length);var n=this.masksProperties.length,a=!1;for(r=0;r<n;r+=1)"n"!==this.masksProperties[r].mode&&(a=!0),this.viewData[r]=ShapePropertyFactory.getShapeProp(this.element,this.masksProperties[r],3);this.hasMasks=a,a&&this.element.addRenderableComponent(this)}function CVBaseElement(){}CVEffects.prototype.renderFrame=function(e){var t,r=this.filters.length;for(t=0;t<r;t+=1)this.filters[t].renderFrame(e)},CVEffects.prototype.getEffects=function(e){var t,r=this.filters.length,n=[];for(t=0;t<r;t+=1)this.filters[t].type===e&&n.push(this.filters[t]);return n},CVMaskElement.prototype.renderFrame=function(){if(this.hasMasks){var e,t,r,n,a=this.element.finalTransform.mat,i=this.element.canvasContext,s=this.masksProperties.length;for(i.beginPath(),e=0;e<s;e+=1)if("n"!==this.masksProperties[e].mode){var o;this.masksProperties[e].inv&&(i.moveTo(0,0),i.lineTo(this.element.globalData.compSize.w,0),i.lineTo(this.element.globalData.compSize.w,this.element.globalData.compSize.h),i.lineTo(0,this.element.globalData.compSize.h),i.lineTo(0,0)),n=this.viewData[e].v,t=a.applyToPointArray(n.v[0][0],n.v[0][1],0),i.moveTo(t[0],t[1]);var l=n._length;for(o=1;o<l;o+=1)r=a.applyToTriplePoints(n.o[o-1],n.i[o],n.v[o]),i.bezierCurveTo(r[0],r[1],r[2],r[3],r[4],r[5]);r=a.applyToTriplePoints(n.o[o-1],n.i[0],n.v[0]),i.bezierCurveTo(r[0],r[1],r[2],r[3],r[4],r[5])}this.element.globalData.renderer.save(!0),i.clip()}},CVMaskElement.prototype.getMaskProperty=MaskElement.prototype.getMaskProperty,CVMaskElement.prototype.destroy=function(){this.element=null};var operationsMap={1:"source-in",2:"source-out",3:"source-in",4:"source-out"};function CVShapeData(e,t,r,n){this.styledShapes=[],this.tr=[0,0,0,0,0,0];var a,i=4;"rc"===t.ty?i=5:"el"===t.ty?i=6:"sr"===t.ty&&(i=7),this.sh=ShapePropertyFactory.getShapeProp(e,t,i,e);var s,o=r.length;for(a=0;a<o;a+=1)r[a].closed||(s={transforms:n.addTransformSequence(r[a].transforms),trNodes:[]},this.styledShapes.push(s),r[a].elements.push(s))}function CVShapeElement(e,t,r){this.shapes=[],this.shapesData=e.shapes,this.stylesList=[],this.itemsData=[],this.prevViewData=[],this.shapeModifiers=[],this.processedElements=[],this.transformsManager=new ShapeTransformManager,this.initElement(e,t,r)}function CVTextElement(e,t,r){this.textSpans=[],this.yOffset=0,this.fillColorAnim=!1,this.strokeColorAnim=!1,this.strokeWidthAnim=!1,this.stroke=!1,this.fill=!1,this.justifyOffset=0,this.currentRender=null,this.renderType="canvas",this.values={fill:"rgba(0,0,0,0)",stroke:"rgba(0,0,0,0)",sWidth:0,fValue:""},this.initElement(e,t,r)}function CVImageElement(e,t,r){this.assetData=t.getAssetData(e.refId),this.img=t.imageLoader.getAsset(this.assetData),this.initElement(e,t,r)}function CVSolidElement(e,t,r){this.initElement(e,t,r)}function CanvasRendererBase(){}function CanvasContext(){this.opacity=-1,this.transform=createTypedArray("float32",16),this.fillStyle="",this.strokeStyle="",this.lineWidth="",this.lineCap="",this.lineJoin="",this.miterLimit="",this.id=Math.random()}function CVContextData(){var e;for(this.stack=[],this.cArrPos=0,this.cTr=new Matrix,e=0;e<15;e+=1){var t=new CanvasContext;this.stack[e]=t}this._length=15,this.nativeContext=null,this.transformMat=new Matrix,this.currentOpacity=1,this.currentFillStyle="",this.appliedFillStyle="",this.currentStrokeStyle="",this.appliedStrokeStyle="",this.currentLineWidth="",this.appliedLineWidth="",this.currentLineCap="",this.appliedLineCap="",this.currentLineJoin="",this.appliedLineJoin="",this.appliedMiterLimit="",this.currentMiterLimit=""}function CVCompElement(e,t,r){this.completeLayers=!1,this.layers=e.layers,this.pendingElements=[],this.elements=createSizedArray(this.layers.length),this.initElement(e,t,r),this.tm=e.tm?PropertyFactory.getProp(this,e.tm,0,t.frameRate,this):{_placeholder:!0}}function CanvasRenderer(e,t){this.animationItem=e,this.renderConfig={clearCanvas:!t||void 0===t.clearCanvas||t.clearCanvas,context:t&&t.context||null,progressiveLoad:t&&t.progressiveLoad||!1,preserveAspectRatio:t&&t.preserveAspectRatio||"xMidYMid meet",imagePreserveAspectRatio:t&&t.imagePreserveAspectRatio||"xMidYMid slice",contentVisibility:t&&t.contentVisibility||"visible",className:t&&t.className||"",id:t&&t.id||"",runExpressions:!t||void 0===t.runExpressions||t.runExpressions},this.renderConfig.dpr=t&&t.dpr||1,this.animationItem.wrapper&&(this.renderConfig.dpr=t&&t.dpr||window.devicePixelRatio||1),this.renderedFrame=-1,this.globalData={frameNum:-1,_mdf:!1,renderConfig:this.renderConfig,currentGlobalAlpha:-1},this.contextData=new CVContextData,this.elements=[],this.pendingElements=[],this.transformMat=new Matrix,this.completeLayers=!1,this.rendererType="canvas",this.renderConfig.clearCanvas&&(this.ctxTransform=this.contextData.transform.bind(this.contextData),this.ctxOpacity=this.contextData.opacity.bind(this.contextData),this.ctxFillStyle=this.contextData.fillStyle.bind(this.contextData),this.ctxStrokeStyle=this.contextData.strokeStyle.bind(this.contextData),this.ctxLineWidth=this.contextData.lineWidth.bind(this.contextData),this.ctxLineCap=this.contextData.lineCap.bind(this.contextData),this.ctxLineJoin=this.contextData.lineJoin.bind(this.contextData),this.ctxMiterLimit=this.contextData.miterLimit.bind(this.contextData),this.ctxFill=this.contextData.fill.bind(this.contextData),this.ctxFillRect=this.contextData.fillRect.bind(this.contextData),this.ctxStroke=this.contextData.stroke.bind(this.contextData),this.save=this.contextData.save.bind(this.contextData))}function HBaseElement(){}function HSolidElement(e,t,r){this.initElement(e,t,r)}function HShapeElement(e,t,r){this.shapes=[],this.shapesData=e.shapes,this.stylesList=[],this.shapeModifiers=[],this.itemsData=[],this.processedElements=[],this.animatedContents=[],this.shapesContainer=createNS("g"),this.initElement(e,t,r),this.prevViewData=[],this.currentBBox={x:999999,y:-999999,h:0,w:0}}function HTextElement(e,t,r){this.textSpans=[],this.textPaths=[],this.currentBBox={x:999999,y:-999999,h:0,w:0},this.renderType="svg",this.isMasked=!1,this.initElement(e,t,r)}function HCameraElement(e,t,r){this.initFrame(),this.initBaseData(e,t,r),this.initHierarchy();var n=PropertyFactory.getProp;if(this.pe=n(this,e.pe,0,0,this),e.ks.p.s?(this.px=n(this,e.ks.p.x,1,0,this),this.py=n(this,e.ks.p.y,1,0,this),this.pz=n(this,e.ks.p.z,1,0,this)):this.p=n(this,e.ks.p,1,0,this),e.ks.a&&(this.a=n(this,e.ks.a,1,0,this)),e.ks.or.k.length&&e.ks.or.k[0].to){var a,i=e.ks.or.k.length;for(a=0;a<i;a+=1)e.ks.or.k[a].to=null,e.ks.or.k[a].ti=null}this.or=n(this,e.ks.or,1,degToRads,this),this.or.sh=!0,this.rx=n(this,e.ks.rx,0,degToRads,this),this.ry=n(this,e.ks.ry,0,degToRads,this),this.rz=n(this,e.ks.rz,0,degToRads,this),this.mat=new Matrix,this._prevMat=new Matrix,this._isFirstFrame=!0,this.finalTransform={mProp:this}}function HImageElement(e,t,r){this.assetData=t.getAssetData(e.refId),this.initElement(e,t,r)}function HybridRendererBase(e,t){this.animationItem=e,this.layers=null,this.renderedFrame=-1,this.renderConfig={className:t&&t.className||"",imagePreserveAspectRatio:t&&t.imagePreserveAspectRatio||"xMidYMid slice",hideOnTransparent:!(t&&!1===t.hideOnTransparent),filterSize:{width:t&&t.filterSize&&t.filterSize.width||"400%",height:t&&t.filterSize&&t.filterSize.height||"400%",x:t&&t.filterSize&&t.filterSize.x||"-100%",y:t&&t.filterSize&&t.filterSize.y||"-100%"}},this.globalData={_mdf:!1,frameNum:-1,renderConfig:this.renderConfig},this.pendingElements=[],this.elements=[],this.threeDElements=[],this.destroyed=!1,this.camera=null,this.supports3d=!0,this.rendererType="html"}function HCompElement(e,t,r){this.layers=e.layers,this.supports3d=!e.hasMask,this.completeLayers=!1,this.pendingElements=[],this.elements=this.layers?createSizedArray(this.layers.length):[],this.initElement(e,t,r),this.tm=e.tm?PropertyFactory.getProp(this,e.tm,0,t.frameRate,this):{_placeholder:!0}}function HybridRenderer(e,t){this.animationItem=e,this.layers=null,this.renderedFrame=-1,this.renderConfig={className:t&&t.className||"",imagePreserveAspectRatio:t&&t.imagePreserveAspectRatio||"xMidYMid slice",hideOnTransparent:!(t&&!1===t.hideOnTransparent),filterSize:{width:t&&t.filterSize&&t.filterSize.width||"400%",height:t&&t.filterSize&&t.filterSize.height||"400%",x:t&&t.filterSize&&t.filterSize.x||"-100%",y:t&&t.filterSize&&t.filterSize.y||"-100%"},runExpressions:!t||void 0===t.runExpressions||t.runExpressions},this.globalData={_mdf:!1,frameNum:-1,renderConfig:this.renderConfig},this.pendingElements=[],this.elements=[],this.threeDElements=[],this.destroyed=!1,this.camera=null,this.supports3d=!0,this.rendererType="html"}CVBaseElement.prototype={createElements:function(){},initRendererElement:function(){},createContainerElements:function(){if(this.data.tt>=1){this.buffers=[];var e=this.globalData.canvasContext,t=assetLoader.createCanvas(e.canvas.width,e.canvas.height);this.buffers.push(t);var r=assetLoader.createCanvas(e.canvas.width,e.canvas.height);this.buffers.push(r),this.data.tt>=3&&!document._isProxy&&assetLoader.loadLumaCanvas()}this.canvasContext=this.globalData.canvasContext,this.transformCanvas=this.globalData.transformCanvas,this.renderableEffectsManager=new CVEffects(this),this.searchEffectTransforms()},createContent:function(){},setBlendMode:function(){var e=this.globalData;if(e.blendMode!==this.data.bm){e.blendMode=this.data.bm;var t=getBlendMode(this.data.bm);e.canvasContext.globalCompositeOperation=t}},createRenderableComponents:function(){this.maskManager=new CVMaskElement(this.data,this),this.transformEffects=this.renderableEffectsManager.getEffects(effectTypes.TRANSFORM_EFFECT)},hideElement:function(){this.hidden||this.isInRange&&!this.isTransparent||(this.hidden=!0)},showElement:function(){this.isInRange&&!this.isTransparent&&(this.hidden=!1,this._isFirstFrame=!0,this.maskManager._isFirstFrame=!0)},clearCanvas:function(e){e.clearRect(this.transformCanvas.tx,this.transformCanvas.ty,this.transformCanvas.w*this.transformCanvas.sx,this.transformCanvas.h*this.transformCanvas.sy)},prepareLayer:function(){if(this.data.tt>=1){var e=this.buffers[0].getContext("2d");this.clearCanvas(e),e.drawImage(this.canvasContext.canvas,0,0),this.currentTransform=this.canvasContext.getTransform(),this.canvasContext.setTransform(1,0,0,1,0,0),this.clearCanvas(this.canvasContext),this.canvasContext.setTransform(this.currentTransform)}},exitLayer:function(){if(this.data.tt>=1){var e=this.buffers[1],t=e.getContext("2d");if(this.clearCanvas(t),t.drawImage(this.canvasContext.canvas,0,0),this.canvasContext.setTransform(1,0,0,1,0,0),this.clearCanvas(this.canvasContext),this.canvasContext.setTransform(this.currentTransform),this.comp.getElementById("tp"in this.data?this.data.tp:this.data.ind-1).renderFrame(!0),this.canvasContext.setTransform(1,0,0,1,0,0),this.data.tt>=3&&!document._isProxy){var r=assetLoader.getLumaCanvas(this.canvasContext.canvas);r.getContext("2d").drawImage(this.canvasContext.canvas,0,0),this.clearCanvas(this.canvasContext),this.canvasContext.drawImage(r,0,0)}this.canvasContext.globalCompositeOperation=operationsMap[this.data.tt],this.canvasContext.drawImage(e,0,0),this.canvasContext.globalCompositeOperation="destination-over",this.canvasContext.drawImage(this.buffers[0],0,0),this.canvasContext.setTransform(this.currentTransform),this.canvasContext.globalCompositeOperation="source-over"}},renderFrame:function(e){if(!this.hidden&&!this.data.hd&&(1!==this.data.td||e)){this.renderTransform(),this.renderRenderable(),this.renderLocalTransform(),this.setBlendMode();var t=0===this.data.ty;this.prepareLayer(),this.globalData.renderer.save(t),this.globalData.renderer.ctxTransform(this.finalTransform.localMat.props),this.globalData.renderer.ctxOpacity(this.finalTransform.localOpacity),this.renderInnerContent(),this.globalData.renderer.restore(t),this.exitLayer(),this.maskManager.hasMasks&&this.globalData.renderer.restore(!0),this._isFirstFrame&&(this._isFirstFrame=!1)}},destroy:function(){this.canvasContext=null,this.data=null,this.globalData=null,this.maskManager.destroy()},mHelper:new Matrix},CVBaseElement.prototype.hide=CVBaseElement.prototype.hideElement,CVBaseElement.prototype.show=CVBaseElement.prototype.showElement,CVShapeData.prototype.setAsAnimated=SVGShapeData.prototype.setAsAnimated,extendPrototype([BaseElement,TransformElement,CVBaseElement,IShapeElement,HierarchyElement,FrameElement,RenderableElement],CVShapeElement),CVShapeElement.prototype.initElement=RenderableDOMElement.prototype.initElement,CVShapeElement.prototype.transformHelper={opacity:1,_opMdf:!1},CVShapeElement.prototype.dashResetter=[],CVShapeElement.prototype.createContent=function(){this.searchShapes(this.shapesData,this.itemsData,this.prevViewData,!0,[])},CVShapeElement.prototype.createStyleElement=function(e,t){var r={data:e,type:e.ty,preTransforms:this.transformsManager.addTransformSequence(t),transforms:[],elements:[],closed:!0===e.hd},n={};if("fl"===e.ty||"st"===e.ty?(n.c=PropertyFactory.getProp(this,e.c,1,255,this),n.c.k||(r.co="rgb("+bmFloor(n.c.v[0])+","+bmFloor(n.c.v[1])+","+bmFloor(n.c.v[2])+")")):"gf"!==e.ty&&"gs"!==e.ty||(n.s=PropertyFactory.getProp(this,e.s,1,null,this),n.e=PropertyFactory.getProp(this,e.e,1,null,this),n.h=PropertyFactory.getProp(this,e.h||{k:0},0,.01,this),n.a=PropertyFactory.getProp(this,e.a||{k:0},0,degToRads,this),n.g=new GradientProperty(this,e.g,this)),n.o=PropertyFactory.getProp(this,e.o,0,.01,this),"st"===e.ty||"gs"===e.ty){if(r.lc=lineCapEnum[e.lc||2],r.lj=lineJoinEnum[e.lj||2],1==e.lj&&(r.ml=e.ml),n.w=PropertyFactory.getProp(this,e.w,0,null,this),n.w.k||(r.wi=n.w.v),e.d){var a=new DashProperty(this,e.d,"canvas",this);n.d=a,n.d.k||(r.da=n.d.dashArray,r.do=n.d.dashoffset[0])}}else r.r=2===e.r?"evenodd":"nonzero";return this.stylesList.push(r),n.style=r,n},CVShapeElement.prototype.createGroupElement=function(){return{it:[],prevViewData:[]}},CVShapeElement.prototype.createTransformElement=function(e){return{transform:{opacity:1,_opMdf:!1,key:this.transformsManager.getNewKey(),op:PropertyFactory.getProp(this,e.o,0,.01,this),mProps:TransformPropertyFactory.getTransformProperty(this,e,this)}}},CVShapeElement.prototype.createShapeElement=function(e){var t=new CVShapeData(this,e,this.stylesList,this.transformsManager);return this.shapes.push(t),this.addShapeToModifiers(t),t},CVShapeElement.prototype.reloadShapes=function(){var e;this._isFirstFrame=!0;var t=this.itemsData.length;for(e=0;e<t;e+=1)this.prevViewData[e]=this.itemsData[e];for(this.searchShapes(this.shapesData,this.itemsData,this.prevViewData,!0,[]),t=this.dynamicProperties.length,e=0;e<t;e+=1)this.dynamicProperties[e].getValue();this.renderModifiers(),this.transformsManager.processSequences(this._isFirstFrame)},CVShapeElement.prototype.addTransformToStyleList=function(e){var t,r=this.stylesList.length;for(t=0;t<r;t+=1)this.stylesList[t].closed||this.stylesList[t].transforms.push(e)},CVShapeElement.prototype.removeTransformFromStyleList=function(){var e,t=this.stylesList.length;for(e=0;e<t;e+=1)this.stylesList[e].closed||this.stylesList[e].transforms.pop()},CVShapeElement.prototype.closeStyles=function(e){var t,r=e.length;for(t=0;t<r;t+=1)e[t].closed=!0},CVShapeElement.prototype.searchShapes=function(e,t,r,n,a){var i,s,o,l,u,c,h=e.length-1,p=[],f=[],d=[].concat(a);for(i=h;i>=0;i-=1){if((l=this.searchProcessedElement(e[i]))?t[i]=r[l-1]:e[i]._shouldRender=n,"fl"===e[i].ty||"st"===e[i].ty||"gf"===e[i].ty||"gs"===e[i].ty)l?t[i].style.closed=!1:t[i]=this.createStyleElement(e[i],d),p.push(t[i].style);else if("gr"===e[i].ty){if(l)for(o=t[i].it.length,s=0;s<o;s+=1)t[i].prevViewData[s]=t[i].it[s];else t[i]=this.createGroupElement(e[i]);this.searchShapes(e[i].it,t[i].it,t[i].prevViewData,n,d)}else"tr"===e[i].ty?(l||(c=this.createTransformElement(e[i]),t[i]=c),d.push(t[i]),this.addTransformToStyleList(t[i])):"sh"===e[i].ty||"rc"===e[i].ty||"el"===e[i].ty||"sr"===e[i].ty?l||(t[i]=this.createShapeElement(e[i])):"tm"===e[i].ty||"rd"===e[i].ty||"pb"===e[i].ty||"zz"===e[i].ty||"op"===e[i].ty?(l?(u=t[i]).closed=!1:((u=ShapeModifiers.getModifier(e[i].ty)).init(this,e[i]),t[i]=u,this.shapeModifiers.push(u)),f.push(u)):"rp"===e[i].ty&&(l?(u=t[i]).closed=!0:(u=ShapeModifiers.getModifier(e[i].ty),t[i]=u,u.init(this,e,i,t),this.shapeModifiers.push(u),n=!1),f.push(u));this.addProcessedElement(e[i],i+1)}for(this.removeTransformFromStyleList(),this.closeStyles(p),h=f.length,i=0;i<h;i+=1)f[i].closed=!0},CVShapeElement.prototype.renderInnerContent=function(){this.transformHelper.opacity=1,this.transformHelper._opMdf=!1,this.renderModifiers(),this.transformsManager.processSequences(this._isFirstFrame),this.renderShape(this.transformHelper,this.shapesData,this.itemsData,!0)},CVShapeElement.prototype.renderShapeTransform=function(e,t){(e._opMdf||t.op._mdf||this._isFirstFrame)&&(t.opacity=e.opacity,t.opacity*=t.op.v,t._opMdf=!0)},CVShapeElement.prototype.drawLayer=function(){var e,t,r,n,a,i,s,o,l,u=this.stylesList.length,c=this.globalData.renderer,h=this.globalData.canvasContext;for(e=0;e<u;e+=1)if(("st"!==(o=(l=this.stylesList[e]).type)&&"gs"!==o||0!==l.wi)&&l.data._shouldRender&&0!==l.coOp&&0!==this.globalData.currentGlobalAlpha){for(c.save(),i=l.elements,"st"===o||"gs"===o?(c.ctxStrokeStyle("st"===o?l.co:l.grd),c.ctxLineWidth(l.wi),c.ctxLineCap(l.lc),c.ctxLineJoin(l.lj),c.ctxMiterLimit(l.ml||0)):c.ctxFillStyle("fl"===o?l.co:l.grd),c.ctxOpacity(l.coOp),"st"!==o&&"gs"!==o&&h.beginPath(),c.ctxTransform(l.preTransforms.finalTransform.props),r=i.length,t=0;t<r;t+=1){for("st"!==o&&"gs"!==o||(h.beginPath(),l.da&&(h.setLineDash(l.da),h.lineDashOffset=l.do)),a=(s=i[t].trNodes).length,n=0;n<a;n+=1)"m"===s[n].t?h.moveTo(s[n].p[0],s[n].p[1]):"c"===s[n].t?h.bezierCurveTo(s[n].pts[0],s[n].pts[1],s[n].pts[2],s[n].pts[3],s[n].pts[4],s[n].pts[5]):h.closePath();"st"!==o&&"gs"!==o||(c.ctxStroke(),l.da&&h.setLineDash(this.dashResetter))}"st"!==o&&"gs"!==o&&this.globalData.renderer.ctxFill(l.r),c.restore()}},CVShapeElement.prototype.renderShape=function(e,t,r,n){var a,i;for(i=e,a=t.length-1;a>=0;a-=1)"tr"===t[a].ty?(i=r[a].transform,this.renderShapeTransform(e,i)):"sh"===t[a].ty||"el"===t[a].ty||"rc"===t[a].ty||"sr"===t[a].ty?this.renderPath(t[a],r[a]):"fl"===t[a].ty?this.renderFill(t[a],r[a],i):"st"===t[a].ty?this.renderStroke(t[a],r[a],i):"gf"===t[a].ty||"gs"===t[a].ty?this.renderGradientFill(t[a],r[a],i):"gr"===t[a].ty?this.renderShape(i,t[a].it,r[a].it):t[a].ty;n&&this.drawLayer()},CVShapeElement.prototype.renderStyledShape=function(e,t){if(this._isFirstFrame||t._mdf||e.transforms._mdf){var r,n,a,i=e.trNodes,s=t.paths,o=s._length;i.length=0;var l=e.transforms.finalTransform;for(a=0;a<o;a+=1){var u=s.shapes[a];if(u&&u.v){for(n=u._length,r=1;r<n;r+=1)1===r&&i.push({t:"m",p:l.applyToPointArray(u.v[0][0],u.v[0][1],0)}),i.push({t:"c",pts:l.applyToTriplePoints(u.o[r-1],u.i[r],u.v[r])});1===n&&i.push({t:"m",p:l.applyToPointArray(u.v[0][0],u.v[0][1],0)}),u.c&&n&&(i.push({t:"c",pts:l.applyToTriplePoints(u.o[r-1],u.i[0],u.v[0])}),i.push({t:"z"}))}}e.trNodes=i}},CVShapeElement.prototype.renderPath=function(e,t){if(!0!==e.hd&&e._shouldRender){var r,n=t.styledShapes.length;for(r=0;r<n;r+=1)this.renderStyledShape(t.styledShapes[r],t.sh)}},CVShapeElement.prototype.renderFill=function(e,t,r){var n=t.style;(t.c._mdf||this._isFirstFrame)&&(n.co="rgb("+bmFloor(t.c.v[0])+","+bmFloor(t.c.v[1])+","+bmFloor(t.c.v[2])+")"),(t.o._mdf||r._opMdf||this._isFirstFrame)&&(n.coOp=t.o.v*r.opacity)},CVShapeElement.prototype.renderGradientFill=function(e,t,r){var n,a=t.style;if(!a.grd||t.g._mdf||t.s._mdf||t.e._mdf||1!==e.t&&(t.h._mdf||t.a._mdf)){var i,s=this.globalData.canvasContext,o=t.s.v,l=t.e.v;if(1===e.t)n=s.createLinearGradient(o[0],o[1],l[0],l[1]);else{var u=Math.sqrt(Math.pow(o[0]-l[0],2)+Math.pow(o[1]-l[1],2)),c=Math.atan2(l[1]-o[1],l[0]-o[0]),h=t.h.v;h>=1?h=.99:h<=-1&&(h=-.99);var p=u*h,f=Math.cos(c+t.a.v)*p+o[0],d=Math.sin(c+t.a.v)*p+o[1];n=s.createRadialGradient(f,d,0,o[0],o[1],u)}var m=e.g.p,g=t.g.c,y=1;for(i=0;i<m;i+=1)t.g._hasOpacity&&t.g._collapsable&&(y=t.g.o[2*i+1]),n.addColorStop(g[4*i]/100,"rgba("+g[4*i+1]+","+g[4*i+2]+","+g[4*i+3]+","+y+")");a.grd=n}a.coOp=t.o.v*r.opacity},CVShapeElement.prototype.renderStroke=function(e,t,r){var n=t.style,a=t.d;a&&(a._mdf||this._isFirstFrame)&&(n.da=a.dashArray,n.do=a.dashoffset[0]),(t.c._mdf||this._isFirstFrame)&&(n.co="rgb("+bmFloor(t.c.v[0])+","+bmFloor(t.c.v[1])+","+bmFloor(t.c.v[2])+")"),(t.o._mdf||r._opMdf||this._isFirstFrame)&&(n.coOp=t.o.v*r.opacity),(t.w._mdf||this._isFirstFrame)&&(n.wi=t.w.v)},CVShapeElement.prototype.destroy=function(){this.shapesData=null,this.globalData=null,this.canvasContext=null,this.stylesList.length=0,this.itemsData.length=0},extendPrototype([BaseElement,TransformElement,CVBaseElement,HierarchyElement,FrameElement,RenderableElement,ITextElement],CVTextElement),CVTextElement.prototype.tHelper=createTag("canvas").getContext("2d"),CVTextElement.prototype.buildNewText=function(){var e=this.textProperty.currentData;this.renderedLetters=createSizedArray(e.l?e.l.length:0);var t=!1;e.fc?(t=!0,this.values.fill=this.buildColor(e.fc)):this.values.fill="rgba(0,0,0,0)",this.fill=t;var r=!1;e.sc&&(r=!0,this.values.stroke=this.buildColor(e.sc),this.values.sWidth=e.sw);var n,a,i,s,o,l,u,c,h,p,f,d,m=this.globalData.fontManager.getFontByName(e.f),g=e.l,y=this.mHelper;this.stroke=r,this.values.fValue=e.finalSize+"px "+this.globalData.fontManager.getFontByName(e.f).fFamily,a=e.finalText.length;var v=this.data.singleShape,b=.001*e.tr*e.finalSize,k=0,x=0,S=!0,w=0;for(n=0;n<a;n+=1){s=(i=this.globalData.fontManager.getCharData(e.finalText[n],m.fStyle,this.globalData.fontManager.getFontByName(e.f).fFamily))&&i.data||{},y.reset(),v&&g[n].n&&(k=-b,x+=e.yOffset,x+=S?1:0,S=!1),h=(u=s.shapes?s.shapes[0].it:[]).length,y.scale(e.finalSize/100,e.finalSize/100),v&&this.applyTextPropertiesToMatrix(e,y,g[n].line,k,x),f=createSizedArray(h-1);var E=0;for(c=0;c<h;c+=1)if("sh"===u[c].ty){for(l=u[c].ks.k.i.length,p=u[c].ks.k,d=[],o=1;o<l;o+=1)1===o&&d.push(y.applyToX(p.v[0][0],p.v[0][1],0),y.applyToY(p.v[0][0],p.v[0][1],0)),d.push(y.applyToX(p.o[o-1][0],p.o[o-1][1],0),y.applyToY(p.o[o-1][0],p.o[o-1][1],0),y.applyToX(p.i[o][0],p.i[o][1],0),y.applyToY(p.i[o][0],p.i[o][1],0),y.applyToX(p.v[o][0],p.v[o][1],0),y.applyToY(p.v[o][0],p.v[o][1],0));d.push(y.applyToX(p.o[o-1][0],p.o[o-1][1],0),y.applyToY(p.o[o-1][0],p.o[o-1][1],0),y.applyToX(p.i[0][0],p.i[0][1],0),y.applyToY(p.i[0][0],p.i[0][1],0),y.applyToX(p.v[0][0],p.v[0][1],0),y.applyToY(p.v[0][0],p.v[0][1],0)),f[E]=d,E+=1}v&&(k+=g[n].l,k+=b),this.textSpans[w]?this.textSpans[w].elem=f:this.textSpans[w]={elem:f},w+=1}},CVTextElement.prototype.renderInnerContent=function(){var e,t,r,n,a,i;this.validateText(),this.canvasContext.font=this.values.fValue,this.globalData.renderer.ctxLineCap("butt"),this.globalData.renderer.ctxLineJoin("miter"),this.globalData.renderer.ctxMiterLimit(4),this.data.singleShape||this.textAnimator.getMeasures(this.textProperty.currentData,this.lettersChangedFlag);var s,o=this.textAnimator.renderedLetters,l=this.textProperty.currentData.l;t=l.length;var u,c,h=null,p=null,f=null,d=this.globalData.renderer;for(e=0;e<t;e+=1)if(!l[e].n){if((s=o[e])&&(d.save(),d.ctxTransform(s.p),d.ctxOpacity(s.o)),this.fill){for(s&&s.fc?h!==s.fc&&(d.ctxFillStyle(s.fc),h=s.fc):h!==this.values.fill&&(h=this.values.fill,d.ctxFillStyle(this.values.fill)),n=(u=this.textSpans[e].elem).length,this.globalData.canvasContext.beginPath(),r=0;r<n;r+=1)for(i=(c=u[r]).length,this.globalData.canvasContext.moveTo(c[0],c[1]),a=2;a<i;a+=6)this.globalData.canvasContext.bezierCurveTo(c[a],c[a+1],c[a+2],c[a+3],c[a+4],c[a+5]);this.globalData.canvasContext.closePath(),d.ctxFill()}if(this.stroke){for(s&&s.sw?f!==s.sw&&(f=s.sw,d.ctxLineWidth(s.sw)):f!==this.values.sWidth&&(f=this.values.sWidth,d.ctxLineWidth(this.values.sWidth)),s&&s.sc?p!==s.sc&&(p=s.sc,d.ctxStrokeStyle(s.sc)):p!==this.values.stroke&&(p=this.values.stroke,d.ctxStrokeStyle(this.values.stroke)),n=(u=this.textSpans[e].elem).length,this.globalData.canvasContext.beginPath(),r=0;r<n;r+=1)for(i=(c=u[r]).length,this.globalData.canvasContext.moveTo(c[0],c[1]),a=2;a<i;a+=6)this.globalData.canvasContext.bezierCurveTo(c[a],c[a+1],c[a+2],c[a+3],c[a+4],c[a+5]);this.globalData.canvasContext.closePath(),d.ctxStroke()}s&&this.globalData.renderer.restore()}},extendPrototype([BaseElement,TransformElement,CVBaseElement,HierarchyElement,FrameElement,RenderableElement],CVImageElement),CVImageElement.prototype.initElement=SVGShapeElement.prototype.initElement,CVImageElement.prototype.prepareFrame=IImageElement.prototype.prepareFrame,CVImageElement.prototype.createContent=function(){if(this.img.width&&(this.assetData.w!==this.img.width||this.assetData.h!==this.img.height)){var e=createTag("canvas");e.width=this.assetData.w,e.height=this.assetData.h;var t,r,n=e.getContext("2d"),a=this.img.width,i=this.img.height,s=a/i,o=this.assetData.w/this.assetData.h,l=this.assetData.pr||this.globalData.renderConfig.imagePreserveAspectRatio;s>o&&"xMidYMid slice"===l||s<o&&"xMidYMid slice"!==l?t=(r=i)*o:r=(t=a)/o,n.drawImage(this.img,(a-t)/2,(i-r)/2,t,r,0,0,this.assetData.w,this.assetData.h),this.img=e}},CVImageElement.prototype.renderInnerContent=function(){this.canvasContext.drawImage(this.img,0,0)},CVImageElement.prototype.destroy=function(){this.img=null},extendPrototype([BaseElement,TransformElement,CVBaseElement,HierarchyElement,FrameElement,RenderableElement],CVSolidElement),CVSolidElement.prototype.initElement=SVGShapeElement.prototype.initElement,CVSolidElement.prototype.prepareFrame=IImageElement.prototype.prepareFrame,CVSolidElement.prototype.renderInnerContent=function(){this.globalData.renderer.ctxFillStyle(this.data.sc),this.globalData.renderer.ctxFillRect(0,0,this.data.sw,this.data.sh)},extendPrototype([BaseRenderer],CanvasRendererBase),CanvasRendererBase.prototype.createShape=function(e){return new CVShapeElement(e,this.globalData,this)},CanvasRendererBase.prototype.createText=function(e){return new CVTextElement(e,this.globalData,this)},CanvasRendererBase.prototype.createImage=function(e){return new CVImageElement(e,this.globalData,this)},CanvasRendererBase.prototype.createSolid=function(e){return new CVSolidElement(e,this.globalData,this)},CanvasRendererBase.prototype.createNull=SVGRenderer.prototype.createNull,CanvasRendererBase.prototype.ctxTransform=function(e){1===e[0]&&0===e[1]&&0===e[4]&&1===e[5]&&0===e[12]&&0===e[13]||this.canvasContext.transform(e[0],e[1],e[4],e[5],e[12],e[13])},CanvasRendererBase.prototype.ctxOpacity=function(e){this.canvasContext.globalAlpha*=e<0?0:e},CanvasRendererBase.prototype.ctxFillStyle=function(e){this.canvasContext.fillStyle=e},CanvasRendererBase.prototype.ctxStrokeStyle=function(e){this.canvasContext.strokeStyle=e},CanvasRendererBase.prototype.ctxLineWidth=function(e){this.canvasContext.lineWidth=e},CanvasRendererBase.prototype.ctxLineCap=function(e){this.canvasContext.lineCap=e},CanvasRendererBase.prototype.ctxLineJoin=function(e){this.canvasContext.lineJoin=e},CanvasRendererBase.prototype.ctxMiterLimit=function(e){this.canvasContext.miterLimit=e},CanvasRendererBase.prototype.ctxFill=function(e){this.canvasContext.fill(e)},CanvasRendererBase.prototype.ctxFillRect=function(e,t,r,n){this.canvasContext.fillRect(e,t,r,n)},CanvasRendererBase.prototype.ctxStroke=function(){this.canvasContext.stroke()},CanvasRendererBase.prototype.reset=function(){this.renderConfig.clearCanvas?this.contextData.reset():this.canvasContext.restore()},CanvasRendererBase.prototype.save=function(){this.canvasContext.save()},CanvasRendererBase.prototype.restore=function(e){this.renderConfig.clearCanvas?(e&&(this.globalData.blendMode="source-over"),this.contextData.restore(e)):this.canvasContext.restore()},CanvasRendererBase.prototype.configAnimation=function(e){if(this.animationItem.wrapper){this.animationItem.container=createTag("canvas");var t=this.animationItem.container.style;t.width="100%",t.height="100%";var r="0px 0px 0px";t.transformOrigin=r,t.mozTransformOrigin=r,t.webkitTransformOrigin=r,t["-webkit-transform"]=r,t.contentVisibility=this.renderConfig.contentVisibility,this.animationItem.wrapper.appendChild(this.animationItem.container),this.canvasContext=this.animationItem.container.getContext("2d"),this.renderConfig.className&&this.animationItem.container.setAttribute("class",this.renderConfig.className),this.renderConfig.id&&this.animationItem.container.setAttribute("id",this.renderConfig.id)}else this.canvasContext=this.renderConfig.context;this.contextData.setContext(this.canvasContext),this.data=e,this.layers=e.layers,this.transformCanvas={w:e.w,h:e.h,sx:0,sy:0,tx:0,ty:0},this.setupGlobalData(e,document.body),this.globalData.canvasContext=this.canvasContext,this.globalData.renderer=this,this.globalData.isDashed=!1,this.globalData.progressiveLoad=this.renderConfig.progressiveLoad,this.globalData.transformCanvas=this.transformCanvas,this.elements=createSizedArray(e.layers.length),this.updateContainerSize()},CanvasRendererBase.prototype.updateContainerSize=function(e,t){var r,n,a,i;if(this.reset(),e?(r=e,n=t,this.canvasContext.canvas.width=r,this.canvasContext.canvas.height=n):(this.animationItem.wrapper&&this.animationItem.container?(r=this.animationItem.wrapper.offsetWidth,n=this.animationItem.wrapper.offsetHeight):(r=this.canvasContext.canvas.width,n=this.canvasContext.canvas.height),this.canvasContext.canvas.width=r*this.renderConfig.dpr,this.canvasContext.canvas.height=n*this.renderConfig.dpr),-1!==this.renderConfig.preserveAspectRatio.indexOf("meet")||-1!==this.renderConfig.preserveAspectRatio.indexOf("slice")){var s=this.renderConfig.preserveAspectRatio.split(" "),o=s[1]||"meet",l=s[0]||"xMidYMid",u=l.substr(0,4),c=l.substr(4);a=r/n,(i=this.transformCanvas.w/this.transformCanvas.h)>a&&"meet"===o||i<a&&"slice"===o?(this.transformCanvas.sx=r/(this.transformCanvas.w/this.renderConfig.dpr),this.transformCanvas.sy=r/(this.transformCanvas.w/this.renderConfig.dpr)):(this.transformCanvas.sx=n/(this.transformCanvas.h/this.renderConfig.dpr),this.transformCanvas.sy=n/(this.transformCanvas.h/this.renderConfig.dpr)),this.transformCanvas.tx="xMid"===u&&(i<a&&"meet"===o||i>a&&"slice"===o)?(r-this.transformCanvas.w*(n/this.transformCanvas.h))/2*this.renderConfig.dpr:"xMax"===u&&(i<a&&"meet"===o||i>a&&"slice"===o)?(r-this.transformCanvas.w*(n/this.transformCanvas.h))*this.renderConfig.dpr:0,this.transformCanvas.ty="YMid"===c&&(i>a&&"meet"===o||i<a&&"slice"===o)?(n-this.transformCanvas.h*(r/this.transformCanvas.w))/2*this.renderConfig.dpr:"YMax"===c&&(i>a&&"meet"===o||i<a&&"slice"===o)?(n-this.transformCanvas.h*(r/this.transformCanvas.w))*this.renderConfig.dpr:0}else"none"===this.renderConfig.preserveAspectRatio?(this.transformCanvas.sx=r/(this.transformCanvas.w/this.renderConfig.dpr),this.transformCanvas.sy=n/(this.transformCanvas.h/this.renderConfig.dpr),this.transformCanvas.tx=0,this.transformCanvas.ty=0):(this.transformCanvas.sx=this.renderConfig.dpr,this.transformCanvas.sy=this.renderConfig.dpr,this.transformCanvas.tx=0,this.transformCanvas.ty=0);this.transformCanvas.props=[this.transformCanvas.sx,0,0,0,0,this.transformCanvas.sy,0,0,0,0,1,0,this.transformCanvas.tx,this.transformCanvas.ty,0,1],this.ctxTransform(this.transformCanvas.props),this.canvasContext.beginPath(),this.canvasContext.rect(0,0,this.transformCanvas.w,this.transformCanvas.h),this.canvasContext.closePath(),this.canvasContext.clip(),this.renderFrame(this.renderedFrame,!0)},CanvasRendererBase.prototype.destroy=function(){var e;for(this.renderConfig.clearCanvas&&this.animationItem.wrapper&&(this.animationItem.wrapper.innerText=""),e=(this.layers?this.layers.length:0)-1;e>=0;e-=1)this.elements[e]&&this.elements[e].destroy&&this.elements[e].destroy();this.elements.length=0,this.globalData.canvasContext=null,this.animationItem.container=null,this.destroyed=!0},CanvasRendererBase.prototype.renderFrame=function(e,t){if((this.renderedFrame!==e||!0!==this.renderConfig.clearCanvas||t)&&!this.destroyed&&-1!==e){var r;this.renderedFrame=e,this.globalData.frameNum=e-this.animationItem._isFirstFrame,this.globalData.frameId+=1,this.globalData._mdf=!this.renderConfig.clearCanvas||t,this.globalData.projectInterface.currentFrame=e;var n=this.layers.length;for(this.completeLayers||this.checkLayers(e),r=n-1;r>=0;r-=1)(this.completeLayers||this.elements[r])&&this.elements[r].prepareFrame(e-this.layers[r].st);if(this.globalData._mdf){for(!0===this.renderConfig.clearCanvas?this.canvasContext.clearRect(0,0,this.transformCanvas.w,this.transformCanvas.h):this.save(),r=n-1;r>=0;r-=1)(this.completeLayers||this.elements[r])&&this.elements[r].renderFrame();!0!==this.renderConfig.clearCanvas&&this.restore()}}},CanvasRendererBase.prototype.buildItem=function(e){var t=this.elements;if(!t[e]&&99!==this.layers[e].ty){var r=this.createItem(this.layers[e],this,this.globalData);t[e]=r,r.initExpressions()}},CanvasRendererBase.prototype.checkPendingElements=function(){for(;this.pendingElements.length;)this.pendingElements.pop().checkParenting()},CanvasRendererBase.prototype.hide=function(){this.animationItem.container.style.display="none"},CanvasRendererBase.prototype.show=function(){this.animationItem.container.style.display="block"},CVContextData.prototype.duplicate=function(){var e=2*this._length,t=0;for(t=this._length;t<e;t+=1)this.stack[t]=new CanvasContext;this._length=e},CVContextData.prototype.reset=function(){this.cArrPos=0,this.cTr.reset(),this.stack[this.cArrPos].opacity=1},CVContextData.prototype.restore=function(e){this.cArrPos-=1;var t,r=this.stack[this.cArrPos],n=r.transform,a=this.cTr.props;for(t=0;t<16;t+=1)a[t]=n[t];if(e){this.nativeContext.restore();var i=this.stack[this.cArrPos+1];this.appliedFillStyle=i.fillStyle,this.appliedStrokeStyle=i.strokeStyle,this.appliedLineWidth=i.lineWidth,this.appliedLineCap=i.lineCap,this.appliedLineJoin=i.lineJoin,this.appliedMiterLimit=i.miterLimit}this.nativeContext.setTransform(n[0],n[1],n[4],n[5],n[12],n[13]),(e||-1!==r.opacity&&this.currentOpacity!==r.opacity)&&(this.nativeContext.globalAlpha=r.opacity,this.currentOpacity=r.opacity),this.currentFillStyle=r.fillStyle,this.currentStrokeStyle=r.strokeStyle,this.currentLineWidth=r.lineWidth,this.currentLineCap=r.lineCap,this.currentLineJoin=r.lineJoin,this.currentMiterLimit=r.miterLimit},CVContextData.prototype.save=function(e){e&&this.nativeContext.save();var t=this.cTr.props;this._length<=this.cArrPos&&this.duplicate();var r,n=this.stack[this.cArrPos];for(r=0;r<16;r+=1)n.transform[r]=t[r];this.cArrPos+=1;var a=this.stack[this.cArrPos];a.opacity=n.opacity,a.fillStyle=n.fillStyle,a.strokeStyle=n.strokeStyle,a.lineWidth=n.lineWidth,a.lineCap=n.lineCap,a.lineJoin=n.lineJoin,a.miterLimit=n.miterLimit},CVContextData.prototype.setOpacity=function(e){this.stack[this.cArrPos].opacity=e},CVContextData.prototype.setContext=function(e){this.nativeContext=e},CVContextData.prototype.fillStyle=function(e){this.stack[this.cArrPos].fillStyle!==e&&(this.currentFillStyle=e,this.stack[this.cArrPos].fillStyle=e)},CVContextData.prototype.strokeStyle=function(e){this.stack[this.cArrPos].strokeStyle!==e&&(this.currentStrokeStyle=e,this.stack[this.cArrPos].strokeStyle=e)},CVContextData.prototype.lineWidth=function(e){this.stack[this.cArrPos].lineWidth!==e&&(this.currentLineWidth=e,this.stack[this.cArrPos].lineWidth=e)},CVContextData.prototype.lineCap=function(e){this.stack[this.cArrPos].lineCap!==e&&(this.currentLineCap=e,this.stack[this.cArrPos].lineCap=e)},CVContextData.prototype.lineJoin=function(e){this.stack[this.cArrPos].lineJoin!==e&&(this.currentLineJoin=e,this.stack[this.cArrPos].lineJoin=e)},CVContextData.prototype.miterLimit=function(e){this.stack[this.cArrPos].miterLimit!==e&&(this.currentMiterLimit=e,this.stack[this.cArrPos].miterLimit=e)},CVContextData.prototype.transform=function(e){this.transformMat.cloneFromProps(e);var t=this.cTr;this.transformMat.multiply(t),t.cloneFromProps(this.transformMat.props);var r=t.props;this.nativeContext.setTransform(r[0],r[1],r[4],r[5],r[12],r[13])},CVContextData.prototype.opacity=function(e){var t=this.stack[this.cArrPos].opacity;t*=e<0?0:e,this.stack[this.cArrPos].opacity!==t&&(this.currentOpacity!==e&&(this.nativeContext.globalAlpha=e,this.currentOpacity=e),this.stack[this.cArrPos].opacity=t)},CVContextData.prototype.fill=function(e){this.appliedFillStyle!==this.currentFillStyle&&(this.appliedFillStyle=this.currentFillStyle,this.nativeContext.fillStyle=this.appliedFillStyle),this.nativeContext.fill(e)},CVContextData.prototype.fillRect=function(e,t,r,n){this.appliedFillStyle!==this.currentFillStyle&&(this.appliedFillStyle=this.currentFillStyle,this.nativeContext.fillStyle=this.appliedFillStyle),this.nativeContext.fillRect(e,t,r,n)},CVContextData.prototype.stroke=function(){this.appliedStrokeStyle!==this.currentStrokeStyle&&(this.appliedStrokeStyle=this.currentStrokeStyle,this.nativeContext.strokeStyle=this.appliedStrokeStyle),this.appliedLineWidth!==this.currentLineWidth&&(this.appliedLineWidth=this.currentLineWidth,this.nativeContext.lineWidth=this.appliedLineWidth),this.appliedLineCap!==this.currentLineCap&&(this.appliedLineCap=this.currentLineCap,this.nativeContext.lineCap=this.appliedLineCap),this.appliedLineJoin!==this.currentLineJoin&&(this.appliedLineJoin=this.currentLineJoin,this.nativeContext.lineJoin=this.appliedLineJoin),this.appliedMiterLimit!==this.currentMiterLimit&&(this.appliedMiterLimit=this.currentMiterLimit,this.nativeContext.miterLimit=this.appliedMiterLimit),this.nativeContext.stroke()},extendPrototype([CanvasRendererBase,ICompElement,CVBaseElement],CVCompElement),CVCompElement.prototype.renderInnerContent=function(){var e,t=this.canvasContext;for(t.beginPath(),t.moveTo(0,0),t.lineTo(this.data.w,0),t.lineTo(this.data.w,this.data.h),t.lineTo(0,this.data.h),t.lineTo(0,0),t.clip(),e=this.layers.length-1;e>=0;e-=1)(this.completeLayers||this.elements[e])&&this.elements[e].renderFrame()},CVCompElement.prototype.destroy=function(){var e;for(e=this.layers.length-1;e>=0;e-=1)this.elements[e]&&this.elements[e].destroy();this.layers=null,this.elements=null},CVCompElement.prototype.createComp=function(e){return new CVCompElement(e,this.globalData,this)},extendPrototype([CanvasRendererBase],CanvasRenderer),CanvasRenderer.prototype.createComp=function(e){return new CVCompElement(e,this.globalData,this)},HBaseElement.prototype={checkBlendMode:function(){},initRendererElement:function(){this.baseElement=createTag(this.data.tg||"div"),this.data.hasMask?(this.svgElement=createNS("svg"),this.layerElement=createNS("g"),this.maskedElement=this.layerElement,this.svgElement.appendChild(this.layerElement),this.baseElement.appendChild(this.svgElement)):this.layerElement=this.baseElement,styleDiv(this.baseElement)},createContainerElements:function(){this.renderableEffectsManager=new CVEffects(this),this.transformedElement=this.baseElement,this.maskedElement=this.layerElement,this.data.ln&&this.layerElement.setAttribute("id",this.data.ln),this.data.cl&&this.layerElement.setAttribute("class",this.data.cl),0!==this.data.bm&&this.setBlendMode()},renderElement:function(){var e=this.transformedElement?this.transformedElement.style:{};if(this.finalTransform._matMdf){var t=this.finalTransform.mat.toCSS();e.transform=t,e.webkitTransform=t}this.finalTransform._opMdf&&(e.opacity=this.finalTransform.mProp.o.v)},renderFrame:function(){this.data.hd||this.hidden||(this.renderTransform(),this.renderRenderable(),this.renderElement(),this.renderInnerContent(),this._isFirstFrame&&(this._isFirstFrame=!1))},destroy:function(){this.layerElement=null,this.transformedElement=null,this.matteElement&&(this.matteElement=null),this.maskManager&&(this.maskManager.destroy(),this.maskManager=null)},createRenderableComponents:function(){this.maskManager=new MaskElement(this.data,this,this.globalData)},addEffects:function(){},setMatte:function(){}},HBaseElement.prototype.getBaseElement=SVGBaseElement.prototype.getBaseElement,HBaseElement.prototype.destroyBaseElement=HBaseElement.prototype.destroy,HBaseElement.prototype.buildElementParenting=BaseRenderer.prototype.buildElementParenting,extendPrototype([BaseElement,TransformElement,HBaseElement,HierarchyElement,FrameElement,RenderableDOMElement],HSolidElement),HSolidElement.prototype.createContent=function(){var e;this.data.hasMask?((e=createNS("rect")).setAttribute("width",this.data.sw),e.setAttribute("height",this.data.sh),e.setAttribute("fill",this.data.sc),this.svgElement.setAttribute("width",this.data.sw),this.svgElement.setAttribute("height",this.data.sh)):((e=createTag("div")).style.width=this.data.sw+"px",e.style.height=this.data.sh+"px",e.style.backgroundColor=this.data.sc),this.layerElement.appendChild(e)},extendPrototype([BaseElement,TransformElement,HSolidElement,SVGShapeElement,HBaseElement,HierarchyElement,FrameElement,RenderableElement],HShapeElement),HShapeElement.prototype._renderShapeFrame=HShapeElement.prototype.renderInnerContent,HShapeElement.prototype.createContent=function(){var e;if(this.baseElement.style.fontSize=0,this.data.hasMask)this.layerElement.appendChild(this.shapesContainer),e=this.svgElement;else{e=createNS("svg");var t=this.comp.data?this.comp.data:this.globalData.compSize;e.setAttribute("width",t.w),e.setAttribute("height",t.h),e.appendChild(this.shapesContainer),this.layerElement.appendChild(e)}this.searchShapes(this.shapesData,this.itemsData,this.prevViewData,this.shapesContainer,0,[],!0),this.filterUniqueShapes(),this.shapeCont=e},HShapeElement.prototype.getTransformedPoint=function(e,t){var r,n=e.length;for(r=0;r<n;r+=1)t=e[r].mProps.v.applyToPointArray(t[0],t[1],0);return t},HShapeElement.prototype.calculateShapeBoundingBox=function(e,t){var r,n,a,i,s,o=e.sh.v,l=e.transformers,u=o._length;if(!(u<=1)){for(r=0;r<u-1;r+=1)n=this.getTransformedPoint(l,o.v[r]),a=this.getTransformedPoint(l,o.o[r]),i=this.getTransformedPoint(l,o.i[r+1]),s=this.getTransformedPoint(l,o.v[r+1]),this.checkBounds(n,a,i,s,t);o.c&&(n=this.getTransformedPoint(l,o.v[r]),a=this.getTransformedPoint(l,o.o[r]),i=this.getTransformedPoint(l,o.i[0]),s=this.getTransformedPoint(l,o.v[0]),this.checkBounds(n,a,i,s,t))}},HShapeElement.prototype.checkBounds=function(e,t,r,n,a){this.getBoundsOfCurve(e,t,r,n);var i=this.shapeBoundingBox;a.x=bmMin(i.left,a.x),a.xMax=bmMax(i.right,a.xMax),a.y=bmMin(i.top,a.y),a.yMax=bmMax(i.bottom,a.yMax)},HShapeElement.prototype.shapeBoundingBox={left:0,right:0,top:0,bottom:0},HShapeElement.prototype.tempBoundingBox={x:0,xMax:0,y:0,yMax:0,width:0,height:0},HShapeElement.prototype.getBoundsOfCurve=function(e,t,r,n){for(var a,i,s,o,l,u,c,h=[[e[0],n[0]],[e[1],n[1]]],p=0;p<2;++p)i=6*e[p]-12*t[p]+6*r[p],a=-3*e[p]+9*t[p]-9*r[p]+3*n[p],s=3*t[p]-3*e[p],i|=0,s|=0,0==(a|=0)&&0===i||(0===a?(o=-s/i)>0&&o<1&&h[p].push(this.calculateF(o,e,t,r,n,p)):(l=i*i-4*s*a)>=0&&((u=(-i+bmSqrt(l))/(2*a))>0&&u<1&&h[p].push(this.calculateF(u,e,t,r,n,p)),(c=(-i-bmSqrt(l))/(2*a))>0&&c<1&&h[p].push(this.calculateF(c,e,t,r,n,p))));this.shapeBoundingBox.left=bmMin.apply(null,h[0]),this.shapeBoundingBox.top=bmMin.apply(null,h[1]),this.shapeBoundingBox.right=bmMax.apply(null,h[0]),this.shapeBoundingBox.bottom=bmMax.apply(null,h[1])},HShapeElement.prototype.calculateF=function(e,t,r,n,a,i){return bmPow(1-e,3)*t[i]+3*bmPow(1-e,2)*e*r[i]+3*(1-e)*bmPow(e,2)*n[i]+bmPow(e,3)*a[i]},HShapeElement.prototype.calculateBoundingBox=function(e,t){var r,n=e.length;for(r=0;r<n;r+=1)e[r]&&e[r].sh?this.calculateShapeBoundingBox(e[r],t):e[r]&&e[r].it?this.calculateBoundingBox(e[r].it,t):e[r]&&e[r].style&&e[r].w&&this.expandStrokeBoundingBox(e[r].w,t)},HShapeElement.prototype.expandStrokeBoundingBox=function(e,t){var r=0;if(e.keyframes){for(var n=0;n<e.keyframes.length;n+=1){var a=e.keyframes[n].s;a>r&&(r=a)}r*=e.mult}else r=e.v*e.mult;t.x-=r,t.xMax+=r,t.y-=r,t.yMax+=r},HShapeElement.prototype.currentBoxContains=function(e){return this.currentBBox.x<=e.x&&this.currentBBox.y<=e.y&&this.currentBBox.width+this.currentBBox.x>=e.x+e.width&&this.currentBBox.height+this.currentBBox.y>=e.y+e.height},HShapeElement.prototype.renderInnerContent=function(){if(this._renderShapeFrame(),!this.hidden&&(this._isFirstFrame||this._mdf)){var e=this.tempBoundingBox,t=999999;if(e.x=t,e.xMax=-t,e.y=t,e.yMax=-t,this.calculateBoundingBox(this.itemsData,e),e.width=e.xMax<e.x?0:e.xMax-e.x,e.height=e.yMax<e.y?0:e.yMax-e.y,this.currentBoxContains(e))return;var r=!1;if(this.currentBBox.w!==e.width&&(this.currentBBox.w=e.width,this.shapeCont.setAttribute("width",e.width),r=!0),this.currentBBox.h!==e.height&&(this.currentBBox.h=e.height,this.shapeCont.setAttribute("height",e.height),r=!0),r||this.currentBBox.x!==e.x||this.currentBBox.y!==e.y){this.currentBBox.w=e.width,this.currentBBox.h=e.height,this.currentBBox.x=e.x,this.currentBBox.y=e.y,this.shapeCont.setAttribute("viewBox",this.currentBBox.x+" "+this.currentBBox.y+" "+this.currentBBox.w+" "+this.currentBBox.h);var n=this.shapeCont.style,a="translate("+this.currentBBox.x+"px,"+this.currentBBox.y+"px)";n.transform=a,n.webkitTransform=a}}},extendPrototype([BaseElement,TransformElement,HBaseElement,HierarchyElement,FrameElement,RenderableDOMElement,ITextElement],HTextElement),HTextElement.prototype.createContent=function(){if(this.isMasked=this.checkMasks(),this.isMasked){this.renderType="svg",this.compW=this.comp.data.w,this.compH=this.comp.data.h,this.svgElement.setAttribute("width",this.compW),this.svgElement.setAttribute("height",this.compH);var e=createNS("g");this.maskedElement.appendChild(e),this.innerElem=e}else this.renderType="html",this.innerElem=this.layerElement;this.checkParenting()},HTextElement.prototype.buildNewText=function(){var e=this.textProperty.currentData;this.renderedLetters=createSizedArray(e.l?e.l.length:0);var t=this.innerElem.style,r=e.fc?this.buildColor(e.fc):"rgba(0,0,0,0)";t.fill=r,t.color=r,e.sc&&(t.stroke=this.buildColor(e.sc),t.strokeWidth=e.sw+"px");var n,a,i=this.globalData.fontManager.getFontByName(e.f);if(!this.globalData.fontManager.chars)if(t.fontSize=e.finalSize+"px",t.lineHeight=e.finalSize+"px",i.fClass)this.innerElem.className=i.fClass;else{t.fontFamily=i.fFamily;var s=e.fWeight,o=e.fStyle;t.fontStyle=o,t.fontWeight=s}var l,u,c,h=e.l;a=h.length;var p,f=this.mHelper,d="",m=0;for(n=0;n<a;n+=1){if(this.globalData.fontManager.chars?(this.textPaths[m]?l=this.textPaths[m]:((l=createNS("path")).setAttribute("stroke-linecap",lineCapEnum[1]),l.setAttribute("stroke-linejoin",lineJoinEnum[2]),l.setAttribute("stroke-miterlimit","4")),this.isMasked||(this.textSpans[m]?c=(u=this.textSpans[m]).children[0]:((u=createTag("div")).style.lineHeight=0,(c=createNS("svg")).appendChild(l),styleDiv(u)))):this.isMasked?l=this.textPaths[m]?this.textPaths[m]:createNS("text"):this.textSpans[m]?(u=this.textSpans[m],l=this.textPaths[m]):(styleDiv(u=createTag("span")),styleDiv(l=createTag("span")),u.appendChild(l)),this.globalData.fontManager.chars){var g,y=this.globalData.fontManager.getCharData(e.finalText[n],i.fStyle,this.globalData.fontManager.getFontByName(e.f).fFamily);if(g=y?y.data:null,f.reset(),g&&g.shapes&&g.shapes.length&&(p=g.shapes[0].it,f.scale(e.finalSize/100,e.finalSize/100),d=this.createPathShape(f,p),l.setAttribute("d",d)),this.isMasked)this.innerElem.appendChild(l);else{if(this.innerElem.appendChild(u),g&&g.shapes){document.body.appendChild(c);var v=c.getBBox();c.setAttribute("width",v.width+2),c.setAttribute("height",v.height+2),c.setAttribute("viewBox",v.x-1+" "+(v.y-1)+" "+(v.width+2)+" "+(v.height+2));var b=c.style,k="translate("+(v.x-1)+"px,"+(v.y-1)+"px)";b.transform=k,b.webkitTransform=k,h[n].yOffset=v.y-1}else c.setAttribute("width",1),c.setAttribute("height",1);u.appendChild(c)}}else if(l.textContent=h[n].val,l.setAttributeNS("http://www.w3.org/XML/1998/namespace","xml:space","preserve"),this.isMasked)this.innerElem.appendChild(l);else{this.innerElem.appendChild(u);var x=l.style,S="translate3d(0,"+-e.finalSize/1.2+"px,0)";x.transform=S,x.webkitTransform=S}this.isMasked?this.textSpans[m]=l:this.textSpans[m]=u,this.textSpans[m].style.display="block",this.textPaths[m]=l,m+=1}for(;m<this.textSpans.length;)this.textSpans[m].style.display="none",m+=1},HTextElement.prototype.renderInnerContent=function(){var e;if(this.validateText(),this.data.singleShape){if(!this._isFirstFrame&&!this.lettersChangedFlag)return;if(this.isMasked&&this.finalTransform._matMdf){this.svgElement.setAttribute("viewBox",-this.finalTransform.mProp.p.v[0]+" "+-this.finalTransform.mProp.p.v[1]+" "+this.compW+" "+this.compH),e=this.svgElement.style;var t="translate("+-this.finalTransform.mProp.p.v[0]+"px,"+-this.finalTransform.mProp.p.v[1]+"px)";e.transform=t,e.webkitTransform=t}}if(this.textAnimator.getMeasures(this.textProperty.currentData,this.lettersChangedFlag),this.lettersChangedFlag||this.textAnimator.lettersChangedFlag){var r,n,a,i,s,o=0,l=this.textAnimator.renderedLetters,u=this.textProperty.currentData.l;for(n=u.length,r=0;r<n;r+=1)u[r].n?o+=1:(i=this.textSpans[r],s=this.textPaths[r],a=l[o],o+=1,a._mdf.m&&(this.isMasked?i.setAttribute("transform",a.m):(i.style.webkitTransform=a.m,i.style.transform=a.m)),i.style.opacity=a.o,a.sw&&a._mdf.sw&&s.setAttribute("stroke-width",a.sw),a.sc&&a._mdf.sc&&s.setAttribute("stroke",a.sc),a.fc&&a._mdf.fc&&(s.setAttribute("fill",a.fc),s.style.color=a.fc));if(this.innerElem.getBBox&&!this.hidden&&(this._isFirstFrame||this._mdf)){var c=this.innerElem.getBBox();if(this.currentBBox.w!==c.width&&(this.currentBBox.w=c.width,this.svgElement.setAttribute("width",c.width)),this.currentBBox.h!==c.height&&(this.currentBBox.h=c.height,this.svgElement.setAttribute("height",c.height)),this.currentBBox.w!==c.width+2||this.currentBBox.h!==c.height+2||this.currentBBox.x!==c.x-1||this.currentBBox.y!==c.y-1){this.currentBBox.w=c.width+2,this.currentBBox.h=c.height+2,this.currentBBox.x=c.x-1,this.currentBBox.y=c.y-1,this.svgElement.setAttribute("viewBox",this.currentBBox.x+" "+this.currentBBox.y+" "+this.currentBBox.w+" "+this.currentBBox.h),e=this.svgElement.style;var h="translate("+this.currentBBox.x+"px,"+this.currentBBox.y+"px)";e.transform=h,e.webkitTransform=h}}}},extendPrototype([BaseElement,FrameElement,HierarchyElement],HCameraElement),HCameraElement.prototype.setup=function(){var e,t,r,n,a=this.comp.threeDElements.length;for(e=0;e<a;e+=1)if("3d"===(t=this.comp.threeDElements[e]).type){r=t.perspectiveElem.style,n=t.container.style;var i=this.pe.v+"px",s="0px 0px 0px",o="matrix3d(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)";r.perspective=i,r.webkitPerspective=i,n.transformOrigin=s,n.mozTransformOrigin=s,n.webkitTransformOrigin=s,r.transform=o,r.webkitTransform=o}},HCameraElement.prototype.createElements=function(){},HCameraElement.prototype.hide=function(){},HCameraElement.prototype.renderFrame=function(){var e,t,r=this._isFirstFrame;if(this.hierarchy)for(t=this.hierarchy.length,e=0;e<t;e+=1)r=this.hierarchy[e].finalTransform.mProp._mdf||r;if(r||this.pe._mdf||this.p&&this.p._mdf||this.px&&(this.px._mdf||this.py._mdf||this.pz._mdf)||this.rx._mdf||this.ry._mdf||this.rz._mdf||this.or._mdf||this.a&&this.a._mdf){if(this.mat.reset(),this.hierarchy)for(e=t=this.hierarchy.length-1;e>=0;e-=1){var n=this.hierarchy[e].finalTransform.mProp;this.mat.translate(-n.p.v[0],-n.p.v[1],n.p.v[2]),this.mat.rotateX(-n.or.v[0]).rotateY(-n.or.v[1]).rotateZ(n.or.v[2]),this.mat.rotateX(-n.rx.v).rotateY(-n.ry.v).rotateZ(n.rz.v),this.mat.scale(1/n.s.v[0],1/n.s.v[1],1/n.s.v[2]),this.mat.translate(n.a.v[0],n.a.v[1],n.a.v[2])}if(this.p?this.mat.translate(-this.p.v[0],-this.p.v[1],this.p.v[2]):this.mat.translate(-this.px.v,-this.py.v,this.pz.v),this.a){var a;a=this.p?[this.p.v[0]-this.a.v[0],this.p.v[1]-this.a.v[1],this.p.v[2]-this.a.v[2]]:[this.px.v-this.a.v[0],this.py.v-this.a.v[1],this.pz.v-this.a.v[2]];var i=Math.sqrt(Math.pow(a[0],2)+Math.pow(a[1],2)+Math.pow(a[2],2)),s=[a[0]/i,a[1]/i,a[2]/i],o=Math.sqrt(s[2]*s[2]+s[0]*s[0]),l=Math.atan2(s[1],o),u=Math.atan2(s[0],-s[2]);this.mat.rotateY(u).rotateX(-l)}this.mat.rotateX(-this.rx.v).rotateY(-this.ry.v).rotateZ(this.rz.v),this.mat.rotateX(-this.or.v[0]).rotateY(-this.or.v[1]).rotateZ(this.or.v[2]),this.mat.translate(this.globalData.compSize.w/2,this.globalData.compSize.h/2,0),this.mat.translate(0,0,this.pe.v);var c=!this._prevMat.equals(this.mat);if((c||this.pe._mdf)&&this.comp.threeDElements){var h,p,f;for(t=this.comp.threeDElements.length,e=0;e<t;e+=1)if("3d"===(h=this.comp.threeDElements[e]).type){if(c){var d=this.mat.toCSS();(f=h.container.style).transform=d,f.webkitTransform=d}this.pe._mdf&&((p=h.perspectiveElem.style).perspective=this.pe.v+"px",p.webkitPerspective=this.pe.v+"px")}this.mat.clone(this._prevMat)}}this._isFirstFrame=!1},HCameraElement.prototype.prepareFrame=function(e){this.prepareProperties(e,!0)},HCameraElement.prototype.destroy=function(){},HCameraElement.prototype.getBaseElement=function(){return null},extendPrototype([BaseElement,TransformElement,HBaseElement,HSolidElement,HierarchyElement,FrameElement,RenderableElement],HImageElement),HImageElement.prototype.createContent=function(){var e=this.globalData.getAssetsPath(this.assetData),t=new Image;this.data.hasMask?(this.imageElem=createNS("image"),this.imageElem.setAttribute("width",this.assetData.w+"px"),this.imageElem.setAttribute("height",this.assetData.h+"px"),this.imageElem.setAttributeNS("http://www.w3.org/1999/xlink","href",e),this.layerElement.appendChild(this.imageElem),this.baseElement.setAttribute("width",this.assetData.w),this.baseElement.setAttribute("height",this.assetData.h)):this.layerElement.appendChild(t),t.crossOrigin="anonymous",t.src=e,this.data.ln&&this.baseElement.setAttribute("id",this.data.ln)},extendPrototype([BaseRenderer],HybridRendererBase),HybridRendererBase.prototype.buildItem=SVGRenderer.prototype.buildItem,HybridRendererBase.prototype.checkPendingElements=function(){for(;this.pendingElements.length;)this.pendingElements.pop().checkParenting()},HybridRendererBase.prototype.appendElementInPos=function(e,t){var r=e.getBaseElement();if(r){var n=this.layers[t];if(n.ddd&&this.supports3d)this.addTo3dContainer(r,t);else if(this.threeDElements)this.addTo3dContainer(r,t);else{for(var a,i,s=0;s<t;)this.elements[s]&&!0!==this.elements[s]&&this.elements[s].getBaseElement&&(i=this.elements[s],a=(this.layers[s].ddd?this.getThreeDContainerByPos(s):i.getBaseElement())||a),s+=1;a?n.ddd&&this.supports3d||this.layerElement.insertBefore(r,a):n.ddd&&this.supports3d||this.layerElement.appendChild(r)}}},HybridRendererBase.prototype.createShape=function(e){return this.supports3d?new HShapeElement(e,this.globalData,this):new SVGShapeElement(e,this.globalData,this)},HybridRendererBase.prototype.createText=function(e){return this.supports3d?new HTextElement(e,this.globalData,this):new SVGTextLottieElement(e,this.globalData,this)},HybridRendererBase.prototype.createCamera=function(e){return this.camera=new HCameraElement(e,this.globalData,this),this.camera},HybridRendererBase.prototype.createImage=function(e){return this.supports3d?new HImageElement(e,this.globalData,this):new IImageElement(e,this.globalData,this)},HybridRendererBase.prototype.createSolid=function(e){return this.supports3d?new HSolidElement(e,this.globalData,this):new ISolidElement(e,this.globalData,this)},HybridRendererBase.prototype.createNull=SVGRenderer.prototype.createNull,HybridRendererBase.prototype.getThreeDContainerByPos=function(e){for(var t=0,r=this.threeDElements.length;t<r;){if(this.threeDElements[t].startPos<=e&&this.threeDElements[t].endPos>=e)return this.threeDElements[t].perspectiveElem;t+=1}return null},HybridRendererBase.prototype.createThreeDContainer=function(e,t){var r,n,a=createTag("div");styleDiv(a);var i=createTag("div");if(styleDiv(i),"3d"===t){(r=a.style).width=this.globalData.compSize.w+"px",r.height=this.globalData.compSize.h+"px";var s="50% 50%";r.webkitTransformOrigin=s,r.mozTransformOrigin=s,r.transformOrigin=s;var o="matrix3d(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)";(n=i.style).transform=o,n.webkitTransform=o}a.appendChild(i);var l={container:i,perspectiveElem:a,startPos:e,endPos:e,type:t};return this.threeDElements.push(l),l},HybridRendererBase.prototype.build3dContainers=function(){var e,t,r=this.layers.length,n="";for(e=0;e<r;e+=1)this.layers[e].ddd&&3!==this.layers[e].ty?("3d"!==n&&(n="3d",t=this.createThreeDContainer(e,"3d")),t.endPos=Math.max(t.endPos,e)):("2d"!==n&&(n="2d",t=this.createThreeDContainer(e,"2d")),t.endPos=Math.max(t.endPos,e));for(e=(r=this.threeDElements.length)-1;e>=0;e-=1)this.resizerElem.appendChild(this.threeDElements[e].perspectiveElem)},HybridRendererBase.prototype.addTo3dContainer=function(e,t){for(var r=0,n=this.threeDElements.length;r<n;){if(t<=this.threeDElements[r].endPos){for(var a,i=this.threeDElements[r].startPos;i<t;)this.elements[i]&&this.elements[i].getBaseElement&&(a=this.elements[i].getBaseElement()),i+=1;a?this.threeDElements[r].container.insertBefore(e,a):this.threeDElements[r].container.appendChild(e);break}r+=1}},HybridRendererBase.prototype.configAnimation=function(e){var t=createTag("div"),r=this.animationItem.wrapper,n=t.style;n.width=e.w+"px",n.height=e.h+"px",this.resizerElem=t,styleDiv(t),n.transformStyle="flat",n.mozTransformStyle="flat",n.webkitTransformStyle="flat",this.renderConfig.className&&t.setAttribute("class",this.renderConfig.className),r.appendChild(t),n.overflow="hidden";var a=createNS("svg");a.setAttribute("width","1"),a.setAttribute("height","1"),styleDiv(a),this.resizerElem.appendChild(a);var i=createNS("defs");a.appendChild(i),this.data=e,this.setupGlobalData(e,a),this.globalData.defs=i,this.layers=e.layers,this.layerElement=this.resizerElem,this.build3dContainers(),this.updateContainerSize()},HybridRendererBase.prototype.destroy=function(){var e;this.animationItem.wrapper&&(this.animationItem.wrapper.innerText=""),this.animationItem.container=null,this.globalData.defs=null;var t=this.layers?this.layers.length:0;for(e=0;e<t;e+=1)this.elements[e]&&this.elements[e].destroy&&this.elements[e].destroy();this.elements.length=0,this.destroyed=!0,this.animationItem=null},HybridRendererBase.prototype.updateContainerSize=function(){var e,t,r,n,a=this.animationItem.wrapper.offsetWidth,i=this.animationItem.wrapper.offsetHeight,s=a/i;this.globalData.compSize.w/this.globalData.compSize.h>s?(e=a/this.globalData.compSize.w,t=a/this.globalData.compSize.w,r=0,n=(i-this.globalData.compSize.h*(a/this.globalData.compSize.w))/2):(e=i/this.globalData.compSize.h,t=i/this.globalData.compSize.h,r=(a-this.globalData.compSize.w*(i/this.globalData.compSize.h))/2,n=0);var o=this.resizerElem.style;o.webkitTransform="matrix3d("+e+",0,0,0,0,"+t+",0,0,0,0,1,0,"+r+","+n+",0,1)",o.transform=o.webkitTransform},HybridRendererBase.prototype.renderFrame=SVGRenderer.prototype.renderFrame,HybridRendererBase.prototype.hide=function(){this.resizerElem.style.display="none"},HybridRendererBase.prototype.show=function(){this.resizerElem.style.display="block"},HybridRendererBase.prototype.initItems=function(){if(this.buildAllItems(),this.camera)this.camera.setup();else{var e,t=this.globalData.compSize.w,r=this.globalData.compSize.h,n=this.threeDElements.length;for(e=0;e<n;e+=1){var a=this.threeDElements[e].perspectiveElem.style;a.webkitPerspective=Math.sqrt(Math.pow(t,2)+Math.pow(r,2))+"px",a.perspective=a.webkitPerspective}}},HybridRendererBase.prototype.searchExtraCompositions=function(e){var t,r=e.length,n=createTag("div");for(t=0;t<r;t+=1)if(e[t].xt){var a=this.createComp(e[t],n,this.globalData.comp,null);a.initExpressions(),this.globalData.projectInterface.registerComposition(a)}},extendPrototype([HybridRendererBase,ICompElement,HBaseElement],HCompElement),HCompElement.prototype._createBaseContainerElements=HCompElement.prototype.createContainerElements,HCompElement.prototype.createContainerElements=function(){this._createBaseContainerElements(),this.data.hasMask?(this.svgElement.setAttribute("width",this.data.w),this.svgElement.setAttribute("height",this.data.h),this.transformedElement=this.baseElement):this.transformedElement=this.layerElement},HCompElement.prototype.addTo3dContainer=function(e,t){for(var r,n=0;n<t;)this.elements[n]&&this.elements[n].getBaseElement&&(r=this.elements[n].getBaseElement()),n+=1;r?this.layerElement.insertBefore(e,r):this.layerElement.appendChild(e)},HCompElement.prototype.createComp=function(e){return this.supports3d?new HCompElement(e,this.globalData,this):new SVGCompElement(e,this.globalData,this)},extendPrototype([HybridRendererBase],HybridRenderer),HybridRenderer.prototype.createComp=function(e){return this.supports3d?new HCompElement(e,this.globalData,this):new SVGCompElement(e,this.globalData,this)};var CompExpressionInterface=function(e){function t(t){for(var r=0,n=e.layers.length;r<n;){if(e.layers[r].nm===t||e.layers[r].ind===t)return e.elements[r].layerInterface;r+=1}return null}return Object.defineProperty(t,"_name",{value:e.data.nm}),t.layer=t,t.pixelAspect=1,t.height=e.data.h||e.globalData.compSize.h,t.width=e.data.w||e.globalData.compSize.w,t.pixelAspect=1,t.frameDuration=1/e.globalData.frameRate,t.displayStartTime=0,t.numLayers=e.layers.length,t};function _typeof$2(e){return _typeof$2="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$2(e)}function seedRandom(e,t){var r,n=this,a=256,i=6,s="random",o=t.pow(a,i),l=t.pow(2,52),u=2*l,c=a-1;function h(e){var t,r=e.length,n=this,i=0,s=n.i=n.j=0,o=n.S=[];for(r||(e=[r++]);i<a;)o[i]=i++;for(i=0;i<a;i++)o[i]=o[s=c&s+e[i%r]+(t=o[i])],o[s]=t;n.g=function(e){for(var t,r=0,i=n.i,s=n.j,o=n.S;e--;)t=o[i=c&i+1],r=r*a+o[c&(o[i]=o[s=c&s+t])+(o[s]=t)];return n.i=i,n.j=s,r}}function p(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function f(e,t){var r,n=[],a=_typeof$2(e);if(t&&"object"==a)for(r in e)try{n.push(f(e[r],t-1))}catch(e){}return n.length?n:"string"==a?e:e+"\0"}function d(e,t){for(var r,n=e+"",a=0;a<n.length;)t[c&a]=c&(r^=19*t[c&a])+n.charCodeAt(a++);return m(t)}function m(e){return String.fromCharCode.apply(0,e)}t["seed"+s]=function(c,g,y){var v=[],b=d(f((g=!0===g?{entropy:!0}:g||{}).entropy?[c,m(e)]:null===c?function(){try{if(r)return m(r.randomBytes(a));var t=new Uint8Array(a);return(n.crypto||n.msCrypto).getRandomValues(t),m(t)}catch(t){var i=n.navigator,s=i&&i.plugins;return[+new Date,n,s,n.screen,m(e)]}}():c,3),v),k=new h(v),x=function(){for(var e=k.g(i),t=o,r=0;e<l;)e=(e+r)*a,t*=a,r=k.g(1);for(;e>=u;)e/=2,t/=2,r>>>=1;return(e+r)/t};return x.int32=function(){return 0|k.g(4)},x.quick=function(){return k.g(4)/4294967296},x.double=x,d(m(k.S),e),(g.pass||y||function(e,r,n,a){return a&&(a.S&&p(a,k),e.state=function(){return p(k,{})}),n?(t[s]=e,r):e})(x,b,"global"in g?g.global:this==t,g.state)},d(t.random(),e)}function initialize$2(e){seedRandom([],e)}var propTypes={SHAPE:"shape"};function _typeof$1(e){return _typeof$1="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$1(e)}var ExpressionManager=function(){var ob={},Math=BMMath,window=null,document=null,XMLHttpRequest=null,fetch=null,frames=null,_lottieGlobal={};function resetFrame(){_lottieGlobal={}}function $bm_isInstanceOfArray(e){return e.constructor===Array||e.constructor===Float32Array}function isNumerable(e,t){return"number"===e||t instanceof Number||"boolean"===e||"string"===e}function $bm_neg(e){var t=_typeof$1(e);if("number"===t||e instanceof Number||"boolean"===t)return-e;if($bm_isInstanceOfArray(e)){var r,n=e.length,a=[];for(r=0;r<n;r+=1)a[r]=-e[r];return a}return e.propType?e.v:-e}initialize$2(BMMath);var easeInBez=BezierFactory.getBezierEasing(.333,0,.833,.833,"easeIn").get,easeOutBez=BezierFactory.getBezierEasing(.167,.167,.667,1,"easeOut").get,easeInOutBez=BezierFactory.getBezierEasing(.33,0,.667,1,"easeInOut").get;function sum(e,t){var r=_typeof$1(e),n=_typeof$1(t);if(isNumerable(r,e)&&isNumerable(n,t)||"string"===r||"string"===n)return e+t;if($bm_isInstanceOfArray(e)&&isNumerable(n,t))return(e=e.slice(0))[0]+=t,e;if(isNumerable(r,e)&&$bm_isInstanceOfArray(t))return(t=t.slice(0))[0]=e+t[0],t;if($bm_isInstanceOfArray(e)&&$bm_isInstanceOfArray(t)){for(var a=0,i=e.length,s=t.length,o=[];a<i||a<s;)("number"==typeof e[a]||e[a]instanceof Number)&&("number"==typeof t[a]||t[a]instanceof Number)?o[a]=e[a]+t[a]:o[a]=void 0===t[a]?e[a]:e[a]||t[a],a+=1;return o}return 0}var add=sum;function sub(e,t){var r=_typeof$1(e),n=_typeof$1(t);if(isNumerable(r,e)&&isNumerable(n,t))return"string"===r&&(e=parseInt(e,10)),"string"===n&&(t=parseInt(t,10)),e-t;if($bm_isInstanceOfArray(e)&&isNumerable(n,t))return(e=e.slice(0))[0]-=t,e;if(isNumerable(r,e)&&$bm_isInstanceOfArray(t))return(t=t.slice(0))[0]=e-t[0],t;if($bm_isInstanceOfArray(e)&&$bm_isInstanceOfArray(t)){for(var a=0,i=e.length,s=t.length,o=[];a<i||a<s;)("number"==typeof e[a]||e[a]instanceof Number)&&("number"==typeof t[a]||t[a]instanceof Number)?o[a]=e[a]-t[a]:o[a]=void 0===t[a]?e[a]:e[a]||t[a],a+=1;return o}return 0}function mul(e,t){var r,n,a,i=_typeof$1(e),s=_typeof$1(t);if(isNumerable(i,e)&&isNumerable(s,t))return e*t;if($bm_isInstanceOfArray(e)&&isNumerable(s,t)){for(a=e.length,r=createTypedArray("float32",a),n=0;n<a;n+=1)r[n]=e[n]*t;return r}if(isNumerable(i,e)&&$bm_isInstanceOfArray(t)){for(a=t.length,r=createTypedArray("float32",a),n=0;n<a;n+=1)r[n]=e*t[n];return r}return 0}function div(e,t){var r,n,a,i=_typeof$1(e),s=_typeof$1(t);if(isNumerable(i,e)&&isNumerable(s,t))return e/t;if($bm_isInstanceOfArray(e)&&isNumerable(s,t)){for(a=e.length,r=createTypedArray("float32",a),n=0;n<a;n+=1)r[n]=e[n]/t;return r}if(isNumerable(i,e)&&$bm_isInstanceOfArray(t)){for(a=t.length,r=createTypedArray("float32",a),n=0;n<a;n+=1)r[n]=e/t[n];return r}return 0}function mod(e,t){return"string"==typeof e&&(e=parseInt(e,10)),"string"==typeof t&&(t=parseInt(t,10)),e%t}var $bm_sum=sum,$bm_sub=sub,$bm_mul=mul,$bm_div=div,$bm_mod=mod;function clamp(e,t,r){if(t>r){var n=r;r=t,t=n}return Math.min(Math.max(e,t),r)}function radiansToDegrees(e){return e/degToRads}var radians_to_degrees=radiansToDegrees;function degreesToRadians(e){return e*degToRads}var degrees_to_radians=radiansToDegrees,helperLengthArray=[0,0,0,0,0,0];function length(e,t){if("number"==typeof e||e instanceof Number)return t=t||0,Math.abs(e-t);var r;t||(t=helperLengthArray);var n=Math.min(e.length,t.length),a=0;for(r=0;r<n;r+=1)a+=Math.pow(t[r]-e[r],2);return Math.sqrt(a)}function normalize(e){return div(e,length(e))}function rgbToHsl(e){var t,r,n=e[0],a=e[1],i=e[2],s=Math.max(n,a,i),o=Math.min(n,a,i),l=(s+o)/2;if(s===o)t=0,r=0;else{var u=s-o;switch(r=l>.5?u/(2-s-o):u/(s+o),s){case n:t=(a-i)/u+(a<i?6:0);break;case a:t=(i-n)/u+2;break;case i:t=(n-a)/u+4}t/=6}return[t,r,l,e[3]]}function hue2rgb(e,t,r){return r<0&&(r+=1),r>1&&(r-=1),r<1/6?e+6*(t-e)*r:r<.5?t:r<2/3?e+(t-e)*(2/3-r)*6:e}function hslToRgb(e){var t,r,n,a=e[0],i=e[1],s=e[2];if(0===i)t=s,n=s,r=s;else{var o=s<.5?s*(1+i):s+i-s*i,l=2*s-o;t=hue2rgb(l,o,a+1/3),r=hue2rgb(l,o,a),n=hue2rgb(l,o,a-1/3)}return[t,r,n,e[3]]}function linear(e,t,r,n,a){if(void 0!==n&&void 0!==a||(n=t,a=r,t=0,r=1),r<t){var i=r;r=t,t=i}if(e<=t)return n;if(e>=r)return a;var s,o=r===t?0:(e-t)/(r-t);if(!n.length)return n+(a-n)*o;var l=n.length,u=createTypedArray("float32",l);for(s=0;s<l;s+=1)u[s]=n[s]+(a[s]-n[s])*o;return u}function random(e,t){if(void 0===t&&(void 0===e?(e=0,t=1):(t=e,e=void 0)),t.length){var r,n=t.length;e||(e=createTypedArray("float32",n));var a=createTypedArray("float32",n),i=BMMath.random();for(r=0;r<n;r+=1)a[r]=e[r]+i*(t[r]-e[r]);return a}return void 0===e&&(e=0),e+BMMath.random()*(t-e)}function createPath(e,t,r,n){var a,i=e.length,s=shapePool.newElement();s.setPathData(!!n,i);var o,l,u=[0,0];for(a=0;a<i;a+=1)o=t&&t[a]?t[a]:u,l=r&&r[a]?r[a]:u,s.setTripleAt(e[a][0],e[a][1],l[0]+e[a][0],l[1]+e[a][1],o[0]+e[a][0],o[1]+e[a][1],a,!0);return s}function initiateExpression(elem,data,property){function noOp(e){return e}if(!elem.globalData.renderConfig.runExpressions)return noOp;var val=data.x,needsVelocity=/velocity(?![\w\d])/.test(val),_needsRandom=-1!==val.indexOf("random"),elemType=elem.data.ty,transform,$bm_transform,content,effect,thisProperty=property;thisProperty.valueAtTime=thisProperty.getValueAtTime,Object.defineProperty(thisProperty,"value",{get:function(){return thisProperty.v}}),elem.comp.frameDuration=1/elem.comp.globalData.frameRate,elem.comp.displayStartTime=0;var inPoint=elem.data.ip/elem.comp.globalData.frameRate,outPoint=elem.data.op/elem.comp.globalData.frameRate,width=elem.data.sw?elem.data.sw:0,height=elem.data.sh?elem.data.sh:0,name=elem.data.nm,loopIn,loop_in,loopOut,loop_out,smooth,toWorld,fromWorld,fromComp,toComp,fromCompToSurface,position,rotation,anchorPoint,scale,thisLayer,thisComp,mask,valueAtTime,velocityAtTime,scoped_bm_rt,expression_function=eval("[function _expression_function(){"+val+";scoped_bm_rt=$bm_rt}]")[0],numKeys=property.kf?data.k.length:0,active=!this.data||!0!==this.data.hd,wiggle=function(e,t){var r,n,a=this.pv.length?this.pv.length:1,i=createTypedArray("float32",a),s=Math.floor(5*time);for(r=0,n=0;r<s;){for(n=0;n<a;n+=1)i[n]+=-t+2*t*BMMath.random();r+=1}var o=5*time,l=o-Math.floor(o),u=createTypedArray("float32",a);if(a>1){for(n=0;n<a;n+=1)u[n]=this.pv[n]+i[n]+(-t+2*t*BMMath.random())*l;return u}return this.pv+i[0]+(-t+2*t*BMMath.random())*l}.bind(this);function loopInDuration(e,t){return loopIn(e,t,!0)}function loopOutDuration(e,t){return loopOut(e,t,!0)}thisProperty.loopIn&&(loopIn=thisProperty.loopIn.bind(thisProperty),loop_in=loopIn),thisProperty.loopOut&&(loopOut=thisProperty.loopOut.bind(thisProperty),loop_out=loopOut),thisProperty.smooth&&(smooth=thisProperty.smooth.bind(thisProperty)),this.getValueAtTime&&(valueAtTime=this.getValueAtTime.bind(this)),this.getVelocityAtTime&&(velocityAtTime=this.getVelocityAtTime.bind(this));var comp=elem.comp.globalData.projectInterface.bind(elem.comp.globalData.projectInterface),time,velocity,value,text,textIndex,textTotal,selectorValue;function lookAt(e,t){var r=[t[0]-e[0],t[1]-e[1],t[2]-e[2]],n=Math.atan2(r[0],Math.sqrt(r[1]*r[1]+r[2]*r[2]))/degToRads;return[-Math.atan2(r[1],r[2])/degToRads,n,0]}function easeOut(e,t,r,n,a){return applyEase(easeOutBez,e,t,r,n,a)}function easeIn(e,t,r,n,a){return applyEase(easeInBez,e,t,r,n,a)}function ease(e,t,r,n,a){return applyEase(easeInOutBez,e,t,r,n,a)}function applyEase(e,t,r,n,a,i){void 0===a?(a=r,i=n):t=(t-r)/(n-r),t>1?t=1:t<0&&(t=0);var s=e(t);if($bm_isInstanceOfArray(a)){var o,l=a.length,u=createTypedArray("float32",l);for(o=0;o<l;o+=1)u[o]=(i[o]-a[o])*s+a[o];return u}return(i-a)*s+a}function nearestKey(e){var t,r,n,a=data.k.length;if(data.k.length&&"number"!=typeof data.k[0])if(r=-1,(e*=elem.comp.globalData.frameRate)<data.k[0].t)r=1,n=data.k[0].t;else{for(t=0;t<a-1;t+=1){if(e===data.k[t].t){r=t+1,n=data.k[t].t;break}if(e>data.k[t].t&&e<data.k[t+1].t){e-data.k[t].t>data.k[t+1].t-e?(r=t+2,n=data.k[t+1].t):(r=t+1,n=data.k[t].t);break}}-1===r&&(r=t+1,n=data.k[t].t)}else r=0,n=0;var i={};return i.index=r,i.time=n/elem.comp.globalData.frameRate,i}function key(e){var t,r,n;if(!data.k.length||"number"==typeof data.k[0])throw new Error("The property has no keyframe at index "+e);e-=1,t={time:data.k[e].t/elem.comp.globalData.frameRate,value:[]};var a=Object.prototype.hasOwnProperty.call(data.k[e],"s")?data.k[e].s:data.k[e-1].e;for(n=a.length,r=0;r<n;r+=1)t[r]=a[r],t.value[r]=a[r];return t}function framesToTime(e,t){return t||(t=elem.comp.globalData.frameRate),e/t}function timeToFrames(e,t){return e||0===e||(e=time),t||(t=elem.comp.globalData.frameRate),e*t}function seedRandom(e){BMMath.seedrandom(randSeed+e)}function sourceRectAtTime(){return elem.sourceRectAtTime()}function substring(e,t){return"string"==typeof value?void 0===t?value.substring(e):value.substring(e,t):""}function substr(e,t){return"string"==typeof value?void 0===t?value.substr(e):value.substr(e,t):""}function posterizeTime(e){time=0===e?0:Math.floor(time*e)/e,value=valueAtTime(time)}var index=elem.data.ind,hasParent=!(!elem.hierarchy||!elem.hierarchy.length),parent,randSeed=Math.floor(1e6*Math.random()),globalData=elem.globalData;function executeExpression(e){return value=e,this.frameExpressionId===elem.globalData.frameId&&"textSelector"!==this.propType?value:("textSelector"===this.propType&&(textIndex=this.textIndex,textTotal=this.textTotal,selectorValue=this.selectorValue),thisLayer||(text=elem.layerInterface.text,thisLayer=elem.layerInterface,thisComp=elem.comp.compInterface,toWorld=thisLayer.toWorld.bind(thisLayer),fromWorld=thisLayer.fromWorld.bind(thisLayer),fromComp=thisLayer.fromComp.bind(thisLayer),toComp=thisLayer.toComp.bind(thisLayer),mask=thisLayer.mask?thisLayer.mask.bind(thisLayer):null,fromCompToSurface=fromComp),transform||(transform=elem.layerInterface("ADBE Transform Group"),$bm_transform=transform,transform&&(anchorPoint=transform.anchorPoint)),4!==elemType||content||(content=thisLayer("ADBE Root Vectors Group")),effect||(effect=thisLayer(4)),(hasParent=!(!elem.hierarchy||!elem.hierarchy.length))&&!parent&&(parent=elem.hierarchy[0].layerInterface),time=this.comp.renderedFrame/this.comp.globalData.frameRate,_needsRandom&&seedRandom(randSeed+time),needsVelocity&&(velocity=velocityAtTime(time)),expression_function(),this.frameExpressionId=elem.globalData.frameId,scoped_bm_rt=scoped_bm_rt.propType===propTypes.SHAPE?scoped_bm_rt.v:scoped_bm_rt)}return executeExpression.__preventDeadCodeRemoval=[$bm_transform,anchorPoint,time,velocity,inPoint,outPoint,width,height,name,loop_in,loop_out,smooth,toComp,fromCompToSurface,toWorld,fromWorld,mask,position,rotation,scale,thisComp,numKeys,active,wiggle,loopInDuration,loopOutDuration,comp,lookAt,easeOut,easeIn,ease,nearestKey,key,text,textIndex,textTotal,selectorValue,framesToTime,timeToFrames,sourceRectAtTime,substring,substr,posterizeTime,index,globalData],executeExpression}return ob.initiateExpression=initiateExpression,ob.__preventDeadCodeRemoval=[window,document,XMLHttpRequest,fetch,frames,$bm_neg,add,$bm_sum,$bm_sub,$bm_mul,$bm_div,$bm_mod,clamp,radians_to_degrees,degreesToRadians,degrees_to_radians,normalize,rgbToHsl,hslToRgb,linear,random,createPath,_lottieGlobal],ob.resetFrame=resetFrame,ob}(),Expressions=function(){var e={initExpressions:function(e){var t=0,r=[];e.renderer.compInterface=CompExpressionInterface(e.renderer),e.renderer.globalData.projectInterface.registerComposition(e.renderer),e.renderer.globalData.pushExpression=function(){t+=1},e.renderer.globalData.popExpression=function(){0==(t-=1)&&function(){var e,t=r.length;for(e=0;e<t;e+=1)r[e].release();r.length=0}()},e.renderer.globalData.registerExpressionProperty=function(e){-1===r.indexOf(e)&&r.push(e)}}};return e.resetFrame=ExpressionManager.resetFrame,e}(),MaskManagerInterface=function(){function e(e,t){this._mask=e,this._data=t}return Object.defineProperty(e.prototype,"maskPath",{get:function(){return this._mask.prop.k&&this._mask.prop.getValue(),this._mask.prop}}),Object.defineProperty(e.prototype,"maskOpacity",{get:function(){return this._mask.op.k&&this._mask.op.getValue(),100*this._mask.op.v}}),function(t){var r,n=createSizedArray(t.viewData.length),a=t.viewData.length;for(r=0;r<a;r+=1)n[r]=new e(t.viewData[r],t.masksProperties[r]);return function(e){for(r=0;r<a;){if(t.masksProperties[r].nm===e)return n[r];r+=1}return null}}}(),ExpressionPropertyInterface=function(){var e={pv:0,v:0,mult:1},t={pv:[0,0,0],v:[0,0,0],mult:1};function r(e,t,r){Object.defineProperty(e,"velocity",{get:function(){return t.getVelocityAtTime(t.comp.currentFrame)}}),e.numKeys=t.keyframes?t.keyframes.length:0,e.key=function(n){if(!e.numKeys)return 0;var a="";a="s"in t.keyframes[n-1]?t.keyframes[n-1].s:"e"in t.keyframes[n-2]?t.keyframes[n-2].e:t.keyframes[n-2].s;var i="unidimensional"===r?new Number(a):Object.assign({},a);return i.time=t.keyframes[n-1].t/t.elem.comp.globalData.frameRate,i.value="unidimensional"===r?a[0]:a,i},e.valueAtTime=t.getValueAtTime,e.speedAtTime=t.getSpeedAtTime,e.velocityAtTime=t.getVelocityAtTime,e.propertyGroup=t.propertyGroup}function n(){return e}return function(a){return a?"unidimensional"===a.propType?function(t){t&&"pv"in t||(t=e);var n=1/t.mult,a=t.pv*n,i=new Number(a);return i.value=a,r(i,t,"unidimensional"),function(){return t.k&&t.getValue(),a=t.v*n,i.value!==a&&((i=new Number(a)).value=a,r(i,t,"unidimensional")),i}}(a):function(e){e&&"pv"in e||(e=t);var n=1/e.mult,a=e.data&&e.data.l||e.pv.length,i=createTypedArray("float32",a),s=createTypedArray("float32",a);return i.value=s,r(i,e,"multidimensional"),function(){e.k&&e.getValue();for(var t=0;t<a;t+=1)s[t]=e.v[t]*n,i[t]=s[t];return i}}(a):n}}(),TransformExpressionInterface=function(e){function t(e){switch(e){case"scale":case"Scale":case"ADBE Scale":case 6:return t.scale;case"rotation":case"Rotation":case"ADBE Rotation":case"ADBE Rotate Z":case 10:return t.rotation;case"ADBE Rotate X":return t.xRotation;case"ADBE Rotate Y":return t.yRotation;case"position":case"Position":case"ADBE Position":case 2:return t.position;case"ADBE Position_0":return t.xPosition;case"ADBE Position_1":return t.yPosition;case"ADBE Position_2":return t.zPosition;case"anchorPoint":case"AnchorPoint":case"Anchor Point":case"ADBE AnchorPoint":case 1:return t.anchorPoint;case"opacity":case"Opacity":case 11:return t.opacity;default:return null}}var r,n,a,i;return Object.defineProperty(t,"rotation",{get:ExpressionPropertyInterface(e.r||e.rz)}),Object.defineProperty(t,"zRotation",{get:ExpressionPropertyInterface(e.rz||e.r)}),Object.defineProperty(t,"xRotation",{get:ExpressionPropertyInterface(e.rx)}),Object.defineProperty(t,"yRotation",{get:ExpressionPropertyInterface(e.ry)}),Object.defineProperty(t,"scale",{get:ExpressionPropertyInterface(e.s)}),e.p?i=ExpressionPropertyInterface(e.p):(r=ExpressionPropertyInterface(e.px),n=ExpressionPropertyInterface(e.py),e.pz&&(a=ExpressionPropertyInterface(e.pz))),Object.defineProperty(t,"position",{get:function(){return e.p?i():[r(),n(),a?a():0]}}),Object.defineProperty(t,"xPosition",{get:ExpressionPropertyInterface(e.px)}),Object.defineProperty(t,"yPosition",{get:ExpressionPropertyInterface(e.py)}),Object.defineProperty(t,"zPosition",{get:ExpressionPropertyInterface(e.pz)}),Object.defineProperty(t,"anchorPoint",{get:ExpressionPropertyInterface(e.a)}),Object.defineProperty(t,"opacity",{get:ExpressionPropertyInterface(e.o)}),Object.defineProperty(t,"skew",{get:ExpressionPropertyInterface(e.sk)}),Object.defineProperty(t,"skewAxis",{get:ExpressionPropertyInterface(e.sa)}),Object.defineProperty(t,"orientation",{get:ExpressionPropertyInterface(e.or)}),t},LayerExpressionInterface=function(){function e(e){var t=new Matrix;return void 0!==e?this._elem.finalTransform.mProp.getValueAtTime(e).clone(t):this._elem.finalTransform.mProp.applyToMatrix(t),t}function t(e,t){var r=this.getMatrix(t);return r.props[12]=0,r.props[13]=0,r.props[14]=0,this.applyPoint(r,e)}function r(e,t){var r=this.getMatrix(t);return this.applyPoint(r,e)}function n(e,t){var r=this.getMatrix(t);return r.props[12]=0,r.props[13]=0,r.props[14]=0,this.invertPoint(r,e)}function a(e,t){var r=this.getMatrix(t);return this.invertPoint(r,e)}function i(e,t){if(this._elem.hierarchy&&this._elem.hierarchy.length){var r,n=this._elem.hierarchy.length;for(r=0;r<n;r+=1)this._elem.hierarchy[r].finalTransform.mProp.applyToMatrix(e)}return e.applyToPointArray(t[0],t[1],t[2]||0)}function s(e,t){if(this._elem.hierarchy&&this._elem.hierarchy.length){var r,n=this._elem.hierarchy.length;for(r=0;r<n;r+=1)this._elem.hierarchy[r].finalTransform.mProp.applyToMatrix(e)}return e.inversePoint(t)}function o(e){var t=new Matrix;if(t.reset(),this._elem.finalTransform.mProp.applyToMatrix(t),this._elem.hierarchy&&this._elem.hierarchy.length){var r,n=this._elem.hierarchy.length;for(r=0;r<n;r+=1)this._elem.hierarchy[r].finalTransform.mProp.applyToMatrix(t);return t.inversePoint(e)}return t.inversePoint(e)}function l(){return[1,1,1,1]}return function(u){var c;function h(e){switch(e){case"ADBE Root Vectors Group":case"Contents":case 2:return h.shapeInterface;case 1:case 6:case"Transform":case"transform":case"ADBE Transform Group":return c;case 4:case"ADBE Effect Parade":case"effects":case"Effects":return h.effect;case"ADBE Text Properties":return h.textInterface;default:return null}}h.getMatrix=e,h.invertPoint=s,h.applyPoint=i,h.toWorld=r,h.toWorldVec=t,h.fromWorld=a,h.fromWorldVec=n,h.toComp=r,h.fromComp=o,h.sampleImage=l,h.sourceRectAtTime=u.sourceRectAtTime.bind(u),h._elem=u;var p=getDescriptor(c=TransformExpressionInterface(u.finalTransform.mProp),"anchorPoint");return Object.defineProperties(h,{hasParent:{get:function(){return u.hierarchy.length}},parent:{get:function(){return u.hierarchy[0].layerInterface}},rotation:getDescriptor(c,"rotation"),scale:getDescriptor(c,"scale"),position:getDescriptor(c,"position"),opacity:getDescriptor(c,"opacity"),anchorPoint:p,anchor_point:p,transform:{get:function(){return c}},active:{get:function(){return u.isInRange}}}),h.startTime=u.data.st,h.index=u.data.ind,h.source=u.data.refId,h.height=0===u.data.ty?u.data.h:100,h.width=0===u.data.ty?u.data.w:100,h.inPoint=u.data.ip/u.comp.globalData.frameRate,h.outPoint=u.data.op/u.comp.globalData.frameRate,h._name=u.data.nm,h.registerMaskInterface=function(e){h.mask=new MaskManagerInterface(e,u)},h.registerEffectsInterface=function(e){h.effect=e},h}}(),propertyGroupFactory=function(e,t){return function(r){return(r=void 0===r?1:r)<=0?e:t(r-1)}},PropertyInterface=function(e,t){var r={_name:e};return function(e){return(e=void 0===e?1:e)<=0?r:t(e-1)}},EffectsExpressionInterface=function(){function e(r,n,a,i){function s(e){for(var t=r.ef,n=0,a=t.length;n<a;){if(e===t[n].nm||e===t[n].mn||e===t[n].ix)return 5===t[n].ty?u[n]:u[n]();n+=1}throw new Error}var o,l=propertyGroupFactory(s,a),u=[],c=r.ef.length;for(o=0;o<c;o+=1)5===r.ef[o].ty?u.push(e(r.ef[o],n.effectElements[o],n.effectElements[o].propertyGroup,i)):u.push(t(n.effectElements[o],r.ef[o].ty,i,l));return"ADBE Color Control"===r.mn&&Object.defineProperty(s,"color",{get:function(){return u[0]()}}),Object.defineProperties(s,{numProperties:{get:function(){return r.np}},_name:{value:r.nm},propertyGroup:{value:l}}),s.enabled=0!==r.en,s.active=s.enabled,s}function t(e,t,r,n){var a=ExpressionPropertyInterface(e.p);return e.p.setGroupProperty&&e.p.setGroupProperty(PropertyInterface("",n)),function(){return 10===t?r.comp.compInterface(e.p.v):a()}}return{createEffectsInterface:function(t,r){if(t.effectsManager){var n,a=[],i=t.data.ef,s=t.effectsManager.effectElements.length;for(n=0;n<s;n+=1)a.push(e(i[n],t.effectsManager.effectElements[n],r,t));var o=t.data.ef||[],l=function(e){for(n=0,s=o.length;n<s;){if(e===o[n].nm||e===o[n].mn||e===o[n].ix)return a[n];n+=1}return null};return Object.defineProperty(l,"numProperties",{get:function(){return o.length}}),l}return null}}}(),ShapePathInterface=function(e,t,r){var n=t.sh;function a(e){return"Shape"===e||"shape"===e||"Path"===e||"path"===e||"ADBE Vector Shape"===e||2===e?a.path:null}var i=propertyGroupFactory(a,r);return n.setGroupProperty(PropertyInterface("Path",i)),Object.defineProperties(a,{path:{get:function(){return n.k&&n.getValue(),n}},shape:{get:function(){return n.k&&n.getValue(),n}},_name:{value:e.nm},ix:{value:e.ix},propertyIndex:{value:e.ix},mn:{value:e.mn},propertyGroup:{value:r}}),a},ShapeExpressionInterface=function(){function e(e,s,p){var f,d=[],m=e?e.length:0;for(f=0;f<m;f+=1)"gr"===e[f].ty?d.push(t(e[f],s[f],p)):"fl"===e[f].ty?d.push(r(e[f],s[f],p)):"st"===e[f].ty?d.push(a(e[f],s[f],p)):"tm"===e[f].ty?d.push(i(e[f],s[f],p)):"tr"===e[f].ty||("el"===e[f].ty?d.push(o(e[f],s[f],p)):"sr"===e[f].ty?d.push(l(e[f],s[f],p)):"sh"===e[f].ty?d.push(ShapePathInterface(e[f],s[f],p)):"rc"===e[f].ty?d.push(u(e[f],s[f],p)):"rd"===e[f].ty?d.push(c(e[f],s[f],p)):"rp"===e[f].ty?d.push(h(e[f],s[f],p)):"gf"===e[f].ty?d.push(n(e[f],s[f],p)):d.push((e[f],s[f],function(){return null})));return d}function t(t,r,n){var a=function(e){switch(e){case"ADBE Vectors Group":case"Contents":case 2:return a.content;default:return a.transform}};a.propertyGroup=propertyGroupFactory(a,n);var i=function(t,r,n){var a,i=function(e){for(var t=0,r=a.length;t<r;){if(a[t]._name===e||a[t].mn===e||a[t].propertyIndex===e||a[t].ix===e||a[t].ind===e)return a[t];t+=1}return"number"==typeof e?a[e-1]:null};i.propertyGroup=propertyGroupFactory(i,n),a=e(t.it,r.it,i.propertyGroup),i.numProperties=a.length;var o=s(t.it[t.it.length-1],r.it[r.it.length-1],i.propertyGroup);return i.transform=o,i.propertyIndex=t.cix,i._name=t.nm,i}(t,r,a.propertyGroup),o=s(t.it[t.it.length-1],r.it[r.it.length-1],a.propertyGroup);return a.content=i,a.transform=o,Object.defineProperty(a,"_name",{get:function(){return t.nm}}),a.numProperties=t.np,a.propertyIndex=t.ix,a.nm=t.nm,a.mn=t.mn,a}function r(e,t,r){function n(e){return"Color"===e||"color"===e?n.color:"Opacity"===e||"opacity"===e?n.opacity:null}return Object.defineProperties(n,{color:{get:ExpressionPropertyInterface(t.c)},opacity:{get:ExpressionPropertyInterface(t.o)},_name:{value:e.nm},mn:{value:e.mn}}),t.c.setGroupProperty(PropertyInterface("Color",r)),t.o.setGroupProperty(PropertyInterface("Opacity",r)),n}function n(e,t,r){function n(e){return"Start Point"===e||"start point"===e?n.startPoint:"End Point"===e||"end point"===e?n.endPoint:"Opacity"===e||"opacity"===e?n.opacity:null}return Object.defineProperties(n,{startPoint:{get:ExpressionPropertyInterface(t.s)},endPoint:{get:ExpressionPropertyInterface(t.e)},opacity:{get:ExpressionPropertyInterface(t.o)},type:{get:function(){return"a"}},_name:{value:e.nm},mn:{value:e.mn}}),t.s.setGroupProperty(PropertyInterface("Start Point",r)),t.e.setGroupProperty(PropertyInterface("End Point",r)),t.o.setGroupProperty(PropertyInterface("Opacity",r)),n}function a(e,t,r){var n,a=propertyGroupFactory(u,r),i=propertyGroupFactory(l,a);function s(r){Object.defineProperty(l,e.d[r].nm,{get:ExpressionPropertyInterface(t.d.dataProps[r].p)})}var o=e.d?e.d.length:0,l={};for(n=0;n<o;n+=1)s(n),t.d.dataProps[n].p.setGroupProperty(i);function u(e){return"Color"===e||"color"===e?u.color:"Opacity"===e||"opacity"===e?u.opacity:"Stroke Width"===e||"stroke width"===e?u.strokeWidth:null}return Object.defineProperties(u,{color:{get:ExpressionPropertyInterface(t.c)},opacity:{get:ExpressionPropertyInterface(t.o)},strokeWidth:{get:ExpressionPropertyInterface(t.w)},dash:{get:function(){return l}},_name:{value:e.nm},mn:{value:e.mn}}),t.c.setGroupProperty(PropertyInterface("Color",a)),t.o.setGroupProperty(PropertyInterface("Opacity",a)),t.w.setGroupProperty(PropertyInterface("Stroke Width",a)),u}function i(e,t,r){function n(t){return t===e.e.ix||"End"===t||"end"===t?n.end:t===e.s.ix?n.start:t===e.o.ix?n.offset:null}var a=propertyGroupFactory(n,r);return n.propertyIndex=e.ix,t.s.setGroupProperty(PropertyInterface("Start",a)),t.e.setGroupProperty(PropertyInterface("End",a)),t.o.setGroupProperty(PropertyInterface("Offset",a)),n.propertyIndex=e.ix,n.propertyGroup=r,Object.defineProperties(n,{start:{get:ExpressionPropertyInterface(t.s)},end:{get:ExpressionPropertyInterface(t.e)},offset:{get:ExpressionPropertyInterface(t.o)},_name:{value:e.nm}}),n.mn=e.mn,n}function s(e,t,r){function n(t){return e.a.ix===t||"Anchor Point"===t?n.anchorPoint:e.o.ix===t||"Opacity"===t?n.opacity:e.p.ix===t||"Position"===t?n.position:e.r.ix===t||"Rotation"===t||"ADBE Vector Rotation"===t?n.rotation:e.s.ix===t||"Scale"===t?n.scale:e.sk&&e.sk.ix===t||"Skew"===t?n.skew:e.sa&&e.sa.ix===t||"Skew Axis"===t?n.skewAxis:null}var a=propertyGroupFactory(n,r);return t.transform.mProps.o.setGroupProperty(PropertyInterface("Opacity",a)),t.transform.mProps.p.setGroupProperty(PropertyInterface("Position",a)),t.transform.mProps.a.setGroupProperty(PropertyInterface("Anchor Point",a)),t.transform.mProps.s.setGroupProperty(PropertyInterface("Scale",a)),t.transform.mProps.r.setGroupProperty(PropertyInterface("Rotation",a)),t.transform.mProps.sk&&(t.transform.mProps.sk.setGroupProperty(PropertyInterface("Skew",a)),t.transform.mProps.sa.setGroupProperty(PropertyInterface("Skew Angle",a))),t.transform.op.setGroupProperty(PropertyInterface("Opacity",a)),Object.defineProperties(n,{opacity:{get:ExpressionPropertyInterface(t.transform.mProps.o)},position:{get:ExpressionPropertyInterface(t.transform.mProps.p)},anchorPoint:{get:ExpressionPropertyInterface(t.transform.mProps.a)},scale:{get:ExpressionPropertyInterface(t.transform.mProps.s)},rotation:{get:ExpressionPropertyInterface(t.transform.mProps.r)},skew:{get:ExpressionPropertyInterface(t.transform.mProps.sk)},skewAxis:{get:ExpressionPropertyInterface(t.transform.mProps.sa)},_name:{value:e.nm}}),n.ty="tr",n.mn=e.mn,n.propertyGroup=r,n}function o(e,t,r){function n(t){return e.p.ix===t?n.position:e.s.ix===t?n.size:null}var a=propertyGroupFactory(n,r);n.propertyIndex=e.ix;var i="tm"===t.sh.ty?t.sh.prop:t.sh;return i.s.setGroupProperty(PropertyInterface("Size",a)),i.p.setGroupProperty(PropertyInterface("Position",a)),Object.defineProperties(n,{size:{get:ExpressionPropertyInterface(i.s)},position:{get:ExpressionPropertyInterface(i.p)},_name:{value:e.nm}}),n.mn=e.mn,n}function l(e,t,r){function n(t){return e.p.ix===t?n.position:e.r.ix===t?n.rotation:e.pt.ix===t?n.points:e.or.ix===t||"ADBE Vector Star Outer Radius"===t?n.outerRadius:e.os.ix===t?n.outerRoundness:!e.ir||e.ir.ix!==t&&"ADBE Vector Star Inner Radius"!==t?e.is&&e.is.ix===t?n.innerRoundness:null:n.innerRadius}var a=propertyGroupFactory(n,r),i="tm"===t.sh.ty?t.sh.prop:t.sh;return n.propertyIndex=e.ix,i.or.setGroupProperty(PropertyInterface("Outer Radius",a)),i.os.setGroupProperty(PropertyInterface("Outer Roundness",a)),i.pt.setGroupProperty(PropertyInterface("Points",a)),i.p.setGroupProperty(PropertyInterface("Position",a)),i.r.setGroupProperty(PropertyInterface("Rotation",a)),e.ir&&(i.ir.setGroupProperty(PropertyInterface("Inner Radius",a)),i.is.setGroupProperty(PropertyInterface("Inner Roundness",a))),Object.defineProperties(n,{position:{get:ExpressionPropertyInterface(i.p)},rotation:{get:ExpressionPropertyInterface(i.r)},points:{get:ExpressionPropertyInterface(i.pt)},outerRadius:{get:ExpressionPropertyInterface(i.or)},outerRoundness:{get:ExpressionPropertyInterface(i.os)},innerRadius:{get:ExpressionPropertyInterface(i.ir)},innerRoundness:{get:ExpressionPropertyInterface(i.is)},_name:{value:e.nm}}),n.mn=e.mn,n}function u(e,t,r){function n(t){return e.p.ix===t?n.position:e.r.ix===t?n.roundness:e.s.ix===t||"Size"===t||"ADBE Vector Rect Size"===t?n.size:null}var a=propertyGroupFactory(n,r),i="tm"===t.sh.ty?t.sh.prop:t.sh;return n.propertyIndex=e.ix,i.p.setGroupProperty(PropertyInterface("Position",a)),i.s.setGroupProperty(PropertyInterface("Size",a)),i.r.setGroupProperty(PropertyInterface("Rotation",a)),Object.defineProperties(n,{position:{get:ExpressionPropertyInterface(i.p)},roundness:{get:ExpressionPropertyInterface(i.r)},size:{get:ExpressionPropertyInterface(i.s)},_name:{value:e.nm}}),n.mn=e.mn,n}function c(e,t,r){function n(t){return e.r.ix===t||"Round Corners 1"===t?n.radius:null}var a=propertyGroupFactory(n,r),i=t;return n.propertyIndex=e.ix,i.rd.setGroupProperty(PropertyInterface("Radius",a)),Object.defineProperties(n,{radius:{get:ExpressionPropertyInterface(i.rd)},_name:{value:e.nm}}),n.mn=e.mn,n}function h(e,t,r){function n(t){return e.c.ix===t||"Copies"===t?n.copies:e.o.ix===t||"Offset"===t?n.offset:null}var a=propertyGroupFactory(n,r),i=t;return n.propertyIndex=e.ix,i.c.setGroupProperty(PropertyInterface("Copies",a)),i.o.setGroupProperty(PropertyInterface("Offset",a)),Object.defineProperties(n,{copies:{get:ExpressionPropertyInterface(i.c)},offset:{get:ExpressionPropertyInterface(i.o)},_name:{value:e.nm}}),n.mn=e.mn,n}return function(t,r,n){var a;function i(e){if("number"==typeof e)return 0===(e=void 0===e?1:e)?n:a[e-1];for(var t=0,r=a.length;t<r;){if(a[t]._name===e)return a[t];t+=1}return null}return i.propertyGroup=propertyGroupFactory(i,(function(){return n})),a=e(t,r,i.propertyGroup),i.numProperties=a.length,i._name="Contents",i}}(),TextExpressionInterface=function(e){var t;function r(e){return"ADBE Text Document"===e?r.sourceText:null}return Object.defineProperty(r,"sourceText",{get:function(){e.textProperty.getValue();var r=e.textProperty.currentData.t;return t&&r===t.value||((t=new String(r)).value=r||new String(r),Object.defineProperty(t,"style",{get:function(){return{fillColor:e.textProperty.currentData.fc}}})),t}}),r};function _typeof(e){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof(e)}var FootageInterface=(dataInterfaceFactory=function(e){function t(e){return"Outline"===e?t.outlineInterface():null}return t._name="Outline",t.outlineInterface=function(e){var t="",r=e.getFootageData();function n(e){if(r[e])return t=e,"object"===_typeof(r=r[e])?n:r;var a=e.indexOf(t);if(-1!==a){var i=parseInt(e.substr(a+t.length),10);return"object"===_typeof(r=r[i])?n:r}return""}return function(){return t="",r=e.getFootageData(),n}}(e),t},function(e){function t(e){return"Data"===e?t.dataInterface:null}return t._name="Data",t.dataInterface=dataInterfaceFactory(e),t}),dataInterfaceFactory,interfaces={layer:LayerExpressionInterface,effects:EffectsExpressionInterface,comp:CompExpressionInterface,shape:ShapeExpressionInterface,text:TextExpressionInterface,footage:FootageInterface};function getInterface(e){return interfaces[e]||null}var expressionHelpers={searchExpressions:function(e,t,r){t.x&&(r.k=!0,r.x=!0,r.initiateExpression=ExpressionManager.initiateExpression,r.effectsSequence.push(r.initiateExpression(e,t,r).bind(r)))},getSpeedAtTime:function(e){var t=this.getValueAtTime(e),r=this.getValueAtTime(e+-.01),n=0;if(t.length){var a;for(a=0;a<t.length;a+=1)n+=Math.pow(r[a]-t[a],2);n=100*Math.sqrt(n)}else n=0;return n},getVelocityAtTime:function(e){if(void 0!==this.vel)return this.vel;var t,r,n=-.001,a=this.getValueAtTime(e),i=this.getValueAtTime(e+n);if(a.length)for(t=createTypedArray("float32",a.length),r=0;r<a.length;r+=1)t[r]=(i[r]-a[r])/n;else t=(i-a)/n;return t},getValueAtTime:function(e){return e*=this.elem.globalData.frameRate,(e-=this.offsetTime)!==this._cachingAtTime.lastFrame&&(this._cachingAtTime.lastIndex=this._cachingAtTime.lastFrame<e?this._cachingAtTime.lastIndex:0,this._cachingAtTime.value=this.interpolateValue(e,this._cachingAtTime),this._cachingAtTime.lastFrame=e),this._cachingAtTime.value},getStaticValueAtTime:function(){return this.pv},setGroupProperty:function(e){this.propertyGroup=e}};function addPropertyDecorator(){function e(e,t,r){if(!this.k||!this.keyframes)return this.pv;e=e?e.toLowerCase():"";var n,a,i,s,o,l=this.comp.renderedFrame,u=this.keyframes,c=u[u.length-1].t;if(l<=c)return this.pv;if(r?a=c-(n=t?Math.abs(c-this.elem.comp.globalData.frameRate*t):Math.max(0,c-this.elem.data.ip)):((!t||t>u.length-1)&&(t=u.length-1),n=c-(a=u[u.length-1-t].t)),"pingpong"===e){if(Math.floor((l-a)/n)%2!=0)return this.getValueAtTime((n-(l-a)%n+a)/this.comp.globalData.frameRate,0)}else{if("offset"===e){var h=this.getValueAtTime(a/this.comp.globalData.frameRate,0),p=this.getValueAtTime(c/this.comp.globalData.frameRate,0),f=this.getValueAtTime(((l-a)%n+a)/this.comp.globalData.frameRate,0),d=Math.floor((l-a)/n);if(this.pv.length){for(s=(o=new Array(h.length)).length,i=0;i<s;i+=1)o[i]=(p[i]-h[i])*d+f[i];return o}return(p-h)*d+f}if("continue"===e){var m=this.getValueAtTime(c/this.comp.globalData.frameRate,0),g=this.getValueAtTime((c-.001)/this.comp.globalData.frameRate,0);if(this.pv.length){for(s=(o=new Array(m.length)).length,i=0;i<s;i+=1)o[i]=m[i]+(m[i]-g[i])*((l-c)/this.comp.globalData.frameRate)/5e-4;return o}return m+(l-c)/.001*(m-g)}}return this.getValueAtTime(((l-a)%n+a)/this.comp.globalData.frameRate,0)}function t(e,t,r){if(!this.k)return this.pv;e=e?e.toLowerCase():"";var n,a,i,s,o,l=this.comp.renderedFrame,u=this.keyframes,c=u[0].t;if(l>=c)return this.pv;if(r?a=c+(n=t?Math.abs(this.elem.comp.globalData.frameRate*t):Math.max(0,this.elem.data.op-c)):((!t||t>u.length-1)&&(t=u.length-1),n=(a=u[t].t)-c),"pingpong"===e){if(Math.floor((c-l)/n)%2==0)return this.getValueAtTime(((c-l)%n+c)/this.comp.globalData.frameRate,0)}else{if("offset"===e){var h=this.getValueAtTime(c/this.comp.globalData.frameRate,0),p=this.getValueAtTime(a/this.comp.globalData.frameRate,0),f=this.getValueAtTime((n-(c-l)%n+c)/this.comp.globalData.frameRate,0),d=Math.floor((c-l)/n)+1;if(this.pv.length){for(s=(o=new Array(h.length)).length,i=0;i<s;i+=1)o[i]=f[i]-(p[i]-h[i])*d;return o}return f-(p-h)*d}if("continue"===e){var m=this.getValueAtTime(c/this.comp.globalData.frameRate,0),g=this.getValueAtTime((c+.001)/this.comp.globalData.frameRate,0);if(this.pv.length){for(s=(o=new Array(m.length)).length,i=0;i<s;i+=1)o[i]=m[i]+(m[i]-g[i])*(c-l)/.001;return o}return m+(m-g)*(c-l)/.001}}return this.getValueAtTime((n-((c-l)%n+c))/this.comp.globalData.frameRate,0)}function r(e,t){if(!this.k)return this.pv;if(e=.5*(e||.4),(t=Math.floor(t||5))<=1)return this.pv;var r,n,a=this.comp.renderedFrame/this.comp.globalData.frameRate,i=a-e,s=t>1?(a+e-i)/(t-1):1,o=0,l=0;for(r=this.pv.length?createTypedArray("float32",this.pv.length):0;o<t;){if(n=this.getValueAtTime(i+o*s),this.pv.length)for(l=0;l<this.pv.length;l+=1)r[l]+=n[l];else r+=n;o+=1}if(this.pv.length)for(l=0;l<this.pv.length;l+=1)r[l]/=t;else r/=t;return r}function n(e){this._transformCachingAtTime||(this._transformCachingAtTime={v:new Matrix});var t=this._transformCachingAtTime.v;if(t.cloneFromProps(this.pre.props),this.appliedTransformations<1){var r=this.a.getValueAtTime(e);t.translate(-r[0]*this.a.mult,-r[1]*this.a.mult,r[2]*this.a.mult)}if(this.appliedTransformations<2){var n=this.s.getValueAtTime(e);t.scale(n[0]*this.s.mult,n[1]*this.s.mult,n[2]*this.s.mult)}if(this.sk&&this.appliedTransformations<3){var a=this.sk.getValueAtTime(e),i=this.sa.getValueAtTime(e);t.skewFromAxis(-a*this.sk.mult,i*this.sa.mult)}if(this.r&&this.appliedTransformations<4){var s=this.r.getValueAtTime(e);t.rotate(-s*this.r.mult)}else if(!this.r&&this.appliedTransformations<4){var o=this.rz.getValueAtTime(e),l=this.ry.getValueAtTime(e),u=this.rx.getValueAtTime(e),c=this.or.getValueAtTime(e);t.rotateZ(-o*this.rz.mult).rotateY(l*this.ry.mult).rotateX(u*this.rx.mult).rotateZ(-c[2]*this.or.mult).rotateY(c[1]*this.or.mult).rotateX(c[0]*this.or.mult)}if(this.data.p&&this.data.p.s){var h=this.px.getValueAtTime(e),p=this.py.getValueAtTime(e);if(this.data.p.z){var f=this.pz.getValueAtTime(e);t.translate(h*this.px.mult,p*this.py.mult,-f*this.pz.mult)}else t.translate(h*this.px.mult,p*this.py.mult,0)}else{var d=this.p.getValueAtTime(e);t.translate(d[0]*this.p.mult,d[1]*this.p.mult,-d[2]*this.p.mult)}return t}function a(){return this.v.clone(new Matrix)}var i=TransformPropertyFactory.getTransformProperty;TransformPropertyFactory.getTransformProperty=function(e,t,r){var s=i(e,t,r);return s.dynamicProperties.length?s.getValueAtTime=n.bind(s):s.getValueAtTime=a.bind(s),s.setGroupProperty=expressionHelpers.setGroupProperty,s};var s=PropertyFactory.getProp;PropertyFactory.getProp=function(n,a,i,o,l){var u=s(n,a,i,o,l);u.kf?u.getValueAtTime=expressionHelpers.getValueAtTime.bind(u):u.getValueAtTime=expressionHelpers.getStaticValueAtTime.bind(u),u.setGroupProperty=expressionHelpers.setGroupProperty,u.loopOut=e,u.loopIn=t,u.smooth=r,u.getVelocityAtTime=expressionHelpers.getVelocityAtTime.bind(u),u.getSpeedAtTime=expressionHelpers.getSpeedAtTime.bind(u),u.numKeys=1===a.a?a.k.length:0,u.propertyIndex=a.ix;var c=0;return 0!==i&&(c=createTypedArray("float32",1===a.a?a.k[0].s.length:a.k.length)),u._cachingAtTime={lastFrame:initialDefaultFrame,lastIndex:0,value:c},expressionHelpers.searchExpressions(n,a,u),u.k&&l.addDynamicProperty(u),u};var o=ShapePropertyFactory.getConstructorFunction(),l=ShapePropertyFactory.getKeyframedConstructorFunction();function u(){}u.prototype={vertices:function(e,t){this.k&&this.getValue();var r,n=this.v;void 0!==t&&(n=this.getValueAtTime(t,0));var a=n._length,i=n[e],s=n.v,o=createSizedArray(a);for(r=0;r<a;r+=1)o[r]="i"===e||"o"===e?[i[r][0]-s[r][0],i[r][1]-s[r][1]]:[i[r][0],i[r][1]];return o},points:function(e){return this.vertices("v",e)},inTangents:function(e){return this.vertices("i",e)},outTangents:function(e){return this.vertices("o",e)},isClosed:function(){return this.v.c},pointOnPath:function(e,t){var r=this.v;void 0!==t&&(r=this.getValueAtTime(t,0)),this._segmentsLength||(this._segmentsLength=bez.getSegmentsLength(r));for(var n,a=this._segmentsLength,i=a.lengths,s=a.totalLength*e,o=0,l=i.length,u=0;o<l;){if(u+i[o].addedLength>s){var c=o,h=r.c&&o===l-1?0:o+1,p=(s-u)/i[o].addedLength;n=bez.getPointInSegment(r.v[c],r.v[h],r.o[c],r.i[h],p,i[o]);break}u+=i[o].addedLength,o+=1}return n||(n=r.c?[r.v[0][0],r.v[0][1]]:[r.v[r._length-1][0],r.v[r._length-1][1]]),n},vectorOnPath:function(e,t,r){1==e?e=this.v.c:0==e&&(e=.999);var n=this.pointOnPath(e,t),a=this.pointOnPath(e+.001,t),i=a[0]-n[0],s=a[1]-n[1],o=Math.sqrt(Math.pow(i,2)+Math.pow(s,2));return 0===o?[0,0]:"tangent"===r?[i/o,s/o]:[-s/o,i/o]},tangentOnPath:function(e,t){return this.vectorOnPath(e,t,"tangent")},normalOnPath:function(e,t){return this.vectorOnPath(e,t,"normal")},setGroupProperty:expressionHelpers.setGroupProperty,getValueAtTime:expressionHelpers.getStaticValueAtTime},extendPrototype([u],o),extendPrototype([u],l),l.prototype.getValueAtTime=function(e){return this._cachingAtTime||(this._cachingAtTime={shapeValue:shapePool.clone(this.pv),lastIndex:0,lastTime:initialDefaultFrame}),e*=this.elem.globalData.frameRate,(e-=this.offsetTime)!==this._cachingAtTime.lastTime&&(this._cachingAtTime.lastIndex=this._cachingAtTime.lastTime<e?this._caching.lastIndex:0,this._cachingAtTime.lastTime=e,this.interpolateShape(e,this._cachingAtTime.shapeValue,this._cachingAtTime)),this._cachingAtTime.shapeValue},l.prototype.initiateExpression=ExpressionManager.initiateExpression;var c=ShapePropertyFactory.getShapeProp;ShapePropertyFactory.getShapeProp=function(e,t,r,n,a){var i=c(e,t,r,n,a);return i.propertyIndex=t.ix,i.lock=!1,3===r?expressionHelpers.searchExpressions(e,t.pt,i):4===r&&expressionHelpers.searchExpressions(e,t.ks,i),i.k&&e.addDynamicProperty(i),i}}function initialize$1(){addPropertyDecorator()}function addDecorator(){TextProperty.prototype.getExpressionValue=function(e,t){var r=this.calculateExpression(t);if(e.t!==r){var n={};return this.copyData(n,e),n.t=r.toString(),n.__complete=!1,n}return e},TextProperty.prototype.searchProperty=function(){var e=this.searchKeyframes(),t=this.searchExpressions();return this.kf=e||t,this.kf},TextProperty.prototype.searchExpressions=function(){return this.data.d.x?(this.calculateExpression=ExpressionManager.initiateExpression.bind(this)(this.elem,this.data.d,this),this.addEffect(this.getExpressionValue.bind(this)),!0):null}}function initialize(){addDecorator()}function SVGComposableEffect(){}SVGComposableEffect.prototype={createMergeNode:function(e,t){var r,n,a=createNS("feMerge");for(a.setAttribute("result",e),n=0;n<t.length;n+=1)(r=createNS("feMergeNode")).setAttribute("in",t[n]),a.appendChild(r),a.appendChild(r);return a}};var linearFilterValue="0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0";function SVGTintFilter(e,t,r,n,a){this.filterManager=t;var i=createNS("feColorMatrix");i.setAttribute("type","matrix"),i.setAttribute("color-interpolation-filters","linearRGB"),i.setAttribute("values",linearFilterValue+" 1 0"),this.linearFilter=i,i.setAttribute("result",n+"_tint_1"),e.appendChild(i),(i=createNS("feColorMatrix")).setAttribute("type","matrix"),i.setAttribute("color-interpolation-filters","sRGB"),i.setAttribute("values","1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"),i.setAttribute("result",n+"_tint_2"),e.appendChild(i),this.matrixFilter=i;var s=this.createMergeNode(n,[a,n+"_tint_1",n+"_tint_2"]);e.appendChild(s)}function SVGFillFilter(e,t,r,n){this.filterManager=t;var a=createNS("feColorMatrix");a.setAttribute("type","matrix"),a.setAttribute("color-interpolation-filters","sRGB"),a.setAttribute("values","1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"),a.setAttribute("result",n),e.appendChild(a),this.matrixFilter=a}function SVGStrokeEffect(e,t,r){this.initialized=!1,this.filterManager=t,this.elem=r,this.paths=[]}function SVGTritoneFilter(e,t,r,n){this.filterManager=t;var a=createNS("feColorMatrix");a.setAttribute("type","matrix"),a.setAttribute("color-interpolation-filters","linearRGB"),a.setAttribute("values","0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0"),e.appendChild(a);var i=createNS("feComponentTransfer");i.setAttribute("color-interpolation-filters","sRGB"),i.setAttribute("result",n),this.matrixFilter=i;var s=createNS("feFuncR");s.setAttribute("type","table"),i.appendChild(s),this.feFuncR=s;var o=createNS("feFuncG");o.setAttribute("type","table"),i.appendChild(o),this.feFuncG=o;var l=createNS("feFuncB");l.setAttribute("type","table"),i.appendChild(l),this.feFuncB=l,e.appendChild(i)}function SVGProLevelsFilter(e,t,r,n){this.filterManager=t;var a=this.filterManager.effectElements,i=createNS("feComponentTransfer");(a[10].p.k||0!==a[10].p.v||a[11].p.k||1!==a[11].p.v||a[12].p.k||1!==a[12].p.v||a[13].p.k||0!==a[13].p.v||a[14].p.k||1!==a[14].p.v)&&(this.feFuncR=this.createFeFunc("feFuncR",i)),(a[17].p.k||0!==a[17].p.v||a[18].p.k||1!==a[18].p.v||a[19].p.k||1!==a[19].p.v||a[20].p.k||0!==a[20].p.v||a[21].p.k||1!==a[21].p.v)&&(this.feFuncG=this.createFeFunc("feFuncG",i)),(a[24].p.k||0!==a[24].p.v||a[25].p.k||1!==a[25].p.v||a[26].p.k||1!==a[26].p.v||a[27].p.k||0!==a[27].p.v||a[28].p.k||1!==a[28].p.v)&&(this.feFuncB=this.createFeFunc("feFuncB",i)),(a[31].p.k||0!==a[31].p.v||a[32].p.k||1!==a[32].p.v||a[33].p.k||1!==a[33].p.v||a[34].p.k||0!==a[34].p.v||a[35].p.k||1!==a[35].p.v)&&(this.feFuncA=this.createFeFunc("feFuncA",i)),(this.feFuncR||this.feFuncG||this.feFuncB||this.feFuncA)&&(i.setAttribute("color-interpolation-filters","sRGB"),e.appendChild(i)),(a[3].p.k||0!==a[3].p.v||a[4].p.k||1!==a[4].p.v||a[5].p.k||1!==a[5].p.v||a[6].p.k||0!==a[6].p.v||a[7].p.k||1!==a[7].p.v)&&((i=createNS("feComponentTransfer")).setAttribute("color-interpolation-filters","sRGB"),i.setAttribute("result",n),e.appendChild(i),this.feFuncRComposed=this.createFeFunc("feFuncR",i),this.feFuncGComposed=this.createFeFunc("feFuncG",i),this.feFuncBComposed=this.createFeFunc("feFuncB",i))}function SVGDropShadowEffect(e,t,r,n,a){var i=t.container.globalData.renderConfig.filterSize,s=t.data.fs||i;e.setAttribute("x",s.x||i.x),e.setAttribute("y",s.y||i.y),e.setAttribute("width",s.width||i.width),e.setAttribute("height",s.height||i.height),this.filterManager=t;var o=createNS("feGaussianBlur");o.setAttribute("in","SourceAlpha"),o.setAttribute("result",n+"_drop_shadow_1"),o.setAttribute("stdDeviation","0"),this.feGaussianBlur=o,e.appendChild(o);var l=createNS("feOffset");l.setAttribute("dx","25"),l.setAttribute("dy","0"),l.setAttribute("in",n+"_drop_shadow_1"),l.setAttribute("result",n+"_drop_shadow_2"),this.feOffset=l,e.appendChild(l);var u=createNS("feFlood");u.setAttribute("flood-color","#00ff00"),u.setAttribute("flood-opacity","1"),u.setAttribute("result",n+"_drop_shadow_3"),this.feFlood=u,e.appendChild(u);var c=createNS("feComposite");c.setAttribute("in",n+"_drop_shadow_3"),c.setAttribute("in2",n+"_drop_shadow_2"),c.setAttribute("operator","in"),c.setAttribute("result",n+"_drop_shadow_4"),e.appendChild(c);var h=this.createMergeNode(n,[n+"_drop_shadow_4",a]);e.appendChild(h)}extendPrototype([SVGComposableEffect],SVGTintFilter),SVGTintFilter.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){var t=this.filterManager.effectElements[0].p.v,r=this.filterManager.effectElements[1].p.v,n=this.filterManager.effectElements[2].p.v/100;this.linearFilter.setAttribute("values",linearFilterValue+" "+n+" 0"),this.matrixFilter.setAttribute("values",r[0]-t[0]+" 0 0 0 "+t[0]+" "+(r[1]-t[1])+" 0 0 0 "+t[1]+" "+(r[2]-t[2])+" 0 0 0 "+t[2]+" 0 0 0 1 0")}},SVGFillFilter.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){var t=this.filterManager.effectElements[2].p.v,r=this.filterManager.effectElements[6].p.v;this.matrixFilter.setAttribute("values","0 0 0 0 "+t[0]+" 0 0 0 0 "+t[1]+" 0 0 0 0 "+t[2]+" 0 0 0 "+r+" 0")}},SVGStrokeEffect.prototype.initialize=function(){var e,t,r,n,a=this.elem.layerElement.children||this.elem.layerElement.childNodes;for(1===this.filterManager.effectElements[1].p.v?(n=this.elem.maskManager.masksProperties.length,r=0):n=1+(r=this.filterManager.effectElements[0].p.v-1),(t=createNS("g")).setAttribute("fill","none"),t.setAttribute("stroke-linecap","round"),t.setAttribute("stroke-dashoffset",1);r<n;r+=1)e=createNS("path"),t.appendChild(e),this.paths.push({p:e,m:r});if(3===this.filterManager.effectElements[10].p.v){var i=createNS("mask"),s=createElementID();i.setAttribute("id",s),i.setAttribute("mask-type","alpha"),i.appendChild(t),this.elem.globalData.defs.appendChild(i);var o=createNS("g");for(o.setAttribute("mask","url("+getLocationHref()+"#"+s+")");a[0];)o.appendChild(a[0]);this.elem.layerElement.appendChild(o),this.masker=i,t.setAttribute("stroke","#fff")}else if(1===this.filterManager.effectElements[10].p.v||2===this.filterManager.effectElements[10].p.v){if(2===this.filterManager.effectElements[10].p.v)for(a=this.elem.layerElement.children||this.elem.layerElement.childNodes;a.length;)this.elem.layerElement.removeChild(a[0]);this.elem.layerElement.appendChild(t),this.elem.layerElement.removeAttribute("mask"),t.setAttribute("stroke","#fff")}this.initialized=!0,this.pathMasker=t},SVGStrokeEffect.prototype.renderFrame=function(e){var t;this.initialized||this.initialize();var r,n,a=this.paths.length;for(t=0;t<a;t+=1)if(-1!==this.paths[t].m&&(r=this.elem.maskManager.viewData[this.paths[t].m],n=this.paths[t].p,(e||this.filterManager._mdf||r.prop._mdf)&&n.setAttribute("d",r.lastPath),e||this.filterManager.effectElements[9].p._mdf||this.filterManager.effectElements[4].p._mdf||this.filterManager.effectElements[7].p._mdf||this.filterManager.effectElements[8].p._mdf||r.prop._mdf)){var i;if(0!==this.filterManager.effectElements[7].p.v||100!==this.filterManager.effectElements[8].p.v){var s=.01*Math.min(this.filterManager.effectElements[7].p.v,this.filterManager.effectElements[8].p.v),o=.01*Math.max(this.filterManager.effectElements[7].p.v,this.filterManager.effectElements[8].p.v),l=n.getTotalLength();i="0 0 0 "+l*s+" ";var u,c=l*(o-s),h=1+2*this.filterManager.effectElements[4].p.v*this.filterManager.effectElements[9].p.v*.01,p=Math.floor(c/h);for(u=0;u<p;u+=1)i+="1 "+2*this.filterManager.effectElements[4].p.v*this.filterManager.effectElements[9].p.v*.01+" ";i+="0 "+10*l+" 0 0"}else i="1 "+2*this.filterManager.effectElements[4].p.v*this.filterManager.effectElements[9].p.v*.01;n.setAttribute("stroke-dasharray",i)}if((e||this.filterManager.effectElements[4].p._mdf)&&this.pathMasker.setAttribute("stroke-width",2*this.filterManager.effectElements[4].p.v),(e||this.filterManager.effectElements[6].p._mdf)&&this.pathMasker.setAttribute("opacity",this.filterManager.effectElements[6].p.v),(1===this.filterManager.effectElements[10].p.v||2===this.filterManager.effectElements[10].p.v)&&(e||this.filterManager.effectElements[3].p._mdf)){var f=this.filterManager.effectElements[3].p.v;this.pathMasker.setAttribute("stroke","rgb("+bmFloor(255*f[0])+","+bmFloor(255*f[1])+","+bmFloor(255*f[2])+")")}},SVGTritoneFilter.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){var t=this.filterManager.effectElements[0].p.v,r=this.filterManager.effectElements[1].p.v,n=this.filterManager.effectElements[2].p.v,a=n[0]+" "+r[0]+" "+t[0],i=n[1]+" "+r[1]+" "+t[1],s=n[2]+" "+r[2]+" "+t[2];this.feFuncR.setAttribute("tableValues",a),this.feFuncG.setAttribute("tableValues",i),this.feFuncB.setAttribute("tableValues",s)}},SVGProLevelsFilter.prototype.createFeFunc=function(e,t){var r=createNS(e);return r.setAttribute("type","table"),t.appendChild(r),r},SVGProLevelsFilter.prototype.getTableValue=function(e,t,r,n,a){for(var i,s,o=0,l=Math.min(e,t),u=Math.max(e,t),c=Array.call(null,{length:256}),h=0,p=a-n,f=t-e;o<=256;)s=(i=o/256)<=l?f<0?a:n:i>=u?f<0?n:a:n+p*Math.pow((i-e)/f,1/r),c[h]=s,h+=1,o+=256/255;return c.join(" ")},SVGProLevelsFilter.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){var t,r=this.filterManager.effectElements;this.feFuncRComposed&&(e||r[3].p._mdf||r[4].p._mdf||r[5].p._mdf||r[6].p._mdf||r[7].p._mdf)&&(t=this.getTableValue(r[3].p.v,r[4].p.v,r[5].p.v,r[6].p.v,r[7].p.v),this.feFuncRComposed.setAttribute("tableValues",t),this.feFuncGComposed.setAttribute("tableValues",t),this.feFuncBComposed.setAttribute("tableValues",t)),this.feFuncR&&(e||r[10].p._mdf||r[11].p._mdf||r[12].p._mdf||r[13].p._mdf||r[14].p._mdf)&&(t=this.getTableValue(r[10].p.v,r[11].p.v,r[12].p.v,r[13].p.v,r[14].p.v),this.feFuncR.setAttribute("tableValues",t)),this.feFuncG&&(e||r[17].p._mdf||r[18].p._mdf||r[19].p._mdf||r[20].p._mdf||r[21].p._mdf)&&(t=this.getTableValue(r[17].p.v,r[18].p.v,r[19].p.v,r[20].p.v,r[21].p.v),this.feFuncG.setAttribute("tableValues",t)),this.feFuncB&&(e||r[24].p._mdf||r[25].p._mdf||r[26].p._mdf||r[27].p._mdf||r[28].p._mdf)&&(t=this.getTableValue(r[24].p.v,r[25].p.v,r[26].p.v,r[27].p.v,r[28].p.v),this.feFuncB.setAttribute("tableValues",t)),this.feFuncA&&(e||r[31].p._mdf||r[32].p._mdf||r[33].p._mdf||r[34].p._mdf||r[35].p._mdf)&&(t=this.getTableValue(r[31].p.v,r[32].p.v,r[33].p.v,r[34].p.v,r[35].p.v),this.feFuncA.setAttribute("tableValues",t))}},extendPrototype([SVGComposableEffect],SVGDropShadowEffect),SVGDropShadowEffect.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){if((e||this.filterManager.effectElements[4].p._mdf)&&this.feGaussianBlur.setAttribute("stdDeviation",this.filterManager.effectElements[4].p.v/4),e||this.filterManager.effectElements[0].p._mdf){var t=this.filterManager.effectElements[0].p.v;this.feFlood.setAttribute("flood-color",rgbToHex(Math.round(255*t[0]),Math.round(255*t[1]),Math.round(255*t[2])))}if((e||this.filterManager.effectElements[1].p._mdf)&&this.feFlood.setAttribute("flood-opacity",this.filterManager.effectElements[1].p.v/255),e||this.filterManager.effectElements[2].p._mdf||this.filterManager.effectElements[3].p._mdf){var r=this.filterManager.effectElements[3].p.v,n=(this.filterManager.effectElements[2].p.v-90)*degToRads,a=r*Math.cos(n),i=r*Math.sin(n);this.feOffset.setAttribute("dx",a),this.feOffset.setAttribute("dy",i)}}};var _svgMatteSymbols=[];function SVGMatte3Effect(e,t,r){this.initialized=!1,this.filterManager=t,this.filterElem=e,this.elem=r,r.matteElement=createNS("g"),r.matteElement.appendChild(r.layerElement),r.matteElement.appendChild(r.transformedElement),r.baseElement=r.matteElement}function SVGGaussianBlurEffect(e,t,r,n){e.setAttribute("x","-100%"),e.setAttribute("y","-100%"),e.setAttribute("width","300%"),e.setAttribute("height","300%"),this.filterManager=t;var a=createNS("feGaussianBlur");a.setAttribute("result",n),e.appendChild(a),this.feGaussianBlur=a}function TransformEffect(){}function SVGTransformEffect(e,t){this.init(t)}function CVTransformEffect(e){this.init(e)}return SVGMatte3Effect.prototype.findSymbol=function(e){for(var t=0,r=_svgMatteSymbols.length;t<r;){if(_svgMatteSymbols[t]===e)return _svgMatteSymbols[t];t+=1}return null},SVGMatte3Effect.prototype.replaceInParent=function(e,t){var r=e.layerElement.parentNode;if(r){for(var n,a=r.children,i=0,s=a.length;i<s&&a[i]!==e.layerElement;)i+=1;i<=s-2&&(n=a[i+1]);var o=createNS("use");o.setAttribute("href","#"+t),n?r.insertBefore(o,n):r.appendChild(o)}},SVGMatte3Effect.prototype.setElementAsMask=function(e,t){if(!this.findSymbol(t)){var r=createElementID(),n=createNS("mask");n.setAttribute("id",t.layerId),n.setAttribute("mask-type","alpha"),_svgMatteSymbols.push(t);var a=e.globalData.defs;a.appendChild(n);var i=createNS("symbol");i.setAttribute("id",r),this.replaceInParent(t,r),i.appendChild(t.layerElement),a.appendChild(i);var s=createNS("use");s.setAttribute("href","#"+r),n.appendChild(s),t.data.hd=!1,t.show()}e.setMatte(t.layerId)},SVGMatte3Effect.prototype.initialize=function(){for(var e=this.filterManager.effectElements[0].p.v,t=this.elem.comp.elements,r=0,n=t.length;r<n;)t[r]&&t[r].data.ind===e&&this.setElementAsMask(this.elem,t[r]),r+=1;this.initialized=!0},SVGMatte3Effect.prototype.renderFrame=function(){this.initialized||this.initialize()},SVGGaussianBlurEffect.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){var t=.3*this.filterManager.effectElements[0].p.v,r=this.filterManager.effectElements[1].p.v,n=3==r?0:t,a=2==r?0:t;this.feGaussianBlur.setAttribute("stdDeviation",n+" "+a);var i=1==this.filterManager.effectElements[2].p.v?"wrap":"duplicate";this.feGaussianBlur.setAttribute("edgeMode",i)}},TransformEffect.prototype.init=function(e){this.effectsManager=e,this.type=effectTypes.TRANSFORM_EFFECT,this.matrix=new Matrix,this.opacity=-1,this._mdf=!1,this._opMdf=!1},TransformEffect.prototype.renderFrame=function(e){if(this._opMdf=!1,this._mdf=!1,e||this.effectsManager._mdf){var t=this.effectsManager.effectElements,r=t[0].p.v,n=t[1].p.v,a=1===t[2].p.v,i=t[3].p.v,s=a?i:t[4].p.v,o=t[5].p.v,l=t[6].p.v,u=t[7].p.v;this.matrix.reset(),this.matrix.translate(-r[0],-r[1],r[2]),this.matrix.scale(.01*s,.01*i,1),this.matrix.rotate(-u*degToRads),this.matrix.skewFromAxis(-o*degToRads,(l+90)*degToRads),this.matrix.translate(n[0],n[1],0),this._mdf=!0,this.opacity!==t[8].p.v&&(this.opacity=t[8].p.v,this._opMdf=!0)}},extendPrototype([TransformEffect],SVGTransformEffect),extendPrototype([TransformEffect],CVTransformEffect),registerRenderer("canvas",CanvasRenderer),registerRenderer("html",HybridRenderer),registerRenderer("svg",SVGRenderer),ShapeModifiers.registerModifier("tm",TrimModifier),ShapeModifiers.registerModifier("pb",PuckerAndBloatModifier),ShapeModifiers.registerModifier("rp",RepeaterModifier),ShapeModifiers.registerModifier("rd",RoundCornersModifier),ShapeModifiers.registerModifier("zz",ZigZagModifier),ShapeModifiers.registerModifier("op",OffsetPathModifier),setExpressionsPlugin(Expressions),setExpressionInterfaces(getInterface),initialize$1(),initialize(),registerEffect$1(20,SVGTintFilter,!0),registerEffect$1(21,SVGFillFilter,!0),registerEffect$1(22,SVGStrokeEffect,!1),registerEffect$1(23,SVGTritoneFilter,!0),registerEffect$1(24,SVGProLevelsFilter,!0),registerEffect$1(25,SVGDropShadowEffect,!0),registerEffect$1(28,SVGMatte3Effect,!1),registerEffect$1(29,SVGGaussianBlurEffect,!0),registerEffect$1(35,SVGTransformEffect,!1),registerEffect(35,CVTransformEffect),lottie},module.exports=factory())},4448:(e,t,r)=>{"use strict";var n=r(7294),a=r(3840);function i(e){for(var t="https://reactjs.org/docs/error-decoder.html?invariant="+e,r=1;r<arguments.length;r++)t+="&args[]="+encodeURIComponent(arguments[r]);return"Minified React error #"+e+"; visit "+t+" for the full message or use the non-minified dev environment for full errors and additional helpful warnings."}var s=new Set,o={};function l(e,t){u(e,t),u(e+"Capture",t)}function u(e,t){for(o[e]=t,e=0;e<t.length;e++)s.add(t[e])}var c=!("undefined"==typeof window||void 0===window.document||void 0===window.document.createElement),h=Object.prototype.hasOwnProperty,p=/^[:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD][:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*$/,f={},d={};function m(e,t,r,n,a,i,s){this.acceptsBooleans=2===t||3===t||4===t,this.attributeName=n,this.attributeNamespace=a,this.mustUseProperty=r,this.propertyName=e,this.type=t,this.sanitizeURL=i,this.removeEmptyString=s}var g={};"children dangerouslySetInnerHTML defaultValue defaultChecked innerHTML suppressContentEditableWarning suppressHydrationWarning style".split(" ").forEach((function(e){g[e]=new m(e,0,!1,e,null,!1,!1)})),[["acceptCharset","accept-charset"],["className","class"],["htmlFor","for"],["httpEquiv","http-equiv"]].forEach((function(e){var t=e[0];g[t]=new m(t,1,!1,e[1],null,!1,!1)})),["contentEditable","draggable","spellCheck","value"].forEach((function(e){g[e]=new m(e,2,!1,e.toLowerCase(),null,!1,!1)})),["autoReverse","externalResourcesRequired","focusable","preserveAlpha"].forEach((function(e){g[e]=new m(e,2,!1,e,null,!1,!1)})),"allowFullScreen async autoFocus autoPlay controls default defer disabled disablePictureInPicture disableRemotePlayback formNoValidate hidden loop noModule noValidate open playsInline readOnly required reversed scoped seamless itemScope".split(" ").forEach((function(e){g[e]=new m(e,3,!1,e.toLowerCase(),null,!1,!1)})),["checked","multiple","muted","selected"].forEach((function(e){g[e]=new m(e,3,!0,e,null,!1,!1)})),["capture","download"].forEach((function(e){g[e]=new m(e,4,!1,e,null,!1,!1)})),["cols","rows","size","span"].forEach((function(e){g[e]=new m(e,6,!1,e,null,!1,!1)})),["rowSpan","start"].forEach((function(e){g[e]=new m(e,5,!1,e.toLowerCase(),null,!1,!1)}));var y=/[\-:]([a-z])/g;function v(e){return e[1].toUpperCase()}function b(e,t,r,n){var a=g.hasOwnProperty(t)?g[t]:null;(null!==a?0!==a.type:n||!(2<t.length)||"o"!==t[0]&&"O"!==t[0]||"n"!==t[1]&&"N"!==t[1])&&(function(e,t,r,n){if(null==t||function(e,t,r,n){if(null!==r&&0===r.type)return!1;switch(typeof t){case"function":case"symbol":return!0;case"boolean":return!n&&(null!==r?!r.acceptsBooleans:"data-"!==(e=e.toLowerCase().slice(0,5))&&"aria-"!==e);default:return!1}}(e,t,r,n))return!0;if(n)return!1;if(null!==r)switch(r.type){case 3:return!t;case 4:return!1===t;case 5:return isNaN(t);case 6:return isNaN(t)||1>t}return!1}(t,r,a,n)&&(r=null),n||null===a?function(e){return!!h.call(d,e)||!h.call(f,e)&&(p.test(e)?d[e]=!0:(f[e]=!0,!1))}(t)&&(null===r?e.removeAttribute(t):e.setAttribute(t,""+r)):a.mustUseProperty?e[a.propertyName]=null===r?3!==a.type&&"":r:(t=a.attributeName,n=a.attributeNamespace,null===r?e.removeAttribute(t):(r=3===(a=a.type)||4===a&&!0===r?"":""+r,n?e.setAttributeNS(n,t,r):e.setAttribute(t,r))))}"accent-height alignment-baseline arabic-form baseline-shift cap-height clip-path clip-rule color-interpolation color-interpolation-filters color-profile color-rendering dominant-baseline enable-background fill-opacity fill-rule flood-color flood-opacity font-family font-size font-size-adjust font-stretch font-style font-variant font-weight glyph-name glyph-orientation-horizontal glyph-orientation-vertical horiz-adv-x horiz-origin-x image-rendering letter-spacing lighting-color marker-end marker-mid marker-start overline-position overline-thickness paint-order panose-1 pointer-events rendering-intent shape-rendering stop-color stop-opacity strikethrough-position strikethrough-thickness stroke-dasharray stroke-dashoffset stroke-linecap stroke-linejoin stroke-miterlimit stroke-opacity stroke-width text-anchor text-decoration text-rendering underline-position underline-thickness unicode-bidi unicode-range units-per-em v-alphabetic v-hanging v-ideographic v-mathematical vector-effect vert-adv-y vert-origin-x vert-origin-y word-spacing writing-mode xmlns:xlink x-height".split(" ").forEach((function(e){var t=e.replace(y,v);g[t]=new m(t,1,!1,e,null,!1,!1)})),"xlink:actuate xlink:arcrole xlink:role xlink:show xlink:title xlink:type".split(" ").forEach((function(e){var t=e.replace(y,v);g[t]=new m(t,1,!1,e,"http://www.w3.org/1999/xlink",!1,!1)})),["xml:base","xml:lang","xml:space"].forEach((function(e){var t=e.replace(y,v);g[t]=new m(t,1,!1,e,"http://www.w3.org/XML/1998/namespace",!1,!1)})),["tabIndex","crossOrigin"].forEach((function(e){g[e]=new m(e,1,!1,e.toLowerCase(),null,!1,!1)})),g.xlinkHref=new m("xlinkHref",1,!1,"xlink:href","http://www.w3.org/1999/xlink",!0,!1),["src","href","action","formAction"].forEach((function(e){g[e]=new m(e,1,!1,e.toLowerCase(),null,!0,!0)}));var k=n.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED,x=Symbol.for("react.element"),S=Symbol.for("react.portal"),w=Symbol.for("react.fragment"),E=Symbol.for("react.strict_mode"),_=Symbol.for("react.profiler"),P=Symbol.for("react.provider"),C=Symbol.for("react.context"),A=Symbol.for("react.forward_ref"),T=Symbol.for("react.suspense"),M=Symbol.for("react.suspense_list"),D=Symbol.for("react.memo"),I=Symbol.for("react.lazy");Symbol.for("react.scope"),Symbol.for("react.debug_trace_mode");var F=Symbol.for("react.offscreen");Symbol.for("react.legacy_hidden"),Symbol.for("react.cache"),Symbol.for("react.tracing_marker");var O=Symbol.iterator;function R(e){return null===e||"object"!=typeof e?null:"function"==typeof(e=O&&e[O]||e["@@iterator"])?e:null}var L,N=Object.assign;function V(e){if(void 0===L)try{throw Error()}catch(e){var t=e.stack.trim().match(/\n( *(at )?)/);L=t&&t[1]||""}return"\n"+L+e}var z=!1;function B(e,t){if(!e||z)return"";z=!0;var r=Error.prepareStackTrace;Error.prepareStackTrace=void 0;try{if(t)if(t=function(){throw Error()},Object.defineProperty(t.prototype,"props",{set:function(){throw Error()}}),"object"==typeof Reflect&&Reflect.construct){try{Reflect.construct(t,[])}catch(e){var n=e}Reflect.construct(e,[],t)}else{try{t.call()}catch(e){n=e}e.call(t.prototype)}else{try{throw Error()}catch(e){n=e}e()}}catch(t){if(t&&n&&"string"==typeof t.stack){for(var a=t.stack.split("\n"),i=n.stack.split("\n"),s=a.length-1,o=i.length-1;1<=s&&0<=o&&a[s]!==i[o];)o--;for(;1<=s&&0<=o;s--,o--)if(a[s]!==i[o]){if(1!==s||1!==o)do{if(s--,0>--o||a[s]!==i[o]){var l="\n"+a[s].replace(" at new "," at ");return e.displayName&&l.includes("<anonymous>")&&(l=l.replace("<anonymous>",e.displayName)),l}}while(1<=s&&0<=o);break}}}finally{z=!1,Error.prepareStackTrace=r}return(e=e?e.displayName||e.name:"")?V(e):""}function j(e){switch(e.tag){case 5:return V(e.type);case 16:return V("Lazy");case 13:return V("Suspense");case 19:return V("SuspenseList");case 0:case 2:case 15:return e=B(e.type,!1);case 11:return e=B(e.type.render,!1);case 1:return e=B(e.type,!0);default:return""}}function G(e){if(null==e)return null;if("function"==typeof e)return e.displayName||e.name||null;if("string"==typeof e)return e;switch(e){case w:return"Fragment";case S:return"Portal";case _:return"Profiler";case E:return"StrictMode";case T:return"Suspense";case M:return"SuspenseList"}if("object"==typeof e)switch(e.$$typeof){case C:return(e.displayName||"Context")+".Consumer";case P:return(e._context.displayName||"Context")+".Provider";case A:var t=e.render;return(e=e.displayName)||(e=""!==(e=t.displayName||t.name||"")?"ForwardRef("+e+")":"ForwardRef"),e;case D:return null!==(t=e.displayName||null)?t:G(e.type)||"Memo";case I:t=e._payload,e=e._init;try{return G(e(t))}catch(e){}}return null}function H(e){var t=e.type;switch(e.tag){case 24:return"Cache";case 9:return(t.displayName||"Context")+".Consumer";case 10:return(t._context.displayName||"Context")+".Provider";case 18:return"DehydratedFragment";case 11:return e=(e=t.render).displayName||e.name||"",t.displayName||(""!==e?"ForwardRef("+e+")":"ForwardRef");case 7:return"Fragment";case 5:return t;case 4:return"Portal";case 3:return"Root";case 6:return"Text";case 16:return G(t);case 8:return t===E?"StrictMode":"Mode";case 22:return"Offscreen";case 12:return"Profiler";case 21:return"Scope";case 13:return"Suspense";case 19:return"SuspenseList";case 25:return"TracingMarker";case 1:case 0:case 17:case 2:case 14:case 15:if("function"==typeof t)return t.displayName||t.name||null;if("string"==typeof t)return t}return null}function q(e){switch(typeof e){case"boolean":case"number":case"string":case"undefined":case"object":return e;default:return""}}function U(e){var t=e.type;return(e=e.nodeName)&&"input"===e.toLowerCase()&&("checkbox"===t||"radio"===t)}function W(e){e._valueTracker||(e._valueTracker=function(e){var t=U(e)?"checked":"value",r=Object.getOwnPropertyDescriptor(e.constructor.prototype,t),n=""+e[t];if(!e.hasOwnProperty(t)&&void 0!==r&&"function"==typeof r.get&&"function"==typeof r.set){var a=r.get,i=r.set;return Object.defineProperty(e,t,{configurable:!0,get:function(){return a.call(this)},set:function(e){n=""+e,i.call(this,e)}}),Object.defineProperty(e,t,{enumerable:r.enumerable}),{getValue:function(){return n},setValue:function(e){n=""+e},stopTracking:function(){e._valueTracker=null,delete e[t]}}}}(e))}function $(e){if(!e)return!1;var t=e._valueTracker;if(!t)return!0;var r=t.getValue(),n="";return e&&(n=U(e)?e.checked?"true":"false":e.value),(e=n)!==r&&(t.setValue(e),!0)}function K(e){if(void 0===(e=e||("undefined"!=typeof document?document:void 0)))return null;try{return e.activeElement||e.body}catch(t){return e.body}}function J(e,t){var r=t.checked;return N({},t,{defaultChecked:void 0,defaultValue:void 0,value:void 0,checked:null!=r?r:e._wrapperState.initialChecked})}function Y(e,t){var r=null==t.defaultValue?"":t.defaultValue,n=null!=t.checked?t.checked:t.defaultChecked;r=q(null!=t.value?t.value:r),e._wrapperState={initialChecked:n,initialValue:r,controlled:"checkbox"===t.type||"radio"===t.type?null!=t.checked:null!=t.value}}function Q(e,t){null!=(t=t.checked)&&b(e,"checked",t,!1)}function X(e,t){Q(e,t);var r=q(t.value),n=t.type;if(null!=r)"number"===n?(0===r&&""===e.value||e.value!=r)&&(e.value=""+r):e.value!==""+r&&(e.value=""+r);else if("submit"===n||"reset"===n)return void e.removeAttribute("value");t.hasOwnProperty("value")?ee(e,t.type,r):t.hasOwnProperty("defaultValue")&&ee(e,t.type,q(t.defaultValue)),null==t.checked&&null!=t.defaultChecked&&(e.defaultChecked=!!t.defaultChecked)}function Z(e,t,r){if(t.hasOwnProperty("value")||t.hasOwnProperty("defaultValue")){var n=t.type;if(!("submit"!==n&&"reset"!==n||void 0!==t.value&&null!==t.value))return;t=""+e._wrapperState.initialValue,r||t===e.value||(e.value=t),e.defaultValue=t}""!==(r=e.name)&&(e.name=""),e.defaultChecked=!!e._wrapperState.initialChecked,""!==r&&(e.name=r)}function ee(e,t,r){"number"===t&&K(e.ownerDocument)===e||(null==r?e.defaultValue=""+e._wrapperState.initialValue:e.defaultValue!==""+r&&(e.defaultValue=""+r))}var te=Array.isArray;function re(e,t,r,n){if(e=e.options,t){t={};for(var a=0;a<r.length;a++)t["$"+r[a]]=!0;for(r=0;r<e.length;r++)a=t.hasOwnProperty("$"+e[r].value),e[r].selected!==a&&(e[r].selected=a),a&&n&&(e[r].defaultSelected=!0)}else{for(r=""+q(r),t=null,a=0;a<e.length;a++){if(e[a].value===r)return e[a].selected=!0,void(n&&(e[a].defaultSelected=!0));null!==t||e[a].disabled||(t=e[a])}null!==t&&(t.selected=!0)}}function ne(e,t){if(null!=t.dangerouslySetInnerHTML)throw Error(i(91));return N({},t,{value:void 0,defaultValue:void 0,children:""+e._wrapperState.initialValue})}function ae(e,t){var r=t.value;if(null==r){if(r=t.children,t=t.defaultValue,null!=r){if(null!=t)throw Error(i(92));if(te(r)){if(1<r.length)throw Error(i(93));r=r[0]}t=r}null==t&&(t=""),r=t}e._wrapperState={initialValue:q(r)}}function ie(e,t){var r=q(t.value),n=q(t.defaultValue);null!=r&&((r=""+r)!==e.value&&(e.value=r),null==t.defaultValue&&e.defaultValue!==r&&(e.defaultValue=r)),null!=n&&(e.defaultValue=""+n)}function se(e){var t=e.textContent;t===e._wrapperState.initialValue&&""!==t&&null!==t&&(e.value=t)}function oe(e){switch(e){case"svg":return"http://www.w3.org/2000/svg";case"math":return"http://www.w3.org/1998/Math/MathML";default:return"http://www.w3.org/1999/xhtml"}}function le(e,t){return null==e||"http://www.w3.org/1999/xhtml"===e?oe(t):"http://www.w3.org/2000/svg"===e&&"foreignObject"===t?"http://www.w3.org/1999/xhtml":e}var ue,ce,he=(ce=function(e,t){if("http://www.w3.org/2000/svg"!==e.namespaceURI||"innerHTML"in e)e.innerHTML=t;else{for((ue=ue||document.createElement("div")).innerHTML="<svg>"+t.valueOf().toString()+"</svg>",t=ue.firstChild;e.firstChild;)e.removeChild(e.firstChild);for(;t.firstChild;)e.appendChild(t.firstChild)}},"undefined"!=typeof MSApp&&MSApp.execUnsafeLocalFunction?function(e,t,r,n){MSApp.execUnsafeLocalFunction((function(){return ce(e,t)}))}:ce);function pe(e,t){if(t){var r=e.firstChild;if(r&&r===e.lastChild&&3===r.nodeType)return void(r.nodeValue=t)}e.textContent=t}var fe={animationIterationCount:!0,aspectRatio:!0,borderImageOutset:!0,borderImageSlice:!0,borderImageWidth:!0,boxFlex:!0,boxFlexGroup:!0,boxOrdinalGroup:!0,columnCount:!0,columns:!0,flex:!0,flexGrow:!0,flexPositive:!0,flexShrink:!0,flexNegative:!0,flexOrder:!0,gridArea:!0,gridRow:!0,gridRowEnd:!0,gridRowSpan:!0,gridRowStart:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnSpan:!0,gridColumnStart:!0,fontWeight:!0,lineClamp:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,tabSize:!0,widows:!0,zIndex:!0,zoom:!0,fillOpacity:!0,floodOpacity:!0,stopOpacity:!0,strokeDasharray:!0,strokeDashoffset:!0,strokeMiterlimit:!0,strokeOpacity:!0,strokeWidth:!0},de=["Webkit","ms","Moz","O"];function me(e,t,r){return null==t||"boolean"==typeof t||""===t?"":r||"number"!=typeof t||0===t||fe.hasOwnProperty(e)&&fe[e]?(""+t).trim():t+"px"}function ge(e,t){for(var r in e=e.style,t)if(t.hasOwnProperty(r)){var n=0===r.indexOf("--"),a=me(r,t[r],n);"float"===r&&(r="cssFloat"),n?e.setProperty(r,a):e[r]=a}}Object.keys(fe).forEach((function(e){de.forEach((function(t){t=t+e.charAt(0).toUpperCase()+e.substring(1),fe[t]=fe[e]}))}));var ye=N({menuitem:!0},{area:!0,base:!0,br:!0,col:!0,embed:!0,hr:!0,img:!0,input:!0,keygen:!0,link:!0,meta:!0,param:!0,source:!0,track:!0,wbr:!0});function ve(e,t){if(t){if(ye[e]&&(null!=t.children||null!=t.dangerouslySetInnerHTML))throw Error(i(137,e));if(null!=t.dangerouslySetInnerHTML){if(null!=t.children)throw Error(i(60));if("object"!=typeof t.dangerouslySetInnerHTML||!("__html"in t.dangerouslySetInnerHTML))throw Error(i(61))}if(null!=t.style&&"object"!=typeof t.style)throw Error(i(62))}}function be(e,t){if(-1===e.indexOf("-"))return"string"==typeof t.is;switch(e){case"annotation-xml":case"color-profile":case"font-face":case"font-face-src":case"font-face-uri":case"font-face-format":case"font-face-name":case"missing-glyph":return!1;default:return!0}}var ke=null;function xe(e){return(e=e.target||e.srcElement||window).correspondingUseElement&&(e=e.correspondingUseElement),3===e.nodeType?e.parentNode:e}var Se=null,we=null,Ee=null;function _e(e){if(e=ba(e)){if("function"!=typeof Se)throw Error(i(280));var t=e.stateNode;t&&(t=xa(t),Se(e.stateNode,e.type,t))}}function Pe(e){we?Ee?Ee.push(e):Ee=[e]:we=e}function Ce(){if(we){var e=we,t=Ee;if(Ee=we=null,_e(e),t)for(e=0;e<t.length;e++)_e(t[e])}}function Ae(e,t){return e(t)}function Te(){}var Me=!1;function De(e,t,r){if(Me)return e(t,r);Me=!0;try{return Ae(e,t,r)}finally{Me=!1,(null!==we||null!==Ee)&&(Te(),Ce())}}function Ie(e,t){var r=e.stateNode;if(null===r)return null;var n=xa(r);if(null===n)return null;r=n[t];e:switch(t){case"onClick":case"onClickCapture":case"onDoubleClick":case"onDoubleClickCapture":case"onMouseDown":case"onMouseDownCapture":case"onMouseMove":case"onMouseMoveCapture":case"onMouseUp":case"onMouseUpCapture":case"onMouseEnter":(n=!n.disabled)||(n=!("button"===(e=e.type)||"input"===e||"select"===e||"textarea"===e)),e=!n;break e;default:e=!1}if(e)return null;if(r&&"function"!=typeof r)throw Error(i(231,t,typeof r));return r}var Fe=!1;if(c)try{var Oe={};Object.defineProperty(Oe,"passive",{get:function(){Fe=!0}}),window.addEventListener("test",Oe,Oe),window.removeEventListener("test",Oe,Oe)}catch(ce){Fe=!1}function Re(e,t,r,n,a,i,s,o,l){var u=Array.prototype.slice.call(arguments,3);try{t.apply(r,u)}catch(e){this.onError(e)}}var Le=!1,Ne=null,Ve=!1,ze=null,Be={onError:function(e){Le=!0,Ne=e}};function je(e,t,r,n,a,i,s,o,l){Le=!1,Ne=null,Re.apply(Be,arguments)}function Ge(e){var t=e,r=e;if(e.alternate)for(;t.return;)t=t.return;else{e=t;do{0!=(4098&(t=e).flags)&&(r=t.return),e=t.return}while(e)}return 3===t.tag?r:null}function He(e){if(13===e.tag){var t=e.memoizedState;if(null===t&&(null!==(e=e.alternate)&&(t=e.memoizedState)),null!==t)return t.dehydrated}return null}function qe(e){if(Ge(e)!==e)throw Error(i(188))}function Ue(e){return null!==(e=function(e){var t=e.alternate;if(!t){if(null===(t=Ge(e)))throw Error(i(188));return t!==e?null:e}for(var r=e,n=t;;){var a=r.return;if(null===a)break;var s=a.alternate;if(null===s){if(null!==(n=a.return)){r=n;continue}break}if(a.child===s.child){for(s=a.child;s;){if(s===r)return qe(a),e;if(s===n)return qe(a),t;s=s.sibling}throw Error(i(188))}if(r.return!==n.return)r=a,n=s;else{for(var o=!1,l=a.child;l;){if(l===r){o=!0,r=a,n=s;break}if(l===n){o=!0,n=a,r=s;break}l=l.sibling}if(!o){for(l=s.child;l;){if(l===r){o=!0,r=s,n=a;break}if(l===n){o=!0,n=s,r=a;break}l=l.sibling}if(!o)throw Error(i(189))}}if(r.alternate!==n)throw Error(i(190))}if(3!==r.tag)throw Error(i(188));return r.stateNode.current===r?e:t}(e))?We(e):null}function We(e){if(5===e.tag||6===e.tag)return e;for(e=e.child;null!==e;){var t=We(e);if(null!==t)return t;e=e.sibling}return null}var $e=a.unstable_scheduleCallback,Ke=a.unstable_cancelCallback,Je=a.unstable_shouldYield,Ye=a.unstable_requestPaint,Qe=a.unstable_now,Xe=a.unstable_getCurrentPriorityLevel,Ze=a.unstable_ImmediatePriority,et=a.unstable_UserBlockingPriority,tt=a.unstable_NormalPriority,rt=a.unstable_LowPriority,nt=a.unstable_IdlePriority,at=null,it=null;var st=Math.clz32?Math.clz32:function(e){return e>>>=0,0===e?32:31-(ot(e)/lt|0)|0},ot=Math.log,lt=Math.LN2;var ut=64,ct=4194304;function ht(e){switch(e&-e){case 1:return 1;case 2:return 2;case 4:return 4;case 8:return 8;case 16:return 16;case 32:return 32;case 64:case 128:case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:case 262144:case 524288:case 1048576:case 2097152:return 4194240&e;case 4194304:case 8388608:case 16777216:case 33554432:case 67108864:return 130023424&e;case 134217728:return 134217728;case 268435456:return 268435456;case 536870912:return 536870912;case 1073741824:return 1073741824;default:return e}}function pt(e,t){var r=e.pendingLanes;if(0===r)return 0;var n=0,a=e.suspendedLanes,i=e.pingedLanes,s=268435455&r;if(0!==s){var o=s&~a;0!==o?n=ht(o):0!==(i&=s)&&(n=ht(i))}else 0!==(s=r&~a)?n=ht(s):0!==i&&(n=ht(i));if(0===n)return 0;if(0!==t&&t!==n&&0==(t&a)&&((a=n&-n)>=(i=t&-t)||16===a&&0!=(4194240&i)))return t;if(0!=(4&n)&&(n|=16&r),0!==(t=e.entangledLanes))for(e=e.entanglements,t&=n;0<t;)a=1<<(r=31-st(t)),n|=e[r],t&=~a;return n}function ft(e,t){switch(e){case 1:case 2:case 4:return t+250;case 8:case 16:case 32:case 64:case 128:case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:case 262144:case 524288:case 1048576:case 2097152:return t+5e3;default:return-1}}function dt(e){return 0!==(e=-1073741825&e.pendingLanes)?e:1073741824&e?1073741824:0}function mt(){var e=ut;return 0==(4194240&(ut<<=1))&&(ut=64),e}function gt(e){for(var t=[],r=0;31>r;r++)t.push(e);return t}function yt(e,t,r){e.pendingLanes|=t,536870912!==t&&(e.suspendedLanes=0,e.pingedLanes=0),(e=e.eventTimes)[t=31-st(t)]=r}function vt(e,t){var r=e.entangledLanes|=t;for(e=e.entanglements;r;){var n=31-st(r),a=1<<n;a&t|e[n]&t&&(e[n]|=t),r&=~a}}var bt=0;function kt(e){return 1<(e&=-e)?4<e?0!=(268435455&e)?16:536870912:4:1}var xt,St,wt,Et,_t,Pt=!1,Ct=[],At=null,Tt=null,Mt=null,Dt=new Map,It=new Map,Ft=[],Ot="mousedown mouseup touchcancel touchend touchstart auxclick dblclick pointercancel pointerdown pointerup dragend dragstart drop compositionend compositionstart keydown keypress keyup input textInput copy cut paste click change contextmenu reset submit".split(" ");function Rt(e,t){switch(e){case"focusin":case"focusout":At=null;break;case"dragenter":case"dragleave":Tt=null;break;case"mouseover":case"mouseout":Mt=null;break;case"pointerover":case"pointerout":Dt.delete(t.pointerId);break;case"gotpointercapture":case"lostpointercapture":It.delete(t.pointerId)}}function Lt(e,t,r,n,a,i){return null===e||e.nativeEvent!==i?(e={blockedOn:t,domEventName:r,eventSystemFlags:n,nativeEvent:i,targetContainers:[a]},null!==t&&(null!==(t=ba(t))&&St(t)),e):(e.eventSystemFlags|=n,t=e.targetContainers,null!==a&&-1===t.indexOf(a)&&t.push(a),e)}function Nt(e){var t=va(e.target);if(null!==t){var r=Ge(t);if(null!==r)if(13===(t=r.tag)){if(null!==(t=He(r)))return e.blockedOn=t,void _t(e.priority,(function(){wt(r)}))}else if(3===t&&r.stateNode.current.memoizedState.isDehydrated)return void(e.blockedOn=3===r.tag?r.stateNode.containerInfo:null)}e.blockedOn=null}function Vt(e){if(null!==e.blockedOn)return!1;for(var t=e.targetContainers;0<t.length;){var r=Jt(e.domEventName,e.eventSystemFlags,t[0],e.nativeEvent);if(null!==r)return null!==(t=ba(r))&&St(t),e.blockedOn=r,!1;var n=new(r=e.nativeEvent).constructor(r.type,r);ke=n,r.target.dispatchEvent(n),ke=null,t.shift()}return!0}function zt(e,t,r){Vt(e)&&r.delete(t)}function Bt(){Pt=!1,null!==At&&Vt(At)&&(At=null),null!==Tt&&Vt(Tt)&&(Tt=null),null!==Mt&&Vt(Mt)&&(Mt=null),Dt.forEach(zt),It.forEach(zt)}function jt(e,t){e.blockedOn===t&&(e.blockedOn=null,Pt||(Pt=!0,a.unstable_scheduleCallback(a.unstable_NormalPriority,Bt)))}function Gt(e){function t(t){return jt(t,e)}if(0<Ct.length){jt(Ct[0],e);for(var r=1;r<Ct.length;r++){var n=Ct[r];n.blockedOn===e&&(n.blockedOn=null)}}for(null!==At&&jt(At,e),null!==Tt&&jt(Tt,e),null!==Mt&&jt(Mt,e),Dt.forEach(t),It.forEach(t),r=0;r<Ft.length;r++)(n=Ft[r]).blockedOn===e&&(n.blockedOn=null);for(;0<Ft.length&&null===(r=Ft[0]).blockedOn;)Nt(r),null===r.blockedOn&&Ft.shift()}var Ht=k.ReactCurrentBatchConfig,qt=!0;function Ut(e,t,r,n){var a=bt,i=Ht.transition;Ht.transition=null;try{bt=1,$t(e,t,r,n)}finally{bt=a,Ht.transition=i}}function Wt(e,t,r,n){var a=bt,i=Ht.transition;Ht.transition=null;try{bt=4,$t(e,t,r,n)}finally{bt=a,Ht.transition=i}}function $t(e,t,r,n){if(qt){var a=Jt(e,t,r,n);if(null===a)qn(e,t,n,Kt,r),Rt(e,n);else if(function(e,t,r,n,a){switch(t){case"focusin":return At=Lt(At,e,t,r,n,a),!0;case"dragenter":return Tt=Lt(Tt,e,t,r,n,a),!0;case"mouseover":return Mt=Lt(Mt,e,t,r,n,a),!0;case"pointerover":var i=a.pointerId;return Dt.set(i,Lt(Dt.get(i)||null,e,t,r,n,a)),!0;case"gotpointercapture":return i=a.pointerId,It.set(i,Lt(It.get(i)||null,e,t,r,n,a)),!0}return!1}(a,e,t,r,n))n.stopPropagation();else if(Rt(e,n),4&t&&-1<Ot.indexOf(e)){for(;null!==a;){var i=ba(a);if(null!==i&&xt(i),null===(i=Jt(e,t,r,n))&&qn(e,t,n,Kt,r),i===a)break;a=i}null!==a&&n.stopPropagation()}else qn(e,t,n,null,r)}}var Kt=null;function Jt(e,t,r,n){if(Kt=null,null!==(e=va(e=xe(n))))if(null===(t=Ge(e)))e=null;else if(13===(r=t.tag)){if(null!==(e=He(t)))return e;e=null}else if(3===r){if(t.stateNode.current.memoizedState.isDehydrated)return 3===t.tag?t.stateNode.containerInfo:null;e=null}else t!==e&&(e=null);return Kt=e,null}function Yt(e){switch(e){case"cancel":case"click":case"close":case"contextmenu":case"copy":case"cut":case"auxclick":case"dblclick":case"dragend":case"dragstart":case"drop":case"focusin":case"focusout":case"input":case"invalid":case"keydown":case"keypress":case"keyup":case"mousedown":case"mouseup":case"paste":case"pause":case"play":case"pointercancel":case"pointerdown":case"pointerup":case"ratechange":case"reset":case"resize":case"seeked":case"submit":case"touchcancel":case"touchend":case"touchstart":case"volumechange":case"change":case"selectionchange":case"textInput":case"compositionstart":case"compositionend":case"compositionupdate":case"beforeblur":case"afterblur":case"beforeinput":case"blur":case"fullscreenchange":case"focus":case"hashchange":case"popstate":case"select":case"selectstart":return 1;case"drag":case"dragenter":case"dragexit":case"dragleave":case"dragover":case"mousemove":case"mouseout":case"mouseover":case"pointermove":case"pointerout":case"pointerover":case"scroll":case"toggle":case"touchmove":case"wheel":case"mouseenter":case"mouseleave":case"pointerenter":case"pointerleave":return 4;case"message":switch(Xe()){case Ze:return 1;case et:return 4;case tt:case rt:return 16;case nt:return 536870912;default:return 16}default:return 16}}var Qt=null,Xt=null,Zt=null;function er(){if(Zt)return Zt;var e,t,r=Xt,n=r.length,a="value"in Qt?Qt.value:Qt.textContent,i=a.length;for(e=0;e<n&&r[e]===a[e];e++);var s=n-e;for(t=1;t<=s&&r[n-t]===a[i-t];t++);return Zt=a.slice(e,1<t?1-t:void 0)}function tr(e){var t=e.keyCode;return"charCode"in e?0===(e=e.charCode)&&13===t&&(e=13):e=t,10===e&&(e=13),32<=e||13===e?e:0}function rr(){return!0}function nr(){return!1}function ar(e){function t(t,r,n,a,i){for(var s in this._reactName=t,this._targetInst=n,this.type=r,this.nativeEvent=a,this.target=i,this.currentTarget=null,e)e.hasOwnProperty(s)&&(t=e[s],this[s]=t?t(a):a[s]);return this.isDefaultPrevented=(null!=a.defaultPrevented?a.defaultPrevented:!1===a.returnValue)?rr:nr,this.isPropagationStopped=nr,this}return N(t.prototype,{preventDefault:function(){this.defaultPrevented=!0;var e=this.nativeEvent;e&&(e.preventDefault?e.preventDefault():"unknown"!=typeof e.returnValue&&(e.returnValue=!1),this.isDefaultPrevented=rr)},stopPropagation:function(){var e=this.nativeEvent;e&&(e.stopPropagation?e.stopPropagation():"unknown"!=typeof e.cancelBubble&&(e.cancelBubble=!0),this.isPropagationStopped=rr)},persist:function(){},isPersistent:rr}),t}var ir,sr,or,lr={eventPhase:0,bubbles:0,cancelable:0,timeStamp:function(e){return e.timeStamp||Date.now()},defaultPrevented:0,isTrusted:0},ur=ar(lr),cr=N({},lr,{view:0,detail:0}),hr=ar(cr),pr=N({},cr,{screenX:0,screenY:0,clientX:0,clientY:0,pageX:0,pageY:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,getModifierState:Er,button:0,buttons:0,relatedTarget:function(e){return void 0===e.relatedTarget?e.fromElement===e.srcElement?e.toElement:e.fromElement:e.relatedTarget},movementX:function(e){return"movementX"in e?e.movementX:(e!==or&&(or&&"mousemove"===e.type?(ir=e.screenX-or.screenX,sr=e.screenY-or.screenY):sr=ir=0,or=e),ir)},movementY:function(e){return"movementY"in e?e.movementY:sr}}),fr=ar(pr),dr=ar(N({},pr,{dataTransfer:0})),mr=ar(N({},cr,{relatedTarget:0})),gr=ar(N({},lr,{animationName:0,elapsedTime:0,pseudoElement:0})),yr=N({},lr,{clipboardData:function(e){return"clipboardData"in e?e.clipboardData:window.clipboardData}}),vr=ar(yr),br=ar(N({},lr,{data:0})),kr={Esc:"Escape",Spacebar:" ",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown",Del:"Delete",Win:"OS",Menu:"ContextMenu",Apps:"ContextMenu",Scroll:"ScrollLock",MozPrintableKey:"Unidentified"},xr={8:"Backspace",9:"Tab",12:"Clear",13:"Enter",16:"Shift",17:"Control",18:"Alt",19:"Pause",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",45:"Insert",46:"Delete",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"NumLock",145:"ScrollLock",224:"Meta"},Sr={Alt:"altKey",Control:"ctrlKey",Meta:"metaKey",Shift:"shiftKey"};function wr(e){var t=this.nativeEvent;return t.getModifierState?t.getModifierState(e):!!(e=Sr[e])&&!!t[e]}function Er(){return wr}var _r=N({},cr,{key:function(e){if(e.key){var t=kr[e.key]||e.key;if("Unidentified"!==t)return t}return"keypress"===e.type?13===(e=tr(e))?"Enter":String.fromCharCode(e):"keydown"===e.type||"keyup"===e.type?xr[e.keyCode]||"Unidentified":""},code:0,location:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,repeat:0,locale:0,getModifierState:Er,charCode:function(e){return"keypress"===e.type?tr(e):0},keyCode:function(e){return"keydown"===e.type||"keyup"===e.type?e.keyCode:0},which:function(e){return"keypress"===e.type?tr(e):"keydown"===e.type||"keyup"===e.type?e.keyCode:0}}),Pr=ar(_r),Cr=ar(N({},pr,{pointerId:0,width:0,height:0,pressure:0,tangentialPressure:0,tiltX:0,tiltY:0,twist:0,pointerType:0,isPrimary:0})),Ar=ar(N({},cr,{touches:0,targetTouches:0,changedTouches:0,altKey:0,metaKey:0,ctrlKey:0,shiftKey:0,getModifierState:Er})),Tr=ar(N({},lr,{propertyName:0,elapsedTime:0,pseudoElement:0})),Mr=N({},pr,{deltaX:function(e){return"deltaX"in e?e.deltaX:"wheelDeltaX"in e?-e.wheelDeltaX:0},deltaY:function(e){return"deltaY"in e?e.deltaY:"wheelDeltaY"in e?-e.wheelDeltaY:"wheelDelta"in e?-e.wheelDelta:0},deltaZ:0,deltaMode:0}),Dr=ar(Mr),Ir=[9,13,27,32],Fr=c&&"CompositionEvent"in window,Or=null;c&&"documentMode"in document&&(Or=document.documentMode);var Rr=c&&"TextEvent"in window&&!Or,Lr=c&&(!Fr||Or&&8<Or&&11>=Or),Nr=String.fromCharCode(32),Vr=!1;function zr(e,t){switch(e){case"keyup":return-1!==Ir.indexOf(t.keyCode);case"keydown":return 229!==t.keyCode;case"keypress":case"mousedown":case"focusout":return!0;default:return!1}}function Br(e){return"object"==typeof(e=e.detail)&&"data"in e?e.data:null}var jr=!1;var Gr={color:!0,date:!0,datetime:!0,"datetime-local":!0,email:!0,month:!0,number:!0,password:!0,range:!0,search:!0,tel:!0,text:!0,time:!0,url:!0,week:!0};function Hr(e){var t=e&&e.nodeName&&e.nodeName.toLowerCase();return"input"===t?!!Gr[e.type]:"textarea"===t}function qr(e,t,r,n){Pe(n),0<(t=Wn(t,"onChange")).length&&(r=new ur("onChange","change",null,r,n),e.push({event:r,listeners:t}))}var Ur=null,Wr=null;function $r(e){Vn(e,0)}function Kr(e){if($(ka(e)))return e}function Jr(e,t){if("change"===e)return t}var Yr=!1;if(c){var Qr;if(c){var Xr="oninput"in document;if(!Xr){var Zr=document.createElement("div");Zr.setAttribute("oninput","return;"),Xr="function"==typeof Zr.oninput}Qr=Xr}else Qr=!1;Yr=Qr&&(!document.documentMode||9<document.documentMode)}function en(){Ur&&(Ur.detachEvent("onpropertychange",tn),Wr=Ur=null)}function tn(e){if("value"===e.propertyName&&Kr(Wr)){var t=[];qr(t,Wr,e,xe(e)),De($r,t)}}function rn(e,t,r){"focusin"===e?(en(),Wr=r,(Ur=t).attachEvent("onpropertychange",tn)):"focusout"===e&&en()}function nn(e){if("selectionchange"===e||"keyup"===e||"keydown"===e)return Kr(Wr)}function an(e,t){if("click"===e)return Kr(t)}function sn(e,t){if("input"===e||"change"===e)return Kr(t)}var on="function"==typeof Object.is?Object.is:function(e,t){return e===t&&(0!==e||1/e==1/t)||e!=e&&t!=t};function ln(e,t){if(on(e,t))return!0;if("object"!=typeof e||null===e||"object"!=typeof t||null===t)return!1;var r=Object.keys(e),n=Object.keys(t);if(r.length!==n.length)return!1;for(n=0;n<r.length;n++){var a=r[n];if(!h.call(t,a)||!on(e[a],t[a]))return!1}return!0}function un(e){for(;e&&e.firstChild;)e=e.firstChild;return e}function cn(e,t){var r,n=un(e);for(e=0;n;){if(3===n.nodeType){if(r=e+n.textContent.length,e<=t&&r>=t)return{node:n,offset:t-e};e=r}e:{for(;n;){if(n.nextSibling){n=n.nextSibling;break e}n=n.parentNode}n=void 0}n=un(n)}}function hn(e,t){return!(!e||!t)&&(e===t||(!e||3!==e.nodeType)&&(t&&3===t.nodeType?hn(e,t.parentNode):"contains"in e?e.contains(t):!!e.compareDocumentPosition&&!!(16&e.compareDocumentPosition(t))))}function pn(){for(var e=window,t=K();t instanceof e.HTMLIFrameElement;){try{var r="string"==typeof t.contentWindow.location.href}catch(e){r=!1}if(!r)break;t=K((e=t.contentWindow).document)}return t}function fn(e){var t=e&&e.nodeName&&e.nodeName.toLowerCase();return t&&("input"===t&&("text"===e.type||"search"===e.type||"tel"===e.type||"url"===e.type||"password"===e.type)||"textarea"===t||"true"===e.contentEditable)}function dn(e){var t=pn(),r=e.focusedElem,n=e.selectionRange;if(t!==r&&r&&r.ownerDocument&&hn(r.ownerDocument.documentElement,r)){if(null!==n&&fn(r))if(t=n.start,void 0===(e=n.end)&&(e=t),"selectionStart"in r)r.selectionStart=t,r.selectionEnd=Math.min(e,r.value.length);else if((e=(t=r.ownerDocument||document)&&t.defaultView||window).getSelection){e=e.getSelection();var a=r.textContent.length,i=Math.min(n.start,a);n=void 0===n.end?i:Math.min(n.end,a),!e.extend&&i>n&&(a=n,n=i,i=a),a=cn(r,i);var s=cn(r,n);a&&s&&(1!==e.rangeCount||e.anchorNode!==a.node||e.anchorOffset!==a.offset||e.focusNode!==s.node||e.focusOffset!==s.offset)&&((t=t.createRange()).setStart(a.node,a.offset),e.removeAllRanges(),i>n?(e.addRange(t),e.extend(s.node,s.offset)):(t.setEnd(s.node,s.offset),e.addRange(t)))}for(t=[],e=r;e=e.parentNode;)1===e.nodeType&&t.push({element:e,left:e.scrollLeft,top:e.scrollTop});for("function"==typeof r.focus&&r.focus(),r=0;r<t.length;r++)(e=t[r]).element.scrollLeft=e.left,e.element.scrollTop=e.top}}var mn=c&&"documentMode"in document&&11>=document.documentMode,gn=null,yn=null,vn=null,bn=!1;function kn(e,t,r){var n=r.window===r?r.document:9===r.nodeType?r:r.ownerDocument;bn||null==gn||gn!==K(n)||("selectionStart"in(n=gn)&&fn(n)?n={start:n.selectionStart,end:n.selectionEnd}:n={anchorNode:(n=(n.ownerDocument&&n.ownerDocument.defaultView||window).getSelection()).anchorNode,anchorOffset:n.anchorOffset,focusNode:n.focusNode,focusOffset:n.focusOffset},vn&&ln(vn,n)||(vn=n,0<(n=Wn(yn,"onSelect")).length&&(t=new ur("onSelect","select",null,t,r),e.push({event:t,listeners:n}),t.target=gn)))}function xn(e,t){var r={};return r[e.toLowerCase()]=t.toLowerCase(),r["Webkit"+e]="webkit"+t,r["Moz"+e]="moz"+t,r}var Sn={animationend:xn("Animation","AnimationEnd"),animationiteration:xn("Animation","AnimationIteration"),animationstart:xn("Animation","AnimationStart"),transitionend:xn("Transition","TransitionEnd")},wn={},En={};function _n(e){if(wn[e])return wn[e];if(!Sn[e])return e;var t,r=Sn[e];for(t in r)if(r.hasOwnProperty(t)&&t in En)return wn[e]=r[t];return e}c&&(En=document.createElement("div").style,"AnimationEvent"in window||(delete Sn.animationend.animation,delete Sn.animationiteration.animation,delete Sn.animationstart.animation),"TransitionEvent"in window||delete Sn.transitionend.transition);var Pn=_n("animationend"),Cn=_n("animationiteration"),An=_n("animationstart"),Tn=_n("transitionend"),Mn=new Map,Dn="abort auxClick cancel canPlay canPlayThrough click close contextMenu copy cut drag dragEnd dragEnter dragExit dragLeave dragOver dragStart drop durationChange emptied encrypted ended error gotPointerCapture input invalid keyDown keyPress keyUp load loadedData loadedMetadata loadStart lostPointerCapture mouseDown mouseMove mouseOut mouseOver mouseUp paste pause play playing pointerCancel pointerDown pointerMove pointerOut pointerOver pointerUp progress rateChange reset resize seeked seeking stalled submit suspend timeUpdate touchCancel touchEnd touchStart volumeChange scroll toggle touchMove waiting wheel".split(" ");function In(e,t){Mn.set(e,t),l(t,[e])}for(var Fn=0;Fn<Dn.length;Fn++){var On=Dn[Fn];In(On.toLowerCase(),"on"+(On[0].toUpperCase()+On.slice(1)))}In(Pn,"onAnimationEnd"),In(Cn,"onAnimationIteration"),In(An,"onAnimationStart"),In("dblclick","onDoubleClick"),In("focusin","onFocus"),In("focusout","onBlur"),In(Tn,"onTransitionEnd"),u("onMouseEnter",["mouseout","mouseover"]),u("onMouseLeave",["mouseout","mouseover"]),u("onPointerEnter",["pointerout","pointerover"]),u("onPointerLeave",["pointerout","pointerover"]),l("onChange","change click focusin focusout input keydown keyup selectionchange".split(" ")),l("onSelect","focusout contextmenu dragend focusin keydown keyup mousedown mouseup selectionchange".split(" ")),l("onBeforeInput",["compositionend","keypress","textInput","paste"]),l("onCompositionEnd","compositionend focusout keydown keypress keyup mousedown".split(" ")),l("onCompositionStart","compositionstart focusout keydown keypress keyup mousedown".split(" ")),l("onCompositionUpdate","compositionupdate focusout keydown keypress keyup mousedown".split(" "));var Rn="abort canplay canplaythrough durationchange emptied encrypted ended error loadeddata loadedmetadata loadstart pause play playing progress ratechange resize seeked seeking stalled suspend timeupdate volumechange waiting".split(" "),Ln=new Set("cancel close invalid load scroll toggle".split(" ").concat(Rn));function Nn(e,t,r){var n=e.type||"unknown-event";e.currentTarget=r,function(e,t,r,n,a,s,o,l,u){if(je.apply(this,arguments),Le){if(!Le)throw Error(i(198));var c=Ne;Le=!1,Ne=null,Ve||(Ve=!0,ze=c)}}(n,t,void 0,e),e.currentTarget=null}function Vn(e,t){t=0!=(4&t);for(var r=0;r<e.length;r++){var n=e[r],a=n.event;n=n.listeners;e:{var i=void 0;if(t)for(var s=n.length-1;0<=s;s--){var o=n[s],l=o.instance,u=o.currentTarget;if(o=o.listener,l!==i&&a.isPropagationStopped())break e;Nn(a,o,u),i=l}else for(s=0;s<n.length;s++){if(l=(o=n[s]).instance,u=o.currentTarget,o=o.listener,l!==i&&a.isPropagationStopped())break e;Nn(a,o,u),i=l}}}if(Ve)throw e=ze,Ve=!1,ze=null,e}function zn(e,t){var r=t[ma];void 0===r&&(r=t[ma]=new Set);var n=e+"__bubble";r.has(n)||(Hn(t,e,2,!1),r.add(n))}function Bn(e,t,r){var n=0;t&&(n|=4),Hn(r,e,n,t)}var jn="_reactListening"+Math.random().toString(36).slice(2);function Gn(e){if(!e[jn]){e[jn]=!0,s.forEach((function(t){"selectionchange"!==t&&(Ln.has(t)||Bn(t,!1,e),Bn(t,!0,e))}));var t=9===e.nodeType?e:e.ownerDocument;null===t||t[jn]||(t[jn]=!0,Bn("selectionchange",!1,t))}}function Hn(e,t,r,n){switch(Yt(t)){case 1:var a=Ut;break;case 4:a=Wt;break;default:a=$t}r=a.bind(null,t,r,e),a=void 0,!Fe||"touchstart"!==t&&"touchmove"!==t&&"wheel"!==t||(a=!0),n?void 0!==a?e.addEventListener(t,r,{capture:!0,passive:a}):e.addEventListener(t,r,!0):void 0!==a?e.addEventListener(t,r,{passive:a}):e.addEventListener(t,r,!1)}function qn(e,t,r,n,a){var i=n;if(0==(1&t)&&0==(2&t)&&null!==n)e:for(;;){if(null===n)return;var s=n.tag;if(3===s||4===s){var o=n.stateNode.containerInfo;if(o===a||8===o.nodeType&&o.parentNode===a)break;if(4===s)for(s=n.return;null!==s;){var l=s.tag;if((3===l||4===l)&&((l=s.stateNode.containerInfo)===a||8===l.nodeType&&l.parentNode===a))return;s=s.return}for(;null!==o;){if(null===(s=va(o)))return;if(5===(l=s.tag)||6===l){n=i=s;continue e}o=o.parentNode}}n=n.return}De((function(){var n=i,a=xe(r),s=[];e:{var o=Mn.get(e);if(void 0!==o){var l=ur,u=e;switch(e){case"keypress":if(0===tr(r))break e;case"keydown":case"keyup":l=Pr;break;case"focusin":u="focus",l=mr;break;case"focusout":u="blur",l=mr;break;case"beforeblur":case"afterblur":l=mr;break;case"click":if(2===r.button)break e;case"auxclick":case"dblclick":case"mousedown":case"mousemove":case"mouseup":case"mouseout":case"mouseover":case"contextmenu":l=fr;break;case"drag":case"dragend":case"dragenter":case"dragexit":case"dragleave":case"dragover":case"dragstart":case"drop":l=dr;break;case"touchcancel":case"touchend":case"touchmove":case"touchstart":l=Ar;break;case Pn:case Cn:case An:l=gr;break;case Tn:l=Tr;break;case"scroll":l=hr;break;case"wheel":l=Dr;break;case"copy":case"cut":case"paste":l=vr;break;case"gotpointercapture":case"lostpointercapture":case"pointercancel":case"pointerdown":case"pointermove":case"pointerout":case"pointerover":case"pointerup":l=Cr}var c=0!=(4&t),h=!c&&"scroll"===e,p=c?null!==o?o+"Capture":null:o;c=[];for(var f,d=n;null!==d;){var m=(f=d).stateNode;if(5===f.tag&&null!==m&&(f=m,null!==p&&(null!=(m=Ie(d,p))&&c.push(Un(d,m,f)))),h)break;d=d.return}0<c.length&&(o=new l(o,u,null,r,a),s.push({event:o,listeners:c}))}}if(0==(7&t)){if(l="mouseout"===e||"pointerout"===e,(!(o="mouseover"===e||"pointerover"===e)||r===ke||!(u=r.relatedTarget||r.fromElement)||!va(u)&&!u[da])&&(l||o)&&(o=a.window===a?a:(o=a.ownerDocument)?o.defaultView||o.parentWindow:window,l?(l=n,null!==(u=(u=r.relatedTarget||r.toElement)?va(u):null)&&(u!==(h=Ge(u))||5!==u.tag&&6!==u.tag)&&(u=null)):(l=null,u=n),l!==u)){if(c=fr,m="onMouseLeave",p="onMouseEnter",d="mouse","pointerout"!==e&&"pointerover"!==e||(c=Cr,m="onPointerLeave",p="onPointerEnter",d="pointer"),h=null==l?o:ka(l),f=null==u?o:ka(u),(o=new c(m,d+"leave",l,r,a)).target=h,o.relatedTarget=f,m=null,va(a)===n&&((c=new c(p,d+"enter",u,r,a)).target=f,c.relatedTarget=h,m=c),h=m,l&&u)e:{for(p=u,d=0,f=c=l;f;f=$n(f))d++;for(f=0,m=p;m;m=$n(m))f++;for(;0<d-f;)c=$n(c),d--;for(;0<f-d;)p=$n(p),f--;for(;d--;){if(c===p||null!==p&&c===p.alternate)break e;c=$n(c),p=$n(p)}c=null}else c=null;null!==l&&Kn(s,o,l,c,!1),null!==u&&null!==h&&Kn(s,h,u,c,!0)}if("select"===(l=(o=n?ka(n):window).nodeName&&o.nodeName.toLowerCase())||"input"===l&&"file"===o.type)var g=Jr;else if(Hr(o))if(Yr)g=sn;else{g=nn;var y=rn}else(l=o.nodeName)&&"input"===l.toLowerCase()&&("checkbox"===o.type||"radio"===o.type)&&(g=an);switch(g&&(g=g(e,n))?qr(s,g,r,a):(y&&y(e,o,n),"focusout"===e&&(y=o._wrapperState)&&y.controlled&&"number"===o.type&&ee(o,"number",o.value)),y=n?ka(n):window,e){case"focusin":(Hr(y)||"true"===y.contentEditable)&&(gn=y,yn=n,vn=null);break;case"focusout":vn=yn=gn=null;break;case"mousedown":bn=!0;break;case"contextmenu":case"mouseup":case"dragend":bn=!1,kn(s,r,a);break;case"selectionchange":if(mn)break;case"keydown":case"keyup":kn(s,r,a)}var v;if(Fr)e:{switch(e){case"compositionstart":var b="onCompositionStart";break e;case"compositionend":b="onCompositionEnd";break e;case"compositionupdate":b="onCompositionUpdate";break e}b=void 0}else jr?zr(e,r)&&(b="onCompositionEnd"):"keydown"===e&&229===r.keyCode&&(b="onCompositionStart");b&&(Lr&&"ko"!==r.locale&&(jr||"onCompositionStart"!==b?"onCompositionEnd"===b&&jr&&(v=er()):(Xt="value"in(Qt=a)?Qt.value:Qt.textContent,jr=!0)),0<(y=Wn(n,b)).length&&(b=new br(b,e,null,r,a),s.push({event:b,listeners:y}),v?b.data=v:null!==(v=Br(r))&&(b.data=v))),(v=Rr?function(e,t){switch(e){case"compositionend":return Br(t);case"keypress":return 32!==t.which?null:(Vr=!0,Nr);case"textInput":return(e=t.data)===Nr&&Vr?null:e;default:return null}}(e,r):function(e,t){if(jr)return"compositionend"===e||!Fr&&zr(e,t)?(e=er(),Zt=Xt=Qt=null,jr=!1,e):null;switch(e){case"paste":default:return null;case"keypress":if(!(t.ctrlKey||t.altKey||t.metaKey)||t.ctrlKey&&t.altKey){if(t.char&&1<t.char.length)return t.char;if(t.which)return String.fromCharCode(t.which)}return null;case"compositionend":return Lr&&"ko"!==t.locale?null:t.data}}(e,r))&&(0<(n=Wn(n,"onBeforeInput")).length&&(a=new br("onBeforeInput","beforeinput",null,r,a),s.push({event:a,listeners:n}),a.data=v))}Vn(s,t)}))}function Un(e,t,r){return{instance:e,listener:t,currentTarget:r}}function Wn(e,t){for(var r=t+"Capture",n=[];null!==e;){var a=e,i=a.stateNode;5===a.tag&&null!==i&&(a=i,null!=(i=Ie(e,r))&&n.unshift(Un(e,i,a)),null!=(i=Ie(e,t))&&n.push(Un(e,i,a))),e=e.return}return n}function $n(e){if(null===e)return null;do{e=e.return}while(e&&5!==e.tag);return e||null}function Kn(e,t,r,n,a){for(var i=t._reactName,s=[];null!==r&&r!==n;){var o=r,l=o.alternate,u=o.stateNode;if(null!==l&&l===n)break;5===o.tag&&null!==u&&(o=u,a?null!=(l=Ie(r,i))&&s.unshift(Un(r,l,o)):a||null!=(l=Ie(r,i))&&s.push(Un(r,l,o))),r=r.return}0!==s.length&&e.push({event:t,listeners:s})}var Jn=/\r\n?/g,Yn=/\u0000|\uFFFD/g;function Qn(e){return("string"==typeof e?e:""+e).replace(Jn,"\n").replace(Yn,"")}function Xn(e,t,r){if(t=Qn(t),Qn(e)!==t&&r)throw Error(i(425))}function Zn(){}var ea=null,ta=null;function ra(e,t){return"textarea"===e||"noscript"===e||"string"==typeof t.children||"number"==typeof t.children||"object"==typeof t.dangerouslySetInnerHTML&&null!==t.dangerouslySetInnerHTML&&null!=t.dangerouslySetInnerHTML.__html}var na="function"==typeof setTimeout?setTimeout:void 0,aa="function"==typeof clearTimeout?clearTimeout:void 0,ia="function"==typeof Promise?Promise:void 0,sa="function"==typeof queueMicrotask?queueMicrotask:void 0!==ia?function(e){return ia.resolve(null).then(e).catch(oa)}:na;function oa(e){setTimeout((function(){throw e}))}function la(e,t){var r=t,n=0;do{var a=r.nextSibling;if(e.removeChild(r),a&&8===a.nodeType)if("/$"===(r=a.data)){if(0===n)return e.removeChild(a),void Gt(t);n--}else"$"!==r&&"$?"!==r&&"$!"!==r||n++;r=a}while(r);Gt(t)}function ua(e){for(;null!=e;e=e.nextSibling){var t=e.nodeType;if(1===t||3===t)break;if(8===t){if("$"===(t=e.data)||"$!"===t||"$?"===t)break;if("/$"===t)return null}}return e}function ca(e){e=e.previousSibling;for(var t=0;e;){if(8===e.nodeType){var r=e.data;if("$"===r||"$!"===r||"$?"===r){if(0===t)return e;t--}else"/$"===r&&t++}e=e.previousSibling}return null}var ha=Math.random().toString(36).slice(2),pa="__reactFiber$"+ha,fa="__reactProps$"+ha,da="__reactContainer$"+ha,ma="__reactEvents$"+ha,ga="__reactListeners$"+ha,ya="__reactHandles$"+ha;function va(e){var t=e[pa];if(t)return t;for(var r=e.parentNode;r;){if(t=r[da]||r[pa]){if(r=t.alternate,null!==t.child||null!==r&&null!==r.child)for(e=ca(e);null!==e;){if(r=e[pa])return r;e=ca(e)}return t}r=(e=r).parentNode}return null}function ba(e){return!(e=e[pa]||e[da])||5!==e.tag&&6!==e.tag&&13!==e.tag&&3!==e.tag?null:e}function ka(e){if(5===e.tag||6===e.tag)return e.stateNode;throw Error(i(33))}function xa(e){return e[fa]||null}var Sa=[],wa=-1;function Ea(e){return{current:e}}function _a(e){0>wa||(e.current=Sa[wa],Sa[wa]=null,wa--)}function Pa(e,t){wa++,Sa[wa]=e.current,e.current=t}var Ca={},Aa=Ea(Ca),Ta=Ea(!1),Ma=Ca;function Da(e,t){var r=e.type.contextTypes;if(!r)return Ca;var n=e.stateNode;if(n&&n.__reactInternalMemoizedUnmaskedChildContext===t)return n.__reactInternalMemoizedMaskedChildContext;var a,i={};for(a in r)i[a]=t[a];return n&&((e=e.stateNode).__reactInternalMemoizedUnmaskedChildContext=t,e.__reactInternalMemoizedMaskedChildContext=i),i}function Ia(e){return null!=(e=e.childContextTypes)}function Fa(){_a(Ta),_a(Aa)}function Oa(e,t,r){if(Aa.current!==Ca)throw Error(i(168));Pa(Aa,t),Pa(Ta,r)}function Ra(e,t,r){var n=e.stateNode;if(t=t.childContextTypes,"function"!=typeof n.getChildContext)return r;for(var a in n=n.getChildContext())if(!(a in t))throw Error(i(108,H(e)||"Unknown",a));return N({},r,n)}function La(e){return e=(e=e.stateNode)&&e.__reactInternalMemoizedMergedChildContext||Ca,Ma=Aa.current,Pa(Aa,e),Pa(Ta,Ta.current),!0}function Na(e,t,r){var n=e.stateNode;if(!n)throw Error(i(169));r?(e=Ra(e,t,Ma),n.__reactInternalMemoizedMergedChildContext=e,_a(Ta),_a(Aa),Pa(Aa,e)):_a(Ta),Pa(Ta,r)}var Va=null,za=!1,Ba=!1;function ja(e){null===Va?Va=[e]:Va.push(e)}function Ga(){if(!Ba&&null!==Va){Ba=!0;var e=0,t=bt;try{var r=Va;for(bt=1;e<r.length;e++){var n=r[e];do{n=n(!0)}while(null!==n)}Va=null,za=!1}catch(t){throw null!==Va&&(Va=Va.slice(e+1)),$e(Ze,Ga),t}finally{bt=t,Ba=!1}}return null}var Ha=[],qa=0,Ua=null,Wa=0,$a=[],Ka=0,Ja=null,Ya=1,Qa="";function Xa(e,t){Ha[qa++]=Wa,Ha[qa++]=Ua,Ua=e,Wa=t}function Za(e,t,r){$a[Ka++]=Ya,$a[Ka++]=Qa,$a[Ka++]=Ja,Ja=e;var n=Ya;e=Qa;var a=32-st(n)-1;n&=~(1<<a),r+=1;var i=32-st(t)+a;if(30<i){var s=a-a%5;i=(n&(1<<s)-1).toString(32),n>>=s,a-=s,Ya=1<<32-st(t)+a|r<<a|n,Qa=i+e}else Ya=1<<i|r<<a|n,Qa=e}function ei(e){null!==e.return&&(Xa(e,1),Za(e,1,0))}function ti(e){for(;e===Ua;)Ua=Ha[--qa],Ha[qa]=null,Wa=Ha[--qa],Ha[qa]=null;for(;e===Ja;)Ja=$a[--Ka],$a[Ka]=null,Qa=$a[--Ka],$a[Ka]=null,Ya=$a[--Ka],$a[Ka]=null}var ri=null,ni=null,ai=!1,ii=null;function si(e,t){var r=Iu(5,null,null,0);r.elementType="DELETED",r.stateNode=t,r.return=e,null===(t=e.deletions)?(e.deletions=[r],e.flags|=16):t.push(r)}function oi(e,t){switch(e.tag){case 5:var r=e.type;return null!==(t=1!==t.nodeType||r.toLowerCase()!==t.nodeName.toLowerCase()?null:t)&&(e.stateNode=t,ri=e,ni=ua(t.firstChild),!0);case 6:return null!==(t=""===e.pendingProps||3!==t.nodeType?null:t)&&(e.stateNode=t,ri=e,ni=null,!0);case 13:return null!==(t=8!==t.nodeType?null:t)&&(r=null!==Ja?{id:Ya,overflow:Qa}:null,e.memoizedState={dehydrated:t,treeContext:r,retryLane:1073741824},(r=Iu(18,null,null,0)).stateNode=t,r.return=e,e.child=r,ri=e,ni=null,!0);default:return!1}}function li(e){return 0!=(1&e.mode)&&0==(128&e.flags)}function ui(e){if(ai){var t=ni;if(t){var r=t;if(!oi(e,t)){if(li(e))throw Error(i(418));t=ua(r.nextSibling);var n=ri;t&&oi(e,t)?si(n,r):(e.flags=-4097&e.flags|2,ai=!1,ri=e)}}else{if(li(e))throw Error(i(418));e.flags=-4097&e.flags|2,ai=!1,ri=e}}}function ci(e){for(e=e.return;null!==e&&5!==e.tag&&3!==e.tag&&13!==e.tag;)e=e.return;ri=e}function hi(e){if(e!==ri)return!1;if(!ai)return ci(e),ai=!0,!1;var t;if((t=3!==e.tag)&&!(t=5!==e.tag)&&(t="head"!==(t=e.type)&&"body"!==t&&!ra(e.type,e.memoizedProps)),t&&(t=ni)){if(li(e))throw pi(),Error(i(418));for(;t;)si(e,t),t=ua(t.nextSibling)}if(ci(e),13===e.tag){if(!(e=null!==(e=e.memoizedState)?e.dehydrated:null))throw Error(i(317));e:{for(e=e.nextSibling,t=0;e;){if(8===e.nodeType){var r=e.data;if("/$"===r){if(0===t){ni=ua(e.nextSibling);break e}t--}else"$"!==r&&"$!"!==r&&"$?"!==r||t++}e=e.nextSibling}ni=null}}else ni=ri?ua(e.stateNode.nextSibling):null;return!0}function pi(){for(var e=ni;e;)e=ua(e.nextSibling)}function fi(){ni=ri=null,ai=!1}function di(e){null===ii?ii=[e]:ii.push(e)}var mi=k.ReactCurrentBatchConfig;function gi(e,t){if(e&&e.defaultProps){for(var r in t=N({},t),e=e.defaultProps)void 0===t[r]&&(t[r]=e[r]);return t}return t}var yi=Ea(null),vi=null,bi=null,ki=null;function xi(){ki=bi=vi=null}function Si(e){var t=yi.current;_a(yi),e._currentValue=t}function wi(e,t,r){for(;null!==e;){var n=e.alternate;if((e.childLanes&t)!==t?(e.childLanes|=t,null!==n&&(n.childLanes|=t)):null!==n&&(n.childLanes&t)!==t&&(n.childLanes|=t),e===r)break;e=e.return}}function Ei(e,t){vi=e,ki=bi=null,null!==(e=e.dependencies)&&null!==e.firstContext&&(0!=(e.lanes&t)&&(ko=!0),e.firstContext=null)}function _i(e){var t=e._currentValue;if(ki!==e)if(e={context:e,memoizedValue:t,next:null},null===bi){if(null===vi)throw Error(i(308));bi=e,vi.dependencies={lanes:0,firstContext:e}}else bi=bi.next=e;return t}var Pi=null;function Ci(e){null===Pi?Pi=[e]:Pi.push(e)}function Ai(e,t,r,n){var a=t.interleaved;return null===a?(r.next=r,Ci(t)):(r.next=a.next,a.next=r),t.interleaved=r,Ti(e,n)}function Ti(e,t){e.lanes|=t;var r=e.alternate;for(null!==r&&(r.lanes|=t),r=e,e=e.return;null!==e;)e.childLanes|=t,null!==(r=e.alternate)&&(r.childLanes|=t),r=e,e=e.return;return 3===r.tag?r.stateNode:null}var Mi=!1;function Di(e){e.updateQueue={baseState:e.memoizedState,firstBaseUpdate:null,lastBaseUpdate:null,shared:{pending:null,interleaved:null,lanes:0},effects:null}}function Ii(e,t){e=e.updateQueue,t.updateQueue===e&&(t.updateQueue={baseState:e.baseState,firstBaseUpdate:e.firstBaseUpdate,lastBaseUpdate:e.lastBaseUpdate,shared:e.shared,effects:e.effects})}function Fi(e,t){return{eventTime:e,lane:t,tag:0,payload:null,callback:null,next:null}}function Oi(e,t,r){var n=e.updateQueue;if(null===n)return null;if(n=n.shared,0!=(2&Tl)){var a=n.pending;return null===a?t.next=t:(t.next=a.next,a.next=t),n.pending=t,Ti(e,r)}return null===(a=n.interleaved)?(t.next=t,Ci(n)):(t.next=a.next,a.next=t),n.interleaved=t,Ti(e,r)}function Ri(e,t,r){if(null!==(t=t.updateQueue)&&(t=t.shared,0!=(4194240&r))){var n=t.lanes;r|=n&=e.pendingLanes,t.lanes=r,vt(e,r)}}function Li(e,t){var r=e.updateQueue,n=e.alternate;if(null!==n&&r===(n=n.updateQueue)){var a=null,i=null;if(null!==(r=r.firstBaseUpdate)){do{var s={eventTime:r.eventTime,lane:r.lane,tag:r.tag,payload:r.payload,callback:r.callback,next:null};null===i?a=i=s:i=i.next=s,r=r.next}while(null!==r);null===i?a=i=t:i=i.next=t}else a=i=t;return r={baseState:n.baseState,firstBaseUpdate:a,lastBaseUpdate:i,shared:n.shared,effects:n.effects},void(e.updateQueue=r)}null===(e=r.lastBaseUpdate)?r.firstBaseUpdate=t:e.next=t,r.lastBaseUpdate=t}function Ni(e,t,r,n){var a=e.updateQueue;Mi=!1;var i=a.firstBaseUpdate,s=a.lastBaseUpdate,o=a.shared.pending;if(null!==o){a.shared.pending=null;var l=o,u=l.next;l.next=null,null===s?i=u:s.next=u,s=l;var c=e.alternate;null!==c&&((o=(c=c.updateQueue).lastBaseUpdate)!==s&&(null===o?c.firstBaseUpdate=u:o.next=u,c.lastBaseUpdate=l))}if(null!==i){var h=a.baseState;for(s=0,c=u=l=null,o=i;;){var p=o.lane,f=o.eventTime;if((n&p)===p){null!==c&&(c=c.next={eventTime:f,lane:0,tag:o.tag,payload:o.payload,callback:o.callback,next:null});e:{var d=e,m=o;switch(p=t,f=r,m.tag){case 1:if("function"==typeof(d=m.payload)){h=d.call(f,h,p);break e}h=d;break e;case 3:d.flags=-65537&d.flags|128;case 0:if(null==(p="function"==typeof(d=m.payload)?d.call(f,h,p):d))break e;h=N({},h,p);break e;case 2:Mi=!0}}null!==o.callback&&0!==o.lane&&(e.flags|=64,null===(p=a.effects)?a.effects=[o]:p.push(o))}else f={eventTime:f,lane:p,tag:o.tag,payload:o.payload,callback:o.callback,next:null},null===c?(u=c=f,l=h):c=c.next=f,s|=p;if(null===(o=o.next)){if(null===(o=a.shared.pending))break;o=(p=o).next,p.next=null,a.lastBaseUpdate=p,a.shared.pending=null}}if(null===c&&(l=h),a.baseState=l,a.firstBaseUpdate=u,a.lastBaseUpdate=c,null!==(t=a.shared.interleaved)){a=t;do{s|=a.lane,a=a.next}while(a!==t)}else null===i&&(a.shared.lanes=0);Nl|=s,e.lanes=s,e.memoizedState=h}}function Vi(e,t,r){if(e=t.effects,t.effects=null,null!==e)for(t=0;t<e.length;t++){var n=e[t],a=n.callback;if(null!==a){if(n.callback=null,n=r,"function"!=typeof a)throw Error(i(191,a));a.call(n)}}}var zi=(new n.Component).refs;function Bi(e,t,r,n){r=null==(r=r(n,t=e.memoizedState))?t:N({},t,r),e.memoizedState=r,0===e.lanes&&(e.updateQueue.baseState=r)}var ji={isMounted:function(e){return!!(e=e._reactInternals)&&Ge(e)===e},enqueueSetState:function(e,t,r){e=e._reactInternals;var n=tu(),a=ru(e),i=Fi(n,a);i.payload=t,null!=r&&(i.callback=r),null!==(t=Oi(e,i,a))&&(nu(t,e,a,n),Ri(t,e,a))},enqueueReplaceState:function(e,t,r){e=e._reactInternals;var n=tu(),a=ru(e),i=Fi(n,a);i.tag=1,i.payload=t,null!=r&&(i.callback=r),null!==(t=Oi(e,i,a))&&(nu(t,e,a,n),Ri(t,e,a))},enqueueForceUpdate:function(e,t){e=e._reactInternals;var r=tu(),n=ru(e),a=Fi(r,n);a.tag=2,null!=t&&(a.callback=t),null!==(t=Oi(e,a,n))&&(nu(t,e,n,r),Ri(t,e,n))}};function Gi(e,t,r,n,a,i,s){return"function"==typeof(e=e.stateNode).shouldComponentUpdate?e.shouldComponentUpdate(n,i,s):!t.prototype||!t.prototype.isPureReactComponent||(!ln(r,n)||!ln(a,i))}function Hi(e,t,r){var n=!1,a=Ca,i=t.contextType;return"object"==typeof i&&null!==i?i=_i(i):(a=Ia(t)?Ma:Aa.current,i=(n=null!=(n=t.contextTypes))?Da(e,a):Ca),t=new t(r,i),e.memoizedState=null!==t.state&&void 0!==t.state?t.state:null,t.updater=ji,e.stateNode=t,t._reactInternals=e,n&&((e=e.stateNode).__reactInternalMemoizedUnmaskedChildContext=a,e.__reactInternalMemoizedMaskedChildContext=i),t}function qi(e,t,r,n){e=t.state,"function"==typeof t.componentWillReceiveProps&&t.componentWillReceiveProps(r,n),"function"==typeof t.UNSAFE_componentWillReceiveProps&&t.UNSAFE_componentWillReceiveProps(r,n),t.state!==e&&ji.enqueueReplaceState(t,t.state,null)}function Ui(e,t,r,n){var a=e.stateNode;a.props=r,a.state=e.memoizedState,a.refs=zi,Di(e);var i=t.contextType;"object"==typeof i&&null!==i?a.context=_i(i):(i=Ia(t)?Ma:Aa.current,a.context=Da(e,i)),a.state=e.memoizedState,"function"==typeof(i=t.getDerivedStateFromProps)&&(Bi(e,t,i,r),a.state=e.memoizedState),"function"==typeof t.getDerivedStateFromProps||"function"==typeof a.getSnapshotBeforeUpdate||"function"!=typeof a.UNSAFE_componentWillMount&&"function"!=typeof a.componentWillMount||(t=a.state,"function"==typeof a.componentWillMount&&a.componentWillMount(),"function"==typeof a.UNSAFE_componentWillMount&&a.UNSAFE_componentWillMount(),t!==a.state&&ji.enqueueReplaceState(a,a.state,null),Ni(e,r,a,n),a.state=e.memoizedState),"function"==typeof a.componentDidMount&&(e.flags|=4194308)}function Wi(e,t,r){if(null!==(e=r.ref)&&"function"!=typeof e&&"object"!=typeof e){if(r._owner){if(r=r._owner){if(1!==r.tag)throw Error(i(309));var n=r.stateNode}if(!n)throw Error(i(147,e));var a=n,s=""+e;return null!==t&&null!==t.ref&&"function"==typeof t.ref&&t.ref._stringRef===s?t.ref:(t=function(e){var t=a.refs;t===zi&&(t=a.refs={}),null===e?delete t[s]:t[s]=e},t._stringRef=s,t)}if("string"!=typeof e)throw Error(i(284));if(!r._owner)throw Error(i(290,e))}return e}function $i(e,t){throw e=Object.prototype.toString.call(t),Error(i(31,"[object Object]"===e?"object with keys {"+Object.keys(t).join(", ")+"}":e))}function Ki(e){return(0,e._init)(e._payload)}function Ji(e){function t(t,r){if(e){var n=t.deletions;null===n?(t.deletions=[r],t.flags|=16):n.push(r)}}function r(r,n){if(!e)return null;for(;null!==n;)t(r,n),n=n.sibling;return null}function n(e,t){for(e=new Map;null!==t;)null!==t.key?e.set(t.key,t):e.set(t.index,t),t=t.sibling;return e}function a(e,t){return(e=Ou(e,t)).index=0,e.sibling=null,e}function s(t,r,n){return t.index=n,e?null!==(n=t.alternate)?(n=n.index)<r?(t.flags|=2,r):n:(t.flags|=2,r):(t.flags|=1048576,r)}function o(t){return e&&null===t.alternate&&(t.flags|=2),t}function l(e,t,r,n){return null===t||6!==t.tag?((t=Vu(r,e.mode,n)).return=e,t):((t=a(t,r)).return=e,t)}function u(e,t,r,n){var i=r.type;return i===w?h(e,t,r.props.children,n,r.key):null!==t&&(t.elementType===i||"object"==typeof i&&null!==i&&i.$$typeof===I&&Ki(i)===t.type)?((n=a(t,r.props)).ref=Wi(e,t,r),n.return=e,n):((n=Ru(r.type,r.key,r.props,null,e.mode,n)).ref=Wi(e,t,r),n.return=e,n)}function c(e,t,r,n){return null===t||4!==t.tag||t.stateNode.containerInfo!==r.containerInfo||t.stateNode.implementation!==r.implementation?((t=zu(r,e.mode,n)).return=e,t):((t=a(t,r.children||[])).return=e,t)}function h(e,t,r,n,i){return null===t||7!==t.tag?((t=Lu(r,e.mode,n,i)).return=e,t):((t=a(t,r)).return=e,t)}function p(e,t,r){if("string"==typeof t&&""!==t||"number"==typeof t)return(t=Vu(""+t,e.mode,r)).return=e,t;if("object"==typeof t&&null!==t){switch(t.$$typeof){case x:return(r=Ru(t.type,t.key,t.props,null,e.mode,r)).ref=Wi(e,null,t),r.return=e,r;case S:return(t=zu(t,e.mode,r)).return=e,t;case I:return p(e,(0,t._init)(t._payload),r)}if(te(t)||R(t))return(t=Lu(t,e.mode,r,null)).return=e,t;$i(e,t)}return null}function f(e,t,r,n){var a=null!==t?t.key:null;if("string"==typeof r&&""!==r||"number"==typeof r)return null!==a?null:l(e,t,""+r,n);if("object"==typeof r&&null!==r){switch(r.$$typeof){case x:return r.key===a?u(e,t,r,n):null;case S:return r.key===a?c(e,t,r,n):null;case I:return f(e,t,(a=r._init)(r._payload),n)}if(te(r)||R(r))return null!==a?null:h(e,t,r,n,null);$i(e,r)}return null}function d(e,t,r,n,a){if("string"==typeof n&&""!==n||"number"==typeof n)return l(t,e=e.get(r)||null,""+n,a);if("object"==typeof n&&null!==n){switch(n.$$typeof){case x:return u(t,e=e.get(null===n.key?r:n.key)||null,n,a);case S:return c(t,e=e.get(null===n.key?r:n.key)||null,n,a);case I:return d(e,t,r,(0,n._init)(n._payload),a)}if(te(n)||R(n))return h(t,e=e.get(r)||null,n,a,null);$i(t,n)}return null}function m(a,i,o,l){for(var u=null,c=null,h=i,m=i=0,g=null;null!==h&&m<o.length;m++){h.index>m?(g=h,h=null):g=h.sibling;var y=f(a,h,o[m],l);if(null===y){null===h&&(h=g);break}e&&h&&null===y.alternate&&t(a,h),i=s(y,i,m),null===c?u=y:c.sibling=y,c=y,h=g}if(m===o.length)return r(a,h),ai&&Xa(a,m),u;if(null===h){for(;m<o.length;m++)null!==(h=p(a,o[m],l))&&(i=s(h,i,m),null===c?u=h:c.sibling=h,c=h);return ai&&Xa(a,m),u}for(h=n(a,h);m<o.length;m++)null!==(g=d(h,a,m,o[m],l))&&(e&&null!==g.alternate&&h.delete(null===g.key?m:g.key),i=s(g,i,m),null===c?u=g:c.sibling=g,c=g);return e&&h.forEach((function(e){return t(a,e)})),ai&&Xa(a,m),u}function g(a,o,l,u){var c=R(l);if("function"!=typeof c)throw Error(i(150));if(null==(l=c.call(l)))throw Error(i(151));for(var h=c=null,m=o,g=o=0,y=null,v=l.next();null!==m&&!v.done;g++,v=l.next()){m.index>g?(y=m,m=null):y=m.sibling;var b=f(a,m,v.value,u);if(null===b){null===m&&(m=y);break}e&&m&&null===b.alternate&&t(a,m),o=s(b,o,g),null===h?c=b:h.sibling=b,h=b,m=y}if(v.done)return r(a,m),ai&&Xa(a,g),c;if(null===m){for(;!v.done;g++,v=l.next())null!==(v=p(a,v.value,u))&&(o=s(v,o,g),null===h?c=v:h.sibling=v,h=v);return ai&&Xa(a,g),c}for(m=n(a,m);!v.done;g++,v=l.next())null!==(v=d(m,a,g,v.value,u))&&(e&&null!==v.alternate&&m.delete(null===v.key?g:v.key),o=s(v,o,g),null===h?c=v:h.sibling=v,h=v);return e&&m.forEach((function(e){return t(a,e)})),ai&&Xa(a,g),c}return function e(n,i,s,l){if("object"==typeof s&&null!==s&&s.type===w&&null===s.key&&(s=s.props.children),"object"==typeof s&&null!==s){switch(s.$$typeof){case x:e:{for(var u=s.key,c=i;null!==c;){if(c.key===u){if((u=s.type)===w){if(7===c.tag){r(n,c.sibling),(i=a(c,s.props.children)).return=n,n=i;break e}}else if(c.elementType===u||"object"==typeof u&&null!==u&&u.$$typeof===I&&Ki(u)===c.type){r(n,c.sibling),(i=a(c,s.props)).ref=Wi(n,c,s),i.return=n,n=i;break e}r(n,c);break}t(n,c),c=c.sibling}s.type===w?((i=Lu(s.props.children,n.mode,l,s.key)).return=n,n=i):((l=Ru(s.type,s.key,s.props,null,n.mode,l)).ref=Wi(n,i,s),l.return=n,n=l)}return o(n);case S:e:{for(c=s.key;null!==i;){if(i.key===c){if(4===i.tag&&i.stateNode.containerInfo===s.containerInfo&&i.stateNode.implementation===s.implementation){r(n,i.sibling),(i=a(i,s.children||[])).return=n,n=i;break e}r(n,i);break}t(n,i),i=i.sibling}(i=zu(s,n.mode,l)).return=n,n=i}return o(n);case I:return e(n,i,(c=s._init)(s._payload),l)}if(te(s))return m(n,i,s,l);if(R(s))return g(n,i,s,l);$i(n,s)}return"string"==typeof s&&""!==s||"number"==typeof s?(s=""+s,null!==i&&6===i.tag?(r(n,i.sibling),(i=a(i,s)).return=n,n=i):(r(n,i),(i=Vu(s,n.mode,l)).return=n,n=i),o(n)):r(n,i)}}var Yi=Ji(!0),Qi=Ji(!1),Xi={},Zi=Ea(Xi),es=Ea(Xi),ts=Ea(Xi);function rs(e){if(e===Xi)throw Error(i(174));return e}function ns(e,t){switch(Pa(ts,t),Pa(es,e),Pa(Zi,Xi),e=t.nodeType){case 9:case 11:t=(t=t.documentElement)?t.namespaceURI:le(null,"");break;default:t=le(t=(e=8===e?t.parentNode:t).namespaceURI||null,e=e.tagName)}_a(Zi),Pa(Zi,t)}function as(){_a(Zi),_a(es),_a(ts)}function is(e){rs(ts.current);var t=rs(Zi.current),r=le(t,e.type);t!==r&&(Pa(es,e),Pa(Zi,r))}function ss(e){es.current===e&&(_a(Zi),_a(es))}var os=Ea(0);function ls(e){for(var t=e;null!==t;){if(13===t.tag){var r=t.memoizedState;if(null!==r&&(null===(r=r.dehydrated)||"$?"===r.data||"$!"===r.data))return t}else if(19===t.tag&&void 0!==t.memoizedProps.revealOrder){if(0!=(128&t.flags))return t}else if(null!==t.child){t.child.return=t,t=t.child;continue}if(t===e)break;for(;null===t.sibling;){if(null===t.return||t.return===e)return null;t=t.return}t.sibling.return=t.return,t=t.sibling}return null}var us=[];function cs(){for(var e=0;e<us.length;e++)us[e]._workInProgressVersionPrimary=null;us.length=0}var hs=k.ReactCurrentDispatcher,ps=k.ReactCurrentBatchConfig,fs=0,ds=null,ms=null,gs=null,ys=!1,vs=!1,bs=0,ks=0;function xs(){throw Error(i(321))}function Ss(e,t){if(null===t)return!1;for(var r=0;r<t.length&&r<e.length;r++)if(!on(e[r],t[r]))return!1;return!0}function ws(e,t,r,n,a,s){if(fs=s,ds=t,t.memoizedState=null,t.updateQueue=null,t.lanes=0,hs.current=null===e||null===e.memoizedState?so:oo,e=r(n,a),vs){s=0;do{if(vs=!1,bs=0,25<=s)throw Error(i(301));s+=1,gs=ms=null,t.updateQueue=null,hs.current=lo,e=r(n,a)}while(vs)}if(hs.current=io,t=null!==ms&&null!==ms.next,fs=0,gs=ms=ds=null,ys=!1,t)throw Error(i(300));return e}function Es(){var e=0!==bs;return bs=0,e}function _s(){var e={memoizedState:null,baseState:null,baseQueue:null,queue:null,next:null};return null===gs?ds.memoizedState=gs=e:gs=gs.next=e,gs}function Ps(){if(null===ms){var e=ds.alternate;e=null!==e?e.memoizedState:null}else e=ms.next;var t=null===gs?ds.memoizedState:gs.next;if(null!==t)gs=t,ms=e;else{if(null===e)throw Error(i(310));e={memoizedState:(ms=e).memoizedState,baseState:ms.baseState,baseQueue:ms.baseQueue,queue:ms.queue,next:null},null===gs?ds.memoizedState=gs=e:gs=gs.next=e}return gs}function Cs(e,t){return"function"==typeof t?t(e):t}function As(e){var t=Ps(),r=t.queue;if(null===r)throw Error(i(311));r.lastRenderedReducer=e;var n=ms,a=n.baseQueue,s=r.pending;if(null!==s){if(null!==a){var o=a.next;a.next=s.next,s.next=o}n.baseQueue=a=s,r.pending=null}if(null!==a){s=a.next,n=n.baseState;var l=o=null,u=null,c=s;do{var h=c.lane;if((fs&h)===h)null!==u&&(u=u.next={lane:0,action:c.action,hasEagerState:c.hasEagerState,eagerState:c.eagerState,next:null}),n=c.hasEagerState?c.eagerState:e(n,c.action);else{var p={lane:h,action:c.action,hasEagerState:c.hasEagerState,eagerState:c.eagerState,next:null};null===u?(l=u=p,o=n):u=u.next=p,ds.lanes|=h,Nl|=h}c=c.next}while(null!==c&&c!==s);null===u?o=n:u.next=l,on(n,t.memoizedState)||(ko=!0),t.memoizedState=n,t.baseState=o,t.baseQueue=u,r.lastRenderedState=n}if(null!==(e=r.interleaved)){a=e;do{s=a.lane,ds.lanes|=s,Nl|=s,a=a.next}while(a!==e)}else null===a&&(r.lanes=0);return[t.memoizedState,r.dispatch]}function Ts(e){var t=Ps(),r=t.queue;if(null===r)throw Error(i(311));r.lastRenderedReducer=e;var n=r.dispatch,a=r.pending,s=t.memoizedState;if(null!==a){r.pending=null;var o=a=a.next;do{s=e(s,o.action),o=o.next}while(o!==a);on(s,t.memoizedState)||(ko=!0),t.memoizedState=s,null===t.baseQueue&&(t.baseState=s),r.lastRenderedState=s}return[s,n]}function Ms(){}function Ds(e,t){var r=ds,n=Ps(),a=t(),s=!on(n.memoizedState,a);if(s&&(n.memoizedState=a,ko=!0),n=n.queue,Hs(Os.bind(null,r,n,e),[e]),n.getSnapshot!==t||s||null!==gs&&1&gs.memoizedState.tag){if(r.flags|=2048,Vs(9,Fs.bind(null,r,n,a,t),void 0,null),null===Ml)throw Error(i(349));0!=(30&fs)||Is(r,t,a)}return a}function Is(e,t,r){e.flags|=16384,e={getSnapshot:t,value:r},null===(t=ds.updateQueue)?(t={lastEffect:null,stores:null},ds.updateQueue=t,t.stores=[e]):null===(r=t.stores)?t.stores=[e]:r.push(e)}function Fs(e,t,r,n){t.value=r,t.getSnapshot=n,Rs(t)&&Ls(e)}function Os(e,t,r){return r((function(){Rs(t)&&Ls(e)}))}function Rs(e){var t=e.getSnapshot;e=e.value;try{var r=t();return!on(e,r)}catch(e){return!0}}function Ls(e){var t=Ti(e,1);null!==t&&nu(t,e,1,-1)}function Ns(e){var t=_s();return"function"==typeof e&&(e=e()),t.memoizedState=t.baseState=e,e={pending:null,interleaved:null,lanes:0,dispatch:null,lastRenderedReducer:Cs,lastRenderedState:e},t.queue=e,e=e.dispatch=to.bind(null,ds,e),[t.memoizedState,e]}function Vs(e,t,r,n){return e={tag:e,create:t,destroy:r,deps:n,next:null},null===(t=ds.updateQueue)?(t={lastEffect:null,stores:null},ds.updateQueue=t,t.lastEffect=e.next=e):null===(r=t.lastEffect)?t.lastEffect=e.next=e:(n=r.next,r.next=e,e.next=n,t.lastEffect=e),e}function zs(){return Ps().memoizedState}function Bs(e,t,r,n){var a=_s();ds.flags|=e,a.memoizedState=Vs(1|t,r,void 0,void 0===n?null:n)}function js(e,t,r,n){var a=Ps();n=void 0===n?null:n;var i=void 0;if(null!==ms){var s=ms.memoizedState;if(i=s.destroy,null!==n&&Ss(n,s.deps))return void(a.memoizedState=Vs(t,r,i,n))}ds.flags|=e,a.memoizedState=Vs(1|t,r,i,n)}function Gs(e,t){return Bs(8390656,8,e,t)}function Hs(e,t){return js(2048,8,e,t)}function qs(e,t){return js(4,2,e,t)}function Us(e,t){return js(4,4,e,t)}function Ws(e,t){return"function"==typeof t?(e=e(),t(e),function(){t(null)}):null!=t?(e=e(),t.current=e,function(){t.current=null}):void 0}function $s(e,t,r){return r=null!=r?r.concat([e]):null,js(4,4,Ws.bind(null,t,e),r)}function Ks(){}function Js(e,t){var r=Ps();t=void 0===t?null:t;var n=r.memoizedState;return null!==n&&null!==t&&Ss(t,n[1])?n[0]:(r.memoizedState=[e,t],e)}function Ys(e,t){var r=Ps();t=void 0===t?null:t;var n=r.memoizedState;return null!==n&&null!==t&&Ss(t,n[1])?n[0]:(e=e(),r.memoizedState=[e,t],e)}function Qs(e,t,r){return 0==(21&fs)?(e.baseState&&(e.baseState=!1,ko=!0),e.memoizedState=r):(on(r,t)||(r=mt(),ds.lanes|=r,Nl|=r,e.baseState=!0),t)}function Xs(e,t){var r=bt;bt=0!==r&&4>r?r:4,e(!0);var n=ps.transition;ps.transition={};try{e(!1),t()}finally{bt=r,ps.transition=n}}function Zs(){return Ps().memoizedState}function eo(e,t,r){var n=ru(e);if(r={lane:n,action:r,hasEagerState:!1,eagerState:null,next:null},ro(e))no(t,r);else if(null!==(r=Ai(e,t,r,n))){nu(r,e,n,tu()),ao(r,t,n)}}function to(e,t,r){var n=ru(e),a={lane:n,action:r,hasEagerState:!1,eagerState:null,next:null};if(ro(e))no(t,a);else{var i=e.alternate;if(0===e.lanes&&(null===i||0===i.lanes)&&null!==(i=t.lastRenderedReducer))try{var s=t.lastRenderedState,o=i(s,r);if(a.hasEagerState=!0,a.eagerState=o,on(o,s)){var l=t.interleaved;return null===l?(a.next=a,Ci(t)):(a.next=l.next,l.next=a),void(t.interleaved=a)}}catch(e){}null!==(r=Ai(e,t,a,n))&&(nu(r,e,n,a=tu()),ao(r,t,n))}}function ro(e){var t=e.alternate;return e===ds||null!==t&&t===ds}function no(e,t){vs=ys=!0;var r=e.pending;null===r?t.next=t:(t.next=r.next,r.next=t),e.pending=t}function ao(e,t,r){if(0!=(4194240&r)){var n=t.lanes;r|=n&=e.pendingLanes,t.lanes=r,vt(e,r)}}var io={readContext:_i,useCallback:xs,useContext:xs,useEffect:xs,useImperativeHandle:xs,useInsertionEffect:xs,useLayoutEffect:xs,useMemo:xs,useReducer:xs,useRef:xs,useState:xs,useDebugValue:xs,useDeferredValue:xs,useTransition:xs,useMutableSource:xs,useSyncExternalStore:xs,useId:xs,unstable_isNewReconciler:!1},so={readContext:_i,useCallback:function(e,t){return _s().memoizedState=[e,void 0===t?null:t],e},useContext:_i,useEffect:Gs,useImperativeHandle:function(e,t,r){return r=null!=r?r.concat([e]):null,Bs(4194308,4,Ws.bind(null,t,e),r)},useLayoutEffect:function(e,t){return Bs(4194308,4,e,t)},useInsertionEffect:function(e,t){return Bs(4,2,e,t)},useMemo:function(e,t){var r=_s();return t=void 0===t?null:t,e=e(),r.memoizedState=[e,t],e},useReducer:function(e,t,r){var n=_s();return t=void 0!==r?r(t):t,n.memoizedState=n.baseState=t,e={pending:null,interleaved:null,lanes:0,dispatch:null,lastRenderedReducer:e,lastRenderedState:t},n.queue=e,e=e.dispatch=eo.bind(null,ds,e),[n.memoizedState,e]},useRef:function(e){return e={current:e},_s().memoizedState=e},useState:Ns,useDebugValue:Ks,useDeferredValue:function(e){return _s().memoizedState=e},useTransition:function(){var e=Ns(!1),t=e[0];return e=Xs.bind(null,e[1]),_s().memoizedState=e,[t,e]},useMutableSource:function(){},useSyncExternalStore:function(e,t,r){var n=ds,a=_s();if(ai){if(void 0===r)throw Error(i(407));r=r()}else{if(r=t(),null===Ml)throw Error(i(349));0!=(30&fs)||Is(n,t,r)}a.memoizedState=r;var s={value:r,getSnapshot:t};return a.queue=s,Gs(Os.bind(null,n,s,e),[e]),n.flags|=2048,Vs(9,Fs.bind(null,n,s,r,t),void 0,null),r},useId:function(){var e=_s(),t=Ml.identifierPrefix;if(ai){var r=Qa;t=":"+t+"R"+(r=(Ya&~(1<<32-st(Ya)-1)).toString(32)+r),0<(r=bs++)&&(t+="H"+r.toString(32)),t+=":"}else t=":"+t+"r"+(r=ks++).toString(32)+":";return e.memoizedState=t},unstable_isNewReconciler:!1},oo={readContext:_i,useCallback:Js,useContext:_i,useEffect:Hs,useImperativeHandle:$s,useInsertionEffect:qs,useLayoutEffect:Us,useMemo:Ys,useReducer:As,useRef:zs,useState:function(){return As(Cs)},useDebugValue:Ks,useDeferredValue:function(e){return Qs(Ps(),ms.memoizedState,e)},useTransition:function(){return[As(Cs)[0],Ps().memoizedState]},useMutableSource:Ms,useSyncExternalStore:Ds,useId:Zs,unstable_isNewReconciler:!1},lo={readContext:_i,useCallback:Js,useContext:_i,useEffect:Hs,useImperativeHandle:$s,useInsertionEffect:qs,useLayoutEffect:Us,useMemo:Ys,useReducer:Ts,useRef:zs,useState:function(){return Ts(Cs)},useDebugValue:Ks,useDeferredValue:function(e){var t=Ps();return null===ms?t.memoizedState=e:Qs(t,ms.memoizedState,e)},useTransition:function(){return[Ts(Cs)[0],Ps().memoizedState]},useMutableSource:Ms,useSyncExternalStore:Ds,useId:Zs,unstable_isNewReconciler:!1};function uo(e,t){try{var r="",n=t;do{r+=j(n),n=n.return}while(n);var a=r}catch(e){a="\nError generating stack: "+e.message+"\n"+e.stack}return{value:e,source:t,stack:a,digest:null}}function co(e,t,r){return{value:e,source:null,stack:null!=r?r:null,digest:null!=t?t:null}}function ho(e,t){try{console.error(t.value)}catch(e){setTimeout((function(){throw e}))}}var po="function"==typeof WeakMap?WeakMap:Map;function fo(e,t,r){(r=Fi(-1,r)).tag=3,r.payload={element:null};var n=t.value;return r.callback=function(){Ul||(Ul=!0,Wl=n),ho(0,t)},r}function mo(e,t,r){(r=Fi(-1,r)).tag=3;var n=e.type.getDerivedStateFromError;if("function"==typeof n){var a=t.value;r.payload=function(){return n(a)},r.callback=function(){ho(0,t)}}var i=e.stateNode;return null!==i&&"function"==typeof i.componentDidCatch&&(r.callback=function(){ho(0,t),"function"!=typeof n&&(null===$l?$l=new Set([this]):$l.add(this));var e=t.stack;this.componentDidCatch(t.value,{componentStack:null!==e?e:""})}),r}function go(e,t,r){var n=e.pingCache;if(null===n){n=e.pingCache=new po;var a=new Set;n.set(t,a)}else void 0===(a=n.get(t))&&(a=new Set,n.set(t,a));a.has(r)||(a.add(r),e=Pu.bind(null,e,t,r),t.then(e,e))}function yo(e){do{var t;if((t=13===e.tag)&&(t=null===(t=e.memoizedState)||null!==t.dehydrated),t)return e;e=e.return}while(null!==e);return null}function vo(e,t,r,n,a){return 0==(1&e.mode)?(e===t?e.flags|=65536:(e.flags|=128,r.flags|=131072,r.flags&=-52805,1===r.tag&&(null===r.alternate?r.tag=17:((t=Fi(-1,1)).tag=2,Oi(r,t,1))),r.lanes|=1),e):(e.flags|=65536,e.lanes=a,e)}var bo=k.ReactCurrentOwner,ko=!1;function xo(e,t,r,n){t.child=null===e?Qi(t,null,r,n):Yi(t,e.child,r,n)}function So(e,t,r,n,a){r=r.render;var i=t.ref;return Ei(t,a),n=ws(e,t,r,n,i,a),r=Es(),null===e||ko?(ai&&r&&ei(t),t.flags|=1,xo(e,t,n,a),t.child):(t.updateQueue=e.updateQueue,t.flags&=-2053,e.lanes&=~a,Uo(e,t,a))}function wo(e,t,r,n,a){if(null===e){var i=r.type;return"function"!=typeof i||Fu(i)||void 0!==i.defaultProps||null!==r.compare||void 0!==r.defaultProps?((e=Ru(r.type,null,n,t,t.mode,a)).ref=t.ref,e.return=t,t.child=e):(t.tag=15,t.type=i,Eo(e,t,i,n,a))}if(i=e.child,0==(e.lanes&a)){var s=i.memoizedProps;if((r=null!==(r=r.compare)?r:ln)(s,n)&&e.ref===t.ref)return Uo(e,t,a)}return t.flags|=1,(e=Ou(i,n)).ref=t.ref,e.return=t,t.child=e}function Eo(e,t,r,n,a){if(null!==e){var i=e.memoizedProps;if(ln(i,n)&&e.ref===t.ref){if(ko=!1,t.pendingProps=n=i,0==(e.lanes&a))return t.lanes=e.lanes,Uo(e,t,a);0!=(131072&e.flags)&&(ko=!0)}}return Co(e,t,r,n,a)}function _o(e,t,r){var n=t.pendingProps,a=n.children,i=null!==e?e.memoizedState:null;if("hidden"===n.mode)if(0==(1&t.mode))t.memoizedState={baseLanes:0,cachePool:null,transitions:null},Pa(Ol,Fl),Fl|=r;else{if(0==(1073741824&r))return e=null!==i?i.baseLanes|r:r,t.lanes=t.childLanes=1073741824,t.memoizedState={baseLanes:e,cachePool:null,transitions:null},t.updateQueue=null,Pa(Ol,Fl),Fl|=e,null;t.memoizedState={baseLanes:0,cachePool:null,transitions:null},n=null!==i?i.baseLanes:r,Pa(Ol,Fl),Fl|=n}else null!==i?(n=i.baseLanes|r,t.memoizedState=null):n=r,Pa(Ol,Fl),Fl|=n;return xo(e,t,a,r),t.child}function Po(e,t){var r=t.ref;(null===e&&null!==r||null!==e&&e.ref!==r)&&(t.flags|=512,t.flags|=2097152)}function Co(e,t,r,n,a){var i=Ia(r)?Ma:Aa.current;return i=Da(t,i),Ei(t,a),r=ws(e,t,r,n,i,a),n=Es(),null===e||ko?(ai&&n&&ei(t),t.flags|=1,xo(e,t,r,a),t.child):(t.updateQueue=e.updateQueue,t.flags&=-2053,e.lanes&=~a,Uo(e,t,a))}function Ao(e,t,r,n,a){if(Ia(r)){var i=!0;La(t)}else i=!1;if(Ei(t,a),null===t.stateNode)qo(e,t),Hi(t,r,n),Ui(t,r,n,a),n=!0;else if(null===e){var s=t.stateNode,o=t.memoizedProps;s.props=o;var l=s.context,u=r.contextType;"object"==typeof u&&null!==u?u=_i(u):u=Da(t,u=Ia(r)?Ma:Aa.current);var c=r.getDerivedStateFromProps,h="function"==typeof c||"function"==typeof s.getSnapshotBeforeUpdate;h||"function"!=typeof s.UNSAFE_componentWillReceiveProps&&"function"!=typeof s.componentWillReceiveProps||(o!==n||l!==u)&&qi(t,s,n,u),Mi=!1;var p=t.memoizedState;s.state=p,Ni(t,n,s,a),l=t.memoizedState,o!==n||p!==l||Ta.current||Mi?("function"==typeof c&&(Bi(t,r,c,n),l=t.memoizedState),(o=Mi||Gi(t,r,o,n,p,l,u))?(h||"function"!=typeof s.UNSAFE_componentWillMount&&"function"!=typeof s.componentWillMount||("function"==typeof s.componentWillMount&&s.componentWillMount(),"function"==typeof s.UNSAFE_componentWillMount&&s.UNSAFE_componentWillMount()),"function"==typeof s.componentDidMount&&(t.flags|=4194308)):("function"==typeof s.componentDidMount&&(t.flags|=4194308),t.memoizedProps=n,t.memoizedState=l),s.props=n,s.state=l,s.context=u,n=o):("function"==typeof s.componentDidMount&&(t.flags|=4194308),n=!1)}else{s=t.stateNode,Ii(e,t),o=t.memoizedProps,u=t.type===t.elementType?o:gi(t.type,o),s.props=u,h=t.pendingProps,p=s.context,"object"==typeof(l=r.contextType)&&null!==l?l=_i(l):l=Da(t,l=Ia(r)?Ma:Aa.current);var f=r.getDerivedStateFromProps;(c="function"==typeof f||"function"==typeof s.getSnapshotBeforeUpdate)||"function"!=typeof s.UNSAFE_componentWillReceiveProps&&"function"!=typeof s.componentWillReceiveProps||(o!==h||p!==l)&&qi(t,s,n,l),Mi=!1,p=t.memoizedState,s.state=p,Ni(t,n,s,a);var d=t.memoizedState;o!==h||p!==d||Ta.current||Mi?("function"==typeof f&&(Bi(t,r,f,n),d=t.memoizedState),(u=Mi||Gi(t,r,u,n,p,d,l)||!1)?(c||"function"!=typeof s.UNSAFE_componentWillUpdate&&"function"!=typeof s.componentWillUpdate||("function"==typeof s.componentWillUpdate&&s.componentWillUpdate(n,d,l),"function"==typeof s.UNSAFE_componentWillUpdate&&s.UNSAFE_componentWillUpdate(n,d,l)),"function"==typeof s.componentDidUpdate&&(t.flags|=4),"function"==typeof s.getSnapshotBeforeUpdate&&(t.flags|=1024)):("function"!=typeof s.componentDidUpdate||o===e.memoizedProps&&p===e.memoizedState||(t.flags|=4),"function"!=typeof s.getSnapshotBeforeUpdate||o===e.memoizedProps&&p===e.memoizedState||(t.flags|=1024),t.memoizedProps=n,t.memoizedState=d),s.props=n,s.state=d,s.context=l,n=u):("function"!=typeof s.componentDidUpdate||o===e.memoizedProps&&p===e.memoizedState||(t.flags|=4),"function"!=typeof s.getSnapshotBeforeUpdate||o===e.memoizedProps&&p===e.memoizedState||(t.flags|=1024),n=!1)}return To(e,t,r,n,i,a)}function To(e,t,r,n,a,i){Po(e,t);var s=0!=(128&t.flags);if(!n&&!s)return a&&Na(t,r,!1),Uo(e,t,i);n=t.stateNode,bo.current=t;var o=s&&"function"!=typeof r.getDerivedStateFromError?null:n.render();return t.flags|=1,null!==e&&s?(t.child=Yi(t,e.child,null,i),t.child=Yi(t,null,o,i)):xo(e,t,o,i),t.memoizedState=n.state,a&&Na(t,r,!0),t.child}function Mo(e){var t=e.stateNode;t.pendingContext?Oa(0,t.pendingContext,t.pendingContext!==t.context):t.context&&Oa(0,t.context,!1),ns(e,t.containerInfo)}function Do(e,t,r,n,a){return fi(),di(a),t.flags|=256,xo(e,t,r,n),t.child}var Io,Fo,Oo,Ro,Lo={dehydrated:null,treeContext:null,retryLane:0};function No(e){return{baseLanes:e,cachePool:null,transitions:null}}function Vo(e,t,r){var n,a=t.pendingProps,s=os.current,o=!1,l=0!=(128&t.flags);if((n=l)||(n=(null===e||null!==e.memoizedState)&&0!=(2&s)),n?(o=!0,t.flags&=-129):null!==e&&null===e.memoizedState||(s|=1),Pa(os,1&s),null===e)return ui(t),null!==(e=t.memoizedState)&&null!==(e=e.dehydrated)?(0==(1&t.mode)?t.lanes=1:"$!"===e.data?t.lanes=8:t.lanes=1073741824,null):(l=a.children,e=a.fallback,o?(a=t.mode,o=t.child,l={mode:"hidden",children:l},0==(1&a)&&null!==o?(o.childLanes=0,o.pendingProps=l):o=Nu(l,a,0,null),e=Lu(e,a,r,null),o.return=t,e.return=t,o.sibling=e,t.child=o,t.child.memoizedState=No(r),t.memoizedState=Lo,e):zo(t,l));if(null!==(s=e.memoizedState)&&null!==(n=s.dehydrated))return function(e,t,r,n,a,s,o){if(r)return 256&t.flags?(t.flags&=-257,Bo(e,t,o,n=co(Error(i(422))))):null!==t.memoizedState?(t.child=e.child,t.flags|=128,null):(s=n.fallback,a=t.mode,n=Nu({mode:"visible",children:n.children},a,0,null),(s=Lu(s,a,o,null)).flags|=2,n.return=t,s.return=t,n.sibling=s,t.child=n,0!=(1&t.mode)&&Yi(t,e.child,null,o),t.child.memoizedState=No(o),t.memoizedState=Lo,s);if(0==(1&t.mode))return Bo(e,t,o,null);if("$!"===a.data){if(n=a.nextSibling&&a.nextSibling.dataset)var l=n.dgst;return n=l,Bo(e,t,o,n=co(s=Error(i(419)),n,void 0))}if(l=0!=(o&e.childLanes),ko||l){if(null!==(n=Ml)){switch(o&-o){case 4:a=2;break;case 16:a=8;break;case 64:case 128:case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:case 262144:case 524288:case 1048576:case 2097152:case 4194304:case 8388608:case 16777216:case 33554432:case 67108864:a=32;break;case 536870912:a=268435456;break;default:a=0}0!==(a=0!=(a&(n.suspendedLanes|o))?0:a)&&a!==s.retryLane&&(s.retryLane=a,Ti(e,a),nu(n,e,a,-1))}return gu(),Bo(e,t,o,n=co(Error(i(421))))}return"$?"===a.data?(t.flags|=128,t.child=e.child,t=Au.bind(null,e),a._reactRetry=t,null):(e=s.treeContext,ni=ua(a.nextSibling),ri=t,ai=!0,ii=null,null!==e&&($a[Ka++]=Ya,$a[Ka++]=Qa,$a[Ka++]=Ja,Ya=e.id,Qa=e.overflow,Ja=t),t=zo(t,n.children),t.flags|=4096,t)}(e,t,l,a,n,s,r);if(o){o=a.fallback,l=t.mode,n=(s=e.child).sibling;var u={mode:"hidden",children:a.children};return 0==(1&l)&&t.child!==s?((a=t.child).childLanes=0,a.pendingProps=u,t.deletions=null):(a=Ou(s,u)).subtreeFlags=14680064&s.subtreeFlags,null!==n?o=Ou(n,o):(o=Lu(o,l,r,null)).flags|=2,o.return=t,a.return=t,a.sibling=o,t.child=a,a=o,o=t.child,l=null===(l=e.child.memoizedState)?No(r):{baseLanes:l.baseLanes|r,cachePool:null,transitions:l.transitions},o.memoizedState=l,o.childLanes=e.childLanes&~r,t.memoizedState=Lo,a}return e=(o=e.child).sibling,a=Ou(o,{mode:"visible",children:a.children}),0==(1&t.mode)&&(a.lanes=r),a.return=t,a.sibling=null,null!==e&&(null===(r=t.deletions)?(t.deletions=[e],t.flags|=16):r.push(e)),t.child=a,t.memoizedState=null,a}function zo(e,t){return(t=Nu({mode:"visible",children:t},e.mode,0,null)).return=e,e.child=t}function Bo(e,t,r,n){return null!==n&&di(n),Yi(t,e.child,null,r),(e=zo(t,t.pendingProps.children)).flags|=2,t.memoizedState=null,e}function jo(e,t,r){e.lanes|=t;var n=e.alternate;null!==n&&(n.lanes|=t),wi(e.return,t,r)}function Go(e,t,r,n,a){var i=e.memoizedState;null===i?e.memoizedState={isBackwards:t,rendering:null,renderingStartTime:0,last:n,tail:r,tailMode:a}:(i.isBackwards=t,i.rendering=null,i.renderingStartTime=0,i.last=n,i.tail=r,i.tailMode=a)}function Ho(e,t,r){var n=t.pendingProps,a=n.revealOrder,i=n.tail;if(xo(e,t,n.children,r),0!=(2&(n=os.current)))n=1&n|2,t.flags|=128;else{if(null!==e&&0!=(128&e.flags))e:for(e=t.child;null!==e;){if(13===e.tag)null!==e.memoizedState&&jo(e,r,t);else if(19===e.tag)jo(e,r,t);else if(null!==e.child){e.child.return=e,e=e.child;continue}if(e===t)break e;for(;null===e.sibling;){if(null===e.return||e.return===t)break e;e=e.return}e.sibling.return=e.return,e=e.sibling}n&=1}if(Pa(os,n),0==(1&t.mode))t.memoizedState=null;else switch(a){case"forwards":for(r=t.child,a=null;null!==r;)null!==(e=r.alternate)&&null===ls(e)&&(a=r),r=r.sibling;null===(r=a)?(a=t.child,t.child=null):(a=r.sibling,r.sibling=null),Go(t,!1,a,r,i);break;case"backwards":for(r=null,a=t.child,t.child=null;null!==a;){if(null!==(e=a.alternate)&&null===ls(e)){t.child=a;break}e=a.sibling,a.sibling=r,r=a,a=e}Go(t,!0,r,null,i);break;case"together":Go(t,!1,null,null,void 0);break;default:t.memoizedState=null}return t.child}function qo(e,t){0==(1&t.mode)&&null!==e&&(e.alternate=null,t.alternate=null,t.flags|=2)}function Uo(e,t,r){if(null!==e&&(t.dependencies=e.dependencies),Nl|=t.lanes,0==(r&t.childLanes))return null;if(null!==e&&t.child!==e.child)throw Error(i(153));if(null!==t.child){for(r=Ou(e=t.child,e.pendingProps),t.child=r,r.return=t;null!==e.sibling;)e=e.sibling,(r=r.sibling=Ou(e,e.pendingProps)).return=t;r.sibling=null}return t.child}function Wo(e,t){if(!ai)switch(e.tailMode){case"hidden":t=e.tail;for(var r=null;null!==t;)null!==t.alternate&&(r=t),t=t.sibling;null===r?e.tail=null:r.sibling=null;break;case"collapsed":r=e.tail;for(var n=null;null!==r;)null!==r.alternate&&(n=r),r=r.sibling;null===n?t||null===e.tail?e.tail=null:e.tail.sibling=null:n.sibling=null}}function $o(e){var t=null!==e.alternate&&e.alternate.child===e.child,r=0,n=0;if(t)for(var a=e.child;null!==a;)r|=a.lanes|a.childLanes,n|=14680064&a.subtreeFlags,n|=14680064&a.flags,a.return=e,a=a.sibling;else for(a=e.child;null!==a;)r|=a.lanes|a.childLanes,n|=a.subtreeFlags,n|=a.flags,a.return=e,a=a.sibling;return e.subtreeFlags|=n,e.childLanes=r,t}function Ko(e,t,r){var n=t.pendingProps;switch(ti(t),t.tag){case 2:case 16:case 15:case 0:case 11:case 7:case 8:case 12:case 9:case 14:return $o(t),null;case 1:case 17:return Ia(t.type)&&Fa(),$o(t),null;case 3:return n=t.stateNode,as(),_a(Ta),_a(Aa),cs(),n.pendingContext&&(n.context=n.pendingContext,n.pendingContext=null),null!==e&&null!==e.child||(hi(t)?t.flags|=4:null===e||e.memoizedState.isDehydrated&&0==(256&t.flags)||(t.flags|=1024,null!==ii&&(ou(ii),ii=null))),Fo(e,t),$o(t),null;case 5:ss(t);var a=rs(ts.current);if(r=t.type,null!==e&&null!=t.stateNode)Oo(e,t,r,n,a),e.ref!==t.ref&&(t.flags|=512,t.flags|=2097152);else{if(!n){if(null===t.stateNode)throw Error(i(166));return $o(t),null}if(e=rs(Zi.current),hi(t)){n=t.stateNode,r=t.type;var s=t.memoizedProps;switch(n[pa]=t,n[fa]=s,e=0!=(1&t.mode),r){case"dialog":zn("cancel",n),zn("close",n);break;case"iframe":case"object":case"embed":zn("load",n);break;case"video":case"audio":for(a=0;a<Rn.length;a++)zn(Rn[a],n);break;case"source":zn("error",n);break;case"img":case"image":case"link":zn("error",n),zn("load",n);break;case"details":zn("toggle",n);break;case"input":Y(n,s),zn("invalid",n);break;case"select":n._wrapperState={wasMultiple:!!s.multiple},zn("invalid",n);break;case"textarea":ae(n,s),zn("invalid",n)}for(var l in ve(r,s),a=null,s)if(s.hasOwnProperty(l)){var u=s[l];"children"===l?"string"==typeof u?n.textContent!==u&&(!0!==s.suppressHydrationWarning&&Xn(n.textContent,u,e),a=["children",u]):"number"==typeof u&&n.textContent!==""+u&&(!0!==s.suppressHydrationWarning&&Xn(n.textContent,u,e),a=["children",""+u]):o.hasOwnProperty(l)&&null!=u&&"onScroll"===l&&zn("scroll",n)}switch(r){case"input":W(n),Z(n,s,!0);break;case"textarea":W(n),se(n);break;case"select":case"option":break;default:"function"==typeof s.onClick&&(n.onclick=Zn)}n=a,t.updateQueue=n,null!==n&&(t.flags|=4)}else{l=9===a.nodeType?a:a.ownerDocument,"http://www.w3.org/1999/xhtml"===e&&(e=oe(r)),"http://www.w3.org/1999/xhtml"===e?"script"===r?((e=l.createElement("div")).innerHTML="<script><\/script>",e=e.removeChild(e.firstChild)):"string"==typeof n.is?e=l.createElement(r,{is:n.is}):(e=l.createElement(r),"select"===r&&(l=e,n.multiple?l.multiple=!0:n.size&&(l.size=n.size))):e=l.createElementNS(e,r),e[pa]=t,e[fa]=n,Io(e,t,!1,!1),t.stateNode=e;e:{switch(l=be(r,n),r){case"dialog":zn("cancel",e),zn("close",e),a=n;break;case"iframe":case"object":case"embed":zn("load",e),a=n;break;case"video":case"audio":for(a=0;a<Rn.length;a++)zn(Rn[a],e);a=n;break;case"source":zn("error",e),a=n;break;case"img":case"image":case"link":zn("error",e),zn("load",e),a=n;break;case"details":zn("toggle",e),a=n;break;case"input":Y(e,n),a=J(e,n),zn("invalid",e);break;case"option":default:a=n;break;case"select":e._wrapperState={wasMultiple:!!n.multiple},a=N({},n,{value:void 0}),zn("invalid",e);break;case"textarea":ae(e,n),a=ne(e,n),zn("invalid",e)}for(s in ve(r,a),u=a)if(u.hasOwnProperty(s)){var c=u[s];"style"===s?ge(e,c):"dangerouslySetInnerHTML"===s?null!=(c=c?c.__html:void 0)&&he(e,c):"children"===s?"string"==typeof c?("textarea"!==r||""!==c)&&pe(e,c):"number"==typeof c&&pe(e,""+c):"suppressContentEditableWarning"!==s&&"suppressHydrationWarning"!==s&&"autoFocus"!==s&&(o.hasOwnProperty(s)?null!=c&&"onScroll"===s&&zn("scroll",e):null!=c&&b(e,s,c,l))}switch(r){case"input":W(e),Z(e,n,!1);break;case"textarea":W(e),se(e);break;case"option":null!=n.value&&e.setAttribute("value",""+q(n.value));break;case"select":e.multiple=!!n.multiple,null!=(s=n.value)?re(e,!!n.multiple,s,!1):null!=n.defaultValue&&re(e,!!n.multiple,n.defaultValue,!0);break;default:"function"==typeof a.onClick&&(e.onclick=Zn)}switch(r){case"button":case"input":case"select":case"textarea":n=!!n.autoFocus;break e;case"img":n=!0;break e;default:n=!1}}n&&(t.flags|=4)}null!==t.ref&&(t.flags|=512,t.flags|=2097152)}return $o(t),null;case 6:if(e&&null!=t.stateNode)Ro(e,t,e.memoizedProps,n);else{if("string"!=typeof n&&null===t.stateNode)throw Error(i(166));if(r=rs(ts.current),rs(Zi.current),hi(t)){if(n=t.stateNode,r=t.memoizedProps,n[pa]=t,(s=n.nodeValue!==r)&&null!==(e=ri))switch(e.tag){case 3:Xn(n.nodeValue,r,0!=(1&e.mode));break;case 5:!0!==e.memoizedProps.suppressHydrationWarning&&Xn(n.nodeValue,r,0!=(1&e.mode))}s&&(t.flags|=4)}else(n=(9===r.nodeType?r:r.ownerDocument).createTextNode(n))[pa]=t,t.stateNode=n}return $o(t),null;case 13:if(_a(os),n=t.memoizedState,null===e||null!==e.memoizedState&&null!==e.memoizedState.dehydrated){if(ai&&null!==ni&&0!=(1&t.mode)&&0==(128&t.flags))pi(),fi(),t.flags|=98560,s=!1;else if(s=hi(t),null!==n&&null!==n.dehydrated){if(null===e){if(!s)throw Error(i(318));if(!(s=null!==(s=t.memoizedState)?s.dehydrated:null))throw Error(i(317));s[pa]=t}else fi(),0==(128&t.flags)&&(t.memoizedState=null),t.flags|=4;$o(t),s=!1}else null!==ii&&(ou(ii),ii=null),s=!0;if(!s)return 65536&t.flags?t:null}return 0!=(128&t.flags)?(t.lanes=r,t):((n=null!==n)!==(null!==e&&null!==e.memoizedState)&&n&&(t.child.flags|=8192,0!=(1&t.mode)&&(null===e||0!=(1&os.current)?0===Rl&&(Rl=3):gu())),null!==t.updateQueue&&(t.flags|=4),$o(t),null);case 4:return as(),Fo(e,t),null===e&&Gn(t.stateNode.containerInfo),$o(t),null;case 10:return Si(t.type._context),$o(t),null;case 19:if(_a(os),null===(s=t.memoizedState))return $o(t),null;if(n=0!=(128&t.flags),null===(l=s.rendering))if(n)Wo(s,!1);else{if(0!==Rl||null!==e&&0!=(128&e.flags))for(e=t.child;null!==e;){if(null!==(l=ls(e))){for(t.flags|=128,Wo(s,!1),null!==(n=l.updateQueue)&&(t.updateQueue=n,t.flags|=4),t.subtreeFlags=0,n=r,r=t.child;null!==r;)e=n,(s=r).flags&=14680066,null===(l=s.alternate)?(s.childLanes=0,s.lanes=e,s.child=null,s.subtreeFlags=0,s.memoizedProps=null,s.memoizedState=null,s.updateQueue=null,s.dependencies=null,s.stateNode=null):(s.childLanes=l.childLanes,s.lanes=l.lanes,s.child=l.child,s.subtreeFlags=0,s.deletions=null,s.memoizedProps=l.memoizedProps,s.memoizedState=l.memoizedState,s.updateQueue=l.updateQueue,s.type=l.type,e=l.dependencies,s.dependencies=null===e?null:{lanes:e.lanes,firstContext:e.firstContext}),r=r.sibling;return Pa(os,1&os.current|2),t.child}e=e.sibling}null!==s.tail&&Qe()>Hl&&(t.flags|=128,n=!0,Wo(s,!1),t.lanes=4194304)}else{if(!n)if(null!==(e=ls(l))){if(t.flags|=128,n=!0,null!==(r=e.updateQueue)&&(t.updateQueue=r,t.flags|=4),Wo(s,!0),null===s.tail&&"hidden"===s.tailMode&&!l.alternate&&!ai)return $o(t),null}else 2*Qe()-s.renderingStartTime>Hl&&1073741824!==r&&(t.flags|=128,n=!0,Wo(s,!1),t.lanes=4194304);s.isBackwards?(l.sibling=t.child,t.child=l):(null!==(r=s.last)?r.sibling=l:t.child=l,s.last=l)}return null!==s.tail?(t=s.tail,s.rendering=t,s.tail=t.sibling,s.renderingStartTime=Qe(),t.sibling=null,r=os.current,Pa(os,n?1&r|2:1&r),t):($o(t),null);case 22:case 23:return pu(),n=null!==t.memoizedState,null!==e&&null!==e.memoizedState!==n&&(t.flags|=8192),n&&0!=(1&t.mode)?0!=(1073741824&Fl)&&($o(t),6&t.subtreeFlags&&(t.flags|=8192)):$o(t),null;case 24:case 25:return null}throw Error(i(156,t.tag))}function Jo(e,t){switch(ti(t),t.tag){case 1:return Ia(t.type)&&Fa(),65536&(e=t.flags)?(t.flags=-65537&e|128,t):null;case 3:return as(),_a(Ta),_a(Aa),cs(),0!=(65536&(e=t.flags))&&0==(128&e)?(t.flags=-65537&e|128,t):null;case 5:return ss(t),null;case 13:if(_a(os),null!==(e=t.memoizedState)&&null!==e.dehydrated){if(null===t.alternate)throw Error(i(340));fi()}return 65536&(e=t.flags)?(t.flags=-65537&e|128,t):null;case 19:return _a(os),null;case 4:return as(),null;case 10:return Si(t.type._context),null;case 22:case 23:return pu(),null;default:return null}}Io=function(e,t){for(var r=t.child;null!==r;){if(5===r.tag||6===r.tag)e.appendChild(r.stateNode);else if(4!==r.tag&&null!==r.child){r.child.return=r,r=r.child;continue}if(r===t)break;for(;null===r.sibling;){if(null===r.return||r.return===t)return;r=r.return}r.sibling.return=r.return,r=r.sibling}},Fo=function(){},Oo=function(e,t,r,n){var a=e.memoizedProps;if(a!==n){e=t.stateNode,rs(Zi.current);var i,s=null;switch(r){case"input":a=J(e,a),n=J(e,n),s=[];break;case"select":a=N({},a,{value:void 0}),n=N({},n,{value:void 0}),s=[];break;case"textarea":a=ne(e,a),n=ne(e,n),s=[];break;default:"function"!=typeof a.onClick&&"function"==typeof n.onClick&&(e.onclick=Zn)}for(c in ve(r,n),r=null,a)if(!n.hasOwnProperty(c)&&a.hasOwnProperty(c)&&null!=a[c])if("style"===c){var l=a[c];for(i in l)l.hasOwnProperty(i)&&(r||(r={}),r[i]="")}else"dangerouslySetInnerHTML"!==c&&"children"!==c&&"suppressContentEditableWarning"!==c&&"suppressHydrationWarning"!==c&&"autoFocus"!==c&&(o.hasOwnProperty(c)?s||(s=[]):(s=s||[]).push(c,null));for(c in n){var u=n[c];if(l=null!=a?a[c]:void 0,n.hasOwnProperty(c)&&u!==l&&(null!=u||null!=l))if("style"===c)if(l){for(i in l)!l.hasOwnProperty(i)||u&&u.hasOwnProperty(i)||(r||(r={}),r[i]="");for(i in u)u.hasOwnProperty(i)&&l[i]!==u[i]&&(r||(r={}),r[i]=u[i])}else r||(s||(s=[]),s.push(c,r)),r=u;else"dangerouslySetInnerHTML"===c?(u=u?u.__html:void 0,l=l?l.__html:void 0,null!=u&&l!==u&&(s=s||[]).push(c,u)):"children"===c?"string"!=typeof u&&"number"!=typeof u||(s=s||[]).push(c,""+u):"suppressContentEditableWarning"!==c&&"suppressHydrationWarning"!==c&&(o.hasOwnProperty(c)?(null!=u&&"onScroll"===c&&zn("scroll",e),s||l===u||(s=[])):(s=s||[]).push(c,u))}r&&(s=s||[]).push("style",r);var c=s;(t.updateQueue=c)&&(t.flags|=4)}},Ro=function(e,t,r,n){r!==n&&(t.flags|=4)};var Yo=!1,Qo=!1,Xo="function"==typeof WeakSet?WeakSet:Set,Zo=null;function el(e,t){var r=e.ref;if(null!==r)if("function"==typeof r)try{r(null)}catch(r){_u(e,t,r)}else r.current=null}function tl(e,t,r){try{r()}catch(r){_u(e,t,r)}}var rl=!1;function nl(e,t,r){var n=t.updateQueue;if(null!==(n=null!==n?n.lastEffect:null)){var a=n=n.next;do{if((a.tag&e)===e){var i=a.destroy;a.destroy=void 0,void 0!==i&&tl(t,r,i)}a=a.next}while(a!==n)}}function al(e,t){if(null!==(t=null!==(t=t.updateQueue)?t.lastEffect:null)){var r=t=t.next;do{if((r.tag&e)===e){var n=r.create;r.destroy=n()}r=r.next}while(r!==t)}}function il(e){var t=e.ref;if(null!==t){var r=e.stateNode;e.tag,e=r,"function"==typeof t?t(e):t.current=e}}function sl(e){var t=e.alternate;null!==t&&(e.alternate=null,sl(t)),e.child=null,e.deletions=null,e.sibling=null,5===e.tag&&(null!==(t=e.stateNode)&&(delete t[pa],delete t[fa],delete t[ma],delete t[ga],delete t[ya])),e.stateNode=null,e.return=null,e.dependencies=null,e.memoizedProps=null,e.memoizedState=null,e.pendingProps=null,e.stateNode=null,e.updateQueue=null}function ol(e){return 5===e.tag||3===e.tag||4===e.tag}function ll(e){e:for(;;){for(;null===e.sibling;){if(null===e.return||ol(e.return))return null;e=e.return}for(e.sibling.return=e.return,e=e.sibling;5!==e.tag&&6!==e.tag&&18!==e.tag;){if(2&e.flags)continue e;if(null===e.child||4===e.tag)continue e;e.child.return=e,e=e.child}if(!(2&e.flags))return e.stateNode}}function ul(e,t,r){var n=e.tag;if(5===n||6===n)e=e.stateNode,t?8===r.nodeType?r.parentNode.insertBefore(e,t):r.insertBefore(e,t):(8===r.nodeType?(t=r.parentNode).insertBefore(e,r):(t=r).appendChild(e),null!=(r=r._reactRootContainer)||null!==t.onclick||(t.onclick=Zn));else if(4!==n&&null!==(e=e.child))for(ul(e,t,r),e=e.sibling;null!==e;)ul(e,t,r),e=e.sibling}function cl(e,t,r){var n=e.tag;if(5===n||6===n)e=e.stateNode,t?r.insertBefore(e,t):r.appendChild(e);else if(4!==n&&null!==(e=e.child))for(cl(e,t,r),e=e.sibling;null!==e;)cl(e,t,r),e=e.sibling}var hl=null,pl=!1;function fl(e,t,r){for(r=r.child;null!==r;)dl(e,t,r),r=r.sibling}function dl(e,t,r){if(it&&"function"==typeof it.onCommitFiberUnmount)try{it.onCommitFiberUnmount(at,r)}catch(e){}switch(r.tag){case 5:Qo||el(r,t);case 6:var n=hl,a=pl;hl=null,fl(e,t,r),pl=a,null!==(hl=n)&&(pl?(e=hl,r=r.stateNode,8===e.nodeType?e.parentNode.removeChild(r):e.removeChild(r)):hl.removeChild(r.stateNode));break;case 18:null!==hl&&(pl?(e=hl,r=r.stateNode,8===e.nodeType?la(e.parentNode,r):1===e.nodeType&&la(e,r),Gt(e)):la(hl,r.stateNode));break;case 4:n=hl,a=pl,hl=r.stateNode.containerInfo,pl=!0,fl(e,t,r),hl=n,pl=a;break;case 0:case 11:case 14:case 15:if(!Qo&&(null!==(n=r.updateQueue)&&null!==(n=n.lastEffect))){a=n=n.next;do{var i=a,s=i.destroy;i=i.tag,void 0!==s&&(0!=(2&i)||0!=(4&i))&&tl(r,t,s),a=a.next}while(a!==n)}fl(e,t,r);break;case 1:if(!Qo&&(el(r,t),"function"==typeof(n=r.stateNode).componentWillUnmount))try{n.props=r.memoizedProps,n.state=r.memoizedState,n.componentWillUnmount()}catch(e){_u(r,t,e)}fl(e,t,r);break;case 21:fl(e,t,r);break;case 22:1&r.mode?(Qo=(n=Qo)||null!==r.memoizedState,fl(e,t,r),Qo=n):fl(e,t,r);break;default:fl(e,t,r)}}function ml(e){var t=e.updateQueue;if(null!==t){e.updateQueue=null;var r=e.stateNode;null===r&&(r=e.stateNode=new Xo),t.forEach((function(t){var n=Tu.bind(null,e,t);r.has(t)||(r.add(t),t.then(n,n))}))}}function gl(e,t){var r=t.deletions;if(null!==r)for(var n=0;n<r.length;n++){var a=r[n];try{var s=e,o=t,l=o;e:for(;null!==l;){switch(l.tag){case 5:hl=l.stateNode,pl=!1;break e;case 3:case 4:hl=l.stateNode.containerInfo,pl=!0;break e}l=l.return}if(null===hl)throw Error(i(160));dl(s,o,a),hl=null,pl=!1;var u=a.alternate;null!==u&&(u.return=null),a.return=null}catch(e){_u(a,t,e)}}if(12854&t.subtreeFlags)for(t=t.child;null!==t;)yl(t,e),t=t.sibling}function yl(e,t){var r=e.alternate,n=e.flags;switch(e.tag){case 0:case 11:case 14:case 15:if(gl(t,e),vl(e),4&n){try{nl(3,e,e.return),al(3,e)}catch(t){_u(e,e.return,t)}try{nl(5,e,e.return)}catch(t){_u(e,e.return,t)}}break;case 1:gl(t,e),vl(e),512&n&&null!==r&&el(r,r.return);break;case 5:if(gl(t,e),vl(e),512&n&&null!==r&&el(r,r.return),32&e.flags){var a=e.stateNode;try{pe(a,"")}catch(t){_u(e,e.return,t)}}if(4&n&&null!=(a=e.stateNode)){var s=e.memoizedProps,o=null!==r?r.memoizedProps:s,l=e.type,u=e.updateQueue;if(e.updateQueue=null,null!==u)try{"input"===l&&"radio"===s.type&&null!=s.name&&Q(a,s),be(l,o);var c=be(l,s);for(o=0;o<u.length;o+=2){var h=u[o],p=u[o+1];"style"===h?ge(a,p):"dangerouslySetInnerHTML"===h?he(a,p):"children"===h?pe(a,p):b(a,h,p,c)}switch(l){case"input":X(a,s);break;case"textarea":ie(a,s);break;case"select":var f=a._wrapperState.wasMultiple;a._wrapperState.wasMultiple=!!s.multiple;var d=s.value;null!=d?re(a,!!s.multiple,d,!1):f!==!!s.multiple&&(null!=s.defaultValue?re(a,!!s.multiple,s.defaultValue,!0):re(a,!!s.multiple,s.multiple?[]:"",!1))}a[fa]=s}catch(t){_u(e,e.return,t)}}break;case 6:if(gl(t,e),vl(e),4&n){if(null===e.stateNode)throw Error(i(162));a=e.stateNode,s=e.memoizedProps;try{a.nodeValue=s}catch(t){_u(e,e.return,t)}}break;case 3:if(gl(t,e),vl(e),4&n&&null!==r&&r.memoizedState.isDehydrated)try{Gt(t.containerInfo)}catch(t){_u(e,e.return,t)}break;case 4:default:gl(t,e),vl(e);break;case 13:gl(t,e),vl(e),8192&(a=e.child).flags&&(s=null!==a.memoizedState,a.stateNode.isHidden=s,!s||null!==a.alternate&&null!==a.alternate.memoizedState||(Gl=Qe())),4&n&&ml(e);break;case 22:if(h=null!==r&&null!==r.memoizedState,1&e.mode?(Qo=(c=Qo)||h,gl(t,e),Qo=c):gl(t,e),vl(e),8192&n){if(c=null!==e.memoizedState,(e.stateNode.isHidden=c)&&!h&&0!=(1&e.mode))for(Zo=e,h=e.child;null!==h;){for(p=Zo=h;null!==Zo;){switch(d=(f=Zo).child,f.tag){case 0:case 11:case 14:case 15:nl(4,f,f.return);break;case 1:el(f,f.return);var m=f.stateNode;if("function"==typeof m.componentWillUnmount){n=f,r=f.return;try{t=n,m.props=t.memoizedProps,m.state=t.memoizedState,m.componentWillUnmount()}catch(e){_u(n,r,e)}}break;case 5:el(f,f.return);break;case 22:if(null!==f.memoizedState){Sl(p);continue}}null!==d?(d.return=f,Zo=d):Sl(p)}h=h.sibling}e:for(h=null,p=e;;){if(5===p.tag){if(null===h){h=p;try{a=p.stateNode,c?"function"==typeof(s=a.style).setProperty?s.setProperty("display","none","important"):s.display="none":(l=p.stateNode,o=null!=(u=p.memoizedProps.style)&&u.hasOwnProperty("display")?u.display:null,l.style.display=me("display",o))}catch(t){_u(e,e.return,t)}}}else if(6===p.tag){if(null===h)try{p.stateNode.nodeValue=c?"":p.memoizedProps}catch(t){_u(e,e.return,t)}}else if((22!==p.tag&&23!==p.tag||null===p.memoizedState||p===e)&&null!==p.child){p.child.return=p,p=p.child;continue}if(p===e)break e;for(;null===p.sibling;){if(null===p.return||p.return===e)break e;h===p&&(h=null),p=p.return}h===p&&(h=null),p.sibling.return=p.return,p=p.sibling}}break;case 19:gl(t,e),vl(e),4&n&&ml(e);case 21:}}function vl(e){var t=e.flags;if(2&t){try{e:{for(var r=e.return;null!==r;){if(ol(r)){var n=r;break e}r=r.return}throw Error(i(160))}switch(n.tag){case 5:var a=n.stateNode;32&n.flags&&(pe(a,""),n.flags&=-33),cl(e,ll(e),a);break;case 3:case 4:var s=n.stateNode.containerInfo;ul(e,ll(e),s);break;default:throw Error(i(161))}}catch(t){_u(e,e.return,t)}e.flags&=-3}4096&t&&(e.flags&=-4097)}function bl(e,t,r){Zo=e,kl(e,t,r)}function kl(e,t,r){for(var n=0!=(1&e.mode);null!==Zo;){var a=Zo,i=a.child;if(22===a.tag&&n){var s=null!==a.memoizedState||Yo;if(!s){var o=a.alternate,l=null!==o&&null!==o.memoizedState||Qo;o=Yo;var u=Qo;if(Yo=s,(Qo=l)&&!u)for(Zo=a;null!==Zo;)l=(s=Zo).child,22===s.tag&&null!==s.memoizedState?wl(a):null!==l?(l.return=s,Zo=l):wl(a);for(;null!==i;)Zo=i,kl(i,t,r),i=i.sibling;Zo=a,Yo=o,Qo=u}xl(e)}else 0!=(8772&a.subtreeFlags)&&null!==i?(i.return=a,Zo=i):xl(e)}}function xl(e){for(;null!==Zo;){var t=Zo;if(0!=(8772&t.flags)){var r=t.alternate;try{if(0!=(8772&t.flags))switch(t.tag){case 0:case 11:case 15:Qo||al(5,t);break;case 1:var n=t.stateNode;if(4&t.flags&&!Qo)if(null===r)n.componentDidMount();else{var a=t.elementType===t.type?r.memoizedProps:gi(t.type,r.memoizedProps);n.componentDidUpdate(a,r.memoizedState,n.__reactInternalSnapshotBeforeUpdate)}var s=t.updateQueue;null!==s&&Vi(t,s,n);break;case 3:var o=t.updateQueue;if(null!==o){if(r=null,null!==t.child)switch(t.child.tag){case 5:case 1:r=t.child.stateNode}Vi(t,o,r)}break;case 5:var l=t.stateNode;if(null===r&&4&t.flags){r=l;var u=t.memoizedProps;switch(t.type){case"button":case"input":case"select":case"textarea":u.autoFocus&&r.focus();break;case"img":u.src&&(r.src=u.src)}}break;case 6:case 4:case 12:case 19:case 17:case 21:case 22:case 23:case 25:break;case 13:if(null===t.memoizedState){var c=t.alternate;if(null!==c){var h=c.memoizedState;if(null!==h){var p=h.dehydrated;null!==p&&Gt(p)}}}break;default:throw Error(i(163))}Qo||512&t.flags&&il(t)}catch(e){_u(t,t.return,e)}}if(t===e){Zo=null;break}if(null!==(r=t.sibling)){r.return=t.return,Zo=r;break}Zo=t.return}}function Sl(e){for(;null!==Zo;){var t=Zo;if(t===e){Zo=null;break}var r=t.sibling;if(null!==r){r.return=t.return,Zo=r;break}Zo=t.return}}function wl(e){for(;null!==Zo;){var t=Zo;try{switch(t.tag){case 0:case 11:case 15:var r=t.return;try{al(4,t)}catch(e){_u(t,r,e)}break;case 1:var n=t.stateNode;if("function"==typeof n.componentDidMount){var a=t.return;try{n.componentDidMount()}catch(e){_u(t,a,e)}}var i=t.return;try{il(t)}catch(e){_u(t,i,e)}break;case 5:var s=t.return;try{il(t)}catch(e){_u(t,s,e)}}}catch(e){_u(t,t.return,e)}if(t===e){Zo=null;break}var o=t.sibling;if(null!==o){o.return=t.return,Zo=o;break}Zo=t.return}}var El,_l=Math.ceil,Pl=k.ReactCurrentDispatcher,Cl=k.ReactCurrentOwner,Al=k.ReactCurrentBatchConfig,Tl=0,Ml=null,Dl=null,Il=0,Fl=0,Ol=Ea(0),Rl=0,Ll=null,Nl=0,Vl=0,zl=0,Bl=null,jl=null,Gl=0,Hl=1/0,ql=null,Ul=!1,Wl=null,$l=null,Kl=!1,Jl=null,Yl=0,Ql=0,Xl=null,Zl=-1,eu=0;function tu(){return 0!=(6&Tl)?Qe():-1!==Zl?Zl:Zl=Qe()}function ru(e){return 0==(1&e.mode)?1:0!=(2&Tl)&&0!==Il?Il&-Il:null!==mi.transition?(0===eu&&(eu=mt()),eu):0!==(e=bt)?e:e=void 0===(e=window.event)?16:Yt(e.type)}function nu(e,t,r,n){if(50<Ql)throw Ql=0,Xl=null,Error(i(185));yt(e,r,n),0!=(2&Tl)&&e===Ml||(e===Ml&&(0==(2&Tl)&&(Vl|=r),4===Rl&&lu(e,Il)),au(e,n),1===r&&0===Tl&&0==(1&t.mode)&&(Hl=Qe()+500,za&&Ga()))}function au(e,t){var r=e.callbackNode;!function(e,t){for(var r=e.suspendedLanes,n=e.pingedLanes,a=e.expirationTimes,i=e.pendingLanes;0<i;){var s=31-st(i),o=1<<s,l=a[s];-1===l?0!=(o&r)&&0==(o&n)||(a[s]=ft(o,t)):l<=t&&(e.expiredLanes|=o),i&=~o}}(e,t);var n=pt(e,e===Ml?Il:0);if(0===n)null!==r&&Ke(r),e.callbackNode=null,e.callbackPriority=0;else if(t=n&-n,e.callbackPriority!==t){if(null!=r&&Ke(r),1===t)0===e.tag?function(e){za=!0,ja(e)}(uu.bind(null,e)):ja(uu.bind(null,e)),sa((function(){0==(6&Tl)&&Ga()})),r=null;else{switch(kt(n)){case 1:r=Ze;break;case 4:r=et;break;case 16:default:r=tt;break;case 536870912:r=nt}r=Mu(r,iu.bind(null,e))}e.callbackPriority=t,e.callbackNode=r}}function iu(e,t){if(Zl=-1,eu=0,0!=(6&Tl))throw Error(i(327));var r=e.callbackNode;if(wu()&&e.callbackNode!==r)return null;var n=pt(e,e===Ml?Il:0);if(0===n)return null;if(0!=(30&n)||0!=(n&e.expiredLanes)||t)t=yu(e,n);else{t=n;var a=Tl;Tl|=2;var s=mu();for(Ml===e&&Il===t||(ql=null,Hl=Qe()+500,fu(e,t));;)try{bu();break}catch(t){du(e,t)}xi(),Pl.current=s,Tl=a,null!==Dl?t=0:(Ml=null,Il=0,t=Rl)}if(0!==t){if(2===t&&(0!==(a=dt(e))&&(n=a,t=su(e,a))),1===t)throw r=Ll,fu(e,0),lu(e,n),au(e,Qe()),r;if(6===t)lu(e,n);else{if(a=e.current.alternate,0==(30&n)&&!function(e){for(var t=e;;){if(16384&t.flags){var r=t.updateQueue;if(null!==r&&null!==(r=r.stores))for(var n=0;n<r.length;n++){var a=r[n],i=a.getSnapshot;a=a.value;try{if(!on(i(),a))return!1}catch(e){return!1}}}if(r=t.child,16384&t.subtreeFlags&&null!==r)r.return=t,t=r;else{if(t===e)break;for(;null===t.sibling;){if(null===t.return||t.return===e)return!0;t=t.return}t.sibling.return=t.return,t=t.sibling}}return!0}(a)&&(2===(t=yu(e,n))&&(0!==(s=dt(e))&&(n=s,t=su(e,s))),1===t))throw r=Ll,fu(e,0),lu(e,n),au(e,Qe()),r;switch(e.finishedWork=a,e.finishedLanes=n,t){case 0:case 1:throw Error(i(345));case 2:case 5:Su(e,jl,ql);break;case 3:if(lu(e,n),(130023424&n)===n&&10<(t=Gl+500-Qe())){if(0!==pt(e,0))break;if(((a=e.suspendedLanes)&n)!==n){tu(),e.pingedLanes|=e.suspendedLanes&a;break}e.timeoutHandle=na(Su.bind(null,e,jl,ql),t);break}Su(e,jl,ql);break;case 4:if(lu(e,n),(4194240&n)===n)break;for(t=e.eventTimes,a=-1;0<n;){var o=31-st(n);s=1<<o,(o=t[o])>a&&(a=o),n&=~s}if(n=a,10<(n=(120>(n=Qe()-n)?120:480>n?480:1080>n?1080:1920>n?1920:3e3>n?3e3:4320>n?4320:1960*_l(n/1960))-n)){e.timeoutHandle=na(Su.bind(null,e,jl,ql),n);break}Su(e,jl,ql);break;default:throw Error(i(329))}}}return au(e,Qe()),e.callbackNode===r?iu.bind(null,e):null}function su(e,t){var r=Bl;return e.current.memoizedState.isDehydrated&&(fu(e,t).flags|=256),2!==(e=yu(e,t))&&(t=jl,jl=r,null!==t&&ou(t)),e}function ou(e){null===jl?jl=e:jl.push.apply(jl,e)}function lu(e,t){for(t&=~zl,t&=~Vl,e.suspendedLanes|=t,e.pingedLanes&=~t,e=e.expirationTimes;0<t;){var r=31-st(t),n=1<<r;e[r]=-1,t&=~n}}function uu(e){if(0!=(6&Tl))throw Error(i(327));wu();var t=pt(e,0);if(0==(1&t))return au(e,Qe()),null;var r=yu(e,t);if(0!==e.tag&&2===r){var n=dt(e);0!==n&&(t=n,r=su(e,n))}if(1===r)throw r=Ll,fu(e,0),lu(e,t),au(e,Qe()),r;if(6===r)throw Error(i(345));return e.finishedWork=e.current.alternate,e.finishedLanes=t,Su(e,jl,ql),au(e,Qe()),null}function cu(e,t){var r=Tl;Tl|=1;try{return e(t)}finally{0===(Tl=r)&&(Hl=Qe()+500,za&&Ga())}}function hu(e){null!==Jl&&0===Jl.tag&&0==(6&Tl)&&wu();var t=Tl;Tl|=1;var r=Al.transition,n=bt;try{if(Al.transition=null,bt=1,e)return e()}finally{bt=n,Al.transition=r,0==(6&(Tl=t))&&Ga()}}function pu(){Fl=Ol.current,_a(Ol)}function fu(e,t){e.finishedWork=null,e.finishedLanes=0;var r=e.timeoutHandle;if(-1!==r&&(e.timeoutHandle=-1,aa(r)),null!==Dl)for(r=Dl.return;null!==r;){var n=r;switch(ti(n),n.tag){case 1:null!=(n=n.type.childContextTypes)&&Fa();break;case 3:as(),_a(Ta),_a(Aa),cs();break;case 5:ss(n);break;case 4:as();break;case 13:case 19:_a(os);break;case 10:Si(n.type._context);break;case 22:case 23:pu()}r=r.return}if(Ml=e,Dl=e=Ou(e.current,null),Il=Fl=t,Rl=0,Ll=null,zl=Vl=Nl=0,jl=Bl=null,null!==Pi){for(t=0;t<Pi.length;t++)if(null!==(n=(r=Pi[t]).interleaved)){r.interleaved=null;var a=n.next,i=r.pending;if(null!==i){var s=i.next;i.next=a,n.next=s}r.pending=n}Pi=null}return e}function du(e,t){for(;;){var r=Dl;try{if(xi(),hs.current=io,ys){for(var n=ds.memoizedState;null!==n;){var a=n.queue;null!==a&&(a.pending=null),n=n.next}ys=!1}if(fs=0,gs=ms=ds=null,vs=!1,bs=0,Cl.current=null,null===r||null===r.return){Rl=1,Ll=t,Dl=null;break}e:{var s=e,o=r.return,l=r,u=t;if(t=Il,l.flags|=32768,null!==u&&"object"==typeof u&&"function"==typeof u.then){var c=u,h=l,p=h.tag;if(0==(1&h.mode)&&(0===p||11===p||15===p)){var f=h.alternate;f?(h.updateQueue=f.updateQueue,h.memoizedState=f.memoizedState,h.lanes=f.lanes):(h.updateQueue=null,h.memoizedState=null)}var d=yo(o);if(null!==d){d.flags&=-257,vo(d,o,l,0,t),1&d.mode&&go(s,c,t),u=c;var m=(t=d).updateQueue;if(null===m){var g=new Set;g.add(u),t.updateQueue=g}else m.add(u);break e}if(0==(1&t)){go(s,c,t),gu();break e}u=Error(i(426))}else if(ai&&1&l.mode){var y=yo(o);if(null!==y){0==(65536&y.flags)&&(y.flags|=256),vo(y,o,l,0,t),di(uo(u,l));break e}}s=u=uo(u,l),4!==Rl&&(Rl=2),null===Bl?Bl=[s]:Bl.push(s),s=o;do{switch(s.tag){case 3:s.flags|=65536,t&=-t,s.lanes|=t,Li(s,fo(0,u,t));break e;case 1:l=u;var v=s.type,b=s.stateNode;if(0==(128&s.flags)&&("function"==typeof v.getDerivedStateFromError||null!==b&&"function"==typeof b.componentDidCatch&&(null===$l||!$l.has(b)))){s.flags|=65536,t&=-t,s.lanes|=t,Li(s,mo(s,l,t));break e}}s=s.return}while(null!==s)}xu(r)}catch(e){t=e,Dl===r&&null!==r&&(Dl=r=r.return);continue}break}}function mu(){var e=Pl.current;return Pl.current=io,null===e?io:e}function gu(){0!==Rl&&3!==Rl&&2!==Rl||(Rl=4),null===Ml||0==(268435455&Nl)&&0==(268435455&Vl)||lu(Ml,Il)}function yu(e,t){var r=Tl;Tl|=2;var n=mu();for(Ml===e&&Il===t||(ql=null,fu(e,t));;)try{vu();break}catch(t){du(e,t)}if(xi(),Tl=r,Pl.current=n,null!==Dl)throw Error(i(261));return Ml=null,Il=0,Rl}function vu(){for(;null!==Dl;)ku(Dl)}function bu(){for(;null!==Dl&&!Je();)ku(Dl)}function ku(e){var t=El(e.alternate,e,Fl);e.memoizedProps=e.pendingProps,null===t?xu(e):Dl=t,Cl.current=null}function xu(e){var t=e;do{var r=t.alternate;if(e=t.return,0==(32768&t.flags)){if(null!==(r=Ko(r,t,Fl)))return void(Dl=r)}else{if(null!==(r=Jo(r,t)))return r.flags&=32767,void(Dl=r);if(null===e)return Rl=6,void(Dl=null);e.flags|=32768,e.subtreeFlags=0,e.deletions=null}if(null!==(t=t.sibling))return void(Dl=t);Dl=t=e}while(null!==t);0===Rl&&(Rl=5)}function Su(e,t,r){var n=bt,a=Al.transition;try{Al.transition=null,bt=1,function(e,t,r,n){do{wu()}while(null!==Jl);if(0!=(6&Tl))throw Error(i(327));r=e.finishedWork;var a=e.finishedLanes;if(null===r)return null;if(e.finishedWork=null,e.finishedLanes=0,r===e.current)throw Error(i(177));e.callbackNode=null,e.callbackPriority=0;var s=r.lanes|r.childLanes;if(function(e,t){var r=e.pendingLanes&~t;e.pendingLanes=t,e.suspendedLanes=0,e.pingedLanes=0,e.expiredLanes&=t,e.mutableReadLanes&=t,e.entangledLanes&=t,t=e.entanglements;var n=e.eventTimes;for(e=e.expirationTimes;0<r;){var a=31-st(r),i=1<<a;t[a]=0,n[a]=-1,e[a]=-1,r&=~i}}(e,s),e===Ml&&(Dl=Ml=null,Il=0),0==(2064&r.subtreeFlags)&&0==(2064&r.flags)||Kl||(Kl=!0,Mu(tt,(function(){return wu(),null}))),s=0!=(15990&r.flags),0!=(15990&r.subtreeFlags)||s){s=Al.transition,Al.transition=null;var o=bt;bt=1;var l=Tl;Tl|=4,Cl.current=null,function(e,t){if(ea=qt,fn(e=pn())){if("selectionStart"in e)var r={start:e.selectionStart,end:e.selectionEnd};else e:{var n=(r=(r=e.ownerDocument)&&r.defaultView||window).getSelection&&r.getSelection();if(n&&0!==n.rangeCount){r=n.anchorNode;var a=n.anchorOffset,s=n.focusNode;n=n.focusOffset;try{r.nodeType,s.nodeType}catch(e){r=null;break e}var o=0,l=-1,u=-1,c=0,h=0,p=e,f=null;t:for(;;){for(var d;p!==r||0!==a&&3!==p.nodeType||(l=o+a),p!==s||0!==n&&3!==p.nodeType||(u=o+n),3===p.nodeType&&(o+=p.nodeValue.length),null!==(d=p.firstChild);)f=p,p=d;for(;;){if(p===e)break t;if(f===r&&++c===a&&(l=o),f===s&&++h===n&&(u=o),null!==(d=p.nextSibling))break;f=(p=f).parentNode}p=d}r=-1===l||-1===u?null:{start:l,end:u}}else r=null}r=r||{start:0,end:0}}else r=null;for(ta={focusedElem:e,selectionRange:r},qt=!1,Zo=t;null!==Zo;)if(e=(t=Zo).child,0!=(1028&t.subtreeFlags)&&null!==e)e.return=t,Zo=e;else for(;null!==Zo;){t=Zo;try{var m=t.alternate;if(0!=(1024&t.flags))switch(t.tag){case 0:case 11:case 15:case 5:case 6:case 4:case 17:break;case 1:if(null!==m){var g=m.memoizedProps,y=m.memoizedState,v=t.stateNode,b=v.getSnapshotBeforeUpdate(t.elementType===t.type?g:gi(t.type,g),y);v.__reactInternalSnapshotBeforeUpdate=b}break;case 3:var k=t.stateNode.containerInfo;1===k.nodeType?k.textContent="":9===k.nodeType&&k.documentElement&&k.removeChild(k.documentElement);break;default:throw Error(i(163))}}catch(e){_u(t,t.return,e)}if(null!==(e=t.sibling)){e.return=t.return,Zo=e;break}Zo=t.return}m=rl,rl=!1}(e,r),yl(r,e),dn(ta),qt=!!ea,ta=ea=null,e.current=r,bl(r,e,a),Ye(),Tl=l,bt=o,Al.transition=s}else e.current=r;if(Kl&&(Kl=!1,Jl=e,Yl=a),s=e.pendingLanes,0===s&&($l=null),function(e){if(it&&"function"==typeof it.onCommitFiberRoot)try{it.onCommitFiberRoot(at,e,void 0,128==(128&e.current.flags))}catch(e){}}(r.stateNode),au(e,Qe()),null!==t)for(n=e.onRecoverableError,r=0;r<t.length;r++)a=t[r],n(a.value,{componentStack:a.stack,digest:a.digest});if(Ul)throw Ul=!1,e=Wl,Wl=null,e;0!=(1&Yl)&&0!==e.tag&&wu(),s=e.pendingLanes,0!=(1&s)?e===Xl?Ql++:(Ql=0,Xl=e):Ql=0,Ga()}(e,t,r,n)}finally{Al.transition=a,bt=n}return null}function wu(){if(null!==Jl){var e=kt(Yl),t=Al.transition,r=bt;try{if(Al.transition=null,bt=16>e?16:e,null===Jl)var n=!1;else{if(e=Jl,Jl=null,Yl=0,0!=(6&Tl))throw Error(i(331));var a=Tl;for(Tl|=4,Zo=e.current;null!==Zo;){var s=Zo,o=s.child;if(0!=(16&Zo.flags)){var l=s.deletions;if(null!==l){for(var u=0;u<l.length;u++){var c=l[u];for(Zo=c;null!==Zo;){var h=Zo;switch(h.tag){case 0:case 11:case 15:nl(8,h,s)}var p=h.child;if(null!==p)p.return=h,Zo=p;else for(;null!==Zo;){var f=(h=Zo).sibling,d=h.return;if(sl(h),h===c){Zo=null;break}if(null!==f){f.return=d,Zo=f;break}Zo=d}}}var m=s.alternate;if(null!==m){var g=m.child;if(null!==g){m.child=null;do{var y=g.sibling;g.sibling=null,g=y}while(null!==g)}}Zo=s}}if(0!=(2064&s.subtreeFlags)&&null!==o)o.return=s,Zo=o;else e:for(;null!==Zo;){if(0!=(2048&(s=Zo).flags))switch(s.tag){case 0:case 11:case 15:nl(9,s,s.return)}var v=s.sibling;if(null!==v){v.return=s.return,Zo=v;break e}Zo=s.return}}var b=e.current;for(Zo=b;null!==Zo;){var k=(o=Zo).child;if(0!=(2064&o.subtreeFlags)&&null!==k)k.return=o,Zo=k;else e:for(o=b;null!==Zo;){if(0!=(2048&(l=Zo).flags))try{switch(l.tag){case 0:case 11:case 15:al(9,l)}}catch(e){_u(l,l.return,e)}if(l===o){Zo=null;break e}var x=l.sibling;if(null!==x){x.return=l.return,Zo=x;break e}Zo=l.return}}if(Tl=a,Ga(),it&&"function"==typeof it.onPostCommitFiberRoot)try{it.onPostCommitFiberRoot(at,e)}catch(e){}n=!0}return n}finally{bt=r,Al.transition=t}}return!1}function Eu(e,t,r){e=Oi(e,t=fo(0,t=uo(r,t),1),1),t=tu(),null!==e&&(yt(e,1,t),au(e,t))}function _u(e,t,r){if(3===e.tag)Eu(e,e,r);else for(;null!==t;){if(3===t.tag){Eu(t,e,r);break}if(1===t.tag){var n=t.stateNode;if("function"==typeof t.type.getDerivedStateFromError||"function"==typeof n.componentDidCatch&&(null===$l||!$l.has(n))){t=Oi(t,e=mo(t,e=uo(r,e),1),1),e=tu(),null!==t&&(yt(t,1,e),au(t,e));break}}t=t.return}}function Pu(e,t,r){var n=e.pingCache;null!==n&&n.delete(t),t=tu(),e.pingedLanes|=e.suspendedLanes&r,Ml===e&&(Il&r)===r&&(4===Rl||3===Rl&&(130023424&Il)===Il&&500>Qe()-Gl?fu(e,0):zl|=r),au(e,t)}function Cu(e,t){0===t&&(0==(1&e.mode)?t=1:(t=ct,0==(130023424&(ct<<=1))&&(ct=4194304)));var r=tu();null!==(e=Ti(e,t))&&(yt(e,t,r),au(e,r))}function Au(e){var t=e.memoizedState,r=0;null!==t&&(r=t.retryLane),Cu(e,r)}function Tu(e,t){var r=0;switch(e.tag){case 13:var n=e.stateNode,a=e.memoizedState;null!==a&&(r=a.retryLane);break;case 19:n=e.stateNode;break;default:throw Error(i(314))}null!==n&&n.delete(t),Cu(e,r)}function Mu(e,t){return $e(e,t)}function Du(e,t,r,n){this.tag=e,this.key=r,this.sibling=this.child=this.return=this.stateNode=this.type=this.elementType=null,this.index=0,this.ref=null,this.pendingProps=t,this.dependencies=this.memoizedState=this.updateQueue=this.memoizedProps=null,this.mode=n,this.subtreeFlags=this.flags=0,this.deletions=null,this.childLanes=this.lanes=0,this.alternate=null}function Iu(e,t,r,n){return new Du(e,t,r,n)}function Fu(e){return!(!(e=e.prototype)||!e.isReactComponent)}function Ou(e,t){var r=e.alternate;return null===r?((r=Iu(e.tag,t,e.key,e.mode)).elementType=e.elementType,r.type=e.type,r.stateNode=e.stateNode,r.alternate=e,e.alternate=r):(r.pendingProps=t,r.type=e.type,r.flags=0,r.subtreeFlags=0,r.deletions=null),r.flags=14680064&e.flags,r.childLanes=e.childLanes,r.lanes=e.lanes,r.child=e.child,r.memoizedProps=e.memoizedProps,r.memoizedState=e.memoizedState,r.updateQueue=e.updateQueue,t=e.dependencies,r.dependencies=null===t?null:{lanes:t.lanes,firstContext:t.firstContext},r.sibling=e.sibling,r.index=e.index,r.ref=e.ref,r}function Ru(e,t,r,n,a,s){var o=2;if(n=e,"function"==typeof e)Fu(e)&&(o=1);else if("string"==typeof e)o=5;else e:switch(e){case w:return Lu(r.children,a,s,t);case E:o=8,a|=8;break;case _:return(e=Iu(12,r,t,2|a)).elementType=_,e.lanes=s,e;case T:return(e=Iu(13,r,t,a)).elementType=T,e.lanes=s,e;case M:return(e=Iu(19,r,t,a)).elementType=M,e.lanes=s,e;case F:return Nu(r,a,s,t);default:if("object"==typeof e&&null!==e)switch(e.$$typeof){case P:o=10;break e;case C:o=9;break e;case A:o=11;break e;case D:o=14;break e;case I:o=16,n=null;break e}throw Error(i(130,null==e?e:typeof e,""))}return(t=Iu(o,r,t,a)).elementType=e,t.type=n,t.lanes=s,t}function Lu(e,t,r,n){return(e=Iu(7,e,n,t)).lanes=r,e}function Nu(e,t,r,n){return(e=Iu(22,e,n,t)).elementType=F,e.lanes=r,e.stateNode={isHidden:!1},e}function Vu(e,t,r){return(e=Iu(6,e,null,t)).lanes=r,e}function zu(e,t,r){return(t=Iu(4,null!==e.children?e.children:[],e.key,t)).lanes=r,t.stateNode={containerInfo:e.containerInfo,pendingChildren:null,implementation:e.implementation},t}function Bu(e,t,r,n,a){this.tag=t,this.containerInfo=e,this.finishedWork=this.pingCache=this.current=this.pendingChildren=null,this.timeoutHandle=-1,this.callbackNode=this.pendingContext=this.context=null,this.callbackPriority=0,this.eventTimes=gt(0),this.expirationTimes=gt(-1),this.entangledLanes=this.finishedLanes=this.mutableReadLanes=this.expiredLanes=this.pingedLanes=this.suspendedLanes=this.pendingLanes=0,this.entanglements=gt(0),this.identifierPrefix=n,this.onRecoverableError=a,this.mutableSourceEagerHydrationData=null}function ju(e,t,r,n,a,i,s,o,l){return e=new Bu(e,t,r,o,l),1===t?(t=1,!0===i&&(t|=8)):t=0,i=Iu(3,null,null,t),e.current=i,i.stateNode=e,i.memoizedState={element:n,isDehydrated:r,cache:null,transitions:null,pendingSuspenseBoundaries:null},Di(i),e}function Gu(e){if(!e)return Ca;e:{if(Ge(e=e._reactInternals)!==e||1!==e.tag)throw Error(i(170));var t=e;do{switch(t.tag){case 3:t=t.stateNode.context;break e;case 1:if(Ia(t.type)){t=t.stateNode.__reactInternalMemoizedMergedChildContext;break e}}t=t.return}while(null!==t);throw Error(i(171))}if(1===e.tag){var r=e.type;if(Ia(r))return Ra(e,r,t)}return t}function Hu(e,t,r,n,a,i,s,o,l){return(e=ju(r,n,!0,e,0,i,0,o,l)).context=Gu(null),r=e.current,(i=Fi(n=tu(),a=ru(r))).callback=null!=t?t:null,Oi(r,i,a),e.current.lanes=a,yt(e,a,n),au(e,n),e}function qu(e,t,r,n){var a=t.current,i=tu(),s=ru(a);return r=Gu(r),null===t.context?t.context=r:t.pendingContext=r,(t=Fi(i,s)).payload={element:e},null!==(n=void 0===n?null:n)&&(t.callback=n),null!==(e=Oi(a,t,s))&&(nu(e,a,s,i),Ri(e,a,s)),s}function Uu(e){return(e=e.current).child?(e.child.tag,e.child.stateNode):null}function Wu(e,t){if(null!==(e=e.memoizedState)&&null!==e.dehydrated){var r=e.retryLane;e.retryLane=0!==r&&r<t?r:t}}function $u(e,t){Wu(e,t),(e=e.alternate)&&Wu(e,t)}El=function(e,t,r){if(null!==e)if(e.memoizedProps!==t.pendingProps||Ta.current)ko=!0;else{if(0==(e.lanes&r)&&0==(128&t.flags))return ko=!1,function(e,t,r){switch(t.tag){case 3:Mo(t),fi();break;case 5:is(t);break;case 1:Ia(t.type)&&La(t);break;case 4:ns(t,t.stateNode.containerInfo);break;case 10:var n=t.type._context,a=t.memoizedProps.value;Pa(yi,n._currentValue),n._currentValue=a;break;case 13:if(null!==(n=t.memoizedState))return null!==n.dehydrated?(Pa(os,1&os.current),t.flags|=128,null):0!=(r&t.child.childLanes)?Vo(e,t,r):(Pa(os,1&os.current),null!==(e=Uo(e,t,r))?e.sibling:null);Pa(os,1&os.current);break;case 19:if(n=0!=(r&t.childLanes),0!=(128&e.flags)){if(n)return Ho(e,t,r);t.flags|=128}if(null!==(a=t.memoizedState)&&(a.rendering=null,a.tail=null,a.lastEffect=null),Pa(os,os.current),n)break;return null;case 22:case 23:return t.lanes=0,_o(e,t,r)}return Uo(e,t,r)}(e,t,r);ko=0!=(131072&e.flags)}else ko=!1,ai&&0!=(1048576&t.flags)&&Za(t,Wa,t.index);switch(t.lanes=0,t.tag){case 2:var n=t.type;qo(e,t),e=t.pendingProps;var a=Da(t,Aa.current);Ei(t,r),a=ws(null,t,n,e,a,r);var s=Es();return t.flags|=1,"object"==typeof a&&null!==a&&"function"==typeof a.render&&void 0===a.$$typeof?(t.tag=1,t.memoizedState=null,t.updateQueue=null,Ia(n)?(s=!0,La(t)):s=!1,t.memoizedState=null!==a.state&&void 0!==a.state?a.state:null,Di(t),a.updater=ji,t.stateNode=a,a._reactInternals=t,Ui(t,n,e,r),t=To(null,t,n,!0,s,r)):(t.tag=0,ai&&s&&ei(t),xo(null,t,a,r),t=t.child),t;case 16:n=t.elementType;e:{switch(qo(e,t),e=t.pendingProps,n=(a=n._init)(n._payload),t.type=n,a=t.tag=function(e){if("function"==typeof e)return Fu(e)?1:0;if(null!=e){if((e=e.$$typeof)===A)return 11;if(e===D)return 14}return 2}(n),e=gi(n,e),a){case 0:t=Co(null,t,n,e,r);break e;case 1:t=Ao(null,t,n,e,r);break e;case 11:t=So(null,t,n,e,r);break e;case 14:t=wo(null,t,n,gi(n.type,e),r);break e}throw Error(i(306,n,""))}return t;case 0:return n=t.type,a=t.pendingProps,Co(e,t,n,a=t.elementType===n?a:gi(n,a),r);case 1:return n=t.type,a=t.pendingProps,Ao(e,t,n,a=t.elementType===n?a:gi(n,a),r);case 3:e:{if(Mo(t),null===e)throw Error(i(387));n=t.pendingProps,a=(s=t.memoizedState).element,Ii(e,t),Ni(t,n,null,r);var o=t.memoizedState;if(n=o.element,s.isDehydrated){if(s={element:n,isDehydrated:!1,cache:o.cache,pendingSuspenseBoundaries:o.pendingSuspenseBoundaries,transitions:o.transitions},t.updateQueue.baseState=s,t.memoizedState=s,256&t.flags){t=Do(e,t,n,r,a=uo(Error(i(423)),t));break e}if(n!==a){t=Do(e,t,n,r,a=uo(Error(i(424)),t));break e}for(ni=ua(t.stateNode.containerInfo.firstChild),ri=t,ai=!0,ii=null,r=Qi(t,null,n,r),t.child=r;r;)r.flags=-3&r.flags|4096,r=r.sibling}else{if(fi(),n===a){t=Uo(e,t,r);break e}xo(e,t,n,r)}t=t.child}return t;case 5:return is(t),null===e&&ui(t),n=t.type,a=t.pendingProps,s=null!==e?e.memoizedProps:null,o=a.children,ra(n,a)?o=null:null!==s&&ra(n,s)&&(t.flags|=32),Po(e,t),xo(e,t,o,r),t.child;case 6:return null===e&&ui(t),null;case 13:return Vo(e,t,r);case 4:return ns(t,t.stateNode.containerInfo),n=t.pendingProps,null===e?t.child=Yi(t,null,n,r):xo(e,t,n,r),t.child;case 11:return n=t.type,a=t.pendingProps,So(e,t,n,a=t.elementType===n?a:gi(n,a),r);case 7:return xo(e,t,t.pendingProps,r),t.child;case 8:case 12:return xo(e,t,t.pendingProps.children,r),t.child;case 10:e:{if(n=t.type._context,a=t.pendingProps,s=t.memoizedProps,o=a.value,Pa(yi,n._currentValue),n._currentValue=o,null!==s)if(on(s.value,o)){if(s.children===a.children&&!Ta.current){t=Uo(e,t,r);break e}}else for(null!==(s=t.child)&&(s.return=t);null!==s;){var l=s.dependencies;if(null!==l){o=s.child;for(var u=l.firstContext;null!==u;){if(u.context===n){if(1===s.tag){(u=Fi(-1,r&-r)).tag=2;var c=s.updateQueue;if(null!==c){var h=(c=c.shared).pending;null===h?u.next=u:(u.next=h.next,h.next=u),c.pending=u}}s.lanes|=r,null!==(u=s.alternate)&&(u.lanes|=r),wi(s.return,r,t),l.lanes|=r;break}u=u.next}}else if(10===s.tag)o=s.type===t.type?null:s.child;else if(18===s.tag){if(null===(o=s.return))throw Error(i(341));o.lanes|=r,null!==(l=o.alternate)&&(l.lanes|=r),wi(o,r,t),o=s.sibling}else o=s.child;if(null!==o)o.return=s;else for(o=s;null!==o;){if(o===t){o=null;break}if(null!==(s=o.sibling)){s.return=o.return,o=s;break}o=o.return}s=o}xo(e,t,a.children,r),t=t.child}return t;case 9:return a=t.type,n=t.pendingProps.children,Ei(t,r),n=n(a=_i(a)),t.flags|=1,xo(e,t,n,r),t.child;case 14:return a=gi(n=t.type,t.pendingProps),wo(e,t,n,a=gi(n.type,a),r);case 15:return Eo(e,t,t.type,t.pendingProps,r);case 17:return n=t.type,a=t.pendingProps,a=t.elementType===n?a:gi(n,a),qo(e,t),t.tag=1,Ia(n)?(e=!0,La(t)):e=!1,Ei(t,r),Hi(t,n,a),Ui(t,n,a,r),To(null,t,n,!0,e,r);case 19:return Ho(e,t,r);case 22:return _o(e,t,r)}throw Error(i(156,t.tag))};var Ku="function"==typeof reportError?reportError:function(e){console.error(e)};function Ju(e){this._internalRoot=e}function Yu(e){this._internalRoot=e}function Qu(e){return!(!e||1!==e.nodeType&&9!==e.nodeType&&11!==e.nodeType)}function Xu(e){return!(!e||1!==e.nodeType&&9!==e.nodeType&&11!==e.nodeType&&(8!==e.nodeType||" react-mount-point-unstable "!==e.nodeValue))}function Zu(){}function ec(e,t,r,n,a){var i=r._reactRootContainer;if(i){var s=i;if("function"==typeof a){var o=a;a=function(){var e=Uu(s);o.call(e)}}qu(t,s,e,a)}else s=function(e,t,r,n,a){if(a){if("function"==typeof n){var i=n;n=function(){var e=Uu(s);i.call(e)}}var s=Hu(t,n,e,0,null,!1,0,"",Zu);return e._reactRootContainer=s,e[da]=s.current,Gn(8===e.nodeType?e.parentNode:e),hu(),s}for(;a=e.lastChild;)e.removeChild(a);if("function"==typeof n){var o=n;n=function(){var e=Uu(l);o.call(e)}}var l=ju(e,0,!1,null,0,!1,0,"",Zu);return e._reactRootContainer=l,e[da]=l.current,Gn(8===e.nodeType?e.parentNode:e),hu((function(){qu(t,l,r,n)})),l}(r,t,e,a,n);return Uu(s)}Yu.prototype.render=Ju.prototype.render=function(e){var t=this._internalRoot;if(null===t)throw Error(i(409));qu(e,t,null,null)},Yu.prototype.unmount=Ju.prototype.unmount=function(){var e=this._internalRoot;if(null!==e){this._internalRoot=null;var t=e.containerInfo;hu((function(){qu(null,e,null,null)})),t[da]=null}},Yu.prototype.unstable_scheduleHydration=function(e){if(e){var t=Et();e={blockedOn:null,target:e,priority:t};for(var r=0;r<Ft.length&&0!==t&&t<Ft[r].priority;r++);Ft.splice(r,0,e),0===r&&Nt(e)}},xt=function(e){switch(e.tag){case 3:var t=e.stateNode;if(t.current.memoizedState.isDehydrated){var r=ht(t.pendingLanes);0!==r&&(vt(t,1|r),au(t,Qe()),0==(6&Tl)&&(Hl=Qe()+500,Ga()))}break;case 13:hu((function(){var t=Ti(e,1);if(null!==t){var r=tu();nu(t,e,1,r)}})),$u(e,1)}},St=function(e){if(13===e.tag){var t=Ti(e,134217728);if(null!==t)nu(t,e,134217728,tu());$u(e,134217728)}},wt=function(e){if(13===e.tag){var t=ru(e),r=Ti(e,t);if(null!==r)nu(r,e,t,tu());$u(e,t)}},Et=function(){return bt},_t=function(e,t){var r=bt;try{return bt=e,t()}finally{bt=r}},Se=function(e,t,r){switch(t){case"input":if(X(e,r),t=r.name,"radio"===r.type&&null!=t){for(r=e;r.parentNode;)r=r.parentNode;for(r=r.querySelectorAll("input[name="+JSON.stringify(""+t)+'][type="radio"]'),t=0;t<r.length;t++){var n=r[t];if(n!==e&&n.form===e.form){var a=xa(n);if(!a)throw Error(i(90));$(n),X(n,a)}}}break;case"textarea":ie(e,r);break;case"select":null!=(t=r.value)&&re(e,!!r.multiple,t,!1)}},Ae=cu,Te=hu;var tc={usingClientEntryPoint:!1,Events:[ba,ka,xa,Pe,Ce,cu]},rc={findFiberByHostInstance:va,bundleType:0,version:"18.2.0",rendererPackageName:"react-dom"},nc={bundleType:rc.bundleType,version:rc.version,rendererPackageName:rc.rendererPackageName,rendererConfig:rc.rendererConfig,overrideHookState:null,overrideHookStateDeletePath:null,overrideHookStateRenamePath:null,overrideProps:null,overridePropsDeletePath:null,overridePropsRenamePath:null,setErrorHandler:null,setSuspenseHandler:null,scheduleUpdate:null,currentDispatcherRef:k.ReactCurrentDispatcher,findHostInstanceByFiber:function(e){return null===(e=Ue(e))?null:e.stateNode},findFiberByHostInstance:rc.findFiberByHostInstance||function(){return null},findHostInstancesForRefresh:null,scheduleRefresh:null,scheduleRoot:null,setRefreshHandler:null,getCurrentFiber:null,reconcilerVersion:"18.2.0-next-9e3b772b8-20220608"};if("undefined"!=typeof __REACT_DEVTOOLS_GLOBAL_HOOK__){var ac=__REACT_DEVTOOLS_GLOBAL_HOOK__;if(!ac.isDisabled&&ac.supportsFiber)try{at=ac.inject(nc),it=ac}catch(ce){}}t.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED=tc,t.createPortal=function(e,t){var r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!Qu(t))throw Error(i(200));return function(e,t,r){var n=3<arguments.length&&void 0!==arguments[3]?arguments[3]:null;return{$$typeof:S,key:null==n?null:""+n,children:e,containerInfo:t,implementation:r}}(e,t,null,r)},t.createRoot=function(e,t){if(!Qu(e))throw Error(i(299));var r=!1,n="",a=Ku;return null!=t&&(!0===t.unstable_strictMode&&(r=!0),void 0!==t.identifierPrefix&&(n=t.identifierPrefix),void 0!==t.onRecoverableError&&(a=t.onRecoverableError)),t=ju(e,1,!1,null,0,r,0,n,a),e[da]=t.current,Gn(8===e.nodeType?e.parentNode:e),new Ju(t)},t.findDOMNode=function(e){if(null==e)return null;if(1===e.nodeType)return e;var t=e._reactInternals;if(void 0===t){if("function"==typeof e.render)throw Error(i(188));throw e=Object.keys(e).join(","),Error(i(268,e))}return e=null===(e=Ue(t))?null:e.stateNode},t.flushSync=function(e){return hu(e)},t.hydrate=function(e,t,r){if(!Xu(t))throw Error(i(200));return ec(null,e,t,!0,r)},t.hydrateRoot=function(e,t,r){if(!Qu(e))throw Error(i(405));var n=null!=r&&r.hydratedSources||null,a=!1,s="",o=Ku;if(null!=r&&(!0===r.unstable_strictMode&&(a=!0),void 0!==r.identifierPrefix&&(s=r.identifierPrefix),void 0!==r.onRecoverableError&&(o=r.onRecoverableError)),t=Hu(t,null,e,1,null!=r?r:null,a,0,s,o),e[da]=t.current,Gn(e),n)for(e=0;e<n.length;e++)a=(a=(r=n[e])._getVersion)(r._source),null==t.mutableSourceEagerHydrationData?t.mutableSourceEagerHydrationData=[r,a]:t.mutableSourceEagerHydrationData.push(r,a);return new Yu(t)},t.render=function(e,t,r){if(!Xu(t))throw Error(i(200));return ec(null,e,t,!1,r)},t.unmountComponentAtNode=function(e){if(!Xu(e))throw Error(i(40));return!!e._reactRootContainer&&(hu((function(){ec(null,null,e,!1,(function(){e._reactRootContainer=null,e[da]=null}))})),!0)},t.unstable_batchedUpdates=cu,t.unstable_renderSubtreeIntoContainer=function(e,t,r,n){if(!Xu(r))throw Error(i(200));if(null==e||void 0===e._reactInternals)throw Error(i(38));return ec(e,t,r,!1,n)},t.version="18.2.0-next-9e3b772b8-20220608"},745:(e,t,r)=>{"use strict";var n=r(3935);t.s=n.createRoot,n.hydrateRoot},3935:(e,t,r)=>{"use strict";!function e(){if("undefined"!=typeof __REACT_DEVTOOLS_GLOBAL_HOOK__&&"function"==typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE)try{__REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(e)}catch(e){console.error(e)}}(),e.exports=r(4448)},2408:(e,t)=>{"use strict";var r=Symbol.for("react.element"),n=Symbol.for("react.portal"),a=Symbol.for("react.fragment"),i=Symbol.for("react.strict_mode"),s=Symbol.for("react.profiler"),o=Symbol.for("react.provider"),l=Symbol.for("react.context"),u=Symbol.for("react.forward_ref"),c=Symbol.for("react.suspense"),h=Symbol.for("react.memo"),p=Symbol.for("react.lazy"),f=Symbol.iterator;var d={isMounted:function(){return!1},enqueueForceUpdate:function(){},enqueueReplaceState:function(){},enqueueSetState:function(){}},m=Object.assign,g={};function y(e,t,r){this.props=e,this.context=t,this.refs=g,this.updater=r||d}function v(){}function b(e,t,r){this.props=e,this.context=t,this.refs=g,this.updater=r||d}y.prototype.isReactComponent={},y.prototype.setState=function(e,t){if("object"!=typeof e&&"function"!=typeof e&&null!=e)throw Error("setState(...): takes an object of state variables to update or a function which returns an object of state variables.");this.updater.enqueueSetState(this,e,t,"setState")},y.prototype.forceUpdate=function(e){this.updater.enqueueForceUpdate(this,e,"forceUpdate")},v.prototype=y.prototype;var k=b.prototype=new v;k.constructor=b,m(k,y.prototype),k.isPureReactComponent=!0;var x=Array.isArray,S=Object.prototype.hasOwnProperty,w={current:null},E={key:!0,ref:!0,__self:!0,__source:!0};function _(e,t,n){var a,i={},s=null,o=null;if(null!=t)for(a in void 0!==t.ref&&(o=t.ref),void 0!==t.key&&(s=""+t.key),t)S.call(t,a)&&!E.hasOwnProperty(a)&&(i[a]=t[a]);var l=arguments.length-2;if(1===l)i.children=n;else if(1<l){for(var u=Array(l),c=0;c<l;c++)u[c]=arguments[c+2];i.children=u}if(e&&e.defaultProps)for(a in l=e.defaultProps)void 0===i[a]&&(i[a]=l[a]);return{$$typeof:r,type:e,key:s,ref:o,props:i,_owner:w.current}}function P(e){return"object"==typeof e&&null!==e&&e.$$typeof===r}var C=/\/+/g;function A(e,t){return"object"==typeof e&&null!==e&&null!=e.key?function(e){var t={"=":"=0",":":"=2"};return"$"+e.replace(/[=:]/g,(function(e){return t[e]}))}(""+e.key):t.toString(36)}function T(e,t,a,i,s){var o=typeof e;"undefined"!==o&&"boolean"!==o||(e=null);var l=!1;if(null===e)l=!0;else switch(o){case"string":case"number":l=!0;break;case"object":switch(e.$$typeof){case r:case n:l=!0}}if(l)return s=s(l=e),e=""===i?"."+A(l,0):i,x(s)?(a="",null!=e&&(a=e.replace(C,"$&/")+"/"),T(s,t,a,"",(function(e){return e}))):null!=s&&(P(s)&&(s=function(e,t){return{$$typeof:r,type:e.type,key:t,ref:e.ref,props:e.props,_owner:e._owner}}(s,a+(!s.key||l&&l.key===s.key?"":(""+s.key).replace(C,"$&/")+"/")+e)),t.push(s)),1;if(l=0,i=""===i?".":i+":",x(e))for(var u=0;u<e.length;u++){var c=i+A(o=e[u],u);l+=T(o,t,a,c,s)}else if(c=function(e){return null===e||"object"!=typeof e?null:"function"==typeof(e=f&&e[f]||e["@@iterator"])?e:null}(e),"function"==typeof c)for(e=c.call(e),u=0;!(o=e.next()).done;)l+=T(o=o.value,t,a,c=i+A(o,u++),s);else if("object"===o)throw t=String(e),Error("Objects are not valid as a React child (found: "+("[object Object]"===t?"object with keys {"+Object.keys(e).join(", ")+"}":t)+"). If you meant to render a collection of children, use an array instead.");return l}function M(e,t,r){if(null==e)return e;var n=[],a=0;return T(e,n,"","",(function(e){return t.call(r,e,a++)})),n}function D(e){if(-1===e._status){var t=e._result;(t=t()).then((function(t){0!==e._status&&-1!==e._status||(e._status=1,e._result=t)}),(function(t){0!==e._status&&-1!==e._status||(e._status=2,e._result=t)})),-1===e._status&&(e._status=0,e._result=t)}if(1===e._status)return e._result.default;throw e._result}var I={current:null},F={transition:null},O={ReactCurrentDispatcher:I,ReactCurrentBatchConfig:F,ReactCurrentOwner:w};t.Children={map:M,forEach:function(e,t,r){M(e,(function(){t.apply(this,arguments)}),r)},count:function(e){var t=0;return M(e,(function(){t++})),t},toArray:function(e){return M(e,(function(e){return e}))||[]},only:function(e){if(!P(e))throw Error("React.Children.only expected to receive a single React element child.");return e}},t.Component=y,t.Fragment=a,t.Profiler=s,t.PureComponent=b,t.StrictMode=i,t.Suspense=c,t.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED=O,t.cloneElement=function(e,t,n){if(null==e)throw Error("React.cloneElement(...): The argument must be a React element, but you passed "+e+".");var a=m({},e.props),i=e.key,s=e.ref,o=e._owner;if(null!=t){if(void 0!==t.ref&&(s=t.ref,o=w.current),void 0!==t.key&&(i=""+t.key),e.type&&e.type.defaultProps)var l=e.type.defaultProps;for(u in t)S.call(t,u)&&!E.hasOwnProperty(u)&&(a[u]=void 0===t[u]&&void 0!==l?l[u]:t[u])}var u=arguments.length-2;if(1===u)a.children=n;else if(1<u){l=Array(u);for(var c=0;c<u;c++)l[c]=arguments[c+2];a.children=l}return{$$typeof:r,type:e.type,key:i,ref:s,props:a,_owner:o}},t.createContext=function(e){return(e={$$typeof:l,_currentValue:e,_currentValue2:e,_threadCount:0,Provider:null,Consumer:null,_defaultValue:null,_globalName:null}).Provider={$$typeof:o,_context:e},e.Consumer=e},t.createElement=_,t.createFactory=function(e){var t=_.bind(null,e);return t.type=e,t},t.createRef=function(){return{current:null}},t.forwardRef=function(e){return{$$typeof:u,render:e}},t.isValidElement=P,t.lazy=function(e){return{$$typeof:p,_payload:{_status:-1,_result:e},_init:D}},t.memo=function(e,t){return{$$typeof:h,type:e,compare:void 0===t?null:t}},t.startTransition=function(e){var t=F.transition;F.transition={};try{e()}finally{F.transition=t}},t.unstable_act=function(){throw Error("act(...) is not supported in production builds of React.")},t.useCallback=function(e,t){return I.current.useCallback(e,t)},t.useContext=function(e){return I.current.useContext(e)},t.useDebugValue=function(){},t.useDeferredValue=function(e){return I.current.useDeferredValue(e)},t.useEffect=function(e,t){return I.current.useEffect(e,t)},t.useId=function(){return I.current.useId()},t.useImperativeHandle=function(e,t,r){return I.current.useImperativeHandle(e,t,r)},t.useInsertionEffect=function(e,t){return I.current.useInsertionEffect(e,t)},t.useLayoutEffect=function(e,t){return I.current.useLayoutEffect(e,t)},t.useMemo=function(e,t){return I.current.useMemo(e,t)},t.useReducer=function(e,t,r){return I.current.useReducer(e,t,r)},t.useRef=function(e){return I.current.useRef(e)},t.useState=function(e){return I.current.useState(e)},t.useSyncExternalStore=function(e,t,r){return I.current.useSyncExternalStore(e,t,r)},t.useTransition=function(){return I.current.useTransition()},t.version="18.2.0"},7294:(e,t,r)=>{"use strict";e.exports=r(2408)},53:(e,t)=>{"use strict";function r(e,t){var r=e.length;e.push(t);e:for(;0<r;){var n=r-1>>>1,a=e[n];if(!(0<i(a,t)))break e;e[n]=t,e[r]=a,r=n}}function n(e){return 0===e.length?null:e[0]}function a(e){if(0===e.length)return null;var t=e[0],r=e.pop();if(r!==t){e[0]=r;e:for(var n=0,a=e.length,s=a>>>1;n<s;){var o=2*(n+1)-1,l=e[o],u=o+1,c=e[u];if(0>i(l,r))u<a&&0>i(c,l)?(e[n]=c,e[u]=r,n=u):(e[n]=l,e[o]=r,n=o);else{if(!(u<a&&0>i(c,r)))break e;e[n]=c,e[u]=r,n=u}}}return t}function i(e,t){var r=e.sortIndex-t.sortIndex;return 0!==r?r:e.id-t.id}if("object"==typeof performance&&"function"==typeof performance.now){var s=performance;t.unstable_now=function(){return s.now()}}else{var o=Date,l=o.now();t.unstable_now=function(){return o.now()-l}}var u=[],c=[],h=1,p=null,f=3,d=!1,m=!1,g=!1,y="function"==typeof setTimeout?setTimeout:null,v="function"==typeof clearTimeout?clearTimeout:null,b="undefined"!=typeof setImmediate?setImmediate:null;function k(e){for(var t=n(c);null!==t;){if(null===t.callback)a(c);else{if(!(t.startTime<=e))break;a(c),t.sortIndex=t.expirationTime,r(u,t)}t=n(c)}}function x(e){if(g=!1,k(e),!m)if(null!==n(u))m=!0,F(S);else{var t=n(c);null!==t&&O(x,t.startTime-e)}}function S(e,r){m=!1,g&&(g=!1,v(P),P=-1),d=!0;var i=f;try{for(k(r),p=n(u);null!==p&&(!(p.expirationTime>r)||e&&!T());){var s=p.callback;if("function"==typeof s){p.callback=null,f=p.priorityLevel;var o=s(p.expirationTime<=r);r=t.unstable_now(),"function"==typeof o?p.callback=o:p===n(u)&&a(u),k(r)}else a(u);p=n(u)}if(null!==p)var l=!0;else{var h=n(c);null!==h&&O(x,h.startTime-r),l=!1}return l}finally{p=null,f=i,d=!1}}"undefined"!=typeof navigator&&void 0!==navigator.scheduling&&void 0!==navigator.scheduling.isInputPending&&navigator.scheduling.isInputPending.bind(navigator.scheduling);var w,E=!1,_=null,P=-1,C=5,A=-1;function T(){return!(t.unstable_now()-A<C)}function M(){if(null!==_){var e=t.unstable_now();A=e;var r=!0;try{r=_(!0,e)}finally{r?w():(E=!1,_=null)}}else E=!1}if("function"==typeof b)w=function(){b(M)};else if("undefined"!=typeof MessageChannel){var D=new MessageChannel,I=D.port2;D.port1.onmessage=M,w=function(){I.postMessage(null)}}else w=function(){y(M,0)};function F(e){_=e,E||(E=!0,w())}function O(e,r){P=y((function(){e(t.unstable_now())}),r)}t.unstable_IdlePriority=5,t.unstable_ImmediatePriority=1,t.unstable_LowPriority=4,t.unstable_NormalPriority=3,t.unstable_Profiling=null,t.unstable_UserBlockingPriority=2,t.unstable_cancelCallback=function(e){e.callback=null},t.unstable_continueExecution=function(){m||d||(m=!0,F(S))},t.unstable_forceFrameRate=function(e){0>e||125<e?console.error("forceFrameRate takes a positive int between 0 and 125, forcing frame rates higher than 125 fps is not supported"):C=0<e?Math.floor(1e3/e):5},t.unstable_getCurrentPriorityLevel=function(){return f},t.unstable_getFirstCallbackNode=function(){return n(u)},t.unstable_next=function(e){switch(f){case 1:case 2:case 3:var t=3;break;default:t=f}var r=f;f=t;try{return e()}finally{f=r}},t.unstable_pauseExecution=function(){},t.unstable_requestPaint=function(){},t.unstable_runWithPriority=function(e,t){switch(e){case 1:case 2:case 3:case 4:case 5:break;default:e=3}var r=f;f=e;try{return t()}finally{f=r}},t.unstable_scheduleCallback=function(e,a,i){var s=t.unstable_now();switch("object"==typeof i&&null!==i?i="number"==typeof(i=i.delay)&&0<i?s+i:s:i=s,e){case 1:var o=-1;break;case 2:o=250;break;case 5:o=1073741823;break;case 4:o=1e4;break;default:o=5e3}return e={id:h++,callback:a,priorityLevel:e,startTime:i,expirationTime:o=i+o,sortIndex:-1},i>s?(e.sortIndex=i,r(c,e),null===n(u)&&e===n(c)&&(g?(v(P),P=-1):g=!0,O(x,i-s))):(e.sortIndex=o,r(u,e),m||d||(m=!0,F(S))),e},t.unstable_shouldYield=T,t.unstable_wrapCallback=function(e){var t=f;return function(){var r=f;f=t;try{return e.apply(this,arguments)}finally{f=r}}}},3840:(e,t,r)=>{"use strict";e.exports=r(53)},3379:e=>{"use strict";var t=[];function r(e){for(var r=-1,n=0;n<t.length;n++)if(t[n].identifier===e){r=n;break}return r}function n(e,n){for(var i={},s=[],o=0;o<e.length;o++){var l=e[o],u=n.base?l[0]+n.base:l[0],c=i[u]||0,h="".concat(u," ").concat(c);i[u]=c+1;var p=r(h),f={css:l[1],media:l[2],sourceMap:l[3],supports:l[4],layer:l[5]};if(-1!==p)t[p].references++,t[p].updater(f);else{var d=a(f,n);n.byIndex=o,t.splice(o,0,{identifier:h,updater:d,references:1})}s.push(h)}return s}function a(e,t){var r=t.domAPI(t);r.update(e);return function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap&&t.supports===e.supports&&t.layer===e.layer)return;r.update(e=t)}else r.remove()}}e.exports=function(e,a){var i=n(e=e||[],a=a||{});return function(e){e=e||[];for(var s=0;s<i.length;s++){var o=r(i[s]);t[o].references--}for(var l=n(e,a),u=0;u<i.length;u++){var c=r(i[u]);0===t[c].references&&(t[c].updater(),t.splice(c,1))}i=l}}},569:e=>{"use strict";var t={};e.exports=function(e,r){var n=function(e){if(void 0===t[e]){var r=document.querySelector(e);if(window.HTMLIFrameElement&&r instanceof window.HTMLIFrameElement)try{r=r.contentDocument.head}catch(e){r=null}t[e]=r}return t[e]}(e);if(!n)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");n.appendChild(r)}},9216:e=>{"use strict";e.exports=function(e){var t=document.createElement("style");return e.setAttributes(t,e.attributes),e.insert(t,e.options),t}},8575:e=>{"use strict";e.exports=function(e,t){Object.keys(t).forEach((function(r){e.setAttribute(r,t[r])}))}},7795:e=>{"use strict";e.exports=function(e){var t=e.insertStyleElement(e);return{update:function(r){!function(e,t,r){var n="";r.supports&&(n+="@supports (".concat(r.supports,") {")),r.media&&(n+="@media ".concat(r.media," {"));var a=void 0!==r.layer;a&&(n+="@layer".concat(r.layer.length>0?" ".concat(r.layer):""," {")),n+=r.css,a&&(n+="}"),r.media&&(n+="}"),r.supports&&(n+="}");var i=r.sourceMap;i&&"undefined"!=typeof btoa&&(n+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(i))))," */")),t.styleTagTransform(n,e,t.options)}(t,e,r)},remove:function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e)}(t)}}}},4589:e=>{"use strict";e.exports=function(e,t){if(t.styleSheet)t.styleSheet.cssText=e;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(e))}}},1739:e=>{e.exports={area:!0,base:!0,br:!0,col:!0,embed:!0,hr:!0,img:!0,input:!0,link:!0,meta:!0,param:!0,source:!0,track:!0,wbr:!0}},1942:(e,t,r)=>{"use strict";e.exports=r.p+"76319ed07df274653459.png"},8420:(e,t,r)=>{"use strict";e.exports=r.p+"5c970459e6839141139d.png"},3630:(e,t,r)=>{"use strict";e.exports=r.p+"b774f4633fe09bd8bd1f.svg"},3311:(e,t,r)=>{"use strict";e.exports=r.p+"a298a0ac59f09aeb64eb.otf"},1755:(e,t,r)=>{"use strict";e.exports=r.p+"b25893558c7f1ad49e5e.ttf"},3056:(e,t,r)=>{"use strict";e.exports=r.p+"0eebbdfb27d542c486ce.ttf"},1272:(e,t,r)=>{"use strict";e.exports=r.p+"2d0dbf42750207f78ffa.ttf"},6856:(e,t,r)=>{"use strict";e.exports=r.p+"ba5622550ada9b5ff2cd.ttf"},6297:(e,t,r)=>{"use strict";e.exports=r.p+"d3098ef471597fe3c2ed.svg"},1055:(e,t,r)=>{"use strict";e.exports=r.p+"0c52acad72ce84465d75.svg"},2063:(e,t,r)=>{"use strict";e.exports=r.p+"7c9b7ad743c021800b5f.png"},1016:(e,t,r)=>{"use strict";e.exports=r.p+"42ff001a8c225fc1a354.png"},1695:(e,t,r)=>{"use strict";e.exports=r.p+"587706f4d9807ac4bdf4.png"},6912:(e,t,r)=>{"use strict";e.exports=r.p+"0428c5c7e6c4bbf91f69.png"},903:(e,t,r)=>{"use strict";e.exports=r.p+"427fc33b09a5b15cc69c.png"},7061:(e,t,r)=>{var n=r(8698).default;function a(){"use strict";e.exports=a=function(){return t},e.exports.__esModule=!0,e.exports.default=e.exports;var t={},r=Object.prototype,i=r.hasOwnProperty,s=Object.defineProperty||function(e,t,r){e[t]=r.value},o="function"==typeof Symbol?Symbol:{},l=o.iterator||"@@iterator",u=o.asyncIterator||"@@asyncIterator",c=o.toStringTag||"@@toStringTag";function h(e,t,r){return Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}),e[t]}try{h({},"")}catch(e){h=function(e,t,r){return e[t]=r}}function p(e,t,r,n){var a=t&&t.prototype instanceof m?t:m,i=Object.create(a.prototype),o=new A(n||[]);return s(i,"_invoke",{value:E(e,r,o)}),i}function f(e,t,r){try{return{type:"normal",arg:e.call(t,r)}}catch(e){return{type:"throw",arg:e}}}t.wrap=p;var d={};function m(){}function g(){}function y(){}var v={};h(v,l,(function(){return this}));var b=Object.getPrototypeOf,k=b&&b(b(T([])));k&&k!==r&&i.call(k,l)&&(v=k);var x=y.prototype=m.prototype=Object.create(v);function S(e){["next","throw","return"].forEach((function(t){h(e,t,(function(e){return this._invoke(t,e)}))}))}function w(e,t){function r(a,s,o,l){var u=f(e[a],e,s);if("throw"!==u.type){var c=u.arg,h=c.value;return h&&"object"==n(h)&&i.call(h,"__await")?t.resolve(h.__await).then((function(e){r("next",e,o,l)}),(function(e){r("throw",e,o,l)})):t.resolve(h).then((function(e){c.value=e,o(c)}),(function(e){return r("throw",e,o,l)}))}l(u.arg)}var a;s(this,"_invoke",{value:function(e,n){function i(){return new t((function(t,a){r(e,n,t,a)}))}return a=a?a.then(i,i):i()}})}function E(e,t,r){var n="suspendedStart";return function(a,i){if("executing"===n)throw new Error("Generator is already running");if("completed"===n){if("throw"===a)throw i;return M()}for(r.method=a,r.arg=i;;){var s=r.delegate;if(s){var o=_(s,r);if(o){if(o===d)continue;return o}}if("next"===r.method)r.sent=r._sent=r.arg;else if("throw"===r.method){if("suspendedStart"===n)throw n="completed",r.arg;r.dispatchException(r.arg)}else"return"===r.method&&r.abrupt("return",r.arg);n="executing";var l=f(e,t,r);if("normal"===l.type){if(n=r.done?"completed":"suspendedYield",l.arg===d)continue;return{value:l.arg,done:r.done}}"throw"===l.type&&(n="completed",r.method="throw",r.arg=l.arg)}}}function _(e,t){var r=t.method,n=e.iterator[r];if(void 0===n)return t.delegate=null,"throw"===r&&e.iterator.return&&(t.method="return",t.arg=void 0,_(e,t),"throw"===t.method)||"return"!==r&&(t.method="throw",t.arg=new TypeError("The iterator does not provide a '"+r+"' method")),d;var a=f(n,e.iterator,t.arg);if("throw"===a.type)return t.method="throw",t.arg=a.arg,t.delegate=null,d;var i=a.arg;return i?i.done?(t[e.resultName]=i.value,t.next=e.nextLoc,"return"!==t.method&&(t.method="next",t.arg=void 0),t.delegate=null,d):i:(t.method="throw",t.arg=new TypeError("iterator result is not an object"),t.delegate=null,d)}function P(e){var t={tryLoc:e[0]};1 in e&&(t.catchLoc=e[1]),2 in e&&(t.finallyLoc=e[2],t.afterLoc=e[3]),this.tryEntries.push(t)}function C(e){var t=e.completion||{};t.type="normal",delete t.arg,e.completion=t}function A(e){this.tryEntries=[{tryLoc:"root"}],e.forEach(P,this),this.reset(!0)}function T(e){if(e){var t=e[l];if(t)return t.call(e);if("function"==typeof e.next)return e;if(!isNaN(e.length)){var r=-1,n=function t(){for(;++r<e.length;)if(i.call(e,r))return t.value=e[r],t.done=!1,t;return t.value=void 0,t.done=!0,t};return n.next=n}}return{next:M}}function M(){return{value:void 0,done:!0}}return g.prototype=y,s(x,"constructor",{value:y,configurable:!0}),s(y,"constructor",{value:g,configurable:!0}),g.displayName=h(y,c,"GeneratorFunction"),t.isGeneratorFunction=function(e){var t="function"==typeof e&&e.constructor;return!!t&&(t===g||"GeneratorFunction"===(t.displayName||t.name))},t.mark=function(e){return Object.setPrototypeOf?Object.setPrototypeOf(e,y):(e.__proto__=y,h(e,c,"GeneratorFunction")),e.prototype=Object.create(x),e},t.awrap=function(e){return{__await:e}},S(w.prototype),h(w.prototype,u,(function(){return this})),t.AsyncIterator=w,t.async=function(e,r,n,a,i){void 0===i&&(i=Promise);var s=new w(p(e,r,n,a),i);return t.isGeneratorFunction(r)?s:s.next().then((function(e){return e.done?e.value:s.next()}))},S(x),h(x,c,"Generator"),h(x,l,(function(){return this})),h(x,"toString",(function(){return"[object Generator]"})),t.keys=function(e){var t=Object(e),r=[];for(var n in t)r.push(n);return r.reverse(),function e(){for(;r.length;){var n=r.pop();if(n in t)return e.value=n,e.done=!1,e}return e.done=!0,e}},t.values=T,A.prototype={constructor:A,reset:function(e){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(C),!e)for(var t in this)"t"===t.charAt(0)&&i.call(this,t)&&!isNaN(+t.slice(1))&&(this[t]=void 0)},stop:function(){this.done=!0;var e=this.tryEntries[0].completion;if("throw"===e.type)throw e.arg;return this.rval},dispatchException:function(e){if(this.done)throw e;var t=this;function r(r,n){return s.type="throw",s.arg=e,t.next=r,n&&(t.method="next",t.arg=void 0),!!n}for(var n=this.tryEntries.length-1;n>=0;--n){var a=this.tryEntries[n],s=a.completion;if("root"===a.tryLoc)return r("end");if(a.tryLoc<=this.prev){var o=i.call(a,"catchLoc"),l=i.call(a,"finallyLoc");if(o&&l){if(this.prev<a.catchLoc)return r(a.catchLoc,!0);if(this.prev<a.finallyLoc)return r(a.finallyLoc)}else if(o){if(this.prev<a.catchLoc)return r(a.catchLoc,!0)}else{if(!l)throw new Error("try statement without catch or finally");if(this.prev<a.finallyLoc)return r(a.finallyLoc)}}}},abrupt:function(e,t){for(var r=this.tryEntries.length-1;r>=0;--r){var n=this.tryEntries[r];if(n.tryLoc<=this.prev&&i.call(n,"finallyLoc")&&this.prev<n.finallyLoc){var a=n;break}}a&&("break"===e||"continue"===e)&&a.tryLoc<=t&&t<=a.finallyLoc&&(a=null);var s=a?a.completion:{};return s.type=e,s.arg=t,a?(this.method="next",this.next=a.finallyLoc,d):this.complete(s)},complete:function(e,t){if("throw"===e.type)throw e.arg;return"break"===e.type||"continue"===e.type?this.next=e.arg:"return"===e.type?(this.rval=this.arg=e.arg,this.method="return",this.next="end"):"normal"===e.type&&t&&(this.next=t),d},finish:function(e){for(var t=this.tryEntries.length-1;t>=0;--t){var r=this.tryEntries[t];if(r.finallyLoc===e)return this.complete(r.completion,r.afterLoc),C(r),d}},catch:function(e){for(var t=this.tryEntries.length-1;t>=0;--t){var r=this.tryEntries[t];if(r.tryLoc===e){var n=r.completion;if("throw"===n.type){var a=n.arg;C(r)}return a}}throw new Error("illegal catch attempt")},delegateYield:function(e,t,r){return this.delegate={iterator:T(e),resultName:t,nextLoc:r},"next"===this.method&&(this.arg=void 0),d}},t}e.exports=a,e.exports.__esModule=!0,e.exports.default=e.exports},8698:e=>{function t(r){return e.exports=t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},e.exports.__esModule=!0,e.exports.default=e.exports,t(r)}e.exports=t,e.exports.__esModule=!0,e.exports.default=e.exports},4687:(e,t,r)=>{var n=r(7061)();e.exports=n;try{regeneratorRuntime=n}catch(e){"object"==typeof globalThis?globalThis.regeneratorRuntime=n:Function("r","regeneratorRuntime = r")(n)}}},__webpack_module_cache__={};function __webpack_require__(e){var t=__webpack_module_cache__[e];if(void 0!==t)return t.exports;var r=__webpack_module_cache__[e]={id:e,exports:{}};return __webpack_modules__[e].call(r.exports,r,r.exports,__webpack_require__),r.exports}__webpack_require__.m=__webpack_modules__,__webpack_require__.amdO={},__webpack_require__.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=(e,t)=>{for(var r in t)__webpack_require__.o(t,r)&&!__webpack_require__.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),(()=>{var e;__webpack_require__.g.importScripts&&(e=__webpack_require__.g.location+"");var t=__webpack_require__.g.document;if(!e&&t&&(t.currentScript&&(e=t.currentScript.src),!e)){var r=t.getElementsByTagName("script");r.length&&(e=r[r.length-1].src)}if(!e)throw new Error("Automatic publicPath is not supported in this browser");e=e.replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),__webpack_require__.p=e})(),__webpack_require__.b=document.baseURI||self.location.href;var __webpack_exports__={};(()=>{"use strict";function e(e,t,r,n,a,i,s){try{var o=e[i](s),l=o.value}catch(e){return void r(e)}o.done?t(l):Promise.resolve(l).then(n,a)}function t(t){return function(){var r=this,n=arguments;return new Promise((function(a,i){var s=t.apply(r,n);function o(t){e(s,a,i,o,l,"next",t)}function l(t){e(s,a,i,o,l,"throw",t)}o(void 0)}))}}function r(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function n(e){return n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},n(e)}function a(e){var t=function(e,t){if("object"!==n(e)||null===e)return e;var r=e[Symbol.toPrimitive];if(void 0!==r){var a=r.call(e,t||"default");if("object"!==n(a))return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"===n(t)?t:String(t)}function i(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,a(n.key),n)}}function s(e,t,r){return t&&i(e.prototype,t),r&&i(e,r),Object.defineProperty(e,"prototype",{writable:!1}),e}function o(e,t){return o=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e},o(e,t)}function l(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&o(e,t)}function u(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function c(e,t){if(t&&("object"===n(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return u(e)}function h(e){return h=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)},h(e)}function p(e){if(Array.isArray(e))return e}function f(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}function d(e,t){if(e){if("string"==typeof e)return f(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);return"Object"===r&&e.constructor&&(r=e.constructor.name),"Map"===r||"Set"===r?Array.from(e):"Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r)?f(e,t):void 0}}function m(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function g(e,t){return p(e)||function(e,t){var r=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=r){var n,a,i,s,o=[],l=!0,u=!1;try{if(i=(r=r.call(e)).next,0===t){if(Object(r)!==r)return;l=!1}else for(;!(l=(n=i.call(r)).done)&&(o.push(n.value),o.length!==t);l=!0);}catch(e){u=!0,a=e}finally{try{if(!l&&null!=r.return&&(s=r.return(),Object(s)!==s))return}finally{if(u)throw a}}return o}}(e,t)||d(e,t)||m()}__webpack_require__.d(__webpack_exports__,{W:()=>ii});var y=__webpack_require__(4687),v=__webpack_require__.n(y),b=__webpack_require__(7294),k=__webpack_require__(745);function x(e,t,r){return(t=a(t))in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}function S(e){return p(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||d(e)||m()}function w(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,n)}return r}function E(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?w(Object(r),!0).forEach((function(t){x(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):w(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}var _={type:"logger",log:function(e){this.output("log",e)},warn:function(e){this.output("warn",e)},error:function(e){this.output("error",e)},output:function(e,t){console&&console[e]&&console[e].apply(console,t)}},P=function(){function e(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};r(this,e),this.init(t,n)}return s(e,[{key:"init",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.prefix=t.prefix||"i18next:",this.logger=e||_,this.options=t,this.debug=t.debug}},{key:"setDebug",value:function(e){this.debug=e}},{key:"log",value:function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return this.forward(t,"log","",!0)}},{key:"warn",value:function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return this.forward(t,"warn","",!0)}},{key:"error",value:function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return this.forward(t,"error","")}},{key:"deprecate",value:function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return this.forward(t,"warn","WARNING DEPRECATED: ",!0)}},{key:"forward",value:function(e,t,r,n){return n&&!this.debug?null:("string"==typeof e[0]&&(e[0]="".concat(r).concat(this.prefix," ").concat(e[0])),this.logger[t](e))}},{key:"create",value:function(t){return new e(this.logger,E(E({},{prefix:"".concat(this.prefix,":").concat(t,":")}),this.options))}},{key:"clone",value:function(t){return(t=t||this.options).prefix=t.prefix||this.prefix,new e(this.logger,t)}}]),e}(),C=new P,A=function(){function e(){r(this,e),this.observers={}}return s(e,[{key:"on",value:function(e,t){var r=this;return e.split(" ").forEach((function(e){r.observers[e]=r.observers[e]||[],r.observers[e].push(t)})),this}},{key:"off",value:function(e,t){this.observers[e]&&(t?this.observers[e]=this.observers[e].filter((function(e){return e!==t})):delete this.observers[e])}},{key:"emit",value:function(e){for(var t=arguments.length,r=new Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];this.observers[e]&&[].concat(this.observers[e]).forEach((function(e){e.apply(void 0,r)}));this.observers["*"]&&[].concat(this.observers["*"]).forEach((function(t){t.apply(t,[e].concat(r))}))}}]),e}();function T(){var e,t,r=new Promise((function(r,n){e=r,t=n}));return r.resolve=e,r.reject=t,r}function M(e){return null==e?"":""+e}function D(e,t,r){function n(e){return e&&e.indexOf("###")>-1?e.replace(/###/g,"."):e}function a(){return!e||"string"==typeof e}for(var i="string"!=typeof t?[].concat(t):t.split(".");i.length>1;){if(a())return{};var s=n(i.shift());!e[s]&&r&&(e[s]=new r),e=Object.prototype.hasOwnProperty.call(e,s)?e[s]:{}}return a()?{}:{obj:e,k:n(i.shift())}}function I(e,t,r){var n=D(e,t,Object);n.obj[n.k]=r}function F(e,t){var r=D(e,t),n=r.obj,a=r.k;if(n)return n[a]}function O(e,t,r){var n=F(e,r);return void 0!==n?n:F(t,r)}function R(e,t,r){for(var n in t)"__proto__"!==n&&"constructor"!==n&&(n in e?"string"==typeof e[n]||e[n]instanceof String||"string"==typeof t[n]||t[n]instanceof String?r&&(e[n]=t[n]):R(e[n],t[n],r):e[n]=t[n]);return e}function L(e){return e.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")}var N={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};function V(e){return"string"==typeof e?e.replace(/[&<>"'\/]/g,(function(e){return N[e]})):e}var z="undefined"!=typeof window&&window.navigator&&void 0===window.navigator.userAgentData&&window.navigator.userAgent&&window.navigator.userAgent.indexOf("MSIE")>-1,B=[" ",",","?","!",";"];function j(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,n)}return r}function G(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?j(Object(r),!0).forEach((function(t){x(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):j(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}function H(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var r,n=h(e);if(t){var a=h(this).constructor;r=Reflect.construct(n,arguments,a)}else r=n.apply(this,arguments);return c(this,r)}}function q(e,t){var r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:".";if(e){if(e[t])return e[t];for(var n=t.split(r),a=e,i=0;i<n.length;++i){if(!a)return;if("string"==typeof a[n[i]]&&i+1<n.length)return;if(void 0===a[n[i]]){for(var s=2,o=n.slice(i,i+s).join(r),l=a[o];void 0===l&&n.length>i+s;)s++,l=a[o=n.slice(i,i+s).join(r)];if(void 0===l)return;if(null===l)return null;if(t.endsWith(o)){if("string"==typeof l)return l;if(o&&"string"==typeof l[o])return l[o]}var u=n.slice(i+s).join(r);return u?q(l,u,r):void 0}a=a[n[i]]}return a}}var U=function(e){l(n,e);var t=H(n);function n(e){var a,i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{ns:["translation"],defaultNS:"translation"};return r(this,n),a=t.call(this),z&&A.call(u(a)),a.data=e||{},a.options=i,void 0===a.options.keySeparator&&(a.options.keySeparator="."),void 0===a.options.ignoreJSONStructure&&(a.options.ignoreJSONStructure=!0),a}return s(n,[{key:"addNamespaces",value:function(e){this.options.ns.indexOf(e)<0&&this.options.ns.push(e)}},{key:"removeNamespaces",value:function(e){var t=this.options.ns.indexOf(e);t>-1&&this.options.ns.splice(t,1)}},{key:"getResource",value:function(e,t,r){var n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},a=void 0!==n.keySeparator?n.keySeparator:this.options.keySeparator,i=void 0!==n.ignoreJSONStructure?n.ignoreJSONStructure:this.options.ignoreJSONStructure,s=[e,t];r&&"string"!=typeof r&&(s=s.concat(r)),r&&"string"==typeof r&&(s=s.concat(a?r.split(a):r)),e.indexOf(".")>-1&&(s=e.split("."));var o=F(this.data,s);return o||!i||"string"!=typeof r?o:q(this.data&&this.data[e]&&this.data[e][t],r,a)}},{key:"addResource",value:function(e,t,r,n){var a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:{silent:!1},i=this.options.keySeparator;void 0===i&&(i=".");var s=[e,t];r&&(s=s.concat(i?r.split(i):r)),e.indexOf(".")>-1&&(n=t,t=(s=e.split("."))[1]),this.addNamespaces(t),I(this.data,s,n),a.silent||this.emit("added",e,t,r,n)}},{key:"addResources",value:function(e,t,r){var n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{silent:!1};for(var a in r)"string"!=typeof r[a]&&"[object Array]"!==Object.prototype.toString.apply(r[a])||this.addResource(e,t,a,r[a],{silent:!0});n.silent||this.emit("added",e,t,r)}},{key:"addResourceBundle",value:function(e,t,r,n,a){var i=arguments.length>5&&void 0!==arguments[5]?arguments[5]:{silent:!1},s=[e,t];e.indexOf(".")>-1&&(n=r,r=t,t=(s=e.split("."))[1]),this.addNamespaces(t);var o=F(this.data,s)||{};n?R(o,r,a):o=G(G({},o),r),I(this.data,s,o),i.silent||this.emit("added",e,t,r)}},{key:"removeResourceBundle",value:function(e,t){this.hasResourceBundle(e,t)&&delete this.data[e][t],this.removeNamespaces(t),this.emit("removed",e,t)}},{key:"hasResourceBundle",value:function(e,t){return void 0!==this.getResource(e,t)}},{key:"getResourceBundle",value:function(e,t){return t||(t=this.options.defaultNS),"v1"===this.options.compatibilityAPI?G(G({},{}),this.getResource(e,t)):this.getResource(e,t)}},{key:"getDataByLanguage",value:function(e){return this.data[e]}},{key:"hasLanguageSomeTranslations",value:function(e){var t=this.getDataByLanguage(e);return!!(t&&Object.keys(t)||[]).find((function(e){return t[e]&&Object.keys(t[e]).length>0}))}},{key:"toJSON",value:function(){return this.data}}]),n}(A),W={processors:{},addPostProcessor:function(e){this.processors[e.name]=e},handle:function(e,t,r,n,a){var i=this;return e.forEach((function(e){i.processors[e]&&(t=i.processors[e].process(t,r,n,a))})),t}};function $(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,n)}return r}function K(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?$(Object(r),!0).forEach((function(t){x(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):$(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}function J(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var r,n=h(e);if(t){var a=h(this).constructor;r=Reflect.construct(n,arguments,a)}else r=n.apply(this,arguments);return c(this,r)}}var Y={},Q=function(e){l(a,e);var t=J(a);function a(e){var n,i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return r(this,a),n=t.call(this),z&&A.call(u(n)),function(e,t,r){e.forEach((function(e){t[e]&&(r[e]=t[e])}))}(["resourceStore","languageUtils","pluralResolver","interpolator","backendConnector","i18nFormat","utils"],e,u(n)),n.options=i,void 0===n.options.keySeparator&&(n.options.keySeparator="."),n.logger=C.create("translator"),n}return s(a,[{key:"changeLanguage",value:function(e){e&&(this.language=e)}},{key:"exists",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{interpolation:{}};if(null==e)return!1;var r=this.resolve(e,t);return r&&void 0!==r.res}},{key:"extractFromKey",value:function(e,t){var r=void 0!==t.nsSeparator?t.nsSeparator:this.options.nsSeparator;void 0===r&&(r=":");var n=void 0!==t.keySeparator?t.keySeparator:this.options.keySeparator,a=t.ns||this.options.defaultNS||[],i=r&&e.indexOf(r)>-1,s=!(this.options.userDefinedKeySeparator||t.keySeparator||this.options.userDefinedNsSeparator||t.nsSeparator||function(e,t,r){t=t||"",r=r||"";var n=B.filter((function(e){return t.indexOf(e)<0&&r.indexOf(e)<0}));if(0===n.length)return!0;var a=new RegExp("(".concat(n.map((function(e){return"?"===e?"\\?":e})).join("|"),")")),i=!a.test(e);if(!i){var s=e.indexOf(r);s>0&&!a.test(e.substring(0,s))&&(i=!0)}return i}(e,r,n));if(i&&!s){var o=e.match(this.interpolator.nestingRegexp);if(o&&o.length>0)return{key:e,namespaces:a};var l=e.split(r);(r!==n||r===n&&this.options.ns.indexOf(l[0])>-1)&&(a=l.shift()),e=l.join(n)}return"string"==typeof a&&(a=[a]),{key:e,namespaces:a}}},{key:"translate",value:function(e,t,r){var i=this;if("object"!==n(t)&&this.options.overloadTranslationOptionHandler&&(t=this.options.overloadTranslationOptionHandler(arguments)),t||(t={}),null==e)return"";Array.isArray(e)||(e=[String(e)]);var s=void 0!==t.returnDetails?t.returnDetails:this.options.returnDetails,o=void 0!==t.keySeparator?t.keySeparator:this.options.keySeparator,l=this.extractFromKey(e[e.length-1],t),u=l.key,c=l.namespaces,h=c[c.length-1],p=t.lng||this.language,f=t.appendNamespaceToCIMode||this.options.appendNamespaceToCIMode;if(p&&"cimode"===p.toLowerCase()){if(f){var d=t.nsSeparator||this.options.nsSeparator;return s?(m.res="".concat(h).concat(d).concat(u),m):"".concat(h).concat(d).concat(u)}return s?(m.res=u,m):u}var m=this.resolve(e,t),g=m&&m.res,y=m&&m.usedKey||u,v=m&&m.exactUsedKey||u,b=Object.prototype.toString.apply(g),k=void 0!==t.joinArrays?t.joinArrays:this.options.joinArrays,x=!this.i18nFormat||this.i18nFormat.handleAsObject;if(x&&g&&("string"!=typeof g&&"boolean"!=typeof g&&"number"!=typeof g)&&["[object Number]","[object Function]","[object RegExp]"].indexOf(b)<0&&("string"!=typeof k||"[object Array]"!==b)){if(!t.returnObjects&&!this.options.returnObjects){this.options.returnedObjectHandler||this.logger.warn("accessing an object - but returnObjects options is not enabled!");var S=this.options.returnedObjectHandler?this.options.returnedObjectHandler(y,g,K(K({},t),{},{ns:c})):"key '".concat(u," (").concat(this.language,")' returned an object instead of string.");return s?(m.res=S,m):S}if(o){var w="[object Array]"===b,E=w?[]:{},_=w?v:y;for(var P in g)if(Object.prototype.hasOwnProperty.call(g,P)){var C="".concat(_).concat(o).concat(P);E[P]=this.translate(C,K(K({},t),{joinArrays:!1,ns:c})),E[P]===C&&(E[P]=g[P])}g=E}}else if(x&&"string"==typeof k&&"[object Array]"===b)(g=g.join(k))&&(g=this.extendTranslation(g,e,t,r));else{var A=!1,T=!1,M=void 0!==t.count&&"string"!=typeof t.count,D=a.hasDefaultValue(t),I=M?this.pluralResolver.getSuffix(p,t.count,t):"",F=t["defaultValue".concat(I)]||t.defaultValue;!this.isValidLookup(g)&&D&&(A=!0,g=F),this.isValidLookup(g)||(T=!0,g=u);var O=(t.missingKeyNoValueFallbackToKey||this.options.missingKeyNoValueFallbackToKey)&&T?void 0:g,R=D&&F!==g&&this.options.updateMissing;if(T||A||R){if(this.logger.log(R?"updateKey":"missingKey",p,h,u,R?F:g),o){var L=this.resolve(u,K(K({},t),{},{keySeparator:!1}));L&&L.res&&this.logger.warn("Seems the loaded translations were in flat JSON format instead of nested. Either set keySeparator: false on init or make sure your translations are published in nested format.")}var N=[],V=this.languageUtils.getFallbackCodes(this.options.fallbackLng,t.lng||this.language);if("fallback"===this.options.saveMissingTo&&V&&V[0])for(var z=0;z<V.length;z++)N.push(V[z]);else"all"===this.options.saveMissingTo?N=this.languageUtils.toResolveHierarchy(t.lng||this.language):N.push(t.lng||this.language);var B=function(e,r,n){var a=D&&n!==g?n:O;i.options.missingKeyHandler?i.options.missingKeyHandler(e,h,r,a,R,t):i.backendConnector&&i.backendConnector.saveMissing&&i.backendConnector.saveMissing(e,h,r,a,R,t),i.emit("missingKey",e,h,r,g)};this.options.saveMissing&&(this.options.saveMissingPlurals&&M?N.forEach((function(e){i.pluralResolver.getSuffixes(e,t).forEach((function(r){B([e],u+r,t["defaultValue".concat(r)]||F)}))})):B(N,u,F))}g=this.extendTranslation(g,e,t,m,r),T&&g===u&&this.options.appendNamespaceToMissingKey&&(g="".concat(h,":").concat(u)),(T||A)&&this.options.parseMissingKeyHandler&&(g="v1"!==this.options.compatibilityAPI?this.options.parseMissingKeyHandler(this.options.appendNamespaceToMissingKey?"".concat(h,":").concat(u):u,A?g:void 0):this.options.parseMissingKeyHandler(g))}return s?(m.res=g,m):g}},{key:"extendTranslation",value:function(e,t,r,n,a){var i=this;if(this.i18nFormat&&this.i18nFormat.parse)e=this.i18nFormat.parse(e,K(K({},this.options.interpolation.defaultVariables),r),n.usedLng,n.usedNS,n.usedKey,{resolved:n});else if(!r.skipInterpolation){r.interpolation&&this.interpolator.init(K(K({},r),{interpolation:K(K({},this.options.interpolation),r.interpolation)}));var s,o="string"==typeof e&&(r&&r.interpolation&&void 0!==r.interpolation.skipOnVariables?r.interpolation.skipOnVariables:this.options.interpolation.skipOnVariables);if(o){var l=e.match(this.interpolator.nestingRegexp);s=l&&l.length}var u=r.replace&&"string"!=typeof r.replace?r.replace:r;if(this.options.interpolation.defaultVariables&&(u=K(K({},this.options.interpolation.defaultVariables),u)),e=this.interpolator.interpolate(e,u,r.lng||this.language,r),o){var c=e.match(this.interpolator.nestingRegexp);s<(c&&c.length)&&(r.nest=!1)}!1!==r.nest&&(e=this.interpolator.nest(e,(function(){for(var e=arguments.length,n=new Array(e),s=0;s<e;s++)n[s]=arguments[s];return a&&a[0]===n[0]&&!r.context?(i.logger.warn("It seems you are nesting recursively key: ".concat(n[0]," in key: ").concat(t[0])),null):i.translate.apply(i,n.concat([t]))}),r)),r.interpolation&&this.interpolator.reset()}var h=r.postProcess||this.options.postProcess,p="string"==typeof h?[h]:h;return null!=e&&p&&p.length&&!1!==r.applyPostProcessor&&(e=W.handle(p,e,t,this.options&&this.options.postProcessPassResolved?K({i18nResolved:n},r):r,this)),e}},{key:"resolve",value:function(e){var t,r,n,a,i,s=this,o=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return"string"==typeof e&&(e=[e]),e.forEach((function(e){if(!s.isValidLookup(t)){var l=s.extractFromKey(e,o),u=l.key;r=u;var c=l.namespaces;s.options.fallbackNS&&(c=c.concat(s.options.fallbackNS));var h=void 0!==o.count&&"string"!=typeof o.count,p=h&&!o.ordinal&&0===o.count&&s.pluralResolver.shouldUseIntlApi(),f=void 0!==o.context&&("string"==typeof o.context||"number"==typeof o.context)&&""!==o.context,d=o.lngs?o.lngs:s.languageUtils.toResolveHierarchy(o.lng||s.language,o.fallbackLng);c.forEach((function(e){s.isValidLookup(t)||(i=e,!Y["".concat(d[0],"-").concat(e)]&&s.utils&&s.utils.hasLoadedNamespace&&!s.utils.hasLoadedNamespace(i)&&(Y["".concat(d[0],"-").concat(e)]=!0,s.logger.warn('key "'.concat(r,'" for languages "').concat(d.join(", "),'" won\'t get resolved as namespace "').concat(i,'" was not yet loaded'),"This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!")),d.forEach((function(r){if(!s.isValidLookup(t)){a=r;var i,l=[u];if(s.i18nFormat&&s.i18nFormat.addLookupKeys)s.i18nFormat.addLookupKeys(l,u,r,e,o);else{var c;h&&(c=s.pluralResolver.getSuffix(r,o.count,o));var d="".concat(s.options.pluralSeparator,"zero");if(h&&(l.push(u+c),p&&l.push(u+d)),f){var m="".concat(u).concat(s.options.contextSeparator).concat(o.context);l.push(m),h&&(l.push(m+c),p&&l.push(m+d))}}for(;i=l.pop();)s.isValidLookup(t)||(n=i,t=s.getResource(r,e,i,o))}})))}))}})),{res:t,usedKey:r,exactUsedKey:n,usedLng:a,usedNS:i}}},{key:"isValidLookup",value:function(e){return!(void 0===e||!this.options.returnNull&&null===e||!this.options.returnEmptyString&&""===e)}},{key:"getResource",value:function(e,t,r){var n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};return this.i18nFormat&&this.i18nFormat.getResource?this.i18nFormat.getResource(e,t,r,n):this.resourceStore.getResource(e,t,r,n)}}],[{key:"hasDefaultValue",value:function(e){var t="defaultValue";for(var r in e)if(Object.prototype.hasOwnProperty.call(e,r)&&t===r.substring(0,t.length)&&void 0!==e[r])return!0;return!1}}]),a}(A);function X(e){return e.charAt(0).toUpperCase()+e.slice(1)}var Z=function(){function e(t){r(this,e),this.options=t,this.supportedLngs=this.options.supportedLngs||!1,this.logger=C.create("languageUtils")}return s(e,[{key:"getScriptPartFromCode",value:function(e){if(!e||e.indexOf("-")<0)return null;var t=e.split("-");return 2===t.length?null:(t.pop(),"x"===t[t.length-1].toLowerCase()?null:this.formatLanguageCode(t.join("-")))}},{key:"getLanguagePartFromCode",value:function(e){if(!e||e.indexOf("-")<0)return e;var t=e.split("-");return this.formatLanguageCode(t[0])}},{key:"formatLanguageCode",value:function(e){if("string"==typeof e&&e.indexOf("-")>-1){var t=["hans","hant","latn","cyrl","cans","mong","arab"],r=e.split("-");return this.options.lowerCaseLng?r=r.map((function(e){return e.toLowerCase()})):2===r.length?(r[0]=r[0].toLowerCase(),r[1]=r[1].toUpperCase(),t.indexOf(r[1].toLowerCase())>-1&&(r[1]=X(r[1].toLowerCase()))):3===r.length&&(r[0]=r[0].toLowerCase(),2===r[1].length&&(r[1]=r[1].toUpperCase()),"sgn"!==r[0]&&2===r[2].length&&(r[2]=r[2].toUpperCase()),t.indexOf(r[1].toLowerCase())>-1&&(r[1]=X(r[1].toLowerCase())),t.indexOf(r[2].toLowerCase())>-1&&(r[2]=X(r[2].toLowerCase()))),r.join("-")}return this.options.cleanCode||this.options.lowerCaseLng?e.toLowerCase():e}},{key:"isSupportedCode",value:function(e){return("languageOnly"===this.options.load||this.options.nonExplicitSupportedLngs)&&(e=this.getLanguagePartFromCode(e)),!this.supportedLngs||!this.supportedLngs.length||this.supportedLngs.indexOf(e)>-1}},{key:"getBestMatchFromCodes",value:function(e){var t,r=this;return e?(e.forEach((function(e){if(!t){var n=r.formatLanguageCode(e);r.options.supportedLngs&&!r.isSupportedCode(n)||(t=n)}})),!t&&this.options.supportedLngs&&e.forEach((function(e){if(!t){var n=r.getLanguagePartFromCode(e);if(r.isSupportedCode(n))return t=n;t=r.options.supportedLngs.find((function(e){if(0===e.indexOf(n))return e}))}})),t||(t=this.getFallbackCodes(this.options.fallbackLng)[0]),t):null}},{key:"getFallbackCodes",value:function(e,t){if(!e)return[];if("function"==typeof e&&(e=e(t)),"string"==typeof e&&(e=[e]),"[object Array]"===Object.prototype.toString.apply(e))return e;if(!t)return e.default||[];var r=e[t];return r||(r=e[this.getScriptPartFromCode(t)]),r||(r=e[this.formatLanguageCode(t)]),r||(r=e[this.getLanguagePartFromCode(t)]),r||(r=e.default),r||[]}},{key:"toResolveHierarchy",value:function(e,t){var r=this,n=this.getFallbackCodes(t||this.options.fallbackLng||[],e),a=[],i=function(e){e&&(r.isSupportedCode(e)?a.push(e):r.logger.warn("rejecting language code not found in supportedLngs: ".concat(e)))};return"string"==typeof e&&e.indexOf("-")>-1?("languageOnly"!==this.options.load&&i(this.formatLanguageCode(e)),"languageOnly"!==this.options.load&&"currentOnly"!==this.options.load&&i(this.getScriptPartFromCode(e)),"currentOnly"!==this.options.load&&i(this.getLanguagePartFromCode(e))):"string"==typeof e&&i(this.formatLanguageCode(e)),n.forEach((function(e){a.indexOf(e)<0&&i(r.formatLanguageCode(e))})),a}}]),e}(),ee=[{lngs:["ach","ak","am","arn","br","fil","gun","ln","mfe","mg","mi","oc","pt","pt-BR","tg","tl","ti","tr","uz","wa"],nr:[1,2],fc:1},{lngs:["af","an","ast","az","bg","bn","ca","da","de","dev","el","en","eo","es","et","eu","fi","fo","fur","fy","gl","gu","ha","hi","hu","hy","ia","it","kk","kn","ku","lb","mai","ml","mn","mr","nah","nap","nb","ne","nl","nn","no","nso","pa","pap","pms","ps","pt-PT","rm","sco","se","si","so","son","sq","sv","sw","ta","te","tk","ur","yo"],nr:[1,2],fc:2},{lngs:["ay","bo","cgg","fa","ht","id","ja","jbo","ka","km","ko","ky","lo","ms","sah","su","th","tt","ug","vi","wo","zh"],nr:[1],fc:3},{lngs:["be","bs","cnr","dz","hr","ru","sr","uk"],nr:[1,2,5],fc:4},{lngs:["ar"],nr:[0,1,2,3,11,100],fc:5},{lngs:["cs","sk"],nr:[1,2,5],fc:6},{lngs:["csb","pl"],nr:[1,2,5],fc:7},{lngs:["cy"],nr:[1,2,3,8],fc:8},{lngs:["fr"],nr:[1,2],fc:9},{lngs:["ga"],nr:[1,2,3,7,11],fc:10},{lngs:["gd"],nr:[1,2,3,20],fc:11},{lngs:["is"],nr:[1,2],fc:12},{lngs:["jv"],nr:[0,1],fc:13},{lngs:["kw"],nr:[1,2,3,4],fc:14},{lngs:["lt"],nr:[1,2,10],fc:15},{lngs:["lv"],nr:[1,2,0],fc:16},{lngs:["mk"],nr:[1,2],fc:17},{lngs:["mnk"],nr:[0,1,2],fc:18},{lngs:["mt"],nr:[1,2,11,20],fc:19},{lngs:["or"],nr:[2,1],fc:2},{lngs:["ro"],nr:[1,2,20],fc:20},{lngs:["sl"],nr:[5,1,2,3],fc:21},{lngs:["he","iw"],nr:[1,2,20,21],fc:22}],te={1:function(e){return Number(e>1)},2:function(e){return Number(1!=e)},3:function(e){return 0},4:function(e){return Number(e%10==1&&e%100!=11?0:e%10>=2&&e%10<=4&&(e%100<10||e%100>=20)?1:2)},5:function(e){return Number(0==e?0:1==e?1:2==e?2:e%100>=3&&e%100<=10?3:e%100>=11?4:5)},6:function(e){return Number(1==e?0:e>=2&&e<=4?1:2)},7:function(e){return Number(1==e?0:e%10>=2&&e%10<=4&&(e%100<10||e%100>=20)?1:2)},8:function(e){return Number(1==e?0:2==e?1:8!=e&&11!=e?2:3)},9:function(e){return Number(e>=2)},10:function(e){return Number(1==e?0:2==e?1:e<7?2:e<11?3:4)},11:function(e){return Number(1==e||11==e?0:2==e||12==e?1:e>2&&e<20?2:3)},12:function(e){return Number(e%10!=1||e%100==11)},13:function(e){return Number(0!==e)},14:function(e){return Number(1==e?0:2==e?1:3==e?2:3)},15:function(e){return Number(e%10==1&&e%100!=11?0:e%10>=2&&(e%100<10||e%100>=20)?1:2)},16:function(e){return Number(e%10==1&&e%100!=11?0:0!==e?1:2)},17:function(e){return Number(1==e||e%10==1&&e%100!=11?0:1)},18:function(e){return Number(0==e?0:1==e?1:2)},19:function(e){return Number(1==e?0:0==e||e%100>1&&e%100<11?1:e%100>10&&e%100<20?2:3)},20:function(e){return Number(1==e?0:0==e||e%100>0&&e%100<20?1:2)},21:function(e){return Number(e%100==1?1:e%100==2?2:e%100==3||e%100==4?3:0)},22:function(e){return Number(1==e?0:2==e?1:(e<0||e>10)&&e%10==0?2:3)}},re=["v1","v2","v3"],ne={zero:0,one:1,two:2,few:3,many:4,other:5};var ae=function(){function e(t){var n,a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};r(this,e),this.languageUtils=t,this.options=a,this.logger=C.create("pluralResolver"),this.options.compatibilityJSON&&"v4"!==this.options.compatibilityJSON||"undefined"!=typeof Intl&&Intl.PluralRules||(this.options.compatibilityJSON="v3",this.logger.error("Your environment seems not to be Intl API compatible, use an Intl.PluralRules polyfill. Will fallback to the compatibilityJSON v3 format handling.")),this.rules=(n={},ee.forEach((function(e){e.lngs.forEach((function(t){n[t]={numbers:e.nr,plurals:te[e.fc]}}))})),n)}return s(e,[{key:"addRule",value:function(e,t){this.rules[e]=t}},{key:"getRule",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(this.shouldUseIntlApi())try{return new Intl.PluralRules(e,{type:t.ordinal?"ordinal":"cardinal"})}catch(e){return}return this.rules[e]||this.rules[this.languageUtils.getLanguagePartFromCode(e)]}},{key:"needsPlural",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=this.getRule(e,t);return this.shouldUseIntlApi()?r&&r.resolvedOptions().pluralCategories.length>1:r&&r.numbers.length>1}},{key:"getPluralFormsOfKey",value:function(e,t){var r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};return this.getSuffixes(e,r).map((function(e){return"".concat(t).concat(e)}))}},{key:"getSuffixes",value:function(e){var t=this,r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.getRule(e,r);return n?this.shouldUseIntlApi()?n.resolvedOptions().pluralCategories.sort((function(e,t){return ne[e]-ne[t]})).map((function(e){return"".concat(t.options.prepend).concat(e)})):n.numbers.map((function(n){return t.getSuffix(e,n,r)})):[]}},{key:"getSuffix",value:function(e,t){var r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},n=this.getRule(e,r);return n?this.shouldUseIntlApi()?"".concat(this.options.prepend).concat(n.select(t)):this.getSuffixRetroCompatible(n,t):(this.logger.warn("no plural rule found for: ".concat(e)),"")}},{key:"getSuffixRetroCompatible",value:function(e,t){var r=this,n=e.noAbs?e.plurals(t):e.plurals(Math.abs(t)),a=e.numbers[n];this.options.simplifyPluralSuffix&&2===e.numbers.length&&1===e.numbers[0]&&(2===a?a="plural":1===a&&(a=""));var i=function(){return r.options.prepend&&a.toString()?r.options.prepend+a.toString():a.toString()};return"v1"===this.options.compatibilityJSON?1===a?"":"number"==typeof a?"_plural_".concat(a.toString()):i():"v2"===this.options.compatibilityJSON||this.options.simplifyPluralSuffix&&2===e.numbers.length&&1===e.numbers[0]?i():this.options.prepend&&n.toString()?this.options.prepend+n.toString():n.toString()}},{key:"shouldUseIntlApi",value:function(){return!re.includes(this.options.compatibilityJSON)}}]),e}();function ie(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,n)}return r}function se(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?ie(Object(r),!0).forEach((function(t){x(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):ie(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}var oe=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};r(this,e),this.logger=C.create("interpolator"),this.options=t,this.format=t.interpolation&&t.interpolation.format||function(e){return e},this.init(t)}return s(e,[{key:"init",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};e.interpolation||(e.interpolation={escapeValue:!0});var t=e.interpolation;this.escape=void 0!==t.escape?t.escape:V,this.escapeValue=void 0===t.escapeValue||t.escapeValue,this.useRawValueToEscape=void 0!==t.useRawValueToEscape&&t.useRawValueToEscape,this.prefix=t.prefix?L(t.prefix):t.prefixEscaped||"{{",this.suffix=t.suffix?L(t.suffix):t.suffixEscaped||"}}",this.formatSeparator=t.formatSeparator?t.formatSeparator:t.formatSeparator||",",this.unescapePrefix=t.unescapeSuffix?"":t.unescapePrefix||"-",this.unescapeSuffix=this.unescapePrefix?"":t.unescapeSuffix||"",this.nestingPrefix=t.nestingPrefix?L(t.nestingPrefix):t.nestingPrefixEscaped||L("$t("),this.nestingSuffix=t.nestingSuffix?L(t.nestingSuffix):t.nestingSuffixEscaped||L(")"),this.nestingOptionsSeparator=t.nestingOptionsSeparator?t.nestingOptionsSeparator:t.nestingOptionsSeparator||",",this.maxReplaces=t.maxReplaces?t.maxReplaces:1e3,this.alwaysFormat=void 0!==t.alwaysFormat&&t.alwaysFormat,this.resetRegExp()}},{key:"reset",value:function(){this.options&&this.init(this.options)}},{key:"resetRegExp",value:function(){var e="".concat(this.prefix,"(.+?)").concat(this.suffix);this.regexp=new RegExp(e,"g");var t="".concat(this.prefix).concat(this.unescapePrefix,"(.+?)").concat(this.unescapeSuffix).concat(this.suffix);this.regexpUnescape=new RegExp(t,"g");var r="".concat(this.nestingPrefix,"(.+?)").concat(this.nestingSuffix);this.nestingRegexp=new RegExp(r,"g")}},{key:"interpolate",value:function(e,t,r,n){var a,i,s,o=this,l=this.options&&this.options.interpolation&&this.options.interpolation.defaultVariables||{};function u(e){return e.replace(/\$/g,"$$$$")}var c=function(e){if(e.indexOf(o.formatSeparator)<0){var a=O(t,l,e);return o.alwaysFormat?o.format(a,void 0,r,se(se(se({},n),t),{},{interpolationkey:e})):a}var i=e.split(o.formatSeparator),s=i.shift().trim(),u=i.join(o.formatSeparator).trim();return o.format(O(t,l,s),u,r,se(se(se({},n),t),{},{interpolationkey:s}))};this.resetRegExp();var h=n&&n.missingInterpolationHandler||this.options.missingInterpolationHandler,p=n&&n.interpolation&&void 0!==n.interpolation.skipOnVariables?n.interpolation.skipOnVariables:this.options.interpolation.skipOnVariables;return[{regex:this.regexpUnescape,safeValue:function(e){return u(e)}},{regex:this.regexp,safeValue:function(e){return o.escapeValue?u(o.escape(e)):u(e)}}].forEach((function(t){for(s=0;a=t.regex.exec(e);){var r=a[1].trim();if(void 0===(i=c(r)))if("function"==typeof h){var l=h(e,a,n);i="string"==typeof l?l:""}else if(n&&n.hasOwnProperty(r))i="";else{if(p){i=a[0];continue}o.logger.warn("missed to pass in variable ".concat(r," for interpolating ").concat(e)),i=""}else"string"==typeof i||o.useRawValueToEscape||(i=M(i));var u=t.safeValue(i);if(e=e.replace(a[0],u),p?(t.regex.lastIndex+=i.length,t.regex.lastIndex-=a[0].length):t.regex.lastIndex=0,++s>=o.maxReplaces)break}})),e}},{key:"nest",value:function(e,t){var r,n,a,i=this,s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};function o(e,t){var r=this.nestingOptionsSeparator;if(e.indexOf(r)<0)return e;var n=e.split(new RegExp("".concat(r,"[ ]*{"))),i="{".concat(n[1]);e=n[0];var s=(i=this.interpolate(i,a)).match(/'/g),o=i.match(/"/g);(s&&s.length%2==0&&!o||o.length%2!=0)&&(i=i.replace(/'/g,'"'));try{a=JSON.parse(i),t&&(a=se(se({},t),a))}catch(t){return this.logger.warn("failed parsing options string in nesting for key ".concat(e),t),"".concat(e).concat(r).concat(i)}return delete a.defaultValue,e}for(;r=this.nestingRegexp.exec(e);){var l=[];(a=(a=se({},s)).replace&&"string"!=typeof a.replace?a.replace:a).applyPostProcessor=!1,delete a.defaultValue;var u=!1;if(-1!==r[0].indexOf(this.formatSeparator)&&!/{.*}/.test(r[1])){var c=r[1].split(this.formatSeparator).map((function(e){return e.trim()}));r[1]=c.shift(),l=c,u=!0}if((n=t(o.call(this,r[1].trim(),a),a))&&r[0]===e&&"string"!=typeof n)return n;"string"!=typeof n&&(n=M(n)),n||(this.logger.warn("missed to resolve ".concat(r[1]," for nesting ").concat(e)),n=""),u&&(n=l.reduce((function(e,t){return i.format(e,t,s.lng,se(se({},s),{},{interpolationkey:r[1].trim()}))}),n.trim())),e=e.replace(r[0],n),this.regexp.lastIndex=0}return e}}]),e}();function le(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,n)}return r}function ue(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?le(Object(r),!0).forEach((function(t){x(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):le(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}function ce(e){var t={};return function(r,n,a){var i=n+JSON.stringify(a),s=t[i];return s||(s=e(n,a),t[i]=s),s(r)}}var he=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};r(this,e),this.logger=C.create("formatter"),this.options=t,this.formats={number:ce((function(e,t){var r=new Intl.NumberFormat(e,t);return function(e){return r.format(e)}})),currency:ce((function(e,t){var r=new Intl.NumberFormat(e,ue(ue({},t),{},{style:"currency"}));return function(e){return r.format(e)}})),datetime:ce((function(e,t){var r=new Intl.DateTimeFormat(e,ue({},t));return function(e){return r.format(e)}})),relativetime:ce((function(e,t){var r=new Intl.RelativeTimeFormat(e,ue({},t));return function(e){return r.format(e,t.range||"day")}})),list:ce((function(e,t){var r=new Intl.ListFormat(e,ue({},t));return function(e){return r.format(e)}}))},this.init(t)}return s(e,[{key:"init",value:function(e){var t=(arguments.length>1&&void 0!==arguments[1]?arguments[1]:{interpolation:{}}).interpolation;this.formatSeparator=t.formatSeparator?t.formatSeparator:t.formatSeparator||","}},{key:"add",value:function(e,t){this.formats[e.toLowerCase().trim()]=t}},{key:"addCached",value:function(e,t){this.formats[e.toLowerCase().trim()]=ce(t)}},{key:"format",value:function(e,t,r,n){var a=this;return t.split(this.formatSeparator).reduce((function(e,t){var i=function(e){var t=e.toLowerCase().trim(),r={};if(e.indexOf("(")>-1){var n=e.split("(");t=n[0].toLowerCase().trim();var a=n[1].substring(0,n[1].length-1);"currency"===t&&a.indexOf(":")<0?r.currency||(r.currency=a.trim()):"relativetime"===t&&a.indexOf(":")<0?r.range||(r.range=a.trim()):a.split(";").forEach((function(e){if(e){var t=S(e.split(":")),n=t[0],a=t.slice(1).join(":").trim().replace(/^'+|'+$/g,"");r[n.trim()]||(r[n.trim()]=a),"false"===a&&(r[n.trim()]=!1),"true"===a&&(r[n.trim()]=!0),isNaN(a)||(r[n.trim()]=parseInt(a,10))}}))}return{formatName:t,formatOptions:r}}(t),s=i.formatName,o=i.formatOptions;if(a.formats[s]){var l=e;try{var u=n&&n.formatParams&&n.formatParams[n.interpolationkey]||{},c=u.locale||u.lng||n.locale||n.lng||r;l=a.formats[s](e,c,ue(ue(ue({},o),n),u))}catch(e){a.logger.warn(e)}return l}return a.logger.warn("there was no format function for ".concat(s)),e}),e)}}]),e}();function pe(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,n)}return r}function fe(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?pe(Object(r),!0).forEach((function(t){x(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):pe(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}function de(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var r,n=h(e);if(t){var a=h(this).constructor;r=Reflect.construct(n,arguments,a)}else r=n.apply(this,arguments);return c(this,r)}}var me=function(e){l(n,e);var t=de(n);function n(e,a,i){var s,o=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};return r(this,n),s=t.call(this),z&&A.call(u(s)),s.backend=e,s.store=a,s.services=i,s.languageUtils=i.languageUtils,s.options=o,s.logger=C.create("backendConnector"),s.waitingReads=[],s.maxParallelReads=o.maxParallelReads||10,s.readingCalls=0,s.maxRetries=o.maxRetries>=0?o.maxRetries:5,s.retryTimeout=o.retryTimeout>=1?o.retryTimeout:350,s.state={},s.queue=[],s.backend&&s.backend.init&&s.backend.init(i,o.backend,o),s}return s(n,[{key:"queueLoad",value:function(e,t,r,n){var a=this,i={},s={},o={},l={};return e.forEach((function(e){var n=!0;t.forEach((function(t){var o="".concat(e,"|").concat(t);!r.reload&&a.store.hasResourceBundle(e,t)?a.state[o]=2:a.state[o]<0||(1===a.state[o]?void 0===s[o]&&(s[o]=!0):(a.state[o]=1,n=!1,void 0===s[o]&&(s[o]=!0),void 0===i[o]&&(i[o]=!0),void 0===l[t]&&(l[t]=!0)))})),n||(o[e]=!0)})),(Object.keys(i).length||Object.keys(s).length)&&this.queue.push({pending:s,pendingCount:Object.keys(s).length,loaded:{},errors:[],callback:n}),{toLoad:Object.keys(i),pending:Object.keys(s),toLoadLanguages:Object.keys(o),toLoadNamespaces:Object.keys(l)}}},{key:"loaded",value:function(e,t,r){var n=e.split("|"),a=n[0],i=n[1];t&&this.emit("failedLoading",a,i,t),r&&this.store.addResourceBundle(a,i,r),this.state[e]=t?-1:2;var s={};this.queue.forEach((function(r){!function(e,t,r,n){var a=D(e,t,Object),i=a.obj,s=a.k;i[s]=i[s]||[],n&&(i[s]=i[s].concat(r)),n||i[s].push(r)}(r.loaded,[a],i),function(e,t){void 0!==e.pending[t]&&(delete e.pending[t],e.pendingCount--)}(r,e),t&&r.errors.push(t),0!==r.pendingCount||r.done||(Object.keys(r.loaded).forEach((function(e){s[e]||(s[e]={});var t=r.loaded[e];t.length&&t.forEach((function(t){void 0===s[e][t]&&(s[e][t]=!0)}))})),r.done=!0,r.errors.length?r.callback(r.errors):r.callback())})),this.emit("loaded",s),this.queue=this.queue.filter((function(e){return!e.done}))}},{key:"read",value:function(e,t,r){var n=this,a=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,i=arguments.length>4&&void 0!==arguments[4]?arguments[4]:this.retryTimeout,s=arguments.length>5?arguments[5]:void 0;if(!e.length)return s(null,{});if(this.readingCalls>=this.maxParallelReads)this.waitingReads.push({lng:e,ns:t,fcName:r,tried:a,wait:i,callback:s});else{this.readingCalls++;var o=function(o,l){if(n.readingCalls--,n.waitingReads.length>0){var u=n.waitingReads.shift();n.read(u.lng,u.ns,u.fcName,u.tried,u.wait,u.callback)}o&&l&&a<n.maxRetries?setTimeout((function(){n.read.call(n,e,t,r,a+1,2*i,s)}),i):s(o,l)},l=this.backend[r].bind(this.backend);if(2!==l.length)return l(e,t,o);try{var u=l(e,t);u&&"function"==typeof u.then?u.then((function(e){return o(null,e)})).catch(o):o(null,u)}catch(e){o(e)}}}},{key:"prepareLoading",value:function(e,t){var r=this,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=arguments.length>3?arguments[3]:void 0;if(!this.backend)return this.logger.warn("No backend was added via i18next.use. Will not load resources."),a&&a();"string"==typeof e&&(e=this.languageUtils.toResolveHierarchy(e)),"string"==typeof t&&(t=[t]);var i=this.queueLoad(e,t,n,a);if(!i.toLoad.length)return i.pending.length||a(),null;i.toLoad.forEach((function(e){r.loadOne(e)}))}},{key:"load",value:function(e,t,r){this.prepareLoading(e,t,{},r)}},{key:"reload",value:function(e,t,r){this.prepareLoading(e,t,{reload:!0},r)}},{key:"loadOne",value:function(e){var t=this,r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",n=e.split("|"),a=n[0],i=n[1];this.read(a,i,"read",void 0,void 0,(function(n,s){n&&t.logger.warn("".concat(r,"loading namespace ").concat(i," for language ").concat(a," failed"),n),!n&&s&&t.logger.log("".concat(r,"loaded namespace ").concat(i," for language ").concat(a),s),t.loaded(e,n,s)}))}},{key:"saveMissing",value:function(e,t,r,n,a){var i=arguments.length>5&&void 0!==arguments[5]?arguments[5]:{},s=arguments.length>6&&void 0!==arguments[6]?arguments[6]:function(){};if(this.services.utils&&this.services.utils.hasLoadedNamespace&&!this.services.utils.hasLoadedNamespace(t))this.logger.warn('did not save key "'.concat(r,'" as the namespace "').concat(t,'" was not yet loaded'),"This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!");else if(null!=r&&""!==r){if(this.backend&&this.backend.create){var o=fe(fe({},i),{},{isUpdate:a}),l=this.backend.create.bind(this.backend);if(l.length<6)try{var u;(u=5===l.length?l(e,t,r,n,o):l(e,t,r,n))&&"function"==typeof u.then?u.then((function(e){return s(null,e)})).catch(s):s(null,u)}catch(e){s(e)}else l(e,t,r,n,s,o)}e&&e[0]&&this.store.addResource(e[0],t,r,n)}}}]),n}(A);function ge(){return{debug:!1,initImmediate:!0,ns:["translation"],defaultNS:["translation"],fallbackLng:["dev"],fallbackNS:!1,supportedLngs:!1,nonExplicitSupportedLngs:!1,load:"all",preload:!1,simplifyPluralSuffix:!0,keySeparator:".",nsSeparator:":",pluralSeparator:"_",contextSeparator:"_",partialBundledLanguages:!1,saveMissing:!1,updateMissing:!1,saveMissingTo:"fallback",saveMissingPlurals:!0,missingKeyHandler:!1,missingInterpolationHandler:!1,postProcess:!1,postProcessPassResolved:!1,returnNull:!0,returnEmptyString:!0,returnObjects:!1,joinArrays:!1,returnedObjectHandler:!1,parseMissingKeyHandler:!1,appendNamespaceToMissingKey:!1,appendNamespaceToCIMode:!1,overloadTranslationOptionHandler:function(e){var t={};if("object"===n(e[1])&&(t=e[1]),"string"==typeof e[1]&&(t.defaultValue=e[1]),"string"==typeof e[2]&&(t.tDescription=e[2]),"object"===n(e[2])||"object"===n(e[3])){var r=e[3]||e[2];Object.keys(r).forEach((function(e){t[e]=r[e]}))}return t},interpolation:{escapeValue:!0,format:function(e,t,r,n){return e},prefix:"{{",suffix:"}}",formatSeparator:",",unescapePrefix:"-",nestingPrefix:"$t(",nestingSuffix:")",nestingOptionsSeparator:",",maxReplaces:1e3,skipOnVariables:!0}}}function ye(e){return"string"==typeof e.ns&&(e.ns=[e.ns]),"string"==typeof e.fallbackLng&&(e.fallbackLng=[e.fallbackLng]),"string"==typeof e.fallbackNS&&(e.fallbackNS=[e.fallbackNS]),e.supportedLngs&&e.supportedLngs.indexOf("cimode")<0&&(e.supportedLngs=e.supportedLngs.concat(["cimode"])),e}function ve(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,n)}return r}function be(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?ve(Object(r),!0).forEach((function(t){x(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):ve(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}function ke(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var r,n=h(e);if(t){var a=h(this).constructor;r=Reflect.construct(n,arguments,a)}else r=n.apply(this,arguments);return c(this,r)}}function xe(){}var Se=function(e){l(a,e);var t=ke(a);function a(){var e,n,i=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},s=arguments.length>1?arguments[1]:void 0;if(r(this,a),e=t.call(this),z&&A.call(u(e)),e.options=ye(i),e.services={},e.logger=C,e.modules={external:[]},n=u(e),Object.getOwnPropertyNames(Object.getPrototypeOf(n)).forEach((function(e){"function"==typeof n[e]&&(n[e]=n[e].bind(n))})),s&&!e.isInitialized&&!i.isClone){if(!e.options.initImmediate)return e.init(i,s),c(e,u(e));setTimeout((function(){e.init(i,s)}),0)}return e}return s(a,[{key:"init",value:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},r=arguments.length>1?arguments[1]:void 0;"function"==typeof t&&(r=t,t={}),!t.defaultNS&&!1!==t.defaultNS&&t.ns&&("string"==typeof t.ns?t.defaultNS=t.ns:t.ns.indexOf("translation")<0&&(t.defaultNS=t.ns[0]));var n=ge();function a(e){return e?"function"==typeof e?new e:e:null}if(this.options=be(be(be({},n),this.options),ye(t)),"v1"!==this.options.compatibilityAPI&&(this.options.interpolation=be(be({},n.interpolation),this.options.interpolation)),void 0!==t.keySeparator&&(this.options.userDefinedKeySeparator=t.keySeparator),void 0!==t.nsSeparator&&(this.options.userDefinedNsSeparator=t.nsSeparator),!this.options.isClone){var i;this.modules.logger?C.init(a(this.modules.logger),this.options):C.init(null,this.options),this.modules.formatter?i=this.modules.formatter:"undefined"!=typeof Intl&&(i=he);var s=new Z(this.options);this.store=new U(this.options.resources,this.options);var o=this.services;o.logger=C,o.resourceStore=this.store,o.languageUtils=s,o.pluralResolver=new ae(s,{prepend:this.options.pluralSeparator,compatibilityJSON:this.options.compatibilityJSON,simplifyPluralSuffix:this.options.simplifyPluralSuffix}),!i||this.options.interpolation.format&&this.options.interpolation.format!==n.interpolation.format||(o.formatter=a(i),o.formatter.init(o,this.options),this.options.interpolation.format=o.formatter.format.bind(o.formatter)),o.interpolator=new oe(this.options),o.utils={hasLoadedNamespace:this.hasLoadedNamespace.bind(this)},o.backendConnector=new me(a(this.modules.backend),o.resourceStore,o,this.options),o.backendConnector.on("*",(function(t){for(var r=arguments.length,n=new Array(r>1?r-1:0),a=1;a<r;a++)n[a-1]=arguments[a];e.emit.apply(e,[t].concat(n))})),this.modules.languageDetector&&(o.languageDetector=a(this.modules.languageDetector),o.languageDetector.init&&o.languageDetector.init(o,this.options.detection,this.options)),this.modules.i18nFormat&&(o.i18nFormat=a(this.modules.i18nFormat),o.i18nFormat.init&&o.i18nFormat.init(this)),this.translator=new Q(this.services,this.options),this.translator.on("*",(function(t){for(var r=arguments.length,n=new Array(r>1?r-1:0),a=1;a<r;a++)n[a-1]=arguments[a];e.emit.apply(e,[t].concat(n))})),this.modules.external.forEach((function(t){t.init&&t.init(e)}))}if(this.format=this.options.interpolation.format,r||(r=xe),this.options.fallbackLng&&!this.services.languageDetector&&!this.options.lng){var l=this.services.languageUtils.getFallbackCodes(this.options.fallbackLng);l.length>0&&"dev"!==l[0]&&(this.options.lng=l[0])}this.services.languageDetector||this.options.lng||this.logger.warn("init: no languageDetector is used and no lng is defined");["getResource","hasResourceBundle","getResourceBundle","getDataByLanguage"].forEach((function(t){e[t]=function(){var r;return(r=e.store)[t].apply(r,arguments)}}));["addResource","addResources","addResourceBundle","removeResourceBundle"].forEach((function(t){e[t]=function(){var r;return(r=e.store)[t].apply(r,arguments),e}}));var u=T(),c=function(){var t=function(t,n){e.isInitialized&&!e.initializedStoreOnce&&e.logger.warn("init: i18next is already initialized. You should call init just once!"),e.isInitialized=!0,e.options.isClone||e.logger.log("initialized",e.options),e.emit("initialized",e.options),u.resolve(n),r(t,n)};if(e.languages&&"v1"!==e.options.compatibilityAPI&&!e.isInitialized)return t(null,e.t.bind(e));e.changeLanguage(e.options.lng,t)};return this.options.resources||!this.options.initImmediate?c():setTimeout(c,0),u}},{key:"loadResources",value:function(e){var t=this,r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:xe,n="string"==typeof e?e:this.language;if("function"==typeof e&&(r=e),!this.options.resources||this.options.partialBundledLanguages){if(n&&"cimode"===n.toLowerCase())return r();var a=[],i=function(e){e&&t.services.languageUtils.toResolveHierarchy(e).forEach((function(e){a.indexOf(e)<0&&a.push(e)}))};if(n)i(n);else this.services.languageUtils.getFallbackCodes(this.options.fallbackLng).forEach((function(e){return i(e)}));this.options.preload&&this.options.preload.forEach((function(e){return i(e)})),this.services.backendConnector.load(a,this.options.ns,(function(e){e||t.resolvedLanguage||!t.language||t.setResolvedLanguage(t.language),r(e)}))}else r(null)}},{key:"reloadResources",value:function(e,t,r){var n=T();return e||(e=this.languages),t||(t=this.options.ns),r||(r=xe),this.services.backendConnector.reload(e,t,(function(e){n.resolve(),r(e)})),n}},{key:"use",value:function(e){if(!e)throw new Error("You are passing an undefined module! Please check the object you are passing to i18next.use()");if(!e.type)throw new Error("You are passing a wrong module! Please check the object you are passing to i18next.use()");return"backend"===e.type&&(this.modules.backend=e),("logger"===e.type||e.log&&e.warn&&e.error)&&(this.modules.logger=e),"languageDetector"===e.type&&(this.modules.languageDetector=e),"i18nFormat"===e.type&&(this.modules.i18nFormat=e),"postProcessor"===e.type&&W.addPostProcessor(e),"formatter"===e.type&&(this.modules.formatter=e),"3rdParty"===e.type&&this.modules.external.push(e),this}},{key:"setResolvedLanguage",value:function(e){if(e&&this.languages&&!(["cimode","dev"].indexOf(e)>-1))for(var t=0;t<this.languages.length;t++){var r=this.languages[t];if(!(["cimode","dev"].indexOf(r)>-1)&&this.store.hasLanguageSomeTranslations(r)){this.resolvedLanguage=r;break}}}},{key:"changeLanguage",value:function(e,t){var r=this;this.isLanguageChangingTo=e;var n=T();this.emit("languageChanging",e);var a=function(e){r.language=e,r.languages=r.services.languageUtils.toResolveHierarchy(e),r.resolvedLanguage=void 0,r.setResolvedLanguage(e)},i=function(i){e||i||!r.services.languageDetector||(i=[]);var s="string"==typeof i?i:r.services.languageUtils.getBestMatchFromCodes(i);s&&(r.language||a(s),r.translator.language||r.translator.changeLanguage(s),r.services.languageDetector&&r.services.languageDetector.cacheUserLanguage&&r.services.languageDetector.cacheUserLanguage(s)),r.loadResources(s,(function(e){!function(e,i){i?(a(i),r.translator.changeLanguage(i),r.isLanguageChangingTo=void 0,r.emit("languageChanged",i),r.logger.log("languageChanged",i)):r.isLanguageChangingTo=void 0,n.resolve((function(){return r.t.apply(r,arguments)})),t&&t(e,(function(){return r.t.apply(r,arguments)}))}(e,s)}))};return e||!this.services.languageDetector||this.services.languageDetector.async?!e&&this.services.languageDetector&&this.services.languageDetector.async?0===this.services.languageDetector.detect.length?this.services.languageDetector.detect().then(i):this.services.languageDetector.detect(i):i(e):i(this.services.languageDetector.detect()),n}},{key:"getFixedT",value:function(e,t,r){var a=this,i=function e(t,i){var s;if("object"!==n(i)){for(var o=arguments.length,l=new Array(o>2?o-2:0),u=2;u<o;u++)l[u-2]=arguments[u];s=a.options.overloadTranslationOptionHandler([t,i].concat(l))}else s=be({},i);s.lng=s.lng||e.lng,s.lngs=s.lngs||e.lngs,s.ns=s.ns||e.ns,s.keyPrefix=s.keyPrefix||r||e.keyPrefix;var c,h=a.options.keySeparator||".";return c=s.keyPrefix&&Array.isArray(t)?t.map((function(e){return"".concat(s.keyPrefix).concat(h).concat(e)})):s.keyPrefix?"".concat(s.keyPrefix).concat(h).concat(t):t,a.t(c,s)};return"string"==typeof e?i.lng=e:i.lngs=e,i.ns=t,i.keyPrefix=r,i}},{key:"t",value:function(){var e;return this.translator&&(e=this.translator).translate.apply(e,arguments)}},{key:"exists",value:function(){var e;return this.translator&&(e=this.translator).exists.apply(e,arguments)}},{key:"setDefaultNamespace",value:function(e){this.options.defaultNS=e}},{key:"hasLoadedNamespace",value:function(e){var t=this,r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!this.isInitialized)return this.logger.warn("hasLoadedNamespace: i18next was not initialized",this.languages),!1;if(!this.languages||!this.languages.length)return this.logger.warn("hasLoadedNamespace: i18n.languages were undefined or empty",this.languages),!1;var n=this.resolvedLanguage||this.languages[0],a=!!this.options&&this.options.fallbackLng,i=this.languages[this.languages.length-1];if("cimode"===n.toLowerCase())return!0;var s=function(e,r){var n=t.services.backendConnector.state["".concat(e,"|").concat(r)];return-1===n||2===n};if(r.precheck){var o=r.precheck(this,s);if(void 0!==o)return o}return!!this.hasResourceBundle(n,e)||(!(this.services.backendConnector.backend&&(!this.options.resources||this.options.partialBundledLanguages))||!(!s(n,e)||a&&!s(i,e)))}},{key:"loadNamespaces",value:function(e,t){var r=this,n=T();return this.options.ns?("string"==typeof e&&(e=[e]),e.forEach((function(e){r.options.ns.indexOf(e)<0&&r.options.ns.push(e)})),this.loadResources((function(e){n.resolve(),t&&t(e)})),n):(t&&t(),Promise.resolve())}},{key:"loadLanguages",value:function(e,t){var r=T();"string"==typeof e&&(e=[e]);var n=this.options.preload||[],a=e.filter((function(e){return n.indexOf(e)<0}));return a.length?(this.options.preload=n.concat(a),this.loadResources((function(e){r.resolve(),t&&t(e)})),r):(t&&t(),Promise.resolve())}},{key:"dir",value:function(e){if(e||(e=this.resolvedLanguage||(this.languages&&this.languages.length>0?this.languages[0]:this.language)),!e)return"rtl";var t=this.services&&this.services.languageUtils||new Z(ge());return["ar","shu","sqr","ssh","xaa","yhd","yud","aao","abh","abv","acm","acq","acw","acx","acy","adf","ads","aeb","aec","afb","ajp","apc","apd","arb","arq","ars","ary","arz","auz","avl","ayh","ayl","ayn","ayp","bbz","pga","he","iw","ps","pbt","pbu","pst","prp","prd","ug","ur","ydd","yds","yih","ji","yi","hbo","men","xmn","fa","jpr","peo","pes","prs","dv","sam","ckb"].indexOf(t.getLanguagePartFromCode(e))>-1||e.toLowerCase().indexOf("-arab")>1?"rtl":"ltr"}},{key:"cloneInstance",value:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:xe,n=be(be(be({},this.options),t),{isClone:!0}),i=new a(n);void 0===t.debug&&void 0===t.prefix||(i.logger=i.logger.clone(t));return["store","services","language"].forEach((function(t){i[t]=e[t]})),i.services=be({},this.services),i.services.utils={hasLoadedNamespace:i.hasLoadedNamespace.bind(i)},i.translator=new Q(i.services,i.options),i.translator.on("*",(function(e){for(var t=arguments.length,r=new Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];i.emit.apply(i,[e].concat(r))})),i.init(n,r),i.translator.options=i.options,i.translator.backendConnector.services.utils={hasLoadedNamespace:i.hasLoadedNamespace.bind(i)},i}},{key:"toJSON",value:function(){return{options:this.options,store:this.store,language:this.language,languages:this.languages,resolvedLanguage:this.resolvedLanguage}}}]),a}(A);x(Se,"createInstance",(function(){return new Se(arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},arguments.length>1?arguments[1]:void 0)}));var we=Se.createInstance();we.createInstance=Se.createInstance;we.createInstance,we.dir,we.init,we.loadResources,we.reloadResources,we.use,we.changeLanguage,we.getFixedT;var Ee=we.t;we.exists,we.setDefaultNamespace,we.hasLoadedNamespace,we.loadNamespaces,we.loadLanguages,__webpack_require__(1739);Object.create(null);var _e=/&(?:amp|#38|lt|#60|gt|#62|apos|#39|quot|#34|nbsp|#160|copy|#169|reg|#174|hellip|#8230|#x2F|#47);/g,Pe={"&amp;":"&","&#38;":"&","&lt;":"<","&#60;":"<","&gt;":">","&#62;":">","&apos;":"'","&#39;":"'","&quot;":'"',"&#34;":'"',"&nbsp;":" ","&#160;":" ","&copy;":"©","&#169;":"©","&reg;":"®","&#174;":"®","&hellip;":"…","&#8230;":"…","&#x2F;":"/","&#47;":"/"},Ce=function(e){return Pe[e]};function Ae(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,n)}return r}function Te(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?Ae(Object(r),!0).forEach((function(t){x(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):Ae(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}var Me={bindI18n:"languageChanged",bindI18nStore:"",transEmptyNodeValue:"",transSupportBasicHtmlNodes:!0,transWrapTextNodes:"",transKeepBasicHtmlNodesFor:["br","strong","i","p"],useSuspense:!0,unescape:function(e){return e.replace(_e,Ce)}};var De={type:"3rdParty",init:function(e){!function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};Me=Te(Te({},Me),e)}(e.options.react),function(e){e}(e)}};(0,b.createContext)(),function(){function e(){r(this,e),this.usedNamespaces={}}s(e,[{key:"addUsedNamespaces",value:function(e){var t=this;e.forEach((function(e){t.usedNamespaces[e]||(t.usedNamespaces[e]=!0)}))}},{key:"getUsedNamespaces",value:function(){return Object.keys(this.usedNamespaces)}}])}();var Ie=[],Fe=Ie.forEach,Oe=Ie.slice;var Re=/^[\u0009\u0020-\u007e\u0080-\u00ff]+$/,Le=function(e,t,r){var n=r||{};n.path=n.path||"/";var a=encodeURIComponent(t),i="".concat(e,"=").concat(a);if(n.maxAge>0){var s=n.maxAge-0;if(Number.isNaN(s))throw new Error("maxAge should be a Number");i+="; Max-Age=".concat(Math.floor(s))}if(n.domain){if(!Re.test(n.domain))throw new TypeError("option domain is invalid");i+="; Domain=".concat(n.domain)}if(n.path){if(!Re.test(n.path))throw new TypeError("option path is invalid");i+="; Path=".concat(n.path)}if(n.expires){if("function"!=typeof n.expires.toUTCString)throw new TypeError("option expires is invalid");i+="; Expires=".concat(n.expires.toUTCString())}if(n.httpOnly&&(i+="; HttpOnly"),n.secure&&(i+="; Secure"),n.sameSite)switch("string"==typeof n.sameSite?n.sameSite.toLowerCase():n.sameSite){case!0:i+="; SameSite=Strict";break;case"lax":i+="; SameSite=Lax";break;case"strict":i+="; SameSite=Strict";break;case"none":i+="; SameSite=None";break;default:throw new TypeError("option sameSite is invalid")}return i},Ne=function(e,t,r,n){var a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:{path:"/",sameSite:"strict"};r&&(a.expires=new Date,a.expires.setTime(a.expires.getTime()+60*r*1e3)),n&&(a.domain=n),document.cookie=Le(e,encodeURIComponent(t),a)},Ve=function(e){for(var t="".concat(e,"="),r=document.cookie.split(";"),n=0;n<r.length;n++){for(var a=r[n];" "===a.charAt(0);)a=a.substring(1,a.length);if(0===a.indexOf(t))return a.substring(t.length,a.length)}return null},ze={name:"cookie",lookup:function(e){var t;if(e.lookupCookie&&"undefined"!=typeof document){var r=Ve(e.lookupCookie);r&&(t=r)}return t},cacheUserLanguage:function(e,t){t.lookupCookie&&"undefined"!=typeof document&&Ne(t.lookupCookie,e,t.cookieMinutes,t.cookieDomain,t.cookieOptions)}},Be={name:"querystring",lookup:function(e){var t;if("undefined"!=typeof window){var r=window.location.search;!window.location.search&&window.location.hash&&window.location.hash.indexOf("?")>-1&&(r=window.location.hash.substring(window.location.hash.indexOf("?")));for(var n=r.substring(1).split("&"),a=0;a<n.length;a++){var i=n[a].indexOf("=");if(i>0)n[a].substring(0,i)===e.lookupQuerystring&&(t=n[a].substring(i+1))}}return t}},je=null,Ge=function(){if(null!==je)return je;try{je="undefined"!==window&&null!==window.localStorage;var e="i18next.translate.boo";window.localStorage.setItem(e,"foo"),window.localStorage.removeItem(e)}catch(e){je=!1}return je},He={name:"localStorage",lookup:function(e){var t;if(e.lookupLocalStorage&&Ge()){var r=window.localStorage.getItem(e.lookupLocalStorage);r&&(t=r)}return t},cacheUserLanguage:function(e,t){t.lookupLocalStorage&&Ge()&&window.localStorage.setItem(t.lookupLocalStorage,e)}},qe=null,Ue=function(){if(null!==qe)return qe;try{qe="undefined"!==window&&null!==window.sessionStorage;var e="i18next.translate.boo";window.sessionStorage.setItem(e,"foo"),window.sessionStorage.removeItem(e)}catch(e){qe=!1}return qe},We={name:"sessionStorage",lookup:function(e){var t;if(e.lookupSessionStorage&&Ue()){var r=window.sessionStorage.getItem(e.lookupSessionStorage);r&&(t=r)}return t},cacheUserLanguage:function(e,t){t.lookupSessionStorage&&Ue()&&window.sessionStorage.setItem(t.lookupSessionStorage,e)}},$e={name:"navigator",lookup:function(e){var t=[];if("undefined"!=typeof navigator){if(navigator.languages)for(var r=0;r<navigator.languages.length;r++)t.push(navigator.languages[r]);navigator.userLanguage&&t.push(navigator.userLanguage),navigator.language&&t.push(navigator.language)}return t.length>0?t:void 0}},Ke={name:"htmlTag",lookup:function(e){var t,r=e.htmlTag||("undefined"!=typeof document?document.documentElement:null);return r&&"function"==typeof r.getAttribute&&(t=r.getAttribute("lang")),t}},Je={name:"path",lookup:function(e){var t;if("undefined"!=typeof window){var r=window.location.pathname.match(/\/([a-zA-Z-]*)/g);if(r instanceof Array)if("number"==typeof e.lookupFromPathIndex){if("string"!=typeof r[e.lookupFromPathIndex])return;t=r[e.lookupFromPathIndex].replace("/","")}else t=r[0].replace("/","")}return t}},Ye={name:"subdomain",lookup:function(e){var t="number"==typeof e.lookupFromSubdomainIndex?e.lookupFromSubdomainIndex+1:1,r="undefined"!=typeof window&&window.location&&window.location.hostname&&window.location.hostname.match(/^(\w{2,5})\.(([a-z0-9-]{1,63}\.[a-z]{2,6})|localhost)/i);if(r)return r[t]}};var Qe=function(){function e(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};r(this,e),this.type="languageDetector",this.detectors={},this.init(t,n)}return s(e,[{key:"init",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};this.services=e,this.options=function(e){return Fe.call(Oe.call(arguments,1),(function(t){if(t)for(var r in t)void 0===e[r]&&(e[r]=t[r])})),e}(t,this.options||{},{order:["querystring","cookie","localStorage","sessionStorage","navigator","htmlTag"],lookupQuerystring:"lng",lookupCookie:"i18next",lookupLocalStorage:"i18nextLng",lookupSessionStorage:"i18nextLng",caches:["localStorage"],excludeCacheFor:["cimode"]}),this.options.lookupFromUrlIndex&&(this.options.lookupFromPathIndex=this.options.lookupFromUrlIndex),this.i18nOptions=r,this.addDetector(ze),this.addDetector(Be),this.addDetector(He),this.addDetector(We),this.addDetector($e),this.addDetector(Ke),this.addDetector(Je),this.addDetector(Ye)}},{key:"addDetector",value:function(e){this.detectors[e.name]=e}},{key:"detect",value:function(e){var t=this;e||(e=this.options.order);var r=[];return e.forEach((function(e){if(t.detectors[e]){var n=t.detectors[e].lookup(t.options);n&&"string"==typeof n&&(n=[n]),n&&(r=r.concat(n))}})),this.services.languageUtils.getBestMatchFromCodes?r:r.length>0?r[0]:null}},{key:"cacheUserLanguage",value:function(e,t){var r=this;t||(t=this.options.caches),t&&(this.options.excludeCacheFor&&this.options.excludeCacheFor.indexOf(e)>-1||t.forEach((function(t){r.detectors[t]&&r.detectors[t].cacheUserLanguage(e,r.options)})))}}]),e}();Qe.type="languageDetector";const Xe=JSON.parse('{"nav.later":"По-късно","nav.prev":"Предишна","nav.next":"Следваща","nav.done":"Готово","intro.button":"Начало","userSurvey.header":"Това първия ли път инсталирате Opera?","userSurvey.newbie_header":"новак","userSurvey.newbie_desc":"Да, нов съм тук","userSurvey.active_header":"активен","userSurvey.active_desc":"не, просто преинсталирам","userSurvey.returning_header":"връщащ се","userSurvey.returning_desc":"Не, връщам се в Opera след като не съм го използвал известно време","themes.header":"В какво настроение сте?","themes.subheader":"Избор на тема на браузъра","themes.light":"Светло","themes.dark":"Тъмно","themes.system":"Система","wallpapers.header":"Какъв е вашият стил?","wallpapers.subheader":"Избор на тапет за Стартовата страница","adblocker.header":"По-бърза навигация без реклами","adblocker.subheader":"Включете блокирането на реклами,","adblocker.label":"Блокиране на реклами","messengers.header":"Бъдете в крак с всички","messengers.subheader":"Добавяне на любими приложения за социални медии","import.failed_header":"ГРЕШКА ПРИ ИМПОРТ","import.failed_message":"Моля, уверете се, че няма други задачи на браузъра, които да работят, и опитайте отново","import.header":"Внасяне на вашите данни","import.subheader":"Изберете браузър по-долу","outro.header":"Вашият браузър Opera е готов","outro.button":"Започнете да сърфирате"}'),Ze=JSON.parse('{"nav.later":"পরে","nav.prev":"পূর্ববর্তী","nav.next":"পরবর্তী","nav.done":"সম্পন্ন","intro.button":"ব্যবহার করে দেখুন","userSurvey.header":"এটা কি প্রথমবার Opera ইনস্টল করছেন?","userSurvey.newbie_header":"নতুন","userSurvey.newbie_desc":"হ্যাঁ, আমি এখানে নতুন","userSurvey.active_header":"সক্রিয়","userSurvey.active_desc":"না, আমি শুধু পুনরায় ইনস্টল করছি","userSurvey.returning_header":"ফিরে আসছে","userSurvey.returning_desc":"না, কিছু সময় ব্যবহার না করার পর আমি Opera-এ ফিরে আসছি","themes.header":"আপনার মুড কেমন আছে?","themes.subheader":"ব্রাউজার থিম নির্বাচন করুন","themes.light":"হালকা","themes.dark":"ঘন","themes.system":"সিস্টেম","wallpapers.header":"আপনার স্টাইল কেমন?","wallpapers.subheader":"সূচনা পৃষ্ঠার ওয়ালপেপার নির্বাচন করুন","adblocker.header":"বিজ্ঞাপন মুক্ত ভাবে দ্রুত ব্রাউজ করুন","adblocker.subheader":"অ্যাড ব্লকার চালু করুন","adblocker.label":"বিজ্ঞাপনগুলি অবরোধ করুন","messengers.header":"সবার সাথে তাল মিলিয়ে চলুন","messengers.subheader":"আপনার পছন্দের সোশ্যাল অ্যাপ যোগ করুন","import.failed_header":"আমদানি ত্রুটি","import.failed_message":"দয়া করে নিশ্চিত করুন যে কোনও অন্যান্য ব্রাউজার টাস্ক চলছে না এবং আবার চেষ্টা করুন","import.header":"আপনার ডেটা ইম্পোর্ট করুন","import.subheader":"নীচে ব্রাউজার নির্বাচন করুন","outro.header":"আপনার Opera ব্রাউজার প্রস্তুত","outro.button":"ব্রাউজ করা শুরু করুন"}'),et=JSON.parse('{"nav.later":"Més tard","nav.prev":"Anterior","nav.next":"Següent","nav.done":"Fet","intro.button":"Primers passos","userSurvey.header":"És la primera vegada que instal·les Opera?","userSurvey.newbie_header":"principiant","userSurvey.newbie_desc":"Sí, sóc nou aquí","userSurvey.active_header":"actiu","userSurvey.active_desc":"No, només estic reinstal·lant","userSurvey.returning_header":"que torna","userSurvey.returning_desc":"No, torno a Opera després de no usar-lo durant un temps","themes.header":"Indica el teu estat d’ànim","themes.subheader":"Selecciona un tema del navegador","themes.light":"Clar","themes.dark":"Fosc","themes.system":"Sistema","wallpapers.header":"Indica el teu estil","wallpapers.subheader":"Selecciona el fons de pantalla de la pàgina inicial","adblocker.header":"Navega més de pressa sense anuncis","adblocker.subheader":"Activa el bloqueig d\'anuncis","adblocker.label":"Bloqueja els anuncis","messengers.header":"Estigues al corrent de tothom","messengers.subheader":"Afegeix les teves xarxes socials preferides","import.failed_header":"ERROR D\'IMPORTACIÓ","import.failed_message":"Assegureu-vos que no s\'estiguin executant altres tasques del navegador i torneu-ho a provar","import.header":"Importa les teves dades","import.subheader":"Selecciona un navegador tot seguit","outro.header":"El teu navegador Opera ja és a punt","outro.button":"Comença a navegar"}'),tt=JSON.parse('{"nav.later":"Později","nav.prev":"Předch.","nav.next":"Další","nav.done":"Dokončeno","intro.button":"Začínáme","userSurvey.header":"Instalujete Operu poprvé?","userSurvey.newbie_header":"nováček","userSurvey.newbie_desc":"Ano, jsem zde nový","userSurvey.active_header":"aktivní","userSurvey.active_desc":"Ne, jen přeinstalávám","userSurvey.returning_header":"vracející se","userSurvey.returning_desc":"Ne, vracím se k Opeře poté, co jsem ji nějakou dobu nepoužíval","themes.header":"Jakou máte náladu?","themes.subheader":"Výběr tématu prohlížeče","themes.light":"Světlé","themes.dark":"Tmavé","themes.system":"Systém","wallpapers.header":"Jaký máte styl?","wallpapers.subheader":"Výběr tapety úvodní stránky","adblocker.header":"Rychlejší prohlížení bez reklam","adblocker.subheader":"Zapněte blokování reklam","adblocker.label":"Blokování reklam","messengers.header":"Držte krok s ostatními","messengers.subheader":"Přidejte své oblíbené sociální aplikace","import.failed_header":"CHYBA IMPORTU","import.failed_message":"Ujistěte se, že žádné další úkoly prohlížeče neběží, a zkuste to znovu","import.header":"Synchronizujte svá data","import.subheader":"Z následující nabídky vyberte prohlížeč","outro.header":"Prohlížeč Opera je připraven","outro.button":"Začít prohlížet web"}'),rt=JSON.parse('{"nav.later":"Senere","nav.prev":"Forrige","nav.next":"Næste","nav.done":"Udfør","intro.button":"Kom godt i gang","userSurvey.header":"Er det første gang, du installerer Opera?","userSurvey.newbie_header":"nybegynder","userSurvey.newbie_desc":"Ja, jeg er ny her","userSurvey.active_header":"aktiv","userSurvey.active_desc":"Nej, jeg geninstallerer bare","userSurvey.returning_header":"tilbagevender","userSurvey.returning_desc":"Nej, jeg vender tilbage til Opera efter ikke at have brugt det i et stykke tid","themes.header":"Hvordan er dit humør?","themes.subheader":"Vælg et browsertema","themes.light":"Lys","themes.dark":"Mørk","themes.system":"System","wallpapers.header":"Hvad er din stil?","wallpapers.subheader":"Vælg en baggrund til startsiden","adblocker.header":"Surf hurtigere uden annoncer","adblocker.subheader":"Slå annonceblokering til","adblocker.label":"Bloker annoncer","messengers.header":"Hold dig opdateret med alle","messengers.subheader":"Tilføj dine foretrukne sociale apps","import.failed_header":"IMPORTFEJL","import.failed_message":"Sørg for, at ingen andre browseropgaver kører, og prøv igen","import.header":"Importér dine data","import.subheader":"Vælg en browser nedenfor","outro.header":"Din Opera-browser er klar","outro.button":"Begynd at browse"}'),nt=JSON.parse('{"nav.later":"Später","nav.prev":"Vorherige","nav.next":"Nächste","nav.done":"Fertig","intro.button":"Erste Schritte","userSurvey.header":"Ist dies das erste Mal, dass Sie Opera installieren?","userSurvey.newbie_header":"Neuling","userSurvey.newbie_desc":"Ja, ich bin neu hier","userSurvey.active_header":"aktiv","userSurvey.active_desc":"Nein, ich installiere nur neu","userSurvey.returning_header":"zurückkehrend","userSurvey.returning_desc":"Nein, ich kehre zu Opera zurück, nachdem ich es eine Weile nicht benutzt habe","themes.header":"Wonach steht dir der Sinn?","themes.subheader":"Wähle ein Browserdesign aus","themes.light":"Hell","themes.dark":"Dunkel","themes.system":"System","wallpapers.header":"Welcher Stil gefällt dir?","wallpapers.subheader":"Wähle ein Hintergrundbild für die Startseite aus","adblocker.header":"Ohne Werbung schneller surfen","adblocker.subheader":"Aktiviere den Werbeblocker","adblocker.label":"Werbung blockieren","messengers.header":"Kontakte pflegen","messengers.subheader":"Füge deine bevorzugten Social-Media-Apps hinzu","import.failed_header":"IMPORTFEHLER","import.failed_message":"Bitte stellen Sie sicher, dass keine anderen Browser-Aufgaben ausgeführt werden, und versuchen Sie es erneut","import.header":"Deine Daten importieren","import.subheader":"Wähle unten einen Browser","outro.header":"Dein Opera-Browser ist startbereit","outro.button":"Browsen beginnen"}'),at=JSON.parse('{"nav.later":"Αργότερα","nav.prev":"Προηγούμενο","nav.next":"Επόμενο","nav.done":"Τέλος","intro.button":"Ξεκινήστε","userSurvey.header":"Είναι αυτή η πρώτη φορά που εγκαθιστάτε το Opera;","userSurvey.newbie_header":"αρχάριος","userSurvey.newbie_desc":"Ναι, είμαι καινούργιος εδώ","userSurvey.active_header":"ενεργός","userSurvey.active_desc":"Όχι, απλώς επανεγκαθιστώ","userSurvey.returning_header":"επιστρέφων","userSurvey.returning_desc":"Όχι, επιστρέφω στο Opera μετά από μια περίοδο που δεν το χρησιμοποιούσα","themes.header":"Σε τι διάθεση βρίσκεστε;","themes.subheader":"Επιλέξτε θέμα προγράμματος περιήγησης","themes.light":"Φωτεινό","themes.dark":"Σκοτεινό","themes.system":"Σύστημα","wallpapers.header":"Ποιο είναι το στυλ σας;","wallpapers.subheader":"Επιλέξτε ταπετσαρία για την Αρχική Σελίδα","adblocker.header":"Ταχύτερη περιήγηση χωρίς διαφημίσεις","adblocker.subheader":"Ενεργοποιήστε τον αποκλεισμό διαφημίσεων","adblocker.label":"Αποκλεισμός διαφημίσεων","messengers.header":"Μάθετε τα νέα των φίλων σας","messengers.subheader":"Προσθέστε τις εφαρμογές των αγαπημένων σας μέσων κοινωνικής δικτύωσης","import.failed_header":"ΣΦΑΛΜΑ ΕΙΣΑΓΩΓΗΣ","import.failed_message":"Βεβαιωθείτε ότι δεν εκτελούνται άλλες εργασίες προγράμματος περιήγησης και δοκιμάστε ξανά","import.header":"Εισάγετε τα δεδομένα σας","import.subheader":"Επιλέξτε ένα από τα παρακάτω προγράμματα περιήγησης","outro.header":"Το πρόγραμμα περιήγησης Opera είναι έτοιμο","outro.button":"Έναρξη περιήγησης"}'),it=JSON.parse('{"browser.chrome":"Chrome","browser.edge":"Edge","browser.safari":"Safari","browser.firefox":"Firefox","browser.crypto":"Opera Crypto","browser.gx":"Opera GX","nav.later":"Later","nav.prev":"Prev","nav.next":"Next","nav.done":"Done","intro.button":"Get started","userSurvey.header":"Is this your first time installing Opera?","userSurvey.newbie_header":"newbie","userSurvey.newbie_desc":"Yes, I’m new here","userSurvey.active_header":"active","userSurvey.active_desc":"No, I’m just reinstalling","userSurvey.returning_header":"returning","userSurvey.returning_desc":"No, I\'m coming back to Opera after not using it for some time","themes.header":"What\'s your mood?","themes.subheader":"Select a browser theme","themes.light":"Light","themes.dark":"Dark","themes.system":"System","wallpapers.header":"What\'s your style?","wallpapers.subheader":"Select a Start Page wallpaper","adblocker.header":"Browse faster ad-free","adblocker.subheader":"Turn on ad blocker","adblocker.label":"Block ads","messengers.header":"Keep up with everyone","messengers.subheader":"Add your favourite social apps","import.failed_header":"IMPORTING ERROR","import.failed_message":"Please make sure no other browser tasks are running and try again","import.header":"Import your data","import.subheader":"Select a browser below","outro.header":"Your Opera browser is ready","outro.button":"Start browsing"}'),st=JSON.parse('{"nav.later":"Después","nav.prev":"Anterior","nav.next":"Siguiente","nav.done":"Listo","intro.button":"Comenzar","userSurvey.header":"¿Es la primera vez que instalas Opera?","userSurvey.newbie_header":"principiante","userSurvey.newbie_desc":"Sí, soy nuevo aquí","userSurvey.active_header":"activo","userSurvey.active_desc":"No, solo estoy reinstalando","userSurvey.returning_header":"que regresa","userSurvey.returning_desc":"No, regreso a Opera después de no usarlo por un tiempo","themes.header":"¿Cuál es tu estado de ánimo?","themes.subheader":"Selecciona un tema para el navegador","themes.light":"Claro","themes.dark":"Oscuro","themes.system":"Sistema","wallpapers.header":"¿Cuál es tu estilo?","wallpapers.subheader":"Selecciona una imagen de fondo para la página de inicio","adblocker.header":"Navega más rápido sin anuncios","adblocker.subheader":"Activa el bloqueador de publicidad","adblocker.label":"Bloquear publicidad","messengers.header":"Mantente al día","messengers.subheader":"Añade tus aplicaciones de redes sociales preferidas","import.failed_header":"ERROR DE IMPORTACIÓN","import.failed_message":"Por favor, asegúrese de que no haya otras tareas del navegador en ejecución e intente de nuevo","import.header":"Importa tus datos","import.subheader":"Selecciona un navegador abajo","outro.header":"Tu Navegador Opera está listo","outro.button":"Comienza a navegar"}'),ot=JSON.parse('{"nav.later":"Más tarde","nav.prev":"Anterior","nav.next":"Siguiente","nav.done":"Hecho","intro.button":"Primeros pasos","userSurvey.header":"¿Es la primera vez que instalas Opera?","userSurvey.newbie_header":"principiante","userSurvey.newbie_desc":"Sí, soy nuevo aquí","userSurvey.active_header":"activo","userSurvey.active_desc":"No, solo estoy reinstalando","userSurvey.returning_header":"de vuelta","userSurvey.returning_desc":"No, vuelvo a Opera después de no usarlo durante un tiempo","themes.header":"Indica tu estado de ánimo","themes.subheader":"selecciona un tema del navegador","themes.light":"Claro","themes.dark":"Oscuro","themes.system":"Sistema","wallpapers.header":"Indica tu estilo","wallpapers.subheader":"Selecciona un fondo de pantalla para la página de inicio","adblocker.header":"Navega más rápido sin anuncios","adblocker.subheader":"Activa el bloqueo de publicidad","adblocker.label":"Bloquear publicidad","messengers.header":"Mantente al corriente de todos","messengers.subheader":"Añade tus redes sociales favoritas","import.failed_header":"ERROR DE IMPORTACIÓN","import.failed_message":"Asegúrese de que no se estén ejecutando otras tareas del navegador e inténtelo de nuevo","import.header":"Importa tus datos","import.subheader":"Selecciona un navegador a continuación","outro.description":"Accede a Aria, VPN Pro y Cashback con tu cuenta gratuita de Opera.","outro.button":"Empezar a navegar"}'),lt=JSON.parse('{"nav.later":"Myöhemmin","nav.prev":"Edellinen","nav.next":"Seuraava","nav.done":"Valmis","intro.button":"Aloita","userSurvey.header":"Asennatko Operan ensimmäistä kertaa?","userSurvey.newbie_header":"aloittelija","userSurvey.newbie_desc":"Kyllä, olen täällä uusi","userSurvey.active_header":"aktiivinen","userSurvey.active_desc":"En, vain asennan uudelleen","userSurvey.returning_header":"palaava","userSurvey.returning_desc":"En, palaan Operaan sen jälkeen, kun en ole käyttänyt sitä jonkin aikaa","themes.header":"Millä tuulella olet?","themes.subheader":"Valitse selaimen teema","themes.light":"Vaalea","themes.dark":"Tumma","themes.system":"Järjestelmä","wallpapers.header":"Mistä tyylistä pidät?","wallpapers.subheader":"Valitse aloitussivun taustakuva","adblocker.header":"Selaa nopeammin ilman mainoksia","adblocker.subheader":"Ota mainosten esto käyttöön","adblocker.label":"Mainosten esto","messengers.header":"Pysy ajan tasalla kuulumisista","messengers.subheader":"Lisää käyttämäsi sosiaalisen median sovellukset","import.failed_header":"TUONTIVIRHE","import.failed_message":"Varmista, ettei muita selaintehtäviä ole käynnissä ja yritä uudelleen","import.header":"Tuo tietosi","import.subheader":"Valitse alta selain","outro.description":"Käytä maksuttomalla Opera-tilillä Ariaa, VPN Prota ja Cashback-hyvityksiä.","outro.button":"Aloita selaaminen"}'),ut=JSON.parse('{"nav.later":"Plus tard","nav.prev":"Préc","nav.next":"Suivant","nav.done":"Fait","intro.button":"Commencer","userSurvey.header":"Est-ce la première fois que vous installez Opera ?","userSurvey.newbie_header":"débutant","userSurvey.newbie_desc":"Oui, je suis nouveau ici","userSurvey.active_header":"actif","userSurvey.active_desc":"Non, je ne fais que réinstaller","userSurvey.returning_header":"de retour","userSurvey.returning_desc":"Non, je reviens à Opera après ne pas l\'avoir utilisé pendant un certain temps","themes.header":"Quelle est ton humeur ?","themes.subheader":"Sélectionne un thème de navigateur","themes.light":"Clair","themes.dark":"Sombre","themes.system":"Système","wallpapers.header":"Quel est ton style ?","wallpapers.subheader":"Sélectionne un fond d\'écran pour la page de démarrage","adblocker.header":"Navigue plus vite et sans pubs","adblocker.subheader":"Activer le blocage des pubs","adblocker.label":"Bloquer les pubs","messengers.header":"Reste en contact avec tout le monde","messengers.subheader":"Ajoute les applis de tes réseaux sociaux préférés","import.failed_header":"ERREUR D\'IMPORTATION","import.failed_message":"Veuillez vous assurer qu\'aucune autre tâche du navigateur n\'est en cours d\'exécution et réessayez","import.header":"Importe tes données","import.subheader":"Sélectionne un navigateur ci-dessous","outro.header":"Ton navigateur Opera est prêt","outro.button":"Commencer la navigation"}'),ct=JSON.parse('{"nav.later":"बाद में","nav.prev":"पिछला","nav.next":"अगला","nav.done":"पूरा हुआ","intro.button":"शुरू करें","userSurvey.header":"क्या यह पहली बार Opera इंस्टॉल कर रहे हैं?","userSurvey.newbie_header":"नया","userSurvey.newbie_desc":"हाँ, मैं यहाँ नया हूँ","userSurvey.active_header":"सक्रिय","userSurvey.active_desc":"नहीं, मैं बस फिर से इंस्टॉल कर रहा हूँ","userSurvey.returning_header":"वापसी","userSurvey.returning_desc":"नहीं, मैं कुछ समय तक इसका उपयोग नहीं करने के बाद Opera पर वापस आ रहा हूँ","themes.header":"आपका मूड कैसा है?","themes.subheader":"एक ब्राउज़र थीम चुनें","themes.light":"हल्का","themes.dark":"गहरा","themes.system":"सिस्टम:","wallpapers.header":"आपका स्टाइल कैसा है?","wallpapers.subheader":"स्टार्ट पेज वॉलपेपर चुनें","adblocker.header":"बिना विज्ञापन के तेज़ गति से ब्राउज़ करें","adblocker.subheader":"विज्ञापन अवरोधक चालू करें","adblocker.label":"विज्ञापन अवरोधित करें","messengers.header":"सभी के साथ रहें","messengers.subheader":"अपनी पसंदीदा सोशल ऐप्स जोड़ें","import.failed_header":"आयात त्रुटि","import.failed_message":"कृपया सुनिश्चित करें कि कोई अन्य ब्राउज़र कार्य चल नहीं रहे हैं और पुनः प्रयास करें","import.header":"अपना डेटा इम्पोर्ट करें","import.subheader":"नीचे ब्राउज़र चुनें","outro.header":"आपका Opera ब्राउज़र तैयार है","outro.button":"ब्राउज़िंग प्रारंभ करें"}'),ht=JSON.parse('{"nav.later":"Kasnije","nav.prev":"Preth.","nav.next":"Sljedeće","nav.done":"Gotovo","intro.button":"Počnite","userSurvey.header":"Je li ovo prvi put da instalirate Operu?","userSurvey.newbie_header":"novák","userSurvey.newbie_desc":"Da, nov sam ovdje","userSurvey.active_header":"aktivan","userSurvey.active_desc":"Ne, samo reinstaliram","userSurvey.returning_header":"koji se vraća","userSurvey.returning_desc":"Ne, vraćam se u Operu nakon što je nisam koristio neko vrijeme","themes.header":"Kako ste raspoloženi?","themes.subheader":"Odaberite temu preglednika","themes.light":"Svijetla","themes.dark":"Tamna","themes.system":"Sustav","wallpapers.header":"Koji je vaš stil?","wallpapers.subheader":"Odaberite pozadinu početne stranice","adblocker.header":"Pregledavajte brže bez oglasa","adblocker.subheader":"Uključi blokiranje oglasa","adblocker.label":"Blokiranje oglasa","messengers.header":"Budite u toku sa svima","messengers.subheader":"Dodajte omiljene društvene aplikacije","import.failed_header":"GREŠKA UVOZA","import.failed_message":"Provjerite jesu li pokrenuti drugi zadaci preglednika i pokušajte ponovno","import.header":"Uvezite svoje podatke","import.subheader":"Odaberite preglednik u nastavku","outro.header":"Vaš preglednik Opera je spreman","outro.button":"Započni pregledavanje"}'),pt=JSON.parse('{"nav.later":"Később","nav.prev":"Előző","nav.next":"Következő","nav.done":"Kész","intro.button":"Kezdés","userSurvey.header":"Először telepíti az Operát?","userSurvey.newbie_header":"újonc","userSurvey.newbie_desc":"Igen, új vagyok itt","userSurvey.active_header":"aktív","userSurvey.active_desc":"Nem, csak újratelepítem","userSurvey.returning_header":"visszatérő","userSurvey.returning_desc":"Nem, visszatérek az Operához, miután egy ideig nem használtam","themes.header":"Milyen a hangulata?","themes.subheader":"Válasszon böngésző témát","themes.light":"Világos","themes.dark":"Sötét","themes.system":"Rendszer:","wallpapers.header":"Milyen a stílusa?","wallpapers.subheader":"Válasszon kezdőlap háttérképet","adblocker.header":"Böngésszen gyorsabban reklámmentesen","adblocker.subheader":"Reklámblokkolás bekapcsolása","adblocker.label":"Reklámok blokkolása","messengers.header":"Tartson lépést mindenkivel","messengers.subheader":"Kedvenc közösségi appok hozzáadása","import.failed_header":"IMPORTHIBA","import.failed_message":"Győződjön meg arról, hogy nincsenek más böngészőfeladatok futtatása és próbálja újra","import.header":"Adatok importálása","import.subheader":"Válasszon böngészőt alább","outro.header":"Opera böngészője készen van","outro.button":"Kezdje el a böngészést"}'),ft=JSON.parse('{"nav.later":"Nanti","nav.prev":"Sebelumnya","nav.next":"Selanjutnya","nav.done":"Selesai","intro.button":"Mulai","userSurvey.header":"Apakah ini pertama kali Anda menginstal Opera?","userSurvey.newbie_header":"pemula","userSurvey.newbie_desc":"Ya, saya baru di sini","userSurvey.active_header":"aktif","userSurvey.active_desc":"Tidak, saya hanya menginstal ulang","userSurvey.returning_header":"kembali","userSurvey.returning_desc":"Tidak, saya kembali ke Opera setelah tidak menggunakannya untuk beberapa waktu","themes.header":"Bagaimana suasana hati Anda?","themes.subheader":"Memilih tema browser","themes.light":"Biasa","themes.dark":"Gelap","themes.system":"Sistem","wallpapers.header":"Bagaimana gaya Anda?","wallpapers.subheader":"Pilih wallpaper Halaman Awal","adblocker.header":"Jelajahi lebih cepat bebas iklan","adblocker.subheader":"Nyalakan pemblokir iklan","adblocker.label":"Blokir iklan","messengers.header":"Tetap terhubung dengan semua orang","messengers.subheader":"Tambahkan aplikasi sosial favorit Anda","import.failed_header":"KESALAHAN IMPOR","import.failed_message":"Pastikan tidak ada tugas peramban lain yang berjalan dan coba lagi","import.header":"Impor data Anda","import.subheader":"Pilih browser di bawah ini","outro.header":"Browser Opera Anda telah siap","outro.button":"Mulai menjelajah"}'),dt=JSON.parse('{"nav.later":"Dopo","nav.prev":"Precedente","nav.next":"Successivo","nav.done":"Fatto","intro.button":"Inizia","userSurvey.header":"È la prima volta che installi Opera?","userSurvey.newbie_header":"principiante","userSurvey.newbie_desc":"Sì, sono nuovo qui","userSurvey.active_header":"attivo","userSurvey.active_desc":"No, sto solo reinstallando","userSurvey.returning_header":"di ritorno","userSurvey.returning_desc":"No, sto tornando a Opera dopo non averlo usato per un po\'","themes.header":"Di che umore sei?","themes.subheader":"Seleziona un tema del browser","themes.light":"Chiaro","themes.dark":"Scuro","themes.system":"Sistema","wallpapers.header":"Qual è il tuo stile?","wallpapers.subheader":"Seleziona uno sfondo per la pagina iniziale","adblocker.header":"Naviga più veloce e senza annunci","adblocker.subheader":"Attiva il blocco degli annunci pubblicitari","adblocker.label":"Blocco degli annunci","messengers.header":"Resta in contatto con tutti","messengers.subheader":"Aggiungi i tuoi social preferiti","import.failed_header":"ERRORE DI IMPORTAZIONE","import.failed_message":"Assicurati che non ci siano altre attività del browser in esecuzione e riprova","import.header":"Importa i tuoi dati","import.subheader":"Seleziona un browser qui sotto","outro.header":"Il tuo browser Opera è pronto","outro.button":"Inizia a navigare"}'),mt=JSON.parse('{"nav.later":"後で","nav.prev":"前へ","nav.next":"次へ","nav.done":"完了","intro.button":"始める","userSurvey.header":"Opera を初めてインストールしますか？","userSurvey.newbie_header":"初心者","userSurvey.newbie_desc":"はい、初めてです","userSurvey.active_header":"アクティブ","userSurvey.active_desc":"いいえ、再インストールしているだけです","userSurvey.returning_header":"復帰","userSurvey.returning_desc":"いいえ、しばらく使わなかった後に Opera に戻ってきました","themes.header":"どうしますか？","themes.subheader":"ブラウザのテーマを選択","themes.light":"ライト","themes.dark":"ダーク","themes.system":"システム","wallpapers.header":"スタイルはどうしますか？","wallpapers.subheader":"スタートページの壁紙を選択","adblocker.header":"高速で無広告ブラウジング","adblocker.subheader":"広告ブロッカーを有効にする","adblocker.label":"広告のブロック","messengers.header":"みんなに合わせる","messengers.subheader":"お気に入りのソーシャルアプリを追加","import.failed_header":"インポートエラー","import.failed_message":"他のブラウザタスクが実行されていないことを確認して、もう一度お試しください","import.header":"データのインポート","import.subheader":"以下のブラウザを選択","outro.header":"ご利用の Opera ブラウザが利用できます","outro.button":"ブラウジングを開始"}'),gt=JSON.parse('{"nav.later":"나중에","nav.prev":"이전","nav.next":"다음","nav.done":"완료","intro.button":"시작하기","userSurvey.header":"Opera를 처음 설치하시나요?","userSurvey.newbie_header":"초보자","userSurvey.newbie_desc":"네, 처음입니다","userSurvey.active_header":"활성","userSurvey.active_desc":"아니요, 다시 설치하는 것뿐입니다","userSurvey.returning_header":"돌아온","userSurvey.returning_desc":"아니요, 한동안 사용하지 않다가 Opera로 돌아왔습니다","themes.header":"어떤 분위기를 원하세요?","themes.subheader":"브라우저 테마 선택","themes.light":"라이트","themes.dark":"다크","themes.system":"시스템","wallpapers.header":"어떤 스타일을 원하세요?","wallpapers.subheader":"시작 페이지 배경무늬 선택","adblocker.header":"더 빠르고 광고 없는 인터넷 탐색","adblocker.subheader":"광고 차단 기능 켜기","adblocker.label":"광고 차단","messengers.header":"모두와 연결되기","messengers.subheader":"좋아하는 소셜 앱 추가","import.failed_header":"가져오기 오류","import.failed_message":"다른 브라우저 작업이 실행되지 않도록 하고 다시 시도하십시오","import.header":"내 데이터 가져오기","import.subheader":"아래에서 브라우저 선택","outro.header":"Opera 브라우저 사용 준비 완료","outro.button":"브라우징 시작"}'),yt=JSON.parse('{"nav.later":"Vėliau","nav.prev":"Peržiūra","nav.next":"Toliau","nav.done":"Atlikta","intro.button":"Pradžia","userSurvey.header":"Ar tai pirmą kartą instaliuojate Opera?","userSurvey.newbie_header":"naujokas","userSurvey.newbie_desc":"Taip, esu naujas čia","userSurvey.active_header":"aktyvus","userSurvey.active_desc":"Ne, tik iš naujo instaliuoju","userSurvey.returning_header":"grįžtantis","userSurvey.returning_desc":"Ne, grįžtu prie Opera po to, kai jos nenaudojau kurį laiką","themes.header":"Kokia jūsų nuotaika?","themes.subheader":"Pasirinkite naršyklės temą","themes.light":"Šviesi","themes.dark":"Tamsi","themes.system":"Sistema","wallpapers.header":"Koks jūsų stilius?","wallpapers.subheader":"Pasirinkite pradžios puslapio ekrano foną","adblocker.header":"Naršykite greičiau, nematydami reklamų","adblocker.subheader":"Įjungti reklamų blokavimą","adblocker.label":"Blokuoti reklamas","messengers.header":"Palaikykite ryšius","messengers.subheader":"Pridėkite mėgstamas socialinių tinklų programas","import.failed_header":"IMPORTAVIMO KLAIDA","import.failed_message":"Įsitikinkite, kad nevykdomos jokios kitos naršyklės užduotys ir bandykite dar kartą","import.header":"Importuokite savo duomenis","import.subheader":"Toliau pasirinkite naršyklę","outro.header":"Jūsų naršyklė „Opera“ paruošta","outro.button":"Pradėkite naršyti"}'),vt=JSON.parse('{"nav.later":"Vēlāk","nav.prev":"Iepr.","nav.next":"Nākamais","nav.done":"Gatavs","intro.button":"Darba sākšana","userSurvey.header":"Vai šī ir pirmā reize, kad instalējat Opera?","userSurvey.newbie_header":"jauns","userSurvey.newbie_desc":"Jā, esmu jauns šeit","userSurvey.active_header":"aktīvs","userSurvey.active_desc":"Nē, tikai pārinstalēju","userSurvey.returning_header":"atgriežas","userSurvey.returning_desc":"Nē, atgriežos pie Opera pēc tam, kad to neizmantoju kādu laiku","themes.header":"Kāds ir jūsu noskaņojums?","themes.subheader":"Atlasiet pārlūkprogrammas dizainu","themes.light":"Gaišs","themes.dark":"Tumšs","themes.system":"Sistēma","wallpapers.header":"Kāds ir jūsu stils?","wallpapers.subheader":"Atlasiet sākumlapas ekrāntapeti","adblocker.header":"Pārlūkojiet ātrāk bez reklāmām","adblocker.subheader":"Ieslēgt reklāmu bloķētāju","adblocker.label":"Reklāmu bloķēšana","messengers.header":"Sazinieties ar visiem","messengers.subheader":"Pievienojiet savas iecienītās sociālo tīklu lietotnes","import.failed_header":"IMPORTĒŠANAS KĻŪDA","import.failed_message":"Lūdzu, pārliecinieties, ka nav citas pārlūka uzdevumi un mēģiniet vēlreiz","import.header":"Importējiet savus datus","import.subheader":"Tālāk atlasiet pārlūkprogrammu","outro.header":"Pārlūkprogramma Opera ir gatava","outro.button":"Sākt pārlūkošanu"}'),bt=JSON.parse('{"nav.later":"Kemudian","nav.prev":"Sebelumnya","nav.next":"Seterusnya","nav.done":"Selesai","intro.button":"Mulakan","userSurvey.header":"Adakah ini kali pertama anda memasang Opera?","userSurvey.newbie_header":"baru","userSurvey.newbie_desc":"Ya, saya baru di sini","userSurvey.active_header":"aktif","userSurvey.active_desc":"Tidak, saya hanya memasang semula","userSurvey.returning_header":"kembali","userSurvey.returning_desc":"Tidak, saya kembali ke Opera selepas tidak menggunakannya untuk beberapa waktu","themes.header":"Apakah perasaan anda?","themes.subheader":"Pilih tema penyemak imbas","themes.light":"Terang","themes.dark":"Gelap","themes.system":"Sistem","wallpapers.header":"Apakah gaya anda?","wallpapers.subheader":"Pilih kertas hias dinding Halaman Permulaan","adblocker.header":"Semak imbas dengan lebih pantas tanpa iklan","adblocker.subheader":"Hidupkan penyekat iklan","adblocker.label":"Sekat iklan","messengers.header":"Ikuti perkembangan semua orang","messengers.subheader":"Tambah aplikasi sosial kegemaran anda","import.failed_header":"RALAT IMPORT","import.failed_message":"Sila pastikan tiada tugas pelayar lain yang berjalan dan cuba lagi","import.header":"Import data anda","import.subheader":"Pilih penyemak imbas di bawah","outro.header":"Penyemak imbas Opera anda sudah sedia","outro.button":"Mula melayar"}'),kt=JSON.parse('{"nav.later":"Senere","nav.prev":"Forrige","nav.next":"Neste","nav.done":"Fullført","intro.button":"Kom i gang","userSurvey.header":"Er dette første gang du installerer Opera?","userSurvey.newbie_header":"nybegynner","userSurvey.newbie_desc":"Ja, jeg er ny her","userSurvey.active_header":"aktiv","userSurvey.active_desc":"Nei, jeg reinstallerer bare","userSurvey.returning_header":"tilbakevendende","userSurvey.returning_desc":"Nei, jeg kommer tilbake til Opera etter å ikke ha brukt det på en stund","themes.header":"Hva med noe som passer til humøret?","themes.subheader":"Velg et nettlesertema","themes.light":"Lyst","themes.dark":"Mørkt","themes.system":"System","wallpapers.header":"Tilpass til din egen stil.","wallpapers.subheader":"Velg et bakgrunnsbilde for startsiden","adblocker.header":"Surf raskere, reklamefritt","adblocker.subheader":"Slå på annonseblokkering","adblocker.label":"Blokker annonser","messengers.header":"Hold kontakten med folk","messengers.subheader":"Legg til apper for sosiale nettverk","import.failed_header":"IMPORTFEIL","import.failed_message":"Sørg for at ingen andre nettleseroppgaver kjører og prøv igjen","import.header":"Importer dataene dine","import.subheader":"Velg en nettleser nedenfor","outro.header":"Opera-nettleseren er klar","outro.button":"Begynn å surfe"}'),xt=JSON.parse('{"nav.later":"Later","nav.prev":"Eerder","nav.next":"Volgende","nav.done":"Gereed","intro.button":"Aan de slag","userSurvey.header":"Is dit de eerste keer dat je Opera installeert?","userSurvey.newbie_header":"nieuwkomer","userSurvey.newbie_desc":"Ja, ik ben nieuw hier","userSurvey.active_header":"actief","userSurvey.active_desc":"Nee, ik installeer het alleen opnieuw","userSurvey.returning_header":"terugkeer","userSurvey.returning_desc":"Nee, ik kom terug bij Opera na het een tijd niet te hebben gebruikt","themes.header":"Hoe is je humeur?","themes.subheader":"Selecteer een browserthema","themes.light":"Licht","themes.dark":"Donker","themes.system":"Systeem","wallpapers.header":"Wat is je stijl?","wallpapers.subheader":"Selecteer een wallpaper voor de startpagina","adblocker.header":"Sneller browsen zonder advertenties","adblocker.subheader":"Schakel ad blocker in","adblocker.label":"Blokkeer advertenties","messengers.header":"Blijf bij met iedereen","messengers.subheader":"Voeg je favoriete social apps toe","import.failed_header":"IMPORTFOUT","import.failed_message":"Zorg ervoor dat er geen andere browsertaken actief zijn en probeer het opnieuw","import.header":"Importeer je gegevens","import.subheader":"Selecteer hieronder een browser","outro.header":"Je Opera-browser is klaar","outro.button":"Begin met browsen"}'),St=JSON.parse('{"nav.later":"Później","nav.prev":"Wstecz","nav.next":"Dalej","nav.done":"Gotowe","intro.button":"Rozpocznij","userSurvey.header":"Czy instalujesz Operę po raz pierwszy?","userSurvey.newbie_header":"nowy","userSurvey.newbie_desc":"Tak, jestem tu nowy","userSurvey.active_header":"aktywny","userSurvey.active_desc":"Nie, po prostu ponownie instaluję","userSurvey.returning_header":"powracający","userSurvey.returning_desc":"Nie, wracam do Opery po dłuższym czasie niekorzystania z niej","themes.header":"W jakim jesteś nastroju?","themes.subheader":"Wybierz motyw przeglądarki","themes.light":"Jasny","themes.dark":"Ciemny","themes.system":"System","wallpapers.header":"Jaki masz styl?","wallpapers.subheader":"Wybierz tapetę strony startowej","adblocker.header":"Przeglądaj sieć szybciej i bez reklam","adblocker.subheader":"Włącz blokowanie reklam","adblocker.label":"Blokowanie reklam","messengers.header":"Pozostań w kontakcie","messengers.subheader":"Dodaj swoje ulubione aplikacje społecznościowe","import.failed_header":"BŁĄD IMPORTU","import.failed_message":"Upewnij się, że żadne inne zadania przeglądarki nie są uruchomione i spróbuj ponownie","import.header":"Zaimportuj swoje dane","import.subheader":"Wybierz przeglądarkę poniżej","outro.header":"Twoja przeglądarka Opera jest gotowa","outro.button":"Rozpocznij przeglądanie"}'),wt=JSON.parse('{"nav.later":"Mais tarde","nav.prev":"Anterior","nav.next":"Próximo","nav.done":"Concluído","intro.button":"Como começar","userSurvey.header":"É a primeira vez que instala o Opera?","userSurvey.newbie_header":"iniciante","userSurvey.newbie_desc":"Sim, sou novo aqui","userSurvey.active_header":"ativo","userSurvey.active_desc":"Não, estou apenas a reinstalar","userSurvey.returning_header":"retornando","userSurvey.returning_desc":"Não, estou a regressar ao Opera após não o usar durante algum tempo","themes.header":"Qual é o seu estado de espírito?","themes.subheader":"Selecione um tema para o browser","themes.light":"Claro","themes.dark":"Escuro","themes.system":"Sistema","wallpapers.header":"Qual é o seu estilo?","wallpapers.subheader":"Selecione uma imagem de fundo para a Página inicial","adblocker.header":"Navegue mais rapidamente e sem anúncios","adblocker.subheader":"Ligar bloqueador de anúncios","adblocker.label":"Bloquear anúncios","messengers.header":"Mantenha-se atualizado","messengers.subheader":"Adicione as aplicações das suas redes sociais favoritas","import.failed_header":"ERRO DE IMPORTAÇÃO","import.failed_message":"Certifique-se de que nenhuma outra tarefa do navegador está em execução e tente novamente","import.header":"Importe os seus dados","import.subheader":"Selecione um browser abaixo","outro.header":"O seu browser Opera está pronto","outro.button":"Iniciar navegação"}'),Et=JSON.parse('{"nav.later":"Depois","nav.prev":"Anterior","nav.next":"Próximo","nav.done":"Concluído","intro.button":"Comece agora","userSurvey.header":"É a primeira vez que você está instalando o Opera?","userSurvey.newbie_header":"iniciante","userSurvey.newbie_desc":"Sim, sou novo aqui","userSurvey.active_header":"ativo","userSurvey.active_desc":"Não, estou apenas reinstalando","userSurvey.returning_header":"retornando","userSurvey.returning_desc":"Não, estou voltando ao Opera depois de não usá-lo por algum tempo","themes.header":"Como está seu astral?","themes.subheader":"Selecione um tema para o navegador","themes.light":"Claro","themes.dark":"Escuro","themes.system":"Sistema","wallpapers.header":"Qual é o seu estilo?","wallpapers.subheader":"Selecione um papel de parede para a Página Inicial","adblocker.header":"Navegue mais rapidamente sem anúncios","adblocker.subheader":"Ative o bloqueador de anúncios","adblocker.label":"Bloquear anúncios","messengers.header":"Acompanhe todo mundo","messengers.subheader":"Adicione seus aplicativos de redes sociais favoritos","import.failed_header":"ERRO DE IMPORTAÇÃO","import.failed_message":"Certifique-se de que nenhuma outra tarefa do navegador esteja em execução e tente novamente","import.header":"Importe seus dados","import.subheader":"Selecione um navegador abaixo","outro.header":"Seu navegador Opera está pronto","outro.button":"Começar a navegar"}'),_t=JSON.parse('{"nav.later":"Mai târziu","nav.prev":"Previzualizare","nav.next":"Următor","nav.done":"Gata","intro.button":"Începe","userSurvey.header":"Este prima dată când instalezi Opera?","userSurvey.newbie_header":"începător","userSurvey.newbie_desc":"Da, sunt nou aici","userSurvey.active_header":"activ","userSurvey.active_desc":"Nu, doar reinstalez","userSurvey.returning_header":"care se întoarce","userSurvey.returning_desc":"Nu, mă întorc la Opera după ce nu l-am folosit o vreme","themes.header":"Cum te simți?","themes.subheader":"Selectează o temă pentru browser","themes.light":"Luminos","themes.dark":"Întunecat","themes.system":"Sistem","wallpapers.header":"Care este stilul tău?","wallpapers.subheader":"Selectează o imagine de fundal pentru Pagina de pornire","adblocker.header":"Navighează mai rapid și fără reclame","adblocker.subheader":"Activează blocatorul de reclame","adblocker.label":"Blocare reclame","messengers.header":"Ține pasul cu ceilalți","messengers.subheader":"Adaugă aplicațiile sociale favorite","import.failed_header":"EROARE DE IMPORT","import.failed_message":"Asigurați-vă că nu rulează alte sarcini ale browserului și încercați din nou","import.header":"Importă datele tale","import.subheader":"Selectează un browser mai jos","outro.header":"Browserul tău Opera este gata","outro.button":"Începe navigarea"}'),Pt=JSON.parse('{"nav.later":"Позже","nav.prev":"Предпросмотр","nav.next":"Далее","nav.done":"Готово","intro.button":"Начать работу","userSurvey.header":"Это первый раз, когда вы устанавливаете Opera?","userSurvey.newbie_header":"новичок","userSurvey.newbie_desc":"Да, я новичок здесь","userSurvey.active_header":"активный","userSurvey.active_desc":"Нет, я просто переустанавливаю","userSurvey.returning_header":"возвращающийся","userSurvey.returning_desc":"Нет, я возвращаюсь к Opera после того, как не использовал его некоторое время","themes.header":"Какое настроение у вас сегодня?","themes.subheader":"Выберите тему браузера","themes.light":"Светлая","themes.dark":"Темная","themes.system":"Система","wallpapers.header":"Какой стиль вам нравится?","wallpapers.subheader":"Выберите обои для начальной страницы","adblocker.header":"Открывайте сайты быстрее и без рекламы","adblocker.subheader":"Включите блокировку рекламы,","adblocker.label":"Блокировка рекламы","messengers.header":"Поддерживайте общение","messengers.subheader":"Добавьте любимые соцсети","import.failed_header":"ОШИБКА ИМПОРТА","import.failed_message":"Убедитесь, что другие задачи браузера не выполняются, и попробуйте снова","import.header":"Импортируйте свои данные","import.subheader":"Выберите браузер ниже","outro.header":"Ваш браузер Opera готов","outro.button":"Начать просмотр"}'),Ct=JSON.parse('{"nav.later":"Neskôr","nav.prev":"Predch.","nav.next":"Nasledujúce","nav.done":"Hotovo","intro.button":"Začať","userSurvey.header":"Je to prvýkrát, čo inštalujete Operu?","userSurvey.newbie_header":"nováčik","userSurvey.newbie_desc":"Áno, som tu nový","userSurvey.active_header":"aktívny","userSurvey.active_desc":"Nie, len preinštalúvam","userSurvey.returning_header":"vracejúci sa","userSurvey.returning_desc":"Nie, vraciam sa k Opere po tom, ako som ju nepoužíval nejaký čas","themes.header":"Akú máte náladu?","themes.subheader":"Vyberte tému prehliadača","themes.light":"Svetlá","themes.dark":"Tmavá","themes.system":"Systém","wallpapers.header":"Aký máte štýl?","wallpapers.subheader":"Vyberte tapetu hlavného okna","adblocker.header":"Prehľadávajte internet rýchlejšie bez reklám","adblocker.subheader":"Zapnite blokovanie reklám","adblocker.label":"Blokovanie reklám","messengers.header":"Majte prehľad o každom","messengers.subheader":"Pridajte obľúbené sociálne aplikácie","import.failed_header":"CHYBA IMPORTU","import.failed_message":"Uistite sa, že nie sú spustené žiadne iné úlohy prehliadača a skúste to znova","import.header":"Importujte údaje","import.subheader":"Vyberte prehliadač nižšie","outro.header":"Váš prehliadač Opera je pripravený","outro.button":"Začnite prehliadať"}'),At=JSON.parse('{"nav.later":"Касније","nav.prev":"Претх.","nav.next":"Даље","nav.done":"Готово","intro.button":"Почните","userSurvey.header":"Да ли је ово први пут да инсталирате Opera?","userSurvey.newbie_header":"новајлија","userSurvey.newbie_desc":"Да, нов сам овде","userSurvey.active_header":"активан","userSurvey.active_desc":"Не, само поново инсталирам","userSurvey.returning_header":"враћа се","userSurvey.returning_desc":"Не, враћам се у Opera након што је нисам користио неко време","themes.header":"Како сте расположени?","themes.subheader":"Изаберите тему прегледача","themes.light":"Светло","themes.dark":"Тамно","themes.system":"Систем","wallpapers.header":"Који је ваш стил?","wallpapers.subheader":"Изаберите позадину почетне стране","adblocker.header":"Прегледајте брже и без реклама","adblocker.subheader":"Укључите алатку за блокирање реклама","adblocker.label":"Блокирај рекламе","messengers.header":"Останите у контакту са свима","messengers.subheader":"Додајте своје омиљене друштвене апликације","import.failed_header":"ГРЕШКА У УВОЗУ","import.failed_message":"Молимо вас да проверите да ли нема других задатака у прегледачу и покушајте поново","import.header":"Увезите своје податке","import.subheader":"Изаберите преледач испод","outro.header":"Ваш прегледач Opera је спреман","outro.button":"Почните са прегледањем"}'),Tt=JSON.parse('{"nav.later":"Senare","nav.prev":"Föreg.","nav.next":"Nästa","nav.done":"Klart","intro.button":"Sätt igång","userSurvey.header":"Är det första gången du installerar Opera?","userSurvey.newbie_header":"nybörjare","userSurvey.newbie_desc":"Ja, jag är ny här","userSurvey.active_header":"aktiv","userSurvey.active_desc":"Nej, jag reinstallerar bara","userSurvey.returning_header":"återvändande","userSurvey.returning_desc":"Nej, jag återvänder till Opera efter att inte ha använt det på ett tag","themes.header":"Vad känner du för?","themes.subheader":"Välj webbläsartema","themes.light":"Ljust","themes.dark":"Mörkt","themes.system":"System","wallpapers.header":"Vad är din stil?","wallpapers.subheader":"Välj en bakgrundsbild för startsidan","adblocker.header":"Surfa snabbare utan annonser","adblocker.subheader":"Slå på annonsblockeraren","adblocker.label":"Blockera annonser","messengers.header":"Håll koll på alla","messengers.subheader":"Lägg till dina favoritappar för sociala nätverk","import.failed_header":"IMPORTFEL","import.failed_message":"Se till att inga andra webbläsaruppgifter körs och försök igen","import.header":"Importera din data","import.subheader":"Välj en webbläsare nedan","outro.header":"Din Opera-webbläsare är redo","outro.button":"Börja surfa"}'),Mt=JSON.parse('{"nav.later":"Baadaye","nav.prev":"Awali","nav.next":"Inayofuata","nav.done":"Imekamilisha","intro.button":"Anza","userSurvey.header":"Je, hii ni mara ya kwanza kusakinisha Opera?","userSurvey.newbie_header":"mpya","userSurvey.newbie_desc":"Ndio, mimi ni mpya hapa","userSurvey.active_header":"mashughuli","userSurvey.active_desc":"Hapana, nasakinisha tu upya","userSurvey.returning_header":"anarudi","userSurvey.returning_desc":"Hapana, ninarudi Opera baada ya kuokoa kuiusa kwa muda","themes.header":"Hali yako ni ipi?","themes.subheader":"Chagua mandhari ya kivinjari","themes.light":"Angavu","themes.dark":"Kolevu","themes.system":"Mfumo","wallpapers.header":"Mtindo wako ni upi?","wallpapers.subheader":"Chagua mandhari nyuma ya Ukurasa wa Kuanza","adblocker.header":"Vinjari kwa haraka bila matangazo","adblocker.subheader":"Washa kizuia matangazo","adblocker.label":"Zuia matangazo","messengers.header":"Endelea kushirikiana na kila mtu","messengers.subheader":"Weka programu unazozipenda za kijamii","import.failed_header":"KOSA LA KUAGIZA","import.failed_message":"Tafadhali hakikisha hakuna kazi zingine za kivinjari zinaendeshwa na ujaribu tena","import.header":"Ingiza data yako","import.subheader":"Chagua kivinjari hapa chini","outro.header":"Kivinjari chako cha Opera kiko tayari","outro.button":"Anza kuvinjari"}'),Dt=JSON.parse('{"nav.later":"பின்னர்","nav.prev":"முந்தையது","nav.next":"அடுத்து","nav.done":"முடிந்தது","intro.button":"தொடங்கவும்","userSurvey.header":"இது முதல் முறையாக Opera ஐ நிறுவுகிறீர்களா?","userSurvey.newbie_header":"புதியவர்","userSurvey.newbie_desc":"ஆம், நான் இங்கு புதியவன்","userSurvey.active_header":"செயல்படுவோர்","userSurvey.active_desc":"இல்லை, நான் மீண்டும் நிறுவுகிறேன்","userSurvey.returning_header":"திரும்பி வருவோர்","userSurvey.returning_desc":"இல்லை, சிறிது காலம் பயன்படுத்தாமல் இருந்த பிறகு Opera வுக்கு திரும்பி வருகிறேன்","themes.header":"உங்கள் மனநிலை எப்படி இருக்கிறது?","themes.subheader":"உலாவி தீமினைத் தேர்ந்தெடுக்கவும்","themes.light":"வெளிர்நிற தீம்","themes.dark":"அடர்நிற தீம்","themes.system":"சிஸ்டம்","wallpapers.header":"உங்கள் ஸ்டைல் என்ன?","wallpapers.subheader":"துவக்கப் பக்க வால்பேப்பரைத் தேர்ந்தெடுக்கவும்","adblocker.header":"விளம்பரங்கள் இல்லாமலும் இன்னும் வேகமாகவும் இணையத்தை உலாவுங்கள்","adblocker.subheader":"விளம்பரத் தடுப்பானை இயக்கவும்","adblocker.label":"விளம்பரங்களைத் தடு","messengers.header":"அனைவரிடமும் இணைப்பில் இருங்கள்","messengers.subheader":"உங்களுக்குப் பிடித்த சமூக ஊடகப் பயன்பாடுகளைச் சேருங்கள்","import.failed_header":"இறக்குமதி பிழை","import.failed_message":"தயவுசெய்து வேறு உலாவி பணிகள் இயங்கவில்லை என்பதை உறுதிப்படுத்தி மீண்டும் முயற்சி செய்யவும்","import.header":"உங்கள் தரவை இறக்குமதி செய்யுங்கள்","import.subheader":"கீழே ஒரு உலாவியைத் தேர்ந்தெடுக்கவும்","outro.header":"உங்கள் Opera உலாவி தயார்","outro.button":"உலாவத் தொடங்குங்கள்!"}'),It=JSON.parse('{"nav.later":"తరువాత","nav.prev":"మునుపటి","nav.next":"తదుపరి","nav.done":"పూర్తయ్యింది","intro.button":"ప్రారంభించండి","userSurvey.header":"ఇది మీరు మొదటిసారి Opera ని ఇన్‌స్టాల్ చేయడం?","userSurvey.newbie_header":"కొత్తవాడి","userSurvey.newbie_desc":"అవును, నేను ఇక్కడ కొత్తవాడిని","userSurvey.active_header":"సక్రియం","userSurvey.active_desc":"లేదు, నేను మళ్లీ ఇన్‌స్టాల్ చేస్తున్నాను","userSurvey.returning_header":"తిరిగి వస్తున్నవాడు","userSurvey.returning_desc":"లేదు, కొంత సమయం వాడకపోయిన తర్వాత Opera కి తిరిగి వస్తున్నాను","themes.header":"మీ మానసిక స్థితి ఏమిటి?","themes.subheader":"బ్రౌజర్ థీమ్‌ను ఎంచుకోండి","themes.light":"లేత రంగు","themes.dark":"ముదురు రంగు","themes.system":"సిస్టమ్","wallpapers.header":"మీ స్టైల్ ఏమిటి?","wallpapers.subheader":"ప్రారంభ పేజీ వాల్‌పేపర్‌ను ఎంచుకోండి","adblocker.header":"యాడ్ రహితంగా వేగంగా బ్రౌజ్ చేయండి","adblocker.subheader":"యాడ్ బ్లాకర్ ఆన్ చేయి","adblocker.label":"యాడ్‌లను బ్లాక్ చేయి","messengers.header":"అందరితో కలిసి ఉండండి","messengers.subheader":"మీకు ఇష్టమైన సామాజిక యాప్‌లను జోడించండి","import.failed_header":"దిగుమతి లోపం","import.failed_message":"దయచేసి ఇతర బ్రౌజర్ పనులు ప్రవహించని నిర్ధారించి మళ్ళీ ప్రయత్నించండి","import.header":"మీ డేటాను దిగుమతి చేయండి","import.subheader":"క్రింద ఒక బ్రౌజర్‌ను ఎంచుకోండి","outro.header":"మీ Opera బ్రౌజర్‌ సిద్ధంగా ఉంది","outro.button":"బ్రౌజింగ్‌ను ప్రారంభించండి"}'),Ft=JSON.parse('{"nav.later":"ภายหลัง","nav.prev":"ก่อนหน้า","nav.next":"ถัดไป","nav.done":"เสร็จสิ้น","intro.button":"เริ่มต้น","userSurvey.header":"นี่เป็นครั้งแรกที่คุณติดตั้ง Opera หรือไม่?","userSurvey.newbie_header":"มือใหม่","userSurvey.newbie_desc":"ใช่ ฉันใหม่ที่นี่","userSurvey.active_header":"ใช้งานอยู่","userSurvey.active_desc":"ไม่ ฉันแค่ติดตั้งใหม่","userSurvey.returning_header":"กลับมาใช้","userSurvey.returning_desc":"ไม่ ฉันกลับมาใช้ Opera หลังจากไม่ได้ใช้มาสักพัก","themes.header":"อารมณ์ของคุณเป็นอย่างไร","themes.subheader":"ตั้งค่าธีมของเบราว์เซอร์","themes.light":"สว่าง","themes.dark":"มืด","themes.system":"ระบบ","wallpapers.header":"สไตล์ของคุณเป็นอย่างไร","wallpapers.subheader":"เลือกวอลล์เปเปอร์ของหน้าเริ่มต้น","adblocker.header":"ท่องเว็บได้เร็วขึ้นแบบไม่มีโฆษณา","adblocker.subheader":"เปิดตัวบล็อกโฆษณา","adblocker.label":"บล็อกโฆษณา","messengers.header":"ทันข่าวสารกับทุกคน","messengers.subheader":"เพิ่มแอบโซเชียลแอปโปรดของคุณ","import.failed_header":"ข้อผิดพลาดในการนำเข้า","import.failed_message":"โปรดตรวจสอบให้แน่ใจว่าไม่มีงานเบราว์เซอร์อื่น ๆ ที่กำลังทำงานและลองอีกครั้ง","import.header":"นำเข้าข้อมูลของคุณ","import.subheader":"เลือกเบราว์เซอร์ด้านล่างนี้","outro.header":"เบราว์เซอร์ Opera ของคุณพร้อมแล้ว","outro.button":"เริ่มการเรียกดู"}'),Ot=JSON.parse('{"nav.later":"Saka na","nav.prev":"Nauna","nav.next":"Susunod","nav.done":"Tapos na","intro.button":"Magsimula","userSurvey.header":"Ito ba ang unang beses mong i-install ang Opera?","userSurvey.newbie_header":"baguhan","userSurvey.newbie_desc":"Oo, bago ako dito","userSurvey.active_header":"aktibo","userSurvey.active_desc":"Hindi, nagi-install lang ulit","userSurvey.returning_header":"bumabalik","userSurvey.returning_desc":"Hindi, bumabalik ako sa Opera pagkatapos hindi gamitin ng ilang panahon","themes.header":"Ano’ng mood mo?","themes.subheader":"Pumili ng tema ng browser","themes.light":"Maliwanag","themes.dark":"Madilim","themes.system":"System","wallpapers.header":"Ano’ng istilo mo?","wallpapers.subheader":"Pumili ng wallpaper ng Start Page","adblocker.header":"Mag-browse nang mas mabilis nang walang ad","adblocker.subheader":"I-on ang ad blocker","adblocker.label":"Ad blocker","messengers.header":"Makasabay sa lahat","messengers.subheader":"Idagdag ang mga paborito mong social app","import.failed_header":"KAMALIAN SA PAG-ANGKAT","import.failed_message":"Pakisigurado na walang ibang mga gawain sa browser na tumatakbo at subukan muli","import.header":"I-import ang iyong data","import.subheader":"Pumili ng browser sa ibaba","outro.header":"Handa na ang iyong Opera browser","outro.button":"Simulan ang pag-browse"}'),Rt=JSON.parse('{"nav.later":"Daha sonra","nav.prev":"Önceki","nav.next":"Sonraki","nav.done":"Tamam","intro.button":"Başlayın","userSurvey.header":"Opera\'yı ilk kez mi yüklüyorsunuz?","userSurvey.newbie_header":"yeni başlayan","userSurvey.newbie_desc":"Evet, burada yeniyim","userSurvey.active_header":"aktif","userSurvey.active_desc":"Hayır, sadece yeniden yüklüyorum","userSurvey.returning_header":"geri dönen","userSurvey.returning_desc":"Hayır, bir süre kullanmadıktan sonra Opera\'ya geri dönüyorum","themes.header":"Ruh halin nedir?","themes.subheader":"Bir tarayıcı teması seç","themes.light":"Aydınlık","themes.dark":"Karanlık","themes.system":"Sistem","wallpapers.header":"Stilin nedir?","wallpapers.subheader":"Bir Başlangıç Sayfası duvar kağıdı seç","adblocker.header":"Daha hızlı reklamsız gezin","adblocker.subheader":"Reklam engelleyiciyi aç","adblocker.label":"Reklamları engelle","messengers.header":"Herkese ayak uydur","messengers.subheader":"Favori sosyal uygulamalarını ekle","import.failed_header":"İÇE AKTARMA HATASI","import.failed_message":"Lütfen başka tarayıcı görevlerinin çalışmadığından emin olun ve tekrar deneyin","import.header":"Verilerini al","import.subheader":"Aşağıdan bir tarayıcı seç","outro.header":"Opera tarayıcın hazır","outro.button":"Gezinmeye başlayın"}'),Lt=JSON.parse('{"nav.later":"Не зараз","nav.prev":"Назад","nav.next":"Далі","nav.done":"Готово","intro.button":"Почати","userSurvey.header":"Це перший раз, коли ви встановлюєте Opera?","userSurvey.newbie_header":"новачок","userSurvey.newbie_desc":"Так, я тут новенький","userSurvey.active_header":"активний","userSurvey.active_desc":"Ні, я просто перевстановлюю","userSurvey.returning_header":"що повертається","userSurvey.returning_desc":"Ні, я повертаюся до Opera після того, як не користувався нею деякий час","themes.header":"Який у вас настрій?","themes.subheader":"Виберіть тему браузера","themes.light":"Світла","themes.dark":"Темна","themes.system":"Система","wallpapers.header":"Який у вас стиль?","wallpapers.subheader":"Виберіть шпалери для початкової сторінки","adblocker.header":"Переглядайте веб-сторінки швидше й без реклами","adblocker.subheader":"Увімкніть блокування реклами","adblocker.label":"Блокування реклами","messengers.header":"Залишайтеся на зв’язку","messengers.subheader":"Додайте улюблені програми соцмереж","import.failed_header":"ПОМИЛКА ІМПОРТУ","import.failed_message":"Будь ласка, переконайтеся, що жодні інші завдання браузера не виконуються, і спробуйте ще раз","import.header":"Імпортуйте свої дані","import.subheader":"Виберіть браузер нижче","outro.header":"Ваш браузер Opera готовий","outro.button":"Почати веб-перегляд"}'),Nt=JSON.parse('{"nav.later":"Sau","nav.prev":"Trước","nav.next":"Tiếp","nav.done":"Xong","intro.button":"Bắt đầu","userSurvey.header":"Đây có phải lần đầu tiên bạn cài đặt Opera không?","userSurvey.newbie_header":"mới","userSurvey.newbie_desc":"Vâng, tôi mới ở đây","userSurvey.active_header":"hoạt động","userSurvey.active_desc":"Không, tôi chỉ đang cài đặt lại","userSurvey.returning_header":"trở lại","userSurvey.returning_desc":"Không, tôi quay lại Opera sau khi không sử dụng nó trong một thời gian","themes.header":"Tâm trạng của bạn là gì?","themes.subheader":"Chọn một chủ đề cho trình duyệt","themes.light":"Sáng","themes.dark":"Tối","themes.system":"Hệ thống","wallpapers.header":"Phong cách của bạn là gì?","wallpapers.subheader":"Chọn một hình nền cho Trang bắt đầu","adblocker.header":"Duyệt không quảng cáo nhanh hơn","adblocker.subheader":"Bật trình chặn quảng cáo lên","adblocker.label":"Chặn quảng cáo","messengers.header":"Theo kịp với mọi người","messengers.subheader":"Thêm các ứng dụng mạng xã hội yêu thích của bạn","import.failed_header":"LỖI NHẬP KHẨU","import.failed_message":"Vui lòng đảm bảo không có nhiệm vụ trình duyệt khác đang chạy và thử lại","import.header":"Nhập vệ dữ liệu của bạn","import.subheader":"Chọn một trình duyệt dưới đây","outro.header":"Trình duyệt Opera của bạn đã sẵn sàng","outro.button":"Bắt đầu duyệt"}'),Vt=JSON.parse('{"nav.later":"稍后","nav.prev":"上一步","nav.next":"下一步","nav.done":"完成","intro.button":"入门指南","userSurvey.header":"这是您第一次安装 Opera 吗？","userSurvey.newbie_header":"新手","userSurvey.newbie_desc":"是的，我是新用户","userSurvey.active_header":"活跃","userSurvey.active_desc":"不，我只是重新安装","userSurvey.returning_header":"回归","userSurvey.returning_desc":"不，我在一段时间不使用后回到 Opera","themes.header":"您的心情如何？","themes.subheader":"选择浏览器主题","themes.light":"浅色","themes.dark":"深色","themes.system":"系统","wallpapers.header":"您的风格是什么？","wallpapers.subheader":"选择首页墙纸","adblocker.header":"浏览速度更快，无广告","adblocker.subheader":"开启广告拦截","adblocker.label":"拦截广告","messengers.header":"关注任何人","messengers.subheader":"添加您最喜欢的社交应用","import.failed_header":"导入错误","import.failed_message":"请确保没有其他浏览器任务正在运行，然后重试","import.header":"导入您的数据","import.subheader":"在下面选择一个浏览器","outro.header":"您的 Opera 浏览器已就绪","outro.button":"开始浏览"}'),zt=JSON.parse('{"nav.later":"稍後","nav.prev":"上一頁","nav.next":"下一頁","nav.done":"完成","intro.button":"開始使用","userSurvey.header":"這是您第一次安裝 Opera 嗎？","userSurvey.newbie_header":"新手","userSurvey.newbie_desc":"是的，我是新用戶","userSurvey.active_header":"活躍","userSurvey.active_desc":"不，我只是重新安裝","userSurvey.returning_header":"回歸","userSurvey.returning_desc":"不，我在一段時間不使用後回到 Opera","themes.header":"您的心情如何？","themes.subheader":"選取瀏覽器佈景主題","themes.light":"淺色","themes.dark":"暗色","themes.system":"系統","wallpapers.header":"您的風格是什麼？","wallpapers.subheader":"選取開始頁面桌布","adblocker.header":"瀏覽速度更快，無廣告","adblocker.subheader":"開啟廣告阻擋功能","adblocker.label":"阻擋廣告","messengers.header":"追蹤任何人","messengers.subheader":"新增您最喜愛的社交應用程式","import.failed_header":"導入錯誤","import.failed_message":"請確保沒有其他瀏覽器任務正在運行，然後重試","import.header":"匯入您的資料","import.subheader":"在下面選取一個瀏覽器","outro.header":"您的 Opera 瀏覽器已就緒","outro.button":"開始瀏覽"}');var Bt,jt;we.use(Qe).use(De).init({lng:null===(Bt=chrome)||void 0===Bt||null===(jt=Bt.i18n)||void 0===jt?void 0:jt.getUILanguage(),fallbackLng:"en-GB",resources:{bg:{translation:Xe},bn:{translation:Ze},ca:{translation:et},cs:{translation:tt},da:{translation:rt},de:{translation:nt},el:{translation:at},"en-GB":{translation:it},"es-419":{translation:st},es:{translation:ot},fi:{translation:lt},fr:{translation:ut},hi:{translation:ct},hr:{translation:ht},hu:{translation:pt},id:{translation:ft},it:{translation:dt},ja:{translation:mt},ko:{translation:gt},lt:{translation:yt},lv:{translation:vt},ms:{translation:bt},no:{translation:kt},nl:{translation:xt},pl:{translation:St},"pt-PT":{translation:wt},"pt-BR":{translation:Et},ro:{translation:_t},ru:{translation:Pt},sk:{translation:Ct},sr:{translation:At},sv:{translation:Tt},sw:{translation:Mt},ta:{translation:Dt},te:{translation:It},th:{translation:Ft},tl:{translation:Ot},tr:{translation:Rt},uk:{translation:Lt},vi:{translation:Nt},"zh-CN":{translation:Vt},"zh-TW":{translation:zt}},keySeparator:!1,nsSeparator:!1,react:{useSuspense:!1},detection:{order:["querystring","navigator","htmlTag","path","subdomain"],caches:[]}});var Gt=__webpack_require__(3379),Ht=__webpack_require__.n(Gt),qt=__webpack_require__(7795),Ut=__webpack_require__.n(qt),Wt=__webpack_require__(569),$t=__webpack_require__.n(Wt),Kt=__webpack_require__(8575),Jt=__webpack_require__.n(Kt),Yt=__webpack_require__(9216),Qt=__webpack_require__.n(Yt),Xt=__webpack_require__(4589),Zt=__webpack_require__.n(Xt),er=__webpack_require__(9580),tr={attributes:{source:"opera-intro"}};tr.styleTagTransform=Zt(),tr.setAttributes=Jt(),tr.insert=$t().bind(null,"head"),tr.domAPI=Ut(),tr.insertStyleElement=Qt();Ht()(er.Z,tr);er.Z&&er.Z.locals&&er.Z.locals;var rr=__webpack_require__(4963),nr={attributes:{source:"opera-intro"}};nr.styleTagTransform=Zt(),nr.setAttributes=Jt(),nr.insert=$t().bind(null,"head"),nr.domAPI=Ut(),nr.insertStyleElement=Qt();Ht()(rr.Z,nr);rr.Z&&rr.Z.locals&&rr.Z.locals;var ar,ir,sr=function(e){opr.introductionPrivate.closeIntroduction(e)},or="dt_wp_standard_9.0";!function(e){e[e.NORMAL=opr.statsPrivate.Priority.NORMAL]="NORMAL",e[e.IMPORTANT=opr.statsPrivate.Priority.IMPORTANT]="IMPORTANT"}(ar||(ar={})),function(e){e.CLICK="click",e.VIEW="view"}(ir||(ir={}));var lr=function(e,t,r){var n={type:e,section:t,page:or};r&&(n.str_value=r),opr.statsPrivate.recordSessionEvent("feature_events.event_welcome_and_upgrade_page_metric",JSON.stringify(n),ar.NORMAL)};function ur(e,t){var r="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!r){if(Array.isArray(e)||(r=function(e,t){if(!e)return;if("string"==typeof e)return cr(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return cr(e,t)}(e))||t&&e&&"number"==typeof e.length){r&&(e=r);var n=0,a=function(){};return{s:a,n:function(){return n>=e.length?{done:!0}:{done:!1,value:e[n++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,o=!1;return{s:function(){r=r.call(e)},n:function(){var e=r.next();return s=e.done,e},e:function(e){o=!0,i=e},f:function(){try{s||null==r.return||r.return()}finally{if(o)throw i}}}}function cr(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}var hr,pr,fr,dr=new Set,mr=function(){var e=t(v().mark((function e(){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,new Promise((function(e){chrome.tabs.getCurrent(e)}));case 2:return e.abrupt("return",!e.sent);case 3:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}(),gr=function(){chrome.tabs.update(void 0,{url:"chrome://startpageshared"})},yr=function(){var e=t(v().mark((function e(){var t,r,n;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,mr();case 2:t=e.sent,r=ur(dr);try{for(r.s();!(n=r.n()).done;)(0,n.value)(t)}catch(e){r.e(e)}finally{r.f()}case 5:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}();chrome.tabs.onActivated.addListener(yr),function(e){e.WELCOME="welcome",e.SETUP="setup",e.DONE="done"}(hr||(hr={})),function(e){e.NONE="none",e.USER_SURVEY="user_survey",e.THEME="theme",e.WALLPAPER="wallpaper",e.ADBLOCKER="adblocker",e.MESSENGERS="messengers",e.IMPORT="import",e.SUMMARY="summary"}(pr||(pr={})),function(e){e.INTRO="intro_slide",e.USER_SURVEY="user_survey_slide",e.THEME="theme_slide",e.WALLPAPERS="wallpapers_slide",e.ADBLOCK="adblock_slide",e.MESSENGERS="messengers_slide",e.IMPORT="import_slide",e.OUTRO="outro_slide"}(fr||(fr={}));var vr=function(){var e=localStorage.getItem("route");return e&&Object.keys(hr).includes(e)?e:hr.WELCOME},br=function(e){var t=localStorage.getItem("feature");return e===hr.SETUP?t&&Object.keys(pr).includes(t)&&t!==pr.NONE?t:pr.THEME:pr.NONE};const kr=__webpack_require__.p+"88a9d8b720fa47faa0f7.png",xr=__webpack_require__.p+"a9a94f26040d1d617ba5.png",Sr=__webpack_require__.p+"5481ba37652e144d94d4.png",wr=__webpack_require__.p+"cda076c0b79d73963c46.png",Er=__webpack_require__.p+"38560e363670f4539ebf.png";function _r(e,t){var r="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!r){if(Array.isArray(e)||(r=function(e,t){if(!e)return;if("string"==typeof e)return Pr(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return Pr(e,t)}(e))||t&&e&&"number"==typeof e.length){r&&(e=r);var n=0,a=function(){};return{s:a,n:function(){return n>=e.length?{done:!0}:{done:!1,value:e[n++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,o=!1;return{s:function(){r=r.call(e)},n:function(){var e=r.next();return s=e.done,e},e:function(e){o=!0,i=e},f:function(){try{s||null==r.return||r.return()}finally{if(o)throw i}}}}function Pr(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}var Cr,Ar;!function(e){e.CHROME="chrome",e.EDGE="edge",e.FIREFOX="firefox",e.SAFARI="safari",e.GX="gx"}(Cr||(Cr={})),function(e){e.CHROME="Chrome",e.EDGE="Microsoft Edge",e.FIREFOX="Mozilla Firefox",e.SAFARI="Safari",e.GX="Opera GX"}(Ar||(Ar={}));var Tr,Mr,Dr=function(e){switch(e){case Ar.CHROME:return kr;case Ar.EDGE:return xr;case Ar.SAFARI:return wr;case Ar.FIREFOX:return Sr;case Ar.GX:return Er}};!function(e){e.COOKIES="cookies",e.HISTORY="history",e.FAVORITES="favorites",e.PASSWORDS="passwords",e.SEARCH_ENGINES="search_engines",e.AUTOFILL_FORM_DATA="autofill_form_data"}(Tr||(Tr={})),function(e){e.NONE="",e.SUCCESS="success",e.FAILURE="failure"}(Mr||(Mr={}));var Ir=function(e){return localStorage.getItem(e)||Mr.NONE},Fr=function(){var e=t(v().mark((function e(){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",new Promise((function(e){opr.operaBrowserPrivate.getUtmContent((function(t){e("ce"===t)}))})));case 1:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}(),Or=function(){var e=t(v().mark((function e(){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",new Promise((function(e){opr.importPrivate.detectImporters((function(t){var r=t.filter((function(e){return Object.values(Ar).includes(e.name)}));e(r)}))})));case 1:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}(),Rr=function(){var e=localStorage.getItem("importFailedData");return e?JSON.parse(e):[]},Lr=function(e){var t=function(e){var t=Rr(),r=[];if(0===t.length)return r;var n=e.name,a=t.find((function(e){return e.browserName==n}));return a?a.browserName===Ar.FIREFOX?e.supportedServices:r.concat(a.failed):r}(e),r=0!==t.length?t:e.supportedServices;return new Promise((function(t){opr.importPrivate.importData(e.id,r,(function(r){var n,a;"Import failed"===(null===(n=chrome.runtime.lastError)||void 0===n?void 0:n.message)?(a=Mr.FAILURE,r&&Nr(r,e.name)):a=Mr.SUCCESS,function(e,t){localStorage.setItem(e,t),jr()}(e.name,a),t(a)}))}))},Nr=function(e,t){var r={browserName:t,failed:e},n=Rr();n.some((function(r){return r.failed==e&&r.browserName==t}))||n.push(r),localStorage.setItem("importFailedData",JSON.stringify(n))},Vr=function(){var e=t(v().mark((function e(){var t,r,n;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,Or();case 2:return t=e.sent,r=Rr(),n=function(e,n,a){var i,s=Ir(n);s===Mr.NONE&&(r.find((function(e){return e.browserName===n}))&&(s=Mr.FAILURE));return{key:e,name:n,label:a,icon:Dr(n),importer:null!==(i=t.find((function(e){return e.name===n})))&&void 0!==i?i:null,state:s}},e.abrupt("return",[n(Cr.CHROME,Ar.CHROME,Ee("browser.chrome")),n(Cr.EDGE,Ar.EDGE,Ee("browser.edge")),n(Cr.SAFARI,Ar.SAFARI,Ee("browser.safari")),n(Cr.FIREFOX,Ar.FIREFOX,Ee("browser.firefox")),n(Cr.GX,Ar.GX,Ee("browser.gx"))]);case 6:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}(),zr=function(){for(var e=[],t=0,r=Object.values(Ar);t<r.length;t++){var n=r[t];Ir(n)===Mr.SUCCESS&&e.push(n)}return e},Br=new Set,jr=function(){var e,t=zr(),r=_r(Br);try{for(r.s();!(e=r.n()).done;){(0,e.value)(t)}}catch(e){r.e(e)}finally{r.f()}};window.addEventListener("storage",jr);var Gr={BeVietnamProBold:{family:"Be Vietnam Pro",weight:700,size:48},BeVietnamProRegular:{family:"Be Vietnam Pro",weight:400,size:24},SpaceMonoBold:{family:"Space Mono",weight:700,size:48},SpaceMonoRegular:{family:"Space Mono",weight:400,size:24},AvertaRegular:{family:"Averta",weight:400,size:15}};function Hr(e){return qr.apply(this,arguments)}function qr(){return(qr=t(v().mark((function e(t){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.prev=0,e.next=3,document.fonts.load("normal ".concat(t.weight," ").concat(t.size,'px "').concat(t.family,'"'));case 3:return e.abrupt("return",!0);case 6:return e.prev=6,e.t0=e.catch(0),console.warn("Failed to load font: ".concat(t.family)),e.abrupt("return",!1);case 10:case"end":return e.stop()}}),e,null,[[0,6]])})))).apply(this,arguments)}function Ur(){var e=!1;return new Promise((function(r){var n=!1;document.fonts.addEventListener("loading",t(v().mark((function t(){var a,i,s;return v().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:a=0,i=Object.values(Gr);case 1:if(!(a<i.length)){t.next=10;break}return s=i[a],t.next=5,Hr(s);case 5:t.sent||(n=!0);case 7:a++,t.next=1;break;case 10:e||(r(!n),e=!0);case 11:case"end":return t.stop()}}),t)}))))}))}function Wr(){return Wr=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e},Wr.apply(this,arguments)}function $r(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return{className:Kr(t)}}function Kr(e){if(!e)return"";if("string"==typeof e)return e;if(Array.isArray(e))return e.reduce((function(e,t){return t?"string"==typeof t?(e.push(t),e):(e.push(Kr(t)),e):e}),[]).filter((function(e){return e})).join(" ");if("object"===n(e))return 0===Object.keys(e).length?"":Object.keys(e).map((function(t){return e[t]&&t})).filter((function(e){return e})).join(" ");throw new Error("Invalid value: ".concat(JSON.stringify(e)))}var Jr;!function(e){e.FORWARD="forward",e.BACKWARD="backward"}(Jr||(Jr={}));var Yr,Qr="start",Xr="end",Zr="key-nav";!function(e){e[e.START=1]="START",e[e.ITEM=2]="ITEM",e[e.SKIP=3]="SKIP",e[e.DOT=4]="DOT",e[e.NAV=5]="NAV",e[e.END=6]="END"}(Yr||(Yr={}));var en,tn,rn,nn=function(e){"Tab"===e.code&&function(e,t){var r=document.activeElement.classList;if(r.contains(Zr))if(t===Jr.BACKWARD){if(document.activeElement===document.body||r.contains(Qr)){var n=document.querySelector(".".concat(Zr,".").concat(Xr));null==n||n.focus(),e.preventDefault()}}else if(document.activeElement===document.body||r.contains(Xr)){var a=document.querySelector(".".concat(Zr,".").concat(Qr));null==a||a.focus(),e.preventDefault()}}(e,e.shiftKey?Jr.BACKWARD:Jr.FORWARD)},an=function(e){var t=e.isStart,r=(0,b.useRef)(null);return(0,b.useEffect)((function(){r.current&&t&&r.current.focus()}),[t,r]),b.createElement("span",Wr({ref:r},$r(Zr,t?Qr:Xr),{tabIndex:t?Yr.START:Yr.END}))};function sn(e,t){var r="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!r){if(Array.isArray(e)||(r=function(e,t){if(!e)return;if("string"==typeof e)return on(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return on(e,t)}(e))||t&&e&&"number"==typeof e.length){r&&(e=r);var n=0,a=function(){};return{s:a,n:function(){return n>=e.length?{done:!0}:{done:!1,value:e[n++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,o=!1;return{s:function(){r=r.call(e)},n:function(){var e=r.next();return s=e.done,e},e:function(e){o=!0,i=e},f:function(){try{s||null==r.return||r.return()}finally{if(o)throw i}}}}function on(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}!function(e){e.NEWBIE="newbie",e.ACTIVE="active",e.RETURNING="returning"}(en||(en={})),function(e){e[e.SYSTEM=-1]="SYSTEM",e[e.LIGHT=0]="LIGHT",e[e.DARK=1]="DARK"}(tn||(tn={})),function(e){e.FIRST_STEP="ab_testing.onboarding_first_step",e.DARK_THEME="ui.dark_skin",e.COLOR_THEME="ui.dark_skin_settings_proxy",e.AD_BLOCKER_ENABLED="adblocker.enabled"}(rn||(rn={}));var ln=new Set,un=function(e){return new Promise((function(t){chrome.settingsPrivate.getPref(e,(function(e){t(e.value)}))}))},cn=function(e,t){chrome.settingsPrivate.setPref(e,t,or)},hn=function(e,t){var r={name:e,listener:t};return ln.add(r),un(e).then(t),function(){ln.delete(r)}},pn=function(e){cn(rn.COLOR_THEME,e)},fn=function(e){return hn(rn.COLOR_THEME,e)},dn=function(){return un(rn.DARK_THEME)},mn=function(e){return hn(rn.DARK_THEME,e)},gn=function(e){cn(rn.AD_BLOCKER_ENABLED,e)},yn=function(e){return hn(rn.AD_BLOCKER_ENABLED,(function(t){e(t)}))};chrome.settingsPrivate.onPrefsChanged.addListener((function(e){var t,r=sn(e);try{for(r.s();!(t=r.n()).done;){var n,a=t.value,i=sn(ln);try{for(i.s();!(n=i.n()).done;){var s=n.value;a.key===s.name&&s.listener(a.value)}}catch(e){i.e(e)}finally{i.f()}}}catch(e){r.e(e)}finally{r.f()}}));const vn=__webpack_require__.p+"185145efabf50976fdfb.jpg",bn=__webpack_require__.p+"91bfc672d518e05bf02d.jpg",kn=__webpack_require__.p+"99aaaf6a69b4e18c92b0.jpg",xn=__webpack_require__.p+"384b42a608fce5d4a1d6.jpg",Sn=__webpack_require__.p+"0968ac62b8504efada7a.jpg",wn=__webpack_require__.p+"439f3447a96cad7c116c.jpg",En=__webpack_require__.p+"dc8e6d22f2d58eab7e86.jpg",_n=__webpack_require__.p+"d92eb252936a5b7d251c.jpg",Pn=__webpack_require__.p+"16bdf796f3ba68f0e3b6.jpg",Cn=__webpack_require__.p+"b989550d0ff55f3e681a.jpg",An=__webpack_require__.p+"2d3a5e698cd1a50a25a3.jpg",Tn=__webpack_require__.p+"36ccdd1bf26354d5ce27.jpg";function Mn(e,t){var r="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!r){if(Array.isArray(e)||(r=function(e,t){if(!e)return;if("string"==typeof e)return Dn(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return Dn(e,t)}(e))||t&&e&&"number"==typeof e.length){r&&(e=r);var n=0,a=function(){};return{s:a,n:function(){return n>=e.length?{done:!0}:{done:!1,value:e[n++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,o=!1;return{s:function(){r=r.call(e)},n:function(){var e=r.next();return s=e.done,e},e:function(e){o=!0,i=e},f:function(){try{s||null==r.return||r.return()}finally{if(o)throw i}}}}function Dn(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}function In(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,n)}return r}function Fn(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?In(Object(r),!0).forEach((function(t){x(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):In(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}var On;!function(e){e.DEFAULT="bundled%2Fdefault",e.LOW_GLOW="opera-one-lowglow",e.DARK_LIGHT="opera-one-darklight",e.GREEN_HIGH="a37be41c44b408ae9fa991a4681760eefb1d8994",e.PINK_HIGH="626beaaeca74e01c1f5d162df8502adb90901d13",e.PURPLE_HIGH="f31a840daa258e607b5f5e0bebfd4f9f9ecaac00"}(On||(On={}));var Rn,Ln=function(e,t){var r=(t?Nn:Vn).find((function(t){return t.id===e.id}));return r?Fn(Fn({},r),{},{textColor:e.titleTextColor,shadowColor:e.titleTextShadowColor}):null},Nn=[{id:On.DEFAULT,background:Cn,thumbnail:xn},{id:On.DARK_LIGHT,background:An,thumbnail:Sn},{id:On.PINK_HIGH,background:Tn,thumbnail:wn}],Vn=[{id:On.GREEN_HIGH,background:_n,thumbnail:bn},{id:On.PURPLE_HIGH,background:Pn,thumbnail:kn},{id:On.LOW_GLOW,background:En,thumbnail:vn}],zn=function(){return new Promise((function(e){opr.wallpapersPrivate.getSelected((function(t){e(t)}))}))},Bn=function(){var e=t(v().mark((function e(t){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,jn(t);case 2:if(!e.sent){e.next=6;break}qn(t),e.next=8;break;case 6:return e.next=8,Hn(t);case 8:case"end":return e.stop()}}),e)})));return function(t){return e.apply(this,arguments)}}(),jn=function(){var e=t(v().mark((function e(t){var r;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,Gn();case 2:return r=e.sent,e.abrupt("return",r.map((function(e){return e.id})).includes(t));case 4:case"end":return e.stop()}}),e)})));return function(t){return e.apply(this,arguments)}}(),Gn=function(){return new Promise((function(e){opr.wallpapersPrivate.getInstalled((function(t){e(t)}))}))},Hn=function(e){return new Promise((function(t){chrome.addonsPrivate.installTheme(e,t)}))},qn=function(e){return new Promise((function(t){opr.wallpapersPrivate.select(e,t)}))},Un=new Set,Wn=function(e){return Un.add(e),zn().then(e),function(){Un.delete(e)}},$n=function(){var e=t(v().mark((function e(){var t,r,n;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,zn();case 2:t=e.sent,r=Mn(Un);try{for(r.s();!(n=r.n()).done;)(0,n.value)(t)}catch(e){r.e(e)}finally{r.f()}case 5:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}();function Kn(e){var t=e.isReady,r=g((0,b.useState)(null),2),n=r[0],a=r[1],i=g((0,b.useState)(!1),2),s=i[0],o=i[1];(0,b.useEffect)((function(){return mn((function(e){return o(e)}))}),[]),(0,b.useEffect)((function(){return Wn((function(e){a(e?Ln(e,s):null)}))}),[s]);var l=t&&n?n.background:null;return b.createElement("section",{className:"background"},b.createElement("div",{className:"active base layer"}),b.createElement("div",$r({active:t&&!s},"light","layer")),b.createElement("div",$r({active:t&&s},"dark","layer")),l&&b.createElement("div",{className:"active wallpaper layer",style:{backgroundImage:"url(".concat(l,")")}}))}function Jn(e){return(0,b.useEffect)((function(){e.isActive&&lr(ir.VIEW,e.section)}),[e.isActive,e.section]),b.createElement("section",{id:e.name,className:"page"},b.createElement("div",{className:"content"},b.createElement("div",{className:"header"},b.createElement("h1",{className:Kr(["title",{wide:e.title.length>=25&&e.title.length<40,widest:e.title.length>=40}])},e.title),b.createElement("h2",{className:"subtitle"},e.subtitle)),b.createElement("div",{className:"feature"},e.children)))}opr.wallpapersPrivate.onSelectionChanged.addListener($n),function(e){e.FORWARD="forward",e.BACKWARD="backward"}(Rn||(Rn={}));var Yn=function(e,t){["Enter","Space"].includes(e.code)&&t()};function Qn(e){var t=e.slides,r=e.isOverlay,n=e.active,a=e.later,i=e.prev,s=e.next,o=e.goTo,l=e.done,u=t[n-1].feature,c=(0,b.useContext)(ii).popup;return b.createElement("div",{className:"navigation"},b.createElement("div",{className:"controls"},b.createElement("div",{className:"left"},r&&![pr.THEME,pr.WALLPAPER,pr.USER_SURVEY].includes(u)&&b.createElement("span",{className:"later link",onClick:a,onKeyDown:function(e){return Yn(e,a)},tabIndex:c?void 0:Yr.SKIP},Ee("nav.later"))),b.createElement("div",{className:"right"},n>1&&b.createElement("span",{className:"prev link",onClick:i,onKeyDown:function(e){return Yn(e,i)},tabIndex:c?void 0:Yr.NAV},Ee("nav.prev")),(!e.unskippable||1!==n)&&b.createElement("span",{className:"next link",onClick:n===t.length?l:s,onKeyDown:function(e){return Yn(e,n===t.length?l:s)},tabIndex:c?void 0:Yr.NAV},n===t.length?Ee("nav.done"):Ee("nav.next")))),(!e.unskippable||1!==n)&&b.createElement("div",{className:"pagination"},b.createElement("div",{className:"dots"},t.map((function(e,t){var r=t+1===n,a=function(){r||o(t+1)};return b.createElement("span",{onClick:a,onKeyDown:function(e){return Yn(e,a)},key:t,className:Kr(["dot",{active:r}]),tabIndex:c?void 0:Yr.DOT})})))))}function Xn(e){var t=e.slides,r=e.isOverlay,n=e.isReady,a=(0,b.useContext)(ii),i=a.feature,s=a.setFeature,o=a.setRoute,l=t.findIndex((function(e){return e.feature===i}))+1,u=g((0,b.useState)(Rn.FORWARD),2),c=u[0],h=u[1],p=g((0,b.useState)(pr.NONE),2),f=p[0],d=p[1],m=(0,b.useRef)(pr.NONE),y=g((0,b.useState)(),2),v=y[0],k=y[1];(0,b.useEffect)((function(){k(opr.featuresPrivate.isFeatureEnabled("opera-one-unskippable-introduction"))}),[]),(0,b.useEffect)((function(){m.current!==i&&d(m.current),m.current=i}),[i]);var x=function(e){var r=t[l-1].section;lr(ir.CLICK,r,"".concat(e,"_button"))},S=function(e){h(e>l?Rn.FORWARD:Rn.BACKWARD),s(t[e-1].feature)},w=function(e){S(l+1),e||x("next")};return b.createElement("div",{className:Kr(["gallery",c])},b.createElement("div",{className:"screens"},t.map((function(e,r){var a=r+1,s=1===a,o=a===t.length-1,l=e.feature===pr.SUMMARY,u=e.feature===f,c=e.feature===i&&n,h=e.content;return b.createElement("div",{key:r,className:Kr(["screen",{dismissed:u,active:c}])},b.createElement(Jn,{key:r,name:e.feature,section:e.section,title:e.title,subtitle:e.subtitle,number:a,isFirst:s,isLast:o,isSummary:l,isDismissed:u,isActive:c},b.createElement(h,{isActive:c,next:w})))}))),n&&l>0&&l<=t.length&&b.createElement(Qn,{isOverlay:r,slides:t,active:l,unskippable:v,later:function(){x("later"),lr(ir.VIEW,fr.OUTRO),e.isOverlay&&sr(!0)},prev:function(){S(l-1),x("back")},next:function(){return w(!1)},goTo:function(e){S(e),x("dot")},done:function(){o(hr.DONE),s(pr.NONE),x("next")}}))}function Zn(){var e=Ee("outro.header");return b.createElement("section",{id:"summary"},b.createElement("div",{className:"content"},b.createElement("div",{className:"header"},b.createElement("h1",{className:"title"},e),b.createElement("span",{className:"start"},Ee("outro.button"))),b.createElement("section",{className:"preview"},b.createElement("i",{className:"desktop"}),b.createElement("i",{className:"android"}),b.createElement("i",{className:"ios"}))))}function ea(e){var t=e.isReady,r=e.isOverlay,n=e.slides,a=(0,b.useContext)(ii).route;return b.createElement("section",{className:"contents"+(t?" ready":"")},b.createElement("i",{className:"opera-logo"}),a!==hr.DONE&&b.createElement(Xn,{isOverlay:r,isReady:t,slides:n}),t&&a===hr.DONE&&b.createElement(Zn,null))}var ta=function(e,t,r){var n=e.steps[0],a=new KeyframeEffect(t,n.keyframes,{duration:n.duration,delay:n.delay,easing:n.easing,fill:"forwards",pseudoElement:r}),i=new Animation(a,document.timeline);i.play(),i.onfinish=function(){var t,r;null===(t=e.onStepFinished)||void 0===t||t.call(e,n.name),null===(r=n.onFinished)||void 0===r||r.call(n)}},ra=function(e,t){ta({name:"welcome",steps:[{name:"focus",duration:1800,delay:0,easing:"ease-in-out",keyframes:[{opacity:0,filter:"blur(20px)",offset:0},{opacity:1,filter:"blur(20px)",offset:.6},{opacity:1,filter:"blur(0)",offset:1}],onFinished:t}]},e,null)},na=function(e,t,r,n,a){ta({name:"disappear",steps:[{name:"fade out",duration:r,delay:n,easing:"ease-in-out",keyframes:[{opacity:1},{opacity:0}],onFinished:a}]},e,t)},aa=function(e,t,r,n,a){ta({name:"shrink",steps:[{name:"shink",duration:r,delay:n,easing:"ease-in-out",keyframes:[{width:"".concat(e.offsetWidth,"px")},{width:0}],onFinished:a}]},e,t)},ia=function(e,t,r,n,a){var i=getComputedStyle(e),s=parseFloat(i.paddingLeft),o=parseFloat(i.paddingRight),l=e.offsetWidth-s-o;ta({name:"shrink",steps:[{name:"shink",duration:r,delay:n,easing:"ease-in-out",keyframes:[{transform:"scale(1)"},{transform:"scale(".concat(window.innerWidth/l,")")}],onFinished:a}]},e,t)};function sa(e){var t=(0,b.useRef)(),r=(0,b.useRef)(),n=e.isTriggered,a=e.onFinished;return(0,b.useEffect)((function(){if(t.current&&r.current){var e=t.current,n=r.current;n.style.width="".concat(n.offsetWidth,"px"),n.style.boxSizing="border-box",ra(e)}}),[t,r]),(0,b.useEffect)((function(){if(n&&t.current&&r.current){var e=t.current,i=r.current;e.style.pointerEvents="none",na(i,null,500,0,(function(){i.style.padding="0",aa(i,null,300,0,(function(){e.classList.add("active"),ia(e,null,1400,200,(function(){a()}))}))}))}}),[n,a,t,r]),b.createElement("span",{ref:t,className:"get-started"},b.createElement("span",{ref:r,className:"label"},b.createElement("span",{className:"logo"}),b.createElement("span",{className:"text"},Ee("intro.button"))))}function oa(e){var t=(0,b.useRef)();return(0,b.useEffect)((function(){lr(ir.VIEW,fr.INTRO)}),[]),b.createElement("section",{className:"overlay",ref:t},b.createElement("div",{className:"container"},b.createElement(sa,{isTriggered:e.isAnimationTriggered,onFinished:e.onAnimationFinished})))}var la=function(e){return e===Mr.FAILURE?{type:e,header:Ee("import.failed_header"),message:Ee("import.failed_message")}:null};function ua(e){return b.createElement("span",{className:"close",onClick:e.onClose,tabIndex:Yr.SKIP,onKeyDown:function(t){["Enter","Space"].includes(t.code)&&(e.onClose(),t.preventDefault())}},b.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",width:"12",height:"13",viewBox:"0 0 12 13",fill:"none"},b.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M0.526544 0.743196C0.208356 1.06746 0.208355 1.59319 0.526543 1.91745L4.8794 6.35339L0.23864 11.0827C-0.0795473 11.407 -0.0795466 11.9327 0.238641 12.257C0.556829 12.5812 1.07271 12.5812 1.3909 12.257L6.03166 7.52765L10.6088 12.1922C10.927 12.5164 11.4429 12.5164 11.7611 12.1922C12.0793 11.8679 12.0793 11.3422 11.7611 11.0179L7.18392 6.35339L11.4732 1.98227C11.7914 1.65801 11.7914 1.13228 11.4732 0.808014C11.155 0.483753 10.6391 0.483753 10.3209 0.808014L6.03166 5.17914L1.6788 0.743196C1.36062 0.418935 0.844731 0.418935 0.526544 0.743196Z",fill:"var(--primary-text-color)"})))}function ca(e){return b.createElement(b.Fragment,null,b.createElement("div",{key:"fade",className:"fade",onClick:e.onClose}),b.createElement("div",Wr({key:"popup"},$r("popup",e.type)),b.createElement("div",{className:"header"},b.createElement("span",null,e.header),b.createElement(ua,{onClose:e.onClose})),e.message&&b.createElement("div",{className:"message"},e.message)))}function ha(e){var t=e.isOverlay,r=e.isReady,n=e.slides,a=e.startBrowsing,i=e.closeIntroduction,s=(0,b.useContext)(ii),o=s.route,l=s.setRoute,u=s.feature,c=s.setFeature,h=s.popup,p=s.setPopup,f=n.findIndex((function(e){return e.feature===u}))+1,d=[hr.DONE,hr.SETUP].includes(o),m=g((0,b.useState)(!1),2),y=m[0],v=m[1],k=g((0,b.useState)(),2),x=k[0],S=k[1],w=(0,b.useCallback)((function(){v(!0),lr(ir.CLICK,fr.INTRO,"launch_button")}),[]);(0,b.useEffect)((function(){var e;e=n[0],c(e.feature)}),[n.length]),(0,b.useEffect)((function(){S(opr.featuresPrivate.isFeatureEnabled("opera-one-unskippable-introduction"));var e=function(e){if(!x||1!==f){if(nn(e),h)return void("Escape"===e.code&&p(null));if("Escape"===e.code&&t&&(o===hr.SETUP&&i(),o===hr.DONE&&a()),["Enter","Space"].includes(e.code))switch(o){case hr.WELCOME:w();break;case hr.DONE:a()}if(o===hr.SETUP){var r=function(e){c(n[e-1].feature)};n.map((function(e,t){return String(t+1)})).includes(e.key)&&r(parseInt(e.key));var s=n.findIndex((function(e){return e.feature===u}))+1;"ArrowRight"===e.key&&(s<n.length?r(s+1):(l(hr.DONE),c(pr.NONE))),"ArrowLeft"===e.key&&s>1&&r(s-1)}}};return document.addEventListener("keydown",e),function(){document.removeEventListener("keydown",e)}}),[t,n,o,l,u,c,h,p,w,a,i,f]);var E=la(h);return b.createElement("main",Wr({},$r(["onboarding",o,{hidden:!r}]),{onMouseDownCapture:function(e){if(0===e.button)switch(o){case hr.WELCOME:w();break;case hr.DONE:a()}},onContextMenuCapture:function(e){e.preventDefault(),e.stopPropagation()}}),b.createElement(an,{isStart:!0}),b.createElement(Kn,{isReady:d}),b.createElement(ea,{isOverlay:t,isReady:d,slides:n,startBrowsing:a,onSetupFinished:function(){l(hr.DONE),c(pr.NONE)}}),h&&E&&b.createElement(ca,{type:h,header:E.header,message:E.message,onClose:function(){p(null)}}),o===hr.WELCOME&&b.createElement(oa,{isAnimationTriggered:y,onAnimationFinished:function(){var e=n[0];l(hr.SETUP),c(e.feature)}}),b.createElement(an,{isStart:!1}))}var pa=__webpack_require__(1248),fa=__webpack_require__.n(pa);function da(e){var t=b.useRef(null),r=b.useRef(null);return b.useEffect((function(){var n,a;r.current&&(t.current||(t.current=fa().loadAnimation({container:r.current,renderer:"svg",animationData:e.animationData,loop:null===(n=e.loop)||void 0===n||n,autoplay:null===(a=e.autoplay)||void 0===a||a,initialSegment:e.frames}),e.onComplete&&t.current.addEventListener("complete",e.onComplete)))}),[t,e.animationData,e.loop,e.autoplay,e.frames,e.onComplete]),b.useEffect((function(){t&&(t.current=t.current)}),[t]),b.createElement("div",{ref:r})}const ma=JSON.parse('{"v":"5.9.0","fr":30,"ip":0,"op":35,"w":704,"h":440,"nm":"THEMES-onboarding-adblocker_DARK","ddd":0,"assets":[{"id":"comp_0","nm":"AD-darkmode","fr":30,"layers":[{"ddd":0,"ind":1,"ty":4,"nm":"close Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[707.25,682.75,0],"ix":2,"l":2},"a":{"a":0,"k":[6.5,5,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[0,0],[0,0]],"o":[[0,0],[0,0]],"v":[[10.391,8.539],[2.566,1.468]],"c":false},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"st","c":{"a":0,"k":[1,1,1,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":1.5,"ix":5},"lc":1,"lj":1,"ml":4,"bm":0,"nm":"Stroke 1","mn":"ADBE Vector Graphic - Stroke","hd":false},{"ind":2,"ty":"sh","ix":3,"ks":{"a":0,"k":{"i":[[0,0],[0,0]],"o":[[0,0],[0,0]],"v":[[2.57,8.539],[10.395,1.468]],"c":false},"ix":2},"nm":"Path 2","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"st","c":{"a":0,"k":[1,1,1,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":1.5,"ix":5},"lc":1,"lj":1,"ml":4,"bm":0,"nm":"Stroke 2","mn":"ADBE Vector Graphic - Stroke","hd":false}],"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":2,"ty":4,"nm":"mask-ad","td":1,"sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[652.75,772,0],"ix":2,"l":2},"a":{"a":0,"k":[42,60,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-8.837,0],[0,0],[0,-8.837],[0,0],[8.837,0],[0,0],[0,8.837],[0,0]],"o":[[0,0],[8.837,0],[0,0],[0,8.837],[0,0],[-8.837,0],[0,0],[0,-8.837]],"v":[[16,0],[68,0],[84,16],[84,104],[68,120],[16,120],[0,104],[0,16]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.729411764706,0.674509803922,0.823529471603,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":3,"ty":4,"nm":"gradient","tt":1,"sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[652.75,712,0],"ix":2,"l":2},"a":{"a":0,"k":[-380.211,76.607,0],"ix":1,"l":2},"s":{"a":0,"k":[121.087,121.087,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ty":"gr","it":[{"d":1,"ty":"el","s":{"a":0,"k":[229.039,229.039],"ix":2},"p":{"a":0,"k":[0,0],"ix":3},"nm":"Ellipse Path 1","mn":"ADBE Vector Shape - Ellipse","hd":false},{"ty":"gf","o":{"a":0,"k":100,"ix":10},"r":1,"bm":0,"g":{"p":3,"k":{"a":0,"k":[0.403,0.094,0.082,0.118,0.701,0.122,0.098,0.182,1,0.149,0.114,0.247],"ix":9}},"s":{"a":0,"k":[0,0],"ix":5},"e":{"a":0,"k":[94.125,64.18],"ix":6},"t":2,"h":{"a":0,"k":0,"ix":7},"a":{"a":0,"k":0,"ix":8},"nm":"Gradient Fill 1","mn":"ADBE Vector Graphic - G-Fill","hd":false},{"ty":"tr","p":{"a":0,"k":[-380.211,76.607],"ix":2},"a":{"a":0,"k":[0,0],"ix":1},"s":{"a":0,"k":[157.36,157.36],"ix":3},"r":{"a":0,"k":0,"ix":6},"o":{"a":0,"k":100,"ix":7},"sk":{"a":0,"k":0,"ix":4},"sa":{"a":0,"k":0,"ix":5},"nm":"Transform"}],"nm":"Ellipse 1","np":2,"cix":2,"bm":0,"ix":1,"mn":"ADBE Vector Group","hd":false}],"ip":0,"op":178,"st":0,"bm":0}]}],"layers":[{"ddd":0,"ind":1,"ty":4,"nm":"tic","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[-347,109,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":25,"s":[100,100,100]},{"t":29,"s":[10,10,100]}],"ix":6,"l":2}},"ao":0,"shapes":[{"ty":"gr","it":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[0,0],[0,0],[0,0]],"o":[[0,0],[0,0],[0,0]],"v":[[-373.25,110.75],[-351.312,133.188],[-321.75,87.75]],"c":false},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":1},"e":{"a":1,"k":[{"i":{"x":[0.667],"y":[0.306]},"o":{"x":[0.333],"y":[0]},"t":16,"s":[0]},{"i":{"x":[0.667],"y":[-5.25]},"o":{"x":[0.333],"y":[6.25]},"t":20,"s":[36]},{"i":{"x":[0.419],"y":[0.998]},"o":{"x":[0.333],"y":[0.293]},"t":21,"s":[36]},{"t":24,"s":[100]}],"ix":2},"o":{"a":0,"k":0,"ix":3},"m":1,"ix":2,"nm":"Trim Paths 1","mn":"ADBE Vector Filter - Trim","hd":false},{"ty":"st","c":{"a":0,"k":[0.301960784314,0.301960784314,0.400000029919,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":9,"ix":5},"lc":2,"lj":2,"bm":0,"nm":"Stroke 1","mn":"ADBE Vector Graphic - Stroke","hd":false},{"ty":"tr","p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":1},"s":{"a":0,"k":[100,100],"ix":3},"r":{"a":0,"k":0,"ix":6},"o":{"a":0,"k":100,"ix":7},"sk":{"a":0,"k":0,"ix":4},"sa":{"a":0,"k":0,"ix":5},"nm":"Transform"}],"nm":"Shape 1","np":3,"cix":2,"bm":0,"ix":1,"mn":"ADBE Vector Group","hd":false}],"ip":16,"op":29,"st":-44,"bm":0},{"ddd":0,"ind":2,"ty":4,"nm":"adblock-icon Outlines","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":12,"s":[0]},{"t":14,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[352,249.5,0],"ix":2,"l":2},"a":{"a":0,"k":[40,40,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":12,"s":[10,10,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":14,"s":[220,220,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":18,"s":[180,180,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":24,"s":[200,200,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":25,"s":[200,200,100]},{"t":29,"s":[10,10,100]}],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-4.994,0.921],[-1.246,-0.231],[-3.544,-1.604],[0,-1.73],[0,0],[5.595,-3.317],[0,0],[1.591,0.945],[0,0],[0,6.182],[0,0],[-1.673,0.754]],"o":[[1.246,-0.231],[4.994,0.921],[1.668,0.754],[0,0],[0,6.182],[0,0],[-1.591,0.945],[0,0],[-5.6,-3.317],[0,0],[0,-1.73],[3.539,-1.604]],"v":[[38.138,10.173],[41.852,10.173],[63.961,15.288],[66.662,19.341],[66.662,45.098],[57.682,60.349],[42.599,69.291],[37.391,69.291],[22.313,60.349],[13.328,45.098],[13.328,19.341],[16.034,15.288]],"c":true},"ix":2},"nm":"Path 2","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.011764705882,0.023529411765,0.082352941176,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":12,"op":29,"st":-48,"bm":0},{"ddd":0,"ind":3,"ty":0,"nm":"AD-darkmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":8,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":12,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":27,"s":[0]},{"t":31,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[553.896,246.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.146,768.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":3,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":6,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":12,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,1]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":27,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,0]},"t":30,"s":[81.36,81.36,100]},{"t":37,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":4,"ty":0,"nm":"AD-darkmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":7,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":11,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":26,"s":[0]},{"t":30,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353.896,246.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.146,768.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":2,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":5,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":11,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,1]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":26,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,0]},"t":29,"s":[81.36,81.36,100]},{"t":36,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":5,"ty":0,"nm":"AD-darkmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":6,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":10,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":25,"s":[0]},{"t":29,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[153.896,246.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.146,768.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":1,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":4,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":10,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,1]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":25,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,0]},"t":28,"s":[81.36,81.36,100]},{"t":35,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":6,"ty":4,"nm":"browser-bg-top Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[350,57,0],"ix":2,"l":2},"a":{"a":0,"k":[158,12,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-4.418,0],[0,0],[0,-4.418],[0,0],[4.418,0],[0,0],[0,4.418],[0,0]],"o":[[0,0],[4.418,0],[0,0],[0,4.418],[0,0],[-4.418,0],[0,0],[0,-4.418]],"v":[[8,0],[308,0],[316,8],[316,16],[308,24],[8,24],[0,16],[0,8]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.301960784314,0.301960784314,0.4,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":7,"ty":4,"nm":"browser-bg-bottom Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[158,76,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-6.627,0],[0,0],[0,-6.627],[0,0],[6.627,0],[0,0],[0,6.627],[0,0]],"o":[[0,0],[6.627,0],[0,0],[0,6.627],[0,0],[-6.627,0],[0,0],[0,-6.627]],"v":[[12,0],[304,0],[316,12],[316,140],[304,152],[12,152],[0,140],[0,12]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.301960784314,0.301960784314,0.4,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":8,"ty":4,"nm":"browser-bg-all","sr":1,"ks":{"o":{"a":0,"k":50,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[158,76,0],"ix":1,"l":2},"s":{"a":0,"k":[210.526,210.526,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-6.627,0],[0,0],[0,-6.627],[0,0],[6.627,0],[0,0],[0,6.627],[0,0]],"o":[[0,0],[6.627,0],[0,0],[0,6.627],[0,0],[-6.627,0],[0,0],[0,-6.627]],"v":[[12,-33.25],[303.525,-33.25],[315.525,-21.25],[315.525,143.8],[303.525,155.8],[12,155.8],[0,143.8],[0,-21.25]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.011764705882,0.023529411765,0.082352941176,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0}],"markers":[]}'),ga=JSON.parse('{"v":"5.9.0","fr":30,"ip":0,"op":35,"w":704,"h":440,"nm":"THEMES-onboarding-adblocker","ddd":0,"assets":[{"id":"comp_0","nm":"AD-lightmode","fr":30,"layers":[{"ddd":0,"ind":1,"ty":4,"nm":"close Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[707.25,682.75,0],"ix":2,"l":2},"a":{"a":0,"k":[6.5,5,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[0,0],[0,0]],"o":[[0,0],[0,0]],"v":[[10.391,8.539],[2.566,1.468]],"c":false},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"st","c":{"a":0,"k":[1,1,1,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":1.5,"ix":5},"lc":1,"lj":1,"ml":4,"bm":0,"nm":"Stroke 1","mn":"ADBE Vector Graphic - Stroke","hd":false},{"ind":2,"ty":"sh","ix":3,"ks":{"a":0,"k":{"i":[[0,0],[0,0]],"o":[[0,0],[0,0]],"v":[[2.57,8.539],[10.395,1.468]],"c":false},"ix":2},"nm":"Path 2","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"st","c":{"a":0,"k":[1,1,1,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":1.5,"ix":5},"lc":1,"lj":1,"ml":4,"bm":0,"nm":"Stroke 2","mn":"ADBE Vector Graphic - Stroke","hd":false}],"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":2,"ty":4,"nm":"mask-ad","td":1,"sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[652.75,772,0],"ix":2,"l":2},"a":{"a":0,"k":[42,60,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-8.837,0],[0,0],[0,-8.837],[0,0],[8.837,0],[0,0],[0,8.837],[0,0]],"o":[[0,0],[8.837,0],[0,0],[0,8.837],[0,0],[-8.837,0],[0,0],[0,-8.837]],"v":[[16,0],[68,0],[84,16],[84,104],[68,120],[16,120],[0,104],[0,16]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.729411764706,0.674509803922,0.823529471603,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":3,"ty":4,"nm":"gradient","tt":1,"sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[1000,662,0],"ix":2,"l":2},"a":{"a":0,"k":[0,0,0],"ix":1,"l":2},"s":{"a":0,"k":[100,100,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ty":"gr","it":[{"d":1,"ty":"el","s":{"a":0,"k":[229.039,229.039],"ix":2},"p":{"a":0,"k":[0,0],"ix":3},"nm":"Ellipse Path 1","mn":"ADBE Vector Shape - Ellipse","hd":false},{"ty":"gf","o":{"a":0,"k":100,"ix":10},"r":1,"bm":0,"g":{"p":5,"k":{"a":0,"k":[0.141,0.741,0.792,0.933,0.326,0.72,0.759,0.918,0.511,0.698,0.725,0.902,0.756,0.712,0.7,0.865,1,0.725,0.675,0.827],"ix":9}},"s":{"a":0,"k":[0,0],"ix":5},"e":{"a":0,"k":[94.125,64.18],"ix":6},"t":2,"h":{"a":0,"k":0,"ix":7},"a":{"a":0,"k":0,"ix":8},"nm":"Gradient Fill 1","mn":"ADBE Vector Graphic - G-Fill","hd":false},{"ty":"tr","p":{"a":0,"k":[-380.211,76.607],"ix":2},"a":{"a":0,"k":[0,0],"ix":1},"s":{"a":0,"k":[157.36,157.36],"ix":3},"r":{"a":0,"k":0,"ix":6},"o":{"a":0,"k":100,"ix":7},"sk":{"a":0,"k":0,"ix":4},"sa":{"a":0,"k":0,"ix":5},"nm":"Transform"}],"nm":"Ellipse 1","np":2,"cix":2,"bm":0,"ix":1,"mn":"ADBE Vector Group","hd":false}],"ip":0,"op":178,"st":0,"bm":0}]}],"layers":[{"ddd":0,"ind":1,"ty":4,"nm":"tic","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[-347,109,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":25,"s":[100,100,100]},{"t":29,"s":[10,10,100]}],"ix":6,"l":2}},"ao":0,"shapes":[{"ty":"gr","it":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[0,0],[0,0],[0,0]],"o":[[0,0],[0,0],[0,0]],"v":[[-373.25,110.75],[-351.312,133.188],[-321.75,87.75]],"c":false},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":1},"e":{"a":1,"k":[{"i":{"x":[0.667],"y":[0.306]},"o":{"x":[0.333],"y":[0]},"t":16,"s":[0]},{"i":{"x":[0.667],"y":[-5.25]},"o":{"x":[0.333],"y":[6.25]},"t":20,"s":[36]},{"i":{"x":[0.419],"y":[0.998]},"o":{"x":[0.333],"y":[0.293]},"t":21,"s":[36]},{"t":24,"s":[100]}],"ix":2},"o":{"a":0,"k":0,"ix":3},"m":1,"ix":2,"nm":"Trim Paths 1","mn":"ADBE Vector Filter - Trim","hd":false},{"ty":"st","c":{"a":0,"k":[1,1,1,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":9,"ix":5},"lc":2,"lj":2,"bm":0,"nm":"Stroke 1","mn":"ADBE Vector Graphic - Stroke","hd":false},{"ty":"tr","p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":1},"s":{"a":0,"k":[100,100],"ix":3},"r":{"a":0,"k":0,"ix":6},"o":{"a":0,"k":100,"ix":7},"sk":{"a":0,"k":0,"ix":4},"sa":{"a":0,"k":0,"ix":5},"nm":"Transform"}],"nm":"Shape 1","np":3,"cix":2,"bm":0,"ix":1,"mn":"ADBE Vector Group","hd":false}],"ip":16,"op":29,"st":-44,"bm":0},{"ddd":0,"ind":2,"ty":4,"nm":"adblock-icon Outlines","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":12,"s":[0]},{"t":14,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[352,249.5,0],"ix":2,"l":2},"a":{"a":0,"k":[40,40,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":12,"s":[10,10,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":14,"s":[220,220,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":18,"s":[180,180,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":24,"s":[200,200,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":25,"s":[200,200,100]},{"t":29,"s":[10,10,100]}],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-4.994,0.921],[-1.246,-0.231],[-3.544,-1.604],[0,-1.73],[0,0],[5.595,-3.317],[0,0],[1.591,0.945],[0,0],[0,6.182],[0,0],[-1.673,0.754]],"o":[[1.246,-0.231],[4.994,0.921],[1.668,0.754],[0,0],[0,6.182],[0,0],[-1.591,0.945],[0,0],[-5.6,-3.317],[0,0],[0,-1.73],[3.539,-1.604]],"v":[[38.138,10.173],[41.852,10.173],[63.961,15.288],[66.662,19.341],[66.662,45.098],[57.682,60.349],[42.599,69.291],[37.391,69.291],[22.313,60.349],[13.328,45.098],[13.328,19.341],[16.034,15.288]],"c":true},"ix":2},"nm":"Path 2","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.58431372549,0.580392156863,0.776470648074,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":12,"op":29,"st":-48,"bm":0},{"ddd":0,"ind":3,"ty":0,"nm":"AD-lightmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":8,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":12,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":25,"s":[0]},{"t":29,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[554.396,247.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.396,769.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":3,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":6,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":12,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,-25.627]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":25,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,77.204]},"t":28,"s":[81.36,81.36,100]},{"t":35,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":4,"ty":0,"nm":"AD-lightmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":7,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":11,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":25,"s":[0]},{"t":29,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[354.396,247.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.396,769.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":2,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":5,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":11,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,1]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":25,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,0]},"t":28,"s":[81.36,81.36,100]},{"t":35,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":5,"ty":0,"nm":"AD-lightmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":6,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":10,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":25,"s":[0]},{"t":29,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[154.396,247.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.396,769.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":1,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":4,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":10,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,1]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":25,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,0]},"t":28,"s":[81.36,81.36,100]},{"t":35,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":6,"ty":4,"nm":"browser-bg-top Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[350,57,0],"ix":2,"l":2},"a":{"a":0,"k":[158,12,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-4.418,0],[0,0],[0,-4.418],[0,0],[4.418,0],[0,0],[0,4.418],[0,0]],"o":[[0,0],[4.418,0],[0,0],[0,4.418],[0,0],[-4.418,0],[0,0],[0,-4.418]],"v":[[8,0],[308,0],[316,8],[316,16],[308,24],[8,24],[0,16],[0,8]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[1,1,1,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":7,"ty":4,"nm":"browser-bg-bottom Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[158,76,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-6.627,0],[0,0],[0,-6.627],[0,0],[6.627,0],[0,0],[0,6.627],[0,0]],"o":[[0,0],[6.627,0],[0,0],[0,6.627],[0,0],[-6.627,0],[0,0],[0,-6.627]],"v":[[12,0],[304,0],[316,12],[316,140],[304,152],[12,152],[0,140],[0,12]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[1,1,1,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":8,"ty":4,"nm":"browser-bg-all","sr":1,"ks":{"o":{"a":0,"k":50,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[158,76,0],"ix":1,"l":2},"s":{"a":0,"k":[210.526,210.526,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-6.627,0],[0,0],[0,-6.627],[0,0],[6.627,0],[0,0],[0,6.627],[0,0]],"o":[[0,0],[6.627,0],[0,0],[0,6.627],[0,0],[-6.627,0],[0,0],[0,-6.627]],"v":[[12,-33.25],[303.525,-33.25],[315.525,-21.25],[315.525,143.8],[303.525,155.8],[12,155.8],[0,143.8],[0,-21.25]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.58431372549,0.580392156863,0.776470588235,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0}],"markers":[]}');var ya=function(e){var t=e.isDarkTheme?ma:ga;return b.createElement("span",{className:"preview",key:String(e.enabled)},b.createElement(da,{animationData:t,frames:e.enabled?[0,24]:[24,36],autoplay:!0,loop:!1}))};function va(e){var t=g((0,b.useState)(!1),2),r=t[0],n=t[1],a=g((0,b.useState)(!1),2),i=a[0],s=a[1],o=e.isActive;(0,b.useEffect)((function(){yn(n),mn((function(e){return s(e)})),dn().then((function(e){return s(e)}))}),[]);var l=function(){gn(!r),lr(ir.CLICK,fr.ADBLOCK,"enable_adblock_button:".concat(r?0:1))};return b.createElement(b.Fragment,null,b.createElement(ya,{key:String(i),enabled:r,isDarkTheme:i}),b.createElement("div",{className:"tile adblock"},b.createElement("span",{className:"label"},Ee("adblocker.label")),b.createElement("input",{type:"checkbox",onChange:l,onKeyDown:function(e){"Enter"===e.code&&l()},checked:r,tabIndex:o?Yr.ITEM:void 0})))}function ba(){return b.createElement("span",{className:"spinner"},b.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",xmlnsXlink:"http://www.w3.org/1999/xlink",viewBox:"0 0 32 32"},b.createElement("defs",null,b.createElement("linearGradient",{id:"a",x1:"-102.13",y1:"91.03",x2:"-103.54",y2:"92.08",gradientTransform:"matrix(10.5 0 0 -8.75 1092.5 822)",gradientUnits:"userSpaceOnUse"},b.createElement("stop",{offset:"0",stopColor:"#fff",stopOpacity:"0"}),b.createElement("stop",{offset:"1",stopColor:"#c8c9d0"})),b.createElement("linearGradient",{id:"b",x1:"-103.1",y1:"92.71",x2:"-101.98",y2:"91.27",gradientTransform:"matrix(10.5 0 0 -8.75 1096 816.75)",xlinkHref:"#a"})),b.createElement("rect",{width:"32",height:"32",rx:"16",ry:"16",opacity:".6"}),b.createElement("g",null,b.createElement("path",{d:"M8 13.5a2 2 0 0 1 2 2.08 6.08 6.08 0 0 0 5.86 6.25 5.48 5.48 0 0 0 2.54-.62 1.88 1.88 0 0 1 2.54 1.09 2.1 2.1 0 0 1-.94 2.61A8.46 8.46 0 0 1 15.77 26C10.4 26 6 21.31 6 15.58a2 2 0 0 1 2-2.08z",fill:"url(#a)"}),b.createElement("path",{d:"M24.07 18.5a2 2 0 0 1-1.93-2.08 6.05 6.05 0 0 0-5.79-6.25 5.36 5.36 0 0 0-2.51.62 1.81 1.81 0 0 1-2.61-.79A2.14 2.14 0 0 1 12 7.15c.05-.06.15-.06.19-.11a8.82 8.82 0 0 1 4.16-1C21.66 6 26 10.69 26 16.42a2 2 0 0 1-1.93 2.08z",fill:"url(#b)"}))))}function ka(e){var t=e.classNames,r=e.hasTabIndex,n=e.onClick,a=e.onMouseEnter,i=e.onMouseLeave,s=e.children;return b.createElement("span",{onClick:n,onMouseEnter:a,onMouseLeave:i,onKeyDown:function(e){["Enter","Space"].includes(e.code)&&n()},tabIndex:r?Yr.ITEM:void 0,className:Kr(["tile",t])},s)}function xa(){return b.createElement("svg",{style:{display:"none"},id:"svgfilters",xmlns:"http://www.w3.org/2000/svg"},b.createElement("defs",null,b.createElement("filter",{id:"light-grey-filter",x:"-10%",y:"-10%",width:"120%",height:"120%",filterUnits:"objectBoundingBox",primitiveUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},b.createElement("feColorMatrix",{type:"matrix",values:"1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0",in:"SourceGraphic",result:"colormatrix"}),b.createElement("feComponentTransfer",{in:"colormatrix",result:"componentTransfer"},b.createElement("feFuncR",{type:"table",tableValues:"0.75"}),b.createElement("feFuncG",{type:"table",tableValues:"0.75"}),b.createElement("feFuncB",{type:"table",tableValues:"0.75"}),b.createElement("feFuncA",{type:"table",tableValues:"0 1"})),b.createElement("feBlend",{mode:"color",in:"componentTransfer",in2:"SourceGraphic",result:"blend"}))))}function Sa(){return b.createElement("div",{className:"overlay-icon"},b.createElement("div",{className:"check"}))}function wa(){return b.createElement("div",{className:"overlay-icon cross"},b.createElement("svg",{width:"25",height:"24",viewBox:"0 0 24 24",fill:"none",xmlns:"http://www.w3.org/2000/svg"},b.createElement("circle",{cx:"12",cy:"12",r:"12",fill:"#E24C5E"}),b.createElement("path",{d:"M7.65552 15.921L11.5789 11.9976L7.65552 8.07416L8.87397 6.85571L12.7974 10.7791L16.7208 6.85571L17.9392 8.07416L14.0158 11.9976L17.9392 15.921L16.7208 17.1394L12.7974 13.216L8.87397 17.1394L7.65552 15.921Z",fill:"white",transform:"translate(-0.5, 0)"})))}function Ea(e){var r=e.browser,n=r.icon,a=r.importer,i=r.state,s=r.label,o=g((0,b.useState)(!1),2),l=o[0],u=o[1],c=function(){var r=t(v().mark((function t(){return v().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return u(!0),t.next=3,e.onImport(e.browser);case 3:u(!1);case 4:case"end":return t.stop()}}),t)})));return function(){return r.apply(this,arguments)}}();return b.createElement(ka,{onClick:i!==Mr.SUCCESS&&a&&!l?c:void 0,classNames:[{disabled:!a,available:a&&i!==Mr.SUCCESS,imported:i===Mr.SUCCESS,selected:i===Mr.SUCCESS,failed:i===Mr.FAILURE}],hasTabIndex:e.hasTabIndex},b.createElement("span",{className:"browser"},b.createElement("span",{className:"icon"},b.createElement("i",{style:{backgroundImage:"url(".concat(n,")")}}),i===Mr.SUCCESS&&b.createElement(Sa,null),i===Mr.FAILURE&&b.createElement(wa,null),l&&b.createElement(ba,null)),b.createElement("span",{className:"name"},s)))}function _a(e){var r=g((0,b.useState)([]),2),n=r[0],a=r[1],i=(0,b.useContext)(ii),s=i.popup,o=i.setPopup,l=e.isActive;(0,b.useEffect)((function(){Vr().then(a)}),[]);var u=function(){var e=t(v().mark((function e(t){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return lr(ir.CLICK,fr.IMPORT,"import_button:".concat(t.key)),e.next=3,Lr(t.importer);case 3:return e.sent===Mr.FAILURE&&o(Mr.FAILURE),e.t0=a,e.next=8,Vr();case 8:e.t1=e.sent,(0,e.t0)(e.t1);case 10:case"end":return e.stop()}}),e)})));return function(t){return e.apply(this,arguments)}}();return b.createElement(b.Fragment,null,b.createElement(xa,null),b.createElement("div",{className:"browsers"},n.map((function(e){return b.createElement(Ea,{key:e.name,onImport:u,browser:e,hasTabIndex:l&&!s&&e.importer&&e.state!==Mr.SUCCESS})}))))}const Pa=__webpack_require__.p+"0d406bdcf61e6d381f23.svg",Ca=__webpack_require__.p+"405e207014bf75cd59c6.svg",Aa=__webpack_require__.p+"eed0b0cc552c8794b337.svg",Ta=__webpack_require__.p+"37d24412e02af82ffc5c.svg",Ma=__webpack_require__.p+"e393a69f0d2e035d1c42.svg",Da=__webpack_require__.p+"61a42bb99a92e9c1352f.svg",Ia=__webpack_require__.p+"28823de3046af6be5504.svg",Fa=__webpack_require__.p+"fcffb6ccd23559274e62.svg",Oa=__webpack_require__.p+"9703c15b184d8259a452.svg",Ra=__webpack_require__.p+"8d979c64297ebab9c9d5.svg",La=__webpack_require__.p+"61c87b77a034799680ad.svg",Na=__webpack_require__.p+"7bbffe1e039c3f8f477a.svg";function Va(e,t){var r="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!r){if(Array.isArray(e)||(r=function(e,t){if(!e)return;if("string"==typeof e)return za(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return za(e,t)}(e))||t&&e&&"number"==typeof e.length){r&&(e=r);var n=0,a=function(){};return{s:a,n:function(){return n>=e.length?{done:!0}:{done:!1,value:e[n++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,o=!1;return{s:function(){r=r.call(e)},n:function(){var e=r.next();return s=e.done,e},e:function(e){o=!0,i=e},f:function(){try{s||null==r.return||r.return()}finally{if(o)throw i}}}}function za(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}var Ba,ja="BR";function Ga(){return Ha.apply(this,arguments)}function Ha(){return(Ha=t(v().mark((function e(){var t,r,n,a;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,new Promise((function(e){opr.locationPrivate.getCurrentCountry((function(t){e(t)}))}));case 2:return t=e.sent,e.next=5,new Promise((function(e){opr.browserSidebarPrivate.getItemsInfo((function(t){e(t)}))}));case 5:return r=e.sent,n=Object.values(Ba),t===ja&&(n=n.filter((function(e){return e!==Ba.X}))),a=r.filter((function(e){return n.includes(e.pref_id)&&e.enabled})).map((function(e){return{pref_id:e.pref_id,enabled:!0,visible:e.visible,name:e.name}})),e.abrupt("return",a);case 10:case"end":return e.stop()}}),e)})))).apply(this,arguments)}!function(e){e.Messenger="FacebookMessenger",e.TikTok="TikTok",e.X="Twitter",e.Instagram="Instagram",e.Telegram="Telegram",e.WhatsApp="Whatsapp"}(Ba||(Ba={}));var qa=new Set,Ua=function(e){return qa.add(e),Ga().then(e),function(){qa.delete(e)}};function Wa(e){var t=function(e){switch(e){case Ba.Instagram:return{name:"Instagram",icon:Pa,iconInactive:Ca};case Ba.Messenger:return{name:"Messenger",icon:Aa,iconInactive:Ta};case Ba.Telegram:return{name:"Telegram",icon:Ma,iconInactive:Da};case Ba.TikTok:return{name:"TikTok",icon:Ia,iconInactive:Fa};case Ba.X:return{name:"X",icon:La,iconInactive:Na};case Ba.WhatsApp:return{name:"WhatsApp",icon:Oa,iconInactive:Ra}}}(e.item.pref_id);return b.createElement(ka,{classNames:[e.item.visible?"active selected":null],onClick:function(){var t,r;t=e.item.pref_id,r=!e.item.visible,opr.browserSidebarPrivate.setItemVisibleUsingPrefId(t,r);var n=e.item.name.toLowerCase().replace(" ","_");lr(ir.CLICK,fr.MESSENGERS,"enable_button:".concat(n,":").concat(e.item.visible?0:1))},onMouseEnter:e.onMouseEnter,onMouseLeave:e.onMouseLeave,hasTabIndex:e.hasTabIndex},b.createElement("span",{className:"messenger"},e.item.visible&&b.createElement("div",{className:"overlay-icon"},b.createElement("div",{className:"check"})),b.createElement("span",{className:"icon"},b.createElement("i",{style:{backgroundImage:"url(".concat(t.icon,")")}})),b.createElement("span",{className:"name"},t.name)))}function $a(e){var t=g((0,b.useState)([]),2),r=t[0],n=t[1],a=g((0,b.useState)(null),2),i=a[0],s=a[1],o=e.isActive;return(0,b.useEffect)((function(){return Ua((function(e){n(e)}))}),[]),b.createElement(b.Fragment,null,r.map((function(e){return b.createElement(Wa,{item:e,key:e.pref_id,isHovered:i===e.pref_id,onMouseEnter:function(){return s(e.pref_id)},onMouseLeave:function(){return s(null)},hasTabIndex:o})})))}opr.browserSidebarPrivate.onItemVisibilityChanged.addListener((function(){Ga().then((function(e){var t,r=Va(qa);try{for(r.s();!(t=r.n()).done;){(0,t.value)(e)}}catch(e){r.e(e)}finally{r.f()}}))}));var Ka=function(e){return e&&"ffeocbomcpokpmjkkloomhnflpjmkjpi"==e.id},Ja=function(e){opr.vibesPrivate.updateActiveVibeConfiguration({mode:e})};function Ya(e){switch(e){case tn.LIGHT:return"light";case tn.DARK:return"dark";case tn.SYSTEM:return"system"}}function Qa(e){return b.createElement(ka,{classNames:[{selected:e.selected},Ya(e.theme),"theme"],onClick:function(){opr.vibesPrivate?Ja(function(e){switch(e){case tn.LIGHT:return opr.vibesPrivate.Mode.LIGHT;case tn.DARK:return opr.vibesPrivate.Mode.DARK;case tn.SYSTEM:return opr.vibesPrivate.Mode.SYSTEM}}(e.theme)):pn(e.theme),lr(ir.CLICK,fr.THEME,"".concat(Ya(e.theme),"_button"))},hasTabIndex:e.hasTabIndex},b.createElement("span",{className:"name"},e.name))}function Xa(e){var t=g((0,b.useState)(null),2),r=t[0],n=t[1],a=/linux/i.test(navigator.userAgent),i=e.isActive;return(0,b.useEffect)((function(){return fn(n)}),[]),b.createElement(b.Fragment,null,b.createElement(Qa,{theme:tn.LIGHT,selected:r===tn.LIGHT,name:Ee("themes.light"),hasTabIndex:i}),b.createElement(Qa,{theme:tn.DARK,selected:r===tn.DARK,name:Ee("themes.dark"),hasTabIndex:i}),!a&&b.createElement(Qa,{theme:tn.SYSTEM,selected:r===tn.SYSTEM,name:Ee("themes.system"),hasTabIndex:i}))}function Za(e){var r=e.id,n=e.isSelected,a=e.isAnyActive,i=e.setAnyHovered,s=g((0,b.useState)(!1),2),o=s[0],l=s[1],u=g((0,b.useState)(!1),2),c=u[0],h=u[1],p=function(){var r=t(v().mark((function t(){return v().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return l(!0),lr(ir.CLICK,fr.WALLPAPERS,"choose_wallpaper"),t.next=4,Bn(e.id);case 4:l(!1);case 5:case"end":return t.stop()}}),t)})));return function(){return r.apply(this,arguments)}}();return b.createElement(ka,{onClick:o?void 0:p,classNames:Kr(["thumbnail",{dimmed:!c&&!n&&a,selected:n},{default:r===On.DEFAULT}]),onMouseEnter:function(){h(!0),i(!0)},onMouseLeave:function(){h(!1),i(!1)},hasTabIndex:e.hasTabIndex},b.createElement("span",{className:"image",style:{backgroundImage:"url(".concat(e.thumbnail||e.src,")")}}),o&&b.createElement(ba,null))}function ei(e){var t=g((0,b.useState)(!1),2),r=t[0],n=t[1],a=g((0,b.useState)(null),2),i=a[0],s=a[1],o=g((0,b.useState)(!1),2),l=o[0],u=o[1],c=e.isActive;(0,b.useEffect)((function(){var e=mn((function(e){n(e)})),t=Wn((function(e){s(e.id)}));return function(){e(),t()}}),[]);var h=r?Nn:Vn,p=h.map((function(e){return e.id})),f=i&&p.includes(i);return b.createElement(b.Fragment,null,h.map((function(e){return b.createElement(Za,{key:e.id,id:e.id,src:e.background,thumbnail:e.thumbnail,isSelected:i===e.id,isAnyActive:f||l,isAnyHovered:l,setAnyHovered:u,hasTabIndex:c})})))}var ti=function(){var e=t(v().mark((function e(){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",new Promise((function(e){opr.featuresPrivate.isFeatureEnabled("high-contrast-mode")?opr.accessibilityPrivate.getHighContrastModeState((function(t){e(t)})):e(!1)})));case 1:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}();function ri(e){return b.createElement("div",{className:"option-container",onClick:e.onClick},b.createElement("div",{className:"option-header","data-user-type":e.userType},Ee("userSurvey.".concat(e.userType,"_header"))),b.createElement("div",{className:"option-desc"},Ee("userSurvey.".concat(e.userType,"_desc"))))}function ni(e){var t=[en.NEWBIE,en.ACTIVE,en.RETURNING];!function(e){for(var t=e.length-1;t>0;t--){var r=Math.floor(Math.random()*(t+1)),n=[e[r],e[t]];e[t]=n[0],e[r]=n[1]}}(t);var r=t.map((function(t,r){return b.createElement(ri,{key:r,userType:t,onClick:function(){return r=t,lr(ir.CLICK,fr.USER_SURVEY,r),void e.next(!0);var r}})}));return b.createElement("div",{className:"survey-container"},r)}function ai(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var r,n=h(e);if(t){var a=h(this).constructor;r=Reflect.construct(n,arguments,a)}else r=n.apply(this,arguments);return c(this,r)}}var ii=b.createContext({route:hr.WELCOME,setRoute:null,feature:pr.NONE,setFeature:null,popup:null,setPopup:null}),si=function(e){var r=e.isOverlay,n=g((0,b.useState)(r?hr.WELCOME:vr()),2),a=n[0],i=n[1],s=g((0,b.useState)(br(a)),2),o=s[0],l=s[1],u=g((0,b.useState)(null),2),c=u[0],h=u[1],p=g((0,b.useState)(!1),2),f=p[0],d=p[1],m=g((0,b.useState)(!1),2),y=m[0],k=m[1],x=function(){var e=g((0,b.useState)(null),2),r=e[0],n=e[1];return(0,b.useEffect)((function(){var e=function(){var e=t(v().mark((function e(){var t,r;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,opr.vibesPrivate.getActiveVibeConfiguration();case 2:return t=e.sent,e.next=5,opr.vibesPrivate.getVibe(t.vibeId);case 5:r=e.sent,n(r);case 7:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}();return opr.vibesPrivate.onActiveVibeConfigurationChanged.addListener(e),e(),function(){opr.vibesPrivate.onActiveVibeConfigurationChanged.removeListener(e)}}),[]),{activeVibe:r}}(),S=x.activeVibe,w=null!=S?S:{},E=w.canChangeMode,_=w.customizableWallpaper,P=g((0,b.useState)(!1),2),C=P[0],A=P[1],T=g((0,b.useState)(!1),2),M=T[0],D=T[1],I=g((0,b.useState)(),2),F=I[0],O=I[1];(0,b.useEffect)((function(){return e=function(e,t){i(e),l(t)},t=function(){var t=vr(),r=br(t);e(t,r)},chrome.storage.onChanged.addListener(t),function(){chrome.storage.onChanged.removeListener(t)};var e,t}),[]),(0,b.useEffect)((function(){Ur().then(d),Fr().then(A),ti().then(D),O(opr.featuresPrivate.isFeatureEnabled("opera-one-unskippable-introduction")),Ur().then(d);var e=setTimeout((function(){return d(!0)}),500);return function(){clearTimeout(e)}}),[]);var R=[F&&{feature:pr.USER_SURVEY,section:fr.USER_SURVEY,title:Ee("userSurvey.header"),subtitle:"",content:ni},E&&!M&&Ka(S)&&{feature:pr.THEME,section:fr.THEME,title:Ee("themes.header"),subtitle:Ee("themes.subheader"),content:Xa},_&&!M&&Ka(S)&&{feature:pr.WALLPAPER,section:fr.WALLPAPERS,title:Ee("wallpapers.header"),subtitle:Ee("wallpapers.subheader"),content:ei},{feature:pr.ADBLOCKER,section:fr.ADBLOCK,title:Ee("adblocker.header"),subtitle:Ee("adblocker.subheader"),content:va},{feature:pr.MESSENGERS,section:fr.MESSENGERS,title:Ee("messengers.header"),subtitle:Ee("messengers.subheader"),content:$a},!C&&{feature:pr.IMPORT,section:fr.IMPORT,title:Ee("import.header"),subtitle:Ee("import.subheader"),content:_a}].filter((function(e){return Boolean(e)}));return b.createElement(ii.Provider,{value:{route:a,setRoute:function(e){!function(e){localStorage.setItem("route",e)}(e),i(e)},feature:o,setFeature:function(e){!function(e){localStorage.setItem("feature",e)}(e),l(e)},popup:c,setPopup:h}},b.createElement(ha,{isReady:f,isOverlay:r,slides:R,closeIntroduction:function(){y||(sr(r),k(!0))},startBrowsing:function(){var e;y||(e=r,lr(ir.CLICK,fr.OUTRO,"start_browsing"),e?sr(!1):gr(),k(!0))}}))},oi=function(e){l(n,e);var t=ai(n);function n(e){return r(this,n),t.call(this,e)}return s(n,[{key:"componentDidCatch",value:function(e,t){sr(!1),gr()}},{key:"render",value:function(){return this.props.children}}]),n}(b.Component),li=document.getElementById("root"),ui=function(){var e=t(v().mark((function e(){var t;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,mr();case 2:t=e.sent,(0,k.s)(li).render(b.createElement(oi,null,b.createElement(si,{isOverlay:t})));case 5:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}();document.body.parentNode&&li&&ui()})()})();