/*! For license information please see index.js.LICENSE.txt */
(()=>{var __webpack_modules__={4963:(e,t,n)=>{"use strict";n.d(t,{Z:()=>o});var r=n(8081),a=n.n(r),i=n(3645),s=n.n(i)()(a());s.push([e.id,"/* Animations */\n\n@keyframes appear {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n\n@keyframes disappear {\n  from {\n    opacity: 1;\n  }\n  to {\n    opacity: 0;\n  }\n}\n\n@keyframes fade {\n  0% {\n    opacity: 1;\n  }\n  20% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n\n@keyframes slide-up {\n  from {\n    transform: translateY(300px);\n  }\n  to {\n    transform: translateY(0);\n  }\n}\n\n/* General */\n\n@keyframes spin {\n  0% {\n    transform: rotate(0deg);\n  }\n  100% {\n    transform: rotate(360deg);\n  }\n}\n\n.spinner {\n  opacity: 0;\n  animation: spin 0.8s linear infinite, appear 0.4s 0.2s ease-in forwards;\n}\n\n/* Background */\n\n.background {\n  .layer {\n    opacity: 0;\n    transition: opacity 0.2s linear;\n\n    &.active {\n      opacity: 1;\n    }\n  }\n\n  .wallpaper {\n    animation: appear 0.3s cubic-bezier(0.33, 1, 0.68, 1) forwards;\n  }\n}\n\n/* Gallery */\n\n.active .page .buttons {\n  visibility: visible;\n}\n\n.page {\n  opacity: 0;\n}\n\n.active .page {\n  animation: appear 0.3s ease-in-out 0.1s forwards;\n}\n\n.active:first-of-type {\n  animation-duration: 0.4s;\n  animation-delay: 0s;\n}\n\n.dismissed .page {\n  animation: disappear var(--fade-out-duration) ease-in-out forwards;\n}\n\n.active .page .buttons {\n  animation: appear 0.3s linear 0.2s forwards;\n  opacity: 0;\n}\n\n.dismissed .page .buttons {\n  animation: disappear 0.3s linear forwards;\n  opacity: 1;\n  pointer-events: none;\n}\n\n/* Summary */\n\n#summary {\n  animation: appear 0.5s ease-in-out 0.3s forwards;\n  opacity: 0;\n\n  .start {\n    animation: appear 0.4s linear 1.4s forwards;\n    opacity: 0;\n  }\n\n  .preview {\n    i {\n      transform: translateY(300px);\n    }\n\n    .desktop {\n      animation: slide-up 0.5s ease-out 0.5s forwards;\n    }\n\n    .android {\n      animation: slide-up 0.5s ease-out 0.7s forwards;\n    }\n\n    .ios {\n      animation: slide-up 0.5s ease-out 0.9s forwards;\n    }\n  }\n}\n",""]);const o=s},9580:(e,t,n)=>{"use strict";n.d(t,{Z:()=>z});var r=n(8081),a=n.n(r),i=n(3645),s=n.n(i),o=n(1667),l=n.n(o),u=new URL(n(3056),n.b),c=new URL(n(1755),n.b),h=new URL(n(6856),n.b),p=new URL(n(1272),n.b),f=new URL(n(3311),n.b),d=new URL(n(6297),n.b),m=new URL(n(8420),n.b),g=new URL(n(1942),n.b),y=new URL(n(1055),n.b),v=new URL(n(3630),n.b),b=new URL(n(903),n.b),k=new URL(n(6912),n.b),x=new URL(n(1016),n.b),S=new URL(n(2063),n.b),w=new URL(n(1695),n.b),E=s()(a()),P=l()(u),_=l()(c),C=l()(h),A=l()(p),T=l()(f),M=l()(d),D=l()(m),I=l()(g),F=l()(y),O=l()(v),R=l()(b),L=l()(k),N=l()(x),V=l()(S),B=l()(w);E.push([e.id,"/* Fonts */\n\n@font-face {\n  font-display: swap;\n  font-family: 'Be Vietnam Pro';\n  font-style: normal;\n  font-weight: 400;\n  src: url("+P+") format('truetype');\n}\n\n@font-face {\n  font-display: swap;\n  font-family: 'Be Vietnam Pro';\n  font-style: normal;\n  font-weight: 700;\n  src: url("+_+") format('truetype');\n}\n\n@font-face {\n  font-display: swap;\n  font-family: 'Space Mono';\n  font-style: normal;\n  font-weight: 400;\n  src: url("+C+") format('truetype');\n}\n\n@font-face {\n  font-display: swap;\n  font-family: 'Space Mono';\n  font-style: normal;\n  font-weight: 700;\n  src: url("+A+") format('truetype');\n}\n\n@font-face {\n  font-display: swap;\n  font-family: Averta;\n  font-style: normal;\n  font-weight: 500;\n  src: url("+T+") format('opentype');\n}\n\n/* General */\n\n* {\n  overscroll-behavior: contain;\n}\n\n.key-nav {\n  position: fixed;\n  opacity: 0;\n  z-index: 0;\n\n  .start {\n    top: 0;\n    left: 0;\n  }\n\n  .end {\n    bottom: 0;\n    right: 0;\n  }\n}\n\n.hidden > * {\n  visibility: hidden;\n  pointer-events: none;\n}\n\nbody {\n  --spacing: 32px;\n  --padding: 64px;\n  --default-content-width: 800px;\n  --max-content-width: 800px;\n  --min-content-width: 800px;\n  --content-width: clamp(\n    var(--min-content-width),\n    var(--default-content-width),\n    var(--max-content-width)\n  );\n  --outro-width: 680px;\n  --accent-color: #5021ff;\n  --light-font-color: #ffffff;\n  --dark-font-color: #000000;\n  --secondary-dark-font-color: #000000a4;\n  --highlight-color: #ffffff22;\n  --shadow-color: #00000033;\n\n  background-color: transparent;\n  box-sizing: border-box;\n  font-family: 'Be Vietnam Pro', 'Space Mono', roboto, sans-serif;\n  height: 100%;\n  margin: 0;\n  padding: 0;\n  width: 100%;\n}\n\n.onboarding {\n  --panel-background-color: #ffffff88;\n  --tile-background-color: #ffffff;\n  --tile-font-color: var(--dark-font-color);\n  --icon-background-color: #000000;\n  --active-background-color: var(--accent-color);\n  --inactive-background-color: #d9d9d9;\n  --preview-background-color: var(--tile-background-color);\n  --preview-hightlight-color: #bcbcda;\n  --primary-text-color: #000000;\n  --secondary-text-color: #252836;\n\n  align-items: center;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  margin: auto;\n  min-height: 100vh;\n  width: var(--default-content-width);\n}\n\n@media (prefers-color-scheme: dark) {\n  .onboarding {\n    --panel-background-color: #3c405580;\n    --tile-background-color: #000000;\n    --tile-font-color: var(--light-font-color);\n    --icon-background-color: #ffffff;\n    --inactive-background-color: #262626;\n    --preview-background-color: #4d4d66;\n    --preview-hightlight-color: #26263c;\n    --primary-text-color: #ffffff;\n    --secondary-text-color: #fff8;\n  }\n}\n\nh1,\nh2 {\n  color: var(--primary-text-color);\n  margin: 0;\n}\n\nh1 {\n  font-size: 48px;\n  font-weight: 700;\n  line-height: 52px;\n}\n\nh2 {\n  font-size: 24px;\n  font-weight: 400;\n  line-height: 24px;\n}\n\n.spinner {\n  align-items: center;\n  display: flex;\n  justify-content: center;\n\n  svg {\n    width: 48px;\n    height: 48px;\n  }\n}\n\n.tile {\n  background-color: var(--tile-background-color);\n  border-radius: 24px;\n  border: 4px solid transparent;\n  box-sizing: border-box;\n  height: 200px;\n  width: 200px;\n\n  &.selected {\n    border-color: var(--accent-color);\n  }\n}\n\n.overlay-icon {\n  z-index: 1;\n  align-items: center;\n  border-radius: 50%;\n  box-shadow: 0px 2px 2px 0px var(--shadow-color);\n  display: flex;\n  height: 24px;\n  justify-content: center;\n  margin-left: auto;\n  position: absolute;\n  width: 24px;\n\n  & > * {\n    border-radius: inherit;\n    display: inline-block;\n    background-position: center;\n    background-repeat: no-repeat;\n  }\n\n  .check {\n    background-color: var(--accent-color);\n    background-image: url("+M+");\n    background-position: center;\n    background-repeat: no-repeat;\n    background-size: 16px;\n    height: 24px;\n    width: 24px;\n  }\n}\n\n.overlay,\n.background,\n.wallpaper {\n  position: fixed;\n  top: 0;\n  left: 0;\n  bottom: 0;\n  right: 0;\n}\n\n.onboarding.done {\n  cursor: pointer;\n}\n\n/* Background */\n\n.background {\n  pointer-events: none;\n\n  .layer {\n    background-position: center;\n    background-size: cover;\n    height: 100%;\n    position: absolute;\n    width: 100%;\n  }\n\n  .base {\n    background-color: #fff;\n  }\n\n  .light {\n    background-image: url("+D+");\n  }\n\n  .dark {\n    background-image: url("+I+");\n  }\n\n  .wallpaper {\n    background-position: center;\n    background-size: cover;\n  }\n}\n\n/* Overlay */\n\n.overlay {\n  background-image: url("+I+");\n  background-position: center;\n  background-repeat: no-repeat;\n  background-size: cover;\n  cursor: pointer;\n\n  .container {\n    align-items: center;\n    box-sizing: border-box;\n    display: flex;\n    height: 100%;\n    justify-content: center;\n    position: relative;\n    width: max(400px, 100%);\n  }\n\n  .get-started {\n    background-color: #f0f2f6;\n    border: 0;\n    border-radius: 18px;\n    cursor: pointer;\n    height: 80px;\n    opacity: 0;\n    padding: 0 14px 0 14px;\n    transition: background-color 0.2s linear;\n    text-transform: uppercase;\n\n    display: inline-flex;\n    box-sizing: content-box;\n    height: 56px;\n    padding: 14px 14px;\n    width: fit-content;\n\n    &.active {\n      background-color: #fff2;\n      pointer-events: none;\n      transition: background-color 0.6s linear;\n    }\n\n    &:hover {\n      background-color: #afb6bb;\n    }\n\n    &::before {\n      animation: appear 0.3s linear 1.6s forwards;\n      background: var(--accent-color);\n      border-radius: 7px;\n      content: '';\n      display: block;\n      flex-grow: 0;\n      flex-shrink: 0;\n      height: 56px;\n      left: 14px;\n      opacity: 0;\n      top: 14px;\n      transition: background-color 0.6s linear;\n      width: 14px;\n    }\n\n    &.active::before {\n      background-color: #fff;\n    }\n\n    .label {\n      display: inline-block;\n      flex-grow: 1;\n      font-size: 24px;\n      font-weight: 400;\n      font-weight: normal;\n      height: 56px;\n      line-height: 56px;\n      padding-left: 68px;\n      padding-right: 32px;\n      position: relative;\n      white-space: nowrap;\n      width: auto;\n\n      .logo {\n        animation: appear 0.3s linear 1.8s forwards;\n        background: url("+F+");\n        content: '';\n        height: 36px;\n        left: 16px;\n        opacity: 0;\n        position: absolute;\n        top: 10px;\n        width: 37px;\n      }\n\n      .text {\n        animation: appear 0.3s linear 2.2s forwards;\n        opacity: 0;\n      }\n    }\n  }\n}\n\n/* Contents */\n\n.contents {\n  align-items: center;\n  display: flex;\n  height: fit-content;\n  justify-content: center;\n  opacity: 0;\n  pointer-events: none;\n\n  &.ready {\n    opacity: 1;\n    pointer-events: all;\n  }\n\n  .opera-logo {\n    background-position: center;\n    background-repeat: no-repeat;\n    background-size: cover;\n    background: url("+O+");\n    height: 26px;\n    position: fixed;\n    right: 40px;\n    top: 32px;\n    width: 26px;\n  }\n}\n\n/* Popup */\n\n.popup {\n  --shadow-color: color-mix(\n    in srgb,\n    var(--primary-text-color) 24%,\n    transparent\n  );\n  background-color: var(--tile-background-color);\n  border-radius: 12px;\n  filter: drop-shadow(0 0 4px var(--shadow-color));\n  left: 50%;\n  opacity: 1;\n  padding: 16px;\n  position: absolute;\n  top: 50%;\n  transform: translate(-50%, -50%);\n  width: 200px;\n  z-index: 3;\n\n  .header {\n    align-items: center;\n    color: var(--primary-text-color);\n    display: inline-flex;\n    flex-direction: row;\n    font-size: 12px;\n    font-weight: 700;\n    justify-content: space-between;\n    text-transform: uppercase;\n    width: 100%;\n\n    .close {\n      align-items: center;\n      cursor: pointer;\n      display: flex;\n      height: 13px;\n      justify-content: center;\n      padding: 2px;\n      width: 12px;\n    }\n  }\n\n  .message {\n    border-top: 1px solid var(--shadow-color);\n    color: var(--primary-text-color);\n    margin-top: 12px;\n    padding-top: 12px;\n  }\n}\n\n.fade {\n  bottom: 0;\n  left: 0;\n  position: fixed;\n  right: 0;\n  top: 0;\n  z-index: 3;\n}\n\n/* Gallery */\n\n.gallery {\n  display: grid;\n  grid-template-columns: repeat(5, 100vw);\n  height: fit-content;\n  margin: auto;\n  padding-bottom: 48px;\n  position: relative;\n  width: var(--max-content-width);\n\n  .header {\n    display: flex;\n    flex-direction: column;\n    gap: 24px;\n  }\n\n  .screens {\n    display: contents;\n\n    .screen {\n      &.active {\n        pointer-events: all;\n      }\n\n      align-items: center;\n      box-sizing: border-box;\n      display: flex;\n      height: fit-content;\n      justify-content: center;\n      min-width: var(--min-content-width);\n      pointer-events: none;\n      position: relative;\n      width: var(--content-width);\n    }\n  }\n\n  .page {\n    box-sizing: border-box;\n    display: flex;\n    flex-direction: column;\n    height: 100%;\n    justify-content: center;\n    margin: auto;\n    min-width: var(--min-content-width);\n    opacity: 0;\n    pointer-events: none;\n    position: relative;\n    width: fit-content;\n  }\n\n  .active .page {\n    pointer-events: all;\n  }\n\n  .content {\n    display: flex;\n    flex-direction: column;\n    height: fit-content;\n    position: relative;\n    width: var(--content-width);\n\n    .title,\n    .subtitle {\n      display: block;\n      position: relative;\n      width: 100%;\n    }\n\n    .wide.title {\n      font-size: 44px;\n      font-size: 48px;\n    }\n\n    .widest.title {\n      font-size: 40px;\n      line-height: 44px;\n    }\n  }\n\n  .feature {\n    background-color: var(--panel-background-color);\n    border-radius: 24px;\n    box-sizing: border-box;\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n    margin: var(--spacing) auto;\n    width: var(--content-width);\n    padding: var(--padding);\n    position: relative;\n    width: 100%;\n  }\n\n  .navigation {\n    animation: appear 0.3s linear 0.2s forwards;\n    bottom: 0;\n    height: 24px;\n    margin-bottom: var(--spacing);\n    opacity: 0;\n    position: absolute;\n    width: var(--max-content-width);\n\n    .controls,\n    .pagination {\n      align-items: center;\n      display: flex;\n      height: 100%;\n      position: absolute;\n      width: 100%;\n    }\n\n    .controls {\n      --default-link-color: var(--dark-font-color);\n      --hovered-link-color: var(--accent-color);\n\n      @media (prefers-color-scheme: dark) {\n        --default-link-color: #ffffff80;\n        --hovered-link-color: var(--light-font-color);\n      }\n\n      color: var(--default-link-color);\n      font-size: 20px;\n      font-weight: 700;\n      justify-content: space-between;\n\n      .left,\n      .right {\n        display: flex;\n        z-index: 1;\n      }\n\n      .right {\n        position: relative;\n        left: 4px;\n      }\n\n      .link {\n        cursor: pointer;\n        padding: 2px 8px;\n        user-select: none;\n\n        &:hover,\n        &:focus {\n          color: var(--hovered-link-color);\n        }\n      }\n\n      .right > .link {\n        &:not(:last-child) {\n          border-right: 2px solid #a4a4a4;\n        }\n      }\n    }\n\n    .pagination {\n      justify-content: center;\n      pointer-events: none;\n\n      .dots {\n        --inactive-dot-color: #00000040;\n        --active-dot-color: var(--accent-color);\n\n        @media (prefers-color-scheme: dark) {\n          --inactive-dot-color: #ffffff40;\n          --active-dot-color: var(--light-font-color);\n        }\n\n        align-items: center;\n        display: flex;\n        gap: 8px;\n        justify-content: center;\n        pointer-events: all;\n        width: 100%;\n      }\n\n      .dot {\n        background-color: var(--inactive-dot-color);\n        border-radius: 50%;\n        cursor: pointer;\n        height: 12px;\n        transition: all 0.2s ease-out;\n        width: 12px;\n\n        &.active {\n          background-color: var(--active-dot-color);\n          height: 16px;\n          width: 16px;\n        }\n      }\n    }\n  }\n\n  .screen:nth-child(2) {\n    left: -100vw;\n  }\n\n  .screen:nth-child(3) {\n    left: -200vw;\n  }\n\n  .screen:nth-child(4) {\n    left: -300vw;\n  }\n\n  .screen:nth-child(5) {\n    left: -400vw;\n  }\n\n  .screen:nth-child(6) {\n    left: -500vw;\n  }\n}\n\n/* Theme */\n\n#theme {\n  .tile {\n    background-color: transparent;\n\n    &::before,\n    &::after {\n      background-position: center;\n      background-repeat: no-repeat;\n      background-size: 192px 192px;\n      border-radius: 20px;\n      height: 192px;\n      position: absolute;\n      width: 192px;\n    }\n  }\n\n  .theme {\n    align-items: center;\n    cursor: pointer;\n    display: flex;\n    justify-content: center;\n    position: relative;\n  }\n\n  .theme::before,\n  .system.theme::after {\n    content: '';\n    opacity: 0.75;\n    transition: opacity 0.2s linear;\n    z-index: 1;\n  }\n\n  .selected.theme::before,\n  .selected.theme::after,\n  .theme:hover::before,\n  .theme:hover::after {\n    opacity: 1;\n  }\n\n  .light.theme::before {\n    background-image: url("+R+");\n  }\n\n  .dark.theme::before {\n    background-image: url("+L+");\n  }\n\n  .system.theme::before {\n    background-image: url("+R+");\n    clip-path: polygon(0 0, 100% 0, 0 100%);\n  }\n\n  .system.theme::after {\n    background-image: url("+L+");\n    clip-path: polygon(100% 0, 100% 100%, 0 100%);\n    z-index: 2;\n  }\n\n  .theme .name {\n    background: white;\n    border-radius: 8px;\n    color: black;\n    font-size: 20px;\n    font-weight: 700;\n    padding: 8px 16px;\n    z-index: 3;\n  }\n}\n\n/* Wallpapers */\n\n#wallpaper {\n  .thumbnail {\n    cursor: pointer;\n    position: relative;\n    user-select: none;\n\n    &.tile {\n      background-color: transparent;\n    }\n\n    .image {\n      background-position: center;\n      background-size: cover;\n      background-repeat: no-repeat;\n      border-radius: 20px;\n      width: 100%;\n      height: 100%;\n      transition: opacity 0.2s linear;\n    }\n\n    &:hover .image {\n      opacity: 1;\n    }\n\n    &.dimmed .image {\n      opacity: 0.6;\n    }\n\n    .image,\n    .spinner {\n      bottom: 0;\n      left: 0;\n      position: absolute;\n      right: 0;\n      top: 0;\n    }\n\n    &.selected .image {\n      opacity: 1;\n    }\n  }\n}\n\n/* Ad blocker */\n\n#adblocker {\n  .label {\n    color: var(--icon-background-color);\n    font-family: Averta;\n    font-size: 15px;\n    font-weight: 400;\n    padding: 0 24px;\n    position: relative;\n    text-align: center;\n    top: -10px;\n    user-select: none;\n  }\n\n  .preview {\n    height: 200px;\n    width: 332px;\n  }\n\n  .adblock {\n    --switch-background-color: black;\n    align-items: center;\n    display: flex;\n    flex-direction: column;\n    gap: 16px;\n    justify-content: center;\n  }\n\n  input[type='checkbox'] {\n    appearance: none;\n    background-color: var(--inactive-background-color);\n    border-radius: 6px;\n    cursor: pointer;\n    height: 32px;\n    position: relative;\n    width: 60px;\n  }\n\n  input[type='checkbox']::after {\n    background-color: white;\n    border-radius: 3px;\n    content: '';\n    display: block;\n    height: 20px;\n    left: 6px;\n    position: absolute;\n    top: 6px;\n    transition: all 0.2s cubic-bezier(0.175, 0.885, 0.32, 1.275);\n    width: 20px;\n  }\n\n  input[type='checkbox']:checked {\n    background-color: var(--active-background-color);\n  }\n\n  input[type='checkbox']:checked::after {\n    left: 34px;\n  }\n}\n\n/* Messengers */\n\n#messengers {\n  .feature {\n    gap: 16px;\n  }\n\n  .tile {\n    cursor: pointer;\n    display: flex;\n    justify-content: center;\n    width: 100px;\n\n    .messenger {\n      filter: url(#light-grey-filter);\n      height: 100%;\n      margin-top: 60px;\n      position: relative;\n      align-items: center;\n      display: flex;\n      flex-direction: column;\n      height: 62px;\n      width: 60px;\n\n      .icon {\n        align-items: center;\n        display: flex;\n        height: 60px;\n        justify-content: center;\n        width: 60px;\n      }\n\n      .name {\n        align-items: center;\n        color: var(--tile-font-color);\n        display: flex;\n        font-family: Averta;\n        font-size: 14px;\n        font-weight: 700;\n        line-height: 24px;\n        margin: 0px;\n        opacity: 0.5;\n        padding-top: 8px;\n      }\n\n      .overlay-icon {\n        right: 0;\n        top: -8px;\n      }\n\n      .icon i {\n        background-position: center;\n        background-repeat: no-repeat;\n        background-size: 48px;\n        display: block;\n        height: 48px;\n        width: 48px;\n      }\n    }\n\n    &:hover .messenger,\n    &.active .messenger {\n      filter: none;\n\n      .name {\n        opacity: 1;\n      }\n    }\n  }\n}\n\n/* Import */\n\n#import {\n  .browsers {\n    align-items: center;\n    display: flex;\n    gap: 16px;\n  }\n\n  .tile {\n    align-items: center;\n    cursor: pointer;\n    display: flex;\n    flex-direction: column;\n    padding-top: 48px;\n    position: relative;\n    user-select: none;\n    width: 120px;\n\n    .browser {\n      align-items: center;\n      display: flex;\n      flex-direction: column;\n      position: relative;\n      width: fit-content;\n\n      &.available {\n        cursor: pointer;\n      }\n\n      .name {\n        color: var(--tile-font-color);\n        filter: none;\n        font-size: 14px;\n        font-style: normal;\n        font-weight: 600;\n        line-height: 18px;\n        opacity: 0.6;\n        padding-top: 4px;\n        text-align: center;\n        width: 100px;\n        white-space: nowrap;\n      }\n\n      .icon {\n        position: relative;\n        height: 64px;\n        width: 64px;\n\n        i {\n          display: inline-block;\n          background-position: center;\n          background-size: contain;\n          filter: url(#light-grey-filter);\n          height: 100%;\n          width: 100%;\n        }\n\n        .spinner {\n          left: 0;\n          position: absolute;\n          right: 0;\n          top: 8px;\n        }\n\n        .overlay-icon {\n          right: 2px;\n          top: -4px;\n          z-index: 2;\n\n          & svg {\n            height: 24px;\n            width: 24px;\n          }\n        }\n      }\n    }\n\n    &.imported {\n      opacity: 1;\n      pointer-events: none;\n\n      .browser .icon i {\n        filter: none;\n      }\n    }\n\n    &:hover .browser .icon i {\n      filter: none;\n    }\n\n    &.disabled {\n      background-color: transparent;\n      opacity: 0.16;\n      pointer-events: none;\n    }\n  }\n}\n\n/* Summary */\n\n#summary {\n  height: 100vh;\n  left: 0;\n  min-height: 100vh;\n  position: fixed;\n  right: 0;\n  top: 0;\n\n  .content {\n    display: flex;\n    flex-direction: column;\n    height: 100vh;\n    justify-content: space-between;\n    margin: 0 auto;\n    width: var(--outro-width);\n  }\n\n  .header {\n    display: flex;\n    flex-direction: column;\n    gap: var(--spacing);\n    padding: calc(2 * var(--spacing)) 0;\n    pointer-events: none;\n    width: var(--max-content-width);\n\n    .title {\n      line-height: 56px;\n    }\n\n    @media screen and (height > 600px) {\n      margin-top: calc(30vh - 180px);\n      gap: calc(5vh - 30px + var(--spacing));\n    }\n  }\n\n  .start {\n    background-color: var(--accent-color);\n    border: 0;\n    border-radius: 16px;\n    color: var(--light-font-color);\n    font-size: 12px;\n    font-size: 18px;\n    font-weight: 700;\n    letter-spacing: 1px;\n    padding: 16px 32px;\n    width: fit-content;\n  }\n\n  .page {\n    padding: 0;\n  }\n\n  .preview {\n    height: 270px;\n    position: relative;\n    width: 720px;\n\n    i {\n      background-size: cover;\n      display: inline-block;\n      position: absolute;\n    }\n\n    .desktop {\n      background-image: url("+N+");\n      height: 470.5px;\n      left: 0;\n      position: absolute;\n      top: 0;\n      width: 720px;\n    }\n\n    .android {\n      background-image: url("+V+");\n      height: 339px;\n      right: -92px;\n      top: 74px;\n      width: 159.5px;\n    }\n\n    .ios {\n      background-image: url("+B+");\n      height: 326px;\n      right: 44px;\n      top: 90px;\n      width: 153.5px;\n    }\n  }\n}\n",""]);const z=E},3645:e=>{"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var n="",r=void 0!==t[5];return t[4]&&(n+="@supports (".concat(t[4],") {")),t[2]&&(n+="@media ".concat(t[2]," {")),r&&(n+="@layer".concat(t[5].length>0?" ".concat(t[5]):""," {")),n+=e(t),r&&(n+="}"),t[2]&&(n+="}"),t[4]&&(n+="}"),n})).join("")},t.i=function(e,n,r,a,i){"string"==typeof e&&(e=[[null,e,void 0]]);var s={};if(r)for(var o=0;o<this.length;o++){var l=this[o][0];null!=l&&(s[l]=!0)}for(var u=0;u<e.length;u++){var c=[].concat(e[u]);r&&s[c[0]]||(void 0!==i&&(void 0===c[5]||(c[1]="@layer".concat(c[5].length>0?" ".concat(c[5]):""," {").concat(c[1],"}")),c[5]=i),n&&(c[2]?(c[1]="@media ".concat(c[2]," {").concat(c[1],"}"),c[2]=n):c[2]=n),a&&(c[4]?(c[1]="@supports (".concat(c[4],") {").concat(c[1],"}"),c[4]=a):c[4]="".concat(a)),t.push(c))}},t}},1667:e=>{"use strict";e.exports=function(e,t){return t||(t={}),e?(e=String(e.__esModule?e.default:e),/^['"].*['"]$/.test(e)&&(e=e.slice(1,-1)),t.hash&&(e+=t.hash),/["'() \t\n]|(%20)/.test(e)||t.needQuotes?'"'.concat(e.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):e):e}},8081:e=>{"use strict";e.exports=function(e){return e[1]}},1248:function(module,exports,__webpack_require__){var factory;"undefined"!=typeof navigator&&(factory=function(){"use strict";var svgNS="http://www.w3.org/2000/svg",locationHref="",_useWebWorker=!1,initialDefaultFrame=-999999,setWebWorker=function(e){_useWebWorker=!!e},getWebWorker=function(){return _useWebWorker},setLocationHref=function(e){locationHref=e},getLocationHref=function(){return locationHref};function createTag(e){return document.createElement(e)}function extendPrototype(e,t){var n,r,a=e.length;for(n=0;n<a;n+=1)for(var i in r=e[n].prototype)Object.prototype.hasOwnProperty.call(r,i)&&(t.prototype[i]=r[i])}function getDescriptor(e,t){return Object.getOwnPropertyDescriptor(e,t)}function createProxyFunction(e){function t(){}return t.prototype=e,t}var audioControllerFactory=function(){function e(e){this.audios=[],this.audioFactory=e,this._volume=1,this._isMuted=!1}return e.prototype={addAudio:function(e){this.audios.push(e)},pause:function(){var e,t=this.audios.length;for(e=0;e<t;e+=1)this.audios[e].pause()},resume:function(){var e,t=this.audios.length;for(e=0;e<t;e+=1)this.audios[e].resume()},setRate:function(e){var t,n=this.audios.length;for(t=0;t<n;t+=1)this.audios[t].setRate(e)},createAudio:function(e){return this.audioFactory?this.audioFactory(e):window.Howl?new window.Howl({src:[e]}):{isPlaying:!1,play:function(){this.isPlaying=!0},seek:function(){this.isPlaying=!1},playing:function(){},rate:function(){},setVolume:function(){}}},setAudioFactory:function(e){this.audioFactory=e},setVolume:function(e){this._volume=e,this._updateVolume()},mute:function(){this._isMuted=!0,this._updateVolume()},unmute:function(){this._isMuted=!1,this._updateVolume()},getVolume:function(){return this._volume},_updateVolume:function(){var e,t=this.audios.length;for(e=0;e<t;e+=1)this.audios[e].volume(this._volume*(this._isMuted?0:1))}},function(){return new e}}(),createTypedArray=function(){function e(e,t){var n,r=0,a=[];switch(e){case"int16":case"uint8c":n=1;break;default:n=1.1}for(r=0;r<t;r+=1)a.push(n);return a}return"function"==typeof Uint8ClampedArray&&"function"==typeof Float32Array?function(t,n){return"float32"===t?new Float32Array(n):"int16"===t?new Int16Array(n):"uint8c"===t?new Uint8ClampedArray(n):e(t,n)}:e}();function createSizedArray(e){return Array.apply(null,{length:e})}function _typeof$6(e){return _typeof$6="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$6(e)}var subframeEnabled=!0,expressionsPlugin=null,expressionsInterfaces=null,idPrefix$1="",isSafari=/^((?!chrome|android).)*safari/i.test(navigator.userAgent),_shouldRoundValues=!1,bmPow=Math.pow,bmSqrt=Math.sqrt,bmFloor=Math.floor,bmMax=Math.max,bmMin=Math.min,BMMath={};function ProjectInterface$1(){return{}}!function(){var e,t=["abs","acos","acosh","asin","asinh","atan","atanh","atan2","ceil","cbrt","expm1","clz32","cos","cosh","exp","floor","fround","hypot","imul","log","log1p","log2","log10","max","min","pow","random","round","sign","sin","sinh","sqrt","tan","tanh","trunc","E","LN10","LN2","LOG10E","LOG2E","PI","SQRT1_2","SQRT2"],n=t.length;for(e=0;e<n;e+=1)BMMath[t[e]]=Math[t[e]]}(),BMMath.random=Math.random,BMMath.abs=function(e){if("object"===_typeof$6(e)&&e.length){var t,n=createSizedArray(e.length),r=e.length;for(t=0;t<r;t+=1)n[t]=Math.abs(e[t]);return n}return Math.abs(e)};var defaultCurveSegments=150,degToRads=Math.PI/180,roundCorner=.5519;function roundValues(e){_shouldRoundValues=!!e}function bmRnd(e){return _shouldRoundValues?Math.round(e):e}function styleDiv(e){e.style.position="absolute",e.style.top=0,e.style.left=0,e.style.display="block",e.style.transformOrigin="0 0",e.style.webkitTransformOrigin="0 0",e.style.backfaceVisibility="visible",e.style.webkitBackfaceVisibility="visible",e.style.transformStyle="preserve-3d",e.style.webkitTransformStyle="preserve-3d",e.style.mozTransformStyle="preserve-3d"}function BMEnterFrameEvent(e,t,n,r){this.type=e,this.currentTime=t,this.totalTime=n,this.direction=r<0?-1:1}function BMCompleteEvent(e,t){this.type=e,this.direction=t<0?-1:1}function BMCompleteLoopEvent(e,t,n,r){this.type=e,this.currentLoop=n,this.totalLoops=t,this.direction=r<0?-1:1}function BMSegmentStartEvent(e,t,n){this.type=e,this.firstFrame=t,this.totalFrames=n}function BMDestroyEvent(e,t){this.type=e,this.target=t}function BMRenderFrameErrorEvent(e,t){this.type="renderFrameError",this.nativeError=e,this.currentTime=t}function BMConfigErrorEvent(e){this.type="configError",this.nativeError=e}function BMAnimationConfigErrorEvent(e,t){this.type=e,this.nativeError=t}var createElementID=(_count=0,function(){return idPrefix$1+"__lottie_element_"+(_count+=1)}),_count;function HSVtoRGB(e,t,n){var r,a,i,s,o,l,u,c;switch(l=n*(1-t),u=n*(1-(o=6*e-(s=Math.floor(6*e)))*t),c=n*(1-(1-o)*t),s%6){case 0:r=n,a=c,i=l;break;case 1:r=u,a=n,i=l;break;case 2:r=l,a=n,i=c;break;case 3:r=l,a=u,i=n;break;case 4:r=c,a=l,i=n;break;case 5:r=n,a=l,i=u}return[r,a,i]}function RGBtoHSV(e,t,n){var r,a=Math.max(e,t,n),i=Math.min(e,t,n),s=a-i,o=0===a?0:s/a,l=a/255;switch(a){case i:r=0;break;case e:r=t-n+s*(t<n?6:0),r/=6*s;break;case t:r=n-e+2*s,r/=6*s;break;case n:r=e-t+4*s,r/=6*s}return[r,o,l]}function addSaturationToRGB(e,t){var n=RGBtoHSV(255*e[0],255*e[1],255*e[2]);return n[1]+=t,n[1]>1?n[1]=1:n[1]<=0&&(n[1]=0),HSVtoRGB(n[0],n[1],n[2])}function addBrightnessToRGB(e,t){var n=RGBtoHSV(255*e[0],255*e[1],255*e[2]);return n[2]+=t,n[2]>1?n[2]=1:n[2]<0&&(n[2]=0),HSVtoRGB(n[0],n[1],n[2])}function addHueToRGB(e,t){var n=RGBtoHSV(255*e[0],255*e[1],255*e[2]);return n[0]+=t/360,n[0]>1?n[0]-=1:n[0]<0&&(n[0]+=1),HSVtoRGB(n[0],n[1],n[2])}var rgbToHex=function(){var e,t,n=[];for(e=0;e<256;e+=1)t=e.toString(16),n[e]=1===t.length?"0"+t:t;return function(e,t,r){return e<0&&(e=0),t<0&&(t=0),r<0&&(r=0),"#"+n[e]+n[t]+n[r]}}(),setSubframeEnabled=function(e){subframeEnabled=!!e},getSubframeEnabled=function(){return subframeEnabled},setExpressionsPlugin=function(e){expressionsPlugin=e},getExpressionsPlugin=function(){return expressionsPlugin},setExpressionInterfaces=function(e){expressionsInterfaces=e},getExpressionInterfaces=function(){return expressionsInterfaces},setDefaultCurveSegments=function(e){defaultCurveSegments=e},getDefaultCurveSegments=function(){return defaultCurveSegments},setIdPrefix=function(e){idPrefix$1=e},getIdPrefix=function(){return idPrefix$1};function createNS(e){return document.createElementNS(svgNS,e)}function _typeof$5(e){return _typeof$5="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$5(e)}var dataManager=function(){var e,t,n=1,r=[],a={onmessage:function(){},postMessage:function(t){e({data:t})}},i={postMessage:function(e){a.onmessage({data:e})}};function s(){t||(t=function(t){if(window.Worker&&window.Blob&&getWebWorker()){var n=new Blob(["var _workerSelf = self; self.onmessage = ",t.toString()],{type:"text/javascript"}),r=URL.createObjectURL(n);return new Worker(r)}return e=t,a}((function(e){if(i.dataManager||(i.dataManager=function(){function e(a,i){var s,o,l,u,c,p,f=a.length;for(o=0;o<f;o+=1)if("ks"in(s=a[o])&&!s.completed){if(s.completed=!0,s.hasMask){var d=s.masksProperties;for(u=d.length,l=0;l<u;l+=1)if(d[l].pt.k.i)r(d[l].pt.k);else for(p=d[l].pt.k.length,c=0;c<p;c+=1)d[l].pt.k[c].s&&r(d[l].pt.k[c].s[0]),d[l].pt.k[c].e&&r(d[l].pt.k[c].e[0])}0===s.ty?(s.layers=t(s.refId,i),e(s.layers,i)):4===s.ty?n(s.shapes):5===s.ty&&h(s)}}function t(e,t){var n=function(e,t){for(var n=0,r=t.length;n<r;){if(t[n].id===e)return t[n];n+=1}return null}(e,t);return n?n.layers.__used?JSON.parse(JSON.stringify(n.layers)):(n.layers.__used=!0,n.layers):null}function n(e){var t,a,i;for(t=e.length-1;t>=0;t-=1)if("sh"===e[t].ty)if(e[t].ks.k.i)r(e[t].ks.k);else for(i=e[t].ks.k.length,a=0;a<i;a+=1)e[t].ks.k[a].s&&r(e[t].ks.k[a].s[0]),e[t].ks.k[a].e&&r(e[t].ks.k[a].e[0]);else"gr"===e[t].ty&&n(e[t].it)}function r(e){var t,n=e.i.length;for(t=0;t<n;t+=1)e.i[t][0]+=e.v[t][0],e.i[t][1]+=e.v[t][1],e.o[t][0]+=e.v[t][0],e.o[t][1]+=e.v[t][1]}function a(e,t){var n=t?t.split("."):[100,100,100];return e[0]>n[0]||!(n[0]>e[0])&&(e[1]>n[1]||!(n[1]>e[1])&&(e[2]>n[2]||!(n[2]>e[2])&&null))}var i,s=function(){var e=[4,4,14];function t(e){var t,n,r,a=e.length;for(t=0;t<a;t+=1)5===e[t].ty&&(r=void 0,r=(n=e[t]).t.d,n.t.d={k:[{s:r,t:0}]})}return function(n){if(a(e,n.v)&&(t(n.layers),n.assets)){var r,i=n.assets.length;for(r=0;r<i;r+=1)n.assets[r].layers&&t(n.assets[r].layers)}}}(),o=(i=[4,7,99],function(e){if(e.chars&&!a(i,e.v)){var t,r=e.chars.length;for(t=0;t<r;t+=1){var s=e.chars[t];s.data&&s.data.shapes&&(n(s.data.shapes),s.data.ip=0,s.data.op=99999,s.data.st=0,s.data.sr=1,s.data.ks={p:{k:[0,0],a:0},s:{k:[100,100],a:0},a:{k:[0,0],a:0},r:{k:0,a:0},o:{k:100,a:0}},e.chars[t].t||(s.data.shapes.push({ty:"no"}),s.data.shapes[0].it.push({p:{k:[0,0],a:0},s:{k:[100,100],a:0},a:{k:[0,0],a:0},r:{k:0,a:0},o:{k:100,a:0},sk:{k:0,a:0},sa:{k:0,a:0},ty:"tr"})))}}}),l=function(){var e=[5,7,15];function t(e){var t,n,r=e.length;for(t=0;t<r;t+=1)5===e[t].ty&&(n=void 0,"number"==typeof(n=e[t].t.p).a&&(n.a={a:0,k:n.a}),"number"==typeof n.p&&(n.p={a:0,k:n.p}),"number"==typeof n.r&&(n.r={a:0,k:n.r}))}return function(n){if(a(e,n.v)&&(t(n.layers),n.assets)){var r,i=n.assets.length;for(r=0;r<i;r+=1)n.assets[r].layers&&t(n.assets[r].layers)}}}(),u=function(){var e=[4,1,9];function t(e){var n,r,a,i=e.length;for(n=0;n<i;n+=1)if("gr"===e[n].ty)t(e[n].it);else if("fl"===e[n].ty||"st"===e[n].ty)if(e[n].c.k&&e[n].c.k[0].i)for(a=e[n].c.k.length,r=0;r<a;r+=1)e[n].c.k[r].s&&(e[n].c.k[r].s[0]/=255,e[n].c.k[r].s[1]/=255,e[n].c.k[r].s[2]/=255,e[n].c.k[r].s[3]/=255),e[n].c.k[r].e&&(e[n].c.k[r].e[0]/=255,e[n].c.k[r].e[1]/=255,e[n].c.k[r].e[2]/=255,e[n].c.k[r].e[3]/=255);else e[n].c.k[0]/=255,e[n].c.k[1]/=255,e[n].c.k[2]/=255,e[n].c.k[3]/=255}function n(e){var n,r=e.length;for(n=0;n<r;n+=1)4===e[n].ty&&t(e[n].shapes)}return function(t){if(a(e,t.v)&&(n(t.layers),t.assets)){var r,i=t.assets.length;for(r=0;r<i;r+=1)t.assets[r].layers&&n(t.assets[r].layers)}}}(),c=function(){var e=[4,4,18];function t(e){var n,r,a;for(n=e.length-1;n>=0;n-=1)if("sh"===e[n].ty)if(e[n].ks.k.i)e[n].ks.k.c=e[n].closed;else for(a=e[n].ks.k.length,r=0;r<a;r+=1)e[n].ks.k[r].s&&(e[n].ks.k[r].s[0].c=e[n].closed),e[n].ks.k[r].e&&(e[n].ks.k[r].e[0].c=e[n].closed);else"gr"===e[n].ty&&t(e[n].it)}function n(e){var n,r,a,i,s,o,l=e.length;for(r=0;r<l;r+=1){if((n=e[r]).hasMask){var u=n.masksProperties;for(i=u.length,a=0;a<i;a+=1)if(u[a].pt.k.i)u[a].pt.k.c=u[a].cl;else for(o=u[a].pt.k.length,s=0;s<o;s+=1)u[a].pt.k[s].s&&(u[a].pt.k[s].s[0].c=u[a].cl),u[a].pt.k[s].e&&(u[a].pt.k[s].e[0].c=u[a].cl)}4===n.ty&&t(n.shapes)}}return function(t){if(a(e,t.v)&&(n(t.layers),t.assets)){var r,i=t.assets.length;for(r=0;r<i;r+=1)t.assets[r].layers&&n(t.assets[r].layers)}}}();function h(e){0===e.t.a.length&&e.t.p}var p={completeData:function(n){n.__complete||(u(n),s(n),o(n),l(n),c(n),e(n.layers,n.assets),function(n,r){if(n){var a=0,i=n.length;for(a=0;a<i;a+=1)1===n[a].t&&(n[a].data.layers=t(n[a].data.refId,r),e(n[a].data.layers,r))}}(n.chars,n.assets),n.__complete=!0)}};return p.checkColors=u,p.checkChars=o,p.checkPathProperties=l,p.checkShapes=c,p.completeLayers=e,p}()),i.assetLoader||(i.assetLoader=function(){function e(e){var t=e.getResponseHeader("content-type");return t&&"json"===e.responseType&&-1!==t.indexOf("json")||e.response&&"object"===_typeof$5(e.response)?e.response:e.response&&"string"==typeof e.response?JSON.parse(e.response):e.responseText?JSON.parse(e.responseText):null}return{load:function(t,n,r,a){var i,s=new XMLHttpRequest;try{s.responseType="json"}catch(e){}s.onreadystatechange=function(){if(4===s.readyState)if(200===s.status)i=e(s),r(i);else try{i=e(s),r(i)}catch(e){a&&a(e)}};try{s.open(["G","E","T"].join(""),t,!0)}catch(e){s.open(["G","E","T"].join(""),n+"/"+t,!0)}s.send()}}}()),"loadAnimation"===e.data.type)i.assetLoader.load(e.data.path,e.data.fullPath,(function(t){i.dataManager.completeData(t),i.postMessage({id:e.data.id,payload:t,status:"success"})}),(function(){i.postMessage({id:e.data.id,status:"error"})}));else if("complete"===e.data.type){var t=e.data.animation;i.dataManager.completeData(t),i.postMessage({id:e.data.id,payload:t,status:"success"})}else"loadData"===e.data.type&&i.assetLoader.load(e.data.path,e.data.fullPath,(function(t){i.postMessage({id:e.data.id,payload:t,status:"success"})}),(function(){i.postMessage({id:e.data.id,status:"error"})}))})),t.onmessage=function(e){var t=e.data,n=t.id,a=r[n];r[n]=null,"success"===t.status?a.onComplete(t.payload):a.onError&&a.onError()})}function o(e,t){var a="processId_"+(n+=1);return r[a]={onComplete:e,onError:t},a}return{loadAnimation:function(e,n,r){s();var a=o(n,r);t.postMessage({type:"loadAnimation",path:e,fullPath:window.location.origin+window.location.pathname,id:a})},loadData:function(e,n,r){s();var a=o(n,r);t.postMessage({type:"loadData",path:e,fullPath:window.location.origin+window.location.pathname,id:a})},completeAnimation:function(e,n,r){s();var a=o(n,r);t.postMessage({type:"complete",animation:e,id:a})}}}(),ImagePreloader=function(){var e=function(){var e=createTag("canvas");e.width=1,e.height=1;var t=e.getContext("2d");return t.fillStyle="rgba(0,0,0,0)",t.fillRect(0,0,1,1),e}();function t(){this.loadedAssets+=1,this.loadedAssets===this.totalImages&&this.loadedFootagesCount===this.totalFootages&&this.imagesLoadedCb&&this.imagesLoadedCb(null)}function n(){this.loadedFootagesCount+=1,this.loadedAssets===this.totalImages&&this.loadedFootagesCount===this.totalFootages&&this.imagesLoadedCb&&this.imagesLoadedCb(null)}function r(e,t,n){var r="";if(e.e)r=e.p;else if(t){var a=e.p;-1!==a.indexOf("images/")&&(a=a.split("/")[1]),r=t+a}else r=n,r+=e.u?e.u:"",r+=e.p;return r}function a(e){var t=0,n=setInterval(function(){(e.getBBox().width||t>500)&&(this._imageLoaded(),clearInterval(n)),t+=1}.bind(this),50)}function i(e){var t={assetData:e},n=r(e,this.assetsPath,this.path);return dataManager.loadData(n,function(e){t.img=e,this._footageLoaded()}.bind(this),function(){t.img={},this._footageLoaded()}.bind(this)),t}function s(){this._imageLoaded=t.bind(this),this._footageLoaded=n.bind(this),this.testImageLoaded=a.bind(this),this.createFootageData=i.bind(this),this.assetsPath="",this.path="",this.totalImages=0,this.totalFootages=0,this.loadedAssets=0,this.loadedFootagesCount=0,this.imagesLoadedCb=null,this.images=[]}return s.prototype={loadAssets:function(e,t){var n;this.imagesLoadedCb=t;var r=e.length;for(n=0;n<r;n+=1)e[n].layers||(e[n].t&&"seq"!==e[n].t?3===e[n].t&&(this.totalFootages+=1,this.images.push(this.createFootageData(e[n]))):(this.totalImages+=1,this.images.push(this._createImageData(e[n]))))},setAssetsPath:function(e){this.assetsPath=e||""},setPath:function(e){this.path=e||""},loadedImages:function(){return this.totalImages===this.loadedAssets},loadedFootages:function(){return this.totalFootages===this.loadedFootagesCount},destroy:function(){this.imagesLoadedCb=null,this.images.length=0},getAsset:function(e){for(var t=0,n=this.images.length;t<n;){if(this.images[t].assetData===e)return this.images[t].img;t+=1}return null},createImgData:function(t){var n=r(t,this.assetsPath,this.path),a=createTag("img");a.crossOrigin="anonymous",a.addEventListener("load",this._imageLoaded,!1),a.addEventListener("error",function(){i.img=e,this._imageLoaded()}.bind(this),!1),a.src=n;var i={img:a,assetData:t};return i},createImageData:function(t){var n=r(t,this.assetsPath,this.path),a=createNS("image");isSafari?this.testImageLoaded(a):a.addEventListener("load",this._imageLoaded,!1),a.addEventListener("error",function(){i.img=e,this._imageLoaded()}.bind(this),!1),a.setAttributeNS("http://www.w3.org/1999/xlink","href",n),this._elementHelper.append?this._elementHelper.append(a):this._elementHelper.appendChild(a);var i={img:a,assetData:t};return i},imageLoaded:t,footageLoaded:n,setCacheType:function(e,t){"svg"===e?(this._elementHelper=t,this._createImageData=this.createImageData.bind(this)):this._createImageData=this.createImgData.bind(this)}},s}();function BaseEvent(){}BaseEvent.prototype={triggerEvent:function(e,t){if(this._cbs[e])for(var n=this._cbs[e],r=0;r<n.length;r+=1)n[r](t)},addEventListener:function(e,t){return this._cbs[e]||(this._cbs[e]=[]),this._cbs[e].push(t),function(){this.removeEventListener(e,t)}.bind(this)},removeEventListener:function(e,t){if(t){if(this._cbs[e]){for(var n=0,r=this._cbs[e].length;n<r;)this._cbs[e][n]===t&&(this._cbs[e].splice(n,1),n-=1,r-=1),n+=1;this._cbs[e].length||(this._cbs[e]=null)}}else this._cbs[e]=null}};var markerParser=function(){function e(e){for(var t,n=e.split("\r\n"),r={},a=0,i=0;i<n.length;i+=1)2===(t=n[i].split(":")).length&&(r[t[0]]=t[1].trim(),a+=1);if(0===a)throw new Error;return r}return function(t){for(var n=[],r=0;r<t.length;r+=1){var a=t[r],i={time:a.tm,duration:a.dr};try{i.payload=JSON.parse(t[r].cm)}catch(n){try{i.payload=e(t[r].cm)}catch(e){i.payload={name:t[r].cm}}}n.push(i)}return n}}(),ProjectInterface=function(){function e(e){this.compositions.push(e)}return function(){function t(e){for(var t=0,n=this.compositions.length;t<n;){if(this.compositions[t].data&&this.compositions[t].data.nm===e)return this.compositions[t].prepareFrame&&this.compositions[t].data.xt&&this.compositions[t].prepareFrame(this.currentFrame),this.compositions[t].compInterface;t+=1}return null}return t.compositions=[],t.currentFrame=0,t.registerComposition=e,t}}(),renderers={},registerRenderer=function(e,t){renderers[e]=t};function getRenderer(e){return renderers[e]}function getRegisteredRenderer(){if(renderers.canvas)return"canvas";for(var e in renderers)if(renderers[e])return e;return""}function _typeof$4(e){return _typeof$4="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$4(e)}var AnimationItem=function(){this._cbs=[],this.name="",this.path="",this.isLoaded=!1,this.currentFrame=0,this.currentRawFrame=0,this.firstFrame=0,this.totalFrames=0,this.frameRate=0,this.frameMult=0,this.playSpeed=1,this.playDirection=1,this.playCount=0,this.animationData={},this.assets=[],this.isPaused=!0,this.autoplay=!1,this.loop=!0,this.renderer=null,this.animationID=createElementID(),this.assetsPath="",this.timeCompleted=0,this.segmentPos=0,this.isSubframeEnabled=getSubframeEnabled(),this.segments=[],this._idle=!0,this._completedLoop=!1,this.projectInterface=ProjectInterface(),this.imagePreloader=new ImagePreloader,this.audioController=audioControllerFactory(),this.markers=[],this.configAnimation=this.configAnimation.bind(this),this.onSetupError=this.onSetupError.bind(this),this.onSegmentComplete=this.onSegmentComplete.bind(this),this.drawnFrameEvent=new BMEnterFrameEvent("drawnFrame",0,0,0),this.expressionsPlugin=getExpressionsPlugin()};extendPrototype([BaseEvent],AnimationItem),AnimationItem.prototype.setParams=function(e){(e.wrapper||e.container)&&(this.wrapper=e.wrapper||e.container);var t="svg";e.animType?t=e.animType:e.renderer&&(t=e.renderer);var n=getRenderer(t);this.renderer=new n(this,e.rendererSettings),this.imagePreloader.setCacheType(t,this.renderer.globalData.defs),this.renderer.setProjectInterface(this.projectInterface),this.animType=t,""===e.loop||null===e.loop||void 0===e.loop||!0===e.loop?this.loop=!0:!1===e.loop?this.loop=!1:this.loop=parseInt(e.loop,10),this.autoplay=!("autoplay"in e)||e.autoplay,this.name=e.name?e.name:"",this.autoloadSegments=!Object.prototype.hasOwnProperty.call(e,"autoloadSegments")||e.autoloadSegments,this.assetsPath=e.assetsPath,this.initialSegment=e.initialSegment,e.audioFactory&&this.audioController.setAudioFactory(e.audioFactory),e.animationData?this.setupAnimation(e.animationData):e.path&&(-1!==e.path.lastIndexOf("\\")?this.path=e.path.substr(0,e.path.lastIndexOf("\\")+1):this.path=e.path.substr(0,e.path.lastIndexOf("/")+1),this.fileName=e.path.substr(e.path.lastIndexOf("/")+1),this.fileName=this.fileName.substr(0,this.fileName.lastIndexOf(".json")),dataManager.loadAnimation(e.path,this.configAnimation,this.onSetupError))},AnimationItem.prototype.onSetupError=function(){this.trigger("data_failed")},AnimationItem.prototype.setupAnimation=function(e){dataManager.completeAnimation(e,this.configAnimation)},AnimationItem.prototype.setData=function(e,t){t&&"object"!==_typeof$4(t)&&(t=JSON.parse(t));var n={wrapper:e,animationData:t},r=e.attributes;n.path=r.getNamedItem("data-animation-path")?r.getNamedItem("data-animation-path").value:r.getNamedItem("data-bm-path")?r.getNamedItem("data-bm-path").value:r.getNamedItem("bm-path")?r.getNamedItem("bm-path").value:"",n.animType=r.getNamedItem("data-anim-type")?r.getNamedItem("data-anim-type").value:r.getNamedItem("data-bm-type")?r.getNamedItem("data-bm-type").value:r.getNamedItem("bm-type")?r.getNamedItem("bm-type").value:r.getNamedItem("data-bm-renderer")?r.getNamedItem("data-bm-renderer").value:r.getNamedItem("bm-renderer")?r.getNamedItem("bm-renderer").value:getRegisteredRenderer()||"canvas";var a=r.getNamedItem("data-anim-loop")?r.getNamedItem("data-anim-loop").value:r.getNamedItem("data-bm-loop")?r.getNamedItem("data-bm-loop").value:r.getNamedItem("bm-loop")?r.getNamedItem("bm-loop").value:"";"false"===a?n.loop=!1:"true"===a?n.loop=!0:""!==a&&(n.loop=parseInt(a,10));var i=r.getNamedItem("data-anim-autoplay")?r.getNamedItem("data-anim-autoplay").value:r.getNamedItem("data-bm-autoplay")?r.getNamedItem("data-bm-autoplay").value:!r.getNamedItem("bm-autoplay")||r.getNamedItem("bm-autoplay").value;n.autoplay="false"!==i,n.name=r.getNamedItem("data-name")?r.getNamedItem("data-name").value:r.getNamedItem("data-bm-name")?r.getNamedItem("data-bm-name").value:r.getNamedItem("bm-name")?r.getNamedItem("bm-name").value:"","false"===(r.getNamedItem("data-anim-prerender")?r.getNamedItem("data-anim-prerender").value:r.getNamedItem("data-bm-prerender")?r.getNamedItem("data-bm-prerender").value:r.getNamedItem("bm-prerender")?r.getNamedItem("bm-prerender").value:"")&&(n.prerender=!1),n.path?this.setParams(n):this.trigger("destroy")},AnimationItem.prototype.includeLayers=function(e){e.op>this.animationData.op&&(this.animationData.op=e.op,this.totalFrames=Math.floor(e.op-this.animationData.ip));var t,n,r=this.animationData.layers,a=r.length,i=e.layers,s=i.length;for(n=0;n<s;n+=1)for(t=0;t<a;){if(r[t].id===i[n].id){r[t]=i[n];break}t+=1}if((e.chars||e.fonts)&&(this.renderer.globalData.fontManager.addChars(e.chars),this.renderer.globalData.fontManager.addFonts(e.fonts,this.renderer.globalData.defs)),e.assets)for(a=e.assets.length,t=0;t<a;t+=1)this.animationData.assets.push(e.assets[t]);this.animationData.__complete=!1,dataManager.completeAnimation(this.animationData,this.onSegmentComplete)},AnimationItem.prototype.onSegmentComplete=function(e){this.animationData=e;var t=getExpressionsPlugin();t&&t.initExpressions(this),this.loadNextSegment()},AnimationItem.prototype.loadNextSegment=function(){var e=this.animationData.segments;if(!e||0===e.length||!this.autoloadSegments)return this.trigger("data_ready"),void(this.timeCompleted=this.totalFrames);var t=e.shift();this.timeCompleted=t.time*this.frameRate;var n=this.path+this.fileName+"_"+this.segmentPos+".json";this.segmentPos+=1,dataManager.loadData(n,this.includeLayers.bind(this),function(){this.trigger("data_failed")}.bind(this))},AnimationItem.prototype.loadSegments=function(){this.animationData.segments||(this.timeCompleted=this.totalFrames),this.loadNextSegment()},AnimationItem.prototype.imagesLoaded=function(){this.trigger("loaded_images"),this.checkLoaded()},AnimationItem.prototype.preloadImages=function(){this.imagePreloader.setAssetsPath(this.assetsPath),this.imagePreloader.setPath(this.path),this.imagePreloader.loadAssets(this.animationData.assets,this.imagesLoaded.bind(this))},AnimationItem.prototype.configAnimation=function(e){if(this.renderer)try{this.animationData=e,this.initialSegment?(this.totalFrames=Math.floor(this.initialSegment[1]-this.initialSegment[0]),this.firstFrame=Math.round(this.initialSegment[0])):(this.totalFrames=Math.floor(this.animationData.op-this.animationData.ip),this.firstFrame=Math.round(this.animationData.ip)),this.renderer.configAnimation(e),e.assets||(e.assets=[]),this.assets=this.animationData.assets,this.frameRate=this.animationData.fr,this.frameMult=this.animationData.fr/1e3,this.renderer.searchExtraCompositions(e.assets),this.markers=markerParser(e.markers||[]),this.trigger("config_ready"),this.preloadImages(),this.loadSegments(),this.updaFrameModifier(),this.waitForFontsLoaded(),this.isPaused&&this.audioController.pause()}catch(e){this.triggerConfigError(e)}},AnimationItem.prototype.waitForFontsLoaded=function(){this.renderer&&(this.renderer.globalData.fontManager.isLoaded?this.checkLoaded():setTimeout(this.waitForFontsLoaded.bind(this),20))},AnimationItem.prototype.checkLoaded=function(){if(!this.isLoaded&&this.renderer.globalData.fontManager.isLoaded&&(this.imagePreloader.loadedImages()||"canvas"!==this.renderer.rendererType)&&this.imagePreloader.loadedFootages()){this.isLoaded=!0;var e=getExpressionsPlugin();e&&e.initExpressions(this),this.renderer.initItems(),setTimeout(function(){this.trigger("DOMLoaded")}.bind(this),0),this.gotoFrame(),this.autoplay&&this.play()}},AnimationItem.prototype.resize=function(e,t){var n="number"==typeof e?e:void 0,r="number"==typeof t?t:void 0;this.renderer.updateContainerSize(n,r)},AnimationItem.prototype.setSubframe=function(e){this.isSubframeEnabled=!!e},AnimationItem.prototype.gotoFrame=function(){this.currentFrame=this.isSubframeEnabled?this.currentRawFrame:~~this.currentRawFrame,this.timeCompleted!==this.totalFrames&&this.currentFrame>this.timeCompleted&&(this.currentFrame=this.timeCompleted),this.trigger("enterFrame"),this.renderFrame(),this.trigger("drawnFrame")},AnimationItem.prototype.renderFrame=function(){if(!1!==this.isLoaded&&this.renderer)try{this.expressionsPlugin&&this.expressionsPlugin.resetFrame(),this.renderer.renderFrame(this.currentFrame+this.firstFrame)}catch(e){this.triggerRenderFrameError(e)}},AnimationItem.prototype.play=function(e){e&&this.name!==e||!0===this.isPaused&&(this.isPaused=!1,this.trigger("_play"),this.audioController.resume(),this._idle&&(this._idle=!1,this.trigger("_active")))},AnimationItem.prototype.pause=function(e){e&&this.name!==e||!1===this.isPaused&&(this.isPaused=!0,this.trigger("_pause"),this._idle=!0,this.trigger("_idle"),this.audioController.pause())},AnimationItem.prototype.togglePause=function(e){e&&this.name!==e||(!0===this.isPaused?this.play():this.pause())},AnimationItem.prototype.stop=function(e){e&&this.name!==e||(this.pause(),this.playCount=0,this._completedLoop=!1,this.setCurrentRawFrameValue(0))},AnimationItem.prototype.getMarkerData=function(e){for(var t,n=0;n<this.markers.length;n+=1)if((t=this.markers[n]).payload&&t.payload.name===e)return t;return null},AnimationItem.prototype.goToAndStop=function(e,t,n){if(!n||this.name===n){var r=Number(e);if(isNaN(r)){var a=this.getMarkerData(e);a&&this.goToAndStop(a.time,!0)}else t?this.setCurrentRawFrameValue(e):this.setCurrentRawFrameValue(e*this.frameModifier);this.pause()}},AnimationItem.prototype.goToAndPlay=function(e,t,n){if(!n||this.name===n){var r=Number(e);if(isNaN(r)){var a=this.getMarkerData(e);a&&(a.duration?this.playSegments([a.time,a.time+a.duration],!0):this.goToAndStop(a.time,!0))}else this.goToAndStop(r,t,n);this.play()}},AnimationItem.prototype.advanceTime=function(e){if(!0!==this.isPaused&&!1!==this.isLoaded){var t=this.currentRawFrame+e*this.frameModifier,n=!1;t>=this.totalFrames-1&&this.frameModifier>0?this.loop&&this.playCount!==this.loop?t>=this.totalFrames?(this.playCount+=1,this.checkSegments(t%this.totalFrames)||(this.setCurrentRawFrameValue(t%this.totalFrames),this._completedLoop=!0,this.trigger("loopComplete"))):this.setCurrentRawFrameValue(t):this.checkSegments(t>this.totalFrames?t%this.totalFrames:0)||(n=!0,t=this.totalFrames-1):t<0?this.checkSegments(t%this.totalFrames)||(!this.loop||this.playCount--<=0&&!0!==this.loop?(n=!0,t=0):(this.setCurrentRawFrameValue(this.totalFrames+t%this.totalFrames),this._completedLoop?this.trigger("loopComplete"):this._completedLoop=!0)):this.setCurrentRawFrameValue(t),n&&(this.setCurrentRawFrameValue(t),this.pause(),this.trigger("complete"))}},AnimationItem.prototype.adjustSegment=function(e,t){this.playCount=0,e[1]<e[0]?(this.frameModifier>0&&(this.playSpeed<0?this.setSpeed(-this.playSpeed):this.setDirection(-1)),this.totalFrames=e[0]-e[1],this.timeCompleted=this.totalFrames,this.firstFrame=e[1],this.setCurrentRawFrameValue(this.totalFrames-.001-t)):e[1]>e[0]&&(this.frameModifier<0&&(this.playSpeed<0?this.setSpeed(-this.playSpeed):this.setDirection(1)),this.totalFrames=e[1]-e[0],this.timeCompleted=this.totalFrames,this.firstFrame=e[0],this.setCurrentRawFrameValue(.001+t)),this.trigger("segmentStart")},AnimationItem.prototype.setSegment=function(e,t){var n=-1;this.isPaused&&(this.currentRawFrame+this.firstFrame<e?n=e:this.currentRawFrame+this.firstFrame>t&&(n=t-e)),this.firstFrame=e,this.totalFrames=t-e,this.timeCompleted=this.totalFrames,-1!==n&&this.goToAndStop(n,!0)},AnimationItem.prototype.playSegments=function(e,t){if(t&&(this.segments.length=0),"object"===_typeof$4(e[0])){var n,r=e.length;for(n=0;n<r;n+=1)this.segments.push(e[n])}else this.segments.push(e);this.segments.length&&t&&this.adjustSegment(this.segments.shift(),0),this.isPaused&&this.play()},AnimationItem.prototype.resetSegments=function(e){this.segments.length=0,this.segments.push([this.animationData.ip,this.animationData.op]),e&&this.checkSegments(0)},AnimationItem.prototype.checkSegments=function(e){return!!this.segments.length&&(this.adjustSegment(this.segments.shift(),e),!0)},AnimationItem.prototype.destroy=function(e){e&&this.name!==e||!this.renderer||(this.renderer.destroy(),this.imagePreloader.destroy(),this.trigger("destroy"),this._cbs=null,this.onEnterFrame=null,this.onLoopComplete=null,this.onComplete=null,this.onSegmentStart=null,this.onDestroy=null,this.renderer=null,this.expressionsPlugin=null,this.imagePreloader=null,this.projectInterface=null)},AnimationItem.prototype.setCurrentRawFrameValue=function(e){this.currentRawFrame=e,this.gotoFrame()},AnimationItem.prototype.setSpeed=function(e){this.playSpeed=e,this.updaFrameModifier()},AnimationItem.prototype.setDirection=function(e){this.playDirection=e<0?-1:1,this.updaFrameModifier()},AnimationItem.prototype.setLoop=function(e){this.loop=e},AnimationItem.prototype.setVolume=function(e,t){t&&this.name!==t||this.audioController.setVolume(e)},AnimationItem.prototype.getVolume=function(){return this.audioController.getVolume()},AnimationItem.prototype.mute=function(e){e&&this.name!==e||this.audioController.mute()},AnimationItem.prototype.unmute=function(e){e&&this.name!==e||this.audioController.unmute()},AnimationItem.prototype.updaFrameModifier=function(){this.frameModifier=this.frameMult*this.playSpeed*this.playDirection,this.audioController.setRate(this.playSpeed*this.playDirection)},AnimationItem.prototype.getPath=function(){return this.path},AnimationItem.prototype.getAssetsPath=function(e){var t="";if(e.e)t=e.p;else if(this.assetsPath){var n=e.p;-1!==n.indexOf("images/")&&(n=n.split("/")[1]),t=this.assetsPath+n}else t=this.path,t+=e.u?e.u:"",t+=e.p;return t},AnimationItem.prototype.getAssetData=function(e){for(var t=0,n=this.assets.length;t<n;){if(e===this.assets[t].id)return this.assets[t];t+=1}return null},AnimationItem.prototype.hide=function(){this.renderer.hide()},AnimationItem.prototype.show=function(){this.renderer.show()},AnimationItem.prototype.getDuration=function(e){return e?this.totalFrames:this.totalFrames/this.frameRate},AnimationItem.prototype.updateDocumentData=function(e,t,n){try{this.renderer.getElementByPath(e).updateDocumentData(t,n)}catch(e){}},AnimationItem.prototype.trigger=function(e){if(this._cbs&&this._cbs[e])switch(e){case"enterFrame":this.triggerEvent(e,new BMEnterFrameEvent(e,this.currentFrame,this.totalFrames,this.frameModifier));break;case"drawnFrame":this.drawnFrameEvent.currentTime=this.currentFrame,this.drawnFrameEvent.totalTime=this.totalFrames,this.drawnFrameEvent.direction=this.frameModifier,this.triggerEvent(e,this.drawnFrameEvent);break;case"loopComplete":this.triggerEvent(e,new BMCompleteLoopEvent(e,this.loop,this.playCount,this.frameMult));break;case"complete":this.triggerEvent(e,new BMCompleteEvent(e,this.frameMult));break;case"segmentStart":this.triggerEvent(e,new BMSegmentStartEvent(e,this.firstFrame,this.totalFrames));break;case"destroy":this.triggerEvent(e,new BMDestroyEvent(e,this));break;default:this.triggerEvent(e)}"enterFrame"===e&&this.onEnterFrame&&this.onEnterFrame.call(this,new BMEnterFrameEvent(e,this.currentFrame,this.totalFrames,this.frameMult)),"loopComplete"===e&&this.onLoopComplete&&this.onLoopComplete.call(this,new BMCompleteLoopEvent(e,this.loop,this.playCount,this.frameMult)),"complete"===e&&this.onComplete&&this.onComplete.call(this,new BMCompleteEvent(e,this.frameMult)),"segmentStart"===e&&this.onSegmentStart&&this.onSegmentStart.call(this,new BMSegmentStartEvent(e,this.firstFrame,this.totalFrames)),"destroy"===e&&this.onDestroy&&this.onDestroy.call(this,new BMDestroyEvent(e,this))},AnimationItem.prototype.triggerRenderFrameError=function(e){var t=new BMRenderFrameErrorEvent(e,this.currentFrame);this.triggerEvent("error",t),this.onError&&this.onError.call(this,t)},AnimationItem.prototype.triggerConfigError=function(e){var t=new BMConfigErrorEvent(e,this.currentFrame);this.triggerEvent("error",t),this.onError&&this.onError.call(this,t)};var animationManager=function(){var e={},t=[],n=0,r=0,a=0,i=!0,s=!1;function o(e){for(var n=0,a=e.target;n<r;)t[n].animation===a&&(t.splice(n,1),n-=1,r-=1,a.isPaused||c()),n+=1}function l(e,n){if(!e)return null;for(var a=0;a<r;){if(t[a].elem===e&&null!==t[a].elem)return t[a].animation;a+=1}var i=new AnimationItem;return h(i,e),i.setData(e,n),i}function u(){a+=1,d()}function c(){a-=1}function h(e,n){e.addEventListener("destroy",o),e.addEventListener("_active",u),e.addEventListener("_idle",c),t.push({elem:n,animation:e}),r+=1}function p(e){var o,l=e-n;for(o=0;o<r;o+=1)t[o].animation.advanceTime(l);n=e,a&&!s?window.requestAnimationFrame(p):i=!0}function f(e){n=e,window.requestAnimationFrame(p)}function d(){!s&&a&&i&&(window.requestAnimationFrame(f),i=!1)}return e.registerAnimation=l,e.loadAnimation=function(e){var t=new AnimationItem;return h(t,null),t.setParams(e),t},e.setSpeed=function(e,n){var a;for(a=0;a<r;a+=1)t[a].animation.setSpeed(e,n)},e.setDirection=function(e,n){var a;for(a=0;a<r;a+=1)t[a].animation.setDirection(e,n)},e.play=function(e){var n;for(n=0;n<r;n+=1)t[n].animation.play(e)},e.pause=function(e){var n;for(n=0;n<r;n+=1)t[n].animation.pause(e)},e.stop=function(e){var n;for(n=0;n<r;n+=1)t[n].animation.stop(e)},e.togglePause=function(e){var n;for(n=0;n<r;n+=1)t[n].animation.togglePause(e)},e.searchAnimations=function(e,t,n){var r,a=[].concat([].slice.call(document.getElementsByClassName("lottie")),[].slice.call(document.getElementsByClassName("bodymovin"))),i=a.length;for(r=0;r<i;r+=1)n&&a[r].setAttribute("data-bm-type",n),l(a[r],e);if(t&&0===i){n||(n="svg");var s=document.getElementsByTagName("body")[0];s.innerText="";var o=createTag("div");o.style.width="100%",o.style.height="100%",o.setAttribute("data-bm-type",n),s.appendChild(o),l(o,e)}},e.resize=function(){var e;for(e=0;e<r;e+=1)t[e].animation.resize()},e.goToAndStop=function(e,n,a){var i;for(i=0;i<r;i+=1)t[i].animation.goToAndStop(e,n,a)},e.destroy=function(e){var n;for(n=r-1;n>=0;n-=1)t[n].animation.destroy(e)},e.freeze=function(){s=!0},e.unfreeze=function(){s=!1,d()},e.setVolume=function(e,n){var a;for(a=0;a<r;a+=1)t[a].animation.setVolume(e,n)},e.mute=function(e){var n;for(n=0;n<r;n+=1)t[n].animation.mute(e)},e.unmute=function(e){var n;for(n=0;n<r;n+=1)t[n].animation.unmute(e)},e.getRegisteredAnimations=function(){var e,n=t.length,r=[];for(e=0;e<n;e+=1)r.push(t[e].animation);return r},e}(),BezierFactory=function(){var e={getBezierEasing:function(e,n,r,a,i){var s=i||("bez_"+e+"_"+n+"_"+r+"_"+a).replace(/\./g,"p");if(t[s])return t[s];var o=new f([e,n,r,a]);return t[s]=o,o}},t={},n=4,r=1e-7,a=10,i=11,s=1/(i-1),o="function"==typeof Float32Array;function l(e,t){return 1-3*t+3*e}function u(e,t){return 3*t-6*e}function c(e){return 3*e}function h(e,t,n){return((l(t,n)*e+u(t,n))*e+c(t))*e}function p(e,t,n){return 3*l(t,n)*e*e+2*u(t,n)*e+c(t)}function f(e){this._p=e,this._mSampleValues=o?new Float32Array(i):new Array(i),this._precomputed=!1,this.get=this.get.bind(this)}return f.prototype={get:function(e){var t=this._p[0],n=this._p[1],r=this._p[2],a=this._p[3];return this._precomputed||this._precompute(),t===n&&r===a?e:0===e?0:1===e?1:h(this._getTForX(e),n,a)},_precompute:function(){var e=this._p[0],t=this._p[1],n=this._p[2],r=this._p[3];this._precomputed=!0,e===t&&n===r||this._calcSampleValues()},_calcSampleValues:function(){for(var e=this._p[0],t=this._p[2],n=0;n<i;++n)this._mSampleValues[n]=h(n*s,e,t)},_getTForX:function(e){for(var t=this._p[0],o=this._p[2],l=this._mSampleValues,u=0,c=1,f=i-1;c!==f&&l[c]<=e;++c)u+=s;var d=u+(e-l[--c])/(l[c+1]-l[c])*s,m=p(d,t,o);return m>=.001?function(e,t,r,a){for(var i=0;i<n;++i){var s=p(t,r,a);if(0===s)return t;t-=(h(t,r,a)-e)/s}return t}(e,d,t,o):0===m?d:function(e,t,n,i,s){var o,l,u=0;do{(o=h(l=t+(n-t)/2,i,s)-e)>0?n=l:t=l}while(Math.abs(o)>r&&++u<a);return l}(e,u,u+s,t,o)}},e}(),pooling={double:function(e){return e.concat(createSizedArray(e.length))}},poolFactory=function(e,t,n){var r=0,a=e,i=createSizedArray(a);return{newElement:function(){return r?i[r-=1]:t()},release:function(e){r===a&&(i=pooling.double(i),a*=2),n&&n(e),i[r]=e,r+=1}}},bezierLengthPool=poolFactory(8,(function(){return{addedLength:0,percents:createTypedArray("float32",getDefaultCurveSegments()),lengths:createTypedArray("float32",getDefaultCurveSegments())}})),segmentsLengthPool=poolFactory(8,(function(){return{lengths:[],totalLength:0}}),(function(e){var t,n=e.lengths.length;for(t=0;t<n;t+=1)bezierLengthPool.release(e.lengths[t]);e.lengths.length=0}));function bezFunction(){var e=Math;function t(e,t,n,r,a,i){var s=e*r+t*a+n*i-a*r-i*e-n*t;return s>-.001&&s<.001}var n=function(e,t,n,r){var a,i,s,o,l,u,c=getDefaultCurveSegments(),h=0,p=[],f=[],d=bezierLengthPool.newElement();for(s=n.length,a=0;a<c;a+=1){for(l=a/(c-1),u=0,i=0;i<s;i+=1)o=bmPow(1-l,3)*e[i]+3*bmPow(1-l,2)*l*n[i]+3*(1-l)*bmPow(l,2)*r[i]+bmPow(l,3)*t[i],p[i]=o,null!==f[i]&&(u+=bmPow(p[i]-f[i],2)),f[i]=p[i];u&&(h+=u=bmSqrt(u)),d.percents[a]=l,d.lengths[a]=h}return d.addedLength=h,d};function r(e){this.segmentLength=0,this.points=new Array(e)}function a(e,t){this.partialLength=e,this.point=t}var i,s=(i={},function(e,n,s,o){var l=(e[0]+"_"+e[1]+"_"+n[0]+"_"+n[1]+"_"+s[0]+"_"+s[1]+"_"+o[0]+"_"+o[1]).replace(/\./g,"p");if(!i[l]){var u,c,h,p,f,d,m,g=getDefaultCurveSegments(),y=0,v=null;2===e.length&&(e[0]!==n[0]||e[1]!==n[1])&&t(e[0],e[1],n[0],n[1],e[0]+s[0],e[1]+s[1])&&t(e[0],e[1],n[0],n[1],n[0]+o[0],n[1]+o[1])&&(g=2);var b=new r(g);for(h=s.length,u=0;u<g;u+=1){for(m=createSizedArray(h),f=u/(g-1),d=0,c=0;c<h;c+=1)p=bmPow(1-f,3)*e[c]+3*bmPow(1-f,2)*f*(e[c]+s[c])+3*(1-f)*bmPow(f,2)*(n[c]+o[c])+bmPow(f,3)*n[c],m[c]=p,null!==v&&(d+=bmPow(m[c]-v[c],2));y+=d=bmSqrt(d),b.points[u]=new a(d,m),v=m}b.segmentLength=y,i[l]=b}return i[l]});function o(e,t){var n=t.percents,r=t.lengths,a=n.length,i=bmFloor((a-1)*e),s=e*t.addedLength,o=0;if(i===a-1||0===i||s===r[i])return n[i];for(var l=r[i]>s?-1:1,u=!0;u;)if(r[i]<=s&&r[i+1]>s?(o=(s-r[i])/(r[i+1]-r[i]),u=!1):i+=l,i<0||i>=a-1){if(i===a-1)return n[i];u=!1}return n[i]+(n[i+1]-n[i])*o}var l=createTypedArray("float32",8);return{getSegmentsLength:function(e){var t,r=segmentsLengthPool.newElement(),a=e.c,i=e.v,s=e.o,o=e.i,l=e._length,u=r.lengths,c=0;for(t=0;t<l-1;t+=1)u[t]=n(i[t],i[t+1],s[t],o[t+1]),c+=u[t].addedLength;return a&&l&&(u[t]=n(i[t],i[0],s[t],o[0]),c+=u[t].addedLength),r.totalLength=c,r},getNewSegment:function(t,n,r,a,i,s,u){i<0?i=0:i>1&&(i=1);var c,h=o(i,u),p=o(s=s>1?1:s,u),f=t.length,d=1-h,m=1-p,g=d*d*d,y=h*d*d*3,v=h*h*d*3,b=h*h*h,k=d*d*m,x=h*d*m+d*h*m+d*d*p,S=h*h*m+d*h*p+h*d*p,w=h*h*p,E=d*m*m,P=h*m*m+d*p*m+d*m*p,_=h*p*m+d*p*p+h*m*p,C=h*p*p,A=m*m*m,T=p*m*m+m*p*m+m*m*p,M=p*p*m+m*p*p+p*m*p,D=p*p*p;for(c=0;c<f;c+=1)l[4*c]=e.round(1e3*(g*t[c]+y*r[c]+v*a[c]+b*n[c]))/1e3,l[4*c+1]=e.round(1e3*(k*t[c]+x*r[c]+S*a[c]+w*n[c]))/1e3,l[4*c+2]=e.round(1e3*(E*t[c]+P*r[c]+_*a[c]+C*n[c]))/1e3,l[4*c+3]=e.round(1e3*(A*t[c]+T*r[c]+M*a[c]+D*n[c]))/1e3;return l},getPointInSegment:function(t,n,r,a,i,s){var l=o(i,s),u=1-l;return[e.round(1e3*(u*u*u*t[0]+(l*u*u+u*l*u+u*u*l)*r[0]+(l*l*u+u*l*l+l*u*l)*a[0]+l*l*l*n[0]))/1e3,e.round(1e3*(u*u*u*t[1]+(l*u*u+u*l*u+u*u*l)*r[1]+(l*l*u+u*l*l+l*u*l)*a[1]+l*l*l*n[1]))/1e3]},buildBezierData:s,pointOnLine2D:t,pointOnLine3D:function(n,r,a,i,s,o,l,u,c){if(0===a&&0===o&&0===c)return t(n,r,i,s,l,u);var h,p=e.sqrt(e.pow(i-n,2)+e.pow(s-r,2)+e.pow(o-a,2)),f=e.sqrt(e.pow(l-n,2)+e.pow(u-r,2)+e.pow(c-a,2)),d=e.sqrt(e.pow(l-i,2)+e.pow(u-s,2)+e.pow(c-o,2));return(h=p>f?p>d?p-f-d:d-f-p:d>f?d-f-p:f-p-d)>-1e-4&&h<1e-4}}}var bez=bezFunction(),initFrame=initialDefaultFrame,mathAbs=Math.abs;function interpolateValue(e,t){var n,r=this.offsetTime;"multidimensional"===this.propType&&(n=createTypedArray("float32",this.pv.length));for(var a,i,s,o,l,u,c,h,p,f=t.lastIndex,d=f,m=this.keyframes.length-1,g=!0;g;){if(a=this.keyframes[d],i=this.keyframes[d+1],d===m-1&&e>=i.t-r){a.h&&(a=i),f=0;break}if(i.t-r>e){f=d;break}d<m-1?d+=1:(f=0,g=!1)}s=this.keyframesMetadata[d]||{};var y,v=i.t-r,b=a.t-r;if(a.to){s.bezierData||(s.bezierData=bez.buildBezierData(a.s,i.s||a.e,a.to,a.ti));var k=s.bezierData;if(e>=v||e<b){var x=e>=v?k.points.length-1:0;for(l=k.points[x].point.length,o=0;o<l;o+=1)n[o]=k.points[x].point[o]}else{s.__fnct?p=s.__fnct:(p=BezierFactory.getBezierEasing(a.o.x,a.o.y,a.i.x,a.i.y,a.n).get,s.__fnct=p),u=p((e-b)/(v-b));var S,w=k.segmentLength*u,E=t.lastFrame<e&&t._lastKeyframeIndex===d?t._lastAddedLength:0;for(h=t.lastFrame<e&&t._lastKeyframeIndex===d?t._lastPoint:0,g=!0,c=k.points.length;g;){if(E+=k.points[h].partialLength,0===w||0===u||h===k.points.length-1){for(l=k.points[h].point.length,o=0;o<l;o+=1)n[o]=k.points[h].point[o];break}if(w>=E&&w<E+k.points[h+1].partialLength){for(S=(w-E)/k.points[h+1].partialLength,l=k.points[h].point.length,o=0;o<l;o+=1)n[o]=k.points[h].point[o]+(k.points[h+1].point[o]-k.points[h].point[o])*S;break}h<c-1?h+=1:g=!1}t._lastPoint=h,t._lastAddedLength=E-k.points[h].partialLength,t._lastKeyframeIndex=d}}else{var P,_,C,A,T;if(m=a.s.length,y=i.s||a.e,this.sh&&1!==a.h)e>=v?(n[0]=y[0],n[1]=y[1],n[2]=y[2]):e<=b?(n[0]=a.s[0],n[1]=a.s[1],n[2]=a.s[2]):quaternionToEuler(n,slerp(createQuaternion(a.s),createQuaternion(y),(e-b)/(v-b)));else for(d=0;d<m;d+=1)1!==a.h&&(e>=v?u=1:e<b?u=0:(a.o.x.constructor===Array?(s.__fnct||(s.__fnct=[]),s.__fnct[d]?p=s.__fnct[d]:(P=void 0===a.o.x[d]?a.o.x[0]:a.o.x[d],_=void 0===a.o.y[d]?a.o.y[0]:a.o.y[d],C=void 0===a.i.x[d]?a.i.x[0]:a.i.x[d],A=void 0===a.i.y[d]?a.i.y[0]:a.i.y[d],p=BezierFactory.getBezierEasing(P,_,C,A).get,s.__fnct[d]=p)):s.__fnct?p=s.__fnct:(P=a.o.x,_=a.o.y,C=a.i.x,A=a.i.y,p=BezierFactory.getBezierEasing(P,_,C,A).get,a.keyframeMetadata=p),u=p((e-b)/(v-b)))),y=i.s||a.e,T=1===a.h?a.s[d]:a.s[d]+(y[d]-a.s[d])*u,"multidimensional"===this.propType?n[d]=T:n=T}return t.lastIndex=f,n}function slerp(e,t,n){var r,a,i,s,o,l=[],u=e[0],c=e[1],h=e[2],p=e[3],f=t[0],d=t[1],m=t[2],g=t[3];return(a=u*f+c*d+h*m+p*g)<0&&(a=-a,f=-f,d=-d,m=-m,g=-g),1-a>1e-6?(r=Math.acos(a),i=Math.sin(r),s=Math.sin((1-n)*r)/i,o=Math.sin(n*r)/i):(s=1-n,o=n),l[0]=s*u+o*f,l[1]=s*c+o*d,l[2]=s*h+o*m,l[3]=s*p+o*g,l}function quaternionToEuler(e,t){var n=t[0],r=t[1],a=t[2],i=t[3],s=Math.atan2(2*r*i-2*n*a,1-2*r*r-2*a*a),o=Math.asin(2*n*r+2*a*i),l=Math.atan2(2*n*i-2*r*a,1-2*n*n-2*a*a);e[0]=s/degToRads,e[1]=o/degToRads,e[2]=l/degToRads}function createQuaternion(e){var t=e[0]*degToRads,n=e[1]*degToRads,r=e[2]*degToRads,a=Math.cos(t/2),i=Math.cos(n/2),s=Math.cos(r/2),o=Math.sin(t/2),l=Math.sin(n/2),u=Math.sin(r/2);return[o*l*s+a*i*u,o*i*s+a*l*u,a*l*s-o*i*u,a*i*s-o*l*u]}function getValueAtCurrentTime(){var e=this.comp.renderedFrame-this.offsetTime,t=this.keyframes[0].t-this.offsetTime,n=this.keyframes[this.keyframes.length-1].t-this.offsetTime;if(!(e===this._caching.lastFrame||this._caching.lastFrame!==initFrame&&(this._caching.lastFrame>=n&&e>=n||this._caching.lastFrame<t&&e<t))){this._caching.lastFrame>=e&&(this._caching._lastKeyframeIndex=-1,this._caching.lastIndex=0);var r=this.interpolateValue(e,this._caching);this.pv=r}return this._caching.lastFrame=e,this.pv}function setVValue(e){var t;if("unidimensional"===this.propType)t=e*this.mult,mathAbs(this.v-t)>1e-5&&(this.v=t,this._mdf=!0);else for(var n=0,r=this.v.length;n<r;)t=e[n]*this.mult,mathAbs(this.v[n]-t)>1e-5&&(this.v[n]=t,this._mdf=!0),n+=1}function processEffectsSequence(){if(this.elem.globalData.frameId!==this.frameId&&this.effectsSequence.length)if(this.lock)this.setVValue(this.pv);else{var e;this.lock=!0,this._mdf=this._isFirstFrame;var t=this.effectsSequence.length,n=this.kf?this.pv:this.data.k;for(e=0;e<t;e+=1)n=this.effectsSequence[e](n);this.setVValue(n),this._isFirstFrame=!1,this.lock=!1,this.frameId=this.elem.globalData.frameId}}function addEffect(e){this.effectsSequence.push(e),this.container.addDynamicProperty(this)}function ValueProperty(e,t,n,r){this.propType="unidimensional",this.mult=n||1,this.data=t,this.v=n?t.k*n:t.k,this.pv=t.k,this._mdf=!1,this.elem=e,this.container=r,this.comp=e.comp,this.k=!1,this.kf=!1,this.vel=0,this.effectsSequence=[],this._isFirstFrame=!0,this.getValue=processEffectsSequence,this.setVValue=setVValue,this.addEffect=addEffect}function MultiDimensionalProperty(e,t,n,r){var a;this.propType="multidimensional",this.mult=n||1,this.data=t,this._mdf=!1,this.elem=e,this.container=r,this.comp=e.comp,this.k=!1,this.kf=!1,this.frameId=-1;var i=t.k.length;for(this.v=createTypedArray("float32",i),this.pv=createTypedArray("float32",i),this.vel=createTypedArray("float32",i),a=0;a<i;a+=1)this.v[a]=t.k[a]*this.mult,this.pv[a]=t.k[a];this._isFirstFrame=!0,this.effectsSequence=[],this.getValue=processEffectsSequence,this.setVValue=setVValue,this.addEffect=addEffect}function KeyframedValueProperty(e,t,n,r){this.propType="unidimensional",this.keyframes=t.k,this.keyframesMetadata=[],this.offsetTime=e.data.st,this.frameId=-1,this._caching={lastFrame:initFrame,lastIndex:0,value:0,_lastKeyframeIndex:-1},this.k=!0,this.kf=!0,this.data=t,this.mult=n||1,this.elem=e,this.container=r,this.comp=e.comp,this.v=initFrame,this.pv=initFrame,this._isFirstFrame=!0,this.getValue=processEffectsSequence,this.setVValue=setVValue,this.interpolateValue=interpolateValue,this.effectsSequence=[getValueAtCurrentTime.bind(this)],this.addEffect=addEffect}function KeyframedMultidimensionalProperty(e,t,n,r){var a;this.propType="multidimensional";var i,s,o,l,u=t.k.length;for(a=0;a<u-1;a+=1)t.k[a].to&&t.k[a].s&&t.k[a+1]&&t.k[a+1].s&&(i=t.k[a].s,s=t.k[a+1].s,o=t.k[a].to,l=t.k[a].ti,(2===i.length&&(i[0]!==s[0]||i[1]!==s[1])&&bez.pointOnLine2D(i[0],i[1],s[0],s[1],i[0]+o[0],i[1]+o[1])&&bez.pointOnLine2D(i[0],i[1],s[0],s[1],s[0]+l[0],s[1]+l[1])||3===i.length&&(i[0]!==s[0]||i[1]!==s[1]||i[2]!==s[2])&&bez.pointOnLine3D(i[0],i[1],i[2],s[0],s[1],s[2],i[0]+o[0],i[1]+o[1],i[2]+o[2])&&bez.pointOnLine3D(i[0],i[1],i[2],s[0],s[1],s[2],s[0]+l[0],s[1]+l[1],s[2]+l[2]))&&(t.k[a].to=null,t.k[a].ti=null),i[0]===s[0]&&i[1]===s[1]&&0===o[0]&&0===o[1]&&0===l[0]&&0===l[1]&&(2===i.length||i[2]===s[2]&&0===o[2]&&0===l[2])&&(t.k[a].to=null,t.k[a].ti=null));this.effectsSequence=[getValueAtCurrentTime.bind(this)],this.data=t,this.keyframes=t.k,this.keyframesMetadata=[],this.offsetTime=e.data.st,this.k=!0,this.kf=!0,this._isFirstFrame=!0,this.mult=n||1,this.elem=e,this.container=r,this.comp=e.comp,this.getValue=processEffectsSequence,this.setVValue=setVValue,this.interpolateValue=interpolateValue,this.frameId=-1;var c=t.k[0].s.length;for(this.v=createTypedArray("float32",c),this.pv=createTypedArray("float32",c),a=0;a<c;a+=1)this.v[a]=initFrame,this.pv[a]=initFrame;this._caching={lastFrame:initFrame,lastIndex:0,value:createTypedArray("float32",c)},this.addEffect=addEffect}var PropertyFactory={getProp:function(e,t,n,r,a){var i;if(t.sid&&(t=e.globalData.slotManager.getProp(t)),t.k.length)if("number"==typeof t.k[0])i=new MultiDimensionalProperty(e,t,r,a);else switch(n){case 0:i=new KeyframedValueProperty(e,t,r,a);break;case 1:i=new KeyframedMultidimensionalProperty(e,t,r,a)}else i=new ValueProperty(e,t,r,a);return i.effectsSequence.length&&a.addDynamicProperty(i),i}};function DynamicPropertyContainer(){}DynamicPropertyContainer.prototype={addDynamicProperty:function(e){-1===this.dynamicProperties.indexOf(e)&&(this.dynamicProperties.push(e),this.container.addDynamicProperty(this),this._isAnimated=!0)},iterateDynamicProperties:function(){var e;this._mdf=!1;var t=this.dynamicProperties.length;for(e=0;e<t;e+=1)this.dynamicProperties[e].getValue(),this.dynamicProperties[e]._mdf&&(this._mdf=!0)},initDynamicPropertyContainer:function(e){this.container=e,this.dynamicProperties=[],this._mdf=!1,this._isAnimated=!1}};var pointPool=poolFactory(8,(function(){return createTypedArray("float32",2)}));function ShapePath(){this.c=!1,this._length=0,this._maxLength=8,this.v=createSizedArray(this._maxLength),this.o=createSizedArray(this._maxLength),this.i=createSizedArray(this._maxLength)}ShapePath.prototype.setPathData=function(e,t){this.c=e,this.setLength(t);for(var n=0;n<t;)this.v[n]=pointPool.newElement(),this.o[n]=pointPool.newElement(),this.i[n]=pointPool.newElement(),n+=1},ShapePath.prototype.setLength=function(e){for(;this._maxLength<e;)this.doubleArrayLength();this._length=e},ShapePath.prototype.doubleArrayLength=function(){this.v=this.v.concat(createSizedArray(this._maxLength)),this.i=this.i.concat(createSizedArray(this._maxLength)),this.o=this.o.concat(createSizedArray(this._maxLength)),this._maxLength*=2},ShapePath.prototype.setXYAt=function(e,t,n,r,a){var i;switch(this._length=Math.max(this._length,r+1),this._length>=this._maxLength&&this.doubleArrayLength(),n){case"v":i=this.v;break;case"i":i=this.i;break;case"o":i=this.o;break;default:i=[]}(!i[r]||i[r]&&!a)&&(i[r]=pointPool.newElement()),i[r][0]=e,i[r][1]=t},ShapePath.prototype.setTripleAt=function(e,t,n,r,a,i,s,o){this.setXYAt(e,t,"v",s,o),this.setXYAt(n,r,"o",s,o),this.setXYAt(a,i,"i",s,o)},ShapePath.prototype.reverse=function(){var e=new ShapePath;e.setPathData(this.c,this._length);var t=this.v,n=this.o,r=this.i,a=0;this.c&&(e.setTripleAt(t[0][0],t[0][1],r[0][0],r[0][1],n[0][0],n[0][1],0,!1),a=1);var i,s=this._length-1,o=this._length;for(i=a;i<o;i+=1)e.setTripleAt(t[s][0],t[s][1],r[s][0],r[s][1],n[s][0],n[s][1],i,!1),s-=1;return e},ShapePath.prototype.length=function(){return this._length};var shapePool=(factory=poolFactory(4,(function(){return new ShapePath}),(function(e){var t,n=e._length;for(t=0;t<n;t+=1)pointPool.release(e.v[t]),pointPool.release(e.i[t]),pointPool.release(e.o[t]),e.v[t]=null,e.i[t]=null,e.o[t]=null;e._length=0,e.c=!1})),factory.clone=function(e){var t,n=factory.newElement(),r=void 0===e._length?e.v.length:e._length;for(n.setLength(r),n.c=e.c,t=0;t<r;t+=1)n.setTripleAt(e.v[t][0],e.v[t][1],e.o[t][0],e.o[t][1],e.i[t][0],e.i[t][1],t);return n},factory),factory;function ShapeCollection(){this._length=0,this._maxLength=4,this.shapes=createSizedArray(this._maxLength)}ShapeCollection.prototype.addShape=function(e){this._length===this._maxLength&&(this.shapes=this.shapes.concat(createSizedArray(this._maxLength)),this._maxLength*=2),this.shapes[this._length]=e,this._length+=1},ShapeCollection.prototype.releaseShapes=function(){var e;for(e=0;e<this._length;e+=1)shapePool.release(this.shapes[e]);this._length=0};var shapeCollectionPool=(ob={newShapeCollection:function(){return _length?pool[_length-=1]:new ShapeCollection},release:function(e){var t,n=e._length;for(t=0;t<n;t+=1)shapePool.release(e.shapes[t]);e._length=0,_length===_maxLength&&(pool=pooling.double(pool),_maxLength*=2),pool[_length]=e,_length+=1}},_length=0,_maxLength=4,pool=createSizedArray(_maxLength),ob),ob,_length,_maxLength,pool,ShapePropertyFactory=function(){var e=-999999;function t(e,t,n){var r,a,i,s,o,l,u,c,h,p=n.lastIndex,f=this.keyframes;if(e<f[0].t-this.offsetTime)r=f[0].s[0],i=!0,p=0;else if(e>=f[f.length-1].t-this.offsetTime)r=f[f.length-1].s?f[f.length-1].s[0]:f[f.length-2].e[0],i=!0;else{for(var d,m,g,y=p,v=f.length-1,b=!0;b&&(d=f[y],!((m=f[y+1]).t-this.offsetTime>e));)y<v-1?y+=1:b=!1;if(g=this.keyframesMetadata[y]||{},p=y,!(i=1===d.h)){if(e>=m.t-this.offsetTime)c=1;else if(e<d.t-this.offsetTime)c=0;else{var k;g.__fnct?k=g.__fnct:(k=BezierFactory.getBezierEasing(d.o.x,d.o.y,d.i.x,d.i.y).get,g.__fnct=k),c=k((e-(d.t-this.offsetTime))/(m.t-this.offsetTime-(d.t-this.offsetTime)))}a=m.s?m.s[0]:d.e[0]}r=d.s[0]}for(l=t._length,u=r.i[0].length,n.lastIndex=p,s=0;s<l;s+=1)for(o=0;o<u;o+=1)h=i?r.i[s][o]:r.i[s][o]+(a.i[s][o]-r.i[s][o])*c,t.i[s][o]=h,h=i?r.o[s][o]:r.o[s][o]+(a.o[s][o]-r.o[s][o])*c,t.o[s][o]=h,h=i?r.v[s][o]:r.v[s][o]+(a.v[s][o]-r.v[s][o])*c,t.v[s][o]=h}function n(){var t=this.comp.renderedFrame-this.offsetTime,n=this.keyframes[0].t-this.offsetTime,r=this.keyframes[this.keyframes.length-1].t-this.offsetTime,a=this._caching.lastFrame;return a!==e&&(a<n&&t<n||a>r&&t>r)||(this._caching.lastIndex=a<t?this._caching.lastIndex:0,this.interpolateShape(t,this.pv,this._caching)),this._caching.lastFrame=t,this.pv}function r(){this.paths=this.localShapeCollection}function a(e){(function(e,t){if(e._length!==t._length||e.c!==t.c)return!1;var n,r=e._length;for(n=0;n<r;n+=1)if(e.v[n][0]!==t.v[n][0]||e.v[n][1]!==t.v[n][1]||e.o[n][0]!==t.o[n][0]||e.o[n][1]!==t.o[n][1]||e.i[n][0]!==t.i[n][0]||e.i[n][1]!==t.i[n][1])return!1;return!0})(this.v,e)||(this.v=shapePool.clone(e),this.localShapeCollection.releaseShapes(),this.localShapeCollection.addShape(this.v),this._mdf=!0,this.paths=this.localShapeCollection)}function i(){if(this.elem.globalData.frameId!==this.frameId)if(this.effectsSequence.length)if(this.lock)this.setVValue(this.pv);else{var e,t;this.lock=!0,this._mdf=!1,e=this.kf?this.pv:this.data.ks?this.data.ks.k:this.data.pt.k;var n=this.effectsSequence.length;for(t=0;t<n;t+=1)e=this.effectsSequence[t](e);this.setVValue(e),this.lock=!1,this.frameId=this.elem.globalData.frameId}else this._mdf=!1}function s(e,t,n){this.propType="shape",this.comp=e.comp,this.container=e,this.elem=e,this.data=t,this.k=!1,this.kf=!1,this._mdf=!1;var a=3===n?t.pt.k:t.ks.k;this.v=shapePool.clone(a),this.pv=shapePool.clone(this.v),this.localShapeCollection=shapeCollectionPool.newShapeCollection(),this.paths=this.localShapeCollection,this.paths.addShape(this.v),this.reset=r,this.effectsSequence=[]}function o(e){this.effectsSequence.push(e),this.container.addDynamicProperty(this)}function l(t,a,i){this.propType="shape",this.comp=t.comp,this.elem=t,this.container=t,this.offsetTime=t.data.st,this.keyframes=3===i?a.pt.k:a.ks.k,this.keyframesMetadata=[],this.k=!0,this.kf=!0;var s=this.keyframes[0].s[0].i.length;this.v=shapePool.newElement(),this.v.setPathData(this.keyframes[0].s[0].c,s),this.pv=shapePool.clone(this.v),this.localShapeCollection=shapeCollectionPool.newShapeCollection(),this.paths=this.localShapeCollection,this.paths.addShape(this.v),this.lastFrame=e,this.reset=r,this._caching={lastFrame:e,lastIndex:0},this.effectsSequence=[n.bind(this)]}s.prototype.interpolateShape=t,s.prototype.getValue=i,s.prototype.setVValue=a,s.prototype.addEffect=o,l.prototype.getValue=i,l.prototype.interpolateShape=t,l.prototype.setVValue=a,l.prototype.addEffect=o;var u=function(){var e=roundCorner;function t(e,t){this.v=shapePool.newElement(),this.v.setPathData(!0,4),this.localShapeCollection=shapeCollectionPool.newShapeCollection(),this.paths=this.localShapeCollection,this.localShapeCollection.addShape(this.v),this.d=t.d,this.elem=e,this.comp=e.comp,this.frameId=-1,this.initDynamicPropertyContainer(e),this.p=PropertyFactory.getProp(e,t.p,1,0,this),this.s=PropertyFactory.getProp(e,t.s,1,0,this),this.dynamicProperties.length?this.k=!0:(this.k=!1,this.convertEllToPath())}return t.prototype={reset:r,getValue:function(){this.elem.globalData.frameId!==this.frameId&&(this.frameId=this.elem.globalData.frameId,this.iterateDynamicProperties(),this._mdf&&this.convertEllToPath())},convertEllToPath:function(){var t=this.p.v[0],n=this.p.v[1],r=this.s.v[0]/2,a=this.s.v[1]/2,i=3!==this.d,s=this.v;s.v[0][0]=t,s.v[0][1]=n-a,s.v[1][0]=i?t+r:t-r,s.v[1][1]=n,s.v[2][0]=t,s.v[2][1]=n+a,s.v[3][0]=i?t-r:t+r,s.v[3][1]=n,s.i[0][0]=i?t-r*e:t+r*e,s.i[0][1]=n-a,s.i[1][0]=i?t+r:t-r,s.i[1][1]=n-a*e,s.i[2][0]=i?t+r*e:t-r*e,s.i[2][1]=n+a,s.i[3][0]=i?t-r:t+r,s.i[3][1]=n+a*e,s.o[0][0]=i?t+r*e:t-r*e,s.o[0][1]=n-a,s.o[1][0]=i?t+r:t-r,s.o[1][1]=n+a*e,s.o[2][0]=i?t-r*e:t+r*e,s.o[2][1]=n+a,s.o[3][0]=i?t-r:t+r,s.o[3][1]=n-a*e}},extendPrototype([DynamicPropertyContainer],t),t}(),c=function(){function e(e,t){this.v=shapePool.newElement(),this.v.setPathData(!0,0),this.elem=e,this.comp=e.comp,this.data=t,this.frameId=-1,this.d=t.d,this.initDynamicPropertyContainer(e),1===t.sy?(this.ir=PropertyFactory.getProp(e,t.ir,0,0,this),this.is=PropertyFactory.getProp(e,t.is,0,.01,this),this.convertToPath=this.convertStarToPath):this.convertToPath=this.convertPolygonToPath,this.pt=PropertyFactory.getProp(e,t.pt,0,0,this),this.p=PropertyFactory.getProp(e,t.p,1,0,this),this.r=PropertyFactory.getProp(e,t.r,0,degToRads,this),this.or=PropertyFactory.getProp(e,t.or,0,0,this),this.os=PropertyFactory.getProp(e,t.os,0,.01,this),this.localShapeCollection=shapeCollectionPool.newShapeCollection(),this.localShapeCollection.addShape(this.v),this.paths=this.localShapeCollection,this.dynamicProperties.length?this.k=!0:(this.k=!1,this.convertToPath())}return e.prototype={reset:r,getValue:function(){this.elem.globalData.frameId!==this.frameId&&(this.frameId=this.elem.globalData.frameId,this.iterateDynamicProperties(),this._mdf&&this.convertToPath())},convertStarToPath:function(){var e,t,n,r,a=2*Math.floor(this.pt.v),i=2*Math.PI/a,s=!0,o=this.or.v,l=this.ir.v,u=this.os.v,c=this.is.v,h=2*Math.PI*o/(2*a),p=2*Math.PI*l/(2*a),f=-Math.PI/2;f+=this.r.v;var d=3===this.data.d?-1:1;for(this.v._length=0,e=0;e<a;e+=1){n=s?u:c,r=s?h:p;var m=(t=s?o:l)*Math.cos(f),g=t*Math.sin(f),y=0===m&&0===g?0:g/Math.sqrt(m*m+g*g),v=0===m&&0===g?0:-m/Math.sqrt(m*m+g*g);m+=+this.p.v[0],g+=+this.p.v[1],this.v.setTripleAt(m,g,m-y*r*n*d,g-v*r*n*d,m+y*r*n*d,g+v*r*n*d,e,!0),s=!s,f+=i*d}},convertPolygonToPath:function(){var e,t=Math.floor(this.pt.v),n=2*Math.PI/t,r=this.or.v,a=this.os.v,i=2*Math.PI*r/(4*t),s=.5*-Math.PI,o=3===this.data.d?-1:1;for(s+=this.r.v,this.v._length=0,e=0;e<t;e+=1){var l=r*Math.cos(s),u=r*Math.sin(s),c=0===l&&0===u?0:u/Math.sqrt(l*l+u*u),h=0===l&&0===u?0:-l/Math.sqrt(l*l+u*u);l+=+this.p.v[0],u+=+this.p.v[1],this.v.setTripleAt(l,u,l-c*i*a*o,u-h*i*a*o,l+c*i*a*o,u+h*i*a*o,e,!0),s+=n*o}this.paths.length=0,this.paths[0]=this.v}},extendPrototype([DynamicPropertyContainer],e),e}(),h=function(){function e(e,t){this.v=shapePool.newElement(),this.v.c=!0,this.localShapeCollection=shapeCollectionPool.newShapeCollection(),this.localShapeCollection.addShape(this.v),this.paths=this.localShapeCollection,this.elem=e,this.comp=e.comp,this.frameId=-1,this.d=t.d,this.initDynamicPropertyContainer(e),this.p=PropertyFactory.getProp(e,t.p,1,0,this),this.s=PropertyFactory.getProp(e,t.s,1,0,this),this.r=PropertyFactory.getProp(e,t.r,0,0,this),this.dynamicProperties.length?this.k=!0:(this.k=!1,this.convertRectToPath())}return e.prototype={convertRectToPath:function(){var e=this.p.v[0],t=this.p.v[1],n=this.s.v[0]/2,r=this.s.v[1]/2,a=bmMin(n,r,this.r.v),i=a*(1-roundCorner);this.v._length=0,2===this.d||1===this.d?(this.v.setTripleAt(e+n,t-r+a,e+n,t-r+a,e+n,t-r+i,0,!0),this.v.setTripleAt(e+n,t+r-a,e+n,t+r-i,e+n,t+r-a,1,!0),0!==a?(this.v.setTripleAt(e+n-a,t+r,e+n-a,t+r,e+n-i,t+r,2,!0),this.v.setTripleAt(e-n+a,t+r,e-n+i,t+r,e-n+a,t+r,3,!0),this.v.setTripleAt(e-n,t+r-a,e-n,t+r-a,e-n,t+r-i,4,!0),this.v.setTripleAt(e-n,t-r+a,e-n,t-r+i,e-n,t-r+a,5,!0),this.v.setTripleAt(e-n+a,t-r,e-n+a,t-r,e-n+i,t-r,6,!0),this.v.setTripleAt(e+n-a,t-r,e+n-i,t-r,e+n-a,t-r,7,!0)):(this.v.setTripleAt(e-n,t+r,e-n+i,t+r,e-n,t+r,2),this.v.setTripleAt(e-n,t-r,e-n,t-r+i,e-n,t-r,3))):(this.v.setTripleAt(e+n,t-r+a,e+n,t-r+i,e+n,t-r+a,0,!0),0!==a?(this.v.setTripleAt(e+n-a,t-r,e+n-a,t-r,e+n-i,t-r,1,!0),this.v.setTripleAt(e-n+a,t-r,e-n+i,t-r,e-n+a,t-r,2,!0),this.v.setTripleAt(e-n,t-r+a,e-n,t-r+a,e-n,t-r+i,3,!0),this.v.setTripleAt(e-n,t+r-a,e-n,t+r-i,e-n,t+r-a,4,!0),this.v.setTripleAt(e-n+a,t+r,e-n+a,t+r,e-n+i,t+r,5,!0),this.v.setTripleAt(e+n-a,t+r,e+n-i,t+r,e+n-a,t+r,6,!0),this.v.setTripleAt(e+n,t+r-a,e+n,t+r-a,e+n,t+r-i,7,!0)):(this.v.setTripleAt(e-n,t-r,e-n+i,t-r,e-n,t-r,1,!0),this.v.setTripleAt(e-n,t+r,e-n,t+r-i,e-n,t+r,2,!0),this.v.setTripleAt(e+n,t+r,e+n-i,t+r,e+n,t+r,3,!0)))},getValue:function(){this.elem.globalData.frameId!==this.frameId&&(this.frameId=this.elem.globalData.frameId,this.iterateDynamicProperties(),this._mdf&&this.convertRectToPath())},reset:r},extendPrototype([DynamicPropertyContainer],e),e}(),p={getShapeProp:function(e,t,n){var r;return 3===n||4===n?r=(3===n?t.pt:t.ks).k.length?new l(e,t,n):new s(e,t,n):5===n?r=new h(e,t):6===n?r=new u(e,t):7===n&&(r=new c(e,t)),r.k&&e.addDynamicProperty(r),r},getConstructorFunction:function(){return s},getKeyframedConstructorFunction:function(){return l}};return p}(),Matrix=function(){var e=Math.cos,t=Math.sin,n=Math.tan,r=Math.round;function a(){return this.props[0]=1,this.props[1]=0,this.props[2]=0,this.props[3]=0,this.props[4]=0,this.props[5]=1,this.props[6]=0,this.props[7]=0,this.props[8]=0,this.props[9]=0,this.props[10]=1,this.props[11]=0,this.props[12]=0,this.props[13]=0,this.props[14]=0,this.props[15]=1,this}function i(n){if(0===n)return this;var r=e(n),a=t(n);return this._t(r,-a,0,0,a,r,0,0,0,0,1,0,0,0,0,1)}function s(n){if(0===n)return this;var r=e(n),a=t(n);return this._t(1,0,0,0,0,r,-a,0,0,a,r,0,0,0,0,1)}function o(n){if(0===n)return this;var r=e(n),a=t(n);return this._t(r,0,a,0,0,1,0,0,-a,0,r,0,0,0,0,1)}function l(n){if(0===n)return this;var r=e(n),a=t(n);return this._t(r,-a,0,0,a,r,0,0,0,0,1,0,0,0,0,1)}function u(e,t){return this._t(1,t,e,1,0,0)}function c(e,t){return this.shear(n(e),n(t))}function h(r,a){var i=e(a),s=t(a);return this._t(i,s,0,0,-s,i,0,0,0,0,1,0,0,0,0,1)._t(1,0,0,0,n(r),1,0,0,0,0,1,0,0,0,0,1)._t(i,-s,0,0,s,i,0,0,0,0,1,0,0,0,0,1)}function p(e,t,n){return n||0===n||(n=1),1===e&&1===t&&1===n?this:this._t(e,0,0,0,0,t,0,0,0,0,n,0,0,0,0,1)}function f(e,t,n,r,a,i,s,o,l,u,c,h,p,f,d,m){return this.props[0]=e,this.props[1]=t,this.props[2]=n,this.props[3]=r,this.props[4]=a,this.props[5]=i,this.props[6]=s,this.props[7]=o,this.props[8]=l,this.props[9]=u,this.props[10]=c,this.props[11]=h,this.props[12]=p,this.props[13]=f,this.props[14]=d,this.props[15]=m,this}function d(e,t,n){return n=n||0,0!==e||0!==t||0!==n?this._t(1,0,0,0,0,1,0,0,0,0,1,0,e,t,n,1):this}function m(e,t,n,r,a,i,s,o,l,u,c,h,p,f,d,m){var g=this.props;if(1===e&&0===t&&0===n&&0===r&&0===a&&1===i&&0===s&&0===o&&0===l&&0===u&&1===c&&0===h)return g[12]=g[12]*e+g[15]*p,g[13]=g[13]*i+g[15]*f,g[14]=g[14]*c+g[15]*d,g[15]*=m,this._identityCalculated=!1,this;var y=g[0],v=g[1],b=g[2],k=g[3],x=g[4],S=g[5],w=g[6],E=g[7],P=g[8],_=g[9],C=g[10],A=g[11],T=g[12],M=g[13],D=g[14],I=g[15];return g[0]=y*e+v*a+b*l+k*p,g[1]=y*t+v*i+b*u+k*f,g[2]=y*n+v*s+b*c+k*d,g[3]=y*r+v*o+b*h+k*m,g[4]=x*e+S*a+w*l+E*p,g[5]=x*t+S*i+w*u+E*f,g[6]=x*n+S*s+w*c+E*d,g[7]=x*r+S*o+w*h+E*m,g[8]=P*e+_*a+C*l+A*p,g[9]=P*t+_*i+C*u+A*f,g[10]=P*n+_*s+C*c+A*d,g[11]=P*r+_*o+C*h+A*m,g[12]=T*e+M*a+D*l+I*p,g[13]=T*t+M*i+D*u+I*f,g[14]=T*n+M*s+D*c+I*d,g[15]=T*r+M*o+D*h+I*m,this._identityCalculated=!1,this}function g(e){var t=e.props;return this.transform(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])}function y(){return this._identityCalculated||(this._identity=!(1!==this.props[0]||0!==this.props[1]||0!==this.props[2]||0!==this.props[3]||0!==this.props[4]||1!==this.props[5]||0!==this.props[6]||0!==this.props[7]||0!==this.props[8]||0!==this.props[9]||1!==this.props[10]||0!==this.props[11]||0!==this.props[12]||0!==this.props[13]||0!==this.props[14]||1!==this.props[15]),this._identityCalculated=!0),this._identity}function v(e){for(var t=0;t<16;){if(e.props[t]!==this.props[t])return!1;t+=1}return!0}function b(e){var t;for(t=0;t<16;t+=1)e.props[t]=this.props[t];return e}function k(e){var t;for(t=0;t<16;t+=1)this.props[t]=e[t]}function x(e,t,n){return{x:e*this.props[0]+t*this.props[4]+n*this.props[8]+this.props[12],y:e*this.props[1]+t*this.props[5]+n*this.props[9]+this.props[13],z:e*this.props[2]+t*this.props[6]+n*this.props[10]+this.props[14]}}function S(e,t,n){return e*this.props[0]+t*this.props[4]+n*this.props[8]+this.props[12]}function w(e,t,n){return e*this.props[1]+t*this.props[5]+n*this.props[9]+this.props[13]}function E(e,t,n){return e*this.props[2]+t*this.props[6]+n*this.props[10]+this.props[14]}function P(){var e=this.props[0]*this.props[5]-this.props[1]*this.props[4],t=this.props[5]/e,n=-this.props[1]/e,r=-this.props[4]/e,a=this.props[0]/e,i=(this.props[4]*this.props[13]-this.props[5]*this.props[12])/e,s=-(this.props[0]*this.props[13]-this.props[1]*this.props[12])/e,o=new Matrix;return o.props[0]=t,o.props[1]=n,o.props[4]=r,o.props[5]=a,o.props[12]=i,o.props[13]=s,o}function _(e){return this.getInverseMatrix().applyToPointArray(e[0],e[1],e[2]||0)}function C(e){var t,n=e.length,r=[];for(t=0;t<n;t+=1)r[t]=_(e[t]);return r}function A(e,t,n){var r=createTypedArray("float32",6);if(this.isIdentity())r[0]=e[0],r[1]=e[1],r[2]=t[0],r[3]=t[1],r[4]=n[0],r[5]=n[1];else{var a=this.props[0],i=this.props[1],s=this.props[4],o=this.props[5],l=this.props[12],u=this.props[13];r[0]=e[0]*a+e[1]*s+l,r[1]=e[0]*i+e[1]*o+u,r[2]=t[0]*a+t[1]*s+l,r[3]=t[0]*i+t[1]*o+u,r[4]=n[0]*a+n[1]*s+l,r[5]=n[0]*i+n[1]*o+u}return r}function T(e,t,n){return this.isIdentity()?[e,t,n]:[e*this.props[0]+t*this.props[4]+n*this.props[8]+this.props[12],e*this.props[1]+t*this.props[5]+n*this.props[9]+this.props[13],e*this.props[2]+t*this.props[6]+n*this.props[10]+this.props[14]]}function M(e,t){if(this.isIdentity())return e+","+t;var n=this.props;return Math.round(100*(e*n[0]+t*n[4]+n[12]))/100+","+Math.round(100*(e*n[1]+t*n[5]+n[13]))/100}function D(){for(var e=0,t=this.props,n="matrix3d(";e<16;)n+=r(1e4*t[e])/1e4,n+=15===e?")":",",e+=1;return n}function I(e){return e<1e-6&&e>0||e>-1e-6&&e<0?r(1e4*e)/1e4:e}function F(){var e=this.props;return"matrix("+I(e[0])+","+I(e[1])+","+I(e[4])+","+I(e[5])+","+I(e[12])+","+I(e[13])+")"}return function(){this.reset=a,this.rotate=i,this.rotateX=s,this.rotateY=o,this.rotateZ=l,this.skew=c,this.skewFromAxis=h,this.shear=u,this.scale=p,this.setTransform=f,this.translate=d,this.transform=m,this.multiply=g,this.applyToPoint=x,this.applyToX=S,this.applyToY=w,this.applyToZ=E,this.applyToPointArray=T,this.applyToTriplePoints=A,this.applyToPointStringified=M,this.toCSS=D,this.to2dCSS=F,this.clone=b,this.cloneFromProps=k,this.equals=v,this.inversePoints=C,this.inversePoint=_,this.getInverseMatrix=P,this._t=this.transform,this.isIdentity=y,this._identity=!0,this._identityCalculated=!1,this.props=createTypedArray("float32",16),this.reset()}}();function _typeof$3(e){return _typeof$3="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$3(e)}var lottie={},standalone="__[STANDALONE]__",animationData="__[ANIMATIONDATA]__",renderer="";function setLocation(e){setLocationHref(e)}function searchAnimations(){!0===standalone?animationManager.searchAnimations(animationData,standalone,renderer):animationManager.searchAnimations()}function setSubframeRendering(e){setSubframeEnabled(e)}function setPrefix(e){setIdPrefix(e)}function loadAnimation(e){return!0===standalone&&(e.animationData=JSON.parse(animationData)),animationManager.loadAnimation(e)}function setQuality(e){if("string"==typeof e)switch(e){case"high":setDefaultCurveSegments(200);break;default:case"medium":setDefaultCurveSegments(50);break;case"low":setDefaultCurveSegments(10)}else!isNaN(e)&&e>1&&setDefaultCurveSegments(e);getDefaultCurveSegments()>=50?roundValues(!1):roundValues(!0)}function inBrowser(){return"undefined"!=typeof navigator}function installPlugin(e,t){"expressions"===e&&setExpressionsPlugin(t)}function getFactory(e){switch(e){case"propertyFactory":return PropertyFactory;case"shapePropertyFactory":return ShapePropertyFactory;case"matrix":return Matrix;default:return null}}function checkReady(){"complete"===document.readyState&&(clearInterval(readyStateCheckInterval),searchAnimations())}function getQueryVariable(e){for(var t=queryString.split("&"),n=0;n<t.length;n+=1){var r=t[n].split("=");if(decodeURIComponent(r[0])==e)return decodeURIComponent(r[1])}return null}lottie.play=animationManager.play,lottie.pause=animationManager.pause,lottie.setLocationHref=setLocation,lottie.togglePause=animationManager.togglePause,lottie.setSpeed=animationManager.setSpeed,lottie.setDirection=animationManager.setDirection,lottie.stop=animationManager.stop,lottie.searchAnimations=searchAnimations,lottie.registerAnimation=animationManager.registerAnimation,lottie.loadAnimation=loadAnimation,lottie.setSubframeRendering=setSubframeRendering,lottie.resize=animationManager.resize,lottie.goToAndStop=animationManager.goToAndStop,lottie.destroy=animationManager.destroy,lottie.setQuality=setQuality,lottie.inBrowser=inBrowser,lottie.installPlugin=installPlugin,lottie.freeze=animationManager.freeze,lottie.unfreeze=animationManager.unfreeze,lottie.setVolume=animationManager.setVolume,lottie.mute=animationManager.mute,lottie.unmute=animationManager.unmute,lottie.getRegisteredAnimations=animationManager.getRegisteredAnimations,lottie.useWebWorker=setWebWorker,lottie.setIDPrefix=setPrefix,lottie.__getFactory=getFactory,lottie.version="5.12.2";var queryString="";if(standalone){var scripts=document.getElementsByTagName("script"),index=scripts.length-1,myScript=scripts[index]||{src:""};queryString=myScript.src?myScript.src.replace(/^[^\?]+\??/,""):"",renderer=getQueryVariable("renderer")}var readyStateCheckInterval=setInterval(checkReady,100);try{"object"!==_typeof$3(exports)&&__webpack_require__.amdO}catch(e){}var ShapeModifiers=function(){var e={},t={};return e.registerModifier=function(e,n){t[e]||(t[e]=n)},e.getModifier=function(e,n,r){return new t[e](n,r)},e}();function ShapeModifier(){}function TrimModifier(){}function PuckerAndBloatModifier(){}ShapeModifier.prototype.initModifierProperties=function(){},ShapeModifier.prototype.addShapeToModifier=function(){},ShapeModifier.prototype.addShape=function(e){if(!this.closed){e.sh.container.addDynamicProperty(e.sh);var t={shape:e.sh,data:e,localShapeCollection:shapeCollectionPool.newShapeCollection()};this.shapes.push(t),this.addShapeToModifier(t),this._isAnimated&&e.setAsAnimated()}},ShapeModifier.prototype.init=function(e,t){this.shapes=[],this.elem=e,this.initDynamicPropertyContainer(e),this.initModifierProperties(e,t),this.frameId=initialDefaultFrame,this.closed=!1,this.k=!1,this.dynamicProperties.length?this.k=!0:this.getValue(!0)},ShapeModifier.prototype.processKeys=function(){this.elem.globalData.frameId!==this.frameId&&(this.frameId=this.elem.globalData.frameId,this.iterateDynamicProperties())},extendPrototype([DynamicPropertyContainer],ShapeModifier),extendPrototype([ShapeModifier],TrimModifier),TrimModifier.prototype.initModifierProperties=function(e,t){this.s=PropertyFactory.getProp(e,t.s,0,.01,this),this.e=PropertyFactory.getProp(e,t.e,0,.01,this),this.o=PropertyFactory.getProp(e,t.o,0,0,this),this.sValue=0,this.eValue=0,this.getValue=this.processKeys,this.m=t.m,this._isAnimated=!!this.s.effectsSequence.length||!!this.e.effectsSequence.length||!!this.o.effectsSequence.length},TrimModifier.prototype.addShapeToModifier=function(e){e.pathsData=[]},TrimModifier.prototype.calculateShapeEdges=function(e,t,n,r,a){var i=[];t<=1?i.push({s:e,e:t}):e>=1?i.push({s:e-1,e:t-1}):(i.push({s:e,e:1}),i.push({s:0,e:t-1}));var s,o,l=[],u=i.length;for(s=0;s<u;s+=1){var c,h;(o=i[s]).e*a<r||o.s*a>r+n||(c=o.s*a<=r?0:(o.s*a-r)/n,h=o.e*a>=r+n?1:(o.e*a-r)/n,l.push([c,h]))}return l.length||l.push([0,0]),l},TrimModifier.prototype.releasePathsData=function(e){var t,n=e.length;for(t=0;t<n;t+=1)segmentsLengthPool.release(e[t]);return e.length=0,e},TrimModifier.prototype.processShapes=function(e){var t,n,r,a;if(this._mdf||e){var i=this.o.v%360/360;if(i<0&&(i+=1),(t=this.s.v>1?1+i:this.s.v<0?0+i:this.s.v+i)>(n=this.e.v>1?1+i:this.e.v<0?0+i:this.e.v+i)){var s=t;t=n,n=s}t=1e-4*Math.round(1e4*t),n=1e-4*Math.round(1e4*n),this.sValue=t,this.eValue=n}else t=this.sValue,n=this.eValue;var o,l,u,c,h,p=this.shapes.length,f=0;if(n===t)for(a=0;a<p;a+=1)this.shapes[a].localShapeCollection.releaseShapes(),this.shapes[a].shape._mdf=!0,this.shapes[a].shape.paths=this.shapes[a].localShapeCollection,this._mdf&&(this.shapes[a].pathsData.length=0);else if(1===n&&0===t||0===n&&1===t){if(this._mdf)for(a=0;a<p;a+=1)this.shapes[a].pathsData.length=0,this.shapes[a].shape._mdf=!0}else{var d,m,g=[];for(a=0;a<p;a+=1)if((d=this.shapes[a]).shape._mdf||this._mdf||e||2===this.m){if(l=(r=d.shape.paths)._length,h=0,!d.shape._mdf&&d.pathsData.length)h=d.totalShapeLength;else{for(u=this.releasePathsData(d.pathsData),o=0;o<l;o+=1)c=bez.getSegmentsLength(r.shapes[o]),u.push(c),h+=c.totalLength;d.totalShapeLength=h,d.pathsData=u}f+=h,d.shape._mdf=!0}else d.shape.paths=d.localShapeCollection;var y,v=t,b=n,k=0;for(a=p-1;a>=0;a-=1)if((d=this.shapes[a]).shape._mdf){for((m=d.localShapeCollection).releaseShapes(),2===this.m&&p>1?(y=this.calculateShapeEdges(t,n,d.totalShapeLength,k,f),k+=d.totalShapeLength):y=[[v,b]],l=y.length,o=0;o<l;o+=1){v=y[o][0],b=y[o][1],g.length=0,b<=1?g.push({s:d.totalShapeLength*v,e:d.totalShapeLength*b}):v>=1?g.push({s:d.totalShapeLength*(v-1),e:d.totalShapeLength*(b-1)}):(g.push({s:d.totalShapeLength*v,e:d.totalShapeLength}),g.push({s:0,e:d.totalShapeLength*(b-1)}));var x=this.addShapes(d,g[0]);if(g[0].s!==g[0].e){if(g.length>1)if(d.shape.paths.shapes[d.shape.paths._length-1].c){var S=x.pop();this.addPaths(x,m),x=this.addShapes(d,g[1],S)}else this.addPaths(x,m),x=this.addShapes(d,g[1]);this.addPaths(x,m)}}d.shape.paths=m}}},TrimModifier.prototype.addPaths=function(e,t){var n,r=e.length;for(n=0;n<r;n+=1)t.addShape(e[n])},TrimModifier.prototype.addSegment=function(e,t,n,r,a,i,s){a.setXYAt(t[0],t[1],"o",i),a.setXYAt(n[0],n[1],"i",i+1),s&&a.setXYAt(e[0],e[1],"v",i),a.setXYAt(r[0],r[1],"v",i+1)},TrimModifier.prototype.addSegmentFromArray=function(e,t,n,r){t.setXYAt(e[1],e[5],"o",n),t.setXYAt(e[2],e[6],"i",n+1),r&&t.setXYAt(e[0],e[4],"v",n),t.setXYAt(e[3],e[7],"v",n+1)},TrimModifier.prototype.addShapes=function(e,t,n){var r,a,i,s,o,l,u,c,h=e.pathsData,p=e.shape.paths.shapes,f=e.shape.paths._length,d=0,m=[],g=!0;for(n?(o=n._length,c=n._length):(n=shapePool.newElement(),o=0,c=0),m.push(n),r=0;r<f;r+=1){for(l=h[r].lengths,n.c=p[r].c,i=p[r].c?l.length:l.length+1,a=1;a<i;a+=1)if(d+(s=l[a-1]).addedLength<t.s)d+=s.addedLength,n.c=!1;else{if(d>t.e){n.c=!1;break}t.s<=d&&t.e>=d+s.addedLength?(this.addSegment(p[r].v[a-1],p[r].o[a-1],p[r].i[a],p[r].v[a],n,o,g),g=!1):(u=bez.getNewSegment(p[r].v[a-1],p[r].v[a],p[r].o[a-1],p[r].i[a],(t.s-d)/s.addedLength,(t.e-d)/s.addedLength,l[a-1]),this.addSegmentFromArray(u,n,o,g),g=!1,n.c=!1),d+=s.addedLength,o+=1}if(p[r].c&&l.length){if(s=l[a-1],d<=t.e){var y=l[a-1].addedLength;t.s<=d&&t.e>=d+y?(this.addSegment(p[r].v[a-1],p[r].o[a-1],p[r].i[0],p[r].v[0],n,o,g),g=!1):(u=bez.getNewSegment(p[r].v[a-1],p[r].v[0],p[r].o[a-1],p[r].i[0],(t.s-d)/y,(t.e-d)/y,l[a-1]),this.addSegmentFromArray(u,n,o,g),g=!1,n.c=!1)}else n.c=!1;d+=s.addedLength,o+=1}if(n._length&&(n.setXYAt(n.v[c][0],n.v[c][1],"i",c),n.setXYAt(n.v[n._length-1][0],n.v[n._length-1][1],"o",n._length-1)),d>t.e)break;r<f-1&&(n=shapePool.newElement(),g=!0,m.push(n),o=0)}return m},extendPrototype([ShapeModifier],PuckerAndBloatModifier),PuckerAndBloatModifier.prototype.initModifierProperties=function(e,t){this.getValue=this.processKeys,this.amount=PropertyFactory.getProp(e,t.a,0,null,this),this._isAnimated=!!this.amount.effectsSequence.length},PuckerAndBloatModifier.prototype.processPath=function(e,t){var n=t/100,r=[0,0],a=e._length,i=0;for(i=0;i<a;i+=1)r[0]+=e.v[i][0],r[1]+=e.v[i][1];r[0]/=a,r[1]/=a;var s,o,l,u,c,h,p=shapePool.newElement();for(p.c=e.c,i=0;i<a;i+=1)s=e.v[i][0]+(r[0]-e.v[i][0])*n,o=e.v[i][1]+(r[1]-e.v[i][1])*n,l=e.o[i][0]+(r[0]-e.o[i][0])*-n,u=e.o[i][1]+(r[1]-e.o[i][1])*-n,c=e.i[i][0]+(r[0]-e.i[i][0])*-n,h=e.i[i][1]+(r[1]-e.i[i][1])*-n,p.setTripleAt(s,o,l,u,c,h,i);return p},PuckerAndBloatModifier.prototype.processShapes=function(e){var t,n,r,a,i,s,o=this.shapes.length,l=this.amount.v;if(0!==l)for(n=0;n<o;n+=1){if(s=(i=this.shapes[n]).localShapeCollection,i.shape._mdf||this._mdf||e)for(s.releaseShapes(),i.shape._mdf=!0,t=i.shape.paths.shapes,a=i.shape.paths._length,r=0;r<a;r+=1)s.addShape(this.processPath(t[r],l));i.shape.paths=i.localShapeCollection}this.dynamicProperties.length||(this._mdf=!1)};var TransformPropertyFactory=function(){var e=[0,0];function t(e,t,n){if(this.elem=e,this.frameId=-1,this.propType="transform",this.data=t,this.v=new Matrix,this.pre=new Matrix,this.appliedTransformations=0,this.initDynamicPropertyContainer(n||e),t.p&&t.p.s?(this.px=PropertyFactory.getProp(e,t.p.x,0,0,this),this.py=PropertyFactory.getProp(e,t.p.y,0,0,this),t.p.z&&(this.pz=PropertyFactory.getProp(e,t.p.z,0,0,this))):this.p=PropertyFactory.getProp(e,t.p||{k:[0,0,0]},1,0,this),t.rx){if(this.rx=PropertyFactory.getProp(e,t.rx,0,degToRads,this),this.ry=PropertyFactory.getProp(e,t.ry,0,degToRads,this),this.rz=PropertyFactory.getProp(e,t.rz,0,degToRads,this),t.or.k[0].ti){var r,a=t.or.k.length;for(r=0;r<a;r+=1)t.or.k[r].to=null,t.or.k[r].ti=null}this.or=PropertyFactory.getProp(e,t.or,1,degToRads,this),this.or.sh=!0}else this.r=PropertyFactory.getProp(e,t.r||{k:0},0,degToRads,this);t.sk&&(this.sk=PropertyFactory.getProp(e,t.sk,0,degToRads,this),this.sa=PropertyFactory.getProp(e,t.sa,0,degToRads,this)),this.a=PropertyFactory.getProp(e,t.a||{k:[0,0,0]},1,0,this),this.s=PropertyFactory.getProp(e,t.s||{k:[100,100,100]},1,.01,this),t.o?this.o=PropertyFactory.getProp(e,t.o,0,.01,e):this.o={_mdf:!1,v:1},this._isDirty=!0,this.dynamicProperties.length||this.getValue(!0)}return t.prototype={applyToMatrix:function(e){var t=this._mdf;this.iterateDynamicProperties(),this._mdf=this._mdf||t,this.a&&e.translate(-this.a.v[0],-this.a.v[1],this.a.v[2]),this.s&&e.scale(this.s.v[0],this.s.v[1],this.s.v[2]),this.sk&&e.skewFromAxis(-this.sk.v,this.sa.v),this.r?e.rotate(-this.r.v):e.rotateZ(-this.rz.v).rotateY(this.ry.v).rotateX(this.rx.v).rotateZ(-this.or.v[2]).rotateY(this.or.v[1]).rotateX(this.or.v[0]),this.data.p.s?this.data.p.z?e.translate(this.px.v,this.py.v,-this.pz.v):e.translate(this.px.v,this.py.v,0):e.translate(this.p.v[0],this.p.v[1],-this.p.v[2])},getValue:function(t){if(this.elem.globalData.frameId!==this.frameId){if(this._isDirty&&(this.precalculateMatrix(),this._isDirty=!1),this.iterateDynamicProperties(),this._mdf||t){var n;if(this.v.cloneFromProps(this.pre.props),this.appliedTransformations<1&&this.v.translate(-this.a.v[0],-this.a.v[1],this.a.v[2]),this.appliedTransformations<2&&this.v.scale(this.s.v[0],this.s.v[1],this.s.v[2]),this.sk&&this.appliedTransformations<3&&this.v.skewFromAxis(-this.sk.v,this.sa.v),this.r&&this.appliedTransformations<4?this.v.rotate(-this.r.v):!this.r&&this.appliedTransformations<4&&this.v.rotateZ(-this.rz.v).rotateY(this.ry.v).rotateX(this.rx.v).rotateZ(-this.or.v[2]).rotateY(this.or.v[1]).rotateX(this.or.v[0]),this.autoOriented){var r,a;if(n=this.elem.globalData.frameRate,this.p&&this.p.keyframes&&this.p.getValueAtTime)this.p._caching.lastFrame+this.p.offsetTime<=this.p.keyframes[0].t?(r=this.p.getValueAtTime((this.p.keyframes[0].t+.01)/n,0),a=this.p.getValueAtTime(this.p.keyframes[0].t/n,0)):this.p._caching.lastFrame+this.p.offsetTime>=this.p.keyframes[this.p.keyframes.length-1].t?(r=this.p.getValueAtTime(this.p.keyframes[this.p.keyframes.length-1].t/n,0),a=this.p.getValueAtTime((this.p.keyframes[this.p.keyframes.length-1].t-.05)/n,0)):(r=this.p.pv,a=this.p.getValueAtTime((this.p._caching.lastFrame+this.p.offsetTime-.01)/n,this.p.offsetTime));else if(this.px&&this.px.keyframes&&this.py.keyframes&&this.px.getValueAtTime&&this.py.getValueAtTime){r=[],a=[];var i=this.px,s=this.py;i._caching.lastFrame+i.offsetTime<=i.keyframes[0].t?(r[0]=i.getValueAtTime((i.keyframes[0].t+.01)/n,0),r[1]=s.getValueAtTime((s.keyframes[0].t+.01)/n,0),a[0]=i.getValueAtTime(i.keyframes[0].t/n,0),a[1]=s.getValueAtTime(s.keyframes[0].t/n,0)):i._caching.lastFrame+i.offsetTime>=i.keyframes[i.keyframes.length-1].t?(r[0]=i.getValueAtTime(i.keyframes[i.keyframes.length-1].t/n,0),r[1]=s.getValueAtTime(s.keyframes[s.keyframes.length-1].t/n,0),a[0]=i.getValueAtTime((i.keyframes[i.keyframes.length-1].t-.01)/n,0),a[1]=s.getValueAtTime((s.keyframes[s.keyframes.length-1].t-.01)/n,0)):(r=[i.pv,s.pv],a[0]=i.getValueAtTime((i._caching.lastFrame+i.offsetTime-.01)/n,i.offsetTime),a[1]=s.getValueAtTime((s._caching.lastFrame+s.offsetTime-.01)/n,s.offsetTime))}else r=a=e;this.v.rotate(-Math.atan2(r[1]-a[1],r[0]-a[0]))}this.data.p&&this.data.p.s?this.data.p.z?this.v.translate(this.px.v,this.py.v,-this.pz.v):this.v.translate(this.px.v,this.py.v,0):this.v.translate(this.p.v[0],this.p.v[1],-this.p.v[2])}this.frameId=this.elem.globalData.frameId}},precalculateMatrix:function(){if(this.appliedTransformations=0,this.pre.reset(),!this.a.effectsSequence.length&&(this.pre.translate(-this.a.v[0],-this.a.v[1],this.a.v[2]),this.appliedTransformations=1,!this.s.effectsSequence.length)){if(this.pre.scale(this.s.v[0],this.s.v[1],this.s.v[2]),this.appliedTransformations=2,this.sk){if(this.sk.effectsSequence.length||this.sa.effectsSequence.length)return;this.pre.skewFromAxis(-this.sk.v,this.sa.v),this.appliedTransformations=3}this.r?this.r.effectsSequence.length||(this.pre.rotate(-this.r.v),this.appliedTransformations=4):this.rz.effectsSequence.length||this.ry.effectsSequence.length||this.rx.effectsSequence.length||this.or.effectsSequence.length||(this.pre.rotateZ(-this.rz.v).rotateY(this.ry.v).rotateX(this.rx.v).rotateZ(-this.or.v[2]).rotateY(this.or.v[1]).rotateX(this.or.v[0]),this.appliedTransformations=4)}},autoOrient:function(){}},extendPrototype([DynamicPropertyContainer],t),t.prototype.addDynamicProperty=function(e){this._addDynamicProperty(e),this.elem.addDynamicProperty(e),this._isDirty=!0},t.prototype._addDynamicProperty=DynamicPropertyContainer.prototype.addDynamicProperty,{getTransformProperty:function(e,n,r){return new t(e,n,r)}}}();function RepeaterModifier(){}function RoundCornersModifier(){}function floatEqual(e,t){return 1e5*Math.abs(e-t)<=Math.min(Math.abs(e),Math.abs(t))}function floatZero(e){return Math.abs(e)<=1e-5}function lerp(e,t,n){return e*(1-n)+t*n}function lerpPoint(e,t,n){return[lerp(e[0],t[0],n),lerp(e[1],t[1],n)]}function quadRoots(e,t,n){if(0===e)return[];var r=t*t-4*e*n;if(r<0)return[];var a=-t/(2*e);if(0===r)return[a];var i=Math.sqrt(r)/(2*e);return[a-i,a+i]}function polynomialCoefficients(e,t,n,r){return[3*t-e-3*n+r,3*e-6*t+3*n,-3*e+3*t,e]}function singlePoint(e){return new PolynomialBezier(e,e,e,e,!1)}function PolynomialBezier(e,t,n,r,a){a&&pointEqual(e,t)&&(t=lerpPoint(e,r,1/3)),a&&pointEqual(n,r)&&(n=lerpPoint(e,r,2/3));var i=polynomialCoefficients(e[0],t[0],n[0],r[0]),s=polynomialCoefficients(e[1],t[1],n[1],r[1]);this.a=[i[0],s[0]],this.b=[i[1],s[1]],this.c=[i[2],s[2]],this.d=[i[3],s[3]],this.points=[e,t,n,r]}function extrema(e,t){var n=e.points[0][t],r=e.points[e.points.length-1][t];if(n>r){var a=r;r=n,n=a}for(var i=quadRoots(3*e.a[t],2*e.b[t],e.c[t]),s=0;s<i.length;s+=1)if(i[s]>0&&i[s]<1){var o=e.point(i[s])[t];o<n?n=o:o>r&&(r=o)}return{min:n,max:r}}function intersectData(e,t,n){var r=e.boundingBox();return{cx:r.cx,cy:r.cy,width:r.width,height:r.height,bez:e,t:(t+n)/2,t1:t,t2:n}}function splitData(e){var t=e.bez.split(.5);return[intersectData(t[0],e.t1,e.t),intersectData(t[1],e.t,e.t2)]}function boxIntersect(e,t){return 2*Math.abs(e.cx-t.cx)<e.width+t.width&&2*Math.abs(e.cy-t.cy)<e.height+t.height}function intersectsImpl(e,t,n,r,a,i){if(boxIntersect(e,t))if(n>=i||e.width<=r&&e.height<=r&&t.width<=r&&t.height<=r)a.push([e.t,t.t]);else{var s=splitData(e),o=splitData(t);intersectsImpl(s[0],o[0],n+1,r,a,i),intersectsImpl(s[0],o[1],n+1,r,a,i),intersectsImpl(s[1],o[0],n+1,r,a,i),intersectsImpl(s[1],o[1],n+1,r,a,i)}}function crossProduct(e,t){return[e[1]*t[2]-e[2]*t[1],e[2]*t[0]-e[0]*t[2],e[0]*t[1]-e[1]*t[0]]}function lineIntersection(e,t,n,r){var a=[e[0],e[1],1],i=[t[0],t[1],1],s=[n[0],n[1],1],o=[r[0],r[1],1],l=crossProduct(crossProduct(a,i),crossProduct(s,o));return floatZero(l[2])?null:[l[0]/l[2],l[1]/l[2]]}function polarOffset(e,t,n){return[e[0]+Math.cos(t)*n,e[1]-Math.sin(t)*n]}function pointDistance(e,t){return Math.hypot(e[0]-t[0],e[1]-t[1])}function pointEqual(e,t){return floatEqual(e[0],t[0])&&floatEqual(e[1],t[1])}function ZigZagModifier(){}function setPoint(e,t,n,r,a,i,s){var o=n-Math.PI/2,l=n+Math.PI/2,u=t[0]+Math.cos(n)*r*a,c=t[1]-Math.sin(n)*r*a;e.setTripleAt(u,c,u+Math.cos(o)*i,c-Math.sin(o)*i,u+Math.cos(l)*s,c-Math.sin(l)*s,e.length())}function getPerpendicularVector(e,t){var n=[t[0]-e[0],t[1]-e[1]],r=.5*-Math.PI;return[Math.cos(r)*n[0]-Math.sin(r)*n[1],Math.sin(r)*n[0]+Math.cos(r)*n[1]]}function getProjectingAngle(e,t){var n=0===t?e.length()-1:t-1,r=(t+1)%e.length(),a=getPerpendicularVector(e.v[n],e.v[r]);return Math.atan2(0,1)-Math.atan2(a[1],a[0])}function zigZagCorner(e,t,n,r,a,i,s){var o=getProjectingAngle(t,n),l=t.v[n%t._length],u=t.v[0===n?t._length-1:n-1],c=t.v[(n+1)%t._length],h=2===i?Math.sqrt(Math.pow(l[0]-u[0],2)+Math.pow(l[1]-u[1],2)):0,p=2===i?Math.sqrt(Math.pow(l[0]-c[0],2)+Math.pow(l[1]-c[1],2)):0;setPoint(e,t.v[n%t._length],o,s,r,p/(2*(a+1)),h/(2*(a+1)),i)}function zigZagSegment(e,t,n,r,a,i){for(var s=0;s<r;s+=1){var o=(s+1)/(r+1),l=2===a?Math.sqrt(Math.pow(t.points[3][0]-t.points[0][0],2)+Math.pow(t.points[3][1]-t.points[0][1],2)):0,u=t.normalAngle(o);setPoint(e,t.point(o),u,i,n,l/(2*(r+1)),l/(2*(r+1)),a),i=-i}return i}function linearOffset(e,t,n){var r=Math.atan2(t[0]-e[0],t[1]-e[1]);return[polarOffset(e,r,n),polarOffset(t,r,n)]}function offsetSegment(e,t){var n,r,a,i,s,o,l;n=(l=linearOffset(e.points[0],e.points[1],t))[0],r=l[1],a=(l=linearOffset(e.points[1],e.points[2],t))[0],i=l[1],s=(l=linearOffset(e.points[2],e.points[3],t))[0],o=l[1];var u=lineIntersection(n,r,a,i);null===u&&(u=r);var c=lineIntersection(s,o,a,i);return null===c&&(c=s),new PolynomialBezier(n,u,c,o)}function joinLines(e,t,n,r,a){var i=t.points[3],s=n.points[0];if(3===r)return i;if(pointEqual(i,s))return i;if(2===r){var o=-t.tangentAngle(1),l=-n.tangentAngle(0)+Math.PI,u=lineIntersection(i,polarOffset(i,o+Math.PI/2,100),s,polarOffset(s,o+Math.PI/2,100)),c=u?pointDistance(u,i):pointDistance(i,s)/2,h=polarOffset(i,o,2*c*roundCorner);return e.setXYAt(h[0],h[1],"o",e.length()-1),h=polarOffset(s,l,2*c*roundCorner),e.setTripleAt(s[0],s[1],s[0],s[1],h[0],h[1],e.length()),s}var p=lineIntersection(pointEqual(i,t.points[2])?t.points[0]:t.points[2],i,s,pointEqual(s,n.points[1])?n.points[3]:n.points[1]);return p&&pointDistance(p,i)<a?(e.setTripleAt(p[0],p[1],p[0],p[1],p[0],p[1],e.length()),p):i}function getIntersection(e,t){var n=e.intersections(t);return n.length&&floatEqual(n[0][0],1)&&n.shift(),n.length?n[0]:null}function pruneSegmentIntersection(e,t){var n=e.slice(),r=t.slice(),a=getIntersection(e[e.length-1],t[0]);return a&&(n[e.length-1]=e[e.length-1].split(a[0])[0],r[0]=t[0].split(a[1])[1]),e.length>1&&t.length>1&&(a=getIntersection(e[0],t[t.length-1]))?[[e[0].split(a[0])[0]],[t[t.length-1].split(a[1])[1]]]:[n,r]}function pruneIntersections(e){for(var t,n=1;n<e.length;n+=1)t=pruneSegmentIntersection(e[n-1],e[n]),e[n-1]=t[0],e[n]=t[1];return e.length>1&&(t=pruneSegmentIntersection(e[e.length-1],e[0]),e[e.length-1]=t[0],e[0]=t[1]),e}function offsetSegmentSplit(e,t){var n,r,a,i,s=e.inflectionPoints();if(0===s.length)return[offsetSegment(e,t)];if(1===s.length||floatEqual(s[1],1))return n=(a=e.split(s[0]))[0],r=a[1],[offsetSegment(n,t),offsetSegment(r,t)];n=(a=e.split(s[0]))[0];var o=(s[1]-s[0])/(1-s[0]);return i=(a=a[1].split(o))[0],r=a[1],[offsetSegment(n,t),offsetSegment(i,t),offsetSegment(r,t)]}function OffsetPathModifier(){}function getFontProperties(e){for(var t=e.fStyle?e.fStyle.split(" "):[],n="normal",r="normal",a=t.length,i=0;i<a;i+=1)switch(t[i].toLowerCase()){case"italic":r="italic";break;case"bold":n="700";break;case"black":n="900";break;case"medium":n="500";break;case"regular":case"normal":n="400";break;case"light":case"thin":n="200"}return{style:r,weight:e.fWeight||n}}extendPrototype([ShapeModifier],RepeaterModifier),RepeaterModifier.prototype.initModifierProperties=function(e,t){this.getValue=this.processKeys,this.c=PropertyFactory.getProp(e,t.c,0,null,this),this.o=PropertyFactory.getProp(e,t.o,0,null,this),this.tr=TransformPropertyFactory.getTransformProperty(e,t.tr,this),this.so=PropertyFactory.getProp(e,t.tr.so,0,.01,this),this.eo=PropertyFactory.getProp(e,t.tr.eo,0,.01,this),this.data=t,this.dynamicProperties.length||this.getValue(!0),this._isAnimated=!!this.dynamicProperties.length,this.pMatrix=new Matrix,this.rMatrix=new Matrix,this.sMatrix=new Matrix,this.tMatrix=new Matrix,this.matrix=new Matrix},RepeaterModifier.prototype.applyTransforms=function(e,t,n,r,a,i){var s=i?-1:1,o=r.s.v[0]+(1-r.s.v[0])*(1-a),l=r.s.v[1]+(1-r.s.v[1])*(1-a);e.translate(r.p.v[0]*s*a,r.p.v[1]*s*a,r.p.v[2]),t.translate(-r.a.v[0],-r.a.v[1],r.a.v[2]),t.rotate(-r.r.v*s*a),t.translate(r.a.v[0],r.a.v[1],r.a.v[2]),n.translate(-r.a.v[0],-r.a.v[1],r.a.v[2]),n.scale(i?1/o:o,i?1/l:l),n.translate(r.a.v[0],r.a.v[1],r.a.v[2])},RepeaterModifier.prototype.init=function(e,t,n,r){for(this.elem=e,this.arr=t,this.pos=n,this.elemsData=r,this._currentCopies=0,this._elements=[],this._groups=[],this.frameId=-1,this.initDynamicPropertyContainer(e),this.initModifierProperties(e,t[n]);n>0;)n-=1,this._elements.unshift(t[n]);this.dynamicProperties.length?this.k=!0:this.getValue(!0)},RepeaterModifier.prototype.resetElements=function(e){var t,n=e.length;for(t=0;t<n;t+=1)e[t]._processed=!1,"gr"===e[t].ty&&this.resetElements(e[t].it)},RepeaterModifier.prototype.cloneElements=function(e){var t=JSON.parse(JSON.stringify(e));return this.resetElements(t),t},RepeaterModifier.prototype.changeGroupRender=function(e,t){var n,r=e.length;for(n=0;n<r;n+=1)e[n]._render=t,"gr"===e[n].ty&&this.changeGroupRender(e[n].it,t)},RepeaterModifier.prototype.processShapes=function(e){var t,n,r,a,i,s=!1;if(this._mdf||e){var o,l=Math.ceil(this.c.v);if(this._groups.length<l){for(;this._groups.length<l;){var u={it:this.cloneElements(this._elements),ty:"gr"};u.it.push({a:{a:0,ix:1,k:[0,0]},nm:"Transform",o:{a:0,ix:7,k:100},p:{a:0,ix:2,k:[0,0]},r:{a:1,ix:6,k:[{s:0,e:0,t:0},{s:0,e:0,t:1}]},s:{a:0,ix:3,k:[100,100]},sa:{a:0,ix:5,k:0},sk:{a:0,ix:4,k:0},ty:"tr"}),this.arr.splice(0,0,u),this._groups.splice(0,0,u),this._currentCopies+=1}this.elem.reloadShapes(),s=!0}for(i=0,r=0;r<=this._groups.length-1;r+=1){if(o=i<l,this._groups[r]._render=o,this.changeGroupRender(this._groups[r].it,o),!o){var c=this.elemsData[r].it,h=c[c.length-1];0!==h.transform.op.v?(h.transform.op._mdf=!0,h.transform.op.v=0):h.transform.op._mdf=!1}i+=1}this._currentCopies=l;var p=this.o.v,f=p%1,d=p>0?Math.floor(p):Math.ceil(p),m=this.pMatrix.props,g=this.rMatrix.props,y=this.sMatrix.props;this.pMatrix.reset(),this.rMatrix.reset(),this.sMatrix.reset(),this.tMatrix.reset(),this.matrix.reset();var v,b,k=0;if(p>0){for(;k<d;)this.applyTransforms(this.pMatrix,this.rMatrix,this.sMatrix,this.tr,1,!1),k+=1;f&&(this.applyTransforms(this.pMatrix,this.rMatrix,this.sMatrix,this.tr,f,!1),k+=f)}else if(p<0){for(;k>d;)this.applyTransforms(this.pMatrix,this.rMatrix,this.sMatrix,this.tr,1,!0),k-=1;f&&(this.applyTransforms(this.pMatrix,this.rMatrix,this.sMatrix,this.tr,-f,!0),k-=f)}for(r=1===this.data.m?0:this._currentCopies-1,a=1===this.data.m?1:-1,i=this._currentCopies;i;){if(b=(n=(t=this.elemsData[r].it)[t.length-1].transform.mProps.v.props).length,t[t.length-1].transform.mProps._mdf=!0,t[t.length-1].transform.op._mdf=!0,t[t.length-1].transform.op.v=1===this._currentCopies?this.so.v:this.so.v+(this.eo.v-this.so.v)*(r/(this._currentCopies-1)),0!==k){for((0!==r&&1===a||r!==this._currentCopies-1&&-1===a)&&this.applyTransforms(this.pMatrix,this.rMatrix,this.sMatrix,this.tr,1,!1),this.matrix.transform(g[0],g[1],g[2],g[3],g[4],g[5],g[6],g[7],g[8],g[9],g[10],g[11],g[12],g[13],g[14],g[15]),this.matrix.transform(y[0],y[1],y[2],y[3],y[4],y[5],y[6],y[7],y[8],y[9],y[10],y[11],y[12],y[13],y[14],y[15]),this.matrix.transform(m[0],m[1],m[2],m[3],m[4],m[5],m[6],m[7],m[8],m[9],m[10],m[11],m[12],m[13],m[14],m[15]),v=0;v<b;v+=1)n[v]=this.matrix.props[v];this.matrix.reset()}else for(this.matrix.reset(),v=0;v<b;v+=1)n[v]=this.matrix.props[v];k+=1,i-=1,r+=a}}else for(i=this._currentCopies,r=0,a=1;i;)n=(t=this.elemsData[r].it)[t.length-1].transform.mProps.v.props,t[t.length-1].transform.mProps._mdf=!1,t[t.length-1].transform.op._mdf=!1,i-=1,r+=a;return s},RepeaterModifier.prototype.addShape=function(){},extendPrototype([ShapeModifier],RoundCornersModifier),RoundCornersModifier.prototype.initModifierProperties=function(e,t){this.getValue=this.processKeys,this.rd=PropertyFactory.getProp(e,t.r,0,null,this),this._isAnimated=!!this.rd.effectsSequence.length},RoundCornersModifier.prototype.processPath=function(e,t){var n,r=shapePool.newElement();r.c=e.c;var a,i,s,o,l,u,c,h,p,f,d,m,g=e._length,y=0;for(n=0;n<g;n+=1)a=e.v[n],s=e.o[n],i=e.i[n],a[0]===s[0]&&a[1]===s[1]&&a[0]===i[0]&&a[1]===i[1]?0!==n&&n!==g-1||e.c?(o=0===n?e.v[g-1]:e.v[n-1],u=(l=Math.sqrt(Math.pow(a[0]-o[0],2)+Math.pow(a[1]-o[1],2)))?Math.min(l/2,t)/l:0,c=d=a[0]+(o[0]-a[0])*u,h=m=a[1]-(a[1]-o[1])*u,p=c-(c-a[0])*roundCorner,f=h-(h-a[1])*roundCorner,r.setTripleAt(c,h,p,f,d,m,y),y+=1,o=n===g-1?e.v[0]:e.v[n+1],u=(l=Math.sqrt(Math.pow(a[0]-o[0],2)+Math.pow(a[1]-o[1],2)))?Math.min(l/2,t)/l:0,c=p=a[0]+(o[0]-a[0])*u,h=f=a[1]+(o[1]-a[1])*u,d=c-(c-a[0])*roundCorner,m=h-(h-a[1])*roundCorner,r.setTripleAt(c,h,p,f,d,m,y),y+=1):(r.setTripleAt(a[0],a[1],s[0],s[1],i[0],i[1],y),y+=1):(r.setTripleAt(e.v[n][0],e.v[n][1],e.o[n][0],e.o[n][1],e.i[n][0],e.i[n][1],y),y+=1);return r},RoundCornersModifier.prototype.processShapes=function(e){var t,n,r,a,i,s,o=this.shapes.length,l=this.rd.v;if(0!==l)for(n=0;n<o;n+=1){if(s=(i=this.shapes[n]).localShapeCollection,i.shape._mdf||this._mdf||e)for(s.releaseShapes(),i.shape._mdf=!0,t=i.shape.paths.shapes,a=i.shape.paths._length,r=0;r<a;r+=1)s.addShape(this.processPath(t[r],l));i.shape.paths=i.localShapeCollection}this.dynamicProperties.length||(this._mdf=!1)},PolynomialBezier.prototype.point=function(e){return[((this.a[0]*e+this.b[0])*e+this.c[0])*e+this.d[0],((this.a[1]*e+this.b[1])*e+this.c[1])*e+this.d[1]]},PolynomialBezier.prototype.derivative=function(e){return[(3*e*this.a[0]+2*this.b[0])*e+this.c[0],(3*e*this.a[1]+2*this.b[1])*e+this.c[1]]},PolynomialBezier.prototype.tangentAngle=function(e){var t=this.derivative(e);return Math.atan2(t[1],t[0])},PolynomialBezier.prototype.normalAngle=function(e){var t=this.derivative(e);return Math.atan2(t[0],t[1])},PolynomialBezier.prototype.inflectionPoints=function(){var e=this.a[1]*this.b[0]-this.a[0]*this.b[1];if(floatZero(e))return[];var t=-.5*(this.a[1]*this.c[0]-this.a[0]*this.c[1])/e,n=t*t-1/3*(this.b[1]*this.c[0]-this.b[0]*this.c[1])/e;if(n<0)return[];var r=Math.sqrt(n);return floatZero(r)?r>0&&r<1?[t]:[]:[t-r,t+r].filter((function(e){return e>0&&e<1}))},PolynomialBezier.prototype.split=function(e){if(e<=0)return[singlePoint(this.points[0]),this];if(e>=1)return[this,singlePoint(this.points[this.points.length-1])];var t=lerpPoint(this.points[0],this.points[1],e),n=lerpPoint(this.points[1],this.points[2],e),r=lerpPoint(this.points[2],this.points[3],e),a=lerpPoint(t,n,e),i=lerpPoint(n,r,e),s=lerpPoint(a,i,e);return[new PolynomialBezier(this.points[0],t,a,s,!0),new PolynomialBezier(s,i,r,this.points[3],!0)]},PolynomialBezier.prototype.bounds=function(){return{x:extrema(this,0),y:extrema(this,1)}},PolynomialBezier.prototype.boundingBox=function(){var e=this.bounds();return{left:e.x.min,right:e.x.max,top:e.y.min,bottom:e.y.max,width:e.x.max-e.x.min,height:e.y.max-e.y.min,cx:(e.x.max+e.x.min)/2,cy:(e.y.max+e.y.min)/2}},PolynomialBezier.prototype.intersections=function(e,t,n){void 0===t&&(t=2),void 0===n&&(n=7);var r=[];return intersectsImpl(intersectData(this,0,1),intersectData(e,0,1),0,t,r,n),r},PolynomialBezier.shapeSegment=function(e,t){var n=(t+1)%e.length();return new PolynomialBezier(e.v[t],e.o[t],e.i[n],e.v[n],!0)},PolynomialBezier.shapeSegmentInverted=function(e,t){var n=(t+1)%e.length();return new PolynomialBezier(e.v[n],e.i[n],e.o[t],e.v[t],!0)},extendPrototype([ShapeModifier],ZigZagModifier),ZigZagModifier.prototype.initModifierProperties=function(e,t){this.getValue=this.processKeys,this.amplitude=PropertyFactory.getProp(e,t.s,0,null,this),this.frequency=PropertyFactory.getProp(e,t.r,0,null,this),this.pointsType=PropertyFactory.getProp(e,t.pt,0,null,this),this._isAnimated=0!==this.amplitude.effectsSequence.length||0!==this.frequency.effectsSequence.length||0!==this.pointsType.effectsSequence.length},ZigZagModifier.prototype.processPath=function(e,t,n,r){var a=e._length,i=shapePool.newElement();if(i.c=e.c,e.c||(a-=1),0===a)return i;var s=-1,o=PolynomialBezier.shapeSegment(e,0);zigZagCorner(i,e,0,t,n,r,s);for(var l=0;l<a;l+=1)s=zigZagSegment(i,o,t,n,r,-s),o=l!==a-1||e.c?PolynomialBezier.shapeSegment(e,(l+1)%a):null,zigZagCorner(i,e,l+1,t,n,r,s);return i},ZigZagModifier.prototype.processShapes=function(e){var t,n,r,a,i,s,o=this.shapes.length,l=this.amplitude.v,u=Math.max(0,Math.round(this.frequency.v)),c=this.pointsType.v;if(0!==l)for(n=0;n<o;n+=1){if(s=(i=this.shapes[n]).localShapeCollection,i.shape._mdf||this._mdf||e)for(s.releaseShapes(),i.shape._mdf=!0,t=i.shape.paths.shapes,a=i.shape.paths._length,r=0;r<a;r+=1)s.addShape(this.processPath(t[r],l,u,c));i.shape.paths=i.localShapeCollection}this.dynamicProperties.length||(this._mdf=!1)},extendPrototype([ShapeModifier],OffsetPathModifier),OffsetPathModifier.prototype.initModifierProperties=function(e,t){this.getValue=this.processKeys,this.amount=PropertyFactory.getProp(e,t.a,0,null,this),this.miterLimit=PropertyFactory.getProp(e,t.ml,0,null,this),this.lineJoin=t.lj,this._isAnimated=0!==this.amount.effectsSequence.length},OffsetPathModifier.prototype.processPath=function(e,t,n,r){var a=shapePool.newElement();a.c=e.c;var i,s,o,l=e.length();e.c||(l-=1);var u=[];for(i=0;i<l;i+=1)o=PolynomialBezier.shapeSegment(e,i),u.push(offsetSegmentSplit(o,t));if(!e.c)for(i=l-1;i>=0;i-=1)o=PolynomialBezier.shapeSegmentInverted(e,i),u.push(offsetSegmentSplit(o,t));u=pruneIntersections(u);var c=null,h=null;for(i=0;i<u.length;i+=1){var p=u[i];for(h&&(c=joinLines(a,h,p[0],n,r)),h=p[p.length-1],s=0;s<p.length;s+=1)o=p[s],c&&pointEqual(o.points[0],c)?a.setXYAt(o.points[1][0],o.points[1][1],"o",a.length()-1):a.setTripleAt(o.points[0][0],o.points[0][1],o.points[1][0],o.points[1][1],o.points[0][0],o.points[0][1],a.length()),a.setTripleAt(o.points[3][0],o.points[3][1],o.points[3][0],o.points[3][1],o.points[2][0],o.points[2][1],a.length()),c=o.points[3]}return u.length&&joinLines(a,h,u[0][0],n,r),a},OffsetPathModifier.prototype.processShapes=function(e){var t,n,r,a,i,s,o=this.shapes.length,l=this.amount.v,u=this.miterLimit.v,c=this.lineJoin;if(0!==l)for(n=0;n<o;n+=1){if(s=(i=this.shapes[n]).localShapeCollection,i.shape._mdf||this._mdf||e)for(s.releaseShapes(),i.shape._mdf=!0,t=i.shape.paths.shapes,a=i.shape.paths._length,r=0;r<a;r+=1)s.addShape(this.processPath(t[r],l,c,u));i.shape.paths=i.localShapeCollection}this.dynamicProperties.length||(this._mdf=!1)};var FontManager=function(){var e=5e3,t={w:0,size:0,shapes:[],data:{shapes:[]}},n=[];n=n.concat([2304,2305,2306,2307,2362,2363,2364,2364,2366,2367,2368,2369,2370,2371,2372,2373,2374,2375,2376,2377,2378,2379,2380,2381,2382,2383,2387,2388,2389,2390,2391,2402,2403]);var r=127988,a=917631,i=917601,s=917626,o=65039,l=8205,u=127462,c=127487,h=["d83cdffb","d83cdffc","d83cdffd","d83cdffe","d83cdfff"];function p(e,t){var n=createTag("span");n.setAttribute("aria-hidden",!0),n.style.fontFamily=t;var r=createTag("span");r.innerText="giItT1WQy@!-/#",n.style.position="absolute",n.style.left="-10000px",n.style.top="-10000px",n.style.fontSize="300px",n.style.fontVariant="normal",n.style.fontStyle="normal",n.style.fontWeight="normal",n.style.letterSpacing="0",n.appendChild(r),document.body.appendChild(n);var a=r.offsetWidth;return r.style.fontFamily=function(e){var t,n=e.split(","),r=n.length,a=[];for(t=0;t<r;t+=1)"sans-serif"!==n[t]&&"monospace"!==n[t]&&a.push(n[t]);return a.join(",")}(e)+", "+t,{node:r,w:a,parent:n}}function f(e,t){var n,r=document.body&&t?"svg":"canvas",a=getFontProperties(e);if("svg"===r){var i=createNS("text");i.style.fontSize="100px",i.setAttribute("font-family",e.fFamily),i.setAttribute("font-style",a.style),i.setAttribute("font-weight",a.weight),i.textContent="1",e.fClass?(i.style.fontFamily="inherit",i.setAttribute("class",e.fClass)):i.style.fontFamily=e.fFamily,t.appendChild(i),n=i}else{var s=new OffscreenCanvas(500,500).getContext("2d");s.font=a.style+" "+a.weight+" 100px "+e.fFamily,n=s}return{measureText:function(e){return"svg"===r?(n.textContent=e,n.getComputedTextLength()):n.measureText(e).width}}}function d(e){var t=0,n=e.charCodeAt(0);if(n>=55296&&n<=56319){var r=e.charCodeAt(1);r>=56320&&r<=57343&&(t=1024*(n-55296)+r-56320+65536)}return t}function m(e){var t=d(e);return t>=u&&t<=c}var g=function(){this.fonts=[],this.chars=null,this.typekitLoaded=0,this.isLoaded=!1,this._warned=!1,this.initTime=Date.now(),this.setIsLoadedBinded=this.setIsLoaded.bind(this),this.checkLoadedFontsBinded=this.checkLoadedFonts.bind(this)};g.isModifier=function(e,t){var n=e.toString(16)+t.toString(16);return-1!==h.indexOf(n)},g.isZeroWidthJoiner=function(e){return e===l},g.isFlagEmoji=function(e){return m(e.substr(0,2))&&m(e.substr(2,2))},g.isRegionalCode=m,g.isCombinedCharacter=function(e){return-1!==n.indexOf(e)},g.isRegionalFlag=function(e,t){var n=d(e.substr(t,2));if(n!==r)return!1;var o=0;for(t+=2;o<5;){if((n=d(e.substr(t,2)))<i||n>s)return!1;o+=1,t+=2}return d(e.substr(t,2))===a},g.isVariationSelector=function(e){return e===o},g.BLACK_FLAG_CODE_POINT=r;var y={addChars:function(e){if(e){var t;this.chars||(this.chars=[]);var n,r,a=e.length,i=this.chars.length;for(t=0;t<a;t+=1){for(n=0,r=!1;n<i;)this.chars[n].style===e[t].style&&this.chars[n].fFamily===e[t].fFamily&&this.chars[n].ch===e[t].ch&&(r=!0),n+=1;r||(this.chars.push(e[t]),i+=1)}}},addFonts:function(e,t){if(e){if(this.chars)return this.isLoaded=!0,void(this.fonts=e.list);if(!document.body)return this.isLoaded=!0,e.list.forEach((function(e){e.helper=f(e),e.cache={}})),void(this.fonts=e.list);var n,r=e.list,a=r.length,i=a;for(n=0;n<a;n+=1){var s,o,l=!0;if(r[n].loaded=!1,r[n].monoCase=p(r[n].fFamily,"monospace"),r[n].sansCase=p(r[n].fFamily,"sans-serif"),r[n].fPath){if("p"===r[n].fOrigin||3===r[n].origin){if((s=document.querySelectorAll('style[f-forigin="p"][f-family="'+r[n].fFamily+'"], style[f-origin="3"][f-family="'+r[n].fFamily+'"]')).length>0&&(l=!1),l){var u=createTag("style");u.setAttribute("f-forigin",r[n].fOrigin),u.setAttribute("f-origin",r[n].origin),u.setAttribute("f-family",r[n].fFamily),u.type="text/css",u.innerText="@font-face {font-family: "+r[n].fFamily+"; font-style: normal; src: url('"+r[n].fPath+"');}",t.appendChild(u)}}else if("g"===r[n].fOrigin||1===r[n].origin){for(s=document.querySelectorAll('link[f-forigin="g"], link[f-origin="1"]'),o=0;o<s.length;o+=1)-1!==s[o].href.indexOf(r[n].fPath)&&(l=!1);if(l){var c=createTag("link");c.setAttribute("f-forigin",r[n].fOrigin),c.setAttribute("f-origin",r[n].origin),c.type="text/css",c.rel="stylesheet",c.href=r[n].fPath,document.body.appendChild(c)}}else if("t"===r[n].fOrigin||2===r[n].origin){for(s=document.querySelectorAll('script[f-forigin="t"], script[f-origin="2"]'),o=0;o<s.length;o+=1)r[n].fPath===s[o].src&&(l=!1);if(l){var h=createTag("link");h.setAttribute("f-forigin",r[n].fOrigin),h.setAttribute("f-origin",r[n].origin),h.setAttribute("rel","stylesheet"),h.setAttribute("href",r[n].fPath),t.appendChild(h)}}}else r[n].loaded=!0,i-=1;r[n].helper=f(r[n],t),r[n].cache={},this.fonts.push(r[n])}0===i?this.isLoaded=!0:setTimeout(this.checkLoadedFonts.bind(this),100)}else this.isLoaded=!0},getCharData:function(e,n,r){for(var a=0,i=this.chars.length;a<i;){if(this.chars[a].ch===e&&this.chars[a].style===n&&this.chars[a].fFamily===r)return this.chars[a];a+=1}return("string"==typeof e&&13!==e.charCodeAt(0)||!e)&&console&&console.warn&&!this._warned&&(this._warned=!0,console.warn("Missing character from exported characters list: ",e,n,r)),t},getFontByName:function(e){for(var t=0,n=this.fonts.length;t<n;){if(this.fonts[t].fName===e)return this.fonts[t];t+=1}return this.fonts[0]},measureText:function(e,t,n){var r=this.getFontByName(t),a=e;if(!r.cache[a]){var i=r.helper;if(" "===e){var s=i.measureText("|"+e+"|"),o=i.measureText("||");r.cache[a]=(s-o)/100}else r.cache[a]=i.measureText(e)/100}return r.cache[a]*n},checkLoadedFonts:function(){var t,n,r,a=this.fonts.length,i=a;for(t=0;t<a;t+=1)this.fonts[t].loaded?i-=1:"n"===this.fonts[t].fOrigin||0===this.fonts[t].origin?this.fonts[t].loaded=!0:(n=this.fonts[t].monoCase.node,r=this.fonts[t].monoCase.w,n.offsetWidth!==r?(i-=1,this.fonts[t].loaded=!0):(n=this.fonts[t].sansCase.node,r=this.fonts[t].sansCase.w,n.offsetWidth!==r&&(i-=1,this.fonts[t].loaded=!0)),this.fonts[t].loaded&&(this.fonts[t].sansCase.parent.parentNode.removeChild(this.fonts[t].sansCase.parent),this.fonts[t].monoCase.parent.parentNode.removeChild(this.fonts[t].monoCase.parent)));0!==i&&Date.now()-this.initTime<e?setTimeout(this.checkLoadedFontsBinded,20):setTimeout(this.setIsLoadedBinded,10)},setIsLoaded:function(){this.isLoaded=!0}};return g.prototype=y,g}();function SlotManager(e){this.animationData=e}function slotFactory(e){return new SlotManager(e)}function RenderableElement(){}SlotManager.prototype.getProp=function(e){return this.animationData.slots&&this.animationData.slots[e.sid]?Object.assign(e,this.animationData.slots[e.sid].p):e},RenderableElement.prototype={initRenderable:function(){this.isInRange=!1,this.hidden=!1,this.isTransparent=!1,this.renderableComponents=[]},addRenderableComponent:function(e){-1===this.renderableComponents.indexOf(e)&&this.renderableComponents.push(e)},removeRenderableComponent:function(e){-1!==this.renderableComponents.indexOf(e)&&this.renderableComponents.splice(this.renderableComponents.indexOf(e),1)},prepareRenderableFrame:function(e){this.checkLayerLimits(e)},checkTransparency:function(){this.finalTransform.mProp.o.v<=0?!this.isTransparent&&this.globalData.renderConfig.hideOnTransparent&&(this.isTransparent=!0,this.hide()):this.isTransparent&&(this.isTransparent=!1,this.show())},checkLayerLimits:function(e){this.data.ip-this.data.st<=e&&this.data.op-this.data.st>e?!0!==this.isInRange&&(this.globalData._mdf=!0,this._mdf=!0,this.isInRange=!0,this.show()):!1!==this.isInRange&&(this.globalData._mdf=!0,this.isInRange=!1,this.hide())},renderRenderable:function(){var e,t=this.renderableComponents.length;for(e=0;e<t;e+=1)this.renderableComponents[e].renderFrame(this._isFirstFrame)},sourceRectAtTime:function(){return{top:0,left:0,width:100,height:100}},getLayerSize:function(){return 5===this.data.ty?{w:this.data.textData.width,h:this.data.textData.height}:{w:this.data.width,h:this.data.height}}};var getBlendMode=(blendModeEnums={0:"source-over",1:"multiply",2:"screen",3:"overlay",4:"darken",5:"lighten",6:"color-dodge",7:"color-burn",8:"hard-light",9:"soft-light",10:"difference",11:"exclusion",12:"hue",13:"saturation",14:"color",15:"luminosity"},function(e){return blendModeEnums[e]||""}),blendModeEnums;function SliderEffect(e,t,n){this.p=PropertyFactory.getProp(t,e.v,0,0,n)}function AngleEffect(e,t,n){this.p=PropertyFactory.getProp(t,e.v,0,0,n)}function ColorEffect(e,t,n){this.p=PropertyFactory.getProp(t,e.v,1,0,n)}function PointEffect(e,t,n){this.p=PropertyFactory.getProp(t,e.v,1,0,n)}function LayerIndexEffect(e,t,n){this.p=PropertyFactory.getProp(t,e.v,0,0,n)}function MaskIndexEffect(e,t,n){this.p=PropertyFactory.getProp(t,e.v,0,0,n)}function CheckboxEffect(e,t,n){this.p=PropertyFactory.getProp(t,e.v,0,0,n)}function NoValueEffect(){this.p={}}function EffectsManager(e,t){var n,r=e.ef||[];this.effectElements=[];var a,i=r.length;for(n=0;n<i;n+=1)a=new GroupEffect(r[n],t),this.effectElements.push(a)}function GroupEffect(e,t){this.init(e,t)}function BaseElement(){}function FrameElement(){}function FootageElement(e,t,n){this.initFrame(),this.initRenderable(),this.assetData=t.getAssetData(e.refId),this.footageData=t.imageLoader.getAsset(this.assetData),this.initBaseData(e,t,n)}function AudioElement(e,t,n){this.initFrame(),this.initRenderable(),this.assetData=t.getAssetData(e.refId),this.initBaseData(e,t,n),this._isPlaying=!1,this._canPlay=!1;var r=this.globalData.getAssetsPath(this.assetData);this.audio=this.globalData.audioController.createAudio(r),this._currentTime=0,this.globalData.audioController.addAudio(this),this._volumeMultiplier=1,this._volume=1,this._previousVolume=null,this.tm=e.tm?PropertyFactory.getProp(this,e.tm,0,t.frameRate,this):{_placeholder:!0},this.lv=PropertyFactory.getProp(this,e.au&&e.au.lv?e.au.lv:{k:[100]},1,.01,this)}function BaseRenderer(){}extendPrototype([DynamicPropertyContainer],GroupEffect),GroupEffect.prototype.getValue=GroupEffect.prototype.iterateDynamicProperties,GroupEffect.prototype.init=function(e,t){var n;this.data=e,this.effectElements=[],this.initDynamicPropertyContainer(t);var r,a=this.data.ef.length,i=this.data.ef;for(n=0;n<a;n+=1){switch(r=null,i[n].ty){case 0:r=new SliderEffect(i[n],t,this);break;case 1:r=new AngleEffect(i[n],t,this);break;case 2:r=new ColorEffect(i[n],t,this);break;case 3:r=new PointEffect(i[n],t,this);break;case 4:case 7:r=new CheckboxEffect(i[n],t,this);break;case 10:r=new LayerIndexEffect(i[n],t,this);break;case 11:r=new MaskIndexEffect(i[n],t,this);break;case 5:r=new EffectsManager(i[n],t,this);break;default:r=new NoValueEffect(i[n],t,this)}r&&this.effectElements.push(r)}},BaseElement.prototype={checkMasks:function(){if(!this.data.hasMask)return!1;for(var e=0,t=this.data.masksProperties.length;e<t;){if("n"!==this.data.masksProperties[e].mode&&!1!==this.data.masksProperties[e].cl)return!0;e+=1}return!1},initExpressions:function(){var e=getExpressionInterfaces();if(e){var t=e("layer"),n=e("effects"),r=e("shape"),a=e("text"),i=e("comp");this.layerInterface=t(this),this.data.hasMask&&this.maskManager&&this.layerInterface.registerMaskInterface(this.maskManager);var s=n.createEffectsInterface(this,this.layerInterface);this.layerInterface.registerEffectsInterface(s),0===this.data.ty||this.data.xt?this.compInterface=i(this):4===this.data.ty?(this.layerInterface.shapeInterface=r(this.shapesData,this.itemsData,this.layerInterface),this.layerInterface.content=this.layerInterface.shapeInterface):5===this.data.ty&&(this.layerInterface.textInterface=a(this),this.layerInterface.text=this.layerInterface.textInterface)}},setBlendMode:function(){var e=getBlendMode(this.data.bm);(this.baseElement||this.layerElement).style["mix-blend-mode"]=e},initBaseData:function(e,t,n){this.globalData=t,this.comp=n,this.data=e,this.layerId=createElementID(),this.data.sr||(this.data.sr=1),this.effectsManager=new EffectsManager(this.data,this,this.dynamicProperties)},getType:function(){return this.type},sourceRectAtTime:function(){}},FrameElement.prototype={initFrame:function(){this._isFirstFrame=!1,this.dynamicProperties=[],this._mdf=!1},prepareProperties:function(e,t){var n,r=this.dynamicProperties.length;for(n=0;n<r;n+=1)(t||this._isParent&&"transform"===this.dynamicProperties[n].propType)&&(this.dynamicProperties[n].getValue(),this.dynamicProperties[n]._mdf&&(this.globalData._mdf=!0,this._mdf=!0))},addDynamicProperty:function(e){-1===this.dynamicProperties.indexOf(e)&&this.dynamicProperties.push(e)}},FootageElement.prototype.prepareFrame=function(){},extendPrototype([RenderableElement,BaseElement,FrameElement],FootageElement),FootageElement.prototype.getBaseElement=function(){return null},FootageElement.prototype.renderFrame=function(){},FootageElement.prototype.destroy=function(){},FootageElement.prototype.initExpressions=function(){var e=getExpressionInterfaces();if(e){var t=e("footage");this.layerInterface=t(this)}},FootageElement.prototype.getFootageData=function(){return this.footageData},AudioElement.prototype.prepareFrame=function(e){if(this.prepareRenderableFrame(e,!0),this.prepareProperties(e,!0),this.tm._placeholder)this._currentTime=e/this.data.sr;else{var t=this.tm.v;this._currentTime=t}this._volume=this.lv.v[0];var n=this._volume*this._volumeMultiplier;this._previousVolume!==n&&(this._previousVolume=n,this.audio.volume(n))},extendPrototype([RenderableElement,BaseElement,FrameElement],AudioElement),AudioElement.prototype.renderFrame=function(){this.isInRange&&this._canPlay&&(this._isPlaying?(!this.audio.playing()||Math.abs(this._currentTime/this.globalData.frameRate-this.audio.seek())>.1)&&this.audio.seek(this._currentTime/this.globalData.frameRate):(this.audio.play(),this.audio.seek(this._currentTime/this.globalData.frameRate),this._isPlaying=!0))},AudioElement.prototype.show=function(){},AudioElement.prototype.hide=function(){this.audio.pause(),this._isPlaying=!1},AudioElement.prototype.pause=function(){this.audio.pause(),this._isPlaying=!1,this._canPlay=!1},AudioElement.prototype.resume=function(){this._canPlay=!0},AudioElement.prototype.setRate=function(e){this.audio.rate(e)},AudioElement.prototype.volume=function(e){this._volumeMultiplier=e,this._previousVolume=e*this._volume,this.audio.volume(this._previousVolume)},AudioElement.prototype.getBaseElement=function(){return null},AudioElement.prototype.destroy=function(){},AudioElement.prototype.sourceRectAtTime=function(){},AudioElement.prototype.initExpressions=function(){},BaseRenderer.prototype.checkLayers=function(e){var t,n,r=this.layers.length;for(this.completeLayers=!0,t=r-1;t>=0;t-=1)this.elements[t]||(n=this.layers[t]).ip-n.st<=e-this.layers[t].st&&n.op-n.st>e-this.layers[t].st&&this.buildItem(t),this.completeLayers=!!this.elements[t]&&this.completeLayers;this.checkPendingElements()},BaseRenderer.prototype.createItem=function(e){switch(e.ty){case 2:return this.createImage(e);case 0:return this.createComp(e);case 1:return this.createSolid(e);case 3:default:return this.createNull(e);case 4:return this.createShape(e);case 5:return this.createText(e);case 6:return this.createAudio(e);case 13:return this.createCamera(e);case 15:return this.createFootage(e)}},BaseRenderer.prototype.createCamera=function(){throw new Error("You're using a 3d camera. Try the html renderer.")},BaseRenderer.prototype.createAudio=function(e){return new AudioElement(e,this.globalData,this)},BaseRenderer.prototype.createFootage=function(e){return new FootageElement(e,this.globalData,this)},BaseRenderer.prototype.buildAllItems=function(){var e,t=this.layers.length;for(e=0;e<t;e+=1)this.buildItem(e);this.checkPendingElements()},BaseRenderer.prototype.includeLayers=function(e){var t;this.completeLayers=!1;var n,r=e.length,a=this.layers.length;for(t=0;t<r;t+=1)for(n=0;n<a;){if(this.layers[n].id===e[t].id){this.layers[n]=e[t];break}n+=1}},BaseRenderer.prototype.setProjectInterface=function(e){this.globalData.projectInterface=e},BaseRenderer.prototype.initItems=function(){this.globalData.progressiveLoad||this.buildAllItems()},BaseRenderer.prototype.buildElementParenting=function(e,t,n){for(var r=this.elements,a=this.layers,i=0,s=a.length;i<s;)a[i].ind==t&&(r[i]&&!0!==r[i]?(n.push(r[i]),r[i].setAsParent(),void 0!==a[i].parent?this.buildElementParenting(e,a[i].parent,n):e.setHierarchy(n)):(this.buildItem(i),this.addPendingElement(e))),i+=1},BaseRenderer.prototype.addPendingElement=function(e){this.pendingElements.push(e)},BaseRenderer.prototype.searchExtraCompositions=function(e){var t,n=e.length;for(t=0;t<n;t+=1)if(e[t].xt){var r=this.createComp(e[t]);r.initExpressions(),this.globalData.projectInterface.registerComposition(r)}},BaseRenderer.prototype.getElementById=function(e){var t,n=this.elements.length;for(t=0;t<n;t+=1)if(this.elements[t].data.ind===e)return this.elements[t];return null},BaseRenderer.prototype.getElementByPath=function(e){var t,n=e.shift();if("number"==typeof n)t=this.elements[n];else{var r,a=this.elements.length;for(r=0;r<a;r+=1)if(this.elements[r].data.nm===n){t=this.elements[r];break}}return 0===e.length?t:t.getElementByPath(e)},BaseRenderer.prototype.setupGlobalData=function(e,t){this.globalData.fontManager=new FontManager,this.globalData.slotManager=slotFactory(e),this.globalData.fontManager.addChars(e.chars),this.globalData.fontManager.addFonts(e.fonts,t),this.globalData.getAssetData=this.animationItem.getAssetData.bind(this.animationItem),this.globalData.getAssetsPath=this.animationItem.getAssetsPath.bind(this.animationItem),this.globalData.imageLoader=this.animationItem.imagePreloader,this.globalData.audioController=this.animationItem.audioController,this.globalData.frameId=0,this.globalData.frameRate=e.fr,this.globalData.nm=e.nm,this.globalData.compSize={w:e.w,h:e.h}};var effectTypes={TRANSFORM_EFFECT:"transformEFfect"};function TransformElement(){}function MaskElement(e,t,n){this.data=e,this.element=t,this.globalData=n,this.storedData=[],this.masksProperties=this.data.masksProperties||[],this.maskElement=null;var r,a,i=this.globalData.defs,s=this.masksProperties?this.masksProperties.length:0;this.viewData=createSizedArray(s),this.solidPath="";var o,l,u,c,h,p,f=this.masksProperties,d=0,m=[],g=createElementID(),y="clipPath",v="clip-path";for(r=0;r<s;r+=1)if(("a"!==f[r].mode&&"n"!==f[r].mode||f[r].inv||100!==f[r].o.k||f[r].o.x)&&(y="mask",v="mask"),"s"!==f[r].mode&&"i"!==f[r].mode||0!==d?u=null:((u=createNS("rect")).setAttribute("fill","#ffffff"),u.setAttribute("width",this.element.comp.data.w||0),u.setAttribute("height",this.element.comp.data.h||0),m.push(u)),a=createNS("path"),"n"===f[r].mode)this.viewData[r]={op:PropertyFactory.getProp(this.element,f[r].o,0,.01,this.element),prop:ShapePropertyFactory.getShapeProp(this.element,f[r],3),elem:a,lastPath:""},i.appendChild(a);else{var b;if(d+=1,a.setAttribute("fill","s"===f[r].mode?"#000000":"#ffffff"),a.setAttribute("clip-rule","nonzero"),0!==f[r].x.k?(y="mask",v="mask",p=PropertyFactory.getProp(this.element,f[r].x,0,null,this.element),b=createElementID(),(c=createNS("filter")).setAttribute("id",b),(h=createNS("feMorphology")).setAttribute("operator","erode"),h.setAttribute("in","SourceGraphic"),h.setAttribute("radius","0"),c.appendChild(h),i.appendChild(c),a.setAttribute("stroke","s"===f[r].mode?"#000000":"#ffffff")):(h=null,p=null),this.storedData[r]={elem:a,x:p,expan:h,lastPath:"",lastOperator:"",filterId:b,lastRadius:0},"i"===f[r].mode){l=m.length;var k=createNS("g");for(o=0;o<l;o+=1)k.appendChild(m[o]);var x=createNS("mask");x.setAttribute("mask-type","alpha"),x.setAttribute("id",g+"_"+d),x.appendChild(a),i.appendChild(x),k.setAttribute("mask","url("+getLocationHref()+"#"+g+"_"+d+")"),m.length=0,m.push(k)}else m.push(a);f[r].inv&&!this.solidPath&&(this.solidPath=this.createLayerSolidPath()),this.viewData[r]={elem:a,lastPath:"",op:PropertyFactory.getProp(this.element,f[r].o,0,.01,this.element),prop:ShapePropertyFactory.getShapeProp(this.element,f[r],3),invRect:u},this.viewData[r].prop.k||this.drawPath(f[r],this.viewData[r].prop.v,this.viewData[r])}for(this.maskElement=createNS(y),s=m.length,r=0;r<s;r+=1)this.maskElement.appendChild(m[r]);d>0&&(this.maskElement.setAttribute("id",g),this.element.maskedElement.setAttribute(v,"url("+getLocationHref()+"#"+g+")"),i.appendChild(this.maskElement)),this.viewData.length&&this.element.addRenderableComponent(this)}TransformElement.prototype={initTransform:function(){var e=new Matrix;this.finalTransform={mProp:this.data.ks?TransformPropertyFactory.getTransformProperty(this,this.data.ks,this):{o:0},_matMdf:!1,_localMatMdf:!1,_opMdf:!1,mat:e,localMat:e,localOpacity:1},this.data.ao&&(this.finalTransform.mProp.autoOriented=!0),this.data.ty},renderTransform:function(){if(this.finalTransform._opMdf=this.finalTransform.mProp.o._mdf||this._isFirstFrame,this.finalTransform._matMdf=this.finalTransform.mProp._mdf||this._isFirstFrame,this.hierarchy){var e,t=this.finalTransform.mat,n=0,r=this.hierarchy.length;if(!this.finalTransform._matMdf)for(;n<r;){if(this.hierarchy[n].finalTransform.mProp._mdf){this.finalTransform._matMdf=!0;break}n+=1}if(this.finalTransform._matMdf)for(e=this.finalTransform.mProp.v.props,t.cloneFromProps(e),n=0;n<r;n+=1)t.multiply(this.hierarchy[n].finalTransform.mProp.v)}this.finalTransform._matMdf&&(this.finalTransform._localMatMdf=this.finalTransform._matMdf),this.finalTransform._opMdf&&(this.finalTransform.localOpacity=this.finalTransform.mProp.o.v)},renderLocalTransform:function(){if(this.localTransforms){var e=0,t=this.localTransforms.length;if(this.finalTransform._localMatMdf=this.finalTransform._matMdf,!this.finalTransform._localMatMdf||!this.finalTransform._opMdf)for(;e<t;)this.localTransforms[e]._mdf&&(this.finalTransform._localMatMdf=!0),this.localTransforms[e]._opMdf&&!this.finalTransform._opMdf&&(this.finalTransform.localOpacity=this.finalTransform.mProp.o.v,this.finalTransform._opMdf=!0),e+=1;if(this.finalTransform._localMatMdf){var n=this.finalTransform.localMat;for(this.localTransforms[0].matrix.clone(n),e=1;e<t;e+=1){var r=this.localTransforms[e].matrix;n.multiply(r)}n.multiply(this.finalTransform.mat)}if(this.finalTransform._opMdf){var a=this.finalTransform.localOpacity;for(e=0;e<t;e+=1)a*=.01*this.localTransforms[e].opacity;this.finalTransform.localOpacity=a}}},searchEffectTransforms:function(){if(this.renderableEffectsManager){var e=this.renderableEffectsManager.getEffects(effectTypes.TRANSFORM_EFFECT);if(e.length){this.localTransforms=[],this.finalTransform.localMat=new Matrix;var t=0,n=e.length;for(t=0;t<n;t+=1)this.localTransforms.push(e[t])}}},globalToLocal:function(e){var t=[];t.push(this.finalTransform);for(var n,r=!0,a=this.comp;r;)a.finalTransform?(a.data.hasMask&&t.splice(0,0,a.finalTransform),a=a.comp):r=!1;var i,s=t.length;for(n=0;n<s;n+=1)i=t[n].mat.applyToPointArray(0,0,0),e=[e[0]-i[0],e[1]-i[1],0];return e},mHelper:new Matrix},MaskElement.prototype.getMaskProperty=function(e){return this.viewData[e].prop},MaskElement.prototype.renderFrame=function(e){var t,n=this.element.finalTransform.mat,r=this.masksProperties.length;for(t=0;t<r;t+=1)if((this.viewData[t].prop._mdf||e)&&this.drawPath(this.masksProperties[t],this.viewData[t].prop.v,this.viewData[t]),(this.viewData[t].op._mdf||e)&&this.viewData[t].elem.setAttribute("fill-opacity",this.viewData[t].op.v),"n"!==this.masksProperties[t].mode&&(this.viewData[t].invRect&&(this.element.finalTransform.mProp._mdf||e)&&this.viewData[t].invRect.setAttribute("transform",n.getInverseMatrix().to2dCSS()),this.storedData[t].x&&(this.storedData[t].x._mdf||e))){var a=this.storedData[t].expan;this.storedData[t].x.v<0?("erode"!==this.storedData[t].lastOperator&&(this.storedData[t].lastOperator="erode",this.storedData[t].elem.setAttribute("filter","url("+getLocationHref()+"#"+this.storedData[t].filterId+")")),a.setAttribute("radius",-this.storedData[t].x.v)):("dilate"!==this.storedData[t].lastOperator&&(this.storedData[t].lastOperator="dilate",this.storedData[t].elem.setAttribute("filter",null)),this.storedData[t].elem.setAttribute("stroke-width",2*this.storedData[t].x.v))}},MaskElement.prototype.getMaskelement=function(){return this.maskElement},MaskElement.prototype.createLayerSolidPath=function(){var e="M0,0 ";return e+=" h"+this.globalData.compSize.w,e+=" v"+this.globalData.compSize.h,e+=" h-"+this.globalData.compSize.w,e+=" v-"+this.globalData.compSize.h+" "},MaskElement.prototype.drawPath=function(e,t,n){var r,a,i=" M"+t.v[0][0]+","+t.v[0][1];for(a=t._length,r=1;r<a;r+=1)i+=" C"+t.o[r-1][0]+","+t.o[r-1][1]+" "+t.i[r][0]+","+t.i[r][1]+" "+t.v[r][0]+","+t.v[r][1];if(t.c&&a>1&&(i+=" C"+t.o[r-1][0]+","+t.o[r-1][1]+" "+t.i[0][0]+","+t.i[0][1]+" "+t.v[0][0]+","+t.v[0][1]),n.lastPath!==i){var s="";n.elem&&(t.c&&(s=e.inv?this.solidPath+i:i),n.elem.setAttribute("d",s)),n.lastPath=i}},MaskElement.prototype.destroy=function(){this.element=null,this.globalData=null,this.maskElement=null,this.data=null,this.masksProperties=null};var filtersFactory=function(){var e={createFilter:function(e,t){var n=createNS("filter");return n.setAttribute("id",e),!0!==t&&(n.setAttribute("filterUnits","objectBoundingBox"),n.setAttribute("x","0%"),n.setAttribute("y","0%"),n.setAttribute("width","100%"),n.setAttribute("height","100%")),n},createAlphaToLuminanceFilter:function(){var e=createNS("feColorMatrix");return e.setAttribute("type","matrix"),e.setAttribute("color-interpolation-filters","sRGB"),e.setAttribute("values","0 0 0 1 0  0 0 0 1 0  0 0 0 1 0  0 0 0 1 1"),e}};return e}(),featureSupport=function(){var e={maskType:!0,svgLumaHidden:!0,offscreenCanvas:"undefined"!=typeof OffscreenCanvas};return(/MSIE 10/i.test(navigator.userAgent)||/MSIE 9/i.test(navigator.userAgent)||/rv:11.0/i.test(navigator.userAgent)||/Edge\/\d./i.test(navigator.userAgent))&&(e.maskType=!1),/firefox/i.test(navigator.userAgent)&&(e.svgLumaHidden=!1),e}(),registeredEffects$1={},idPrefix="filter_result_";function SVGEffects(e){var t,n,r="SourceGraphic",a=e.data.ef?e.data.ef.length:0,i=createElementID(),s=filtersFactory.createFilter(i,!0),o=0;for(this.filters=[],t=0;t<a;t+=1){n=null;var l=e.data.ef[t].ty;registeredEffects$1[l]&&(n=new(0,registeredEffects$1[l].effect)(s,e.effectsManager.effectElements[t],e,idPrefix+o,r),r=idPrefix+o,registeredEffects$1[l].countsAsEffect&&(o+=1)),n&&this.filters.push(n)}o&&(e.globalData.defs.appendChild(s),e.layerElement.setAttribute("filter","url("+getLocationHref()+"#"+i+")")),this.filters.length&&e.addRenderableComponent(this)}function registerEffect$1(e,t,n){registeredEffects$1[e]={effect:t,countsAsEffect:n}}function SVGBaseElement(){}function HierarchyElement(){}function RenderableDOMElement(){}function IImageElement(e,t,n){this.assetData=t.getAssetData(e.refId),this.assetData&&this.assetData.sid&&(this.assetData=t.slotManager.getProp(this.assetData)),this.initElement(e,t,n),this.sourceRect={top:0,left:0,width:this.assetData.w,height:this.assetData.h}}function ProcessedElement(e,t){this.elem=e,this.pos=t}function IShapeElement(){}SVGEffects.prototype.renderFrame=function(e){var t,n=this.filters.length;for(t=0;t<n;t+=1)this.filters[t].renderFrame(e)},SVGEffects.prototype.getEffects=function(e){var t,n=this.filters.length,r=[];for(t=0;t<n;t+=1)this.filters[t].type===e&&r.push(this.filters[t]);return r},SVGBaseElement.prototype={initRendererElement:function(){this.layerElement=createNS("g")},createContainerElements:function(){this.matteElement=createNS("g"),this.transformedElement=this.layerElement,this.maskedElement=this.layerElement,this._sizeChanged=!1;var e=null;if(this.data.td){this.matteMasks={};var t=createNS("g");t.setAttribute("id",this.layerId),t.appendChild(this.layerElement),e=t,this.globalData.defs.appendChild(t)}else this.data.tt?(this.matteElement.appendChild(this.layerElement),e=this.matteElement,this.baseElement=this.matteElement):this.baseElement=this.layerElement;if(this.data.ln&&this.layerElement.setAttribute("id",this.data.ln),this.data.cl&&this.layerElement.setAttribute("class",this.data.cl),0===this.data.ty&&!this.data.hd){var n=createNS("clipPath"),r=createNS("path");r.setAttribute("d","M0,0 L"+this.data.w+",0 L"+this.data.w+","+this.data.h+" L0,"+this.data.h+"z");var a=createElementID();if(n.setAttribute("id",a),n.appendChild(r),this.globalData.defs.appendChild(n),this.checkMasks()){var i=createNS("g");i.setAttribute("clip-path","url("+getLocationHref()+"#"+a+")"),i.appendChild(this.layerElement),this.transformedElement=i,e?e.appendChild(this.transformedElement):this.baseElement=this.transformedElement}else this.layerElement.setAttribute("clip-path","url("+getLocationHref()+"#"+a+")")}0!==this.data.bm&&this.setBlendMode()},renderElement:function(){this.finalTransform._localMatMdf&&this.transformedElement.setAttribute("transform",this.finalTransform.localMat.to2dCSS()),this.finalTransform._opMdf&&this.transformedElement.setAttribute("opacity",this.finalTransform.localOpacity)},destroyBaseElement:function(){this.layerElement=null,this.matteElement=null,this.maskManager.destroy()},getBaseElement:function(){return this.data.hd?null:this.baseElement},createRenderableComponents:function(){this.maskManager=new MaskElement(this.data,this,this.globalData),this.renderableEffectsManager=new SVGEffects(this),this.searchEffectTransforms()},getMatte:function(e){if(this.matteMasks||(this.matteMasks={}),!this.matteMasks[e]){var t,n,r,a,i=this.layerId+"_"+e;if(1===e||3===e){var s=createNS("mask");s.setAttribute("id",i),s.setAttribute("mask-type",3===e?"luminance":"alpha"),(r=createNS("use")).setAttributeNS("http://www.w3.org/1999/xlink","href","#"+this.layerId),s.appendChild(r),this.globalData.defs.appendChild(s),featureSupport.maskType||1!==e||(s.setAttribute("mask-type","luminance"),t=createElementID(),n=filtersFactory.createFilter(t),this.globalData.defs.appendChild(n),n.appendChild(filtersFactory.createAlphaToLuminanceFilter()),(a=createNS("g")).appendChild(r),s.appendChild(a),a.setAttribute("filter","url("+getLocationHref()+"#"+t+")"))}else if(2===e){var o=createNS("mask");o.setAttribute("id",i),o.setAttribute("mask-type","alpha");var l=createNS("g");o.appendChild(l),t=createElementID(),n=filtersFactory.createFilter(t);var u=createNS("feComponentTransfer");u.setAttribute("in","SourceGraphic"),n.appendChild(u);var c=createNS("feFuncA");c.setAttribute("type","table"),c.setAttribute("tableValues","1.0 0.0"),u.appendChild(c),this.globalData.defs.appendChild(n);var h=createNS("rect");h.setAttribute("width",this.comp.data.w),h.setAttribute("height",this.comp.data.h),h.setAttribute("x","0"),h.setAttribute("y","0"),h.setAttribute("fill","#ffffff"),h.setAttribute("opacity","0"),l.setAttribute("filter","url("+getLocationHref()+"#"+t+")"),l.appendChild(h),(r=createNS("use")).setAttributeNS("http://www.w3.org/1999/xlink","href","#"+this.layerId),l.appendChild(r),featureSupport.maskType||(o.setAttribute("mask-type","luminance"),n.appendChild(filtersFactory.createAlphaToLuminanceFilter()),a=createNS("g"),l.appendChild(h),a.appendChild(this.layerElement),l.appendChild(a)),this.globalData.defs.appendChild(o)}this.matteMasks[e]=i}return this.matteMasks[e]},setMatte:function(e){this.matteElement&&this.matteElement.setAttribute("mask","url("+getLocationHref()+"#"+e+")")}},HierarchyElement.prototype={initHierarchy:function(){this.hierarchy=[],this._isParent=!1,this.checkParenting()},setHierarchy:function(e){this.hierarchy=e},setAsParent:function(){this._isParent=!0},checkParenting:function(){void 0!==this.data.parent&&this.comp.buildElementParenting(this,this.data.parent,[])}},extendPrototype([RenderableElement,createProxyFunction({initElement:function(e,t,n){this.initFrame(),this.initBaseData(e,t,n),this.initTransform(e,t,n),this.initHierarchy(),this.initRenderable(),this.initRendererElement(),this.createContainerElements(),this.createRenderableComponents(),this.createContent(),this.hide()},hide:function(){this.hidden||this.isInRange&&!this.isTransparent||((this.baseElement||this.layerElement).style.display="none",this.hidden=!0)},show:function(){this.isInRange&&!this.isTransparent&&(this.data.hd||((this.baseElement||this.layerElement).style.display="block"),this.hidden=!1,this._isFirstFrame=!0)},renderFrame:function(){this.data.hd||this.hidden||(this.renderTransform(),this.renderRenderable(),this.renderLocalTransform(),this.renderElement(),this.renderInnerContent(),this._isFirstFrame&&(this._isFirstFrame=!1))},renderInnerContent:function(){},prepareFrame:function(e){this._mdf=!1,this.prepareRenderableFrame(e),this.prepareProperties(e,this.isInRange),this.checkTransparency()},destroy:function(){this.innerElem=null,this.destroyBaseElement()}})],RenderableDOMElement),extendPrototype([BaseElement,TransformElement,SVGBaseElement,HierarchyElement,FrameElement,RenderableDOMElement],IImageElement),IImageElement.prototype.createContent=function(){var e=this.globalData.getAssetsPath(this.assetData);this.innerElem=createNS("image"),this.innerElem.setAttribute("width",this.assetData.w+"px"),this.innerElem.setAttribute("height",this.assetData.h+"px"),this.innerElem.setAttribute("preserveAspectRatio",this.assetData.pr||this.globalData.renderConfig.imagePreserveAspectRatio),this.innerElem.setAttributeNS("http://www.w3.org/1999/xlink","href",e),this.layerElement.appendChild(this.innerElem)},IImageElement.prototype.sourceRectAtTime=function(){return this.sourceRect},IShapeElement.prototype={addShapeToModifiers:function(e){var t,n=this.shapeModifiers.length;for(t=0;t<n;t+=1)this.shapeModifiers[t].addShape(e)},isShapeInAnimatedModifiers:function(e){for(var t=this.shapeModifiers.length;0<t;)if(this.shapeModifiers[0].isAnimatedWithShape(e))return!0;return!1},renderModifiers:function(){if(this.shapeModifiers.length){var e,t=this.shapes.length;for(e=0;e<t;e+=1)this.shapes[e].sh.reset();for(e=(t=this.shapeModifiers.length)-1;e>=0&&!this.shapeModifiers[e].processShapes(this._isFirstFrame);e-=1);}},searchProcessedElement:function(e){for(var t=this.processedElements,n=0,r=t.length;n<r;){if(t[n].elem===e)return t[n].pos;n+=1}return 0},addProcessedElement:function(e,t){for(var n=this.processedElements,r=n.length;r;)if(n[r-=1].elem===e)return void(n[r].pos=t);n.push(new ProcessedElement(e,t))},prepareFrame:function(e){this.prepareRenderableFrame(e),this.prepareProperties(e,this.isInRange)}};var lineCapEnum={1:"butt",2:"round",3:"square"},lineJoinEnum={1:"miter",2:"round",3:"bevel"};function SVGShapeData(e,t,n){this.caches=[],this.styles=[],this.transformers=e,this.lStr="",this.sh=n,this.lvl=t,this._isAnimated=!!n.k;for(var r=0,a=e.length;r<a;){if(e[r].mProps.dynamicProperties.length){this._isAnimated=!0;break}r+=1}}function SVGStyleData(e,t){this.data=e,this.type=e.ty,this.d="",this.lvl=t,this._mdf=!1,this.closed=!0===e.hd,this.pElem=createNS("path"),this.msElem=null}function DashProperty(e,t,n,r){var a;this.elem=e,this.frameId=-1,this.dataProps=createSizedArray(t.length),this.renderer=n,this.k=!1,this.dashStr="",this.dashArray=createTypedArray("float32",t.length?t.length-1:0),this.dashoffset=createTypedArray("float32",1),this.initDynamicPropertyContainer(r);var i,s=t.length||0;for(a=0;a<s;a+=1)i=PropertyFactory.getProp(e,t[a].v,0,0,this),this.k=i.k||this.k,this.dataProps[a]={n:t[a].n,p:i};this.k||this.getValue(!0),this._isAnimated=this.k}function SVGStrokeStyleData(e,t,n){this.initDynamicPropertyContainer(e),this.getValue=this.iterateDynamicProperties,this.o=PropertyFactory.getProp(e,t.o,0,.01,this),this.w=PropertyFactory.getProp(e,t.w,0,null,this),this.d=new DashProperty(e,t.d||{},"svg",this),this.c=PropertyFactory.getProp(e,t.c,1,255,this),this.style=n,this._isAnimated=!!this._isAnimated}function SVGFillStyleData(e,t,n){this.initDynamicPropertyContainer(e),this.getValue=this.iterateDynamicProperties,this.o=PropertyFactory.getProp(e,t.o,0,.01,this),this.c=PropertyFactory.getProp(e,t.c,1,255,this),this.style=n}function SVGNoStyleData(e,t,n){this.initDynamicPropertyContainer(e),this.getValue=this.iterateDynamicProperties,this.style=n}function GradientProperty(e,t,n){this.data=t,this.c=createTypedArray("uint8c",4*t.p);var r=t.k.k[0].s?t.k.k[0].s.length-4*t.p:t.k.k.length-4*t.p;this.o=createTypedArray("float32",r),this._cmdf=!1,this._omdf=!1,this._collapsable=this.checkCollapsable(),this._hasOpacity=r,this.initDynamicPropertyContainer(n),this.prop=PropertyFactory.getProp(e,t.k,1,null,this),this.k=this.prop.k,this.getValue(!0)}function SVGGradientFillStyleData(e,t,n){this.initDynamicPropertyContainer(e),this.getValue=this.iterateDynamicProperties,this.initGradientData(e,t,n)}function SVGGradientStrokeStyleData(e,t,n){this.initDynamicPropertyContainer(e),this.getValue=this.iterateDynamicProperties,this.w=PropertyFactory.getProp(e,t.w,0,null,this),this.d=new DashProperty(e,t.d||{},"svg",this),this.initGradientData(e,t,n),this._isAnimated=!!this._isAnimated}function ShapeGroupData(){this.it=[],this.prevViewData=[],this.gr=createNS("g")}function SVGTransformData(e,t,n){this.transform={mProps:e,op:t,container:n},this.elements=[],this._isAnimated=this.transform.mProps.dynamicProperties.length||this.transform.op.effectsSequence.length}SVGShapeData.prototype.setAsAnimated=function(){this._isAnimated=!0},SVGStyleData.prototype.reset=function(){this.d="",this._mdf=!1},DashProperty.prototype.getValue=function(e){if((this.elem.globalData.frameId!==this.frameId||e)&&(this.frameId=this.elem.globalData.frameId,this.iterateDynamicProperties(),this._mdf=this._mdf||e,this._mdf)){var t=0,n=this.dataProps.length;for("svg"===this.renderer&&(this.dashStr=""),t=0;t<n;t+=1)"o"!==this.dataProps[t].n?"svg"===this.renderer?this.dashStr+=" "+this.dataProps[t].p.v:this.dashArray[t]=this.dataProps[t].p.v:this.dashoffset[0]=this.dataProps[t].p.v}},extendPrototype([DynamicPropertyContainer],DashProperty),extendPrototype([DynamicPropertyContainer],SVGStrokeStyleData),extendPrototype([DynamicPropertyContainer],SVGFillStyleData),extendPrototype([DynamicPropertyContainer],SVGNoStyleData),GradientProperty.prototype.comparePoints=function(e,t){for(var n=0,r=this.o.length/2;n<r;){if(Math.abs(e[4*n]-e[4*t+2*n])>.01)return!1;n+=1}return!0},GradientProperty.prototype.checkCollapsable=function(){if(this.o.length/2!=this.c.length/4)return!1;if(this.data.k.k[0].s)for(var e=0,t=this.data.k.k.length;e<t;){if(!this.comparePoints(this.data.k.k[e].s,this.data.p))return!1;e+=1}else if(!this.comparePoints(this.data.k.k,this.data.p))return!1;return!0},GradientProperty.prototype.getValue=function(e){if(this.prop.getValue(),this._mdf=!1,this._cmdf=!1,this._omdf=!1,this.prop._mdf||e){var t,n,r,a=4*this.data.p;for(t=0;t<a;t+=1)n=t%4==0?100:255,r=Math.round(this.prop.v[t]*n),this.c[t]!==r&&(this.c[t]=r,this._cmdf=!e);if(this.o.length)for(a=this.prop.v.length,t=4*this.data.p;t<a;t+=1)n=t%2==0?100:1,r=t%2==0?Math.round(100*this.prop.v[t]):this.prop.v[t],this.o[t-4*this.data.p]!==r&&(this.o[t-4*this.data.p]=r,this._omdf=!e);this._mdf=!e}},extendPrototype([DynamicPropertyContainer],GradientProperty),SVGGradientFillStyleData.prototype.initGradientData=function(e,t,n){this.o=PropertyFactory.getProp(e,t.o,0,.01,this),this.s=PropertyFactory.getProp(e,t.s,1,null,this),this.e=PropertyFactory.getProp(e,t.e,1,null,this),this.h=PropertyFactory.getProp(e,t.h||{k:0},0,.01,this),this.a=PropertyFactory.getProp(e,t.a||{k:0},0,degToRads,this),this.g=new GradientProperty(e,t.g,this),this.style=n,this.stops=[],this.setGradientData(n.pElem,t),this.setGradientOpacity(t,n),this._isAnimated=!!this._isAnimated},SVGGradientFillStyleData.prototype.setGradientData=function(e,t){var n=createElementID(),r=createNS(1===t.t?"linearGradient":"radialGradient");r.setAttribute("id",n),r.setAttribute("spreadMethod","pad"),r.setAttribute("gradientUnits","userSpaceOnUse");var a,i,s,o=[];for(s=4*t.g.p,i=0;i<s;i+=4)a=createNS("stop"),r.appendChild(a),o.push(a);e.setAttribute("gf"===t.ty?"fill":"stroke","url("+getLocationHref()+"#"+n+")"),this.gf=r,this.cst=o},SVGGradientFillStyleData.prototype.setGradientOpacity=function(e,t){if(this.g._hasOpacity&&!this.g._collapsable){var n,r,a,i=createNS("mask"),s=createNS("path");i.appendChild(s);var o=createElementID(),l=createElementID();i.setAttribute("id",l);var u=createNS(1===e.t?"linearGradient":"radialGradient");u.setAttribute("id",o),u.setAttribute("spreadMethod","pad"),u.setAttribute("gradientUnits","userSpaceOnUse"),a=e.g.k.k[0].s?e.g.k.k[0].s.length:e.g.k.k.length;var c=this.stops;for(r=4*e.g.p;r<a;r+=2)(n=createNS("stop")).setAttribute("stop-color","rgb(255,255,255)"),u.appendChild(n),c.push(n);s.setAttribute("gf"===e.ty?"fill":"stroke","url("+getLocationHref()+"#"+o+")"),"gs"===e.ty&&(s.setAttribute("stroke-linecap",lineCapEnum[e.lc||2]),s.setAttribute("stroke-linejoin",lineJoinEnum[e.lj||2]),1===e.lj&&s.setAttribute("stroke-miterlimit",e.ml)),this.of=u,this.ms=i,this.ost=c,this.maskId=l,t.msElem=s}},extendPrototype([DynamicPropertyContainer],SVGGradientFillStyleData),extendPrototype([SVGGradientFillStyleData,DynamicPropertyContainer],SVGGradientStrokeStyleData);var buildShapeString=function(e,t,n,r){if(0===t)return"";var a,i=e.o,s=e.i,o=e.v,l=" M"+r.applyToPointStringified(o[0][0],o[0][1]);for(a=1;a<t;a+=1)l+=" C"+r.applyToPointStringified(i[a-1][0],i[a-1][1])+" "+r.applyToPointStringified(s[a][0],s[a][1])+" "+r.applyToPointStringified(o[a][0],o[a][1]);return n&&t&&(l+=" C"+r.applyToPointStringified(i[a-1][0],i[a-1][1])+" "+r.applyToPointStringified(s[0][0],s[0][1])+" "+r.applyToPointStringified(o[0][0],o[0][1]),l+="z"),l},SVGElementsRenderer=function(){var e=new Matrix,t=new Matrix;function n(e,t,n){(n||t.transform.op._mdf)&&t.transform.container.setAttribute("opacity",t.transform.op.v),(n||t.transform.mProps._mdf)&&t.transform.container.setAttribute("transform",t.transform.mProps.v.to2dCSS())}function r(){}function a(n,r,a){var i,s,o,l,u,c,h,p,f,d,m=r.styles.length,g=r.lvl;for(c=0;c<m;c+=1){if(l=r.sh._mdf||a,r.styles[c].lvl<g){for(p=t.reset(),f=g-r.styles[c].lvl,d=r.transformers.length-1;!l&&f>0;)l=r.transformers[d].mProps._mdf||l,f-=1,d-=1;if(l)for(f=g-r.styles[c].lvl,d=r.transformers.length-1;f>0;)p.multiply(r.transformers[d].mProps.v),f-=1,d-=1}else p=e;if(s=(h=r.sh.paths)._length,l){for(o="",i=0;i<s;i+=1)(u=h.shapes[i])&&u._length&&(o+=buildShapeString(u,u._length,u.c,p));r.caches[c]=o}else o=r.caches[c];r.styles[c].d+=!0===n.hd?"":o,r.styles[c]._mdf=l||r.styles[c]._mdf}}function i(e,t,n){var r=t.style;(t.c._mdf||n)&&r.pElem.setAttribute("fill","rgb("+bmFloor(t.c.v[0])+","+bmFloor(t.c.v[1])+","+bmFloor(t.c.v[2])+")"),(t.o._mdf||n)&&r.pElem.setAttribute("fill-opacity",t.o.v)}function s(e,t,n){o(e,t,n),l(0,t,n)}function o(e,t,n){var r,a,i,s,o,l=t.gf,u=t.g._hasOpacity,c=t.s.v,h=t.e.v;if(t.o._mdf||n){var p="gf"===e.ty?"fill-opacity":"stroke-opacity";t.style.pElem.setAttribute(p,t.o.v)}if(t.s._mdf||n){var f=1===e.t?"x1":"cx",d="x1"===f?"y1":"cy";l.setAttribute(f,c[0]),l.setAttribute(d,c[1]),u&&!t.g._collapsable&&(t.of.setAttribute(f,c[0]),t.of.setAttribute(d,c[1]))}if(t.g._cmdf||n){r=t.cst;var m=t.g.c;for(i=r.length,a=0;a<i;a+=1)(s=r[a]).setAttribute("offset",m[4*a]+"%"),s.setAttribute("stop-color","rgb("+m[4*a+1]+","+m[4*a+2]+","+m[4*a+3]+")")}if(u&&(t.g._omdf||n)){var g=t.g.o;for(i=(r=t.g._collapsable?t.cst:t.ost).length,a=0;a<i;a+=1)s=r[a],t.g._collapsable||s.setAttribute("offset",g[2*a]+"%"),s.setAttribute("stop-opacity",g[2*a+1])}if(1===e.t)(t.e._mdf||n)&&(l.setAttribute("x2",h[0]),l.setAttribute("y2",h[1]),u&&!t.g._collapsable&&(t.of.setAttribute("x2",h[0]),t.of.setAttribute("y2",h[1])));else if((t.s._mdf||t.e._mdf||n)&&(o=Math.sqrt(Math.pow(c[0]-h[0],2)+Math.pow(c[1]-h[1],2)),l.setAttribute("r",o),u&&!t.g._collapsable&&t.of.setAttribute("r",o)),t.e._mdf||t.h._mdf||t.a._mdf||n){o||(o=Math.sqrt(Math.pow(c[0]-h[0],2)+Math.pow(c[1]-h[1],2)));var y=Math.atan2(h[1]-c[1],h[0]-c[0]),v=t.h.v;v>=1?v=.99:v<=-1&&(v=-.99);var b=o*v,k=Math.cos(y+t.a.v)*b+c[0],x=Math.sin(y+t.a.v)*b+c[1];l.setAttribute("fx",k),l.setAttribute("fy",x),u&&!t.g._collapsable&&(t.of.setAttribute("fx",k),t.of.setAttribute("fy",x))}}function l(e,t,n){var r=t.style,a=t.d;a&&(a._mdf||n)&&a.dashStr&&(r.pElem.setAttribute("stroke-dasharray",a.dashStr),r.pElem.setAttribute("stroke-dashoffset",a.dashoffset[0])),t.c&&(t.c._mdf||n)&&r.pElem.setAttribute("stroke","rgb("+bmFloor(t.c.v[0])+","+bmFloor(t.c.v[1])+","+bmFloor(t.c.v[2])+")"),(t.o._mdf||n)&&r.pElem.setAttribute("stroke-opacity",t.o.v),(t.w._mdf||n)&&(r.pElem.setAttribute("stroke-width",t.w.v),r.msElem&&r.msElem.setAttribute("stroke-width",t.w.v))}return{createRenderFunction:function(e){switch(e.ty){case"fl":return i;case"gf":return o;case"gs":return s;case"st":return l;case"sh":case"el":case"rc":case"sr":return a;case"tr":return n;case"no":return r;default:return null}}}}();function SVGShapeElement(e,t,n){this.shapes=[],this.shapesData=e.shapes,this.stylesList=[],this.shapeModifiers=[],this.itemsData=[],this.processedElements=[],this.animatedContents=[],this.initElement(e,t,n),this.prevViewData=[]}function LetterProps(e,t,n,r,a,i){this.o=e,this.sw=t,this.sc=n,this.fc=r,this.m=a,this.p=i,this._mdf={o:!0,sw:!!t,sc:!!n,fc:!!r,m:!0,p:!0}}function TextProperty(e,t){this._frameId=initialDefaultFrame,this.pv="",this.v="",this.kf=!1,this._isFirstFrame=!0,this._mdf=!1,t.d&&t.d.sid&&(t.d=e.globalData.slotManager.getProp(t.d)),this.data=t,this.elem=e,this.comp=this.elem.comp,this.keysIndex=0,this.canResize=!1,this.minimumFontSize=1,this.effectsSequence=[],this.currentData={ascent:0,boxWidth:this.defaultBoxWidth,f:"",fStyle:"",fWeight:"",fc:"",j:"",justifyOffset:"",l:[],lh:0,lineWidths:[],ls:"",of:"",s:"",sc:"",sw:0,t:0,tr:0,sz:0,ps:null,fillColorAnim:!1,strokeColorAnim:!1,strokeWidthAnim:!1,yOffset:0,finalSize:0,finalText:[],finalLineHeight:0,__complete:!1},this.copyData(this.currentData,this.data.d.k[0].s),this.searchProperty()||this.completeTextData(this.currentData)}extendPrototype([BaseElement,TransformElement,SVGBaseElement,IShapeElement,HierarchyElement,FrameElement,RenderableDOMElement],SVGShapeElement),SVGShapeElement.prototype.initSecondaryElement=function(){},SVGShapeElement.prototype.identityMatrix=new Matrix,SVGShapeElement.prototype.buildExpressionInterface=function(){},SVGShapeElement.prototype.createContent=function(){this.searchShapes(this.shapesData,this.itemsData,this.prevViewData,this.layerElement,0,[],!0),this.filterUniqueShapes()},SVGShapeElement.prototype.filterUniqueShapes=function(){var e,t,n,r,a=this.shapes.length,i=this.stylesList.length,s=[],o=!1;for(n=0;n<i;n+=1){for(r=this.stylesList[n],o=!1,s.length=0,e=0;e<a;e+=1)-1!==(t=this.shapes[e]).styles.indexOf(r)&&(s.push(t),o=t._isAnimated||o);s.length>1&&o&&this.setShapesAsAnimated(s)}},SVGShapeElement.prototype.setShapesAsAnimated=function(e){var t,n=e.length;for(t=0;t<n;t+=1)e[t].setAsAnimated()},SVGShapeElement.prototype.createStyleElement=function(e,t){var n,r=new SVGStyleData(e,t),a=r.pElem;return"st"===e.ty?n=new SVGStrokeStyleData(this,e,r):"fl"===e.ty?n=new SVGFillStyleData(this,e,r):"gf"===e.ty||"gs"===e.ty?(n=new("gf"===e.ty?SVGGradientFillStyleData:SVGGradientStrokeStyleData)(this,e,r),this.globalData.defs.appendChild(n.gf),n.maskId&&(this.globalData.defs.appendChild(n.ms),this.globalData.defs.appendChild(n.of),a.setAttribute("mask","url("+getLocationHref()+"#"+n.maskId+")"))):"no"===e.ty&&(n=new SVGNoStyleData(this,e,r)),"st"!==e.ty&&"gs"!==e.ty||(a.setAttribute("stroke-linecap",lineCapEnum[e.lc||2]),a.setAttribute("stroke-linejoin",lineJoinEnum[e.lj||2]),a.setAttribute("fill-opacity","0"),1===e.lj&&a.setAttribute("stroke-miterlimit",e.ml)),2===e.r&&a.setAttribute("fill-rule","evenodd"),e.ln&&a.setAttribute("id",e.ln),e.cl&&a.setAttribute("class",e.cl),e.bm&&(a.style["mix-blend-mode"]=getBlendMode(e.bm)),this.stylesList.push(r),this.addToAnimatedContents(e,n),n},SVGShapeElement.prototype.createGroupElement=function(e){var t=new ShapeGroupData;return e.ln&&t.gr.setAttribute("id",e.ln),e.cl&&t.gr.setAttribute("class",e.cl),e.bm&&(t.gr.style["mix-blend-mode"]=getBlendMode(e.bm)),t},SVGShapeElement.prototype.createTransformElement=function(e,t){var n=TransformPropertyFactory.getTransformProperty(this,e,this),r=new SVGTransformData(n,n.o,t);return this.addToAnimatedContents(e,r),r},SVGShapeElement.prototype.createShapeElement=function(e,t,n){var r=4;"rc"===e.ty?r=5:"el"===e.ty?r=6:"sr"===e.ty&&(r=7);var a=new SVGShapeData(t,n,ShapePropertyFactory.getShapeProp(this,e,r,this));return this.shapes.push(a),this.addShapeToModifiers(a),this.addToAnimatedContents(e,a),a},SVGShapeElement.prototype.addToAnimatedContents=function(e,t){for(var n=0,r=this.animatedContents.length;n<r;){if(this.animatedContents[n].element===t)return;n+=1}this.animatedContents.push({fn:SVGElementsRenderer.createRenderFunction(e),element:t,data:e})},SVGShapeElement.prototype.setElementStyles=function(e){var t,n=e.styles,r=this.stylesList.length;for(t=0;t<r;t+=1)this.stylesList[t].closed||n.push(this.stylesList[t])},SVGShapeElement.prototype.reloadShapes=function(){var e;this._isFirstFrame=!0;var t=this.itemsData.length;for(e=0;e<t;e+=1)this.prevViewData[e]=this.itemsData[e];for(this.searchShapes(this.shapesData,this.itemsData,this.prevViewData,this.layerElement,0,[],!0),this.filterUniqueShapes(),t=this.dynamicProperties.length,e=0;e<t;e+=1)this.dynamicProperties[e].getValue();this.renderModifiers()},SVGShapeElement.prototype.searchShapes=function(e,t,n,r,a,i,s){var o,l,u,c,h,p,f=[].concat(i),d=e.length-1,m=[],g=[];for(o=d;o>=0;o-=1){if((p=this.searchProcessedElement(e[o]))?t[o]=n[p-1]:e[o]._render=s,"fl"===e[o].ty||"st"===e[o].ty||"gf"===e[o].ty||"gs"===e[o].ty||"no"===e[o].ty)p?t[o].style.closed=!1:t[o]=this.createStyleElement(e[o],a),e[o]._render&&t[o].style.pElem.parentNode!==r&&r.appendChild(t[o].style.pElem),m.push(t[o].style);else if("gr"===e[o].ty){if(p)for(u=t[o].it.length,l=0;l<u;l+=1)t[o].prevViewData[l]=t[o].it[l];else t[o]=this.createGroupElement(e[o]);this.searchShapes(e[o].it,t[o].it,t[o].prevViewData,t[o].gr,a+1,f,s),e[o]._render&&t[o].gr.parentNode!==r&&r.appendChild(t[o].gr)}else"tr"===e[o].ty?(p||(t[o]=this.createTransformElement(e[o],r)),c=t[o].transform,f.push(c)):"sh"===e[o].ty||"rc"===e[o].ty||"el"===e[o].ty||"sr"===e[o].ty?(p||(t[o]=this.createShapeElement(e[o],f,a)),this.setElementStyles(t[o])):"tm"===e[o].ty||"rd"===e[o].ty||"ms"===e[o].ty||"pb"===e[o].ty||"zz"===e[o].ty||"op"===e[o].ty?(p?(h=t[o]).closed=!1:((h=ShapeModifiers.getModifier(e[o].ty)).init(this,e[o]),t[o]=h,this.shapeModifiers.push(h)),g.push(h)):"rp"===e[o].ty&&(p?(h=t[o]).closed=!0:(h=ShapeModifiers.getModifier(e[o].ty),t[o]=h,h.init(this,e,o,t),this.shapeModifiers.push(h),s=!1),g.push(h));this.addProcessedElement(e[o],o+1)}for(d=m.length,o=0;o<d;o+=1)m[o].closed=!0;for(d=g.length,o=0;o<d;o+=1)g[o].closed=!0},SVGShapeElement.prototype.renderInnerContent=function(){var e;this.renderModifiers();var t=this.stylesList.length;for(e=0;e<t;e+=1)this.stylesList[e].reset();for(this.renderShape(),e=0;e<t;e+=1)(this.stylesList[e]._mdf||this._isFirstFrame)&&(this.stylesList[e].msElem&&(this.stylesList[e].msElem.setAttribute("d",this.stylesList[e].d),this.stylesList[e].d="M0 0"+this.stylesList[e].d),this.stylesList[e].pElem.setAttribute("d",this.stylesList[e].d||"M0 0"))},SVGShapeElement.prototype.renderShape=function(){var e,t,n=this.animatedContents.length;for(e=0;e<n;e+=1)t=this.animatedContents[e],(this._isFirstFrame||t.element._isAnimated)&&!0!==t.data&&t.fn(t.data,t.element,this._isFirstFrame)},SVGShapeElement.prototype.destroy=function(){this.destroyBaseElement(),this.shapesData=null,this.itemsData=null},LetterProps.prototype.update=function(e,t,n,r,a,i){this._mdf.o=!1,this._mdf.sw=!1,this._mdf.sc=!1,this._mdf.fc=!1,this._mdf.m=!1,this._mdf.p=!1;var s=!1;return this.o!==e&&(this.o=e,this._mdf.o=!0,s=!0),this.sw!==t&&(this.sw=t,this._mdf.sw=!0,s=!0),this.sc!==n&&(this.sc=n,this._mdf.sc=!0,s=!0),this.fc!==r&&(this.fc=r,this._mdf.fc=!0,s=!0),this.m!==a&&(this.m=a,this._mdf.m=!0,s=!0),!i.length||this.p[0]===i[0]&&this.p[1]===i[1]&&this.p[4]===i[4]&&this.p[5]===i[5]&&this.p[12]===i[12]&&this.p[13]===i[13]||(this.p=i,this._mdf.p=!0,s=!0),s},TextProperty.prototype.defaultBoxWidth=[0,0],TextProperty.prototype.copyData=function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n]);return e},TextProperty.prototype.setCurrentData=function(e){e.__complete||this.completeTextData(e),this.currentData=e,this.currentData.boxWidth=this.currentData.boxWidth||this.defaultBoxWidth,this._mdf=!0},TextProperty.prototype.searchProperty=function(){return this.searchKeyframes()},TextProperty.prototype.searchKeyframes=function(){return this.kf=this.data.d.k.length>1,this.kf&&this.addEffect(this.getKeyframeValue.bind(this)),this.kf},TextProperty.prototype.addEffect=function(e){this.effectsSequence.push(e),this.elem.addDynamicProperty(this)},TextProperty.prototype.getValue=function(e){if(this.elem.globalData.frameId!==this.frameId&&this.effectsSequence.length||e){this.currentData.t=this.data.d.k[this.keysIndex].s.t;var t=this.currentData,n=this.keysIndex;if(this.lock)this.setCurrentData(this.currentData);else{var r;this.lock=!0,this._mdf=!1;var a=this.effectsSequence.length,i=e||this.data.d.k[this.keysIndex].s;for(r=0;r<a;r+=1)i=n!==this.keysIndex?this.effectsSequence[r](i,i.t):this.effectsSequence[r](this.currentData,i.t);t!==i&&this.setCurrentData(i),this.v=this.currentData,this.pv=this.v,this.lock=!1,this.frameId=this.elem.globalData.frameId}}},TextProperty.prototype.getKeyframeValue=function(){for(var e=this.data.d.k,t=this.elem.comp.renderedFrame,n=0,r=e.length;n<=r-1&&!(n===r-1||e[n+1].t>t);)n+=1;return this.keysIndex!==n&&(this.keysIndex=n),this.data.d.k[this.keysIndex].s},TextProperty.prototype.buildFinalText=function(e){for(var t,n,r=[],a=0,i=e.length,s=!1,o=!1,l="";a<i;)s=o,o=!1,t=e.charCodeAt(a),l=e.charAt(a),FontManager.isCombinedCharacter(t)?s=!0:t>=55296&&t<=56319?FontManager.isRegionalFlag(e,a)?l=e.substr(a,14):(n=e.charCodeAt(a+1))>=56320&&n<=57343&&(FontManager.isModifier(t,n)?(l=e.substr(a,2),s=!0):l=FontManager.isFlagEmoji(e.substr(a,4))?e.substr(a,4):e.substr(a,2)):t>56319?(n=e.charCodeAt(a+1),FontManager.isVariationSelector(t)&&(s=!0)):FontManager.isZeroWidthJoiner(t)&&(s=!0,o=!0),s?(r[r.length-1]+=l,s=!1):r.push(l),a+=l.length;return r},TextProperty.prototype.completeTextData=function(e){e.__complete=!0;var t,n,r,a,i,s,o,l=this.elem.globalData.fontManager,u=this.data,c=[],h=0,p=u.m.g,f=0,d=0,m=0,g=[],y=0,v=0,b=l.getFontByName(e.f),k=0,x=getFontProperties(b);e.fWeight=x.weight,e.fStyle=x.style,e.finalSize=e.s,e.finalText=this.buildFinalText(e.t),n=e.finalText.length,e.finalLineHeight=e.lh;var S,w=e.tr/1e3*e.finalSize;if(e.sz)for(var E,P,_=!0,C=e.sz[0],A=e.sz[1];_;){E=0,y=0,n=(P=this.buildFinalText(e.t)).length,w=e.tr/1e3*e.finalSize;var T=-1;for(t=0;t<n;t+=1)S=P[t].charCodeAt(0),r=!1," "===P[t]?T=t:13!==S&&3!==S||(y=0,r=!0,E+=e.finalLineHeight||1.2*e.finalSize),l.chars?(o=l.getCharData(P[t],b.fStyle,b.fFamily),k=r?0:o.w*e.finalSize/100):k=l.measureText(P[t],e.f,e.finalSize),y+k>C&&" "!==P[t]?(-1===T?n+=1:t=T,E+=e.finalLineHeight||1.2*e.finalSize,P.splice(t,T===t?1:0,"\r"),T=-1,y=0):(y+=k,y+=w);E+=b.ascent*e.finalSize/100,this.canResize&&e.finalSize>this.minimumFontSize&&A<E?(e.finalSize-=1,e.finalLineHeight=e.finalSize*e.lh/e.s):(e.finalText=P,n=e.finalText.length,_=!1)}y=-w,k=0;var M,D=0;for(t=0;t<n;t+=1)if(r=!1,13===(S=(M=e.finalText[t]).charCodeAt(0))||3===S?(D=0,g.push(y),v=y>v?y:v,y=-2*w,a="",r=!0,m+=1):a=M,l.chars?(o=l.getCharData(M,b.fStyle,l.getFontByName(e.f).fFamily),k=r?0:o.w*e.finalSize/100):k=l.measureText(a,e.f,e.finalSize)," "===M?D+=k+w:(y+=k+w+D,D=0),c.push({l:k,an:k,add:f,n:r,anIndexes:[],val:a,line:m,animatorJustifyOffset:0}),2==p){if(f+=k,""===a||" "===a||t===n-1){for(""!==a&&" "!==a||(f-=k);d<=t;)c[d].an=f,c[d].ind=h,c[d].extra=k,d+=1;h+=1,f=0}}else if(3==p){if(f+=k,""===a||t===n-1){for(""===a&&(f-=k);d<=t;)c[d].an=f,c[d].ind=h,c[d].extra=k,d+=1;f=0,h+=1}}else c[h].ind=h,c[h].extra=0,h+=1;if(e.l=c,v=y>v?y:v,g.push(y),e.sz)e.boxWidth=e.sz[0],e.justifyOffset=0;else switch(e.boxWidth=v,e.j){case 1:e.justifyOffset=-e.boxWidth;break;case 2:e.justifyOffset=-e.boxWidth/2;break;default:e.justifyOffset=0}e.lineWidths=g;var I,F,O,R,L=u.a;s=L.length;var N=[];for(i=0;i<s;i+=1){for((I=L[i]).a.sc&&(e.strokeColorAnim=!0),I.a.sw&&(e.strokeWidthAnim=!0),(I.a.fc||I.a.fh||I.a.fs||I.a.fb)&&(e.fillColorAnim=!0),R=0,O=I.s.b,t=0;t<n;t+=1)(F=c[t]).anIndexes[i]=R,(1==O&&""!==F.val||2==O&&""!==F.val&&" "!==F.val||3==O&&(F.n||" "==F.val||t==n-1)||4==O&&(F.n||t==n-1))&&(1===I.s.rn&&N.push(R),R+=1);u.a[i].s.totalChars=R;var V,B=-1;if(1===I.s.rn)for(t=0;t<n;t+=1)B!=(F=c[t]).anIndexes[i]&&(B=F.anIndexes[i],V=N.splice(Math.floor(Math.random()*N.length),1)[0]),F.anIndexes[i]=V}e.yOffset=e.finalLineHeight||1.2*e.finalSize,e.ls=e.ls||0,e.ascent=b.ascent*e.finalSize/100},TextProperty.prototype.updateDocumentData=function(e,t){t=void 0===t?this.keysIndex:t;var n=this.copyData({},this.data.d.k[t].s);n=this.copyData(n,e),this.data.d.k[t].s=n,this.recalculate(t),this.setCurrentData(n),this.elem.addDynamicProperty(this)},TextProperty.prototype.recalculate=function(e){var t=this.data.d.k[e].s;t.__complete=!1,this.keysIndex=0,this._isFirstFrame=!0,this.getValue(t)},TextProperty.prototype.canResizeFont=function(e){this.canResize=e,this.recalculate(this.keysIndex),this.elem.addDynamicProperty(this)},TextProperty.prototype.setMinimumFontSize=function(e){this.minimumFontSize=Math.floor(e)||1,this.recalculate(this.keysIndex),this.elem.addDynamicProperty(this)};var TextSelectorProp=function(){var e=Math.max,t=Math.min,n=Math.floor;function r(e,t){this._currentTextLength=-1,this.k=!1,this.data=t,this.elem=e,this.comp=e.comp,this.finalS=0,this.finalE=0,this.initDynamicPropertyContainer(e),this.s=PropertyFactory.getProp(e,t.s||{k:0},0,0,this),this.e="e"in t?PropertyFactory.getProp(e,t.e,0,0,this):{v:100},this.o=PropertyFactory.getProp(e,t.o||{k:0},0,0,this),this.xe=PropertyFactory.getProp(e,t.xe||{k:0},0,0,this),this.ne=PropertyFactory.getProp(e,t.ne||{k:0},0,0,this),this.sm=PropertyFactory.getProp(e,t.sm||{k:100},0,0,this),this.a=PropertyFactory.getProp(e,t.a,0,.01,this),this.dynamicProperties.length||this.getValue()}return r.prototype={getMult:function(r){this._currentTextLength!==this.elem.textProperty.currentData.l.length&&this.getValue();var a=0,i=0,s=1,o=1;this.ne.v>0?a=this.ne.v/100:i=-this.ne.v/100,this.xe.v>0?s=1-this.xe.v/100:o=1+this.xe.v/100;var l=BezierFactory.getBezierEasing(a,i,s,o).get,u=0,c=this.finalS,h=this.finalE,p=this.data.sh;if(2===p)u=l(u=h===c?r>=h?1:0:e(0,t(.5/(h-c)+(r-c)/(h-c),1)));else if(3===p)u=l(u=h===c?r>=h?0:1:1-e(0,t(.5/(h-c)+(r-c)/(h-c),1)));else if(4===p)h===c?u=0:(u=e(0,t(.5/(h-c)+(r-c)/(h-c),1)))<.5?u*=2:u=1-2*(u-.5),u=l(u);else if(5===p){if(h===c)u=0;else{var f=h-c,d=-f/2+(r=t(e(0,r+.5-c),h-c)),m=f/2;u=Math.sqrt(1-d*d/(m*m))}u=l(u)}else 6===p?(h===c?u=0:(r=t(e(0,r+.5-c),h-c),u=(1+Math.cos(Math.PI+2*Math.PI*r/(h-c)))/2),u=l(u)):(r>=n(c)&&(u=e(0,t(r-c<0?t(h,1)-(c-r):h-r,1))),u=l(u));if(100!==this.sm.v){var g=.01*this.sm.v;0===g&&(g=1e-8);var y=.5-.5*g;u<y?u=0:(u=(u-y)/g)>1&&(u=1)}return u*this.a.v},getValue:function(e){this.iterateDynamicProperties(),this._mdf=e||this._mdf,this._currentTextLength=this.elem.textProperty.currentData.l.length||0,e&&2===this.data.r&&(this.e.v=this._currentTextLength);var t=2===this.data.r?1:100/this.data.totalChars,n=this.o.v/t,r=this.s.v/t+n,a=this.e.v/t+n;if(r>a){var i=r;r=a,a=i}this.finalS=r,this.finalE=a}},extendPrototype([DynamicPropertyContainer],r),{getTextSelectorProp:function(e,t,n){return new r(e,t,n)}}}();function TextAnimatorDataProperty(e,t,n){var r={propType:!1},a=PropertyFactory.getProp,i=t.a;this.a={r:i.r?a(e,i.r,0,degToRads,n):r,rx:i.rx?a(e,i.rx,0,degToRads,n):r,ry:i.ry?a(e,i.ry,0,degToRads,n):r,sk:i.sk?a(e,i.sk,0,degToRads,n):r,sa:i.sa?a(e,i.sa,0,degToRads,n):r,s:i.s?a(e,i.s,1,.01,n):r,a:i.a?a(e,i.a,1,0,n):r,o:i.o?a(e,i.o,0,.01,n):r,p:i.p?a(e,i.p,1,0,n):r,sw:i.sw?a(e,i.sw,0,0,n):r,sc:i.sc?a(e,i.sc,1,0,n):r,fc:i.fc?a(e,i.fc,1,0,n):r,fh:i.fh?a(e,i.fh,0,0,n):r,fs:i.fs?a(e,i.fs,0,.01,n):r,fb:i.fb?a(e,i.fb,0,.01,n):r,t:i.t?a(e,i.t,0,0,n):r},this.s=TextSelectorProp.getTextSelectorProp(e,t.s,n),this.s.t=t.s.t}function TextAnimatorProperty(e,t,n){this._isFirstFrame=!0,this._hasMaskedPath=!1,this._frameId=-1,this._textData=e,this._renderType=t,this._elem=n,this._animatorsData=createSizedArray(this._textData.a.length),this._pathData={},this._moreOptions={alignment:{}},this.renderedLetters=[],this.lettersChangedFlag=!1,this.initDynamicPropertyContainer(n)}function ITextElement(){}TextAnimatorProperty.prototype.searchProperties=function(){var e,t,n=this._textData.a.length,r=PropertyFactory.getProp;for(e=0;e<n;e+=1)t=this._textData.a[e],this._animatorsData[e]=new TextAnimatorDataProperty(this._elem,t,this);this._textData.p&&"m"in this._textData.p?(this._pathData={a:r(this._elem,this._textData.p.a,0,0,this),f:r(this._elem,this._textData.p.f,0,0,this),l:r(this._elem,this._textData.p.l,0,0,this),r:r(this._elem,this._textData.p.r,0,0,this),p:r(this._elem,this._textData.p.p,0,0,this),m:this._elem.maskManager.getMaskProperty(this._textData.p.m)},this._hasMaskedPath=!0):this._hasMaskedPath=!1,this._moreOptions.alignment=r(this._elem,this._textData.m.a,1,0,this)},TextAnimatorProperty.prototype.getMeasures=function(e,t){if(this.lettersChangedFlag=t,this._mdf||this._isFirstFrame||t||this._hasMaskedPath&&this._pathData.m._mdf){this._isFirstFrame=!1;var n,r,a,i,s,o,l,u,c,h,p,f,d,m,g,y,v,b,k,x=this._moreOptions.alignment.v,S=this._animatorsData,w=this._textData,E=this.mHelper,P=this._renderType,_=this.renderedLetters.length,C=e.l;if(this._hasMaskedPath){if(k=this._pathData.m,!this._pathData.n||this._pathData._mdf){var A,T=k.v;for(this._pathData.r.v&&(T=T.reverse()),s={tLength:0,segments:[]},i=T._length-1,y=0,a=0;a<i;a+=1)A=bez.buildBezierData(T.v[a],T.v[a+1],[T.o[a][0]-T.v[a][0],T.o[a][1]-T.v[a][1]],[T.i[a+1][0]-T.v[a+1][0],T.i[a+1][1]-T.v[a+1][1]]),s.tLength+=A.segmentLength,s.segments.push(A),y+=A.segmentLength;a=i,k.v.c&&(A=bez.buildBezierData(T.v[a],T.v[0],[T.o[a][0]-T.v[a][0],T.o[a][1]-T.v[a][1]],[T.i[0][0]-T.v[0][0],T.i[0][1]-T.v[0][1]]),s.tLength+=A.segmentLength,s.segments.push(A),y+=A.segmentLength),this._pathData.pi=s}if(s=this._pathData.pi,o=this._pathData.f.v,p=0,h=1,u=0,c=!0,m=s.segments,o<0&&k.v.c)for(s.tLength<Math.abs(o)&&(o=-Math.abs(o)%s.tLength),h=(d=m[p=m.length-1].points).length-1;o<0;)o+=d[h].partialLength,(h-=1)<0&&(h=(d=m[p-=1].points).length-1);f=(d=m[p].points)[h-1],g=(l=d[h]).partialLength}i=C.length,n=0,r=0;var M,D,I,F,O,R=1.2*e.finalSize*.714,L=!0;I=S.length;var N,V,B,z,j,G,H,q,U,W,$,K,J=-1,Y=o,Q=p,X=h,Z=-1,ee="",te=this.defaultPropsArray;if(2===e.j||1===e.j){var ne=0,re=0,ae=2===e.j?-.5:-1,ie=0,se=!0;for(a=0;a<i;a+=1)if(C[a].n){for(ne&&(ne+=re);ie<a;)C[ie].animatorJustifyOffset=ne,ie+=1;ne=0,se=!0}else{for(D=0;D<I;D+=1)(M=S[D].a).t.propType&&(se&&2===e.j&&(re+=M.t.v*ae),(O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars)).length?ne+=M.t.v*O[0]*ae:ne+=M.t.v*O*ae);se=!1}for(ne&&(ne+=re);ie<a;)C[ie].animatorJustifyOffset=ne,ie+=1}for(a=0;a<i;a+=1){if(E.reset(),z=1,C[a].n)n=0,r+=e.yOffset,r+=L?1:0,o=Y,L=!1,this._hasMaskedPath&&(h=X,f=(d=m[p=Q].points)[h-1],g=(l=d[h]).partialLength,u=0),ee="",$="",U="",K="",te=this.defaultPropsArray;else{if(this._hasMaskedPath){if(Z!==C[a].line){switch(e.j){case 1:o+=y-e.lineWidths[C[a].line];break;case 2:o+=(y-e.lineWidths[C[a].line])/2}Z=C[a].line}J!==C[a].ind&&(C[J]&&(o+=C[J].extra),o+=C[a].an/2,J=C[a].ind),o+=x[0]*C[a].an*.005;var oe=0;for(D=0;D<I;D+=1)(M=S[D].a).p.propType&&((O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars)).length?oe+=M.p.v[0]*O[0]:oe+=M.p.v[0]*O),M.a.propType&&((O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars)).length?oe+=M.a.v[0]*O[0]:oe+=M.a.v[0]*O);for(c=!0,this._pathData.a.v&&(o=.5*C[0].an+(y-this._pathData.f.v-.5*C[0].an-.5*C[C.length-1].an)*J/(i-1),o+=this._pathData.f.v);c;)u+g>=o+oe||!d?(v=(o+oe-u)/l.partialLength,V=f.point[0]+(l.point[0]-f.point[0])*v,B=f.point[1]+(l.point[1]-f.point[1])*v,E.translate(-x[0]*C[a].an*.005,-x[1]*R*.01),c=!1):d&&(u+=l.partialLength,(h+=1)>=d.length&&(h=0,m[p+=1]?d=m[p].points:k.v.c?(h=0,d=m[p=0].points):(u-=l.partialLength,d=null)),d&&(f=l,g=(l=d[h]).partialLength));N=C[a].an/2-C[a].add,E.translate(-N,0,0)}else N=C[a].an/2-C[a].add,E.translate(-N,0,0),E.translate(-x[0]*C[a].an*.005,-x[1]*R*.01,0);for(D=0;D<I;D+=1)(M=S[D].a).t.propType&&(O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars),0===n&&0===e.j||(this._hasMaskedPath?O.length?o+=M.t.v*O[0]:o+=M.t.v*O:O.length?n+=M.t.v*O[0]:n+=M.t.v*O));for(e.strokeWidthAnim&&(G=e.sw||0),e.strokeColorAnim&&(j=e.sc?[e.sc[0],e.sc[1],e.sc[2]]:[0,0,0]),e.fillColorAnim&&e.fc&&(H=[e.fc[0],e.fc[1],e.fc[2]]),D=0;D<I;D+=1)(M=S[D].a).a.propType&&((O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars)).length?E.translate(-M.a.v[0]*O[0],-M.a.v[1]*O[1],M.a.v[2]*O[2]):E.translate(-M.a.v[0]*O,-M.a.v[1]*O,M.a.v[2]*O));for(D=0;D<I;D+=1)(M=S[D].a).s.propType&&((O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars)).length?E.scale(1+(M.s.v[0]-1)*O[0],1+(M.s.v[1]-1)*O[1],1):E.scale(1+(M.s.v[0]-1)*O,1+(M.s.v[1]-1)*O,1));for(D=0;D<I;D+=1){if(M=S[D].a,O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars),M.sk.propType&&(O.length?E.skewFromAxis(-M.sk.v*O[0],M.sa.v*O[1]):E.skewFromAxis(-M.sk.v*O,M.sa.v*O)),M.r.propType&&(O.length?E.rotateZ(-M.r.v*O[2]):E.rotateZ(-M.r.v*O)),M.ry.propType&&(O.length?E.rotateY(M.ry.v*O[1]):E.rotateY(M.ry.v*O)),M.rx.propType&&(O.length?E.rotateX(M.rx.v*O[0]):E.rotateX(M.rx.v*O)),M.o.propType&&(O.length?z+=(M.o.v*O[0]-z)*O[0]:z+=(M.o.v*O-z)*O),e.strokeWidthAnim&&M.sw.propType&&(O.length?G+=M.sw.v*O[0]:G+=M.sw.v*O),e.strokeColorAnim&&M.sc.propType)for(q=0;q<3;q+=1)O.length?j[q]+=(M.sc.v[q]-j[q])*O[0]:j[q]+=(M.sc.v[q]-j[q])*O;if(e.fillColorAnim&&e.fc){if(M.fc.propType)for(q=0;q<3;q+=1)O.length?H[q]+=(M.fc.v[q]-H[q])*O[0]:H[q]+=(M.fc.v[q]-H[q])*O;M.fh.propType&&(H=O.length?addHueToRGB(H,M.fh.v*O[0]):addHueToRGB(H,M.fh.v*O)),M.fs.propType&&(H=O.length?addSaturationToRGB(H,M.fs.v*O[0]):addSaturationToRGB(H,M.fs.v*O)),M.fb.propType&&(H=O.length?addBrightnessToRGB(H,M.fb.v*O[0]):addBrightnessToRGB(H,M.fb.v*O))}}for(D=0;D<I;D+=1)(M=S[D].a).p.propType&&(O=S[D].s.getMult(C[a].anIndexes[D],w.a[D].s.totalChars),this._hasMaskedPath?O.length?E.translate(0,M.p.v[1]*O[0],-M.p.v[2]*O[1]):E.translate(0,M.p.v[1]*O,-M.p.v[2]*O):O.length?E.translate(M.p.v[0]*O[0],M.p.v[1]*O[1],-M.p.v[2]*O[2]):E.translate(M.p.v[0]*O,M.p.v[1]*O,-M.p.v[2]*O));if(e.strokeWidthAnim&&(U=G<0?0:G),e.strokeColorAnim&&(W="rgb("+Math.round(255*j[0])+","+Math.round(255*j[1])+","+Math.round(255*j[2])+")"),e.fillColorAnim&&e.fc&&($="rgb("+Math.round(255*H[0])+","+Math.round(255*H[1])+","+Math.round(255*H[2])+")"),this._hasMaskedPath){if(E.translate(0,-e.ls),E.translate(0,x[1]*R*.01+r,0),this._pathData.p.v){b=(l.point[1]-f.point[1])/(l.point[0]-f.point[0]);var le=180*Math.atan(b)/Math.PI;l.point[0]<f.point[0]&&(le+=180),E.rotate(-le*Math.PI/180)}E.translate(V,B,0),o-=x[0]*C[a].an*.005,C[a+1]&&J!==C[a+1].ind&&(o+=C[a].an/2,o+=.001*e.tr*e.finalSize)}else{switch(E.translate(n,r,0),e.ps&&E.translate(e.ps[0],e.ps[1]+e.ascent,0),e.j){case 1:E.translate(C[a].animatorJustifyOffset+e.justifyOffset+(e.boxWidth-e.lineWidths[C[a].line]),0,0);break;case 2:E.translate(C[a].animatorJustifyOffset+e.justifyOffset+(e.boxWidth-e.lineWidths[C[a].line])/2,0,0)}E.translate(0,-e.ls),E.translate(N,0,0),E.translate(x[0]*C[a].an*.005,x[1]*R*.01,0),n+=C[a].l+.001*e.tr*e.finalSize}"html"===P?ee=E.toCSS():"svg"===P?ee=E.to2dCSS():te=[E.props[0],E.props[1],E.props[2],E.props[3],E.props[4],E.props[5],E.props[6],E.props[7],E.props[8],E.props[9],E.props[10],E.props[11],E.props[12],E.props[13],E.props[14],E.props[15]],K=z}_<=a?(F=new LetterProps(K,U,W,$,ee,te),this.renderedLetters.push(F),_+=1,this.lettersChangedFlag=!0):(F=this.renderedLetters[a],this.lettersChangedFlag=F.update(K,U,W,$,ee,te)||this.lettersChangedFlag)}}},TextAnimatorProperty.prototype.getValue=function(){this._elem.globalData.frameId!==this._frameId&&(this._frameId=this._elem.globalData.frameId,this.iterateDynamicProperties())},TextAnimatorProperty.prototype.mHelper=new Matrix,TextAnimatorProperty.prototype.defaultPropsArray=[],extendPrototype([DynamicPropertyContainer],TextAnimatorProperty),ITextElement.prototype.initElement=function(e,t,n){this.lettersChangedFlag=!0,this.initFrame(),this.initBaseData(e,t,n),this.textProperty=new TextProperty(this,e.t,this.dynamicProperties),this.textAnimator=new TextAnimatorProperty(e.t,this.renderType,this),this.initTransform(e,t,n),this.initHierarchy(),this.initRenderable(),this.initRendererElement(),this.createContainerElements(),this.createRenderableComponents(),this.createContent(),this.hide(),this.textAnimator.searchProperties(this.dynamicProperties)},ITextElement.prototype.prepareFrame=function(e){this._mdf=!1,this.prepareRenderableFrame(e),this.prepareProperties(e,this.isInRange)},ITextElement.prototype.createPathShape=function(e,t){var n,r,a=t.length,i="";for(n=0;n<a;n+=1)"sh"===t[n].ty&&(r=t[n].ks.k,i+=buildShapeString(r,r.i.length,!0,e));return i},ITextElement.prototype.updateDocumentData=function(e,t){this.textProperty.updateDocumentData(e,t)},ITextElement.prototype.canResizeFont=function(e){this.textProperty.canResizeFont(e)},ITextElement.prototype.setMinimumFontSize=function(e){this.textProperty.setMinimumFontSize(e)},ITextElement.prototype.applyTextPropertiesToMatrix=function(e,t,n,r,a){switch(e.ps&&t.translate(e.ps[0],e.ps[1]+e.ascent,0),t.translate(0,-e.ls,0),e.j){case 1:t.translate(e.justifyOffset+(e.boxWidth-e.lineWidths[n]),0,0);break;case 2:t.translate(e.justifyOffset+(e.boxWidth-e.lineWidths[n])/2,0,0)}t.translate(r,a,0)},ITextElement.prototype.buildColor=function(e){return"rgb("+Math.round(255*e[0])+","+Math.round(255*e[1])+","+Math.round(255*e[2])+")"},ITextElement.prototype.emptyProp=new LetterProps,ITextElement.prototype.destroy=function(){},ITextElement.prototype.validateText=function(){(this.textProperty._mdf||this.textProperty._isFirstFrame)&&(this.buildNewText(),this.textProperty._isFirstFrame=!1,this.textProperty._mdf=!1)};var emptyShapeData={shapes:[]};function SVGTextLottieElement(e,t,n){this.textSpans=[],this.renderType="svg",this.initElement(e,t,n)}function ISolidElement(e,t,n){this.initElement(e,t,n)}function NullElement(e,t,n){this.initFrame(),this.initBaseData(e,t,n),this.initFrame(),this.initTransform(e,t,n),this.initHierarchy()}function SVGRendererBase(){}function ICompElement(){}function SVGCompElement(e,t,n){this.layers=e.layers,this.supports3d=!0,this.completeLayers=!1,this.pendingElements=[],this.elements=this.layers?createSizedArray(this.layers.length):[],this.initElement(e,t,n),this.tm=e.tm?PropertyFactory.getProp(this,e.tm,0,t.frameRate,this):{_placeholder:!0}}function SVGRenderer(e,t){this.animationItem=e,this.layers=null,this.renderedFrame=-1,this.svgElement=createNS("svg");var n="";if(t&&t.title){var r=createNS("title"),a=createElementID();r.setAttribute("id",a),r.textContent=t.title,this.svgElement.appendChild(r),n+=a}if(t&&t.description){var i=createNS("desc"),s=createElementID();i.setAttribute("id",s),i.textContent=t.description,this.svgElement.appendChild(i),n+=" "+s}n&&this.svgElement.setAttribute("aria-labelledby",n);var o=createNS("defs");this.svgElement.appendChild(o);var l=createNS("g");this.svgElement.appendChild(l),this.layerElement=l,this.renderConfig={preserveAspectRatio:t&&t.preserveAspectRatio||"xMidYMid meet",imagePreserveAspectRatio:t&&t.imagePreserveAspectRatio||"xMidYMid slice",contentVisibility:t&&t.contentVisibility||"visible",progressiveLoad:t&&t.progressiveLoad||!1,hideOnTransparent:!(t&&!1===t.hideOnTransparent),viewBoxOnly:t&&t.viewBoxOnly||!1,viewBoxSize:t&&t.viewBoxSize||!1,className:t&&t.className||"",id:t&&t.id||"",focusable:t&&t.focusable,filterSize:{width:t&&t.filterSize&&t.filterSize.width||"100%",height:t&&t.filterSize&&t.filterSize.height||"100%",x:t&&t.filterSize&&t.filterSize.x||"0%",y:t&&t.filterSize&&t.filterSize.y||"0%"},width:t&&t.width,height:t&&t.height,runExpressions:!t||void 0===t.runExpressions||t.runExpressions},this.globalData={_mdf:!1,frameNum:-1,defs:o,renderConfig:this.renderConfig},this.elements=[],this.pendingElements=[],this.destroyed=!1,this.rendererType="svg"}function ShapeTransformManager(){this.sequences={},this.sequenceList=[],this.transform_key_count=0}extendPrototype([BaseElement,TransformElement,SVGBaseElement,HierarchyElement,FrameElement,RenderableDOMElement,ITextElement],SVGTextLottieElement),SVGTextLottieElement.prototype.createContent=function(){this.data.singleShape&&!this.globalData.fontManager.chars&&(this.textContainer=createNS("text"))},SVGTextLottieElement.prototype.buildTextContents=function(e){for(var t=0,n=e.length,r=[],a="";t<n;)e[t]===String.fromCharCode(13)||e[t]===String.fromCharCode(3)?(r.push(a),a=""):a+=e[t],t+=1;return r.push(a),r},SVGTextLottieElement.prototype.buildShapeData=function(e,t){if(e.shapes&&e.shapes.length){var n=e.shapes[0];if(n.it){var r=n.it[n.it.length-1];r.s&&(r.s.k[0]=t,r.s.k[1]=t)}}return e},SVGTextLottieElement.prototype.buildNewText=function(){var e,t;this.addDynamicProperty(this);var n=this.textProperty.currentData;this.renderedLetters=createSizedArray(n?n.l.length:0),n.fc?this.layerElement.setAttribute("fill",this.buildColor(n.fc)):this.layerElement.setAttribute("fill","rgba(0,0,0,0)"),n.sc&&(this.layerElement.setAttribute("stroke",this.buildColor(n.sc)),this.layerElement.setAttribute("stroke-width",n.sw)),this.layerElement.setAttribute("font-size",n.finalSize);var r=this.globalData.fontManager.getFontByName(n.f);if(r.fClass)this.layerElement.setAttribute("class",r.fClass);else{this.layerElement.setAttribute("font-family",r.fFamily);var a=n.fWeight,i=n.fStyle;this.layerElement.setAttribute("font-style",i),this.layerElement.setAttribute("font-weight",a)}this.layerElement.setAttribute("aria-label",n.t);var s,o=n.l||[],l=!!this.globalData.fontManager.chars;t=o.length;var u=this.mHelper,c=this.data.singleShape,h=0,p=0,f=!0,d=.001*n.tr*n.finalSize;if(!c||l||n.sz){var m,g=this.textSpans.length;for(e=0;e<t;e+=1){if(this.textSpans[e]||(this.textSpans[e]={span:null,childSpan:null,glyph:null}),!l||!c||0===e){if(s=g>e?this.textSpans[e].span:createNS(l?"g":"text"),g<=e){if(s.setAttribute("stroke-linecap","butt"),s.setAttribute("stroke-linejoin","round"),s.setAttribute("stroke-miterlimit","4"),this.textSpans[e].span=s,l){var y=createNS("g");s.appendChild(y),this.textSpans[e].childSpan=y}this.textSpans[e].span=s,this.layerElement.appendChild(s)}s.style.display="inherit"}if(u.reset(),c&&(o[e].n&&(h=-d,p+=n.yOffset,p+=f?1:0,f=!1),this.applyTextPropertiesToMatrix(n,u,o[e].line,h,p),h+=o[e].l||0,h+=d),l){var v;if(1===(m=this.globalData.fontManager.getCharData(n.finalText[e],r.fStyle,this.globalData.fontManager.getFontByName(n.f).fFamily)).t)v=new SVGCompElement(m.data,this.globalData,this);else{var b=emptyShapeData;m.data&&m.data.shapes&&(b=this.buildShapeData(m.data,n.finalSize)),v=new SVGShapeElement(b,this.globalData,this)}if(this.textSpans[e].glyph){var k=this.textSpans[e].glyph;this.textSpans[e].childSpan.removeChild(k.layerElement),k.destroy()}this.textSpans[e].glyph=v,v._debug=!0,v.prepareFrame(0),v.renderFrame(),this.textSpans[e].childSpan.appendChild(v.layerElement),1===m.t&&this.textSpans[e].childSpan.setAttribute("transform","scale("+n.finalSize/100+","+n.finalSize/100+")")}else c&&s.setAttribute("transform","translate("+u.props[12]+","+u.props[13]+")"),s.textContent=o[e].val,s.setAttributeNS("http://www.w3.org/XML/1998/namespace","xml:space","preserve")}c&&s&&s.setAttribute("d","")}else{var x=this.textContainer,S="start";switch(n.j){case 1:S="end";break;case 2:S="middle";break;default:S="start"}x.setAttribute("text-anchor",S),x.setAttribute("letter-spacing",d);var w=this.buildTextContents(n.finalText);for(t=w.length,p=n.ps?n.ps[1]+n.ascent:0,e=0;e<t;e+=1)(s=this.textSpans[e].span||createNS("tspan")).textContent=w[e],s.setAttribute("x",0),s.setAttribute("y",p),s.style.display="inherit",x.appendChild(s),this.textSpans[e]||(this.textSpans[e]={span:null,glyph:null}),this.textSpans[e].span=s,p+=n.finalLineHeight;this.layerElement.appendChild(x)}for(;e<this.textSpans.length;)this.textSpans[e].span.style.display="none",e+=1;this._sizeChanged=!0},SVGTextLottieElement.prototype.sourceRectAtTime=function(){if(this.prepareFrame(this.comp.renderedFrame-this.data.st),this.renderInnerContent(),this._sizeChanged){this._sizeChanged=!1;var e=this.layerElement.getBBox();this.bbox={top:e.y,left:e.x,width:e.width,height:e.height}}return this.bbox},SVGTextLottieElement.prototype.getValue=function(){var e,t,n=this.textSpans.length;for(this.renderedFrame=this.comp.renderedFrame,e=0;e<n;e+=1)(t=this.textSpans[e].glyph)&&(t.prepareFrame(this.comp.renderedFrame-this.data.st),t._mdf&&(this._mdf=!0))},SVGTextLottieElement.prototype.renderInnerContent=function(){if(this.validateText(),(!this.data.singleShape||this._mdf)&&(this.textAnimator.getMeasures(this.textProperty.currentData,this.lettersChangedFlag),this.lettersChangedFlag||this.textAnimator.lettersChangedFlag)){var e,t;this._sizeChanged=!0;var n,r,a,i=this.textAnimator.renderedLetters,s=this.textProperty.currentData.l;for(t=s.length,e=0;e<t;e+=1)s[e].n||(n=i[e],r=this.textSpans[e].span,(a=this.textSpans[e].glyph)&&a.renderFrame(),n._mdf.m&&r.setAttribute("transform",n.m),n._mdf.o&&r.setAttribute("opacity",n.o),n._mdf.sw&&r.setAttribute("stroke-width",n.sw),n._mdf.sc&&r.setAttribute("stroke",n.sc),n._mdf.fc&&r.setAttribute("fill",n.fc))}},extendPrototype([IImageElement],ISolidElement),ISolidElement.prototype.createContent=function(){var e=createNS("rect");e.setAttribute("width",this.data.sw),e.setAttribute("height",this.data.sh),e.setAttribute("fill",this.data.sc),this.layerElement.appendChild(e)},NullElement.prototype.prepareFrame=function(e){this.prepareProperties(e,!0)},NullElement.prototype.renderFrame=function(){},NullElement.prototype.getBaseElement=function(){return null},NullElement.prototype.destroy=function(){},NullElement.prototype.sourceRectAtTime=function(){},NullElement.prototype.hide=function(){},extendPrototype([BaseElement,TransformElement,HierarchyElement,FrameElement],NullElement),extendPrototype([BaseRenderer],SVGRendererBase),SVGRendererBase.prototype.createNull=function(e){return new NullElement(e,this.globalData,this)},SVGRendererBase.prototype.createShape=function(e){return new SVGShapeElement(e,this.globalData,this)},SVGRendererBase.prototype.createText=function(e){return new SVGTextLottieElement(e,this.globalData,this)},SVGRendererBase.prototype.createImage=function(e){return new IImageElement(e,this.globalData,this)},SVGRendererBase.prototype.createSolid=function(e){return new ISolidElement(e,this.globalData,this)},SVGRendererBase.prototype.configAnimation=function(e){this.svgElement.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.svgElement.setAttribute("xmlns:xlink","http://www.w3.org/1999/xlink"),this.renderConfig.viewBoxSize?this.svgElement.setAttribute("viewBox",this.renderConfig.viewBoxSize):this.svgElement.setAttribute("viewBox","0 0 "+e.w+" "+e.h),this.renderConfig.viewBoxOnly||(this.svgElement.setAttribute("width",e.w),this.svgElement.setAttribute("height",e.h),this.svgElement.style.width="100%",this.svgElement.style.height="100%",this.svgElement.style.transform="translate3d(0,0,0)",this.svgElement.style.contentVisibility=this.renderConfig.contentVisibility),this.renderConfig.width&&this.svgElement.setAttribute("width",this.renderConfig.width),this.renderConfig.height&&this.svgElement.setAttribute("height",this.renderConfig.height),this.renderConfig.className&&this.svgElement.setAttribute("class",this.renderConfig.className),this.renderConfig.id&&this.svgElement.setAttribute("id",this.renderConfig.id),void 0!==this.renderConfig.focusable&&this.svgElement.setAttribute("focusable",this.renderConfig.focusable),this.svgElement.setAttribute("preserveAspectRatio",this.renderConfig.preserveAspectRatio),this.animationItem.wrapper.appendChild(this.svgElement);var t=this.globalData.defs;this.setupGlobalData(e,t),this.globalData.progressiveLoad=this.renderConfig.progressiveLoad,this.data=e;var n=createNS("clipPath"),r=createNS("rect");r.setAttribute("width",e.w),r.setAttribute("height",e.h),r.setAttribute("x",0),r.setAttribute("y",0);var a=createElementID();n.setAttribute("id",a),n.appendChild(r),this.layerElement.setAttribute("clip-path","url("+getLocationHref()+"#"+a+")"),t.appendChild(n),this.layers=e.layers,this.elements=createSizedArray(e.layers.length)},SVGRendererBase.prototype.destroy=function(){var e;this.animationItem.wrapper&&(this.animationItem.wrapper.innerText=""),this.layerElement=null,this.globalData.defs=null;var t=this.layers?this.layers.length:0;for(e=0;e<t;e+=1)this.elements[e]&&this.elements[e].destroy&&this.elements[e].destroy();this.elements.length=0,this.destroyed=!0,this.animationItem=null},SVGRendererBase.prototype.updateContainerSize=function(){},SVGRendererBase.prototype.findIndexByInd=function(e){var t=0,n=this.layers.length;for(t=0;t<n;t+=1)if(this.layers[t].ind===e)return t;return-1},SVGRendererBase.prototype.buildItem=function(e){var t=this.elements;if(!t[e]&&99!==this.layers[e].ty){t[e]=!0;var n=this.createItem(this.layers[e]);if(t[e]=n,getExpressionsPlugin()&&(0===this.layers[e].ty&&this.globalData.projectInterface.registerComposition(n),n.initExpressions()),this.appendElementInPos(n,e),this.layers[e].tt){var r="tp"in this.layers[e]?this.findIndexByInd(this.layers[e].tp):e-1;if(-1===r)return;if(this.elements[r]&&!0!==this.elements[r]){var a=t[r].getMatte(this.layers[e].tt);n.setMatte(a)}else this.buildItem(r),this.addPendingElement(n)}}},SVGRendererBase.prototype.checkPendingElements=function(){for(;this.pendingElements.length;){var e=this.pendingElements.pop();if(e.checkParenting(),e.data.tt)for(var t=0,n=this.elements.length;t<n;){if(this.elements[t]===e){var r="tp"in e.data?this.findIndexByInd(e.data.tp):t-1,a=this.elements[r].getMatte(this.layers[t].tt);e.setMatte(a);break}t+=1}}},SVGRendererBase.prototype.renderFrame=function(e){if(this.renderedFrame!==e&&!this.destroyed){var t;null===e?e=this.renderedFrame:this.renderedFrame=e,this.globalData.frameNum=e,this.globalData.frameId+=1,this.globalData.projectInterface.currentFrame=e,this.globalData._mdf=!1;var n=this.layers.length;for(this.completeLayers||this.checkLayers(e),t=n-1;t>=0;t-=1)(this.completeLayers||this.elements[t])&&this.elements[t].prepareFrame(e-this.layers[t].st);if(this.globalData._mdf)for(t=0;t<n;t+=1)(this.completeLayers||this.elements[t])&&this.elements[t].renderFrame()}},SVGRendererBase.prototype.appendElementInPos=function(e,t){var n=e.getBaseElement();if(n){for(var r,a=0;a<t;)this.elements[a]&&!0!==this.elements[a]&&this.elements[a].getBaseElement()&&(r=this.elements[a].getBaseElement()),a+=1;r?this.layerElement.insertBefore(n,r):this.layerElement.appendChild(n)}},SVGRendererBase.prototype.hide=function(){this.layerElement.style.display="none"},SVGRendererBase.prototype.show=function(){this.layerElement.style.display="block"},extendPrototype([BaseElement,TransformElement,HierarchyElement,FrameElement,RenderableDOMElement],ICompElement),ICompElement.prototype.initElement=function(e,t,n){this.initFrame(),this.initBaseData(e,t,n),this.initTransform(e,t,n),this.initRenderable(),this.initHierarchy(),this.initRendererElement(),this.createContainerElements(),this.createRenderableComponents(),!this.data.xt&&t.progressiveLoad||this.buildAllItems(),this.hide()},ICompElement.prototype.prepareFrame=function(e){if(this._mdf=!1,this.prepareRenderableFrame(e),this.prepareProperties(e,this.isInRange),this.isInRange||this.data.xt){if(this.tm._placeholder)this.renderedFrame=e/this.data.sr;else{var t=this.tm.v;t===this.data.op&&(t=this.data.op-1),this.renderedFrame=t}var n,r=this.elements.length;for(this.completeLayers||this.checkLayers(this.renderedFrame),n=r-1;n>=0;n-=1)(this.completeLayers||this.elements[n])&&(this.elements[n].prepareFrame(this.renderedFrame-this.layers[n].st),this.elements[n]._mdf&&(this._mdf=!0))}},ICompElement.prototype.renderInnerContent=function(){var e,t=this.layers.length;for(e=0;e<t;e+=1)(this.completeLayers||this.elements[e])&&this.elements[e].renderFrame()},ICompElement.prototype.setElements=function(e){this.elements=e},ICompElement.prototype.getElements=function(){return this.elements},ICompElement.prototype.destroyElements=function(){var e,t=this.layers.length;for(e=0;e<t;e+=1)this.elements[e]&&this.elements[e].destroy()},ICompElement.prototype.destroy=function(){this.destroyElements(),this.destroyBaseElement()},extendPrototype([SVGRendererBase,ICompElement,SVGBaseElement],SVGCompElement),SVGCompElement.prototype.createComp=function(e){return new SVGCompElement(e,this.globalData,this)},extendPrototype([SVGRendererBase],SVGRenderer),SVGRenderer.prototype.createComp=function(e){return new SVGCompElement(e,this.globalData,this)},ShapeTransformManager.prototype={addTransformSequence:function(e){var t,n=e.length,r="_";for(t=0;t<n;t+=1)r+=e[t].transform.key+"_";var a=this.sequences[r];return a||(a={transforms:[].concat(e),finalTransform:new Matrix,_mdf:!1},this.sequences[r]=a,this.sequenceList.push(a)),a},processSequence:function(e,t){for(var n=0,r=e.transforms.length,a=t;n<r&&!t;){if(e.transforms[n].transform.mProps._mdf){a=!0;break}n+=1}if(a)for(e.finalTransform.reset(),n=r-1;n>=0;n-=1)e.finalTransform.multiply(e.transforms[n].transform.mProps.v);e._mdf=a},processSequences:function(e){var t,n=this.sequenceList.length;for(t=0;t<n;t+=1)this.processSequence(this.sequenceList[t],e)},getNewKey:function(){return this.transform_key_count+=1,"_"+this.transform_key_count}};var lumaLoader=function(){var e="__lottie_element_luma_buffer",t=null,n=null,r=null;function a(){var a,i,s;t||(a=createNS("svg"),i=createNS("filter"),s=createNS("feColorMatrix"),i.setAttribute("id",e),s.setAttribute("type","matrix"),s.setAttribute("color-interpolation-filters","sRGB"),s.setAttribute("values","0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0"),i.appendChild(s),a.appendChild(i),a.setAttribute("id",e+"_svg"),featureSupport.svgLumaHidden&&(a.style.display="none"),r=a,document.body.appendChild(r),t=createTag("canvas"),(n=t.getContext("2d")).filter="url(#"+e+")",n.fillStyle="rgba(0,0,0,0)",n.fillRect(0,0,1,1))}return{load:a,get:function(r){return t||a(),t.width=r.width,t.height=r.height,n.filter="url(#"+e+")",t}}};function createCanvas(e,t){if(featureSupport.offscreenCanvas)return new OffscreenCanvas(e,t);var n=createTag("canvas");return n.width=e,n.height=t,n}var assetLoader={loadLumaCanvas:lumaLoader.load,getLumaCanvas:lumaLoader.get,createCanvas},registeredEffects={};function CVEffects(e){var t,n,r=e.data.ef?e.data.ef.length:0;for(this.filters=[],t=0;t<r;t+=1){n=null;var a=e.data.ef[t].ty;registeredEffects[a]&&(n=new(0,registeredEffects[a].effect)(e.effectsManager.effectElements[t],e)),n&&this.filters.push(n)}this.filters.length&&e.addRenderableComponent(this)}function registerEffect(e,t){registeredEffects[e]={effect:t}}function CVMaskElement(e,t){var n;this.data=e,this.element=t,this.masksProperties=this.data.masksProperties||[],this.viewData=createSizedArray(this.masksProperties.length);var r=this.masksProperties.length,a=!1;for(n=0;n<r;n+=1)"n"!==this.masksProperties[n].mode&&(a=!0),this.viewData[n]=ShapePropertyFactory.getShapeProp(this.element,this.masksProperties[n],3);this.hasMasks=a,a&&this.element.addRenderableComponent(this)}function CVBaseElement(){}CVEffects.prototype.renderFrame=function(e){var t,n=this.filters.length;for(t=0;t<n;t+=1)this.filters[t].renderFrame(e)},CVEffects.prototype.getEffects=function(e){var t,n=this.filters.length,r=[];for(t=0;t<n;t+=1)this.filters[t].type===e&&r.push(this.filters[t]);return r},CVMaskElement.prototype.renderFrame=function(){if(this.hasMasks){var e,t,n,r,a=this.element.finalTransform.mat,i=this.element.canvasContext,s=this.masksProperties.length;for(i.beginPath(),e=0;e<s;e+=1)if("n"!==this.masksProperties[e].mode){var o;this.masksProperties[e].inv&&(i.moveTo(0,0),i.lineTo(this.element.globalData.compSize.w,0),i.lineTo(this.element.globalData.compSize.w,this.element.globalData.compSize.h),i.lineTo(0,this.element.globalData.compSize.h),i.lineTo(0,0)),r=this.viewData[e].v,t=a.applyToPointArray(r.v[0][0],r.v[0][1],0),i.moveTo(t[0],t[1]);var l=r._length;for(o=1;o<l;o+=1)n=a.applyToTriplePoints(r.o[o-1],r.i[o],r.v[o]),i.bezierCurveTo(n[0],n[1],n[2],n[3],n[4],n[5]);n=a.applyToTriplePoints(r.o[o-1],r.i[0],r.v[0]),i.bezierCurveTo(n[0],n[1],n[2],n[3],n[4],n[5])}this.element.globalData.renderer.save(!0),i.clip()}},CVMaskElement.prototype.getMaskProperty=MaskElement.prototype.getMaskProperty,CVMaskElement.prototype.destroy=function(){this.element=null};var operationsMap={1:"source-in",2:"source-out",3:"source-in",4:"source-out"};function CVShapeData(e,t,n,r){this.styledShapes=[],this.tr=[0,0,0,0,0,0];var a,i=4;"rc"===t.ty?i=5:"el"===t.ty?i=6:"sr"===t.ty&&(i=7),this.sh=ShapePropertyFactory.getShapeProp(e,t,i,e);var s,o=n.length;for(a=0;a<o;a+=1)n[a].closed||(s={transforms:r.addTransformSequence(n[a].transforms),trNodes:[]},this.styledShapes.push(s),n[a].elements.push(s))}function CVShapeElement(e,t,n){this.shapes=[],this.shapesData=e.shapes,this.stylesList=[],this.itemsData=[],this.prevViewData=[],this.shapeModifiers=[],this.processedElements=[],this.transformsManager=new ShapeTransformManager,this.initElement(e,t,n)}function CVTextElement(e,t,n){this.textSpans=[],this.yOffset=0,this.fillColorAnim=!1,this.strokeColorAnim=!1,this.strokeWidthAnim=!1,this.stroke=!1,this.fill=!1,this.justifyOffset=0,this.currentRender=null,this.renderType="canvas",this.values={fill:"rgba(0,0,0,0)",stroke:"rgba(0,0,0,0)",sWidth:0,fValue:""},this.initElement(e,t,n)}function CVImageElement(e,t,n){this.assetData=t.getAssetData(e.refId),this.img=t.imageLoader.getAsset(this.assetData),this.initElement(e,t,n)}function CVSolidElement(e,t,n){this.initElement(e,t,n)}function CanvasRendererBase(){}function CanvasContext(){this.opacity=-1,this.transform=createTypedArray("float32",16),this.fillStyle="",this.strokeStyle="",this.lineWidth="",this.lineCap="",this.lineJoin="",this.miterLimit="",this.id=Math.random()}function CVContextData(){var e;for(this.stack=[],this.cArrPos=0,this.cTr=new Matrix,e=0;e<15;e+=1){var t=new CanvasContext;this.stack[e]=t}this._length=15,this.nativeContext=null,this.transformMat=new Matrix,this.currentOpacity=1,this.currentFillStyle="",this.appliedFillStyle="",this.currentStrokeStyle="",this.appliedStrokeStyle="",this.currentLineWidth="",this.appliedLineWidth="",this.currentLineCap="",this.appliedLineCap="",this.currentLineJoin="",this.appliedLineJoin="",this.appliedMiterLimit="",this.currentMiterLimit=""}function CVCompElement(e,t,n){this.completeLayers=!1,this.layers=e.layers,this.pendingElements=[],this.elements=createSizedArray(this.layers.length),this.initElement(e,t,n),this.tm=e.tm?PropertyFactory.getProp(this,e.tm,0,t.frameRate,this):{_placeholder:!0}}function CanvasRenderer(e,t){this.animationItem=e,this.renderConfig={clearCanvas:!t||void 0===t.clearCanvas||t.clearCanvas,context:t&&t.context||null,progressiveLoad:t&&t.progressiveLoad||!1,preserveAspectRatio:t&&t.preserveAspectRatio||"xMidYMid meet",imagePreserveAspectRatio:t&&t.imagePreserveAspectRatio||"xMidYMid slice",contentVisibility:t&&t.contentVisibility||"visible",className:t&&t.className||"",id:t&&t.id||"",runExpressions:!t||void 0===t.runExpressions||t.runExpressions},this.renderConfig.dpr=t&&t.dpr||1,this.animationItem.wrapper&&(this.renderConfig.dpr=t&&t.dpr||window.devicePixelRatio||1),this.renderedFrame=-1,this.globalData={frameNum:-1,_mdf:!1,renderConfig:this.renderConfig,currentGlobalAlpha:-1},this.contextData=new CVContextData,this.elements=[],this.pendingElements=[],this.transformMat=new Matrix,this.completeLayers=!1,this.rendererType="canvas",this.renderConfig.clearCanvas&&(this.ctxTransform=this.contextData.transform.bind(this.contextData),this.ctxOpacity=this.contextData.opacity.bind(this.contextData),this.ctxFillStyle=this.contextData.fillStyle.bind(this.contextData),this.ctxStrokeStyle=this.contextData.strokeStyle.bind(this.contextData),this.ctxLineWidth=this.contextData.lineWidth.bind(this.contextData),this.ctxLineCap=this.contextData.lineCap.bind(this.contextData),this.ctxLineJoin=this.contextData.lineJoin.bind(this.contextData),this.ctxMiterLimit=this.contextData.miterLimit.bind(this.contextData),this.ctxFill=this.contextData.fill.bind(this.contextData),this.ctxFillRect=this.contextData.fillRect.bind(this.contextData),this.ctxStroke=this.contextData.stroke.bind(this.contextData),this.save=this.contextData.save.bind(this.contextData))}function HBaseElement(){}function HSolidElement(e,t,n){this.initElement(e,t,n)}function HShapeElement(e,t,n){this.shapes=[],this.shapesData=e.shapes,this.stylesList=[],this.shapeModifiers=[],this.itemsData=[],this.processedElements=[],this.animatedContents=[],this.shapesContainer=createNS("g"),this.initElement(e,t,n),this.prevViewData=[],this.currentBBox={x:999999,y:-999999,h:0,w:0}}function HTextElement(e,t,n){this.textSpans=[],this.textPaths=[],this.currentBBox={x:999999,y:-999999,h:0,w:0},this.renderType="svg",this.isMasked=!1,this.initElement(e,t,n)}function HCameraElement(e,t,n){this.initFrame(),this.initBaseData(e,t,n),this.initHierarchy();var r=PropertyFactory.getProp;if(this.pe=r(this,e.pe,0,0,this),e.ks.p.s?(this.px=r(this,e.ks.p.x,1,0,this),this.py=r(this,e.ks.p.y,1,0,this),this.pz=r(this,e.ks.p.z,1,0,this)):this.p=r(this,e.ks.p,1,0,this),e.ks.a&&(this.a=r(this,e.ks.a,1,0,this)),e.ks.or.k.length&&e.ks.or.k[0].to){var a,i=e.ks.or.k.length;for(a=0;a<i;a+=1)e.ks.or.k[a].to=null,e.ks.or.k[a].ti=null}this.or=r(this,e.ks.or,1,degToRads,this),this.or.sh=!0,this.rx=r(this,e.ks.rx,0,degToRads,this),this.ry=r(this,e.ks.ry,0,degToRads,this),this.rz=r(this,e.ks.rz,0,degToRads,this),this.mat=new Matrix,this._prevMat=new Matrix,this._isFirstFrame=!0,this.finalTransform={mProp:this}}function HImageElement(e,t,n){this.assetData=t.getAssetData(e.refId),this.initElement(e,t,n)}function HybridRendererBase(e,t){this.animationItem=e,this.layers=null,this.renderedFrame=-1,this.renderConfig={className:t&&t.className||"",imagePreserveAspectRatio:t&&t.imagePreserveAspectRatio||"xMidYMid slice",hideOnTransparent:!(t&&!1===t.hideOnTransparent),filterSize:{width:t&&t.filterSize&&t.filterSize.width||"400%",height:t&&t.filterSize&&t.filterSize.height||"400%",x:t&&t.filterSize&&t.filterSize.x||"-100%",y:t&&t.filterSize&&t.filterSize.y||"-100%"}},this.globalData={_mdf:!1,frameNum:-1,renderConfig:this.renderConfig},this.pendingElements=[],this.elements=[],this.threeDElements=[],this.destroyed=!1,this.camera=null,this.supports3d=!0,this.rendererType="html"}function HCompElement(e,t,n){this.layers=e.layers,this.supports3d=!e.hasMask,this.completeLayers=!1,this.pendingElements=[],this.elements=this.layers?createSizedArray(this.layers.length):[],this.initElement(e,t,n),this.tm=e.tm?PropertyFactory.getProp(this,e.tm,0,t.frameRate,this):{_placeholder:!0}}function HybridRenderer(e,t){this.animationItem=e,this.layers=null,this.renderedFrame=-1,this.renderConfig={className:t&&t.className||"",imagePreserveAspectRatio:t&&t.imagePreserveAspectRatio||"xMidYMid slice",hideOnTransparent:!(t&&!1===t.hideOnTransparent),filterSize:{width:t&&t.filterSize&&t.filterSize.width||"400%",height:t&&t.filterSize&&t.filterSize.height||"400%",x:t&&t.filterSize&&t.filterSize.x||"-100%",y:t&&t.filterSize&&t.filterSize.y||"-100%"},runExpressions:!t||void 0===t.runExpressions||t.runExpressions},this.globalData={_mdf:!1,frameNum:-1,renderConfig:this.renderConfig},this.pendingElements=[],this.elements=[],this.threeDElements=[],this.destroyed=!1,this.camera=null,this.supports3d=!0,this.rendererType="html"}CVBaseElement.prototype={createElements:function(){},initRendererElement:function(){},createContainerElements:function(){if(this.data.tt>=1){this.buffers=[];var e=this.globalData.canvasContext,t=assetLoader.createCanvas(e.canvas.width,e.canvas.height);this.buffers.push(t);var n=assetLoader.createCanvas(e.canvas.width,e.canvas.height);this.buffers.push(n),this.data.tt>=3&&!document._isProxy&&assetLoader.loadLumaCanvas()}this.canvasContext=this.globalData.canvasContext,this.transformCanvas=this.globalData.transformCanvas,this.renderableEffectsManager=new CVEffects(this),this.searchEffectTransforms()},createContent:function(){},setBlendMode:function(){var e=this.globalData;if(e.blendMode!==this.data.bm){e.blendMode=this.data.bm;var t=getBlendMode(this.data.bm);e.canvasContext.globalCompositeOperation=t}},createRenderableComponents:function(){this.maskManager=new CVMaskElement(this.data,this),this.transformEffects=this.renderableEffectsManager.getEffects(effectTypes.TRANSFORM_EFFECT)},hideElement:function(){this.hidden||this.isInRange&&!this.isTransparent||(this.hidden=!0)},showElement:function(){this.isInRange&&!this.isTransparent&&(this.hidden=!1,this._isFirstFrame=!0,this.maskManager._isFirstFrame=!0)},clearCanvas:function(e){e.clearRect(this.transformCanvas.tx,this.transformCanvas.ty,this.transformCanvas.w*this.transformCanvas.sx,this.transformCanvas.h*this.transformCanvas.sy)},prepareLayer:function(){if(this.data.tt>=1){var e=this.buffers[0].getContext("2d");this.clearCanvas(e),e.drawImage(this.canvasContext.canvas,0,0),this.currentTransform=this.canvasContext.getTransform(),this.canvasContext.setTransform(1,0,0,1,0,0),this.clearCanvas(this.canvasContext),this.canvasContext.setTransform(this.currentTransform)}},exitLayer:function(){if(this.data.tt>=1){var e=this.buffers[1],t=e.getContext("2d");if(this.clearCanvas(t),t.drawImage(this.canvasContext.canvas,0,0),this.canvasContext.setTransform(1,0,0,1,0,0),this.clearCanvas(this.canvasContext),this.canvasContext.setTransform(this.currentTransform),this.comp.getElementById("tp"in this.data?this.data.tp:this.data.ind-1).renderFrame(!0),this.canvasContext.setTransform(1,0,0,1,0,0),this.data.tt>=3&&!document._isProxy){var n=assetLoader.getLumaCanvas(this.canvasContext.canvas);n.getContext("2d").drawImage(this.canvasContext.canvas,0,0),this.clearCanvas(this.canvasContext),this.canvasContext.drawImage(n,0,0)}this.canvasContext.globalCompositeOperation=operationsMap[this.data.tt],this.canvasContext.drawImage(e,0,0),this.canvasContext.globalCompositeOperation="destination-over",this.canvasContext.drawImage(this.buffers[0],0,0),this.canvasContext.setTransform(this.currentTransform),this.canvasContext.globalCompositeOperation="source-over"}},renderFrame:function(e){if(!this.hidden&&!this.data.hd&&(1!==this.data.td||e)){this.renderTransform(),this.renderRenderable(),this.renderLocalTransform(),this.setBlendMode();var t=0===this.data.ty;this.prepareLayer(),this.globalData.renderer.save(t),this.globalData.renderer.ctxTransform(this.finalTransform.localMat.props),this.globalData.renderer.ctxOpacity(this.finalTransform.localOpacity),this.renderInnerContent(),this.globalData.renderer.restore(t),this.exitLayer(),this.maskManager.hasMasks&&this.globalData.renderer.restore(!0),this._isFirstFrame&&(this._isFirstFrame=!1)}},destroy:function(){this.canvasContext=null,this.data=null,this.globalData=null,this.maskManager.destroy()},mHelper:new Matrix},CVBaseElement.prototype.hide=CVBaseElement.prototype.hideElement,CVBaseElement.prototype.show=CVBaseElement.prototype.showElement,CVShapeData.prototype.setAsAnimated=SVGShapeData.prototype.setAsAnimated,extendPrototype([BaseElement,TransformElement,CVBaseElement,IShapeElement,HierarchyElement,FrameElement,RenderableElement],CVShapeElement),CVShapeElement.prototype.initElement=RenderableDOMElement.prototype.initElement,CVShapeElement.prototype.transformHelper={opacity:1,_opMdf:!1},CVShapeElement.prototype.dashResetter=[],CVShapeElement.prototype.createContent=function(){this.searchShapes(this.shapesData,this.itemsData,this.prevViewData,!0,[])},CVShapeElement.prototype.createStyleElement=function(e,t){var n={data:e,type:e.ty,preTransforms:this.transformsManager.addTransformSequence(t),transforms:[],elements:[],closed:!0===e.hd},r={};if("fl"===e.ty||"st"===e.ty?(r.c=PropertyFactory.getProp(this,e.c,1,255,this),r.c.k||(n.co="rgb("+bmFloor(r.c.v[0])+","+bmFloor(r.c.v[1])+","+bmFloor(r.c.v[2])+")")):"gf"!==e.ty&&"gs"!==e.ty||(r.s=PropertyFactory.getProp(this,e.s,1,null,this),r.e=PropertyFactory.getProp(this,e.e,1,null,this),r.h=PropertyFactory.getProp(this,e.h||{k:0},0,.01,this),r.a=PropertyFactory.getProp(this,e.a||{k:0},0,degToRads,this),r.g=new GradientProperty(this,e.g,this)),r.o=PropertyFactory.getProp(this,e.o,0,.01,this),"st"===e.ty||"gs"===e.ty){if(n.lc=lineCapEnum[e.lc||2],n.lj=lineJoinEnum[e.lj||2],1==e.lj&&(n.ml=e.ml),r.w=PropertyFactory.getProp(this,e.w,0,null,this),r.w.k||(n.wi=r.w.v),e.d){var a=new DashProperty(this,e.d,"canvas",this);r.d=a,r.d.k||(n.da=r.d.dashArray,n.do=r.d.dashoffset[0])}}else n.r=2===e.r?"evenodd":"nonzero";return this.stylesList.push(n),r.style=n,r},CVShapeElement.prototype.createGroupElement=function(){return{it:[],prevViewData:[]}},CVShapeElement.prototype.createTransformElement=function(e){return{transform:{opacity:1,_opMdf:!1,key:this.transformsManager.getNewKey(),op:PropertyFactory.getProp(this,e.o,0,.01,this),mProps:TransformPropertyFactory.getTransformProperty(this,e,this)}}},CVShapeElement.prototype.createShapeElement=function(e){var t=new CVShapeData(this,e,this.stylesList,this.transformsManager);return this.shapes.push(t),this.addShapeToModifiers(t),t},CVShapeElement.prototype.reloadShapes=function(){var e;this._isFirstFrame=!0;var t=this.itemsData.length;for(e=0;e<t;e+=1)this.prevViewData[e]=this.itemsData[e];for(this.searchShapes(this.shapesData,this.itemsData,this.prevViewData,!0,[]),t=this.dynamicProperties.length,e=0;e<t;e+=1)this.dynamicProperties[e].getValue();this.renderModifiers(),this.transformsManager.processSequences(this._isFirstFrame)},CVShapeElement.prototype.addTransformToStyleList=function(e){var t,n=this.stylesList.length;for(t=0;t<n;t+=1)this.stylesList[t].closed||this.stylesList[t].transforms.push(e)},CVShapeElement.prototype.removeTransformFromStyleList=function(){var e,t=this.stylesList.length;for(e=0;e<t;e+=1)this.stylesList[e].closed||this.stylesList[e].transforms.pop()},CVShapeElement.prototype.closeStyles=function(e){var t,n=e.length;for(t=0;t<n;t+=1)e[t].closed=!0},CVShapeElement.prototype.searchShapes=function(e,t,n,r,a){var i,s,o,l,u,c,h=e.length-1,p=[],f=[],d=[].concat(a);for(i=h;i>=0;i-=1){if((l=this.searchProcessedElement(e[i]))?t[i]=n[l-1]:e[i]._shouldRender=r,"fl"===e[i].ty||"st"===e[i].ty||"gf"===e[i].ty||"gs"===e[i].ty)l?t[i].style.closed=!1:t[i]=this.createStyleElement(e[i],d),p.push(t[i].style);else if("gr"===e[i].ty){if(l)for(o=t[i].it.length,s=0;s<o;s+=1)t[i].prevViewData[s]=t[i].it[s];else t[i]=this.createGroupElement(e[i]);this.searchShapes(e[i].it,t[i].it,t[i].prevViewData,r,d)}else"tr"===e[i].ty?(l||(c=this.createTransformElement(e[i]),t[i]=c),d.push(t[i]),this.addTransformToStyleList(t[i])):"sh"===e[i].ty||"rc"===e[i].ty||"el"===e[i].ty||"sr"===e[i].ty?l||(t[i]=this.createShapeElement(e[i])):"tm"===e[i].ty||"rd"===e[i].ty||"pb"===e[i].ty||"zz"===e[i].ty||"op"===e[i].ty?(l?(u=t[i]).closed=!1:((u=ShapeModifiers.getModifier(e[i].ty)).init(this,e[i]),t[i]=u,this.shapeModifiers.push(u)),f.push(u)):"rp"===e[i].ty&&(l?(u=t[i]).closed=!0:(u=ShapeModifiers.getModifier(e[i].ty),t[i]=u,u.init(this,e,i,t),this.shapeModifiers.push(u),r=!1),f.push(u));this.addProcessedElement(e[i],i+1)}for(this.removeTransformFromStyleList(),this.closeStyles(p),h=f.length,i=0;i<h;i+=1)f[i].closed=!0},CVShapeElement.prototype.renderInnerContent=function(){this.transformHelper.opacity=1,this.transformHelper._opMdf=!1,this.renderModifiers(),this.transformsManager.processSequences(this._isFirstFrame),this.renderShape(this.transformHelper,this.shapesData,this.itemsData,!0)},CVShapeElement.prototype.renderShapeTransform=function(e,t){(e._opMdf||t.op._mdf||this._isFirstFrame)&&(t.opacity=e.opacity,t.opacity*=t.op.v,t._opMdf=!0)},CVShapeElement.prototype.drawLayer=function(){var e,t,n,r,a,i,s,o,l,u=this.stylesList.length,c=this.globalData.renderer,h=this.globalData.canvasContext;for(e=0;e<u;e+=1)if(("st"!==(o=(l=this.stylesList[e]).type)&&"gs"!==o||0!==l.wi)&&l.data._shouldRender&&0!==l.coOp&&0!==this.globalData.currentGlobalAlpha){for(c.save(),i=l.elements,"st"===o||"gs"===o?(c.ctxStrokeStyle("st"===o?l.co:l.grd),c.ctxLineWidth(l.wi),c.ctxLineCap(l.lc),c.ctxLineJoin(l.lj),c.ctxMiterLimit(l.ml||0)):c.ctxFillStyle("fl"===o?l.co:l.grd),c.ctxOpacity(l.coOp),"st"!==o&&"gs"!==o&&h.beginPath(),c.ctxTransform(l.preTransforms.finalTransform.props),n=i.length,t=0;t<n;t+=1){for("st"!==o&&"gs"!==o||(h.beginPath(),l.da&&(h.setLineDash(l.da),h.lineDashOffset=l.do)),a=(s=i[t].trNodes).length,r=0;r<a;r+=1)"m"===s[r].t?h.moveTo(s[r].p[0],s[r].p[1]):"c"===s[r].t?h.bezierCurveTo(s[r].pts[0],s[r].pts[1],s[r].pts[2],s[r].pts[3],s[r].pts[4],s[r].pts[5]):h.closePath();"st"!==o&&"gs"!==o||(c.ctxStroke(),l.da&&h.setLineDash(this.dashResetter))}"st"!==o&&"gs"!==o&&this.globalData.renderer.ctxFill(l.r),c.restore()}},CVShapeElement.prototype.renderShape=function(e,t,n,r){var a,i;for(i=e,a=t.length-1;a>=0;a-=1)"tr"===t[a].ty?(i=n[a].transform,this.renderShapeTransform(e,i)):"sh"===t[a].ty||"el"===t[a].ty||"rc"===t[a].ty||"sr"===t[a].ty?this.renderPath(t[a],n[a]):"fl"===t[a].ty?this.renderFill(t[a],n[a],i):"st"===t[a].ty?this.renderStroke(t[a],n[a],i):"gf"===t[a].ty||"gs"===t[a].ty?this.renderGradientFill(t[a],n[a],i):"gr"===t[a].ty?this.renderShape(i,t[a].it,n[a].it):t[a].ty;r&&this.drawLayer()},CVShapeElement.prototype.renderStyledShape=function(e,t){if(this._isFirstFrame||t._mdf||e.transforms._mdf){var n,r,a,i=e.trNodes,s=t.paths,o=s._length;i.length=0;var l=e.transforms.finalTransform;for(a=0;a<o;a+=1){var u=s.shapes[a];if(u&&u.v){for(r=u._length,n=1;n<r;n+=1)1===n&&i.push({t:"m",p:l.applyToPointArray(u.v[0][0],u.v[0][1],0)}),i.push({t:"c",pts:l.applyToTriplePoints(u.o[n-1],u.i[n],u.v[n])});1===r&&i.push({t:"m",p:l.applyToPointArray(u.v[0][0],u.v[0][1],0)}),u.c&&r&&(i.push({t:"c",pts:l.applyToTriplePoints(u.o[n-1],u.i[0],u.v[0])}),i.push({t:"z"}))}}e.trNodes=i}},CVShapeElement.prototype.renderPath=function(e,t){if(!0!==e.hd&&e._shouldRender){var n,r=t.styledShapes.length;for(n=0;n<r;n+=1)this.renderStyledShape(t.styledShapes[n],t.sh)}},CVShapeElement.prototype.renderFill=function(e,t,n){var r=t.style;(t.c._mdf||this._isFirstFrame)&&(r.co="rgb("+bmFloor(t.c.v[0])+","+bmFloor(t.c.v[1])+","+bmFloor(t.c.v[2])+")"),(t.o._mdf||n._opMdf||this._isFirstFrame)&&(r.coOp=t.o.v*n.opacity)},CVShapeElement.prototype.renderGradientFill=function(e,t,n){var r,a=t.style;if(!a.grd||t.g._mdf||t.s._mdf||t.e._mdf||1!==e.t&&(t.h._mdf||t.a._mdf)){var i,s=this.globalData.canvasContext,o=t.s.v,l=t.e.v;if(1===e.t)r=s.createLinearGradient(o[0],o[1],l[0],l[1]);else{var u=Math.sqrt(Math.pow(o[0]-l[0],2)+Math.pow(o[1]-l[1],2)),c=Math.atan2(l[1]-o[1],l[0]-o[0]),h=t.h.v;h>=1?h=.99:h<=-1&&(h=-.99);var p=u*h,f=Math.cos(c+t.a.v)*p+o[0],d=Math.sin(c+t.a.v)*p+o[1];r=s.createRadialGradient(f,d,0,o[0],o[1],u)}var m=e.g.p,g=t.g.c,y=1;for(i=0;i<m;i+=1)t.g._hasOpacity&&t.g._collapsable&&(y=t.g.o[2*i+1]),r.addColorStop(g[4*i]/100,"rgba("+g[4*i+1]+","+g[4*i+2]+","+g[4*i+3]+","+y+")");a.grd=r}a.coOp=t.o.v*n.opacity},CVShapeElement.prototype.renderStroke=function(e,t,n){var r=t.style,a=t.d;a&&(a._mdf||this._isFirstFrame)&&(r.da=a.dashArray,r.do=a.dashoffset[0]),(t.c._mdf||this._isFirstFrame)&&(r.co="rgb("+bmFloor(t.c.v[0])+","+bmFloor(t.c.v[1])+","+bmFloor(t.c.v[2])+")"),(t.o._mdf||n._opMdf||this._isFirstFrame)&&(r.coOp=t.o.v*n.opacity),(t.w._mdf||this._isFirstFrame)&&(r.wi=t.w.v)},CVShapeElement.prototype.destroy=function(){this.shapesData=null,this.globalData=null,this.canvasContext=null,this.stylesList.length=0,this.itemsData.length=0},extendPrototype([BaseElement,TransformElement,CVBaseElement,HierarchyElement,FrameElement,RenderableElement,ITextElement],CVTextElement),CVTextElement.prototype.tHelper=createTag("canvas").getContext("2d"),CVTextElement.prototype.buildNewText=function(){var e=this.textProperty.currentData;this.renderedLetters=createSizedArray(e.l?e.l.length:0);var t=!1;e.fc?(t=!0,this.values.fill=this.buildColor(e.fc)):this.values.fill="rgba(0,0,0,0)",this.fill=t;var n=!1;e.sc&&(n=!0,this.values.stroke=this.buildColor(e.sc),this.values.sWidth=e.sw);var r,a,i,s,o,l,u,c,h,p,f,d,m=this.globalData.fontManager.getFontByName(e.f),g=e.l,y=this.mHelper;this.stroke=n,this.values.fValue=e.finalSize+"px "+this.globalData.fontManager.getFontByName(e.f).fFamily,a=e.finalText.length;var v=this.data.singleShape,b=.001*e.tr*e.finalSize,k=0,x=0,S=!0,w=0;for(r=0;r<a;r+=1){s=(i=this.globalData.fontManager.getCharData(e.finalText[r],m.fStyle,this.globalData.fontManager.getFontByName(e.f).fFamily))&&i.data||{},y.reset(),v&&g[r].n&&(k=-b,x+=e.yOffset,x+=S?1:0,S=!1),h=(u=s.shapes?s.shapes[0].it:[]).length,y.scale(e.finalSize/100,e.finalSize/100),v&&this.applyTextPropertiesToMatrix(e,y,g[r].line,k,x),f=createSizedArray(h-1);var E=0;for(c=0;c<h;c+=1)if("sh"===u[c].ty){for(l=u[c].ks.k.i.length,p=u[c].ks.k,d=[],o=1;o<l;o+=1)1===o&&d.push(y.applyToX(p.v[0][0],p.v[0][1],0),y.applyToY(p.v[0][0],p.v[0][1],0)),d.push(y.applyToX(p.o[o-1][0],p.o[o-1][1],0),y.applyToY(p.o[o-1][0],p.o[o-1][1],0),y.applyToX(p.i[o][0],p.i[o][1],0),y.applyToY(p.i[o][0],p.i[o][1],0),y.applyToX(p.v[o][0],p.v[o][1],0),y.applyToY(p.v[o][0],p.v[o][1],0));d.push(y.applyToX(p.o[o-1][0],p.o[o-1][1],0),y.applyToY(p.o[o-1][0],p.o[o-1][1],0),y.applyToX(p.i[0][0],p.i[0][1],0),y.applyToY(p.i[0][0],p.i[0][1],0),y.applyToX(p.v[0][0],p.v[0][1],0),y.applyToY(p.v[0][0],p.v[0][1],0)),f[E]=d,E+=1}v&&(k+=g[r].l,k+=b),this.textSpans[w]?this.textSpans[w].elem=f:this.textSpans[w]={elem:f},w+=1}},CVTextElement.prototype.renderInnerContent=function(){var e,t,n,r,a,i;this.validateText(),this.canvasContext.font=this.values.fValue,this.globalData.renderer.ctxLineCap("butt"),this.globalData.renderer.ctxLineJoin("miter"),this.globalData.renderer.ctxMiterLimit(4),this.data.singleShape||this.textAnimator.getMeasures(this.textProperty.currentData,this.lettersChangedFlag);var s,o=this.textAnimator.renderedLetters,l=this.textProperty.currentData.l;t=l.length;var u,c,h=null,p=null,f=null,d=this.globalData.renderer;for(e=0;e<t;e+=1)if(!l[e].n){if((s=o[e])&&(d.save(),d.ctxTransform(s.p),d.ctxOpacity(s.o)),this.fill){for(s&&s.fc?h!==s.fc&&(d.ctxFillStyle(s.fc),h=s.fc):h!==this.values.fill&&(h=this.values.fill,d.ctxFillStyle(this.values.fill)),r=(u=this.textSpans[e].elem).length,this.globalData.canvasContext.beginPath(),n=0;n<r;n+=1)for(i=(c=u[n]).length,this.globalData.canvasContext.moveTo(c[0],c[1]),a=2;a<i;a+=6)this.globalData.canvasContext.bezierCurveTo(c[a],c[a+1],c[a+2],c[a+3],c[a+4],c[a+5]);this.globalData.canvasContext.closePath(),d.ctxFill()}if(this.stroke){for(s&&s.sw?f!==s.sw&&(f=s.sw,d.ctxLineWidth(s.sw)):f!==this.values.sWidth&&(f=this.values.sWidth,d.ctxLineWidth(this.values.sWidth)),s&&s.sc?p!==s.sc&&(p=s.sc,d.ctxStrokeStyle(s.sc)):p!==this.values.stroke&&(p=this.values.stroke,d.ctxStrokeStyle(this.values.stroke)),r=(u=this.textSpans[e].elem).length,this.globalData.canvasContext.beginPath(),n=0;n<r;n+=1)for(i=(c=u[n]).length,this.globalData.canvasContext.moveTo(c[0],c[1]),a=2;a<i;a+=6)this.globalData.canvasContext.bezierCurveTo(c[a],c[a+1],c[a+2],c[a+3],c[a+4],c[a+5]);this.globalData.canvasContext.closePath(),d.ctxStroke()}s&&this.globalData.renderer.restore()}},extendPrototype([BaseElement,TransformElement,CVBaseElement,HierarchyElement,FrameElement,RenderableElement],CVImageElement),CVImageElement.prototype.initElement=SVGShapeElement.prototype.initElement,CVImageElement.prototype.prepareFrame=IImageElement.prototype.prepareFrame,CVImageElement.prototype.createContent=function(){if(this.img.width&&(this.assetData.w!==this.img.width||this.assetData.h!==this.img.height)){var e=createTag("canvas");e.width=this.assetData.w,e.height=this.assetData.h;var t,n,r=e.getContext("2d"),a=this.img.width,i=this.img.height,s=a/i,o=this.assetData.w/this.assetData.h,l=this.assetData.pr||this.globalData.renderConfig.imagePreserveAspectRatio;s>o&&"xMidYMid slice"===l||s<o&&"xMidYMid slice"!==l?t=(n=i)*o:n=(t=a)/o,r.drawImage(this.img,(a-t)/2,(i-n)/2,t,n,0,0,this.assetData.w,this.assetData.h),this.img=e}},CVImageElement.prototype.renderInnerContent=function(){this.canvasContext.drawImage(this.img,0,0)},CVImageElement.prototype.destroy=function(){this.img=null},extendPrototype([BaseElement,TransformElement,CVBaseElement,HierarchyElement,FrameElement,RenderableElement],CVSolidElement),CVSolidElement.prototype.initElement=SVGShapeElement.prototype.initElement,CVSolidElement.prototype.prepareFrame=IImageElement.prototype.prepareFrame,CVSolidElement.prototype.renderInnerContent=function(){this.globalData.renderer.ctxFillStyle(this.data.sc),this.globalData.renderer.ctxFillRect(0,0,this.data.sw,this.data.sh)},extendPrototype([BaseRenderer],CanvasRendererBase),CanvasRendererBase.prototype.createShape=function(e){return new CVShapeElement(e,this.globalData,this)},CanvasRendererBase.prototype.createText=function(e){return new CVTextElement(e,this.globalData,this)},CanvasRendererBase.prototype.createImage=function(e){return new CVImageElement(e,this.globalData,this)},CanvasRendererBase.prototype.createSolid=function(e){return new CVSolidElement(e,this.globalData,this)},CanvasRendererBase.prototype.createNull=SVGRenderer.prototype.createNull,CanvasRendererBase.prototype.ctxTransform=function(e){1===e[0]&&0===e[1]&&0===e[4]&&1===e[5]&&0===e[12]&&0===e[13]||this.canvasContext.transform(e[0],e[1],e[4],e[5],e[12],e[13])},CanvasRendererBase.prototype.ctxOpacity=function(e){this.canvasContext.globalAlpha*=e<0?0:e},CanvasRendererBase.prototype.ctxFillStyle=function(e){this.canvasContext.fillStyle=e},CanvasRendererBase.prototype.ctxStrokeStyle=function(e){this.canvasContext.strokeStyle=e},CanvasRendererBase.prototype.ctxLineWidth=function(e){this.canvasContext.lineWidth=e},CanvasRendererBase.prototype.ctxLineCap=function(e){this.canvasContext.lineCap=e},CanvasRendererBase.prototype.ctxLineJoin=function(e){this.canvasContext.lineJoin=e},CanvasRendererBase.prototype.ctxMiterLimit=function(e){this.canvasContext.miterLimit=e},CanvasRendererBase.prototype.ctxFill=function(e){this.canvasContext.fill(e)},CanvasRendererBase.prototype.ctxFillRect=function(e,t,n,r){this.canvasContext.fillRect(e,t,n,r)},CanvasRendererBase.prototype.ctxStroke=function(){this.canvasContext.stroke()},CanvasRendererBase.prototype.reset=function(){this.renderConfig.clearCanvas?this.contextData.reset():this.canvasContext.restore()},CanvasRendererBase.prototype.save=function(){this.canvasContext.save()},CanvasRendererBase.prototype.restore=function(e){this.renderConfig.clearCanvas?(e&&(this.globalData.blendMode="source-over"),this.contextData.restore(e)):this.canvasContext.restore()},CanvasRendererBase.prototype.configAnimation=function(e){if(this.animationItem.wrapper){this.animationItem.container=createTag("canvas");var t=this.animationItem.container.style;t.width="100%",t.height="100%";var n="0px 0px 0px";t.transformOrigin=n,t.mozTransformOrigin=n,t.webkitTransformOrigin=n,t["-webkit-transform"]=n,t.contentVisibility=this.renderConfig.contentVisibility,this.animationItem.wrapper.appendChild(this.animationItem.container),this.canvasContext=this.animationItem.container.getContext("2d"),this.renderConfig.className&&this.animationItem.container.setAttribute("class",this.renderConfig.className),this.renderConfig.id&&this.animationItem.container.setAttribute("id",this.renderConfig.id)}else this.canvasContext=this.renderConfig.context;this.contextData.setContext(this.canvasContext),this.data=e,this.layers=e.layers,this.transformCanvas={w:e.w,h:e.h,sx:0,sy:0,tx:0,ty:0},this.setupGlobalData(e,document.body),this.globalData.canvasContext=this.canvasContext,this.globalData.renderer=this,this.globalData.isDashed=!1,this.globalData.progressiveLoad=this.renderConfig.progressiveLoad,this.globalData.transformCanvas=this.transformCanvas,this.elements=createSizedArray(e.layers.length),this.updateContainerSize()},CanvasRendererBase.prototype.updateContainerSize=function(e,t){var n,r,a,i;if(this.reset(),e?(n=e,r=t,this.canvasContext.canvas.width=n,this.canvasContext.canvas.height=r):(this.animationItem.wrapper&&this.animationItem.container?(n=this.animationItem.wrapper.offsetWidth,r=this.animationItem.wrapper.offsetHeight):(n=this.canvasContext.canvas.width,r=this.canvasContext.canvas.height),this.canvasContext.canvas.width=n*this.renderConfig.dpr,this.canvasContext.canvas.height=r*this.renderConfig.dpr),-1!==this.renderConfig.preserveAspectRatio.indexOf("meet")||-1!==this.renderConfig.preserveAspectRatio.indexOf("slice")){var s=this.renderConfig.preserveAspectRatio.split(" "),o=s[1]||"meet",l=s[0]||"xMidYMid",u=l.substr(0,4),c=l.substr(4);a=n/r,(i=this.transformCanvas.w/this.transformCanvas.h)>a&&"meet"===o||i<a&&"slice"===o?(this.transformCanvas.sx=n/(this.transformCanvas.w/this.renderConfig.dpr),this.transformCanvas.sy=n/(this.transformCanvas.w/this.renderConfig.dpr)):(this.transformCanvas.sx=r/(this.transformCanvas.h/this.renderConfig.dpr),this.transformCanvas.sy=r/(this.transformCanvas.h/this.renderConfig.dpr)),this.transformCanvas.tx="xMid"===u&&(i<a&&"meet"===o||i>a&&"slice"===o)?(n-this.transformCanvas.w*(r/this.transformCanvas.h))/2*this.renderConfig.dpr:"xMax"===u&&(i<a&&"meet"===o||i>a&&"slice"===o)?(n-this.transformCanvas.w*(r/this.transformCanvas.h))*this.renderConfig.dpr:0,this.transformCanvas.ty="YMid"===c&&(i>a&&"meet"===o||i<a&&"slice"===o)?(r-this.transformCanvas.h*(n/this.transformCanvas.w))/2*this.renderConfig.dpr:"YMax"===c&&(i>a&&"meet"===o||i<a&&"slice"===o)?(r-this.transformCanvas.h*(n/this.transformCanvas.w))*this.renderConfig.dpr:0}else"none"===this.renderConfig.preserveAspectRatio?(this.transformCanvas.sx=n/(this.transformCanvas.w/this.renderConfig.dpr),this.transformCanvas.sy=r/(this.transformCanvas.h/this.renderConfig.dpr),this.transformCanvas.tx=0,this.transformCanvas.ty=0):(this.transformCanvas.sx=this.renderConfig.dpr,this.transformCanvas.sy=this.renderConfig.dpr,this.transformCanvas.tx=0,this.transformCanvas.ty=0);this.transformCanvas.props=[this.transformCanvas.sx,0,0,0,0,this.transformCanvas.sy,0,0,0,0,1,0,this.transformCanvas.tx,this.transformCanvas.ty,0,1],this.ctxTransform(this.transformCanvas.props),this.canvasContext.beginPath(),this.canvasContext.rect(0,0,this.transformCanvas.w,this.transformCanvas.h),this.canvasContext.closePath(),this.canvasContext.clip(),this.renderFrame(this.renderedFrame,!0)},CanvasRendererBase.prototype.destroy=function(){var e;for(this.renderConfig.clearCanvas&&this.animationItem.wrapper&&(this.animationItem.wrapper.innerText=""),e=(this.layers?this.layers.length:0)-1;e>=0;e-=1)this.elements[e]&&this.elements[e].destroy&&this.elements[e].destroy();this.elements.length=0,this.globalData.canvasContext=null,this.animationItem.container=null,this.destroyed=!0},CanvasRendererBase.prototype.renderFrame=function(e,t){if((this.renderedFrame!==e||!0!==this.renderConfig.clearCanvas||t)&&!this.destroyed&&-1!==e){var n;this.renderedFrame=e,this.globalData.frameNum=e-this.animationItem._isFirstFrame,this.globalData.frameId+=1,this.globalData._mdf=!this.renderConfig.clearCanvas||t,this.globalData.projectInterface.currentFrame=e;var r=this.layers.length;for(this.completeLayers||this.checkLayers(e),n=r-1;n>=0;n-=1)(this.completeLayers||this.elements[n])&&this.elements[n].prepareFrame(e-this.layers[n].st);if(this.globalData._mdf){for(!0===this.renderConfig.clearCanvas?this.canvasContext.clearRect(0,0,this.transformCanvas.w,this.transformCanvas.h):this.save(),n=r-1;n>=0;n-=1)(this.completeLayers||this.elements[n])&&this.elements[n].renderFrame();!0!==this.renderConfig.clearCanvas&&this.restore()}}},CanvasRendererBase.prototype.buildItem=function(e){var t=this.elements;if(!t[e]&&99!==this.layers[e].ty){var n=this.createItem(this.layers[e],this,this.globalData);t[e]=n,n.initExpressions()}},CanvasRendererBase.prototype.checkPendingElements=function(){for(;this.pendingElements.length;)this.pendingElements.pop().checkParenting()},CanvasRendererBase.prototype.hide=function(){this.animationItem.container.style.display="none"},CanvasRendererBase.prototype.show=function(){this.animationItem.container.style.display="block"},CVContextData.prototype.duplicate=function(){var e=2*this._length,t=0;for(t=this._length;t<e;t+=1)this.stack[t]=new CanvasContext;this._length=e},CVContextData.prototype.reset=function(){this.cArrPos=0,this.cTr.reset(),this.stack[this.cArrPos].opacity=1},CVContextData.prototype.restore=function(e){this.cArrPos-=1;var t,n=this.stack[this.cArrPos],r=n.transform,a=this.cTr.props;for(t=0;t<16;t+=1)a[t]=r[t];if(e){this.nativeContext.restore();var i=this.stack[this.cArrPos+1];this.appliedFillStyle=i.fillStyle,this.appliedStrokeStyle=i.strokeStyle,this.appliedLineWidth=i.lineWidth,this.appliedLineCap=i.lineCap,this.appliedLineJoin=i.lineJoin,this.appliedMiterLimit=i.miterLimit}this.nativeContext.setTransform(r[0],r[1],r[4],r[5],r[12],r[13]),(e||-1!==n.opacity&&this.currentOpacity!==n.opacity)&&(this.nativeContext.globalAlpha=n.opacity,this.currentOpacity=n.opacity),this.currentFillStyle=n.fillStyle,this.currentStrokeStyle=n.strokeStyle,this.currentLineWidth=n.lineWidth,this.currentLineCap=n.lineCap,this.currentLineJoin=n.lineJoin,this.currentMiterLimit=n.miterLimit},CVContextData.prototype.save=function(e){e&&this.nativeContext.save();var t=this.cTr.props;this._length<=this.cArrPos&&this.duplicate();var n,r=this.stack[this.cArrPos];for(n=0;n<16;n+=1)r.transform[n]=t[n];this.cArrPos+=1;var a=this.stack[this.cArrPos];a.opacity=r.opacity,a.fillStyle=r.fillStyle,a.strokeStyle=r.strokeStyle,a.lineWidth=r.lineWidth,a.lineCap=r.lineCap,a.lineJoin=r.lineJoin,a.miterLimit=r.miterLimit},CVContextData.prototype.setOpacity=function(e){this.stack[this.cArrPos].opacity=e},CVContextData.prototype.setContext=function(e){this.nativeContext=e},CVContextData.prototype.fillStyle=function(e){this.stack[this.cArrPos].fillStyle!==e&&(this.currentFillStyle=e,this.stack[this.cArrPos].fillStyle=e)},CVContextData.prototype.strokeStyle=function(e){this.stack[this.cArrPos].strokeStyle!==e&&(this.currentStrokeStyle=e,this.stack[this.cArrPos].strokeStyle=e)},CVContextData.prototype.lineWidth=function(e){this.stack[this.cArrPos].lineWidth!==e&&(this.currentLineWidth=e,this.stack[this.cArrPos].lineWidth=e)},CVContextData.prototype.lineCap=function(e){this.stack[this.cArrPos].lineCap!==e&&(this.currentLineCap=e,this.stack[this.cArrPos].lineCap=e)},CVContextData.prototype.lineJoin=function(e){this.stack[this.cArrPos].lineJoin!==e&&(this.currentLineJoin=e,this.stack[this.cArrPos].lineJoin=e)},CVContextData.prototype.miterLimit=function(e){this.stack[this.cArrPos].miterLimit!==e&&(this.currentMiterLimit=e,this.stack[this.cArrPos].miterLimit=e)},CVContextData.prototype.transform=function(e){this.transformMat.cloneFromProps(e);var t=this.cTr;this.transformMat.multiply(t),t.cloneFromProps(this.transformMat.props);var n=t.props;this.nativeContext.setTransform(n[0],n[1],n[4],n[5],n[12],n[13])},CVContextData.prototype.opacity=function(e){var t=this.stack[this.cArrPos].opacity;t*=e<0?0:e,this.stack[this.cArrPos].opacity!==t&&(this.currentOpacity!==e&&(this.nativeContext.globalAlpha=e,this.currentOpacity=e),this.stack[this.cArrPos].opacity=t)},CVContextData.prototype.fill=function(e){this.appliedFillStyle!==this.currentFillStyle&&(this.appliedFillStyle=this.currentFillStyle,this.nativeContext.fillStyle=this.appliedFillStyle),this.nativeContext.fill(e)},CVContextData.prototype.fillRect=function(e,t,n,r){this.appliedFillStyle!==this.currentFillStyle&&(this.appliedFillStyle=this.currentFillStyle,this.nativeContext.fillStyle=this.appliedFillStyle),this.nativeContext.fillRect(e,t,n,r)},CVContextData.prototype.stroke=function(){this.appliedStrokeStyle!==this.currentStrokeStyle&&(this.appliedStrokeStyle=this.currentStrokeStyle,this.nativeContext.strokeStyle=this.appliedStrokeStyle),this.appliedLineWidth!==this.currentLineWidth&&(this.appliedLineWidth=this.currentLineWidth,this.nativeContext.lineWidth=this.appliedLineWidth),this.appliedLineCap!==this.currentLineCap&&(this.appliedLineCap=this.currentLineCap,this.nativeContext.lineCap=this.appliedLineCap),this.appliedLineJoin!==this.currentLineJoin&&(this.appliedLineJoin=this.currentLineJoin,this.nativeContext.lineJoin=this.appliedLineJoin),this.appliedMiterLimit!==this.currentMiterLimit&&(this.appliedMiterLimit=this.currentMiterLimit,this.nativeContext.miterLimit=this.appliedMiterLimit),this.nativeContext.stroke()},extendPrototype([CanvasRendererBase,ICompElement,CVBaseElement],CVCompElement),CVCompElement.prototype.renderInnerContent=function(){var e,t=this.canvasContext;for(t.beginPath(),t.moveTo(0,0),t.lineTo(this.data.w,0),t.lineTo(this.data.w,this.data.h),t.lineTo(0,this.data.h),t.lineTo(0,0),t.clip(),e=this.layers.length-1;e>=0;e-=1)(this.completeLayers||this.elements[e])&&this.elements[e].renderFrame()},CVCompElement.prototype.destroy=function(){var e;for(e=this.layers.length-1;e>=0;e-=1)this.elements[e]&&this.elements[e].destroy();this.layers=null,this.elements=null},CVCompElement.prototype.createComp=function(e){return new CVCompElement(e,this.globalData,this)},extendPrototype([CanvasRendererBase],CanvasRenderer),CanvasRenderer.prototype.createComp=function(e){return new CVCompElement(e,this.globalData,this)},HBaseElement.prototype={checkBlendMode:function(){},initRendererElement:function(){this.baseElement=createTag(this.data.tg||"div"),this.data.hasMask?(this.svgElement=createNS("svg"),this.layerElement=createNS("g"),this.maskedElement=this.layerElement,this.svgElement.appendChild(this.layerElement),this.baseElement.appendChild(this.svgElement)):this.layerElement=this.baseElement,styleDiv(this.baseElement)},createContainerElements:function(){this.renderableEffectsManager=new CVEffects(this),this.transformedElement=this.baseElement,this.maskedElement=this.layerElement,this.data.ln&&this.layerElement.setAttribute("id",this.data.ln),this.data.cl&&this.layerElement.setAttribute("class",this.data.cl),0!==this.data.bm&&this.setBlendMode()},renderElement:function(){var e=this.transformedElement?this.transformedElement.style:{};if(this.finalTransform._matMdf){var t=this.finalTransform.mat.toCSS();e.transform=t,e.webkitTransform=t}this.finalTransform._opMdf&&(e.opacity=this.finalTransform.mProp.o.v)},renderFrame:function(){this.data.hd||this.hidden||(this.renderTransform(),this.renderRenderable(),this.renderElement(),this.renderInnerContent(),this._isFirstFrame&&(this._isFirstFrame=!1))},destroy:function(){this.layerElement=null,this.transformedElement=null,this.matteElement&&(this.matteElement=null),this.maskManager&&(this.maskManager.destroy(),this.maskManager=null)},createRenderableComponents:function(){this.maskManager=new MaskElement(this.data,this,this.globalData)},addEffects:function(){},setMatte:function(){}},HBaseElement.prototype.getBaseElement=SVGBaseElement.prototype.getBaseElement,HBaseElement.prototype.destroyBaseElement=HBaseElement.prototype.destroy,HBaseElement.prototype.buildElementParenting=BaseRenderer.prototype.buildElementParenting,extendPrototype([BaseElement,TransformElement,HBaseElement,HierarchyElement,FrameElement,RenderableDOMElement],HSolidElement),HSolidElement.prototype.createContent=function(){var e;this.data.hasMask?((e=createNS("rect")).setAttribute("width",this.data.sw),e.setAttribute("height",this.data.sh),e.setAttribute("fill",this.data.sc),this.svgElement.setAttribute("width",this.data.sw),this.svgElement.setAttribute("height",this.data.sh)):((e=createTag("div")).style.width=this.data.sw+"px",e.style.height=this.data.sh+"px",e.style.backgroundColor=this.data.sc),this.layerElement.appendChild(e)},extendPrototype([BaseElement,TransformElement,HSolidElement,SVGShapeElement,HBaseElement,HierarchyElement,FrameElement,RenderableElement],HShapeElement),HShapeElement.prototype._renderShapeFrame=HShapeElement.prototype.renderInnerContent,HShapeElement.prototype.createContent=function(){var e;if(this.baseElement.style.fontSize=0,this.data.hasMask)this.layerElement.appendChild(this.shapesContainer),e=this.svgElement;else{e=createNS("svg");var t=this.comp.data?this.comp.data:this.globalData.compSize;e.setAttribute("width",t.w),e.setAttribute("height",t.h),e.appendChild(this.shapesContainer),this.layerElement.appendChild(e)}this.searchShapes(this.shapesData,this.itemsData,this.prevViewData,this.shapesContainer,0,[],!0),this.filterUniqueShapes(),this.shapeCont=e},HShapeElement.prototype.getTransformedPoint=function(e,t){var n,r=e.length;for(n=0;n<r;n+=1)t=e[n].mProps.v.applyToPointArray(t[0],t[1],0);return t},HShapeElement.prototype.calculateShapeBoundingBox=function(e,t){var n,r,a,i,s,o=e.sh.v,l=e.transformers,u=o._length;if(!(u<=1)){for(n=0;n<u-1;n+=1)r=this.getTransformedPoint(l,o.v[n]),a=this.getTransformedPoint(l,o.o[n]),i=this.getTransformedPoint(l,o.i[n+1]),s=this.getTransformedPoint(l,o.v[n+1]),this.checkBounds(r,a,i,s,t);o.c&&(r=this.getTransformedPoint(l,o.v[n]),a=this.getTransformedPoint(l,o.o[n]),i=this.getTransformedPoint(l,o.i[0]),s=this.getTransformedPoint(l,o.v[0]),this.checkBounds(r,a,i,s,t))}},HShapeElement.prototype.checkBounds=function(e,t,n,r,a){this.getBoundsOfCurve(e,t,n,r);var i=this.shapeBoundingBox;a.x=bmMin(i.left,a.x),a.xMax=bmMax(i.right,a.xMax),a.y=bmMin(i.top,a.y),a.yMax=bmMax(i.bottom,a.yMax)},HShapeElement.prototype.shapeBoundingBox={left:0,right:0,top:0,bottom:0},HShapeElement.prototype.tempBoundingBox={x:0,xMax:0,y:0,yMax:0,width:0,height:0},HShapeElement.prototype.getBoundsOfCurve=function(e,t,n,r){for(var a,i,s,o,l,u,c,h=[[e[0],r[0]],[e[1],r[1]]],p=0;p<2;++p)i=6*e[p]-12*t[p]+6*n[p],a=-3*e[p]+9*t[p]-9*n[p]+3*r[p],s=3*t[p]-3*e[p],i|=0,s|=0,0==(a|=0)&&0===i||(0===a?(o=-s/i)>0&&o<1&&h[p].push(this.calculateF(o,e,t,n,r,p)):(l=i*i-4*s*a)>=0&&((u=(-i+bmSqrt(l))/(2*a))>0&&u<1&&h[p].push(this.calculateF(u,e,t,n,r,p)),(c=(-i-bmSqrt(l))/(2*a))>0&&c<1&&h[p].push(this.calculateF(c,e,t,n,r,p))));this.shapeBoundingBox.left=bmMin.apply(null,h[0]),this.shapeBoundingBox.top=bmMin.apply(null,h[1]),this.shapeBoundingBox.right=bmMax.apply(null,h[0]),this.shapeBoundingBox.bottom=bmMax.apply(null,h[1])},HShapeElement.prototype.calculateF=function(e,t,n,r,a,i){return bmPow(1-e,3)*t[i]+3*bmPow(1-e,2)*e*n[i]+3*(1-e)*bmPow(e,2)*r[i]+bmPow(e,3)*a[i]},HShapeElement.prototype.calculateBoundingBox=function(e,t){var n,r=e.length;for(n=0;n<r;n+=1)e[n]&&e[n].sh?this.calculateShapeBoundingBox(e[n],t):e[n]&&e[n].it?this.calculateBoundingBox(e[n].it,t):e[n]&&e[n].style&&e[n].w&&this.expandStrokeBoundingBox(e[n].w,t)},HShapeElement.prototype.expandStrokeBoundingBox=function(e,t){var n=0;if(e.keyframes){for(var r=0;r<e.keyframes.length;r+=1){var a=e.keyframes[r].s;a>n&&(n=a)}n*=e.mult}else n=e.v*e.mult;t.x-=n,t.xMax+=n,t.y-=n,t.yMax+=n},HShapeElement.prototype.currentBoxContains=function(e){return this.currentBBox.x<=e.x&&this.currentBBox.y<=e.y&&this.currentBBox.width+this.currentBBox.x>=e.x+e.width&&this.currentBBox.height+this.currentBBox.y>=e.y+e.height},HShapeElement.prototype.renderInnerContent=function(){if(this._renderShapeFrame(),!this.hidden&&(this._isFirstFrame||this._mdf)){var e=this.tempBoundingBox,t=999999;if(e.x=t,e.xMax=-t,e.y=t,e.yMax=-t,this.calculateBoundingBox(this.itemsData,e),e.width=e.xMax<e.x?0:e.xMax-e.x,e.height=e.yMax<e.y?0:e.yMax-e.y,this.currentBoxContains(e))return;var n=!1;if(this.currentBBox.w!==e.width&&(this.currentBBox.w=e.width,this.shapeCont.setAttribute("width",e.width),n=!0),this.currentBBox.h!==e.height&&(this.currentBBox.h=e.height,this.shapeCont.setAttribute("height",e.height),n=!0),n||this.currentBBox.x!==e.x||this.currentBBox.y!==e.y){this.currentBBox.w=e.width,this.currentBBox.h=e.height,this.currentBBox.x=e.x,this.currentBBox.y=e.y,this.shapeCont.setAttribute("viewBox",this.currentBBox.x+" "+this.currentBBox.y+" "+this.currentBBox.w+" "+this.currentBBox.h);var r=this.shapeCont.style,a="translate("+this.currentBBox.x+"px,"+this.currentBBox.y+"px)";r.transform=a,r.webkitTransform=a}}},extendPrototype([BaseElement,TransformElement,HBaseElement,HierarchyElement,FrameElement,RenderableDOMElement,ITextElement],HTextElement),HTextElement.prototype.createContent=function(){if(this.isMasked=this.checkMasks(),this.isMasked){this.renderType="svg",this.compW=this.comp.data.w,this.compH=this.comp.data.h,this.svgElement.setAttribute("width",this.compW),this.svgElement.setAttribute("height",this.compH);var e=createNS("g");this.maskedElement.appendChild(e),this.innerElem=e}else this.renderType="html",this.innerElem=this.layerElement;this.checkParenting()},HTextElement.prototype.buildNewText=function(){var e=this.textProperty.currentData;this.renderedLetters=createSizedArray(e.l?e.l.length:0);var t=this.innerElem.style,n=e.fc?this.buildColor(e.fc):"rgba(0,0,0,0)";t.fill=n,t.color=n,e.sc&&(t.stroke=this.buildColor(e.sc),t.strokeWidth=e.sw+"px");var r,a,i=this.globalData.fontManager.getFontByName(e.f);if(!this.globalData.fontManager.chars)if(t.fontSize=e.finalSize+"px",t.lineHeight=e.finalSize+"px",i.fClass)this.innerElem.className=i.fClass;else{t.fontFamily=i.fFamily;var s=e.fWeight,o=e.fStyle;t.fontStyle=o,t.fontWeight=s}var l,u,c,h=e.l;a=h.length;var p,f=this.mHelper,d="",m=0;for(r=0;r<a;r+=1){if(this.globalData.fontManager.chars?(this.textPaths[m]?l=this.textPaths[m]:((l=createNS("path")).setAttribute("stroke-linecap",lineCapEnum[1]),l.setAttribute("stroke-linejoin",lineJoinEnum[2]),l.setAttribute("stroke-miterlimit","4")),this.isMasked||(this.textSpans[m]?c=(u=this.textSpans[m]).children[0]:((u=createTag("div")).style.lineHeight=0,(c=createNS("svg")).appendChild(l),styleDiv(u)))):this.isMasked?l=this.textPaths[m]?this.textPaths[m]:createNS("text"):this.textSpans[m]?(u=this.textSpans[m],l=this.textPaths[m]):(styleDiv(u=createTag("span")),styleDiv(l=createTag("span")),u.appendChild(l)),this.globalData.fontManager.chars){var g,y=this.globalData.fontManager.getCharData(e.finalText[r],i.fStyle,this.globalData.fontManager.getFontByName(e.f).fFamily);if(g=y?y.data:null,f.reset(),g&&g.shapes&&g.shapes.length&&(p=g.shapes[0].it,f.scale(e.finalSize/100,e.finalSize/100),d=this.createPathShape(f,p),l.setAttribute("d",d)),this.isMasked)this.innerElem.appendChild(l);else{if(this.innerElem.appendChild(u),g&&g.shapes){document.body.appendChild(c);var v=c.getBBox();c.setAttribute("width",v.width+2),c.setAttribute("height",v.height+2),c.setAttribute("viewBox",v.x-1+" "+(v.y-1)+" "+(v.width+2)+" "+(v.height+2));var b=c.style,k="translate("+(v.x-1)+"px,"+(v.y-1)+"px)";b.transform=k,b.webkitTransform=k,h[r].yOffset=v.y-1}else c.setAttribute("width",1),c.setAttribute("height",1);u.appendChild(c)}}else if(l.textContent=h[r].val,l.setAttributeNS("http://www.w3.org/XML/1998/namespace","xml:space","preserve"),this.isMasked)this.innerElem.appendChild(l);else{this.innerElem.appendChild(u);var x=l.style,S="translate3d(0,"+-e.finalSize/1.2+"px,0)";x.transform=S,x.webkitTransform=S}this.isMasked?this.textSpans[m]=l:this.textSpans[m]=u,this.textSpans[m].style.display="block",this.textPaths[m]=l,m+=1}for(;m<this.textSpans.length;)this.textSpans[m].style.display="none",m+=1},HTextElement.prototype.renderInnerContent=function(){var e;if(this.validateText(),this.data.singleShape){if(!this._isFirstFrame&&!this.lettersChangedFlag)return;if(this.isMasked&&this.finalTransform._matMdf){this.svgElement.setAttribute("viewBox",-this.finalTransform.mProp.p.v[0]+" "+-this.finalTransform.mProp.p.v[1]+" "+this.compW+" "+this.compH),e=this.svgElement.style;var t="translate("+-this.finalTransform.mProp.p.v[0]+"px,"+-this.finalTransform.mProp.p.v[1]+"px)";e.transform=t,e.webkitTransform=t}}if(this.textAnimator.getMeasures(this.textProperty.currentData,this.lettersChangedFlag),this.lettersChangedFlag||this.textAnimator.lettersChangedFlag){var n,r,a,i,s,o=0,l=this.textAnimator.renderedLetters,u=this.textProperty.currentData.l;for(r=u.length,n=0;n<r;n+=1)u[n].n?o+=1:(i=this.textSpans[n],s=this.textPaths[n],a=l[o],o+=1,a._mdf.m&&(this.isMasked?i.setAttribute("transform",a.m):(i.style.webkitTransform=a.m,i.style.transform=a.m)),i.style.opacity=a.o,a.sw&&a._mdf.sw&&s.setAttribute("stroke-width",a.sw),a.sc&&a._mdf.sc&&s.setAttribute("stroke",a.sc),a.fc&&a._mdf.fc&&(s.setAttribute("fill",a.fc),s.style.color=a.fc));if(this.innerElem.getBBox&&!this.hidden&&(this._isFirstFrame||this._mdf)){var c=this.innerElem.getBBox();if(this.currentBBox.w!==c.width&&(this.currentBBox.w=c.width,this.svgElement.setAttribute("width",c.width)),this.currentBBox.h!==c.height&&(this.currentBBox.h=c.height,this.svgElement.setAttribute("height",c.height)),this.currentBBox.w!==c.width+2||this.currentBBox.h!==c.height+2||this.currentBBox.x!==c.x-1||this.currentBBox.y!==c.y-1){this.currentBBox.w=c.width+2,this.currentBBox.h=c.height+2,this.currentBBox.x=c.x-1,this.currentBBox.y=c.y-1,this.svgElement.setAttribute("viewBox",this.currentBBox.x+" "+this.currentBBox.y+" "+this.currentBBox.w+" "+this.currentBBox.h),e=this.svgElement.style;var h="translate("+this.currentBBox.x+"px,"+this.currentBBox.y+"px)";e.transform=h,e.webkitTransform=h}}}},extendPrototype([BaseElement,FrameElement,HierarchyElement],HCameraElement),HCameraElement.prototype.setup=function(){var e,t,n,r,a=this.comp.threeDElements.length;for(e=0;e<a;e+=1)if("3d"===(t=this.comp.threeDElements[e]).type){n=t.perspectiveElem.style,r=t.container.style;var i=this.pe.v+"px",s="0px 0px 0px",o="matrix3d(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)";n.perspective=i,n.webkitPerspective=i,r.transformOrigin=s,r.mozTransformOrigin=s,r.webkitTransformOrigin=s,n.transform=o,n.webkitTransform=o}},HCameraElement.prototype.createElements=function(){},HCameraElement.prototype.hide=function(){},HCameraElement.prototype.renderFrame=function(){var e,t,n=this._isFirstFrame;if(this.hierarchy)for(t=this.hierarchy.length,e=0;e<t;e+=1)n=this.hierarchy[e].finalTransform.mProp._mdf||n;if(n||this.pe._mdf||this.p&&this.p._mdf||this.px&&(this.px._mdf||this.py._mdf||this.pz._mdf)||this.rx._mdf||this.ry._mdf||this.rz._mdf||this.or._mdf||this.a&&this.a._mdf){if(this.mat.reset(),this.hierarchy)for(e=t=this.hierarchy.length-1;e>=0;e-=1){var r=this.hierarchy[e].finalTransform.mProp;this.mat.translate(-r.p.v[0],-r.p.v[1],r.p.v[2]),this.mat.rotateX(-r.or.v[0]).rotateY(-r.or.v[1]).rotateZ(r.or.v[2]),this.mat.rotateX(-r.rx.v).rotateY(-r.ry.v).rotateZ(r.rz.v),this.mat.scale(1/r.s.v[0],1/r.s.v[1],1/r.s.v[2]),this.mat.translate(r.a.v[0],r.a.v[1],r.a.v[2])}if(this.p?this.mat.translate(-this.p.v[0],-this.p.v[1],this.p.v[2]):this.mat.translate(-this.px.v,-this.py.v,this.pz.v),this.a){var a;a=this.p?[this.p.v[0]-this.a.v[0],this.p.v[1]-this.a.v[1],this.p.v[2]-this.a.v[2]]:[this.px.v-this.a.v[0],this.py.v-this.a.v[1],this.pz.v-this.a.v[2]];var i=Math.sqrt(Math.pow(a[0],2)+Math.pow(a[1],2)+Math.pow(a[2],2)),s=[a[0]/i,a[1]/i,a[2]/i],o=Math.sqrt(s[2]*s[2]+s[0]*s[0]),l=Math.atan2(s[1],o),u=Math.atan2(s[0],-s[2]);this.mat.rotateY(u).rotateX(-l)}this.mat.rotateX(-this.rx.v).rotateY(-this.ry.v).rotateZ(this.rz.v),this.mat.rotateX(-this.or.v[0]).rotateY(-this.or.v[1]).rotateZ(this.or.v[2]),this.mat.translate(this.globalData.compSize.w/2,this.globalData.compSize.h/2,0),this.mat.translate(0,0,this.pe.v);var c=!this._prevMat.equals(this.mat);if((c||this.pe._mdf)&&this.comp.threeDElements){var h,p,f;for(t=this.comp.threeDElements.length,e=0;e<t;e+=1)if("3d"===(h=this.comp.threeDElements[e]).type){if(c){var d=this.mat.toCSS();(f=h.container.style).transform=d,f.webkitTransform=d}this.pe._mdf&&((p=h.perspectiveElem.style).perspective=this.pe.v+"px",p.webkitPerspective=this.pe.v+"px")}this.mat.clone(this._prevMat)}}this._isFirstFrame=!1},HCameraElement.prototype.prepareFrame=function(e){this.prepareProperties(e,!0)},HCameraElement.prototype.destroy=function(){},HCameraElement.prototype.getBaseElement=function(){return null},extendPrototype([BaseElement,TransformElement,HBaseElement,HSolidElement,HierarchyElement,FrameElement,RenderableElement],HImageElement),HImageElement.prototype.createContent=function(){var e=this.globalData.getAssetsPath(this.assetData),t=new Image;this.data.hasMask?(this.imageElem=createNS("image"),this.imageElem.setAttribute("width",this.assetData.w+"px"),this.imageElem.setAttribute("height",this.assetData.h+"px"),this.imageElem.setAttributeNS("http://www.w3.org/1999/xlink","href",e),this.layerElement.appendChild(this.imageElem),this.baseElement.setAttribute("width",this.assetData.w),this.baseElement.setAttribute("height",this.assetData.h)):this.layerElement.appendChild(t),t.crossOrigin="anonymous",t.src=e,this.data.ln&&this.baseElement.setAttribute("id",this.data.ln)},extendPrototype([BaseRenderer],HybridRendererBase),HybridRendererBase.prototype.buildItem=SVGRenderer.prototype.buildItem,HybridRendererBase.prototype.checkPendingElements=function(){for(;this.pendingElements.length;)this.pendingElements.pop().checkParenting()},HybridRendererBase.prototype.appendElementInPos=function(e,t){var n=e.getBaseElement();if(n){var r=this.layers[t];if(r.ddd&&this.supports3d)this.addTo3dContainer(n,t);else if(this.threeDElements)this.addTo3dContainer(n,t);else{for(var a,i,s=0;s<t;)this.elements[s]&&!0!==this.elements[s]&&this.elements[s].getBaseElement&&(i=this.elements[s],a=(this.layers[s].ddd?this.getThreeDContainerByPos(s):i.getBaseElement())||a),s+=1;a?r.ddd&&this.supports3d||this.layerElement.insertBefore(n,a):r.ddd&&this.supports3d||this.layerElement.appendChild(n)}}},HybridRendererBase.prototype.createShape=function(e){return this.supports3d?new HShapeElement(e,this.globalData,this):new SVGShapeElement(e,this.globalData,this)},HybridRendererBase.prototype.createText=function(e){return this.supports3d?new HTextElement(e,this.globalData,this):new SVGTextLottieElement(e,this.globalData,this)},HybridRendererBase.prototype.createCamera=function(e){return this.camera=new HCameraElement(e,this.globalData,this),this.camera},HybridRendererBase.prototype.createImage=function(e){return this.supports3d?new HImageElement(e,this.globalData,this):new IImageElement(e,this.globalData,this)},HybridRendererBase.prototype.createSolid=function(e){return this.supports3d?new HSolidElement(e,this.globalData,this):new ISolidElement(e,this.globalData,this)},HybridRendererBase.prototype.createNull=SVGRenderer.prototype.createNull,HybridRendererBase.prototype.getThreeDContainerByPos=function(e){for(var t=0,n=this.threeDElements.length;t<n;){if(this.threeDElements[t].startPos<=e&&this.threeDElements[t].endPos>=e)return this.threeDElements[t].perspectiveElem;t+=1}return null},HybridRendererBase.prototype.createThreeDContainer=function(e,t){var n,r,a=createTag("div");styleDiv(a);var i=createTag("div");if(styleDiv(i),"3d"===t){(n=a.style).width=this.globalData.compSize.w+"px",n.height=this.globalData.compSize.h+"px";var s="50% 50%";n.webkitTransformOrigin=s,n.mozTransformOrigin=s,n.transformOrigin=s;var o="matrix3d(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)";(r=i.style).transform=o,r.webkitTransform=o}a.appendChild(i);var l={container:i,perspectiveElem:a,startPos:e,endPos:e,type:t};return this.threeDElements.push(l),l},HybridRendererBase.prototype.build3dContainers=function(){var e,t,n=this.layers.length,r="";for(e=0;e<n;e+=1)this.layers[e].ddd&&3!==this.layers[e].ty?("3d"!==r&&(r="3d",t=this.createThreeDContainer(e,"3d")),t.endPos=Math.max(t.endPos,e)):("2d"!==r&&(r="2d",t=this.createThreeDContainer(e,"2d")),t.endPos=Math.max(t.endPos,e));for(e=(n=this.threeDElements.length)-1;e>=0;e-=1)this.resizerElem.appendChild(this.threeDElements[e].perspectiveElem)},HybridRendererBase.prototype.addTo3dContainer=function(e,t){for(var n=0,r=this.threeDElements.length;n<r;){if(t<=this.threeDElements[n].endPos){for(var a,i=this.threeDElements[n].startPos;i<t;)this.elements[i]&&this.elements[i].getBaseElement&&(a=this.elements[i].getBaseElement()),i+=1;a?this.threeDElements[n].container.insertBefore(e,a):this.threeDElements[n].container.appendChild(e);break}n+=1}},HybridRendererBase.prototype.configAnimation=function(e){var t=createTag("div"),n=this.animationItem.wrapper,r=t.style;r.width=e.w+"px",r.height=e.h+"px",this.resizerElem=t,styleDiv(t),r.transformStyle="flat",r.mozTransformStyle="flat",r.webkitTransformStyle="flat",this.renderConfig.className&&t.setAttribute("class",this.renderConfig.className),n.appendChild(t),r.overflow="hidden";var a=createNS("svg");a.setAttribute("width","1"),a.setAttribute("height","1"),styleDiv(a),this.resizerElem.appendChild(a);var i=createNS("defs");a.appendChild(i),this.data=e,this.setupGlobalData(e,a),this.globalData.defs=i,this.layers=e.layers,this.layerElement=this.resizerElem,this.build3dContainers(),this.updateContainerSize()},HybridRendererBase.prototype.destroy=function(){var e;this.animationItem.wrapper&&(this.animationItem.wrapper.innerText=""),this.animationItem.container=null,this.globalData.defs=null;var t=this.layers?this.layers.length:0;for(e=0;e<t;e+=1)this.elements[e]&&this.elements[e].destroy&&this.elements[e].destroy();this.elements.length=0,this.destroyed=!0,this.animationItem=null},HybridRendererBase.prototype.updateContainerSize=function(){var e,t,n,r,a=this.animationItem.wrapper.offsetWidth,i=this.animationItem.wrapper.offsetHeight,s=a/i;this.globalData.compSize.w/this.globalData.compSize.h>s?(e=a/this.globalData.compSize.w,t=a/this.globalData.compSize.w,n=0,r=(i-this.globalData.compSize.h*(a/this.globalData.compSize.w))/2):(e=i/this.globalData.compSize.h,t=i/this.globalData.compSize.h,n=(a-this.globalData.compSize.w*(i/this.globalData.compSize.h))/2,r=0);var o=this.resizerElem.style;o.webkitTransform="matrix3d("+e+",0,0,0,0,"+t+",0,0,0,0,1,0,"+n+","+r+",0,1)",o.transform=o.webkitTransform},HybridRendererBase.prototype.renderFrame=SVGRenderer.prototype.renderFrame,HybridRendererBase.prototype.hide=function(){this.resizerElem.style.display="none"},HybridRendererBase.prototype.show=function(){this.resizerElem.style.display="block"},HybridRendererBase.prototype.initItems=function(){if(this.buildAllItems(),this.camera)this.camera.setup();else{var e,t=this.globalData.compSize.w,n=this.globalData.compSize.h,r=this.threeDElements.length;for(e=0;e<r;e+=1){var a=this.threeDElements[e].perspectiveElem.style;a.webkitPerspective=Math.sqrt(Math.pow(t,2)+Math.pow(n,2))+"px",a.perspective=a.webkitPerspective}}},HybridRendererBase.prototype.searchExtraCompositions=function(e){var t,n=e.length,r=createTag("div");for(t=0;t<n;t+=1)if(e[t].xt){var a=this.createComp(e[t],r,this.globalData.comp,null);a.initExpressions(),this.globalData.projectInterface.registerComposition(a)}},extendPrototype([HybridRendererBase,ICompElement,HBaseElement],HCompElement),HCompElement.prototype._createBaseContainerElements=HCompElement.prototype.createContainerElements,HCompElement.prototype.createContainerElements=function(){this._createBaseContainerElements(),this.data.hasMask?(this.svgElement.setAttribute("width",this.data.w),this.svgElement.setAttribute("height",this.data.h),this.transformedElement=this.baseElement):this.transformedElement=this.layerElement},HCompElement.prototype.addTo3dContainer=function(e,t){for(var n,r=0;r<t;)this.elements[r]&&this.elements[r].getBaseElement&&(n=this.elements[r].getBaseElement()),r+=1;n?this.layerElement.insertBefore(e,n):this.layerElement.appendChild(e)},HCompElement.prototype.createComp=function(e){return this.supports3d?new HCompElement(e,this.globalData,this):new SVGCompElement(e,this.globalData,this)},extendPrototype([HybridRendererBase],HybridRenderer),HybridRenderer.prototype.createComp=function(e){return this.supports3d?new HCompElement(e,this.globalData,this):new SVGCompElement(e,this.globalData,this)};var CompExpressionInterface=function(e){function t(t){for(var n=0,r=e.layers.length;n<r;){if(e.layers[n].nm===t||e.layers[n].ind===t)return e.elements[n].layerInterface;n+=1}return null}return Object.defineProperty(t,"_name",{value:e.data.nm}),t.layer=t,t.pixelAspect=1,t.height=e.data.h||e.globalData.compSize.h,t.width=e.data.w||e.globalData.compSize.w,t.pixelAspect=1,t.frameDuration=1/e.globalData.frameRate,t.displayStartTime=0,t.numLayers=e.layers.length,t};function _typeof$2(e){return _typeof$2="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$2(e)}function seedRandom(e,t){var n,r=this,a=256,i=6,s="random",o=t.pow(a,i),l=t.pow(2,52),u=2*l,c=a-1;function h(e){var t,n=e.length,r=this,i=0,s=r.i=r.j=0,o=r.S=[];for(n||(e=[n++]);i<a;)o[i]=i++;for(i=0;i<a;i++)o[i]=o[s=c&s+e[i%n]+(t=o[i])],o[s]=t;r.g=function(e){for(var t,n=0,i=r.i,s=r.j,o=r.S;e--;)t=o[i=c&i+1],n=n*a+o[c&(o[i]=o[s=c&s+t])+(o[s]=t)];return r.i=i,r.j=s,n}}function p(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function f(e,t){var n,r=[],a=_typeof$2(e);if(t&&"object"==a)for(n in e)try{r.push(f(e[n],t-1))}catch(e){}return r.length?r:"string"==a?e:e+"\0"}function d(e,t){for(var n,r=e+"",a=0;a<r.length;)t[c&a]=c&(n^=19*t[c&a])+r.charCodeAt(a++);return m(t)}function m(e){return String.fromCharCode.apply(0,e)}t["seed"+s]=function(c,g,y){var v=[],b=d(f((g=!0===g?{entropy:!0}:g||{}).entropy?[c,m(e)]:null===c?function(){try{if(n)return m(n.randomBytes(a));var t=new Uint8Array(a);return(r.crypto||r.msCrypto).getRandomValues(t),m(t)}catch(t){var i=r.navigator,s=i&&i.plugins;return[+new Date,r,s,r.screen,m(e)]}}():c,3),v),k=new h(v),x=function(){for(var e=k.g(i),t=o,n=0;e<l;)e=(e+n)*a,t*=a,n=k.g(1);for(;e>=u;)e/=2,t/=2,n>>>=1;return(e+n)/t};return x.int32=function(){return 0|k.g(4)},x.quick=function(){return k.g(4)/4294967296},x.double=x,d(m(k.S),e),(g.pass||y||function(e,n,r,a){return a&&(a.S&&p(a,k),e.state=function(){return p(k,{})}),r?(t[s]=e,n):e})(x,b,"global"in g?g.global:this==t,g.state)},d(t.random(),e)}function initialize$2(e){seedRandom([],e)}var propTypes={SHAPE:"shape"};function _typeof$1(e){return _typeof$1="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof$1(e)}var ExpressionManager=function(){var ob={},Math=BMMath,window=null,document=null,XMLHttpRequest=null,fetch=null,frames=null,_lottieGlobal={};function resetFrame(){_lottieGlobal={}}function $bm_isInstanceOfArray(e){return e.constructor===Array||e.constructor===Float32Array}function isNumerable(e,t){return"number"===e||t instanceof Number||"boolean"===e||"string"===e}function $bm_neg(e){var t=_typeof$1(e);if("number"===t||e instanceof Number||"boolean"===t)return-e;if($bm_isInstanceOfArray(e)){var n,r=e.length,a=[];for(n=0;n<r;n+=1)a[n]=-e[n];return a}return e.propType?e.v:-e}initialize$2(BMMath);var easeInBez=BezierFactory.getBezierEasing(.333,0,.833,.833,"easeIn").get,easeOutBez=BezierFactory.getBezierEasing(.167,.167,.667,1,"easeOut").get,easeInOutBez=BezierFactory.getBezierEasing(.33,0,.667,1,"easeInOut").get;function sum(e,t){var n=_typeof$1(e),r=_typeof$1(t);if(isNumerable(n,e)&&isNumerable(r,t)||"string"===n||"string"===r)return e+t;if($bm_isInstanceOfArray(e)&&isNumerable(r,t))return(e=e.slice(0))[0]+=t,e;if(isNumerable(n,e)&&$bm_isInstanceOfArray(t))return(t=t.slice(0))[0]=e+t[0],t;if($bm_isInstanceOfArray(e)&&$bm_isInstanceOfArray(t)){for(var a=0,i=e.length,s=t.length,o=[];a<i||a<s;)("number"==typeof e[a]||e[a]instanceof Number)&&("number"==typeof t[a]||t[a]instanceof Number)?o[a]=e[a]+t[a]:o[a]=void 0===t[a]?e[a]:e[a]||t[a],a+=1;return o}return 0}var add=sum;function sub(e,t){var n=_typeof$1(e),r=_typeof$1(t);if(isNumerable(n,e)&&isNumerable(r,t))return"string"===n&&(e=parseInt(e,10)),"string"===r&&(t=parseInt(t,10)),e-t;if($bm_isInstanceOfArray(e)&&isNumerable(r,t))return(e=e.slice(0))[0]-=t,e;if(isNumerable(n,e)&&$bm_isInstanceOfArray(t))return(t=t.slice(0))[0]=e-t[0],t;if($bm_isInstanceOfArray(e)&&$bm_isInstanceOfArray(t)){for(var a=0,i=e.length,s=t.length,o=[];a<i||a<s;)("number"==typeof e[a]||e[a]instanceof Number)&&("number"==typeof t[a]||t[a]instanceof Number)?o[a]=e[a]-t[a]:o[a]=void 0===t[a]?e[a]:e[a]||t[a],a+=1;return o}return 0}function mul(e,t){var n,r,a,i=_typeof$1(e),s=_typeof$1(t);if(isNumerable(i,e)&&isNumerable(s,t))return e*t;if($bm_isInstanceOfArray(e)&&isNumerable(s,t)){for(a=e.length,n=createTypedArray("float32",a),r=0;r<a;r+=1)n[r]=e[r]*t;return n}if(isNumerable(i,e)&&$bm_isInstanceOfArray(t)){for(a=t.length,n=createTypedArray("float32",a),r=0;r<a;r+=1)n[r]=e*t[r];return n}return 0}function div(e,t){var n,r,a,i=_typeof$1(e),s=_typeof$1(t);if(isNumerable(i,e)&&isNumerable(s,t))return e/t;if($bm_isInstanceOfArray(e)&&isNumerable(s,t)){for(a=e.length,n=createTypedArray("float32",a),r=0;r<a;r+=1)n[r]=e[r]/t;return n}if(isNumerable(i,e)&&$bm_isInstanceOfArray(t)){for(a=t.length,n=createTypedArray("float32",a),r=0;r<a;r+=1)n[r]=e/t[r];return n}return 0}function mod(e,t){return"string"==typeof e&&(e=parseInt(e,10)),"string"==typeof t&&(t=parseInt(t,10)),e%t}var $bm_sum=sum,$bm_sub=sub,$bm_mul=mul,$bm_div=div,$bm_mod=mod;function clamp(e,t,n){if(t>n){var r=n;n=t,t=r}return Math.min(Math.max(e,t),n)}function radiansToDegrees(e){return e/degToRads}var radians_to_degrees=radiansToDegrees;function degreesToRadians(e){return e*degToRads}var degrees_to_radians=radiansToDegrees,helperLengthArray=[0,0,0,0,0,0];function length(e,t){if("number"==typeof e||e instanceof Number)return t=t||0,Math.abs(e-t);var n;t||(t=helperLengthArray);var r=Math.min(e.length,t.length),a=0;for(n=0;n<r;n+=1)a+=Math.pow(t[n]-e[n],2);return Math.sqrt(a)}function normalize(e){return div(e,length(e))}function rgbToHsl(e){var t,n,r=e[0],a=e[1],i=e[2],s=Math.max(r,a,i),o=Math.min(r,a,i),l=(s+o)/2;if(s===o)t=0,n=0;else{var u=s-o;switch(n=l>.5?u/(2-s-o):u/(s+o),s){case r:t=(a-i)/u+(a<i?6:0);break;case a:t=(i-r)/u+2;break;case i:t=(r-a)/u+4}t/=6}return[t,n,l,e[3]]}function hue2rgb(e,t,n){return n<0&&(n+=1),n>1&&(n-=1),n<1/6?e+6*(t-e)*n:n<.5?t:n<2/3?e+(t-e)*(2/3-n)*6:e}function hslToRgb(e){var t,n,r,a=e[0],i=e[1],s=e[2];if(0===i)t=s,r=s,n=s;else{var o=s<.5?s*(1+i):s+i-s*i,l=2*s-o;t=hue2rgb(l,o,a+1/3),n=hue2rgb(l,o,a),r=hue2rgb(l,o,a-1/3)}return[t,n,r,e[3]]}function linear(e,t,n,r,a){if(void 0!==r&&void 0!==a||(r=t,a=n,t=0,n=1),n<t){var i=n;n=t,t=i}if(e<=t)return r;if(e>=n)return a;var s,o=n===t?0:(e-t)/(n-t);if(!r.length)return r+(a-r)*o;var l=r.length,u=createTypedArray("float32",l);for(s=0;s<l;s+=1)u[s]=r[s]+(a[s]-r[s])*o;return u}function random(e,t){if(void 0===t&&(void 0===e?(e=0,t=1):(t=e,e=void 0)),t.length){var n,r=t.length;e||(e=createTypedArray("float32",r));var a=createTypedArray("float32",r),i=BMMath.random();for(n=0;n<r;n+=1)a[n]=e[n]+i*(t[n]-e[n]);return a}return void 0===e&&(e=0),e+BMMath.random()*(t-e)}function createPath(e,t,n,r){var a,i=e.length,s=shapePool.newElement();s.setPathData(!!r,i);var o,l,u=[0,0];for(a=0;a<i;a+=1)o=t&&t[a]?t[a]:u,l=n&&n[a]?n[a]:u,s.setTripleAt(e[a][0],e[a][1],l[0]+e[a][0],l[1]+e[a][1],o[0]+e[a][0],o[1]+e[a][1],a,!0);return s}function initiateExpression(elem,data,property){function noOp(e){return e}if(!elem.globalData.renderConfig.runExpressions)return noOp;var val=data.x,needsVelocity=/velocity(?![\w\d])/.test(val),_needsRandom=-1!==val.indexOf("random"),elemType=elem.data.ty,transform,$bm_transform,content,effect,thisProperty=property;thisProperty.valueAtTime=thisProperty.getValueAtTime,Object.defineProperty(thisProperty,"value",{get:function(){return thisProperty.v}}),elem.comp.frameDuration=1/elem.comp.globalData.frameRate,elem.comp.displayStartTime=0;var inPoint=elem.data.ip/elem.comp.globalData.frameRate,outPoint=elem.data.op/elem.comp.globalData.frameRate,width=elem.data.sw?elem.data.sw:0,height=elem.data.sh?elem.data.sh:0,name=elem.data.nm,loopIn,loop_in,loopOut,loop_out,smooth,toWorld,fromWorld,fromComp,toComp,fromCompToSurface,position,rotation,anchorPoint,scale,thisLayer,thisComp,mask,valueAtTime,velocityAtTime,scoped_bm_rt,expression_function=eval("[function _expression_function(){"+val+";scoped_bm_rt=$bm_rt}]")[0],numKeys=property.kf?data.k.length:0,active=!this.data||!0!==this.data.hd,wiggle=function(e,t){var n,r,a=this.pv.length?this.pv.length:1,i=createTypedArray("float32",a),s=Math.floor(5*time);for(n=0,r=0;n<s;){for(r=0;r<a;r+=1)i[r]+=-t+2*t*BMMath.random();n+=1}var o=5*time,l=o-Math.floor(o),u=createTypedArray("float32",a);if(a>1){for(r=0;r<a;r+=1)u[r]=this.pv[r]+i[r]+(-t+2*t*BMMath.random())*l;return u}return this.pv+i[0]+(-t+2*t*BMMath.random())*l}.bind(this);function loopInDuration(e,t){return loopIn(e,t,!0)}function loopOutDuration(e,t){return loopOut(e,t,!0)}thisProperty.loopIn&&(loopIn=thisProperty.loopIn.bind(thisProperty),loop_in=loopIn),thisProperty.loopOut&&(loopOut=thisProperty.loopOut.bind(thisProperty),loop_out=loopOut),thisProperty.smooth&&(smooth=thisProperty.smooth.bind(thisProperty)),this.getValueAtTime&&(valueAtTime=this.getValueAtTime.bind(this)),this.getVelocityAtTime&&(velocityAtTime=this.getVelocityAtTime.bind(this));var comp=elem.comp.globalData.projectInterface.bind(elem.comp.globalData.projectInterface),time,velocity,value,text,textIndex,textTotal,selectorValue;function lookAt(e,t){var n=[t[0]-e[0],t[1]-e[1],t[2]-e[2]],r=Math.atan2(n[0],Math.sqrt(n[1]*n[1]+n[2]*n[2]))/degToRads;return[-Math.atan2(n[1],n[2])/degToRads,r,0]}function easeOut(e,t,n,r,a){return applyEase(easeOutBez,e,t,n,r,a)}function easeIn(e,t,n,r,a){return applyEase(easeInBez,e,t,n,r,a)}function ease(e,t,n,r,a){return applyEase(easeInOutBez,e,t,n,r,a)}function applyEase(e,t,n,r,a,i){void 0===a?(a=n,i=r):t=(t-n)/(r-n),t>1?t=1:t<0&&(t=0);var s=e(t);if($bm_isInstanceOfArray(a)){var o,l=a.length,u=createTypedArray("float32",l);for(o=0;o<l;o+=1)u[o]=(i[o]-a[o])*s+a[o];return u}return(i-a)*s+a}function nearestKey(e){var t,n,r,a=data.k.length;if(data.k.length&&"number"!=typeof data.k[0])if(n=-1,(e*=elem.comp.globalData.frameRate)<data.k[0].t)n=1,r=data.k[0].t;else{for(t=0;t<a-1;t+=1){if(e===data.k[t].t){n=t+1,r=data.k[t].t;break}if(e>data.k[t].t&&e<data.k[t+1].t){e-data.k[t].t>data.k[t+1].t-e?(n=t+2,r=data.k[t+1].t):(n=t+1,r=data.k[t].t);break}}-1===n&&(n=t+1,r=data.k[t].t)}else n=0,r=0;var i={};return i.index=n,i.time=r/elem.comp.globalData.frameRate,i}function key(e){var t,n,r;if(!data.k.length||"number"==typeof data.k[0])throw new Error("The property has no keyframe at index "+e);e-=1,t={time:data.k[e].t/elem.comp.globalData.frameRate,value:[]};var a=Object.prototype.hasOwnProperty.call(data.k[e],"s")?data.k[e].s:data.k[e-1].e;for(r=a.length,n=0;n<r;n+=1)t[n]=a[n],t.value[n]=a[n];return t}function framesToTime(e,t){return t||(t=elem.comp.globalData.frameRate),e/t}function timeToFrames(e,t){return e||0===e||(e=time),t||(t=elem.comp.globalData.frameRate),e*t}function seedRandom(e){BMMath.seedrandom(randSeed+e)}function sourceRectAtTime(){return elem.sourceRectAtTime()}function substring(e,t){return"string"==typeof value?void 0===t?value.substring(e):value.substring(e,t):""}function substr(e,t){return"string"==typeof value?void 0===t?value.substr(e):value.substr(e,t):""}function posterizeTime(e){time=0===e?0:Math.floor(time*e)/e,value=valueAtTime(time)}var index=elem.data.ind,hasParent=!(!elem.hierarchy||!elem.hierarchy.length),parent,randSeed=Math.floor(1e6*Math.random()),globalData=elem.globalData;function executeExpression(e){return value=e,this.frameExpressionId===elem.globalData.frameId&&"textSelector"!==this.propType?value:("textSelector"===this.propType&&(textIndex=this.textIndex,textTotal=this.textTotal,selectorValue=this.selectorValue),thisLayer||(text=elem.layerInterface.text,thisLayer=elem.layerInterface,thisComp=elem.comp.compInterface,toWorld=thisLayer.toWorld.bind(thisLayer),fromWorld=thisLayer.fromWorld.bind(thisLayer),fromComp=thisLayer.fromComp.bind(thisLayer),toComp=thisLayer.toComp.bind(thisLayer),mask=thisLayer.mask?thisLayer.mask.bind(thisLayer):null,fromCompToSurface=fromComp),transform||(transform=elem.layerInterface("ADBE Transform Group"),$bm_transform=transform,transform&&(anchorPoint=transform.anchorPoint)),4!==elemType||content||(content=thisLayer("ADBE Root Vectors Group")),effect||(effect=thisLayer(4)),(hasParent=!(!elem.hierarchy||!elem.hierarchy.length))&&!parent&&(parent=elem.hierarchy[0].layerInterface),time=this.comp.renderedFrame/this.comp.globalData.frameRate,_needsRandom&&seedRandom(randSeed+time),needsVelocity&&(velocity=velocityAtTime(time)),expression_function(),this.frameExpressionId=elem.globalData.frameId,scoped_bm_rt=scoped_bm_rt.propType===propTypes.SHAPE?scoped_bm_rt.v:scoped_bm_rt)}return executeExpression.__preventDeadCodeRemoval=[$bm_transform,anchorPoint,time,velocity,inPoint,outPoint,width,height,name,loop_in,loop_out,smooth,toComp,fromCompToSurface,toWorld,fromWorld,mask,position,rotation,scale,thisComp,numKeys,active,wiggle,loopInDuration,loopOutDuration,comp,lookAt,easeOut,easeIn,ease,nearestKey,key,text,textIndex,textTotal,selectorValue,framesToTime,timeToFrames,sourceRectAtTime,substring,substr,posterizeTime,index,globalData],executeExpression}return ob.initiateExpression=initiateExpression,ob.__preventDeadCodeRemoval=[window,document,XMLHttpRequest,fetch,frames,$bm_neg,add,$bm_sum,$bm_sub,$bm_mul,$bm_div,$bm_mod,clamp,radians_to_degrees,degreesToRadians,degrees_to_radians,normalize,rgbToHsl,hslToRgb,linear,random,createPath,_lottieGlobal],ob.resetFrame=resetFrame,ob}(),Expressions=function(){var e={initExpressions:function(e){var t=0,n=[];e.renderer.compInterface=CompExpressionInterface(e.renderer),e.renderer.globalData.projectInterface.registerComposition(e.renderer),e.renderer.globalData.pushExpression=function(){t+=1},e.renderer.globalData.popExpression=function(){0==(t-=1)&&function(){var e,t=n.length;for(e=0;e<t;e+=1)n[e].release();n.length=0}()},e.renderer.globalData.registerExpressionProperty=function(e){-1===n.indexOf(e)&&n.push(e)}}};return e.resetFrame=ExpressionManager.resetFrame,e}(),MaskManagerInterface=function(){function e(e,t){this._mask=e,this._data=t}return Object.defineProperty(e.prototype,"maskPath",{get:function(){return this._mask.prop.k&&this._mask.prop.getValue(),this._mask.prop}}),Object.defineProperty(e.prototype,"maskOpacity",{get:function(){return this._mask.op.k&&this._mask.op.getValue(),100*this._mask.op.v}}),function(t){var n,r=createSizedArray(t.viewData.length),a=t.viewData.length;for(n=0;n<a;n+=1)r[n]=new e(t.viewData[n],t.masksProperties[n]);return function(e){for(n=0;n<a;){if(t.masksProperties[n].nm===e)return r[n];n+=1}return null}}}(),ExpressionPropertyInterface=function(){var e={pv:0,v:0,mult:1},t={pv:[0,0,0],v:[0,0,0],mult:1};function n(e,t,n){Object.defineProperty(e,"velocity",{get:function(){return t.getVelocityAtTime(t.comp.currentFrame)}}),e.numKeys=t.keyframes?t.keyframes.length:0,e.key=function(r){if(!e.numKeys)return 0;var a="";a="s"in t.keyframes[r-1]?t.keyframes[r-1].s:"e"in t.keyframes[r-2]?t.keyframes[r-2].e:t.keyframes[r-2].s;var i="unidimensional"===n?new Number(a):Object.assign({},a);return i.time=t.keyframes[r-1].t/t.elem.comp.globalData.frameRate,i.value="unidimensional"===n?a[0]:a,i},e.valueAtTime=t.getValueAtTime,e.speedAtTime=t.getSpeedAtTime,e.velocityAtTime=t.getVelocityAtTime,e.propertyGroup=t.propertyGroup}function r(){return e}return function(a){return a?"unidimensional"===a.propType?function(t){t&&"pv"in t||(t=e);var r=1/t.mult,a=t.pv*r,i=new Number(a);return i.value=a,n(i,t,"unidimensional"),function(){return t.k&&t.getValue(),a=t.v*r,i.value!==a&&((i=new Number(a)).value=a,n(i,t,"unidimensional")),i}}(a):function(e){e&&"pv"in e||(e=t);var r=1/e.mult,a=e.data&&e.data.l||e.pv.length,i=createTypedArray("float32",a),s=createTypedArray("float32",a);return i.value=s,n(i,e,"multidimensional"),function(){e.k&&e.getValue();for(var t=0;t<a;t+=1)s[t]=e.v[t]*r,i[t]=s[t];return i}}(a):r}}(),TransformExpressionInterface=function(e){function t(e){switch(e){case"scale":case"Scale":case"ADBE Scale":case 6:return t.scale;case"rotation":case"Rotation":case"ADBE Rotation":case"ADBE Rotate Z":case 10:return t.rotation;case"ADBE Rotate X":return t.xRotation;case"ADBE Rotate Y":return t.yRotation;case"position":case"Position":case"ADBE Position":case 2:return t.position;case"ADBE Position_0":return t.xPosition;case"ADBE Position_1":return t.yPosition;case"ADBE Position_2":return t.zPosition;case"anchorPoint":case"AnchorPoint":case"Anchor Point":case"ADBE AnchorPoint":case 1:return t.anchorPoint;case"opacity":case"Opacity":case 11:return t.opacity;default:return null}}var n,r,a,i;return Object.defineProperty(t,"rotation",{get:ExpressionPropertyInterface(e.r||e.rz)}),Object.defineProperty(t,"zRotation",{get:ExpressionPropertyInterface(e.rz||e.r)}),Object.defineProperty(t,"xRotation",{get:ExpressionPropertyInterface(e.rx)}),Object.defineProperty(t,"yRotation",{get:ExpressionPropertyInterface(e.ry)}),Object.defineProperty(t,"scale",{get:ExpressionPropertyInterface(e.s)}),e.p?i=ExpressionPropertyInterface(e.p):(n=ExpressionPropertyInterface(e.px),r=ExpressionPropertyInterface(e.py),e.pz&&(a=ExpressionPropertyInterface(e.pz))),Object.defineProperty(t,"position",{get:function(){return e.p?i():[n(),r(),a?a():0]}}),Object.defineProperty(t,"xPosition",{get:ExpressionPropertyInterface(e.px)}),Object.defineProperty(t,"yPosition",{get:ExpressionPropertyInterface(e.py)}),Object.defineProperty(t,"zPosition",{get:ExpressionPropertyInterface(e.pz)}),Object.defineProperty(t,"anchorPoint",{get:ExpressionPropertyInterface(e.a)}),Object.defineProperty(t,"opacity",{get:ExpressionPropertyInterface(e.o)}),Object.defineProperty(t,"skew",{get:ExpressionPropertyInterface(e.sk)}),Object.defineProperty(t,"skewAxis",{get:ExpressionPropertyInterface(e.sa)}),Object.defineProperty(t,"orientation",{get:ExpressionPropertyInterface(e.or)}),t},LayerExpressionInterface=function(){function e(e){var t=new Matrix;return void 0!==e?this._elem.finalTransform.mProp.getValueAtTime(e).clone(t):this._elem.finalTransform.mProp.applyToMatrix(t),t}function t(e,t){var n=this.getMatrix(t);return n.props[12]=0,n.props[13]=0,n.props[14]=0,this.applyPoint(n,e)}function n(e,t){var n=this.getMatrix(t);return this.applyPoint(n,e)}function r(e,t){var n=this.getMatrix(t);return n.props[12]=0,n.props[13]=0,n.props[14]=0,this.invertPoint(n,e)}function a(e,t){var n=this.getMatrix(t);return this.invertPoint(n,e)}function i(e,t){if(this._elem.hierarchy&&this._elem.hierarchy.length){var n,r=this._elem.hierarchy.length;for(n=0;n<r;n+=1)this._elem.hierarchy[n].finalTransform.mProp.applyToMatrix(e)}return e.applyToPointArray(t[0],t[1],t[2]||0)}function s(e,t){if(this._elem.hierarchy&&this._elem.hierarchy.length){var n,r=this._elem.hierarchy.length;for(n=0;n<r;n+=1)this._elem.hierarchy[n].finalTransform.mProp.applyToMatrix(e)}return e.inversePoint(t)}function o(e){var t=new Matrix;if(t.reset(),this._elem.finalTransform.mProp.applyToMatrix(t),this._elem.hierarchy&&this._elem.hierarchy.length){var n,r=this._elem.hierarchy.length;for(n=0;n<r;n+=1)this._elem.hierarchy[n].finalTransform.mProp.applyToMatrix(t);return t.inversePoint(e)}return t.inversePoint(e)}function l(){return[1,1,1,1]}return function(u){var c;function h(e){switch(e){case"ADBE Root Vectors Group":case"Contents":case 2:return h.shapeInterface;case 1:case 6:case"Transform":case"transform":case"ADBE Transform Group":return c;case 4:case"ADBE Effect Parade":case"effects":case"Effects":return h.effect;case"ADBE Text Properties":return h.textInterface;default:return null}}h.getMatrix=e,h.invertPoint=s,h.applyPoint=i,h.toWorld=n,h.toWorldVec=t,h.fromWorld=a,h.fromWorldVec=r,h.toComp=n,h.fromComp=o,h.sampleImage=l,h.sourceRectAtTime=u.sourceRectAtTime.bind(u),h._elem=u;var p=getDescriptor(c=TransformExpressionInterface(u.finalTransform.mProp),"anchorPoint");return Object.defineProperties(h,{hasParent:{get:function(){return u.hierarchy.length}},parent:{get:function(){return u.hierarchy[0].layerInterface}},rotation:getDescriptor(c,"rotation"),scale:getDescriptor(c,"scale"),position:getDescriptor(c,"position"),opacity:getDescriptor(c,"opacity"),anchorPoint:p,anchor_point:p,transform:{get:function(){return c}},active:{get:function(){return u.isInRange}}}),h.startTime=u.data.st,h.index=u.data.ind,h.source=u.data.refId,h.height=0===u.data.ty?u.data.h:100,h.width=0===u.data.ty?u.data.w:100,h.inPoint=u.data.ip/u.comp.globalData.frameRate,h.outPoint=u.data.op/u.comp.globalData.frameRate,h._name=u.data.nm,h.registerMaskInterface=function(e){h.mask=new MaskManagerInterface(e,u)},h.registerEffectsInterface=function(e){h.effect=e},h}}(),propertyGroupFactory=function(e,t){return function(n){return(n=void 0===n?1:n)<=0?e:t(n-1)}},PropertyInterface=function(e,t){var n={_name:e};return function(e){return(e=void 0===e?1:e)<=0?n:t(e-1)}},EffectsExpressionInterface=function(){function e(n,r,a,i){function s(e){for(var t=n.ef,r=0,a=t.length;r<a;){if(e===t[r].nm||e===t[r].mn||e===t[r].ix)return 5===t[r].ty?u[r]:u[r]();r+=1}throw new Error}var o,l=propertyGroupFactory(s,a),u=[],c=n.ef.length;for(o=0;o<c;o+=1)5===n.ef[o].ty?u.push(e(n.ef[o],r.effectElements[o],r.effectElements[o].propertyGroup,i)):u.push(t(r.effectElements[o],n.ef[o].ty,i,l));return"ADBE Color Control"===n.mn&&Object.defineProperty(s,"color",{get:function(){return u[0]()}}),Object.defineProperties(s,{numProperties:{get:function(){return n.np}},_name:{value:n.nm},propertyGroup:{value:l}}),s.enabled=0!==n.en,s.active=s.enabled,s}function t(e,t,n,r){var a=ExpressionPropertyInterface(e.p);return e.p.setGroupProperty&&e.p.setGroupProperty(PropertyInterface("",r)),function(){return 10===t?n.comp.compInterface(e.p.v):a()}}return{createEffectsInterface:function(t,n){if(t.effectsManager){var r,a=[],i=t.data.ef,s=t.effectsManager.effectElements.length;for(r=0;r<s;r+=1)a.push(e(i[r],t.effectsManager.effectElements[r],n,t));var o=t.data.ef||[],l=function(e){for(r=0,s=o.length;r<s;){if(e===o[r].nm||e===o[r].mn||e===o[r].ix)return a[r];r+=1}return null};return Object.defineProperty(l,"numProperties",{get:function(){return o.length}}),l}return null}}}(),ShapePathInterface=function(e,t,n){var r=t.sh;function a(e){return"Shape"===e||"shape"===e||"Path"===e||"path"===e||"ADBE Vector Shape"===e||2===e?a.path:null}var i=propertyGroupFactory(a,n);return r.setGroupProperty(PropertyInterface("Path",i)),Object.defineProperties(a,{path:{get:function(){return r.k&&r.getValue(),r}},shape:{get:function(){return r.k&&r.getValue(),r}},_name:{value:e.nm},ix:{value:e.ix},propertyIndex:{value:e.ix},mn:{value:e.mn},propertyGroup:{value:n}}),a},ShapeExpressionInterface=function(){function e(e,s,p){var f,d=[],m=e?e.length:0;for(f=0;f<m;f+=1)"gr"===e[f].ty?d.push(t(e[f],s[f],p)):"fl"===e[f].ty?d.push(n(e[f],s[f],p)):"st"===e[f].ty?d.push(a(e[f],s[f],p)):"tm"===e[f].ty?d.push(i(e[f],s[f],p)):"tr"===e[f].ty||("el"===e[f].ty?d.push(o(e[f],s[f],p)):"sr"===e[f].ty?d.push(l(e[f],s[f],p)):"sh"===e[f].ty?d.push(ShapePathInterface(e[f],s[f],p)):"rc"===e[f].ty?d.push(u(e[f],s[f],p)):"rd"===e[f].ty?d.push(c(e[f],s[f],p)):"rp"===e[f].ty?d.push(h(e[f],s[f],p)):"gf"===e[f].ty?d.push(r(e[f],s[f],p)):d.push((e[f],s[f],function(){return null})));return d}function t(t,n,r){var a=function(e){switch(e){case"ADBE Vectors Group":case"Contents":case 2:return a.content;default:return a.transform}};a.propertyGroup=propertyGroupFactory(a,r);var i=function(t,n,r){var a,i=function(e){for(var t=0,n=a.length;t<n;){if(a[t]._name===e||a[t].mn===e||a[t].propertyIndex===e||a[t].ix===e||a[t].ind===e)return a[t];t+=1}return"number"==typeof e?a[e-1]:null};i.propertyGroup=propertyGroupFactory(i,r),a=e(t.it,n.it,i.propertyGroup),i.numProperties=a.length;var o=s(t.it[t.it.length-1],n.it[n.it.length-1],i.propertyGroup);return i.transform=o,i.propertyIndex=t.cix,i._name=t.nm,i}(t,n,a.propertyGroup),o=s(t.it[t.it.length-1],n.it[n.it.length-1],a.propertyGroup);return a.content=i,a.transform=o,Object.defineProperty(a,"_name",{get:function(){return t.nm}}),a.numProperties=t.np,a.propertyIndex=t.ix,a.nm=t.nm,a.mn=t.mn,a}function n(e,t,n){function r(e){return"Color"===e||"color"===e?r.color:"Opacity"===e||"opacity"===e?r.opacity:null}return Object.defineProperties(r,{color:{get:ExpressionPropertyInterface(t.c)},opacity:{get:ExpressionPropertyInterface(t.o)},_name:{value:e.nm},mn:{value:e.mn}}),t.c.setGroupProperty(PropertyInterface("Color",n)),t.o.setGroupProperty(PropertyInterface("Opacity",n)),r}function r(e,t,n){function r(e){return"Start Point"===e||"start point"===e?r.startPoint:"End Point"===e||"end point"===e?r.endPoint:"Opacity"===e||"opacity"===e?r.opacity:null}return Object.defineProperties(r,{startPoint:{get:ExpressionPropertyInterface(t.s)},endPoint:{get:ExpressionPropertyInterface(t.e)},opacity:{get:ExpressionPropertyInterface(t.o)},type:{get:function(){return"a"}},_name:{value:e.nm},mn:{value:e.mn}}),t.s.setGroupProperty(PropertyInterface("Start Point",n)),t.e.setGroupProperty(PropertyInterface("End Point",n)),t.o.setGroupProperty(PropertyInterface("Opacity",n)),r}function a(e,t,n){var r,a=propertyGroupFactory(u,n),i=propertyGroupFactory(l,a);function s(n){Object.defineProperty(l,e.d[n].nm,{get:ExpressionPropertyInterface(t.d.dataProps[n].p)})}var o=e.d?e.d.length:0,l={};for(r=0;r<o;r+=1)s(r),t.d.dataProps[r].p.setGroupProperty(i);function u(e){return"Color"===e||"color"===e?u.color:"Opacity"===e||"opacity"===e?u.opacity:"Stroke Width"===e||"stroke width"===e?u.strokeWidth:null}return Object.defineProperties(u,{color:{get:ExpressionPropertyInterface(t.c)},opacity:{get:ExpressionPropertyInterface(t.o)},strokeWidth:{get:ExpressionPropertyInterface(t.w)},dash:{get:function(){return l}},_name:{value:e.nm},mn:{value:e.mn}}),t.c.setGroupProperty(PropertyInterface("Color",a)),t.o.setGroupProperty(PropertyInterface("Opacity",a)),t.w.setGroupProperty(PropertyInterface("Stroke Width",a)),u}function i(e,t,n){function r(t){return t===e.e.ix||"End"===t||"end"===t?r.end:t===e.s.ix?r.start:t===e.o.ix?r.offset:null}var a=propertyGroupFactory(r,n);return r.propertyIndex=e.ix,t.s.setGroupProperty(PropertyInterface("Start",a)),t.e.setGroupProperty(PropertyInterface("End",a)),t.o.setGroupProperty(PropertyInterface("Offset",a)),r.propertyIndex=e.ix,r.propertyGroup=n,Object.defineProperties(r,{start:{get:ExpressionPropertyInterface(t.s)},end:{get:ExpressionPropertyInterface(t.e)},offset:{get:ExpressionPropertyInterface(t.o)},_name:{value:e.nm}}),r.mn=e.mn,r}function s(e,t,n){function r(t){return e.a.ix===t||"Anchor Point"===t?r.anchorPoint:e.o.ix===t||"Opacity"===t?r.opacity:e.p.ix===t||"Position"===t?r.position:e.r.ix===t||"Rotation"===t||"ADBE Vector Rotation"===t?r.rotation:e.s.ix===t||"Scale"===t?r.scale:e.sk&&e.sk.ix===t||"Skew"===t?r.skew:e.sa&&e.sa.ix===t||"Skew Axis"===t?r.skewAxis:null}var a=propertyGroupFactory(r,n);return t.transform.mProps.o.setGroupProperty(PropertyInterface("Opacity",a)),t.transform.mProps.p.setGroupProperty(PropertyInterface("Position",a)),t.transform.mProps.a.setGroupProperty(PropertyInterface("Anchor Point",a)),t.transform.mProps.s.setGroupProperty(PropertyInterface("Scale",a)),t.transform.mProps.r.setGroupProperty(PropertyInterface("Rotation",a)),t.transform.mProps.sk&&(t.transform.mProps.sk.setGroupProperty(PropertyInterface("Skew",a)),t.transform.mProps.sa.setGroupProperty(PropertyInterface("Skew Angle",a))),t.transform.op.setGroupProperty(PropertyInterface("Opacity",a)),Object.defineProperties(r,{opacity:{get:ExpressionPropertyInterface(t.transform.mProps.o)},position:{get:ExpressionPropertyInterface(t.transform.mProps.p)},anchorPoint:{get:ExpressionPropertyInterface(t.transform.mProps.a)},scale:{get:ExpressionPropertyInterface(t.transform.mProps.s)},rotation:{get:ExpressionPropertyInterface(t.transform.mProps.r)},skew:{get:ExpressionPropertyInterface(t.transform.mProps.sk)},skewAxis:{get:ExpressionPropertyInterface(t.transform.mProps.sa)},_name:{value:e.nm}}),r.ty="tr",r.mn=e.mn,r.propertyGroup=n,r}function o(e,t,n){function r(t){return e.p.ix===t?r.position:e.s.ix===t?r.size:null}var a=propertyGroupFactory(r,n);r.propertyIndex=e.ix;var i="tm"===t.sh.ty?t.sh.prop:t.sh;return i.s.setGroupProperty(PropertyInterface("Size",a)),i.p.setGroupProperty(PropertyInterface("Position",a)),Object.defineProperties(r,{size:{get:ExpressionPropertyInterface(i.s)},position:{get:ExpressionPropertyInterface(i.p)},_name:{value:e.nm}}),r.mn=e.mn,r}function l(e,t,n){function r(t){return e.p.ix===t?r.position:e.r.ix===t?r.rotation:e.pt.ix===t?r.points:e.or.ix===t||"ADBE Vector Star Outer Radius"===t?r.outerRadius:e.os.ix===t?r.outerRoundness:!e.ir||e.ir.ix!==t&&"ADBE Vector Star Inner Radius"!==t?e.is&&e.is.ix===t?r.innerRoundness:null:r.innerRadius}var a=propertyGroupFactory(r,n),i="tm"===t.sh.ty?t.sh.prop:t.sh;return r.propertyIndex=e.ix,i.or.setGroupProperty(PropertyInterface("Outer Radius",a)),i.os.setGroupProperty(PropertyInterface("Outer Roundness",a)),i.pt.setGroupProperty(PropertyInterface("Points",a)),i.p.setGroupProperty(PropertyInterface("Position",a)),i.r.setGroupProperty(PropertyInterface("Rotation",a)),e.ir&&(i.ir.setGroupProperty(PropertyInterface("Inner Radius",a)),i.is.setGroupProperty(PropertyInterface("Inner Roundness",a))),Object.defineProperties(r,{position:{get:ExpressionPropertyInterface(i.p)},rotation:{get:ExpressionPropertyInterface(i.r)},points:{get:ExpressionPropertyInterface(i.pt)},outerRadius:{get:ExpressionPropertyInterface(i.or)},outerRoundness:{get:ExpressionPropertyInterface(i.os)},innerRadius:{get:ExpressionPropertyInterface(i.ir)},innerRoundness:{get:ExpressionPropertyInterface(i.is)},_name:{value:e.nm}}),r.mn=e.mn,r}function u(e,t,n){function r(t){return e.p.ix===t?r.position:e.r.ix===t?r.roundness:e.s.ix===t||"Size"===t||"ADBE Vector Rect Size"===t?r.size:null}var a=propertyGroupFactory(r,n),i="tm"===t.sh.ty?t.sh.prop:t.sh;return r.propertyIndex=e.ix,i.p.setGroupProperty(PropertyInterface("Position",a)),i.s.setGroupProperty(PropertyInterface("Size",a)),i.r.setGroupProperty(PropertyInterface("Rotation",a)),Object.defineProperties(r,{position:{get:ExpressionPropertyInterface(i.p)},roundness:{get:ExpressionPropertyInterface(i.r)},size:{get:ExpressionPropertyInterface(i.s)},_name:{value:e.nm}}),r.mn=e.mn,r}function c(e,t,n){function r(t){return e.r.ix===t||"Round Corners 1"===t?r.radius:null}var a=propertyGroupFactory(r,n),i=t;return r.propertyIndex=e.ix,i.rd.setGroupProperty(PropertyInterface("Radius",a)),Object.defineProperties(r,{radius:{get:ExpressionPropertyInterface(i.rd)},_name:{value:e.nm}}),r.mn=e.mn,r}function h(e,t,n){function r(t){return e.c.ix===t||"Copies"===t?r.copies:e.o.ix===t||"Offset"===t?r.offset:null}var a=propertyGroupFactory(r,n),i=t;return r.propertyIndex=e.ix,i.c.setGroupProperty(PropertyInterface("Copies",a)),i.o.setGroupProperty(PropertyInterface("Offset",a)),Object.defineProperties(r,{copies:{get:ExpressionPropertyInterface(i.c)},offset:{get:ExpressionPropertyInterface(i.o)},_name:{value:e.nm}}),r.mn=e.mn,r}return function(t,n,r){var a;function i(e){if("number"==typeof e)return 0===(e=void 0===e?1:e)?r:a[e-1];for(var t=0,n=a.length;t<n;){if(a[t]._name===e)return a[t];t+=1}return null}return i.propertyGroup=propertyGroupFactory(i,(function(){return r})),a=e(t,n,i.propertyGroup),i.numProperties=a.length,i._name="Contents",i}}(),TextExpressionInterface=function(e){var t;function n(e){return"ADBE Text Document"===e?n.sourceText:null}return Object.defineProperty(n,"sourceText",{get:function(){e.textProperty.getValue();var n=e.textProperty.currentData.t;return t&&n===t.value||((t=new String(n)).value=n||new String(n),Object.defineProperty(t,"style",{get:function(){return{fillColor:e.textProperty.currentData.fc}}})),t}}),n};function _typeof(e){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_typeof(e)}var FootageInterface=(dataInterfaceFactory=function(e){function t(e){return"Outline"===e?t.outlineInterface():null}return t._name="Outline",t.outlineInterface=function(e){var t="",n=e.getFootageData();function r(e){if(n[e])return t=e,"object"===_typeof(n=n[e])?r:n;var a=e.indexOf(t);if(-1!==a){var i=parseInt(e.substr(a+t.length),10);return"object"===_typeof(n=n[i])?r:n}return""}return function(){return t="",n=e.getFootageData(),r}}(e),t},function(e){function t(e){return"Data"===e?t.dataInterface:null}return t._name="Data",t.dataInterface=dataInterfaceFactory(e),t}),dataInterfaceFactory,interfaces={layer:LayerExpressionInterface,effects:EffectsExpressionInterface,comp:CompExpressionInterface,shape:ShapeExpressionInterface,text:TextExpressionInterface,footage:FootageInterface};function getInterface(e){return interfaces[e]||null}var expressionHelpers={searchExpressions:function(e,t,n){t.x&&(n.k=!0,n.x=!0,n.initiateExpression=ExpressionManager.initiateExpression,n.effectsSequence.push(n.initiateExpression(e,t,n).bind(n)))},getSpeedAtTime:function(e){var t=this.getValueAtTime(e),n=this.getValueAtTime(e+-.01),r=0;if(t.length){var a;for(a=0;a<t.length;a+=1)r+=Math.pow(n[a]-t[a],2);r=100*Math.sqrt(r)}else r=0;return r},getVelocityAtTime:function(e){if(void 0!==this.vel)return this.vel;var t,n,r=-.001,a=this.getValueAtTime(e),i=this.getValueAtTime(e+r);if(a.length)for(t=createTypedArray("float32",a.length),n=0;n<a.length;n+=1)t[n]=(i[n]-a[n])/r;else t=(i-a)/r;return t},getValueAtTime:function(e){return e*=this.elem.globalData.frameRate,(e-=this.offsetTime)!==this._cachingAtTime.lastFrame&&(this._cachingAtTime.lastIndex=this._cachingAtTime.lastFrame<e?this._cachingAtTime.lastIndex:0,this._cachingAtTime.value=this.interpolateValue(e,this._cachingAtTime),this._cachingAtTime.lastFrame=e),this._cachingAtTime.value},getStaticValueAtTime:function(){return this.pv},setGroupProperty:function(e){this.propertyGroup=e}};function addPropertyDecorator(){function e(e,t,n){if(!this.k||!this.keyframes)return this.pv;e=e?e.toLowerCase():"";var r,a,i,s,o,l=this.comp.renderedFrame,u=this.keyframes,c=u[u.length-1].t;if(l<=c)return this.pv;if(n?a=c-(r=t?Math.abs(c-this.elem.comp.globalData.frameRate*t):Math.max(0,c-this.elem.data.ip)):((!t||t>u.length-1)&&(t=u.length-1),r=c-(a=u[u.length-1-t].t)),"pingpong"===e){if(Math.floor((l-a)/r)%2!=0)return this.getValueAtTime((r-(l-a)%r+a)/this.comp.globalData.frameRate,0)}else{if("offset"===e){var h=this.getValueAtTime(a/this.comp.globalData.frameRate,0),p=this.getValueAtTime(c/this.comp.globalData.frameRate,0),f=this.getValueAtTime(((l-a)%r+a)/this.comp.globalData.frameRate,0),d=Math.floor((l-a)/r);if(this.pv.length){for(s=(o=new Array(h.length)).length,i=0;i<s;i+=1)o[i]=(p[i]-h[i])*d+f[i];return o}return(p-h)*d+f}if("continue"===e){var m=this.getValueAtTime(c/this.comp.globalData.frameRate,0),g=this.getValueAtTime((c-.001)/this.comp.globalData.frameRate,0);if(this.pv.length){for(s=(o=new Array(m.length)).length,i=0;i<s;i+=1)o[i]=m[i]+(m[i]-g[i])*((l-c)/this.comp.globalData.frameRate)/5e-4;return o}return m+(l-c)/.001*(m-g)}}return this.getValueAtTime(((l-a)%r+a)/this.comp.globalData.frameRate,0)}function t(e,t,n){if(!this.k)return this.pv;e=e?e.toLowerCase():"";var r,a,i,s,o,l=this.comp.renderedFrame,u=this.keyframes,c=u[0].t;if(l>=c)return this.pv;if(n?a=c+(r=t?Math.abs(this.elem.comp.globalData.frameRate*t):Math.max(0,this.elem.data.op-c)):((!t||t>u.length-1)&&(t=u.length-1),r=(a=u[t].t)-c),"pingpong"===e){if(Math.floor((c-l)/r)%2==0)return this.getValueAtTime(((c-l)%r+c)/this.comp.globalData.frameRate,0)}else{if("offset"===e){var h=this.getValueAtTime(c/this.comp.globalData.frameRate,0),p=this.getValueAtTime(a/this.comp.globalData.frameRate,0),f=this.getValueAtTime((r-(c-l)%r+c)/this.comp.globalData.frameRate,0),d=Math.floor((c-l)/r)+1;if(this.pv.length){for(s=(o=new Array(h.length)).length,i=0;i<s;i+=1)o[i]=f[i]-(p[i]-h[i])*d;return o}return f-(p-h)*d}if("continue"===e){var m=this.getValueAtTime(c/this.comp.globalData.frameRate,0),g=this.getValueAtTime((c+.001)/this.comp.globalData.frameRate,0);if(this.pv.length){for(s=(o=new Array(m.length)).length,i=0;i<s;i+=1)o[i]=m[i]+(m[i]-g[i])*(c-l)/.001;return o}return m+(m-g)*(c-l)/.001}}return this.getValueAtTime((r-((c-l)%r+c))/this.comp.globalData.frameRate,0)}function n(e,t){if(!this.k)return this.pv;if(e=.5*(e||.4),(t=Math.floor(t||5))<=1)return this.pv;var n,r,a=this.comp.renderedFrame/this.comp.globalData.frameRate,i=a-e,s=t>1?(a+e-i)/(t-1):1,o=0,l=0;for(n=this.pv.length?createTypedArray("float32",this.pv.length):0;o<t;){if(r=this.getValueAtTime(i+o*s),this.pv.length)for(l=0;l<this.pv.length;l+=1)n[l]+=r[l];else n+=r;o+=1}if(this.pv.length)for(l=0;l<this.pv.length;l+=1)n[l]/=t;else n/=t;return n}function r(e){this._transformCachingAtTime||(this._transformCachingAtTime={v:new Matrix});var t=this._transformCachingAtTime.v;if(t.cloneFromProps(this.pre.props),this.appliedTransformations<1){var n=this.a.getValueAtTime(e);t.translate(-n[0]*this.a.mult,-n[1]*this.a.mult,n[2]*this.a.mult)}if(this.appliedTransformations<2){var r=this.s.getValueAtTime(e);t.scale(r[0]*this.s.mult,r[1]*this.s.mult,r[2]*this.s.mult)}if(this.sk&&this.appliedTransformations<3){var a=this.sk.getValueAtTime(e),i=this.sa.getValueAtTime(e);t.skewFromAxis(-a*this.sk.mult,i*this.sa.mult)}if(this.r&&this.appliedTransformations<4){var s=this.r.getValueAtTime(e);t.rotate(-s*this.r.mult)}else if(!this.r&&this.appliedTransformations<4){var o=this.rz.getValueAtTime(e),l=this.ry.getValueAtTime(e),u=this.rx.getValueAtTime(e),c=this.or.getValueAtTime(e);t.rotateZ(-o*this.rz.mult).rotateY(l*this.ry.mult).rotateX(u*this.rx.mult).rotateZ(-c[2]*this.or.mult).rotateY(c[1]*this.or.mult).rotateX(c[0]*this.or.mult)}if(this.data.p&&this.data.p.s){var h=this.px.getValueAtTime(e),p=this.py.getValueAtTime(e);if(this.data.p.z){var f=this.pz.getValueAtTime(e);t.translate(h*this.px.mult,p*this.py.mult,-f*this.pz.mult)}else t.translate(h*this.px.mult,p*this.py.mult,0)}else{var d=this.p.getValueAtTime(e);t.translate(d[0]*this.p.mult,d[1]*this.p.mult,-d[2]*this.p.mult)}return t}function a(){return this.v.clone(new Matrix)}var i=TransformPropertyFactory.getTransformProperty;TransformPropertyFactory.getTransformProperty=function(e,t,n){var s=i(e,t,n);return s.dynamicProperties.length?s.getValueAtTime=r.bind(s):s.getValueAtTime=a.bind(s),s.setGroupProperty=expressionHelpers.setGroupProperty,s};var s=PropertyFactory.getProp;PropertyFactory.getProp=function(r,a,i,o,l){var u=s(r,a,i,o,l);u.kf?u.getValueAtTime=expressionHelpers.getValueAtTime.bind(u):u.getValueAtTime=expressionHelpers.getStaticValueAtTime.bind(u),u.setGroupProperty=expressionHelpers.setGroupProperty,u.loopOut=e,u.loopIn=t,u.smooth=n,u.getVelocityAtTime=expressionHelpers.getVelocityAtTime.bind(u),u.getSpeedAtTime=expressionHelpers.getSpeedAtTime.bind(u),u.numKeys=1===a.a?a.k.length:0,u.propertyIndex=a.ix;var c=0;return 0!==i&&(c=createTypedArray("float32",1===a.a?a.k[0].s.length:a.k.length)),u._cachingAtTime={lastFrame:initialDefaultFrame,lastIndex:0,value:c},expressionHelpers.searchExpressions(r,a,u),u.k&&l.addDynamicProperty(u),u};var o=ShapePropertyFactory.getConstructorFunction(),l=ShapePropertyFactory.getKeyframedConstructorFunction();function u(){}u.prototype={vertices:function(e,t){this.k&&this.getValue();var n,r=this.v;void 0!==t&&(r=this.getValueAtTime(t,0));var a=r._length,i=r[e],s=r.v,o=createSizedArray(a);for(n=0;n<a;n+=1)o[n]="i"===e||"o"===e?[i[n][0]-s[n][0],i[n][1]-s[n][1]]:[i[n][0],i[n][1]];return o},points:function(e){return this.vertices("v",e)},inTangents:function(e){return this.vertices("i",e)},outTangents:function(e){return this.vertices("o",e)},isClosed:function(){return this.v.c},pointOnPath:function(e,t){var n=this.v;void 0!==t&&(n=this.getValueAtTime(t,0)),this._segmentsLength||(this._segmentsLength=bez.getSegmentsLength(n));for(var r,a=this._segmentsLength,i=a.lengths,s=a.totalLength*e,o=0,l=i.length,u=0;o<l;){if(u+i[o].addedLength>s){var c=o,h=n.c&&o===l-1?0:o+1,p=(s-u)/i[o].addedLength;r=bez.getPointInSegment(n.v[c],n.v[h],n.o[c],n.i[h],p,i[o]);break}u+=i[o].addedLength,o+=1}return r||(r=n.c?[n.v[0][0],n.v[0][1]]:[n.v[n._length-1][0],n.v[n._length-1][1]]),r},vectorOnPath:function(e,t,n){1==e?e=this.v.c:0==e&&(e=.999);var r=this.pointOnPath(e,t),a=this.pointOnPath(e+.001,t),i=a[0]-r[0],s=a[1]-r[1],o=Math.sqrt(Math.pow(i,2)+Math.pow(s,2));return 0===o?[0,0]:"tangent"===n?[i/o,s/o]:[-s/o,i/o]},tangentOnPath:function(e,t){return this.vectorOnPath(e,t,"tangent")},normalOnPath:function(e,t){return this.vectorOnPath(e,t,"normal")},setGroupProperty:expressionHelpers.setGroupProperty,getValueAtTime:expressionHelpers.getStaticValueAtTime},extendPrototype([u],o),extendPrototype([u],l),l.prototype.getValueAtTime=function(e){return this._cachingAtTime||(this._cachingAtTime={shapeValue:shapePool.clone(this.pv),lastIndex:0,lastTime:initialDefaultFrame}),e*=this.elem.globalData.frameRate,(e-=this.offsetTime)!==this._cachingAtTime.lastTime&&(this._cachingAtTime.lastIndex=this._cachingAtTime.lastTime<e?this._caching.lastIndex:0,this._cachingAtTime.lastTime=e,this.interpolateShape(e,this._cachingAtTime.shapeValue,this._cachingAtTime)),this._cachingAtTime.shapeValue},l.prototype.initiateExpression=ExpressionManager.initiateExpression;var c=ShapePropertyFactory.getShapeProp;ShapePropertyFactory.getShapeProp=function(e,t,n,r,a){var i=c(e,t,n,r,a);return i.propertyIndex=t.ix,i.lock=!1,3===n?expressionHelpers.searchExpressions(e,t.pt,i):4===n&&expressionHelpers.searchExpressions(e,t.ks,i),i.k&&e.addDynamicProperty(i),i}}function initialize$1(){addPropertyDecorator()}function addDecorator(){TextProperty.prototype.getExpressionValue=function(e,t){var n=this.calculateExpression(t);if(e.t!==n){var r={};return this.copyData(r,e),r.t=n.toString(),r.__complete=!1,r}return e},TextProperty.prototype.searchProperty=function(){var e=this.searchKeyframes(),t=this.searchExpressions();return this.kf=e||t,this.kf},TextProperty.prototype.searchExpressions=function(){return this.data.d.x?(this.calculateExpression=ExpressionManager.initiateExpression.bind(this)(this.elem,this.data.d,this),this.addEffect(this.getExpressionValue.bind(this)),!0):null}}function initialize(){addDecorator()}function SVGComposableEffect(){}SVGComposableEffect.prototype={createMergeNode:function(e,t){var n,r,a=createNS("feMerge");for(a.setAttribute("result",e),r=0;r<t.length;r+=1)(n=createNS("feMergeNode")).setAttribute("in",t[r]),a.appendChild(n),a.appendChild(n);return a}};var linearFilterValue="0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0";function SVGTintFilter(e,t,n,r,a){this.filterManager=t;var i=createNS("feColorMatrix");i.setAttribute("type","matrix"),i.setAttribute("color-interpolation-filters","linearRGB"),i.setAttribute("values",linearFilterValue+" 1 0"),this.linearFilter=i,i.setAttribute("result",r+"_tint_1"),e.appendChild(i),(i=createNS("feColorMatrix")).setAttribute("type","matrix"),i.setAttribute("color-interpolation-filters","sRGB"),i.setAttribute("values","1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"),i.setAttribute("result",r+"_tint_2"),e.appendChild(i),this.matrixFilter=i;var s=this.createMergeNode(r,[a,r+"_tint_1",r+"_tint_2"]);e.appendChild(s)}function SVGFillFilter(e,t,n,r){this.filterManager=t;var a=createNS("feColorMatrix");a.setAttribute("type","matrix"),a.setAttribute("color-interpolation-filters","sRGB"),a.setAttribute("values","1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"),a.setAttribute("result",r),e.appendChild(a),this.matrixFilter=a}function SVGStrokeEffect(e,t,n){this.initialized=!1,this.filterManager=t,this.elem=n,this.paths=[]}function SVGTritoneFilter(e,t,n,r){this.filterManager=t;var a=createNS("feColorMatrix");a.setAttribute("type","matrix"),a.setAttribute("color-interpolation-filters","linearRGB"),a.setAttribute("values","0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0"),e.appendChild(a);var i=createNS("feComponentTransfer");i.setAttribute("color-interpolation-filters","sRGB"),i.setAttribute("result",r),this.matrixFilter=i;var s=createNS("feFuncR");s.setAttribute("type","table"),i.appendChild(s),this.feFuncR=s;var o=createNS("feFuncG");o.setAttribute("type","table"),i.appendChild(o),this.feFuncG=o;var l=createNS("feFuncB");l.setAttribute("type","table"),i.appendChild(l),this.feFuncB=l,e.appendChild(i)}function SVGProLevelsFilter(e,t,n,r){this.filterManager=t;var a=this.filterManager.effectElements,i=createNS("feComponentTransfer");(a[10].p.k||0!==a[10].p.v||a[11].p.k||1!==a[11].p.v||a[12].p.k||1!==a[12].p.v||a[13].p.k||0!==a[13].p.v||a[14].p.k||1!==a[14].p.v)&&(this.feFuncR=this.createFeFunc("feFuncR",i)),(a[17].p.k||0!==a[17].p.v||a[18].p.k||1!==a[18].p.v||a[19].p.k||1!==a[19].p.v||a[20].p.k||0!==a[20].p.v||a[21].p.k||1!==a[21].p.v)&&(this.feFuncG=this.createFeFunc("feFuncG",i)),(a[24].p.k||0!==a[24].p.v||a[25].p.k||1!==a[25].p.v||a[26].p.k||1!==a[26].p.v||a[27].p.k||0!==a[27].p.v||a[28].p.k||1!==a[28].p.v)&&(this.feFuncB=this.createFeFunc("feFuncB",i)),(a[31].p.k||0!==a[31].p.v||a[32].p.k||1!==a[32].p.v||a[33].p.k||1!==a[33].p.v||a[34].p.k||0!==a[34].p.v||a[35].p.k||1!==a[35].p.v)&&(this.feFuncA=this.createFeFunc("feFuncA",i)),(this.feFuncR||this.feFuncG||this.feFuncB||this.feFuncA)&&(i.setAttribute("color-interpolation-filters","sRGB"),e.appendChild(i)),(a[3].p.k||0!==a[3].p.v||a[4].p.k||1!==a[4].p.v||a[5].p.k||1!==a[5].p.v||a[6].p.k||0!==a[6].p.v||a[7].p.k||1!==a[7].p.v)&&((i=createNS("feComponentTransfer")).setAttribute("color-interpolation-filters","sRGB"),i.setAttribute("result",r),e.appendChild(i),this.feFuncRComposed=this.createFeFunc("feFuncR",i),this.feFuncGComposed=this.createFeFunc("feFuncG",i),this.feFuncBComposed=this.createFeFunc("feFuncB",i))}function SVGDropShadowEffect(e,t,n,r,a){var i=t.container.globalData.renderConfig.filterSize,s=t.data.fs||i;e.setAttribute("x",s.x||i.x),e.setAttribute("y",s.y||i.y),e.setAttribute("width",s.width||i.width),e.setAttribute("height",s.height||i.height),this.filterManager=t;var o=createNS("feGaussianBlur");o.setAttribute("in","SourceAlpha"),o.setAttribute("result",r+"_drop_shadow_1"),o.setAttribute("stdDeviation","0"),this.feGaussianBlur=o,e.appendChild(o);var l=createNS("feOffset");l.setAttribute("dx","25"),l.setAttribute("dy","0"),l.setAttribute("in",r+"_drop_shadow_1"),l.setAttribute("result",r+"_drop_shadow_2"),this.feOffset=l,e.appendChild(l);var u=createNS("feFlood");u.setAttribute("flood-color","#00ff00"),u.setAttribute("flood-opacity","1"),u.setAttribute("result",r+"_drop_shadow_3"),this.feFlood=u,e.appendChild(u);var c=createNS("feComposite");c.setAttribute("in",r+"_drop_shadow_3"),c.setAttribute("in2",r+"_drop_shadow_2"),c.setAttribute("operator","in"),c.setAttribute("result",r+"_drop_shadow_4"),e.appendChild(c);var h=this.createMergeNode(r,[r+"_drop_shadow_4",a]);e.appendChild(h)}extendPrototype([SVGComposableEffect],SVGTintFilter),SVGTintFilter.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){var t=this.filterManager.effectElements[0].p.v,n=this.filterManager.effectElements[1].p.v,r=this.filterManager.effectElements[2].p.v/100;this.linearFilter.setAttribute("values",linearFilterValue+" "+r+" 0"),this.matrixFilter.setAttribute("values",n[0]-t[0]+" 0 0 0 "+t[0]+" "+(n[1]-t[1])+" 0 0 0 "+t[1]+" "+(n[2]-t[2])+" 0 0 0 "+t[2]+" 0 0 0 1 0")}},SVGFillFilter.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){var t=this.filterManager.effectElements[2].p.v,n=this.filterManager.effectElements[6].p.v;this.matrixFilter.setAttribute("values","0 0 0 0 "+t[0]+" 0 0 0 0 "+t[1]+" 0 0 0 0 "+t[2]+" 0 0 0 "+n+" 0")}},SVGStrokeEffect.prototype.initialize=function(){var e,t,n,r,a=this.elem.layerElement.children||this.elem.layerElement.childNodes;for(1===this.filterManager.effectElements[1].p.v?(r=this.elem.maskManager.masksProperties.length,n=0):r=1+(n=this.filterManager.effectElements[0].p.v-1),(t=createNS("g")).setAttribute("fill","none"),t.setAttribute("stroke-linecap","round"),t.setAttribute("stroke-dashoffset",1);n<r;n+=1)e=createNS("path"),t.appendChild(e),this.paths.push({p:e,m:n});if(3===this.filterManager.effectElements[10].p.v){var i=createNS("mask"),s=createElementID();i.setAttribute("id",s),i.setAttribute("mask-type","alpha"),i.appendChild(t),this.elem.globalData.defs.appendChild(i);var o=createNS("g");for(o.setAttribute("mask","url("+getLocationHref()+"#"+s+")");a[0];)o.appendChild(a[0]);this.elem.layerElement.appendChild(o),this.masker=i,t.setAttribute("stroke","#fff")}else if(1===this.filterManager.effectElements[10].p.v||2===this.filterManager.effectElements[10].p.v){if(2===this.filterManager.effectElements[10].p.v)for(a=this.elem.layerElement.children||this.elem.layerElement.childNodes;a.length;)this.elem.layerElement.removeChild(a[0]);this.elem.layerElement.appendChild(t),this.elem.layerElement.removeAttribute("mask"),t.setAttribute("stroke","#fff")}this.initialized=!0,this.pathMasker=t},SVGStrokeEffect.prototype.renderFrame=function(e){var t;this.initialized||this.initialize();var n,r,a=this.paths.length;for(t=0;t<a;t+=1)if(-1!==this.paths[t].m&&(n=this.elem.maskManager.viewData[this.paths[t].m],r=this.paths[t].p,(e||this.filterManager._mdf||n.prop._mdf)&&r.setAttribute("d",n.lastPath),e||this.filterManager.effectElements[9].p._mdf||this.filterManager.effectElements[4].p._mdf||this.filterManager.effectElements[7].p._mdf||this.filterManager.effectElements[8].p._mdf||n.prop._mdf)){var i;if(0!==this.filterManager.effectElements[7].p.v||100!==this.filterManager.effectElements[8].p.v){var s=.01*Math.min(this.filterManager.effectElements[7].p.v,this.filterManager.effectElements[8].p.v),o=.01*Math.max(this.filterManager.effectElements[7].p.v,this.filterManager.effectElements[8].p.v),l=r.getTotalLength();i="0 0 0 "+l*s+" ";var u,c=l*(o-s),h=1+2*this.filterManager.effectElements[4].p.v*this.filterManager.effectElements[9].p.v*.01,p=Math.floor(c/h);for(u=0;u<p;u+=1)i+="1 "+2*this.filterManager.effectElements[4].p.v*this.filterManager.effectElements[9].p.v*.01+" ";i+="0 "+10*l+" 0 0"}else i="1 "+2*this.filterManager.effectElements[4].p.v*this.filterManager.effectElements[9].p.v*.01;r.setAttribute("stroke-dasharray",i)}if((e||this.filterManager.effectElements[4].p._mdf)&&this.pathMasker.setAttribute("stroke-width",2*this.filterManager.effectElements[4].p.v),(e||this.filterManager.effectElements[6].p._mdf)&&this.pathMasker.setAttribute("opacity",this.filterManager.effectElements[6].p.v),(1===this.filterManager.effectElements[10].p.v||2===this.filterManager.effectElements[10].p.v)&&(e||this.filterManager.effectElements[3].p._mdf)){var f=this.filterManager.effectElements[3].p.v;this.pathMasker.setAttribute("stroke","rgb("+bmFloor(255*f[0])+","+bmFloor(255*f[1])+","+bmFloor(255*f[2])+")")}},SVGTritoneFilter.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){var t=this.filterManager.effectElements[0].p.v,n=this.filterManager.effectElements[1].p.v,r=this.filterManager.effectElements[2].p.v,a=r[0]+" "+n[0]+" "+t[0],i=r[1]+" "+n[1]+" "+t[1],s=r[2]+" "+n[2]+" "+t[2];this.feFuncR.setAttribute("tableValues",a),this.feFuncG.setAttribute("tableValues",i),this.feFuncB.setAttribute("tableValues",s)}},SVGProLevelsFilter.prototype.createFeFunc=function(e,t){var n=createNS(e);return n.setAttribute("type","table"),t.appendChild(n),n},SVGProLevelsFilter.prototype.getTableValue=function(e,t,n,r,a){for(var i,s,o=0,l=Math.min(e,t),u=Math.max(e,t),c=Array.call(null,{length:256}),h=0,p=a-r,f=t-e;o<=256;)s=(i=o/256)<=l?f<0?a:r:i>=u?f<0?r:a:r+p*Math.pow((i-e)/f,1/n),c[h]=s,h+=1,o+=256/255;return c.join(" ")},SVGProLevelsFilter.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){var t,n=this.filterManager.effectElements;this.feFuncRComposed&&(e||n[3].p._mdf||n[4].p._mdf||n[5].p._mdf||n[6].p._mdf||n[7].p._mdf)&&(t=this.getTableValue(n[3].p.v,n[4].p.v,n[5].p.v,n[6].p.v,n[7].p.v),this.feFuncRComposed.setAttribute("tableValues",t),this.feFuncGComposed.setAttribute("tableValues",t),this.feFuncBComposed.setAttribute("tableValues",t)),this.feFuncR&&(e||n[10].p._mdf||n[11].p._mdf||n[12].p._mdf||n[13].p._mdf||n[14].p._mdf)&&(t=this.getTableValue(n[10].p.v,n[11].p.v,n[12].p.v,n[13].p.v,n[14].p.v),this.feFuncR.setAttribute("tableValues",t)),this.feFuncG&&(e||n[17].p._mdf||n[18].p._mdf||n[19].p._mdf||n[20].p._mdf||n[21].p._mdf)&&(t=this.getTableValue(n[17].p.v,n[18].p.v,n[19].p.v,n[20].p.v,n[21].p.v),this.feFuncG.setAttribute("tableValues",t)),this.feFuncB&&(e||n[24].p._mdf||n[25].p._mdf||n[26].p._mdf||n[27].p._mdf||n[28].p._mdf)&&(t=this.getTableValue(n[24].p.v,n[25].p.v,n[26].p.v,n[27].p.v,n[28].p.v),this.feFuncB.setAttribute("tableValues",t)),this.feFuncA&&(e||n[31].p._mdf||n[32].p._mdf||n[33].p._mdf||n[34].p._mdf||n[35].p._mdf)&&(t=this.getTableValue(n[31].p.v,n[32].p.v,n[33].p.v,n[34].p.v,n[35].p.v),this.feFuncA.setAttribute("tableValues",t))}},extendPrototype([SVGComposableEffect],SVGDropShadowEffect),SVGDropShadowEffect.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){if((e||this.filterManager.effectElements[4].p._mdf)&&this.feGaussianBlur.setAttribute("stdDeviation",this.filterManager.effectElements[4].p.v/4),e||this.filterManager.effectElements[0].p._mdf){var t=this.filterManager.effectElements[0].p.v;this.feFlood.setAttribute("flood-color",rgbToHex(Math.round(255*t[0]),Math.round(255*t[1]),Math.round(255*t[2])))}if((e||this.filterManager.effectElements[1].p._mdf)&&this.feFlood.setAttribute("flood-opacity",this.filterManager.effectElements[1].p.v/255),e||this.filterManager.effectElements[2].p._mdf||this.filterManager.effectElements[3].p._mdf){var n=this.filterManager.effectElements[3].p.v,r=(this.filterManager.effectElements[2].p.v-90)*degToRads,a=n*Math.cos(r),i=n*Math.sin(r);this.feOffset.setAttribute("dx",a),this.feOffset.setAttribute("dy",i)}}};var _svgMatteSymbols=[];function SVGMatte3Effect(e,t,n){this.initialized=!1,this.filterManager=t,this.filterElem=e,this.elem=n,n.matteElement=createNS("g"),n.matteElement.appendChild(n.layerElement),n.matteElement.appendChild(n.transformedElement),n.baseElement=n.matteElement}function SVGGaussianBlurEffect(e,t,n,r){e.setAttribute("x","-100%"),e.setAttribute("y","-100%"),e.setAttribute("width","300%"),e.setAttribute("height","300%"),this.filterManager=t;var a=createNS("feGaussianBlur");a.setAttribute("result",r),e.appendChild(a),this.feGaussianBlur=a}function TransformEffect(){}function SVGTransformEffect(e,t){this.init(t)}function CVTransformEffect(e){this.init(e)}return SVGMatte3Effect.prototype.findSymbol=function(e){for(var t=0,n=_svgMatteSymbols.length;t<n;){if(_svgMatteSymbols[t]===e)return _svgMatteSymbols[t];t+=1}return null},SVGMatte3Effect.prototype.replaceInParent=function(e,t){var n=e.layerElement.parentNode;if(n){for(var r,a=n.children,i=0,s=a.length;i<s&&a[i]!==e.layerElement;)i+=1;i<=s-2&&(r=a[i+1]);var o=createNS("use");o.setAttribute("href","#"+t),r?n.insertBefore(o,r):n.appendChild(o)}},SVGMatte3Effect.prototype.setElementAsMask=function(e,t){if(!this.findSymbol(t)){var n=createElementID(),r=createNS("mask");r.setAttribute("id",t.layerId),r.setAttribute("mask-type","alpha"),_svgMatteSymbols.push(t);var a=e.globalData.defs;a.appendChild(r);var i=createNS("symbol");i.setAttribute("id",n),this.replaceInParent(t,n),i.appendChild(t.layerElement),a.appendChild(i);var s=createNS("use");s.setAttribute("href","#"+n),r.appendChild(s),t.data.hd=!1,t.show()}e.setMatte(t.layerId)},SVGMatte3Effect.prototype.initialize=function(){for(var e=this.filterManager.effectElements[0].p.v,t=this.elem.comp.elements,n=0,r=t.length;n<r;)t[n]&&t[n].data.ind===e&&this.setElementAsMask(this.elem,t[n]),n+=1;this.initialized=!0},SVGMatte3Effect.prototype.renderFrame=function(){this.initialized||this.initialize()},SVGGaussianBlurEffect.prototype.renderFrame=function(e){if(e||this.filterManager._mdf){var t=.3*this.filterManager.effectElements[0].p.v,n=this.filterManager.effectElements[1].p.v,r=3==n?0:t,a=2==n?0:t;this.feGaussianBlur.setAttribute("stdDeviation",r+" "+a);var i=1==this.filterManager.effectElements[2].p.v?"wrap":"duplicate";this.feGaussianBlur.setAttribute("edgeMode",i)}},TransformEffect.prototype.init=function(e){this.effectsManager=e,this.type=effectTypes.TRANSFORM_EFFECT,this.matrix=new Matrix,this.opacity=-1,this._mdf=!1,this._opMdf=!1},TransformEffect.prototype.renderFrame=function(e){if(this._opMdf=!1,this._mdf=!1,e||this.effectsManager._mdf){var t=this.effectsManager.effectElements,n=t[0].p.v,r=t[1].p.v,a=1===t[2].p.v,i=t[3].p.v,s=a?i:t[4].p.v,o=t[5].p.v,l=t[6].p.v,u=t[7].p.v;this.matrix.reset(),this.matrix.translate(-n[0],-n[1],n[2]),this.matrix.scale(.01*s,.01*i,1),this.matrix.rotate(-u*degToRads),this.matrix.skewFromAxis(-o*degToRads,(l+90)*degToRads),this.matrix.translate(r[0],r[1],0),this._mdf=!0,this.opacity!==t[8].p.v&&(this.opacity=t[8].p.v,this._opMdf=!0)}},extendPrototype([TransformEffect],SVGTransformEffect),extendPrototype([TransformEffect],CVTransformEffect),registerRenderer("canvas",CanvasRenderer),registerRenderer("html",HybridRenderer),registerRenderer("svg",SVGRenderer),ShapeModifiers.registerModifier("tm",TrimModifier),ShapeModifiers.registerModifier("pb",PuckerAndBloatModifier),ShapeModifiers.registerModifier("rp",RepeaterModifier),ShapeModifiers.registerModifier("rd",RoundCornersModifier),ShapeModifiers.registerModifier("zz",ZigZagModifier),ShapeModifiers.registerModifier("op",OffsetPathModifier),setExpressionsPlugin(Expressions),setExpressionInterfaces(getInterface),initialize$1(),initialize(),registerEffect$1(20,SVGTintFilter,!0),registerEffect$1(21,SVGFillFilter,!0),registerEffect$1(22,SVGStrokeEffect,!1),registerEffect$1(23,SVGTritoneFilter,!0),registerEffect$1(24,SVGProLevelsFilter,!0),registerEffect$1(25,SVGDropShadowEffect,!0),registerEffect$1(28,SVGMatte3Effect,!1),registerEffect$1(29,SVGGaussianBlurEffect,!0),registerEffect$1(35,SVGTransformEffect,!1),registerEffect(35,CVTransformEffect),lottie},module.exports=factory())},4448:(e,t,n)=>{"use strict";var r=n(7294),a=n(3840);function i(e){for(var t="https://reactjs.org/docs/error-decoder.html?invariant="+e,n=1;n<arguments.length;n++)t+="&args[]="+encodeURIComponent(arguments[n]);return"Minified React error #"+e+"; visit "+t+" for the full message or use the non-minified dev environment for full errors and additional helpful warnings."}var s=new Set,o={};function l(e,t){u(e,t),u(e+"Capture",t)}function u(e,t){for(o[e]=t,e=0;e<t.length;e++)s.add(t[e])}var c=!("undefined"==typeof window||void 0===window.document||void 0===window.document.createElement),h=Object.prototype.hasOwnProperty,p=/^[:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD][:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*$/,f={},d={};function m(e,t,n,r,a,i,s){this.acceptsBooleans=2===t||3===t||4===t,this.attributeName=r,this.attributeNamespace=a,this.mustUseProperty=n,this.propertyName=e,this.type=t,this.sanitizeURL=i,this.removeEmptyString=s}var g={};"children dangerouslySetInnerHTML defaultValue defaultChecked innerHTML suppressContentEditableWarning suppressHydrationWarning style".split(" ").forEach((function(e){g[e]=new m(e,0,!1,e,null,!1,!1)})),[["acceptCharset","accept-charset"],["className","class"],["htmlFor","for"],["httpEquiv","http-equiv"]].forEach((function(e){var t=e[0];g[t]=new m(t,1,!1,e[1],null,!1,!1)})),["contentEditable","draggable","spellCheck","value"].forEach((function(e){g[e]=new m(e,2,!1,e.toLowerCase(),null,!1,!1)})),["autoReverse","externalResourcesRequired","focusable","preserveAlpha"].forEach((function(e){g[e]=new m(e,2,!1,e,null,!1,!1)})),"allowFullScreen async autoFocus autoPlay controls default defer disabled disablePictureInPicture disableRemotePlayback formNoValidate hidden loop noModule noValidate open playsInline readOnly required reversed scoped seamless itemScope".split(" ").forEach((function(e){g[e]=new m(e,3,!1,e.toLowerCase(),null,!1,!1)})),["checked","multiple","muted","selected"].forEach((function(e){g[e]=new m(e,3,!0,e,null,!1,!1)})),["capture","download"].forEach((function(e){g[e]=new m(e,4,!1,e,null,!1,!1)})),["cols","rows","size","span"].forEach((function(e){g[e]=new m(e,6,!1,e,null,!1,!1)})),["rowSpan","start"].forEach((function(e){g[e]=new m(e,5,!1,e.toLowerCase(),null,!1,!1)}));var y=/[\-:]([a-z])/g;function v(e){return e[1].toUpperCase()}function b(e,t,n,r){var a=g.hasOwnProperty(t)?g[t]:null;(null!==a?0!==a.type:r||!(2<t.length)||"o"!==t[0]&&"O"!==t[0]||"n"!==t[1]&&"N"!==t[1])&&(function(e,t,n,r){if(null==t||function(e,t,n,r){if(null!==n&&0===n.type)return!1;switch(typeof t){case"function":case"symbol":return!0;case"boolean":return!r&&(null!==n?!n.acceptsBooleans:"data-"!==(e=e.toLowerCase().slice(0,5))&&"aria-"!==e);default:return!1}}(e,t,n,r))return!0;if(r)return!1;if(null!==n)switch(n.type){case 3:return!t;case 4:return!1===t;case 5:return isNaN(t);case 6:return isNaN(t)||1>t}return!1}(t,n,a,r)&&(n=null),r||null===a?function(e){return!!h.call(d,e)||!h.call(f,e)&&(p.test(e)?d[e]=!0:(f[e]=!0,!1))}(t)&&(null===n?e.removeAttribute(t):e.setAttribute(t,""+n)):a.mustUseProperty?e[a.propertyName]=null===n?3!==a.type&&"":n:(t=a.attributeName,r=a.attributeNamespace,null===n?e.removeAttribute(t):(n=3===(a=a.type)||4===a&&!0===n?"":""+n,r?e.setAttributeNS(r,t,n):e.setAttribute(t,n))))}"accent-height alignment-baseline arabic-form baseline-shift cap-height clip-path clip-rule color-interpolation color-interpolation-filters color-profile color-rendering dominant-baseline enable-background fill-opacity fill-rule flood-color flood-opacity font-family font-size font-size-adjust font-stretch font-style font-variant font-weight glyph-name glyph-orientation-horizontal glyph-orientation-vertical horiz-adv-x horiz-origin-x image-rendering letter-spacing lighting-color marker-end marker-mid marker-start overline-position overline-thickness paint-order panose-1 pointer-events rendering-intent shape-rendering stop-color stop-opacity strikethrough-position strikethrough-thickness stroke-dasharray stroke-dashoffset stroke-linecap stroke-linejoin stroke-miterlimit stroke-opacity stroke-width text-anchor text-decoration text-rendering underline-position underline-thickness unicode-bidi unicode-range units-per-em v-alphabetic v-hanging v-ideographic v-mathematical vector-effect vert-adv-y vert-origin-x vert-origin-y word-spacing writing-mode xmlns:xlink x-height".split(" ").forEach((function(e){var t=e.replace(y,v);g[t]=new m(t,1,!1,e,null,!1,!1)})),"xlink:actuate xlink:arcrole xlink:role xlink:show xlink:title xlink:type".split(" ").forEach((function(e){var t=e.replace(y,v);g[t]=new m(t,1,!1,e,"http://www.w3.org/1999/xlink",!1,!1)})),["xml:base","xml:lang","xml:space"].forEach((function(e){var t=e.replace(y,v);g[t]=new m(t,1,!1,e,"http://www.w3.org/XML/1998/namespace",!1,!1)})),["tabIndex","crossOrigin"].forEach((function(e){g[e]=new m(e,1,!1,e.toLowerCase(),null,!1,!1)})),g.xlinkHref=new m("xlinkHref",1,!1,"xlink:href","http://www.w3.org/1999/xlink",!0,!1),["src","href","action","formAction"].forEach((function(e){g[e]=new m(e,1,!1,e.toLowerCase(),null,!0,!0)}));var k=r.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED,x=Symbol.for("react.element"),S=Symbol.for("react.portal"),w=Symbol.for("react.fragment"),E=Symbol.for("react.strict_mode"),P=Symbol.for("react.profiler"),_=Symbol.for("react.provider"),C=Symbol.for("react.context"),A=Symbol.for("react.forward_ref"),T=Symbol.for("react.suspense"),M=Symbol.for("react.suspense_list"),D=Symbol.for("react.memo"),I=Symbol.for("react.lazy");Symbol.for("react.scope"),Symbol.for("react.debug_trace_mode");var F=Symbol.for("react.offscreen");Symbol.for("react.legacy_hidden"),Symbol.for("react.cache"),Symbol.for("react.tracing_marker");var O=Symbol.iterator;function R(e){return null===e||"object"!=typeof e?null:"function"==typeof(e=O&&e[O]||e["@@iterator"])?e:null}var L,N=Object.assign;function V(e){if(void 0===L)try{throw Error()}catch(e){var t=e.stack.trim().match(/\n( *(at )?)/);L=t&&t[1]||""}return"\n"+L+e}var B=!1;function z(e,t){if(!e||B)return"";B=!0;var n=Error.prepareStackTrace;Error.prepareStackTrace=void 0;try{if(t)if(t=function(){throw Error()},Object.defineProperty(t.prototype,"props",{set:function(){throw Error()}}),"object"==typeof Reflect&&Reflect.construct){try{Reflect.construct(t,[])}catch(e){var r=e}Reflect.construct(e,[],t)}else{try{t.call()}catch(e){r=e}e.call(t.prototype)}else{try{throw Error()}catch(e){r=e}e()}}catch(t){if(t&&r&&"string"==typeof t.stack){for(var a=t.stack.split("\n"),i=r.stack.split("\n"),s=a.length-1,o=i.length-1;1<=s&&0<=o&&a[s]!==i[o];)o--;for(;1<=s&&0<=o;s--,o--)if(a[s]!==i[o]){if(1!==s||1!==o)do{if(s--,0>--o||a[s]!==i[o]){var l="\n"+a[s].replace(" at new "," at ");return e.displayName&&l.includes("<anonymous>")&&(l=l.replace("<anonymous>",e.displayName)),l}}while(1<=s&&0<=o);break}}}finally{B=!1,Error.prepareStackTrace=n}return(e=e?e.displayName||e.name:"")?V(e):""}function j(e){switch(e.tag){case 5:return V(e.type);case 16:return V("Lazy");case 13:return V("Suspense");case 19:return V("SuspenseList");case 0:case 2:case 15:return e=z(e.type,!1);case 11:return e=z(e.type.render,!1);case 1:return e=z(e.type,!0);default:return""}}function G(e){if(null==e)return null;if("function"==typeof e)return e.displayName||e.name||null;if("string"==typeof e)return e;switch(e){case w:return"Fragment";case S:return"Portal";case P:return"Profiler";case E:return"StrictMode";case T:return"Suspense";case M:return"SuspenseList"}if("object"==typeof e)switch(e.$$typeof){case C:return(e.displayName||"Context")+".Consumer";case _:return(e._context.displayName||"Context")+".Provider";case A:var t=e.render;return(e=e.displayName)||(e=""!==(e=t.displayName||t.name||"")?"ForwardRef("+e+")":"ForwardRef"),e;case D:return null!==(t=e.displayName||null)?t:G(e.type)||"Memo";case I:t=e._payload,e=e._init;try{return G(e(t))}catch(e){}}return null}function H(e){var t=e.type;switch(e.tag){case 24:return"Cache";case 9:return(t.displayName||"Context")+".Consumer";case 10:return(t._context.displayName||"Context")+".Provider";case 18:return"DehydratedFragment";case 11:return e=(e=t.render).displayName||e.name||"",t.displayName||(""!==e?"ForwardRef("+e+")":"ForwardRef");case 7:return"Fragment";case 5:return t;case 4:return"Portal";case 3:return"Root";case 6:return"Text";case 16:return G(t);case 8:return t===E?"StrictMode":"Mode";case 22:return"Offscreen";case 12:return"Profiler";case 21:return"Scope";case 13:return"Suspense";case 19:return"SuspenseList";case 25:return"TracingMarker";case 1:case 0:case 17:case 2:case 14:case 15:if("function"==typeof t)return t.displayName||t.name||null;if("string"==typeof t)return t}return null}function q(e){switch(typeof e){case"boolean":case"number":case"string":case"undefined":case"object":return e;default:return""}}function U(e){var t=e.type;return(e=e.nodeName)&&"input"===e.toLowerCase()&&("checkbox"===t||"radio"===t)}function W(e){e._valueTracker||(e._valueTracker=function(e){var t=U(e)?"checked":"value",n=Object.getOwnPropertyDescriptor(e.constructor.prototype,t),r=""+e[t];if(!e.hasOwnProperty(t)&&void 0!==n&&"function"==typeof n.get&&"function"==typeof n.set){var a=n.get,i=n.set;return Object.defineProperty(e,t,{configurable:!0,get:function(){return a.call(this)},set:function(e){r=""+e,i.call(this,e)}}),Object.defineProperty(e,t,{enumerable:n.enumerable}),{getValue:function(){return r},setValue:function(e){r=""+e},stopTracking:function(){e._valueTracker=null,delete e[t]}}}}(e))}function $(e){if(!e)return!1;var t=e._valueTracker;if(!t)return!0;var n=t.getValue(),r="";return e&&(r=U(e)?e.checked?"true":"false":e.value),(e=r)!==n&&(t.setValue(e),!0)}function K(e){if(void 0===(e=e||("undefined"!=typeof document?document:void 0)))return null;try{return e.activeElement||e.body}catch(t){return e.body}}function J(e,t){var n=t.checked;return N({},t,{defaultChecked:void 0,defaultValue:void 0,value:void 0,checked:null!=n?n:e._wrapperState.initialChecked})}function Y(e,t){var n=null==t.defaultValue?"":t.defaultValue,r=null!=t.checked?t.checked:t.defaultChecked;n=q(null!=t.value?t.value:n),e._wrapperState={initialChecked:r,initialValue:n,controlled:"checkbox"===t.type||"radio"===t.type?null!=t.checked:null!=t.value}}function Q(e,t){null!=(t=t.checked)&&b(e,"checked",t,!1)}function X(e,t){Q(e,t);var n=q(t.value),r=t.type;if(null!=n)"number"===r?(0===n&&""===e.value||e.value!=n)&&(e.value=""+n):e.value!==""+n&&(e.value=""+n);else if("submit"===r||"reset"===r)return void e.removeAttribute("value");t.hasOwnProperty("value")?ee(e,t.type,n):t.hasOwnProperty("defaultValue")&&ee(e,t.type,q(t.defaultValue)),null==t.checked&&null!=t.defaultChecked&&(e.defaultChecked=!!t.defaultChecked)}function Z(e,t,n){if(t.hasOwnProperty("value")||t.hasOwnProperty("defaultValue")){var r=t.type;if(!("submit"!==r&&"reset"!==r||void 0!==t.value&&null!==t.value))return;t=""+e._wrapperState.initialValue,n||t===e.value||(e.value=t),e.defaultValue=t}""!==(n=e.name)&&(e.name=""),e.defaultChecked=!!e._wrapperState.initialChecked,""!==n&&(e.name=n)}function ee(e,t,n){"number"===t&&K(e.ownerDocument)===e||(null==n?e.defaultValue=""+e._wrapperState.initialValue:e.defaultValue!==""+n&&(e.defaultValue=""+n))}var te=Array.isArray;function ne(e,t,n,r){if(e=e.options,t){t={};for(var a=0;a<n.length;a++)t["$"+n[a]]=!0;for(n=0;n<e.length;n++)a=t.hasOwnProperty("$"+e[n].value),e[n].selected!==a&&(e[n].selected=a),a&&r&&(e[n].defaultSelected=!0)}else{for(n=""+q(n),t=null,a=0;a<e.length;a++){if(e[a].value===n)return e[a].selected=!0,void(r&&(e[a].defaultSelected=!0));null!==t||e[a].disabled||(t=e[a])}null!==t&&(t.selected=!0)}}function re(e,t){if(null!=t.dangerouslySetInnerHTML)throw Error(i(91));return N({},t,{value:void 0,defaultValue:void 0,children:""+e._wrapperState.initialValue})}function ae(e,t){var n=t.value;if(null==n){if(n=t.children,t=t.defaultValue,null!=n){if(null!=t)throw Error(i(92));if(te(n)){if(1<n.length)throw Error(i(93));n=n[0]}t=n}null==t&&(t=""),n=t}e._wrapperState={initialValue:q(n)}}function ie(e,t){var n=q(t.value),r=q(t.defaultValue);null!=n&&((n=""+n)!==e.value&&(e.value=n),null==t.defaultValue&&e.defaultValue!==n&&(e.defaultValue=n)),null!=r&&(e.defaultValue=""+r)}function se(e){var t=e.textContent;t===e._wrapperState.initialValue&&""!==t&&null!==t&&(e.value=t)}function oe(e){switch(e){case"svg":return"http://www.w3.org/2000/svg";case"math":return"http://www.w3.org/1998/Math/MathML";default:return"http://www.w3.org/1999/xhtml"}}function le(e,t){return null==e||"http://www.w3.org/1999/xhtml"===e?oe(t):"http://www.w3.org/2000/svg"===e&&"foreignObject"===t?"http://www.w3.org/1999/xhtml":e}var ue,ce,he=(ce=function(e,t){if("http://www.w3.org/2000/svg"!==e.namespaceURI||"innerHTML"in e)e.innerHTML=t;else{for((ue=ue||document.createElement("div")).innerHTML="<svg>"+t.valueOf().toString()+"</svg>",t=ue.firstChild;e.firstChild;)e.removeChild(e.firstChild);for(;t.firstChild;)e.appendChild(t.firstChild)}},"undefined"!=typeof MSApp&&MSApp.execUnsafeLocalFunction?function(e,t,n,r){MSApp.execUnsafeLocalFunction((function(){return ce(e,t)}))}:ce);function pe(e,t){if(t){var n=e.firstChild;if(n&&n===e.lastChild&&3===n.nodeType)return void(n.nodeValue=t)}e.textContent=t}var fe={animationIterationCount:!0,aspectRatio:!0,borderImageOutset:!0,borderImageSlice:!0,borderImageWidth:!0,boxFlex:!0,boxFlexGroup:!0,boxOrdinalGroup:!0,columnCount:!0,columns:!0,flex:!0,flexGrow:!0,flexPositive:!0,flexShrink:!0,flexNegative:!0,flexOrder:!0,gridArea:!0,gridRow:!0,gridRowEnd:!0,gridRowSpan:!0,gridRowStart:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnSpan:!0,gridColumnStart:!0,fontWeight:!0,lineClamp:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,tabSize:!0,widows:!0,zIndex:!0,zoom:!0,fillOpacity:!0,floodOpacity:!0,stopOpacity:!0,strokeDasharray:!0,strokeDashoffset:!0,strokeMiterlimit:!0,strokeOpacity:!0,strokeWidth:!0},de=["Webkit","ms","Moz","O"];function me(e,t,n){return null==t||"boolean"==typeof t||""===t?"":n||"number"!=typeof t||0===t||fe.hasOwnProperty(e)&&fe[e]?(""+t).trim():t+"px"}function ge(e,t){for(var n in e=e.style,t)if(t.hasOwnProperty(n)){var r=0===n.indexOf("--"),a=me(n,t[n],r);"float"===n&&(n="cssFloat"),r?e.setProperty(n,a):e[n]=a}}Object.keys(fe).forEach((function(e){de.forEach((function(t){t=t+e.charAt(0).toUpperCase()+e.substring(1),fe[t]=fe[e]}))}));var ye=N({menuitem:!0},{area:!0,base:!0,br:!0,col:!0,embed:!0,hr:!0,img:!0,input:!0,keygen:!0,link:!0,meta:!0,param:!0,source:!0,track:!0,wbr:!0});function ve(e,t){if(t){if(ye[e]&&(null!=t.children||null!=t.dangerouslySetInnerHTML))throw Error(i(137,e));if(null!=t.dangerouslySetInnerHTML){if(null!=t.children)throw Error(i(60));if("object"!=typeof t.dangerouslySetInnerHTML||!("__html"in t.dangerouslySetInnerHTML))throw Error(i(61))}if(null!=t.style&&"object"!=typeof t.style)throw Error(i(62))}}function be(e,t){if(-1===e.indexOf("-"))return"string"==typeof t.is;switch(e){case"annotation-xml":case"color-profile":case"font-face":case"font-face-src":case"font-face-uri":case"font-face-format":case"font-face-name":case"missing-glyph":return!1;default:return!0}}var ke=null;function xe(e){return(e=e.target||e.srcElement||window).correspondingUseElement&&(e=e.correspondingUseElement),3===e.nodeType?e.parentNode:e}var Se=null,we=null,Ee=null;function Pe(e){if(e=ba(e)){if("function"!=typeof Se)throw Error(i(280));var t=e.stateNode;t&&(t=xa(t),Se(e.stateNode,e.type,t))}}function _e(e){we?Ee?Ee.push(e):Ee=[e]:we=e}function Ce(){if(we){var e=we,t=Ee;if(Ee=we=null,Pe(e),t)for(e=0;e<t.length;e++)Pe(t[e])}}function Ae(e,t){return e(t)}function Te(){}var Me=!1;function De(e,t,n){if(Me)return e(t,n);Me=!0;try{return Ae(e,t,n)}finally{Me=!1,(null!==we||null!==Ee)&&(Te(),Ce())}}function Ie(e,t){var n=e.stateNode;if(null===n)return null;var r=xa(n);if(null===r)return null;n=r[t];e:switch(t){case"onClick":case"onClickCapture":case"onDoubleClick":case"onDoubleClickCapture":case"onMouseDown":case"onMouseDownCapture":case"onMouseMove":case"onMouseMoveCapture":case"onMouseUp":case"onMouseUpCapture":case"onMouseEnter":(r=!r.disabled)||(r=!("button"===(e=e.type)||"input"===e||"select"===e||"textarea"===e)),e=!r;break e;default:e=!1}if(e)return null;if(n&&"function"!=typeof n)throw Error(i(231,t,typeof n));return n}var Fe=!1;if(c)try{var Oe={};Object.defineProperty(Oe,"passive",{get:function(){Fe=!0}}),window.addEventListener("test",Oe,Oe),window.removeEventListener("test",Oe,Oe)}catch(ce){Fe=!1}function Re(e,t,n,r,a,i,s,o,l){var u=Array.prototype.slice.call(arguments,3);try{t.apply(n,u)}catch(e){this.onError(e)}}var Le=!1,Ne=null,Ve=!1,Be=null,ze={onError:function(e){Le=!0,Ne=e}};function je(e,t,n,r,a,i,s,o,l){Le=!1,Ne=null,Re.apply(ze,arguments)}function Ge(e){var t=e,n=e;if(e.alternate)for(;t.return;)t=t.return;else{e=t;do{0!=(4098&(t=e).flags)&&(n=t.return),e=t.return}while(e)}return 3===t.tag?n:null}function He(e){if(13===e.tag){var t=e.memoizedState;if(null===t&&(null!==(e=e.alternate)&&(t=e.memoizedState)),null!==t)return t.dehydrated}return null}function qe(e){if(Ge(e)!==e)throw Error(i(188))}function Ue(e){return null!==(e=function(e){var t=e.alternate;if(!t){if(null===(t=Ge(e)))throw Error(i(188));return t!==e?null:e}for(var n=e,r=t;;){var a=n.return;if(null===a)break;var s=a.alternate;if(null===s){if(null!==(r=a.return)){n=r;continue}break}if(a.child===s.child){for(s=a.child;s;){if(s===n)return qe(a),e;if(s===r)return qe(a),t;s=s.sibling}throw Error(i(188))}if(n.return!==r.return)n=a,r=s;else{for(var o=!1,l=a.child;l;){if(l===n){o=!0,n=a,r=s;break}if(l===r){o=!0,r=a,n=s;break}l=l.sibling}if(!o){for(l=s.child;l;){if(l===n){o=!0,n=s,r=a;break}if(l===r){o=!0,r=s,n=a;break}l=l.sibling}if(!o)throw Error(i(189))}}if(n.alternate!==r)throw Error(i(190))}if(3!==n.tag)throw Error(i(188));return n.stateNode.current===n?e:t}(e))?We(e):null}function We(e){if(5===e.tag||6===e.tag)return e;for(e=e.child;null!==e;){var t=We(e);if(null!==t)return t;e=e.sibling}return null}var $e=a.unstable_scheduleCallback,Ke=a.unstable_cancelCallback,Je=a.unstable_shouldYield,Ye=a.unstable_requestPaint,Qe=a.unstable_now,Xe=a.unstable_getCurrentPriorityLevel,Ze=a.unstable_ImmediatePriority,et=a.unstable_UserBlockingPriority,tt=a.unstable_NormalPriority,nt=a.unstable_LowPriority,rt=a.unstable_IdlePriority,at=null,it=null;var st=Math.clz32?Math.clz32:function(e){return e>>>=0,0===e?32:31-(ot(e)/lt|0)|0},ot=Math.log,lt=Math.LN2;var ut=64,ct=4194304;function ht(e){switch(e&-e){case 1:return 1;case 2:return 2;case 4:return 4;case 8:return 8;case 16:return 16;case 32:return 32;case 64:case 128:case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:case 262144:case 524288:case 1048576:case 2097152:return 4194240&e;case 4194304:case 8388608:case 16777216:case 33554432:case 67108864:return 130023424&e;case 134217728:return 134217728;case 268435456:return 268435456;case 536870912:return 536870912;case 1073741824:return 1073741824;default:return e}}function pt(e,t){var n=e.pendingLanes;if(0===n)return 0;var r=0,a=e.suspendedLanes,i=e.pingedLanes,s=268435455&n;if(0!==s){var o=s&~a;0!==o?r=ht(o):0!==(i&=s)&&(r=ht(i))}else 0!==(s=n&~a)?r=ht(s):0!==i&&(r=ht(i));if(0===r)return 0;if(0!==t&&t!==r&&0==(t&a)&&((a=r&-r)>=(i=t&-t)||16===a&&0!=(4194240&i)))return t;if(0!=(4&r)&&(r|=16&n),0!==(t=e.entangledLanes))for(e=e.entanglements,t&=r;0<t;)a=1<<(n=31-st(t)),r|=e[n],t&=~a;return r}function ft(e,t){switch(e){case 1:case 2:case 4:return t+250;case 8:case 16:case 32:case 64:case 128:case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:case 262144:case 524288:case 1048576:case 2097152:return t+5e3;default:return-1}}function dt(e){return 0!==(e=-1073741825&e.pendingLanes)?e:1073741824&e?1073741824:0}function mt(){var e=ut;return 0==(4194240&(ut<<=1))&&(ut=64),e}function gt(e){for(var t=[],n=0;31>n;n++)t.push(e);return t}function yt(e,t,n){e.pendingLanes|=t,536870912!==t&&(e.suspendedLanes=0,e.pingedLanes=0),(e=e.eventTimes)[t=31-st(t)]=n}function vt(e,t){var n=e.entangledLanes|=t;for(e=e.entanglements;n;){var r=31-st(n),a=1<<r;a&t|e[r]&t&&(e[r]|=t),n&=~a}}var bt=0;function kt(e){return 1<(e&=-e)?4<e?0!=(268435455&e)?16:536870912:4:1}var xt,St,wt,Et,Pt,_t=!1,Ct=[],At=null,Tt=null,Mt=null,Dt=new Map,It=new Map,Ft=[],Ot="mousedown mouseup touchcancel touchend touchstart auxclick dblclick pointercancel pointerdown pointerup dragend dragstart drop compositionend compositionstart keydown keypress keyup input textInput copy cut paste click change contextmenu reset submit".split(" ");function Rt(e,t){switch(e){case"focusin":case"focusout":At=null;break;case"dragenter":case"dragleave":Tt=null;break;case"mouseover":case"mouseout":Mt=null;break;case"pointerover":case"pointerout":Dt.delete(t.pointerId);break;case"gotpointercapture":case"lostpointercapture":It.delete(t.pointerId)}}function Lt(e,t,n,r,a,i){return null===e||e.nativeEvent!==i?(e={blockedOn:t,domEventName:n,eventSystemFlags:r,nativeEvent:i,targetContainers:[a]},null!==t&&(null!==(t=ba(t))&&St(t)),e):(e.eventSystemFlags|=r,t=e.targetContainers,null!==a&&-1===t.indexOf(a)&&t.push(a),e)}function Nt(e){var t=va(e.target);if(null!==t){var n=Ge(t);if(null!==n)if(13===(t=n.tag)){if(null!==(t=He(n)))return e.blockedOn=t,void Pt(e.priority,(function(){wt(n)}))}else if(3===t&&n.stateNode.current.memoizedState.isDehydrated)return void(e.blockedOn=3===n.tag?n.stateNode.containerInfo:null)}e.blockedOn=null}function Vt(e){if(null!==e.blockedOn)return!1;for(var t=e.targetContainers;0<t.length;){var n=Jt(e.domEventName,e.eventSystemFlags,t[0],e.nativeEvent);if(null!==n)return null!==(t=ba(n))&&St(t),e.blockedOn=n,!1;var r=new(n=e.nativeEvent).constructor(n.type,n);ke=r,n.target.dispatchEvent(r),ke=null,t.shift()}return!0}function Bt(e,t,n){Vt(e)&&n.delete(t)}function zt(){_t=!1,null!==At&&Vt(At)&&(At=null),null!==Tt&&Vt(Tt)&&(Tt=null),null!==Mt&&Vt(Mt)&&(Mt=null),Dt.forEach(Bt),It.forEach(Bt)}function jt(e,t){e.blockedOn===t&&(e.blockedOn=null,_t||(_t=!0,a.unstable_scheduleCallback(a.unstable_NormalPriority,zt)))}function Gt(e){function t(t){return jt(t,e)}if(0<Ct.length){jt(Ct[0],e);for(var n=1;n<Ct.length;n++){var r=Ct[n];r.blockedOn===e&&(r.blockedOn=null)}}for(null!==At&&jt(At,e),null!==Tt&&jt(Tt,e),null!==Mt&&jt(Mt,e),Dt.forEach(t),It.forEach(t),n=0;n<Ft.length;n++)(r=Ft[n]).blockedOn===e&&(r.blockedOn=null);for(;0<Ft.length&&null===(n=Ft[0]).blockedOn;)Nt(n),null===n.blockedOn&&Ft.shift()}var Ht=k.ReactCurrentBatchConfig,qt=!0;function Ut(e,t,n,r){var a=bt,i=Ht.transition;Ht.transition=null;try{bt=1,$t(e,t,n,r)}finally{bt=a,Ht.transition=i}}function Wt(e,t,n,r){var a=bt,i=Ht.transition;Ht.transition=null;try{bt=4,$t(e,t,n,r)}finally{bt=a,Ht.transition=i}}function $t(e,t,n,r){if(qt){var a=Jt(e,t,n,r);if(null===a)qr(e,t,r,Kt,n),Rt(e,r);else if(function(e,t,n,r,a){switch(t){case"focusin":return At=Lt(At,e,t,n,r,a),!0;case"dragenter":return Tt=Lt(Tt,e,t,n,r,a),!0;case"mouseover":return Mt=Lt(Mt,e,t,n,r,a),!0;case"pointerover":var i=a.pointerId;return Dt.set(i,Lt(Dt.get(i)||null,e,t,n,r,a)),!0;case"gotpointercapture":return i=a.pointerId,It.set(i,Lt(It.get(i)||null,e,t,n,r,a)),!0}return!1}(a,e,t,n,r))r.stopPropagation();else if(Rt(e,r),4&t&&-1<Ot.indexOf(e)){for(;null!==a;){var i=ba(a);if(null!==i&&xt(i),null===(i=Jt(e,t,n,r))&&qr(e,t,r,Kt,n),i===a)break;a=i}null!==a&&r.stopPropagation()}else qr(e,t,r,null,n)}}var Kt=null;function Jt(e,t,n,r){if(Kt=null,null!==(e=va(e=xe(r))))if(null===(t=Ge(e)))e=null;else if(13===(n=t.tag)){if(null!==(e=He(t)))return e;e=null}else if(3===n){if(t.stateNode.current.memoizedState.isDehydrated)return 3===t.tag?t.stateNode.containerInfo:null;e=null}else t!==e&&(e=null);return Kt=e,null}function Yt(e){switch(e){case"cancel":case"click":case"close":case"contextmenu":case"copy":case"cut":case"auxclick":case"dblclick":case"dragend":case"dragstart":case"drop":case"focusin":case"focusout":case"input":case"invalid":case"keydown":case"keypress":case"keyup":case"mousedown":case"mouseup":case"paste":case"pause":case"play":case"pointercancel":case"pointerdown":case"pointerup":case"ratechange":case"reset":case"resize":case"seeked":case"submit":case"touchcancel":case"touchend":case"touchstart":case"volumechange":case"change":case"selectionchange":case"textInput":case"compositionstart":case"compositionend":case"compositionupdate":case"beforeblur":case"afterblur":case"beforeinput":case"blur":case"fullscreenchange":case"focus":case"hashchange":case"popstate":case"select":case"selectstart":return 1;case"drag":case"dragenter":case"dragexit":case"dragleave":case"dragover":case"mousemove":case"mouseout":case"mouseover":case"pointermove":case"pointerout":case"pointerover":case"scroll":case"toggle":case"touchmove":case"wheel":case"mouseenter":case"mouseleave":case"pointerenter":case"pointerleave":return 4;case"message":switch(Xe()){case Ze:return 1;case et:return 4;case tt:case nt:return 16;case rt:return 536870912;default:return 16}default:return 16}}var Qt=null,Xt=null,Zt=null;function en(){if(Zt)return Zt;var e,t,n=Xt,r=n.length,a="value"in Qt?Qt.value:Qt.textContent,i=a.length;for(e=0;e<r&&n[e]===a[e];e++);var s=r-e;for(t=1;t<=s&&n[r-t]===a[i-t];t++);return Zt=a.slice(e,1<t?1-t:void 0)}function tn(e){var t=e.keyCode;return"charCode"in e?0===(e=e.charCode)&&13===t&&(e=13):e=t,10===e&&(e=13),32<=e||13===e?e:0}function nn(){return!0}function rn(){return!1}function an(e){function t(t,n,r,a,i){for(var s in this._reactName=t,this._targetInst=r,this.type=n,this.nativeEvent=a,this.target=i,this.currentTarget=null,e)e.hasOwnProperty(s)&&(t=e[s],this[s]=t?t(a):a[s]);return this.isDefaultPrevented=(null!=a.defaultPrevented?a.defaultPrevented:!1===a.returnValue)?nn:rn,this.isPropagationStopped=rn,this}return N(t.prototype,{preventDefault:function(){this.defaultPrevented=!0;var e=this.nativeEvent;e&&(e.preventDefault?e.preventDefault():"unknown"!=typeof e.returnValue&&(e.returnValue=!1),this.isDefaultPrevented=nn)},stopPropagation:function(){var e=this.nativeEvent;e&&(e.stopPropagation?e.stopPropagation():"unknown"!=typeof e.cancelBubble&&(e.cancelBubble=!0),this.isPropagationStopped=nn)},persist:function(){},isPersistent:nn}),t}var sn,on,ln,un={eventPhase:0,bubbles:0,cancelable:0,timeStamp:function(e){return e.timeStamp||Date.now()},defaultPrevented:0,isTrusted:0},cn=an(un),hn=N({},un,{view:0,detail:0}),pn=an(hn),fn=N({},hn,{screenX:0,screenY:0,clientX:0,clientY:0,pageX:0,pageY:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,getModifierState:Pn,button:0,buttons:0,relatedTarget:function(e){return void 0===e.relatedTarget?e.fromElement===e.srcElement?e.toElement:e.fromElement:e.relatedTarget},movementX:function(e){return"movementX"in e?e.movementX:(e!==ln&&(ln&&"mousemove"===e.type?(sn=e.screenX-ln.screenX,on=e.screenY-ln.screenY):on=sn=0,ln=e),sn)},movementY:function(e){return"movementY"in e?e.movementY:on}}),dn=an(fn),mn=an(N({},fn,{dataTransfer:0})),gn=an(N({},hn,{relatedTarget:0})),yn=an(N({},un,{animationName:0,elapsedTime:0,pseudoElement:0})),vn=N({},un,{clipboardData:function(e){return"clipboardData"in e?e.clipboardData:window.clipboardData}}),bn=an(vn),kn=an(N({},un,{data:0})),xn={Esc:"Escape",Spacebar:" ",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown",Del:"Delete",Win:"OS",Menu:"ContextMenu",Apps:"ContextMenu",Scroll:"ScrollLock",MozPrintableKey:"Unidentified"},Sn={8:"Backspace",9:"Tab",12:"Clear",13:"Enter",16:"Shift",17:"Control",18:"Alt",19:"Pause",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",45:"Insert",46:"Delete",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"NumLock",145:"ScrollLock",224:"Meta"},wn={Alt:"altKey",Control:"ctrlKey",Meta:"metaKey",Shift:"shiftKey"};function En(e){var t=this.nativeEvent;return t.getModifierState?t.getModifierState(e):!!(e=wn[e])&&!!t[e]}function Pn(){return En}var _n=N({},hn,{key:function(e){if(e.key){var t=xn[e.key]||e.key;if("Unidentified"!==t)return t}return"keypress"===e.type?13===(e=tn(e))?"Enter":String.fromCharCode(e):"keydown"===e.type||"keyup"===e.type?Sn[e.keyCode]||"Unidentified":""},code:0,location:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,repeat:0,locale:0,getModifierState:Pn,charCode:function(e){return"keypress"===e.type?tn(e):0},keyCode:function(e){return"keydown"===e.type||"keyup"===e.type?e.keyCode:0},which:function(e){return"keypress"===e.type?tn(e):"keydown"===e.type||"keyup"===e.type?e.keyCode:0}}),Cn=an(_n),An=an(N({},fn,{pointerId:0,width:0,height:0,pressure:0,tangentialPressure:0,tiltX:0,tiltY:0,twist:0,pointerType:0,isPrimary:0})),Tn=an(N({},hn,{touches:0,targetTouches:0,changedTouches:0,altKey:0,metaKey:0,ctrlKey:0,shiftKey:0,getModifierState:Pn})),Mn=an(N({},un,{propertyName:0,elapsedTime:0,pseudoElement:0})),Dn=N({},fn,{deltaX:function(e){return"deltaX"in e?e.deltaX:"wheelDeltaX"in e?-e.wheelDeltaX:0},deltaY:function(e){return"deltaY"in e?e.deltaY:"wheelDeltaY"in e?-e.wheelDeltaY:"wheelDelta"in e?-e.wheelDelta:0},deltaZ:0,deltaMode:0}),In=an(Dn),Fn=[9,13,27,32],On=c&&"CompositionEvent"in window,Rn=null;c&&"documentMode"in document&&(Rn=document.documentMode);var Ln=c&&"TextEvent"in window&&!Rn,Nn=c&&(!On||Rn&&8<Rn&&11>=Rn),Vn=String.fromCharCode(32),Bn=!1;function zn(e,t){switch(e){case"keyup":return-1!==Fn.indexOf(t.keyCode);case"keydown":return 229!==t.keyCode;case"keypress":case"mousedown":case"focusout":return!0;default:return!1}}function jn(e){return"object"==typeof(e=e.detail)&&"data"in e?e.data:null}var Gn=!1;var Hn={color:!0,date:!0,datetime:!0,"datetime-local":!0,email:!0,month:!0,number:!0,password:!0,range:!0,search:!0,tel:!0,text:!0,time:!0,url:!0,week:!0};function qn(e){var t=e&&e.nodeName&&e.nodeName.toLowerCase();return"input"===t?!!Hn[e.type]:"textarea"===t}function Un(e,t,n,r){_e(r),0<(t=Wr(t,"onChange")).length&&(n=new cn("onChange","change",null,n,r),e.push({event:n,listeners:t}))}var Wn=null,$n=null;function Kn(e){Vr(e,0)}function Jn(e){if($(ka(e)))return e}function Yn(e,t){if("change"===e)return t}var Qn=!1;if(c){var Xn;if(c){var Zn="oninput"in document;if(!Zn){var er=document.createElement("div");er.setAttribute("oninput","return;"),Zn="function"==typeof er.oninput}Xn=Zn}else Xn=!1;Qn=Xn&&(!document.documentMode||9<document.documentMode)}function tr(){Wn&&(Wn.detachEvent("onpropertychange",nr),$n=Wn=null)}function nr(e){if("value"===e.propertyName&&Jn($n)){var t=[];Un(t,$n,e,xe(e)),De(Kn,t)}}function rr(e,t,n){"focusin"===e?(tr(),$n=n,(Wn=t).attachEvent("onpropertychange",nr)):"focusout"===e&&tr()}function ar(e){if("selectionchange"===e||"keyup"===e||"keydown"===e)return Jn($n)}function ir(e,t){if("click"===e)return Jn(t)}function sr(e,t){if("input"===e||"change"===e)return Jn(t)}var or="function"==typeof Object.is?Object.is:function(e,t){return e===t&&(0!==e||1/e==1/t)||e!=e&&t!=t};function lr(e,t){if(or(e,t))return!0;if("object"!=typeof e||null===e||"object"!=typeof t||null===t)return!1;var n=Object.keys(e),r=Object.keys(t);if(n.length!==r.length)return!1;for(r=0;r<n.length;r++){var a=n[r];if(!h.call(t,a)||!or(e[a],t[a]))return!1}return!0}function ur(e){for(;e&&e.firstChild;)e=e.firstChild;return e}function cr(e,t){var n,r=ur(e);for(e=0;r;){if(3===r.nodeType){if(n=e+r.textContent.length,e<=t&&n>=t)return{node:r,offset:t-e};e=n}e:{for(;r;){if(r.nextSibling){r=r.nextSibling;break e}r=r.parentNode}r=void 0}r=ur(r)}}function hr(e,t){return!(!e||!t)&&(e===t||(!e||3!==e.nodeType)&&(t&&3===t.nodeType?hr(e,t.parentNode):"contains"in e?e.contains(t):!!e.compareDocumentPosition&&!!(16&e.compareDocumentPosition(t))))}function pr(){for(var e=window,t=K();t instanceof e.HTMLIFrameElement;){try{var n="string"==typeof t.contentWindow.location.href}catch(e){n=!1}if(!n)break;t=K((e=t.contentWindow).document)}return t}function fr(e){var t=e&&e.nodeName&&e.nodeName.toLowerCase();return t&&("input"===t&&("text"===e.type||"search"===e.type||"tel"===e.type||"url"===e.type||"password"===e.type)||"textarea"===t||"true"===e.contentEditable)}function dr(e){var t=pr(),n=e.focusedElem,r=e.selectionRange;if(t!==n&&n&&n.ownerDocument&&hr(n.ownerDocument.documentElement,n)){if(null!==r&&fr(n))if(t=r.start,void 0===(e=r.end)&&(e=t),"selectionStart"in n)n.selectionStart=t,n.selectionEnd=Math.min(e,n.value.length);else if((e=(t=n.ownerDocument||document)&&t.defaultView||window).getSelection){e=e.getSelection();var a=n.textContent.length,i=Math.min(r.start,a);r=void 0===r.end?i:Math.min(r.end,a),!e.extend&&i>r&&(a=r,r=i,i=a),a=cr(n,i);var s=cr(n,r);a&&s&&(1!==e.rangeCount||e.anchorNode!==a.node||e.anchorOffset!==a.offset||e.focusNode!==s.node||e.focusOffset!==s.offset)&&((t=t.createRange()).setStart(a.node,a.offset),e.removeAllRanges(),i>r?(e.addRange(t),e.extend(s.node,s.offset)):(t.setEnd(s.node,s.offset),e.addRange(t)))}for(t=[],e=n;e=e.parentNode;)1===e.nodeType&&t.push({element:e,left:e.scrollLeft,top:e.scrollTop});for("function"==typeof n.focus&&n.focus(),n=0;n<t.length;n++)(e=t[n]).element.scrollLeft=e.left,e.element.scrollTop=e.top}}var mr=c&&"documentMode"in document&&11>=document.documentMode,gr=null,yr=null,vr=null,br=!1;function kr(e,t,n){var r=n.window===n?n.document:9===n.nodeType?n:n.ownerDocument;br||null==gr||gr!==K(r)||("selectionStart"in(r=gr)&&fr(r)?r={start:r.selectionStart,end:r.selectionEnd}:r={anchorNode:(r=(r.ownerDocument&&r.ownerDocument.defaultView||window).getSelection()).anchorNode,anchorOffset:r.anchorOffset,focusNode:r.focusNode,focusOffset:r.focusOffset},vr&&lr(vr,r)||(vr=r,0<(r=Wr(yr,"onSelect")).length&&(t=new cn("onSelect","select",null,t,n),e.push({event:t,listeners:r}),t.target=gr)))}function xr(e,t){var n={};return n[e.toLowerCase()]=t.toLowerCase(),n["Webkit"+e]="webkit"+t,n["Moz"+e]="moz"+t,n}var Sr={animationend:xr("Animation","AnimationEnd"),animationiteration:xr("Animation","AnimationIteration"),animationstart:xr("Animation","AnimationStart"),transitionend:xr("Transition","TransitionEnd")},wr={},Er={};function Pr(e){if(wr[e])return wr[e];if(!Sr[e])return e;var t,n=Sr[e];for(t in n)if(n.hasOwnProperty(t)&&t in Er)return wr[e]=n[t];return e}c&&(Er=document.createElement("div").style,"AnimationEvent"in window||(delete Sr.animationend.animation,delete Sr.animationiteration.animation,delete Sr.animationstart.animation),"TransitionEvent"in window||delete Sr.transitionend.transition);var _r=Pr("animationend"),Cr=Pr("animationiteration"),Ar=Pr("animationstart"),Tr=Pr("transitionend"),Mr=new Map,Dr="abort auxClick cancel canPlay canPlayThrough click close contextMenu copy cut drag dragEnd dragEnter dragExit dragLeave dragOver dragStart drop durationChange emptied encrypted ended error gotPointerCapture input invalid keyDown keyPress keyUp load loadedData loadedMetadata loadStart lostPointerCapture mouseDown mouseMove mouseOut mouseOver mouseUp paste pause play playing pointerCancel pointerDown pointerMove pointerOut pointerOver pointerUp progress rateChange reset resize seeked seeking stalled submit suspend timeUpdate touchCancel touchEnd touchStart volumeChange scroll toggle touchMove waiting wheel".split(" ");function Ir(e,t){Mr.set(e,t),l(t,[e])}for(var Fr=0;Fr<Dr.length;Fr++){var Or=Dr[Fr];Ir(Or.toLowerCase(),"on"+(Or[0].toUpperCase()+Or.slice(1)))}Ir(_r,"onAnimationEnd"),Ir(Cr,"onAnimationIteration"),Ir(Ar,"onAnimationStart"),Ir("dblclick","onDoubleClick"),Ir("focusin","onFocus"),Ir("focusout","onBlur"),Ir(Tr,"onTransitionEnd"),u("onMouseEnter",["mouseout","mouseover"]),u("onMouseLeave",["mouseout","mouseover"]),u("onPointerEnter",["pointerout","pointerover"]),u("onPointerLeave",["pointerout","pointerover"]),l("onChange","change click focusin focusout input keydown keyup selectionchange".split(" ")),l("onSelect","focusout contextmenu dragend focusin keydown keyup mousedown mouseup selectionchange".split(" ")),l("onBeforeInput",["compositionend","keypress","textInput","paste"]),l("onCompositionEnd","compositionend focusout keydown keypress keyup mousedown".split(" ")),l("onCompositionStart","compositionstart focusout keydown keypress keyup mousedown".split(" ")),l("onCompositionUpdate","compositionupdate focusout keydown keypress keyup mousedown".split(" "));var Rr="abort canplay canplaythrough durationchange emptied encrypted ended error loadeddata loadedmetadata loadstart pause play playing progress ratechange resize seeked seeking stalled suspend timeupdate volumechange waiting".split(" "),Lr=new Set("cancel close invalid load scroll toggle".split(" ").concat(Rr));function Nr(e,t,n){var r=e.type||"unknown-event";e.currentTarget=n,function(e,t,n,r,a,s,o,l,u){if(je.apply(this,arguments),Le){if(!Le)throw Error(i(198));var c=Ne;Le=!1,Ne=null,Ve||(Ve=!0,Be=c)}}(r,t,void 0,e),e.currentTarget=null}function Vr(e,t){t=0!=(4&t);for(var n=0;n<e.length;n++){var r=e[n],a=r.event;r=r.listeners;e:{var i=void 0;if(t)for(var s=r.length-1;0<=s;s--){var o=r[s],l=o.instance,u=o.currentTarget;if(o=o.listener,l!==i&&a.isPropagationStopped())break e;Nr(a,o,u),i=l}else for(s=0;s<r.length;s++){if(l=(o=r[s]).instance,u=o.currentTarget,o=o.listener,l!==i&&a.isPropagationStopped())break e;Nr(a,o,u),i=l}}}if(Ve)throw e=Be,Ve=!1,Be=null,e}function Br(e,t){var n=t[ma];void 0===n&&(n=t[ma]=new Set);var r=e+"__bubble";n.has(r)||(Hr(t,e,2,!1),n.add(r))}function zr(e,t,n){var r=0;t&&(r|=4),Hr(n,e,r,t)}var jr="_reactListening"+Math.random().toString(36).slice(2);function Gr(e){if(!e[jr]){e[jr]=!0,s.forEach((function(t){"selectionchange"!==t&&(Lr.has(t)||zr(t,!1,e),zr(t,!0,e))}));var t=9===e.nodeType?e:e.ownerDocument;null===t||t[jr]||(t[jr]=!0,zr("selectionchange",!1,t))}}function Hr(e,t,n,r){switch(Yt(t)){case 1:var a=Ut;break;case 4:a=Wt;break;default:a=$t}n=a.bind(null,t,n,e),a=void 0,!Fe||"touchstart"!==t&&"touchmove"!==t&&"wheel"!==t||(a=!0),r?void 0!==a?e.addEventListener(t,n,{capture:!0,passive:a}):e.addEventListener(t,n,!0):void 0!==a?e.addEventListener(t,n,{passive:a}):e.addEventListener(t,n,!1)}function qr(e,t,n,r,a){var i=r;if(0==(1&t)&&0==(2&t)&&null!==r)e:for(;;){if(null===r)return;var s=r.tag;if(3===s||4===s){var o=r.stateNode.containerInfo;if(o===a||8===o.nodeType&&o.parentNode===a)break;if(4===s)for(s=r.return;null!==s;){var l=s.tag;if((3===l||4===l)&&((l=s.stateNode.containerInfo)===a||8===l.nodeType&&l.parentNode===a))return;s=s.return}for(;null!==o;){if(null===(s=va(o)))return;if(5===(l=s.tag)||6===l){r=i=s;continue e}o=o.parentNode}}r=r.return}De((function(){var r=i,a=xe(n),s=[];e:{var o=Mr.get(e);if(void 0!==o){var l=cn,u=e;switch(e){case"keypress":if(0===tn(n))break e;case"keydown":case"keyup":l=Cn;break;case"focusin":u="focus",l=gn;break;case"focusout":u="blur",l=gn;break;case"beforeblur":case"afterblur":l=gn;break;case"click":if(2===n.button)break e;case"auxclick":case"dblclick":case"mousedown":case"mousemove":case"mouseup":case"mouseout":case"mouseover":case"contextmenu":l=dn;break;case"drag":case"dragend":case"dragenter":case"dragexit":case"dragleave":case"dragover":case"dragstart":case"drop":l=mn;break;case"touchcancel":case"touchend":case"touchmove":case"touchstart":l=Tn;break;case _r:case Cr:case Ar:l=yn;break;case Tr:l=Mn;break;case"scroll":l=pn;break;case"wheel":l=In;break;case"copy":case"cut":case"paste":l=bn;break;case"gotpointercapture":case"lostpointercapture":case"pointercancel":case"pointerdown":case"pointermove":case"pointerout":case"pointerover":case"pointerup":l=An}var c=0!=(4&t),h=!c&&"scroll"===e,p=c?null!==o?o+"Capture":null:o;c=[];for(var f,d=r;null!==d;){var m=(f=d).stateNode;if(5===f.tag&&null!==m&&(f=m,null!==p&&(null!=(m=Ie(d,p))&&c.push(Ur(d,m,f)))),h)break;d=d.return}0<c.length&&(o=new l(o,u,null,n,a),s.push({event:o,listeners:c}))}}if(0==(7&t)){if(l="mouseout"===e||"pointerout"===e,(!(o="mouseover"===e||"pointerover"===e)||n===ke||!(u=n.relatedTarget||n.fromElement)||!va(u)&&!u[da])&&(l||o)&&(o=a.window===a?a:(o=a.ownerDocument)?o.defaultView||o.parentWindow:window,l?(l=r,null!==(u=(u=n.relatedTarget||n.toElement)?va(u):null)&&(u!==(h=Ge(u))||5!==u.tag&&6!==u.tag)&&(u=null)):(l=null,u=r),l!==u)){if(c=dn,m="onMouseLeave",p="onMouseEnter",d="mouse","pointerout"!==e&&"pointerover"!==e||(c=An,m="onPointerLeave",p="onPointerEnter",d="pointer"),h=null==l?o:ka(l),f=null==u?o:ka(u),(o=new c(m,d+"leave",l,n,a)).target=h,o.relatedTarget=f,m=null,va(a)===r&&((c=new c(p,d+"enter",u,n,a)).target=f,c.relatedTarget=h,m=c),h=m,l&&u)e:{for(p=u,d=0,f=c=l;f;f=$r(f))d++;for(f=0,m=p;m;m=$r(m))f++;for(;0<d-f;)c=$r(c),d--;for(;0<f-d;)p=$r(p),f--;for(;d--;){if(c===p||null!==p&&c===p.alternate)break e;c=$r(c),p=$r(p)}c=null}else c=null;null!==l&&Kr(s,o,l,c,!1),null!==u&&null!==h&&Kr(s,h,u,c,!0)}if("select"===(l=(o=r?ka(r):window).nodeName&&o.nodeName.toLowerCase())||"input"===l&&"file"===o.type)var g=Yn;else if(qn(o))if(Qn)g=sr;else{g=ar;var y=rr}else(l=o.nodeName)&&"input"===l.toLowerCase()&&("checkbox"===o.type||"radio"===o.type)&&(g=ir);switch(g&&(g=g(e,r))?Un(s,g,n,a):(y&&y(e,o,r),"focusout"===e&&(y=o._wrapperState)&&y.controlled&&"number"===o.type&&ee(o,"number",o.value)),y=r?ka(r):window,e){case"focusin":(qn(y)||"true"===y.contentEditable)&&(gr=y,yr=r,vr=null);break;case"focusout":vr=yr=gr=null;break;case"mousedown":br=!0;break;case"contextmenu":case"mouseup":case"dragend":br=!1,kr(s,n,a);break;case"selectionchange":if(mr)break;case"keydown":case"keyup":kr(s,n,a)}var v;if(On)e:{switch(e){case"compositionstart":var b="onCompositionStart";break e;case"compositionend":b="onCompositionEnd";break e;case"compositionupdate":b="onCompositionUpdate";break e}b=void 0}else Gn?zn(e,n)&&(b="onCompositionEnd"):"keydown"===e&&229===n.keyCode&&(b="onCompositionStart");b&&(Nn&&"ko"!==n.locale&&(Gn||"onCompositionStart"!==b?"onCompositionEnd"===b&&Gn&&(v=en()):(Xt="value"in(Qt=a)?Qt.value:Qt.textContent,Gn=!0)),0<(y=Wr(r,b)).length&&(b=new kn(b,e,null,n,a),s.push({event:b,listeners:y}),v?b.data=v:null!==(v=jn(n))&&(b.data=v))),(v=Ln?function(e,t){switch(e){case"compositionend":return jn(t);case"keypress":return 32!==t.which?null:(Bn=!0,Vn);case"textInput":return(e=t.data)===Vn&&Bn?null:e;default:return null}}(e,n):function(e,t){if(Gn)return"compositionend"===e||!On&&zn(e,t)?(e=en(),Zt=Xt=Qt=null,Gn=!1,e):null;switch(e){case"paste":default:return null;case"keypress":if(!(t.ctrlKey||t.altKey||t.metaKey)||t.ctrlKey&&t.altKey){if(t.char&&1<t.char.length)return t.char;if(t.which)return String.fromCharCode(t.which)}return null;case"compositionend":return Nn&&"ko"!==t.locale?null:t.data}}(e,n))&&(0<(r=Wr(r,"onBeforeInput")).length&&(a=new kn("onBeforeInput","beforeinput",null,n,a),s.push({event:a,listeners:r}),a.data=v))}Vr(s,t)}))}function Ur(e,t,n){return{instance:e,listener:t,currentTarget:n}}function Wr(e,t){for(var n=t+"Capture",r=[];null!==e;){var a=e,i=a.stateNode;5===a.tag&&null!==i&&(a=i,null!=(i=Ie(e,n))&&r.unshift(Ur(e,i,a)),null!=(i=Ie(e,t))&&r.push(Ur(e,i,a))),e=e.return}return r}function $r(e){if(null===e)return null;do{e=e.return}while(e&&5!==e.tag);return e||null}function Kr(e,t,n,r,a){for(var i=t._reactName,s=[];null!==n&&n!==r;){var o=n,l=o.alternate,u=o.stateNode;if(null!==l&&l===r)break;5===o.tag&&null!==u&&(o=u,a?null!=(l=Ie(n,i))&&s.unshift(Ur(n,l,o)):a||null!=(l=Ie(n,i))&&s.push(Ur(n,l,o))),n=n.return}0!==s.length&&e.push({event:t,listeners:s})}var Jr=/\r\n?/g,Yr=/\u0000|\uFFFD/g;function Qr(e){return("string"==typeof e?e:""+e).replace(Jr,"\n").replace(Yr,"")}function Xr(e,t,n){if(t=Qr(t),Qr(e)!==t&&n)throw Error(i(425))}function Zr(){}var ea=null,ta=null;function na(e,t){return"textarea"===e||"noscript"===e||"string"==typeof t.children||"number"==typeof t.children||"object"==typeof t.dangerouslySetInnerHTML&&null!==t.dangerouslySetInnerHTML&&null!=t.dangerouslySetInnerHTML.__html}var ra="function"==typeof setTimeout?setTimeout:void 0,aa="function"==typeof clearTimeout?clearTimeout:void 0,ia="function"==typeof Promise?Promise:void 0,sa="function"==typeof queueMicrotask?queueMicrotask:void 0!==ia?function(e){return ia.resolve(null).then(e).catch(oa)}:ra;function oa(e){setTimeout((function(){throw e}))}function la(e,t){var n=t,r=0;do{var a=n.nextSibling;if(e.removeChild(n),a&&8===a.nodeType)if("/$"===(n=a.data)){if(0===r)return e.removeChild(a),void Gt(t);r--}else"$"!==n&&"$?"!==n&&"$!"!==n||r++;n=a}while(n);Gt(t)}function ua(e){for(;null!=e;e=e.nextSibling){var t=e.nodeType;if(1===t||3===t)break;if(8===t){if("$"===(t=e.data)||"$!"===t||"$?"===t)break;if("/$"===t)return null}}return e}function ca(e){e=e.previousSibling;for(var t=0;e;){if(8===e.nodeType){var n=e.data;if("$"===n||"$!"===n||"$?"===n){if(0===t)return e;t--}else"/$"===n&&t++}e=e.previousSibling}return null}var ha=Math.random().toString(36).slice(2),pa="__reactFiber$"+ha,fa="__reactProps$"+ha,da="__reactContainer$"+ha,ma="__reactEvents$"+ha,ga="__reactListeners$"+ha,ya="__reactHandles$"+ha;function va(e){var t=e[pa];if(t)return t;for(var n=e.parentNode;n;){if(t=n[da]||n[pa]){if(n=t.alternate,null!==t.child||null!==n&&null!==n.child)for(e=ca(e);null!==e;){if(n=e[pa])return n;e=ca(e)}return t}n=(e=n).parentNode}return null}function ba(e){return!(e=e[pa]||e[da])||5!==e.tag&&6!==e.tag&&13!==e.tag&&3!==e.tag?null:e}function ka(e){if(5===e.tag||6===e.tag)return e.stateNode;throw Error(i(33))}function xa(e){return e[fa]||null}var Sa=[],wa=-1;function Ea(e){return{current:e}}function Pa(e){0>wa||(e.current=Sa[wa],Sa[wa]=null,wa--)}function _a(e,t){wa++,Sa[wa]=e.current,e.current=t}var Ca={},Aa=Ea(Ca),Ta=Ea(!1),Ma=Ca;function Da(e,t){var n=e.type.contextTypes;if(!n)return Ca;var r=e.stateNode;if(r&&r.__reactInternalMemoizedUnmaskedChildContext===t)return r.__reactInternalMemoizedMaskedChildContext;var a,i={};for(a in n)i[a]=t[a];return r&&((e=e.stateNode).__reactInternalMemoizedUnmaskedChildContext=t,e.__reactInternalMemoizedMaskedChildContext=i),i}function Ia(e){return null!=(e=e.childContextTypes)}function Fa(){Pa(Ta),Pa(Aa)}function Oa(e,t,n){if(Aa.current!==Ca)throw Error(i(168));_a(Aa,t),_a(Ta,n)}function Ra(e,t,n){var r=e.stateNode;if(t=t.childContextTypes,"function"!=typeof r.getChildContext)return n;for(var a in r=r.getChildContext())if(!(a in t))throw Error(i(108,H(e)||"Unknown",a));return N({},n,r)}function La(e){return e=(e=e.stateNode)&&e.__reactInternalMemoizedMergedChildContext||Ca,Ma=Aa.current,_a(Aa,e),_a(Ta,Ta.current),!0}function Na(e,t,n){var r=e.stateNode;if(!r)throw Error(i(169));n?(e=Ra(e,t,Ma),r.__reactInternalMemoizedMergedChildContext=e,Pa(Ta),Pa(Aa),_a(Aa,e)):Pa(Ta),_a(Ta,n)}var Va=null,Ba=!1,za=!1;function ja(e){null===Va?Va=[e]:Va.push(e)}function Ga(){if(!za&&null!==Va){za=!0;var e=0,t=bt;try{var n=Va;for(bt=1;e<n.length;e++){var r=n[e];do{r=r(!0)}while(null!==r)}Va=null,Ba=!1}catch(t){throw null!==Va&&(Va=Va.slice(e+1)),$e(Ze,Ga),t}finally{bt=t,za=!1}}return null}var Ha=[],qa=0,Ua=null,Wa=0,$a=[],Ka=0,Ja=null,Ya=1,Qa="";function Xa(e,t){Ha[qa++]=Wa,Ha[qa++]=Ua,Ua=e,Wa=t}function Za(e,t,n){$a[Ka++]=Ya,$a[Ka++]=Qa,$a[Ka++]=Ja,Ja=e;var r=Ya;e=Qa;var a=32-st(r)-1;r&=~(1<<a),n+=1;var i=32-st(t)+a;if(30<i){var s=a-a%5;i=(r&(1<<s)-1).toString(32),r>>=s,a-=s,Ya=1<<32-st(t)+a|n<<a|r,Qa=i+e}else Ya=1<<i|n<<a|r,Qa=e}function ei(e){null!==e.return&&(Xa(e,1),Za(e,1,0))}function ti(e){for(;e===Ua;)Ua=Ha[--qa],Ha[qa]=null,Wa=Ha[--qa],Ha[qa]=null;for(;e===Ja;)Ja=$a[--Ka],$a[Ka]=null,Qa=$a[--Ka],$a[Ka]=null,Ya=$a[--Ka],$a[Ka]=null}var ni=null,ri=null,ai=!1,ii=null;function si(e,t){var n=Iu(5,null,null,0);n.elementType="DELETED",n.stateNode=t,n.return=e,null===(t=e.deletions)?(e.deletions=[n],e.flags|=16):t.push(n)}function oi(e,t){switch(e.tag){case 5:var n=e.type;return null!==(t=1!==t.nodeType||n.toLowerCase()!==t.nodeName.toLowerCase()?null:t)&&(e.stateNode=t,ni=e,ri=ua(t.firstChild),!0);case 6:return null!==(t=""===e.pendingProps||3!==t.nodeType?null:t)&&(e.stateNode=t,ni=e,ri=null,!0);case 13:return null!==(t=8!==t.nodeType?null:t)&&(n=null!==Ja?{id:Ya,overflow:Qa}:null,e.memoizedState={dehydrated:t,treeContext:n,retryLane:1073741824},(n=Iu(18,null,null,0)).stateNode=t,n.return=e,e.child=n,ni=e,ri=null,!0);default:return!1}}function li(e){return 0!=(1&e.mode)&&0==(128&e.flags)}function ui(e){if(ai){var t=ri;if(t){var n=t;if(!oi(e,t)){if(li(e))throw Error(i(418));t=ua(n.nextSibling);var r=ni;t&&oi(e,t)?si(r,n):(e.flags=-4097&e.flags|2,ai=!1,ni=e)}}else{if(li(e))throw Error(i(418));e.flags=-4097&e.flags|2,ai=!1,ni=e}}}function ci(e){for(e=e.return;null!==e&&5!==e.tag&&3!==e.tag&&13!==e.tag;)e=e.return;ni=e}function hi(e){if(e!==ni)return!1;if(!ai)return ci(e),ai=!0,!1;var t;if((t=3!==e.tag)&&!(t=5!==e.tag)&&(t="head"!==(t=e.type)&&"body"!==t&&!na(e.type,e.memoizedProps)),t&&(t=ri)){if(li(e))throw pi(),Error(i(418));for(;t;)si(e,t),t=ua(t.nextSibling)}if(ci(e),13===e.tag){if(!(e=null!==(e=e.memoizedState)?e.dehydrated:null))throw Error(i(317));e:{for(e=e.nextSibling,t=0;e;){if(8===e.nodeType){var n=e.data;if("/$"===n){if(0===t){ri=ua(e.nextSibling);break e}t--}else"$"!==n&&"$!"!==n&&"$?"!==n||t++}e=e.nextSibling}ri=null}}else ri=ni?ua(e.stateNode.nextSibling):null;return!0}function pi(){for(var e=ri;e;)e=ua(e.nextSibling)}function fi(){ri=ni=null,ai=!1}function di(e){null===ii?ii=[e]:ii.push(e)}var mi=k.ReactCurrentBatchConfig;function gi(e,t){if(e&&e.defaultProps){for(var n in t=N({},t),e=e.defaultProps)void 0===t[n]&&(t[n]=e[n]);return t}return t}var yi=Ea(null),vi=null,bi=null,ki=null;function xi(){ki=bi=vi=null}function Si(e){var t=yi.current;Pa(yi),e._currentValue=t}function wi(e,t,n){for(;null!==e;){var r=e.alternate;if((e.childLanes&t)!==t?(e.childLanes|=t,null!==r&&(r.childLanes|=t)):null!==r&&(r.childLanes&t)!==t&&(r.childLanes|=t),e===n)break;e=e.return}}function Ei(e,t){vi=e,ki=bi=null,null!==(e=e.dependencies)&&null!==e.firstContext&&(0!=(e.lanes&t)&&(ko=!0),e.firstContext=null)}function Pi(e){var t=e._currentValue;if(ki!==e)if(e={context:e,memoizedValue:t,next:null},null===bi){if(null===vi)throw Error(i(308));bi=e,vi.dependencies={lanes:0,firstContext:e}}else bi=bi.next=e;return t}var _i=null;function Ci(e){null===_i?_i=[e]:_i.push(e)}function Ai(e,t,n,r){var a=t.interleaved;return null===a?(n.next=n,Ci(t)):(n.next=a.next,a.next=n),t.interleaved=n,Ti(e,r)}function Ti(e,t){e.lanes|=t;var n=e.alternate;for(null!==n&&(n.lanes|=t),n=e,e=e.return;null!==e;)e.childLanes|=t,null!==(n=e.alternate)&&(n.childLanes|=t),n=e,e=e.return;return 3===n.tag?n.stateNode:null}var Mi=!1;function Di(e){e.updateQueue={baseState:e.memoizedState,firstBaseUpdate:null,lastBaseUpdate:null,shared:{pending:null,interleaved:null,lanes:0},effects:null}}function Ii(e,t){e=e.updateQueue,t.updateQueue===e&&(t.updateQueue={baseState:e.baseState,firstBaseUpdate:e.firstBaseUpdate,lastBaseUpdate:e.lastBaseUpdate,shared:e.shared,effects:e.effects})}function Fi(e,t){return{eventTime:e,lane:t,tag:0,payload:null,callback:null,next:null}}function Oi(e,t,n){var r=e.updateQueue;if(null===r)return null;if(r=r.shared,0!=(2&Tl)){var a=r.pending;return null===a?t.next=t:(t.next=a.next,a.next=t),r.pending=t,Ti(e,n)}return null===(a=r.interleaved)?(t.next=t,Ci(r)):(t.next=a.next,a.next=t),r.interleaved=t,Ti(e,n)}function Ri(e,t,n){if(null!==(t=t.updateQueue)&&(t=t.shared,0!=(4194240&n))){var r=t.lanes;n|=r&=e.pendingLanes,t.lanes=n,vt(e,n)}}function Li(e,t){var n=e.updateQueue,r=e.alternate;if(null!==r&&n===(r=r.updateQueue)){var a=null,i=null;if(null!==(n=n.firstBaseUpdate)){do{var s={eventTime:n.eventTime,lane:n.lane,tag:n.tag,payload:n.payload,callback:n.callback,next:null};null===i?a=i=s:i=i.next=s,n=n.next}while(null!==n);null===i?a=i=t:i=i.next=t}else a=i=t;return n={baseState:r.baseState,firstBaseUpdate:a,lastBaseUpdate:i,shared:r.shared,effects:r.effects},void(e.updateQueue=n)}null===(e=n.lastBaseUpdate)?n.firstBaseUpdate=t:e.next=t,n.lastBaseUpdate=t}function Ni(e,t,n,r){var a=e.updateQueue;Mi=!1;var i=a.firstBaseUpdate,s=a.lastBaseUpdate,o=a.shared.pending;if(null!==o){a.shared.pending=null;var l=o,u=l.next;l.next=null,null===s?i=u:s.next=u,s=l;var c=e.alternate;null!==c&&((o=(c=c.updateQueue).lastBaseUpdate)!==s&&(null===o?c.firstBaseUpdate=u:o.next=u,c.lastBaseUpdate=l))}if(null!==i){var h=a.baseState;for(s=0,c=u=l=null,o=i;;){var p=o.lane,f=o.eventTime;if((r&p)===p){null!==c&&(c=c.next={eventTime:f,lane:0,tag:o.tag,payload:o.payload,callback:o.callback,next:null});e:{var d=e,m=o;switch(p=t,f=n,m.tag){case 1:if("function"==typeof(d=m.payload)){h=d.call(f,h,p);break e}h=d;break e;case 3:d.flags=-65537&d.flags|128;case 0:if(null==(p="function"==typeof(d=m.payload)?d.call(f,h,p):d))break e;h=N({},h,p);break e;case 2:Mi=!0}}null!==o.callback&&0!==o.lane&&(e.flags|=64,null===(p=a.effects)?a.effects=[o]:p.push(o))}else f={eventTime:f,lane:p,tag:o.tag,payload:o.payload,callback:o.callback,next:null},null===c?(u=c=f,l=h):c=c.next=f,s|=p;if(null===(o=o.next)){if(null===(o=a.shared.pending))break;o=(p=o).next,p.next=null,a.lastBaseUpdate=p,a.shared.pending=null}}if(null===c&&(l=h),a.baseState=l,a.firstBaseUpdate=u,a.lastBaseUpdate=c,null!==(t=a.shared.interleaved)){a=t;do{s|=a.lane,a=a.next}while(a!==t)}else null===i&&(a.shared.lanes=0);Nl|=s,e.lanes=s,e.memoizedState=h}}function Vi(e,t,n){if(e=t.effects,t.effects=null,null!==e)for(t=0;t<e.length;t++){var r=e[t],a=r.callback;if(null!==a){if(r.callback=null,r=n,"function"!=typeof a)throw Error(i(191,a));a.call(r)}}}var Bi=(new r.Component).refs;function zi(e,t,n,r){n=null==(n=n(r,t=e.memoizedState))?t:N({},t,n),e.memoizedState=n,0===e.lanes&&(e.updateQueue.baseState=n)}var ji={isMounted:function(e){return!!(e=e._reactInternals)&&Ge(e)===e},enqueueSetState:function(e,t,n){e=e._reactInternals;var r=tu(),a=nu(e),i=Fi(r,a);i.payload=t,null!=n&&(i.callback=n),null!==(t=Oi(e,i,a))&&(ru(t,e,a,r),Ri(t,e,a))},enqueueReplaceState:function(e,t,n){e=e._reactInternals;var r=tu(),a=nu(e),i=Fi(r,a);i.tag=1,i.payload=t,null!=n&&(i.callback=n),null!==(t=Oi(e,i,a))&&(ru(t,e,a,r),Ri(t,e,a))},enqueueForceUpdate:function(e,t){e=e._reactInternals;var n=tu(),r=nu(e),a=Fi(n,r);a.tag=2,null!=t&&(a.callback=t),null!==(t=Oi(e,a,r))&&(ru(t,e,r,n),Ri(t,e,r))}};function Gi(e,t,n,r,a,i,s){return"function"==typeof(e=e.stateNode).shouldComponentUpdate?e.shouldComponentUpdate(r,i,s):!t.prototype||!t.prototype.isPureReactComponent||(!lr(n,r)||!lr(a,i))}function Hi(e,t,n){var r=!1,a=Ca,i=t.contextType;return"object"==typeof i&&null!==i?i=Pi(i):(a=Ia(t)?Ma:Aa.current,i=(r=null!=(r=t.contextTypes))?Da(e,a):Ca),t=new t(n,i),e.memoizedState=null!==t.state&&void 0!==t.state?t.state:null,t.updater=ji,e.stateNode=t,t._reactInternals=e,r&&((e=e.stateNode).__reactInternalMemoizedUnmaskedChildContext=a,e.__reactInternalMemoizedMaskedChildContext=i),t}function qi(e,t,n,r){e=t.state,"function"==typeof t.componentWillReceiveProps&&t.componentWillReceiveProps(n,r),"function"==typeof t.UNSAFE_componentWillReceiveProps&&t.UNSAFE_componentWillReceiveProps(n,r),t.state!==e&&ji.enqueueReplaceState(t,t.state,null)}function Ui(e,t,n,r){var a=e.stateNode;a.props=n,a.state=e.memoizedState,a.refs=Bi,Di(e);var i=t.contextType;"object"==typeof i&&null!==i?a.context=Pi(i):(i=Ia(t)?Ma:Aa.current,a.context=Da(e,i)),a.state=e.memoizedState,"function"==typeof(i=t.getDerivedStateFromProps)&&(zi(e,t,i,n),a.state=e.memoizedState),"function"==typeof t.getDerivedStateFromProps||"function"==typeof a.getSnapshotBeforeUpdate||"function"!=typeof a.UNSAFE_componentWillMount&&"function"!=typeof a.componentWillMount||(t=a.state,"function"==typeof a.componentWillMount&&a.componentWillMount(),"function"==typeof a.UNSAFE_componentWillMount&&a.UNSAFE_componentWillMount(),t!==a.state&&ji.enqueueReplaceState(a,a.state,null),Ni(e,n,a,r),a.state=e.memoizedState),"function"==typeof a.componentDidMount&&(e.flags|=4194308)}function Wi(e,t,n){if(null!==(e=n.ref)&&"function"!=typeof e&&"object"!=typeof e){if(n._owner){if(n=n._owner){if(1!==n.tag)throw Error(i(309));var r=n.stateNode}if(!r)throw Error(i(147,e));var a=r,s=""+e;return null!==t&&null!==t.ref&&"function"==typeof t.ref&&t.ref._stringRef===s?t.ref:(t=function(e){var t=a.refs;t===Bi&&(t=a.refs={}),null===e?delete t[s]:t[s]=e},t._stringRef=s,t)}if("string"!=typeof e)throw Error(i(284));if(!n._owner)throw Error(i(290,e))}return e}function $i(e,t){throw e=Object.prototype.toString.call(t),Error(i(31,"[object Object]"===e?"object with keys {"+Object.keys(t).join(", ")+"}":e))}function Ki(e){return(0,e._init)(e._payload)}function Ji(e){function t(t,n){if(e){var r=t.deletions;null===r?(t.deletions=[n],t.flags|=16):r.push(n)}}function n(n,r){if(!e)return null;for(;null!==r;)t(n,r),r=r.sibling;return null}function r(e,t){for(e=new Map;null!==t;)null!==t.key?e.set(t.key,t):e.set(t.index,t),t=t.sibling;return e}function a(e,t){return(e=Ou(e,t)).index=0,e.sibling=null,e}function s(t,n,r){return t.index=r,e?null!==(r=t.alternate)?(r=r.index)<n?(t.flags|=2,n):r:(t.flags|=2,n):(t.flags|=1048576,n)}function o(t){return e&&null===t.alternate&&(t.flags|=2),t}function l(e,t,n,r){return null===t||6!==t.tag?((t=Vu(n,e.mode,r)).return=e,t):((t=a(t,n)).return=e,t)}function u(e,t,n,r){var i=n.type;return i===w?h(e,t,n.props.children,r,n.key):null!==t&&(t.elementType===i||"object"==typeof i&&null!==i&&i.$$typeof===I&&Ki(i)===t.type)?((r=a(t,n.props)).ref=Wi(e,t,n),r.return=e,r):((r=Ru(n.type,n.key,n.props,null,e.mode,r)).ref=Wi(e,t,n),r.return=e,r)}function c(e,t,n,r){return null===t||4!==t.tag||t.stateNode.containerInfo!==n.containerInfo||t.stateNode.implementation!==n.implementation?((t=Bu(n,e.mode,r)).return=e,t):((t=a(t,n.children||[])).return=e,t)}function h(e,t,n,r,i){return null===t||7!==t.tag?((t=Lu(n,e.mode,r,i)).return=e,t):((t=a(t,n)).return=e,t)}function p(e,t,n){if("string"==typeof t&&""!==t||"number"==typeof t)return(t=Vu(""+t,e.mode,n)).return=e,t;if("object"==typeof t&&null!==t){switch(t.$$typeof){case x:return(n=Ru(t.type,t.key,t.props,null,e.mode,n)).ref=Wi(e,null,t),n.return=e,n;case S:return(t=Bu(t,e.mode,n)).return=e,t;case I:return p(e,(0,t._init)(t._payload),n)}if(te(t)||R(t))return(t=Lu(t,e.mode,n,null)).return=e,t;$i(e,t)}return null}function f(e,t,n,r){var a=null!==t?t.key:null;if("string"==typeof n&&""!==n||"number"==typeof n)return null!==a?null:l(e,t,""+n,r);if("object"==typeof n&&null!==n){switch(n.$$typeof){case x:return n.key===a?u(e,t,n,r):null;case S:return n.key===a?c(e,t,n,r):null;case I:return f(e,t,(a=n._init)(n._payload),r)}if(te(n)||R(n))return null!==a?null:h(e,t,n,r,null);$i(e,n)}return null}function d(e,t,n,r,a){if("string"==typeof r&&""!==r||"number"==typeof r)return l(t,e=e.get(n)||null,""+r,a);if("object"==typeof r&&null!==r){switch(r.$$typeof){case x:return u(t,e=e.get(null===r.key?n:r.key)||null,r,a);case S:return c(t,e=e.get(null===r.key?n:r.key)||null,r,a);case I:return d(e,t,n,(0,r._init)(r._payload),a)}if(te(r)||R(r))return h(t,e=e.get(n)||null,r,a,null);$i(t,r)}return null}function m(a,i,o,l){for(var u=null,c=null,h=i,m=i=0,g=null;null!==h&&m<o.length;m++){h.index>m?(g=h,h=null):g=h.sibling;var y=f(a,h,o[m],l);if(null===y){null===h&&(h=g);break}e&&h&&null===y.alternate&&t(a,h),i=s(y,i,m),null===c?u=y:c.sibling=y,c=y,h=g}if(m===o.length)return n(a,h),ai&&Xa(a,m),u;if(null===h){for(;m<o.length;m++)null!==(h=p(a,o[m],l))&&(i=s(h,i,m),null===c?u=h:c.sibling=h,c=h);return ai&&Xa(a,m),u}for(h=r(a,h);m<o.length;m++)null!==(g=d(h,a,m,o[m],l))&&(e&&null!==g.alternate&&h.delete(null===g.key?m:g.key),i=s(g,i,m),null===c?u=g:c.sibling=g,c=g);return e&&h.forEach((function(e){return t(a,e)})),ai&&Xa(a,m),u}function g(a,o,l,u){var c=R(l);if("function"!=typeof c)throw Error(i(150));if(null==(l=c.call(l)))throw Error(i(151));for(var h=c=null,m=o,g=o=0,y=null,v=l.next();null!==m&&!v.done;g++,v=l.next()){m.index>g?(y=m,m=null):y=m.sibling;var b=f(a,m,v.value,u);if(null===b){null===m&&(m=y);break}e&&m&&null===b.alternate&&t(a,m),o=s(b,o,g),null===h?c=b:h.sibling=b,h=b,m=y}if(v.done)return n(a,m),ai&&Xa(a,g),c;if(null===m){for(;!v.done;g++,v=l.next())null!==(v=p(a,v.value,u))&&(o=s(v,o,g),null===h?c=v:h.sibling=v,h=v);return ai&&Xa(a,g),c}for(m=r(a,m);!v.done;g++,v=l.next())null!==(v=d(m,a,g,v.value,u))&&(e&&null!==v.alternate&&m.delete(null===v.key?g:v.key),o=s(v,o,g),null===h?c=v:h.sibling=v,h=v);return e&&m.forEach((function(e){return t(a,e)})),ai&&Xa(a,g),c}return function e(r,i,s,l){if("object"==typeof s&&null!==s&&s.type===w&&null===s.key&&(s=s.props.children),"object"==typeof s&&null!==s){switch(s.$$typeof){case x:e:{for(var u=s.key,c=i;null!==c;){if(c.key===u){if((u=s.type)===w){if(7===c.tag){n(r,c.sibling),(i=a(c,s.props.children)).return=r,r=i;break e}}else if(c.elementType===u||"object"==typeof u&&null!==u&&u.$$typeof===I&&Ki(u)===c.type){n(r,c.sibling),(i=a(c,s.props)).ref=Wi(r,c,s),i.return=r,r=i;break e}n(r,c);break}t(r,c),c=c.sibling}s.type===w?((i=Lu(s.props.children,r.mode,l,s.key)).return=r,r=i):((l=Ru(s.type,s.key,s.props,null,r.mode,l)).ref=Wi(r,i,s),l.return=r,r=l)}return o(r);case S:e:{for(c=s.key;null!==i;){if(i.key===c){if(4===i.tag&&i.stateNode.containerInfo===s.containerInfo&&i.stateNode.implementation===s.implementation){n(r,i.sibling),(i=a(i,s.children||[])).return=r,r=i;break e}n(r,i);break}t(r,i),i=i.sibling}(i=Bu(s,r.mode,l)).return=r,r=i}return o(r);case I:return e(r,i,(c=s._init)(s._payload),l)}if(te(s))return m(r,i,s,l);if(R(s))return g(r,i,s,l);$i(r,s)}return"string"==typeof s&&""!==s||"number"==typeof s?(s=""+s,null!==i&&6===i.tag?(n(r,i.sibling),(i=a(i,s)).return=r,r=i):(n(r,i),(i=Vu(s,r.mode,l)).return=r,r=i),o(r)):n(r,i)}}var Yi=Ji(!0),Qi=Ji(!1),Xi={},Zi=Ea(Xi),es=Ea(Xi),ts=Ea(Xi);function ns(e){if(e===Xi)throw Error(i(174));return e}function rs(e,t){switch(_a(ts,t),_a(es,e),_a(Zi,Xi),e=t.nodeType){case 9:case 11:t=(t=t.documentElement)?t.namespaceURI:le(null,"");break;default:t=le(t=(e=8===e?t.parentNode:t).namespaceURI||null,e=e.tagName)}Pa(Zi),_a(Zi,t)}function as(){Pa(Zi),Pa(es),Pa(ts)}function is(e){ns(ts.current);var t=ns(Zi.current),n=le(t,e.type);t!==n&&(_a(es,e),_a(Zi,n))}function ss(e){es.current===e&&(Pa(Zi),Pa(es))}var os=Ea(0);function ls(e){for(var t=e;null!==t;){if(13===t.tag){var n=t.memoizedState;if(null!==n&&(null===(n=n.dehydrated)||"$?"===n.data||"$!"===n.data))return t}else if(19===t.tag&&void 0!==t.memoizedProps.revealOrder){if(0!=(128&t.flags))return t}else if(null!==t.child){t.child.return=t,t=t.child;continue}if(t===e)break;for(;null===t.sibling;){if(null===t.return||t.return===e)return null;t=t.return}t.sibling.return=t.return,t=t.sibling}return null}var us=[];function cs(){for(var e=0;e<us.length;e++)us[e]._workInProgressVersionPrimary=null;us.length=0}var hs=k.ReactCurrentDispatcher,ps=k.ReactCurrentBatchConfig,fs=0,ds=null,ms=null,gs=null,ys=!1,vs=!1,bs=0,ks=0;function xs(){throw Error(i(321))}function Ss(e,t){if(null===t)return!1;for(var n=0;n<t.length&&n<e.length;n++)if(!or(e[n],t[n]))return!1;return!0}function ws(e,t,n,r,a,s){if(fs=s,ds=t,t.memoizedState=null,t.updateQueue=null,t.lanes=0,hs.current=null===e||null===e.memoizedState?so:oo,e=n(r,a),vs){s=0;do{if(vs=!1,bs=0,25<=s)throw Error(i(301));s+=1,gs=ms=null,t.updateQueue=null,hs.current=lo,e=n(r,a)}while(vs)}if(hs.current=io,t=null!==ms&&null!==ms.next,fs=0,gs=ms=ds=null,ys=!1,t)throw Error(i(300));return e}function Es(){var e=0!==bs;return bs=0,e}function Ps(){var e={memoizedState:null,baseState:null,baseQueue:null,queue:null,next:null};return null===gs?ds.memoizedState=gs=e:gs=gs.next=e,gs}function _s(){if(null===ms){var e=ds.alternate;e=null!==e?e.memoizedState:null}else e=ms.next;var t=null===gs?ds.memoizedState:gs.next;if(null!==t)gs=t,ms=e;else{if(null===e)throw Error(i(310));e={memoizedState:(ms=e).memoizedState,baseState:ms.baseState,baseQueue:ms.baseQueue,queue:ms.queue,next:null},null===gs?ds.memoizedState=gs=e:gs=gs.next=e}return gs}function Cs(e,t){return"function"==typeof t?t(e):t}function As(e){var t=_s(),n=t.queue;if(null===n)throw Error(i(311));n.lastRenderedReducer=e;var r=ms,a=r.baseQueue,s=n.pending;if(null!==s){if(null!==a){var o=a.next;a.next=s.next,s.next=o}r.baseQueue=a=s,n.pending=null}if(null!==a){s=a.next,r=r.baseState;var l=o=null,u=null,c=s;do{var h=c.lane;if((fs&h)===h)null!==u&&(u=u.next={lane:0,action:c.action,hasEagerState:c.hasEagerState,eagerState:c.eagerState,next:null}),r=c.hasEagerState?c.eagerState:e(r,c.action);else{var p={lane:h,action:c.action,hasEagerState:c.hasEagerState,eagerState:c.eagerState,next:null};null===u?(l=u=p,o=r):u=u.next=p,ds.lanes|=h,Nl|=h}c=c.next}while(null!==c&&c!==s);null===u?o=r:u.next=l,or(r,t.memoizedState)||(ko=!0),t.memoizedState=r,t.baseState=o,t.baseQueue=u,n.lastRenderedState=r}if(null!==(e=n.interleaved)){a=e;do{s=a.lane,ds.lanes|=s,Nl|=s,a=a.next}while(a!==e)}else null===a&&(n.lanes=0);return[t.memoizedState,n.dispatch]}function Ts(e){var t=_s(),n=t.queue;if(null===n)throw Error(i(311));n.lastRenderedReducer=e;var r=n.dispatch,a=n.pending,s=t.memoizedState;if(null!==a){n.pending=null;var o=a=a.next;do{s=e(s,o.action),o=o.next}while(o!==a);or(s,t.memoizedState)||(ko=!0),t.memoizedState=s,null===t.baseQueue&&(t.baseState=s),n.lastRenderedState=s}return[s,r]}function Ms(){}function Ds(e,t){var n=ds,r=_s(),a=t(),s=!or(r.memoizedState,a);if(s&&(r.memoizedState=a,ko=!0),r=r.queue,Hs(Os.bind(null,n,r,e),[e]),r.getSnapshot!==t||s||null!==gs&&1&gs.memoizedState.tag){if(n.flags|=2048,Vs(9,Fs.bind(null,n,r,a,t),void 0,null),null===Ml)throw Error(i(349));0!=(30&fs)||Is(n,t,a)}return a}function Is(e,t,n){e.flags|=16384,e={getSnapshot:t,value:n},null===(t=ds.updateQueue)?(t={lastEffect:null,stores:null},ds.updateQueue=t,t.stores=[e]):null===(n=t.stores)?t.stores=[e]:n.push(e)}function Fs(e,t,n,r){t.value=n,t.getSnapshot=r,Rs(t)&&Ls(e)}function Os(e,t,n){return n((function(){Rs(t)&&Ls(e)}))}function Rs(e){var t=e.getSnapshot;e=e.value;try{var n=t();return!or(e,n)}catch(e){return!0}}function Ls(e){var t=Ti(e,1);null!==t&&ru(t,e,1,-1)}function Ns(e){var t=Ps();return"function"==typeof e&&(e=e()),t.memoizedState=t.baseState=e,e={pending:null,interleaved:null,lanes:0,dispatch:null,lastRenderedReducer:Cs,lastRenderedState:e},t.queue=e,e=e.dispatch=to.bind(null,ds,e),[t.memoizedState,e]}function Vs(e,t,n,r){return e={tag:e,create:t,destroy:n,deps:r,next:null},null===(t=ds.updateQueue)?(t={lastEffect:null,stores:null},ds.updateQueue=t,t.lastEffect=e.next=e):null===(n=t.lastEffect)?t.lastEffect=e.next=e:(r=n.next,n.next=e,e.next=r,t.lastEffect=e),e}function Bs(){return _s().memoizedState}function zs(e,t,n,r){var a=Ps();ds.flags|=e,a.memoizedState=Vs(1|t,n,void 0,void 0===r?null:r)}function js(e,t,n,r){var a=_s();r=void 0===r?null:r;var i=void 0;if(null!==ms){var s=ms.memoizedState;if(i=s.destroy,null!==r&&Ss(r,s.deps))return void(a.memoizedState=Vs(t,n,i,r))}ds.flags|=e,a.memoizedState=Vs(1|t,n,i,r)}function Gs(e,t){return zs(8390656,8,e,t)}function Hs(e,t){return js(2048,8,e,t)}function qs(e,t){return js(4,2,e,t)}function Us(e,t){return js(4,4,e,t)}function Ws(e,t){return"function"==typeof t?(e=e(),t(e),function(){t(null)}):null!=t?(e=e(),t.current=e,function(){t.current=null}):void 0}function $s(e,t,n){return n=null!=n?n.concat([e]):null,js(4,4,Ws.bind(null,t,e),n)}function Ks(){}function Js(e,t){var n=_s();t=void 0===t?null:t;var r=n.memoizedState;return null!==r&&null!==t&&Ss(t,r[1])?r[0]:(n.memoizedState=[e,t],e)}function Ys(e,t){var n=_s();t=void 0===t?null:t;var r=n.memoizedState;return null!==r&&null!==t&&Ss(t,r[1])?r[0]:(e=e(),n.memoizedState=[e,t],e)}function Qs(e,t,n){return 0==(21&fs)?(e.baseState&&(e.baseState=!1,ko=!0),e.memoizedState=n):(or(n,t)||(n=mt(),ds.lanes|=n,Nl|=n,e.baseState=!0),t)}function Xs(e,t){var n=bt;bt=0!==n&&4>n?n:4,e(!0);var r=ps.transition;ps.transition={};try{e(!1),t()}finally{bt=n,ps.transition=r}}function Zs(){return _s().memoizedState}function eo(e,t,n){var r=nu(e);if(n={lane:r,action:n,hasEagerState:!1,eagerState:null,next:null},no(e))ro(t,n);else if(null!==(n=Ai(e,t,n,r))){ru(n,e,r,tu()),ao(n,t,r)}}function to(e,t,n){var r=nu(e),a={lane:r,action:n,hasEagerState:!1,eagerState:null,next:null};if(no(e))ro(t,a);else{var i=e.alternate;if(0===e.lanes&&(null===i||0===i.lanes)&&null!==(i=t.lastRenderedReducer))try{var s=t.lastRenderedState,o=i(s,n);if(a.hasEagerState=!0,a.eagerState=o,or(o,s)){var l=t.interleaved;return null===l?(a.next=a,Ci(t)):(a.next=l.next,l.next=a),void(t.interleaved=a)}}catch(e){}null!==(n=Ai(e,t,a,r))&&(ru(n,e,r,a=tu()),ao(n,t,r))}}function no(e){var t=e.alternate;return e===ds||null!==t&&t===ds}function ro(e,t){vs=ys=!0;var n=e.pending;null===n?t.next=t:(t.next=n.next,n.next=t),e.pending=t}function ao(e,t,n){if(0!=(4194240&n)){var r=t.lanes;n|=r&=e.pendingLanes,t.lanes=n,vt(e,n)}}var io={readContext:Pi,useCallback:xs,useContext:xs,useEffect:xs,useImperativeHandle:xs,useInsertionEffect:xs,useLayoutEffect:xs,useMemo:xs,useReducer:xs,useRef:xs,useState:xs,useDebugValue:xs,useDeferredValue:xs,useTransition:xs,useMutableSource:xs,useSyncExternalStore:xs,useId:xs,unstable_isNewReconciler:!1},so={readContext:Pi,useCallback:function(e,t){return Ps().memoizedState=[e,void 0===t?null:t],e},useContext:Pi,useEffect:Gs,useImperativeHandle:function(e,t,n){return n=null!=n?n.concat([e]):null,zs(4194308,4,Ws.bind(null,t,e),n)},useLayoutEffect:function(e,t){return zs(4194308,4,e,t)},useInsertionEffect:function(e,t){return zs(4,2,e,t)},useMemo:function(e,t){var n=Ps();return t=void 0===t?null:t,e=e(),n.memoizedState=[e,t],e},useReducer:function(e,t,n){var r=Ps();return t=void 0!==n?n(t):t,r.memoizedState=r.baseState=t,e={pending:null,interleaved:null,lanes:0,dispatch:null,lastRenderedReducer:e,lastRenderedState:t},r.queue=e,e=e.dispatch=eo.bind(null,ds,e),[r.memoizedState,e]},useRef:function(e){return e={current:e},Ps().memoizedState=e},useState:Ns,useDebugValue:Ks,useDeferredValue:function(e){return Ps().memoizedState=e},useTransition:function(){var e=Ns(!1),t=e[0];return e=Xs.bind(null,e[1]),Ps().memoizedState=e,[t,e]},useMutableSource:function(){},useSyncExternalStore:function(e,t,n){var r=ds,a=Ps();if(ai){if(void 0===n)throw Error(i(407));n=n()}else{if(n=t(),null===Ml)throw Error(i(349));0!=(30&fs)||Is(r,t,n)}a.memoizedState=n;var s={value:n,getSnapshot:t};return a.queue=s,Gs(Os.bind(null,r,s,e),[e]),r.flags|=2048,Vs(9,Fs.bind(null,r,s,n,t),void 0,null),n},useId:function(){var e=Ps(),t=Ml.identifierPrefix;if(ai){var n=Qa;t=":"+t+"R"+(n=(Ya&~(1<<32-st(Ya)-1)).toString(32)+n),0<(n=bs++)&&(t+="H"+n.toString(32)),t+=":"}else t=":"+t+"r"+(n=ks++).toString(32)+":";return e.memoizedState=t},unstable_isNewReconciler:!1},oo={readContext:Pi,useCallback:Js,useContext:Pi,useEffect:Hs,useImperativeHandle:$s,useInsertionEffect:qs,useLayoutEffect:Us,useMemo:Ys,useReducer:As,useRef:Bs,useState:function(){return As(Cs)},useDebugValue:Ks,useDeferredValue:function(e){return Qs(_s(),ms.memoizedState,e)},useTransition:function(){return[As(Cs)[0],_s().memoizedState]},useMutableSource:Ms,useSyncExternalStore:Ds,useId:Zs,unstable_isNewReconciler:!1},lo={readContext:Pi,useCallback:Js,useContext:Pi,useEffect:Hs,useImperativeHandle:$s,useInsertionEffect:qs,useLayoutEffect:Us,useMemo:Ys,useReducer:Ts,useRef:Bs,useState:function(){return Ts(Cs)},useDebugValue:Ks,useDeferredValue:function(e){var t=_s();return null===ms?t.memoizedState=e:Qs(t,ms.memoizedState,e)},useTransition:function(){return[Ts(Cs)[0],_s().memoizedState]},useMutableSource:Ms,useSyncExternalStore:Ds,useId:Zs,unstable_isNewReconciler:!1};function uo(e,t){try{var n="",r=t;do{n+=j(r),r=r.return}while(r);var a=n}catch(e){a="\nError generating stack: "+e.message+"\n"+e.stack}return{value:e,source:t,stack:a,digest:null}}function co(e,t,n){return{value:e,source:null,stack:null!=n?n:null,digest:null!=t?t:null}}function ho(e,t){try{console.error(t.value)}catch(e){setTimeout((function(){throw e}))}}var po="function"==typeof WeakMap?WeakMap:Map;function fo(e,t,n){(n=Fi(-1,n)).tag=3,n.payload={element:null};var r=t.value;return n.callback=function(){Ul||(Ul=!0,Wl=r),ho(0,t)},n}function mo(e,t,n){(n=Fi(-1,n)).tag=3;var r=e.type.getDerivedStateFromError;if("function"==typeof r){var a=t.value;n.payload=function(){return r(a)},n.callback=function(){ho(0,t)}}var i=e.stateNode;return null!==i&&"function"==typeof i.componentDidCatch&&(n.callback=function(){ho(0,t),"function"!=typeof r&&(null===$l?$l=new Set([this]):$l.add(this));var e=t.stack;this.componentDidCatch(t.value,{componentStack:null!==e?e:""})}),n}function go(e,t,n){var r=e.pingCache;if(null===r){r=e.pingCache=new po;var a=new Set;r.set(t,a)}else void 0===(a=r.get(t))&&(a=new Set,r.set(t,a));a.has(n)||(a.add(n),e=_u.bind(null,e,t,n),t.then(e,e))}function yo(e){do{var t;if((t=13===e.tag)&&(t=null===(t=e.memoizedState)||null!==t.dehydrated),t)return e;e=e.return}while(null!==e);return null}function vo(e,t,n,r,a){return 0==(1&e.mode)?(e===t?e.flags|=65536:(e.flags|=128,n.flags|=131072,n.flags&=-52805,1===n.tag&&(null===n.alternate?n.tag=17:((t=Fi(-1,1)).tag=2,Oi(n,t,1))),n.lanes|=1),e):(e.flags|=65536,e.lanes=a,e)}var bo=k.ReactCurrentOwner,ko=!1;function xo(e,t,n,r){t.child=null===e?Qi(t,null,n,r):Yi(t,e.child,n,r)}function So(e,t,n,r,a){n=n.render;var i=t.ref;return Ei(t,a),r=ws(e,t,n,r,i,a),n=Es(),null===e||ko?(ai&&n&&ei(t),t.flags|=1,xo(e,t,r,a),t.child):(t.updateQueue=e.updateQueue,t.flags&=-2053,e.lanes&=~a,Uo(e,t,a))}function wo(e,t,n,r,a){if(null===e){var i=n.type;return"function"!=typeof i||Fu(i)||void 0!==i.defaultProps||null!==n.compare||void 0!==n.defaultProps?((e=Ru(n.type,null,r,t,t.mode,a)).ref=t.ref,e.return=t,t.child=e):(t.tag=15,t.type=i,Eo(e,t,i,r,a))}if(i=e.child,0==(e.lanes&a)){var s=i.memoizedProps;if((n=null!==(n=n.compare)?n:lr)(s,r)&&e.ref===t.ref)return Uo(e,t,a)}return t.flags|=1,(e=Ou(i,r)).ref=t.ref,e.return=t,t.child=e}function Eo(e,t,n,r,a){if(null!==e){var i=e.memoizedProps;if(lr(i,r)&&e.ref===t.ref){if(ko=!1,t.pendingProps=r=i,0==(e.lanes&a))return t.lanes=e.lanes,Uo(e,t,a);0!=(131072&e.flags)&&(ko=!0)}}return Co(e,t,n,r,a)}function Po(e,t,n){var r=t.pendingProps,a=r.children,i=null!==e?e.memoizedState:null;if("hidden"===r.mode)if(0==(1&t.mode))t.memoizedState={baseLanes:0,cachePool:null,transitions:null},_a(Ol,Fl),Fl|=n;else{if(0==(1073741824&n))return e=null!==i?i.baseLanes|n:n,t.lanes=t.childLanes=1073741824,t.memoizedState={baseLanes:e,cachePool:null,transitions:null},t.updateQueue=null,_a(Ol,Fl),Fl|=e,null;t.memoizedState={baseLanes:0,cachePool:null,transitions:null},r=null!==i?i.baseLanes:n,_a(Ol,Fl),Fl|=r}else null!==i?(r=i.baseLanes|n,t.memoizedState=null):r=n,_a(Ol,Fl),Fl|=r;return xo(e,t,a,n),t.child}function _o(e,t){var n=t.ref;(null===e&&null!==n||null!==e&&e.ref!==n)&&(t.flags|=512,t.flags|=2097152)}function Co(e,t,n,r,a){var i=Ia(n)?Ma:Aa.current;return i=Da(t,i),Ei(t,a),n=ws(e,t,n,r,i,a),r=Es(),null===e||ko?(ai&&r&&ei(t),t.flags|=1,xo(e,t,n,a),t.child):(t.updateQueue=e.updateQueue,t.flags&=-2053,e.lanes&=~a,Uo(e,t,a))}function Ao(e,t,n,r,a){if(Ia(n)){var i=!0;La(t)}else i=!1;if(Ei(t,a),null===t.stateNode)qo(e,t),Hi(t,n,r),Ui(t,n,r,a),r=!0;else if(null===e){var s=t.stateNode,o=t.memoizedProps;s.props=o;var l=s.context,u=n.contextType;"object"==typeof u&&null!==u?u=Pi(u):u=Da(t,u=Ia(n)?Ma:Aa.current);var c=n.getDerivedStateFromProps,h="function"==typeof c||"function"==typeof s.getSnapshotBeforeUpdate;h||"function"!=typeof s.UNSAFE_componentWillReceiveProps&&"function"!=typeof s.componentWillReceiveProps||(o!==r||l!==u)&&qi(t,s,r,u),Mi=!1;var p=t.memoizedState;s.state=p,Ni(t,r,s,a),l=t.memoizedState,o!==r||p!==l||Ta.current||Mi?("function"==typeof c&&(zi(t,n,c,r),l=t.memoizedState),(o=Mi||Gi(t,n,o,r,p,l,u))?(h||"function"!=typeof s.UNSAFE_componentWillMount&&"function"!=typeof s.componentWillMount||("function"==typeof s.componentWillMount&&s.componentWillMount(),"function"==typeof s.UNSAFE_componentWillMount&&s.UNSAFE_componentWillMount()),"function"==typeof s.componentDidMount&&(t.flags|=4194308)):("function"==typeof s.componentDidMount&&(t.flags|=4194308),t.memoizedProps=r,t.memoizedState=l),s.props=r,s.state=l,s.context=u,r=o):("function"==typeof s.componentDidMount&&(t.flags|=4194308),r=!1)}else{s=t.stateNode,Ii(e,t),o=t.memoizedProps,u=t.type===t.elementType?o:gi(t.type,o),s.props=u,h=t.pendingProps,p=s.context,"object"==typeof(l=n.contextType)&&null!==l?l=Pi(l):l=Da(t,l=Ia(n)?Ma:Aa.current);var f=n.getDerivedStateFromProps;(c="function"==typeof f||"function"==typeof s.getSnapshotBeforeUpdate)||"function"!=typeof s.UNSAFE_componentWillReceiveProps&&"function"!=typeof s.componentWillReceiveProps||(o!==h||p!==l)&&qi(t,s,r,l),Mi=!1,p=t.memoizedState,s.state=p,Ni(t,r,s,a);var d=t.memoizedState;o!==h||p!==d||Ta.current||Mi?("function"==typeof f&&(zi(t,n,f,r),d=t.memoizedState),(u=Mi||Gi(t,n,u,r,p,d,l)||!1)?(c||"function"!=typeof s.UNSAFE_componentWillUpdate&&"function"!=typeof s.componentWillUpdate||("function"==typeof s.componentWillUpdate&&s.componentWillUpdate(r,d,l),"function"==typeof s.UNSAFE_componentWillUpdate&&s.UNSAFE_componentWillUpdate(r,d,l)),"function"==typeof s.componentDidUpdate&&(t.flags|=4),"function"==typeof s.getSnapshotBeforeUpdate&&(t.flags|=1024)):("function"!=typeof s.componentDidUpdate||o===e.memoizedProps&&p===e.memoizedState||(t.flags|=4),"function"!=typeof s.getSnapshotBeforeUpdate||o===e.memoizedProps&&p===e.memoizedState||(t.flags|=1024),t.memoizedProps=r,t.memoizedState=d),s.props=r,s.state=d,s.context=l,r=u):("function"!=typeof s.componentDidUpdate||o===e.memoizedProps&&p===e.memoizedState||(t.flags|=4),"function"!=typeof s.getSnapshotBeforeUpdate||o===e.memoizedProps&&p===e.memoizedState||(t.flags|=1024),r=!1)}return To(e,t,n,r,i,a)}function To(e,t,n,r,a,i){_o(e,t);var s=0!=(128&t.flags);if(!r&&!s)return a&&Na(t,n,!1),Uo(e,t,i);r=t.stateNode,bo.current=t;var o=s&&"function"!=typeof n.getDerivedStateFromError?null:r.render();return t.flags|=1,null!==e&&s?(t.child=Yi(t,e.child,null,i),t.child=Yi(t,null,o,i)):xo(e,t,o,i),t.memoizedState=r.state,a&&Na(t,n,!0),t.child}function Mo(e){var t=e.stateNode;t.pendingContext?Oa(0,t.pendingContext,t.pendingContext!==t.context):t.context&&Oa(0,t.context,!1),rs(e,t.containerInfo)}function Do(e,t,n,r,a){return fi(),di(a),t.flags|=256,xo(e,t,n,r),t.child}var Io,Fo,Oo,Ro,Lo={dehydrated:null,treeContext:null,retryLane:0};function No(e){return{baseLanes:e,cachePool:null,transitions:null}}function Vo(e,t,n){var r,a=t.pendingProps,s=os.current,o=!1,l=0!=(128&t.flags);if((r=l)||(r=(null===e||null!==e.memoizedState)&&0!=(2&s)),r?(o=!0,t.flags&=-129):null!==e&&null===e.memoizedState||(s|=1),_a(os,1&s),null===e)return ui(t),null!==(e=t.memoizedState)&&null!==(e=e.dehydrated)?(0==(1&t.mode)?t.lanes=1:"$!"===e.data?t.lanes=8:t.lanes=1073741824,null):(l=a.children,e=a.fallback,o?(a=t.mode,o=t.child,l={mode:"hidden",children:l},0==(1&a)&&null!==o?(o.childLanes=0,o.pendingProps=l):o=Nu(l,a,0,null),e=Lu(e,a,n,null),o.return=t,e.return=t,o.sibling=e,t.child=o,t.child.memoizedState=No(n),t.memoizedState=Lo,e):Bo(t,l));if(null!==(s=e.memoizedState)&&null!==(r=s.dehydrated))return function(e,t,n,r,a,s,o){if(n)return 256&t.flags?(t.flags&=-257,zo(e,t,o,r=co(Error(i(422))))):null!==t.memoizedState?(t.child=e.child,t.flags|=128,null):(s=r.fallback,a=t.mode,r=Nu({mode:"visible",children:r.children},a,0,null),(s=Lu(s,a,o,null)).flags|=2,r.return=t,s.return=t,r.sibling=s,t.child=r,0!=(1&t.mode)&&Yi(t,e.child,null,o),t.child.memoizedState=No(o),t.memoizedState=Lo,s);if(0==(1&t.mode))return zo(e,t,o,null);if("$!"===a.data){if(r=a.nextSibling&&a.nextSibling.dataset)var l=r.dgst;return r=l,zo(e,t,o,r=co(s=Error(i(419)),r,void 0))}if(l=0!=(o&e.childLanes),ko||l){if(null!==(r=Ml)){switch(o&-o){case 4:a=2;break;case 16:a=8;break;case 64:case 128:case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:case 262144:case 524288:case 1048576:case 2097152:case 4194304:case 8388608:case 16777216:case 33554432:case 67108864:a=32;break;case 536870912:a=268435456;break;default:a=0}0!==(a=0!=(a&(r.suspendedLanes|o))?0:a)&&a!==s.retryLane&&(s.retryLane=a,Ti(e,a),ru(r,e,a,-1))}return gu(),zo(e,t,o,r=co(Error(i(421))))}return"$?"===a.data?(t.flags|=128,t.child=e.child,t=Au.bind(null,e),a._reactRetry=t,null):(e=s.treeContext,ri=ua(a.nextSibling),ni=t,ai=!0,ii=null,null!==e&&($a[Ka++]=Ya,$a[Ka++]=Qa,$a[Ka++]=Ja,Ya=e.id,Qa=e.overflow,Ja=t),t=Bo(t,r.children),t.flags|=4096,t)}(e,t,l,a,r,s,n);if(o){o=a.fallback,l=t.mode,r=(s=e.child).sibling;var u={mode:"hidden",children:a.children};return 0==(1&l)&&t.child!==s?((a=t.child).childLanes=0,a.pendingProps=u,t.deletions=null):(a=Ou(s,u)).subtreeFlags=14680064&s.subtreeFlags,null!==r?o=Ou(r,o):(o=Lu(o,l,n,null)).flags|=2,o.return=t,a.return=t,a.sibling=o,t.child=a,a=o,o=t.child,l=null===(l=e.child.memoizedState)?No(n):{baseLanes:l.baseLanes|n,cachePool:null,transitions:l.transitions},o.memoizedState=l,o.childLanes=e.childLanes&~n,t.memoizedState=Lo,a}return e=(o=e.child).sibling,a=Ou(o,{mode:"visible",children:a.children}),0==(1&t.mode)&&(a.lanes=n),a.return=t,a.sibling=null,null!==e&&(null===(n=t.deletions)?(t.deletions=[e],t.flags|=16):n.push(e)),t.child=a,t.memoizedState=null,a}function Bo(e,t){return(t=Nu({mode:"visible",children:t},e.mode,0,null)).return=e,e.child=t}function zo(e,t,n,r){return null!==r&&di(r),Yi(t,e.child,null,n),(e=Bo(t,t.pendingProps.children)).flags|=2,t.memoizedState=null,e}function jo(e,t,n){e.lanes|=t;var r=e.alternate;null!==r&&(r.lanes|=t),wi(e.return,t,n)}function Go(e,t,n,r,a){var i=e.memoizedState;null===i?e.memoizedState={isBackwards:t,rendering:null,renderingStartTime:0,last:r,tail:n,tailMode:a}:(i.isBackwards=t,i.rendering=null,i.renderingStartTime=0,i.last=r,i.tail=n,i.tailMode=a)}function Ho(e,t,n){var r=t.pendingProps,a=r.revealOrder,i=r.tail;if(xo(e,t,r.children,n),0!=(2&(r=os.current)))r=1&r|2,t.flags|=128;else{if(null!==e&&0!=(128&e.flags))e:for(e=t.child;null!==e;){if(13===e.tag)null!==e.memoizedState&&jo(e,n,t);else if(19===e.tag)jo(e,n,t);else if(null!==e.child){e.child.return=e,e=e.child;continue}if(e===t)break e;for(;null===e.sibling;){if(null===e.return||e.return===t)break e;e=e.return}e.sibling.return=e.return,e=e.sibling}r&=1}if(_a(os,r),0==(1&t.mode))t.memoizedState=null;else switch(a){case"forwards":for(n=t.child,a=null;null!==n;)null!==(e=n.alternate)&&null===ls(e)&&(a=n),n=n.sibling;null===(n=a)?(a=t.child,t.child=null):(a=n.sibling,n.sibling=null),Go(t,!1,a,n,i);break;case"backwards":for(n=null,a=t.child,t.child=null;null!==a;){if(null!==(e=a.alternate)&&null===ls(e)){t.child=a;break}e=a.sibling,a.sibling=n,n=a,a=e}Go(t,!0,n,null,i);break;case"together":Go(t,!1,null,null,void 0);break;default:t.memoizedState=null}return t.child}function qo(e,t){0==(1&t.mode)&&null!==e&&(e.alternate=null,t.alternate=null,t.flags|=2)}function Uo(e,t,n){if(null!==e&&(t.dependencies=e.dependencies),Nl|=t.lanes,0==(n&t.childLanes))return null;if(null!==e&&t.child!==e.child)throw Error(i(153));if(null!==t.child){for(n=Ou(e=t.child,e.pendingProps),t.child=n,n.return=t;null!==e.sibling;)e=e.sibling,(n=n.sibling=Ou(e,e.pendingProps)).return=t;n.sibling=null}return t.child}function Wo(e,t){if(!ai)switch(e.tailMode){case"hidden":t=e.tail;for(var n=null;null!==t;)null!==t.alternate&&(n=t),t=t.sibling;null===n?e.tail=null:n.sibling=null;break;case"collapsed":n=e.tail;for(var r=null;null!==n;)null!==n.alternate&&(r=n),n=n.sibling;null===r?t||null===e.tail?e.tail=null:e.tail.sibling=null:r.sibling=null}}function $o(e){var t=null!==e.alternate&&e.alternate.child===e.child,n=0,r=0;if(t)for(var a=e.child;null!==a;)n|=a.lanes|a.childLanes,r|=14680064&a.subtreeFlags,r|=14680064&a.flags,a.return=e,a=a.sibling;else for(a=e.child;null!==a;)n|=a.lanes|a.childLanes,r|=a.subtreeFlags,r|=a.flags,a.return=e,a=a.sibling;return e.subtreeFlags|=r,e.childLanes=n,t}function Ko(e,t,n){var r=t.pendingProps;switch(ti(t),t.tag){case 2:case 16:case 15:case 0:case 11:case 7:case 8:case 12:case 9:case 14:return $o(t),null;case 1:case 17:return Ia(t.type)&&Fa(),$o(t),null;case 3:return r=t.stateNode,as(),Pa(Ta),Pa(Aa),cs(),r.pendingContext&&(r.context=r.pendingContext,r.pendingContext=null),null!==e&&null!==e.child||(hi(t)?t.flags|=4:null===e||e.memoizedState.isDehydrated&&0==(256&t.flags)||(t.flags|=1024,null!==ii&&(ou(ii),ii=null))),Fo(e,t),$o(t),null;case 5:ss(t);var a=ns(ts.current);if(n=t.type,null!==e&&null!=t.stateNode)Oo(e,t,n,r,a),e.ref!==t.ref&&(t.flags|=512,t.flags|=2097152);else{if(!r){if(null===t.stateNode)throw Error(i(166));return $o(t),null}if(e=ns(Zi.current),hi(t)){r=t.stateNode,n=t.type;var s=t.memoizedProps;switch(r[pa]=t,r[fa]=s,e=0!=(1&t.mode),n){case"dialog":Br("cancel",r),Br("close",r);break;case"iframe":case"object":case"embed":Br("load",r);break;case"video":case"audio":for(a=0;a<Rr.length;a++)Br(Rr[a],r);break;case"source":Br("error",r);break;case"img":case"image":case"link":Br("error",r),Br("load",r);break;case"details":Br("toggle",r);break;case"input":Y(r,s),Br("invalid",r);break;case"select":r._wrapperState={wasMultiple:!!s.multiple},Br("invalid",r);break;case"textarea":ae(r,s),Br("invalid",r)}for(var l in ve(n,s),a=null,s)if(s.hasOwnProperty(l)){var u=s[l];"children"===l?"string"==typeof u?r.textContent!==u&&(!0!==s.suppressHydrationWarning&&Xr(r.textContent,u,e),a=["children",u]):"number"==typeof u&&r.textContent!==""+u&&(!0!==s.suppressHydrationWarning&&Xr(r.textContent,u,e),a=["children",""+u]):o.hasOwnProperty(l)&&null!=u&&"onScroll"===l&&Br("scroll",r)}switch(n){case"input":W(r),Z(r,s,!0);break;case"textarea":W(r),se(r);break;case"select":case"option":break;default:"function"==typeof s.onClick&&(r.onclick=Zr)}r=a,t.updateQueue=r,null!==r&&(t.flags|=4)}else{l=9===a.nodeType?a:a.ownerDocument,"http://www.w3.org/1999/xhtml"===e&&(e=oe(n)),"http://www.w3.org/1999/xhtml"===e?"script"===n?((e=l.createElement("div")).innerHTML="<script><\/script>",e=e.removeChild(e.firstChild)):"string"==typeof r.is?e=l.createElement(n,{is:r.is}):(e=l.createElement(n),"select"===n&&(l=e,r.multiple?l.multiple=!0:r.size&&(l.size=r.size))):e=l.createElementNS(e,n),e[pa]=t,e[fa]=r,Io(e,t,!1,!1),t.stateNode=e;e:{switch(l=be(n,r),n){case"dialog":Br("cancel",e),Br("close",e),a=r;break;case"iframe":case"object":case"embed":Br("load",e),a=r;break;case"video":case"audio":for(a=0;a<Rr.length;a++)Br(Rr[a],e);a=r;break;case"source":Br("error",e),a=r;break;case"img":case"image":case"link":Br("error",e),Br("load",e),a=r;break;case"details":Br("toggle",e),a=r;break;case"input":Y(e,r),a=J(e,r),Br("invalid",e);break;case"option":default:a=r;break;case"select":e._wrapperState={wasMultiple:!!r.multiple},a=N({},r,{value:void 0}),Br("invalid",e);break;case"textarea":ae(e,r),a=re(e,r),Br("invalid",e)}for(s in ve(n,a),u=a)if(u.hasOwnProperty(s)){var c=u[s];"style"===s?ge(e,c):"dangerouslySetInnerHTML"===s?null!=(c=c?c.__html:void 0)&&he(e,c):"children"===s?"string"==typeof c?("textarea"!==n||""!==c)&&pe(e,c):"number"==typeof c&&pe(e,""+c):"suppressContentEditableWarning"!==s&&"suppressHydrationWarning"!==s&&"autoFocus"!==s&&(o.hasOwnProperty(s)?null!=c&&"onScroll"===s&&Br("scroll",e):null!=c&&b(e,s,c,l))}switch(n){case"input":W(e),Z(e,r,!1);break;case"textarea":W(e),se(e);break;case"option":null!=r.value&&e.setAttribute("value",""+q(r.value));break;case"select":e.multiple=!!r.multiple,null!=(s=r.value)?ne(e,!!r.multiple,s,!1):null!=r.defaultValue&&ne(e,!!r.multiple,r.defaultValue,!0);break;default:"function"==typeof a.onClick&&(e.onclick=Zr)}switch(n){case"button":case"input":case"select":case"textarea":r=!!r.autoFocus;break e;case"img":r=!0;break e;default:r=!1}}r&&(t.flags|=4)}null!==t.ref&&(t.flags|=512,t.flags|=2097152)}return $o(t),null;case 6:if(e&&null!=t.stateNode)Ro(e,t,e.memoizedProps,r);else{if("string"!=typeof r&&null===t.stateNode)throw Error(i(166));if(n=ns(ts.current),ns(Zi.current),hi(t)){if(r=t.stateNode,n=t.memoizedProps,r[pa]=t,(s=r.nodeValue!==n)&&null!==(e=ni))switch(e.tag){case 3:Xr(r.nodeValue,n,0!=(1&e.mode));break;case 5:!0!==e.memoizedProps.suppressHydrationWarning&&Xr(r.nodeValue,n,0!=(1&e.mode))}s&&(t.flags|=4)}else(r=(9===n.nodeType?n:n.ownerDocument).createTextNode(r))[pa]=t,t.stateNode=r}return $o(t),null;case 13:if(Pa(os),r=t.memoizedState,null===e||null!==e.memoizedState&&null!==e.memoizedState.dehydrated){if(ai&&null!==ri&&0!=(1&t.mode)&&0==(128&t.flags))pi(),fi(),t.flags|=98560,s=!1;else if(s=hi(t),null!==r&&null!==r.dehydrated){if(null===e){if(!s)throw Error(i(318));if(!(s=null!==(s=t.memoizedState)?s.dehydrated:null))throw Error(i(317));s[pa]=t}else fi(),0==(128&t.flags)&&(t.memoizedState=null),t.flags|=4;$o(t),s=!1}else null!==ii&&(ou(ii),ii=null),s=!0;if(!s)return 65536&t.flags?t:null}return 0!=(128&t.flags)?(t.lanes=n,t):((r=null!==r)!==(null!==e&&null!==e.memoizedState)&&r&&(t.child.flags|=8192,0!=(1&t.mode)&&(null===e||0!=(1&os.current)?0===Rl&&(Rl=3):gu())),null!==t.updateQueue&&(t.flags|=4),$o(t),null);case 4:return as(),Fo(e,t),null===e&&Gr(t.stateNode.containerInfo),$o(t),null;case 10:return Si(t.type._context),$o(t),null;case 19:if(Pa(os),null===(s=t.memoizedState))return $o(t),null;if(r=0!=(128&t.flags),null===(l=s.rendering))if(r)Wo(s,!1);else{if(0!==Rl||null!==e&&0!=(128&e.flags))for(e=t.child;null!==e;){if(null!==(l=ls(e))){for(t.flags|=128,Wo(s,!1),null!==(r=l.updateQueue)&&(t.updateQueue=r,t.flags|=4),t.subtreeFlags=0,r=n,n=t.child;null!==n;)e=r,(s=n).flags&=14680066,null===(l=s.alternate)?(s.childLanes=0,s.lanes=e,s.child=null,s.subtreeFlags=0,s.memoizedProps=null,s.memoizedState=null,s.updateQueue=null,s.dependencies=null,s.stateNode=null):(s.childLanes=l.childLanes,s.lanes=l.lanes,s.child=l.child,s.subtreeFlags=0,s.deletions=null,s.memoizedProps=l.memoizedProps,s.memoizedState=l.memoizedState,s.updateQueue=l.updateQueue,s.type=l.type,e=l.dependencies,s.dependencies=null===e?null:{lanes:e.lanes,firstContext:e.firstContext}),n=n.sibling;return _a(os,1&os.current|2),t.child}e=e.sibling}null!==s.tail&&Qe()>Hl&&(t.flags|=128,r=!0,Wo(s,!1),t.lanes=4194304)}else{if(!r)if(null!==(e=ls(l))){if(t.flags|=128,r=!0,null!==(n=e.updateQueue)&&(t.updateQueue=n,t.flags|=4),Wo(s,!0),null===s.tail&&"hidden"===s.tailMode&&!l.alternate&&!ai)return $o(t),null}else 2*Qe()-s.renderingStartTime>Hl&&1073741824!==n&&(t.flags|=128,r=!0,Wo(s,!1),t.lanes=4194304);s.isBackwards?(l.sibling=t.child,t.child=l):(null!==(n=s.last)?n.sibling=l:t.child=l,s.last=l)}return null!==s.tail?(t=s.tail,s.rendering=t,s.tail=t.sibling,s.renderingStartTime=Qe(),t.sibling=null,n=os.current,_a(os,r?1&n|2:1&n),t):($o(t),null);case 22:case 23:return pu(),r=null!==t.memoizedState,null!==e&&null!==e.memoizedState!==r&&(t.flags|=8192),r&&0!=(1&t.mode)?0!=(1073741824&Fl)&&($o(t),6&t.subtreeFlags&&(t.flags|=8192)):$o(t),null;case 24:case 25:return null}throw Error(i(156,t.tag))}function Jo(e,t){switch(ti(t),t.tag){case 1:return Ia(t.type)&&Fa(),65536&(e=t.flags)?(t.flags=-65537&e|128,t):null;case 3:return as(),Pa(Ta),Pa(Aa),cs(),0!=(65536&(e=t.flags))&&0==(128&e)?(t.flags=-65537&e|128,t):null;case 5:return ss(t),null;case 13:if(Pa(os),null!==(e=t.memoizedState)&&null!==e.dehydrated){if(null===t.alternate)throw Error(i(340));fi()}return 65536&(e=t.flags)?(t.flags=-65537&e|128,t):null;case 19:return Pa(os),null;case 4:return as(),null;case 10:return Si(t.type._context),null;case 22:case 23:return pu(),null;default:return null}}Io=function(e,t){for(var n=t.child;null!==n;){if(5===n.tag||6===n.tag)e.appendChild(n.stateNode);else if(4!==n.tag&&null!==n.child){n.child.return=n,n=n.child;continue}if(n===t)break;for(;null===n.sibling;){if(null===n.return||n.return===t)return;n=n.return}n.sibling.return=n.return,n=n.sibling}},Fo=function(){},Oo=function(e,t,n,r){var a=e.memoizedProps;if(a!==r){e=t.stateNode,ns(Zi.current);var i,s=null;switch(n){case"input":a=J(e,a),r=J(e,r),s=[];break;case"select":a=N({},a,{value:void 0}),r=N({},r,{value:void 0}),s=[];break;case"textarea":a=re(e,a),r=re(e,r),s=[];break;default:"function"!=typeof a.onClick&&"function"==typeof r.onClick&&(e.onclick=Zr)}for(c in ve(n,r),n=null,a)if(!r.hasOwnProperty(c)&&a.hasOwnProperty(c)&&null!=a[c])if("style"===c){var l=a[c];for(i in l)l.hasOwnProperty(i)&&(n||(n={}),n[i]="")}else"dangerouslySetInnerHTML"!==c&&"children"!==c&&"suppressContentEditableWarning"!==c&&"suppressHydrationWarning"!==c&&"autoFocus"!==c&&(o.hasOwnProperty(c)?s||(s=[]):(s=s||[]).push(c,null));for(c in r){var u=r[c];if(l=null!=a?a[c]:void 0,r.hasOwnProperty(c)&&u!==l&&(null!=u||null!=l))if("style"===c)if(l){for(i in l)!l.hasOwnProperty(i)||u&&u.hasOwnProperty(i)||(n||(n={}),n[i]="");for(i in u)u.hasOwnProperty(i)&&l[i]!==u[i]&&(n||(n={}),n[i]=u[i])}else n||(s||(s=[]),s.push(c,n)),n=u;else"dangerouslySetInnerHTML"===c?(u=u?u.__html:void 0,l=l?l.__html:void 0,null!=u&&l!==u&&(s=s||[]).push(c,u)):"children"===c?"string"!=typeof u&&"number"!=typeof u||(s=s||[]).push(c,""+u):"suppressContentEditableWarning"!==c&&"suppressHydrationWarning"!==c&&(o.hasOwnProperty(c)?(null!=u&&"onScroll"===c&&Br("scroll",e),s||l===u||(s=[])):(s=s||[]).push(c,u))}n&&(s=s||[]).push("style",n);var c=s;(t.updateQueue=c)&&(t.flags|=4)}},Ro=function(e,t,n,r){n!==r&&(t.flags|=4)};var Yo=!1,Qo=!1,Xo="function"==typeof WeakSet?WeakSet:Set,Zo=null;function el(e,t){var n=e.ref;if(null!==n)if("function"==typeof n)try{n(null)}catch(n){Pu(e,t,n)}else n.current=null}function tl(e,t,n){try{n()}catch(n){Pu(e,t,n)}}var nl=!1;function rl(e,t,n){var r=t.updateQueue;if(null!==(r=null!==r?r.lastEffect:null)){var a=r=r.next;do{if((a.tag&e)===e){var i=a.destroy;a.destroy=void 0,void 0!==i&&tl(t,n,i)}a=a.next}while(a!==r)}}function al(e,t){if(null!==(t=null!==(t=t.updateQueue)?t.lastEffect:null)){var n=t=t.next;do{if((n.tag&e)===e){var r=n.create;n.destroy=r()}n=n.next}while(n!==t)}}function il(e){var t=e.ref;if(null!==t){var n=e.stateNode;e.tag,e=n,"function"==typeof t?t(e):t.current=e}}function sl(e){var t=e.alternate;null!==t&&(e.alternate=null,sl(t)),e.child=null,e.deletions=null,e.sibling=null,5===e.tag&&(null!==(t=e.stateNode)&&(delete t[pa],delete t[fa],delete t[ma],delete t[ga],delete t[ya])),e.stateNode=null,e.return=null,e.dependencies=null,e.memoizedProps=null,e.memoizedState=null,e.pendingProps=null,e.stateNode=null,e.updateQueue=null}function ol(e){return 5===e.tag||3===e.tag||4===e.tag}function ll(e){e:for(;;){for(;null===e.sibling;){if(null===e.return||ol(e.return))return null;e=e.return}for(e.sibling.return=e.return,e=e.sibling;5!==e.tag&&6!==e.tag&&18!==e.tag;){if(2&e.flags)continue e;if(null===e.child||4===e.tag)continue e;e.child.return=e,e=e.child}if(!(2&e.flags))return e.stateNode}}function ul(e,t,n){var r=e.tag;if(5===r||6===r)e=e.stateNode,t?8===n.nodeType?n.parentNode.insertBefore(e,t):n.insertBefore(e,t):(8===n.nodeType?(t=n.parentNode).insertBefore(e,n):(t=n).appendChild(e),null!=(n=n._reactRootContainer)||null!==t.onclick||(t.onclick=Zr));else if(4!==r&&null!==(e=e.child))for(ul(e,t,n),e=e.sibling;null!==e;)ul(e,t,n),e=e.sibling}function cl(e,t,n){var r=e.tag;if(5===r||6===r)e=e.stateNode,t?n.insertBefore(e,t):n.appendChild(e);else if(4!==r&&null!==(e=e.child))for(cl(e,t,n),e=e.sibling;null!==e;)cl(e,t,n),e=e.sibling}var hl=null,pl=!1;function fl(e,t,n){for(n=n.child;null!==n;)dl(e,t,n),n=n.sibling}function dl(e,t,n){if(it&&"function"==typeof it.onCommitFiberUnmount)try{it.onCommitFiberUnmount(at,n)}catch(e){}switch(n.tag){case 5:Qo||el(n,t);case 6:var r=hl,a=pl;hl=null,fl(e,t,n),pl=a,null!==(hl=r)&&(pl?(e=hl,n=n.stateNode,8===e.nodeType?e.parentNode.removeChild(n):e.removeChild(n)):hl.removeChild(n.stateNode));break;case 18:null!==hl&&(pl?(e=hl,n=n.stateNode,8===e.nodeType?la(e.parentNode,n):1===e.nodeType&&la(e,n),Gt(e)):la(hl,n.stateNode));break;case 4:r=hl,a=pl,hl=n.stateNode.containerInfo,pl=!0,fl(e,t,n),hl=r,pl=a;break;case 0:case 11:case 14:case 15:if(!Qo&&(null!==(r=n.updateQueue)&&null!==(r=r.lastEffect))){a=r=r.next;do{var i=a,s=i.destroy;i=i.tag,void 0!==s&&(0!=(2&i)||0!=(4&i))&&tl(n,t,s),a=a.next}while(a!==r)}fl(e,t,n);break;case 1:if(!Qo&&(el(n,t),"function"==typeof(r=n.stateNode).componentWillUnmount))try{r.props=n.memoizedProps,r.state=n.memoizedState,r.componentWillUnmount()}catch(e){Pu(n,t,e)}fl(e,t,n);break;case 21:fl(e,t,n);break;case 22:1&n.mode?(Qo=(r=Qo)||null!==n.memoizedState,fl(e,t,n),Qo=r):fl(e,t,n);break;default:fl(e,t,n)}}function ml(e){var t=e.updateQueue;if(null!==t){e.updateQueue=null;var n=e.stateNode;null===n&&(n=e.stateNode=new Xo),t.forEach((function(t){var r=Tu.bind(null,e,t);n.has(t)||(n.add(t),t.then(r,r))}))}}function gl(e,t){var n=t.deletions;if(null!==n)for(var r=0;r<n.length;r++){var a=n[r];try{var s=e,o=t,l=o;e:for(;null!==l;){switch(l.tag){case 5:hl=l.stateNode,pl=!1;break e;case 3:case 4:hl=l.stateNode.containerInfo,pl=!0;break e}l=l.return}if(null===hl)throw Error(i(160));dl(s,o,a),hl=null,pl=!1;var u=a.alternate;null!==u&&(u.return=null),a.return=null}catch(e){Pu(a,t,e)}}if(12854&t.subtreeFlags)for(t=t.child;null!==t;)yl(t,e),t=t.sibling}function yl(e,t){var n=e.alternate,r=e.flags;switch(e.tag){case 0:case 11:case 14:case 15:if(gl(t,e),vl(e),4&r){try{rl(3,e,e.return),al(3,e)}catch(t){Pu(e,e.return,t)}try{rl(5,e,e.return)}catch(t){Pu(e,e.return,t)}}break;case 1:gl(t,e),vl(e),512&r&&null!==n&&el(n,n.return);break;case 5:if(gl(t,e),vl(e),512&r&&null!==n&&el(n,n.return),32&e.flags){var a=e.stateNode;try{pe(a,"")}catch(t){Pu(e,e.return,t)}}if(4&r&&null!=(a=e.stateNode)){var s=e.memoizedProps,o=null!==n?n.memoizedProps:s,l=e.type,u=e.updateQueue;if(e.updateQueue=null,null!==u)try{"input"===l&&"radio"===s.type&&null!=s.name&&Q(a,s),be(l,o);var c=be(l,s);for(o=0;o<u.length;o+=2){var h=u[o],p=u[o+1];"style"===h?ge(a,p):"dangerouslySetInnerHTML"===h?he(a,p):"children"===h?pe(a,p):b(a,h,p,c)}switch(l){case"input":X(a,s);break;case"textarea":ie(a,s);break;case"select":var f=a._wrapperState.wasMultiple;a._wrapperState.wasMultiple=!!s.multiple;var d=s.value;null!=d?ne(a,!!s.multiple,d,!1):f!==!!s.multiple&&(null!=s.defaultValue?ne(a,!!s.multiple,s.defaultValue,!0):ne(a,!!s.multiple,s.multiple?[]:"",!1))}a[fa]=s}catch(t){Pu(e,e.return,t)}}break;case 6:if(gl(t,e),vl(e),4&r){if(null===e.stateNode)throw Error(i(162));a=e.stateNode,s=e.memoizedProps;try{a.nodeValue=s}catch(t){Pu(e,e.return,t)}}break;case 3:if(gl(t,e),vl(e),4&r&&null!==n&&n.memoizedState.isDehydrated)try{Gt(t.containerInfo)}catch(t){Pu(e,e.return,t)}break;case 4:default:gl(t,e),vl(e);break;case 13:gl(t,e),vl(e),8192&(a=e.child).flags&&(s=null!==a.memoizedState,a.stateNode.isHidden=s,!s||null!==a.alternate&&null!==a.alternate.memoizedState||(Gl=Qe())),4&r&&ml(e);break;case 22:if(h=null!==n&&null!==n.memoizedState,1&e.mode?(Qo=(c=Qo)||h,gl(t,e),Qo=c):gl(t,e),vl(e),8192&r){if(c=null!==e.memoizedState,(e.stateNode.isHidden=c)&&!h&&0!=(1&e.mode))for(Zo=e,h=e.child;null!==h;){for(p=Zo=h;null!==Zo;){switch(d=(f=Zo).child,f.tag){case 0:case 11:case 14:case 15:rl(4,f,f.return);break;case 1:el(f,f.return);var m=f.stateNode;if("function"==typeof m.componentWillUnmount){r=f,n=f.return;try{t=r,m.props=t.memoizedProps,m.state=t.memoizedState,m.componentWillUnmount()}catch(e){Pu(r,n,e)}}break;case 5:el(f,f.return);break;case 22:if(null!==f.memoizedState){Sl(p);continue}}null!==d?(d.return=f,Zo=d):Sl(p)}h=h.sibling}e:for(h=null,p=e;;){if(5===p.tag){if(null===h){h=p;try{a=p.stateNode,c?"function"==typeof(s=a.style).setProperty?s.setProperty("display","none","important"):s.display="none":(l=p.stateNode,o=null!=(u=p.memoizedProps.style)&&u.hasOwnProperty("display")?u.display:null,l.style.display=me("display",o))}catch(t){Pu(e,e.return,t)}}}else if(6===p.tag){if(null===h)try{p.stateNode.nodeValue=c?"":p.memoizedProps}catch(t){Pu(e,e.return,t)}}else if((22!==p.tag&&23!==p.tag||null===p.memoizedState||p===e)&&null!==p.child){p.child.return=p,p=p.child;continue}if(p===e)break e;for(;null===p.sibling;){if(null===p.return||p.return===e)break e;h===p&&(h=null),p=p.return}h===p&&(h=null),p.sibling.return=p.return,p=p.sibling}}break;case 19:gl(t,e),vl(e),4&r&&ml(e);case 21:}}function vl(e){var t=e.flags;if(2&t){try{e:{for(var n=e.return;null!==n;){if(ol(n)){var r=n;break e}n=n.return}throw Error(i(160))}switch(r.tag){case 5:var a=r.stateNode;32&r.flags&&(pe(a,""),r.flags&=-33),cl(e,ll(e),a);break;case 3:case 4:var s=r.stateNode.containerInfo;ul(e,ll(e),s);break;default:throw Error(i(161))}}catch(t){Pu(e,e.return,t)}e.flags&=-3}4096&t&&(e.flags&=-4097)}function bl(e,t,n){Zo=e,kl(e,t,n)}function kl(e,t,n){for(var r=0!=(1&e.mode);null!==Zo;){var a=Zo,i=a.child;if(22===a.tag&&r){var s=null!==a.memoizedState||Yo;if(!s){var o=a.alternate,l=null!==o&&null!==o.memoizedState||Qo;o=Yo;var u=Qo;if(Yo=s,(Qo=l)&&!u)for(Zo=a;null!==Zo;)l=(s=Zo).child,22===s.tag&&null!==s.memoizedState?wl(a):null!==l?(l.return=s,Zo=l):wl(a);for(;null!==i;)Zo=i,kl(i,t,n),i=i.sibling;Zo=a,Yo=o,Qo=u}xl(e)}else 0!=(8772&a.subtreeFlags)&&null!==i?(i.return=a,Zo=i):xl(e)}}function xl(e){for(;null!==Zo;){var t=Zo;if(0!=(8772&t.flags)){var n=t.alternate;try{if(0!=(8772&t.flags))switch(t.tag){case 0:case 11:case 15:Qo||al(5,t);break;case 1:var r=t.stateNode;if(4&t.flags&&!Qo)if(null===n)r.componentDidMount();else{var a=t.elementType===t.type?n.memoizedProps:gi(t.type,n.memoizedProps);r.componentDidUpdate(a,n.memoizedState,r.__reactInternalSnapshotBeforeUpdate)}var s=t.updateQueue;null!==s&&Vi(t,s,r);break;case 3:var o=t.updateQueue;if(null!==o){if(n=null,null!==t.child)switch(t.child.tag){case 5:case 1:n=t.child.stateNode}Vi(t,o,n)}break;case 5:var l=t.stateNode;if(null===n&&4&t.flags){n=l;var u=t.memoizedProps;switch(t.type){case"button":case"input":case"select":case"textarea":u.autoFocus&&n.focus();break;case"img":u.src&&(n.src=u.src)}}break;case 6:case 4:case 12:case 19:case 17:case 21:case 22:case 23:case 25:break;case 13:if(null===t.memoizedState){var c=t.alternate;if(null!==c){var h=c.memoizedState;if(null!==h){var p=h.dehydrated;null!==p&&Gt(p)}}}break;default:throw Error(i(163))}Qo||512&t.flags&&il(t)}catch(e){Pu(t,t.return,e)}}if(t===e){Zo=null;break}if(null!==(n=t.sibling)){n.return=t.return,Zo=n;break}Zo=t.return}}function Sl(e){for(;null!==Zo;){var t=Zo;if(t===e){Zo=null;break}var n=t.sibling;if(null!==n){n.return=t.return,Zo=n;break}Zo=t.return}}function wl(e){for(;null!==Zo;){var t=Zo;try{switch(t.tag){case 0:case 11:case 15:var n=t.return;try{al(4,t)}catch(e){Pu(t,n,e)}break;case 1:var r=t.stateNode;if("function"==typeof r.componentDidMount){var a=t.return;try{r.componentDidMount()}catch(e){Pu(t,a,e)}}var i=t.return;try{il(t)}catch(e){Pu(t,i,e)}break;case 5:var s=t.return;try{il(t)}catch(e){Pu(t,s,e)}}}catch(e){Pu(t,t.return,e)}if(t===e){Zo=null;break}var o=t.sibling;if(null!==o){o.return=t.return,Zo=o;break}Zo=t.return}}var El,Pl=Math.ceil,_l=k.ReactCurrentDispatcher,Cl=k.ReactCurrentOwner,Al=k.ReactCurrentBatchConfig,Tl=0,Ml=null,Dl=null,Il=0,Fl=0,Ol=Ea(0),Rl=0,Ll=null,Nl=0,Vl=0,Bl=0,zl=null,jl=null,Gl=0,Hl=1/0,ql=null,Ul=!1,Wl=null,$l=null,Kl=!1,Jl=null,Yl=0,Ql=0,Xl=null,Zl=-1,eu=0;function tu(){return 0!=(6&Tl)?Qe():-1!==Zl?Zl:Zl=Qe()}function nu(e){return 0==(1&e.mode)?1:0!=(2&Tl)&&0!==Il?Il&-Il:null!==mi.transition?(0===eu&&(eu=mt()),eu):0!==(e=bt)?e:e=void 0===(e=window.event)?16:Yt(e.type)}function ru(e,t,n,r){if(50<Ql)throw Ql=0,Xl=null,Error(i(185));yt(e,n,r),0!=(2&Tl)&&e===Ml||(e===Ml&&(0==(2&Tl)&&(Vl|=n),4===Rl&&lu(e,Il)),au(e,r),1===n&&0===Tl&&0==(1&t.mode)&&(Hl=Qe()+500,Ba&&Ga()))}function au(e,t){var n=e.callbackNode;!function(e,t){for(var n=e.suspendedLanes,r=e.pingedLanes,a=e.expirationTimes,i=e.pendingLanes;0<i;){var s=31-st(i),o=1<<s,l=a[s];-1===l?0!=(o&n)&&0==(o&r)||(a[s]=ft(o,t)):l<=t&&(e.expiredLanes|=o),i&=~o}}(e,t);var r=pt(e,e===Ml?Il:0);if(0===r)null!==n&&Ke(n),e.callbackNode=null,e.callbackPriority=0;else if(t=r&-r,e.callbackPriority!==t){if(null!=n&&Ke(n),1===t)0===e.tag?function(e){Ba=!0,ja(e)}(uu.bind(null,e)):ja(uu.bind(null,e)),sa((function(){0==(6&Tl)&&Ga()})),n=null;else{switch(kt(r)){case 1:n=Ze;break;case 4:n=et;break;case 16:default:n=tt;break;case 536870912:n=rt}n=Mu(n,iu.bind(null,e))}e.callbackPriority=t,e.callbackNode=n}}function iu(e,t){if(Zl=-1,eu=0,0!=(6&Tl))throw Error(i(327));var n=e.callbackNode;if(wu()&&e.callbackNode!==n)return null;var r=pt(e,e===Ml?Il:0);if(0===r)return null;if(0!=(30&r)||0!=(r&e.expiredLanes)||t)t=yu(e,r);else{t=r;var a=Tl;Tl|=2;var s=mu();for(Ml===e&&Il===t||(ql=null,Hl=Qe()+500,fu(e,t));;)try{bu();break}catch(t){du(e,t)}xi(),_l.current=s,Tl=a,null!==Dl?t=0:(Ml=null,Il=0,t=Rl)}if(0!==t){if(2===t&&(0!==(a=dt(e))&&(r=a,t=su(e,a))),1===t)throw n=Ll,fu(e,0),lu(e,r),au(e,Qe()),n;if(6===t)lu(e,r);else{if(a=e.current.alternate,0==(30&r)&&!function(e){for(var t=e;;){if(16384&t.flags){var n=t.updateQueue;if(null!==n&&null!==(n=n.stores))for(var r=0;r<n.length;r++){var a=n[r],i=a.getSnapshot;a=a.value;try{if(!or(i(),a))return!1}catch(e){return!1}}}if(n=t.child,16384&t.subtreeFlags&&null!==n)n.return=t,t=n;else{if(t===e)break;for(;null===t.sibling;){if(null===t.return||t.return===e)return!0;t=t.return}t.sibling.return=t.return,t=t.sibling}}return!0}(a)&&(2===(t=yu(e,r))&&(0!==(s=dt(e))&&(r=s,t=su(e,s))),1===t))throw n=Ll,fu(e,0),lu(e,r),au(e,Qe()),n;switch(e.finishedWork=a,e.finishedLanes=r,t){case 0:case 1:throw Error(i(345));case 2:case 5:Su(e,jl,ql);break;case 3:if(lu(e,r),(130023424&r)===r&&10<(t=Gl+500-Qe())){if(0!==pt(e,0))break;if(((a=e.suspendedLanes)&r)!==r){tu(),e.pingedLanes|=e.suspendedLanes&a;break}e.timeoutHandle=ra(Su.bind(null,e,jl,ql),t);break}Su(e,jl,ql);break;case 4:if(lu(e,r),(4194240&r)===r)break;for(t=e.eventTimes,a=-1;0<r;){var o=31-st(r);s=1<<o,(o=t[o])>a&&(a=o),r&=~s}if(r=a,10<(r=(120>(r=Qe()-r)?120:480>r?480:1080>r?1080:1920>r?1920:3e3>r?3e3:4320>r?4320:1960*Pl(r/1960))-r)){e.timeoutHandle=ra(Su.bind(null,e,jl,ql),r);break}Su(e,jl,ql);break;default:throw Error(i(329))}}}return au(e,Qe()),e.callbackNode===n?iu.bind(null,e):null}function su(e,t){var n=zl;return e.current.memoizedState.isDehydrated&&(fu(e,t).flags|=256),2!==(e=yu(e,t))&&(t=jl,jl=n,null!==t&&ou(t)),e}function ou(e){null===jl?jl=e:jl.push.apply(jl,e)}function lu(e,t){for(t&=~Bl,t&=~Vl,e.suspendedLanes|=t,e.pingedLanes&=~t,e=e.expirationTimes;0<t;){var n=31-st(t),r=1<<n;e[n]=-1,t&=~r}}function uu(e){if(0!=(6&Tl))throw Error(i(327));wu();var t=pt(e,0);if(0==(1&t))return au(e,Qe()),null;var n=yu(e,t);if(0!==e.tag&&2===n){var r=dt(e);0!==r&&(t=r,n=su(e,r))}if(1===n)throw n=Ll,fu(e,0),lu(e,t),au(e,Qe()),n;if(6===n)throw Error(i(345));return e.finishedWork=e.current.alternate,e.finishedLanes=t,Su(e,jl,ql),au(e,Qe()),null}function cu(e,t){var n=Tl;Tl|=1;try{return e(t)}finally{0===(Tl=n)&&(Hl=Qe()+500,Ba&&Ga())}}function hu(e){null!==Jl&&0===Jl.tag&&0==(6&Tl)&&wu();var t=Tl;Tl|=1;var n=Al.transition,r=bt;try{if(Al.transition=null,bt=1,e)return e()}finally{bt=r,Al.transition=n,0==(6&(Tl=t))&&Ga()}}function pu(){Fl=Ol.current,Pa(Ol)}function fu(e,t){e.finishedWork=null,e.finishedLanes=0;var n=e.timeoutHandle;if(-1!==n&&(e.timeoutHandle=-1,aa(n)),null!==Dl)for(n=Dl.return;null!==n;){var r=n;switch(ti(r),r.tag){case 1:null!=(r=r.type.childContextTypes)&&Fa();break;case 3:as(),Pa(Ta),Pa(Aa),cs();break;case 5:ss(r);break;case 4:as();break;case 13:case 19:Pa(os);break;case 10:Si(r.type._context);break;case 22:case 23:pu()}n=n.return}if(Ml=e,Dl=e=Ou(e.current,null),Il=Fl=t,Rl=0,Ll=null,Bl=Vl=Nl=0,jl=zl=null,null!==_i){for(t=0;t<_i.length;t++)if(null!==(r=(n=_i[t]).interleaved)){n.interleaved=null;var a=r.next,i=n.pending;if(null!==i){var s=i.next;i.next=a,r.next=s}n.pending=r}_i=null}return e}function du(e,t){for(;;){var n=Dl;try{if(xi(),hs.current=io,ys){for(var r=ds.memoizedState;null!==r;){var a=r.queue;null!==a&&(a.pending=null),r=r.next}ys=!1}if(fs=0,gs=ms=ds=null,vs=!1,bs=0,Cl.current=null,null===n||null===n.return){Rl=1,Ll=t,Dl=null;break}e:{var s=e,o=n.return,l=n,u=t;if(t=Il,l.flags|=32768,null!==u&&"object"==typeof u&&"function"==typeof u.then){var c=u,h=l,p=h.tag;if(0==(1&h.mode)&&(0===p||11===p||15===p)){var f=h.alternate;f?(h.updateQueue=f.updateQueue,h.memoizedState=f.memoizedState,h.lanes=f.lanes):(h.updateQueue=null,h.memoizedState=null)}var d=yo(o);if(null!==d){d.flags&=-257,vo(d,o,l,0,t),1&d.mode&&go(s,c,t),u=c;var m=(t=d).updateQueue;if(null===m){var g=new Set;g.add(u),t.updateQueue=g}else m.add(u);break e}if(0==(1&t)){go(s,c,t),gu();break e}u=Error(i(426))}else if(ai&&1&l.mode){var y=yo(o);if(null!==y){0==(65536&y.flags)&&(y.flags|=256),vo(y,o,l,0,t),di(uo(u,l));break e}}s=u=uo(u,l),4!==Rl&&(Rl=2),null===zl?zl=[s]:zl.push(s),s=o;do{switch(s.tag){case 3:s.flags|=65536,t&=-t,s.lanes|=t,Li(s,fo(0,u,t));break e;case 1:l=u;var v=s.type,b=s.stateNode;if(0==(128&s.flags)&&("function"==typeof v.getDerivedStateFromError||null!==b&&"function"==typeof b.componentDidCatch&&(null===$l||!$l.has(b)))){s.flags|=65536,t&=-t,s.lanes|=t,Li(s,mo(s,l,t));break e}}s=s.return}while(null!==s)}xu(n)}catch(e){t=e,Dl===n&&null!==n&&(Dl=n=n.return);continue}break}}function mu(){var e=_l.current;return _l.current=io,null===e?io:e}function gu(){0!==Rl&&3!==Rl&&2!==Rl||(Rl=4),null===Ml||0==(268435455&Nl)&&0==(268435455&Vl)||lu(Ml,Il)}function yu(e,t){var n=Tl;Tl|=2;var r=mu();for(Ml===e&&Il===t||(ql=null,fu(e,t));;)try{vu();break}catch(t){du(e,t)}if(xi(),Tl=n,_l.current=r,null!==Dl)throw Error(i(261));return Ml=null,Il=0,Rl}function vu(){for(;null!==Dl;)ku(Dl)}function bu(){for(;null!==Dl&&!Je();)ku(Dl)}function ku(e){var t=El(e.alternate,e,Fl);e.memoizedProps=e.pendingProps,null===t?xu(e):Dl=t,Cl.current=null}function xu(e){var t=e;do{var n=t.alternate;if(e=t.return,0==(32768&t.flags)){if(null!==(n=Ko(n,t,Fl)))return void(Dl=n)}else{if(null!==(n=Jo(n,t)))return n.flags&=32767,void(Dl=n);if(null===e)return Rl=6,void(Dl=null);e.flags|=32768,e.subtreeFlags=0,e.deletions=null}if(null!==(t=t.sibling))return void(Dl=t);Dl=t=e}while(null!==t);0===Rl&&(Rl=5)}function Su(e,t,n){var r=bt,a=Al.transition;try{Al.transition=null,bt=1,function(e,t,n,r){do{wu()}while(null!==Jl);if(0!=(6&Tl))throw Error(i(327));n=e.finishedWork;var a=e.finishedLanes;if(null===n)return null;if(e.finishedWork=null,e.finishedLanes=0,n===e.current)throw Error(i(177));e.callbackNode=null,e.callbackPriority=0;var s=n.lanes|n.childLanes;if(function(e,t){var n=e.pendingLanes&~t;e.pendingLanes=t,e.suspendedLanes=0,e.pingedLanes=0,e.expiredLanes&=t,e.mutableReadLanes&=t,e.entangledLanes&=t,t=e.entanglements;var r=e.eventTimes;for(e=e.expirationTimes;0<n;){var a=31-st(n),i=1<<a;t[a]=0,r[a]=-1,e[a]=-1,n&=~i}}(e,s),e===Ml&&(Dl=Ml=null,Il=0),0==(2064&n.subtreeFlags)&&0==(2064&n.flags)||Kl||(Kl=!0,Mu(tt,(function(){return wu(),null}))),s=0!=(15990&n.flags),0!=(15990&n.subtreeFlags)||s){s=Al.transition,Al.transition=null;var o=bt;bt=1;var l=Tl;Tl|=4,Cl.current=null,function(e,t){if(ea=qt,fr(e=pr())){if("selectionStart"in e)var n={start:e.selectionStart,end:e.selectionEnd};else e:{var r=(n=(n=e.ownerDocument)&&n.defaultView||window).getSelection&&n.getSelection();if(r&&0!==r.rangeCount){n=r.anchorNode;var a=r.anchorOffset,s=r.focusNode;r=r.focusOffset;try{n.nodeType,s.nodeType}catch(e){n=null;break e}var o=0,l=-1,u=-1,c=0,h=0,p=e,f=null;t:for(;;){for(var d;p!==n||0!==a&&3!==p.nodeType||(l=o+a),p!==s||0!==r&&3!==p.nodeType||(u=o+r),3===p.nodeType&&(o+=p.nodeValue.length),null!==(d=p.firstChild);)f=p,p=d;for(;;){if(p===e)break t;if(f===n&&++c===a&&(l=o),f===s&&++h===r&&(u=o),null!==(d=p.nextSibling))break;f=(p=f).parentNode}p=d}n=-1===l||-1===u?null:{start:l,end:u}}else n=null}n=n||{start:0,end:0}}else n=null;for(ta={focusedElem:e,selectionRange:n},qt=!1,Zo=t;null!==Zo;)if(e=(t=Zo).child,0!=(1028&t.subtreeFlags)&&null!==e)e.return=t,Zo=e;else for(;null!==Zo;){t=Zo;try{var m=t.alternate;if(0!=(1024&t.flags))switch(t.tag){case 0:case 11:case 15:case 5:case 6:case 4:case 17:break;case 1:if(null!==m){var g=m.memoizedProps,y=m.memoizedState,v=t.stateNode,b=v.getSnapshotBeforeUpdate(t.elementType===t.type?g:gi(t.type,g),y);v.__reactInternalSnapshotBeforeUpdate=b}break;case 3:var k=t.stateNode.containerInfo;1===k.nodeType?k.textContent="":9===k.nodeType&&k.documentElement&&k.removeChild(k.documentElement);break;default:throw Error(i(163))}}catch(e){Pu(t,t.return,e)}if(null!==(e=t.sibling)){e.return=t.return,Zo=e;break}Zo=t.return}m=nl,nl=!1}(e,n),yl(n,e),dr(ta),qt=!!ea,ta=ea=null,e.current=n,bl(n,e,a),Ye(),Tl=l,bt=o,Al.transition=s}else e.current=n;if(Kl&&(Kl=!1,Jl=e,Yl=a),s=e.pendingLanes,0===s&&($l=null),function(e){if(it&&"function"==typeof it.onCommitFiberRoot)try{it.onCommitFiberRoot(at,e,void 0,128==(128&e.current.flags))}catch(e){}}(n.stateNode),au(e,Qe()),null!==t)for(r=e.onRecoverableError,n=0;n<t.length;n++)a=t[n],r(a.value,{componentStack:a.stack,digest:a.digest});if(Ul)throw Ul=!1,e=Wl,Wl=null,e;0!=(1&Yl)&&0!==e.tag&&wu(),s=e.pendingLanes,0!=(1&s)?e===Xl?Ql++:(Ql=0,Xl=e):Ql=0,Ga()}(e,t,n,r)}finally{Al.transition=a,bt=r}return null}function wu(){if(null!==Jl){var e=kt(Yl),t=Al.transition,n=bt;try{if(Al.transition=null,bt=16>e?16:e,null===Jl)var r=!1;else{if(e=Jl,Jl=null,Yl=0,0!=(6&Tl))throw Error(i(331));var a=Tl;for(Tl|=4,Zo=e.current;null!==Zo;){var s=Zo,o=s.child;if(0!=(16&Zo.flags)){var l=s.deletions;if(null!==l){for(var u=0;u<l.length;u++){var c=l[u];for(Zo=c;null!==Zo;){var h=Zo;switch(h.tag){case 0:case 11:case 15:rl(8,h,s)}var p=h.child;if(null!==p)p.return=h,Zo=p;else for(;null!==Zo;){var f=(h=Zo).sibling,d=h.return;if(sl(h),h===c){Zo=null;break}if(null!==f){f.return=d,Zo=f;break}Zo=d}}}var m=s.alternate;if(null!==m){var g=m.child;if(null!==g){m.child=null;do{var y=g.sibling;g.sibling=null,g=y}while(null!==g)}}Zo=s}}if(0!=(2064&s.subtreeFlags)&&null!==o)o.return=s,Zo=o;else e:for(;null!==Zo;){if(0!=(2048&(s=Zo).flags))switch(s.tag){case 0:case 11:case 15:rl(9,s,s.return)}var v=s.sibling;if(null!==v){v.return=s.return,Zo=v;break e}Zo=s.return}}var b=e.current;for(Zo=b;null!==Zo;){var k=(o=Zo).child;if(0!=(2064&o.subtreeFlags)&&null!==k)k.return=o,Zo=k;else e:for(o=b;null!==Zo;){if(0!=(2048&(l=Zo).flags))try{switch(l.tag){case 0:case 11:case 15:al(9,l)}}catch(e){Pu(l,l.return,e)}if(l===o){Zo=null;break e}var x=l.sibling;if(null!==x){x.return=l.return,Zo=x;break e}Zo=l.return}}if(Tl=a,Ga(),it&&"function"==typeof it.onPostCommitFiberRoot)try{it.onPostCommitFiberRoot(at,e)}catch(e){}r=!0}return r}finally{bt=n,Al.transition=t}}return!1}function Eu(e,t,n){e=Oi(e,t=fo(0,t=uo(n,t),1),1),t=tu(),null!==e&&(yt(e,1,t),au(e,t))}function Pu(e,t,n){if(3===e.tag)Eu(e,e,n);else for(;null!==t;){if(3===t.tag){Eu(t,e,n);break}if(1===t.tag){var r=t.stateNode;if("function"==typeof t.type.getDerivedStateFromError||"function"==typeof r.componentDidCatch&&(null===$l||!$l.has(r))){t=Oi(t,e=mo(t,e=uo(n,e),1),1),e=tu(),null!==t&&(yt(t,1,e),au(t,e));break}}t=t.return}}function _u(e,t,n){var r=e.pingCache;null!==r&&r.delete(t),t=tu(),e.pingedLanes|=e.suspendedLanes&n,Ml===e&&(Il&n)===n&&(4===Rl||3===Rl&&(130023424&Il)===Il&&500>Qe()-Gl?fu(e,0):Bl|=n),au(e,t)}function Cu(e,t){0===t&&(0==(1&e.mode)?t=1:(t=ct,0==(130023424&(ct<<=1))&&(ct=4194304)));var n=tu();null!==(e=Ti(e,t))&&(yt(e,t,n),au(e,n))}function Au(e){var t=e.memoizedState,n=0;null!==t&&(n=t.retryLane),Cu(e,n)}function Tu(e,t){var n=0;switch(e.tag){case 13:var r=e.stateNode,a=e.memoizedState;null!==a&&(n=a.retryLane);break;case 19:r=e.stateNode;break;default:throw Error(i(314))}null!==r&&r.delete(t),Cu(e,n)}function Mu(e,t){return $e(e,t)}function Du(e,t,n,r){this.tag=e,this.key=n,this.sibling=this.child=this.return=this.stateNode=this.type=this.elementType=null,this.index=0,this.ref=null,this.pendingProps=t,this.dependencies=this.memoizedState=this.updateQueue=this.memoizedProps=null,this.mode=r,this.subtreeFlags=this.flags=0,this.deletions=null,this.childLanes=this.lanes=0,this.alternate=null}function Iu(e,t,n,r){return new Du(e,t,n,r)}function Fu(e){return!(!(e=e.prototype)||!e.isReactComponent)}function Ou(e,t){var n=e.alternate;return null===n?((n=Iu(e.tag,t,e.key,e.mode)).elementType=e.elementType,n.type=e.type,n.stateNode=e.stateNode,n.alternate=e,e.alternate=n):(n.pendingProps=t,n.type=e.type,n.flags=0,n.subtreeFlags=0,n.deletions=null),n.flags=14680064&e.flags,n.childLanes=e.childLanes,n.lanes=e.lanes,n.child=e.child,n.memoizedProps=e.memoizedProps,n.memoizedState=e.memoizedState,n.updateQueue=e.updateQueue,t=e.dependencies,n.dependencies=null===t?null:{lanes:t.lanes,firstContext:t.firstContext},n.sibling=e.sibling,n.index=e.index,n.ref=e.ref,n}function Ru(e,t,n,r,a,s){var o=2;if(r=e,"function"==typeof e)Fu(e)&&(o=1);else if("string"==typeof e)o=5;else e:switch(e){case w:return Lu(n.children,a,s,t);case E:o=8,a|=8;break;case P:return(e=Iu(12,n,t,2|a)).elementType=P,e.lanes=s,e;case T:return(e=Iu(13,n,t,a)).elementType=T,e.lanes=s,e;case M:return(e=Iu(19,n,t,a)).elementType=M,e.lanes=s,e;case F:return Nu(n,a,s,t);default:if("object"==typeof e&&null!==e)switch(e.$$typeof){case _:o=10;break e;case C:o=9;break e;case A:o=11;break e;case D:o=14;break e;case I:o=16,r=null;break e}throw Error(i(130,null==e?e:typeof e,""))}return(t=Iu(o,n,t,a)).elementType=e,t.type=r,t.lanes=s,t}function Lu(e,t,n,r){return(e=Iu(7,e,r,t)).lanes=n,e}function Nu(e,t,n,r){return(e=Iu(22,e,r,t)).elementType=F,e.lanes=n,e.stateNode={isHidden:!1},e}function Vu(e,t,n){return(e=Iu(6,e,null,t)).lanes=n,e}function Bu(e,t,n){return(t=Iu(4,null!==e.children?e.children:[],e.key,t)).lanes=n,t.stateNode={containerInfo:e.containerInfo,pendingChildren:null,implementation:e.implementation},t}function zu(e,t,n,r,a){this.tag=t,this.containerInfo=e,this.finishedWork=this.pingCache=this.current=this.pendingChildren=null,this.timeoutHandle=-1,this.callbackNode=this.pendingContext=this.context=null,this.callbackPriority=0,this.eventTimes=gt(0),this.expirationTimes=gt(-1),this.entangledLanes=this.finishedLanes=this.mutableReadLanes=this.expiredLanes=this.pingedLanes=this.suspendedLanes=this.pendingLanes=0,this.entanglements=gt(0),this.identifierPrefix=r,this.onRecoverableError=a,this.mutableSourceEagerHydrationData=null}function ju(e,t,n,r,a,i,s,o,l){return e=new zu(e,t,n,o,l),1===t?(t=1,!0===i&&(t|=8)):t=0,i=Iu(3,null,null,t),e.current=i,i.stateNode=e,i.memoizedState={element:r,isDehydrated:n,cache:null,transitions:null,pendingSuspenseBoundaries:null},Di(i),e}function Gu(e){if(!e)return Ca;e:{if(Ge(e=e._reactInternals)!==e||1!==e.tag)throw Error(i(170));var t=e;do{switch(t.tag){case 3:t=t.stateNode.context;break e;case 1:if(Ia(t.type)){t=t.stateNode.__reactInternalMemoizedMergedChildContext;break e}}t=t.return}while(null!==t);throw Error(i(171))}if(1===e.tag){var n=e.type;if(Ia(n))return Ra(e,n,t)}return t}function Hu(e,t,n,r,a,i,s,o,l){return(e=ju(n,r,!0,e,0,i,0,o,l)).context=Gu(null),n=e.current,(i=Fi(r=tu(),a=nu(n))).callback=null!=t?t:null,Oi(n,i,a),e.current.lanes=a,yt(e,a,r),au(e,r),e}function qu(e,t,n,r){var a=t.current,i=tu(),s=nu(a);return n=Gu(n),null===t.context?t.context=n:t.pendingContext=n,(t=Fi(i,s)).payload={element:e},null!==(r=void 0===r?null:r)&&(t.callback=r),null!==(e=Oi(a,t,s))&&(ru(e,a,s,i),Ri(e,a,s)),s}function Uu(e){return(e=e.current).child?(e.child.tag,e.child.stateNode):null}function Wu(e,t){if(null!==(e=e.memoizedState)&&null!==e.dehydrated){var n=e.retryLane;e.retryLane=0!==n&&n<t?n:t}}function $u(e,t){Wu(e,t),(e=e.alternate)&&Wu(e,t)}El=function(e,t,n){if(null!==e)if(e.memoizedProps!==t.pendingProps||Ta.current)ko=!0;else{if(0==(e.lanes&n)&&0==(128&t.flags))return ko=!1,function(e,t,n){switch(t.tag){case 3:Mo(t),fi();break;case 5:is(t);break;case 1:Ia(t.type)&&La(t);break;case 4:rs(t,t.stateNode.containerInfo);break;case 10:var r=t.type._context,a=t.memoizedProps.value;_a(yi,r._currentValue),r._currentValue=a;break;case 13:if(null!==(r=t.memoizedState))return null!==r.dehydrated?(_a(os,1&os.current),t.flags|=128,null):0!=(n&t.child.childLanes)?Vo(e,t,n):(_a(os,1&os.current),null!==(e=Uo(e,t,n))?e.sibling:null);_a(os,1&os.current);break;case 19:if(r=0!=(n&t.childLanes),0!=(128&e.flags)){if(r)return Ho(e,t,n);t.flags|=128}if(null!==(a=t.memoizedState)&&(a.rendering=null,a.tail=null,a.lastEffect=null),_a(os,os.current),r)break;return null;case 22:case 23:return t.lanes=0,Po(e,t,n)}return Uo(e,t,n)}(e,t,n);ko=0!=(131072&e.flags)}else ko=!1,ai&&0!=(1048576&t.flags)&&Za(t,Wa,t.index);switch(t.lanes=0,t.tag){case 2:var r=t.type;qo(e,t),e=t.pendingProps;var a=Da(t,Aa.current);Ei(t,n),a=ws(null,t,r,e,a,n);var s=Es();return t.flags|=1,"object"==typeof a&&null!==a&&"function"==typeof a.render&&void 0===a.$$typeof?(t.tag=1,t.memoizedState=null,t.updateQueue=null,Ia(r)?(s=!0,La(t)):s=!1,t.memoizedState=null!==a.state&&void 0!==a.state?a.state:null,Di(t),a.updater=ji,t.stateNode=a,a._reactInternals=t,Ui(t,r,e,n),t=To(null,t,r,!0,s,n)):(t.tag=0,ai&&s&&ei(t),xo(null,t,a,n),t=t.child),t;case 16:r=t.elementType;e:{switch(qo(e,t),e=t.pendingProps,r=(a=r._init)(r._payload),t.type=r,a=t.tag=function(e){if("function"==typeof e)return Fu(e)?1:0;if(null!=e){if((e=e.$$typeof)===A)return 11;if(e===D)return 14}return 2}(r),e=gi(r,e),a){case 0:t=Co(null,t,r,e,n);break e;case 1:t=Ao(null,t,r,e,n);break e;case 11:t=So(null,t,r,e,n);break e;case 14:t=wo(null,t,r,gi(r.type,e),n);break e}throw Error(i(306,r,""))}return t;case 0:return r=t.type,a=t.pendingProps,Co(e,t,r,a=t.elementType===r?a:gi(r,a),n);case 1:return r=t.type,a=t.pendingProps,Ao(e,t,r,a=t.elementType===r?a:gi(r,a),n);case 3:e:{if(Mo(t),null===e)throw Error(i(387));r=t.pendingProps,a=(s=t.memoizedState).element,Ii(e,t),Ni(t,r,null,n);var o=t.memoizedState;if(r=o.element,s.isDehydrated){if(s={element:r,isDehydrated:!1,cache:o.cache,pendingSuspenseBoundaries:o.pendingSuspenseBoundaries,transitions:o.transitions},t.updateQueue.baseState=s,t.memoizedState=s,256&t.flags){t=Do(e,t,r,n,a=uo(Error(i(423)),t));break e}if(r!==a){t=Do(e,t,r,n,a=uo(Error(i(424)),t));break e}for(ri=ua(t.stateNode.containerInfo.firstChild),ni=t,ai=!0,ii=null,n=Qi(t,null,r,n),t.child=n;n;)n.flags=-3&n.flags|4096,n=n.sibling}else{if(fi(),r===a){t=Uo(e,t,n);break e}xo(e,t,r,n)}t=t.child}return t;case 5:return is(t),null===e&&ui(t),r=t.type,a=t.pendingProps,s=null!==e?e.memoizedProps:null,o=a.children,na(r,a)?o=null:null!==s&&na(r,s)&&(t.flags|=32),_o(e,t),xo(e,t,o,n),t.child;case 6:return null===e&&ui(t),null;case 13:return Vo(e,t,n);case 4:return rs(t,t.stateNode.containerInfo),r=t.pendingProps,null===e?t.child=Yi(t,null,r,n):xo(e,t,r,n),t.child;case 11:return r=t.type,a=t.pendingProps,So(e,t,r,a=t.elementType===r?a:gi(r,a),n);case 7:return xo(e,t,t.pendingProps,n),t.child;case 8:case 12:return xo(e,t,t.pendingProps.children,n),t.child;case 10:e:{if(r=t.type._context,a=t.pendingProps,s=t.memoizedProps,o=a.value,_a(yi,r._currentValue),r._currentValue=o,null!==s)if(or(s.value,o)){if(s.children===a.children&&!Ta.current){t=Uo(e,t,n);break e}}else for(null!==(s=t.child)&&(s.return=t);null!==s;){var l=s.dependencies;if(null!==l){o=s.child;for(var u=l.firstContext;null!==u;){if(u.context===r){if(1===s.tag){(u=Fi(-1,n&-n)).tag=2;var c=s.updateQueue;if(null!==c){var h=(c=c.shared).pending;null===h?u.next=u:(u.next=h.next,h.next=u),c.pending=u}}s.lanes|=n,null!==(u=s.alternate)&&(u.lanes|=n),wi(s.return,n,t),l.lanes|=n;break}u=u.next}}else if(10===s.tag)o=s.type===t.type?null:s.child;else if(18===s.tag){if(null===(o=s.return))throw Error(i(341));o.lanes|=n,null!==(l=o.alternate)&&(l.lanes|=n),wi(o,n,t),o=s.sibling}else o=s.child;if(null!==o)o.return=s;else for(o=s;null!==o;){if(o===t){o=null;break}if(null!==(s=o.sibling)){s.return=o.return,o=s;break}o=o.return}s=o}xo(e,t,a.children,n),t=t.child}return t;case 9:return a=t.type,r=t.pendingProps.children,Ei(t,n),r=r(a=Pi(a)),t.flags|=1,xo(e,t,r,n),t.child;case 14:return a=gi(r=t.type,t.pendingProps),wo(e,t,r,a=gi(r.type,a),n);case 15:return Eo(e,t,t.type,t.pendingProps,n);case 17:return r=t.type,a=t.pendingProps,a=t.elementType===r?a:gi(r,a),qo(e,t),t.tag=1,Ia(r)?(e=!0,La(t)):e=!1,Ei(t,n),Hi(t,r,a),Ui(t,r,a,n),To(null,t,r,!0,e,n);case 19:return Ho(e,t,n);case 22:return Po(e,t,n)}throw Error(i(156,t.tag))};var Ku="function"==typeof reportError?reportError:function(e){console.error(e)};function Ju(e){this._internalRoot=e}function Yu(e){this._internalRoot=e}function Qu(e){return!(!e||1!==e.nodeType&&9!==e.nodeType&&11!==e.nodeType)}function Xu(e){return!(!e||1!==e.nodeType&&9!==e.nodeType&&11!==e.nodeType&&(8!==e.nodeType||" react-mount-point-unstable "!==e.nodeValue))}function Zu(){}function ec(e,t,n,r,a){var i=n._reactRootContainer;if(i){var s=i;if("function"==typeof a){var o=a;a=function(){var e=Uu(s);o.call(e)}}qu(t,s,e,a)}else s=function(e,t,n,r,a){if(a){if("function"==typeof r){var i=r;r=function(){var e=Uu(s);i.call(e)}}var s=Hu(t,r,e,0,null,!1,0,"",Zu);return e._reactRootContainer=s,e[da]=s.current,Gr(8===e.nodeType?e.parentNode:e),hu(),s}for(;a=e.lastChild;)e.removeChild(a);if("function"==typeof r){var o=r;r=function(){var e=Uu(l);o.call(e)}}var l=ju(e,0,!1,null,0,!1,0,"",Zu);return e._reactRootContainer=l,e[da]=l.current,Gr(8===e.nodeType?e.parentNode:e),hu((function(){qu(t,l,n,r)})),l}(n,t,e,a,r);return Uu(s)}Yu.prototype.render=Ju.prototype.render=function(e){var t=this._internalRoot;if(null===t)throw Error(i(409));qu(e,t,null,null)},Yu.prototype.unmount=Ju.prototype.unmount=function(){var e=this._internalRoot;if(null!==e){this._internalRoot=null;var t=e.containerInfo;hu((function(){qu(null,e,null,null)})),t[da]=null}},Yu.prototype.unstable_scheduleHydration=function(e){if(e){var t=Et();e={blockedOn:null,target:e,priority:t};for(var n=0;n<Ft.length&&0!==t&&t<Ft[n].priority;n++);Ft.splice(n,0,e),0===n&&Nt(e)}},xt=function(e){switch(e.tag){case 3:var t=e.stateNode;if(t.current.memoizedState.isDehydrated){var n=ht(t.pendingLanes);0!==n&&(vt(t,1|n),au(t,Qe()),0==(6&Tl)&&(Hl=Qe()+500,Ga()))}break;case 13:hu((function(){var t=Ti(e,1);if(null!==t){var n=tu();ru(t,e,1,n)}})),$u(e,1)}},St=function(e){if(13===e.tag){var t=Ti(e,134217728);if(null!==t)ru(t,e,134217728,tu());$u(e,134217728)}},wt=function(e){if(13===e.tag){var t=nu(e),n=Ti(e,t);if(null!==n)ru(n,e,t,tu());$u(e,t)}},Et=function(){return bt},Pt=function(e,t){var n=bt;try{return bt=e,t()}finally{bt=n}},Se=function(e,t,n){switch(t){case"input":if(X(e,n),t=n.name,"radio"===n.type&&null!=t){for(n=e;n.parentNode;)n=n.parentNode;for(n=n.querySelectorAll("input[name="+JSON.stringify(""+t)+'][type="radio"]'),t=0;t<n.length;t++){var r=n[t];if(r!==e&&r.form===e.form){var a=xa(r);if(!a)throw Error(i(90));$(r),X(r,a)}}}break;case"textarea":ie(e,n);break;case"select":null!=(t=n.value)&&ne(e,!!n.multiple,t,!1)}},Ae=cu,Te=hu;var tc={usingClientEntryPoint:!1,Events:[ba,ka,xa,_e,Ce,cu]},nc={findFiberByHostInstance:va,bundleType:0,version:"18.2.0",rendererPackageName:"react-dom"},rc={bundleType:nc.bundleType,version:nc.version,rendererPackageName:nc.rendererPackageName,rendererConfig:nc.rendererConfig,overrideHookState:null,overrideHookStateDeletePath:null,overrideHookStateRenamePath:null,overrideProps:null,overridePropsDeletePath:null,overridePropsRenamePath:null,setErrorHandler:null,setSuspenseHandler:null,scheduleUpdate:null,currentDispatcherRef:k.ReactCurrentDispatcher,findHostInstanceByFiber:function(e){return null===(e=Ue(e))?null:e.stateNode},findFiberByHostInstance:nc.findFiberByHostInstance||function(){return null},findHostInstancesForRefresh:null,scheduleRefresh:null,scheduleRoot:null,setRefreshHandler:null,getCurrentFiber:null,reconcilerVersion:"18.2.0-next-9e3b772b8-20220608"};if("undefined"!=typeof __REACT_DEVTOOLS_GLOBAL_HOOK__){var ac=__REACT_DEVTOOLS_GLOBAL_HOOK__;if(!ac.isDisabled&&ac.supportsFiber)try{at=ac.inject(rc),it=ac}catch(ce){}}t.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED=tc,t.createPortal=function(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!Qu(t))throw Error(i(200));return function(e,t,n){var r=3<arguments.length&&void 0!==arguments[3]?arguments[3]:null;return{$$typeof:S,key:null==r?null:""+r,children:e,containerInfo:t,implementation:n}}(e,t,null,n)},t.createRoot=function(e,t){if(!Qu(e))throw Error(i(299));var n=!1,r="",a=Ku;return null!=t&&(!0===t.unstable_strictMode&&(n=!0),void 0!==t.identifierPrefix&&(r=t.identifierPrefix),void 0!==t.onRecoverableError&&(a=t.onRecoverableError)),t=ju(e,1,!1,null,0,n,0,r,a),e[da]=t.current,Gr(8===e.nodeType?e.parentNode:e),new Ju(t)},t.findDOMNode=function(e){if(null==e)return null;if(1===e.nodeType)return e;var t=e._reactInternals;if(void 0===t){if("function"==typeof e.render)throw Error(i(188));throw e=Object.keys(e).join(","),Error(i(268,e))}return e=null===(e=Ue(t))?null:e.stateNode},t.flushSync=function(e){return hu(e)},t.hydrate=function(e,t,n){if(!Xu(t))throw Error(i(200));return ec(null,e,t,!0,n)},t.hydrateRoot=function(e,t,n){if(!Qu(e))throw Error(i(405));var r=null!=n&&n.hydratedSources||null,a=!1,s="",o=Ku;if(null!=n&&(!0===n.unstable_strictMode&&(a=!0),void 0!==n.identifierPrefix&&(s=n.identifierPrefix),void 0!==n.onRecoverableError&&(o=n.onRecoverableError)),t=Hu(t,null,e,1,null!=n?n:null,a,0,s,o),e[da]=t.current,Gr(e),r)for(e=0;e<r.length;e++)a=(a=(n=r[e])._getVersion)(n._source),null==t.mutableSourceEagerHydrationData?t.mutableSourceEagerHydrationData=[n,a]:t.mutableSourceEagerHydrationData.push(n,a);return new Yu(t)},t.render=function(e,t,n){if(!Xu(t))throw Error(i(200));return ec(null,e,t,!1,n)},t.unmountComponentAtNode=function(e){if(!Xu(e))throw Error(i(40));return!!e._reactRootContainer&&(hu((function(){ec(null,null,e,!1,(function(){e._reactRootContainer=null,e[da]=null}))})),!0)},t.unstable_batchedUpdates=cu,t.unstable_renderSubtreeIntoContainer=function(e,t,n,r){if(!Xu(n))throw Error(i(200));if(null==e||void 0===e._reactInternals)throw Error(i(38));return ec(e,t,n,!1,r)},t.version="18.2.0-next-9e3b772b8-20220608"},745:(e,t,n)=>{"use strict";var r=n(3935);t.s=r.createRoot,r.hydrateRoot},3935:(e,t,n)=>{"use strict";!function e(){if("undefined"!=typeof __REACT_DEVTOOLS_GLOBAL_HOOK__&&"function"==typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE)try{__REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(e)}catch(e){console.error(e)}}(),e.exports=n(4448)},2408:(e,t)=>{"use strict";var n=Symbol.for("react.element"),r=Symbol.for("react.portal"),a=Symbol.for("react.fragment"),i=Symbol.for("react.strict_mode"),s=Symbol.for("react.profiler"),o=Symbol.for("react.provider"),l=Symbol.for("react.context"),u=Symbol.for("react.forward_ref"),c=Symbol.for("react.suspense"),h=Symbol.for("react.memo"),p=Symbol.for("react.lazy"),f=Symbol.iterator;var d={isMounted:function(){return!1},enqueueForceUpdate:function(){},enqueueReplaceState:function(){},enqueueSetState:function(){}},m=Object.assign,g={};function y(e,t,n){this.props=e,this.context=t,this.refs=g,this.updater=n||d}function v(){}function b(e,t,n){this.props=e,this.context=t,this.refs=g,this.updater=n||d}y.prototype.isReactComponent={},y.prototype.setState=function(e,t){if("object"!=typeof e&&"function"!=typeof e&&null!=e)throw Error("setState(...): takes an object of state variables to update or a function which returns an object of state variables.");this.updater.enqueueSetState(this,e,t,"setState")},y.prototype.forceUpdate=function(e){this.updater.enqueueForceUpdate(this,e,"forceUpdate")},v.prototype=y.prototype;var k=b.prototype=new v;k.constructor=b,m(k,y.prototype),k.isPureReactComponent=!0;var x=Array.isArray,S=Object.prototype.hasOwnProperty,w={current:null},E={key:!0,ref:!0,__self:!0,__source:!0};function P(e,t,r){var a,i={},s=null,o=null;if(null!=t)for(a in void 0!==t.ref&&(o=t.ref),void 0!==t.key&&(s=""+t.key),t)S.call(t,a)&&!E.hasOwnProperty(a)&&(i[a]=t[a]);var l=arguments.length-2;if(1===l)i.children=r;else if(1<l){for(var u=Array(l),c=0;c<l;c++)u[c]=arguments[c+2];i.children=u}if(e&&e.defaultProps)for(a in l=e.defaultProps)void 0===i[a]&&(i[a]=l[a]);return{$$typeof:n,type:e,key:s,ref:o,props:i,_owner:w.current}}function _(e){return"object"==typeof e&&null!==e&&e.$$typeof===n}var C=/\/+/g;function A(e,t){return"object"==typeof e&&null!==e&&null!=e.key?function(e){var t={"=":"=0",":":"=2"};return"$"+e.replace(/[=:]/g,(function(e){return t[e]}))}(""+e.key):t.toString(36)}function T(e,t,a,i,s){var o=typeof e;"undefined"!==o&&"boolean"!==o||(e=null);var l=!1;if(null===e)l=!0;else switch(o){case"string":case"number":l=!0;break;case"object":switch(e.$$typeof){case n:case r:l=!0}}if(l)return s=s(l=e),e=""===i?"."+A(l,0):i,x(s)?(a="",null!=e&&(a=e.replace(C,"$&/")+"/"),T(s,t,a,"",(function(e){return e}))):null!=s&&(_(s)&&(s=function(e,t){return{$$typeof:n,type:e.type,key:t,ref:e.ref,props:e.props,_owner:e._owner}}(s,a+(!s.key||l&&l.key===s.key?"":(""+s.key).replace(C,"$&/")+"/")+e)),t.push(s)),1;if(l=0,i=""===i?".":i+":",x(e))for(var u=0;u<e.length;u++){var c=i+A(o=e[u],u);l+=T(o,t,a,c,s)}else if(c=function(e){return null===e||"object"!=typeof e?null:"function"==typeof(e=f&&e[f]||e["@@iterator"])?e:null}(e),"function"==typeof c)for(e=c.call(e),u=0;!(o=e.next()).done;)l+=T(o=o.value,t,a,c=i+A(o,u++),s);else if("object"===o)throw t=String(e),Error("Objects are not valid as a React child (found: "+("[object Object]"===t?"object with keys {"+Object.keys(e).join(", ")+"}":t)+"). If you meant to render a collection of children, use an array instead.");return l}function M(e,t,n){if(null==e)return e;var r=[],a=0;return T(e,r,"","",(function(e){return t.call(n,e,a++)})),r}function D(e){if(-1===e._status){var t=e._result;(t=t()).then((function(t){0!==e._status&&-1!==e._status||(e._status=1,e._result=t)}),(function(t){0!==e._status&&-1!==e._status||(e._status=2,e._result=t)})),-1===e._status&&(e._status=0,e._result=t)}if(1===e._status)return e._result.default;throw e._result}var I={current:null},F={transition:null},O={ReactCurrentDispatcher:I,ReactCurrentBatchConfig:F,ReactCurrentOwner:w};t.Children={map:M,forEach:function(e,t,n){M(e,(function(){t.apply(this,arguments)}),n)},count:function(e){var t=0;return M(e,(function(){t++})),t},toArray:function(e){return M(e,(function(e){return e}))||[]},only:function(e){if(!_(e))throw Error("React.Children.only expected to receive a single React element child.");return e}},t.Component=y,t.Fragment=a,t.Profiler=s,t.PureComponent=b,t.StrictMode=i,t.Suspense=c,t.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED=O,t.cloneElement=function(e,t,r){if(null==e)throw Error("React.cloneElement(...): The argument must be a React element, but you passed "+e+".");var a=m({},e.props),i=e.key,s=e.ref,o=e._owner;if(null!=t){if(void 0!==t.ref&&(s=t.ref,o=w.current),void 0!==t.key&&(i=""+t.key),e.type&&e.type.defaultProps)var l=e.type.defaultProps;for(u in t)S.call(t,u)&&!E.hasOwnProperty(u)&&(a[u]=void 0===t[u]&&void 0!==l?l[u]:t[u])}var u=arguments.length-2;if(1===u)a.children=r;else if(1<u){l=Array(u);for(var c=0;c<u;c++)l[c]=arguments[c+2];a.children=l}return{$$typeof:n,type:e.type,key:i,ref:s,props:a,_owner:o}},t.createContext=function(e){return(e={$$typeof:l,_currentValue:e,_currentValue2:e,_threadCount:0,Provider:null,Consumer:null,_defaultValue:null,_globalName:null}).Provider={$$typeof:o,_context:e},e.Consumer=e},t.createElement=P,t.createFactory=function(e){var t=P.bind(null,e);return t.type=e,t},t.createRef=function(){return{current:null}},t.forwardRef=function(e){return{$$typeof:u,render:e}},t.isValidElement=_,t.lazy=function(e){return{$$typeof:p,_payload:{_status:-1,_result:e},_init:D}},t.memo=function(e,t){return{$$typeof:h,type:e,compare:void 0===t?null:t}},t.startTransition=function(e){var t=F.transition;F.transition={};try{e()}finally{F.transition=t}},t.unstable_act=function(){throw Error("act(...) is not supported in production builds of React.")},t.useCallback=function(e,t){return I.current.useCallback(e,t)},t.useContext=function(e){return I.current.useContext(e)},t.useDebugValue=function(){},t.useDeferredValue=function(e){return I.current.useDeferredValue(e)},t.useEffect=function(e,t){return I.current.useEffect(e,t)},t.useId=function(){return I.current.useId()},t.useImperativeHandle=function(e,t,n){return I.current.useImperativeHandle(e,t,n)},t.useInsertionEffect=function(e,t){return I.current.useInsertionEffect(e,t)},t.useLayoutEffect=function(e,t){return I.current.useLayoutEffect(e,t)},t.useMemo=function(e,t){return I.current.useMemo(e,t)},t.useReducer=function(e,t,n){return I.current.useReducer(e,t,n)},t.useRef=function(e){return I.current.useRef(e)},t.useState=function(e){return I.current.useState(e)},t.useSyncExternalStore=function(e,t,n){return I.current.useSyncExternalStore(e,t,n)},t.useTransition=function(){return I.current.useTransition()},t.version="18.2.0"},7294:(e,t,n)=>{"use strict";e.exports=n(2408)},53:(e,t)=>{"use strict";function n(e,t){var n=e.length;e.push(t);e:for(;0<n;){var r=n-1>>>1,a=e[r];if(!(0<i(a,t)))break e;e[r]=t,e[n]=a,n=r}}function r(e){return 0===e.length?null:e[0]}function a(e){if(0===e.length)return null;var t=e[0],n=e.pop();if(n!==t){e[0]=n;e:for(var r=0,a=e.length,s=a>>>1;r<s;){var o=2*(r+1)-1,l=e[o],u=o+1,c=e[u];if(0>i(l,n))u<a&&0>i(c,l)?(e[r]=c,e[u]=n,r=u):(e[r]=l,e[o]=n,r=o);else{if(!(u<a&&0>i(c,n)))break e;e[r]=c,e[u]=n,r=u}}}return t}function i(e,t){var n=e.sortIndex-t.sortIndex;return 0!==n?n:e.id-t.id}if("object"==typeof performance&&"function"==typeof performance.now){var s=performance;t.unstable_now=function(){return s.now()}}else{var o=Date,l=o.now();t.unstable_now=function(){return o.now()-l}}var u=[],c=[],h=1,p=null,f=3,d=!1,m=!1,g=!1,y="function"==typeof setTimeout?setTimeout:null,v="function"==typeof clearTimeout?clearTimeout:null,b="undefined"!=typeof setImmediate?setImmediate:null;function k(e){for(var t=r(c);null!==t;){if(null===t.callback)a(c);else{if(!(t.startTime<=e))break;a(c),t.sortIndex=t.expirationTime,n(u,t)}t=r(c)}}function x(e){if(g=!1,k(e),!m)if(null!==r(u))m=!0,F(S);else{var t=r(c);null!==t&&O(x,t.startTime-e)}}function S(e,n){m=!1,g&&(g=!1,v(_),_=-1),d=!0;var i=f;try{for(k(n),p=r(u);null!==p&&(!(p.expirationTime>n)||e&&!T());){var s=p.callback;if("function"==typeof s){p.callback=null,f=p.priorityLevel;var o=s(p.expirationTime<=n);n=t.unstable_now(),"function"==typeof o?p.callback=o:p===r(u)&&a(u),k(n)}else a(u);p=r(u)}if(null!==p)var l=!0;else{var h=r(c);null!==h&&O(x,h.startTime-n),l=!1}return l}finally{p=null,f=i,d=!1}}"undefined"!=typeof navigator&&void 0!==navigator.scheduling&&void 0!==navigator.scheduling.isInputPending&&navigator.scheduling.isInputPending.bind(navigator.scheduling);var w,E=!1,P=null,_=-1,C=5,A=-1;function T(){return!(t.unstable_now()-A<C)}function M(){if(null!==P){var e=t.unstable_now();A=e;var n=!0;try{n=P(!0,e)}finally{n?w():(E=!1,P=null)}}else E=!1}if("function"==typeof b)w=function(){b(M)};else if("undefined"!=typeof MessageChannel){var D=new MessageChannel,I=D.port2;D.port1.onmessage=M,w=function(){I.postMessage(null)}}else w=function(){y(M,0)};function F(e){P=e,E||(E=!0,w())}function O(e,n){_=y((function(){e(t.unstable_now())}),n)}t.unstable_IdlePriority=5,t.unstable_ImmediatePriority=1,t.unstable_LowPriority=4,t.unstable_NormalPriority=3,t.unstable_Profiling=null,t.unstable_UserBlockingPriority=2,t.unstable_cancelCallback=function(e){e.callback=null},t.unstable_continueExecution=function(){m||d||(m=!0,F(S))},t.unstable_forceFrameRate=function(e){0>e||125<e?console.error("forceFrameRate takes a positive int between 0 and 125, forcing frame rates higher than 125 fps is not supported"):C=0<e?Math.floor(1e3/e):5},t.unstable_getCurrentPriorityLevel=function(){return f},t.unstable_getFirstCallbackNode=function(){return r(u)},t.unstable_next=function(e){switch(f){case 1:case 2:case 3:var t=3;break;default:t=f}var n=f;f=t;try{return e()}finally{f=n}},t.unstable_pauseExecution=function(){},t.unstable_requestPaint=function(){},t.unstable_runWithPriority=function(e,t){switch(e){case 1:case 2:case 3:case 4:case 5:break;default:e=3}var n=f;f=e;try{return t()}finally{f=n}},t.unstable_scheduleCallback=function(e,a,i){var s=t.unstable_now();switch("object"==typeof i&&null!==i?i="number"==typeof(i=i.delay)&&0<i?s+i:s:i=s,e){case 1:var o=-1;break;case 2:o=250;break;case 5:o=1073741823;break;case 4:o=1e4;break;default:o=5e3}return e={id:h++,callback:a,priorityLevel:e,startTime:i,expirationTime:o=i+o,sortIndex:-1},i>s?(e.sortIndex=i,n(c,e),null===r(u)&&e===r(c)&&(g?(v(_),_=-1):g=!0,O(x,i-s))):(e.sortIndex=o,n(u,e),m||d||(m=!0,F(S))),e},t.unstable_shouldYield=T,t.unstable_wrapCallback=function(e){var t=f;return function(){var n=f;f=t;try{return e.apply(this,arguments)}finally{f=n}}}},3840:(e,t,n)=>{"use strict";e.exports=n(53)},3379:e=>{"use strict";var t=[];function n(e){for(var n=-1,r=0;r<t.length;r++)if(t[r].identifier===e){n=r;break}return n}function r(e,r){for(var i={},s=[],o=0;o<e.length;o++){var l=e[o],u=r.base?l[0]+r.base:l[0],c=i[u]||0,h="".concat(u," ").concat(c);i[u]=c+1;var p=n(h),f={css:l[1],media:l[2],sourceMap:l[3],supports:l[4],layer:l[5]};if(-1!==p)t[p].references++,t[p].updater(f);else{var d=a(f,r);r.byIndex=o,t.splice(o,0,{identifier:h,updater:d,references:1})}s.push(h)}return s}function a(e,t){var n=t.domAPI(t);n.update(e);return function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap&&t.supports===e.supports&&t.layer===e.layer)return;n.update(e=t)}else n.remove()}}e.exports=function(e,a){var i=r(e=e||[],a=a||{});return function(e){e=e||[];for(var s=0;s<i.length;s++){var o=n(i[s]);t[o].references--}for(var l=r(e,a),u=0;u<i.length;u++){var c=n(i[u]);0===t[c].references&&(t[c].updater(),t.splice(c,1))}i=l}}},569:e=>{"use strict";var t={};e.exports=function(e,n){var r=function(e){if(void 0===t[e]){var n=document.querySelector(e);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}t[e]=n}return t[e]}(e);if(!r)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");r.appendChild(n)}},9216:e=>{"use strict";e.exports=function(e){var t=document.createElement("style");return e.setAttributes(t,e.attributes),e.insert(t,e.options),t}},8575:e=>{"use strict";e.exports=function(e,t){Object.keys(t).forEach((function(n){e.setAttribute(n,t[n])}))}},7795:e=>{"use strict";e.exports=function(e){var t=e.insertStyleElement(e);return{update:function(n){!function(e,t,n){var r="";n.supports&&(r+="@supports (".concat(n.supports,") {")),n.media&&(r+="@media ".concat(n.media," {"));var a=void 0!==n.layer;a&&(r+="@layer".concat(n.layer.length>0?" ".concat(n.layer):""," {")),r+=n.css,a&&(r+="}"),n.media&&(r+="}"),n.supports&&(r+="}");var i=n.sourceMap;i&&"undefined"!=typeof btoa&&(r+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(i))))," */")),t.styleTagTransform(r,e,t.options)}(t,e,n)},remove:function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e)}(t)}}}},4589:e=>{"use strict";e.exports=function(e,t){if(t.styleSheet)t.styleSheet.cssText=e;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(e))}}},1739:e=>{e.exports={area:!0,base:!0,br:!0,col:!0,embed:!0,hr:!0,img:!0,input:!0,link:!0,meta:!0,param:!0,source:!0,track:!0,wbr:!0}},1942:(e,t,n)=>{"use strict";e.exports=n.p+"76319ed07df274653459.png"},8420:(e,t,n)=>{"use strict";e.exports=n.p+"5c970459e6839141139d.png"},3630:(e,t,n)=>{"use strict";e.exports=n.p+"b774f4633fe09bd8bd1f.svg"},3311:(e,t,n)=>{"use strict";e.exports=n.p+"a298a0ac59f09aeb64eb.otf"},1755:(e,t,n)=>{"use strict";e.exports=n.p+"b25893558c7f1ad49e5e.ttf"},3056:(e,t,n)=>{"use strict";e.exports=n.p+"0eebbdfb27d542c486ce.ttf"},1272:(e,t,n)=>{"use strict";e.exports=n.p+"2d0dbf42750207f78ffa.ttf"},6856:(e,t,n)=>{"use strict";e.exports=n.p+"ba5622550ada9b5ff2cd.ttf"},6297:(e,t,n)=>{"use strict";e.exports=n.p+"d3098ef471597fe3c2ed.svg"},1055:(e,t,n)=>{"use strict";e.exports=n.p+"0c52acad72ce84465d75.svg"},2063:(e,t,n)=>{"use strict";e.exports=n.p+"7c9b7ad743c021800b5f.png"},1016:(e,t,n)=>{"use strict";e.exports=n.p+"42ff001a8c225fc1a354.png"},1695:(e,t,n)=>{"use strict";e.exports=n.p+"587706f4d9807ac4bdf4.png"},6912:(e,t,n)=>{"use strict";e.exports=n.p+"0428c5c7e6c4bbf91f69.png"},903:(e,t,n)=>{"use strict";e.exports=n.p+"427fc33b09a5b15cc69c.png"},7061:(e,t,n)=>{var r=n(8698).default;function a(){"use strict";e.exports=a=function(){return t},e.exports.__esModule=!0,e.exports.default=e.exports;var t={},n=Object.prototype,i=n.hasOwnProperty,s=Object.defineProperty||function(e,t,n){e[t]=n.value},o="function"==typeof Symbol?Symbol:{},l=o.iterator||"@@iterator",u=o.asyncIterator||"@@asyncIterator",c=o.toStringTag||"@@toStringTag";function h(e,t,n){return Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}),e[t]}try{h({},"")}catch(e){h=function(e,t,n){return e[t]=n}}function p(e,t,n,r){var a=t&&t.prototype instanceof m?t:m,i=Object.create(a.prototype),o=new A(r||[]);return s(i,"_invoke",{value:E(e,n,o)}),i}function f(e,t,n){try{return{type:"normal",arg:e.call(t,n)}}catch(e){return{type:"throw",arg:e}}}t.wrap=p;var d={};function m(){}function g(){}function y(){}var v={};h(v,l,(function(){return this}));var b=Object.getPrototypeOf,k=b&&b(b(T([])));k&&k!==n&&i.call(k,l)&&(v=k);var x=y.prototype=m.prototype=Object.create(v);function S(e){["next","throw","return"].forEach((function(t){h(e,t,(function(e){return this._invoke(t,e)}))}))}function w(e,t){function n(a,s,o,l){var u=f(e[a],e,s);if("throw"!==u.type){var c=u.arg,h=c.value;return h&&"object"==r(h)&&i.call(h,"__await")?t.resolve(h.__await).then((function(e){n("next",e,o,l)}),(function(e){n("throw",e,o,l)})):t.resolve(h).then((function(e){c.value=e,o(c)}),(function(e){return n("throw",e,o,l)}))}l(u.arg)}var a;s(this,"_invoke",{value:function(e,r){function i(){return new t((function(t,a){n(e,r,t,a)}))}return a=a?a.then(i,i):i()}})}function E(e,t,n){var r="suspendedStart";return function(a,i){if("executing"===r)throw new Error("Generator is already running");if("completed"===r){if("throw"===a)throw i;return M()}for(n.method=a,n.arg=i;;){var s=n.delegate;if(s){var o=P(s,n);if(o){if(o===d)continue;return o}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===r)throw r="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);r="executing";var l=f(e,t,n);if("normal"===l.type){if(r=n.done?"completed":"suspendedYield",l.arg===d)continue;return{value:l.arg,done:n.done}}"throw"===l.type&&(r="completed",n.method="throw",n.arg=l.arg)}}}function P(e,t){var n=t.method,r=e.iterator[n];if(void 0===r)return t.delegate=null,"throw"===n&&e.iterator.return&&(t.method="return",t.arg=void 0,P(e,t),"throw"===t.method)||"return"!==n&&(t.method="throw",t.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var a=f(r,e.iterator,t.arg);if("throw"===a.type)return t.method="throw",t.arg=a.arg,t.delegate=null,d;var i=a.arg;return i?i.done?(t[e.resultName]=i.value,t.next=e.nextLoc,"return"!==t.method&&(t.method="next",t.arg=void 0),t.delegate=null,d):i:(t.method="throw",t.arg=new TypeError("iterator result is not an object"),t.delegate=null,d)}function _(e){var t={tryLoc:e[0]};1 in e&&(t.catchLoc=e[1]),2 in e&&(t.finallyLoc=e[2],t.afterLoc=e[3]),this.tryEntries.push(t)}function C(e){var t=e.completion||{};t.type="normal",delete t.arg,e.completion=t}function A(e){this.tryEntries=[{tryLoc:"root"}],e.forEach(_,this),this.reset(!0)}function T(e){if(e){var t=e[l];if(t)return t.call(e);if("function"==typeof e.next)return e;if(!isNaN(e.length)){var n=-1,r=function t(){for(;++n<e.length;)if(i.call(e,n))return t.value=e[n],t.done=!1,t;return t.value=void 0,t.done=!0,t};return r.next=r}}return{next:M}}function M(){return{value:void 0,done:!0}}return g.prototype=y,s(x,"constructor",{value:y,configurable:!0}),s(y,"constructor",{value:g,configurable:!0}),g.displayName=h(y,c,"GeneratorFunction"),t.isGeneratorFunction=function(e){var t="function"==typeof e&&e.constructor;return!!t&&(t===g||"GeneratorFunction"===(t.displayName||t.name))},t.mark=function(e){return Object.setPrototypeOf?Object.setPrototypeOf(e,y):(e.__proto__=y,h(e,c,"GeneratorFunction")),e.prototype=Object.create(x),e},t.awrap=function(e){return{__await:e}},S(w.prototype),h(w.prototype,u,(function(){return this})),t.AsyncIterator=w,t.async=function(e,n,r,a,i){void 0===i&&(i=Promise);var s=new w(p(e,n,r,a),i);return t.isGeneratorFunction(n)?s:s.next().then((function(e){return e.done?e.value:s.next()}))},S(x),h(x,c,"Generator"),h(x,l,(function(){return this})),h(x,"toString",(function(){return"[object Generator]"})),t.keys=function(e){var t=Object(e),n=[];for(var r in t)n.push(r);return n.reverse(),function e(){for(;n.length;){var r=n.pop();if(r in t)return e.value=r,e.done=!1,e}return e.done=!0,e}},t.values=T,A.prototype={constructor:A,reset:function(e){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(C),!e)for(var t in this)"t"===t.charAt(0)&&i.call(this,t)&&!isNaN(+t.slice(1))&&(this[t]=void 0)},stop:function(){this.done=!0;var e=this.tryEntries[0].completion;if("throw"===e.type)throw e.arg;return this.rval},dispatchException:function(e){if(this.done)throw e;var t=this;function n(n,r){return s.type="throw",s.arg=e,t.next=n,r&&(t.method="next",t.arg=void 0),!!r}for(var r=this.tryEntries.length-1;r>=0;--r){var a=this.tryEntries[r],s=a.completion;if("root"===a.tryLoc)return n("end");if(a.tryLoc<=this.prev){var o=i.call(a,"catchLoc"),l=i.call(a,"finallyLoc");if(o&&l){if(this.prev<a.catchLoc)return n(a.catchLoc,!0);if(this.prev<a.finallyLoc)return n(a.finallyLoc)}else if(o){if(this.prev<a.catchLoc)return n(a.catchLoc,!0)}else{if(!l)throw new Error("try statement without catch or finally");if(this.prev<a.finallyLoc)return n(a.finallyLoc)}}}},abrupt:function(e,t){for(var n=this.tryEntries.length-1;n>=0;--n){var r=this.tryEntries[n];if(r.tryLoc<=this.prev&&i.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var a=r;break}}a&&("break"===e||"continue"===e)&&a.tryLoc<=t&&t<=a.finallyLoc&&(a=null);var s=a?a.completion:{};return s.type=e,s.arg=t,a?(this.method="next",this.next=a.finallyLoc,d):this.complete(s)},complete:function(e,t){if("throw"===e.type)throw e.arg;return"break"===e.type||"continue"===e.type?this.next=e.arg:"return"===e.type?(this.rval=this.arg=e.arg,this.method="return",this.next="end"):"normal"===e.type&&t&&(this.next=t),d},finish:function(e){for(var t=this.tryEntries.length-1;t>=0;--t){var n=this.tryEntries[t];if(n.finallyLoc===e)return this.complete(n.completion,n.afterLoc),C(n),d}},catch:function(e){for(var t=this.tryEntries.length-1;t>=0;--t){var n=this.tryEntries[t];if(n.tryLoc===e){var r=n.completion;if("throw"===r.type){var a=r.arg;C(n)}return a}}throw new Error("illegal catch attempt")},delegateYield:function(e,t,n){return this.delegate={iterator:T(e),resultName:t,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}e.exports=a,e.exports.__esModule=!0,e.exports.default=e.exports},8698:e=>{function t(n){return e.exports=t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},e.exports.__esModule=!0,e.exports.default=e.exports,t(n)}e.exports=t,e.exports.__esModule=!0,e.exports.default=e.exports},4687:(e,t,n)=>{var r=n(7061)();e.exports=r;try{regeneratorRuntime=r}catch(e){"object"==typeof globalThis?globalThis.regeneratorRuntime=r:Function("r","regeneratorRuntime = r")(r)}}},__webpack_module_cache__={};function __webpack_require__(e){var t=__webpack_module_cache__[e];if(void 0!==t)return t.exports;var n=__webpack_module_cache__[e]={id:e,exports:{}};return __webpack_modules__[e].call(n.exports,n,n.exports,__webpack_require__),n.exports}__webpack_require__.m=__webpack_modules__,__webpack_require__.amdO={},__webpack_require__.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=(e,t)=>{for(var n in t)__webpack_require__.o(t,n)&&!__webpack_require__.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),(()=>{var e;__webpack_require__.g.importScripts&&(e=__webpack_require__.g.location+"");var t=__webpack_require__.g.document;if(!e&&t&&(t.currentScript&&(e=t.currentScript.src),!e)){var n=t.getElementsByTagName("script");n.length&&(e=n[n.length-1].src)}if(!e)throw new Error("Automatic publicPath is not supported in this browser");e=e.replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),__webpack_require__.p=e})(),__webpack_require__.b=document.baseURI||self.location.href;var __webpack_exports__={};(()=>{"use strict";function e(e,t,n,r,a,i,s){try{var o=e[i](s),l=o.value}catch(e){return void n(e)}o.done?t(l):Promise.resolve(l).then(r,a)}function t(t){return function(){var n=this,r=arguments;return new Promise((function(a,i){var s=t.apply(n,r);function o(t){e(s,a,i,o,l,"next",t)}function l(t){e(s,a,i,o,l,"throw",t)}o(void 0)}))}}function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}function a(e){var t=function(e,t){if("object"!==r(e)||null===e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var a=n.call(e,t||"default");if("object"!==r(a))return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"===r(t)?t:String(t)}function i(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,a(r.key),r)}}function s(e,t,n){return t&&i(e.prototype,t),n&&i(e,n),Object.defineProperty(e,"prototype",{writable:!1}),e}function o(e,t){return o=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e},o(e,t)}function l(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&o(e,t)}function u(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function c(e,t){if(t&&("object"===r(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return u(e)}function h(e){return h=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)},h(e)}function p(e){if(Array.isArray(e))return e}function f(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function d(e,t){if(e){if("string"==typeof e)return f(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?f(e,t):void 0}}function m(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function g(e,t){return p(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var r,a,i,s,o=[],l=!0,u=!1;try{if(i=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;l=!1}else for(;!(l=(r=i.call(n)).done)&&(o.push(r.value),o.length!==t);l=!0);}catch(e){u=!0,a=e}finally{try{if(!l&&null!=n.return&&(s=n.return(),Object(s)!==s))return}finally{if(u)throw a}}return o}}(e,t)||d(e,t)||m()}__webpack_require__.d(__webpack_exports__,{W:()=>Za});var y=__webpack_require__(4687),v=__webpack_require__.n(y),b=__webpack_require__(7294),k=__webpack_require__(745);function x(e,t,n){return(t=a(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function S(e){return p(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||d(e)||m()}function w(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function E(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?w(Object(n),!0).forEach((function(t){x(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):w(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}var P={type:"logger",log:function(e){this.output("log",e)},warn:function(e){this.output("warn",e)},error:function(e){this.output("error",e)},output:function(e,t){console&&console[e]&&console[e].apply(console,t)}},_=function(){function e(t){var r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};n(this,e),this.init(t,r)}return s(e,[{key:"init",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.prefix=t.prefix||"i18next:",this.logger=e||P,this.options=t,this.debug=t.debug}},{key:"setDebug",value:function(e){this.debug=e}},{key:"log",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.forward(t,"log","",!0)}},{key:"warn",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.forward(t,"warn","",!0)}},{key:"error",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.forward(t,"error","")}},{key:"deprecate",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.forward(t,"warn","WARNING DEPRECATED: ",!0)}},{key:"forward",value:function(e,t,n,r){return r&&!this.debug?null:("string"==typeof e[0]&&(e[0]="".concat(n).concat(this.prefix," ").concat(e[0])),this.logger[t](e))}},{key:"create",value:function(t){return new e(this.logger,E(E({},{prefix:"".concat(this.prefix,":").concat(t,":")}),this.options))}},{key:"clone",value:function(t){return(t=t||this.options).prefix=t.prefix||this.prefix,new e(this.logger,t)}}]),e}(),C=new _,A=function(){function e(){n(this,e),this.observers={}}return s(e,[{key:"on",value:function(e,t){var n=this;return e.split(" ").forEach((function(e){n.observers[e]=n.observers[e]||[],n.observers[e].push(t)})),this}},{key:"off",value:function(e,t){this.observers[e]&&(t?this.observers[e]=this.observers[e].filter((function(e){return e!==t})):delete this.observers[e])}},{key:"emit",value:function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];this.observers[e]&&[].concat(this.observers[e]).forEach((function(e){e.apply(void 0,n)}));this.observers["*"]&&[].concat(this.observers["*"]).forEach((function(t){t.apply(t,[e].concat(n))}))}}]),e}();function T(){var e,t,n=new Promise((function(n,r){e=n,t=r}));return n.resolve=e,n.reject=t,n}function M(e){return null==e?"":""+e}function D(e,t,n){function r(e){return e&&e.indexOf("###")>-1?e.replace(/###/g,"."):e}function a(){return!e||"string"==typeof e}for(var i="string"!=typeof t?[].concat(t):t.split(".");i.length>1;){if(a())return{};var s=r(i.shift());!e[s]&&n&&(e[s]=new n),e=Object.prototype.hasOwnProperty.call(e,s)?e[s]:{}}return a()?{}:{obj:e,k:r(i.shift())}}function I(e,t,n){var r=D(e,t,Object);r.obj[r.k]=n}function F(e,t){var n=D(e,t),r=n.obj,a=n.k;if(r)return r[a]}function O(e,t,n){var r=F(e,n);return void 0!==r?r:F(t,n)}function R(e,t,n){for(var r in t)"__proto__"!==r&&"constructor"!==r&&(r in e?"string"==typeof e[r]||e[r]instanceof String||"string"==typeof t[r]||t[r]instanceof String?n&&(e[r]=t[r]):R(e[r],t[r],n):e[r]=t[r]);return e}function L(e){return e.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")}var N={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};function V(e){return"string"==typeof e?e.replace(/[&<>"'\/]/g,(function(e){return N[e]})):e}var B="undefined"!=typeof window&&window.navigator&&void 0===window.navigator.userAgentData&&window.navigator.userAgent&&window.navigator.userAgent.indexOf("MSIE")>-1,z=[" ",",","?","!",";"];function j(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function G(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?j(Object(n),!0).forEach((function(t){x(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):j(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function H(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var n,r=h(e);if(t){var a=h(this).constructor;n=Reflect.construct(r,arguments,a)}else n=r.apply(this,arguments);return c(this,n)}}function q(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:".";if(e){if(e[t])return e[t];for(var r=t.split(n),a=e,i=0;i<r.length;++i){if(!a)return;if("string"==typeof a[r[i]]&&i+1<r.length)return;if(void 0===a[r[i]]){for(var s=2,o=r.slice(i,i+s).join(n),l=a[o];void 0===l&&r.length>i+s;)s++,l=a[o=r.slice(i,i+s).join(n)];if(void 0===l)return;if(null===l)return null;if(t.endsWith(o)){if("string"==typeof l)return l;if(o&&"string"==typeof l[o])return l[o]}var u=r.slice(i+s).join(n);return u?q(l,u,n):void 0}a=a[r[i]]}return a}}var U=function(e){l(r,e);var t=H(r);function r(e){var a,i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{ns:["translation"],defaultNS:"translation"};return n(this,r),a=t.call(this),B&&A.call(u(a)),a.data=e||{},a.options=i,void 0===a.options.keySeparator&&(a.options.keySeparator="."),void 0===a.options.ignoreJSONStructure&&(a.options.ignoreJSONStructure=!0),a}return s(r,[{key:"addNamespaces",value:function(e){this.options.ns.indexOf(e)<0&&this.options.ns.push(e)}},{key:"removeNamespaces",value:function(e){var t=this.options.ns.indexOf(e);t>-1&&this.options.ns.splice(t,1)}},{key:"getResource",value:function(e,t,n){var r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},a=void 0!==r.keySeparator?r.keySeparator:this.options.keySeparator,i=void 0!==r.ignoreJSONStructure?r.ignoreJSONStructure:this.options.ignoreJSONStructure,s=[e,t];n&&"string"!=typeof n&&(s=s.concat(n)),n&&"string"==typeof n&&(s=s.concat(a?n.split(a):n)),e.indexOf(".")>-1&&(s=e.split("."));var o=F(this.data,s);return o||!i||"string"!=typeof n?o:q(this.data&&this.data[e]&&this.data[e][t],n,a)}},{key:"addResource",value:function(e,t,n,r){var a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:{silent:!1},i=this.options.keySeparator;void 0===i&&(i=".");var s=[e,t];n&&(s=s.concat(i?n.split(i):n)),e.indexOf(".")>-1&&(r=t,t=(s=e.split("."))[1]),this.addNamespaces(t),I(this.data,s,r),a.silent||this.emit("added",e,t,n,r)}},{key:"addResources",value:function(e,t,n){var r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{silent:!1};for(var a in n)"string"!=typeof n[a]&&"[object Array]"!==Object.prototype.toString.apply(n[a])||this.addResource(e,t,a,n[a],{silent:!0});r.silent||this.emit("added",e,t,n)}},{key:"addResourceBundle",value:function(e,t,n,r,a){var i=arguments.length>5&&void 0!==arguments[5]?arguments[5]:{silent:!1},s=[e,t];e.indexOf(".")>-1&&(r=n,n=t,t=(s=e.split("."))[1]),this.addNamespaces(t);var o=F(this.data,s)||{};r?R(o,n,a):o=G(G({},o),n),I(this.data,s,o),i.silent||this.emit("added",e,t,n)}},{key:"removeResourceBundle",value:function(e,t){this.hasResourceBundle(e,t)&&delete this.data[e][t],this.removeNamespaces(t),this.emit("removed",e,t)}},{key:"hasResourceBundle",value:function(e,t){return void 0!==this.getResource(e,t)}},{key:"getResourceBundle",value:function(e,t){return t||(t=this.options.defaultNS),"v1"===this.options.compatibilityAPI?G(G({},{}),this.getResource(e,t)):this.getResource(e,t)}},{key:"getDataByLanguage",value:function(e){return this.data[e]}},{key:"hasLanguageSomeTranslations",value:function(e){var t=this.getDataByLanguage(e);return!!(t&&Object.keys(t)||[]).find((function(e){return t[e]&&Object.keys(t[e]).length>0}))}},{key:"toJSON",value:function(){return this.data}}]),r}(A),W={processors:{},addPostProcessor:function(e){this.processors[e.name]=e},handle:function(e,t,n,r,a){var i=this;return e.forEach((function(e){i.processors[e]&&(t=i.processors[e].process(t,n,r,a))})),t}};function $(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function K(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?$(Object(n),!0).forEach((function(t){x(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):$(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function J(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var n,r=h(e);if(t){var a=h(this).constructor;n=Reflect.construct(r,arguments,a)}else n=r.apply(this,arguments);return c(this,n)}}var Y={},Q=function(e){l(a,e);var t=J(a);function a(e){var r,i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return n(this,a),r=t.call(this),B&&A.call(u(r)),function(e,t,n){e.forEach((function(e){t[e]&&(n[e]=t[e])}))}(["resourceStore","languageUtils","pluralResolver","interpolator","backendConnector","i18nFormat","utils"],e,u(r)),r.options=i,void 0===r.options.keySeparator&&(r.options.keySeparator="."),r.logger=C.create("translator"),r}return s(a,[{key:"changeLanguage",value:function(e){e&&(this.language=e)}},{key:"exists",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{interpolation:{}};if(null==e)return!1;var n=this.resolve(e,t);return n&&void 0!==n.res}},{key:"extractFromKey",value:function(e,t){var n=void 0!==t.nsSeparator?t.nsSeparator:this.options.nsSeparator;void 0===n&&(n=":");var r=void 0!==t.keySeparator?t.keySeparator:this.options.keySeparator,a=t.ns||this.options.defaultNS||[],i=n&&e.indexOf(n)>-1,s=!(this.options.userDefinedKeySeparator||t.keySeparator||this.options.userDefinedNsSeparator||t.nsSeparator||function(e,t,n){t=t||"",n=n||"";var r=z.filter((function(e){return t.indexOf(e)<0&&n.indexOf(e)<0}));if(0===r.length)return!0;var a=new RegExp("(".concat(r.map((function(e){return"?"===e?"\\?":e})).join("|"),")")),i=!a.test(e);if(!i){var s=e.indexOf(n);s>0&&!a.test(e.substring(0,s))&&(i=!0)}return i}(e,n,r));if(i&&!s){var o=e.match(this.interpolator.nestingRegexp);if(o&&o.length>0)return{key:e,namespaces:a};var l=e.split(n);(n!==r||n===r&&this.options.ns.indexOf(l[0])>-1)&&(a=l.shift()),e=l.join(r)}return"string"==typeof a&&(a=[a]),{key:e,namespaces:a}}},{key:"translate",value:function(e,t,n){var i=this;if("object"!==r(t)&&this.options.overloadTranslationOptionHandler&&(t=this.options.overloadTranslationOptionHandler(arguments)),t||(t={}),null==e)return"";Array.isArray(e)||(e=[String(e)]);var s=void 0!==t.returnDetails?t.returnDetails:this.options.returnDetails,o=void 0!==t.keySeparator?t.keySeparator:this.options.keySeparator,l=this.extractFromKey(e[e.length-1],t),u=l.key,c=l.namespaces,h=c[c.length-1],p=t.lng||this.language,f=t.appendNamespaceToCIMode||this.options.appendNamespaceToCIMode;if(p&&"cimode"===p.toLowerCase()){if(f){var d=t.nsSeparator||this.options.nsSeparator;return s?(m.res="".concat(h).concat(d).concat(u),m):"".concat(h).concat(d).concat(u)}return s?(m.res=u,m):u}var m=this.resolve(e,t),g=m&&m.res,y=m&&m.usedKey||u,v=m&&m.exactUsedKey||u,b=Object.prototype.toString.apply(g),k=void 0!==t.joinArrays?t.joinArrays:this.options.joinArrays,x=!this.i18nFormat||this.i18nFormat.handleAsObject;if(x&&g&&("string"!=typeof g&&"boolean"!=typeof g&&"number"!=typeof g)&&["[object Number]","[object Function]","[object RegExp]"].indexOf(b)<0&&("string"!=typeof k||"[object Array]"!==b)){if(!t.returnObjects&&!this.options.returnObjects){this.options.returnedObjectHandler||this.logger.warn("accessing an object - but returnObjects options is not enabled!");var S=this.options.returnedObjectHandler?this.options.returnedObjectHandler(y,g,K(K({},t),{},{ns:c})):"key '".concat(u," (").concat(this.language,")' returned an object instead of string.");return s?(m.res=S,m):S}if(o){var w="[object Array]"===b,E=w?[]:{},P=w?v:y;for(var _ in g)if(Object.prototype.hasOwnProperty.call(g,_)){var C="".concat(P).concat(o).concat(_);E[_]=this.translate(C,K(K({},t),{joinArrays:!1,ns:c})),E[_]===C&&(E[_]=g[_])}g=E}}else if(x&&"string"==typeof k&&"[object Array]"===b)(g=g.join(k))&&(g=this.extendTranslation(g,e,t,n));else{var A=!1,T=!1,M=void 0!==t.count&&"string"!=typeof t.count,D=a.hasDefaultValue(t),I=M?this.pluralResolver.getSuffix(p,t.count,t):"",F=t["defaultValue".concat(I)]||t.defaultValue;!this.isValidLookup(g)&&D&&(A=!0,g=F),this.isValidLookup(g)||(T=!0,g=u);var O=(t.missingKeyNoValueFallbackToKey||this.options.missingKeyNoValueFallbackToKey)&&T?void 0:g,R=D&&F!==g&&this.options.updateMissing;if(T||A||R){if(this.logger.log(R?"updateKey":"missingKey",p,h,u,R?F:g),o){var L=this.resolve(u,K(K({},t),{},{keySeparator:!1}));L&&L.res&&this.logger.warn("Seems the loaded translations were in flat JSON format instead of nested. Either set keySeparator: false on init or make sure your translations are published in nested format.")}var N=[],V=this.languageUtils.getFallbackCodes(this.options.fallbackLng,t.lng||this.language);if("fallback"===this.options.saveMissingTo&&V&&V[0])for(var B=0;B<V.length;B++)N.push(V[B]);else"all"===this.options.saveMissingTo?N=this.languageUtils.toResolveHierarchy(t.lng||this.language):N.push(t.lng||this.language);var z=function(e,n,r){var a=D&&r!==g?r:O;i.options.missingKeyHandler?i.options.missingKeyHandler(e,h,n,a,R,t):i.backendConnector&&i.backendConnector.saveMissing&&i.backendConnector.saveMissing(e,h,n,a,R,t),i.emit("missingKey",e,h,n,g)};this.options.saveMissing&&(this.options.saveMissingPlurals&&M?N.forEach((function(e){i.pluralResolver.getSuffixes(e,t).forEach((function(n){z([e],u+n,t["defaultValue".concat(n)]||F)}))})):z(N,u,F))}g=this.extendTranslation(g,e,t,m,n),T&&g===u&&this.options.appendNamespaceToMissingKey&&(g="".concat(h,":").concat(u)),(T||A)&&this.options.parseMissingKeyHandler&&(g="v1"!==this.options.compatibilityAPI?this.options.parseMissingKeyHandler(this.options.appendNamespaceToMissingKey?"".concat(h,":").concat(u):u,A?g:void 0):this.options.parseMissingKeyHandler(g))}return s?(m.res=g,m):g}},{key:"extendTranslation",value:function(e,t,n,r,a){var i=this;if(this.i18nFormat&&this.i18nFormat.parse)e=this.i18nFormat.parse(e,K(K({},this.options.interpolation.defaultVariables),n),r.usedLng,r.usedNS,r.usedKey,{resolved:r});else if(!n.skipInterpolation){n.interpolation&&this.interpolator.init(K(K({},n),{interpolation:K(K({},this.options.interpolation),n.interpolation)}));var s,o="string"==typeof e&&(n&&n.interpolation&&void 0!==n.interpolation.skipOnVariables?n.interpolation.skipOnVariables:this.options.interpolation.skipOnVariables);if(o){var l=e.match(this.interpolator.nestingRegexp);s=l&&l.length}var u=n.replace&&"string"!=typeof n.replace?n.replace:n;if(this.options.interpolation.defaultVariables&&(u=K(K({},this.options.interpolation.defaultVariables),u)),e=this.interpolator.interpolate(e,u,n.lng||this.language,n),o){var c=e.match(this.interpolator.nestingRegexp);s<(c&&c.length)&&(n.nest=!1)}!1!==n.nest&&(e=this.interpolator.nest(e,(function(){for(var e=arguments.length,r=new Array(e),s=0;s<e;s++)r[s]=arguments[s];return a&&a[0]===r[0]&&!n.context?(i.logger.warn("It seems you are nesting recursively key: ".concat(r[0]," in key: ").concat(t[0])),null):i.translate.apply(i,r.concat([t]))}),n)),n.interpolation&&this.interpolator.reset()}var h=n.postProcess||this.options.postProcess,p="string"==typeof h?[h]:h;return null!=e&&p&&p.length&&!1!==n.applyPostProcessor&&(e=W.handle(p,e,t,this.options&&this.options.postProcessPassResolved?K({i18nResolved:r},n):n,this)),e}},{key:"resolve",value:function(e){var t,n,r,a,i,s=this,o=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return"string"==typeof e&&(e=[e]),e.forEach((function(e){if(!s.isValidLookup(t)){var l=s.extractFromKey(e,o),u=l.key;n=u;var c=l.namespaces;s.options.fallbackNS&&(c=c.concat(s.options.fallbackNS));var h=void 0!==o.count&&"string"!=typeof o.count,p=h&&!o.ordinal&&0===o.count&&s.pluralResolver.shouldUseIntlApi(),f=void 0!==o.context&&("string"==typeof o.context||"number"==typeof o.context)&&""!==o.context,d=o.lngs?o.lngs:s.languageUtils.toResolveHierarchy(o.lng||s.language,o.fallbackLng);c.forEach((function(e){s.isValidLookup(t)||(i=e,!Y["".concat(d[0],"-").concat(e)]&&s.utils&&s.utils.hasLoadedNamespace&&!s.utils.hasLoadedNamespace(i)&&(Y["".concat(d[0],"-").concat(e)]=!0,s.logger.warn('key "'.concat(n,'" for languages "').concat(d.join(", "),'" won\'t get resolved as namespace "').concat(i,'" was not yet loaded'),"This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!")),d.forEach((function(n){if(!s.isValidLookup(t)){a=n;var i,l=[u];if(s.i18nFormat&&s.i18nFormat.addLookupKeys)s.i18nFormat.addLookupKeys(l,u,n,e,o);else{var c;h&&(c=s.pluralResolver.getSuffix(n,o.count,o));var d="".concat(s.options.pluralSeparator,"zero");if(h&&(l.push(u+c),p&&l.push(u+d)),f){var m="".concat(u).concat(s.options.contextSeparator).concat(o.context);l.push(m),h&&(l.push(m+c),p&&l.push(m+d))}}for(;i=l.pop();)s.isValidLookup(t)||(r=i,t=s.getResource(n,e,i,o))}})))}))}})),{res:t,usedKey:n,exactUsedKey:r,usedLng:a,usedNS:i}}},{key:"isValidLookup",value:function(e){return!(void 0===e||!this.options.returnNull&&null===e||!this.options.returnEmptyString&&""===e)}},{key:"getResource",value:function(e,t,n){var r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};return this.i18nFormat&&this.i18nFormat.getResource?this.i18nFormat.getResource(e,t,n,r):this.resourceStore.getResource(e,t,n,r)}}],[{key:"hasDefaultValue",value:function(e){var t="defaultValue";for(var n in e)if(Object.prototype.hasOwnProperty.call(e,n)&&t===n.substring(0,t.length)&&void 0!==e[n])return!0;return!1}}]),a}(A);function X(e){return e.charAt(0).toUpperCase()+e.slice(1)}var Z=function(){function e(t){n(this,e),this.options=t,this.supportedLngs=this.options.supportedLngs||!1,this.logger=C.create("languageUtils")}return s(e,[{key:"getScriptPartFromCode",value:function(e){if(!e||e.indexOf("-")<0)return null;var t=e.split("-");return 2===t.length?null:(t.pop(),"x"===t[t.length-1].toLowerCase()?null:this.formatLanguageCode(t.join("-")))}},{key:"getLanguagePartFromCode",value:function(e){if(!e||e.indexOf("-")<0)return e;var t=e.split("-");return this.formatLanguageCode(t[0])}},{key:"formatLanguageCode",value:function(e){if("string"==typeof e&&e.indexOf("-")>-1){var t=["hans","hant","latn","cyrl","cans","mong","arab"],n=e.split("-");return this.options.lowerCaseLng?n=n.map((function(e){return e.toLowerCase()})):2===n.length?(n[0]=n[0].toLowerCase(),n[1]=n[1].toUpperCase(),t.indexOf(n[1].toLowerCase())>-1&&(n[1]=X(n[1].toLowerCase()))):3===n.length&&(n[0]=n[0].toLowerCase(),2===n[1].length&&(n[1]=n[1].toUpperCase()),"sgn"!==n[0]&&2===n[2].length&&(n[2]=n[2].toUpperCase()),t.indexOf(n[1].toLowerCase())>-1&&(n[1]=X(n[1].toLowerCase())),t.indexOf(n[2].toLowerCase())>-1&&(n[2]=X(n[2].toLowerCase()))),n.join("-")}return this.options.cleanCode||this.options.lowerCaseLng?e.toLowerCase():e}},{key:"isSupportedCode",value:function(e){return("languageOnly"===this.options.load||this.options.nonExplicitSupportedLngs)&&(e=this.getLanguagePartFromCode(e)),!this.supportedLngs||!this.supportedLngs.length||this.supportedLngs.indexOf(e)>-1}},{key:"getBestMatchFromCodes",value:function(e){var t,n=this;return e?(e.forEach((function(e){if(!t){var r=n.formatLanguageCode(e);n.options.supportedLngs&&!n.isSupportedCode(r)||(t=r)}})),!t&&this.options.supportedLngs&&e.forEach((function(e){if(!t){var r=n.getLanguagePartFromCode(e);if(n.isSupportedCode(r))return t=r;t=n.options.supportedLngs.find((function(e){if(0===e.indexOf(r))return e}))}})),t||(t=this.getFallbackCodes(this.options.fallbackLng)[0]),t):null}},{key:"getFallbackCodes",value:function(e,t){if(!e)return[];if("function"==typeof e&&(e=e(t)),"string"==typeof e&&(e=[e]),"[object Array]"===Object.prototype.toString.apply(e))return e;if(!t)return e.default||[];var n=e[t];return n||(n=e[this.getScriptPartFromCode(t)]),n||(n=e[this.formatLanguageCode(t)]),n||(n=e[this.getLanguagePartFromCode(t)]),n||(n=e.default),n||[]}},{key:"toResolveHierarchy",value:function(e,t){var n=this,r=this.getFallbackCodes(t||this.options.fallbackLng||[],e),a=[],i=function(e){e&&(n.isSupportedCode(e)?a.push(e):n.logger.warn("rejecting language code not found in supportedLngs: ".concat(e)))};return"string"==typeof e&&e.indexOf("-")>-1?("languageOnly"!==this.options.load&&i(this.formatLanguageCode(e)),"languageOnly"!==this.options.load&&"currentOnly"!==this.options.load&&i(this.getScriptPartFromCode(e)),"currentOnly"!==this.options.load&&i(this.getLanguagePartFromCode(e))):"string"==typeof e&&i(this.formatLanguageCode(e)),r.forEach((function(e){a.indexOf(e)<0&&i(n.formatLanguageCode(e))})),a}}]),e}(),ee=[{lngs:["ach","ak","am","arn","br","fil","gun","ln","mfe","mg","mi","oc","pt","pt-BR","tg","tl","ti","tr","uz","wa"],nr:[1,2],fc:1},{lngs:["af","an","ast","az","bg","bn","ca","da","de","dev","el","en","eo","es","et","eu","fi","fo","fur","fy","gl","gu","ha","hi","hu","hy","ia","it","kk","kn","ku","lb","mai","ml","mn","mr","nah","nap","nb","ne","nl","nn","no","nso","pa","pap","pms","ps","pt-PT","rm","sco","se","si","so","son","sq","sv","sw","ta","te","tk","ur","yo"],nr:[1,2],fc:2},{lngs:["ay","bo","cgg","fa","ht","id","ja","jbo","ka","km","ko","ky","lo","ms","sah","su","th","tt","ug","vi","wo","zh"],nr:[1],fc:3},{lngs:["be","bs","cnr","dz","hr","ru","sr","uk"],nr:[1,2,5],fc:4},{lngs:["ar"],nr:[0,1,2,3,11,100],fc:5},{lngs:["cs","sk"],nr:[1,2,5],fc:6},{lngs:["csb","pl"],nr:[1,2,5],fc:7},{lngs:["cy"],nr:[1,2,3,8],fc:8},{lngs:["fr"],nr:[1,2],fc:9},{lngs:["ga"],nr:[1,2,3,7,11],fc:10},{lngs:["gd"],nr:[1,2,3,20],fc:11},{lngs:["is"],nr:[1,2],fc:12},{lngs:["jv"],nr:[0,1],fc:13},{lngs:["kw"],nr:[1,2,3,4],fc:14},{lngs:["lt"],nr:[1,2,10],fc:15},{lngs:["lv"],nr:[1,2,0],fc:16},{lngs:["mk"],nr:[1,2],fc:17},{lngs:["mnk"],nr:[0,1,2],fc:18},{lngs:["mt"],nr:[1,2,11,20],fc:19},{lngs:["or"],nr:[2,1],fc:2},{lngs:["ro"],nr:[1,2,20],fc:20},{lngs:["sl"],nr:[5,1,2,3],fc:21},{lngs:["he","iw"],nr:[1,2,20,21],fc:22}],te={1:function(e){return Number(e>1)},2:function(e){return Number(1!=e)},3:function(e){return 0},4:function(e){return Number(e%10==1&&e%100!=11?0:e%10>=2&&e%10<=4&&(e%100<10||e%100>=20)?1:2)},5:function(e){return Number(0==e?0:1==e?1:2==e?2:e%100>=3&&e%100<=10?3:e%100>=11?4:5)},6:function(e){return Number(1==e?0:e>=2&&e<=4?1:2)},7:function(e){return Number(1==e?0:e%10>=2&&e%10<=4&&(e%100<10||e%100>=20)?1:2)},8:function(e){return Number(1==e?0:2==e?1:8!=e&&11!=e?2:3)},9:function(e){return Number(e>=2)},10:function(e){return Number(1==e?0:2==e?1:e<7?2:e<11?3:4)},11:function(e){return Number(1==e||11==e?0:2==e||12==e?1:e>2&&e<20?2:3)},12:function(e){return Number(e%10!=1||e%100==11)},13:function(e){return Number(0!==e)},14:function(e){return Number(1==e?0:2==e?1:3==e?2:3)},15:function(e){return Number(e%10==1&&e%100!=11?0:e%10>=2&&(e%100<10||e%100>=20)?1:2)},16:function(e){return Number(e%10==1&&e%100!=11?0:0!==e?1:2)},17:function(e){return Number(1==e||e%10==1&&e%100!=11?0:1)},18:function(e){return Number(0==e?0:1==e?1:2)},19:function(e){return Number(1==e?0:0==e||e%100>1&&e%100<11?1:e%100>10&&e%100<20?2:3)},20:function(e){return Number(1==e?0:0==e||e%100>0&&e%100<20?1:2)},21:function(e){return Number(e%100==1?1:e%100==2?2:e%100==3||e%100==4?3:0)},22:function(e){return Number(1==e?0:2==e?1:(e<0||e>10)&&e%10==0?2:3)}},ne=["v1","v2","v3"],re={zero:0,one:1,two:2,few:3,many:4,other:5};var ae=function(){function e(t){var r,a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};n(this,e),this.languageUtils=t,this.options=a,this.logger=C.create("pluralResolver"),this.options.compatibilityJSON&&"v4"!==this.options.compatibilityJSON||"undefined"!=typeof Intl&&Intl.PluralRules||(this.options.compatibilityJSON="v3",this.logger.error("Your environment seems not to be Intl API compatible, use an Intl.PluralRules polyfill. Will fallback to the compatibilityJSON v3 format handling.")),this.rules=(r={},ee.forEach((function(e){e.lngs.forEach((function(t){r[t]={numbers:e.nr,plurals:te[e.fc]}}))})),r)}return s(e,[{key:"addRule",value:function(e,t){this.rules[e]=t}},{key:"getRule",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(this.shouldUseIntlApi())try{return new Intl.PluralRules(e,{type:t.ordinal?"ordinal":"cardinal"})}catch(e){return}return this.rules[e]||this.rules[this.languageUtils.getLanguagePartFromCode(e)]}},{key:"needsPlural",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.getRule(e,t);return this.shouldUseIntlApi()?n&&n.resolvedOptions().pluralCategories.length>1:n&&n.numbers.length>1}},{key:"getPluralFormsOfKey",value:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};return this.getSuffixes(e,n).map((function(e){return"".concat(t).concat(e)}))}},{key:"getSuffixes",value:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=this.getRule(e,n);return r?this.shouldUseIntlApi()?r.resolvedOptions().pluralCategories.sort((function(e,t){return re[e]-re[t]})).map((function(e){return"".concat(t.options.prepend).concat(e)})):r.numbers.map((function(r){return t.getSuffix(e,r,n)})):[]}},{key:"getSuffix",value:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=this.getRule(e,n);return r?this.shouldUseIntlApi()?"".concat(this.options.prepend).concat(r.select(t)):this.getSuffixRetroCompatible(r,t):(this.logger.warn("no plural rule found for: ".concat(e)),"")}},{key:"getSuffixRetroCompatible",value:function(e,t){var n=this,r=e.noAbs?e.plurals(t):e.plurals(Math.abs(t)),a=e.numbers[r];this.options.simplifyPluralSuffix&&2===e.numbers.length&&1===e.numbers[0]&&(2===a?a="plural":1===a&&(a=""));var i=function(){return n.options.prepend&&a.toString()?n.options.prepend+a.toString():a.toString()};return"v1"===this.options.compatibilityJSON?1===a?"":"number"==typeof a?"_plural_".concat(a.toString()):i():"v2"===this.options.compatibilityJSON||this.options.simplifyPluralSuffix&&2===e.numbers.length&&1===e.numbers[0]?i():this.options.prepend&&r.toString()?this.options.prepend+r.toString():r.toString()}},{key:"shouldUseIntlApi",value:function(){return!ne.includes(this.options.compatibilityJSON)}}]),e}();function ie(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function se(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?ie(Object(n),!0).forEach((function(t){x(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):ie(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}var oe=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};n(this,e),this.logger=C.create("interpolator"),this.options=t,this.format=t.interpolation&&t.interpolation.format||function(e){return e},this.init(t)}return s(e,[{key:"init",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};e.interpolation||(e.interpolation={escapeValue:!0});var t=e.interpolation;this.escape=void 0!==t.escape?t.escape:V,this.escapeValue=void 0===t.escapeValue||t.escapeValue,this.useRawValueToEscape=void 0!==t.useRawValueToEscape&&t.useRawValueToEscape,this.prefix=t.prefix?L(t.prefix):t.prefixEscaped||"{{",this.suffix=t.suffix?L(t.suffix):t.suffixEscaped||"}}",this.formatSeparator=t.formatSeparator?t.formatSeparator:t.formatSeparator||",",this.unescapePrefix=t.unescapeSuffix?"":t.unescapePrefix||"-",this.unescapeSuffix=this.unescapePrefix?"":t.unescapeSuffix||"",this.nestingPrefix=t.nestingPrefix?L(t.nestingPrefix):t.nestingPrefixEscaped||L("$t("),this.nestingSuffix=t.nestingSuffix?L(t.nestingSuffix):t.nestingSuffixEscaped||L(")"),this.nestingOptionsSeparator=t.nestingOptionsSeparator?t.nestingOptionsSeparator:t.nestingOptionsSeparator||",",this.maxReplaces=t.maxReplaces?t.maxReplaces:1e3,this.alwaysFormat=void 0!==t.alwaysFormat&&t.alwaysFormat,this.resetRegExp()}},{key:"reset",value:function(){this.options&&this.init(this.options)}},{key:"resetRegExp",value:function(){var e="".concat(this.prefix,"(.+?)").concat(this.suffix);this.regexp=new RegExp(e,"g");var t="".concat(this.prefix).concat(this.unescapePrefix,"(.+?)").concat(this.unescapeSuffix).concat(this.suffix);this.regexpUnescape=new RegExp(t,"g");var n="".concat(this.nestingPrefix,"(.+?)").concat(this.nestingSuffix);this.nestingRegexp=new RegExp(n,"g")}},{key:"interpolate",value:function(e,t,n,r){var a,i,s,o=this,l=this.options&&this.options.interpolation&&this.options.interpolation.defaultVariables||{};function u(e){return e.replace(/\$/g,"$$$$")}var c=function(e){if(e.indexOf(o.formatSeparator)<0){var a=O(t,l,e);return o.alwaysFormat?o.format(a,void 0,n,se(se(se({},r),t),{},{interpolationkey:e})):a}var i=e.split(o.formatSeparator),s=i.shift().trim(),u=i.join(o.formatSeparator).trim();return o.format(O(t,l,s),u,n,se(se(se({},r),t),{},{interpolationkey:s}))};this.resetRegExp();var h=r&&r.missingInterpolationHandler||this.options.missingInterpolationHandler,p=r&&r.interpolation&&void 0!==r.interpolation.skipOnVariables?r.interpolation.skipOnVariables:this.options.interpolation.skipOnVariables;return[{regex:this.regexpUnescape,safeValue:function(e){return u(e)}},{regex:this.regexp,safeValue:function(e){return o.escapeValue?u(o.escape(e)):u(e)}}].forEach((function(t){for(s=0;a=t.regex.exec(e);){var n=a[1].trim();if(void 0===(i=c(n)))if("function"==typeof h){var l=h(e,a,r);i="string"==typeof l?l:""}else if(r&&r.hasOwnProperty(n))i="";else{if(p){i=a[0];continue}o.logger.warn("missed to pass in variable ".concat(n," for interpolating ").concat(e)),i=""}else"string"==typeof i||o.useRawValueToEscape||(i=M(i));var u=t.safeValue(i);if(e=e.replace(a[0],u),p?(t.regex.lastIndex+=i.length,t.regex.lastIndex-=a[0].length):t.regex.lastIndex=0,++s>=o.maxReplaces)break}})),e}},{key:"nest",value:function(e,t){var n,r,a,i=this,s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};function o(e,t){var n=this.nestingOptionsSeparator;if(e.indexOf(n)<0)return e;var r=e.split(new RegExp("".concat(n,"[ ]*{"))),i="{".concat(r[1]);e=r[0];var s=(i=this.interpolate(i,a)).match(/'/g),o=i.match(/"/g);(s&&s.length%2==0&&!o||o.length%2!=0)&&(i=i.replace(/'/g,'"'));try{a=JSON.parse(i),t&&(a=se(se({},t),a))}catch(t){return this.logger.warn("failed parsing options string in nesting for key ".concat(e),t),"".concat(e).concat(n).concat(i)}return delete a.defaultValue,e}for(;n=this.nestingRegexp.exec(e);){var l=[];(a=(a=se({},s)).replace&&"string"!=typeof a.replace?a.replace:a).applyPostProcessor=!1,delete a.defaultValue;var u=!1;if(-1!==n[0].indexOf(this.formatSeparator)&&!/{.*}/.test(n[1])){var c=n[1].split(this.formatSeparator).map((function(e){return e.trim()}));n[1]=c.shift(),l=c,u=!0}if((r=t(o.call(this,n[1].trim(),a),a))&&n[0]===e&&"string"!=typeof r)return r;"string"!=typeof r&&(r=M(r)),r||(this.logger.warn("missed to resolve ".concat(n[1]," for nesting ").concat(e)),r=""),u&&(r=l.reduce((function(e,t){return i.format(e,t,s.lng,se(se({},s),{},{interpolationkey:n[1].trim()}))}),r.trim())),e=e.replace(n[0],r),this.regexp.lastIndex=0}return e}}]),e}();function le(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function ue(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?le(Object(n),!0).forEach((function(t){x(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):le(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function ce(e){var t={};return function(n,r,a){var i=r+JSON.stringify(a),s=t[i];return s||(s=e(r,a),t[i]=s),s(n)}}var he=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};n(this,e),this.logger=C.create("formatter"),this.options=t,this.formats={number:ce((function(e,t){var n=new Intl.NumberFormat(e,t);return function(e){return n.format(e)}})),currency:ce((function(e,t){var n=new Intl.NumberFormat(e,ue(ue({},t),{},{style:"currency"}));return function(e){return n.format(e)}})),datetime:ce((function(e,t){var n=new Intl.DateTimeFormat(e,ue({},t));return function(e){return n.format(e)}})),relativetime:ce((function(e,t){var n=new Intl.RelativeTimeFormat(e,ue({},t));return function(e){return n.format(e,t.range||"day")}})),list:ce((function(e,t){var n=new Intl.ListFormat(e,ue({},t));return function(e){return n.format(e)}}))},this.init(t)}return s(e,[{key:"init",value:function(e){var t=(arguments.length>1&&void 0!==arguments[1]?arguments[1]:{interpolation:{}}).interpolation;this.formatSeparator=t.formatSeparator?t.formatSeparator:t.formatSeparator||","}},{key:"add",value:function(e,t){this.formats[e.toLowerCase().trim()]=t}},{key:"addCached",value:function(e,t){this.formats[e.toLowerCase().trim()]=ce(t)}},{key:"format",value:function(e,t,n,r){var a=this;return t.split(this.formatSeparator).reduce((function(e,t){var i=function(e){var t=e.toLowerCase().trim(),n={};if(e.indexOf("(")>-1){var r=e.split("(");t=r[0].toLowerCase().trim();var a=r[1].substring(0,r[1].length-1);"currency"===t&&a.indexOf(":")<0?n.currency||(n.currency=a.trim()):"relativetime"===t&&a.indexOf(":")<0?n.range||(n.range=a.trim()):a.split(";").forEach((function(e){if(e){var t=S(e.split(":")),r=t[0],a=t.slice(1).join(":").trim().replace(/^'+|'+$/g,"");n[r.trim()]||(n[r.trim()]=a),"false"===a&&(n[r.trim()]=!1),"true"===a&&(n[r.trim()]=!0),isNaN(a)||(n[r.trim()]=parseInt(a,10))}}))}return{formatName:t,formatOptions:n}}(t),s=i.formatName,o=i.formatOptions;if(a.formats[s]){var l=e;try{var u=r&&r.formatParams&&r.formatParams[r.interpolationkey]||{},c=u.locale||u.lng||r.locale||r.lng||n;l=a.formats[s](e,c,ue(ue(ue({},o),r),u))}catch(e){a.logger.warn(e)}return l}return a.logger.warn("there was no format function for ".concat(s)),e}),e)}}]),e}();function pe(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function fe(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?pe(Object(n),!0).forEach((function(t){x(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):pe(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function de(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var n,r=h(e);if(t){var a=h(this).constructor;n=Reflect.construct(r,arguments,a)}else n=r.apply(this,arguments);return c(this,n)}}var me=function(e){l(r,e);var t=de(r);function r(e,a,i){var s,o=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};return n(this,r),s=t.call(this),B&&A.call(u(s)),s.backend=e,s.store=a,s.services=i,s.languageUtils=i.languageUtils,s.options=o,s.logger=C.create("backendConnector"),s.waitingReads=[],s.maxParallelReads=o.maxParallelReads||10,s.readingCalls=0,s.maxRetries=o.maxRetries>=0?o.maxRetries:5,s.retryTimeout=o.retryTimeout>=1?o.retryTimeout:350,s.state={},s.queue=[],s.backend&&s.backend.init&&s.backend.init(i,o.backend,o),s}return s(r,[{key:"queueLoad",value:function(e,t,n,r){var a=this,i={},s={},o={},l={};return e.forEach((function(e){var r=!0;t.forEach((function(t){var o="".concat(e,"|").concat(t);!n.reload&&a.store.hasResourceBundle(e,t)?a.state[o]=2:a.state[o]<0||(1===a.state[o]?void 0===s[o]&&(s[o]=!0):(a.state[o]=1,r=!1,void 0===s[o]&&(s[o]=!0),void 0===i[o]&&(i[o]=!0),void 0===l[t]&&(l[t]=!0)))})),r||(o[e]=!0)})),(Object.keys(i).length||Object.keys(s).length)&&this.queue.push({pending:s,pendingCount:Object.keys(s).length,loaded:{},errors:[],callback:r}),{toLoad:Object.keys(i),pending:Object.keys(s),toLoadLanguages:Object.keys(o),toLoadNamespaces:Object.keys(l)}}},{key:"loaded",value:function(e,t,n){var r=e.split("|"),a=r[0],i=r[1];t&&this.emit("failedLoading",a,i,t),n&&this.store.addResourceBundle(a,i,n),this.state[e]=t?-1:2;var s={};this.queue.forEach((function(n){!function(e,t,n,r){var a=D(e,t,Object),i=a.obj,s=a.k;i[s]=i[s]||[],r&&(i[s]=i[s].concat(n)),r||i[s].push(n)}(n.loaded,[a],i),function(e,t){void 0!==e.pending[t]&&(delete e.pending[t],e.pendingCount--)}(n,e),t&&n.errors.push(t),0!==n.pendingCount||n.done||(Object.keys(n.loaded).forEach((function(e){s[e]||(s[e]={});var t=n.loaded[e];t.length&&t.forEach((function(t){void 0===s[e][t]&&(s[e][t]=!0)}))})),n.done=!0,n.errors.length?n.callback(n.errors):n.callback())})),this.emit("loaded",s),this.queue=this.queue.filter((function(e){return!e.done}))}},{key:"read",value:function(e,t,n){var r=this,a=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,i=arguments.length>4&&void 0!==arguments[4]?arguments[4]:this.retryTimeout,s=arguments.length>5?arguments[5]:void 0;if(!e.length)return s(null,{});if(this.readingCalls>=this.maxParallelReads)this.waitingReads.push({lng:e,ns:t,fcName:n,tried:a,wait:i,callback:s});else{this.readingCalls++;var o=function(o,l){if(r.readingCalls--,r.waitingReads.length>0){var u=r.waitingReads.shift();r.read(u.lng,u.ns,u.fcName,u.tried,u.wait,u.callback)}o&&l&&a<r.maxRetries?setTimeout((function(){r.read.call(r,e,t,n,a+1,2*i,s)}),i):s(o,l)},l=this.backend[n].bind(this.backend);if(2!==l.length)return l(e,t,o);try{var u=l(e,t);u&&"function"==typeof u.then?u.then((function(e){return o(null,e)})).catch(o):o(null,u)}catch(e){o(e)}}}},{key:"prepareLoading",value:function(e,t){var n=this,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=arguments.length>3?arguments[3]:void 0;if(!this.backend)return this.logger.warn("No backend was added via i18next.use. Will not load resources."),a&&a();"string"==typeof e&&(e=this.languageUtils.toResolveHierarchy(e)),"string"==typeof t&&(t=[t]);var i=this.queueLoad(e,t,r,a);if(!i.toLoad.length)return i.pending.length||a(),null;i.toLoad.forEach((function(e){n.loadOne(e)}))}},{key:"load",value:function(e,t,n){this.prepareLoading(e,t,{},n)}},{key:"reload",value:function(e,t,n){this.prepareLoading(e,t,{reload:!0},n)}},{key:"loadOne",value:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",r=e.split("|"),a=r[0],i=r[1];this.read(a,i,"read",void 0,void 0,(function(r,s){r&&t.logger.warn("".concat(n,"loading namespace ").concat(i," for language ").concat(a," failed"),r),!r&&s&&t.logger.log("".concat(n,"loaded namespace ").concat(i," for language ").concat(a),s),t.loaded(e,r,s)}))}},{key:"saveMissing",value:function(e,t,n,r,a){var i=arguments.length>5&&void 0!==arguments[5]?arguments[5]:{},s=arguments.length>6&&void 0!==arguments[6]?arguments[6]:function(){};if(this.services.utils&&this.services.utils.hasLoadedNamespace&&!this.services.utils.hasLoadedNamespace(t))this.logger.warn('did not save key "'.concat(n,'" as the namespace "').concat(t,'" was not yet loaded'),"This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!");else if(null!=n&&""!==n){if(this.backend&&this.backend.create){var o=fe(fe({},i),{},{isUpdate:a}),l=this.backend.create.bind(this.backend);if(l.length<6)try{var u;(u=5===l.length?l(e,t,n,r,o):l(e,t,n,r))&&"function"==typeof u.then?u.then((function(e){return s(null,e)})).catch(s):s(null,u)}catch(e){s(e)}else l(e,t,n,r,s,o)}e&&e[0]&&this.store.addResource(e[0],t,n,r)}}}]),r}(A);function ge(){return{debug:!1,initImmediate:!0,ns:["translation"],defaultNS:["translation"],fallbackLng:["dev"],fallbackNS:!1,supportedLngs:!1,nonExplicitSupportedLngs:!1,load:"all",preload:!1,simplifyPluralSuffix:!0,keySeparator:".",nsSeparator:":",pluralSeparator:"_",contextSeparator:"_",partialBundledLanguages:!1,saveMissing:!1,updateMissing:!1,saveMissingTo:"fallback",saveMissingPlurals:!0,missingKeyHandler:!1,missingInterpolationHandler:!1,postProcess:!1,postProcessPassResolved:!1,returnNull:!0,returnEmptyString:!0,returnObjects:!1,joinArrays:!1,returnedObjectHandler:!1,parseMissingKeyHandler:!1,appendNamespaceToMissingKey:!1,appendNamespaceToCIMode:!1,overloadTranslationOptionHandler:function(e){var t={};if("object"===r(e[1])&&(t=e[1]),"string"==typeof e[1]&&(t.defaultValue=e[1]),"string"==typeof e[2]&&(t.tDescription=e[2]),"object"===r(e[2])||"object"===r(e[3])){var n=e[3]||e[2];Object.keys(n).forEach((function(e){t[e]=n[e]}))}return t},interpolation:{escapeValue:!0,format:function(e,t,n,r){return e},prefix:"{{",suffix:"}}",formatSeparator:",",unescapePrefix:"-",nestingPrefix:"$t(",nestingSuffix:")",nestingOptionsSeparator:",",maxReplaces:1e3,skipOnVariables:!0}}}function ye(e){return"string"==typeof e.ns&&(e.ns=[e.ns]),"string"==typeof e.fallbackLng&&(e.fallbackLng=[e.fallbackLng]),"string"==typeof e.fallbackNS&&(e.fallbackNS=[e.fallbackNS]),e.supportedLngs&&e.supportedLngs.indexOf("cimode")<0&&(e.supportedLngs=e.supportedLngs.concat(["cimode"])),e}function ve(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function be(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?ve(Object(n),!0).forEach((function(t){x(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):ve(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function ke(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var n,r=h(e);if(t){var a=h(this).constructor;n=Reflect.construct(r,arguments,a)}else n=r.apply(this,arguments);return c(this,n)}}function xe(){}var Se=function(e){l(a,e);var t=ke(a);function a(){var e,r,i=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},s=arguments.length>1?arguments[1]:void 0;if(n(this,a),e=t.call(this),B&&A.call(u(e)),e.options=ye(i),e.services={},e.logger=C,e.modules={external:[]},r=u(e),Object.getOwnPropertyNames(Object.getPrototypeOf(r)).forEach((function(e){"function"==typeof r[e]&&(r[e]=r[e].bind(r))})),s&&!e.isInitialized&&!i.isClone){if(!e.options.initImmediate)return e.init(i,s),c(e,u(e));setTimeout((function(){e.init(i,s)}),0)}return e}return s(a,[{key:"init",value:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=arguments.length>1?arguments[1]:void 0;"function"==typeof t&&(n=t,t={}),!t.defaultNS&&!1!==t.defaultNS&&t.ns&&("string"==typeof t.ns?t.defaultNS=t.ns:t.ns.indexOf("translation")<0&&(t.defaultNS=t.ns[0]));var r=ge();function a(e){return e?"function"==typeof e?new e:e:null}if(this.options=be(be(be({},r),this.options),ye(t)),"v1"!==this.options.compatibilityAPI&&(this.options.interpolation=be(be({},r.interpolation),this.options.interpolation)),void 0!==t.keySeparator&&(this.options.userDefinedKeySeparator=t.keySeparator),void 0!==t.nsSeparator&&(this.options.userDefinedNsSeparator=t.nsSeparator),!this.options.isClone){var i;this.modules.logger?C.init(a(this.modules.logger),this.options):C.init(null,this.options),this.modules.formatter?i=this.modules.formatter:"undefined"!=typeof Intl&&(i=he);var s=new Z(this.options);this.store=new U(this.options.resources,this.options);var o=this.services;o.logger=C,o.resourceStore=this.store,o.languageUtils=s,o.pluralResolver=new ae(s,{prepend:this.options.pluralSeparator,compatibilityJSON:this.options.compatibilityJSON,simplifyPluralSuffix:this.options.simplifyPluralSuffix}),!i||this.options.interpolation.format&&this.options.interpolation.format!==r.interpolation.format||(o.formatter=a(i),o.formatter.init(o,this.options),this.options.interpolation.format=o.formatter.format.bind(o.formatter)),o.interpolator=new oe(this.options),o.utils={hasLoadedNamespace:this.hasLoadedNamespace.bind(this)},o.backendConnector=new me(a(this.modules.backend),o.resourceStore,o,this.options),o.backendConnector.on("*",(function(t){for(var n=arguments.length,r=new Array(n>1?n-1:0),a=1;a<n;a++)r[a-1]=arguments[a];e.emit.apply(e,[t].concat(r))})),this.modules.languageDetector&&(o.languageDetector=a(this.modules.languageDetector),o.languageDetector.init&&o.languageDetector.init(o,this.options.detection,this.options)),this.modules.i18nFormat&&(o.i18nFormat=a(this.modules.i18nFormat),o.i18nFormat.init&&o.i18nFormat.init(this)),this.translator=new Q(this.services,this.options),this.translator.on("*",(function(t){for(var n=arguments.length,r=new Array(n>1?n-1:0),a=1;a<n;a++)r[a-1]=arguments[a];e.emit.apply(e,[t].concat(r))})),this.modules.external.forEach((function(t){t.init&&t.init(e)}))}if(this.format=this.options.interpolation.format,n||(n=xe),this.options.fallbackLng&&!this.services.languageDetector&&!this.options.lng){var l=this.services.languageUtils.getFallbackCodes(this.options.fallbackLng);l.length>0&&"dev"!==l[0]&&(this.options.lng=l[0])}this.services.languageDetector||this.options.lng||this.logger.warn("init: no languageDetector is used and no lng is defined");["getResource","hasResourceBundle","getResourceBundle","getDataByLanguage"].forEach((function(t){e[t]=function(){var n;return(n=e.store)[t].apply(n,arguments)}}));["addResource","addResources","addResourceBundle","removeResourceBundle"].forEach((function(t){e[t]=function(){var n;return(n=e.store)[t].apply(n,arguments),e}}));var u=T(),c=function(){var t=function(t,r){e.isInitialized&&!e.initializedStoreOnce&&e.logger.warn("init: i18next is already initialized. You should call init just once!"),e.isInitialized=!0,e.options.isClone||e.logger.log("initialized",e.options),e.emit("initialized",e.options),u.resolve(r),n(t,r)};if(e.languages&&"v1"!==e.options.compatibilityAPI&&!e.isInitialized)return t(null,e.t.bind(e));e.changeLanguage(e.options.lng,t)};return this.options.resources||!this.options.initImmediate?c():setTimeout(c,0),u}},{key:"loadResources",value:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:xe,r="string"==typeof e?e:this.language;if("function"==typeof e&&(n=e),!this.options.resources||this.options.partialBundledLanguages){if(r&&"cimode"===r.toLowerCase())return n();var a=[],i=function(e){e&&t.services.languageUtils.toResolveHierarchy(e).forEach((function(e){a.indexOf(e)<0&&a.push(e)}))};if(r)i(r);else this.services.languageUtils.getFallbackCodes(this.options.fallbackLng).forEach((function(e){return i(e)}));this.options.preload&&this.options.preload.forEach((function(e){return i(e)})),this.services.backendConnector.load(a,this.options.ns,(function(e){e||t.resolvedLanguage||!t.language||t.setResolvedLanguage(t.language),n(e)}))}else n(null)}},{key:"reloadResources",value:function(e,t,n){var r=T();return e||(e=this.languages),t||(t=this.options.ns),n||(n=xe),this.services.backendConnector.reload(e,t,(function(e){r.resolve(),n(e)})),r}},{key:"use",value:function(e){if(!e)throw new Error("You are passing an undefined module! Please check the object you are passing to i18next.use()");if(!e.type)throw new Error("You are passing a wrong module! Please check the object you are passing to i18next.use()");return"backend"===e.type&&(this.modules.backend=e),("logger"===e.type||e.log&&e.warn&&e.error)&&(this.modules.logger=e),"languageDetector"===e.type&&(this.modules.languageDetector=e),"i18nFormat"===e.type&&(this.modules.i18nFormat=e),"postProcessor"===e.type&&W.addPostProcessor(e),"formatter"===e.type&&(this.modules.formatter=e),"3rdParty"===e.type&&this.modules.external.push(e),this}},{key:"setResolvedLanguage",value:function(e){if(e&&this.languages&&!(["cimode","dev"].indexOf(e)>-1))for(var t=0;t<this.languages.length;t++){var n=this.languages[t];if(!(["cimode","dev"].indexOf(n)>-1)&&this.store.hasLanguageSomeTranslations(n)){this.resolvedLanguage=n;break}}}},{key:"changeLanguage",value:function(e,t){var n=this;this.isLanguageChangingTo=e;var r=T();this.emit("languageChanging",e);var a=function(e){n.language=e,n.languages=n.services.languageUtils.toResolveHierarchy(e),n.resolvedLanguage=void 0,n.setResolvedLanguage(e)},i=function(i){e||i||!n.services.languageDetector||(i=[]);var s="string"==typeof i?i:n.services.languageUtils.getBestMatchFromCodes(i);s&&(n.language||a(s),n.translator.language||n.translator.changeLanguage(s),n.services.languageDetector&&n.services.languageDetector.cacheUserLanguage&&n.services.languageDetector.cacheUserLanguage(s)),n.loadResources(s,(function(e){!function(e,i){i?(a(i),n.translator.changeLanguage(i),n.isLanguageChangingTo=void 0,n.emit("languageChanged",i),n.logger.log("languageChanged",i)):n.isLanguageChangingTo=void 0,r.resolve((function(){return n.t.apply(n,arguments)})),t&&t(e,(function(){return n.t.apply(n,arguments)}))}(e,s)}))};return e||!this.services.languageDetector||this.services.languageDetector.async?!e&&this.services.languageDetector&&this.services.languageDetector.async?0===this.services.languageDetector.detect.length?this.services.languageDetector.detect().then(i):this.services.languageDetector.detect(i):i(e):i(this.services.languageDetector.detect()),r}},{key:"getFixedT",value:function(e,t,n){var a=this,i=function e(t,i){var s;if("object"!==r(i)){for(var o=arguments.length,l=new Array(o>2?o-2:0),u=2;u<o;u++)l[u-2]=arguments[u];s=a.options.overloadTranslationOptionHandler([t,i].concat(l))}else s=be({},i);s.lng=s.lng||e.lng,s.lngs=s.lngs||e.lngs,s.ns=s.ns||e.ns,s.keyPrefix=s.keyPrefix||n||e.keyPrefix;var c,h=a.options.keySeparator||".";return c=s.keyPrefix&&Array.isArray(t)?t.map((function(e){return"".concat(s.keyPrefix).concat(h).concat(e)})):s.keyPrefix?"".concat(s.keyPrefix).concat(h).concat(t):t,a.t(c,s)};return"string"==typeof e?i.lng=e:i.lngs=e,i.ns=t,i.keyPrefix=n,i}},{key:"t",value:function(){var e;return this.translator&&(e=this.translator).translate.apply(e,arguments)}},{key:"exists",value:function(){var e;return this.translator&&(e=this.translator).exists.apply(e,arguments)}},{key:"setDefaultNamespace",value:function(e){this.options.defaultNS=e}},{key:"hasLoadedNamespace",value:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!this.isInitialized)return this.logger.warn("hasLoadedNamespace: i18next was not initialized",this.languages),!1;if(!this.languages||!this.languages.length)return this.logger.warn("hasLoadedNamespace: i18n.languages were undefined or empty",this.languages),!1;var r=this.resolvedLanguage||this.languages[0],a=!!this.options&&this.options.fallbackLng,i=this.languages[this.languages.length-1];if("cimode"===r.toLowerCase())return!0;var s=function(e,n){var r=t.services.backendConnector.state["".concat(e,"|").concat(n)];return-1===r||2===r};if(n.precheck){var o=n.precheck(this,s);if(void 0!==o)return o}return!!this.hasResourceBundle(r,e)||(!(this.services.backendConnector.backend&&(!this.options.resources||this.options.partialBundledLanguages))||!(!s(r,e)||a&&!s(i,e)))}},{key:"loadNamespaces",value:function(e,t){var n=this,r=T();return this.options.ns?("string"==typeof e&&(e=[e]),e.forEach((function(e){n.options.ns.indexOf(e)<0&&n.options.ns.push(e)})),this.loadResources((function(e){r.resolve(),t&&t(e)})),r):(t&&t(),Promise.resolve())}},{key:"loadLanguages",value:function(e,t){var n=T();"string"==typeof e&&(e=[e]);var r=this.options.preload||[],a=e.filter((function(e){return r.indexOf(e)<0}));return a.length?(this.options.preload=r.concat(a),this.loadResources((function(e){n.resolve(),t&&t(e)})),n):(t&&t(),Promise.resolve())}},{key:"dir",value:function(e){if(e||(e=this.resolvedLanguage||(this.languages&&this.languages.length>0?this.languages[0]:this.language)),!e)return"rtl";var t=this.services&&this.services.languageUtils||new Z(ge());return["ar","shu","sqr","ssh","xaa","yhd","yud","aao","abh","abv","acm","acq","acw","acx","acy","adf","ads","aeb","aec","afb","ajp","apc","apd","arb","arq","ars","ary","arz","auz","avl","ayh","ayl","ayn","ayp","bbz","pga","he","iw","ps","pbt","pbu","pst","prp","prd","ug","ur","ydd","yds","yih","ji","yi","hbo","men","xmn","fa","jpr","peo","pes","prs","dv","sam","ckb"].indexOf(t.getLanguagePartFromCode(e))>-1||e.toLowerCase().indexOf("-arab")>1?"rtl":"ltr"}},{key:"cloneInstance",value:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:xe,r=be(be(be({},this.options),t),{isClone:!0}),i=new a(r);void 0===t.debug&&void 0===t.prefix||(i.logger=i.logger.clone(t));return["store","services","language"].forEach((function(t){i[t]=e[t]})),i.services=be({},this.services),i.services.utils={hasLoadedNamespace:i.hasLoadedNamespace.bind(i)},i.translator=new Q(i.services,i.options),i.translator.on("*",(function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];i.emit.apply(i,[e].concat(n))})),i.init(r,n),i.translator.options=i.options,i.translator.backendConnector.services.utils={hasLoadedNamespace:i.hasLoadedNamespace.bind(i)},i}},{key:"toJSON",value:function(){return{options:this.options,store:this.store,language:this.language,languages:this.languages,resolvedLanguage:this.resolvedLanguage}}}]),a}(A);x(Se,"createInstance",(function(){return new Se(arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},arguments.length>1?arguments[1]:void 0)}));var we=Se.createInstance();we.createInstance=Se.createInstance;we.createInstance,we.dir,we.init,we.loadResources,we.reloadResources,we.use,we.changeLanguage,we.getFixedT;var Ee=we.t;we.exists,we.setDefaultNamespace,we.hasLoadedNamespace,we.loadNamespaces,we.loadLanguages,__webpack_require__(1739);Object.create(null);var Pe=/&(?:amp|#38|lt|#60|gt|#62|apos|#39|quot|#34|nbsp|#160|copy|#169|reg|#174|hellip|#8230|#x2F|#47);/g,_e={"&amp;":"&","&#38;":"&","&lt;":"<","&#60;":"<","&gt;":">","&#62;":">","&apos;":"'","&#39;":"'","&quot;":'"',"&#34;":'"',"&nbsp;":" ","&#160;":" ","&copy;":"©","&#169;":"©","&reg;":"®","&#174;":"®","&hellip;":"…","&#8230;":"…","&#x2F;":"/","&#47;":"/"},Ce=function(e){return _e[e]};function Ae(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function Te(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?Ae(Object(n),!0).forEach((function(t){x(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):Ae(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}var Me={bindI18n:"languageChanged",bindI18nStore:"",transEmptyNodeValue:"",transSupportBasicHtmlNodes:!0,transWrapTextNodes:"",transKeepBasicHtmlNodesFor:["br","strong","i","p"],useSuspense:!0,unescape:function(e){return e.replace(Pe,Ce)}};var De={type:"3rdParty",init:function(e){!function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};Me=Te(Te({},Me),e)}(e.options.react),function(e){e}(e)}};(0,b.createContext)(),function(){function e(){n(this,e),this.usedNamespaces={}}s(e,[{key:"addUsedNamespaces",value:function(e){var t=this;e.forEach((function(e){t.usedNamespaces[e]||(t.usedNamespaces[e]=!0)}))}},{key:"getUsedNamespaces",value:function(){return Object.keys(this.usedNamespaces)}}])}();var Ie=[],Fe=Ie.forEach,Oe=Ie.slice;var Re=/^[\u0009\u0020-\u007e\u0080-\u00ff]+$/,Le=function(e,t,n){var r=n||{};r.path=r.path||"/";var a=encodeURIComponent(t),i="".concat(e,"=").concat(a);if(r.maxAge>0){var s=r.maxAge-0;if(Number.isNaN(s))throw new Error("maxAge should be a Number");i+="; Max-Age=".concat(Math.floor(s))}if(r.domain){if(!Re.test(r.domain))throw new TypeError("option domain is invalid");i+="; Domain=".concat(r.domain)}if(r.path){if(!Re.test(r.path))throw new TypeError("option path is invalid");i+="; Path=".concat(r.path)}if(r.expires){if("function"!=typeof r.expires.toUTCString)throw new TypeError("option expires is invalid");i+="; Expires=".concat(r.expires.toUTCString())}if(r.httpOnly&&(i+="; HttpOnly"),r.secure&&(i+="; Secure"),r.sameSite)switch("string"==typeof r.sameSite?r.sameSite.toLowerCase():r.sameSite){case!0:i+="; SameSite=Strict";break;case"lax":i+="; SameSite=Lax";break;case"strict":i+="; SameSite=Strict";break;case"none":i+="; SameSite=None";break;default:throw new TypeError("option sameSite is invalid")}return i},Ne=function(e,t,n,r){var a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:{path:"/",sameSite:"strict"};n&&(a.expires=new Date,a.expires.setTime(a.expires.getTime()+60*n*1e3)),r&&(a.domain=r),document.cookie=Le(e,encodeURIComponent(t),a)},Ve=function(e){for(var t="".concat(e,"="),n=document.cookie.split(";"),r=0;r<n.length;r++){for(var a=n[r];" "===a.charAt(0);)a=a.substring(1,a.length);if(0===a.indexOf(t))return a.substring(t.length,a.length)}return null},Be={name:"cookie",lookup:function(e){var t;if(e.lookupCookie&&"undefined"!=typeof document){var n=Ve(e.lookupCookie);n&&(t=n)}return t},cacheUserLanguage:function(e,t){t.lookupCookie&&"undefined"!=typeof document&&Ne(t.lookupCookie,e,t.cookieMinutes,t.cookieDomain,t.cookieOptions)}},ze={name:"querystring",lookup:function(e){var t;if("undefined"!=typeof window){var n=window.location.search;!window.location.search&&window.location.hash&&window.location.hash.indexOf("?")>-1&&(n=window.location.hash.substring(window.location.hash.indexOf("?")));for(var r=n.substring(1).split("&"),a=0;a<r.length;a++){var i=r[a].indexOf("=");if(i>0)r[a].substring(0,i)===e.lookupQuerystring&&(t=r[a].substring(i+1))}}return t}},je=null,Ge=function(){if(null!==je)return je;try{je="undefined"!==window&&null!==window.localStorage;var e="i18next.translate.boo";window.localStorage.setItem(e,"foo"),window.localStorage.removeItem(e)}catch(e){je=!1}return je},He={name:"localStorage",lookup:function(e){var t;if(e.lookupLocalStorage&&Ge()){var n=window.localStorage.getItem(e.lookupLocalStorage);n&&(t=n)}return t},cacheUserLanguage:function(e,t){t.lookupLocalStorage&&Ge()&&window.localStorage.setItem(t.lookupLocalStorage,e)}},qe=null,Ue=function(){if(null!==qe)return qe;try{qe="undefined"!==window&&null!==window.sessionStorage;var e="i18next.translate.boo";window.sessionStorage.setItem(e,"foo"),window.sessionStorage.removeItem(e)}catch(e){qe=!1}return qe},We={name:"sessionStorage",lookup:function(e){var t;if(e.lookupSessionStorage&&Ue()){var n=window.sessionStorage.getItem(e.lookupSessionStorage);n&&(t=n)}return t},cacheUserLanguage:function(e,t){t.lookupSessionStorage&&Ue()&&window.sessionStorage.setItem(t.lookupSessionStorage,e)}},$e={name:"navigator",lookup:function(e){var t=[];if("undefined"!=typeof navigator){if(navigator.languages)for(var n=0;n<navigator.languages.length;n++)t.push(navigator.languages[n]);navigator.userLanguage&&t.push(navigator.userLanguage),navigator.language&&t.push(navigator.language)}return t.length>0?t:void 0}},Ke={name:"htmlTag",lookup:function(e){var t,n=e.htmlTag||("undefined"!=typeof document?document.documentElement:null);return n&&"function"==typeof n.getAttribute&&(t=n.getAttribute("lang")),t}},Je={name:"path",lookup:function(e){var t;if("undefined"!=typeof window){var n=window.location.pathname.match(/\/([a-zA-Z-]*)/g);if(n instanceof Array)if("number"==typeof e.lookupFromPathIndex){if("string"!=typeof n[e.lookupFromPathIndex])return;t=n[e.lookupFromPathIndex].replace("/","")}else t=n[0].replace("/","")}return t}},Ye={name:"subdomain",lookup:function(e){var t="number"==typeof e.lookupFromSubdomainIndex?e.lookupFromSubdomainIndex+1:1,n="undefined"!=typeof window&&window.location&&window.location.hostname&&window.location.hostname.match(/^(\w{2,5})\.(([a-z0-9-]{1,63}\.[a-z]{2,6})|localhost)/i);if(n)return n[t]}};var Qe=function(){function e(t){var r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};n(this,e),this.type="languageDetector",this.detectors={},this.init(t,r)}return s(e,[{key:"init",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};this.services=e,this.options=function(e){return Fe.call(Oe.call(arguments,1),(function(t){if(t)for(var n in t)void 0===e[n]&&(e[n]=t[n])})),e}(t,this.options||{},{order:["querystring","cookie","localStorage","sessionStorage","navigator","htmlTag"],lookupQuerystring:"lng",lookupCookie:"i18next",lookupLocalStorage:"i18nextLng",lookupSessionStorage:"i18nextLng",caches:["localStorage"],excludeCacheFor:["cimode"]}),this.options.lookupFromUrlIndex&&(this.options.lookupFromPathIndex=this.options.lookupFromUrlIndex),this.i18nOptions=n,this.addDetector(Be),this.addDetector(ze),this.addDetector(He),this.addDetector(We),this.addDetector($e),this.addDetector(Ke),this.addDetector(Je),this.addDetector(Ye)}},{key:"addDetector",value:function(e){this.detectors[e.name]=e}},{key:"detect",value:function(e){var t=this;e||(e=this.options.order);var n=[];return e.forEach((function(e){if(t.detectors[e]){var r=t.detectors[e].lookup(t.options);r&&"string"==typeof r&&(r=[r]),r&&(n=n.concat(r))}})),this.services.languageUtils.getBestMatchFromCodes?n:n.length>0?n[0]:null}},{key:"cacheUserLanguage",value:function(e,t){var n=this;t||(t=this.options.caches),t&&(this.options.excludeCacheFor&&this.options.excludeCacheFor.indexOf(e)>-1||t.forEach((function(t){n.detectors[t]&&n.detectors[t].cacheUserLanguage(e,n.options)})))}}]),e}();Qe.type="languageDetector";const Xe=JSON.parse('{"nav.later":"По-късно","nav.prev":"Предишна","nav.next":"Следваща","nav.done":"Готово","intro.button":"Начало","themes.header":"В какво настроение сте?","themes.subheader":"Избор на тема на браузъра","themes.light":"Светло","themes.dark":"Тъмно","themes.system":"Система","wallpapers.header":"Какъв е вашият стил?","wallpapers.subheader":"Избор на тапет за Стартовата страница","adblocker.header":"По-бърза навигация без реклами","adblocker.subheader":"Включете блокирането на реклами,","adblocker.label":"Блокиране на реклами","messengers.header":"Бъдете в крак с всички","messengers.subheader":"Добавяне на любими приложения за социални медии","import.failed_header":"ГРЕШКА ПРИ ИМПОРТ","import.failed_message":"Моля, уверете се, че няма други задачи на браузъра, които да работят, и опитайте отново","import.header":"Внасяне на вашите данни","import.subheader":"Изберете браузър по-долу","outro.header":"Вашият браузър Opera е готов","outro.button":"Започнете да сърфирате"}'),Ze=JSON.parse('{"nav.later":"পরে","nav.prev":"পূর্ববর্তী","nav.next":"পরবর্তী","nav.done":"সম্পন্ন","intro.button":"ব্যবহার করে দেখুন","themes.header":"আপনার মুড কেমন আছে?","themes.subheader":"ব্রাউজার থিম নির্বাচন করুন","themes.light":"হালকা","themes.dark":"ঘন","themes.system":"সিস্টেম","wallpapers.header":"আপনার স্টাইল কেমন?","wallpapers.subheader":"সূচনা পৃষ্ঠার ওয়ালপেপার নির্বাচন করুন","adblocker.header":"বিজ্ঞাপন মুক্ত ভাবে দ্রুত ব্রাউজ করুন","adblocker.subheader":"অ্যাড ব্লকার চালু করুন","adblocker.label":"বিজ্ঞাপনগুলি অবরোধ করুন","messengers.header":"সবার সাথে তাল মিলিয়ে চলুন","messengers.subheader":"আপনার পছন্দের সোশ্যাল অ্যাপ যোগ করুন","import.failed_header":"আমদানি ত্রুটি","import.failed_message":"দয়া করে নিশ্চিত করুন যে কোনও অন্যান্য ব্রাউজার টাস্ক চলছে না এবং আবার চেষ্টা করুন","import.header":"আপনার ডেটা ইম্পোর্ট করুন","import.subheader":"নীচে ব্রাউজার নির্বাচন করুন","outro.header":"আপনার Opera ব্রাউজার প্রস্তুত","outro.button":"ব্রাউজ করা শুরু করুন"}'),et=JSON.parse('{"nav.later":"Més tard","nav.prev":"Anterior","nav.next":"Següent","nav.done":"Fet","intro.button":"Primers passos","themes.header":"Indica el teu estat d’ànim","themes.subheader":"Selecciona un tema del navegador","themes.light":"Clar","themes.dark":"Fosc","themes.system":"Sistema","wallpapers.header":"Indica el teu estil","wallpapers.subheader":"Selecciona el fons de pantalla de la pàgina inicial","adblocker.header":"Navega més de pressa sense anuncis","adblocker.subheader":"Activa el bloqueig d\'anuncis","adblocker.label":"Bloqueja els anuncis","messengers.header":"Estigues al corrent de tothom","messengers.subheader":"Afegeix les teves xarxes socials preferides","import.failed_header":"ERROR D\'IMPORTACIÓ","import.failed_message":"Assegureu-vos que no s\'estiguin executant altres tasques del navegador i torneu-ho a provar","import.header":"Importa les teves dades","import.subheader":"Selecciona un navegador tot seguit","outro.header":"El teu navegador Opera ja és a punt","outro.button":"Comença a navegar"}'),tt=JSON.parse('{"nav.later":"Později","nav.prev":"Předch.","nav.next":"Další","nav.done":"Dokončeno","intro.button":"Začínáme","themes.header":"Jakou máte náladu?","themes.subheader":"Výběr tématu prohlížeče","themes.light":"Světlé","themes.dark":"Tmavé","themes.system":"Systém","wallpapers.header":"Jaký máte styl?","wallpapers.subheader":"Výběr tapety úvodní stránky","adblocker.header":"Rychlejší prohlížení bez reklam","adblocker.subheader":"Zapněte blokování reklam","adblocker.label":"Blokování reklam","messengers.header":"Držte krok s ostatními","messengers.subheader":"Přidejte své oblíbené sociální aplikace","import.failed_header":"CHYBA IMPORTU","import.failed_message":"Ujistěte se, že žádné další úkoly prohlížeče neběží, a zkuste to znovu","import.header":"Synchronizujte svá data","import.subheader":"Z následující nabídky vyberte prohlížeč","outro.header":"Prohlížeč Opera je připraven","outro.button":"Začít prohlížet web"}'),nt=JSON.parse('{"nav.later":"Senere","nav.prev":"Forrige","nav.next":"Næste","nav.done":"Udfør","intro.button":"Kom godt i gang","themes.header":"Hvordan er dit humør?","themes.subheader":"Vælg et browsertema","themes.light":"Lys","themes.dark":"Mørk","themes.system":"System","wallpapers.header":"Hvad er din stil?","wallpapers.subheader":"Vælg en baggrund til startsiden","adblocker.header":"Surf hurtigere uden annoncer","adblocker.subheader":"Slå annonceblokering til","adblocker.label":"Bloker annoncer","messengers.header":"Hold dig opdateret med alle","messengers.subheader":"Tilføj dine foretrukne sociale apps","import.failed_header":"IMPORTFEJL","import.failed_message":"Sørg for, at ingen andre browseropgaver kører, og prøv igen","import.header":"Importér dine data","import.subheader":"Vælg en browser nedenfor","outro.header":"Din Opera-browser er klar","outro.button":"Begynd at browse"}'),rt=JSON.parse('{"nav.later":"Später","nav.prev":"Vorherige","nav.next":"Nächste","nav.done":"Fertig","intro.button":"Erste Schritte","themes.header":"Wonach steht dir der Sinn?","themes.subheader":"Wähle ein Browserdesign aus","themes.light":"Hell","themes.dark":"Dunkel","themes.system":"System","wallpapers.header":"Welcher Stil gefällt dir?","wallpapers.subheader":"Wähle ein Hintergrundbild für die Startseite aus","adblocker.header":"Ohne Werbung schneller surfen","adblocker.subheader":"Aktiviere den Werbeblocker","adblocker.label":"Werbung blockieren","messengers.header":"Kontakte pflegen","messengers.subheader":"Füge deine bevorzugten Social-Media-Apps hinzu","import.failed_header":"IMPORTFEHLER","import.failed_message":"Bitte stellen Sie sicher, dass keine anderen Browser-Aufgaben ausgeführt werden, und versuchen Sie es erneut","import.header":"Deine Daten importieren","import.subheader":"Wähle unten einen Browser","outro.header":"Dein Opera-Browser ist startbereit","outro.button":"Browsen beginnen"}'),at=JSON.parse('{"nav.later":"Αργότερα","nav.prev":"Προηγούμενο","nav.next":"Επόμενο","nav.done":"Τέλος","intro.button":"Ξεκινήστε","themes.header":"Σε τι διάθεση βρίσκεστε;","themes.subheader":"Επιλέξτε θέμα προγράμματος περιήγησης","themes.light":"Φωτεινό","themes.dark":"Σκοτεινό","themes.system":"Σύστημα","wallpapers.header":"Ποιο είναι το στυλ σας;","wallpapers.subheader":"Επιλέξτε ταπετσαρία για την Αρχική Σελίδα","adblocker.header":"Ταχύτερη περιήγηση χωρίς διαφημίσεις","adblocker.subheader":"Ενεργοποιήστε τον αποκλεισμό διαφημίσεων","adblocker.label":"Αποκλεισμός διαφημίσεων","messengers.header":"Μάθετε τα νέα των φίλων σας","messengers.subheader":"Προσθέστε τις εφαρμογές των αγαπημένων σας μέσων κοινωνικής δικτύωσης","import.failed_header":"ΣΦΑΛΜΑ ΕΙΣΑΓΩΓΗΣ","import.failed_message":"Βεβαιωθείτε ότι δεν εκτελούνται άλλες εργασίες προγράμματος περιήγησης και δοκιμάστε ξανά","import.header":"Εισάγετε τα δεδομένα σας","import.subheader":"Επιλέξτε ένα από τα παρακάτω προγράμματα περιήγησης","outro.header":"Το πρόγραμμα περιήγησης Opera είναι έτοιμο","outro.button":"Έναρξη περιήγησης"}'),it=JSON.parse('{"browser.chrome":"Chrome","browser.edge":"Edge","browser.safari":"Safari","browser.firefox":"Firefox","browser.crypto":"Opera Crypto","browser.gx":"Opera GX","nav.later":"Later","nav.prev":"Prev","nav.next":"Next","nav.done":"Done","intro.button":"Get started","themes.header":"What\'s your mood?","themes.subheader":"Select a browser theme","themes.light":"Light","themes.dark":"Dark","themes.system":"System","wallpapers.header":"What\'s your style?","wallpapers.subheader":"Select a Start Page wallpaper","adblocker.header":"Browse faster ad-free","adblocker.subheader":"Turn on ad blocker","adblocker.label":"Block ads","messengers.header":"Keep up with everyone","messengers.subheader":"Add your favourite social apps","import.failed_header":"IMPORTING ERROR","import.failed_message":"Please make sure no other browser tasks are running and try again","import.header":"Import your data","import.subheader":"Select a browser below","outro.header":"Your Opera browser is ready","outro.button":"Start browsing"}'),st=JSON.parse('{"nav.later":"Después","nav.prev":"Anterior","nav.next":"Siguiente","nav.done":"Listo","intro.button":"Comenzar","themes.header":"¿Cuál es tu estado de ánimo?","themes.subheader":"Selecciona un tema para el navegador","themes.light":"Claro","themes.dark":"Oscuro","themes.system":"Sistema","wallpapers.header":"¿Cuál es tu estilo?","wallpapers.subheader":"Selecciona una imagen de fondo para la página de inicio","adblocker.header":"Navega más rápido sin anuncios","adblocker.subheader":"Activa el bloqueador de publicidad","adblocker.label":"Bloquear publicidad","messengers.header":"Mantente al día","messengers.subheader":"Añade tus aplicaciones de redes sociales preferidas","import.failed_header":"ERROR DE IMPORTACIÓN","import.failed_message":"Por favor, asegúrese de que no haya otras tareas del navegador en ejecución e intente de nuevo","import.header":"Importa tus datos","import.subheader":"Selecciona un navegador abajo","outro.header":"Tu Navegador Opera está listo","outro.button":"Comienza a navegar"}'),ot=JSON.parse('{"nav.later":"Más tarde","nav.prev":"Anterior","nav.next":"Siguiente","nav.done":"Hecho","intro.button":"Primeros pasos","themes.header":"Indica tu estado de ánimo","themes.subheader":"selecciona un tema del navegador","themes.light":"Claro","themes.dark":"Oscuro","themes.system":"Sistema","wallpapers.header":"Indica tu estilo","wallpapers.subheader":"Selecciona un fondo de pantalla para la página de inicio","adblocker.header":"Navega más rápido sin anuncios","adblocker.subheader":"Activa el bloqueo de publicidad","adblocker.label":"Bloquear publicidad","messengers.header":"Mantente al corriente de todos","messengers.subheader":"Añade tus redes sociales favoritas","import.failed_header":"ERROR DE IMPORTACIÓN","import.failed_message":"Asegúrese de que no se estén ejecutando otras tareas del navegador e inténtelo de nuevo","import.header":"Importa tus datos","import.subheader":"Selecciona un navegador a continuación","outro.description":"Accede a Aria, VPN Pro y Cashback con tu cuenta gratuita de Opera.","outro.button":"Empezar a navegar"}'),lt=JSON.parse('{"nav.later":"Myöhemmin","nav.prev":"Edellinen","nav.next":"Seuraava","nav.done":"Valmis","intro.button":"Aloita","themes.header":"Millä tuulella olet?","themes.subheader":"Valitse selaimen teema","themes.light":"Vaalea","themes.dark":"Tumma","themes.system":"Järjestelmä","wallpapers.header":"Mistä tyylistä pidät?","wallpapers.subheader":"Valitse aloitussivun taustakuva","adblocker.header":"Selaa nopeammin ilman mainoksia","adblocker.subheader":"Ota mainosten esto käyttöön","adblocker.label":"Mainosten esto","messengers.header":"Pysy ajan tasalla kuulumisista","messengers.subheader":"Lisää käyttämäsi sosiaalisen median sovellukset","import.failed_header":"TUONTIVIRHE","import.failed_message":"Varmista, ettei muita selaintehtäviä ole käynnissä ja yritä uudelleen","import.header":"Tuo tietosi","import.subheader":"Valitse alta selain","outro.description":"Käytä maksuttomalla Opera-tilillä Ariaa, VPN Prota ja Cashback-hyvityksiä.","outro.button":"Aloita selaaminen"}'),ut=JSON.parse('{"nav.later":"Plus tard","nav.prev":"Préc","nav.next":"Suivant","nav.done":"Fait","intro.button":"Commencer","themes.header":"Quelle est ton humeur ?","themes.subheader":"Sélectionne un thème de navigateur","themes.light":"Clair","themes.dark":"Sombre","themes.system":"Système","wallpapers.header":"Quel est ton style ?","wallpapers.subheader":"Sélectionne un fond d\'écran pour la page de démarrage","adblocker.header":"Navigue plus vite et sans pubs","adblocker.subheader":"Activer le blocage des pubs","adblocker.label":"Bloquer les pubs","messengers.header":"Reste en contact avec tout le monde","messengers.subheader":"Ajoute les applis de tes réseaux sociaux préférés","import.failed_header":"ERREUR D\'IMPORTATION","import.failed_message":"Veuillez vous assurer qu\'aucune autre tâche du navigateur n\'est en cours d\'exécution et réessayez","import.header":"Importe tes données","import.subheader":"Sélectionne un navigateur ci-dessous","outro.header":"Ton navigateur Opera est prêt","outro.button":"Commencer la navigation"}'),ct=JSON.parse('{"nav.later":"बाद में","nav.prev":"पिछला","nav.next":"अगला","nav.done":"पूरा हुआ","intro.button":"शुरू करें","themes.header":"आपका मूड कैसा है?","themes.subheader":"एक ब्राउज़र थीम चुनें","themes.light":"हल्का","themes.dark":"गहरा","themes.system":"सिस्टम:","wallpapers.header":"आपका स्टाइल कैसा है?","wallpapers.subheader":"स्टार्ट पेज वॉलपेपर चुनें","adblocker.header":"बिना विज्ञापन के तेज़ गति से ब्राउज़ करें","adblocker.subheader":"विज्ञापन अवरोधक चालू करें","adblocker.label":"विज्ञापन अवरोधित करें","messengers.header":"सभी के साथ रहें","messengers.subheader":"अपनी पसंदीदा सोशल ऐप्स जोड़ें","import.failed_header":"आयात त्रुटि","import.failed_message":"कृपया सुनिश्चित करें कि कोई अन्य ब्राउज़र कार्य चल नहीं रहे हैं और पुनः प्रयास करें","import.header":"अपना डेटा इम्पोर्ट करें","import.subheader":"नीचे ब्राउज़र चुनें","outro.header":"आपका Opera ब्राउज़र तैयार है","outro.button":"ब्राउज़िंग प्रारंभ करें"}'),ht=JSON.parse('{"nav.later":"Kasnije","nav.prev":"Preth.","nav.next":"Sljedeće","nav.done":"Gotovo","intro.button":"Počnite","themes.header":"Kako ste raspoloženi?","themes.subheader":"Odaberite temu preglednika","themes.light":"Svijetla","themes.dark":"Tamna","themes.system":"Sustav","wallpapers.header":"Koji je vaš stil?","wallpapers.subheader":"Odaberite pozadinu početne stranice","adblocker.header":"Pregledavajte brže bez oglasa","adblocker.subheader":"Uključi blokiranje oglasa","adblocker.label":"Blokiranje oglasa","messengers.header":"Budite u toku sa svima","messengers.subheader":"Dodajte omiljene društvene aplikacije","import.failed_header":"GREŠKA UVOZA","import.failed_message":"Provjerite jesu li pokrenuti drugi zadaci preglednika i pokušajte ponovno","import.header":"Uvezite svoje podatke","import.subheader":"Odaberite preglednik u nastavku","outro.header":"Vaš preglednik Opera je spreman","outro.button":"Započni pregledavanje"}'),pt=JSON.parse('{"nav.later":"Később","nav.prev":"Előző","nav.next":"Következő","nav.done":"Kész","intro.button":"Kezdés","themes.header":"Milyen a hangulata?","themes.subheader":"Válasszon böngésző témát","themes.light":"Világos","themes.dark":"Sötét","themes.system":"Rendszer:","wallpapers.header":"Milyen a stílusa?","wallpapers.subheader":"Válasszon kezdőlap háttérképet","adblocker.header":"Böngésszen gyorsabban reklámmentesen","adblocker.subheader":"Reklámblokkolás bekapcsolása","adblocker.label":"Reklámok blokkolása","messengers.header":"Tartson lépést mindenkivel","messengers.subheader":"Kedvenc közösségi appok hozzáadása","import.failed_header":"IMPORTHIBA","import.failed_message":"Győződjön meg arról, hogy nincsenek más böngészőfeladatok futtatása és próbálja újra","import.header":"Adatok importálása","import.subheader":"Válasszon böngészőt alább","outro.header":"Opera böngészője készen van","outro.button":"Kezdje el a böngészést"}'),ft=JSON.parse('{"nav.later":"Nanti","nav.prev":"Sebelumnya","nav.next":"Selanjutnya","nav.done":"Selesai","intro.button":"Mulai","themes.header":"Bagaimana suasana hati Anda?","themes.subheader":"Memilih tema browser","themes.light":"Biasa","themes.dark":"Gelap","themes.system":"Sistem","wallpapers.header":"Bagaimana gaya Anda?","wallpapers.subheader":"Pilih wallpaper Halaman Awal","adblocker.header":"Jelajahi lebih cepat bebas iklan","adblocker.subheader":"Nyalakan pemblokir iklan","adblocker.label":"Blokir iklan","messengers.header":"Tetap terhubung dengan semua orang","messengers.subheader":"Tambahkan aplikasi sosial favorit Anda","import.failed_header":"KESALAHAN IMPOR","import.failed_message":"Pastikan tidak ada tugas peramban lain yang berjalan dan coba lagi","import.header":"Impor data Anda","import.subheader":"Pilih browser di bawah ini","outro.header":"Browser Opera Anda telah siap","outro.button":"Mulai menjelajah"}'),dt=JSON.parse('{"nav.later":"Dopo","nav.prev":"Precedente","nav.next":"Successivo","nav.done":"Fatto","intro.button":"Inizia","themes.header":"Di che umore sei?","themes.subheader":"Seleziona un tema del browser","themes.light":"Chiaro","themes.dark":"Scuro","themes.system":"Sistema","wallpapers.header":"Qual è il tuo stile?","wallpapers.subheader":"Seleziona uno sfondo per la pagina iniziale","adblocker.header":"Naviga più veloce e senza annunci","adblocker.subheader":"Attiva il blocco degli annunci pubblicitari","adblocker.label":"Blocco degli annunci","messengers.header":"Resta in contatto con tutti","messengers.subheader":"Aggiungi i tuoi social preferiti","import.failed_header":"ERRORE DI IMPORTAZIONE","import.failed_message":"Assicurati che non ci siano altre attività del browser in esecuzione e riprova","import.header":"Importa i tuoi dati","import.subheader":"Seleziona un browser qui sotto","outro.header":"Il tuo browser Opera è pronto","outro.button":"Inizia a navigare"}'),mt=JSON.parse('{"nav.later":"後で","nav.prev":"前へ","nav.next":"次へ","nav.done":"完了","intro.button":"始める","themes.header":"どうしますか？","themes.subheader":"ブラウザのテーマを選択","themes.light":"ライト","themes.dark":"ダーク","themes.system":"システム","wallpapers.header":"スタイルはどうしますか？","wallpapers.subheader":"スタートページの壁紙を選択","adblocker.header":"高速で無広告ブラウジング","adblocker.subheader":"広告ブロッカーを有効にする","adblocker.label":"広告のブロック","messengers.header":"みんなに合わせる","messengers.subheader":"お気に入りのソーシャルアプリを追加","import.failed_header":"インポートエラー","import.failed_message":"他のブラウザタスクが実行されていないことを確認して、もう一度お試しください","import.header":"データのインポート","import.subheader":"以下のブラウザを選択","outro.header":"ご利用の Opera ブラウザが利用できます","outro.button":"ブラウジングを開始"}'),gt=JSON.parse('{"nav.later":"나중에","nav.prev":"이전","nav.next":"다음","nav.done":"완료","intro.button":"시작하기","themes.header":"어떤 분위기를 원하세요?","themes.subheader":"브라우저 테마 선택","themes.light":"라이트","themes.dark":"다크","themes.system":"시스템","wallpapers.header":"어떤 스타일을 원하세요?","wallpapers.subheader":"시작 페이지 배경무늬 선택","adblocker.header":"더 빠르고 광고 없는 인터넷 탐색","adblocker.subheader":"광고 차단 기능 켜기","adblocker.label":"광고 차단","messengers.header":"모두와 연결되기","messengers.subheader":"좋아하는 소셜 앱 추가","import.failed_header":"가져오기 오류","import.failed_message":"다른 브라우저 작업이 실행되지 않도록 하고 다시 시도하십시오","import.header":"내 데이터 가져오기","import.subheader":"아래에서 브라우저 선택","outro.header":"Opera 브라우저 사용 준비 완료","outro.button":"브라우징 시작"}'),yt=JSON.parse('{"nav.later":"Vėliau","nav.prev":"Peržiūra","nav.next":"Toliau","nav.done":"Atlikta","intro.button":"Pradžia","themes.header":"Kokia jūsų nuotaika?","themes.subheader":"Pasirinkite naršyklės temą","themes.light":"Šviesi","themes.dark":"Tamsi","themes.system":"Sistema","wallpapers.header":"Koks jūsų stilius?","wallpapers.subheader":"Pasirinkite pradžios puslapio ekrano foną","adblocker.header":"Naršykite greičiau, nematydami reklamų","adblocker.subheader":"Įjungti reklamų blokavimą","adblocker.label":"Blokuoti reklamas","messengers.header":"Palaikykite ryšius","messengers.subheader":"Pridėkite mėgstamas socialinių tinklų programas","import.failed_header":"IMPORTAVIMO KLAIDA","import.failed_message":"Įsitikinkite, kad nevykdomos jokios kitos naršyklės užduotys ir bandykite dar kartą","import.header":"Importuokite savo duomenis","import.subheader":"Toliau pasirinkite naršyklę","outro.header":"Jūsų naršyklė „Opera“ paruošta","outro.button":"Pradėkite naršyti"}'),vt=JSON.parse('{"nav.later":"Vēlāk","nav.prev":"Iepr.","nav.next":"Nākamais","nav.done":"Gatavs","intro.button":"Darba sākšana","themes.header":"Kāds ir jūsu noskaņojums?","themes.subheader":"Atlasiet pārlūkprogrammas dizainu","themes.light":"Gaišs","themes.dark":"Tumšs","themes.system":"Sistēma","wallpapers.header":"Kāds ir jūsu stils?","wallpapers.subheader":"Atlasiet sākumlapas ekrāntapeti","adblocker.header":"Pārlūkojiet ātrāk bez reklāmām","adblocker.subheader":"Ieslēgt reklāmu bloķētāju","adblocker.label":"Reklāmu bloķēšana","messengers.header":"Sazinieties ar visiem","messengers.subheader":"Pievienojiet savas iecienītās sociālo tīklu lietotnes","import.failed_header":"IMPORTĒŠANAS KĻŪDA","import.failed_message":"Lūdzu, pārliecinieties, ka nav citas pārlūka uzdevumi un mēģiniet vēlreiz","import.header":"Importējiet savus datus","import.subheader":"Tālāk atlasiet pārlūkprogrammu","outro.header":"Pārlūkprogramma Opera ir gatava","outro.button":"Sākt pārlūkošanu"}'),bt=JSON.parse('{"nav.later":"Kemudian","nav.prev":"Sebelumnya","nav.next":"Seterusnya","nav.done":"Selesai","intro.button":"Mulakan","themes.header":"Apakah perasaan anda?","themes.subheader":"Pilih tema penyemak imbas","themes.light":"Terang","themes.dark":"Gelap","themes.system":"Sistem","wallpapers.header":"Apakah gaya anda?","wallpapers.subheader":"Pilih kertas hias dinding Halaman Permulaan","adblocker.header":"Semak imbas dengan lebih pantas tanpa iklan","adblocker.subheader":"Hidupkan penyekat iklan","adblocker.label":"Sekat iklan","messengers.header":"Ikuti perkembangan semua orang","messengers.subheader":"Tambah aplikasi sosial kegemaran anda","import.failed_header":"RALAT IMPORT","import.failed_message":"Sila pastikan tiada tugas pelayar lain yang berjalan dan cuba lagi","import.header":"Import data anda","import.subheader":"Pilih penyemak imbas di bawah","outro.header":"Penyemak imbas Opera anda sudah sedia","outro.button":"Mula melayar"}'),kt=JSON.parse('{"nav.later":"Senere","nav.prev":"Forrige","nav.next":"Neste","nav.done":"Fullført","intro.button":"Kom i gang","themes.header":"Hva med noe som passer til humøret?","themes.subheader":"Velg et nettlesertema","themes.light":"Lyst","themes.dark":"Mørkt","themes.system":"System","wallpapers.header":"Tilpass til din egen stil.","wallpapers.subheader":"Velg et bakgrunnsbilde for startsiden","adblocker.header":"Surf raskere, reklamefritt","adblocker.subheader":"Slå på annonseblokkering","adblocker.label":"Blokker annonser","messengers.header":"Hold kontakten med folk","messengers.subheader":"Legg til apper for sosiale nettverk","import.failed_header":"IMPORTFEIL","import.failed_message":"Sørg for at ingen andre nettleseroppgaver kjører og prøv igjen","import.header":"Importer dataene dine","import.subheader":"Velg en nettleser nedenfor","outro.header":"Opera-nettleseren er klar","outro.button":"Begynn å surfe"}'),xt=JSON.parse('{"nav.later":"Later","nav.prev":"Eerder","nav.next":"Volgende","nav.done":"Gereed","intro.button":"Aan de slag","themes.header":"Hoe is je humeur?","themes.subheader":"Selecteer een browserthema","themes.light":"Licht","themes.dark":"Donker","themes.system":"Systeem","wallpapers.header":"Wat is je stijl?","wallpapers.subheader":"Selecteer een wallpaper voor de startpagina","adblocker.header":"Sneller browsen zonder advertenties","adblocker.subheader":"Schakel ad blocker in","adblocker.label":"Blokkeer advertenties","messengers.header":"Blijf bij met iedereen","messengers.subheader":"Voeg je favoriete social apps toe","import.failed_header":"IMPORTFOUT","import.failed_message":"Zorg ervoor dat er geen andere browsertaken actief zijn en probeer het opnieuw","import.header":"Importeer je gegevens","import.subheader":"Selecteer hieronder een browser","outro.header":"Je Opera-browser is klaar","outro.button":"Begin met browsen"}'),St=JSON.parse('{"nav.later":"Później","nav.prev":"Wstecz","nav.next":"Dalej","nav.done":"Gotowe","intro.button":"Rozpocznij","themes.header":"W jakim jesteś nastroju?","themes.subheader":"Wybierz motyw przeglądarki","themes.light":"Jasny","themes.dark":"Ciemny","themes.system":"System","wallpapers.header":"Jaki masz styl?","wallpapers.subheader":"Wybierz tapetę strony startowej","adblocker.header":"Przeglądaj sieć szybciej i bez reklam","adblocker.subheader":"Włącz blokowanie reklam","adblocker.label":"Blokowanie reklam","messengers.header":"Pozostań w kontakcie","messengers.subheader":"Dodaj swoje ulubione aplikacje społecznościowe","import.failed_header":"BŁĄD IMPORTU","import.failed_message":"Upewnij się, że żadne inne zadania przeglądarki nie są uruchomione i spróbuj ponownie","import.header":"Zaimportuj swoje dane","import.subheader":"Wybierz przeglądarkę poniżej","outro.header":"Twoja przeglądarka Opera jest gotowa","outro.button":"Rozpocznij przeglądanie"}'),wt=JSON.parse('{"nav.later":"Mais tarde","nav.prev":"Anterior","nav.next":"Próximo","nav.done":"Concluído","intro.button":"Como começar","themes.header":"Qual é o seu estado de espírito?","themes.subheader":"Selecione um tema para o browser","themes.light":"Claro","themes.dark":"Escuro","themes.system":"Sistema","wallpapers.header":"Qual é o seu estilo?","wallpapers.subheader":"Selecione uma imagem de fundo para a Página inicial","adblocker.header":"Navegue mais rapidamente e sem anúncios","adblocker.subheader":"Ligar bloqueador de anúncios","adblocker.label":"Bloquear anúncios","messengers.header":"Mantenha-se atualizado","messengers.subheader":"Adicione as aplicações das suas redes sociais favoritas","import.failed_header":"ERRO DE IMPORTAÇÃO","import.failed_message":"Certifique-se de que nenhuma outra tarefa do navegador está em execução e tente novamente","import.header":"Importe os seus dados","import.subheader":"Selecione um browser abaixo","outro.header":"O seu browser Opera está pronto","outro.button":"Iniciar navegação"}'),Et=JSON.parse('{"nav.later":"Depois","nav.prev":"Anterior","nav.next":"Próximo","nav.done":"Concluído","intro.button":"Comece agora","themes.header":"Como está seu astral?","themes.subheader":"Selecione um tema para o navegador","themes.light":"Claro","themes.dark":"Escuro","themes.system":"Sistema","wallpapers.header":"Qual é o seu estilo?","wallpapers.subheader":"Selecione um papel de parede para a Página Inicial","adblocker.header":"Navegue mais rapidamente sem anúncios","adblocker.subheader":"Ative o bloqueador de anúncios","adblocker.label":"Bloquear anúncios","messengers.header":"Acompanhe todo mundo","messengers.subheader":"Adicione seus aplicativos de redes sociais favoritos","import.failed_header":"ERRO DE IMPORTAÇÃO","import.failed_message":"Certifique-se de que nenhuma outra tarefa do navegador esteja em execução e tente novamente","import.header":"Importe seus dados","import.subheader":"Selecione um navegador abaixo","outro.header":"Seu navegador Opera está pronto","outro.button":"Começar a navegar"}'),Pt=JSON.parse('{"nav.later":"Mai târziu","nav.prev":"Previzualizare","nav.next":"Următor","nav.done":"Gata","intro.button":"Începe","themes.header":"Cum te simți?","themes.subheader":"Selectează o temă pentru browser","themes.light":"Luminos","themes.dark":"Întunecat","themes.system":"Sistem","wallpapers.header":"Care este stilul tău?","wallpapers.subheader":"Selectează o imagine de fundal pentru Pagina de pornire","adblocker.header":"Navighează mai rapid și fără reclame","adblocker.subheader":"Activează blocatorul de reclame","adblocker.label":"Blocare reclame","messengers.header":"Ține pasul cu ceilalți","messengers.subheader":"Adaugă aplicațiile sociale favorite","import.failed_header":"EROARE DE IMPORT","import.failed_message":"Asigurați-vă că nu rulează alte sarcini ale browserului și încercați din nou","import.header":"Importă datele tale","import.subheader":"Selectează un browser mai jos","outro.header":"Browserul tău Opera este gata","outro.button":"Începe navigarea"}'),_t=JSON.parse('{"nav.later":"Позже","nav.prev":"Предпросмотр","nav.next":"Далее","nav.done":"Готово","intro.button":"Начать работу","themes.header":"Какое настроение у вас сегодня?","themes.subheader":"Выберите тему браузера","themes.light":"Светлая","themes.dark":"Темная","themes.system":"Система","wallpapers.header":"Какой стиль вам нравится?","wallpapers.subheader":"Выберите обои для начальной страницы","adblocker.header":"Открывайте сайты быстрее и без рекламы","adblocker.subheader":"Включите блокировку рекламы,","adblocker.label":"Блокировка рекламы","messengers.header":"Поддерживайте общение","messengers.subheader":"Добавьте любимые соцсети","import.failed_header":"ОШИБКА ИМПОРТА","import.failed_message":"Убедитесь, что другие задачи браузера не выполняются, и попробуйте снова","import.header":"Импортируйте свои данные","import.subheader":"Выберите браузер ниже","outro.header":"Ваш браузер Opera готов","outro.button":"Начать просмотр"}'),Ct=JSON.parse('{"nav.later":"Neskôr","nav.prev":"Predch.","nav.next":"Nasledujúce","nav.done":"Hotovo","intro.button":"Začať","themes.header":"Akú máte náladu?","themes.subheader":"Vyberte tému prehliadača","themes.light":"Svetlá","themes.dark":"Tmavá","themes.system":"Systém","wallpapers.header":"Aký máte štýl?","wallpapers.subheader":"Vyberte tapetu hlavného okna","adblocker.header":"Prehľadávajte internet rýchlejšie bez reklám","adblocker.subheader":"Zapnite blokovanie reklám","adblocker.label":"Blokovanie reklám","messengers.header":"Majte prehľad o každom","messengers.subheader":"Pridajte obľúbené sociálne aplikácie","import.failed_header":"CHYBA IMPORTU","import.failed_message":"Uistite sa, že nie sú spustené žiadne iné úlohy prehliadača a skúste to znova","import.header":"Importujte údaje","import.subheader":"Vyberte prehliadač nižšie","outro.header":"Váš prehliadač Opera je pripravený","outro.button":"Začnite prehliadať"}'),At=JSON.parse('{"nav.later":"Касније","nav.prev":"Претх.","nav.next":"Даље","nav.done":"Готово","intro.button":"Почните","themes.header":"Како сте расположени?","themes.subheader":"Изаберите тему прегледача","themes.light":"Светло","themes.dark":"Тамно","themes.system":"Систем","wallpapers.header":"Који је ваш стил?","wallpapers.subheader":"Изаберите позадину почетне стране","adblocker.header":"Прегледајте брже и без реклама","adblocker.subheader":"Укључите алатку за блокирање реклама","adblocker.label":"Блокирај рекламе","messengers.header":"Останите у контакту са свима","messengers.subheader":"Додајте своје омиљене друштвене апликације","import.failed_header":"ГРЕШКА У УВОЗУ","import.failed_message":"Молимо вас да проверите да ли нема других задатака у прегледачу и покушајте поново","import.header":"Увезите своје податке","import.subheader":"Изаберите преледач испод","outro.header":"Ваш прегледач Opera је спреман","outro.button":"Почните са прегледањем"}'),Tt=JSON.parse('{"nav.later":"Senare","nav.prev":"Föreg.","nav.next":"Nästa","nav.done":"Klart","intro.button":"Sätt igång","themes.header":"Vad känner du för?","themes.subheader":"Välj webbläsartema","themes.light":"Ljust","themes.dark":"Mörkt","themes.system":"System","wallpapers.header":"Vad är din stil?","wallpapers.subheader":"Välj en bakgrundsbild för startsidan","adblocker.header":"Surfa snabbare utan annonser","adblocker.subheader":"Slå på annonsblockeraren","adblocker.label":"Blockera annonser","messengers.header":"Håll koll på alla","messengers.subheader":"Lägg till dina favoritappar för sociala nätverk","import.failed_header":"IMPORTFEL","import.failed_message":"Se till att inga andra webbläsaruppgifter körs och försök igen","import.header":"Importera din data","import.subheader":"Välj en webbläsare nedan","outro.header":"Din Opera-webbläsare är redo","outro.button":"Börja surfa"}'),Mt=JSON.parse('{"nav.later":"Baadaye","nav.prev":"Awali","nav.next":"Inayofuata","nav.done":"Imekamilisha","intro.button":"Anza","themes.header":"Hali yako ni ipi?","themes.subheader":"Chagua mandhari ya kivinjari","themes.light":"Angavu","themes.dark":"Kolevu","themes.system":"Mfumo","wallpapers.header":"Mtindo wako ni upi?","wallpapers.subheader":"Chagua mandhari nyuma ya Ukurasa wa Kuanza","adblocker.header":"Vinjari kwa haraka bila matangazo","adblocker.subheader":"Washa kizuia matangazo","adblocker.label":"Zuia matangazo","messengers.header":"Endelea kushirikiana na kila mtu","messengers.subheader":"Weka programu unazozipenda za kijamii","import.failed_header":"KOSA LA KUAGIZA","import.failed_message":"Tafadhali hakikisha hakuna kazi zingine za kivinjari zinaendeshwa na ujaribu tena","import.header":"Ingiza data yako","import.subheader":"Chagua kivinjari hapa chini","outro.header":"Kivinjari chako cha Opera kiko tayari","outro.button":"Anza kuvinjari"}'),Dt=JSON.parse('{"nav.later":"பின்னர்","nav.prev":"முந்தையது","nav.next":"அடுத்து","nav.done":"முடிந்தது","intro.button":"தொடங்கவும்","themes.header":"உங்கள் மனநிலை எப்படி இருக்கிறது?","themes.subheader":"உலாவி தீமினைத் தேர்ந்தெடுக்கவும்","themes.light":"வெளிர்நிற தீம்","themes.dark":"அடர்நிற தீம்","themes.system":"சிஸ்டம்","wallpapers.header":"உங்கள் ஸ்டைல் என்ன?","wallpapers.subheader":"துவக்கப் பக்க வால்பேப்பரைத் தேர்ந்தெடுக்கவும்","adblocker.header":"விளம்பரங்கள் இல்லாமலும் இன்னும் வேகமாகவும் இணையத்தை உலாவுங்கள்","adblocker.subheader":"விளம்பரத் தடுப்பானை இயக்கவும்","adblocker.label":"விளம்பரங்களைத் தடு","messengers.header":"அனைவரிடமும் இணைப்பில் இருங்கள்","messengers.subheader":"உங்களுக்குப் பிடித்த சமூக ஊடகப் பயன்பாடுகளைச் சேருங்கள்","import.failed_header":"இறக்குமதி பிழை","import.failed_message":"தயவுசெய்து வேறு உலாவி பணிகள் இயங்கவில்லை என்பதை உறுதிப்படுத்தி மீண்டும் முயற்சி செய்யவும்","import.header":"உங்கள் தரவை இறக்குமதி செய்யுங்கள்","import.subheader":"கீழே ஒரு உலாவியைத் தேர்ந்தெடுக்கவும்","outro.header":"உங்கள் Opera உலாவி தயார்","outro.button":"உலாவத் தொடங்குங்கள்!"}'),It=JSON.parse('{"nav.later":"తరువాత","nav.prev":"మునుపటి","nav.next":"తదుపరి","nav.done":"పూర్తయ్యింది","intro.button":"ప్రారంభించండి","themes.header":"మీ మానసిక స్థితి ఏమిటి?","themes.subheader":"బ్రౌజర్ థీమ్‌ను ఎంచుకోండి","themes.light":"లేత రంగు","themes.dark":"ముదురు రంగు","themes.system":"సిస్టమ్","wallpapers.header":"మీ స్టైల్ ఏమిటి?","wallpapers.subheader":"ప్రారంభ పేజీ వాల్‌పేపర్‌ను ఎంచుకోండి","adblocker.header":"యాడ్ రహితంగా వేగంగా బ్రౌజ్ చేయండి","adblocker.subheader":"యాడ్ బ్లాకర్ ఆన్ చేయి","adblocker.label":"యాడ్‌లను బ్లాక్ చేయి","messengers.header":"అందరితో కలిసి ఉండండి","messengers.subheader":"మీకు ఇష్టమైన సామాజిక యాప్‌లను జోడించండి","import.failed_header":"దిగుమతి లోపం","import.failed_message":"దయచేసి ఇతర బ్రౌజర్ పనులు ప్రవహించని నిర్ధారించి మళ్ళీ ప్రయత్నించండి","import.header":"మీ డేటాను దిగుమతి చేయండి","import.subheader":"క్రింద ఒక బ్రౌజర్‌ను ఎంచుకోండి","outro.header":"మీ Opera బ్రౌజర్‌ సిద్ధంగా ఉంది","outro.button":"బ్రౌజింగ్‌ను ప్రారంభించండి"}'),Ft=JSON.parse('{"nav.later":"ภายหลัง","nav.prev":"ก่อนหน้า","nav.next":"ถัดไป","nav.done":"เสร็จสิ้น","intro.button":"เริ่มต้น","themes.header":"อารมณ์ของคุณเป็นอย่างไร","themes.subheader":"ตั้งค่าธีมของเบราว์เซอร์","themes.light":"สว่าง","themes.dark":"มืด","themes.system":"ระบบ","wallpapers.header":"สไตล์ของคุณเป็นอย่างไร","wallpapers.subheader":"เลือกวอลล์เปเปอร์ของหน้าเริ่มต้น","adblocker.header":"ท่องเว็บได้เร็วขึ้นแบบไม่มีโฆษณา","adblocker.subheader":"เปิดตัวบล็อกโฆษณา","adblocker.label":"บล็อกโฆษณา","messengers.header":"ทันข่าวสารกับทุกคน","messengers.subheader":"เพิ่มแอบโซเชียลแอปโปรดของคุณ","import.failed_header":"ข้อผิดพลาดในการนำเข้า","import.failed_message":"โปรดตรวจสอบให้แน่ใจว่าไม่มีงานเบราว์เซอร์อื่น ๆ ที่กำลังทำงานและลองอีกครั้ง","import.header":"นำเข้าข้อมูลของคุณ","import.subheader":"เลือกเบราว์เซอร์ด้านล่างนี้","outro.header":"เบราว์เซอร์ Opera ของคุณพร้อมแล้ว","outro.button":"เริ่มการเรียกดู"}'),Ot=JSON.parse('{"nav.later":"Saka na","nav.prev":"Nauna","nav.next":"Susunod","nav.done":"Tapos na","intro.button":"Magsimula","themes.header":"Ano’ng mood mo?","themes.subheader":"Pumili ng tema ng browser","themes.light":"Maliwanag","themes.dark":"Madilim","themes.system":"System","wallpapers.header":"Ano’ng istilo mo?","wallpapers.subheader":"Pumili ng wallpaper ng Start Page","adblocker.header":"Mag-browse nang mas mabilis nang walang ad","adblocker.subheader":"I-on ang ad blocker","adblocker.label":"Ad blocker","messengers.header":"Makasabay sa lahat","messengers.subheader":"Idagdag ang mga paborito mong social app","import.failed_header":"KAMALIAN SA PAG-ANGKAT","import.failed_message":"Pakisigurado na walang ibang mga gawain sa browser na tumatakbo at subukan muli","import.header":"I-import ang iyong data","import.subheader":"Pumili ng browser sa ibaba","outro.header":"Handa na ang iyong Opera browser","outro.button":"Simulan ang pag-browse"}'),Rt=JSON.parse('{"nav.later":"Daha sonra","nav.prev":"Önceki","nav.next":"Sonraki","nav.done":"Tamam","intro.button":"Başlayın","themes.header":"Ruh halin nedir?","themes.subheader":"Bir tarayıcı teması seç","themes.light":"Aydınlık","themes.dark":"Karanlık","themes.system":"Sistem","wallpapers.header":"Stilin nedir?","wallpapers.subheader":"Bir Başlangıç Sayfası duvar kağıdı seç","adblocker.header":"Daha hızlı reklamsız gezin","adblocker.subheader":"Reklam engelleyiciyi aç","adblocker.label":"Reklamları engelle","messengers.header":"Herkese ayak uydur","messengers.subheader":"Favori sosyal uygulamalarını ekle","import.failed_header":"İÇE AKTARMA HATASI","import.failed_message":"Lütfen başka tarayıcı görevlerinin çalışmadığından emin olun ve tekrar deneyin","import.header":"Verilerini al","import.subheader":"Aşağıdan bir tarayıcı seç","outro.header":"Opera tarayıcın hazır","outro.button":"Gezinmeye başlayın"}'),Lt=JSON.parse('{"nav.later":"Не зараз","nav.prev":"Назад","nav.next":"Далі","nav.done":"Готово","intro.button":"Почати","themes.header":"Який у вас настрій?","themes.subheader":"Виберіть тему браузера","themes.light":"Світла","themes.dark":"Темна","themes.system":"Система","wallpapers.header":"Який у вас стиль?","wallpapers.subheader":"Виберіть шпалери для початкової сторінки","adblocker.header":"Переглядайте веб-сторінки швидше й без реклами","adblocker.subheader":"Увімкніть блокування реклами","adblocker.label":"Блокування реклами","messengers.header":"Залишайтеся на зв’язку","messengers.subheader":"Додайте улюблені програми соцмереж","import.failed_header":"ПОМИЛКА ІМПОРТУ","import.failed_message":"Будь ласка, переконайтеся, що жодні інші завдання браузера не виконуються, і спробуйте ще раз","import.header":"Імпортуйте свої дані","import.subheader":"Виберіть браузер нижче","outro.header":"Ваш браузер Opera готовий","outro.button":"Почати веб-перегляд"}'),Nt=JSON.parse('{"nav.later":"Sau","nav.prev":"Trước","nav.next":"Tiếp","nav.done":"Xong","intro.button":"Bắt đầu","themes.header":"Tâm trạng của bạn là gì?","themes.subheader":"Chọn một chủ đề cho trình duyệt","themes.light":"Sáng","themes.dark":"Tối","themes.system":"Hệ thống","wallpapers.header":"Phong cách của bạn là gì?","wallpapers.subheader":"Chọn một hình nền cho Trang bắt đầu","adblocker.header":"Duyệt không quảng cáo nhanh hơn","adblocker.subheader":"Bật trình chặn quảng cáo lên","adblocker.label":"Chặn quảng cáo","messengers.header":"Theo kịp với mọi người","messengers.subheader":"Thêm các ứng dụng mạng xã hội yêu thích của bạn","import.failed_header":"LỖI NHẬP KHẨU","import.failed_message":"Vui lòng đảm bảo không có nhiệm vụ trình duyệt khác đang chạy và thử lại","import.header":"Nhập vệ dữ liệu của bạn","import.subheader":"Chọn một trình duyệt dưới đây","outro.header":"Trình duyệt Opera của bạn đã sẵn sàng","outro.button":"Bắt đầu duyệt"}'),Vt=JSON.parse('{"nav.later":"稍后","nav.prev":"上一步","nav.next":"下一步","nav.done":"完成","intro.button":"入门指南","themes.header":"您的心情如何？","themes.subheader":"选择浏览器主题","themes.light":"浅色","themes.dark":"深色","themes.system":"系统","wallpapers.header":"您的风格是什么？","wallpapers.subheader":"选择首页墙纸","adblocker.header":"浏览速度更快，无广告","adblocker.subheader":"开启广告拦截","adblocker.label":"拦截广告","messengers.header":"关注任何人","messengers.subheader":"添加您最喜欢的社交应用","import.failed_header":"导入错误","import.failed_message":"请确保没有其他浏览器任务正在运行，然后重试","import.header":"导入您的数据","import.subheader":"在下面选择一个浏览器","outro.header":"您的 Opera 浏览器已就绪","outro.button":"开始浏览"}'),Bt=JSON.parse('{"nav.later":"稍後","nav.prev":"上一頁","nav.next":"下一頁","nav.done":"完成","intro.button":"開始使用","themes.header":"您的心情如何？","themes.subheader":"選取瀏覽器佈景主題","themes.light":"淺色","themes.dark":"暗色","themes.system":"系統","wallpapers.header":"您的風格是什麼？","wallpapers.subheader":"選取開始頁面桌布","adblocker.header":"瀏覽速度更快，無廣告","adblocker.subheader":"開啟廣告阻擋功能","adblocker.label":"阻擋廣告","messengers.header":"追蹤任何人","messengers.subheader":"新增您最喜愛的社交應用程式","import.failed_header":"導入錯誤","import.failed_message":"請確保沒有其他瀏覽器任務正在運行，然後重試","import.header":"匯入您的資料","import.subheader":"在下面選取一個瀏覽器","outro.header":"您的 Opera 瀏覽器已就緒","outro.button":"開始瀏覽"}');var zt,jt;we.use(Qe).use(De).init({lng:null===(zt=chrome)||void 0===zt||null===(jt=zt.i18n)||void 0===jt?void 0:jt.getUILanguage(),fallbackLng:"en-GB",resources:{bg:{translation:Xe},bn:{translation:Ze},ca:{translation:et},cs:{translation:tt},da:{translation:nt},de:{translation:rt},el:{translation:at},"en-GB":{translation:it},"es-419":{translation:st},es:{translation:ot},fi:{translation:lt},fr:{translation:ut},hi:{translation:ct},hr:{translation:ht},hu:{translation:pt},id:{translation:ft},it:{translation:dt},ja:{translation:mt},ko:{translation:gt},lt:{translation:yt},lv:{translation:vt},ms:{translation:bt},no:{translation:kt},nl:{translation:xt},pl:{translation:St},"pt-PT":{translation:wt},"pt-BR":{translation:Et},ro:{translation:Pt},ru:{translation:_t},sk:{translation:Ct},sr:{translation:At},sv:{translation:Tt},sw:{translation:Mt},ta:{translation:Dt},te:{translation:It},th:{translation:Ft},tl:{translation:Ot},tr:{translation:Rt},uk:{translation:Lt},vi:{translation:Nt},"zh-CN":{translation:Vt},"zh-TW":{translation:Bt}},keySeparator:!1,nsSeparator:!1,react:{useSuspense:!1},detection:{order:["querystring","navigator","htmlTag","path","subdomain"],caches:[]}});var Gt=__webpack_require__(3379),Ht=__webpack_require__.n(Gt),qt=__webpack_require__(7795),Ut=__webpack_require__.n(qt),Wt=__webpack_require__(569),$t=__webpack_require__.n(Wt),Kt=__webpack_require__(8575),Jt=__webpack_require__.n(Kt),Yt=__webpack_require__(9216),Qt=__webpack_require__.n(Yt),Xt=__webpack_require__(4589),Zt=__webpack_require__.n(Xt),en=__webpack_require__(9580),tn={attributes:{source:"opera-intro"}};tn.styleTagTransform=Zt(),tn.setAttributes=Jt(),tn.insert=$t().bind(null,"head"),tn.domAPI=Ut(),tn.insertStyleElement=Qt();Ht()(en.Z,tn);en.Z&&en.Z.locals&&en.Z.locals;var nn=__webpack_require__(4963),rn={attributes:{source:"opera-intro"}};rn.styleTagTransform=Zt(),rn.setAttributes=Jt(),rn.insert=$t().bind(null,"head"),rn.domAPI=Ut(),rn.insertStyleElement=Qt();Ht()(nn.Z,rn);nn.Z&&nn.Z.locals&&nn.Z.locals;var an,sn,on=function(e){opr.introductionPrivate.closeIntroduction(e)},ln="dt_wp_standard_8.0";!function(e){e[e.NORMAL=opr.statsPrivate.Priority.NORMAL]="NORMAL",e[e.IMPORTANT=opr.statsPrivate.Priority.IMPORTANT]="IMPORTANT"}(an||(an={})),function(e){e.CLICK="click",e.VIEW="view"}(sn||(sn={}));var un=function(e,t,n){var r={type:e,section:t,page:ln};n&&(r.str_value=n),opr.statsPrivate.recordSessionEvent("feature_events.event_welcome_and_upgrade_page_metric",JSON.stringify(r),an.NORMAL)};function cn(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(!e)return;if("string"==typeof e)return hn(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return hn(e,t)}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,a=function(){};return{s:a,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,o=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return s=e.done,e},e:function(e){o=!0,i=e},f:function(){try{s||null==n.return||n.return()}finally{if(o)throw i}}}}function hn(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}var pn,fn,dn,mn=new Set,gn=function(){var e=t(v().mark((function e(){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,new Promise((function(e){chrome.tabs.getCurrent(e)}));case 2:return e.abrupt("return",!e.sent);case 3:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}(),yn=function(){chrome.tabs.update(void 0,{url:"chrome://startpageshared"})},vn=function(){var e=t(v().mark((function e(){var t,n,r;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,gn();case 2:t=e.sent,n=cn(mn);try{for(n.s();!(r=n.n()).done;)(0,r.value)(t)}catch(e){n.e(e)}finally{n.f()}case 5:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}();chrome.tabs.onActivated.addListener(vn),function(e){e.WELCOME="welcome",e.SETUP="setup",e.DONE="done"}(pn||(pn={})),function(e){e.NONE="none",e.THEME="theme",e.WALLPAPER="wallpaper",e.ADBLOCKER="adblocker",e.MESSENGERS="messengers",e.IMPORT="import",e.SUMMARY="summary"}(fn||(fn={})),function(e){e.INTRO="intro_slide",e.THEME="theme_slide",e.WALLPAPERS="wallpapers_slide",e.ADBLOCK="adblock_slide",e.MESSENGERS="messengers_slide",e.IMPORT="import_slide",e.OUTRO="outro_slide"}(dn||(dn={}));var bn=function(){var e=localStorage.getItem("route");return e&&Object.keys(pn).includes(e)?e:pn.WELCOME},kn=function(e){var t=localStorage.getItem("feature");return e===pn.SETUP?t&&Object.keys(fn).includes(t)&&t!==fn.NONE?t:fn.THEME:fn.NONE},xn={BeVietnamProBold:{family:"Be Vietnam Pro",weight:700,size:48},BeVietnamProRegular:{family:"Be Vietnam Pro",weight:400,size:24},SpaceMonoBold:{family:"Space Mono",weight:700,size:48},SpaceMonoRegular:{family:"Space Mono",weight:400,size:24},AvertaRegular:{family:"Averta",weight:400,size:15}};function Sn(e){return wn.apply(this,arguments)}function wn(){return(wn=t(v().mark((function e(t){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.prev=0,e.next=3,document.fonts.load("normal ".concat(t.weight," ").concat(t.size,'px "').concat(t.family,'"'));case 3:return e.abrupt("return",!0);case 6:return e.prev=6,e.t0=e.catch(0),console.warn("Failed to load font: ".concat(t.family)),e.abrupt("return",!1);case 10:case"end":return e.stop()}}),e,null,[[0,6]])})))).apply(this,arguments)}function En(){return En=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},En.apply(this,arguments)}function Pn(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return{className:_n(t)}}function _n(e){if(!e)return"";if("string"==typeof e)return e;if(Array.isArray(e))return e.reduce((function(e,t){return t?"string"==typeof t?(e.push(t),e):(e.push(_n(t)),e):e}),[]).filter((function(e){return e})).join(" ");if("object"===r(e))return 0===Object.keys(e).length?"":Object.keys(e).map((function(t){return e[t]&&t})).filter((function(e){return e})).join(" ");throw new Error("Invalid value: ".concat(JSON.stringify(e)))}var Cn;!function(e){e.FORWARD="forward",e.BACKWARD="backward"}(Cn||(Cn={}));var An,Tn="start",Mn="end",Dn="key-nav";!function(e){e[e.START=1]="START",e[e.ITEM=2]="ITEM",e[e.SKIP=3]="SKIP",e[e.DOT=4]="DOT",e[e.NAV=5]="NAV",e[e.END=6]="END"}(An||(An={}));var In,Fn,On=function(e){"Tab"===e.code&&function(e,t){var n=document.activeElement.classList;if(n.contains(Dn))if(t===Cn.BACKWARD){if(document.activeElement===document.body||n.contains(Tn)){var r=document.querySelector(".".concat(Dn,".").concat(Mn));null==r||r.focus(),e.preventDefault()}}else if(document.activeElement===document.body||n.contains(Mn)){var a=document.querySelector(".".concat(Dn,".").concat(Tn));null==a||a.focus(),e.preventDefault()}}(e,e.shiftKey?Cn.BACKWARD:Cn.FORWARD)},Rn=function(e){var t=e.isStart,n=(0,b.useRef)(null);return(0,b.useEffect)((function(){n.current&&t&&n.current.focus()}),[t,n]),b.createElement("span",En({ref:n},Pn(Dn,t?Tn:Mn),{tabIndex:t?An.START:An.END}))};function Ln(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(!e)return;if("string"==typeof e)return Nn(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return Nn(e,t)}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,a=function(){};return{s:a,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,o=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return s=e.done,e},e:function(e){o=!0,i=e},f:function(){try{s||null==n.return||n.return()}finally{if(o)throw i}}}}function Nn(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}!function(e){e[e.SYSTEM=-1]="SYSTEM",e[e.LIGHT=0]="LIGHT",e[e.DARK=1]="DARK"}(In||(In={})),function(e){e.DARK_THEME="ui.dark_skin",e.COLOR_THEME="ui.dark_skin_settings_proxy",e.AD_BLOCKER_ENABLED="adblocker.enabled"}(Fn||(Fn={}));var Vn=new Set,Bn=function(e){return new Promise((function(t){chrome.settingsPrivate.getPref(e,(function(e){t(e.value)}))}))},zn=function(e,t){chrome.settingsPrivate.setPref(e,t,ln)},jn=function(e,t){var n={name:e,listener:t};return Vn.add(n),Bn(e).then(t),function(){Vn.delete(n)}},Gn=function(e){zn(Fn.COLOR_THEME,e)},Hn=function(e){return jn(Fn.COLOR_THEME,e)},qn=function(){return Bn(Fn.DARK_THEME)},Un=function(e){return jn(Fn.DARK_THEME,e)},Wn=function(e){zn(Fn.AD_BLOCKER_ENABLED,e)},$n=function(e){return jn(Fn.AD_BLOCKER_ENABLED,(function(t){e(t)}))};chrome.settingsPrivate.onPrefsChanged.addListener((function(e){var t,n=Ln(e);try{for(n.s();!(t=n.n()).done;){var r,a=t.value,i=Ln(Vn);try{for(i.s();!(r=i.n()).done;){var s=r.value;a.key===s.name&&s.listener(a.value)}}catch(e){i.e(e)}finally{i.f()}}}catch(e){n.e(e)}finally{n.f()}}));const Kn=__webpack_require__.p+"185145efabf50976fdfb.jpg",Jn=__webpack_require__.p+"91bfc672d518e05bf02d.jpg",Yn=__webpack_require__.p+"99aaaf6a69b4e18c92b0.jpg",Qn=__webpack_require__.p+"384b42a608fce5d4a1d6.jpg",Xn=__webpack_require__.p+"0968ac62b8504efada7a.jpg",Zn=__webpack_require__.p+"439f3447a96cad7c116c.jpg",er=__webpack_require__.p+"dc8e6d22f2d58eab7e86.jpg",tr=__webpack_require__.p+"d92eb252936a5b7d251c.jpg",nr=__webpack_require__.p+"16bdf796f3ba68f0e3b6.jpg",rr=__webpack_require__.p+"b989550d0ff55f3e681a.jpg",ar=__webpack_require__.p+"2d3a5e698cd1a50a25a3.jpg",ir=__webpack_require__.p+"36ccdd1bf26354d5ce27.jpg";function sr(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(!e)return;if("string"==typeof e)return or(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return or(e,t)}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,a=function(){};return{s:a,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,o=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return s=e.done,e},e:function(e){o=!0,i=e},f:function(){try{s||null==n.return||n.return()}finally{if(o)throw i}}}}function or(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function lr(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function ur(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?lr(Object(n),!0).forEach((function(t){x(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):lr(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}var cr;!function(e){e.DEFAULT="bundled%2Fdefault",e.LOW_GLOW="opera-one-lowglow",e.DARK_LIGHT="opera-one-darklight",e.GREEN_HIGH="a37be41c44b408ae9fa991a4681760eefb1d8994",e.PINK_HIGH="626beaaeca74e01c1f5d162df8502adb90901d13",e.PURPLE_HIGH="f31a840daa258e607b5f5e0bebfd4f9f9ecaac00"}(cr||(cr={}));var hr,pr=function(e,t){var n=(t?fr:dr).find((function(t){return t.id===e.id}));return n?ur(ur({},n),{},{textColor:e.titleTextColor,shadowColor:e.titleTextShadowColor}):null},fr=[{id:cr.DEFAULT,background:rr,thumbnail:Qn},{id:cr.DARK_LIGHT,background:ar,thumbnail:Xn},{id:cr.PINK_HIGH,background:ir,thumbnail:Zn}],dr=[{id:cr.GREEN_HIGH,background:tr,thumbnail:Jn},{id:cr.PURPLE_HIGH,background:nr,thumbnail:Yn},{id:cr.LOW_GLOW,background:er,thumbnail:Kn}],mr=function(){return new Promise((function(e){opr.wallpapersPrivate.getSelected((function(t){e(t)}))}))},gr=function(){var e=t(v().mark((function e(t){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,yr(t);case 2:if(!e.sent){e.next=6;break}kr(t),e.next=8;break;case 6:return e.next=8,br(t);case 8:case"end":return e.stop()}}),e)})));return function(t){return e.apply(this,arguments)}}(),yr=function(){var e=t(v().mark((function e(t){var n;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,vr();case 2:return n=e.sent,e.abrupt("return",n.map((function(e){return e.id})).includes(t));case 4:case"end":return e.stop()}}),e)})));return function(t){return e.apply(this,arguments)}}(),vr=function(){return new Promise((function(e){opr.wallpapersPrivate.getInstalled((function(t){e(t)}))}))},br=function(e){return new Promise((function(t){chrome.addonsPrivate.installTheme(e,t)}))},kr=function(e){return new Promise((function(t){opr.wallpapersPrivate.select(e,t)}))},xr=new Set,Sr=function(e){return xr.add(e),mr().then(e),function(){xr.delete(e)}},wr=function(){var e=t(v().mark((function e(){var t,n,r;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,mr();case 2:t=e.sent,n=sr(xr);try{for(n.s();!(r=n.n()).done;)(0,r.value)(t)}catch(e){n.e(e)}finally{n.f()}case 5:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}();function Er(e){var t=e.isReady,n=g((0,b.useState)(null),2),r=n[0],a=n[1],i=g((0,b.useState)(!1),2),s=i[0],o=i[1];(0,b.useEffect)((function(){return Un((function(e){return o(e)}))}),[]),(0,b.useEffect)((function(){return Sr((function(e){a(e?pr(e,s):null)}))}),[s]);var l=t&&r?r.background:null;return b.createElement("section",{className:"background"},b.createElement("div",{className:"active base layer"}),b.createElement("div",Pn({active:t&&!s},"light","layer")),b.createElement("div",Pn({active:t&&s},"dark","layer")),l&&b.createElement("div",{className:"active wallpaper layer",style:{backgroundImage:"url(".concat(l,")")}}))}function Pr(e){return(0,b.useEffect)((function(){e.isActive&&un(sn.VIEW,e.section)}),[e.isActive,e.section]),b.createElement("section",{id:e.name,className:"page"},b.createElement("div",{className:"content"},b.createElement("div",{className:"header"},b.createElement("h1",{className:_n(["title",{wide:e.title.length>=25&&e.title.length<40,widest:e.title.length>=40}])},e.title),b.createElement("h2",{className:"subtitle"},e.subtitle)),b.createElement("div",{className:"feature"},e.children)))}opr.wallpapersPrivate.onSelectionChanged.addListener(wr),function(e){e.FORWARD="forward",e.BACKWARD="backward"}(hr||(hr={}));var _r=function(e,t){["Enter","Space"].includes(e.code)&&t()};function Cr(e){var t=e.slides,n=e.isOverlay,r=e.active,a=e.later,i=e.prev,s=e.next,o=e.goTo,l=e.done,u=t[r-1].feature,c=(0,b.useContext)(Za).popup;return b.createElement("div",{className:"navigation"},b.createElement("div",{className:"controls"},b.createElement("div",{className:"left"},n&&![fn.THEME,fn.WALLPAPER].includes(u)&&b.createElement("span",{className:"later link",onClick:a,onKeyDown:function(e){return _r(e,a)},tabIndex:c?void 0:An.SKIP},Ee("nav.later"))),b.createElement("div",{className:"right"},r>1&&b.createElement("span",{className:"prev link",onClick:i,onKeyDown:function(e){return _r(e,i)},tabIndex:c?void 0:An.NAV},Ee("nav.prev")),b.createElement("span",{className:"next link",onClick:r===t.length?l:s,onKeyDown:function(e){return _r(e,r===t.length?l:s)},tabIndex:c?void 0:An.NAV},r===t.length?Ee("nav.done"):Ee("nav.next")))),b.createElement("div",{className:"pagination"},b.createElement("div",{className:"dots"},t.map((function(e,t){var n=t+1===r,a=function(){n||o(t+1)};return b.createElement("span",{onClick:a,onKeyDown:function(e){return _r(e,a)},key:t,className:_n(["dot",{active:n}]),tabIndex:c?void 0:An.DOT})})))))}function Ar(e){var t=e.slides,n=e.isOverlay,r=e.isReady,a=(0,b.useContext)(Za),i=a.feature,s=a.setFeature,o=a.setRoute,l=t.findIndex((function(e){return e.feature===i}))+1,u=g((0,b.useState)(hr.FORWARD),2),c=u[0],h=u[1],p=g((0,b.useState)(fn.NONE),2),f=p[0],d=p[1],m=(0,b.useRef)(fn.NONE);(0,b.useEffect)((function(){m.current!==i&&d(m.current),m.current=i}),[i]);var y=function(e){var n=t[l-1].section;un(sn.CLICK,n,"".concat(e,"_button"))},v=function(e){h(e>l?hr.FORWARD:hr.BACKWARD),s(t[e-1].feature)};return b.createElement("div",{className:_n(["gallery",c])},b.createElement("div",{className:"screens"},t.map((function(e,n){var r=n+1,a=1===r,s=r===t.length-1,o=e.feature===fn.SUMMARY,l=e.feature===f,u=e.feature===i,c=e.content;return b.createElement("div",{key:n,className:_n(["screen",{dismissed:l,active:u}])},b.createElement(Pr,{key:n,name:e.feature,section:e.section,title:e.title,subtitle:e.subtitle,number:r,isFirst:a,isLast:s,isSummary:o,isDismissed:l,isActive:u},b.createElement(c,{isActive:u})))}))),r&&l>0&&l<=t.length&&b.createElement(Cr,{isOverlay:n,slides:t,active:l,later:function(){y("later"),e.isOverlay&&on(!0)},prev:function(){v(l-1),y("back")},next:function(){v(l+1),y("next")},goTo:function(e){v(e),y("dot")},done:function(){o(pn.DONE),s(fn.NONE),y("next")}}))}function Tr(){var e=Ee("outro.header");return b.createElement("section",{id:"summary"},b.createElement("div",{className:"content"},b.createElement("div",{className:"header"},b.createElement("h1",{className:"title"},e),b.createElement("span",{className:"start"},Ee("outro.button"))),b.createElement("section",{className:"preview"},b.createElement("i",{className:"desktop"}),b.createElement("i",{className:"android"}),b.createElement("i",{className:"ios"}))))}function Mr(e){var t=e.isReady,n=e.isOverlay,r=e.slides,a=(0,b.useContext)(Za).route;return b.createElement("section",{className:"contents"+(t?" ready":"")},b.createElement("i",{className:"opera-logo"}),a!==pn.DONE&&b.createElement(Ar,{isOverlay:n,isReady:t,slides:r}),t&&a===pn.DONE&&b.createElement(Tr,null))}var Dr=function(e,t,n){var r=e.steps[0],a=new KeyframeEffect(t,r.keyframes,{duration:r.duration,delay:r.delay,easing:r.easing,fill:"forwards",pseudoElement:n}),i=new Animation(a,document.timeline);i.play(),i.onfinish=function(){var t,n;null===(t=e.onStepFinished)||void 0===t||t.call(e,r.name),null===(n=r.onFinished)||void 0===n||n.call(r)}},Ir=function(e,t){Dr({name:"welcome",steps:[{name:"focus",duration:1800,delay:0,easing:"ease-in-out",keyframes:[{opacity:0,filter:"blur(20px)",offset:0},{opacity:1,filter:"blur(20px)",offset:.6},{opacity:1,filter:"blur(0)",offset:1}],onFinished:t}]},e,null)},Fr=function(e,t,n,r,a){Dr({name:"disappear",steps:[{name:"fade out",duration:n,delay:r,easing:"ease-in-out",keyframes:[{opacity:1},{opacity:0}],onFinished:a}]},e,t)},Or=function(e,t,n,r,a){Dr({name:"shrink",steps:[{name:"shink",duration:n,delay:r,easing:"ease-in-out",keyframes:[{width:"".concat(e.offsetWidth,"px")},{width:0}],onFinished:a}]},e,t)},Rr=function(e,t,n,r,a){var i=getComputedStyle(e),s=parseFloat(i.paddingLeft),o=parseFloat(i.paddingRight),l=e.offsetWidth-s-o;Dr({name:"shrink",steps:[{name:"shink",duration:n,delay:r,easing:"ease-in-out",keyframes:[{transform:"scale(1)"},{transform:"scale(".concat(window.innerWidth/l,")")}],onFinished:a}]},e,t)};function Lr(e){var t=(0,b.useRef)(),n=(0,b.useRef)(),r=e.isTriggered,a=e.onFinished;return(0,b.useEffect)((function(){if(t.current&&n.current){var e=t.current,r=n.current;r.style.width="".concat(r.offsetWidth,"px"),r.style.boxSizing="border-box",Ir(e)}}),[t,n]),(0,b.useEffect)((function(){if(r&&t.current&&n.current){var e=t.current,i=n.current;e.style.pointerEvents="none",Fr(i,null,500,0,(function(){i.style.padding="0",Or(i,null,300,0,(function(){e.classList.add("active"),Rr(e,null,1400,200,(function(){a()}))}))}))}}),[r,a,t,n]),b.createElement("span",{ref:t,className:"get-started"},b.createElement("span",{ref:n,className:"label"},b.createElement("span",{className:"logo"}),b.createElement("span",{className:"text"},Ee("intro.button"))))}function Nr(e){var t=(0,b.useRef)();return(0,b.useEffect)((function(){un(sn.VIEW,dn.INTRO)}),[]),b.createElement("section",{className:"overlay",ref:t},b.createElement("div",{className:"container"},b.createElement(Lr,{isTriggered:e.isAnimationTriggered,onFinished:e.onAnimationFinished})))}const Vr=__webpack_require__.p+"88a9d8b720fa47faa0f7.png",Br=__webpack_require__.p+"a9a94f26040d1d617ba5.png",zr=__webpack_require__.p+"5481ba37652e144d94d4.png",jr=__webpack_require__.p+"cda076c0b79d73963c46.png",Gr=__webpack_require__.p+"38560e363670f4539ebf.png";function Hr(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(!e)return;if("string"==typeof e)return qr(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return qr(e,t)}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,a=function(){};return{s:a,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,o=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return s=e.done,e},e:function(e){o=!0,i=e},f:function(){try{s||null==n.return||n.return()}finally{if(o)throw i}}}}function qr(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}var Ur,Wr;!function(e){e.CHROME="chrome",e.EDGE="edge",e.FIREFOX="firefox",e.SAFARI="safari",e.GX="gx"}(Ur||(Ur={})),function(e){e.CHROME="Chrome",e.EDGE="Microsoft Edge",e.FIREFOX="Mozilla Firefox",e.SAFARI="Safari",e.GX="Opera GX"}(Wr||(Wr={}));var $r,Kr,Jr=function(e){switch(e){case Wr.CHROME:return Vr;case Wr.EDGE:return Br;case Wr.SAFARI:return jr;case Wr.FIREFOX:return zr;case Wr.GX:return Gr}};!function(e){e.COOKIES="cookies",e.HISTORY="history",e.FAVORITES="favorites",e.PASSWORDS="passwords",e.SEARCH_ENGINES="search_engines",e.AUTOFILL_FORM_DATA="autofill_form_data"}($r||($r={})),function(e){e.NONE="",e.SUCCESS="success",e.FAILURE="failure"}(Kr||(Kr={}));var Yr=function(e){return localStorage.getItem(e)||Kr.NONE},Qr=function(){var e=t(v().mark((function e(){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",new Promise((function(e){opr.importPrivate.detectImporters((function(t){var n=t.filter((function(e){return Object.values(Wr).includes(e.name)}));e(n)}))})));case 1:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}(),Xr=function(){var e=localStorage.getItem("importFailedData");return e?JSON.parse(e):[]},Zr=function(e){var t=function(e){var t=Xr(),n=[];if(0===t.length)return n;var r=e.name,a=t.find((function(e){return e.browserName==r}));return a?a.browserName===Wr.FIREFOX?e.supportedServices:n.concat(a.failed):n}(e),n=0!==t.length?t:e.supportedServices;return new Promise((function(t){opr.importPrivate.importData(e.id,n,(function(n){var r,a;"Import failed"===(null===(r=chrome.runtime.lastError)||void 0===r?void 0:r.message)?(a=Kr.FAILURE,n&&ea(n,e.name)):a=Kr.SUCCESS,function(e,t){localStorage.setItem(e,t),aa()}(e.name,a),t(a)}))}))},ea=function(e,t){var n={browserName:t,failed:e},r=Xr();r.some((function(n){return n.failed==e&&n.browserName==t}))||r.push(n),localStorage.setItem("importFailedData",JSON.stringify(r))},ta=function(){var e=t(v().mark((function e(){var t,n,r;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,Qr();case 2:return t=e.sent,n=Xr(),r=function(e,r,a){var i,s=Yr(r);s===Kr.NONE&&(n.find((function(e){return e.browserName===r}))&&(s=Kr.FAILURE));return{key:e,name:r,label:a,icon:Jr(r),importer:null!==(i=t.find((function(e){return e.name===r})))&&void 0!==i?i:null,state:s}},e.abrupt("return",[r(Ur.CHROME,Wr.CHROME,Ee("browser.chrome")),r(Ur.EDGE,Wr.EDGE,Ee("browser.edge")),r(Ur.SAFARI,Wr.SAFARI,Ee("browser.safari")),r(Ur.FIREFOX,Wr.FIREFOX,Ee("browser.firefox")),r(Ur.GX,Wr.GX,Ee("browser.gx"))]);case 6:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}(),na=function(){for(var e=[],t=0,n=Object.values(Wr);t<n.length;t++){var r=n[t];Yr(r)===Kr.SUCCESS&&e.push(r)}return e},ra=new Set,aa=function(){var e,t=na(),n=Hr(ra);try{for(n.s();!(e=n.n()).done;){(0,e.value)(t)}}catch(e){n.e(e)}finally{n.f()}};window.addEventListener("storage",aa);var ia=function(e){return e===Kr.FAILURE?{type:e,header:Ee("import.failed_header"),message:Ee("import.failed_message")}:null};function sa(e){return b.createElement("span",{className:"close",onClick:e.onClose,tabIndex:An.SKIP,onKeyDown:function(t){["Enter","Space"].includes(t.code)&&(e.onClose(),t.preventDefault())}},b.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",width:"12",height:"13",viewBox:"0 0 12 13",fill:"none"},b.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M0.526544 0.743196C0.208356 1.06746 0.208355 1.59319 0.526543 1.91745L4.8794 6.35339L0.23864 11.0827C-0.0795473 11.407 -0.0795466 11.9327 0.238641 12.257C0.556829 12.5812 1.07271 12.5812 1.3909 12.257L6.03166 7.52765L10.6088 12.1922C10.927 12.5164 11.4429 12.5164 11.7611 12.1922C12.0793 11.8679 12.0793 11.3422 11.7611 11.0179L7.18392 6.35339L11.4732 1.98227C11.7914 1.65801 11.7914 1.13228 11.4732 0.808014C11.155 0.483753 10.6391 0.483753 10.3209 0.808014L6.03166 5.17914L1.6788 0.743196C1.36062 0.418935 0.844731 0.418935 0.526544 0.743196Z",fill:"var(--primary-text-color)"})))}function oa(e){return b.createElement(b.Fragment,null,b.createElement("div",{key:"fade",className:"fade",onClick:e.onClose}),b.createElement("div",En({key:"popup"},Pn("popup",e.type)),b.createElement("div",{className:"header"},b.createElement("span",null,e.header),b.createElement(sa,{onClose:e.onClose})),e.message&&b.createElement("div",{className:"message"},e.message)))}function la(e){var t=e.isOverlay,n=e.isReady,r=e.slides,a=e.startBrowsing,i=e.closeIntroduction,s=(0,b.useContext)(Za),o=s.route,l=s.setRoute,u=s.feature,c=s.setFeature,h=s.popup,p=s.setPopup,f=[pn.DONE,pn.SETUP].includes(o),d=g((0,b.useState)(!1),2),m=d[0],y=d[1],v=(0,b.useCallback)((function(){y(!0),un(sn.CLICK,dn.INTRO,"launch_button")}),[]);(0,b.useEffect)((function(){var e;e=r[0],c(e.feature)}),[r.length]),(0,b.useEffect)((function(){var e=function(e){if(On(e),h)"Escape"===e.code&&p(null);else{if("Escape"===e.code&&t&&(o===pn.SETUP&&i(),o===pn.DONE&&a()),["Enter","Space"].includes(e.code))switch(o){case pn.WELCOME:v();break;case pn.DONE:a()}if(o===pn.SETUP){var n=function(e){c(r[e-1].feature)};r.map((function(e,t){return String(t+1)})).includes(e.key)&&n(parseInt(e.key));var s=r.findIndex((function(e){return e.feature===u}))+1;"ArrowRight"===e.key&&(s<r.length?n(s+1):(l(pn.DONE),c(fn.NONE))),"ArrowLeft"===e.key&&s>1&&n(s-1)}}};return document.addEventListener("keydown",e),function(){document.removeEventListener("keydown",e)}}),[t,r,o,l,u,c,h,p,v,a,i]);var k=ia(h);return b.createElement("main",En({},Pn(["onboarding",o,{hidden:!n}]),{onMouseDownCapture:function(e){if(0===e.button)switch(o){case pn.WELCOME:v();break;case pn.DONE:a()}},onContextMenuCapture:function(e){e.preventDefault(),e.stopPropagation()}}),b.createElement(Rn,{isStart:!0}),b.createElement(Er,{isReady:f}),b.createElement(Mr,{isOverlay:t,isReady:f,slides:r,startBrowsing:a,onSetupFinished:function(){l(pn.DONE),c(fn.NONE)}}),h&&k&&b.createElement(oa,{type:h,header:k.header,message:k.message,onClose:function(){p(null)}}),o===pn.WELCOME&&b.createElement(Nr,{isAnimationTriggered:m,onAnimationFinished:function(){var e=r[0];l(pn.SETUP),c(e.feature)}}),b.createElement(Rn,{isStart:!1}))}var ua=__webpack_require__(1248),ca=__webpack_require__.n(ua);function ha(e){var t=b.useRef(null),n=b.useRef(null);return b.useEffect((function(){var r,a;n.current&&(t.current||(t.current=ca().loadAnimation({container:n.current,renderer:"svg",animationData:e.animationData,loop:null===(r=e.loop)||void 0===r||r,autoplay:null===(a=e.autoplay)||void 0===a||a,initialSegment:e.frames}),e.onComplete&&t.current.addEventListener("complete",e.onComplete)))}),[t,e.animationData,e.loop,e.autoplay,e.frames,e.onComplete]),b.useEffect((function(){t&&(t.current=t.current)}),[t]),b.createElement("div",{ref:n})}const pa=JSON.parse('{"v":"5.9.0","fr":30,"ip":0,"op":35,"w":704,"h":440,"nm":"THEMES-onboarding-adblocker_DARK","ddd":0,"assets":[{"id":"comp_0","nm":"AD-darkmode","fr":30,"layers":[{"ddd":0,"ind":1,"ty":4,"nm":"close Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[707.25,682.75,0],"ix":2,"l":2},"a":{"a":0,"k":[6.5,5,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[0,0],[0,0]],"o":[[0,0],[0,0]],"v":[[10.391,8.539],[2.566,1.468]],"c":false},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"st","c":{"a":0,"k":[1,1,1,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":1.5,"ix":5},"lc":1,"lj":1,"ml":4,"bm":0,"nm":"Stroke 1","mn":"ADBE Vector Graphic - Stroke","hd":false},{"ind":2,"ty":"sh","ix":3,"ks":{"a":0,"k":{"i":[[0,0],[0,0]],"o":[[0,0],[0,0]],"v":[[2.57,8.539],[10.395,1.468]],"c":false},"ix":2},"nm":"Path 2","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"st","c":{"a":0,"k":[1,1,1,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":1.5,"ix":5},"lc":1,"lj":1,"ml":4,"bm":0,"nm":"Stroke 2","mn":"ADBE Vector Graphic - Stroke","hd":false}],"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":2,"ty":4,"nm":"mask-ad","td":1,"sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[652.75,772,0],"ix":2,"l":2},"a":{"a":0,"k":[42,60,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-8.837,0],[0,0],[0,-8.837],[0,0],[8.837,0],[0,0],[0,8.837],[0,0]],"o":[[0,0],[8.837,0],[0,0],[0,8.837],[0,0],[-8.837,0],[0,0],[0,-8.837]],"v":[[16,0],[68,0],[84,16],[84,104],[68,120],[16,120],[0,104],[0,16]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.729411764706,0.674509803922,0.823529471603,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":3,"ty":4,"nm":"gradient","tt":1,"sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[652.75,712,0],"ix":2,"l":2},"a":{"a":0,"k":[-380.211,76.607,0],"ix":1,"l":2},"s":{"a":0,"k":[121.087,121.087,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ty":"gr","it":[{"d":1,"ty":"el","s":{"a":0,"k":[229.039,229.039],"ix":2},"p":{"a":0,"k":[0,0],"ix":3},"nm":"Ellipse Path 1","mn":"ADBE Vector Shape - Ellipse","hd":false},{"ty":"gf","o":{"a":0,"k":100,"ix":10},"r":1,"bm":0,"g":{"p":3,"k":{"a":0,"k":[0.403,0.094,0.082,0.118,0.701,0.122,0.098,0.182,1,0.149,0.114,0.247],"ix":9}},"s":{"a":0,"k":[0,0],"ix":5},"e":{"a":0,"k":[94.125,64.18],"ix":6},"t":2,"h":{"a":0,"k":0,"ix":7},"a":{"a":0,"k":0,"ix":8},"nm":"Gradient Fill 1","mn":"ADBE Vector Graphic - G-Fill","hd":false},{"ty":"tr","p":{"a":0,"k":[-380.211,76.607],"ix":2},"a":{"a":0,"k":[0,0],"ix":1},"s":{"a":0,"k":[157.36,157.36],"ix":3},"r":{"a":0,"k":0,"ix":6},"o":{"a":0,"k":100,"ix":7},"sk":{"a":0,"k":0,"ix":4},"sa":{"a":0,"k":0,"ix":5},"nm":"Transform"}],"nm":"Ellipse 1","np":2,"cix":2,"bm":0,"ix":1,"mn":"ADBE Vector Group","hd":false}],"ip":0,"op":178,"st":0,"bm":0}]}],"layers":[{"ddd":0,"ind":1,"ty":4,"nm":"tic","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[-347,109,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":25,"s":[100,100,100]},{"t":29,"s":[10,10,100]}],"ix":6,"l":2}},"ao":0,"shapes":[{"ty":"gr","it":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[0,0],[0,0],[0,0]],"o":[[0,0],[0,0],[0,0]],"v":[[-373.25,110.75],[-351.312,133.188],[-321.75,87.75]],"c":false},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":1},"e":{"a":1,"k":[{"i":{"x":[0.667],"y":[0.306]},"o":{"x":[0.333],"y":[0]},"t":16,"s":[0]},{"i":{"x":[0.667],"y":[-5.25]},"o":{"x":[0.333],"y":[6.25]},"t":20,"s":[36]},{"i":{"x":[0.419],"y":[0.998]},"o":{"x":[0.333],"y":[0.293]},"t":21,"s":[36]},{"t":24,"s":[100]}],"ix":2},"o":{"a":0,"k":0,"ix":3},"m":1,"ix":2,"nm":"Trim Paths 1","mn":"ADBE Vector Filter - Trim","hd":false},{"ty":"st","c":{"a":0,"k":[0.301960784314,0.301960784314,0.400000029919,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":9,"ix":5},"lc":2,"lj":2,"bm":0,"nm":"Stroke 1","mn":"ADBE Vector Graphic - Stroke","hd":false},{"ty":"tr","p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":1},"s":{"a":0,"k":[100,100],"ix":3},"r":{"a":0,"k":0,"ix":6},"o":{"a":0,"k":100,"ix":7},"sk":{"a":0,"k":0,"ix":4},"sa":{"a":0,"k":0,"ix":5},"nm":"Transform"}],"nm":"Shape 1","np":3,"cix":2,"bm":0,"ix":1,"mn":"ADBE Vector Group","hd":false}],"ip":16,"op":29,"st":-44,"bm":0},{"ddd":0,"ind":2,"ty":4,"nm":"adblock-icon Outlines","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":12,"s":[0]},{"t":14,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[352,249.5,0],"ix":2,"l":2},"a":{"a":0,"k":[40,40,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":12,"s":[10,10,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":14,"s":[220,220,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":18,"s":[180,180,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":24,"s":[200,200,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":25,"s":[200,200,100]},{"t":29,"s":[10,10,100]}],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-4.994,0.921],[-1.246,-0.231],[-3.544,-1.604],[0,-1.73],[0,0],[5.595,-3.317],[0,0],[1.591,0.945],[0,0],[0,6.182],[0,0],[-1.673,0.754]],"o":[[1.246,-0.231],[4.994,0.921],[1.668,0.754],[0,0],[0,6.182],[0,0],[-1.591,0.945],[0,0],[-5.6,-3.317],[0,0],[0,-1.73],[3.539,-1.604]],"v":[[38.138,10.173],[41.852,10.173],[63.961,15.288],[66.662,19.341],[66.662,45.098],[57.682,60.349],[42.599,69.291],[37.391,69.291],[22.313,60.349],[13.328,45.098],[13.328,19.341],[16.034,15.288]],"c":true},"ix":2},"nm":"Path 2","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.011764705882,0.023529411765,0.082352941176,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":12,"op":29,"st":-48,"bm":0},{"ddd":0,"ind":3,"ty":0,"nm":"AD-darkmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":8,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":12,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":27,"s":[0]},{"t":31,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[553.896,246.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.146,768.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":3,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":6,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":12,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,1]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":27,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,0]},"t":30,"s":[81.36,81.36,100]},{"t":37,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":4,"ty":0,"nm":"AD-darkmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":7,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":11,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":26,"s":[0]},{"t":30,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353.896,246.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.146,768.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":2,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":5,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":11,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,1]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":26,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,0]},"t":29,"s":[81.36,81.36,100]},{"t":36,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":5,"ty":0,"nm":"AD-darkmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":6,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":10,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":25,"s":[0]},{"t":29,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[153.896,246.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.146,768.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":1,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":4,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":10,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,1]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":25,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,0]},"t":28,"s":[81.36,81.36,100]},{"t":35,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":6,"ty":4,"nm":"browser-bg-top Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[350,57,0],"ix":2,"l":2},"a":{"a":0,"k":[158,12,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-4.418,0],[0,0],[0,-4.418],[0,0],[4.418,0],[0,0],[0,4.418],[0,0]],"o":[[0,0],[4.418,0],[0,0],[0,4.418],[0,0],[-4.418,0],[0,0],[0,-4.418]],"v":[[8,0],[308,0],[316,8],[316,16],[308,24],[8,24],[0,16],[0,8]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.301960784314,0.301960784314,0.4,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":7,"ty":4,"nm":"browser-bg-bottom Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[158,76,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-6.627,0],[0,0],[0,-6.627],[0,0],[6.627,0],[0,0],[0,6.627],[0,0]],"o":[[0,0],[6.627,0],[0,0],[0,6.627],[0,0],[-6.627,0],[0,0],[0,-6.627]],"v":[[12,0],[304,0],[316,12],[316,140],[304,152],[12,152],[0,140],[0,12]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.301960784314,0.301960784314,0.4,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":8,"ty":4,"nm":"browser-bg-all","sr":1,"ks":{"o":{"a":0,"k":50,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[158,76,0],"ix":1,"l":2},"s":{"a":0,"k":[210.526,210.526,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-6.627,0],[0,0],[0,-6.627],[0,0],[6.627,0],[0,0],[0,6.627],[0,0]],"o":[[0,0],[6.627,0],[0,0],[0,6.627],[0,0],[-6.627,0],[0,0],[0,-6.627]],"v":[[12,-33.25],[303.525,-33.25],[315.525,-21.25],[315.525,143.8],[303.525,155.8],[12,155.8],[0,143.8],[0,-21.25]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.011764705882,0.023529411765,0.082352941176,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0}],"markers":[]}'),fa=JSON.parse('{"v":"5.9.0","fr":30,"ip":0,"op":35,"w":704,"h":440,"nm":"THEMES-onboarding-adblocker","ddd":0,"assets":[{"id":"comp_0","nm":"AD-lightmode","fr":30,"layers":[{"ddd":0,"ind":1,"ty":4,"nm":"close Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[707.25,682.75,0],"ix":2,"l":2},"a":{"a":0,"k":[6.5,5,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[0,0],[0,0]],"o":[[0,0],[0,0]],"v":[[10.391,8.539],[2.566,1.468]],"c":false},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"st","c":{"a":0,"k":[1,1,1,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":1.5,"ix":5},"lc":1,"lj":1,"ml":4,"bm":0,"nm":"Stroke 1","mn":"ADBE Vector Graphic - Stroke","hd":false},{"ind":2,"ty":"sh","ix":3,"ks":{"a":0,"k":{"i":[[0,0],[0,0]],"o":[[0,0],[0,0]],"v":[[2.57,8.539],[10.395,1.468]],"c":false},"ix":2},"nm":"Path 2","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"st","c":{"a":0,"k":[1,1,1,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":1.5,"ix":5},"lc":1,"lj":1,"ml":4,"bm":0,"nm":"Stroke 2","mn":"ADBE Vector Graphic - Stroke","hd":false}],"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":2,"ty":4,"nm":"mask-ad","td":1,"sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[652.75,772,0],"ix":2,"l":2},"a":{"a":0,"k":[42,60,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-8.837,0],[0,0],[0,-8.837],[0,0],[8.837,0],[0,0],[0,8.837],[0,0]],"o":[[0,0],[8.837,0],[0,0],[0,8.837],[0,0],[-8.837,0],[0,0],[0,-8.837]],"v":[[16,0],[68,0],[84,16],[84,104],[68,120],[16,120],[0,104],[0,16]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.729411764706,0.674509803922,0.823529471603,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":178,"st":0,"bm":0},{"ddd":0,"ind":3,"ty":4,"nm":"gradient","tt":1,"sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[1000,662,0],"ix":2,"l":2},"a":{"a":0,"k":[0,0,0],"ix":1,"l":2},"s":{"a":0,"k":[100,100,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ty":"gr","it":[{"d":1,"ty":"el","s":{"a":0,"k":[229.039,229.039],"ix":2},"p":{"a":0,"k":[0,0],"ix":3},"nm":"Ellipse Path 1","mn":"ADBE Vector Shape - Ellipse","hd":false},{"ty":"gf","o":{"a":0,"k":100,"ix":10},"r":1,"bm":0,"g":{"p":5,"k":{"a":0,"k":[0.141,0.741,0.792,0.933,0.326,0.72,0.759,0.918,0.511,0.698,0.725,0.902,0.756,0.712,0.7,0.865,1,0.725,0.675,0.827],"ix":9}},"s":{"a":0,"k":[0,0],"ix":5},"e":{"a":0,"k":[94.125,64.18],"ix":6},"t":2,"h":{"a":0,"k":0,"ix":7},"a":{"a":0,"k":0,"ix":8},"nm":"Gradient Fill 1","mn":"ADBE Vector Graphic - G-Fill","hd":false},{"ty":"tr","p":{"a":0,"k":[-380.211,76.607],"ix":2},"a":{"a":0,"k":[0,0],"ix":1},"s":{"a":0,"k":[157.36,157.36],"ix":3},"r":{"a":0,"k":0,"ix":6},"o":{"a":0,"k":100,"ix":7},"sk":{"a":0,"k":0,"ix":4},"sa":{"a":0,"k":0,"ix":5},"nm":"Transform"}],"nm":"Ellipse 1","np":2,"cix":2,"bm":0,"ix":1,"mn":"ADBE Vector Group","hd":false}],"ip":0,"op":178,"st":0,"bm":0}]}],"layers":[{"ddd":0,"ind":1,"ty":4,"nm":"tic","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[-347,109,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":25,"s":[100,100,100]},{"t":29,"s":[10,10,100]}],"ix":6,"l":2}},"ao":0,"shapes":[{"ty":"gr","it":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[0,0],[0,0],[0,0]],"o":[[0,0],[0,0],[0,0]],"v":[[-373.25,110.75],[-351.312,133.188],[-321.75,87.75]],"c":false},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":1},"e":{"a":1,"k":[{"i":{"x":[0.667],"y":[0.306]},"o":{"x":[0.333],"y":[0]},"t":16,"s":[0]},{"i":{"x":[0.667],"y":[-5.25]},"o":{"x":[0.333],"y":[6.25]},"t":20,"s":[36]},{"i":{"x":[0.419],"y":[0.998]},"o":{"x":[0.333],"y":[0.293]},"t":21,"s":[36]},{"t":24,"s":[100]}],"ix":2},"o":{"a":0,"k":0,"ix":3},"m":1,"ix":2,"nm":"Trim Paths 1","mn":"ADBE Vector Filter - Trim","hd":false},{"ty":"st","c":{"a":0,"k":[1,1,1,1],"ix":3},"o":{"a":0,"k":100,"ix":4},"w":{"a":0,"k":9,"ix":5},"lc":2,"lj":2,"bm":0,"nm":"Stroke 1","mn":"ADBE Vector Graphic - Stroke","hd":false},{"ty":"tr","p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":1},"s":{"a":0,"k":[100,100],"ix":3},"r":{"a":0,"k":0,"ix":6},"o":{"a":0,"k":100,"ix":7},"sk":{"a":0,"k":0,"ix":4},"sa":{"a":0,"k":0,"ix":5},"nm":"Transform"}],"nm":"Shape 1","np":3,"cix":2,"bm":0,"ix":1,"mn":"ADBE Vector Group","hd":false}],"ip":16,"op":29,"st":-44,"bm":0},{"ddd":0,"ind":2,"ty":4,"nm":"adblock-icon Outlines","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":12,"s":[0]},{"t":14,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[352,249.5,0],"ix":2,"l":2},"a":{"a":0,"k":[40,40,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":12,"s":[10,10,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":14,"s":[220,220,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":18,"s":[180,180,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":24,"s":[200,200,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":25,"s":[200,200,100]},{"t":29,"s":[10,10,100]}],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-4.994,0.921],[-1.246,-0.231],[-3.544,-1.604],[0,-1.73],[0,0],[5.595,-3.317],[0,0],[1.591,0.945],[0,0],[0,6.182],[0,0],[-1.673,0.754]],"o":[[1.246,-0.231],[4.994,0.921],[1.668,0.754],[0,0],[0,6.182],[0,0],[-1.591,0.945],[0,0],[-5.6,-3.317],[0,0],[0,-1.73],[3.539,-1.604]],"v":[[38.138,10.173],[41.852,10.173],[63.961,15.288],[66.662,19.341],[66.662,45.098],[57.682,60.349],[42.599,69.291],[37.391,69.291],[22.313,60.349],[13.328,45.098],[13.328,19.341],[16.034,15.288]],"c":true},"ix":2},"nm":"Path 2","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.58431372549,0.580392156863,0.776470648074,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":12,"op":29,"st":-48,"bm":0},{"ddd":0,"ind":3,"ty":0,"nm":"AD-lightmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":8,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":12,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":25,"s":[0]},{"t":29,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[554.396,247.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.396,769.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":3,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":6,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":12,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,-25.627]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":25,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,77.204]},"t":28,"s":[81.36,81.36,100]},{"t":35,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":4,"ty":0,"nm":"AD-lightmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":7,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":11,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":25,"s":[0]},{"t":29,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[354.396,247.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.396,769.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":2,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":5,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":11,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,1]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":25,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,0]},"t":28,"s":[81.36,81.36,100]},{"t":35,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":5,"ty":0,"nm":"AD-lightmode","refId":"comp_0","sr":1,"ks":{"o":{"a":1,"k":[{"i":{"x":[0.667],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":6,"s":[100]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.333],"y":[0]},"t":10,"s":[0]},{"i":{"x":[0.833],"y":[1]},"o":{"x":[0.167],"y":[0]},"t":25,"s":[0]},{"t":29,"s":[100]}],"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[154.396,247.029,0],"ix":2,"l":2},"a":{"a":0,"k":[654.396,769.029,0],"ix":1,"l":2},"s":{"a":1,"k":[{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":1,"s":[100,100,100]},{"i":{"x":[0.667,0.667,0.667],"y":[1,1,1]},"o":{"x":[0.333,0.333,0.333],"y":[0,0,0]},"t":4,"s":[110,110,100]},{"i":{"x":[0.833,0.833,0.833],"y":[1,1,1]},"o":{"x":[0.167,0.167,0.167],"y":[0,0,0]},"t":10,"s":[10,10,100]},{"i":{"x":[0.811,0.811,0.648],"y":[0.773,0.773,1]},"o":{"x":[0.157,0.157,0.157],"y":[0,0,0]},"t":25,"s":[10,10,100]},{"i":{"x":[0.57,0.57,0.805],"y":[0.98,0.98,1]},"o":{"x":[0.125,0.125,0.438],"y":[1.335,1.335,0]},"t":28,"s":[81.36,81.36,100]},{"t":35,"s":[100,100,100]}],"ix":6,"l":2}},"ao":0,"w":2000,"h":1324,"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":6,"ty":4,"nm":"browser-bg-top Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[350,57,0],"ix":2,"l":2},"a":{"a":0,"k":[158,12,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-4.418,0],[0,0],[0,-4.418],[0,0],[4.418,0],[0,0],[0,4.418],[0,0]],"o":[[0,0],[4.418,0],[0,0],[0,4.418],[0,0],[-4.418,0],[0,0],[0,-4.418]],"v":[[8,0],[308,0],[316,8],[316,16],[308,24],[8,24],[0,16],[0,8]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[1,1,1,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":7,"ty":4,"nm":"browser-bg-bottom Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[158,76,0],"ix":1,"l":2},"s":{"a":0,"k":[200,200,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-6.627,0],[0,0],[0,-6.627],[0,0],[6.627,0],[0,0],[0,6.627],[0,0]],"o":[[0,0],[6.627,0],[0,0],[0,6.627],[0,0],[-6.627,0],[0,0],[0,-6.627]],"v":[[12,0],[304,0],[316,12],[316,140],[304,152],[12,152],[0,140],[0,12]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[1,1,1,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0},{"ddd":0,"ind":8,"ty":4,"nm":"browser-bg-all","sr":1,"ks":{"o":{"a":0,"k":50,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[353,249,0],"ix":2,"l":2},"a":{"a":0,"k":[158,76,0],"ix":1,"l":2},"s":{"a":0,"k":[210.526,210.526,100],"ix":6,"l":2}},"ao":0,"shapes":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":0,"k":{"i":[[-6.627,0],[0,0],[0,-6.627],[0,0],[6.627,0],[0,0],[0,6.627],[0,0]],"o":[[0,0],[6.627,0],[0,0],[0,6.627],[0,0],[-6.627,0],[0,0],[0,-6.627]],"v":[[12,-33.25],[303.525,-33.25],[315.525,-21.25],[315.525,143.8],[303.525,155.8],[12,155.8],[0,143.8],[0,-21.25]],"c":true},"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"fl","c":{"a":0,"k":[0.58431372549,0.580392156863,0.776470588235,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false}],"ip":0,"op":36,"st":0,"bm":0}],"markers":[]}');var da=function(e){var t=e.isDarkTheme?pa:fa;return b.createElement("span",{className:"preview",key:String(e.enabled)},b.createElement(ha,{animationData:t,frames:e.enabled?[0,24]:[24,36],autoplay:!0,loop:!1}))};function ma(e){var t=g((0,b.useState)(!1),2),n=t[0],r=t[1],a=g((0,b.useState)(!1),2),i=a[0],s=a[1],o=e.isActive;(0,b.useEffect)((function(){$n(r),Un((function(e){return s(e)})),qn().then((function(e){return s(e)}))}),[]);var l=function(){Wn(!n),un(sn.CLICK,dn.ADBLOCK,"enable_adblock_button:".concat(n?0:1))};return b.createElement(b.Fragment,null,b.createElement(da,{key:String(i),enabled:n,isDarkTheme:i}),b.createElement("div",{className:"tile adblock"},b.createElement("span",{className:"label"},Ee("adblocker.label")),b.createElement("input",{type:"checkbox",onChange:l,onKeyDown:function(e){"Enter"===e.code&&l()},checked:n,tabIndex:o?An.ITEM:void 0})))}function ga(){return b.createElement("span",{className:"spinner"},b.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",xmlnsXlink:"http://www.w3.org/1999/xlink",viewBox:"0 0 32 32"},b.createElement("defs",null,b.createElement("linearGradient",{id:"a",x1:"-102.13",y1:"91.03",x2:"-103.54",y2:"92.08",gradientTransform:"matrix(10.5 0 0 -8.75 1092.5 822)",gradientUnits:"userSpaceOnUse"},b.createElement("stop",{offset:"0",stopColor:"#fff",stopOpacity:"0"}),b.createElement("stop",{offset:"1",stopColor:"#c8c9d0"})),b.createElement("linearGradient",{id:"b",x1:"-103.1",y1:"92.71",x2:"-101.98",y2:"91.27",gradientTransform:"matrix(10.5 0 0 -8.75 1096 816.75)",xlinkHref:"#a"})),b.createElement("rect",{width:"32",height:"32",rx:"16",ry:"16",opacity:".6"}),b.createElement("g",null,b.createElement("path",{d:"M8 13.5a2 2 0 0 1 2 2.08 6.08 6.08 0 0 0 5.86 6.25 5.48 5.48 0 0 0 2.54-.62 1.88 1.88 0 0 1 2.54 1.09 2.1 2.1 0 0 1-.94 2.61A8.46 8.46 0 0 1 15.77 26C10.4 26 6 21.31 6 15.58a2 2 0 0 1 2-2.08z",fill:"url(#a)"}),b.createElement("path",{d:"M24.07 18.5a2 2 0 0 1-1.93-2.08 6.05 6.05 0 0 0-5.79-6.25 5.36 5.36 0 0 0-2.51.62 1.81 1.81 0 0 1-2.61-.79A2.14 2.14 0 0 1 12 7.15c.05-.06.15-.06.19-.11a8.82 8.82 0 0 1 4.16-1C21.66 6 26 10.69 26 16.42a2 2 0 0 1-1.93 2.08z",fill:"url(#b)"}))))}function ya(e){var t=e.classNames,n=e.hasTabIndex,r=e.onClick,a=e.onMouseEnter,i=e.onMouseLeave,s=e.children;return b.createElement("span",{onClick:r,onMouseEnter:a,onMouseLeave:i,onKeyDown:function(e){["Enter","Space"].includes(e.code)&&r()},tabIndex:n?An.ITEM:void 0,className:_n(["tile",t])},s)}function va(){return b.createElement("svg",{style:{display:"none"},id:"svgfilters",xmlns:"http://www.w3.org/2000/svg"},b.createElement("defs",null,b.createElement("filter",{id:"light-grey-filter",x:"-10%",y:"-10%",width:"120%",height:"120%",filterUnits:"objectBoundingBox",primitiveUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},b.createElement("feColorMatrix",{type:"matrix",values:"1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0",in:"SourceGraphic",result:"colormatrix"}),b.createElement("feComponentTransfer",{in:"colormatrix",result:"componentTransfer"},b.createElement("feFuncR",{type:"table",tableValues:"0.75"}),b.createElement("feFuncG",{type:"table",tableValues:"0.75"}),b.createElement("feFuncB",{type:"table",tableValues:"0.75"}),b.createElement("feFuncA",{type:"table",tableValues:"0 1"})),b.createElement("feBlend",{mode:"color",in:"componentTransfer",in2:"SourceGraphic",result:"blend"}))))}function ba(){return b.createElement("div",{className:"overlay-icon"},b.createElement("div",{className:"check"}))}function ka(){return b.createElement("div",{className:"overlay-icon cross"},b.createElement("svg",{width:"25",height:"24",viewBox:"0 0 24 24",fill:"none",xmlns:"http://www.w3.org/2000/svg"},b.createElement("circle",{cx:"12",cy:"12",r:"12",fill:"#E24C5E"}),b.createElement("path",{d:"M7.65552 15.921L11.5789 11.9976L7.65552 8.07416L8.87397 6.85571L12.7974 10.7791L16.7208 6.85571L17.9392 8.07416L14.0158 11.9976L17.9392 15.921L16.7208 17.1394L12.7974 13.216L8.87397 17.1394L7.65552 15.921Z",fill:"white",transform:"translate(-0.5, 0)"})))}function xa(e){var n=e.browser,r=n.icon,a=n.importer,i=n.state,s=n.label,o=g((0,b.useState)(!1),2),l=o[0],u=o[1],c=function(){var n=t(v().mark((function t(){return v().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return u(!0),t.next=3,e.onImport(e.browser);case 3:u(!1);case 4:case"end":return t.stop()}}),t)})));return function(){return n.apply(this,arguments)}}();return b.createElement(ya,{onClick:i!==Kr.SUCCESS&&a&&!l?c:void 0,classNames:[{disabled:!a,available:a&&i!==Kr.SUCCESS,imported:i===Kr.SUCCESS,selected:i===Kr.SUCCESS,failed:i===Kr.FAILURE}],hasTabIndex:e.hasTabIndex},b.createElement("span",{className:"browser"},b.createElement("span",{className:"icon"},b.createElement("i",{style:{backgroundImage:"url(".concat(r,")")}}),i===Kr.SUCCESS&&b.createElement(ba,null),i===Kr.FAILURE&&b.createElement(ka,null),l&&b.createElement(ga,null)),b.createElement("span",{className:"name"},s)))}function Sa(e){var n=g((0,b.useState)([]),2),r=n[0],a=n[1],i=(0,b.useContext)(Za),s=i.popup,o=i.setPopup,l=e.isActive;(0,b.useEffect)((function(){ta().then(a)}),[]);var u=function(){var e=t(v().mark((function e(t){return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return un(sn.CLICK,dn.IMPORT,"import_button:".concat(t.key)),e.next=3,Zr(t.importer);case 3:return e.sent===Kr.FAILURE&&o(Kr.FAILURE),e.t0=a,e.next=8,ta();case 8:e.t1=e.sent,(0,e.t0)(e.t1);case 10:case"end":return e.stop()}}),e)})));return function(t){return e.apply(this,arguments)}}();return b.createElement(b.Fragment,null,b.createElement(va,null),b.createElement("div",{className:"browsers"},r.map((function(e){return b.createElement(xa,{key:e.name,onImport:u,browser:e,hasTabIndex:l&&!s&&e.importer&&e.state!==Kr.SUCCESS})}))))}const wa=__webpack_require__.p+"0d406bdcf61e6d381f23.svg",Ea=__webpack_require__.p+"405e207014bf75cd59c6.svg",Pa=__webpack_require__.p+"eed0b0cc552c8794b337.svg",_a=__webpack_require__.p+"37d24412e02af82ffc5c.svg",Ca=__webpack_require__.p+"e393a69f0d2e035d1c42.svg",Aa=__webpack_require__.p+"61a42bb99a92e9c1352f.svg",Ta=__webpack_require__.p+"28823de3046af6be5504.svg",Ma=__webpack_require__.p+"fcffb6ccd23559274e62.svg",Da=__webpack_require__.p+"9703c15b184d8259a452.svg",Ia=__webpack_require__.p+"8d979c64297ebab9c9d5.svg",Fa=__webpack_require__.p+"61c87b77a034799680ad.svg",Oa=__webpack_require__.p+"7bbffe1e039c3f8f477a.svg";function Ra(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(!e)return;if("string"==typeof e)return La(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return La(e,t)}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,a=function(){};return{s:a,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,o=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return s=e.done,e},e:function(e){o=!0,i=e},f:function(){try{s||null==n.return||n.return()}finally{if(o)throw i}}}}function La(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}var Na,Va="BR";function Ba(){return za.apply(this,arguments)}function za(){return(za=t(v().mark((function e(){var t,n,r,a;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,new Promise((function(e){opr.locationPrivate.getCurrentCountry((function(t){e(t)}))}));case 2:return t=e.sent,e.next=5,new Promise((function(e){opr.browserSidebarPrivate.getItemsInfo((function(t){e(t)}))}));case 5:return n=e.sent,r=Object.values(Na),t===Va&&(r=r.filter((function(e){return e!==Na.X}))),a=n.filter((function(e){return r.includes(e.pref_id)&&e.enabled})).map((function(e){return{pref_id:e.pref_id,enabled:!0,visible:e.visible,name:e.name}})),e.abrupt("return",a);case 10:case"end":return e.stop()}}),e)})))).apply(this,arguments)}!function(e){e.Messenger="FacebookMessenger",e.TikTok="TikTok",e.X="Twitter",e.Instagram="Instagram",e.Telegram="Telegram",e.WhatsApp="Whatsapp"}(Na||(Na={}));var ja=new Set,Ga=function(e){return ja.add(e),Ba().then(e),function(){ja.delete(e)}};function Ha(e){var t=function(e){switch(e){case Na.Instagram:return{name:"Instagram",icon:wa,iconInactive:Ea};case Na.Messenger:return{name:"Messenger",icon:Pa,iconInactive:_a};case Na.Telegram:return{name:"Telegram",icon:Ca,iconInactive:Aa};case Na.TikTok:return{name:"TikTok",icon:Ta,iconInactive:Ma};case Na.X:return{name:"X",icon:Fa,iconInactive:Oa};case Na.WhatsApp:return{name:"WhatsApp",icon:Da,iconInactive:Ia}}}(e.item.pref_id);return b.createElement(ya,{classNames:[e.item.visible?"active selected":null],onClick:function(){var t,n;t=e.item.pref_id,n=!e.item.visible,opr.browserSidebarPrivate.setItemVisibleUsingPrefId(t,n);var r=e.item.name.toLowerCase().replace(" ","_");un(sn.CLICK,dn.MESSENGERS,"enable_button:".concat(r,":").concat(e.item.visible?0:1))},onMouseEnter:e.onMouseEnter,onMouseLeave:e.onMouseLeave,hasTabIndex:e.hasTabIndex},b.createElement("span",{className:"messenger"},e.item.visible&&b.createElement("div",{className:"overlay-icon"},b.createElement("div",{className:"check"})),b.createElement("span",{className:"icon"},b.createElement("i",{style:{backgroundImage:"url(".concat(t.icon,")")}})),b.createElement("span",{className:"name"},t.name)))}function qa(e){var t=g((0,b.useState)([]),2),n=t[0],r=t[1],a=g((0,b.useState)(null),2),i=a[0],s=a[1],o=e.isActive;return(0,b.useEffect)((function(){return Ga((function(e){r(e)}))}),[]),b.createElement(b.Fragment,null,n.map((function(e){return b.createElement(Ha,{item:e,key:e.pref_id,isHovered:i===e.pref_id,onMouseEnter:function(){return s(e.pref_id)},onMouseLeave:function(){return s(null)},hasTabIndex:o})})))}opr.browserSidebarPrivate.onItemVisibilityChanged.addListener((function(){Ba().then((function(e){var t,n=Ra(ja);try{for(n.s();!(t=n.n()).done;){(0,t.value)(e)}}catch(e){n.e(e)}finally{n.f()}}))}));var Ua=function(e){return e&&"ffeocbomcpokpmjkkloomhnflpjmkjpi"==e.id},Wa=function(e){opr.vibesPrivate.updateActiveVibeConfiguration({mode:e})};function $a(e){switch(e){case In.LIGHT:return"light";case In.DARK:return"dark";case In.SYSTEM:return"system"}}function Ka(e){return b.createElement(ya,{classNames:[{selected:e.selected},$a(e.theme),"theme"],onClick:function(){opr.vibesPrivate?Wa(function(e){switch(e){case In.LIGHT:return opr.vibesPrivate.Mode.LIGHT;case In.DARK:return opr.vibesPrivate.Mode.DARK;case In.SYSTEM:return opr.vibesPrivate.Mode.SYSTEM}}(e.theme)):Gn(e.theme),un(sn.CLICK,dn.THEME,"".concat($a(e.theme),"_button"))},hasTabIndex:e.hasTabIndex},b.createElement("span",{className:"name"},e.name))}function Ja(e){var t=g((0,b.useState)(null),2),n=t[0],r=t[1],a=/linux/i.test(navigator.userAgent),i=e.isActive;return(0,b.useEffect)((function(){return Hn(r)}),[]),b.createElement(b.Fragment,null,b.createElement(Ka,{theme:In.LIGHT,selected:n===In.LIGHT,name:Ee("themes.light"),hasTabIndex:i}),b.createElement(Ka,{theme:In.DARK,selected:n===In.DARK,name:Ee("themes.dark"),hasTabIndex:i}),!a&&b.createElement(Ka,{theme:In.SYSTEM,selected:n===In.SYSTEM,name:Ee("themes.system"),hasTabIndex:i}))}function Ya(e){var n=e.id,r=e.isSelected,a=e.isAnyActive,i=e.setAnyHovered,s=g((0,b.useState)(!1),2),o=s[0],l=s[1],u=g((0,b.useState)(!1),2),c=u[0],h=u[1],p=function(){var n=t(v().mark((function t(){return v().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return l(!0),un(sn.CLICK,dn.WALLPAPERS,"choose_wallpaper"),t.next=4,gr(e.id);case 4:l(!1);case 5:case"end":return t.stop()}}),t)})));return function(){return n.apply(this,arguments)}}();return b.createElement(ya,{onClick:o?void 0:p,classNames:_n(["thumbnail",{dimmed:!c&&!r&&a,selected:r},{default:n===cr.DEFAULT}]),onMouseEnter:function(){h(!0),i(!0)},onMouseLeave:function(){h(!1),i(!1)},hasTabIndex:e.hasTabIndex},b.createElement("span",{className:"image",style:{backgroundImage:"url(".concat(e.thumbnail||e.src,")")}}),o&&b.createElement(ga,null))}function Qa(e){var t=g((0,b.useState)(!1),2),n=t[0],r=t[1],a=g((0,b.useState)(null),2),i=a[0],s=a[1],o=g((0,b.useState)(!1),2),l=o[0],u=o[1],c=e.isActive;(0,b.useEffect)((function(){var e=Un((function(e){r(e)})),t=Sr((function(e){s(e.id)}));return function(){e(),t()}}),[]);var h=n?fr:dr,p=h.map((function(e){return e.id})),f=i&&p.includes(i);return b.createElement(b.Fragment,null,h.map((function(e){return b.createElement(Ya,{key:e.id,id:e.id,src:e.background,thumbnail:e.thumbnail,isSelected:i===e.id,isAnyActive:f||l,isAnyHovered:l,setAnyHovered:u,hasTabIndex:c})})))}function Xa(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var n,r=h(e);if(t){var a=h(this).constructor;n=Reflect.construct(r,arguments,a)}else n=r.apply(this,arguments);return c(this,n)}}var Za=b.createContext({route:pn.WELCOME,setRoute:null,feature:fn.NONE,setFeature:null,popup:null,setPopup:null}),ei=function(e){var n=e.isOverlay,r=g((0,b.useState)(n?pn.WELCOME:bn()),2),a=r[0],i=r[1],s=g((0,b.useState)(kn(a)),2),o=s[0],l=s[1],u=g((0,b.useState)(null),2),c=u[0],h=u[1],p=g((0,b.useState)(!1),2),f=p[0],d=p[1],m=g((0,b.useState)(!1),2),y=m[0],k=m[1],x=function(){var e=g((0,b.useState)(null),2),n=e[0],r=e[1];return(0,b.useEffect)((function(){var e=function(){var e=t(v().mark((function e(){var t,n;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,opr.vibesPrivate.getActiveVibeConfiguration();case 2:return t=e.sent,e.next=5,opr.vibesPrivate.getVibe(t.vibeId);case 5:n=e.sent,r(n);case 7:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}();return opr.vibesPrivate.onActiveVibeConfigurationChanged.addListener(e),e(),function(){opr.vibesPrivate.onActiveVibeConfigurationChanged.removeListener(e)}}),[]),{activeVibe:n}}(),S=x.activeVibe,w=null!=S?S:{},E=w.canChangeMode,P=w.customizableWallpaper;(0,b.useEffect)((function(){return e=function(e,t){i(e),l(t)},t=function(){var t=bn(),n=kn(t);e(t,n)},chrome.storage.onChanged.addListener(t),function(){chrome.storage.onChanged.removeListener(t)};var e,t}),[]),(0,b.useEffect)((function(){var e;(e=!1,new Promise((function(n){var r=!1;document.fonts.addEventListener("loading",t(v().mark((function t(){var a,i,s;return v().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:a=0,i=Object.values(xn);case 1:if(!(a<i.length)){t.next=10;break}return s=i[a],t.next=5,Sn(s);case 5:t.sent||(r=!0);case 7:a++,t.next=1;break;case 10:e||(n(!r),e=!0);case 11:case"end":return t.stop()}}),t)}))))}))).then(d);var n=setTimeout((function(){return d(!0)}),500);return function(){clearTimeout(n)}}),[]);var _=[E&&Ua(S)&&{feature:fn.THEME,section:dn.THEME,title:Ee("themes.header"),subtitle:Ee("themes.subheader"),content:Ja},P&&Ua(S)&&{feature:fn.WALLPAPER,section:dn.WALLPAPERS,title:Ee("wallpapers.header"),subtitle:Ee("wallpapers.subheader"),content:Qa},{feature:fn.ADBLOCKER,section:dn.ADBLOCK,title:Ee("adblocker.header"),subtitle:Ee("adblocker.subheader"),content:ma},{feature:fn.MESSENGERS,section:dn.MESSENGERS,title:Ee("messengers.header"),subtitle:Ee("messengers.subheader"),content:qa},{feature:fn.IMPORT,section:dn.IMPORT,title:Ee("import.header"),subtitle:Ee("import.subheader"),content:Sa}].filter((function(e){return Boolean(e)}));return b.createElement(Za.Provider,{value:{route:a,setRoute:function(e){!function(e){localStorage.setItem("route",e)}(e),i(e)},feature:o,setFeature:function(e){!function(e){localStorage.setItem("feature",e)}(e),l(e)},popup:c,setPopup:h}},b.createElement(la,{isReady:f,isOverlay:n,slides:_,closeIntroduction:function(){y||(on(n),k(!0))},startBrowsing:function(){var e;y||(e=n,un(sn.CLICK,dn.OUTRO,"start_browsing"),e?on(!1):yn(),k(!0))}}))},ti=function(e){l(r,e);var t=Xa(r);function r(e){return n(this,r),t.call(this,e)}return s(r,[{key:"componentDidCatch",value:function(e,t){on(!1),yn()}},{key:"render",value:function(){return this.props.children}}]),r}(b.Component),ni=document.getElementById("root"),ri=function(){var e=t(v().mark((function e(){var t;return v().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,gn();case 2:t=e.sent,(0,k.s)(ni).render(b.createElement(ti,null,b.createElement(ei,{isOverlay:t})));case 5:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}();document.body.parentNode&&ni&&ri()})()})();